/*
 * $Id: RegexpDefinitionPatternMatcherTest.java 795343 2009-07-18 11:26:09Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.tiles.definition.pattern.regexp;

import static org.junit.Assert.*;

import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcher;
import org.junit.Test;

/**
 * Tests {@link RegexpDefinitionPatternMatcher}.
 *
 * @version $Rev: 795343 $ $Date: 2009-07-18 13:26:09 +0200 (sab, 18 lug 2009) $
 * @since 2.2.0
 */
public class RegexpDefinitionPatternMatcherTest {

    /**
     * Test method for
     * {@link org.apache.tiles.definition.pattern.RegexpPatternDefinitionResolver
     * #resolveDefinition(java.lang.String, java.lang.Object)}.
     */
    @Test
    public void testResolveDefinition() {
        Definition def = new Definition();
        def.setName("testDef(.*)\\.message(.*)");
        def.setTemplateAttribute(Attribute.createTemplateAttribute("/test{1}.jsp"));
        def.putAttribute("body", new Attribute("message{2}"));
        DefinitionPatternMatcher patternMatcher = new RegexpDefinitionPatternMatcher("testDef(.*)\\.message(.*)", def);
        Definition result = patternMatcher.createDefinition("testDefOne.messageTwo");
        assertNotNull(result);
        assertEquals("testDefOne.messageTwo", result.getName());
        assertEquals("/testOne.jsp", result.getTemplateAttribute().getValue());
        assertEquals("messageTwo", result.getAttribute("body").getValue());
    }
}
