% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_edge_attr}
\alias{set_edge_attr}
\title{Set edge attributes}
\usage{
set_edge_attr(graph, name, index = E(graph), value)
}
\arguments{
\item{graph}{The graph}

\item{name}{The name of the attribute to set.}

\item{index}{An optional edge sequence to set the attributes of
a subset of edges.}

\item{value}{The new value of the attribute for all (or \code{index})
edges.
If \code{NULL}, the input is returned unchanged.}
}
\value{
The graph, with the edge attribute added or set.
}
\description{
Set edge attributes
}
\examples{
g <- make_ring(10) \%>\%
  set_edge_attr("label", value = LETTERS[1:10])
g
plot(g)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_graph_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{set_vertex_attrs}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
