
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileAxisAttributes.h
    \brief Definition of Axis Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef AxisAttributes_H
#define AxisAttributes_H

#include "magics.h"
#include "AxisMethod.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class AxisAttributes 
{
public:
//  --  constructor
    AxisAttributes();
    
//  --  destructor
    virtual ~AxisAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const AxisAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string orientation_;
	string position_;
	bool line_;
	int line_thickness_;
	bool grid_;
	int grid_thickness_;
	bool minor_grid_;
	int minor_grid_thickness_;
	double grid_reference_level_;
	int grid_reference_thickness_;
	bool title_;
	string title_text_;
	string title_orientation_;
	double title_height_;
	string title_font_;
	string title_font_style_;
	double title_relative_position_;
	bool tick_;
	double interval_;
	doublearray positions_;
	string tick_position_;
	double tick_length_;
	int tick_thickness_;
	bool label_;
	string label_type_;
	int label_frequency_;
	bool label_first_;
	bool label_last_;
	string label_position_;
	string label_orientation_;
	string label_font_;
	string label_font_style_;
	double label_height_;
	stringarray label_labels_;
	string label_format_;
	bool minor_tick_;
	int minor_tick_count_;
	int minor_tick_thickness_;
	bool tip_;
	string tip_text_;
	double tip_height_;
	string tip_quality_;
	doublearray highlighted_values_;
	int highlighted_values_thickness_;
	unique_ptr<AxisMethod> method_;
	unique_ptr<Colour> line_colour_;
	LineStyle line_style_;
	unique_ptr<Colour> grid_colour_;
	unique_ptr<Colour> grid_background_colour_;
	LineStyle grid_style_;
	unique_ptr<Colour> minor_grid_colour_;
	LineStyle minor_grid_style_;
	unique_ptr<Colour> grid_reference_colour_;
	LineStyle grid_reference_style_;
	unique_ptr<Colour> title_colour_;
	unique_ptr<Colour> tick_colour_;
	unique_ptr<Colour> label_colour_;
	unique_ptr<Colour> minor_tick_colour_;
	unique_ptr<Colour> tip_colour_;
	unique_ptr<Colour> highlighted_values_colour_;
	LineStyle highlighted_values_style_;
	 

private:
	friend ostream& operator<<(ostream& s,const AxisAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

