function(check_beta_version _files)
	set(oneValueArgs RESULT VERSION)
	cmake_parse_arguments(_PARAM "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

	if(DEFINED _PARAM_RESULT)
		set(msgLevel STATUS)
	else()
		set(msgLevel FATAL_ERROR)
	endif()

	foreach(file IN LISTS _files)
		string(REGEX MATCH "[0-9]+\\.[0-9]+\\.[0-9]+\\+?" VERSION "${file}")
		if(NOT VERSION)
			message(FATAL_ERROR "Cannot extract version of file: ${file}")
		endif()

		if(DEFINED _PARAM_VERSION)
			string(REPLACE "+" "" _out "${VERSION}")
			set(${_PARAM_VERSION} ${_out} PARENT_SCOPE)
		endif()

		message(STATUS "Check file for beta/snapshot: ${file}")
		if(VERSION MATCHES "\\+")
			message(${msgLevel} "Version seems to be a snapshot: ${VERSION}")
			if(DEFINED _PARAM_RESULT)
				set(${_PARAM_RESULT} ON PARENT_SCOPE)
			endif()
			return()
		endif()

		string(REGEX MATCHALL "[0-9]+" VERSION_PARTS "${VERSION}")
		foreach(NUM ${VERSION_PARTS})
			if(NUM GREATER_EQUAL 100)
				message(${msgLevel} "Version seems to be a beta release: ${VERSION}")
				if(DEFINED _PARAM_RESULT)
					set(${_PARAM_RESULT} ON PARENT_SCOPE)
				endif()
				return()
			endif()
		endforeach()
	endforeach()
endfunction()
