/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.base.AbstractSet;
import com.github.andrewoma.dexx.collection.internal.base.Iterables;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractSelfBuilder;
import com.github.andrewoma.dexx.collection.internal.hashmap.CompactHashMap;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class HashSet<E>
extends AbstractSet<E> {
    private static final HashSet EMPTY = new HashSet();
    private static final KeyFunction keyFunction = new KeyFunction<Object, Object>(){

        @Override
        @NotNull
        public Object key(@NotNull Object value) {
            return value;
        }
    };
    private final CompactHashMap<E, E> compactHashMap;

    @NotNull
    public static <E> BuilderFactory<E, HashSet<E>> factory() {
        return new BuilderFactory<E, HashSet<E>>(){

            @Override
            @NotNull
            public Builder<E, HashSet<E>> newBuilder() {
                return new AbstractSelfBuilder<E, HashSet<E>>(HashSet.empty()){

                    @Override
                    @NotNull
                    public Builder<E, HashSet<E>> add(E element) {
                        this.result = ((HashSet)this.result).add(element);
                        return this;
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> HashSet<E> empty() {
        return EMPTY;
    }

    private HashSet() {
        this(CompactHashMap.empty());
    }

    private HashSet(CompactHashMap<E, E> compactHashMap) {
        this.compactHashMap = compactHashMap;
    }

    private KeyFunction<E, E> keyFunction() {
        return keyFunction;
    }

    @Override
    @NotNull
    public HashSet<E> add(E value) {
        return new HashSet<E>(this.compactHashMap.put(value, value, this.keyFunction()));
    }

    @Override
    @NotNull
    public HashSet<E> remove(E value) {
        return new HashSet<E>(this.compactHashMap.remove(value, this.keyFunction()));
    }

    @Override
    public boolean contains(E value) {
        return this.compactHashMap.get(value, this.keyFunction()) != null;
    }

    @Override
    public int size() {
        return this.compactHashMap.size();
    }

    @Override
    public <U> void forEach(@NotNull Function<E, U> f) {
        Iterables.forEach(this, f);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        final Iterator<Pair<E, E>> iterator = this.compactHashMap.iterator(this.keyFunction());
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return ((Pair)iterator.next()).component1();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

