## TFSA-2022-090: Int overflow in `RaggedRangeOp`

### CVE Number
CVE-2022-35940

### Impact
The [`RaggedRangOp`](https://github.com/tensorflow/tensorflow/blob/0b6b491d21d6a4eb5fbab1cca565bc1e94ca9543/tensorflow/core/kernels/ragged_range_op.cc#L74-L88) function takes an argument `limits` that is eventually used to construct a `TensorShape` as an `int64`. If `limits` is a very large float, it can overflow when converted to an `int64`. This triggers an `InvalidArgument` but also throws an abort signal that crashes the program.
```python
import tensorflow as tf
tf.raw_ops.RaggedRange(starts=[1.1,0.1],limits=[10.0,1e20],deltas=[1,1])
```

### Patches
We have patched the issue in GitHub commit [37cefa91bee4eace55715eeef43720b958a01192](https://github.com/tensorflow/tensorflow/commit/37cefa91bee4eace55715eeef43720b958a01192).

The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.


### Attribution
This vulnerability has been reported by Jingyi Shi.
