
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Qt User Interface                                                     *
 *                                                                        *
 *  Copyright (c) 1999-2025, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program. If not, see <https://www.gnu.org/licenses/>. *
 *                                                                        *
 **************************************************************************/

/*! \file eltmovedialog2.h
 *  \brief Provides a dialog through which the user can perform
 *  elementary moves on a 2-manifold triangulation.
 */

#ifndef __ELTMOVEDIALOG2_H
#define __ELTMOVEDIALOG2_H

#include "triangulation/forward.h"
#include "packet/packet.h"

#include "reginaqt.h"
#include <QDialog>
#include <vector>

class QAbstractButton;
class QButtonGroup;
class QDialogButtonBox;
class QLabel;
class QRadioButton;
template <int, int> class FaceChooser;
template <int> class SimplexChooser;

/**
 * A dialog used to select and perform an elementary move on a
 * 2-manifold triangulation.
 */
class EltMoveDialog2 : public QDialog, public regina::PacketListener {
    Q_OBJECT

    private:
        /**
         * Internal components:
         */
        QLabel* name;
        QLabel* overview;

        FaceChooser<2, 0>* box31;
        FaceChooser<2, 1>* box22;
        SimplexChooser<2>* box13;
        FaceChooser<2, 0>* box20v;
        SimplexChooser<2>* boxShellBdry;
        QRadioButton* use31;
        QRadioButton* use22;
        QRadioButton* use13;
        QRadioButton* use20v;
        QRadioButton* useShellBdry;
        QButtonGroup* moveTypes;
        QDialogButtonBox* buttons;

        /**
         * Packet tree structure:
         */
        regina::PacketOf<regina::Triangulation<2>>* tri_;

    public:
        /**
         * Constructor and destructor.
         */
        EltMoveDialog2(QWidget* parent,
            regina::PacketOf<regina::Triangulation<2>>* tri);
        ~EltMoveDialog2() override;

        /**
         * Update the overview information if the triangulation changes.
         */
        void packetWasRenamed(regina::Packet&) override;
        void packetWasChanged(regina::Packet&) override;
        void packetBeingDestroyed(regina::PacketShell) override;

    protected slots:
        /**
         * A button at the bottom of the dialog has been clicked.
         */
        virtual void clicked(QAbstractButton*);

        /**
         * One of the move types has been selected.
         */
        void updateApply();

    private:
        template <typename ChooserClass>
        void updateStates(ChooserClass* chooser, QRadioButton* button);
};

#endif
