% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_functions.R
\name{get_matches}
\alias{get_matches}
\title{Get matches from matchit object}
\usage{
get_matches(object, model_frame, id_cols = NULL, newdata = NULL)
}
\arguments{
\item{object}{The \code{'matchit'} class model object}

\item{model_frame}{The \code{'data.frame'} class object used in creation of \code{object}.}

\item{id_cols}{A string indicating the ID for the datset used in the call to \code{\link{matchit}}. 
This can be used in combination with \code{newdata} to return the base dataset. Defaults to 
\code{NULL}.}

\item{newdata}{A new \code{data.frame} object to extract matched observations from. Used in 
conjunction with \code{id_cols}. Defaults to \code{NULL}.}
}
\value{
If \code{newdata} is \code{NULL}, a subset of \code{model_frame} containing the rows 
corresponding to the matched treatement and control observations with weights appended. If 
\code{newdata} is not \code{NULL}, an equivalent subset of \code{newdata} is returned.
}
\description{
Get the resulting matches from a \code{matchit} model object. This function allows the 
user to extract the matches from the original dataset used in model building or from a new dataset
that has a matching set of key column(s) (\code{id_cols}).
}
