# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    FaultKind,
    PartitionScheme,
    ServiceKind,
    ServicePlacementPolicyType,
    ServiceScalingMechanismKind,
    ServiceScalingTriggerKind,
)

if TYPE_CHECKING:
    from .. import models as _models


class AdditionalNetworkInterfaceConfiguration(_Model):
    """Specifies the settings for a network interface to attach to the node type.

    :ivar name: Name of the network interface. Required.
    :vartype name: str
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar dscp_configuration: Specifies the DSCP configuration to apply to the network interface.
    :vartype dscp_configuration: ~azure.mgmt.servicefabricmanagedclusters.models.SubResource
    :ivar ip_configurations: Specifies the IP configurations of the network interface. Required.
    :vartype ip_configurations:
     list[~azure.mgmt.servicefabricmanagedclusters.models.IpConfiguration]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the network interface. Required."""
    enable_accelerated_networking: Optional[bool] = rest_field(
        name="enableAcceleratedNetworking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the network interface is accelerated networking-enabled."""
    dscp_configuration: Optional["_models.SubResource"] = rest_field(
        name="dscpConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the DSCP configuration to apply to the network interface."""
    ip_configurations: list["_models.IpConfiguration"] = rest_field(
        name="ipConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the IP configurations of the network interface. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        ip_configurations: list["_models.IpConfiguration"],
        enable_accelerated_networking: Optional[bool] = None,
        dscp_configuration: Optional["_models.SubResource"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScalingMechanism(_Model):
    """Describes the mechanism for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AddRemoveIncrementalNamedPartitionScalingMechanism, PartitionInstanceCountScaleMechanism

    :ivar kind: Required. Known values are: "ScalePartitionInstanceCount" and
     "AddRemoveIncrementalNamedPartition".
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingMechanismKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"ScalePartitionInstanceCount\" and
     \"AddRemoveIncrementalNamedPartition\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AddRemoveIncrementalNamedPartitionScalingMechanism(
    ScalingMechanism, discriminator="AddRemoveIncrementalNamedPartition"
):  # pylint: disable=name-too-long
    """Represents a scaling mechanism for adding or removing named partitions of a stateless service.
    Partition names are in the format '0','1'...'N-1'.

    :ivar min_partition_count: Minimum number of named partitions of the service. Required.
    :vartype min_partition_count: int
    :ivar max_partition_count: Maximum number of named partitions of the service. Required.
    :vartype max_partition_count: int
    :ivar scale_increment: The number of instances to add or remove during a scaling operation.
     Required.
    :vartype scale_increment: int
    :ivar kind: Specifies the mechanism associated with this scaling policy. Required. Represents a
     scaling mechanism for adding or removing named partitions of a stateless service. The value is
     1.
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ADD_REMOVE_INCREMENTAL_NAMED_PARTITION
    """

    min_partition_count: int = rest_field(
        name="minPartitionCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum number of named partitions of the service. Required."""
    max_partition_count: int = rest_field(
        name="maxPartitionCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of named partitions of the service. Required."""
    scale_increment: int = rest_field(name="scaleIncrement", visibility=["read", "create", "update", "delete", "query"])
    """The number of instances to add or remove during a scaling operation. Required."""
    kind: Literal[ServiceScalingMechanismKind.ADD_REMOVE_INCREMENTAL_NAMED_PARTITION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the mechanism associated with this scaling policy. Required. Represents a scaling
     mechanism for adding or removing named partitions of a stateless service. The value is 1."""

    @overload
    def __init__(
        self,
        *,
        min_partition_count: int,
        max_partition_count: int,
        scale_increment: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ServiceScalingMechanismKind.ADD_REMOVE_INCREMENTAL_NAMED_PARTITION  # type: ignore


class ApplicationFetchHealthRequest(_Model):
    """Parameters for fetching the health of an application.

    :ivar events_health_state_filter: Allows filtering of the health events returned in the
     response based on health state. Known values are: "Default", "None", "Ok", "Warning", "Error",
     and "All".
    :vartype events_health_state_filter: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.HealthFilter
    :ivar deployed_applications_health_state_filter: Allows filtering of the deployed applications
     health state objects returned in the result of application health query based on their health
     state. Known values are: "Default", "None", "Ok", "Warning", "Error", and "All".
    :vartype deployed_applications_health_state_filter: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.HealthFilter
    :ivar services_health_state_filter: Allows filtering of the services health state objects
     returned in the result of services health query based on their health state. Known values are:
     "Default", "None", "Ok", "Warning", "Error", and "All".
    :vartype services_health_state_filter: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.HealthFilter
    :ivar exclude_health_statistics: Indicates whether the health statistics should be returned as
     part of the query result. False by default. The statistics show the number of children entities
     in health state Ok, Warning, and Error.
    :vartype exclude_health_statistics: bool
    :ivar timeout: Request timeout for the health query in seconds. The default value is 60
     seconds.
    :vartype timeout: int
    """

    events_health_state_filter: Optional[Union[str, "_models.HealthFilter"]] = rest_field(
        name="eventsHealthStateFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows filtering of the health events returned in the response based on health state. Known
     values are: \"Default\", \"None\", \"Ok\", \"Warning\", \"Error\", and \"All\"."""
    deployed_applications_health_state_filter: Optional[Union[str, "_models.HealthFilter"]] = rest_field(
        name="deployedApplicationsHealthStateFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows filtering of the deployed applications health state objects returned in the result of
     application health query based on their health state. Known values are: \"Default\", \"None\",
     \"Ok\", \"Warning\", \"Error\", and \"All\"."""
    services_health_state_filter: Optional[Union[str, "_models.HealthFilter"]] = rest_field(
        name="servicesHealthStateFilter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Allows filtering of the services health state objects returned in the result of services health
     query based on their health state. Known values are: \"Default\", \"None\", \"Ok\",
     \"Warning\", \"Error\", and \"All\"."""
    exclude_health_statistics: Optional[bool] = rest_field(
        name="excludeHealthStatistics", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the health statistics should be returned as part of the query result. False
     by default. The statistics show the number of children entities in health state Ok, Warning,
     and Error."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Request timeout for the health query in seconds. The default value is 60 seconds."""

    @overload
    def __init__(
        self,
        *,
        events_health_state_filter: Optional[Union[str, "_models.HealthFilter"]] = None,
        deployed_applications_health_state_filter: Optional[Union[str, "_models.HealthFilter"]] = None,
        services_health_state_filter: Optional[Union[str, "_models.HealthFilter"]] = None,
        exclude_health_statistics: Optional[bool] = None,
        timeout: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationHealthPolicy(_Model):
    """Defines a health policy used to evaluate the health of an application or one of its children
    entities.

    :ivar consider_warning_as_error: Indicates whether warnings are treated with the same severity
     as errors. Required.
    :vartype consider_warning_as_error: bool
    :ivar max_percent_unhealthy_deployed_applications: The maximum allowed percentage of unhealthy
     deployed applications. Allowed values are Byte values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can be
     unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number of
     nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage
     is zero. Required.
    :vartype max_percent_unhealthy_deployed_applications: int
    :ivar default_service_type_health_policy: The health policy used by default to evaluate the
     health of a service type.
    :vartype default_service_type_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceTypeHealthPolicy
    :ivar service_type_health_policy_map: The map with service type health policy per service type
     name. The map is empty by default.
    :vartype service_type_health_policy_map: dict[str,
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceTypeHealthPolicy]
    """

    consider_warning_as_error: bool = rest_field(
        name="considerWarningAsError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether warnings are treated with the same severity as errors. Required."""
    max_percent_unhealthy_deployed_applications: int = rest_field(
        name="maxPercentUnhealthyDeployedApplications", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte
     values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can be
     unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number of
     nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage
     is zero. Required."""
    default_service_type_health_policy: Optional["_models.ServiceTypeHealthPolicy"] = rest_field(
        name="defaultServiceTypeHealthPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The health policy used by default to evaluate the health of a service type."""
    service_type_health_policy_map: Optional[dict[str, "_models.ServiceTypeHealthPolicy"]] = rest_field(
        name="serviceTypeHealthPolicyMap", visibility=["read", "create", "update", "delete", "query"]
    )
    """The map with service type health policy per service type name. The map is empty by default."""

    @overload
    def __init__(
        self,
        *,
        consider_warning_as_error: bool,
        max_percent_unhealthy_deployed_applications: int,
        default_service_type_health_policy: Optional["_models.ServiceTypeHealthPolicy"] = None,
        service_type_health_policy_map: Optional[dict[str, "_models.ServiceTypeHealthPolicy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """Proxy Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    """


class ApplicationResource(ProxyResource):
    """The application resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar properties: The application resource properties.
    :vartype properties:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationResourceProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Describes the managed identities for an Azure resource.
    :vartype identity: ~azure.mgmt.servicefabricmanagedclusters.models.ManagedIdentity
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    properties: Optional["_models.ApplicationResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The application resource properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    identity: Optional["_models.ManagedIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the managed identities for an Azure resource."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""

    __flattened_items = ["managed_identities", "provisioning_state", "version", "parameters", "upgrade_policy"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApplicationResourceProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        identity: Optional["_models.ManagedIdentity"] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ApplicationResourceProperties(_Model):
    """The application resource properties.

    :ivar managed_identities: List of user assigned identities for the application, each mapped to
     a friendly name.
    :vartype managed_identities:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUserAssignedIdentity]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar version: The version of the application type as defined in the application manifest.
     This name must be the full Arm Resource ID for the referenced application type version.
    :vartype version: str
    :ivar parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :vartype parameters: dict[str, str]
    :ivar upgrade_policy: Describes the policy for a monitored application upgrade.
    :vartype upgrade_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUpgradePolicy
    """

    managed_identities: Optional[list["_models.ApplicationUserAssignedIdentity"]] = rest_field(
        name="managedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of user assigned identities for the application, each mapped to a friendly name."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The current deployment or provisioning state, which only appears in the response."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the application type as defined in the application manifest.
     This name must be the full Arm Resource ID for the referenced application type version."""
    parameters: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of application parameters with overridden values from their default values specified in
     the application manifest."""
    upgrade_policy: Optional["_models.ApplicationUpgradePolicy"] = rest_field(
        name="upgradePolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the policy for a monitored application upgrade."""

    @overload
    def __init__(
        self,
        *,
        managed_identities: Optional[list["_models.ApplicationUserAssignedIdentity"]] = None,
        version: Optional[str] = None,
        parameters: Optional[dict[str, str]] = None,
        upgrade_policy: Optional["_models.ApplicationUpgradePolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationTypeResource(ProxyResource):
    """The application type name resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar properties: The application type name properties.
    :vartype properties:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeResourceProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    properties: Optional["_models.ApplicationTypeResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The application type name properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""

    __flattened_items = ["provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApplicationTypeResourceProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ApplicationTypeResourceProperties(_Model):
    """The application type name properties.

    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The current deployment or provisioning state, which only appears in the response."""


class ApplicationTypeUpdateParameters(_Model):
    """Application type update request.

    :ivar tags: Application type update parameters.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application type update parameters."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationTypeVersionResource(ProxyResource):
    """An application type version resource for the specified application type name resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar properties: The properties of the application type version resource.
    :vartype properties:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeVersionResourceProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    properties: Optional["_models.ApplicationTypeVersionResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The properties of the application type version resource."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""

    __flattened_items = ["provisioning_state", "app_package_url"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ApplicationTypeVersionResourceProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ApplicationTypeVersionResourceProperties(_Model):
    """The properties of the application type version resource.

    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar app_package_url: The URL to the application package. Required.
    :vartype app_package_url: str
    """

    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The current deployment or provisioning state, which only appears in the response."""
    app_package_url: str = rest_field(name="appPackageUrl", visibility=["read", "create", "update", "delete", "query"])
    """The URL to the application package. Required."""

    @overload
    def __init__(
        self,
        *,
        app_package_url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationTypeVersionsCleanupPolicy(_Model):
    """The policy used to clean up unused versions. When the policy is not specified explicitly, the
    default unused application versions to keep will be 3.

    :ivar max_unused_versions_to_keep: Number of unused versions per application type to keep.
     Required.
    :vartype max_unused_versions_to_keep: int
    """

    max_unused_versions_to_keep: int = rest_field(
        name="maxUnusedVersionsToKeep", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of unused versions per application type to keep. Required."""

    @overload
    def __init__(
        self,
        *,
        max_unused_versions_to_keep: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationTypeVersionUpdateParameters(_Model):
    """Application type version update request.

    :ivar tags: Application type version update parameters.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application type version update parameters."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationUpdateParameters(_Model):
    """Application update request.

    :ivar tags: Application update parameters.
    :vartype tags: dict[str, str]
    :ivar properties: Application update parameters properties.
    :vartype properties:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationUpdateParametersProperties
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Application update parameters."""
    properties: Optional["_models.ApplicationUpdateParametersProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Application update parameters properties."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ApplicationUpdateParametersProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationUpdateParametersProperties(_Model):
    """Properties for application update request.

    :ivar parameters: List of application parameters with overridden values from their default
     values specified in the application manifest.
    :vartype parameters: dict[str, str]
    """

    parameters: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of application parameters with overridden values from their default values specified in
     the application manifest."""

    @overload
    def __init__(
        self,
        *,
        parameters: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationUpgradePolicy(_Model):
    """Describes the policy for a monitored application upgrade.

    :ivar application_health_policy: Defines a health policy used to evaluate the health of an
     application or one of its children entities.
    :vartype application_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationHealthPolicy
    :ivar force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :vartype force_restart: bool
    :ivar rolling_upgrade_monitoring_policy: The policy used for monitoring the application
     upgrade.
    :vartype rolling_upgrade_monitoring_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.RollingUpgradeMonitoringPolicy
    :ivar instance_close_delay_duration: Duration in seconds, to wait before a stateless instance
     is closed, to allow the active requests to drain gracefully. This would be effective when the
     instance is closing during the application/cluster upgrade, only for those instances which have
     a non-zero delay duration configured in the service description.
    :vartype instance_close_delay_duration: int
    :ivar upgrade_mode: The mode used to monitor health during a rolling upgrade. The values are
     Monitored, and UnmonitoredAuto. Known values are: "Monitored" and "UnmonitoredAuto".
    :vartype upgrade_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.RollingUpgradeMode
    :ivar upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an
     upgrade domain and prevent loss of availability when there are unexpected issues. When this
     timeout expires, processing of the upgrade domain will proceed regardless of availability loss
     issues. The timeout is reset at the start of each upgrade domain. Valid values are between 0
     and 42949672925 inclusive. (unsigned 32-bit integer). Unit is in seconds.
    :vartype upgrade_replica_set_check_timeout: int
    :ivar recreate_application: Determines whether the application should be recreated on update.
     If value=true, the rest of the upgrade policy parameters are not allowed.
    :vartype recreate_application: bool
    """

    application_health_policy: Optional["_models.ApplicationHealthPolicy"] = rest_field(
        name="applicationHealthPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines a health policy used to evaluate the health of an application or one of its children
     entities."""
    force_restart: Optional[bool] = rest_field(
        name="forceRestart", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, then processes are forcefully restarted during upgrade even when the code version has
     not changed (the upgrade only changes configuration or data)."""
    rolling_upgrade_monitoring_policy: Optional["_models.RollingUpgradeMonitoringPolicy"] = rest_field(
        name="rollingUpgradeMonitoringPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy used for monitoring the application upgrade."""
    instance_close_delay_duration: Optional[int] = rest_field(
        name="instanceCloseDelayDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Duration in seconds, to wait before a stateless instance is closed, to allow the active
     requests to drain gracefully. This would be effective when the instance is closing during the
     application/cluster upgrade, only for those instances which have a non-zero delay duration
     configured in the service description."""
    upgrade_mode: Optional[Union[str, "_models.RollingUpgradeMode"]] = rest_field(
        name="upgradeMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The mode used to monitor health during a rolling upgrade. The values are Monitored, and
     UnmonitoredAuto. Known values are: \"Monitored\" and \"UnmonitoredAuto\"."""
    upgrade_replica_set_check_timeout: Optional[int] = rest_field(
        name="upgradeReplicaSetCheckTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum amount of time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires, processing of the
     upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the
     start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned
     32-bit integer). Unit is in seconds."""
    recreate_application: Optional[bool] = rest_field(
        name="recreateApplication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Determines whether the application should be recreated on update. If value=true, the rest of
     the upgrade policy parameters are not allowed."""

    @overload
    def __init__(
        self,
        *,
        application_health_policy: Optional["_models.ApplicationHealthPolicy"] = None,
        force_restart: Optional[bool] = None,
        rolling_upgrade_monitoring_policy: Optional["_models.RollingUpgradeMonitoringPolicy"] = None,
        instance_close_delay_duration: Optional[int] = None,
        upgrade_mode: Optional[Union[str, "_models.RollingUpgradeMode"]] = None,
        upgrade_replica_set_check_timeout: Optional[int] = None,
        recreate_application: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApplicationUserAssignedIdentity(_Model):
    """User assigned identity for the application.

    :ivar name: The friendly name of user assigned identity. Required.
    :vartype name: str
    :ivar principal_id: The principal id of user assigned identity. Required.
    :vartype principal_id: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The friendly name of user assigned identity. Required."""
    principal_id: str = rest_field(name="principalId", visibility=["read", "create", "update", "delete", "query"])
    """The principal id of user assigned identity. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        principal_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AvailableOperationDisplay(_Model):
    """Operation supported by the Service Fabric resource provider.

    :ivar provider: The name of the provider.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that can be performed.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the provider."""
    resource: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource on which the operation is performed."""
    operation: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operation that can be performed."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Operation description."""

    @overload
    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScalingTrigger(_Model):
    """Describes the trigger for performing a scaling operation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AveragePartitionLoadScalingTrigger, AverageServiceLoadScalingTrigger

    :ivar kind: Required. Known values are: "AveragePartitionLoadTrigger" and
     "AverageServiceLoadTrigger".
    :vartype kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceScalingTriggerKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"AveragePartitionLoadTrigger\" and \"AverageServiceLoadTrigger\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AveragePartitionLoadScalingTrigger(ScalingTrigger, discriminator="AveragePartitionLoadTrigger"):
    """Represents a scaling trigger related to an average load of a metric/resource of a partition.

    :ivar metric_name: The name of the metric for which usage should be tracked. Required.
    :vartype metric_name: str
    :ivar lower_load_threshold: The lower limit of the load below which a scale in operation should
     be performed. Required.
    :vartype lower_load_threshold: float
    :ivar upper_load_threshold: The upper limit of the load beyond which a scale out operation
     should be performed. Required.
    :vartype upper_load_threshold: float
    :ivar scale_interval: The period in seconds on which a decision is made whether to scale or
     not. This property should come in ISO 8601 format "hh:mm:ss". Required.
    :vartype scale_interval: str
    :ivar kind: Specifies the trigger associated with this scaling policy. Required. Represents a
     scaling trigger related to an average load of a metric/resource of a partition. The value is 0.
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.AVERAGE_PARTITION_LOAD_TRIGGER
    """

    metric_name: str = rest_field(name="metricName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the metric for which usage should be tracked. Required."""
    lower_load_threshold: float = rest_field(
        name="lowerLoadThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """The lower limit of the load below which a scale in operation should be performed. Required."""
    upper_load_threshold: float = rest_field(
        name="upperLoadThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upper limit of the load beyond which a scale out operation should be performed. Required."""
    scale_interval: str = rest_field(name="scaleInterval", visibility=["read", "create", "update", "delete", "query"])
    """The period in seconds on which a decision is made whether to scale or not. This property should
     come in ISO 8601 format \"hh:mm:ss\". Required."""
    kind: Literal[ServiceScalingTriggerKind.AVERAGE_PARTITION_LOAD_TRIGGER] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the trigger associated with this scaling policy. Required. Represents a scaling
     trigger related to an average load of a metric/resource of a partition. The value is 0."""

    @overload
    def __init__(
        self,
        *,
        metric_name: str,
        lower_load_threshold: float,
        upper_load_threshold: float,
        scale_interval: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ServiceScalingTriggerKind.AVERAGE_PARTITION_LOAD_TRIGGER  # type: ignore


class AverageServiceLoadScalingTrigger(ScalingTrigger, discriminator="AverageServiceLoadTrigger"):
    """Represents a scaling policy related to an average load of a metric/resource of a service.

    :ivar metric_name: The name of the metric for which usage should be tracked. Required.
    :vartype metric_name: str
    :ivar lower_load_threshold: The lower limit of the load below which a scale in operation should
     be performed. Required.
    :vartype lower_load_threshold: float
    :ivar upper_load_threshold: The upper limit of the load beyond which a scale out operation
     should be performed. Required.
    :vartype upper_load_threshold: float
    :ivar scale_interval: The period in seconds on which a decision is made whether to scale or
     not. This property should come in ISO 8601 format "hh:mm:ss". Required.
    :vartype scale_interval: str
    :ivar use_only_primary_load: Flag determines whether only the load of primary replica should be
     considered for scaling. If set to true, then trigger will only consider the load of primary
     replicas of stateful service. If set to false, trigger will consider load of all replicas. This
     parameter cannot be set to true for stateless service. Required.
    :vartype use_only_primary_load: bool
    :ivar kind: Specifies the trigger associated with this scaling policy. Required. Represents a
     scaling policy related to an average load of a metric/resource of a service. The value is 1.
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.AVERAGE_SERVICE_LOAD_TRIGGER
    """

    metric_name: str = rest_field(name="metricName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the metric for which usage should be tracked. Required."""
    lower_load_threshold: float = rest_field(
        name="lowerLoadThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """The lower limit of the load below which a scale in operation should be performed. Required."""
    upper_load_threshold: float = rest_field(
        name="upperLoadThreshold", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upper limit of the load beyond which a scale out operation should be performed. Required."""
    scale_interval: str = rest_field(name="scaleInterval", visibility=["read", "create", "update", "delete", "query"])
    """The period in seconds on which a decision is made whether to scale or not. This property should
     come in ISO 8601 format \"hh:mm:ss\". Required."""
    use_only_primary_load: bool = rest_field(
        name="useOnlyPrimaryLoad", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag determines whether only the load of primary replica should be considered for scaling. If
     set to true, then trigger will only consider the load of primary replicas of stateful service.
     If set to false, trigger will consider load of all replicas. This parameter cannot be set to
     true for stateless service. Required."""
    kind: Literal[ServiceScalingTriggerKind.AVERAGE_SERVICE_LOAD_TRIGGER] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the trigger associated with this scaling policy. Required. Represents a scaling
     policy related to an average load of a metric/resource of a service. The value is 1."""

    @overload
    def __init__(
        self,
        *,
        metric_name: str,
        lower_load_threshold: float,
        upper_load_threshold: float,
        scale_interval: str,
        use_only_primary_load: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ServiceScalingTriggerKind.AVERAGE_SERVICE_LOAD_TRIGGER  # type: ignore


class AzureActiveDirectory(_Model):
    """The settings to enable AAD authentication on the cluster.

    :ivar tenant_id: Azure active directory tenant id.
    :vartype tenant_id: str
    :ivar cluster_application: Azure active directory cluster application id.
    :vartype cluster_application: str
    :ivar client_application: Azure active directory client application id.
    :vartype client_application: str
    """

    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read", "create", "update", "delete", "query"])
    """Azure active directory tenant id."""
    cluster_application: Optional[str] = rest_field(
        name="clusterApplication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure active directory cluster application id."""
    client_application: Optional[str] = rest_field(
        name="clientApplication", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure active directory client application id."""

    @overload
    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        cluster_application: Optional[str] = None,
        client_application: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientCertificate(_Model):
    """Client certificate definition.

    :ivar is_admin: Indicates if the client certificate has admin access to the cluster. Non admin
     clients can perform only read only operations on the cluster. Required.
    :vartype is_admin: bool
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar common_name: Certificate common name.
    :vartype common_name: str
    :ivar issuer_thumbprint: Issuer thumbprint for the certificate. Only used together with
     CommonName.
    :vartype issuer_thumbprint: str
    """

    is_admin: bool = rest_field(name="isAdmin", visibility=["read", "create", "update", "delete", "query"])
    """Indicates if the client certificate has admin access to the cluster. Non admin clients can
     perform only read only operations on the cluster. Required."""
    thumbprint: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Certificate thumbprint."""
    common_name: Optional[str] = rest_field(
        name="commonName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Certificate common name."""
    issuer_thumbprint: Optional[str] = rest_field(
        name="issuerThumbprint", visibility=["read", "create", "update", "delete", "query"]
    )
    """Issuer thumbprint for the certificate. Only used together with CommonName."""

    @overload
    def __init__(
        self,
        *,
        is_admin: bool,
        thumbprint: Optional[str] = None,
        common_name: Optional[str] = None,
        issuer_thumbprint: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterHealthPolicy(_Model):
    """Defines a health policy used to evaluate the health of the cluster or of a cluster node.

    :ivar max_percent_unhealthy_nodes: The maximum allowed percentage of unhealthy nodes before
     reporting an error. For example, to allow 10% of nodes to be unhealthy, this value would be 10.

     The percentage represents the maximum tolerated percentage of nodes that can be unhealthy
     before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy node, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy nodes over the total number of
     nodes in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage
     is zero.

     In large clusters, some nodes will always be down or out for repairs, so this percentage should
     be configured to tolerate that. Required.
    :vartype max_percent_unhealthy_nodes: int
    :ivar max_percent_unhealthy_applications: The maximum allowed percentage of unhealthy
     applications before reporting an error. For example, to allow 10% of applications to be
     unhealthy, this value would be 10.

     The percentage represents the maximum tolerated percentage of applications that can be
     unhealthy before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy application, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy applications over the total number of
     application instances in the cluster, excluding applications of application types that are
     included in the ApplicationTypeHealthPolicyMap.
     The computation rounds up to tolerate one failure on small numbers of applications. Default
     percentage is zero. Required.
    :vartype max_percent_unhealthy_applications: int
    """

    max_percent_unhealthy_nodes: int = rest_field(
        name="maxPercentUnhealthyNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy nodes before reporting an error. For example, to
     allow 10% of nodes to be unhealthy, this value would be 10.
     
     The percentage represents the maximum tolerated percentage of nodes that can be unhealthy
     before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy node, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy nodes over the total number of
     nodes in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage
     is zero.
     
     In large clusters, some nodes will always be down or out for repairs, so this percentage should
     be configured to tolerate that. Required."""
    max_percent_unhealthy_applications: int = rest_field(
        name="maxPercentUnhealthyApplications", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy applications before reporting an error. For
     example, to allow 10% of applications to be unhealthy, this value would be 10.
     
     The percentage represents the maximum tolerated percentage of applications that can be
     unhealthy before the cluster is considered in error.
     If the percentage is respected but there is at least one unhealthy application, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy applications over the total number of
     application instances in the cluster, excluding applications of application types that are
     included in the ApplicationTypeHealthPolicyMap.
     The computation rounds up to tolerate one failure on small numbers of applications. Default
     percentage is zero. Required."""

    @overload
    def __init__(
        self,
        *,
        max_percent_unhealthy_nodes: int,
        max_percent_unhealthy_applications: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterMonitoringPolicy(_Model):
    """Describes the monitoring policies for the cluster upgrade.

    :ivar health_check_wait_duration: The length of time to wait after completing an upgrade domain
     before performing health checks. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms
     format. Required.
    :vartype health_check_wait_duration: ~datetime.timedelta
    :ivar health_check_stable_duration: The amount of time that the application or cluster must
     remain healthy before the upgrade proceeds to the next upgrade domain. The duration can be in
     either hh:mm:ss or in d.hh:mm:ss.ms format. Required.
    :vartype health_check_stable_duration: ~datetime.timedelta
    :ivar health_check_retry_timeout: The amount of time to retry health evaluation when the
     application or cluster is unhealthy before the upgrade rolls back. The timeout can be in either
     hh:mm:ss or in d.hh:mm:ss.ms format. Required.
    :vartype health_check_retry_timeout: ~datetime.timedelta
    :ivar upgrade_timeout: The amount of time the overall upgrade has to complete before the
     upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format. Required.
    :vartype upgrade_timeout: ~datetime.timedelta
    :ivar upgrade_domain_timeout: The amount of time each upgrade domain has to complete before the
     upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format. Required.
    :vartype upgrade_domain_timeout: ~datetime.timedelta
    """

    health_check_wait_duration: datetime.timedelta = rest_field(
        name="healthCheckWaitDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The length of time to wait after completing an upgrade domain before performing health checks.
     The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms format. Required."""
    health_check_stable_duration: datetime.timedelta = rest_field(
        name="healthCheckStableDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time that the application or cluster must remain healthy before the upgrade
     proceeds to the next upgrade domain. The duration can be in either hh:mm:ss or in d.hh:mm:ss.ms
     format. Required."""
    health_check_retry_timeout: datetime.timedelta = rest_field(
        name="healthCheckRetryTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time to retry health evaluation when the application or cluster is unhealthy
     before the upgrade rolls back. The timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms
     format. Required."""
    upgrade_timeout: datetime.timedelta = rest_field(
        name="upgradeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time the overall upgrade has to complete before the upgrade rolls back. The
     timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format. Required."""
    upgrade_domain_timeout: datetime.timedelta = rest_field(
        name="upgradeDomainTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time each upgrade domain has to complete before the upgrade rolls back. The
     timeout can be in either hh:mm:ss or in d.hh:mm:ss.ms format. Required."""

    @overload
    def __init__(
        self,
        *,
        health_check_wait_duration: datetime.timedelta,
        health_check_stable_duration: datetime.timedelta,
        health_check_retry_timeout: datetime.timedelta,
        upgrade_timeout: datetime.timedelta,
        upgrade_domain_timeout: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterUpgradeDeltaHealthPolicy(_Model):
    """Describes the delta health policies for the cluster upgrade.

    :ivar max_percent_delta_unhealthy_nodes: The maximum allowed percentage of nodes health
     degradation allowed during cluster upgrades.
     The delta is measured between the state of the nodes at the beginning of upgrade and the state
     of the nodes at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits. Required.
    :vartype max_percent_delta_unhealthy_nodes: int
    :ivar max_percent_upgrade_domain_delta_unhealthy_nodes: The maximum allowed percentage of
     upgrade domain nodes health degradation allowed during cluster upgrades.
     The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade
     and the state of the upgrade domain nodes at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion for all completed upgrade
     domains to make sure the state of the upgrade domains is within tolerated limits.
    :vartype max_percent_upgrade_domain_delta_unhealthy_nodes: int
    :ivar max_percent_delta_unhealthy_applications: The maximum allowed percentage of applications
     health degradation allowed during cluster upgrades.
     The delta is measured between the state of the applications at the beginning of upgrade and the
     state of the applications at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits. System services are not included in this.
     NOTE: This value will overwrite the value specified in
     properties.UpgradeDescription.HealthPolicy.MaxPercentUnhealthyApplications.
    :vartype max_percent_delta_unhealthy_applications: int
    """

    max_percent_delta_unhealthy_nodes: int = rest_field(
        name="maxPercentDeltaUnhealthyNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of nodes health degradation allowed during cluster upgrades.
     The delta is measured between the state of the nodes at the beginning of upgrade and the state
     of the nodes at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits. Required."""
    max_percent_upgrade_domain_delta_unhealthy_nodes: Optional[int] = rest_field(
        name="maxPercentUpgradeDomainDeltaUnhealthyNodes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of upgrade domain nodes health degradation allowed during
     cluster upgrades.
     The delta is measured between the state of the upgrade domain nodes at the beginning of upgrade
     and the state of the upgrade domain nodes at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion for all completed upgrade
     domains to make sure the state of the upgrade domains is within tolerated limits."""
    max_percent_delta_unhealthy_applications: Optional[int] = rest_field(
        name="maxPercentDeltaUnhealthyApplications", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of applications health degradation allowed during cluster
     upgrades.
     The delta is measured between the state of the applications at the beginning of upgrade and the
     state of the applications at the time of the health evaluation.
     The check is performed after every upgrade domain upgrade completion to make sure the global
     state of the cluster is within tolerated limits. System services are not included in this.
     NOTE: This value will overwrite the value specified in
     properties.UpgradeDescription.HealthPolicy.MaxPercentUnhealthyApplications."""

    @overload
    def __init__(
        self,
        *,
        max_percent_delta_unhealthy_nodes: int,
        max_percent_upgrade_domain_delta_unhealthy_nodes: Optional[int] = None,
        max_percent_delta_unhealthy_applications: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterUpgradePolicy(_Model):
    """Describes the policy used when upgrading the cluster.

    :ivar force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :vartype force_restart: bool
    :ivar health_policy: The cluster health policy defines a health policy used to evaluate the
     health of the cluster during a cluster upgrade.
    :vartype health_policy: ~azure.mgmt.servicefabricmanagedclusters.models.ClusterHealthPolicy
    :ivar delta_health_policy: The cluster delta health policy defines a health policy used to
     evaluate the health of the cluster during a cluster upgrade.
    :vartype delta_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeDeltaHealthPolicy
    :ivar monitoring_policy: The cluster monitoring policy describes the parameters for monitoring
     an upgrade in Monitored mode.
    :vartype monitoring_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterMonitoringPolicy
    :ivar upgrade_replica_set_check_timeout: The maximum amount of time to block processing of an
     upgrade domain and prevent loss of availability when there are unexpected issues.
     When this timeout expires, processing of the upgrade domain will proceed regardless of
     availability loss issues.
     The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss
     or in d.hh:mm:ss.ms format.
     This value must be between 00:00:00 and 49710.06:28:15 (unsigned 32 bit integer for seconds).
    :vartype upgrade_replica_set_check_timeout: str
    """

    force_restart: Optional[bool] = rest_field(
        name="forceRestart", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, then processes are forcefully restarted during upgrade even when the code version has
     not changed (the upgrade only changes configuration or data)."""
    health_policy: Optional["_models.ClusterHealthPolicy"] = rest_field(
        name="healthPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The cluster health policy defines a health policy used to evaluate the health of the cluster
     during a cluster upgrade."""
    delta_health_policy: Optional["_models.ClusterUpgradeDeltaHealthPolicy"] = rest_field(
        name="deltaHealthPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The cluster delta health policy defines a health policy used to evaluate the health of the
     cluster during a cluster upgrade."""
    monitoring_policy: Optional["_models.ClusterMonitoringPolicy"] = rest_field(
        name="monitoringPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The cluster monitoring policy describes the parameters for monitoring an upgrade in Monitored
     mode."""
    upgrade_replica_set_check_timeout: Optional[str] = rest_field(
        name="upgradeReplicaSetCheckTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum amount of time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues.
     When this timeout expires, processing of the upgrade domain will proceed regardless of
     availability loss issues.
     The timeout is reset at the start of each upgrade domain. The timeout can be in either hh:mm:ss
     or in d.hh:mm:ss.ms format.
     This value must be between 00:00:00 and 49710.06:28:15 (unsigned 32 bit integer for seconds)."""

    @overload
    def __init__(
        self,
        *,
        force_restart: Optional[bool] = None,
        health_policy: Optional["_models.ClusterHealthPolicy"] = None,
        delta_health_policy: Optional["_models.ClusterUpgradeDeltaHealthPolicy"] = None,
        monitoring_policy: Optional["_models.ClusterMonitoringPolicy"] = None,
        upgrade_replica_set_check_timeout: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EndpointRangeDescription(_Model):
    """Port range details.

    :ivar start_port: Starting port of a range of ports. Required.
    :vartype start_port: int
    :ivar end_port: End port of a range of ports. Required.
    :vartype end_port: int
    """

    start_port: int = rest_field(name="startPort", visibility=["read", "create", "update", "delete", "query"])
    """Starting port of a range of ports. Required."""
    end_port: int = rest_field(name="endPort", visibility=["read", "create", "update", "delete", "query"])
    """End port of a range of ports. Required."""

    @overload
    def __init__(
        self,
        *,
        start_port: int,
        end_port: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.servicefabricmanagedclusters.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[list["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorModelError(_Model):
    """The error details.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error message."""

    @overload
    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.servicefabricmanagedclusters.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FaultSimulation(_Model):
    """Fault simulation object with status.

    :ivar simulation_id: unique identifier for the fault simulation.
    :vartype simulation_id: str
    :ivar status: Fault simulation status. Known values are: "Starting", "Active", "Stopping",
     "Done", "StartFailed", and "StopFailed".
    :vartype status: str or ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationStatus
    :ivar start_time: The start time of the fault simulation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the fault simulation.
    :vartype end_time: ~datetime.datetime
    :ivar details: Fault simulation details.
    :vartype details: ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationDetails
    """

    simulation_id: Optional[str] = rest_field(
        name="simulationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """unique identifier for the fault simulation."""
    status: Optional[Union[str, "_models.FaultSimulationStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Fault simulation status. Known values are: \"Starting\", \"Active\", \"Stopping\", \"Done\",
     \"StartFailed\", and \"StopFailed\"."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the fault simulation."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the fault simulation."""
    details: Optional["_models.FaultSimulationDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Fault simulation details."""

    @overload
    def __init__(
        self,
        *,
        simulation_id: Optional[str] = None,
        status: Optional[Union[str, "_models.FaultSimulationStatus"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        details: Optional["_models.FaultSimulationDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FaultSimulationConstraints(_Model):
    """Constraints for Fault Simulation action.

    :ivar expiration_time: The absolute expiration timestamp (UTC) after which this fault
     simulation should be stopped if it's still active.
    :vartype expiration_time: ~datetime.datetime
    """

    expiration_time: Optional[datetime.datetime] = rest_field(
        name="expirationTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The absolute expiration timestamp (UTC) after which this fault simulation should be stopped if
     it's still active."""

    @overload
    def __init__(
        self,
        *,
        expiration_time: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FaultSimulationContent(_Model):
    """Parameters for Fault Simulation action.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ZoneFaultSimulationContent

    :ivar fault_kind: The kind of fault to be simulated. Required. "Zone"
    :vartype fault_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.FaultKind
    :ivar force: Force the action to go through without any check on the cluster.
    :vartype force: bool
    :ivar constraints: Constraints for Fault Simulation action.
    :vartype constraints:
     ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationConstraints
    """

    __mapping__: dict[str, _Model] = {}
    fault_kind: str = rest_discriminator(name="faultKind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of fault to be simulated. Required. \"Zone\""""
    force: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Force the action to go through without any check on the cluster."""
    constraints: Optional["_models.FaultSimulationConstraints"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Constraints for Fault Simulation action."""

    @overload
    def __init__(
        self,
        *,
        fault_kind: str,
        force: Optional[bool] = None,
        constraints: Optional["_models.FaultSimulationConstraints"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FaultSimulationContentWrapper(_Model):
    """Fault Simulation Request for Start action.

    :ivar parameters: Parameters for Fault Simulation start action. Required.
    :vartype parameters: ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationContent
    """

    parameters: "_models.FaultSimulationContent" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for Fault Simulation start action. Required."""

    @overload
    def __init__(
        self,
        *,
        parameters: "_models.FaultSimulationContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FaultSimulationDetails(_Model):
    """Details for Fault Simulation.

    :ivar cluster_id: unique identifier for the cluster resource.
    :vartype cluster_id: str
    :ivar operation_id: unique identifier for the operation associated with the fault simulation.
    :vartype operation_id: str
    :ivar node_type_fault_simulation: List of node type simulations associated with the cluster
     fault simulation.
    :vartype node_type_fault_simulation:
     list[~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeFaultSimulation]
    :ivar parameters: Fault simulation parameters.
    :vartype parameters: ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationContent
    """

    cluster_id: Optional[str] = rest_field(name="clusterId", visibility=["read", "create", "update", "delete", "query"])
    """unique identifier for the cluster resource."""
    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """unique identifier for the operation associated with the fault simulation."""
    node_type_fault_simulation: Optional[list["_models.NodeTypeFaultSimulation"]] = rest_field(
        name="nodeTypeFaultSimulation", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of node type simulations associated with the cluster fault simulation."""
    parameters: Optional["_models.FaultSimulationContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Fault simulation parameters."""

    @overload
    def __init__(
        self,
        *,
        cluster_id: Optional[str] = None,
        operation_id: Optional[str] = None,
        node_type_fault_simulation: Optional[list["_models.NodeTypeFaultSimulation"]] = None,
        parameters: Optional["_models.FaultSimulationContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FaultSimulationIdContent(_Model):
    """Parameters for Fault Simulation id.

    :ivar simulation_id: unique identifier for the fault simulation. Required.
    :vartype simulation_id: str
    """

    simulation_id: str = rest_field(name="simulationId", visibility=["read", "create", "update", "delete", "query"])
    """unique identifier for the fault simulation. Required."""

    @overload
    def __init__(
        self,
        *,
        simulation_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FrontendConfiguration(_Model):
    """Describes the frontend configurations for the node type.

    :ivar ip_address_type: The IP address type of this frontend configuration. If omitted the
     default value is IPv4. Known values are: "IPv4" and "IPv6".
    :vartype ip_address_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.IPAddressType
    :ivar load_balancer_backend_address_pool_id: The resource Id of the Load Balancer backend
     address pool that the VM instances of the node type are associated with. The format of the
     resource Id is
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}'.
    :vartype load_balancer_backend_address_pool_id: str
    :ivar load_balancer_inbound_nat_pool_id: The resource Id of the Load Balancer inbound NAT pool
     that the VM instances of the node type are associated with. The format of the resource Id is
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatPools/{inboundNatPoolName}'.
    :vartype load_balancer_inbound_nat_pool_id: str
    :ivar application_gateway_backend_address_pool_id: The resource Id of application gateway
     backend address pool. The format of the resource Id is
     '/subscriptions/<subscriptionId>/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendAddressPools/{backendAddressPoolName}'.
    :vartype application_gateway_backend_address_pool_id: str
    """

    ip_address_type: Optional[Union[str, "_models.IPAddressType"]] = rest_field(
        name="ipAddressType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The IP address type of this frontend configuration. If omitted the default value is IPv4. Known
     values are: \"IPv4\" and \"IPv6\"."""
    load_balancer_backend_address_pool_id: Optional[str] = rest_field(
        name="loadBalancerBackendAddressPoolId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the Load Balancer backend address pool that the VM instances of the node
     type are associated with. The format of the resource Id is
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/backendAddressPools/{backendAddressPoolName}'."""
    load_balancer_inbound_nat_pool_id: Optional[str] = rest_field(
        name="loadBalancerInboundNatPoolId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of the Load Balancer inbound NAT pool that the VM instances of the node type
     are associated with. The format of the resource Id is
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/inboundNatPools/{inboundNatPoolName}'."""
    application_gateway_backend_address_pool_id: Optional[str] = rest_field(
        name="applicationGatewayBackendAddressPoolId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource Id of application gateway backend address pool. The format of the resource Id is
     '/subscriptions/<subscriptionId>/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/applicationGateways/{applicationGatewayName}/backendAddressPools/{backendAddressPoolName}'."""

    @overload
    def __init__(
        self,
        *,
        ip_address_type: Optional[Union[str, "_models.IPAddressType"]] = None,
        load_balancer_backend_address_pool_id: Optional[str] = None,
        load_balancer_inbound_nat_pool_id: Optional[str] = None,
        application_gateway_backend_address_pool_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpConfiguration(_Model):
    """Specifies an IP configuration of the network interface.

    :ivar name: Name of the network interface. Required.
    :vartype name: str
    :ivar application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A node type can reference backend address pools of
     multiple application gateways. Multiple node types cannot use the same application gateway.
    :vartype application_gateway_backend_address_pools:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SubResource]
    :ivar load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A node type can reference backend address pools of one public and one
     internal load balancer. Multiple node types cannot use the same basic sku load balancer.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SubResource]
    :ivar load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools of
     the load balancers. A node type can reference inbound nat pools of one public and one internal
     load balancer. Multiple node types cannot use the same basic sku load balancer.
    :vartype load_balancer_inbound_nat_pools:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SubResource]
    :ivar subnet: Specifies the subnet of the network interface.
    :vartype subnet: ~azure.mgmt.servicefabricmanagedclusters.models.SubResource
    :ivar private_ip_address_version: Specifies whether the IP configuration's private IP is IPv4
     or IPv6. Default is IPv4. Known values are: "IPv4" and "IPv6".
    :vartype private_ip_address_version: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PrivateIPAddressVersion
    :ivar public_ip_address_configuration: The public IP address configuration of the network
     interface.
    :vartype public_ip_address_configuration:
     ~azure.mgmt.servicefabricmanagedclusters.models.IPConfigurationPublicIPAddressConfiguration
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the network interface. Required."""
    application_gateway_backend_address_pools: Optional[list["_models.SubResource"]] = rest_field(
        name="applicationGatewayBackendAddressPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies an array of references to backend address pools of application gateways. A node type
     can reference backend address pools of multiple application gateways. Multiple node types
     cannot use the same application gateway."""
    load_balancer_backend_address_pools: Optional[list["_models.SubResource"]] = rest_field(
        name="loadBalancerBackendAddressPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies an array of references to backend address pools of load balancers. A node type can
     reference backend address pools of one public and one internal load balancer. Multiple node
     types cannot use the same basic sku load balancer."""
    load_balancer_inbound_nat_pools: Optional[list["_models.SubResource"]] = rest_field(
        name="loadBalancerInboundNatPools", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies an array of references to inbound Nat pools of the load balancers. A node type can
     reference inbound nat pools of one public and one internal load balancer. Multiple node types
     cannot use the same basic sku load balancer."""
    subnet: Optional["_models.SubResource"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the subnet of the network interface."""
    private_ip_address_version: Optional[Union[str, "_models.PrivateIPAddressVersion"]] = rest_field(
        name="privateIPAddressVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the IP configuration's private IP is IPv4 or IPv6. Default is IPv4. Known
     values are: \"IPv4\" and \"IPv6\"."""
    public_ip_address_configuration: Optional["_models.IPConfigurationPublicIPAddressConfiguration"] = rest_field(
        name="publicIPAddressConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The public IP address configuration of the network interface."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        application_gateway_backend_address_pools: Optional[list["_models.SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[list["_models.SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[list["_models.SubResource"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        private_ip_address_version: Optional[Union[str, "_models.PrivateIPAddressVersion"]] = None,
        public_ip_address_configuration: Optional["_models.IPConfigurationPublicIPAddressConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IPConfigurationPublicIPAddressConfiguration(_Model):  # pylint: disable=name-too-long
    """The public IP address configuration of the network interface.

    :ivar name: Name of the network interface. Required.
    :vartype name: str
    :ivar ip_tags: Specifies the list of IP tags associated with the public IP address.
    :vartype ip_tags: list[~azure.mgmt.servicefabricmanagedclusters.models.IpTag]
    :ivar public_ip_address_version: Specifies whether the IP configuration's public IP is IPv4 or
     IPv6. Default is IPv4. Known values are: "IPv4" and "IPv6".
    :vartype public_ip_address_version: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PublicIPAddressVersion
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the network interface. Required."""
    ip_tags: Optional[list["_models.IpTag"]] = rest_field(
        name="ipTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the list of IP tags associated with the public IP address."""
    public_ip_address_version: Optional[Union[str, "_models.PublicIPAddressVersion"]] = rest_field(
        name="publicIPAddressVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the IP configuration's public IP is IPv4 or IPv6. Default is IPv4. Known
     values are: \"IPv4\" and \"IPv6\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        ip_tags: Optional[list["_models.IpTag"]] = None,
        public_ip_address_version: Optional[Union[str, "_models.PublicIPAddressVersion"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class IpTag(_Model):
    """The IP tag associated with the public IP address.

    :ivar ip_tag_type: IP tag type. Example: FirstPartyUsage. Required.
    :vartype ip_tag_type: str
    :ivar tag: IP tag associated with the public IP. Example: SQL, Storage etc. Required.
    :vartype tag: str
    """

    ip_tag_type: str = rest_field(name="ipTagType", visibility=["read", "create", "update", "delete", "query"])
    """IP tag type. Example: FirstPartyUsage. Required."""
    tag: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """IP tag associated with the public IP. Example: SQL, Storage etc. Required."""

    @overload
    def __init__(
        self,
        *,
        ip_tag_type: str,
        tag: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LoadBalancingRule(_Model):
    """Describes a load balancing rule.

    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 1 and 65534. Required.
    :vartype frontend_port: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535. Required.
    :vartype backend_port: int
    :ivar protocol: The reference to the transport protocol used by the load balancing rule.
     Required. Known values are: "tcp" and "udp".
    :vartype protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.Protocol
    :ivar probe_port: The prob port used by the load balancing rule. Acceptable values are between
     1 and 65535.
    :vartype probe_port: int
    :ivar probe_protocol: the reference to the load balancer probe used by the load balancing rule.
     Required. Known values are: "tcp", "http", and "https".
    :vartype probe_protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.ProbeProtocol
    :ivar probe_request_path: The probe request path. Only supported for HTTP/HTTPS probes.
    :vartype probe_request_path: str
    :ivar load_distribution: The load distribution policy for this rule.
    :vartype load_distribution: str
    """

    frontend_port: int = rest_field(name="frontendPort", visibility=["read", "create", "update", "delete", "query"])
    """The port for the external endpoint. Port numbers for each rule must be unique within the Load
     Balancer. Acceptable values are between 1 and 65534. Required."""
    backend_port: int = rest_field(name="backendPort", visibility=["read", "create", "update", "delete", "query"])
    """The port used for internal connections on the endpoint. Acceptable values are between 1 and
     65535. Required."""
    protocol: Union[str, "_models.Protocol"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The reference to the transport protocol used by the load balancing rule. Required. Known values
     are: \"tcp\" and \"udp\"."""
    probe_port: Optional[int] = rest_field(name="probePort", visibility=["read", "create", "update", "delete", "query"])
    """The prob port used by the load balancing rule. Acceptable values are between 1 and 65535."""
    probe_protocol: Union[str, "_models.ProbeProtocol"] = rest_field(
        name="probeProtocol", visibility=["read", "create", "update", "delete", "query"]
    )
    """the reference to the load balancer probe used by the load balancing rule. Required. Known
     values are: \"tcp\", \"http\", and \"https\"."""
    probe_request_path: Optional[str] = rest_field(
        name="probeRequestPath", visibility=["read", "create", "update", "delete", "query"]
    )
    """The probe request path. Only supported for HTTP/HTTPS probes."""
    load_distribution: Optional[str] = rest_field(
        name="loadDistribution", visibility=["read", "create", "update", "delete", "query"]
    )
    """The load distribution policy for this rule."""

    @overload
    def __init__(
        self,
        *,
        frontend_port: int,
        backend_port: int,
        protocol: Union[str, "_models.Protocol"],
        probe_protocol: Union[str, "_models.ProbeProtocol"],
        probe_port: Optional[int] = None,
        probe_request_path: Optional[str] = None,
        load_distribution: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LongRunningOperationResult(_Model):
    """Long running operation result.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The completion percentage of the operation.
    :vartype percent_complete: float
    :ivar status: The status of the operation.
    :vartype status: str
    :ivar error: The operation error.
    :vartype error: ~azure.mgmt.servicefabricmanagedclusters.models.ErrorModelError
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the operation."""
    start_time: Optional[datetime.datetime] = rest_field(
        name="startTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The start time of the operation."""
    end_time: Optional[datetime.datetime] = rest_field(
        name="endTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The end time of the operation."""
    percent_complete: Optional[float] = rest_field(
        name="percentComplete", visibility=["read", "create", "update", "delete", "query"]
    )
    """The completion percentage of the operation."""
    status: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The status of the operation."""
    error: Optional["_models.ErrorModelError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The operation error."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        status: Optional[str] = None,
        error: Optional["_models.ErrorModelError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedAzResiliencyStatus(_Model):
    """Describes the result of the request to list Managed VM Sizes for Service Fabric Managed
    Clusters.

    :ivar base_resource_status: List of Managed VM Sizes for Service Fabric Managed Clusters.
    :vartype base_resource_status:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ResourceAzStatus]
    :ivar is_cluster_zone_resilient: URL to get the next set of Managed VM Sizes if there are any.
    :vartype is_cluster_zone_resilient: bool
    """

    base_resource_status: Optional[list["_models.ResourceAzStatus"]] = rest_field(
        name="baseResourceStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of Managed VM Sizes for Service Fabric Managed Clusters."""
    is_cluster_zone_resilient: Optional[bool] = rest_field(name="isClusterZoneResilient", visibility=["read"])
    """URL to get the next set of Managed VM Sizes if there are any."""

    @overload
    def __init__(
        self,
        *,
        base_resource_status: Optional[list["_models.ResourceAzStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """Tracked Resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedCluster(TrackedResource):
    """The managed cluster resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The managed cluster resource properties.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.ManagedClusterProperties
    :ivar etag: If eTag is provided in the response body, it may also be provided as a header per
     the normal etag convention.  Entity tags are used for comparing two or more entities from the
     same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match
     (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.",.
    :vartype etag: str
    :ivar sku: The sku of the managed cluster. Required.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.Sku
    """

    properties: Optional["_models.ManagedClusterProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed cluster resource properties."""
    etag: Optional[str] = rest_field(visibility=["read"])
    """If eTag is provided in the response body, it may also be provided as a header per the normal
     etag convention.  Entity tags are used for comparing two or more entities from the same
     requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section
     14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields.\",."""
    sku: "_models.Sku" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku of the managed cluster. Required."""

    __flattened_items = [
        "dns_name",
        "fqdn",
        "ipv4_address",
        "cluster_id",
        "cluster_state",
        "cluster_certificate_thumbprints",
        "client_connection_port",
        "http_gateway_connection_port",
        "admin_user_name",
        "admin_password",
        "load_balancing_rules",
        "allow_rdp_access",
        "network_security_rules",
        "clients",
        "azure_active_directory",
        "fabric_settings",
        "provisioning_state",
        "cluster_code_version",
        "cluster_upgrade_mode",
        "cluster_upgrade_cadence",
        "addon_features",
        "enable_auto_os_upgrade",
        "zonal_resiliency",
        "application_type_versions_cleanup_policy",
        "enable_ipv6",
        "subnet_id",
        "ip_tags",
        "ipv6_address",
        "enable_service_public_ip",
        "auxiliary_subnets",
        "service_endpoints",
        "zonal_update_mode",
        "use_custom_vnet",
        "public_ip_prefix_id",
        "public_i_pv6_prefix_id",
        "ddos_protection_plan_id",
        "upgrade_description",
        "http_gateway_token_auth_connection_port",
        "enable_http_gateway_exclusive_auth_mode",
        "auto_generated_domain_name_label_scope",
        "allocated_outbound_ports",
        "vm_image",
        "enable_outbound_only_node_types",
    ]

    @overload
    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[dict[str, str]] = None,
        properties: Optional["_models.ManagedClusterProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ManagedClusterCodeVersionResult(_Model):
    """The result of the Service Fabric runtime versions.

    :ivar id: The identification of the result.
    :vartype id: str
    :ivar name: The name of the result.
    :vartype name: str
    :ivar type: The result resource type.
    :vartype type: str
    :ivar properties: The detail of the Service Fabric runtime version result.
    :vartype properties:
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedClusterVersionDetails
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The identification of the result."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the result."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The result resource type."""
    properties: Optional["_models.ManagedClusterVersionDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The detail of the Service Fabric runtime version result."""

    __flattened_items = ["cluster_code_version", "support_expiry_utc", "os_type"]

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        type: Optional[str] = None,
        properties: Optional["_models.ManagedClusterVersionDetails"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class ManagedClusterProperties(_Model):
    """Describes the managed cluster resource properties.

    :ivar dns_name: The cluster dns name. Required.
    :vartype dns_name: str
    :ivar fqdn: The fully qualified domain name associated with the public load balancer of the
     cluster.
    :vartype fqdn: str
    :ivar ipv4_address: The IPv4 address associated with the public load balancer of the cluster.
    :vartype ipv4_address: str
    :ivar cluster_id: A service generated unique identifier for the cluster resource.
    :vartype cluster_id: str
    :ivar cluster_state: The current state of the cluster. Known values are: "WaitingForNodes",
     "Deploying", "BaselineUpgrade", "Upgrading", "UpgradeFailed", and "Ready".
    :vartype cluster_state: str or ~azure.mgmt.servicefabricmanagedclusters.models.ClusterState
    :ivar cluster_certificate_thumbprints: List of thumbprints of the cluster certificates.
    :vartype cluster_certificate_thumbprints: list[str]
    :ivar client_connection_port: The port used for client connections to the cluster.
    :vartype client_connection_port: int
    :ivar http_gateway_connection_port: The port used for HTTP connections to the cluster.
    :vartype http_gateway_connection_port: int
    :ivar admin_user_name: VM admin user name. Required.
    :vartype admin_user_name: str
    :ivar admin_password: VM admin user password.
    :vartype admin_password: str
    :ivar load_balancing_rules: Load balancing rules that are applied to the public load balancer
     of the cluster.
    :vartype load_balancing_rules:
     list[~azure.mgmt.servicefabricmanagedclusters.models.LoadBalancingRule]
    :ivar allow_rdp_access: Setting this to true enables RDP access to the VM. The default NSG rule
     opens RDP port to Internet which can be overridden with custom Network Security Rules. The
     default value for this setting is false.
    :vartype allow_rdp_access: bool
    :ivar network_security_rules: Custom Network Security Rules that are applied to the Virtual
     Network of the cluster.
    :vartype network_security_rules:
     list[~azure.mgmt.servicefabricmanagedclusters.models.NetworkSecurityRule]
    :ivar clients: Client certificates that are allowed to manage the cluster.
    :vartype clients: list[~azure.mgmt.servicefabricmanagedclusters.models.ClientCertificate]
    :ivar azure_active_directory: The AAD authentication settings of the cluster.
    :vartype azure_active_directory:
     ~azure.mgmt.servicefabricmanagedclusters.models.AzureActiveDirectory
    :ivar fabric_settings: The list of custom fabric settings to configure the cluster.
    :vartype fabric_settings:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SettingsSectionDescription]
    :ivar provisioning_state: The provisioning state of the managed cluster resource. Known values
     are: "None", "Creating", "Created", "Updating", "Succeeded", "Failed", "Canceled", "Deleting",
     "Deleted", and "Other".
    :vartype provisioning_state: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedResourceProvisioningState
    :ivar cluster_code_version: The Service Fabric runtime version of the cluster. This property is
     required when **clusterUpgradeMode** is set to 'Manual'. To get list of available Service
     Fabric versions for new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To get the
     list of available version for existing clusters use **availableClusterVersions**.
    :vartype cluster_code_version: str
    :ivar cluster_upgrade_mode: The upgrade mode of the cluster when new Service Fabric runtime
     version is available. Known values are: "Automatic" and "Manual".
    :vartype cluster_upgrade_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeMode
    :ivar cluster_upgrade_cadence: Indicates when new cluster runtime version upgrades will be
     applied after they are released. By default is Wave0. Only applies when **clusterUpgradeMode**
     is set to 'Automatic'. Known values are: "Wave0", "Wave1", and "Wave2".
    :vartype cluster_upgrade_cadence: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradeCadence
    :ivar addon_features: List of add-on features to enable on the cluster.
    :vartype addon_features: list[str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedClusterAddOnFeature]
    :ivar enable_auto_os_upgrade: Enables automatic OS upgrade for node types created using OS
     images with version 'latest'. The default value for this setting is false.
    :vartype enable_auto_os_upgrade: bool
    :ivar zonal_resiliency: Indicates if the cluster has zone resiliency.
    :vartype zonal_resiliency: bool
    :ivar application_type_versions_cleanup_policy: The policy used to clean up unused versions.
    :vartype application_type_versions_cleanup_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.ApplicationTypeVersionsCleanupPolicy
    :ivar enable_ipv6: Setting this to true creates IPv6 address space for the default VNet used by
     the cluster. This setting cannot be changed once the cluster is created. The default value for
     this setting is false.
    :vartype enable_ipv6: bool
    :ivar subnet_id: If specified, the node types for the cluster are created in this subnet
     instead of the default VNet. The **networkSecurityRules** specified for the cluster are also
     applied to this subnet. This setting cannot be changed once the cluster is created.
    :vartype subnet_id: str
    :ivar ip_tags: The list of IP tags associated with the default public IP address of the
     cluster.
    :vartype ip_tags: list[~azure.mgmt.servicefabricmanagedclusters.models.IpTag]
    :ivar ipv6_address: IPv6 address for the cluster if IPv6 is enabled.
    :vartype ipv6_address: str
    :ivar enable_service_public_ip: Setting this to true will link the IPv4 address as the
     ServicePublicIP of the IPv6 address. It can only be set to True if IPv6 is enabled on the
     cluster.
    :vartype enable_service_public_ip: bool
    :ivar auxiliary_subnets: Auxiliary subnets for the cluster.
    :vartype auxiliary_subnets: list[~azure.mgmt.servicefabricmanagedclusters.models.Subnet]
    :ivar service_endpoints: Service endpoints for subnets in the cluster.
    :vartype service_endpoints:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceEndpoint]
    :ivar zonal_update_mode: Indicates the update mode for Cross Az clusters. Known values are:
     "Standard" and "Fast".
    :vartype zonal_update_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ZonalUpdateMode
    :ivar use_custom_vnet: For new clusters, this parameter indicates that it uses Bring your own
     VNet, but the subnet is specified at node type level; and for such clusters, the subnetId
     property is required for node types.
    :vartype use_custom_vnet: bool
    :ivar public_ip_prefix_id: Specify the resource id of a public IPv4 prefix that the load
     balancer will allocate a public IPv4 address from. This setting cannot be changed once the
     cluster is created.
    :vartype public_ip_prefix_id: str
    :ivar public_i_pv6_prefix_id: Specify the resource id of a public IPv6 prefix that the load
     balancer will allocate a public IPv6 address from. This setting cannot be changed once the
     cluster is created.
    :vartype public_i_pv6_prefix_id: str
    :ivar ddos_protection_plan_id: Specify the resource id of a DDoS network protection plan that
     will be associated with the virtual network of the cluster.
    :vartype ddos_protection_plan_id: str
    :ivar upgrade_description: The policy to use when upgrading the cluster.
    :vartype upgrade_description:
     ~azure.mgmt.servicefabricmanagedclusters.models.ClusterUpgradePolicy
    :ivar http_gateway_token_auth_connection_port: The port used for token-auth based HTTPS
     connections to the cluster. Cannot be set to the same port as HttpGatewayEndpoint.
    :vartype http_gateway_token_auth_connection_port: int
    :ivar enable_http_gateway_exclusive_auth_mode: If true, token-based authentication is not
     allowed on the HttpGatewayEndpoint. This is required to support TLS versions 1.3 and above. If
     token-based authentication is used, HttpGatewayTokenAuthConnectionPort must be defined.
    :vartype enable_http_gateway_exclusive_auth_mode: bool
    :ivar auto_generated_domain_name_label_scope: This property is the entry point to using a
     public CA cert for your cluster cert. It specifies the level of reuse allowed for the custom
     FQDN created, matching the subject of the public CA cert. Known values are: "TenantReuse",
     "SubscriptionReuse", "ResourceGroupReuse", and "NoReuse".
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.AutoGeneratedDomainNameLabelScope
    :ivar allocated_outbound_ports: The number of outbound ports allocated for SNAT for each node
     in the backend pool of the default load balancer. The default value is 0 which provides dynamic
     port allocation based on pool size.
    :vartype allocated_outbound_ports: int
    :ivar vm_image: The VM image the node types are configured with. This property controls the
     Service Fabric component packages to be used for the cluster. Allowed values are: 'Windows'.
     The default value is 'Windows'.
    :vartype vm_image: str
    :ivar enable_outbound_only_node_types: Enable the creation of node types with only outbound
     traffic enabled. If set, a separate load balancer backend pool will be created for node types
     with inbound traffic enabled. Can only be set at the time of cluster creation.
    :vartype enable_outbound_only_node_types: bool
    """

    dns_name: str = rest_field(name="dnsName", visibility=["read", "create", "update", "delete", "query"])
    """The cluster dns name. Required."""
    fqdn: Optional[str] = rest_field(visibility=["read"])
    """The fully qualified domain name associated with the public load balancer of the cluster."""
    ipv4_address: Optional[str] = rest_field(name="ipv4Address", visibility=["read"])
    """The IPv4 address associated with the public load balancer of the cluster."""
    cluster_id: Optional[str] = rest_field(name="clusterId", visibility=["read"])
    """A service generated unique identifier for the cluster resource."""
    cluster_state: Optional[Union[str, "_models.ClusterState"]] = rest_field(name="clusterState", visibility=["read"])
    """The current state of the cluster. Known values are: \"WaitingForNodes\", \"Deploying\",
     \"BaselineUpgrade\", \"Upgrading\", \"UpgradeFailed\", and \"Ready\"."""
    cluster_certificate_thumbprints: Optional[list[str]] = rest_field(
        name="clusterCertificateThumbprints", visibility=["read"]
    )
    """List of thumbprints of the cluster certificates."""
    client_connection_port: Optional[int] = rest_field(
        name="clientConnectionPort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port used for client connections to the cluster."""
    http_gateway_connection_port: Optional[int] = rest_field(
        name="httpGatewayConnectionPort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port used for HTTP connections to the cluster."""
    admin_user_name: str = rest_field(name="adminUserName", visibility=["read", "create", "update", "delete", "query"])
    """VM admin user name. Required."""
    admin_password: Optional[str] = rest_field(
        name="adminPassword", visibility=["read", "create", "update", "delete", "query"]
    )
    """VM admin user password."""
    load_balancing_rules: Optional[list["_models.LoadBalancingRule"]] = rest_field(
        name="loadBalancingRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Load balancing rules that are applied to the public load balancer of the cluster."""
    allow_rdp_access: Optional[bool] = rest_field(
        name="allowRdpAccess", visibility=["read", "create", "update", "delete", "query"]
    )
    """Setting this to true enables RDP access to the VM. The default NSG rule opens RDP port to
     Internet which can be overridden with custom Network Security Rules. The default value for this
     setting is false."""
    network_security_rules: Optional[list["_models.NetworkSecurityRule"]] = rest_field(
        name="networkSecurityRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """Custom Network Security Rules that are applied to the Virtual Network of the cluster."""
    clients: Optional[list["_models.ClientCertificate"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Client certificates that are allowed to manage the cluster."""
    azure_active_directory: Optional["_models.AzureActiveDirectory"] = rest_field(
        name="azureActiveDirectory", visibility=["read", "create", "update", "delete", "query"]
    )
    """The AAD authentication settings of the cluster."""
    fabric_settings: Optional[list["_models.SettingsSectionDescription"]] = rest_field(
        name="fabricSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of custom fabric settings to configure the cluster."""
    provisioning_state: Optional[Union[str, "_models.ManagedResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the managed cluster resource. Known values are: \"None\",
     \"Creating\", \"Created\", \"Updating\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleting\",
     \"Deleted\", and \"Other\"."""
    cluster_code_version: Optional[str] = rest_field(
        name="clusterCodeVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Service Fabric runtime version of the cluster. This property is required when
     **clusterUpgradeMode** is set to 'Manual'. To get list of available Service Fabric versions for
     new clusters use `ClusterVersion API <./ClusterVersion.md>`_. To get the list of available
     version for existing clusters use **availableClusterVersions**."""
    cluster_upgrade_mode: Optional[Union[str, "_models.ClusterUpgradeMode"]] = rest_field(
        name="clusterUpgradeMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade mode of the cluster when new Service Fabric runtime version is available. Known
     values are: \"Automatic\" and \"Manual\"."""
    cluster_upgrade_cadence: Optional[Union[str, "_models.ClusterUpgradeCadence"]] = rest_field(
        name="clusterUpgradeCadence", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates when new cluster runtime version upgrades will be applied after they are released. By
     default is Wave0. Only applies when **clusterUpgradeMode** is set to 'Automatic'. Known values
     are: \"Wave0\", \"Wave1\", and \"Wave2\"."""
    addon_features: Optional[list[Union[str, "_models.ManagedClusterAddOnFeature"]]] = rest_field(
        name="addonFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of add-on features to enable on the cluster."""
    enable_auto_os_upgrade: Optional[bool] = rest_field(
        name="enableAutoOSUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enables automatic OS upgrade for node types created using OS images with version 'latest'. The
     default value for this setting is false."""
    zonal_resiliency: Optional[bool] = rest_field(
        name="zonalResiliency", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the cluster has zone resiliency."""
    application_type_versions_cleanup_policy: Optional["_models.ApplicationTypeVersionsCleanupPolicy"] = rest_field(
        name="applicationTypeVersionsCleanupPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy used to clean up unused versions."""
    enable_ipv6: Optional[bool] = rest_field(
        name="enableIpv6", visibility=["read", "create", "update", "delete", "query"]
    )
    """Setting this to true creates IPv6 address space for the default VNet used by the cluster. This
     setting cannot be changed once the cluster is created. The default value for this setting is
     false."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """If specified, the node types for the cluster are created in this subnet instead of the default
     VNet. The **networkSecurityRules** specified for the cluster are also applied to this subnet.
     This setting cannot be changed once the cluster is created."""
    ip_tags: Optional[list["_models.IpTag"]] = rest_field(
        name="ipTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of IP tags associated with the default public IP address of the cluster."""
    ipv6_address: Optional[str] = rest_field(name="ipv6Address", visibility=["read"])
    """IPv6 address for the cluster if IPv6 is enabled."""
    enable_service_public_ip: Optional[bool] = rest_field(
        name="enableServicePublicIP", visibility=["read", "create", "update", "delete", "query"]
    )
    """Setting this to true will link the IPv4 address as the ServicePublicIP of the IPv6 address. It
     can only be set to True if IPv6 is enabled on the cluster."""
    auxiliary_subnets: Optional[list["_models.Subnet"]] = rest_field(
        name="auxiliarySubnets", visibility=["read", "create", "update", "delete", "query"]
    )
    """Auxiliary subnets for the cluster."""
    service_endpoints: Optional[list["_models.ServiceEndpoint"]] = rest_field(
        name="serviceEndpoints", visibility=["read", "create", "update", "delete", "query"]
    )
    """Service endpoints for subnets in the cluster."""
    zonal_update_mode: Optional[Union[str, "_models.ZonalUpdateMode"]] = rest_field(
        name="zonalUpdateMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the update mode for Cross Az clusters. Known values are: \"Standard\" and \"Fast\"."""
    use_custom_vnet: Optional[bool] = rest_field(
        name="useCustomVnet", visibility=["read", "create", "update", "delete", "query"]
    )
    """For new clusters, this parameter indicates that it uses Bring your own VNet, but the subnet is
     specified at node type level; and for such clusters, the subnetId property is required for node
     types."""
    public_ip_prefix_id: Optional[str] = rest_field(
        name="publicIPPrefixId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify the resource id of a public IPv4 prefix that the load balancer will allocate a public
     IPv4 address from. This setting cannot be changed once the cluster is created."""
    public_i_pv6_prefix_id: Optional[str] = rest_field(
        name="publicIPv6PrefixId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify the resource id of a public IPv6 prefix that the load balancer will allocate a public
     IPv6 address from. This setting cannot be changed once the cluster is created."""
    ddos_protection_plan_id: Optional[str] = rest_field(
        name="ddosProtectionPlanId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specify the resource id of a DDoS network protection plan that will be associated with the
     virtual network of the cluster."""
    upgrade_description: Optional["_models.ClusterUpgradePolicy"] = rest_field(
        name="upgradeDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """The policy to use when upgrading the cluster."""
    http_gateway_token_auth_connection_port: Optional[int] = rest_field(
        name="httpGatewayTokenAuthConnectionPort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port used for token-auth based HTTPS connections to the cluster. Cannot be set to the same
     port as HttpGatewayEndpoint."""
    enable_http_gateway_exclusive_auth_mode: Optional[bool] = rest_field(
        name="enableHttpGatewayExclusiveAuthMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, token-based authentication is not allowed on the HttpGatewayEndpoint. This is required
     to support TLS versions 1.3 and above. If token-based authentication is used,
     HttpGatewayTokenAuthConnectionPort must be defined."""
    auto_generated_domain_name_label_scope: Optional[Union[str, "_models.AutoGeneratedDomainNameLabelScope"]] = (
        rest_field(name="autoGeneratedDomainNameLabelScope", visibility=["read", "create", "update", "delete", "query"])
    )
    """This property is the entry point to using a public CA cert for your cluster cert. It specifies
     the level of reuse allowed for the custom FQDN created, matching the subject of the public CA
     cert. Known values are: \"TenantReuse\", \"SubscriptionReuse\", \"ResourceGroupReuse\", and
     \"NoReuse\"."""
    allocated_outbound_ports: Optional[int] = rest_field(
        name="allocatedOutboundPorts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of outbound ports allocated for SNAT for each node in the backend pool of the
     default load balancer. The default value is 0 which provides dynamic port allocation based on
     pool size."""
    vm_image: Optional[str] = rest_field(name="VMImage", visibility=["read", "create", "update", "delete", "query"])
    """The VM image the node types are configured with. This property controls the Service Fabric
     component packages to be used for the cluster. Allowed values are: 'Windows'. The default value
     is 'Windows'."""
    enable_outbound_only_node_types: Optional[bool] = rest_field(
        name="enableOutboundOnlyNodeTypes", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable the creation of node types with only outbound traffic enabled. If set, a separate load
     balancer backend pool will be created for node types with inbound traffic enabled. Can only be
     set at the time of cluster creation."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        dns_name: str,
        admin_user_name: str,
        client_connection_port: Optional[int] = None,
        http_gateway_connection_port: Optional[int] = None,
        admin_password: Optional[str] = None,
        load_balancing_rules: Optional[list["_models.LoadBalancingRule"]] = None,
        allow_rdp_access: Optional[bool] = None,
        network_security_rules: Optional[list["_models.NetworkSecurityRule"]] = None,
        clients: Optional[list["_models.ClientCertificate"]] = None,
        azure_active_directory: Optional["_models.AzureActiveDirectory"] = None,
        fabric_settings: Optional[list["_models.SettingsSectionDescription"]] = None,
        cluster_code_version: Optional[str] = None,
        cluster_upgrade_mode: Optional[Union[str, "_models.ClusterUpgradeMode"]] = None,
        cluster_upgrade_cadence: Optional[Union[str, "_models.ClusterUpgradeCadence"]] = None,
        addon_features: Optional[list[Union[str, "_models.ManagedClusterAddOnFeature"]]] = None,
        enable_auto_os_upgrade: Optional[bool] = None,
        zonal_resiliency: Optional[bool] = None,
        application_type_versions_cleanup_policy: Optional["_models.ApplicationTypeVersionsCleanupPolicy"] = None,
        enable_ipv6: Optional[bool] = None,
        subnet_id: Optional[str] = None,
        ip_tags: Optional[list["_models.IpTag"]] = None,
        enable_service_public_ip: Optional[bool] = None,
        auxiliary_subnets: Optional[list["_models.Subnet"]] = None,
        service_endpoints: Optional[list["_models.ServiceEndpoint"]] = None,
        zonal_update_mode: Optional[Union[str, "_models.ZonalUpdateMode"]] = None,
        use_custom_vnet: Optional[bool] = None,
        public_ip_prefix_id: Optional[str] = None,
        public_i_pv6_prefix_id: Optional[str] = None,
        ddos_protection_plan_id: Optional[str] = None,
        upgrade_description: Optional["_models.ClusterUpgradePolicy"] = None,
        http_gateway_token_auth_connection_port: Optional[int] = None,
        enable_http_gateway_exclusive_auth_mode: Optional[bool] = None,
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        allocated_outbound_ports: Optional[int] = None,
        vm_image: Optional[str] = None,
        enable_outbound_only_node_types: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedClusterUpdateParameters(_Model):
    """Managed cluster update request.

    :ivar tags: Managed cluster update parameters.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Managed cluster update parameters."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedClusterVersionDetails(_Model):
    """The detail of the Service Fabric runtime version result.

    :ivar cluster_code_version: The Service Fabric runtime version of the cluster.
    :vartype cluster_code_version: str
    :ivar support_expiry_utc: The date of expiry of support of the version.
    :vartype support_expiry_utc: ~datetime.datetime
    :ivar os_type: Cluster operating system, the default will be Windows. "Windows"
    :vartype os_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.OsType
    """

    cluster_code_version: Optional[str] = rest_field(
        name="clusterCodeVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Service Fabric runtime version of the cluster."""
    support_expiry_utc: Optional[datetime.datetime] = rest_field(
        name="supportExpiryUtc", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The date of expiry of support of the version."""
    os_type: Optional[Union[str, "_models.OsType"]] = rest_field(
        name="osType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Cluster operating system, the default will be Windows. \"Windows\""""

    @overload
    def __init__(
        self,
        *,
        cluster_code_version: Optional[str] = None,
        support_expiry_utc: Optional[datetime.datetime] = None,
        os_type: Optional[Union[str, "_models.OsType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedIdentity(_Model):
    """Describes the managed identities for an Azure resource.

    :ivar principal_id: The principal id of the managed identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the managed identity. This property will only be provided for
     a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity for the resource. Known values are: "None",
     "SystemAssigned", "UserAssigned", and "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.servicefabricmanagedclusters.models.ManagedIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.servicefabricmanagedclusters.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of the managed identity. This property will only be provided for a system
     assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant id of the managed identity. This property will only be provided for a system
     assigned identity."""
    type: Optional[Union[str, "_models.ManagedIdentityType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity for the resource. Known values are: \"None\", \"SystemAssigned\",
     \"UserAssigned\", and \"SystemAssigned, UserAssigned\"."""
    user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the resource. The user identity dictionary key
     references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        user_assigned_identities: Optional[dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedMaintenanceWindowStatus(_Model):
    """Describes the maintenance window status of the Service Fabric Managed Cluster.

    :ivar is_window_enabled: If maintenance window is enabled on this cluster.
    :vartype is_window_enabled: bool
    :ivar is_region_ready: Indicates if the region is ready to configure maintenance windows.
    :vartype is_region_ready: bool
    :ivar is_window_active: If maintenance window is active.
    :vartype is_window_active: bool
    :ivar can_apply_updates: If updates can be applied.
    :vartype can_apply_updates: bool
    :ivar last_window_status_update_at_utc: Last window update time in UTC.
    :vartype last_window_status_update_at_utc: ~datetime.datetime
    :ivar last_window_start_time_utc: Last window start time in UTC.
    :vartype last_window_start_time_utc: ~datetime.datetime
    :ivar last_window_end_time_utc: Last window end time in UTC.
    :vartype last_window_end_time_utc: ~datetime.datetime
    """

    is_window_enabled: Optional[bool] = rest_field(name="isWindowEnabled", visibility=["read"])
    """If maintenance window is enabled on this cluster."""
    is_region_ready: Optional[bool] = rest_field(name="isRegionReady", visibility=["read"])
    """Indicates if the region is ready to configure maintenance windows."""
    is_window_active: Optional[bool] = rest_field(name="isWindowActive", visibility=["read"])
    """If maintenance window is active."""
    can_apply_updates: Optional[bool] = rest_field(name="canApplyUpdates", visibility=["read"])
    """If updates can be applied."""
    last_window_status_update_at_utc: Optional[datetime.datetime] = rest_field(
        name="lastWindowStatusUpdateAtUTC", visibility=["read"], format="rfc3339"
    )
    """Last window update time in UTC."""
    last_window_start_time_utc: Optional[datetime.datetime] = rest_field(
        name="lastWindowStartTimeUTC", visibility=["read"], format="rfc3339"
    )
    """Last window start time in UTC."""
    last_window_end_time_utc: Optional[datetime.datetime] = rest_field(
        name="lastWindowEndTimeUTC", visibility=["read"], format="rfc3339"
    )
    """Last window end time in UTC."""


class ManagedVMSize(_Model):
    """Describes a VM Sizes.

    :ivar properties: VM Size properties.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.VMSize
    :ivar id: VM Size id.
    :vartype id: str
    :ivar name: VM Size name.
    :vartype name: str
    :ivar type: VM Size type.
    :vartype type: str
    """

    properties: Optional["_models.VMSize"] = rest_field(visibility=["read"])
    """VM Size properties."""
    id: Optional[str] = rest_field(visibility=["read"])
    """VM Size id."""
    name: Optional[str] = rest_field(visibility=["read"])
    """VM Size name."""
    type: Optional[str] = rest_field(visibility=["read"])
    """VM Size type."""


class Partition(_Model):
    """Describes how the service is partitioned.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    NamedPartitionScheme, SingletonPartitionScheme, UniformInt64RangePartitionScheme

    :ivar partition_scheme: Required. Known values are: "Singleton", "UniformInt64Range", and
     "Named".
    :vartype partition_scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PartitionScheme
    """

    __mapping__: dict[str, _Model] = {}
    partition_scheme: str = rest_discriminator(
        name="partitionScheme", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"Singleton\", \"UniformInt64Range\", and \"Named\"."""

    @overload
    def __init__(
        self,
        *,
        partition_scheme: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NamedPartitionScheme(Partition, discriminator="Named"):
    """Describes the named partition scheme of the service.

    :ivar names: Array for the names of the partitions. Required.
    :vartype names: list[str]
    :ivar partition_scheme: Specifies how the service is partitioned. Required. Indicates that the
     partition is based on string names, and is a NamedPartitionScheme object. The value is 2.
    :vartype partition_scheme: str or ~azure.mgmt.servicefabricmanagedclusters.models.NAMED
    """

    names: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Array for the names of the partitions. Required."""
    partition_scheme: Literal[PartitionScheme.NAMED] = rest_discriminator(name="partitionScheme", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies how the service is partitioned. Required. Indicates that the partition is based on
     string names, and is a NamedPartitionScheme object. The value is 2."""

    @overload
    def __init__(
        self,
        *,
        names: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.partition_scheme = PartitionScheme.NAMED  # type: ignore


class NetworkSecurityRule(_Model):
    """Describes a network security rule.

    :ivar name: Network security rule name. Required.
    :vartype name: str
    :ivar description: Network security rule description.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Required. Known values are: "http",
     "https", "tcp", "udp", "icmp", "ah", and "esp".
    :vartype protocol: str or ~azure.mgmt.servicefabricmanagedclusters.models.NsgProtocol
    :ivar source_address_prefixes: The CIDR or source IP ranges.
    :vartype source_address_prefixes: list[str]
    :ivar destination_address_prefixes: The destination address prefixes. CIDR or destination IP
     ranges.
    :vartype destination_address_prefixes: list[str]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix. CIDR or destination IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :vartype destination_address_prefix: str
    :ivar source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_range: str
    :ivar destination_port_range: he destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_range: str
    :ivar access: The network traffic is allowed or denied. Required. Known values are: "allow" and
     "deny".
    :vartype access: str or ~azure.mgmt.servicefabricmanagedclusters.models.Access
    :ivar priority: The priority of the rule. The value can be in the range 1000 to 3000. Values
     outside this range are reserved for Service Fabric ManagerCluster Resource Provider. The
     priority number must be unique for each rule in the collection. The lower the priority number,
     the higher the priority of the rule. Required.
    :vartype priority: int
    :ivar direction: Network security rule direction. Required. Known values are: "inbound" and
     "outbound".
    :vartype direction: str or ~azure.mgmt.servicefabricmanagedclusters.models.Direction
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Network security rule name. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Network security rule description."""
    protocol: Union[str, "_models.NsgProtocol"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Network protocol this rule applies to. Required. Known values are: \"http\", \"https\",
     \"tcp\", \"udp\", \"icmp\", \"ah\", and \"esp\"."""
    source_address_prefixes: Optional[list[str]] = rest_field(
        name="sourceAddressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The CIDR or source IP ranges."""
    destination_address_prefixes: Optional[list[str]] = rest_field(
        name="destinationAddressPrefixes", visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination address prefixes. CIDR or destination IP ranges."""
    source_port_ranges: Optional[list[str]] = rest_field(
        name="sourcePortRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source port ranges."""
    destination_port_ranges: Optional[list[str]] = rest_field(
        name="destinationPortRanges", visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination port ranges."""
    source_address_prefix: Optional[str] = rest_field(
        name="sourceAddressPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default
     tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is
     an ingress rule, specifies where network traffic originates from."""
    destination_address_prefix: Optional[str] = rest_field(
        name="destinationAddressPrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used."""
    source_port_range: Optional[str] = rest_field(
        name="sourcePortRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used
     to match all ports."""
    destination_port_range: Optional[str] = rest_field(
        name="destinationPortRange", visibility=["read", "create", "update", "delete", "query"]
    )
    """he destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be
     used to match all ports."""
    access: Union[str, "_models.Access"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The network traffic is allowed or denied. Required. Known values are: \"allow\" and \"deny\"."""
    priority: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The priority of the rule. The value can be in the range 1000 to 3000. Values outside this range
     are reserved for Service Fabric ManagerCluster Resource Provider. The priority number must be
     unique for each rule in the collection. The lower the priority number, the higher the priority
     of the rule. Required."""
    direction: Union[str, "_models.Direction"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Network security rule direction. Required. Known values are: \"inbound\" and \"outbound\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "_models.NsgProtocol"],
        access: Union[str, "_models.Access"],
        priority: int,
        direction: Union[str, "_models.Direction"],
        description: Optional[str] = None,
        source_address_prefixes: Optional[list[str]] = None,
        destination_address_prefixes: Optional[list[str]] = None,
        source_port_ranges: Optional[list[str]] = None,
        destination_port_ranges: Optional[list[str]] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeType(ProxyResource):
    """Describes a node type in the cluster, each node type represents sub set of nodes in the
    cluster.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar properties: The node type properties.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The node type sku.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSku
    """

    properties: Optional["_models.NodeTypeProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The node type properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    sku: Optional["_models.NodeTypeSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The node type sku."""

    __flattened_items = [
        "is_primary",
        "vm_instance_count",
        "data_disk_size_gb",
        "data_disk_type",
        "data_disk_letter",
        "placement_properties",
        "capacities",
        "application_ports",
        "ephemeral_ports",
        "vm_size",
        "vm_image_publisher",
        "vm_image_offer",
        "vm_image_sku",
        "vm_image_version",
        "vm_secrets",
        "vm_extensions",
        "vm_managed_identity",
        "is_stateless",
        "multiple_placement_groups",
        "frontend_configurations",
        "network_security_rules",
        "additional_data_disks",
        "enable_encryption_at_host",
        "provisioning_state",
        "enable_accelerated_networking",
        "use_default_public_load_balancer",
        "use_temp_data_disk",
        "enable_over_provisioning",
        "zones",
        "is_spot_vm",
        "host_group_id",
        "use_ephemeral_os_disk",
        "spot_restore_timeout",
        "eviction_policy",
        "vm_image_resource_id",
        "subnet_id",
        "vm_setup_actions",
        "security_type",
        "security_encryption_type",
        "secure_boot_enabled",
        "enable_node_public_ip",
        "enable_node_public_i_pv6",
        "vm_shared_gallery_image_id",
        "nat_gateway_id",
        "nat_configurations",
        "vm_image_plan",
        "service_artifact_reference_id",
        "dscp_configuration_id",
        "additional_network_interface_configurations",
        "computer_name_prefix",
        "vm_applications",
        "zone_balance",
        "is_outbound_only",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.NodeTypeProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.NodeTypeSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class NodeTypeActionParameters(_Model):
    """Parameters for Node type action. If nodes are not specified on the parameters, the operation
    will be performed in all nodes of the node type one upgrade domain at a time.

    :ivar nodes: List of node names from the node type.
    :vartype nodes: list[str]
    :ivar force: Force the action to go through.
    :vartype force: bool
    :ivar update_type: Specifies the way the operation will be performed. Known values are:
     "Default" and "ByUpgradeDomain".
    :vartype update_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.UpdateType
    """

    nodes: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of node names from the node type."""
    force: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Force the action to go through."""
    update_type: Optional[Union[str, "_models.UpdateType"]] = rest_field(
        name="updateType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the way the operation will be performed. Known values are: \"Default\" and
     \"ByUpgradeDomain\"."""

    @overload
    def __init__(
        self,
        *,
        nodes: Optional[list[str]] = None,
        force: Optional[bool] = None,
        update_type: Optional[Union[str, "_models.UpdateType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeTypeAvailableSku(_Model):
    """Defines the type of sku available for a node type.

    :ivar resource_type: The type of resource the sku applies to. Value:
     Microsoft.ServiceFabric/managedClusters/nodeTypes.
    :vartype resource_type: str
    :ivar sku: The supported SKU for a for node type.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSupportedSku
    :ivar capacity: Provides information about how the node count can be scaled.
    :vartype capacity: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSkuCapacity
    """

    resource_type: Optional[str] = rest_field(name="resourceType", visibility=["read"])
    """The type of resource the sku applies to. Value:
     Microsoft.ServiceFabric/managedClusters/nodeTypes."""
    sku: Optional["_models.NodeTypeSupportedSku"] = rest_field(visibility=["read"])
    """The supported SKU for a for node type."""
    capacity: Optional["_models.NodeTypeSkuCapacity"] = rest_field(visibility=["read"])
    """Provides information about how the node count can be scaled."""


class NodeTypeFaultSimulation(_Model):
    """Node type fault simulation object with status.

    :ivar node_type_name: Node type name.
    :vartype node_type_name: str
    :ivar status: Fault simulation status. Known values are: "Starting", "Active", "Stopping",
     "Done", "StartFailed", and "StopFailed".
    :vartype status: str or ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationStatus
    :ivar operation_id: Current or latest asynchronous operation identifier on the node type.
    :vartype operation_id: str
    :ivar operation_status: Current or latest asynchronous operation status on the node type. Known
     values are: "Created", "Started", "Succeeded", "Failed", "Aborted", and "Canceled".
    :vartype operation_status: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.SfmcOperationStatus
    """

    node_type_name: Optional[str] = rest_field(
        name="nodeTypeName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Node type name."""
    status: Optional[Union[str, "_models.FaultSimulationStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Fault simulation status. Known values are: \"Starting\", \"Active\", \"Stopping\", \"Done\",
     \"StartFailed\", and \"StopFailed\"."""
    operation_id: Optional[str] = rest_field(
        name="operationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current or latest asynchronous operation identifier on the node type."""
    operation_status: Optional[Union[str, "_models.SfmcOperationStatus"]] = rest_field(
        name="operationStatus", visibility=["read", "create", "update", "delete", "query"]
    )
    """Current or latest asynchronous operation status on the node type. Known values are:
     \"Created\", \"Started\", \"Succeeded\", \"Failed\", \"Aborted\", and \"Canceled\"."""

    @overload
    def __init__(
        self,
        *,
        node_type_name: Optional[str] = None,
        status: Optional[Union[str, "_models.FaultSimulationStatus"]] = None,
        operation_id: Optional[str] = None,
        operation_status: Optional[Union[str, "_models.SfmcOperationStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeTypeNatConfig(_Model):
    """Provides information about NAT configuration on the default public Load Balancer for the node
    type.

    :ivar backend_port: The internal port for the NAT configuration.
    :vartype backend_port: int
    :ivar frontend_port_range_start: The port range start for the external endpoint.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The port range end for the external endpoint.
    :vartype frontend_port_range_end: int
    """

    backend_port: Optional[int] = rest_field(
        name="backendPort", visibility=["read", "create", "update", "delete", "query"]
    )
    """The internal port for the NAT configuration."""
    frontend_port_range_start: Optional[int] = rest_field(
        name="frontendPortRangeStart", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port range start for the external endpoint."""
    frontend_port_range_end: Optional[int] = rest_field(
        name="frontendPortRangeEnd", visibility=["read", "create", "update", "delete", "query"]
    )
    """The port range end for the external endpoint."""

    @overload
    def __init__(
        self,
        *,
        backend_port: Optional[int] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeTypeProperties(_Model):
    """Describes a node type in the cluster, each node type represents sub set of nodes in the
    cluster.

    :ivar is_primary: Indicates the Service Fabric system services for the cluster will run on this
     node type. This setting cannot be changed once the node type is created. Required.
    :vartype is_primary: bool
    :ivar vm_instance_count: The number of nodes in the node type. **Values:** -1 - Use when auto
     scale rules are configured or sku.capacity is defined 0 - Not supported >0 - Use for manual
     scale. Required.
    :vartype vm_instance_count: int
    :ivar data_disk_size_gb: Disk size for the managed disk attached to the vms on the node type in
     GBs.
    :vartype data_disk_size_gb: int
    :ivar data_disk_type: Managed data disk type. Specifies the storage account type for the
     managed disk. Known values are: "Standard_LRS", "StandardSSD_LRS", "Premium_LRS",
     "PremiumV2_LRS", "StandardSSD_ZRS", and "Premium_ZRS".
    :vartype data_disk_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.DiskType
    :ivar data_disk_letter: Managed data disk letter. It can not use the reserved letter C or D and
     it can not change after created.
    :vartype data_disk_letter: str
    :ivar placement_properties: The placement tags applied to nodes in the node type, which can be
     used to indicate where certain services (workload) should run.
    :vartype placement_properties: dict[str, str]
    :ivar capacities: The capacity tags applied to the nodes in the node type, the cluster resource
     manager uses these tags to understand how much resource a node has.
    :vartype capacities: dict[str, str]
    :ivar application_ports: The range of ports from which cluster assigned port to Service Fabric
     applications.
    :vartype application_ports:
     ~azure.mgmt.servicefabricmanagedclusters.models.EndpointRangeDescription
    :ivar ephemeral_ports: The range of ephemeral ports that nodes in this node type should be
     configured with.
    :vartype ephemeral_ports:
     ~azure.mgmt.servicefabricmanagedclusters.models.EndpointRangeDescription
    :ivar vm_size: The size of virtual machines in the pool. All virtual machines in a pool are the
     same size. For example, Standard_D3.
    :vartype vm_size: str
    :ivar vm_image_publisher: The publisher of the Azure Virtual Machines Marketplace image. For
     example, Canonical or MicrosoftWindowsServer.
    :vartype vm_image_publisher: str
    :ivar vm_image_offer: The offer type of the Azure Virtual Machines Marketplace image. For
     example, UbuntuServer or WindowsServer.
    :vartype vm_image_offer: str
    :ivar vm_image_sku: The SKU of the Azure Virtual Machines Marketplace image. For example,
     14.04.0-LTS or 2012-R2-Datacenter.
    :vartype vm_image_sku: str
    :ivar vm_image_version: The version of the Azure Virtual Machines Marketplace image. A value of
     'latest' can be specified to select the latest version of an image. If omitted, the default is
     'latest'.
    :vartype vm_image_version: str
    :ivar vm_secrets: The secrets to install in the virtual machines.
    :vartype vm_secrets: list[~azure.mgmt.servicefabricmanagedclusters.models.VaultSecretGroup]
    :ivar vm_extensions: Set of extensions that should be installed onto the virtual machines.
    :vartype vm_extensions: list[~azure.mgmt.servicefabricmanagedclusters.models.VMSSExtension]
    :ivar vm_managed_identity: Identities to assign to the virtual machine scale set under the node
     type.
    :vartype vm_managed_identity: ~azure.mgmt.servicefabricmanagedclusters.models.VmManagedIdentity
    :ivar is_stateless: Indicates if the node type can only host Stateless workloads.
    :vartype is_stateless: bool
    :ivar multiple_placement_groups: Indicates if scale set associated with the node type can be
     composed of multiple placement groups.
    :vartype multiple_placement_groups: bool
    :ivar frontend_configurations: Indicates the node type uses its own frontend configurations
     instead of the default one for the cluster. This setting can only be specified for non-primary
     node types and can not be added or removed after the node type is created.
    :vartype frontend_configurations:
     list[~azure.mgmt.servicefabricmanagedclusters.models.FrontendConfiguration]
    :ivar network_security_rules: The Network Security Rules for this node type. This setting can
     only be specified for node types that are configured with frontend configurations.
    :vartype network_security_rules:
     list[~azure.mgmt.servicefabricmanagedclusters.models.NetworkSecurityRule]
    :ivar additional_data_disks: Additional managed data disks.
    :vartype additional_data_disks:
     list[~azure.mgmt.servicefabricmanagedclusters.models.VmssDataDisk]
    :ivar enable_encryption_at_host: Enable or disable the Host Encryption for the virtual machines
     on the node type. This will enable the encryption for all the disks including Resource/Temp
     disk at host itself. Default: The Encryption at host will be disabled unless this property is
     set to true for the resource.
    :vartype enable_encryption_at_host: bool
    :ivar provisioning_state: The provisioning state of the node type resource. Known values are:
     "None", "Creating", "Created", "Updating", "Succeeded", "Failed", "Canceled", "Deleting",
     "Deleted", and "Other".
    :vartype provisioning_state: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ManagedResourceProvisioningState
    :ivar enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :vartype enable_accelerated_networking: bool
    :ivar use_default_public_load_balancer: Specifies whether the use public load balancer. If not
     specified and the node type doesn't have its own frontend configuration, it will be attached to
     the default load balancer. If the node type uses its own Load balancer and
     useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If
     the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set,
     then the custom load balancer must include a public load balancer to provide outbound
     connectivity.
    :vartype use_default_public_load_balancer: bool
    :ivar use_temp_data_disk: Specifies whether to use the temporary disk for the service fabric
     data root, in which case no managed data disk will be attached and the temporary disk will be
     used. It is only allowed for stateless node types.
    :vartype use_temp_data_disk: bool
    :ivar enable_over_provisioning: Specifies whether the node type should be overprovisioned. It
     is only allowed for stateless node types.
    :vartype enable_over_provisioning: bool
    :ivar zones: Specifies the availability zones where the node type would span across. If the
     cluster is not spanning across availability zones, initiates az migration for the cluster.
    :vartype zones: list[str]
    :ivar is_spot_vm: Indicates whether the node type will be Spot Virtual Machines. Azure will
     allocate the VMs if there is capacity available and the VMs can be evicted at any time.
    :vartype is_spot_vm: bool
    :ivar host_group_id: Specifies the full host group resource Id. This property is used for
     deploying on azure dedicated hosts.
    :vartype host_group_id: str
    :ivar use_ephemeral_os_disk: Indicates whether to use ephemeral os disk. The sku selected on
     the vmSize property needs to support this feature.
    :vartype use_ephemeral_os_disk: bool
    :ivar spot_restore_timeout: Indicates the time duration after which the platform will not try
     to restore the VMSS SPOT instances specified as ISO 8601.
    :vartype spot_restore_timeout: str
    :ivar eviction_policy: Specifies the eviction policy for virtual machines in a SPOT node type.
     Default is Delete. Known values are: "Delete" and "Deallocate".
    :vartype eviction_policy: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.EvictionPolicyType
    :ivar vm_image_resource_id: Indicates the resource id of the vm image. This parameter is used
     for custom vm image.
    :vartype vm_image_resource_id: str
    :ivar subnet_id: Indicates the resource id of the subnet for the node type.
    :vartype subnet_id: str
    :ivar vm_setup_actions: Specifies the actions to be performed on the vms before bootstrapping
     the service fabric runtime.
    :vartype vm_setup_actions: list[str or
     ~azure.mgmt.servicefabricmanagedclusters.models.VmSetupAction]
    :ivar security_type: Specifies the security type of the nodeType. Supported values include
     Standard, TrustedLaunch and ConfidentialVM. Known values are: "TrustedLaunch", "Standard", and
     "ConfidentialVM".
    :vartype security_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.SecurityType
    :ivar security_encryption_type: Specifies the EncryptionType of the managed disk. It is set to
     DiskWithVMGuestState for encryption of the managed disk along with VMGuestState blob and
     VMGuestStateOnly for encryption of just the VMGuestState blob. Note: It can be set for only
     Confidential VMs. Known values are: "DiskWithVMGuestState" and "VMGuestStateOnly".
    :vartype security_encryption_type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.SecurityEncryptionType
    :ivar secure_boot_enabled: Specifies whether secure boot should be enabled on the nodeType. Can
     only be used with TrustedLaunch and ConfidentialVM SecurityType.
    :vartype secure_boot_enabled: bool
    :ivar enable_node_public_ip: Specifies whether each node is allocated its own public IPv4
     address. This is only supported on secondary node types with custom Load Balancers.
    :vartype enable_node_public_ip: bool
    :ivar enable_node_public_i_pv6: Specifies whether each node is allocated its own public IPv6
     address. This is only supported on secondary node types with custom Load Balancers.
    :vartype enable_node_public_i_pv6: bool
    :ivar vm_shared_gallery_image_id: Indicates the resource id of the vm shared galleries image.
     This parameter is used for custom vm image.
    :vartype vm_shared_gallery_image_id: str
    :ivar nat_gateway_id: Specifies the resource id of a NAT Gateway to attach to the subnet of
     this node type. Node type must use custom load balancer.
    :vartype nat_gateway_id: str
    :ivar nat_configurations: Specifies the NAT configuration on default public Load Balancer for
     the node type. This is only supported for node types use the default public Load Balancer.
    :vartype nat_configurations:
     list[~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeNatConfig]
    :ivar vm_image_plan: Specifies information about the marketplace image used to create the
     virtual machine. This element is only used for marketplace images. Before you can use a
     marketplace image from an API, you must enable the image for programmatic use. In the Azure
     portal, find the marketplace image that you want to use and then click Want to deploy
     programmatically, Get Started ->. Enter any required information and then click Save.
    :vartype vm_image_plan: ~azure.mgmt.servicefabricmanagedclusters.models.VmImagePlan
    :ivar service_artifact_reference_id: Specifies the service artifact reference id used to set
     same image version for all virtual machines in the scale set when using 'latest' image version.
    :vartype service_artifact_reference_id: str
    :ivar dscp_configuration_id: Specifies the resource id of the DSCP configuration to apply to
     the node type network interface.
    :vartype dscp_configuration_id: str
    :ivar additional_network_interface_configurations: Specifies the settings for any additional
     secondary network interfaces to attach to the node type.
    :vartype additional_network_interface_configurations:
     list[~azure.mgmt.servicefabricmanagedclusters.models.AdditionalNetworkInterfaceConfiguration]
    :ivar computer_name_prefix: Specifies the computer name prefix. Limited to 9 characters. If
     specified, allows for a longer name to be specified for the node type name.
    :vartype computer_name_prefix: str
    :ivar vm_applications: Specifies the gallery applications that should be made available to the
     underlying VMSS.
    :vartype vm_applications: list[~azure.mgmt.servicefabricmanagedclusters.models.VmApplication]
    :ivar zone_balance: Setting this to true allows stateless node types to scale out without equal
     distribution across zones.
    :vartype zone_balance: bool
    :ivar is_outbound_only: Specifies the node type should be configured for only outbound traffic
     and not inbound traffic.
    :vartype is_outbound_only: bool
    """

    is_primary: bool = rest_field(name="isPrimary", visibility=["read", "create", "update", "delete", "query"])
    """Indicates the Service Fabric system services for the cluster will run on this node type. This
     setting cannot be changed once the node type is created. Required."""
    vm_instance_count: int = rest_field(
        name="vmInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of nodes in the node type. **Values:** -1 - Use when auto scale rules are configured
     or sku.capacity is defined 0 - Not supported >0 - Use for manual scale. Required."""
    data_disk_size_gb: Optional[int] = rest_field(
        name="dataDiskSizeGB", visibility=["read", "create", "update", "delete", "query"]
    )
    """Disk size for the managed disk attached to the vms on the node type in GBs."""
    data_disk_type: Optional[Union[str, "_models.DiskType"]] = rest_field(
        name="dataDiskType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed data disk type. Specifies the storage account type for the managed disk. Known values
     are: \"Standard_LRS\", \"StandardSSD_LRS\", \"Premium_LRS\", \"PremiumV2_LRS\",
     \"StandardSSD_ZRS\", and \"Premium_ZRS\"."""
    data_disk_letter: Optional[str] = rest_field(
        name="dataDiskLetter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed data disk letter. It can not use the reserved letter C or D and it can not change after
     created."""
    placement_properties: Optional[dict[str, str]] = rest_field(
        name="placementProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """The placement tags applied to nodes in the node type, which can be used to indicate where
     certain services (workload) should run."""
    capacities: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The capacity tags applied to the nodes in the node type, the cluster resource manager uses
     these tags to understand how much resource a node has."""
    application_ports: Optional["_models.EndpointRangeDescription"] = rest_field(
        name="applicationPorts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of ports from which cluster assigned port to Service Fabric applications."""
    ephemeral_ports: Optional["_models.EndpointRangeDescription"] = rest_field(
        name="ephemeralPorts", visibility=["read", "create", "update", "delete", "query"]
    )
    """The range of ephemeral ports that nodes in this node type should be configured with."""
    vm_size: Optional[str] = rest_field(name="vmSize", visibility=["read", "create", "update", "delete", "query"])
    """The size of virtual machines in the pool. All virtual machines in a pool are the same size. For
     example, Standard_D3."""
    vm_image_publisher: Optional[str] = rest_field(
        name="vmImagePublisher", visibility=["read", "create", "update", "delete", "query"]
    )
    """The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or
     MicrosoftWindowsServer."""
    vm_image_offer: Optional[str] = rest_field(
        name="vmImageOffer", visibility=["read", "create", "update", "delete", "query"]
    )
    """The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or
     WindowsServer."""
    vm_image_sku: Optional[str] = rest_field(
        name="vmImageSku", visibility=["read", "create", "update", "delete", "query"]
    )
    """The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or
     2012-R2-Datacenter."""
    vm_image_version: Optional[str] = rest_field(
        name="vmImageVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be
     specified to select the latest version of an image. If omitted, the default is 'latest'."""
    vm_secrets: Optional[list["_models.VaultSecretGroup"]] = rest_field(
        name="vmSecrets", visibility=["read", "create", "update", "delete", "query"]
    )
    """The secrets to install in the virtual machines."""
    vm_extensions: Optional[list["_models.VMSSExtension"]] = rest_field(
        name="vmExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of extensions that should be installed onto the virtual machines."""
    vm_managed_identity: Optional["_models.VmManagedIdentity"] = rest_field(
        name="vmManagedIdentity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identities to assign to the virtual machine scale set under the node type."""
    is_stateless: Optional[bool] = rest_field(
        name="isStateless", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the node type can only host Stateless workloads."""
    multiple_placement_groups: Optional[bool] = rest_field(
        name="multiplePlacementGroups", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if scale set associated with the node type can be composed of multiple placement
     groups."""
    frontend_configurations: Optional[list["_models.FrontendConfiguration"]] = rest_field(
        name="frontendConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the node type uses its own frontend configurations instead of the default one for the
     cluster. This setting can only be specified for non-primary node types and can not be added or
     removed after the node type is created."""
    network_security_rules: Optional[list["_models.NetworkSecurityRule"]] = rest_field(
        name="networkSecurityRules", visibility=["read", "create", "update", "delete", "query"]
    )
    """The Network Security Rules for this node type. This setting can only be specified for node
     types that are configured with frontend configurations."""
    additional_data_disks: Optional[list["_models.VmssDataDisk"]] = rest_field(
        name="additionalDataDisks", visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional managed data disks."""
    enable_encryption_at_host: Optional[bool] = rest_field(
        name="enableEncryptionAtHost", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable or disable the Host Encryption for the virtual machines on the node type. This will
     enable the encryption for all the disks including Resource/Temp disk at host itself. Default:
     The Encryption at host will be disabled unless this property is set to true for the resource."""
    provisioning_state: Optional[Union[str, "_models.ManagedResourceProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The provisioning state of the node type resource. Known values are: \"None\", \"Creating\",
     \"Created\", \"Updating\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleting\", \"Deleted\",
     and \"Other\"."""
    enable_accelerated_networking: Optional[bool] = rest_field(
        name="enableAcceleratedNetworking", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the network interface is accelerated networking-enabled."""
    use_default_public_load_balancer: Optional[bool] = rest_field(
        name="useDefaultPublicLoadBalancer", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the use public load balancer. If not specified and the node type doesn't have
     its own frontend configuration, it will be attached to the default load balancer. If the node
     type uses its own Load balancer and useDefaultPublicLoadBalancer is true, then the frontend has
     to be an Internal Load Balancer. If the node type uses its own Load balancer and
     useDefaultPublicLoadBalancer is false or not set, then the custom load balancer must include a
     public load balancer to provide outbound connectivity."""
    use_temp_data_disk: Optional[bool] = rest_field(
        name="useTempDataDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether to use the temporary disk for the service fabric data root, in which case no
     managed data disk will be attached and the temporary disk will be used. It is only allowed for
     stateless node types."""
    enable_over_provisioning: Optional[bool] = rest_field(
        name="enableOverProvisioning", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether the node type should be overprovisioned. It is only allowed for stateless
     node types."""
    zones: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the availability zones where the node type would span across. If the cluster is not
     spanning across availability zones, initiates az migration for the cluster."""
    is_spot_vm: Optional[bool] = rest_field(name="isSpotVM", visibility=["read", "create", "update", "delete", "query"])
    """Indicates whether the node type will be Spot Virtual Machines. Azure will allocate the VMs if
     there is capacity available and the VMs can be evicted at any time."""
    host_group_id: Optional[str] = rest_field(
        name="hostGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the full host group resource Id. This property is used for deploying on azure
     dedicated hosts."""
    use_ephemeral_os_disk: Optional[bool] = rest_field(
        name="useEphemeralOSDisk", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether to use ephemeral os disk. The sku selected on the vmSize property needs to
     support this feature."""
    spot_restore_timeout: Optional[str] = rest_field(
        name="spotRestoreTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the time duration after which the platform will not try to restore the VMSS SPOT
     instances specified as ISO 8601."""
    eviction_policy: Optional[Union[str, "_models.EvictionPolicyType"]] = rest_field(
        name="evictionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
     Known values are: \"Delete\" and \"Deallocate\"."""
    vm_image_resource_id: Optional[str] = rest_field(
        name="vmImageResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the resource id of the vm image. This parameter is used for custom vm image."""
    subnet_id: Optional[str] = rest_field(name="subnetId", visibility=["read", "create", "update", "delete", "query"])
    """Indicates the resource id of the subnet for the node type."""
    vm_setup_actions: Optional[list[Union[str, "_models.VmSetupAction"]]] = rest_field(
        name="vmSetupActions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the actions to be performed on the vms before bootstrapping the service fabric
     runtime."""
    security_type: Optional[Union[str, "_models.SecurityType"]] = rest_field(
        name="securityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the security type of the nodeType. Supported values include Standard, TrustedLaunch
     and ConfidentialVM. Known values are: \"TrustedLaunch\", \"Standard\", and \"ConfidentialVM\"."""
    security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionType"]] = rest_field(
        name="securityEncryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the EncryptionType of the managed disk. It is set to DiskWithVMGuestState for
     encryption of the managed disk along with VMGuestState blob and VMGuestStateOnly for encryption
     of just the VMGuestState blob. Note: It can be set for only Confidential VMs. Known values are:
     \"DiskWithVMGuestState\" and \"VMGuestStateOnly\"."""
    secure_boot_enabled: Optional[bool] = rest_field(
        name="secureBootEnabled", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether secure boot should be enabled on the nodeType. Can only be used with
     TrustedLaunch and ConfidentialVM SecurityType."""
    enable_node_public_ip: Optional[bool] = rest_field(
        name="enableNodePublicIP", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether each node is allocated its own public IPv4 address. This is only supported on
     secondary node types with custom Load Balancers."""
    enable_node_public_i_pv6: Optional[bool] = rest_field(
        name="enableNodePublicIPv6", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies whether each node is allocated its own public IPv6 address. This is only supported on
     secondary node types with custom Load Balancers."""
    vm_shared_gallery_image_id: Optional[str] = rest_field(
        name="vmSharedGalleryImageId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the resource id of the vm shared galleries image. This parameter is used for custom
     vm image."""
    nat_gateway_id: Optional[str] = rest_field(
        name="natGatewayId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the resource id of a NAT Gateway to attach to the subnet of this node type. Node type
     must use custom load balancer."""
    nat_configurations: Optional[list["_models.NodeTypeNatConfig"]] = rest_field(
        name="natConfigurations", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the NAT configuration on default public Load Balancer for the node type. This is only
     supported for node types use the default public Load Balancer."""
    vm_image_plan: Optional["_models.VmImagePlan"] = rest_field(
        name="vmImagePlan", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies information about the marketplace image used to create the virtual machine. This
     element is only used for marketplace images. Before you can use a marketplace image from an
     API, you must enable the image for programmatic use. In the Azure portal, find the marketplace
     image that you want to use and then click Want to deploy programmatically, Get Started ->.
     Enter any required information and then click Save."""
    service_artifact_reference_id: Optional[str] = rest_field(
        name="serviceArtifactReferenceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the service artifact reference id used to set same image version for all virtual
     machines in the scale set when using 'latest' image version."""
    dscp_configuration_id: Optional[str] = rest_field(
        name="dscpConfigurationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the resource id of the DSCP configuration to apply to the node type network
     interface."""
    additional_network_interface_configurations: Optional[list["_models.AdditionalNetworkInterfaceConfiguration"]] = (
        rest_field(
            name="additionalNetworkInterfaceConfigurations", visibility=["read", "create", "update", "delete", "query"]
        )
    )
    """Specifies the settings for any additional secondary network interfaces to attach to the node
     type."""
    computer_name_prefix: Optional[str] = rest_field(
        name="computerNamePrefix", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the computer name prefix. Limited to 9 characters. If specified, allows for a longer
     name to be specified for the node type name."""
    vm_applications: Optional[list["_models.VmApplication"]] = rest_field(
        name="vmApplications", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the gallery applications that should be made available to the underlying VMSS."""
    zone_balance: Optional[bool] = rest_field(
        name="zoneBalance", visibility=["read", "create", "update", "delete", "query"]
    )
    """Setting this to true allows stateless node types to scale out without equal distribution across
     zones."""
    is_outbound_only: Optional[bool] = rest_field(
        name="isOutboundOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the node type should be configured for only outbound traffic and not inbound traffic."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        is_primary: bool,
        vm_instance_count: int,
        data_disk_size_gb: Optional[int] = None,
        data_disk_type: Optional[Union[str, "_models.DiskType"]] = None,
        data_disk_letter: Optional[str] = None,
        placement_properties: Optional[dict[str, str]] = None,
        capacities: Optional[dict[str, str]] = None,
        application_ports: Optional["_models.EndpointRangeDescription"] = None,
        ephemeral_ports: Optional["_models.EndpointRangeDescription"] = None,
        vm_size: Optional[str] = None,
        vm_image_publisher: Optional[str] = None,
        vm_image_offer: Optional[str] = None,
        vm_image_sku: Optional[str] = None,
        vm_image_version: Optional[str] = None,
        vm_secrets: Optional[list["_models.VaultSecretGroup"]] = None,
        vm_extensions: Optional[list["_models.VMSSExtension"]] = None,
        vm_managed_identity: Optional["_models.VmManagedIdentity"] = None,
        is_stateless: Optional[bool] = None,
        multiple_placement_groups: Optional[bool] = None,
        frontend_configurations: Optional[list["_models.FrontendConfiguration"]] = None,
        network_security_rules: Optional[list["_models.NetworkSecurityRule"]] = None,
        additional_data_disks: Optional[list["_models.VmssDataDisk"]] = None,
        enable_encryption_at_host: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        use_default_public_load_balancer: Optional[bool] = None,
        use_temp_data_disk: Optional[bool] = None,
        enable_over_provisioning: Optional[bool] = None,
        zones: Optional[list[str]] = None,
        is_spot_vm: Optional[bool] = None,
        host_group_id: Optional[str] = None,
        use_ephemeral_os_disk: Optional[bool] = None,
        spot_restore_timeout: Optional[str] = None,
        eviction_policy: Optional[Union[str, "_models.EvictionPolicyType"]] = None,
        vm_image_resource_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        vm_setup_actions: Optional[list[Union[str, "_models.VmSetupAction"]]] = None,
        security_type: Optional[Union[str, "_models.SecurityType"]] = None,
        security_encryption_type: Optional[Union[str, "_models.SecurityEncryptionType"]] = None,
        secure_boot_enabled: Optional[bool] = None,
        enable_node_public_ip: Optional[bool] = None,
        enable_node_public_i_pv6: Optional[bool] = None,
        vm_shared_gallery_image_id: Optional[str] = None,
        nat_gateway_id: Optional[str] = None,
        nat_configurations: Optional[list["_models.NodeTypeNatConfig"]] = None,
        vm_image_plan: Optional["_models.VmImagePlan"] = None,
        service_artifact_reference_id: Optional[str] = None,
        dscp_configuration_id: Optional[str] = None,
        additional_network_interface_configurations: Optional[
            list["_models.AdditionalNetworkInterfaceConfiguration"]
        ] = None,
        computer_name_prefix: Optional[str] = None,
        vm_applications: Optional[list["_models.VmApplication"]] = None,
        zone_balance: Optional[bool] = None,
        is_outbound_only: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeTypeSku(_Model):
    """Describes a node type sku.

    :ivar name: The sku name. Name is internally generated and is used in auto-scale scenarios.
     Property does not allow to be changed to other values than generated. To avoid deployment
     errors please omit the property.
    :vartype name: str
    :ivar tier: Specifies the tier of the node type. Possible Values: **Standard**.
    :vartype tier: str
    :ivar capacity: The number of nodes in the node type. If present in request it will override
     properties.vmInstanceCount. Required.
    :vartype capacity: int
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sku name. Name is internally generated and is used in auto-scale scenarios. Property does
     not allow to be changed to other values than generated. To avoid deployment errors please omit
     the property."""
    tier: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the tier of the node type. Possible Values: **Standard**."""
    capacity: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of nodes in the node type. If present in request it will override
     properties.vmInstanceCount. Required."""

    @overload
    def __init__(
        self,
        *,
        capacity: int,
        name: Optional[str] = None,
        tier: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NodeTypeSkuCapacity(_Model):
    """Provides information about how node type can be scaled.

    :ivar minimum: Lowest permitted node count in a node type.
    :vartype minimum: int
    :ivar maximum: Highest permitted node count in a node type.
    :vartype maximum: int
    :ivar default: Default node count in a node type.
    :vartype default: int
    :ivar scale_type: Node type capacity scale type. Known values are: "None", "Manual", and
     "Automatic".
    :vartype scale_type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSkuScaleType
    """

    minimum: Optional[int] = rest_field(visibility=["read"])
    """Lowest permitted node count in a node type."""
    maximum: Optional[int] = rest_field(visibility=["read"])
    """Highest permitted node count in a node type."""
    default: Optional[int] = rest_field(visibility=["read"])
    """Default node count in a node type."""
    scale_type: Optional[Union[str, "_models.NodeTypeSkuScaleType"]] = rest_field(name="scaleType", visibility=["read"])
    """Node type capacity scale type. Known values are: \"None\", \"Manual\", and \"Automatic\"."""


class NodeTypeSupportedSku(_Model):
    """Describes a node type supported sku.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: Specifies the tier of the node type. Possible Values: **Standard**.
    :vartype tier: str
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The sku name."""
    tier: Optional[str] = rest_field(visibility=["read"])
    """Specifies the tier of the node type. Possible Values: **Standard**."""


class NodeTypeUpdateParameters(_Model):
    """Node type update request.

    :ivar tags: Node type update parameters.
    :vartype tags: dict[str, str]
    :ivar sku: The node type sku.
    :vartype sku: ~azure.mgmt.servicefabricmanagedclusters.models.NodeTypeSku
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Node type update parameters."""
    sku: Optional["_models.NodeTypeSku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The node type sku."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
        sku: Optional["_models.NodeTypeSku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationResult(_Model):
    """Available operation list result.

    :ivar name: The name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.servicefabricmanagedclusters.models.AvailableOperationDisplay
    :ivar origin: Origin result.
    :vartype origin: str
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the operation."""
    is_data_action: Optional[bool] = rest_field(
        name="isDataAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the operation is a data action."""
    display: Optional["_models.AvailableOperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The object that represents the operation."""
    origin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Origin result."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """The URL to use for getting the next set of results."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.AvailableOperationDisplay"] = None,
        origin: Optional[str] = None,
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PartitionInstanceCountScaleMechanism(ScalingMechanism, discriminator="ScalePartitionInstanceCount"):
    """Represents a scaling mechanism for adding or removing instances of stateless service partition.

    :ivar min_instance_count: Minimum number of instances of the partition. Required.
    :vartype min_instance_count: int
    :ivar max_instance_count: Maximum number of instances of the partition. Required.
    :vartype max_instance_count: int
    :ivar scale_increment: The number of instances to add or remove during a scaling operation.
     Required.
    :vartype scale_increment: int
    :ivar kind: Specifies the mechanism associated with this scaling policy. Required. Represents a
     scaling mechanism for adding or removing instances of stateless service partition. The value is
     0.
    :vartype kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.SCALE_PARTITION_INSTANCE_COUNT
    """

    min_instance_count: int = rest_field(
        name="minInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Minimum number of instances of the partition. Required."""
    max_instance_count: int = rest_field(
        name="maxInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of instances of the partition. Required."""
    scale_increment: int = rest_field(name="scaleIncrement", visibility=["read", "create", "update", "delete", "query"])
    """The number of instances to add or remove during a scaling operation. Required."""
    kind: Literal[ServiceScalingMechanismKind.SCALE_PARTITION_INSTANCE_COUNT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the mechanism associated with this scaling policy. Required. Represents a scaling
     mechanism for adding or removing instances of stateless service partition. The value is 0."""

    @overload
    def __init__(
        self,
        *,
        min_instance_count: int,
        max_instance_count: int,
        scale_increment: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = ServiceScalingMechanismKind.SCALE_PARTITION_INSTANCE_COUNT  # type: ignore


class ResourceAzStatus(_Model):
    """Describes Az Resiliency status of Base resources.

    :ivar resource_name: VM Size properties.
    :vartype resource_name: str
    :ivar resource_type: VM Size id.
    :vartype resource_type: str
    :ivar is_zone_resilient: VM Size name.
    :vartype is_zone_resilient: bool
    :ivar details: Zone resiliency status details for the resource.
    :vartype details: str
    """

    resource_name: Optional[str] = rest_field(name="resourceName", visibility=["read"])
    """VM Size properties."""
    resource_type: Optional[str] = rest_field(name="resourceType", visibility=["read"])
    """VM Size id."""
    is_zone_resilient: Optional[bool] = rest_field(name="isZoneResilient", visibility=["read"])
    """VM Size name."""
    details: Optional[str] = rest_field(visibility=["read"])
    """Zone resiliency status details for the resource."""


class RestartDeployedCodePackageRequest(_Model):
    """Parameters for restarting a deployed code package.

    :ivar node_name: The name of the node where the code package needs to be restarted. Use '*' to
     restart on all nodes where the code package is running. Required.
    :vartype node_name: str
    :ivar service_manifest_name: The name of the service manifest as specified in the code package.
     Required.
    :vartype service_manifest_name: str
    :ivar code_package_name: The name of the code package as specified in the service manifest.
     Required.
    :vartype code_package_name: str
    :ivar code_package_instance_id: The instance ID for currently running entry point. For a code
     package setup entry point (if specified) runs first and after it finishes main entry point is
     started. Each time entry point executable is run, its instance ID will change. If 0 is passed
     in as the code package instance ID, the API will restart the code package with whatever
     instance ID it is currently running. If an instance ID other than 0 is passed in, the API will
     restart the code package only if the current Instance ID matches the passed in instance ID.
     Note, passing in the exact instance ID (not 0) in the API is safer, because if ensures at most
     one restart of the code package. Required.
    :vartype code_package_instance_id: str
    :ivar service_package_activation_id: The activation id of a deployed service package. If
     ServicePackageActivationMode specified at the time of creating the service is 'SharedProcess'
     (or if it is not specified, in which case it defaults to 'SharedProcess'), then value of
     ServicePackageActivationId is always an empty string.
    :vartype service_package_activation_id: str
    """

    node_name: str = rest_field(name="nodeName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the node where the code package needs to be restarted. Use '*' to restart on all
     nodes where the code package is running. Required."""
    service_manifest_name: str = rest_field(
        name="serviceManifestName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the service manifest as specified in the code package. Required."""
    code_package_name: str = rest_field(
        name="codePackageName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the code package as specified in the service manifest. Required."""
    code_package_instance_id: str = rest_field(
        name="codePackageInstanceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The instance ID for currently running entry point. For a code package setup entry point (if
     specified) runs first and after it finishes main entry point is started. Each time entry point
     executable is run, its instance ID will change. If 0 is passed in as the code package instance
     ID, the API will restart the code package with whatever instance ID it is currently running. If
     an instance ID other than 0 is passed in, the API will restart the code package only if the
     current Instance ID matches the passed in instance ID. Note, passing in the exact instance ID
     (not 0) in the API is safer, because if ensures at most one restart of the code package.
     Required."""
    service_package_activation_id: Optional[str] = rest_field(
        name="servicePackageActivationId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The activation id of a deployed service package. If ServicePackageActivationMode specified at
     the time of creating the service is 'SharedProcess' (or if it is not specified, in which case
     it defaults to 'SharedProcess'), then value of ServicePackageActivationId is always an empty
     string."""

    @overload
    def __init__(
        self,
        *,
        node_name: str,
        service_manifest_name: str,
        code_package_name: str,
        code_package_instance_id: str,
        service_package_activation_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RestartReplicaRequest(_Model):
    """Request to restart a replica.

    :ivar partition_id: The ID of the partition. Required.
    :vartype partition_id: str
    :ivar replica_ids: The IDs of the replicas to be restarted. Required.
    :vartype replica_ids: list[int]
    :ivar restart_kind: The kind of restart to perform. Required. "Simultaneous"
    :vartype restart_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.RestartKind
    :ivar force_restart: If true, the restart operation will be forced. Use this option with care,
     as it may cause data loss.
    :vartype force_restart: bool
    :ivar timeout: The server timeout for performing the operation in seconds. This timeout
     specifies the time duration that the client is willing to wait for the requested operation to
     complete. The default value for this parameter is 60 seconds.
    :vartype timeout: int
    """

    partition_id: str = rest_field(name="partitionId", visibility=["read", "create", "update", "delete", "query"])
    """The ID of the partition. Required."""
    replica_ids: list[int] = rest_field(name="replicaIds", visibility=["read", "create", "update", "delete", "query"])
    """The IDs of the replicas to be restarted. Required."""
    restart_kind: Union[str, "_models.RestartKind"] = rest_field(
        name="restartKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The kind of restart to perform. Required. \"Simultaneous\""""
    force_restart: Optional[bool] = rest_field(
        name="forceRestart", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, the restart operation will be forced. Use this option with care, as it may cause data
     loss."""
    timeout: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The server timeout for performing the operation in seconds. This timeout specifies the time
     duration that the client is willing to wait for the requested operation to complete. The
     default value for this parameter is 60 seconds."""

    @overload
    def __init__(
        self,
        *,
        partition_id: str,
        replica_ids: list[int],
        restart_kind: Union[str, "_models.RestartKind"],
        force_restart: Optional[bool] = None,
        timeout: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RollingUpgradeMonitoringPolicy(_Model):
    """The policy used for monitoring the application upgrade.

    :ivar failure_action: The compensating action to perform when a Monitored upgrade encounters
     monitoring policy or health policy violations. Invalid indicates the failure action is invalid.
     Rollback specifies that the upgrade will start rolling back automatically. Manual indicates
     that the upgrade will switch to UnmonitoredManual upgrade mode. Required. Known values are:
     "Rollback" and "Manual".
    :vartype failure_action: str or ~azure.mgmt.servicefabricmanagedclusters.models.FailureAction
    :ivar health_check_wait_duration: The amount of time to wait after completing an upgrade domain
     before applying health policies. It is interpreted as a string representing an ISO 8601
     duration with following format "hh:mm:ss.fff". Required.
    :vartype health_check_wait_duration: ~datetime.timedelta
    :ivar health_check_stable_duration: The amount of time that the application or cluster must
     remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a
     string representing an ISO 8601 duration with following format "hh:mm:ss.fff". Required.
    :vartype health_check_stable_duration: ~datetime.timedelta
    :ivar health_check_retry_timeout: The amount of time to retry health evaluation when the
     application or cluster is unhealthy before FailureAction is executed. It is interpreted as a
     string representing an ISO 8601 duration with following format "hh:mm:ss.fff". Required.
    :vartype health_check_retry_timeout: ~datetime.timedelta
    :ivar upgrade_timeout: The amount of time the overall upgrade has to complete before
     FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
     representing an ISO 8601 duration with following format "hh:mm:ss.fff". Required.
    :vartype upgrade_timeout: ~datetime.timedelta
    :ivar upgrade_domain_timeout: The amount of time each upgrade domain has to complete before
     FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string
     representing an ISO 8601 duration with following format "hh:mm:ss.fff". Required.
    :vartype upgrade_domain_timeout: ~datetime.timedelta
    """

    failure_action: Union[str, "_models.FailureAction"] = rest_field(
        name="failureAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The compensating action to perform when a Monitored upgrade encounters monitoring policy or
     health policy violations. Invalid indicates the failure action is invalid. Rollback specifies
     that the upgrade will start rolling back automatically. Manual indicates that the upgrade will
     switch to UnmonitoredManual upgrade mode. Required. Known values are: \"Rollback\" and
     \"Manual\"."""
    health_check_wait_duration: datetime.timedelta = rest_field(
        name="healthCheckWaitDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time to wait after completing an upgrade domain before applying health policies.
     It is interpreted as a string representing an ISO 8601 duration with following format
     \"hh:mm:ss.fff\". Required."""
    health_check_stable_duration: datetime.timedelta = rest_field(
        name="healthCheckStableDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time that the application or cluster must remain healthy before the upgrade
     proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601
     duration with following format \"hh:mm:ss.fff\". Required."""
    health_check_retry_timeout: datetime.timedelta = rest_field(
        name="healthCheckRetryTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time to retry health evaluation when the application or cluster is unhealthy
     before FailureAction is executed. It is interpreted as a string representing an ISO 8601
     duration with following format \"hh:mm:ss.fff\". Required."""
    upgrade_timeout: datetime.timedelta = rest_field(
        name="upgradeTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot
     be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with
     following format \"hh:mm:ss.fff\". Required."""
    upgrade_domain_timeout: datetime.timedelta = rest_field(
        name="upgradeDomainTimeout", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot
     be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with
     following format \"hh:mm:ss.fff\". Required."""

    @overload
    def __init__(
        self,
        *,
        failure_action: Union[str, "_models.FailureAction"],
        health_check_wait_duration: datetime.timedelta,
        health_check_stable_duration: datetime.timedelta,
        health_check_retry_timeout: datetime.timedelta,
        upgrade_timeout: datetime.timedelta,
        upgrade_domain_timeout: datetime.timedelta,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RuntimeApplicationHealthPolicy(_Model):
    """Cluster level definition for a health policy used to evaluate the health of an application or
    one of its children entities.

    :ivar consider_warning_as_error: Indicates whether warnings are treated with the same severity
     as errors. Required.
    :vartype consider_warning_as_error: bool
    :ivar max_percent_unhealthy_deployed_applications: The maximum allowed percentage of unhealthy
     deployed applications. Allowed values are Byte values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can be
     unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number of
     nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage
     is zero. Required.
    :vartype max_percent_unhealthy_deployed_applications: int
    :ivar default_service_type_health_policy: The health policy used by default to evaluate the
     health of a service type.
    :vartype default_service_type_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeServiceTypeHealthPolicy
    :ivar service_type_health_policy_map: The map with service type health policy per service type
     name. The map is empty by default.
    :vartype service_type_health_policy_map: dict[str,
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeServiceTypeHealthPolicy]
    """

    consider_warning_as_error: bool = rest_field(
        name="considerWarningAsError", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether warnings are treated with the same severity as errors. Required."""
    max_percent_unhealthy_deployed_applications: int = rest_field(
        name="maxPercentUnhealthyDeployedApplications", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy deployed applications. Allowed values are Byte
     values from zero to 100.
     The percentage represents the maximum tolerated percentage of deployed applications that can be
     unhealthy before the application is considered in error.
     This is calculated by dividing the number of unhealthy deployed applications over the number of
     nodes where the application is currently deployed on in the cluster.
     The computation rounds up to tolerate one failure on small numbers of nodes. Default percentage
     is zero. Required."""
    default_service_type_health_policy: Optional["_models.RuntimeServiceTypeHealthPolicy"] = rest_field(
        name="defaultServiceTypeHealthPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The health policy used by default to evaluate the health of a service type."""
    service_type_health_policy_map: Optional[dict[str, "_models.RuntimeServiceTypeHealthPolicy"]] = rest_field(
        name="serviceTypeHealthPolicyMap", visibility=["read", "create", "update", "delete", "query"]
    )
    """The map with service type health policy per service type name. The map is empty by default."""

    @overload
    def __init__(
        self,
        *,
        consider_warning_as_error: bool,
        max_percent_unhealthy_deployed_applications: int,
        default_service_type_health_policy: Optional["_models.RuntimeServiceTypeHealthPolicy"] = None,
        service_type_health_policy_map: Optional[dict[str, "_models.RuntimeServiceTypeHealthPolicy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RuntimeResumeApplicationUpgradeParameters(_Model):  # pylint: disable=name-too-long
    """Parameters for Resume Upgrade action. The upgrade domain name must be specified.

    :ivar upgrade_domain_name: The upgrade domain name. Expected to be the next upgrade domain if
     the application is upgrading.
    :vartype upgrade_domain_name: str
    """

    upgrade_domain_name: Optional[str] = rest_field(
        name="upgradeDomainName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The upgrade domain name. Expected to be the next upgrade domain if the application is
     upgrading."""

    @overload
    def __init__(
        self,
        *,
        upgrade_domain_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RuntimeRollingUpgradeUpdateMonitoringPolicy(_Model):  # pylint: disable=name-too-long
    """Describes the parameters for updating a rolling upgrade of application or cluster.

    :ivar rolling_upgrade_mode: The mode used to monitor health during a rolling upgrade. Required.
     Known values are: "UnmonitoredAuto", "UnmonitoredManual", and "Monitored".
    :vartype rolling_upgrade_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeRollingUpgradeMode
    :ivar force_restart: If true, then processes are forcefully restarted during upgrade even when
     the code version has not changed (the upgrade only changes configuration or data).
    :vartype force_restart: bool
    :ivar replica_set_check_timeout_in_milliseconds: The maximum amount of time to block processing
     of an upgrade domain and prevent loss of availability when there are unexpected issues. When
     this timeout expires, processing of the upgrade domain will proceed regardless of availability
     loss issues. The timeout is reset at the start of each upgrade domain. Valid values are between
     0 and 42949672925 inclusive. (unsigned 32-bit integer).
    :vartype replica_set_check_timeout_in_milliseconds: int
    :ivar failure_action: The compensating action to perform when a Monitored upgrade encounters
     monitoring policy or health policy violations. Invalid indicates the failure action is invalid.
     Rollback specifies that the upgrade will start rolling back automatically. Manual indicates
     that the upgrade will switch to UnmonitoredManual upgrade mode. Known values are: "Rollback"
     and "Manual".
    :vartype failure_action: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeFailureAction
    :ivar health_check_wait_duration_in_milliseconds: The amount of time to wait after completing
     an upgrade domain before applying health policies. It is first interpreted as a string
     representing an ISO 8601 duration. If that fails, then it is interpreted as a number
     representing the total number of milliseconds.
    :vartype health_check_wait_duration_in_milliseconds: str
    :ivar health_check_stable_duration_in_milliseconds: The amount of time that the application or
     cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is first
     interpreted as a string representing an ISO 8601 duration. If that fails, then it is
     interpreted as a number representing the total number of milliseconds.
    :vartype health_check_stable_duration_in_milliseconds: str
    :ivar health_check_retry_timeout_in_milliseconds: The amount of time to retry health evaluation
     when the application or cluster is unhealthy before FailureAction is executed. It is first
     interpreted as a string representing an ISO 8601 duration. If that fails, then it is
     interpreted as a number representing the total number of milliseconds.
    :vartype health_check_retry_timeout_in_milliseconds: str
    :ivar upgrade_timeout_in_milliseconds: The amount of time the overall upgrade has to complete
     before FailureAction is executed. It is first interpreted as a string representing an ISO 8601
     duration. If that fails, then it is interpreted as a number representing the total number of
     milliseconds.
    :vartype upgrade_timeout_in_milliseconds: str
    :ivar upgrade_domain_timeout_in_milliseconds: The amount of time each upgrade domain has to
     complete before FailureAction is executed. It is first interpreted as a string representing an
     ISO 8601 duration. If that fails, then it is interpreted as a number representing the total
     number of milliseconds.
    :vartype upgrade_domain_timeout_in_milliseconds: str
    :ivar instance_close_delay_duration_in_seconds: Duration in seconds, to wait before a stateless
     instance is closed, to allow the active requests to drain gracefully. This would be effective
     when the instance is closing during the application/cluster upgrade, only for those instances
     which have a non-zero delay duration configured in the service description.
    :vartype instance_close_delay_duration_in_seconds: int
    """

    rolling_upgrade_mode: Union[str, "_models.RuntimeRollingUpgradeMode"] = rest_field(
        name="rollingUpgradeMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The mode used to monitor health during a rolling upgrade. Required. Known values are:
     \"UnmonitoredAuto\", \"UnmonitoredManual\", and \"Monitored\"."""
    force_restart: Optional[bool] = rest_field(
        name="forceRestart", visibility=["read", "create", "update", "delete", "query"]
    )
    """If true, then processes are forcefully restarted during upgrade even when the code version has
     not changed (the upgrade only changes configuration or data)."""
    replica_set_check_timeout_in_milliseconds: Optional[int] = rest_field(
        name="replicaSetCheckTimeoutInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum amount of time to block processing of an upgrade domain and prevent loss of
     availability when there are unexpected issues. When this timeout expires, processing of the
     upgrade domain will proceed regardless of availability loss issues. The timeout is reset at the
     start of each upgrade domain. Valid values are between 0 and 42949672925 inclusive. (unsigned
     32-bit integer)."""
    failure_action: Optional[Union[str, "_models.RuntimeFailureAction"]] = rest_field(
        name="failureAction", visibility=["read", "create", "update", "delete", "query"]
    )
    """The compensating action to perform when a Monitored upgrade encounters monitoring policy or
     health policy violations. Invalid indicates the failure action is invalid. Rollback specifies
     that the upgrade will start rolling back automatically. Manual indicates that the upgrade will
     switch to UnmonitoredManual upgrade mode. Known values are: \"Rollback\" and \"Manual\"."""
    health_check_wait_duration_in_milliseconds: Optional[str] = rest_field(
        name="healthCheckWaitDurationInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time to wait after completing an upgrade domain before applying health policies.
     It is first interpreted as a string representing an ISO 8601 duration. If that fails, then it
     is interpreted as a number representing the total number of milliseconds."""
    health_check_stable_duration_in_milliseconds: Optional[str] = rest_field(
        name="healthCheckStableDurationInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time that the application or cluster must remain healthy before the upgrade
     proceeds to the next upgrade domain. It is first interpreted as a string representing an ISO
     8601 duration. If that fails, then it is interpreted as a number representing the total number
     of milliseconds."""
    health_check_retry_timeout_in_milliseconds: Optional[str] = rest_field(
        name="healthCheckRetryTimeoutInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time to retry health evaluation when the application or cluster is unhealthy
     before FailureAction is executed. It is first interpreted as a string representing an ISO 8601
     duration. If that fails, then it is interpreted as a number representing the total number of
     milliseconds."""
    upgrade_timeout_in_milliseconds: Optional[str] = rest_field(
        name="upgradeTimeoutInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time the overall upgrade has to complete before FailureAction is executed. It is
     first interpreted as a string representing an ISO 8601 duration. If that fails, then it is
     interpreted as a number representing the total number of milliseconds."""
    upgrade_domain_timeout_in_milliseconds: Optional[str] = rest_field(
        name="upgradeDomainTimeoutInMilliseconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """The amount of time each upgrade domain has to complete before FailureAction is executed. It is
     first interpreted as a string representing an ISO 8601 duration. If that fails, then it is
     interpreted as a number representing the total number of milliseconds."""
    instance_close_delay_duration_in_seconds: Optional[int] = rest_field(
        name="instanceCloseDelayDurationInSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Duration in seconds, to wait before a stateless instance is closed, to allow the active
     requests to drain gracefully. This would be effective when the instance is closing during the
     application/cluster upgrade, only for those instances which have a non-zero delay duration
     configured in the service description."""

    @overload
    def __init__(
        self,
        *,
        rolling_upgrade_mode: Union[str, "_models.RuntimeRollingUpgradeMode"],
        force_restart: Optional[bool] = None,
        replica_set_check_timeout_in_milliseconds: Optional[int] = None,
        failure_action: Optional[Union[str, "_models.RuntimeFailureAction"]] = None,
        health_check_wait_duration_in_milliseconds: Optional[str] = None,
        health_check_stable_duration_in_milliseconds: Optional[str] = None,
        health_check_retry_timeout_in_milliseconds: Optional[str] = None,
        upgrade_timeout_in_milliseconds: Optional[str] = None,
        upgrade_domain_timeout_in_milliseconds: Optional[str] = None,
        instance_close_delay_duration_in_seconds: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RuntimeServiceTypeHealthPolicy(_Model):
    """Cluster level definition that represents the health policy used to evaluate the health of
    services belonging to a service type.

    :ivar max_percent_unhealthy_services: The maximum allowed percentage of unhealthy services.

     The percentage represents the maximum tolerated percentage of services that can be unhealthy
     before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy service, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the specific service type
     over the total number of services of the specific service type.
     The computation rounds up to tolerate one failure on small numbers of services. Required.
    :vartype max_percent_unhealthy_services: int
    :ivar max_percent_unhealthy_partitions_per_service: The maximum allowed percentage of unhealthy
     partitions per service.

     The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
     before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy partition, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy partitions over the total
     number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of partitions. Required.
    :vartype max_percent_unhealthy_partitions_per_service: int
    :ivar max_percent_unhealthy_replicas_per_partition: The maximum allowed percentage of unhealthy
     replicas per partition.

     The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
     before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy replica, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas over the total number
     of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of replicas. Required.
    :vartype max_percent_unhealthy_replicas_per_partition: int
    """

    max_percent_unhealthy_services: int = rest_field(
        name="maxPercentUnhealthyServices", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy services.
     
     The percentage represents the maximum tolerated percentage of services that can be unhealthy
     before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy service, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the specific service type
     over the total number of services of the specific service type.
     The computation rounds up to tolerate one failure on small numbers of services. Required."""
    max_percent_unhealthy_partitions_per_service: int = rest_field(
        name="maxPercentUnhealthyPartitionsPerService", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy partitions per service.
     
     The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
     before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy partition, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy partitions over the total
     number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of partitions. Required."""
    max_percent_unhealthy_replicas_per_partition: int = rest_field(
        name="maxPercentUnhealthyReplicasPerPartition", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy replicas per partition.
     
     The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
     before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy replica, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas over the total number
     of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of replicas. Required."""

    @overload
    def __init__(
        self,
        *,
        max_percent_unhealthy_services: int,
        max_percent_unhealthy_partitions_per_service: int,
        max_percent_unhealthy_replicas_per_partition: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RuntimeUpdateApplicationUpgradeParameters(_Model):  # pylint: disable=name-too-long
    """Parameters for the Update Upgrade action.

    :ivar name: The name of the application, including the 'fabric:' URI scheme. Required.
    :vartype name: str
    :ivar upgrade_kind: The kind of the upgrade. Required. "Rolling"
    :vartype upgrade_kind: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeUpgradeKind
    :ivar application_health_policy: Defines a health policy used to evaluate the health of an
     application or one of its children entities.
    :vartype application_health_policy:
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeApplicationHealthPolicy
    :ivar update_description: Describes the parameters for updating a rolling upgrade of
     application or cluster and a monitoring policy.
    :vartype update_description:
     ~azure.mgmt.servicefabricmanagedclusters.models.RuntimeRollingUpgradeUpdateMonitoringPolicy
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the application, including the 'fabric:' URI scheme. Required."""
    upgrade_kind: Union[str, "_models.RuntimeUpgradeKind"] = rest_field(
        name="upgradeKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The kind of the upgrade. Required. \"Rolling\""""
    application_health_policy: Optional["_models.RuntimeApplicationHealthPolicy"] = rest_field(
        name="applicationHealthPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Defines a health policy used to evaluate the health of an application or one of its children
     entities."""
    update_description: Optional["_models.RuntimeRollingUpgradeUpdateMonitoringPolicy"] = rest_field(
        name="updateDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the parameters for updating a rolling upgrade of application or cluster and a
     monitoring policy."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        upgrade_kind: Union[str, "_models.RuntimeUpgradeKind"],
        application_health_policy: Optional["_models.RuntimeApplicationHealthPolicy"] = None,
        update_description: Optional["_models.RuntimeRollingUpgradeUpdateMonitoringPolicy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScalingPolicy(_Model):
    """Specifies a metric to load balance a service during runtime.

    :ivar scaling_mechanism: Specifies the mechanism associated with this scaling policy. Required.
    :vartype scaling_mechanism: ~azure.mgmt.servicefabricmanagedclusters.models.ScalingMechanism
    :ivar scaling_trigger: Specifies the trigger associated with this scaling policy. Required.
    :vartype scaling_trigger: ~azure.mgmt.servicefabricmanagedclusters.models.ScalingTrigger
    """

    scaling_mechanism: "_models.ScalingMechanism" = rest_field(
        name="scalingMechanism", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the mechanism associated with this scaling policy. Required."""
    scaling_trigger: "_models.ScalingTrigger" = rest_field(
        name="scalingTrigger", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the trigger associated with this scaling policy. Required."""

    @overload
    def __init__(
        self,
        *,
        scaling_mechanism: "_models.ScalingMechanism",
        scaling_trigger: "_models.ScalingTrigger",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceCorrelation(_Model):
    """Creates a particular correlation between services.

    :ivar scheme: The ServiceCorrelationScheme which describes the relationship between this
     service and the service specified via ServiceName. Required. Known values are:
     "AlignedAffinity" and "NonAlignedAffinity".
    :vartype scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelationScheme
    :ivar service_name: The Arm Resource ID of the service that the correlation relationship is
     established with. Required.
    :vartype service_name: str
    """

    scheme: Union[str, "_models.ServiceCorrelationScheme"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The ServiceCorrelationScheme which describes the relationship between this service and the
     service specified via ServiceName. Required. Known values are: \"AlignedAffinity\" and
     \"NonAlignedAffinity\"."""
    service_name: str = rest_field(name="serviceName", visibility=["read", "create", "update", "delete", "query"])
    """The Arm Resource ID of the service that the correlation relationship is established with.
     Required."""

    @overload
    def __init__(
        self,
        *,
        scheme: Union[str, "_models.ServiceCorrelationScheme"],
        service_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceEndpoint(_Model):
    """The service endpoint properties.

    :ivar service: The type of the endpoint service. Required.
    :vartype service: str
    :ivar locations: A list of locations.
    :vartype locations: list[str]
    :ivar network_identifier: Specifies the resource id of the service endpoint to be used in the
     cluster.
    :vartype network_identifier: str
    """

    service: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the endpoint service. Required."""
    locations: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A list of locations."""
    network_identifier: Optional[str] = rest_field(
        name="networkIdentifier", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the resource id of the service endpoint to be used in the cluster."""

    @overload
    def __init__(
        self,
        *,
        service: str,
        locations: Optional[list[str]] = None,
        network_identifier: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceLoadMetric(_Model):
    """Specifies a metric to load balance a service during runtime.

    :ivar name: The name of the metric. If the service chooses to report load during runtime, the
     load metric name should match the name that is specified in Name exactly. Note that metric
     names are case sensitive. Required.
    :vartype name: str
    :ivar weight: The service load metric relative weight, compared to other metrics configured for
     this service, as a number. Known values are: "Zero", "Low", "Medium", and "High".
    :vartype weight: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetricWeight
    :ivar primary_default_load: Used only for Stateful services. The default amount of load, as a
     number, that this service creates for this metric when it is a Primary replica.
    :vartype primary_default_load: int
    :ivar secondary_default_load: Used only for Stateful services. The default amount of load, as a
     number, that this service creates for this metric when it is a Secondary replica.
    :vartype secondary_default_load: int
    :ivar default_load: Used only for Stateless services. The default amount of load, as a number,
     that this service creates for this metric.
    :vartype default_load: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the metric. If the service chooses to report load during runtime, the load metric
     name should match the name that is specified in Name exactly. Note that metric names are case
     sensitive. Required."""
    weight: Optional[Union[str, "_models.ServiceLoadMetricWeight"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The service load metric relative weight, compared to other metrics configured for this service,
     as a number. Known values are: \"Zero\", \"Low\", \"Medium\", and \"High\"."""
    primary_default_load: Optional[int] = rest_field(
        name="primaryDefaultLoad", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used only for Stateful services. The default amount of load, as a number, that this service
     creates for this metric when it is a Primary replica."""
    secondary_default_load: Optional[int] = rest_field(
        name="secondaryDefaultLoad", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used only for Stateful services. The default amount of load, as a number, that this service
     creates for this metric when it is a Secondary replica."""
    default_load: Optional[int] = rest_field(
        name="defaultLoad", visibility=["read", "create", "update", "delete", "query"]
    )
    """Used only for Stateless services. The default amount of load, as a number, that this service
     creates for this metric."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        weight: Optional[Union[str, "_models.ServiceLoadMetricWeight"]] = None,
        primary_default_load: Optional[int] = None,
        secondary_default_load: Optional[int] = None,
        default_load: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServicePlacementPolicy(_Model):
    """Describes the policy to be used for placement of a Service Fabric service.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ServicePlacementInvalidDomainPolicy, ServicePlacementNonPartiallyPlaceServicePolicy,
    ServicePlacementPreferPrimaryDomainPolicy, ServicePlacementRequiredDomainPolicy,
    ServicePlacementRequireDomainDistributionPolicy

    :ivar type: Required. Known values are: "InvalidDomain", "RequiredDomain",
     "PreferredPrimaryDomain", "RequiredDomainDistribution", and "NonPartiallyPlaceService".
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicyType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"InvalidDomain\", \"RequiredDomain\", \"PreferredPrimaryDomain\",
     \"RequiredDomainDistribution\", and \"NonPartiallyPlaceService\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServicePlacementInvalidDomainPolicy(ServicePlacementPolicy, discriminator="InvalidDomain"):
    """Describes the policy to be used for placement of a Service Fabric service where a particular
    fault or upgrade domain should not be used for placement of the instances or replicas of that
    service.

    :ivar domain_name: The name of the domain that should not be used for placement. Required.
    :vartype domain_name: str
    :ivar type: The type of placement policy for a service fabric service. Following are the
     possible values. Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or
     upgrade domain cannot be used for placement of this service. The value is 0.
    :vartype type: str or ~azure.mgmt.servicefabricmanagedclusters.models.INVALID_DOMAIN
    """

    domain_name: str = rest_field(name="domainName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the domain that should not be used for placement. Required."""
    type: Literal[ServicePlacementPolicyType.INVALID_DOMAIN] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of placement policy for a service fabric service. Following are the possible values.
     Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementInvalidDomainPolicyDescription, which indicates that a particular fault or
     upgrade domain cannot be used for placement of this service. The value is 0."""

    @overload
    def __init__(
        self,
        *,
        domain_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServicePlacementPolicyType.INVALID_DOMAIN  # type: ignore


class ServicePlacementNonPartiallyPlaceServicePolicy(
    ServicePlacementPolicy, discriminator="NonPartiallyPlaceService"
):  # pylint: disable=name-too-long
    """The type of placement policy for a service fabric service. Following are the possible values.

    :ivar type: Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible all
     replicas of a particular partition of the service should be placed atomically. The value is 4.
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.NON_PARTIALLY_PLACE_SERVICE
    """

    type: Literal[ServicePlacementPolicyType.NON_PARTIALLY_PLACE_SERVICE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementNonPartiallyPlaceServicePolicyDescription, which indicates that if possible all
     replicas of a particular partition of the service should be placed atomically. The value is 4."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServicePlacementPolicyType.NON_PARTIALLY_PLACE_SERVICE  # type: ignore


class ServicePlacementPreferPrimaryDomainPolicy(
    ServicePlacementPolicy, discriminator="PreferredPrimaryDomain"
):  # pylint: disable=name-too-long
    """Describes the policy to be used for placement of a Service Fabric service where the service's
    Primary replicas should optimally be placed in a particular domain.

    This placement policy is usually used with fault domains in scenarios where the Service Fabric
    cluster is geographically distributed in order to indicate that a service's primary replica
    should
    be located in a particular fault domain, which in geo-distributed scenarios usually aligns with
    regional
    or datacenter boundaries. Note that since this is an optimization it is possible that the
    Primary replica
    may not end up located in this domain due to failures, capacity limits, or other constraints.

    :ivar domain_name: The name of the domain that should used for placement as per this policy.
     Required.
    :vartype domain_name: str
    :ivar type: The type of placement policy for a service fabric service. Following are the
     possible values. Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
     Primary replica for the partitions of the service should be located in a particular domain as
     an optimization. The value is 2.
    :vartype type: str or ~azure.mgmt.servicefabricmanagedclusters.models.PREFERRED_PRIMARY_DOMAIN
    """

    domain_name: str = rest_field(name="domainName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the domain that should used for placement as per this policy. Required."""
    type: Literal[ServicePlacementPolicyType.PREFERRED_PRIMARY_DOMAIN] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of placement policy for a service fabric service. Following are the possible values.
     Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementPreferPrimaryDomainPolicyDescription, which indicates that if possible the
     Primary replica for the partitions of the service should be located in a particular domain as
     an optimization. The value is 2."""

    @overload
    def __init__(
        self,
        *,
        domain_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServicePlacementPolicyType.PREFERRED_PRIMARY_DOMAIN  # type: ignore


class ServicePlacementRequiredDomainPolicy(ServicePlacementPolicy, discriminator="RequiredDomain"):
    """Describes the policy to be used for placement of a Service Fabric service where the instances
    or replicas of that service must be placed in a particular domain.

    :ivar domain_name: The name of the domain that should used for placement as per this policy.
     Required.
    :vartype domain_name: str
    :ivar type: The type of placement policy for a service fabric service. Following are the
     possible values. Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the
     service must be placed in a specific domain. The value is 1.
    :vartype type: str or ~azure.mgmt.servicefabricmanagedclusters.models.REQUIRED_DOMAIN
    """

    domain_name: str = rest_field(name="domainName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the domain that should used for placement as per this policy. Required."""
    type: Literal[ServicePlacementPolicyType.REQUIRED_DOMAIN] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of placement policy for a service fabric service. Following are the possible values.
     Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementRequireDomainDistributionPolicyDescription indicating that the replicas of the
     service must be placed in a specific domain. The value is 1."""

    @overload
    def __init__(
        self,
        *,
        domain_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServicePlacementPolicyType.REQUIRED_DOMAIN  # type: ignore


class ServicePlacementRequireDomainDistributionPolicy(
    ServicePlacementPolicy, discriminator="RequiredDomainDistribution"
):  # pylint: disable=name-too-long
    """Describes the policy to be used for placement of a Service Fabric service where two replicas
    from the same partition should never be placed in the same fault or upgrade domain.

    While this is not common it can expose the service to an increased risk of concurrent failures
    due to unplanned outages or other cases of subsequent/concurrent failures. As an example,
    consider
    a case where replicas are deployed across different data center, with one replica per location.
    In the event that one of the datacenters goes offline, normally the replica that was placed in
    that
    datacenter will be packed into one of the remaining datacenters. If this is not desirable then
    this
    policy should be set.

    :ivar domain_name: The name of the domain that should used for placement as per this policy.
     Required.
    :vartype domain_name: str
    :ivar type: The type of placement policy for a service fabric service. Following are the
     possible values. Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementRequireDomainDistributionPolicyDescription, indicating that the system will
     disallow placement of any two replicas from the same partition in the same domain at any time.
     The value is 3.
    :vartype type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.REQUIRED_DOMAIN_DISTRIBUTION
    """

    domain_name: str = rest_field(name="domainName", visibility=["read", "create", "update", "delete", "query"])
    """The name of the domain that should used for placement as per this policy. Required."""
    type: Literal[ServicePlacementPolicyType.REQUIRED_DOMAIN_DISTRIBUTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of placement policy for a service fabric service. Following are the possible values.
     Required. Indicates that the ServicePlacementPolicyDescription is of type
     ServicePlacementRequireDomainDistributionPolicyDescription, indicating that the system will
     disallow placement of any two replicas from the same partition in the same domain at any time.
     The value is 3."""

    @overload
    def __init__(
        self,
        *,
        domain_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ServicePlacementPolicyType.REQUIRED_DOMAIN_DISTRIBUTION  # type: ignore


class ServiceResource(ProxyResource):
    """The service resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.servicefabricmanagedclusters.models.SystemData
    :ivar properties: The service resource properties.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.ServiceResourceProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives.
    :vartype location: str
    """

    properties: Optional["_models.ServiceResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The service resource properties."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: Optional[str] = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.ServiceResourceProperties"] = None,
        tags: Optional[dict[str, str]] = None,
        location: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceResourcePropertiesBase(_Model):
    """The common service resource properties.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Known values are: "Zero",
     "Low", "Medium", and "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    """

    placement_constraints: Optional[str] = rest_field(
        name="placementConstraints", visibility=["read", "create", "update", "delete", "query"]
    )
    """The placement constraints as a string. Placement constraints are boolean expressions on node
     properties and allow for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is blue specify the
     following: \"NodeColor == blue)\"."""
    correlation_scheme: Optional[list["_models.ServiceCorrelation"]] = rest_field(
        name="correlationScheme", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list that describes the correlation of the service with other services."""
    service_load_metrics: Optional[list["_models.ServiceLoadMetric"]] = rest_field(
        name="serviceLoadMetrics", visibility=["read", "create", "update", "delete", "query"]
    )
    """The service load metrics is given as an array of ServiceLoadMetric objects."""
    service_placement_policies: Optional[list["_models.ServicePlacementPolicy"]] = rest_field(
        name="servicePlacementPolicies", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list that describes the correlation of the service with other services."""
    default_move_cost: Optional[Union[str, "_models.MoveCost"]] = rest_field(
        name="defaultMoveCost", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the move cost for the service. Known values are: \"Zero\", \"Low\", \"Medium\", and
     \"High\"."""
    scaling_policies: Optional[list["_models.ScalingPolicy"]] = rest_field(
        name="scalingPolicies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Scaling policies for this service."""

    @overload
    def __init__(
        self,
        *,
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[list["_models.ServiceCorrelation"]] = None,
        service_load_metrics: Optional[list["_models.ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[list["_models.ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "_models.MoveCost"]] = None,
        scaling_policies: Optional[list["_models.ScalingPolicy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceResourceProperties(ServiceResourcePropertiesBase):
    """The service resource properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    StatefulServiceProperties, StatelessServiceProperties

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Known values are: "Zero",
     "Low", "Medium", and "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar service_kind: The kind of service (Stateless or Stateful). Required. Known values are:
     "Stateless" and "Stateful".
    :vartype service_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ServiceKind
    :ivar service_type_name: The name of the service type. Required.
    :vartype service_type_name: str
    :ivar partition_description: Describes how the service is partitioned. Required.
    :vartype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
    :ivar service_package_activation_mode: The activation Mode of the service package. Known values
     are: "SharedProcess" and "ExclusiveProcess".
    :vartype service_package_activation_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
    :ivar service_dns_name: Dns name used for the service. If this is specified, then the DNS name
     can be used to return the IP addresses of service endpoints for application layer protocols
     (e.g., HTTP).
     When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new
     name.
     When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the
     name being unresolvable.
    :vartype service_dns_name: str
    """

    __mapping__: dict[str, _Model] = {}
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The current deployment or provisioning state, which only appears in the response."""
    service_kind: str = rest_discriminator(
        name="serviceKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The kind of service (Stateless or Stateful). Required. Known values are: \"Stateless\" and
     \"Stateful\"."""
    service_type_name: str = rest_field(
        name="serviceTypeName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The name of the service type. Required."""
    partition_description: "_models.Partition" = rest_field(
        name="partitionDescription", visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes how the service is partitioned. Required."""
    service_package_activation_mode: Optional[Union[str, "_models.ServicePackageActivationMode"]] = rest_field(
        name="servicePackageActivationMode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The activation Mode of the service package. Known values are: \"SharedProcess\" and
     \"ExclusiveProcess\"."""
    service_dns_name: Optional[str] = rest_field(
        name="serviceDnsName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Dns name used for the service. If this is specified, then the DNS name can be used to return
     the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
     When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new
     name.
     When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the
     name being unresolvable."""

    @overload
    def __init__(
        self,
        *,
        service_kind: str,
        service_type_name: str,
        partition_description: "_models.Partition",
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[list["_models.ServiceCorrelation"]] = None,
        service_load_metrics: Optional[list["_models.ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[list["_models.ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "_models.MoveCost"]] = None,
        scaling_policies: Optional[list["_models.ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "_models.ServicePackageActivationMode"]] = None,
        service_dns_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceTypeHealthPolicy(_Model):
    """Represents the health policy used to evaluate the health of services belonging to a service
    type.

    :ivar max_percent_unhealthy_services: The maximum allowed percentage of unhealthy services.

     The percentage represents the maximum tolerated percentage of services that can be unhealthy
     before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy service, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the specific service type
     over the total number of services of the specific service type.
     The computation rounds up to tolerate one failure on small numbers of services. Required.
    :vartype max_percent_unhealthy_services: int
    :ivar max_percent_unhealthy_partitions_per_service: The maximum allowed percentage of unhealthy
     partitions per service.

     The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
     before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy partition, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy partitions over the total
     number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of partitions. Required.
    :vartype max_percent_unhealthy_partitions_per_service: int
    :ivar max_percent_unhealthy_replicas_per_partition: The maximum allowed percentage of unhealthy
     replicas per partition.

     The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
     before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy replica, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas over the total number
     of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of replicas. Required.
    :vartype max_percent_unhealthy_replicas_per_partition: int
    """

    max_percent_unhealthy_services: int = rest_field(
        name="maxPercentUnhealthyServices", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy services.
     
     The percentage represents the maximum tolerated percentage of services that can be unhealthy
     before the application is considered in error.
     If the percentage is respected but there is at least one unhealthy service, the health is
     evaluated as Warning.
     This is calculated by dividing the number of unhealthy services of the specific service type
     over the total number of services of the specific service type.
     The computation rounds up to tolerate one failure on small numbers of services. Required."""
    max_percent_unhealthy_partitions_per_service: int = rest_field(
        name="maxPercentUnhealthyPartitionsPerService", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy partitions per service.
     
     The percentage represents the maximum tolerated percentage of partitions that can be unhealthy
     before the service is considered in error.
     If the percentage is respected but there is at least one unhealthy partition, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy partitions over the total
     number of partitions in the service.
     The computation rounds up to tolerate one failure on small numbers of partitions. Required."""
    max_percent_unhealthy_replicas_per_partition: int = rest_field(
        name="maxPercentUnhealthyReplicasPerPartition", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum allowed percentage of unhealthy replicas per partition.
     
     The percentage represents the maximum tolerated percentage of replicas that can be unhealthy
     before the partition is considered in error.
     If the percentage is respected but there is at least one unhealthy replica, the health is
     evaluated as Warning.
     The percentage is calculated by dividing the number of unhealthy replicas over the total number
     of replicas in the partition.
     The computation rounds up to tolerate one failure on small numbers of replicas. Required."""

    @overload
    def __init__(
        self,
        *,
        max_percent_unhealthy_services: int,
        max_percent_unhealthy_partitions_per_service: int,
        max_percent_unhealthy_replicas_per_partition: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServiceUpdateParameters(_Model):
    """Service update request.

    :ivar tags: Service update parameters.
    :vartype tags: dict[str, str]
    """

    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Service update parameters."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SettingsParameterDescription(_Model):
    """Describes a parameter in fabric settings of the cluster.

    :ivar name: The parameter name of fabric setting. Required.
    :vartype name: str
    :ivar value: The parameter value of fabric setting. Required.
    :vartype value: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The parameter name of fabric setting. Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The parameter value of fabric setting. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SettingsSectionDescription(_Model):
    """Describes a section in the fabric settings of the cluster.

    :ivar name: The section name of the fabric settings. Required.
    :vartype name: str
    :ivar parameters: The collection of parameters in the section. Required.
    :vartype parameters:
     list[~azure.mgmt.servicefabricmanagedclusters.models.SettingsParameterDescription]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The section name of the fabric settings. Required."""
    parameters: list["_models.SettingsParameterDescription"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The collection of parameters in the section. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: list["_models.SettingsParameterDescription"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SingletonPartitionScheme(Partition, discriminator="Singleton"):
    """Describes the partition scheme of a singleton-partitioned, or non-partitioned service.

    :ivar partition_scheme: Specifies how the service is partitioned. Required. Indicates that the
     partition is based on string names, and is a SingletonPartitionScheme object, The value is 0.
    :vartype partition_scheme: str or ~azure.mgmt.servicefabricmanagedclusters.models.SINGLETON
    """

    partition_scheme: Literal[PartitionScheme.SINGLETON] = rest_discriminator(name="partitionScheme", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies how the service is partitioned. Required. Indicates that the partition is based on
     string names, and is a SingletonPartitionScheme object, The value is 0."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.partition_scheme = PartitionScheme.SINGLETON  # type: ignore


class Sku(_Model):
    """Service Fabric managed cluster Sku definition.

    :ivar name: Sku Name. Required. Known values are: "Basic" and "Standard".
    :vartype name: str or ~azure.mgmt.servicefabricmanagedclusters.models.SkuName
    """

    name: Union[str, "_models.SkuName"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku Name. Required. Known values are: \"Basic\" and \"Standard\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StatefulServiceProperties(ServiceResourceProperties, discriminator="Stateful"):
    """The properties of a stateful service resource.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Known values are: "Zero",
     "Low", "Medium", and "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar service_type_name: The name of the service type. Required.
    :vartype service_type_name: str
    :ivar partition_description: Describes how the service is partitioned. Required.
    :vartype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
    :ivar service_package_activation_mode: The activation Mode of the service package. Known values
     are: "SharedProcess" and "ExclusiveProcess".
    :vartype service_package_activation_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
    :ivar service_dns_name: Dns name used for the service. If this is specified, then the DNS name
     can be used to return the IP addresses of service endpoints for application layer protocols
     (e.g., HTTP).
     When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new
     name.
     When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the
     name being unresolvable.
    :vartype service_dns_name: str
    :ivar has_persisted_state: A flag indicating whether this is a persistent service which stores
     states on the local disk. If it is then the value of this property is true, if not it is false.
    :vartype has_persisted_state: bool
    :ivar target_replica_set_size: The target replica set size as a number.
    :vartype target_replica_set_size: int
    :ivar min_replica_set_size: The minimum replica set size as a number.
    :vartype min_replica_set_size: int
    :ivar replica_restart_wait_duration: The duration between when a replica goes down and when a
     new replica is created, represented in ISO 8601 format "hh:mm:ss".
    :vartype replica_restart_wait_duration: ~datetime.timedelta
    :ivar quorum_loss_wait_duration: The maximum duration for which a partition is allowed to be in
     a state of quorum loss, represented in ISO 8601 format "hh:mm:ss".
    :vartype quorum_loss_wait_duration: ~datetime.timedelta
    :ivar stand_by_replica_keep_duration: The definition on how long StandBy replicas should be
     maintained before being removed, represented in ISO 8601 format "hh:mm:ss".
    :vartype stand_by_replica_keep_duration: ~datetime.timedelta
    :ivar service_placement_time_limit: The duration for which replicas can stay InBuild before
     reporting that build is stuck, represented in ISO 8601 format "hh:mm:ss".
    :vartype service_placement_time_limit: ~datetime.timedelta
    :ivar service_kind: The kind of service (Stateless or Stateful). Required. Uses Service Fabric
     to make its state or part of its state highly available and reliable. The value is 1.
    :vartype service_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.STATEFUL
    """

    has_persisted_state: Optional[bool] = rest_field(
        name="hasPersistedState", visibility=["read", "create", "update", "delete", "query"]
    )
    """A flag indicating whether this is a persistent service which stores states on the local disk.
     If it is then the value of this property is true, if not it is false."""
    target_replica_set_size: Optional[int] = rest_field(
        name="targetReplicaSetSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The target replica set size as a number."""
    min_replica_set_size: Optional[int] = rest_field(
        name="minReplicaSetSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """The minimum replica set size as a number."""
    replica_restart_wait_duration: Optional[datetime.timedelta] = rest_field(
        name="replicaRestartWaitDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The duration between when a replica goes down and when a new replica is created, represented in
     ISO 8601 format \"hh:mm:ss\"."""
    quorum_loss_wait_duration: Optional[datetime.timedelta] = rest_field(
        name="quorumLossWaitDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The maximum duration for which a partition is allowed to be in a state of quorum loss,
     represented in ISO 8601 format \"hh:mm:ss\"."""
    stand_by_replica_keep_duration: Optional[datetime.timedelta] = rest_field(
        name="standByReplicaKeepDuration", visibility=["read", "create", "update", "delete", "query"]
    )
    """The definition on how long StandBy replicas should be maintained before being removed,
     represented in ISO 8601 format \"hh:mm:ss\"."""
    service_placement_time_limit: Optional[datetime.timedelta] = rest_field(
        name="servicePlacementTimeLimit", visibility=["read", "create", "update", "delete", "query"]
    )
    """The duration for which replicas can stay InBuild before reporting that build is stuck,
     represented in ISO 8601 format \"hh:mm:ss\"."""
    service_kind: Literal[ServiceKind.STATEFUL] = rest_discriminator(name="serviceKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of service (Stateless or Stateful). Required. Uses Service Fabric to make its state or
     part of its state highly available and reliable. The value is 1."""

    @overload
    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "_models.Partition",
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[list["_models.ServiceCorrelation"]] = None,
        service_load_metrics: Optional[list["_models.ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[list["_models.ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "_models.MoveCost"]] = None,
        scaling_policies: Optional[list["_models.ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "_models.ServicePackageActivationMode"]] = None,
        service_dns_name: Optional[str] = None,
        has_persisted_state: Optional[bool] = None,
        target_replica_set_size: Optional[int] = None,
        min_replica_set_size: Optional[int] = None,
        replica_restart_wait_duration: Optional[datetime.timedelta] = None,
        quorum_loss_wait_duration: Optional[datetime.timedelta] = None,
        stand_by_replica_keep_duration: Optional[datetime.timedelta] = None,
        service_placement_time_limit: Optional[datetime.timedelta] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.service_kind = ServiceKind.STATEFUL  # type: ignore


class StatelessServiceProperties(ServiceResourceProperties, discriminator="Stateless"):
    """The properties of a stateless service resource.

    :ivar placement_constraints: The placement constraints as a string. Placement constraints are
     boolean expressions on node properties and allow for restricting a service to particular nodes
     based on the service requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :vartype placement_constraints: str
    :ivar correlation_scheme: A list that describes the correlation of the service with other
     services.
    :vartype correlation_scheme:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceCorrelation]
    :ivar service_load_metrics: The service load metrics is given as an array of ServiceLoadMetric
     objects.
    :vartype service_load_metrics:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServiceLoadMetric]
    :ivar service_placement_policies: A list that describes the correlation of the service with
     other services.
    :vartype service_placement_policies:
     list[~azure.mgmt.servicefabricmanagedclusters.models.ServicePlacementPolicy]
    :ivar default_move_cost: Specifies the move cost for the service. Known values are: "Zero",
     "Low", "Medium", and "High".
    :vartype default_move_cost: str or ~azure.mgmt.servicefabricmanagedclusters.models.MoveCost
    :ivar scaling_policies: Scaling policies for this service.
    :vartype scaling_policies: list[~azure.mgmt.servicefabricmanagedclusters.models.ScalingPolicy]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar service_type_name: The name of the service type. Required.
    :vartype service_type_name: str
    :ivar partition_description: Describes how the service is partitioned. Required.
    :vartype partition_description: ~azure.mgmt.servicefabricmanagedclusters.models.Partition
    :ivar service_package_activation_mode: The activation Mode of the service package. Known values
     are: "SharedProcess" and "ExclusiveProcess".
    :vartype service_package_activation_mode: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.ServicePackageActivationMode
    :ivar service_dns_name: Dns name used for the service. If this is specified, then the DNS name
     can be used to return the IP addresses of service endpoints for application layer protocols
     (e.g., HTTP).
     When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new
     name.
     When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the
     name being unresolvable.
    :vartype service_dns_name: str
    :ivar instance_count: The instance count. Required.
    :vartype instance_count: int
    :ivar min_instance_count: MinInstanceCount is the minimum number of instances that must be up
     to meet the EnsureAvailability safety check during operations like upgrade or deactivate node.
     The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 *
     InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1
     is first converted into the number of nodes on which the instances are allowed to be placed
     according to the placement constraints on the service.
    :vartype min_instance_count: int
    :ivar min_instance_percentage: MinInstancePercentage is the minimum percentage of InstanceCount
     that must be up to meet the EnsureAvailability safety check during operations like upgrade or
     deactivate node. The actual number that is used is max( MinInstanceCount, ceil(
     MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during
     MinInstancePercentage computation, -1 is first converted into the number of nodes on which the
     instances are allowed to be placed according to the placement constraints on the service.
    :vartype min_instance_percentage: int
    :ivar service_kind: The kind of service (Stateless or Stateful). Required. Does not use Service
     Fabric to make its state highly available or reliable. The value is 0.
    :vartype service_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.STATELESS
    """

    instance_count: int = rest_field(name="instanceCount", visibility=["read", "create", "update", "delete", "query"])
    """The instance count. Required."""
    min_instance_count: Optional[int] = rest_field(
        name="minInstanceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """MinInstanceCount is the minimum number of instances that must be up to meet the
     EnsureAvailability safety check during operations like upgrade or deactivate node. The actual
     number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 *
     InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1
     is first converted into the number of nodes on which the instances are allowed to be placed
     according to the placement constraints on the service."""
    min_instance_percentage: Optional[int] = rest_field(
        name="minInstancePercentage", visibility=["read", "create", "update", "delete", "query"]
    )
    """MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the
     EnsureAvailability safety check during operations like upgrade or deactivate node. The actual
     number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 *
     InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage
     computation, -1 is first converted into the number of nodes on which the instances are allowed
     to be placed according to the placement constraints on the service."""
    service_kind: Literal[ServiceKind.STATELESS] = rest_discriminator(name="serviceKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of service (Stateless or Stateful). Required. Does not use Service Fabric to make its
     state highly available or reliable. The value is 0."""

    @overload
    def __init__(
        self,
        *,
        service_type_name: str,
        partition_description: "_models.Partition",
        instance_count: int,
        placement_constraints: Optional[str] = None,
        correlation_scheme: Optional[list["_models.ServiceCorrelation"]] = None,
        service_load_metrics: Optional[list["_models.ServiceLoadMetric"]] = None,
        service_placement_policies: Optional[list["_models.ServicePlacementPolicy"]] = None,
        default_move_cost: Optional[Union[str, "_models.MoveCost"]] = None,
        scaling_policies: Optional[list["_models.ScalingPolicy"]] = None,
        service_package_activation_mode: Optional[Union[str, "_models.ServicePackageActivationMode"]] = None,
        service_dns_name: Optional[str] = None,
        min_instance_count: Optional[int] = None,
        min_instance_percentage: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.service_kind = ServiceKind.STATELESS  # type: ignore


class Subnet(_Model):
    """Describes a Subnet.

    :ivar name: Subnet name. Required.
    :vartype name: str
    :ivar enable_ipv6: Indicates wether to enable Ipv6 or not. If not provided, it will take the
     same configuration as the cluster.
    :vartype enable_ipv6: bool
    :ivar private_endpoint_network_policies: Enable or Disable apply network policies on private
     end point in the subnet. Known values are: "enabled" and "disabled".
    :vartype private_endpoint_network_policies: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PrivateEndpointNetworkPolicies
    :ivar private_link_service_network_policies: Enable or Disable apply network policies on
     private link service in the subnet. Known values are: "enabled" and "disabled".
    :vartype private_link_service_network_policies: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.PrivateLinkServiceNetworkPolicies
    :ivar network_security_group_id: Full resource id for the network security group.
    :vartype network_security_group_id: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Subnet name. Required."""
    enable_ipv6: Optional[bool] = rest_field(
        name="enableIpv6", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates wether to enable Ipv6 or not. If not provided, it will take the same configuration as
     the cluster."""
    private_endpoint_network_policies: Optional[Union[str, "_models.PrivateEndpointNetworkPolicies"]] = rest_field(
        name="privateEndpointNetworkPolicies", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enable or Disable apply network policies on private end point in the subnet. Known values are:
     \"enabled\" and \"disabled\"."""
    private_link_service_network_policies: Optional[Union[str, "_models.PrivateLinkServiceNetworkPolicies"]] = (
        rest_field(name="privateLinkServiceNetworkPolicies", visibility=["read", "create", "update", "delete", "query"])
    )
    """Enable or Disable apply network policies on private link service in the subnet. Known values
     are: \"enabled\" and \"disabled\"."""
    network_security_group_id: Optional[str] = rest_field(
        name="networkSecurityGroupId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Full resource id for the network security group."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        enable_ipv6: Optional[bool] = None,
        private_endpoint_network_policies: Optional[Union[str, "_models.PrivateEndpointNetworkPolicies"]] = None,
        private_link_service_network_policies: Optional[Union[str, "_models.PrivateLinkServiceNetworkPolicies"]] = None,
        network_security_group_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SubResource(_Model):
    """Azure resource identifier.

    :ivar id: Azure resource identifier.
    :vartype id: str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Azure resource identifier."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UniformInt64RangePartitionScheme(Partition, discriminator="UniformInt64Range"):
    """Describes a partitioning scheme where an integer range is allocated evenly across a number of
    partitions.

    :ivar count: The number of partitions. Required.
    :vartype count: int
    :ivar low_key: The lower bound of the partition key range that
     should be split between the partition ‘Count’. Required.
    :vartype low_key: int
    :ivar high_key: The upper bound of the partition key range that
     should be split between the partition ‘Count’. Required.
    :vartype high_key: int
    :ivar partition_scheme: Specifies how the service is partitioned. Required. Indicates that the
     partition is based on Int64 key ranges, and is a UniformInt64RangePartitionScheme object. The
     value is 1.
    :vartype partition_scheme: str or
     ~azure.mgmt.servicefabricmanagedclusters.models.UNIFORM_INT64_RANGE
    """

    count: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of partitions. Required."""
    low_key: int = rest_field(name="lowKey", visibility=["read", "create", "update", "delete", "query"])
    """The lower bound of the partition key range that
     should be split between the partition ‘Count’. Required."""
    high_key: int = rest_field(name="highKey", visibility=["read", "create", "update", "delete", "query"])
    """The upper bound of the partition key range that
     should be split between the partition ‘Count’. Required."""
    partition_scheme: Literal[PartitionScheme.UNIFORM_INT64_RANGE] = rest_discriminator(name="partitionScheme", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies how the service is partitioned. Required. Indicates that the partition is based on
     Int64 key ranges, and is a UniformInt64RangePartitionScheme object. The value is 1."""

    @overload
    def __init__(
        self,
        *,
        count: int,
        low_key: int,
        high_key: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.partition_scheme = PartitionScheme.UNIFORM_INT64_RANGE  # type: ignore


class UserAssignedIdentity(_Model):
    """User assigned identity.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal id of user assigned identity."""
    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client id of user assigned identity."""


class VaultCertificate(_Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should
    reside on the VM.

    :ivar certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. Required.
    :vartype certificate_url: str
    :ivar certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. For Linux VMs, the certificate file is placed under the
     /var/lib/waagent directory, with the file name {UppercaseThumbprint}.crt for the X509
     certificate file and {UppercaseThumbprint}.prv for private key. Both of these files are .pem
     formatted. Required.
    :vartype certificate_store: str
    """

    certificate_url: str = rest_field(name="certificateUrl", visibility=["read", "create", "update", "delete", "query"])
    """This is the URL of a certificate that has been uploaded to Key Vault as a secret. For adding a
     secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. Required."""
    certificate_store: str = rest_field(
        name="certificateStore", visibility=["read", "create", "update", "delete", "query"]
    )
    """For Windows VMs, specifies the certificate store on the Virtual Machine to which the
     certificate should be added. The specified certificate store is implicitly in the LocalMachine
     account. For Linux VMs, the certificate file is placed under the /var/lib/waagent directory,
     with the file name {UppercaseThumbprint}.crt for the X509 certificate file and
     {UppercaseThumbprint}.prv for private key. Both of these files are .pem formatted. Required."""

    @overload
    def __init__(
        self,
        *,
        certificate_url: str,
        certificate_store: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VaultSecretGroup(_Model):
    """Specifies set of certificates that should be installed onto the virtual machines.

    :ivar source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates. Required.
    :vartype source_vault: ~azure.mgmt.servicefabricmanagedclusters.models.SubResource
    :ivar vault_certificates: The list of key vault references in SourceVault which contain
     certificates. Required.
    :vartype vault_certificates:
     list[~azure.mgmt.servicefabricmanagedclusters.models.VaultCertificate]
    """

    source_vault: "_models.SubResource" = rest_field(
        name="sourceVault", visibility=["read", "create", "update", "delete", "query"]
    )
    """The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
     Required."""
    vault_certificates: list["_models.VaultCertificate"] = rest_field(
        name="vaultCertificates", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of key vault references in SourceVault which contain certificates. Required."""

    @overload
    def __init__(
        self,
        *,
        source_vault: "_models.SubResource",
        vault_certificates: list["_models.VaultCertificate"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VmApplication(_Model):
    """Specifies the gallery application that should be made available to the underlying VMSS.

    :ivar configuration_reference: Optional, Specifies the uri to an azure blob that will replace
     the default configuration for the package if provided.
    :vartype configuration_reference: str
    :ivar enable_automatic_upgrade: If set to true, when a new Gallery Application version is
     available in PIR/SIG, it will be automatically updated for the underlying VMSS.
    :vartype enable_automatic_upgrade: bool
    :ivar order: Optional, Specifies the order in which the packages have to be installed.
    :vartype order: int
    :ivar package_reference_id: Specifies the GalleryApplicationVersion resource id on the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     Required.
    :vartype package_reference_id: str
    :ivar vm_gallery_tags: Optional, Specifies a passthrough value for more generic context.
     Accepts a JSON-formatted string e.g. '{"Tag1":"Value1","Tag2":"Value2"}'.
    :vartype vm_gallery_tags: str
    :ivar treat_failure_as_deployment_failure: Optional, If true, any failure for any operation in
     the VmApplication will fail the deployment.
    :vartype treat_failure_as_deployment_failure: bool
    """

    configuration_reference: Optional[str] = rest_field(
        name="configurationReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional, Specifies the uri to an azure blob that will replace the default configuration for
     the package if provided."""
    enable_automatic_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """If set to true, when a new Gallery Application version is available in PIR/SIG, it will be
     automatically updated for the underlying VMSS."""
    order: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional, Specifies the order in which the packages have to be installed."""
    package_reference_id: str = rest_field(
        name="packageReferenceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the GalleryApplicationVersion resource id on the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{application}/versions/{version}.
     Required."""
    vm_gallery_tags: Optional[str] = rest_field(
        name="vmGalleryTags", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional, Specifies a passthrough value for more generic context. Accepts a JSON-formatted
     string e.g. '{\"Tag1\":\"Value1\",\"Tag2\":\"Value2\"}'."""
    treat_failure_as_deployment_failure: Optional[bool] = rest_field(
        name="treatFailureAsDeploymentFailure", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional, If true, any failure for any operation in the VmApplication will fail the deployment."""

    @overload
    def __init__(
        self,
        *,
        package_reference_id: str,
        configuration_reference: Optional[str] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        order: Optional[int] = None,
        vm_gallery_tags: Optional[str] = None,
        treat_failure_as_deployment_failure: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VmImagePlan(_Model):
    """Specifies information about the marketplace image used to create the virtual machine. This
    element is only used for marketplace images. Before you can use a marketplace image from an
    API, you must enable the image for programmatic use. In the Azure portal, find the marketplace
    image that you want to use and then click Want to deploy programmatically, Get Started. Enter
    any required information and then click Save.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The plan ID."""
    product: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the product of the image from the marketplace. This is the same value as Offer under
     the imageReference element."""
    promotion_code: Optional[str] = rest_field(
        name="promotionCode", visibility=["read", "create", "update", "delete", "query"]
    )
    """The promotion code."""
    publisher: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The publisher ID."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        publisher: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VmManagedIdentity(_Model):
    """Identities for the virtual machine scale set under the node type.

    :ivar user_assigned_identities: The list of user identities associated with the virtual machine
     scale set under the node type. Each entry will be an ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: list[str]
    """

    user_assigned_identities: Optional[list[str]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of user identities associated with the virtual machine scale set under the node type.
     Each entry will be an ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'."""

    @overload
    def __init__(
        self,
        *,
        user_assigned_identities: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMSize(_Model):
    """VM Sizes properties.

    :ivar size: VM Size name.
    :vartype size: str
    """

    size: Optional[str] = rest_field(visibility=["read"])
    """VM Size name."""


class VmssDataDisk(_Model):
    """Managed data disk description.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM. Lun
     0 is reserved for the service fabric data disk. Required.
    :vartype lun: int
    :ivar disk_size_gb: Disk size for each vm in the node type in GBs. Required.
    :vartype disk_size_gb: int
    :ivar disk_type: Managed data disk type. Specifies the storage account type for the managed
     disk. Required. Known values are: "Standard_LRS", "StandardSSD_LRS", "Premium_LRS",
     "PremiumV2_LRS", "StandardSSD_ZRS", and "Premium_ZRS".
    :vartype disk_type: str or ~azure.mgmt.servicefabricmanagedclusters.models.DiskType
    :ivar disk_letter: Managed data disk letter. It can not use the reserved letter C or D and it
     can not change after created. Required.
    :vartype disk_letter: str
    """

    lun: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the logical unit number of the data disk. This value is used to identify data disks
     within the VM and therefore must be unique for each data disk attached to a VM. Lun 0 is
     reserved for the service fabric data disk. Required."""
    disk_size_gb: int = rest_field(name="diskSizeGB", visibility=["read", "create", "update", "delete", "query"])
    """Disk size for each vm in the node type in GBs. Required."""
    disk_type: Union[str, "_models.DiskType"] = rest_field(
        name="diskType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Managed data disk type. Specifies the storage account type for the managed disk. Required.
     Known values are: \"Standard_LRS\", \"StandardSSD_LRS\", \"Premium_LRS\", \"PremiumV2_LRS\",
     \"StandardSSD_ZRS\", and \"Premium_ZRS\"."""
    disk_letter: str = rest_field(name="diskLetter", visibility=["read", "create", "update", "delete", "query"])
    """Managed data disk letter. It can not use the reserved letter C or D and it can not change after
     created. Required."""

    @overload
    def __init__(
        self,
        *,
        lun: int,
        disk_size_gb: int,
        disk_type: Union[str, "_models.DiskType"],
        disk_letter: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VMSSExtension(_Model):
    """Specifies set of extensions that should be installed onto the virtual machines.

    :ivar name: The name of the extension. Required.
    :vartype name: str
    :ivar properties: Describes the properties of a Virtual Machine Scale Set Extension. Required.
    :vartype properties: ~azure.mgmt.servicefabricmanagedclusters.models.VMSSExtensionProperties
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extension. Required."""
    properties: "_models.VMSSExtensionProperties" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the properties of a Virtual Machine Scale Set Extension. Required."""

    __flattened_items = [
        "publisher",
        "type",
        "type_handler_version",
        "auto_upgrade_minor_version",
        "settings",
        "protected_settings",
        "force_update_tag",
        "provision_after_extensions",
        "provisioning_state",
        "enable_automatic_upgrade",
        "setup_order",
    ]

    @overload
    def __init__(
        self,
        *,
        name: str,
        properties: "_models.VMSSExtensionProperties",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class VMSSExtensionProperties(_Model):
    """Describes the properties of a Virtual Machine Scale Set Extension.

    :ivar publisher: The name of the extension handler publisher. Required.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
     Required.
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler. Required.
    :vartype type_handler_version: str
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: any
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: any
    :ivar force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :vartype provision_after_extensions: list[str]
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :vartype enable_automatic_upgrade: bool
    :ivar setup_order: Indicates the setup order for the extension.
    :vartype setup_order: list[str or
     ~azure.mgmt.servicefabricmanagedclusters.models.VmssExtensionSetupOrder]
    """

    publisher: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the extension handler publisher. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies the type of the extension; an example is \"CustomScriptExtension\". Required."""
    type_handler_version: str = rest_field(
        name="typeHandlerVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the version of the script handler. Required."""
    auto_upgrade_minor_version: Optional[bool] = rest_field(
        name="autoUpgradeMinorVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should use a newer minor version if one is available at
     deployment time. Once deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true."""
    settings: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Json formatted public settings for the extension."""
    protected_settings: Optional[Any] = rest_field(
        name="protectedSettings", visibility=["read", "create", "update", "delete", "query"]
    )
    """The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no
     protected settings at all."""
    force_update_tag: Optional[str] = rest_field(
        name="forceUpdateTag", visibility=["read", "create", "update", "delete", "query"]
    )
    """If a value is provided and is different from the previous value, the extension handler will be
     forced to update even if the extension configuration has not changed."""
    provision_after_extensions: Optional[list[str]] = rest_field(
        name="provisionAfterExtensions", visibility=["read", "create", "update", "delete", "query"]
    )
    """Collection of extension names after which this extension needs to be provisioned."""
    provisioning_state: Optional[str] = rest_field(name="provisioningState", visibility=["read"])
    """The provisioning state, which only appears in the response."""
    enable_automatic_upgrade: Optional[bool] = rest_field(
        name="enableAutomaticUpgrade", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates whether the extension should be automatically upgraded by the platform if there is a
     newer version of the extension available."""
    setup_order: Optional[list[Union[str, "_models.VmssExtensionSetupOrder"]]] = rest_field(
        name="setupOrder", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the setup order for the extension."""

    @overload
    def __init__(
        self,
        *,
        publisher: str,
        type: str,
        type_handler_version: str,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        force_update_tag: Optional[str] = None,
        provision_after_extensions: Optional[list[str]] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        setup_order: Optional[list[Union[str, "_models.VmssExtensionSetupOrder"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ZoneFaultSimulationContent(FaultSimulationContent, discriminator="Zone"):
    """Parameters for Zone Fault Simulation action.

    :ivar force: Force the action to go through without any check on the cluster.
    :vartype force: bool
    :ivar constraints: Constraints for Fault Simulation action.
    :vartype constraints:
     ~azure.mgmt.servicefabricmanagedclusters.models.FaultSimulationConstraints
    :ivar zones: Indicates the zones of the fault simulation.
    :vartype zones: list[str]
    :ivar fault_kind: The kind of fault simulation. Required. Simulates an availability zone down.
    :vartype fault_kind: str or ~azure.mgmt.servicefabricmanagedclusters.models.ZONE
    """

    zones: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates the zones of the fault simulation."""
    fault_kind: Literal[FaultKind.ZONE] = rest_discriminator(name="faultKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of fault simulation. Required. Simulates an availability zone down."""

    @overload
    def __init__(
        self,
        *,
        force: Optional[bool] = None,
        constraints: Optional["_models.FaultSimulationConstraints"] = None,
        zones: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.fault_kind = FaultKind.ZONE  # type: ignore
