# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python put_governance_rule_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.governance_rules.create_or_update(
        scope="subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
        rule_id="ad9a8e26-29d9-4829-bb30-e597a58cdbb8",
        governance_rule={
            "properties": {
                "conditionSets": [
                    {
                        "conditions": [
                            {
                                "operator": "In",
                                "property": "$.AssessmentKey",
                                "value": '["b1cd27e0-4ecc-4246-939f-49c426d9d72f", "fe83f80b-073d-4ccf-93d9-6797eb870201"]',
                            }
                        ]
                    }
                ],
                "description": "A rule for critical recommendations",
                "displayName": "Admin's rule",
                "governanceEmailNotification": {
                    "disableManagerEmailNotification": False,
                    "disableOwnerEmailNotification": False,
                },
                "isDisabled": False,
                "isGracePeriod": True,
                "ownerSource": {"type": "Manually", "value": "user@contoso.com"},
                "remediationTimeframe": "7.00:00:00",
                "rulePriority": 200,
                "ruleType": "Integrated",
                "sourceResourceType": "Assessments",
            }
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2022-01-01-preview/examples/GovernanceRules/PutGovernanceRule_example.json
if __name__ == "__main__":
    main()
