// +build use_ffjson

// DO NOT EDIT!
// Code generated by ffjson <https://github.com/pquerna/ffjson>
// source: .root/src/github.com/mailru/easyjson/benchmark/data.go
// DO NOT EDIT!

package benchmark

import (
	"bytes"
	"errors"
	"fmt"
	fflib "github.com/pquerna/ffjson/fflib/v1"
)

// MarshalJSON marshal bytes to json - template
func (j *Entities) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *Entities) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"hashtags":`)
	if j.Hashtags != nil {
		buf.WriteString(`[`)
		for i, v := range j.Hashtags {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"urls":`)
	if j.Urls != nil {
		buf.WriteString(`[`)
		for i, v := range j.Urls {
			if i != 0 {
				buf.WriteString(`,`)
			}
			if v != nil {
				fflib.WriteJsonString(buf, string(*v))
			} else {
				buf.WriteString(`null`)
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"user_mentions":`)
	if j.UserMentions != nil {
		buf.WriteString(`[`)
		for i, v := range j.UserMentions {
			if i != 0 {
				buf.WriteString(`,`)
			}
			if v != nil {
				fflib.WriteJsonString(buf, string(*v))
			} else {
				buf.WriteString(`null`)
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtEntitiesbase = iota
	ffjtEntitiesnosuchkey

	ffjtEntitiesHashtags

	ffjtEntitiesUrls

	ffjtEntitiesUserMentions
)

var ffjKeyEntitiesHashtags = []byte("hashtags")

var ffjKeyEntitiesUrls = []byte("urls")

var ffjKeyEntitiesUserMentions = []byte("user_mentions")

// UnmarshalJSON umarshall json - template of ffjson
func (j *Entities) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *Entities) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtEntitiesbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtEntitiesnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'h':

					if bytes.Equal(ffjKeyEntitiesHashtags, kn) {
						currentKey = ffjtEntitiesHashtags
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffjKeyEntitiesUrls, kn) {
						currentKey = ffjtEntitiesUrls
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyEntitiesUserMentions, kn) {
						currentKey = ffjtEntitiesUserMentions
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyEntitiesUserMentions, kn) {
					currentKey = ffjtEntitiesUserMentions
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyEntitiesUrls, kn) {
					currentKey = ffjtEntitiesUrls
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyEntitiesHashtags, kn) {
					currentKey = ffjtEntitiesHashtags
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtEntitiesnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtEntitiesHashtags:
					goto handle_Hashtags

				case ffjtEntitiesUrls:
					goto handle_Urls

				case ffjtEntitiesUserMentions:
					goto handle_UserMentions

				case ffjtEntitiesnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Hashtags:

	/* handler: j.Hashtags type=[]benchmark.Hashtag kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Hashtags = nil
		} else {

			j.Hashtags = []Hashtag{}

			wantVal := true

			for {

				var tmpJHashtags Hashtag

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJHashtags type=benchmark.Hashtag kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

					} else {

						err = tmpJHashtags.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
						if err != nil {
							return err
						}
					}
					state = fflib.FFParse_after_value
				}

				j.Hashtags = append(j.Hashtags, tmpJHashtags)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Urls:

	/* handler: j.Urls type=[]*string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Urls = nil
		} else {

			j.Urls = []*string{}

			wantVal := true

			for {

				var tmpJUrls *string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJUrls type=*string kind=ptr quoted=false*/

				{

					if tok == fflib.FFTok_null {
						tmpJUrls = nil
					} else {
						if tmpJUrls == nil {
							tmpJUrls = new(string)
						}

						/* handler: tmpJUrls type=string kind=string quoted=false*/

						{

							{
								if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
									return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
								}
							}

							if tok == fflib.FFTok_null {

								tmpJUrls = nil

							} else {

								var tval string
								outBuf := fs.Output.Bytes()

								tval = string(string(outBuf))
								tmpJUrls = &tval

							}
						}

					}
				}

				j.Urls = append(j.Urls, tmpJUrls)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UserMentions:

	/* handler: j.UserMentions type=[]*string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.UserMentions = nil
		} else {

			j.UserMentions = []*string{}

			wantVal := true

			for {

				var tmpJUserMentions *string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJUserMentions type=*string kind=ptr quoted=false*/

				{

					if tok == fflib.FFTok_null {
						tmpJUserMentions = nil
					} else {
						if tmpJUserMentions == nil {
							tmpJUserMentions = new(string)
						}

						/* handler: tmpJUserMentions type=string kind=string quoted=false*/

						{

							{
								if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
									return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
								}
							}

							if tok == fflib.FFTok_null {

								tmpJUserMentions = nil

							} else {

								var tval string
								outBuf := fs.Output.Bytes()

								tval = string(string(outBuf))
								tmpJUserMentions = &tval

							}
						}

					}
				}

				j.UserMentions = append(j.UserMentions, tmpJUserMentions)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *Hashtag) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *Hashtag) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"indices":`)
	if j.Indices != nil {
		buf.WriteString(`[`)
		for i, v := range j.Indices {
			if i != 0 {
				buf.WriteString(`,`)
			}
			fflib.FormatBits2(buf, uint64(v), 10, v < 0)
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"text":`)
	fflib.WriteJsonString(buf, string(j.Text))
	buf.WriteByte('}')
	return nil
}

const (
	ffjtHashtagbase = iota
	ffjtHashtagnosuchkey

	ffjtHashtagIndices

	ffjtHashtagText
)

var ffjKeyHashtagIndices = []byte("indices")

var ffjKeyHashtagText = []byte("text")

// UnmarshalJSON umarshall json - template of ffjson
func (j *Hashtag) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *Hashtag) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtHashtagbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtHashtagnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffjKeyHashtagIndices, kn) {
						currentKey = ffjtHashtagIndices
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffjKeyHashtagText, kn) {
						currentKey = ffjtHashtagText
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffjKeyHashtagText, kn) {
					currentKey = ffjtHashtagText
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyHashtagIndices, kn) {
					currentKey = ffjtHashtagIndices
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtHashtagnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtHashtagIndices:
					goto handle_Indices

				case ffjtHashtagText:
					goto handle_Text

				case ffjtHashtagnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Indices:

	/* handler: j.Indices type=[]int kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Indices = nil
		} else {

			j.Indices = []int{}

			wantVal := true

			for {

				var tmpJIndices int

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJIndices type=int kind=int quoted=false*/

				{
					if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
						return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
					}
				}

				{

					if tok == fflib.FFTok_null {

					} else {

						tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

						if err != nil {
							return fs.WrapErr(err)
						}

						tmpJIndices = int(tval)

					}
				}

				j.Indices = append(j.Indices, tmpJIndices)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Text:

	/* handler: j.Text type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Text = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *LargeStruct) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *LargeStruct) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"search_metadata":`)

	{

		err = j.SearchMetadata.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"statuses":`)
	if j.Statuses != nil {
		buf.WriteString(`[`)
		for i, v := range j.Statuses {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtLargeStructbase = iota
	ffjtLargeStructnosuchkey

	ffjtLargeStructSearchMetadata

	ffjtLargeStructStatuses
)

var ffjKeyLargeStructSearchMetadata = []byte("search_metadata")

var ffjKeyLargeStructStatuses = []byte("statuses")

// UnmarshalJSON umarshall json - template of ffjson
func (j *LargeStruct) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *LargeStruct) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtLargeStructbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtLargeStructnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffjKeyLargeStructSearchMetadata, kn) {
						currentKey = ffjtLargeStructSearchMetadata
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyLargeStructStatuses, kn) {
						currentKey = ffjtLargeStructStatuses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyLargeStructStatuses, kn) {
					currentKey = ffjtLargeStructStatuses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyLargeStructSearchMetadata, kn) {
					currentKey = ffjtLargeStructSearchMetadata
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtLargeStructnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtLargeStructSearchMetadata:
					goto handle_SearchMetadata

				case ffjtLargeStructStatuses:
					goto handle_Statuses

				case ffjtLargeStructnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_SearchMetadata:

	/* handler: j.SearchMetadata type=benchmark.SearchMetadata kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.SearchMetadata.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Statuses:

	/* handler: j.Statuses type=[]benchmark.Status kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Statuses = nil
		} else {

			j.Statuses = []Status{}

			wantVal := true

			for {

				var tmpJStatuses Status

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJStatuses type=benchmark.Status kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

					} else {

						err = tmpJStatuses.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
						if err != nil {
							return err
						}
					}
					state = fflib.FFParse_after_value
				}

				j.Statuses = append(j.Statuses, tmpJStatuses)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *SearchMetadata) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *SearchMetadata) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"completed_in":`)
	fflib.AppendFloat(buf, float64(j.CompletedIn), 'g', -1, 64)
	buf.WriteString(`,"count":`)
	fflib.FormatBits2(buf, uint64(j.Count), 10, j.Count < 0)
	buf.WriteString(`,"max_id":`)
	fflib.FormatBits2(buf, uint64(j.MaxID), 10, j.MaxID < 0)
	buf.WriteString(`,"max_id_str":`)
	fflib.WriteJsonString(buf, string(j.MaxIDStr))
	buf.WriteString(`,"next_results":`)
	fflib.WriteJsonString(buf, string(j.NextResults))
	buf.WriteString(`,"query":`)
	fflib.WriteJsonString(buf, string(j.Query))
	buf.WriteString(`,"refresh_url":`)
	fflib.WriteJsonString(buf, string(j.RefreshURL))
	buf.WriteString(`,"since_id":`)
	fflib.FormatBits2(buf, uint64(j.SinceID), 10, j.SinceID < 0)
	buf.WriteString(`,"since_id_str":`)
	fflib.WriteJsonString(buf, string(j.SinceIDStr))
	buf.WriteByte('}')
	return nil
}

const (
	ffjtSearchMetadatabase = iota
	ffjtSearchMetadatanosuchkey

	ffjtSearchMetadataCompletedIn

	ffjtSearchMetadataCount

	ffjtSearchMetadataMaxID

	ffjtSearchMetadataMaxIDStr

	ffjtSearchMetadataNextResults

	ffjtSearchMetadataQuery

	ffjtSearchMetadataRefreshURL

	ffjtSearchMetadataSinceID

	ffjtSearchMetadataSinceIDStr
)

var ffjKeySearchMetadataCompletedIn = []byte("completed_in")

var ffjKeySearchMetadataCount = []byte("count")

var ffjKeySearchMetadataMaxID = []byte("max_id")

var ffjKeySearchMetadataMaxIDStr = []byte("max_id_str")

var ffjKeySearchMetadataNextResults = []byte("next_results")

var ffjKeySearchMetadataQuery = []byte("query")

var ffjKeySearchMetadataRefreshURL = []byte("refresh_url")

var ffjKeySearchMetadataSinceID = []byte("since_id")

var ffjKeySearchMetadataSinceIDStr = []byte("since_id_str")

// UnmarshalJSON umarshall json - template of ffjson
func (j *SearchMetadata) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *SearchMetadata) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtSearchMetadatabase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtSearchMetadatanosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffjKeySearchMetadataCompletedIn, kn) {
						currentKey = ffjtSearchMetadataCompletedIn
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeySearchMetadataCount, kn) {
						currentKey = ffjtSearchMetadataCount
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffjKeySearchMetadataMaxID, kn) {
						currentKey = ffjtSearchMetadataMaxID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeySearchMetadataMaxIDStr, kn) {
						currentKey = ffjtSearchMetadataMaxIDStr
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffjKeySearchMetadataNextResults, kn) {
						currentKey = ffjtSearchMetadataNextResults
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'q':

					if bytes.Equal(ffjKeySearchMetadataQuery, kn) {
						currentKey = ffjtSearchMetadataQuery
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffjKeySearchMetadataRefreshURL, kn) {
						currentKey = ffjtSearchMetadataRefreshURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffjKeySearchMetadataSinceID, kn) {
						currentKey = ffjtSearchMetadataSinceID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeySearchMetadataSinceIDStr, kn) {
						currentKey = ffjtSearchMetadataSinceIDStr
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeySearchMetadataSinceIDStr, kn) {
					currentKey = ffjtSearchMetadataSinceIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeySearchMetadataSinceID, kn) {
					currentKey = ffjtSearchMetadataSinceID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeySearchMetadataRefreshURL, kn) {
					currentKey = ffjtSearchMetadataRefreshURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeySearchMetadataQuery, kn) {
					currentKey = ffjtSearchMetadataQuery
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeySearchMetadataNextResults, kn) {
					currentKey = ffjtSearchMetadataNextResults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeySearchMetadataMaxIDStr, kn) {
					currentKey = ffjtSearchMetadataMaxIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeySearchMetadataMaxID, kn) {
					currentKey = ffjtSearchMetadataMaxID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeySearchMetadataCount, kn) {
					currentKey = ffjtSearchMetadataCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeySearchMetadataCompletedIn, kn) {
					currentKey = ffjtSearchMetadataCompletedIn
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtSearchMetadatanosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtSearchMetadataCompletedIn:
					goto handle_CompletedIn

				case ffjtSearchMetadataCount:
					goto handle_Count

				case ffjtSearchMetadataMaxID:
					goto handle_MaxID

				case ffjtSearchMetadataMaxIDStr:
					goto handle_MaxIDStr

				case ffjtSearchMetadataNextResults:
					goto handle_NextResults

				case ffjtSearchMetadataQuery:
					goto handle_Query

				case ffjtSearchMetadataRefreshURL:
					goto handle_RefreshURL

				case ffjtSearchMetadataSinceID:
					goto handle_SinceID

				case ffjtSearchMetadataSinceIDStr:
					goto handle_SinceIDStr

				case ffjtSearchMetadatanosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_CompletedIn:

	/* handler: j.CompletedIn type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.CompletedIn = float64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Count:

	/* handler: j.Count type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.Count = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MaxID:

	/* handler: j.MaxID type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.MaxID = int64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MaxIDStr:

	/* handler: j.MaxIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.MaxIDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NextResults:

	/* handler: j.NextResults type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.NextResults = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Query:

	/* handler: j.Query type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Query = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RefreshURL:

	/* handler: j.RefreshURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.RefreshURL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SinceID:

	/* handler: j.SinceID type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.SinceID = int64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SinceIDStr:

	/* handler: j.SinceIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.SinceIDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *Status) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *Status) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if j.Contributors != nil {
		buf.WriteString(`{"contributors":`)
		fflib.WriteJsonString(buf, string(*j.Contributors))
	} else {
		buf.WriteString(`{"contributors":null`)
	}
	if j.Coordinates != nil {
		buf.WriteString(`,"coordinates":`)
		fflib.WriteJsonString(buf, string(*j.Coordinates))
	} else {
		buf.WriteString(`,"coordinates":null`)
	}
	buf.WriteString(`,"created_at":`)
	fflib.WriteJsonString(buf, string(j.CreatedAt))
	buf.WriteString(`,"entities":`)

	{

		err = j.Entities.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	if j.Favorited {
		buf.WriteString(`,"favorited":true`)
	} else {
		buf.WriteString(`,"favorited":false`)
	}
	if j.Geo != nil {
		buf.WriteString(`,"geo":`)
		fflib.WriteJsonString(buf, string(*j.Geo))
	} else {
		buf.WriteString(`,"geo":null`)
	}
	buf.WriteString(`,"id":`)
	fflib.FormatBits2(buf, uint64(j.ID), 10, j.ID < 0)
	buf.WriteString(`,"id_str":`)
	fflib.WriteJsonString(buf, string(j.IDStr))
	if j.InReplyToScreenName != nil {
		buf.WriteString(`,"in_reply_to_screen_name":`)
		fflib.WriteJsonString(buf, string(*j.InReplyToScreenName))
	} else {
		buf.WriteString(`,"in_reply_to_screen_name":null`)
	}
	if j.InReplyToStatusID != nil {
		buf.WriteString(`,"in_reply_to_status_id":`)
		fflib.WriteJsonString(buf, string(*j.InReplyToStatusID))
	} else {
		buf.WriteString(`,"in_reply_to_status_id":null`)
	}
	if j.InReplyToStatusIDStr != nil {
		buf.WriteString(`,"in_reply_to_status_id_str":`)
		fflib.WriteJsonString(buf, string(*j.InReplyToStatusIDStr))
	} else {
		buf.WriteString(`,"in_reply_to_status_id_str":null`)
	}
	if j.InReplyToUserID != nil {
		buf.WriteString(`,"in_reply_to_user_id":`)
		fflib.WriteJsonString(buf, string(*j.InReplyToUserID))
	} else {
		buf.WriteString(`,"in_reply_to_user_id":null`)
	}
	if j.InReplyToUserIDStr != nil {
		buf.WriteString(`,"in_reply_to_user_id_str":`)
		fflib.WriteJsonString(buf, string(*j.InReplyToUserIDStr))
	} else {
		buf.WriteString(`,"in_reply_to_user_id_str":null`)
	}
	buf.WriteString(`,"metadata":`)

	{

		err = j.Metadata.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	if j.Place != nil {
		buf.WriteString(`,"place":`)
		fflib.WriteJsonString(buf, string(*j.Place))
	} else {
		buf.WriteString(`,"place":null`)
	}
	buf.WriteString(`,"retweet_count":`)
	fflib.FormatBits2(buf, uint64(j.RetweetCount), 10, j.RetweetCount < 0)
	if j.Retweeted {
		buf.WriteString(`,"retweeted":true`)
	} else {
		buf.WriteString(`,"retweeted":false`)
	}
	buf.WriteString(`,"source":`)
	fflib.WriteJsonString(buf, string(j.Source))
	buf.WriteString(`,"text":`)
	fflib.WriteJsonString(buf, string(j.Text))
	if j.Truncated {
		buf.WriteString(`,"truncated":true`)
	} else {
		buf.WriteString(`,"truncated":false`)
	}
	buf.WriteString(`,"user":`)

	{

		err = j.User.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtStatusbase = iota
	ffjtStatusnosuchkey

	ffjtStatusContributors

	ffjtStatusCoordinates

	ffjtStatusCreatedAt

	ffjtStatusEntities

	ffjtStatusFavorited

	ffjtStatusGeo

	ffjtStatusID

	ffjtStatusIDStr

	ffjtStatusInReplyToScreenName

	ffjtStatusInReplyToStatusID

	ffjtStatusInReplyToStatusIDStr

	ffjtStatusInReplyToUserID

	ffjtStatusInReplyToUserIDStr

	ffjtStatusMetadata

	ffjtStatusPlace

	ffjtStatusRetweetCount

	ffjtStatusRetweeted

	ffjtStatusSource

	ffjtStatusText

	ffjtStatusTruncated

	ffjtStatusUser
)

var ffjKeyStatusContributors = []byte("contributors")

var ffjKeyStatusCoordinates = []byte("coordinates")

var ffjKeyStatusCreatedAt = []byte("created_at")

var ffjKeyStatusEntities = []byte("entities")

var ffjKeyStatusFavorited = []byte("favorited")

var ffjKeyStatusGeo = []byte("geo")

var ffjKeyStatusID = []byte("id")

var ffjKeyStatusIDStr = []byte("id_str")

var ffjKeyStatusInReplyToScreenName = []byte("in_reply_to_screen_name")

var ffjKeyStatusInReplyToStatusID = []byte("in_reply_to_status_id")

var ffjKeyStatusInReplyToStatusIDStr = []byte("in_reply_to_status_id_str")

var ffjKeyStatusInReplyToUserID = []byte("in_reply_to_user_id")

var ffjKeyStatusInReplyToUserIDStr = []byte("in_reply_to_user_id_str")

var ffjKeyStatusMetadata = []byte("metadata")

var ffjKeyStatusPlace = []byte("place")

var ffjKeyStatusRetweetCount = []byte("retweet_count")

var ffjKeyStatusRetweeted = []byte("retweeted")

var ffjKeyStatusSource = []byte("source")

var ffjKeyStatusText = []byte("text")

var ffjKeyStatusTruncated = []byte("truncated")

var ffjKeyStatusUser = []byte("user")

// UnmarshalJSON umarshall json - template of ffjson
func (j *Status) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *Status) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtStatusbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtStatusnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffjKeyStatusContributors, kn) {
						currentKey = ffjtStatusContributors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusCoordinates, kn) {
						currentKey = ffjtStatusCoordinates
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusCreatedAt, kn) {
						currentKey = ffjtStatusCreatedAt
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffjKeyStatusEntities, kn) {
						currentKey = ffjtStatusEntities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffjKeyStatusFavorited, kn) {
						currentKey = ffjtStatusFavorited
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'g':

					if bytes.Equal(ffjKeyStatusGeo, kn) {
						currentKey = ffjtStatusGeo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffjKeyStatusID, kn) {
						currentKey = ffjtStatusID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusIDStr, kn) {
						currentKey = ffjtStatusIDStr
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusInReplyToScreenName, kn) {
						currentKey = ffjtStatusInReplyToScreenName
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusInReplyToStatusID, kn) {
						currentKey = ffjtStatusInReplyToStatusID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusInReplyToStatusIDStr, kn) {
						currentKey = ffjtStatusInReplyToStatusIDStr
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusInReplyToUserID, kn) {
						currentKey = ffjtStatusInReplyToUserID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusInReplyToUserIDStr, kn) {
						currentKey = ffjtStatusInReplyToUserIDStr
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffjKeyStatusMetadata, kn) {
						currentKey = ffjtStatusMetadata
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffjKeyStatusPlace, kn) {
						currentKey = ffjtStatusPlace
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffjKeyStatusRetweetCount, kn) {
						currentKey = ffjtStatusRetweetCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusRetweeted, kn) {
						currentKey = ffjtStatusRetweeted
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffjKeyStatusSource, kn) {
						currentKey = ffjtStatusSource
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffjKeyStatusText, kn) {
						currentKey = ffjtStatusText
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyStatusTruncated, kn) {
						currentKey = ffjtStatusTruncated
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffjKeyStatusUser, kn) {
						currentKey = ffjtStatusUser
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyStatusUser, kn) {
					currentKey = ffjtStatusUser
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusTruncated, kn) {
					currentKey = ffjtStatusTruncated
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusText, kn) {
					currentKey = ffjtStatusText
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusSource, kn) {
					currentKey = ffjtStatusSource
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusRetweeted, kn) {
					currentKey = ffjtStatusRetweeted
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyStatusRetweetCount, kn) {
					currentKey = ffjtStatusRetweetCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusPlace, kn) {
					currentKey = ffjtStatusPlace
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusMetadata, kn) {
					currentKey = ffjtStatusMetadata
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusInReplyToUserIDStr, kn) {
					currentKey = ffjtStatusInReplyToUserIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusInReplyToUserID, kn) {
					currentKey = ffjtStatusInReplyToUserID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusInReplyToStatusIDStr, kn) {
					currentKey = ffjtStatusInReplyToStatusIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusInReplyToStatusID, kn) {
					currentKey = ffjtStatusInReplyToStatusID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusInReplyToScreenName, kn) {
					currentKey = ffjtStatusInReplyToScreenName
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusIDStr, kn) {
					currentKey = ffjtStatusIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusID, kn) {
					currentKey = ffjtStatusID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusGeo, kn) {
					currentKey = ffjtStatusGeo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyStatusFavorited, kn) {
					currentKey = ffjtStatusFavorited
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusEntities, kn) {
					currentKey = ffjtStatusEntities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyStatusCreatedAt, kn) {
					currentKey = ffjtStatusCreatedAt
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusCoordinates, kn) {
					currentKey = ffjtStatusCoordinates
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusContributors, kn) {
					currentKey = ffjtStatusContributors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtStatusnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtStatusContributors:
					goto handle_Contributors

				case ffjtStatusCoordinates:
					goto handle_Coordinates

				case ffjtStatusCreatedAt:
					goto handle_CreatedAt

				case ffjtStatusEntities:
					goto handle_Entities

				case ffjtStatusFavorited:
					goto handle_Favorited

				case ffjtStatusGeo:
					goto handle_Geo

				case ffjtStatusID:
					goto handle_ID

				case ffjtStatusIDStr:
					goto handle_IDStr

				case ffjtStatusInReplyToScreenName:
					goto handle_InReplyToScreenName

				case ffjtStatusInReplyToStatusID:
					goto handle_InReplyToStatusID

				case ffjtStatusInReplyToStatusIDStr:
					goto handle_InReplyToStatusIDStr

				case ffjtStatusInReplyToUserID:
					goto handle_InReplyToUserID

				case ffjtStatusInReplyToUserIDStr:
					goto handle_InReplyToUserIDStr

				case ffjtStatusMetadata:
					goto handle_Metadata

				case ffjtStatusPlace:
					goto handle_Place

				case ffjtStatusRetweetCount:
					goto handle_RetweetCount

				case ffjtStatusRetweeted:
					goto handle_Retweeted

				case ffjtStatusSource:
					goto handle_Source

				case ffjtStatusText:
					goto handle_Text

				case ffjtStatusTruncated:
					goto handle_Truncated

				case ffjtStatusUser:
					goto handle_User

				case ffjtStatusnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Contributors:

	/* handler: j.Contributors type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.Contributors = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.Contributors = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Coordinates:

	/* handler: j.Coordinates type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.Coordinates = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.Coordinates = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CreatedAt:

	/* handler: j.CreatedAt type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.CreatedAt = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Entities:

	/* handler: j.Entities type=benchmark.Entities kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.Entities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Favorited:

	/* handler: j.Favorited type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.Favorited = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.Favorited = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Geo:

	/* handler: j.Geo type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.Geo = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.Geo = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: j.ID type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.ID = int64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IDStr:

	/* handler: j.IDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.IDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToScreenName:

	/* handler: j.InReplyToScreenName type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.InReplyToScreenName = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.InReplyToScreenName = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToStatusID:

	/* handler: j.InReplyToStatusID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.InReplyToStatusID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.InReplyToStatusID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToStatusIDStr:

	/* handler: j.InReplyToStatusIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.InReplyToStatusIDStr = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.InReplyToStatusIDStr = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToUserID:

	/* handler: j.InReplyToUserID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.InReplyToUserID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.InReplyToUserID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReplyToUserIDStr:

	/* handler: j.InReplyToUserIDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.InReplyToUserIDStr = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.InReplyToUserIDStr = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Metadata:

	/* handler: j.Metadata type=benchmark.StatusMetadata kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.Metadata.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Place:

	/* handler: j.Place type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.Place = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.Place = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RetweetCount:

	/* handler: j.RetweetCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.RetweetCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Retweeted:

	/* handler: j.Retweeted type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.Retweeted = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.Retweeted = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Source:

	/* handler: j.Source type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Source = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Text:

	/* handler: j.Text type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Text = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Truncated:

	/* handler: j.Truncated type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.Truncated = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.Truncated = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_User:

	/* handler: j.User type=benchmark.User kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.User.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *StatusMetadata) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *StatusMetadata) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"iso_language_code":`)
	fflib.WriteJsonString(buf, string(j.IsoLanguageCode))
	buf.WriteString(`,"result_type":`)
	fflib.WriteJsonString(buf, string(j.ResultType))
	buf.WriteByte('}')
	return nil
}

const (
	ffjtStatusMetadatabase = iota
	ffjtStatusMetadatanosuchkey

	ffjtStatusMetadataIsoLanguageCode

	ffjtStatusMetadataResultType
)

var ffjKeyStatusMetadataIsoLanguageCode = []byte("iso_language_code")

var ffjKeyStatusMetadataResultType = []byte("result_type")

// UnmarshalJSON umarshall json - template of ffjson
func (j *StatusMetadata) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *StatusMetadata) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtStatusMetadatabase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtStatusMetadatanosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffjKeyStatusMetadataIsoLanguageCode, kn) {
						currentKey = ffjtStatusMetadataIsoLanguageCode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffjKeyStatusMetadataResultType, kn) {
						currentKey = ffjtStatusMetadataResultType
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyStatusMetadataResultType, kn) {
					currentKey = ffjtStatusMetadataResultType
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyStatusMetadataIsoLanguageCode, kn) {
					currentKey = ffjtStatusMetadataIsoLanguageCode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtStatusMetadatanosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtStatusMetadataIsoLanguageCode:
					goto handle_IsoLanguageCode

				case ffjtStatusMetadataResultType:
					goto handle_ResultType

				case ffjtStatusMetadatanosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_IsoLanguageCode:

	/* handler: j.IsoLanguageCode type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.IsoLanguageCode = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ResultType:

	/* handler: j.ResultType type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ResultType = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *URL) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *URL) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if j.ExpandedURL != nil {
		buf.WriteString(`{"expanded_url":`)
		fflib.WriteJsonString(buf, string(*j.ExpandedURL))
	} else {
		buf.WriteString(`{"expanded_url":null`)
	}
	buf.WriteString(`,"indices":`)
	if j.Indices != nil {
		buf.WriteString(`[`)
		for i, v := range j.Indices {
			if i != 0 {
				buf.WriteString(`,`)
			}
			fflib.FormatBits2(buf, uint64(v), 10, v < 0)
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"url":`)
	fflib.WriteJsonString(buf, string(j.URL))
	buf.WriteByte('}')
	return nil
}

const (
	ffjtURLbase = iota
	ffjtURLnosuchkey

	ffjtURLExpandedURL

	ffjtURLIndices

	ffjtURLURL
)

var ffjKeyURLExpandedURL = []byte("expanded_url")

var ffjKeyURLIndices = []byte("indices")

var ffjKeyURLURL = []byte("url")

// UnmarshalJSON umarshall json - template of ffjson
func (j *URL) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *URL) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtURLbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtURLnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'e':

					if bytes.Equal(ffjKeyURLExpandedURL, kn) {
						currentKey = ffjtURLExpandedURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffjKeyURLIndices, kn) {
						currentKey = ffjtURLIndices
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffjKeyURLURL, kn) {
						currentKey = ffjtURLURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffjKeyURLURL, kn) {
					currentKey = ffjtURLURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyURLIndices, kn) {
					currentKey = ffjtURLIndices
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyURLExpandedURL, kn) {
					currentKey = ffjtURLExpandedURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtURLnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtURLExpandedURL:
					goto handle_ExpandedURL

				case ffjtURLIndices:
					goto handle_Indices

				case ffjtURLURL:
					goto handle_URL

				case ffjtURLnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ExpandedURL:

	/* handler: j.ExpandedURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.ExpandedURL = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.ExpandedURL = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Indices:

	/* handler: j.Indices type=[]int kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Indices = nil
		} else {

			j.Indices = []int{}

			wantVal := true

			for {

				var tmpJIndices int

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJIndices type=int kind=int quoted=false*/

				{
					if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
						return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
					}
				}

				{

					if tok == fflib.FFTok_null {

					} else {

						tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

						if err != nil {
							return fs.WrapErr(err)
						}

						tmpJIndices = int(tval)

					}
				}

				j.Indices = append(j.Indices, tmpJIndices)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: j.URL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.URL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *User) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *User) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	if j.ContributorsEnabled {
		buf.WriteString(`{"contributors_enabled":true`)
	} else {
		buf.WriteString(`{"contributors_enabled":false`)
	}
	buf.WriteString(`,"created_at":`)
	fflib.WriteJsonString(buf, string(j.CreatedAt))
	if j.DefaultProfile {
		buf.WriteString(`,"default_profile":true`)
	} else {
		buf.WriteString(`,"default_profile":false`)
	}
	if j.DefaultProfileImage {
		buf.WriteString(`,"default_profile_image":true`)
	} else {
		buf.WriteString(`,"default_profile_image":false`)
	}
	buf.WriteString(`,"description":`)
	fflib.WriteJsonString(buf, string(j.Description))
	buf.WriteString(`,"entities":`)

	{

		err = j.Entities.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"favourites_count":`)
	fflib.FormatBits2(buf, uint64(j.FavouritesCount), 10, j.FavouritesCount < 0)
	if j.FollowRequestSent != nil {
		buf.WriteString(`,"follow_request_sent":`)
		fflib.WriteJsonString(buf, string(*j.FollowRequestSent))
	} else {
		buf.WriteString(`,"follow_request_sent":null`)
	}
	buf.WriteString(`,"followers_count":`)
	fflib.FormatBits2(buf, uint64(j.FollowersCount), 10, j.FollowersCount < 0)
	if j.Following != nil {
		buf.WriteString(`,"following":`)
		fflib.WriteJsonString(buf, string(*j.Following))
	} else {
		buf.WriteString(`,"following":null`)
	}
	buf.WriteString(`,"friends_count":`)
	fflib.FormatBits2(buf, uint64(j.FriendsCount), 10, j.FriendsCount < 0)
	if j.GeoEnabled {
		buf.WriteString(`,"geo_enabled":true`)
	} else {
		buf.WriteString(`,"geo_enabled":false`)
	}
	buf.WriteString(`,"id":`)
	fflib.FormatBits2(buf, uint64(j.ID), 10, j.ID < 0)
	buf.WriteString(`,"id_str":`)
	fflib.WriteJsonString(buf, string(j.IDStr))
	if j.IsTranslator {
		buf.WriteString(`,"is_translator":true`)
	} else {
		buf.WriteString(`,"is_translator":false`)
	}
	buf.WriteString(`,"lang":`)
	fflib.WriteJsonString(buf, string(j.Lang))
	buf.WriteString(`,"listed_count":`)
	fflib.FormatBits2(buf, uint64(j.ListedCount), 10, j.ListedCount < 0)
	buf.WriteString(`,"location":`)
	fflib.WriteJsonString(buf, string(j.Location))
	buf.WriteString(`,"name":`)
	fflib.WriteJsonString(buf, string(j.Name))
	if j.Notifications != nil {
		buf.WriteString(`,"notifications":`)
		fflib.WriteJsonString(buf, string(*j.Notifications))
	} else {
		buf.WriteString(`,"notifications":null`)
	}
	buf.WriteString(`,"profile_background_color":`)
	fflib.WriteJsonString(buf, string(j.ProfileBackgroundColor))
	buf.WriteString(`,"profile_background_image_url":`)
	fflib.WriteJsonString(buf, string(j.ProfileBackgroundImageURL))
	buf.WriteString(`,"profile_background_image_url_https":`)
	fflib.WriteJsonString(buf, string(j.ProfileBackgroundImageURLHTTPS))
	if j.ProfileBackgroundTile {
		buf.WriteString(`,"profile_background_tile":true`)
	} else {
		buf.WriteString(`,"profile_background_tile":false`)
	}
	buf.WriteString(`,"profile_image_url":`)
	fflib.WriteJsonString(buf, string(j.ProfileImageURL))
	buf.WriteString(`,"profile_image_url_https":`)
	fflib.WriteJsonString(buf, string(j.ProfileImageURLHTTPS))
	buf.WriteString(`,"profile_link_color":`)
	fflib.WriteJsonString(buf, string(j.ProfileLinkColor))
	buf.WriteString(`,"profile_sidebar_border_color":`)
	fflib.WriteJsonString(buf, string(j.ProfileSidebarBorderColor))
	buf.WriteString(`,"profile_sidebar_fill_color":`)
	fflib.WriteJsonString(buf, string(j.ProfileSidebarFillColor))
	buf.WriteString(`,"profile_text_color":`)
	fflib.WriteJsonString(buf, string(j.ProfileTextColor))
	if j.ProfileUseBackgroundImage {
		buf.WriteString(`,"profile_use_background_image":true`)
	} else {
		buf.WriteString(`,"profile_use_background_image":false`)
	}
	if j.Protected {
		buf.WriteString(`,"protected":true`)
	} else {
		buf.WriteString(`,"protected":false`)
	}
	buf.WriteString(`,"screen_name":`)
	fflib.WriteJsonString(buf, string(j.ScreenName))
	if j.ShowAllInlineMedia {
		buf.WriteString(`,"show_all_inline_media":true`)
	} else {
		buf.WriteString(`,"show_all_inline_media":false`)
	}
	buf.WriteString(`,"statuses_count":`)
	fflib.FormatBits2(buf, uint64(j.StatusesCount), 10, j.StatusesCount < 0)
	buf.WriteString(`,"time_zone":`)
	fflib.WriteJsonString(buf, string(j.TimeZone))
	if j.URL != nil {
		buf.WriteString(`,"url":`)
		fflib.WriteJsonString(buf, string(*j.URL))
	} else {
		buf.WriteString(`,"url":null`)
	}
	buf.WriteString(`,"utc_offset":`)
	fflib.FormatBits2(buf, uint64(j.UtcOffset), 10, j.UtcOffset < 0)
	if j.Verified {
		buf.WriteString(`,"verified":true`)
	} else {
		buf.WriteString(`,"verified":false`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtUserbase = iota
	ffjtUsernosuchkey

	ffjtUserContributorsEnabled

	ffjtUserCreatedAt

	ffjtUserDefaultProfile

	ffjtUserDefaultProfileImage

	ffjtUserDescription

	ffjtUserEntities

	ffjtUserFavouritesCount

	ffjtUserFollowRequestSent

	ffjtUserFollowersCount

	ffjtUserFollowing

	ffjtUserFriendsCount

	ffjtUserGeoEnabled

	ffjtUserID

	ffjtUserIDStr

	ffjtUserIsTranslator

	ffjtUserLang

	ffjtUserListedCount

	ffjtUserLocation

	ffjtUserName

	ffjtUserNotifications

	ffjtUserProfileBackgroundColor

	ffjtUserProfileBackgroundImageURL

	ffjtUserProfileBackgroundImageURLHTTPS

	ffjtUserProfileBackgroundTile

	ffjtUserProfileImageURL

	ffjtUserProfileImageURLHTTPS

	ffjtUserProfileLinkColor

	ffjtUserProfileSidebarBorderColor

	ffjtUserProfileSidebarFillColor

	ffjtUserProfileTextColor

	ffjtUserProfileUseBackgroundImage

	ffjtUserProtected

	ffjtUserScreenName

	ffjtUserShowAllInlineMedia

	ffjtUserStatusesCount

	ffjtUserTimeZone

	ffjtUserURL

	ffjtUserUtcOffset

	ffjtUserVerified
)

var ffjKeyUserContributorsEnabled = []byte("contributors_enabled")

var ffjKeyUserCreatedAt = []byte("created_at")

var ffjKeyUserDefaultProfile = []byte("default_profile")

var ffjKeyUserDefaultProfileImage = []byte("default_profile_image")

var ffjKeyUserDescription = []byte("description")

var ffjKeyUserEntities = []byte("entities")

var ffjKeyUserFavouritesCount = []byte("favourites_count")

var ffjKeyUserFollowRequestSent = []byte("follow_request_sent")

var ffjKeyUserFollowersCount = []byte("followers_count")

var ffjKeyUserFollowing = []byte("following")

var ffjKeyUserFriendsCount = []byte("friends_count")

var ffjKeyUserGeoEnabled = []byte("geo_enabled")

var ffjKeyUserID = []byte("id")

var ffjKeyUserIDStr = []byte("id_str")

var ffjKeyUserIsTranslator = []byte("is_translator")

var ffjKeyUserLang = []byte("lang")

var ffjKeyUserListedCount = []byte("listed_count")

var ffjKeyUserLocation = []byte("location")

var ffjKeyUserName = []byte("name")

var ffjKeyUserNotifications = []byte("notifications")

var ffjKeyUserProfileBackgroundColor = []byte("profile_background_color")

var ffjKeyUserProfileBackgroundImageURL = []byte("profile_background_image_url")

var ffjKeyUserProfileBackgroundImageURLHTTPS = []byte("profile_background_image_url_https")

var ffjKeyUserProfileBackgroundTile = []byte("profile_background_tile")

var ffjKeyUserProfileImageURL = []byte("profile_image_url")

var ffjKeyUserProfileImageURLHTTPS = []byte("profile_image_url_https")

var ffjKeyUserProfileLinkColor = []byte("profile_link_color")

var ffjKeyUserProfileSidebarBorderColor = []byte("profile_sidebar_border_color")

var ffjKeyUserProfileSidebarFillColor = []byte("profile_sidebar_fill_color")

var ffjKeyUserProfileTextColor = []byte("profile_text_color")

var ffjKeyUserProfileUseBackgroundImage = []byte("profile_use_background_image")

var ffjKeyUserProtected = []byte("protected")

var ffjKeyUserScreenName = []byte("screen_name")

var ffjKeyUserShowAllInlineMedia = []byte("show_all_inline_media")

var ffjKeyUserStatusesCount = []byte("statuses_count")

var ffjKeyUserTimeZone = []byte("time_zone")

var ffjKeyUserURL = []byte("url")

var ffjKeyUserUtcOffset = []byte("utc_offset")

var ffjKeyUserVerified = []byte("verified")

// UnmarshalJSON umarshall json - template of ffjson
func (j *User) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *User) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtUserbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtUsernosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffjKeyUserContributorsEnabled, kn) {
						currentKey = ffjtUserContributorsEnabled
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserCreatedAt, kn) {
						currentKey = ffjtUserCreatedAt
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffjKeyUserDefaultProfile, kn) {
						currentKey = ffjtUserDefaultProfile
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserDefaultProfileImage, kn) {
						currentKey = ffjtUserDefaultProfileImage
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserDescription, kn) {
						currentKey = ffjtUserDescription
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffjKeyUserEntities, kn) {
						currentKey = ffjtUserEntities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffjKeyUserFavouritesCount, kn) {
						currentKey = ffjtUserFavouritesCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserFollowRequestSent, kn) {
						currentKey = ffjtUserFollowRequestSent
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserFollowersCount, kn) {
						currentKey = ffjtUserFollowersCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserFollowing, kn) {
						currentKey = ffjtUserFollowing
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserFriendsCount, kn) {
						currentKey = ffjtUserFriendsCount
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'g':

					if bytes.Equal(ffjKeyUserGeoEnabled, kn) {
						currentKey = ffjtUserGeoEnabled
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffjKeyUserID, kn) {
						currentKey = ffjtUserID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserIDStr, kn) {
						currentKey = ffjtUserIDStr
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserIsTranslator, kn) {
						currentKey = ffjtUserIsTranslator
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffjKeyUserLang, kn) {
						currentKey = ffjtUserLang
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserListedCount, kn) {
						currentKey = ffjtUserListedCount
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserLocation, kn) {
						currentKey = ffjtUserLocation
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffjKeyUserName, kn) {
						currentKey = ffjtUserName
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserNotifications, kn) {
						currentKey = ffjtUserNotifications
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffjKeyUserProfileBackgroundColor, kn) {
						currentKey = ffjtUserProfileBackgroundColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileBackgroundImageURL, kn) {
						currentKey = ffjtUserProfileBackgroundImageURL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileBackgroundImageURLHTTPS, kn) {
						currentKey = ffjtUserProfileBackgroundImageURLHTTPS
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileBackgroundTile, kn) {
						currentKey = ffjtUserProfileBackgroundTile
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileImageURL, kn) {
						currentKey = ffjtUserProfileImageURL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileImageURLHTTPS, kn) {
						currentKey = ffjtUserProfileImageURLHTTPS
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileLinkColor, kn) {
						currentKey = ffjtUserProfileLinkColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileSidebarBorderColor, kn) {
						currentKey = ffjtUserProfileSidebarBorderColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileSidebarFillColor, kn) {
						currentKey = ffjtUserProfileSidebarFillColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileTextColor, kn) {
						currentKey = ffjtUserProfileTextColor
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProfileUseBackgroundImage, kn) {
						currentKey = ffjtUserProfileUseBackgroundImage
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserProtected, kn) {
						currentKey = ffjtUserProtected
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffjKeyUserScreenName, kn) {
						currentKey = ffjtUserScreenName
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserShowAllInlineMedia, kn) {
						currentKey = ffjtUserShowAllInlineMedia
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserStatusesCount, kn) {
						currentKey = ffjtUserStatusesCount
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffjKeyUserTimeZone, kn) {
						currentKey = ffjtUserTimeZone
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffjKeyUserURL, kn) {
						currentKey = ffjtUserURL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffjKeyUserUtcOffset, kn) {
						currentKey = ffjtUserUtcOffset
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffjKeyUserVerified, kn) {
						currentKey = ffjtUserVerified
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserVerified, kn) {
					currentKey = ffjtUserVerified
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserUtcOffset, kn) {
					currentKey = ffjtUserUtcOffset
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserURL, kn) {
					currentKey = ffjtUserURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserTimeZone, kn) {
					currentKey = ffjtUserTimeZone
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserStatusesCount, kn) {
					currentKey = ffjtUserStatusesCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserShowAllInlineMedia, kn) {
					currentKey = ffjtUserShowAllInlineMedia
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserScreenName, kn) {
					currentKey = ffjtUserScreenName
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserProtected, kn) {
					currentKey = ffjtUserProtected
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileUseBackgroundImage, kn) {
					currentKey = ffjtUserProfileUseBackgroundImage
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserProfileTextColor, kn) {
					currentKey = ffjtUserProfileTextColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileSidebarFillColor, kn) {
					currentKey = ffjtUserProfileSidebarFillColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileSidebarBorderColor, kn) {
					currentKey = ffjtUserProfileSidebarBorderColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileLinkColor, kn) {
					currentKey = ffjtUserProfileLinkColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileImageURLHTTPS, kn) {
					currentKey = ffjtUserProfileImageURLHTTPS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserProfileImageURL, kn) {
					currentKey = ffjtUserProfileImageURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileBackgroundTile, kn) {
					currentKey = ffjtUserProfileBackgroundTile
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileBackgroundImageURLHTTPS, kn) {
					currentKey = ffjtUserProfileBackgroundImageURLHTTPS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileBackgroundImageURL, kn) {
					currentKey = ffjtUserProfileBackgroundImageURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserProfileBackgroundColor, kn) {
					currentKey = ffjtUserProfileBackgroundColor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserNotifications, kn) {
					currentKey = ffjtUserNotifications
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserName, kn) {
					currentKey = ffjtUserName
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserLocation, kn) {
					currentKey = ffjtUserLocation
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserListedCount, kn) {
					currentKey = ffjtUserListedCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserLang, kn) {
					currentKey = ffjtUserLang
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserIsTranslator, kn) {
					currentKey = ffjtUserIsTranslator
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserIDStr, kn) {
					currentKey = ffjtUserIDStr
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserID, kn) {
					currentKey = ffjtUserID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserGeoEnabled, kn) {
					currentKey = ffjtUserGeoEnabled
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserFriendsCount, kn) {
					currentKey = ffjtUserFriendsCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserFollowing, kn) {
					currentKey = ffjtUserFollowing
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserFollowersCount, kn) {
					currentKey = ffjtUserFollowersCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserFollowRequestSent, kn) {
					currentKey = ffjtUserFollowRequestSent
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserFavouritesCount, kn) {
					currentKey = ffjtUserFavouritesCount
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserEntities, kn) {
					currentKey = ffjtUserEntities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserDescription, kn) {
					currentKey = ffjtUserDescription
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserDefaultProfileImage, kn) {
					currentKey = ffjtUserDefaultProfileImage
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserDefaultProfile, kn) {
					currentKey = ffjtUserDefaultProfile
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffjKeyUserCreatedAt, kn) {
					currentKey = ffjtUserCreatedAt
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserContributorsEnabled, kn) {
					currentKey = ffjtUserContributorsEnabled
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtUsernosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtUserContributorsEnabled:
					goto handle_ContributorsEnabled

				case ffjtUserCreatedAt:
					goto handle_CreatedAt

				case ffjtUserDefaultProfile:
					goto handle_DefaultProfile

				case ffjtUserDefaultProfileImage:
					goto handle_DefaultProfileImage

				case ffjtUserDescription:
					goto handle_Description

				case ffjtUserEntities:
					goto handle_Entities

				case ffjtUserFavouritesCount:
					goto handle_FavouritesCount

				case ffjtUserFollowRequestSent:
					goto handle_FollowRequestSent

				case ffjtUserFollowersCount:
					goto handle_FollowersCount

				case ffjtUserFollowing:
					goto handle_Following

				case ffjtUserFriendsCount:
					goto handle_FriendsCount

				case ffjtUserGeoEnabled:
					goto handle_GeoEnabled

				case ffjtUserID:
					goto handle_ID

				case ffjtUserIDStr:
					goto handle_IDStr

				case ffjtUserIsTranslator:
					goto handle_IsTranslator

				case ffjtUserLang:
					goto handle_Lang

				case ffjtUserListedCount:
					goto handle_ListedCount

				case ffjtUserLocation:
					goto handle_Location

				case ffjtUserName:
					goto handle_Name

				case ffjtUserNotifications:
					goto handle_Notifications

				case ffjtUserProfileBackgroundColor:
					goto handle_ProfileBackgroundColor

				case ffjtUserProfileBackgroundImageURL:
					goto handle_ProfileBackgroundImageURL

				case ffjtUserProfileBackgroundImageURLHTTPS:
					goto handle_ProfileBackgroundImageURLHTTPS

				case ffjtUserProfileBackgroundTile:
					goto handle_ProfileBackgroundTile

				case ffjtUserProfileImageURL:
					goto handle_ProfileImageURL

				case ffjtUserProfileImageURLHTTPS:
					goto handle_ProfileImageURLHTTPS

				case ffjtUserProfileLinkColor:
					goto handle_ProfileLinkColor

				case ffjtUserProfileSidebarBorderColor:
					goto handle_ProfileSidebarBorderColor

				case ffjtUserProfileSidebarFillColor:
					goto handle_ProfileSidebarFillColor

				case ffjtUserProfileTextColor:
					goto handle_ProfileTextColor

				case ffjtUserProfileUseBackgroundImage:
					goto handle_ProfileUseBackgroundImage

				case ffjtUserProtected:
					goto handle_Protected

				case ffjtUserScreenName:
					goto handle_ScreenName

				case ffjtUserShowAllInlineMedia:
					goto handle_ShowAllInlineMedia

				case ffjtUserStatusesCount:
					goto handle_StatusesCount

				case ffjtUserTimeZone:
					goto handle_TimeZone

				case ffjtUserURL:
					goto handle_URL

				case ffjtUserUtcOffset:
					goto handle_UtcOffset

				case ffjtUserVerified:
					goto handle_Verified

				case ffjtUsernosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ContributorsEnabled:

	/* handler: j.ContributorsEnabled type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.ContributorsEnabled = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.ContributorsEnabled = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CreatedAt:

	/* handler: j.CreatedAt type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.CreatedAt = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DefaultProfile:

	/* handler: j.DefaultProfile type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.DefaultProfile = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.DefaultProfile = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DefaultProfileImage:

	/* handler: j.DefaultProfileImage type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.DefaultProfileImage = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.DefaultProfileImage = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Description:

	/* handler: j.Description type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Description = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Entities:

	/* handler: j.Entities type=benchmark.UserEntities kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.Entities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FavouritesCount:

	/* handler: j.FavouritesCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.FavouritesCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FollowRequestSent:

	/* handler: j.FollowRequestSent type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.FollowRequestSent = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.FollowRequestSent = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FollowersCount:

	/* handler: j.FollowersCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.FollowersCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Following:

	/* handler: j.Following type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.Following = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.Following = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FriendsCount:

	/* handler: j.FriendsCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.FriendsCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_GeoEnabled:

	/* handler: j.GeoEnabled type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.GeoEnabled = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.GeoEnabled = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: j.ID type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.ID = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IDStr:

	/* handler: j.IDStr type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.IDStr = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IsTranslator:

	/* handler: j.IsTranslator type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.IsTranslator = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.IsTranslator = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Lang:

	/* handler: j.Lang type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Lang = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ListedCount:

	/* handler: j.ListedCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.ListedCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Location:

	/* handler: j.Location type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Location = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: j.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Notifications:

	/* handler: j.Notifications type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.Notifications = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.Notifications = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundColor:

	/* handler: j.ProfileBackgroundColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileBackgroundColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundImageURL:

	/* handler: j.ProfileBackgroundImageURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileBackgroundImageURL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundImageURLHTTPS:

	/* handler: j.ProfileBackgroundImageURLHTTPS type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileBackgroundImageURLHTTPS = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileBackgroundTile:

	/* handler: j.ProfileBackgroundTile type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.ProfileBackgroundTile = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.ProfileBackgroundTile = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileImageURL:

	/* handler: j.ProfileImageURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileImageURL = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileImageURLHTTPS:

	/* handler: j.ProfileImageURLHTTPS type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileImageURLHTTPS = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileLinkColor:

	/* handler: j.ProfileLinkColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileLinkColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileSidebarBorderColor:

	/* handler: j.ProfileSidebarBorderColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileSidebarBorderColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileSidebarFillColor:

	/* handler: j.ProfileSidebarFillColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileSidebarFillColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileTextColor:

	/* handler: j.ProfileTextColor type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ProfileTextColor = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ProfileUseBackgroundImage:

	/* handler: j.ProfileUseBackgroundImage type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.ProfileUseBackgroundImage = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.ProfileUseBackgroundImage = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Protected:

	/* handler: j.Protected type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.Protected = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.Protected = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ScreenName:

	/* handler: j.ScreenName type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.ScreenName = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ShowAllInlineMedia:

	/* handler: j.ShowAllInlineMedia type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.ShowAllInlineMedia = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.ShowAllInlineMedia = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_StatusesCount:

	/* handler: j.StatusesCount type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.StatusesCount = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TimeZone:

	/* handler: j.TimeZone type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			j.TimeZone = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: j.URL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			j.URL = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			j.URL = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UtcOffset:

	/* handler: j.UtcOffset type=int kind=int quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			j.UtcOffset = int(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Verified:

	/* handler: j.Verified type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

		} else {
			tmpb := fs.Output.Bytes()

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				j.Verified = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				j.Verified = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *UserEntities) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *UserEntities) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"description":`)

	{

		err = j.Description.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"url":`)

	{

		err = j.URL.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtUserEntitiesbase = iota
	ffjtUserEntitiesnosuchkey

	ffjtUserEntitiesDescription

	ffjtUserEntitiesURL
)

var ffjKeyUserEntitiesDescription = []byte("description")

var ffjKeyUserEntitiesURL = []byte("url")

// UnmarshalJSON umarshall json - template of ffjson
func (j *UserEntities) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *UserEntities) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtUserEntitiesbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtUserEntitiesnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'd':

					if bytes.Equal(ffjKeyUserEntitiesDescription, kn) {
						currentKey = ffjtUserEntitiesDescription
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffjKeyUserEntitiesURL, kn) {
						currentKey = ffjtUserEntitiesURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffjKeyUserEntitiesURL, kn) {
					currentKey = ffjtUserEntitiesURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffjKeyUserEntitiesDescription, kn) {
					currentKey = ffjtUserEntitiesDescription
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtUserEntitiesnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtUserEntitiesDescription:
					goto handle_Description

				case ffjtUserEntitiesURL:
					goto handle_URL

				case ffjtUserEntitiesnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Description:

	/* handler: j.Description type=benchmark.UserEntityDescription kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.Description.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: j.URL type=benchmark.UserEntityURL kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

		} else {

			err = j.URL.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
			if err != nil {
				return err
			}
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *UserEntityDescription) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *UserEntityDescription) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"urls":`)
	if j.Urls != nil {
		buf.WriteString(`[`)
		for i, v := range j.Urls {
			if i != 0 {
				buf.WriteString(`,`)
			}
			if v != nil {
				fflib.WriteJsonString(buf, string(*v))
			} else {
				buf.WriteString(`null`)
			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtUserEntityDescriptionbase = iota
	ffjtUserEntityDescriptionnosuchkey

	ffjtUserEntityDescriptionUrls
)

var ffjKeyUserEntityDescriptionUrls = []byte("urls")

// UnmarshalJSON umarshall json - template of ffjson
func (j *UserEntityDescription) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *UserEntityDescription) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtUserEntityDescriptionbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtUserEntityDescriptionnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'u':

					if bytes.Equal(ffjKeyUserEntityDescriptionUrls, kn) {
						currentKey = ffjtUserEntityDescriptionUrls
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyUserEntityDescriptionUrls, kn) {
					currentKey = ffjtUserEntityDescriptionUrls
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtUserEntityDescriptionnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtUserEntityDescriptionUrls:
					goto handle_Urls

				case ffjtUserEntityDescriptionnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Urls:

	/* handler: j.Urls type=[]*string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Urls = nil
		} else {

			j.Urls = []*string{}

			wantVal := true

			for {

				var tmpJUrls *string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJUrls type=*string kind=ptr quoted=false*/

				{

					if tok == fflib.FFTok_null {
						tmpJUrls = nil
					} else {
						if tmpJUrls == nil {
							tmpJUrls = new(string)
						}

						/* handler: tmpJUrls type=string kind=string quoted=false*/

						{

							{
								if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
									return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
								}
							}

							if tok == fflib.FFTok_null {

								tmpJUrls = nil

							} else {

								var tval string
								outBuf := fs.Output.Bytes()

								tval = string(string(outBuf))
								tmpJUrls = &tval

							}
						}

					}
				}

				j.Urls = append(j.Urls, tmpJUrls)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *UserEntityURL) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *UserEntityURL) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"urls":`)
	if j.Urls != nil {
		buf.WriteString(`[`)
		for i, v := range j.Urls {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtUserEntityURLbase = iota
	ffjtUserEntityURLnosuchkey

	ffjtUserEntityURLUrls
)

var ffjKeyUserEntityURLUrls = []byte("urls")

// UnmarshalJSON umarshall json - template of ffjson
func (j *UserEntityURL) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *UserEntityURL) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtUserEntityURLbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtUserEntityURLnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'u':

					if bytes.Equal(ffjKeyUserEntityURLUrls, kn) {
						currentKey = ffjtUserEntityURLUrls
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffjKeyUserEntityURLUrls, kn) {
					currentKey = ffjtUserEntityURLUrls
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtUserEntityURLnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtUserEntityURLUrls:
					goto handle_Urls

				case ffjtUserEntityURLnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Urls:

	/* handler: j.Urls type=[]benchmark.URL kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Urls = nil
		} else {

			j.Urls = []URL{}

			wantVal := true

			for {

				var tmpJUrls URL

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJUrls type=benchmark.URL kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

					} else {

						err = tmpJUrls.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
						if err != nil {
							return err
						}
					}
					state = fflib.FFParse_after_value
				}

				j.Urls = append(j.Urls, tmpJUrls)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

// MarshalJSON marshal bytes to json - template
func (j *XLStruct) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if j == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := j.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}

// MarshalJSONBuf marshal buff to json - template
func (j *XLStruct) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if j == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"Data":`)
	if j.Data != nil {
		buf.WriteString(`[`)
		for i, v := range j.Data {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffjtXLStructbase = iota
	ffjtXLStructnosuchkey

	ffjtXLStructData
)

var ffjKeyXLStructData = []byte("Data")

// UnmarshalJSON umarshall json - template of ffjson
func (j *XLStruct) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return j.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

// UnmarshalJSONFFLexer fast json unmarshall - template ffjson
func (j *XLStruct) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error
	currentKey := ffjtXLStructbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffjtXLStructnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'D':

					if bytes.Equal(ffjKeyXLStructData, kn) {
						currentKey = ffjtXLStructData
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffjKeyXLStructData, kn) {
					currentKey = ffjtXLStructData
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffjtXLStructnosuchkey
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffjtXLStructData:
					goto handle_Data

				case ffjtXLStructnosuchkey:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Data:

	/* handler: j.Data type=[]benchmark.LargeStruct kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			j.Data = nil
		} else {

			j.Data = []LargeStruct{}

			wantVal := true

			for {

				var tmpJData LargeStruct

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmpJData type=benchmark.LargeStruct kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

					} else {

						err = tmpJData.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
						if err != nil {
							return err
						}
					}
					state = fflib.FFParse_after_value
				}

				j.Data = append(j.Data, tmpJData)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}
