#!/bin/sh

# Convert PNG images to 32-bit packed cardinal ARGB output as
# a C header file for use with the EWMH _NET_WM_ICON property.
# The primary use of this script is to generate src/wm_icons.h
# which is done with:
#   ./make_wm_icons.sh zutty_16x16.png zutty_32x32.png > ../src/wm_icons.h

convert_png () {
    identify $1 > /dev/null
    if [ $? -eq 0 ] ; then
        echo "   // $1"
        echo -n "   " && identify -format "%w, %h,\n" $1
        convert $1 -color-matrix '0 0 1 0, 0 1 0 0, 1 0 0 0, 0 0 0 1' RGBA:- | \
            hexdump -v -e '3/4 "   0x%08x," 1/4 "   0x%08x,\n"'
    fi
}

if [ "$#" -eq 0 ] ; then
    echo "Usage: $0 icon.png [icon2.png ...]"
    exit 1
fi

cat <<EOF
/* Generated by icons/make_wm_icons.sh $@ */

const unsigned long wm_icons [] =
{
EOF

while [ ! -z "$1" ] ; do
    convert_png $1
    shift
    if [ ! -z "$1" ] ; then
        echo
    fi
done

echo "};"
