/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.Connection;
import Ice.FixedProxyException;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.RouterPrx;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.Reference;
import IceUtil.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class FixedReference
extends Reference {
    private Connection[] _fixedConnections;
    private Random _rand = new Random();

    public FixedReference(Instance instance, Communicator communicator, Identity identity, Hashtable hashtable, String string, int n, Connection[] connectionArray) {
        super(instance, communicator, identity, hashtable, string, n, false);
        this._fixedConnections = connectionArray;
    }

    public Endpoint[] getEndpoints() {
        return new Endpoint[0];
    }

    public String getAdapterId() {
        return "";
    }

    public Reference changeAdapterId(String string) {
        throw new FixedProxyException();
    }

    public Reference changeRouter(RouterPrx routerPrx) {
        throw new FixedProxyException();
    }

    public Reference changeLocator(LocatorPrx locatorPrx) {
        throw new FixedProxyException();
    }

    public Reference changeTimeout(int n) {
        throw new FixedProxyException();
    }

    public void streamWrite(BasicStream basicStream) throws MarshalException {
        throw new FixedProxyException();
    }

    public String toString() throws MarshalException {
        throw new FixedProxyException();
    }

    public Connection getConnection() {
        Vector<Connection> vector = new Vector<Connection>();
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                int n;
                for (n = 0; n < this._fixedConnections.length; ++n) {
                    if (this._fixedConnections[n].endpoint().datagram()) continue;
                    vector.addElement(this._fixedConnections[n]);
                }
                break;
            }
            case 3: 
            case 4: {
                int n;
                for (n = 0; n < this._fixedConnections.length; ++n) {
                    if (!this._fixedConnections[n].endpoint().datagram()) continue;
                    vector.addElement(this._fixedConnections[n]);
                }
                break;
            }
        }
        if (vector.size() > 1) {
            Vector vector2 = new Vector();
            vector2.setSize(vector.size());
            Random random = new Random();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int n;
                while (vector2.elementAt(n = Math.abs(random.nextInt() % vector.size())) != null) {
                }
                vector2.setElementAt(enumeration.nextElement(), n);
            }
            vector = vector2;
        }
        if (vector.size() > 1) {
            Vector vector3 = new Vector();
            for (int i = vector.size(); i > 0; --i) {
                if (!((Endpoint)vector.elementAt(i - 1)).secure()) continue;
                vector3.addElement(vector.elementAt(i - 1));
                vector.removeElementAt(i - 1);
            }
            if (this.getSecure()) {
                vector = vector3;
            } else {
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((Connection)enumeration.nextElement());
                }
            }
        } else if (vector.size() == 1) {
            Connection connection = (Connection)vector.elementAt(0);
            if (this.getSecure() && !connection.endpoint().secure()) {
                vector.removeElementAt(0);
            }
        }
        if (vector.size() == 0) {
            NoEndpointException noEndpointException = new NoEndpointException();
            noEndpointException.proxy = "";
            throw noEndpointException;
        }
        Connection connection = (Connection)vector.elementAt(0);
        connection.throwException();
        return connection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FixedReference)) {
            return false;
        }
        FixedReference fixedReference = (FixedReference)object;
        if (!super.equals(fixedReference)) {
            return false;
        }
        return Arrays.equals(this._fixedConnections, fixedReference._fixedConnections);
    }

    protected FixedReference() {
    }

    protected void shallowCopy(FixedReference fixedReference) {
        super.shallowCopy(fixedReference);
        fixedReference._fixedConnections = this._fixedConnections;
        fixedReference._rand = this._rand;
    }

    public Object ice_clone() {
        FixedReference fixedReference = new FixedReference();
        this.shallowCopy(fixedReference);
        return fixedReference;
    }
}

