/* stringcomparator.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "stringcomparator.hh"

bool StringComparator::sm_use_strverscmp = true;

void StringComparator::setUseStrVersCmp( bool nv )
{
    sm_use_strverscmp = nv;
}

bool StringComparator::getUseStrVersCmp()
{
    return sm_use_strverscmp;
}

bool StringComparator::is_equal( const std::string &s1,
                                 const std::string &s2 )
{
    return s1 == s2;
}

int StringComparator::compare( const std::string &s1,
                               const std::string &s2 )
{
    return compare( s1.c_str(), s2.c_str() );
}

bool StringComparator::is_equal( const char *s1,
                                 const char *s2 )
{
    if ( ! s1 || ! s2 ) return false;

    if ( strcmp( s1, s2 ) == 0 ) return true;

    return false;
}

int StringComparator::compare( const char *s1,
                               const char *s2 )
{
    if ( ! s1 || ! s2 ) return false;

    if ( sm_use_strverscmp ) {
#ifdef HAVE_STRVERSCMP
        return strverscmp( s1, s2 );
#else
        return strcmp( s1, s2 );
#endif
    } else {
        return strcmp( s1, s2 );
    }
}
