/*
 * +-------------------------------------------------------+
 * |                                                       |
 * |     videogen                                          |
 * |                                                       |
 * |     a simple XFree86 Modeline calculator              |
 * |     (c) 1997-2002, Szabolcs Rumi                      |   
 * |                                                       |
 * |     http://www.rtfm.hu/videogen                       |
 * |                                                       |
 * |     the videogen package is distributed under the     |
 * |     GNU General Public License Version 2 (GPLv2)      |
 * |                                                       |
 * +-------------------------------------------------------+   
 */





#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>

#include "config.h"
#include "videogen.h"





int
pmsg (int vlevel, char *fmt, ...)
{
	va_list vl;
	int printed = 0;



	va_start (vl, fmt);

	if (vlevel <= verbose)
		printed = vfprintf (stderr, fmt, vl);

#ifdef DEBUG
	if (vlevel == 2)
		printed = vfprintf (stderr, fmt, vl);
#endif

	va_end (vl);

	return (printed);
}





char *
tpathexp (char *tpath, char *expath)
{
	char uname[16];
	unsigned int pos = 0;
	struct passwd *pw;



	if ((tpath == NULL) || (strlen (tpath) == 0) || (tpath[0] != '~'))
		strcpy (expath, tpath);
	else
	{
		while ((tpath[1 + pos] != '\0') && (tpath[1 + pos] != '/'))
		{
			uname[pos] = tpath[1 + pos];
			pos++;
		}

		uname[pos] = '\0';

		if (pos > 0)
		{
			if ((pw = getpwnam ((char *)&uname)) == NULL)
				strcpy (expath, tpath);
			else
			{
				strcpy (expath, pw->pw_dir);
				strcat (expath, (char *)(tpath + pos + 1));
			}
		}
		else
		{
			if ((pw = getpwuid (getuid ())) == NULL)
				strcpy (expath, tpath);
			else
			{
				strcpy (expath, pw->pw_dir);
				strcat (expath, (char *)(tpath + pos + 1));
			}
		}
	}

	return (expath);
}





/* EOF */
