/*  
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

/*
--------
OVERVIEW
--------
- This file should be considered as a template for constructing vdkbuilder
plugin components. Users should copy/paste and easily adapt this file
to their own components.
- See also plugins.txt into /plugins directory for further informations.
*/


// write here your component include file
#define COMPO_INCLUDE <vdkb2/vdkb_treeview.h>
// leave it as is
#define INTERFACE_INCLUDE <vdkb2/vdkb_interface.h>
// write how vdkbuilder will name components pointers,
// pointer names  will be suffixed with a number
// i.e: databox0
#define VDK_WIDGET "treeview"
// write here your interface name
// normally: CLASSComponentInterface
#define INTERFACE  VDKBTreeViewComponentInterface
// tip displayed into builder tool palette
// change with your own
#define COMPO_TIP "TreeView"


//////////////////////
#include COMPO_INCLUDE
#include INTERFACE_INCLUDE
#include <vdkb2/vdkb_evbox.h>
#include <vdkb2/vdkb_utils.h>
#include <vdkb2/vdkb_form.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_objinspect.h>
#include <vdkb2/vdkb_prjman.h>
#include <stdlib.h>
////////////////////////
/*
icon to be displayed on toolbar palette
*/
/*
 change to your own icon, do not change COMPO_XPM,
 change string constants instead.
*/
static const char * COMPO_XPM[] =
{
"22 21 7 1",
". c #808080",
"# c #000000",
"e c #ffff00",
"b c #303030",
"d c #0000ff",
"a c #ffffff",
"c c #ff0000",
"......................",
".####################.",
".#aaaaaaaaaaaaa#aaa.#.",
".#bbbaaaaaaaaaa#a##.#.",
".#aabaaaaaaaaaa#a##.#.",
".#aabaaacccaaaa#....#.",
".#aabbbbcccaaaa######.",
".#aabaabaaaaaaa#a.a.#.",
".#aabaa#aaaaaaa#.a.a#.",
".#aabaa#aaaddda#a.a.#.",
".#aabaa####ddda#.a.a#.",
".#aabaaaaa#aaaa#a.a.#.",
".#aabaaaaa#aaaa#.a.a#.",
".#aabaaaaa###aa#a.a.#.",
".#aabaaaaaaaaaa######.",
".#aabaaaeeeaaaa#aaa.#.",
".#aab###eeeaaaa#a##.#.",
".#aaaaaaaaaaaaa#a##.#.",
".#aaaaaaaaaaaaa#....#.",
".####################.",
"......................"
};
////////////////////////
/*
Interface class for builder widget
leave it as is
 */
class INTERFACE : public VDKBAbstractComponentInterface
   {
public:
     INTERFACE() {}
     virtual ~INTERFACE()
    {
    }
     // write vdk code to create component
     char* CreateSource(char* buffer,VDKBParser& parser)
    {
      return CLASS::CreateSource(buffer,parser);
    }
     // parse .frm file to make the component
     bool CreateWidget(VDKBGuiForm* owner,
		       char* buffer,VDKBParser& parser)
    {
      return CLASS::CreateWidget(owner,buffer,parser);
    }
     // make and add a new component to edit form
     int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL)
   {
     return CLASS::MakeWidget(owner,ev);
   }
     // return component icon to be inserted
     // into vdkbuilder tool palette
     const char** Icon() { return COMPO_XPM; }
     // icon tip
     const char* Tip() { return COMPO_TIP; }
     // return component vdk class name
     const char* VDKName()
    {
      return (const char*) VDK_CLASS;
    }
};
// get a new interface object
// this is called by plugin object from builder
extern "C"
VDKBAbstractComponentInterface* GetExportClass()
{
  return new INTERFACE;
}

/*
 component properties, change here with your own or leave array empty
 like this:
 static char* vdk_props[] = { 0 };
 if your component does not have any property to be set with the WI
*/
#define PROPERTY1     "SelectionMode"
/*
  #define PROPERTY2     "Cross"
  #define PROPERTY3     "Scrollbars"
*/

static char* vdk_props[] =
{
  PROPERTY1,
  /*
    PROPERTY2,
    PROPERTY3,
  */
  0
};

/*
 component provided signals, change here signal provided for your component
 or  leave array empty like this:
 static char* vdk_signals[] = { 0 };
 if your component does not have any signal provided
*/
#define SIGNAL1   "select_row_signal"
#define SIGNAL2   "row_activated_signal"
#define SIGNAL3   "click_column_signal"
  /*
  #define SIGNAL4   "databox_selection_changed_signal"
  #define SIGNAL5   "databox_selection_stopped_signal"
  #define SIGNAL6   "databox_selection_canceled_signal"
*/


static char* vdk_signals[] =
{
  SIGNAL1,
  SIGNAL2,
  SIGNAL3,
  /*
    SIGNAL4,
    SIGNAL5,
    SIGNAL6,
  */
  0
};

/*
 component signal nicknames, they will be used to make signal response
 signatures like this:
 bool On<componentname><signal nickname>(VdkObject* sender);
 e.g.
 Ondatabox1Zoomed(VDKObject* sender);
 Change here nicknames for your component or leave array empty like this:
 static char* vdk_nicknames[] = { 0 };
 if your component does not have any signal provided
*/
#define NICK1  "RowSelected"
#define NICK2  "RowActivated"
#define NICK3  "ColumnClicked"
  /*
  #define NICK4  "SelectionChanged"
  #define NICK5  "SelectionStopped"
  #define NICK6  "SelectionCanceled"
*/

static char* vdk_nicknames[] =
{
  NICK1,
  NICK2,
  NICK3,
  /*
    NICK4,
    NICK5,
    NICK6,
  */
  0
};

/*
local buffer
*/
static char buff[256];
/*
  used to autogenerate default
  component names
*/
int CLASS::Counter = 0;


// dynamic tables
// leave it as is
DEFINE_SIGNAL_LIST(CLASS,VDK_ANCESTOR);
DEFINE_EVENT_LIST(CLASS,VDK_ANCESTOR);
///////////////////////////////////////////////////
/*

static int OnCtreeButtonEvent(GtkWidget *w, GdkEvent* event, void* o)
{
  g_return_val_if_fail(o != NULL, FALSE);
  g_return_val_if_fail(w != NULL, FALSE);
  CLASS* obj = reinterpret_cast<CLASS*>(o);
  obj->ButtonPressed(obj->ObjectFromVDK(), event);
  return FALSE;
}
*/
//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDK_ANCESTOR(owner),VDKBObject(name)
{
  int t = 0;
  // newly constructed component counter is incremented
  // each time
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  // add component specific properties to VDKBObject properties list
  for(t = 0; vdk_props[t]; t++)
    proplist.add(VDKBProperty(vdk_props[t]));
  // add component specifi signal to VDKBObject signal list
  for(t = 0; vdk_signals[t]; t++)
    siglist.add(VDKBSignal(vdk_signals[t], this, vdk_nicknames[t]));
  /*
    here you may want set some default value for some property:
    SetPropValue(<"property name">,<"property value">);
    e.g:
    //set a reasonable size fro the widget in the case
    // it will be dropped into a fixed container
    sprintf(buff,"%d,%d",150,110);
    SetPropValue("Usize",buff);
  */
  //set a reasonable size fro the widget in the case
  // it will be dropped into a fixed container
  sprintf(buff,"%d,%d",150,110);
  SetPropValue("Usize",buff);
  // connects component common events.
  /*
  gtk_signal_connect(GTK_OBJECT(WrappedWidget()),"button_press_event",
		   GTK_SIGNAL_FUNC(::OnCtreeButtonEvent),
		   reinterpret_cast<gpointer>(this));
  */
  CONNECT_COMMON_EVENTS;
  // makes a pop menu common to all widgets (in vdkb_widpopmenu.cc/h)
  // this pop menu will be popped at righ button press event.
  popmenu = new VDKBWidgetPopMenu(this);
  // a reasonable initial size (mainly for adding the component
  // to a fixed container)
  // change to your own size
  SetSize(100,100);
}
///////////////////////////////////////////////
//
//    WRITE WIDGET DESCRIPTION TO .FRM FILE
//
///////////////////////////////////////////////
/*
  Writes a .frm format representation of the component
  This virtual function is called by VDKBForm::WriteBoxesOnFrm()
  a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  int t;
  // first call ancestor to write common properties values
  VDKBObject::WriteOnFrm(fp,parentobj);
  // now we write component specific properties values.
  for( t = 0; vdk_props[t]; t++)
      fprintf(fp,"\n\t%s:%s;", vdk_props[t],(char*) GetProp(vdk_props[t]));
}
////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
////////////////////////////////////////
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  triggered when user wants drop a widget into a form.
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable counter
  // to ensure unicity
  CLASS* component;
  // component name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    {
      // actually makes component
      // <buff> contains component pointer name (autogenerated)
      // may be your constructor is different
      // patch if necessary
      ////////////////////////////////////////
      component = new CLASS(buff,owner);
      ////////////////////////////////////////
    }
  /*
    in this part we write some widget specific initailization code,
    patch or comment out if not applicable to your widget
  */
  ////////////////////////////////////////////
  // add component to form
  return owner->AddToSelf(component,ev);
}
/*
  This is called by a global CreateSource() in vdkb_parser.cc.
*/
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  int smode = 0;
  char local[64];
  // gets component name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  // writes code to make the component
  // may be your constructor is different
  // patch if necessary
  ///////////////////////////////////////////////////////
  sprintf(local,"%s:",vdk_props[0]);
  if(parser.GetParam(arg,buffer,local) &&
     strcmp(arg,NIHIL_PROP))
    {
      smode = atoi(arg);
    }
  sprintf(tmp,"\n%s = new %s(this,NULL,(GtkSelectionMode) %d);",
	  obj_name,VDK_CLASS,smode);
  ///////////////////////////////////////////////////////
  strcpy(source,tmp);
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  /*
    in this part we write some component specific initialization code,
    reading properties values from .frm file and setting them
    to into widget.
  */

  //////////////////////////////////////////////////////////////
  // get code that adds component to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp,false);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
  Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
  reading .frm file.
  MakeGuiObjects() scans .frm file and call a global CreateWidget()
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  int smode;
  CLASS* component;
  // get component name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;
  if(parser.GetParam(arg,buffer,"SelectionMode:") &&
     strcmp(arg,NIHIL_PROP))
    smode = atoi(arg);

  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      // actually makes component
      // <obj_name> contains component pointer name (autogenerated)
      // may be your constructor is different
      // patch if necessary
      ///////////////////////////////////////////
      component = new CLASS(obj_name,owner);
      ///////////////////////////////////////////
      /*
	in this part we write some component specific initialization code,
	and we can't use vdk_props[] loop.
	Patch or comment out if not applicable to your widget
      */
      if(parser.GetParam(arg,buffer,"SelectionMode:") &&
	 strcmp(arg,NIHIL_PROP))
	component->SetPropValue("SelectionMode",arg);
      ////////////////////////////////////////////
      // pack widget to container
      return owner->PackToSelf(component, container, buffer, parser);
    }
  else
    return false;
}
////////////////////////////
//   WIDGET INSPECTOR STUFF
////////////////////////////
/*
  This part of code is dedicated to widget inspector
  management. All widget described here have the
  purpose to let the end-user set component properties
  that will be showed at the bottom of the WI when end-user
  selects your component.
  So this part of code is only a footstep, you have to
  write your own, anyway i hope will be useful.
  I suggest to initially write components without this part
  and add it after you have checked component works
  properly withou properties setting.
*/

/*
GTK_SELECTION_SINGLE,  GTK_SELECTION_BROWSE,  GTK_SELECTION_MULTIPLE,
  GTK_SELECTION_EXTENDED
*/
static
char *selectionmodes[] = { "none","single","browse","multiple",0 };

/*
  This is called by Widget Inspector when end-user selects
  your component on edit form.
*/
VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  // assign inspector for later use
  inspector = isp;
  /*
    generally we make a frame and fill it with widgets.
    Frame will be returned to widget inspector and
    showed at his bottom
  */
  VDKFrame* bframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);
  /*
    now we make a table that will accomodate all widgets
  */
  VDKTable* table = new VDKTable(inspector,1,2,true);
  table->SetSize(219,-1);
  setButton = new VDKCustomButton(inspector,"Set sel mode");
  table->AddToCell(setButton,0,0);
  // set component as parent
  setButton->Parent(this);
  // now we connect "clicked" signal with signal response
  SignalConnect(setButton,"clicked",&CLASS::OnSetSelectionMode);

  selmode = new VDKCombo(inspector,NULL);
  selmode->SetSize(100,-1);
  StringList sm;
  int t = 0;
  for(;selectionmodes[t];t++)
    sm.add(VDKString(selectionmodes[t]));
  selmode->PopdownStrings = sm;
  table->AddToCell(selmode,0,1);
  int r = atoi(GetProp(vdk_props[0]));
  selmode->SelectItem(r);
  /*
    we have finished, now add table to frame and return it
  */
  bframe->Add(table,l_justify,false,false,false);
  return bframe;
}
/*
signal response to clicked signal on setButton
*/
bool
CLASS::OnSetSelectionMode(VDKObject* sender)
{
  int sel = selmode->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  SetPropValue(vdk_props[0],buff);
  inspector->FormNeedToBeChanged();
  return true;
}






