/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/handlebox.h"
#include "vdk/forms.h"

void VDKHandleBox::HandleBoxSignal (GtkWidget* hb,
			       GtkWidget *child,
			       gpointer gp)
{
  g_return_if_fail(hb!= NULL);
  g_return_if_fail(child != NULL);
  g_return_if_fail(gp != NULL);
  VDKObjectSignal *signal = reinterpret_cast<VDKObjectSignal*>(gp);
  VDKHandleBox* obj = reinterpret_cast<VDKHandleBox*>(signal->obj);
  obj->SignalEmit(signal->signal);
}
/*
 */

VDKHandleBox::VDKHandleBox(VDKForm* owner) :
  VDKObjectContainer(owner),
  Child("Child",this,NULL)
{
  widget = gtk_handle_box_new ();
  gtk_container_border_width (GTK_CONTAINER (widget),1);
  s_child_attached.obj = this;
  s_child_attached.signal = child_attached_signal;
  s_child_detached.obj = this;
  s_child_detached.signal = child_detached_signal;

  gtk_signal_connect (GTK_OBJECT (widget),
		      "child_attached",
		      GTK_SIGNAL_FUNC (VDKHandleBox::HandleBoxSignal),
		      reinterpret_cast<gpointer>(&s_child_attached));
  gtk_signal_connect (GTK_OBJECT (widget),
		      "child_detached",
		      GTK_SIGNAL_FUNC (VDKHandleBox::HandleBoxSignal),
		      reinterpret_cast<gpointer>(&s_child_detached));
}

VDKHandleBox::~VDKHandleBox()
{}

void VDKHandleBox::Add(VDKObject* obj, int , int , int , int)
{
  //items.add(obj);
  gtk_container_add (GTK_CONTAINER (widget), obj->Widget());
  //gtk_widget_show(obj->Widget());
  // set property
  Child(obj);
  // sets handle box as object parent
  //obj->Parent(this);
  //obj->Setup();
  VDKObjectContainer::Add(obj,0,0,0,0);
}


  
