/* valatrystatement.c generated by valac, the Vala compiler
 * generated from valatrystatement.vala, do not modify */

/* valatrystatement.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaTryStatementPrivate {
	gboolean _after_try_block_reachable;
	ValaBlock* _body;
	ValaBlock* _finally_body;
	ValaList* catch_clauses;
};


static gpointer vala_try_statement_parent_class = NULL;
static ValaStatementIface * vala_try_statement_vala_statement_parent_iface = NULL;

#define VALA_TRY_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TRY_STATEMENT, ValaTryStatementPrivate))
static void vala_try_statement_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_try_statement_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gboolean vala_try_statement_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static void vala_try_statement_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_try_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new try statement.
 *
 * @param body             body of the try statement
 * @param finally_body     body of the optional finally clause
 * @param source_reference reference to source code
 * @return                 newly created try statement
 */
ValaTryStatement*
vala_try_statement_construct (GType object_type,
                              ValaBlock* body,
                              ValaBlock* finally_body,
                              ValaSourceReference* source_reference)
{
	ValaTryStatement* self = NULL;
	g_return_val_if_fail (body != NULL, NULL);
	self = (ValaTryStatement*) vala_code_node_construct (object_type);
	vala_try_statement_set_body (self, body);
	vala_try_statement_set_finally_body (self, finally_body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaTryStatement*
vala_try_statement_new (ValaBlock* body,
                        ValaBlock* finally_body,
                        ValaSourceReference* source_reference)
{
	return vala_try_statement_construct (VALA_TYPE_TRY_STATEMENT, body, finally_body, source_reference);
}


/**
 * Appends the specified clause to the list of catch clauses.
 *
 * @param clause a catch clause
 */
void
vala_try_statement_add_catch_clause (ValaTryStatement* self,
                                     ValaCatchClause* clause)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clause != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) clause, (ValaCodeNode*) self);
	_tmp0_ = self->priv->catch_clauses;
	vala_collection_add ((ValaCollection*) _tmp0_, clause);
}


/**
 * Returns a copy of the list of catch clauses.
 *
 * @return list of catch clauses
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_try_statement_get_catch_clauses (ValaTryStatement* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->catch_clauses;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_try_statement_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaTryStatement * self;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_try_statement (visitor, self);
}


static void
vala_try_statement_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaTryStatement * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp14_;
	ValaBlock* _tmp15_;
	self = (ValaTryStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_try_statement_get_body (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _clause_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _clause_index = 0;
		_tmp2_ = self->priv->catch_clauses;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_clause_list = _tmp3_;
		_tmp4_ = _clause_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_clause_size = _tmp6_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaCatchClause* _tmp13_;
			_tmp7_ = _clause_index;
			_clause_index = _tmp7_ + 1;
			_tmp8_ = _clause_index;
			_tmp9_ = _clause_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _clause_list;
			_tmp11_ = _clause_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			clause = (ValaCatchClause*) _tmp12_;
			_tmp13_ = clause;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp14_ = vala_try_statement_get_finally_body (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaBlock* _tmp16_;
		ValaBlock* _tmp17_;
		_tmp16_ = vala_try_statement_get_finally_body (self);
		_tmp17_ = _tmp16_;
		vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
	}
}


static gboolean
vala_try_statement_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaTryStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValaArrayList* handled_error_types = NULL;
	GEqualFunc _tmp22_;
	ValaArrayList* _tmp23_;
	ValaBlock* _tmp86_;
	ValaBlock* _tmp87_;
	ValaArrayList* _tmp104_;
	gboolean _tmp105_;
	gboolean _tmp106_;
	self = (ValaTryStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_try_statement_get_body (self);
	_tmp5_ = _tmp4_;
	vala_code_node_check ((ValaCodeNode*) _tmp5_, context);
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	error_types = _tmp7_;
	{
		ValaList* _body_error_type_list = NULL;
		ValaBlock* _tmp8_;
		ValaBlock* _tmp9_;
		ValaList* _tmp10_;
		gint _body_error_type_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _body_error_type_index = 0;
		_tmp8_ = vala_try_statement_get_body (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp9_);
		_body_error_type_list = _tmp10_;
		_tmp11_ = _body_error_type_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_body_error_type_size = _tmp13_;
		_body_error_type_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			ValaDataType* body_error_type = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValaArrayList* _tmp20_;
			ValaDataType* _tmp21_;
			_tmp14_ = _body_error_type_index;
			_body_error_type_index = _tmp14_ + 1;
			_tmp15_ = _body_error_type_index;
			_tmp16_ = _body_error_type_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _body_error_type_list;
			_tmp18_ = _body_error_type_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			body_error_type = (ValaDataType*) _tmp19_;
			_tmp20_ = error_types;
			_tmp21_ = body_error_type;
			vala_collection_add ((ValaCollection*) _tmp20_, _tmp21_);
			_vala_code_node_unref0 (body_error_type);
		}
		_vala_iterable_unref0 (_body_error_type_list);
	}
	_tmp22_ = g_direct_equal;
	_tmp23_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp22_);
	handled_error_types = _tmp23_;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _clause_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _clause_index = 0;
		_tmp24_ = self->priv->catch_clauses;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_clause_list = _tmp25_;
		_tmp26_ = _clause_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_clause_size = _tmp28_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ValaArrayList* _tmp69_;
			ValaCatchClause* _tmp70_;
			_tmp29_ = _clause_index;
			_clause_index = _tmp29_ + 1;
			_tmp30_ = _clause_index;
			_tmp31_ = _clause_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _clause_list;
			_tmp33_ = _clause_index;
			_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
			clause = (ValaCatchClause*) _tmp34_;
			{
				ValaArrayList* _body_error_type_list = NULL;
				ValaArrayList* _tmp35_;
				ValaArrayList* _tmp36_;
				gint _body_error_type_size = 0;
				ValaArrayList* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _body_error_type_index = 0;
				_tmp35_ = error_types;
				_tmp36_ = _vala_iterable_ref0 (_tmp35_);
				_body_error_type_list = _tmp36_;
				_tmp37_ = _body_error_type_list;
				_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
				_tmp39_ = _tmp38_;
				_body_error_type_size = _tmp39_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					ValaDataType* body_error_type = NULL;
					ValaArrayList* _tmp43_;
					gint _tmp44_;
					gpointer _tmp45_;
					gboolean _tmp46_ = FALSE;
					ValaCatchClause* _tmp47_;
					ValaDataType* _tmp48_;
					ValaDataType* _tmp49_;
					_tmp40_ = _body_error_type_index;
					_body_error_type_index = _tmp40_ + 1;
					_tmp41_ = _body_error_type_index;
					_tmp42_ = _body_error_type_size;
					if (!(_tmp41_ < _tmp42_)) {
						break;
					}
					_tmp43_ = _body_error_type_list;
					_tmp44_ = _body_error_type_index;
					_tmp45_ = vala_list_get ((ValaList*) _tmp43_, _tmp44_);
					body_error_type = (ValaDataType*) _tmp45_;
					_tmp47_ = clause;
					_tmp48_ = vala_catch_clause_get_error_type (_tmp47_);
					_tmp49_ = _tmp48_;
					if (_tmp49_ == NULL) {
						_tmp46_ = TRUE;
					} else {
						ValaDataType* _tmp50_;
						ValaCatchClause* _tmp51_;
						ValaDataType* _tmp52_;
						ValaDataType* _tmp53_;
						_tmp50_ = body_error_type;
						_tmp51_ = clause;
						_tmp52_ = vala_catch_clause_get_error_type (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp46_ = vala_data_type_compatible (_tmp50_, _tmp53_);
					}
					if (_tmp46_) {
						ValaArrayList* _tmp54_;
						ValaDataType* _tmp55_;
						_tmp54_ = handled_error_types;
						_tmp55_ = body_error_type;
						vala_collection_add ((ValaCollection*) _tmp54_, _tmp55_);
					}
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			{
				ValaArrayList* _handled_error_type_list = NULL;
				ValaArrayList* _tmp56_;
				ValaArrayList* _tmp57_;
				gint _handled_error_type_size = 0;
				ValaArrayList* _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				gint _handled_error_type_index = 0;
				_tmp56_ = handled_error_types;
				_tmp57_ = _vala_iterable_ref0 (_tmp56_);
				_handled_error_type_list = _tmp57_;
				_tmp58_ = _handled_error_type_list;
				_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
				_tmp60_ = _tmp59_;
				_handled_error_type_size = _tmp60_;
				_handled_error_type_index = -1;
				while (TRUE) {
					gint _tmp61_;
					gint _tmp62_;
					gint _tmp63_;
					ValaDataType* handled_error_type = NULL;
					ValaArrayList* _tmp64_;
					gint _tmp65_;
					gpointer _tmp66_;
					ValaArrayList* _tmp67_;
					ValaDataType* _tmp68_;
					_tmp61_ = _handled_error_type_index;
					_handled_error_type_index = _tmp61_ + 1;
					_tmp62_ = _handled_error_type_index;
					_tmp63_ = _handled_error_type_size;
					if (!(_tmp62_ < _tmp63_)) {
						break;
					}
					_tmp64_ = _handled_error_type_list;
					_tmp65_ = _handled_error_type_index;
					_tmp66_ = vala_list_get ((ValaList*) _tmp64_, _tmp65_);
					handled_error_type = (ValaDataType*) _tmp66_;
					_tmp67_ = error_types;
					_tmp68_ = handled_error_type;
					vala_collection_remove ((ValaCollection*) _tmp67_, _tmp68_);
					_vala_code_node_unref0 (handled_error_type);
				}
				_vala_iterable_unref0 (_handled_error_type_list);
			}
			_tmp69_ = handled_error_types;
			vala_collection_clear ((ValaCollection*) _tmp69_);
			_tmp70_ = clause;
			vala_code_node_check ((ValaCodeNode*) _tmp70_, context);
			{
				ValaList* _body_error_type_list = NULL;
				ValaCatchClause* _tmp71_;
				ValaBlock* _tmp72_;
				ValaBlock* _tmp73_;
				ValaList* _tmp74_;
				gint _body_error_type_size = 0;
				ValaList* _tmp75_;
				gint _tmp76_;
				gint _tmp77_;
				gint _body_error_type_index = 0;
				_tmp71_ = clause;
				_tmp72_ = vala_catch_clause_get_body (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp73_);
				_body_error_type_list = _tmp74_;
				_tmp75_ = _body_error_type_list;
				_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
				_tmp77_ = _tmp76_;
				_body_error_type_size = _tmp77_;
				_body_error_type_index = -1;
				while (TRUE) {
					gint _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					ValaDataType* body_error_type = NULL;
					ValaList* _tmp81_;
					gint _tmp82_;
					gpointer _tmp83_;
					ValaArrayList* _tmp84_;
					ValaDataType* _tmp85_;
					_tmp78_ = _body_error_type_index;
					_body_error_type_index = _tmp78_ + 1;
					_tmp79_ = _body_error_type_index;
					_tmp80_ = _body_error_type_size;
					if (!(_tmp79_ < _tmp80_)) {
						break;
					}
					_tmp81_ = _body_error_type_list;
					_tmp82_ = _body_error_type_index;
					_tmp83_ = vala_list_get (_tmp81_, _tmp82_);
					body_error_type = (ValaDataType*) _tmp83_;
					_tmp84_ = error_types;
					_tmp85_ = body_error_type;
					vala_collection_add ((ValaCollection*) _tmp84_, _tmp85_);
					_vala_code_node_unref0 (body_error_type);
				}
				_vala_iterable_unref0 (_body_error_type_list);
			}
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp86_ = vala_try_statement_get_finally_body (self);
	_tmp87_ = _tmp86_;
	if (_tmp87_ != NULL) {
		ValaBlock* _tmp88_;
		ValaBlock* _tmp89_;
		_tmp88_ = vala_try_statement_get_finally_body (self);
		_tmp89_ = _tmp88_;
		vala_code_node_check ((ValaCodeNode*) _tmp89_, context);
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp90_;
			ValaBlock* _tmp91_;
			ValaList* _tmp92_;
			gint _body_error_type_size = 0;
			ValaList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _body_error_type_index = 0;
			_tmp90_ = vala_try_statement_get_finally_body (self);
			_tmp91_ = _tmp90_;
			_tmp92_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp91_);
			_body_error_type_list = _tmp92_;
			_tmp93_ = _body_error_type_list;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_body_error_type_size = _tmp95_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp99_;
				gint _tmp100_;
				gpointer _tmp101_;
				ValaArrayList* _tmp102_;
				ValaDataType* _tmp103_;
				_tmp96_ = _body_error_type_index;
				_body_error_type_index = _tmp96_ + 1;
				_tmp97_ = _body_error_type_index;
				_tmp98_ = _body_error_type_size;
				if (!(_tmp97_ < _tmp98_)) {
					break;
				}
				_tmp99_ = _body_error_type_list;
				_tmp100_ = _body_error_type_index;
				_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
				body_error_type = (ValaDataType*) _tmp101_;
				_tmp102_ = error_types;
				_tmp103_ = body_error_type;
				vala_collection_add ((ValaCollection*) _tmp102_, _tmp103_);
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp104_ = error_types;
	vala_code_node_add_error_types ((ValaCodeNode*) self, (ValaList*) _tmp104_);
	_tmp105_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp106_ = _tmp105_;
	result = !_tmp106_;
	_vala_iterable_unref0 (handled_error_types);
	_vala_iterable_unref0 (error_types);
	return result;
}


static void
vala_try_statement_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaTryStatement * self;
	self = (ValaTryStatement*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_try_statement ((ValaCodeVisitor*) codegen, self);
}


ValaBlock*
vala_try_statement_get_body (ValaTryStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


void
vala_try_statement_set_body (ValaTryStatement* self,
                             ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
	_tmp1_ = self->priv->_body;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaBlock*
vala_try_statement_get_finally_body (ValaTryStatement* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_finally_body;
	result = _tmp0_;
	return result;
}


void
vala_try_statement_set_finally_body (ValaTryStatement* self,
                                     ValaBlock* value)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_finally_body);
	self->priv->_finally_body = _tmp0_;
	_tmp1_ = self->priv->_finally_body;
	if (_tmp1_ != NULL) {
		ValaBlock* _tmp2_;
		_tmp2_ = self->priv->_finally_body;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


gboolean
vala_try_statement_get_after_try_block_reachable (ValaTryStatement* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_after_try_block_reachable;
	result = _tmp0_;
	return result;
}


void
vala_try_statement_set_after_try_block_reachable (ValaTryStatement* self,
                                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_after_try_block_reachable = value;
}


static void
vala_try_statement_class_init (ValaTryStatementClass * klass)
{
	vala_try_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_try_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaTryStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_try_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_try_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_try_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_try_statement_real_emit;
}


static void
vala_try_statement_vala_statement_interface_init (ValaStatementIface * iface)
{
	vala_try_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void
vala_try_statement_instance_init (ValaTryStatement * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_TRY_STATEMENT_GET_PRIVATE (self);
	self->priv->_after_try_block_reachable = TRUE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CATCH_CLAUSE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->catch_clauses = (ValaList*) _tmp1_;
}


static void
vala_try_statement_finalize (ValaCodeNode * obj)
{
	ValaTryStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_TRY_STATEMENT, ValaTryStatement);
	_vala_code_node_unref0 (self->priv->_body);
	_vala_code_node_unref0 (self->priv->_finally_body);
	_vala_iterable_unref0 (self->priv->catch_clauses);
	VALA_CODE_NODE_CLASS (vala_try_statement_parent_class)->finalize (obj);
}


/**
 * Represents a try statement in the source code.
 */
GType
vala_try_statement_get_type (void)
{
	static volatile gsize vala_try_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_try_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTryStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_try_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTryStatement), 0, (GInstanceInitFunc) vala_try_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_try_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_try_statement_type_id;
		vala_try_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaTryStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_try_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_try_statement_type_id__volatile, vala_try_statement_type_id);
	}
	return vala_try_statement_type_id__volatile;
}



