/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2007, 2008  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

	$Id: iovec.c 1332 2008-06-10 20:01:01Z wsl $
	$URL: http://rot.zo.oi/svn/wsl/src/unsort/iovec.c $

*****************************************************************************/

#include <stdbool.h>
#include <stdint.h>
#include <inttypes.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <fcntl.h>
#include <sys/uio.h>

#include "error.h"
#include "filebuf.h"
#include "iovec.h"

struct iovec_const {
	const void *iov_base;
	size_t iov_len;
};

static uint32_t writev_max = IOV_MAX;

void writev_all(int fd, struct iovec *iov, uint32_t count) {
	ssize_t r, len;

	if(!count)
		return;

	while(count) {
		r = writev(fd, iov, (int)(count > writev_max ? writev_max : count));
		if(r == -1)
			exit_perror(ERROR_SYSTEM, "Can't write to fd %d", fd);
		if(!r)
			exit_error(ERROR_SYSTEM, "Can't write to fd %d", fd);
		while(r) {
			len = iov->iov_len;
			if(r < len) {
				iov->iov_base = (char *)iov->iov_base + r;
				iov->iov_len -= r;
			} else {
				r -= len;
				iov++;
				count--;
			}
		}
	}
}

bool iovec_parse(filebuf_t *fb, int sep, struct iovec *iov, const uint32_t *tlb) {
	const char *buf, *end, *line;
	uint32_t count;
	struct iovec_const *ioc;

	buf = fb->buf;
	end = buf + fb->len;
	count = fb->start;

	while(buf < end) {
		line = (const char *)memchr(buf, sep, (size_t)(end - buf));
		if(!line)
			break;
		line++;
		/* buf..line is nu een regel */
		if(iov) {
			ioc = (struct iovec_const *)iov + (tlb ? tlb[count] : count);
			ioc->iov_base = buf;
			ioc->iov_len = (size_t)(line - buf);
		}
		count++;
		buf = line;
	}

	fb-> count = count;

	return buf < end;
}
