/* -*- mode: c; c-basic-offset: 4; indent-tabs-mode: nil -*- */
/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#ifndef SCOPEUTILS_H
#define SCOPEUTILS_H

#include <gio/gio.h>
#include <libintl.h>
#include <QString>
#include <QVariant>

GIcon* gfileIconFromUri(const QString &uri);
GVariant* hashtableToAsv(GHashTable *hashtable);
QVariantMap ghashtableToQVariantHash(GHashTable *hashtable);
QVariantHash QVariantMapToHash(const QVariantMap &map);
QString randomizedTimeUuid();

inline char* _(const char *__msgid) {
    return gettext(__msgid);
}

#endif
