/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef GENERALSETTINGS_H
#define GENERALSETTINGS_H

#include <QObject>
#include <QFrame>
#include <QWidget>
#include <QVBoxLayout>
#include <QSettings>
#include <QDir>

#include <ukcc/interface/interface.h>
#include <ukcc/widgets/titlelabel.h>
#include <ukcc/widgets/comboxframe.h>
#include <ukcc/widgets/fixlabel.h>
#include "kswitchbutton.h"

using namespace kdk;

#define UKUI_PANEL_SETTINGS                 "org.ukui.panel.settings"
#define GROUP_ENABLE                        "groupingenable"
#define PANEL_SIZE_KEY                      "panelsize"
#define ICON_SIZE_KEY                       "iconsize"
#define PANEL_POSITION_KEY                  "panelposition"
#define LOCK_PANEL_KEY                      "lockpanel"
#define HIDE_PANEL_KEY                      "hidepanel"
#define SHOW_TASKVIEW                       "showtaskview"
#define SHOW_NIGHTMODE                      "shownightmode"

class GeneralSettings : public QFrame
{
    Q_OBJECT
public:
    explicit GeneralSettings(QWidget *parent = nullptr);

signals:

private:
    void setFrame_Noframe(QFrame *frame);
    QFrame *setLine(QFrame *frame);
    void lockPanel();
    void mergeTaskgroup();
    void panelSize();
    void setPanelSizeComboxIndex();
    void panelPosition();
    void hidePanel();

    QVBoxLayout *m_generalSettingsLayout = nullptr;
    //合并按钮
    QFrame *m_mergeTaskgroupFrame = nullptr;
    QHBoxLayout *m_mergeTaskgroupLayout = nullptr;
    QLabel *m_mergeTaskgroupLabel = nullptr;
    QComboBox *m_mergeTaskgroup = nullptr;
    //调整任务栏大小
    QFrame *m_panelsizeFrame = nullptr;
    QHBoxLayout *m_panelsizeLayout = nullptr;
    QLabel *m_panelsizeLebel = nullptr;
    QComboBox *m_panelsizeCombox = nullptr;
    //调整任务栏位置
    QFrame *m_panelpositionFrame = nullptr;
    QHBoxLayout *m_panelpositionLayout = nullptr;
    QLabel *m_panelpositionLebel = nullptr;
    QComboBox *m_panelpositionCombox = nullptr;
    //隐藏任务栏按钮
    QFrame *m_hidePanelFrame = nullptr;
    QHBoxLayout *m_hidePanelLayout = nullptr;
    QLabel *m_hidePanelLabel = nullptr;
    KSwitchButton *m_hidePanelBtn = nullptr;
    //锁定任务栏按钮
    QFrame *m_lockPanelFrame = nullptr;
    QHBoxLayout *m_lockPanelLayout = nullptr;
    QLabel *m_lockPanelLabel = nullptr;
    KSwitchButton *m_lockPanelBtn = nullptr;

    QGSettings *m_panelSettings = nullptr;

private slots:
    void lockPanelChanged(bool);
};

#endif // GENERALSETTINGS_H
