/*	############################################################
	# @(#) chr_850.h
	# @(#)
	# @(#) Copyright (c) 1995-2001 by Dirk Hagedorn
	# @(#) Dirk Hagedorn (udo@dirk-hagedorn.de)
	#
	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.
	# 
	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.
	# 
	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	# 
	# @(#) Uebersetzungstabellen fuer MS-DOS (Codepage 850)
	############################################################	*/

#include	"portab.h"

#ifndef ID_CHARSET_H
#define	ID_CHARSET_H
const char *id_charset_h= "@(#) chr_850.h   14.04.1998";
#endif

#ifndef	THIS_CHARSET
#define	THIS_CHARSET	"cp850"
#endif


/*	------------------------------------------------------------	*/

/*	############################################################
	# ISO-Zeichensatz in System-Zeichensatz umsetzen
	############################################################	*/
typedef struct _iso2sys
{	unsigned char	iso;
	unsigned char	sys;
}	ISO2SYS;


LOCAL const ISO2SYS iso2sys_item[128]=
{
	{ 128,	0		},		/* null		*/	/* !!!! */
	{ 129,	0		},		/* null		*/	/* !!!! */
	{ 130,	0		},		/* '' (9u)	*/	/* !!!! */
	{ 131,	'\237'	},		/* #f		*/
	{ 132,	0		},		/* "" (99u)	*/	/* !!!! */
	{ 133,	0		},		/* !..		*/	/* !!!! */
	{ 134,	'\273'	},		/* #dag		*/
	{ 135,	0		},		/* 2x#dag	*/	/* !!!! */
	{ 136,	'^'		},		/* #circ	*/
	{ 137,	0		},		/* #promill	*/
	{ 138,	'S'		},		/* vS		*/	/* !!!! */
	{ 139,	'<'		},		/* <		*/	/* !!!! */
	{ 140,	'O'		},		/* &OE		*/	/* !!!! */
	{ 141,	0		},		/* null		*/
	{ 142,	0		},		/* null		*/
	{ 143,	0		},		/* null		*/
	{ 144,	0		},		/* null		*/
	{ 145,	0		},		/* '' (6o)	*/	/* !!!! */
	{ 146,	0		},		/* '' (9o)	*/	/* !!!! */
	{ 147,	0		},		/* "" (66o)	*/	/* !!!! */
	{ 148,	0		},		/* "" (99u)	*/	/* !!!! */
	{ 149,	'\372'	},		/* #bullet	*/
	{ 150,	'-'		},		/* --		*/	/* !!!! */
	{ 151,	'-'		},		/* ---		*/	/* !!!! */
	{ 152,	'~'		},		/* !~		*/	/* !!!! */
	{ 153,	0		},		/* #tm		*/	/* !!!! */
	{ 154,	's'		},		/* vs		*/
	{ 155,	'>'		},		/* >		*/
	{ 156,	'o'		},		/* &oe		*/	/* !!!! */
	{ 157,	0		},		/* null		*/
	{ 158,	0		},		/* null		*/
	{ 159,	'Y'		},		/* "Y		*/	/* !!!! */
	{ 150,	0		},		/* null		*/
	{ 161,	'\255'	},		/* #!		*/
	{ 162,	'\275'	},		/* #cent	*/
	{ 163,	'\234'	},		/* #pound	*/
	{ 164,	'\317'	},		/* general currency	*/
	{ 165,	'\276'	},		/* #yen		*/
	{ 166,	'\335'	},		/* broken dash	*/
	{ 167,	'\025'	},		/* #sect	*/
	{ 168,	'\371'	},		/* #"		*/
	{ 169,	'\270'	},		/* #copy	*/
	{ 170,	'\246'	},		/* _a		*/
	{ 171,	'\256'	},		/* #<		*/
	{ 172,	'\252'	},		/* #neg		*/
	{ 173,	'\360'	},		/* strich	*/
	{ 174,	'\251'	},		/* #reg		*/
	{ 175,	'\356'	},		/* #macron	*/
	{ 176,	'\370'	},		/* #degree	*/
	{ 177,	'\361'	},		/* #pm		*/
	{ 178,	'\375'	},		/* #^2		*/
	{ 179,	'\374'	},		/* #^3		*/
	{ 180,	'\357'	},		/* #'		*/
	{ 181,	'\346'	},		/* #mu		*/
	{ 182,	'\364'	},		/* #p		*/
	{ 183,	'\372'	},		/* #cdot	*/
	{ 184,	'\367'	},		/* cedille	*/
	{ 185,	'\373'	},		/* #^1		*/
	{ 186,	'\247'	},		/* _o		*/
	{ 187,	'\257'	},		/* #>		*/
	{ 188,	'\254'	},		/* #1/4		*/
	{ 189,	'\253'	},		/* #1/2		*/
	{ 190,	'\363'	},		/* #3/4		*/
	{ 191,	'\250'	},		/* #?		*/
	{ 192,	'\267'	},		/* `A		*/
	{ 193,	'\265'	},		/* 'A		*/
	{ 194,	'\266'	},		/* ^A		*/
	{ 195,	'\307'	},		/* ~A		*/
	{ 196,	'\216'	},		/* "A		*/
	{ 197,	'\217'	},		/* .A		*/
	{ 198,	'\222'	},		/* &AE		*/
	{ 199,	'\200'	},		/* ,C		*/
	{ 200,	'\324'	},		/* `E		*/
	{ 201,	'\220'	},		/* 'E		*/
	{ 202,	'\322'	},		/* ^E		*/
	{ 203,	'\323'	},		/* "E		*/
	{ 204,	'\336'	},		/* `I		*/
	{ 205,	'\326'	},		/* 'I		*/
	{ 206,	'\327'	},		/* ^I		*/
	{ 207,	'\330'	},		/* "I		*/
	{ 208,	'\321'	},		/* -D		*/
	{ 209,	'\245'	},		/* ~N		*/
	{ 210,	'\343'	},		/* `O		*/
	{ 211,	'\340'	},		/* 'O		*/
	{ 212,	'\342'	},		/* ^O		*/
	{ 213,	'\345'	},		/* ~O		*/
	{ 214,	'\231'	},		/* "O		*/
	{ 215,	'\236'	},		/* #times	*/
	{ 216,	'\235'	},		/* /O		*/
	{ 217,	'\353'	},		/* `U		*/
	{ 218,	'\351'	},		/* 'U		*/
	{ 219,	'\352'	},		/* ^U		*/
	{ 220,	'\232'	},		/* "U		*/
	{ 221,	'\355'	},		/* 'Y		*/
	{ 222,	'\347'	},		/* |b		*/
	{ 223,	'\341'	},		/* "s (beta) */
	{ 224,	'\205'	},		/* `a		*/
	{ 225,	'\240'	},		/* 'a		*/
	{ 226,	'\203'	},		/* ^a		*/
	{ 227,	'\306'	},		/* ~a		*/
	{ 228,	'\204'	},		/* "a		*/
	{ 229,	'\206'	},		/* .a		*/
	{ 230,	'\221'	},		/* &ae		*/
	{ 231,	'\207'	},		/* ,c		*/
	{ 232,	'\212'	},		/* `e		*/
	{ 233,	'\202'	},		/* 'e		*/
	{ 234,	'\210'	},		/* ^e		*/
	{ 235,	'\211'	},		/* "e		*/
	{ 236,	'\215'	},		/* `i		*/
	{ 237,	'\241'	},		/* 'i		*/
	{ 238,	'\214'	},		/* ^i		*/
	{ 239,	'\213'	},		/* "i		*/
	{ 240,	'\320'	},		/* o|''		*/
	{ 241,	'\244'	},		/* ~n		*/
	{ 242,	'\225'	},		/* `o		*/
	{ 243,	'\242'	},		/* 'o		*/
	{ 244,	'\223'	},		/* ^o		*/
	{ 245,	'\344'	},		/* ~o		*/
	{ 246,	'\224'	},		/* "o		*/
	{ 247,	'\366'	},		/* #div		*/
	{ 248,	'\233'	},		/* /o		*/
	{ 249,	'\227'	},		/* `u		*/
	{ 250,	'\243'	},		/* 'u		*/
	{ 251,	'\226'	},		/* ^u		*/
	{ 252,	'\201'	},		/* "u		*/
	{ 253,	'\354'	},		/* 'y		*/
	{ 254,	'\350'	},		/* |B		*/
	{ 255,	'\230'	}		/* "y		*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# Systemzeichensatz in andere Zeichensaetze umwandeln
	############################################################	*/

typedef struct _chartable
{
	unsigned char system;
	char ascii[16];
	char ansi[16];
	char tex[16];
	char html[10];
}	CHARTABLE;

LOCAL /* const */ CHARTABLE chrtab[128]=
{
	{	'\200',	"C",	"\\'C7",		"\\c{C}",			"&Ccedil;"	},
	{	'\201',	"ue",	"\\'FC",		"{\\\"u}",			"&uuml;"	},
	{	'\202',	"e",	"\\'E9",		"\\'{e}",			"&eacute;"	},
	{	'\203',	"a",	"\\'E2",		"\\^{a}",			"&acirc;"	},
	{	'\204',	"ae",	"\\'E4",		"{\\\"a}",			"&auml;"	},
	{	'\205',	"a",	"\\'E0",		"\\`{a}",			"&agrave;"	},
	{	'\206',	"a",	"\\'E5",		"{\\aa}",			"&aring;"	},
	{	'\207',	"c",	"\\'E7",		"\\c{c}",			"&ccedil;"	},

	{	'\210',	"e",	"\\'EA",		"\\^{e}",			"&ecirc;"	},
	{	'\211',	"e",	"\\'EB",		"\\\"{e}",			"&euml;"	},
	{	'\212',	"e",	"\\'E8",		"\\`{e}",			"&egrave;"	},
	{	'\213',	"i",	"\\'EF",		"\\\"{i}",			"&iuml;"	},
	{	'\214',	"i",	"\\'EE",		"\\^{i}",			"&icirc;"	},
	{	'\215',	"i",	"\\'EC",		"\\`{i}",			"&igrave;"	},
	{	'\216',	"Ae",	"\\'C4",		"{\\\"A}",			"&Auml;"	},
	{	'\217',	"A",	"\\'C5",		"{\\AA}",			"&Aring;"	},

	{	'\220',	"E",	"\\'C9",		"\\'{E}",			"&Eacute;"	},
	{	'\221',	"ae",	"\\'E6",		"{\\ae}",			"&aelig;"	},
	{	'\222',	"AE",	"\\'C6",		"{\\AE}",			"&AElig;"	},
	{	'\223',	"o",	"\\'F4",		"\\^{o}",			"&ocirc;"	},
	{	'\224',	"oe",	"\\'F6",		"{\\\"o}",			"&ouml;"	},
	{	'\225',	"o",	"\\'F2",		"\\`{o}",			"&ograve;"	},
	{	'\226',	"u",	"\\'FB",		"\\^{u}",			"&ucirc;"	},
	{	'\227',	"u",	"\\'F9",		"\\`{u}",			"&ugrave;"	},

	{	'\230',	"y",	"\\'FF",		"\\\"{y}",			"&yuml;"	},
	{	'\231',	"Oe",	"\\'D6",		"{\\\"O}",			"&Ouml;"	},
	{	'\232',	"Ue",	"\\'DC",		"{\\\"U}",			"&Uuml;"	},
	{	'\233',	"o",	"\\'F8",		"\\/{o}",			"&#248;"	},
	{	'\234',	"",		"\\'A3",		"\\pounds{}",		"&#163;"	},
	{	'\235',	"O",	"\\'D8",		"{\\O}",			"&Oslash;"	},
	{	'\236', "x",	"\\'D7",		"$\\times$",		"&#215;"	},
	{	'\237',	"",		"\\'83",		"$f$",				"&#166;"	},

	{	'\240',	"a",	"\\'E1",		"\\'{a}",			"&aacute;"	},
	{	'\241',	"i",	"\\'ED",		"\\'{i}",			"&iacute;"	},
	{	'\242',	"o",	"\\'F3",		"\\'{o}",			"&oacute;"	},
	{	'\243',	"u",	"\\'FA",		"\\'{u}",			"&uacute;"	},
	{	'\244',	"n",	"\\'F1",		"\\~{n}",			"&ntilde;"	},
	{	'\245',	"N",	"\\'D1",		"\\~{N}",			"&Ntilde;"	},
	{	'\246',	"",		"\\'AA",		"\\b{a}",			"&#170;"	},
	{	'\247',	"",		"\\'BA",		"\\b{o}",			"&#186;"	},

	{	'\250',	"",		"\\'BF",		"?`",				"&#191;"	},
	{	'\251', "(R)",	"\\'AE",		"(R)",				"&#174;"	},
	{	'\252',	"",		"\\'AC",		"$\\neg$",			"&#172;"	},
	{	'\253',	"",		"\\'BD",		"$\\frac{1}{2}$",	"&#189;"	},
	{	'\254',	"",		"\\'BC",		"$\\frac{1}{4}$",	"&#188;"	},
	{	'\255',	"!",	"\\'A1",		"!`",				"&#161;"	},
	{	'\256',	"",		"\\'AB",		"\"<",				"&#171;"	},
	{	'\257',	"",		"\\'BB",		"\">",				"&#187;"	},

	{	'\260',	"",		"",				"",					""			},
	{	'\261',	"",		"",				"",					""			},
	{	'\262',	"",		"",				"",					""			},
	{	'\263',	"|",	"|",			"$\\mid$",			"|"			},
	{	'\264', "A",	"\\'C1",		"\\'{A}",			"&Aacute;"	},
	{	'\265', "A",	"\\'C2",		"\\^{A}",			"&Acirc;"	},
	{	'\266', "A",	"\\'C0",		"\\`{A}",			"&Agrave;"	},
	{	'\267', "(C)",	"\\'A9",		"\\copyright{}",	"&copy;"	},

	{	'\270',	"+",	"+",			"+",				"+"			},
	{	'\271',	"|",	"|",			"$\\mid$",			"|"			},
	{	'\272',	"+",	"+",			"+",				"+"			},
	{	'\273',	"+",	"+",			"+",				"+"			},
	{	'\274',	"+",	"+",			"+",				"+"			},
	{	'\275', "",		"\\'A2",		"cent",				"&#162;"	},
	{	'\276',	"",		"\\'A5",		"yen",				"&#165;"	},
	{	'\277',	"+",	"+",			"+",				"+"			},

	{	'\300',	"+",	"+",			"+",				"+"			},
	{	'\301',	"+",	"+",			"+",				"+"			},
	{	'\302',	"+",	"+",			"+",				"+"			},
	{	'\303',	"+",	"+",			"+",				"+"			},
	{	'\304',	"-",	"-",			"-",				"-"			},
	{	'\305',	"+",	"+",			"+",				"+"			},
	{	'\306', "a",	"\\'E3",		"\\~{a}",			"&atilde;"	},
	{	'\307', "A",	"\\'C3",		"\\~{A}",			"&Atilde;"	},

	{	'\310',	"+",	"+",			"+",				"+"			},
	{	'\311',	"+",	"+",			"+",				"+"			},
	{	'\312',	"+",	"+",			"+",				"+"			},
	{	'\313',	"+",	"+",			"+",				"+"			},
	{	'\314',	"+",	"+",			"+",				"+"			},
	{	'\315',	"-",	"-",			"-",				"-"			},
	{	'\316',	"+",	"+",			"+",				"+"			},
	{	'\317', "",		"\\'A4",		"",					"&#164;"	},	/* general-currency sign */

	{	'\320',	"",		"{\\f2 d}",		"$\\delta$",		""			},
	{	'\321', "N",	"\\'D0",		"",					"&#208;"	},	/* -D */
	{	'\322', "E",	"\\'CA",		"\\^{E}",			"&Ecirc;"	},
	{	'\323', "E",	"\\'CB",		"\\\"E",			"&Euml;"	},
	{	'\324', "E",	"\\'C8",		"\\`{E}",			"&Egrave;"	},
	{	'\325',	"'",	"'",			"'",				"'"			},
	{	'\326', "I",	"\\'CD",		"\\'{I}",			"&Iacute;"	},
	{	'\327', "I",	"\\'CE",		"\\^{I}",			"&Icirc;"	},

	{	'\330', "I",	"\\'CF",		"\\\"I",			"&Iuml;"	},
	{	'\331',	"+",	"+",			"+",				"+"			},
	{	'\332',	"+",	"+",			"+",				"+"			},
	{	'\333',	"",		"",				"",					""			},
	{	'\334',	"",		"",				"",					""			},
	{	'\335',	"|",	"|",			"$\\mid$",			"|"			},
	{	'\336', "I",	"\\'CC",		"\\`{I}",			"&Igrave;"	},
	{	'\337',	"",		"",				"",					""			},

	{	'\340', "O",	"\\'D3",		"\\'{O}",			"&Oacute;"	},
	{	'\341',	"ss",	"\\'DF",		"{\\ss}",			"&szlig;"	},
	{	'\342', "O",	"\\'D4",		"\\^{O}",			"&Ocirc;"	},
	{	'\343', "O",	"\\'D2",		"\\`{O}",			"&Ograve;"	},
	{	'\344', "o",	"\\'F5",		"\\~{o}",			"&otilde;"	},
	{	'\345', "O",	"\\'D5",		"\\~{O}",			"&Otilde;"	},
	{	'\346', "",		"\\'B5",		"$\\mu$",			"&#181;"	},
	{	'\347', "",		"\\'DE",		"",					"&#222;"	},	/* |o */

	{	'\350', "",		"\\'FE",		"",					"&#254;"	},	/* |B */
	{	'\351', "U",	"\\'DA",		"\\'{U}",			"&Uacute;"	},
	{	'\352', "U",	"\\'DB",		"\\^{U}",			"&Ucirc;"	},
	{	'\353', "U",	"\\'D9",		"\\`{U}",			"&Ugrave;"	},
	{	'\354', "y",	"\\'FD",		"\\'{y}",			"&yacute;"	},
	{	'\355', "Y",	"\\'DD",		"\\'{Y}",			"&Yacute;"	},
	{	'\356', "",		"\\'AF",		"",					"&#175;"	},	/* macron */
	{	'\357', "",		"\\'B4",		"\\'{ }",			"&#180;"	},

	{	'\360',	"-",	"-",			"-",				"-"			},
	{	'\361',	"",		"\\'B1",		"$\\pm$",			"&#177;"	},
	{	'\362',	"=",	"=",			"=",				"="			},
	{	'\363', "3/4",	"\\'BE",		"$\\frac{3}{4}$",	"&#180;"	},
	{	'\364', "",		"\\'B6",		"\\P{}",			"&#182;"	},
	{	'\365', "",		"\\'A7",		"\\S{}",			"&sect;"	},
	{	'\366', "",		"\\'F7",		"$\\div$",			"&#247;"	},
	{	'\367', "",		"\\'B8",		"\\c{ }",			"&#184;"	},
	
	{	'\370',	"",		"\\'B0",		"$\\circ$",			"&#176;"	},
	{	'\371',	"",		"",				"",					""			},
	{	'\372',	"",		"\\'B7",		"$\\bullet$",		"&#183;"	},
	{	'\373', "",		"\\'B9",		"$^1$",				"&#185;"	},
	{	'\374',	"",		"\\'B3",		"$^3$",				"&#179;"	},
	{	'\375', "",		"\\'B2",		"$^2$",				"&#178;"	},
	{	'\376',	"",		"",				"",					""			},
	{	'\377',	"",		"\\'AF",		"",					"&#175;"	}		/* #macron	*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# universellen Zeichensatz in ASCII-Zeichensatz umsetzen
	############################################################	*/
typedef struct _uni2systab
{
	char			uni[8];
	unsigned char	system[2];
}	UNI2SYSTAB;

#define	UNI2SYSTABSIZE	64

LOCAL const UNI2SYSTAB uni2sys[UNI2SYSTABSIZE]=
{
	{	"(!\"a)",	"\204"	},
	{	"(!\"e)",	"\211"	},
	{	"(!\"i)",	"\213"	},
	{	"(!\"o)",	"\224"	},
	{	"(!\"u)",	"\201"	},
	{	"(!\"y)",	"\230"	},
	{	"(!\"s)",	"\341"	},
	{	"(!\"A)",	"\216"	},
	{	"(!\"E)",	"\323"	},
	{	"(!\"I)",	"\330"	},
	{	"(!\"O)",	"\231"	},
	{	"(!\"U)",	"\232"	},
	{	"(!\"Y)",	"Y"		},	/* 13 */

	{	"(!'a)",	"\240"	},
	{	"(!'e)",	"\202"	},
	{	"(!'i)",	"\241"	},
	{	"(!'o)",	"\242"	},
	{	"(!'u)",	"\243"	},
	{	"(!'y)",	"\354"	},
	{	"(!'A)",	"\265"	},
	{	"(!'E)",	"\220"	},
	{	"(!'I)",	"\326"	},
	{	"(!'O)",	"\340"	},
	{	"(!'U)",	"\351"	},
	{	"(!'Y)",	"\355"	},	/* 12 */

	{	"(!`a)",	"\205"	},
	{	"(!`e)",	"\212"	},
	{	"(!`i)",	"\215"	},
	{	"(!`o)",	"\225"	},
	{	"(!`u)",	"\227"	},
	{	"(!`A)",	"\267"	},
	{	"(!`E)",	"\324"	},
	{	"(!`I)",	"\336"	},
	{	"(!`O)",	"\343"	},
	{	"(!`U)",	"\353"	},	/* 10 */

	{	"(!^a)",	"\203"	},
	{	"(!^e)",	"\210"	},
	{	"(!^i)",	"\214"	},
	{	"(!^o)",	"\223"	},
	{	"(!^u)",	"\226"	},
	{	"(!^A)",	"\266"	},
	{	"(!^E)",	"\322"	},
	{	"(!^I)",	"\327"	},
	{	"(!^O)",	"\342"	},
	{	"(!^U)",	"\352"	},	/* 10 */

	{	"(!~a)",	"\306"	},
	{	"(!~n)",	"\244"	},
	{	"(!~o)",	"\344"	},
	{	"(!~A)",	"\307"	},
	{	"(!~N)",	"\245"	},
	{	"(!~O)",	"\345"	},	/*  6 */

	{	"(!.a)",	"\206"	},
	{	"(!.A)",	"\217"	},	/*  2 */

	{	"(!&ae)",	"\221"	},
	{	"(!&AE)",	"\222"	},
	{	"(!&oe)",	"oe"	},
	{	"(!&OE)",	"OE"	},	/*  4 */

	{	"(!,c)",	"\207"	},
	{	"(!,C)",	"\200"	},	/*  2 */

	{	"(!_a)",	"\246"	},
	{	"(!_o)",	"\247"	},	/*  2 */

	{	"(!\\o)",	"\233"	},
	{	"(!\\O)",	"\235"	},	/*  2 */

	{	"(!#S)",	"\365"	},
};

/*	############################################################
	# chr_850.h
	############################################################	*/

