/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.piccolo2d.PCamera;
import org.piccolo2d.PLayer;
import org.piccolo2d.PRoot;

public class PUtil {
    public static final long DEFAULT_ACTIVITY_STEP_RATE = 20L;
    public static final int ACTIVITY_SCHEDULER_FRAME_DELAY = 10;
    public static final Iterator NULL_ITERATOR = Collections.EMPTY_LIST.iterator();
    private static final int PATH_TERMINATOR = -1;
    public static final Enumeration NULL_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    public static PCamera createBasicScenegraph() {
        PRoot root = new PRoot();
        PLayer layer = new PLayer();
        PCamera camera = new PCamera();
        root.addChild(camera);
        root.addChild(layer);
        camera.addLayer(layer);
        return camera;
    }

    public static void writeStroke(Stroke stroke, ObjectOutputStream out) throws IOException {
        if (stroke instanceof Serializable) {
            out.writeBoolean(true);
            out.writeBoolean(true);
            out.writeObject(stroke);
        } else if (stroke instanceof BasicStroke) {
            out.writeBoolean(true);
            out.writeBoolean(false);
            PUtil.writeBasicStroke((BasicStroke)stroke, out);
        } else {
            out.writeBoolean(false);
        }
    }

    private static void writeBasicStroke(BasicStroke basicStroke, ObjectOutputStream out) throws IOException {
        float[] dash = basicStroke.getDashArray();
        if (dash == null) {
            out.write(0);
        } else {
            out.write(dash.length);
            for (int i = 0; i < dash.length; ++i) {
                out.writeFloat(dash[i]);
            }
        }
        out.writeFloat(basicStroke.getLineWidth());
        out.writeInt(basicStroke.getEndCap());
        out.writeInt(basicStroke.getLineJoin());
        out.writeFloat(basicStroke.getMiterLimit());
        out.writeFloat(basicStroke.getDashPhase());
    }

    public static Stroke readStroke(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean wroteStroke = in.readBoolean();
        if (!wroteStroke) {
            return null;
        }
        boolean serializedStroke = in.readBoolean();
        if (serializedStroke) {
            return (Stroke)in.readObject();
        }
        return PUtil.readBasicStroke(in);
    }

    private static Stroke readBasicStroke(ObjectInputStream in) throws IOException {
        float[] dash = null;
        int dashLength = in.read();
        if (dashLength != 0) {
            dash = new float[dashLength];
            for (int i = 0; i < dashLength; ++i) {
                dash[i] = in.readFloat();
            }
        }
        float lineWidth = in.readFloat();
        int endCap = in.readInt();
        int lineJoin = in.readInt();
        float miterLimit = in.readFloat();
        float dashPhase = in.readFloat();
        return new BasicStroke(lineWidth, endCap, lineJoin, miterLimit, dash, dashPhase);
    }

    public static GeneralPath readPath(ObjectInputStream in) throws IOException, ClassNotFoundException {
        GeneralPath path = new GeneralPath();
        block8: while (true) {
            int segType = in.readInt();
            switch (segType) {
                case 0: {
                    path.moveTo(in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 1: {
                    path.lineTo(in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 2: {
                    path.quadTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 3: {
                    path.curveTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
                    continue block8;
                }
                case 4: {
                    path.closePath();
                    continue block8;
                }
                case -1: {
                    return path;
                }
            }
            break;
        }
        throw new IOException("Unknown path type encountered while deserializing path.");
    }

    public static void writePath(GeneralPath path, ObjectOutputStream out) throws IOException {
        PathIterator i = path.getPathIterator(null);
        float[] data = new float[6];
        while (!i.isDone()) {
            switch (i.currentSegment(data)) {
                case 0: {
                    out.writeInt(0);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    break;
                }
                case 1: {
                    out.writeInt(1);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    break;
                }
                case 2: {
                    out.writeInt(2);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    out.writeFloat(data[2]);
                    out.writeFloat(data[3]);
                    break;
                }
                case 3: {
                    out.writeInt(3);
                    out.writeFloat(data[0]);
                    out.writeFloat(data[1]);
                    out.writeFloat(data[2]);
                    out.writeFloat(data[3]);
                    out.writeFloat(data[4]);
                    out.writeFloat(data[5]);
                    break;
                }
                case 4: {
                    out.writeInt(4);
                    break;
                }
                default: {
                    throw new IOException("Unknown path type encountered while serializing path.");
                }
            }
            i.next();
        }
        out.writeInt(-1);
    }
}

