package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCrossBoarderStatus invokes the vpc.UpdateCrossBoarderStatus API synchronously
func (client *Client) UpdateCrossBoarderStatus(request *UpdateCrossBoarderStatusRequest) (response *UpdateCrossBoarderStatusResponse, err error) {
	response = CreateUpdateCrossBoarderStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCrossBoarderStatusWithChan invokes the vpc.UpdateCrossBoarderStatus API asynchronously
func (client *Client) UpdateCrossBoarderStatusWithChan(request *UpdateCrossBoarderStatusRequest) (<-chan *UpdateCrossBoarderStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateCrossBoarderStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCrossBoarderStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCrossBoarderStatusWithCallback invokes the vpc.UpdateCrossBoarderStatus API asynchronously
func (client *Client) UpdateCrossBoarderStatusWithCallback(request *UpdateCrossBoarderStatusRequest, callback func(response *UpdateCrossBoarderStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCrossBoarderStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateCrossBoarderStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCrossBoarderStatusRequest is the request struct for api UpdateCrossBoarderStatus
type UpdateCrossBoarderStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Enable               requests.Boolean `position:"Query" name:"Enable"`
	ResourceUid          requests.Integer `position:"Query" name:"ResourceUid"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// UpdateCrossBoarderStatusResponse is the response struct for api UpdateCrossBoarderStatus
type UpdateCrossBoarderStatusResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateCrossBoarderStatusRequest creates a request to invoke UpdateCrossBoarderStatus API
func CreateUpdateCrossBoarderStatusRequest() (request *UpdateCrossBoarderStatusRequest) {
	request = &UpdateCrossBoarderStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "UpdateCrossBoarderStatus", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateCrossBoarderStatusResponse creates a response to parse from UpdateCrossBoarderStatus response
func CreateUpdateCrossBoarderStatusResponse() (response *UpdateCrossBoarderStatusResponse) {
	response = &UpdateCrossBoarderStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
