from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


qScriptConnect = _Mock()

qScriptDisconnect = _Mock()



class QScriptClass(_Mock):
  pass
  Callable = 0
  HandlesReadAccess = 1
  HandlesWriteAccess = 2
  HasInstance = 1

class QScriptClassPropertyIterator(_Mock):
  pass


class QScriptContext(_Mock):
  pass
  ExceptionState = 1
  NormalState = 0
  RangeError = 4
  ReferenceError = 1
  SyntaxError = 2
  TypeError = 3
  URIError = 5
  UnknownError = 0

class QScriptContextInfo(_Mock):
  pass
  NativeFunction = 3
  QtFunction = 1
  QtPropertyFunction = 2
  ScriptFunction = 0

class QScriptEngine(_Mock):
  pass
  AutoCreateDynamicProperties = 256
  AutoOwnership = 2
  ExcludeChildObjects = 1
  ExcludeDeleteLater = 16
  ExcludeSlots = 32
  ExcludeSuperClassContents = 6
  ExcludeSuperClassMethods = 2
  ExcludeSuperClassProperties = 4
  PreferExistingWrapperObject = 512
  QtOwnership = 0
  ScriptOwnership = 1
  SkipMethodsInEnumeration = 8

class QScriptEngineAgent(_Mock):
  pass
  DebuggerInvocationRequest = 0

class QScriptString(_Mock):
  pass


class QScriptSyntaxCheckResult(_Mock):
  pass
  Error = 0
  Intermediate = 1
  Valid = 2

class QScriptValue(_Mock):
  pass
  KeepExistingFlags = 2048
  NullValue = 0
  PropertyGetter = 8
  PropertySetter = 16
  QObjectMember = 32
  ReadOnly = 1
  ResolveFull = 3
  ResolveLocal = 0
  ResolvePrototype = 1
  ResolveScope = 2
  SkipInEnumeration = 4
  UndefinedValue = 1
  Undeletable = 2
  UserRange = -16777216

class QScriptValueIterator(_Mock):
  pass


