//+=============================================================================
//
// file :         DServerLog.cpp
//
// description :  Implementation of the DServer logging oriented commands
//
// project :      TANGO
//
// author(s) :    N.Leclercq - SOLEIL
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013,2014,2015
//                        European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// Revision 3.7  2010/09/09 13:45:22  taurel
// - Add year 2010 in Copyright notice
//
// Revision 3.6  2010/06/18 07:45:47  taurel
// - In case of locked device, polling and logging related commands are
// allowed only for the locker process
//
// Revision 3.5  2009/01/21 12:49:04  taurel
// - Change CopyRights for 2009
//
// Revision 3.4  2008/10/06 15:01:09  taurel
// - Changed the licensing info from GPL to LGPL
//
// Revision 3.3  2008/10/03 06:52:31  taurel
// - Add some licensing info in each files
//
// Revision 3.2  2003/05/28 14:55:09  taurel
// Add the include (conditionally) of the include files generated by autoconf
//
// Revision 3.1  2003/05/16 08:46:16  taurel
// Many changes for release 3.0.1. The most important ones are :
// - Timeout are backs
// - Multiple db servers (change in TANGO_HOST syntax)
// - Added methods to print DeviceData, DeviceDataHistory, DeviceAttribute and DeviceAttributeHistory instances
// - Attributes name stored in blackbox
// - Remove check if a class is created without any device
// - It's now possible to create a DeviceProxy from its alias name
// - Command, attribute names are case insensitive
// - Change parameters of some DeviceProxy logging methods
// - Change parameters of DeviceProxy asynchronous replies calls
// - New serialization model in device server (no serialization model)
// - Win32 (2000) device server service does not exit at loggoff anymore
// - Miscellaneous bug fixes
//
// Revision 3.0  2003/03/25 16:43:20  taurel
// Many changes for Tango release 3.0 including
// - Added full logging features
// - Added asynchronous calls
// - Host name of clients now stored in black-box
// - Three serialization model in DS
// - Fix miscellaneous bugs
// - Ported to gcc 3.2
// - Added ApiUtil::cleanup() and destructor methods
// - Some internal cleanups
// - Change the way how TangoMonitor class is implemented. It's a recursive
//   mutex
//
// Revision 2.2  2003/03/11 17:55:53  nleclercq
// Switch from log4cpp to log4tango
//
// Revision 2.1  2003/02/17 14:57:41  taurel
// Added the new Tango logging stuff (Thanks Nicolas from Soleil)
//
//-=============================================================================

#include <tango/tango.h>

namespace Tango
{
//+----------------------------------------------------------------------------
//
// method : DServer::add_logging_target
//
//-----------------------------------------------------------------------------
void DServer::add_logging_target(const Tango::DevVarStringArray *argin)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::add_logging_target" << std::endl;
    Logging::add_logging_target(argin);
    TANGO_LOG_DEBUG << "Leaving DServer::add_logging_target" << std::endl;
}

//+----------------------------------------------------------------------------
//
// method : DServer::remove_logging_target
//
//-----------------------------------------------------------------------------
void DServer::remove_logging_target(const Tango::DevVarStringArray *argin)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::remove_logging_target" << std::endl;
    Logging::remove_logging_target(argin);
    TANGO_LOG_DEBUG << "Leaving DServer::remove_logging_target" << std::endl;
}

//+----------------------------------------------------------------------------
//
// method : DServer::get_logging_target
//
//-----------------------------------------------------------------------------
Tango::DevVarStringArray *DServer::get_logging_target(const std::string &dev_name)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::get_logging_target" << std::endl;
    DevVarStringArray *res = Logging::get_logging_target(dev_name);
    TANGO_LOG_DEBUG << "Leaving DServer::get_logging_target" << std::endl;
    return res;
}

//+----------------------------------------------------------------------------
//
// method : DServer::set_logging_level
//
//-----------------------------------------------------------------------------
void DServer::set_logging_level(const Tango::DevVarLongStringArray *argin)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::set_logging_level" << std::endl;
    Logging::set_logging_level(argin);
    TANGO_LOG_DEBUG << "Leaving DServer::set_logging_level" << std::endl;
}

//+----------------------------------------------------------------------------
//
// method : DServer::get_logging_level
//
//-----------------------------------------------------------------------------
DevVarLongStringArray *DServer::get_logging_level(const DevVarStringArray *argin)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::get_logging_level" << std::endl;
    DevVarLongStringArray *res = Logging::get_logging_level(argin);
    TANGO_LOG_DEBUG << "Leaving DServer::get_logging_level" << std::endl;
    return res;
}

//+----------------------------------------------------------------------------
//
// method : DServer::stop_logging
//
//-----------------------------------------------------------------------------
void DServer::stop_logging(void)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::stop_logging" << std::endl;
    Logging::stop_logging();
    TANGO_LOG_DEBUG << "Leaving DServer::stop_logging" << std::endl;
}

//+----------------------------------------------------------------------------
//
// method : DServer::start_logging
//
//-----------------------------------------------------------------------------
void DServer::start_logging(void)
{
    NoSyncModelTangoMonitor mon(this);
    TANGO_LOG_DEBUG << "Entering DServer::start_logging" << std::endl;
    Logging::start_logging();
    TANGO_LOG_DEBUG << "Leaving DServer::start_logging" << std::endl;
}

} // namespace Tango
