#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include <dolfin.h>

class Value3D: public Function
{
public:
  Value3D(const FunctionSpace & V, double xv, double yv, double zv):
    Function(V), xv(xv), yv(yv), zv(zv)
  {}
  
  void eval(double* values, const double* x) const
  {
    values[0] = xv;
    values[1] = yv;
    values[2] = zv;
  }

  double xv, yv, zv;
};

class Value: public Function
{
public:
  Value(const FunctionSpace & V, double value):
    Function(V), value(value)
  {}
  
  void eval(double* values, const double* x) const
  {
    values[0] = value;
  }

  double value;
};

class BoundaryPressure: public Function
{
public:
  BoundaryPressure(const FunctionSpace & V):
    Function(V)
  {}

  void eval(double* values, const double* x) const
  {
    values[0] = 0.0;
  }
};

/*
    const double dx = x[0] - 0.5;
    const double dy = x[1] - 0.5;
    const double dz = x[2] - 0.5;
*/

class BodyForce: public Function
{
public:
  BodyForce(const FunctionSpace & V):
    Function(V)
  {}

  void eval(double* values, const double* x) const
  {
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
  }
};

class Displacement: public Function
{
public:
  Displacement(const FunctionSpace & V):
    Function(V)
  {}

  void eval(double* values, const double* x) const
  {
    values[0] =  0.0;
    values[1] =  0.0;
    values[2] =  0.0;
  }
};

#endif
