/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <iostream>

#include "options.hh"
#include "global.hh"
#include "basic.hh"

void Toptions::show_short_help() {
	std::cout << _("Type \"swac-get --help\" for help.") << std::endl;
}


void Toptions::show_help() {
	std::cout << _("Usage : swac-get clear|upgrade|update") << std::endl;
	std::cout << _("        swac-get select|deselect <url|packid>") << std::endl;
	std::cout << _("        swac-get source-select|source-deselect|source-delete <url>") << std::endl;
	std::cout << _("        swac-get list|list-sources|list-available") << std::endl;
	std::cout << _("        swac-get sql <query>") << std::endl;
        std::cout << _("        swac-get [--help] [--version]") << std::endl  << std::endl;
	std::cout << _("Swac-get is a simple command line program which allows to download and install in a SQLite3") << std::endl;
	std::cout << _("database of audio collections of words (SWAC). For more information, please, visit the") << std::endl;
	std::cout << _("Shtooka Project homepage at: http://shtooka.net/.") << std::endl;
	std::cout << _("Commands :") << std::endl;
	std::cout << _("   clear                   clear database") << std::endl;
	std::cout << _("   deselect <url|packid>   delete records of the package <url|packid> from the database") << std::endl;
	std::cout << _("   list                    list installed packages") << std::endl;
	std::cout << _("   list-available          list available packages") << std::endl;
	std::cout << _("   list-sources            list source repositories") << std::endl;
	std::cout << _("   sql <query>             execute a sql query in the database") << std::endl;
	std::cout << _("   select <url|packid>     insert records of the package <url|packid> in the database") << std::endl;
	std::cout << _("                           ex: swac-get select file:///home/<my directory>/") << std::endl;
	std::cout << _("                               swac-get select http://packs.shtooka.net/<my directory>/ogg/") << std::endl;
	std::cout << _("                               swac-get select fra-balm-voc") << std::endl;
	std::cout << _("   source-delete <url>     delete <url> from the repositories list") << std::endl;
	std::cout << _("   source-deselect <url>   deselect <url> from the repositories list") << std::endl;
	std::cout << _("   source-select <url>     add <url> to the repositories list") << std::endl;
	std::cout << _("   update                  update the list of available packages") << std::endl;
	std::cout << _("   upgrade                 upgrade installed packages") << std::endl;
	std::cout << _("Options :") << std::endl;
	std::cout << _("   -t, --target <path>     set the SQLite3 database path") << std::endl; 
	std::cout << _("                               (default path is ~/.swac/swac.db)") << std::endl;
	std::cout << _("   -v, --version           print version information and exit") << std::endl;
	std::cout << _("   -h, --help              print this help and exit") << std::endl;
}

void Toptions::init() {
	//private
	cursor = 0;

	//options
	version = false;
	action = 0;
	target = "";
}

bool Toptions::next_arg() {
	if  (++cursor < argc) {
		current_arg = argv[cursor];
		return true;
	}
	print_error(std::string(_("Expected argument after")) + " \"" + current_arg + "\"");
	return false;
}


bool Toptions::parse_arg() {
	next_arg();

	if (current_arg == "--help" or current_arg == "-h") {
		help = true;
		return true;
	}

	if (current_arg == "--version" or current_arg == "-v") {
		version = true;
		return true;
	}

	if (current_arg == "--target" or current_arg == "-t") {
		if (!next_arg()) 
			return false;
		target = current_arg;
		return true;
	}

	if (current_arg == "update") {
		if (action != 0)
			return false;
		action = UPDATE;
		return true;
	}

	if (current_arg == "clear") {
		if (action != 0)
			return false;
		action = CLEAR;
		return true;
	}

	if (current_arg == "upgrade") {
		if (action != 0)
			return false;
		action = UPGRADE;
		return true;
	}

	if (current_arg == "list") {
		if (action != 0)
			return false;
		action = LIST;
		return true;
	}

	if (current_arg == "list-sources") {
		if (action != 0)
			return false;
		action = LIST_SOURCES;
		return true;
	}

	if (current_arg == "list-available") {
		if (action != 0)
			return false;
		action = LIST_AVAILABLE;
		return true;
	}

	if (current_arg == "select") {
		if (!next_arg() or action != 0) 
			return false;

		action = SELECT;
		action_arg = current_arg;
		return true;
	}

	if (current_arg == "deselect") {
		if (!next_arg() or action != 0) 
			return false;

		action = DESELECT;
		action_arg = current_arg;
		return true;
	}

	if (current_arg == "source-select") {
		if (!next_arg() or action != 0) 
			return false;

		action = SOURCE_SELECT;
		action_arg = current_arg;
		return true;
	}

	if (current_arg == "source-deselect") {
		if (!next_arg() or action != 0) 
			return false;

		action = SOURCE_DESELECT;
		action_arg = current_arg;
		return true;
	}

	if (current_arg == "source-delete") {
		if (!next_arg() or action != 0) 
			return false;

		action = SOURCE_DELETE;
		action_arg = current_arg;
		return true;
	}

	if (current_arg == "sql") {
		if (!next_arg() or action != 0) 
			return false;

		action = SQL;
		action_arg = current_arg;
		return true;
	}

	return false;
}

bool Toptions::parse(int _argc, char *_argv[]) {
	argc = _argc;
	argv = _argv;

	init();
	while (cursor + 1 < argc) {
		if (!parse_arg()) {
			print_error(std::string(_("Syntaxe error on:")) + " \"" + current_arg + "\""); 
			show_short_help();
			return false;
		}
	}
	return true;
}


