; RUN: llvm-as %s -o %t.bc
; RUN: llvm-spirv %t.bc -spirv-text -o - | FileCheck --check-prefix CHECK-SPIRV %s
; RUN: llvm-spirv %t.bc -o %t.spv
; RUN: spirv-val %t.spv

target triple = "spir64-unknown-unknown"

; CHECK-SPIRV-DAG: TypeInt [[#I8TYPE:]] 8
; CHECK-SPIRV-DAG: TypeInt [[#I32TYPE:]] 32
; CHECK-SPIRV-DAG: TypeInt [[#I16TYPE:]] 16
; CHECK-SPIRV-DAG: TypeInt [[#I64TYPE:]] 64
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_0:]] 0
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_1:]] 1
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_2:]] 2
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_3:]] 3
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_4:]] 4
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_5:]] 5
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_6:]] 6
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_7:]] 7
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_8:]] 8
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_9:]] 9
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_10:]] 10
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_11:]] 11
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_12:]] 12
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_13:]] 13
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_14:]] 14
; CHECK-SPIRV-DAG: Constant [[#I32TYPE]] [[#CONST_15:]] 15
; CHECK-SPIRV-DAG: TypeVector [[#V2XI8TYPE:]] [[#I8TYPE]] 2
; CHECK-SPIRV-DAG: TypeVector [[#V3XI8TYPE:]] [[#I8TYPE]] 3
; CHECK-SPIRV-DAG: TypeVector [[#V4XI8TYPE:]] [[#I8TYPE]] 4
; CHECK-SPIRV-DAG: TypeVector [[#V8XI8TYPE:]] [[#I8TYPE]] 8
; CHECK-SPIRV-DAG: TypeVector [[#V16XI8TYPE:]] [[#I8TYPE]] 16
; CHECK-SPIRV-DAG: TypeVector [[#V2XI16TYPE:]] [[#I16TYPE]] 2
; CHECK-SPIRV-DAG: TypeVector [[#V3XI16TYPE:]] [[#I16TYPE]] 3
; CHECK-SPIRV-DAG: TypeVector [[#V4XI16TYPE:]] [[#I16TYPE]] 4
; CHECK-SPIRV-DAG: TypeVector [[#V8XI16TYPE:]] [[#I16TYPE]] 8
; CHECK-SPIRV-DAG: TypeVector [[#V16XI16TYPE:]] [[#I16TYPE]] 16
; CHECK-SPIRV-DAG: TypeVector [[#V2XI32TYPE:]] [[#I32TYPE]] 2
; CHECK-SPIRV-DAG: TypeVector [[#V3XI32TYPE:]] [[#I32TYPE]] 3
; CHECK-SPIRV-DAG: TypeVector [[#V4XI32TYPE:]] [[#I32TYPE]] 4
; CHECK-SPIRV-DAG: TypeVector [[#V8XI32TYPE:]] [[#I32TYPE]] 8
; CHECK-SPIRV-DAG: TypeVector [[#V16XI32TYPE:]] [[#I32TYPE]] 16
; CHECK-SPIRV-DAG: TypeVector [[#V2XI64TYPE:]] [[#I64TYPE]] 2
; CHECK-SPIRV-DAG: TypeVector [[#V3XI64TYPE:]] [[#I64TYPE]] 3
; CHECK-SPIRV-DAG: TypeVector [[#V4XI64TYPE:]] [[#I64TYPE]] 4
; CHECK-SPIRV-DAG: TypeVector [[#V8XI64TYPE:]] [[#I64TYPE]] 8
; CHECK-SPIRV-DAG: TypeVector [[#V16XI64TYPE:]] [[#I64TYPE]] 16

; -------- I8 --------

; CHECK-SPIRV: FunctionParameter [[#V2XI8TYPE]] [[#VEC_V2XI8TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_0_V2XI8TYPE:]] [[#VEC_V2XI8TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_1_V2XI8TYPE:]] [[#VEC_V2XI8TYPE]] [[#CONST_1]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_0_V2XI8TYPE:]] [[#EXTRACT_0_V2XI8TYPE]] [[#EXTRACT_1_V2XI8TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_0_V2XI8TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V3XI8TYPE]] [[#VEC_V3XI8TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_0_V3XI8TYPE:]] [[#VEC_V3XI8TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_1_V3XI8TYPE:]] [[#VEC_V3XI8TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_2_V3XI8TYPE:]] [[#VEC_V3XI8TYPE]] [[#CONST_2]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_0_V3XI8TYPE:]] [[#EXTRACT_0_V3XI8TYPE]] [[#EXTRACT_1_V3XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_1_V3XI8TYPE:]] [[#XOR_0_V3XI8TYPE]] [[#EXTRACT_2_V3XI8TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_1_V3XI8TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V4XI8TYPE]] [[#VEC_V4XI8TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_0_V4XI8TYPE:]] [[#VEC_V4XI8TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_1_V4XI8TYPE:]] [[#VEC_V4XI8TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_2_V4XI8TYPE:]] [[#VEC_V4XI8TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_3_V4XI8TYPE:]] [[#VEC_V4XI8TYPE]] [[#CONST_3]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_0_V4XI8TYPE:]] [[#EXTRACT_0_V4XI8TYPE]] [[#EXTRACT_1_V4XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_1_V4XI8TYPE:]] [[#EXTRACT_2_V4XI8TYPE]] [[#EXTRACT_3_V4XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_2_V4XI8TYPE:]] [[#XOR_0_V4XI8TYPE]] [[#XOR_1_V4XI8TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_2_V4XI8TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V8XI8TYPE]] [[#VEC_V8XI8TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_0_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_1_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_2_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_3_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_4_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_5_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_6_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_7_V8XI8TYPE:]] [[#VEC_V8XI8TYPE]] [[#CONST_7]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_0_V8XI8TYPE:]] [[#EXTRACT_0_V8XI8TYPE]] [[#EXTRACT_1_V8XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_1_V8XI8TYPE:]] [[#EXTRACT_2_V8XI8TYPE]] [[#EXTRACT_3_V8XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_2_V8XI8TYPE:]] [[#EXTRACT_4_V8XI8TYPE]] [[#EXTRACT_5_V8XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_3_V8XI8TYPE:]] [[#EXTRACT_6_V8XI8TYPE]] [[#EXTRACT_7_V8XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_4_V8XI8TYPE:]] [[#XOR_0_V8XI8TYPE]] [[#XOR_1_V8XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_5_V8XI8TYPE:]] [[#XOR_2_V8XI8TYPE]] [[#XOR_3_V8XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_6_V8XI8TYPE:]] [[#XOR_4_V8XI8TYPE]] [[#XOR_5_V8XI8TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_6_V8XI8TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V16XI8TYPE]] [[#VEC_V16XI8TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_0_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_1_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_2_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_3_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_4_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_5_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_6_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_7_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_7]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_8_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_8]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_9_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_9]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_10_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_10]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_11_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_11]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_12_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_12]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_13_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_13]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_14_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_14]]
; CHECK-SPIRV: VectorExtractDynamic [[#I8TYPE]] [[#EXTRACT_15_V16XI8TYPE:]] [[#VEC_V16XI8TYPE]] [[#CONST_15]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_0_V16XI8TYPE:]] [[#EXTRACT_0_V16XI8TYPE]] [[#EXTRACT_1_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_1_V16XI8TYPE:]] [[#EXTRACT_2_V16XI8TYPE]] [[#EXTRACT_3_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_2_V16XI8TYPE:]] [[#EXTRACT_4_V16XI8TYPE]] [[#EXTRACT_5_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_3_V16XI8TYPE:]] [[#EXTRACT_6_V16XI8TYPE]] [[#EXTRACT_7_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_4_V16XI8TYPE:]] [[#EXTRACT_8_V16XI8TYPE]] [[#EXTRACT_9_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_5_V16XI8TYPE:]] [[#EXTRACT_10_V16XI8TYPE]] [[#EXTRACT_11_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_6_V16XI8TYPE:]] [[#EXTRACT_12_V16XI8TYPE]] [[#EXTRACT_13_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_7_V16XI8TYPE:]] [[#EXTRACT_14_V16XI8TYPE]] [[#EXTRACT_15_V16XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_8_V16XI8TYPE:]] [[#XOR_0_V16XI8TYPE]] [[#XOR_1_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_9_V16XI8TYPE:]] [[#XOR_2_V16XI8TYPE]] [[#XOR_3_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_10_V16XI8TYPE:]] [[#XOR_4_V16XI8TYPE]] [[#XOR_5_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_11_V16XI8TYPE:]] [[#XOR_6_V16XI8TYPE]] [[#XOR_7_V16XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_12_V16XI8TYPE:]] [[#XOR_8_V16XI8TYPE]] [[#XOR_9_V16XI8TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_13_V16XI8TYPE:]] [[#XOR_10_V16XI8TYPE]] [[#XOR_11_V16XI8TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I8TYPE]] [[#XOR_14_V16XI8TYPE:]] [[#XOR_12_V16XI8TYPE]] [[#XOR_13_V16XI8TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_14_V16XI8TYPE]]

; -------- I16 --------

; CHECK-SPIRV: FunctionParameter [[#V2XI16TYPE]] [[#VEC_V2XI16TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_0_V2XI16TYPE:]] [[#VEC_V2XI16TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_1_V2XI16TYPE:]] [[#VEC_V2XI16TYPE]] [[#CONST_1]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_0_V2XI16TYPE:]] [[#EXTRACT_0_V2XI16TYPE]] [[#EXTRACT_1_V2XI16TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_0_V2XI16TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V3XI16TYPE]] [[#VEC_V3XI16TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_0_V3XI16TYPE:]] [[#VEC_V3XI16TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_1_V3XI16TYPE:]] [[#VEC_V3XI16TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_2_V3XI16TYPE:]] [[#VEC_V3XI16TYPE]] [[#CONST_2]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_0_V3XI16TYPE:]] [[#EXTRACT_0_V3XI16TYPE]] [[#EXTRACT_1_V3XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_1_V3XI16TYPE:]] [[#XOR_0_V3XI16TYPE]] [[#EXTRACT_2_V3XI16TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_1_V3XI16TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V4XI16TYPE]] [[#VEC_V4XI16TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_0_V4XI16TYPE:]] [[#VEC_V4XI16TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_1_V4XI16TYPE:]] [[#VEC_V4XI16TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_2_V4XI16TYPE:]] [[#VEC_V4XI16TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_3_V4XI16TYPE:]] [[#VEC_V4XI16TYPE]] [[#CONST_3]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_0_V4XI16TYPE:]] [[#EXTRACT_0_V4XI16TYPE]] [[#EXTRACT_1_V4XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_1_V4XI16TYPE:]] [[#EXTRACT_2_V4XI16TYPE]] [[#EXTRACT_3_V4XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_2_V4XI16TYPE:]] [[#XOR_0_V4XI16TYPE]] [[#XOR_1_V4XI16TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_2_V4XI16TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V8XI16TYPE]] [[#VEC_V8XI16TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_0_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_1_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_2_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_3_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_4_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_5_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_6_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_7_V8XI16TYPE:]] [[#VEC_V8XI16TYPE]] [[#CONST_7]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_0_V8XI16TYPE:]] [[#EXTRACT_0_V8XI16TYPE]] [[#EXTRACT_1_V8XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_1_V8XI16TYPE:]] [[#EXTRACT_2_V8XI16TYPE]] [[#EXTRACT_3_V8XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_2_V8XI16TYPE:]] [[#EXTRACT_4_V8XI16TYPE]] [[#EXTRACT_5_V8XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_3_V8XI16TYPE:]] [[#EXTRACT_6_V8XI16TYPE]] [[#EXTRACT_7_V8XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_4_V8XI16TYPE:]] [[#XOR_0_V8XI16TYPE]] [[#XOR_1_V8XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_5_V8XI16TYPE:]] [[#XOR_2_V8XI16TYPE]] [[#XOR_3_V8XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_6_V8XI16TYPE:]] [[#XOR_4_V8XI16TYPE]] [[#XOR_5_V8XI16TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_6_V8XI16TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V16XI16TYPE]] [[#VEC_V16XI16TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_0_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_1_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_2_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_3_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_4_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_5_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_6_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_7_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_7]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_8_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_8]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_9_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_9]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_10_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_10]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_11_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_11]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_12_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_12]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_13_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_13]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_14_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_14]]
; CHECK-SPIRV: VectorExtractDynamic [[#I16TYPE]] [[#EXTRACT_15_V16XI16TYPE:]] [[#VEC_V16XI16TYPE]] [[#CONST_15]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_0_V16XI16TYPE:]] [[#EXTRACT_0_V16XI16TYPE]] [[#EXTRACT_1_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_1_V16XI16TYPE:]] [[#EXTRACT_2_V16XI16TYPE]] [[#EXTRACT_3_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_2_V16XI16TYPE:]] [[#EXTRACT_4_V16XI16TYPE]] [[#EXTRACT_5_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_3_V16XI16TYPE:]] [[#EXTRACT_6_V16XI16TYPE]] [[#EXTRACT_7_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_4_V16XI16TYPE:]] [[#EXTRACT_8_V16XI16TYPE]] [[#EXTRACT_9_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_5_V16XI16TYPE:]] [[#EXTRACT_10_V16XI16TYPE]] [[#EXTRACT_11_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_6_V16XI16TYPE:]] [[#EXTRACT_12_V16XI16TYPE]] [[#EXTRACT_13_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_7_V16XI16TYPE:]] [[#EXTRACT_14_V16XI16TYPE]] [[#EXTRACT_15_V16XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_8_V16XI16TYPE:]] [[#XOR_0_V16XI16TYPE]] [[#XOR_1_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_9_V16XI16TYPE:]] [[#XOR_2_V16XI16TYPE]] [[#XOR_3_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_10_V16XI16TYPE:]] [[#XOR_4_V16XI16TYPE]] [[#XOR_5_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_11_V16XI16TYPE:]] [[#XOR_6_V16XI16TYPE]] [[#XOR_7_V16XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_12_V16XI16TYPE:]] [[#XOR_8_V16XI16TYPE]] [[#XOR_9_V16XI16TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_13_V16XI16TYPE:]] [[#XOR_10_V16XI16TYPE]] [[#XOR_11_V16XI16TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I16TYPE]] [[#XOR_14_V16XI16TYPE:]] [[#XOR_12_V16XI16TYPE]] [[#XOR_13_V16XI16TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_14_V16XI16TYPE]]

; -------- I32 --------

; CHECK-SPIRV: FunctionParameter [[#V2XI32TYPE]] [[#VEC_V2XI32TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_0_V2XI32TYPE:]] [[#VEC_V2XI32TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_1_V2XI32TYPE:]] [[#VEC_V2XI32TYPE]] [[#CONST_1]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_0_V2XI32TYPE:]] [[#EXTRACT_0_V2XI32TYPE]] [[#EXTRACT_1_V2XI32TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_0_V2XI32TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V3XI32TYPE]] [[#VEC_V3XI32TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_0_V3XI32TYPE:]] [[#VEC_V3XI32TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_1_V3XI32TYPE:]] [[#VEC_V3XI32TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_2_V3XI32TYPE:]] [[#VEC_V3XI32TYPE]] [[#CONST_2]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_0_V3XI32TYPE:]] [[#EXTRACT_0_V3XI32TYPE]] [[#EXTRACT_1_V3XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_1_V3XI32TYPE:]] [[#XOR_0_V3XI32TYPE]] [[#EXTRACT_2_V3XI32TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_1_V3XI32TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V4XI32TYPE]] [[#VEC_V4XI32TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_0_V4XI32TYPE:]] [[#VEC_V4XI32TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_1_V4XI32TYPE:]] [[#VEC_V4XI32TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_2_V4XI32TYPE:]] [[#VEC_V4XI32TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_3_V4XI32TYPE:]] [[#VEC_V4XI32TYPE]] [[#CONST_3]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_0_V4XI32TYPE:]] [[#EXTRACT_0_V4XI32TYPE]] [[#EXTRACT_1_V4XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_1_V4XI32TYPE:]] [[#EXTRACT_2_V4XI32TYPE]] [[#EXTRACT_3_V4XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_2_V4XI32TYPE:]] [[#XOR_0_V4XI32TYPE]] [[#XOR_1_V4XI32TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_2_V4XI32TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V8XI32TYPE]] [[#VEC_V8XI32TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_0_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_1_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_2_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_3_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_4_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_5_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_6_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_7_V8XI32TYPE:]] [[#VEC_V8XI32TYPE]] [[#CONST_7]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_0_V8XI32TYPE:]] [[#EXTRACT_0_V8XI32TYPE]] [[#EXTRACT_1_V8XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_1_V8XI32TYPE:]] [[#EXTRACT_2_V8XI32TYPE]] [[#EXTRACT_3_V8XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_2_V8XI32TYPE:]] [[#EXTRACT_4_V8XI32TYPE]] [[#EXTRACT_5_V8XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_3_V8XI32TYPE:]] [[#EXTRACT_6_V8XI32TYPE]] [[#EXTRACT_7_V8XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_4_V8XI32TYPE:]] [[#XOR_0_V8XI32TYPE]] [[#XOR_1_V8XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_5_V8XI32TYPE:]] [[#XOR_2_V8XI32TYPE]] [[#XOR_3_V8XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_6_V8XI32TYPE:]] [[#XOR_4_V8XI32TYPE]] [[#XOR_5_V8XI32TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_6_V8XI32TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V16XI32TYPE]] [[#VEC_V16XI32TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_0_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_1_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_2_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_3_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_4_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_5_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_6_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_7_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_7]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_8_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_8]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_9_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_9]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_10_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_10]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_11_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_11]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_12_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_12]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_13_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_13]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_14_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_14]]
; CHECK-SPIRV: VectorExtractDynamic [[#I32TYPE]] [[#EXTRACT_15_V16XI32TYPE:]] [[#VEC_V16XI32TYPE]] [[#CONST_15]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_0_V16XI32TYPE:]] [[#EXTRACT_0_V16XI32TYPE]] [[#EXTRACT_1_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_1_V16XI32TYPE:]] [[#EXTRACT_2_V16XI32TYPE]] [[#EXTRACT_3_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_2_V16XI32TYPE:]] [[#EXTRACT_4_V16XI32TYPE]] [[#EXTRACT_5_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_3_V16XI32TYPE:]] [[#EXTRACT_6_V16XI32TYPE]] [[#EXTRACT_7_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_4_V16XI32TYPE:]] [[#EXTRACT_8_V16XI32TYPE]] [[#EXTRACT_9_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_5_V16XI32TYPE:]] [[#EXTRACT_10_V16XI32TYPE]] [[#EXTRACT_11_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_6_V16XI32TYPE:]] [[#EXTRACT_12_V16XI32TYPE]] [[#EXTRACT_13_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_7_V16XI32TYPE:]] [[#EXTRACT_14_V16XI32TYPE]] [[#EXTRACT_15_V16XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_8_V16XI32TYPE:]] [[#XOR_0_V16XI32TYPE]] [[#XOR_1_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_9_V16XI32TYPE:]] [[#XOR_2_V16XI32TYPE]] [[#XOR_3_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_10_V16XI32TYPE:]] [[#XOR_4_V16XI32TYPE]] [[#XOR_5_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_11_V16XI32TYPE:]] [[#XOR_6_V16XI32TYPE]] [[#XOR_7_V16XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_12_V16XI32TYPE:]] [[#XOR_8_V16XI32TYPE]] [[#XOR_9_V16XI32TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_13_V16XI32TYPE:]] [[#XOR_10_V16XI32TYPE]] [[#XOR_11_V16XI32TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I32TYPE]] [[#XOR_14_V16XI32TYPE:]] [[#XOR_12_V16XI32TYPE]] [[#XOR_13_V16XI32TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_14_V16XI32TYPE]]

; -------- I64 --------

; CHECK-SPIRV: FunctionParameter [[#V2XI64TYPE]] [[#VEC_V2XI64TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_0_V2XI64TYPE:]] [[#VEC_V2XI64TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_1_V2XI64TYPE:]] [[#VEC_V2XI64TYPE]] [[#CONST_1]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_0_V2XI64TYPE:]] [[#EXTRACT_0_V2XI64TYPE]] [[#EXTRACT_1_V2XI64TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_0_V2XI64TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V3XI64TYPE]] [[#VEC_V3XI64TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_0_V3XI64TYPE:]] [[#VEC_V3XI64TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_1_V3XI64TYPE:]] [[#VEC_V3XI64TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_2_V3XI64TYPE:]] [[#VEC_V3XI64TYPE]] [[#CONST_2]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_0_V3XI64TYPE:]] [[#EXTRACT_0_V3XI64TYPE]] [[#EXTRACT_1_V3XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_1_V3XI64TYPE:]] [[#XOR_0_V3XI64TYPE]] [[#EXTRACT_2_V3XI64TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_1_V3XI64TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V4XI64TYPE]] [[#VEC_V4XI64TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_0_V4XI64TYPE:]] [[#VEC_V4XI64TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_1_V4XI64TYPE:]] [[#VEC_V4XI64TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_2_V4XI64TYPE:]] [[#VEC_V4XI64TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_3_V4XI64TYPE:]] [[#VEC_V4XI64TYPE]] [[#CONST_3]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_0_V4XI64TYPE:]] [[#EXTRACT_0_V4XI64TYPE]] [[#EXTRACT_1_V4XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_1_V4XI64TYPE:]] [[#EXTRACT_2_V4XI64TYPE]] [[#EXTRACT_3_V4XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_2_V4XI64TYPE:]] [[#XOR_0_V4XI64TYPE]] [[#XOR_1_V4XI64TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_2_V4XI64TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V8XI64TYPE]] [[#VEC_V8XI64TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_0_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_1_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_2_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_3_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_4_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_5_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_6_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_7_V8XI64TYPE:]] [[#VEC_V8XI64TYPE]] [[#CONST_7]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_0_V8XI64TYPE:]] [[#EXTRACT_0_V8XI64TYPE]] [[#EXTRACT_1_V8XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_1_V8XI64TYPE:]] [[#EXTRACT_2_V8XI64TYPE]] [[#EXTRACT_3_V8XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_2_V8XI64TYPE:]] [[#EXTRACT_4_V8XI64TYPE]] [[#EXTRACT_5_V8XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_3_V8XI64TYPE:]] [[#EXTRACT_6_V8XI64TYPE]] [[#EXTRACT_7_V8XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_4_V8XI64TYPE:]] [[#XOR_0_V8XI64TYPE]] [[#XOR_1_V8XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_5_V8XI64TYPE:]] [[#XOR_2_V8XI64TYPE]] [[#XOR_3_V8XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_6_V8XI64TYPE:]] [[#XOR_4_V8XI64TYPE]] [[#XOR_5_V8XI64TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_6_V8XI64TYPE]]

; CHECK-SPIRV: FunctionParameter [[#V16XI64TYPE]] [[#VEC_V16XI64TYPE:]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_0_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_0]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_1_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_1]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_2_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_2]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_3_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_3]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_4_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_4]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_5_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_5]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_6_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_6]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_7_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_7]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_8_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_8]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_9_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_9]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_10_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_10]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_11_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_11]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_12_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_12]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_13_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_13]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_14_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_14]]
; CHECK-SPIRV: VectorExtractDynamic [[#I64TYPE]] [[#EXTRACT_15_V16XI64TYPE:]] [[#VEC_V16XI64TYPE]] [[#CONST_15]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_0_V16XI64TYPE:]] [[#EXTRACT_0_V16XI64TYPE]] [[#EXTRACT_1_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_1_V16XI64TYPE:]] [[#EXTRACT_2_V16XI64TYPE]] [[#EXTRACT_3_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_2_V16XI64TYPE:]] [[#EXTRACT_4_V16XI64TYPE]] [[#EXTRACT_5_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_3_V16XI64TYPE:]] [[#EXTRACT_6_V16XI64TYPE]] [[#EXTRACT_7_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_4_V16XI64TYPE:]] [[#EXTRACT_8_V16XI64TYPE]] [[#EXTRACT_9_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_5_V16XI64TYPE:]] [[#EXTRACT_10_V16XI64TYPE]] [[#EXTRACT_11_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_6_V16XI64TYPE:]] [[#EXTRACT_12_V16XI64TYPE]] [[#EXTRACT_13_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_7_V16XI64TYPE:]] [[#EXTRACT_14_V16XI64TYPE]] [[#EXTRACT_15_V16XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_8_V16XI64TYPE:]] [[#XOR_0_V16XI64TYPE]] [[#XOR_1_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_9_V16XI64TYPE:]] [[#XOR_2_V16XI64TYPE]] [[#XOR_3_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_10_V16XI64TYPE:]] [[#XOR_4_V16XI64TYPE]] [[#XOR_5_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_11_V16XI64TYPE:]] [[#XOR_6_V16XI64TYPE]] [[#XOR_7_V16XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_12_V16XI64TYPE:]] [[#XOR_8_V16XI64TYPE]] [[#XOR_9_V16XI64TYPE]]
; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_13_V16XI64TYPE:]] [[#XOR_10_V16XI64TYPE]] [[#XOR_11_V16XI64TYPE]]

; CHECK-SPIRV: BitwiseXor [[#I64TYPE]] [[#XOR_14_V16XI64TYPE:]] [[#XOR_12_V16XI64TYPE]] [[#XOR_13_V16XI64TYPE]]
; CHECK-SPIRV: ReturnValue [[#XOR_14_V16XI64TYPE]]

define spir_func i8 @test_vector_reduce_xor_v2i8(<2 x i8> %v) {
entry:
  %0 = call i8 @llvm.vector.reduce.xor.v2i8(<2 x i8> %v)
  ret i8 %0
}

define spir_func i8 @test_vector_reduce_xor_v3i8(<3 x i8> %v) {
entry:
  %0 = call i8 @llvm.vector.reduce.xor.v3i8(<3 x i8> %v)
  ret i8 %0
}

define spir_func i8 @test_vector_reduce_xor_v4i8(<4 x i8> %v) {
entry:
  %0 = call i8 @llvm.vector.reduce.xor.v4i8(<4 x i8> %v)
  ret i8 %0
}

define spir_func i8 @test_vector_reduce_xor_v8i8(<8 x i8> %v) {
entry:
  %0 = call i8 @llvm.vector.reduce.xor.v8i8(<8 x i8> %v)
  ret i8 %0
}

define spir_func i8 @test_vector_reduce_xor_v16i8(<16 x i8> %v) {
entry:
  %0 = call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %v)
  ret i8 %0
}

define spir_func i16 @test_vector_reduce_xor_v2i16(<2 x i16> %v) {
entry:
  %0 = call i16 @llvm.vector.reduce.xor.v2i16(<2 x i16> %v)
  ret i16 %0
}

define spir_func i16 @test_vector_reduce_xor_v3i16(<3 x i16> %v) {
entry:
  %0 = call i16 @llvm.vector.reduce.xor.v3i16(<3 x i16> %v)
  ret i16 %0
}

define spir_func i16 @test_vector_reduce_xor_v4i16(<4 x i16> %v) {
entry:
  %0 = call i16 @llvm.vector.reduce.xor.v4i16(<4 x i16> %v)
  ret i16 %0
}

define spir_func i16 @test_vector_reduce_xor_v8i16(<8 x i16> %v) {
entry:
  %0 = call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %v)
  ret i16 %0
}

define spir_func i16 @test_vector_reduce_xor_v16i16(<16 x i16> %v) {
entry:
  %0 = call i16 @llvm.vector.reduce.xor.v16i16(<16 x i16> %v)
  ret i16 %0
}


define spir_func i32 @test_vector_reduce_xor_v2i32(<2 x i32> %v) {
entry:
  %0 = call i32 @llvm.vector.reduce.xor.v2i32(<2 x i32> %v)
  ret i32 %0
}

define spir_func i32 @test_vector_reduce_xor_v3i32(<3 x i32> %v) {
entry:
  %0 = call i32 @llvm.vector.reduce.xor.v3i32(<3 x i32> %v)
  ret i32 %0
}

define spir_func i32 @test_vector_reduce_xor_v4i32(<4 x i32> %v) {
entry:
  %0 = call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %v)
  ret i32 %0
}

define spir_func i32 @test_vector_reduce_xor_v8i32(<8 x i32> %v) {
entry:
  %0 = call i32 @llvm.vector.reduce.xor.v8i32(<8 x i32> %v)
  ret i32 %0
}

define spir_func i32 @test_vector_reduce_xor_v16i32(<16 x i32> %v) {
entry:
  %0 = call i32 @llvm.vector.reduce.xor.v16i32(<16 x i32> %v)
  ret i32 %0
}

define spir_func i64 @test_vector_reduce_xor_v2i64(<2 x i64> %v) {
entry:
  %0 = call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %v)
  ret i64 %0
}

define spir_func i64 @test_vector_reduce_xor_v3i64(<3 x i64> %v) {
entry:
  %0 = call i64 @llvm.vector.reduce.xor.v3i64(<3 x i64> %v)
  ret i64 %0
}

define spir_func i64 @test_vector_reduce_xor_v4i64(<4 x i64> %v) {
entry:
  %0 = call i64 @llvm.vector.reduce.xor.v4i64(<4 x i64> %v)
  ret i64 %0
}

define spir_func i64 @test_vector_reduce_xor_v8i64(<8 x i64> %v) {
entry:
  %0 = call i64 @llvm.vector.reduce.xor.v8i64(<8 x i64> %v)
  ret i64 %0
}

define spir_func i64 @test_vector_reduce_xor_v16i64(<16 x i64> %v) {
entry:
  %0 = call i64 @llvm.vector.reduce.xor.v16i64(<16 x i64> %v)
  ret i64 %0
}

declare i8 @llvm.vector.reduce.xor.v2i8(<2 x i8>)
declare i8 @llvm.vector.reduce.xor.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.xor.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.xor.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.xor.v16i8(<16 x i8>)

declare i16 @llvm.vector.reduce.xor.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.xor.v3i16(<3 x i16>)
declare i16 @llvm.vector.reduce.xor.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.xor.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.xor.v16i16(<16 x i16>)

declare i32 @llvm.vector.reduce.xor.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.xor.v3i32(<3 x i32>)
declare i32 @llvm.vector.reduce.xor.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.xor.v8i32(<8 x i32>)
declare i32 @llvm.vector.reduce.xor.v16i32(<16 x i32>)

declare i64 @llvm.vector.reduce.xor.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.xor.v3i64(<3 x i64>)
declare i64 @llvm.vector.reduce.xor.v4i64(<4 x i64>)
declare i64 @llvm.vector.reduce.xor.v8i64(<8 x i64>)
declare i64 @llvm.vector.reduce.xor.v16i64(<16 x i64>)
