-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--  VCG
--
--  Purpose:
--
--  The main entry point of the VC-Generator.  Takes the Syntax-Tree, Dictionary,
--  LexTokenManager table and Flow Analyser Heap that have been previously
--  populated by the Sem and FlowAnalyser phases, and produces Verfication
--  Conditions or Path Functions for the given subprogram.
--
--  In many of the VCG Components, there are references to "JFB section x.y"
--  These are referring to
--   Jean Francois Bergeretti
--   "An Algebraic Approach to Program Analysis: Foundations of a Practical
--     Analysis System"
--   PhD Thesis
--   University of Southampton Department of Electronics, 1979
--
--  This document effectively serves as a mathematical specification of the
--  VC Generator.
--
--  For a copy of this document, please contact either the SPARK team at Praxis
--  (sparkinfo@praxis-his.com), or contract the University of Southampton.
--
--  Clients:
--
--  Sem.CompUnit
--
--  Use:
--
--  See Sem.Compunit
--
--  Extension:
--
--  None planned.
--------------------------------------------------------------------------------

with CommandLineData;
with Dictionary;
with Heap;
with LexTokenManager;
with STree;

use type CommandLineData.Rule_Generation_Policies;
use type Dictionary.Rule_Policies;
use type Dictionary.Scopes;

--# inherit Cells,
--#         Clists,
--#         CommandLineData,
--#         CStacks,
--#         DAG,
--#         Debug,
--#         Declarations,
--#         Dictionary,
--#         ErrorHandler,
--#         ExaminerConstants,
--#         E_Strings,
--#         FileSystem,
--#         File_Utils,
--#         Graph,
--#         Heap,
--#         Labels,
--#         LexTokenLists,
--#         LexTokenManager,
--#         Maths,
--#         Pairs,
--#         Pile,
--#         ScreenEcho,
--#         SeqAlgebra,
--#         SPARK_IO,
--#         SP_Symbols,
--#         Statistics,
--#         StmtStack,
--#         STree,
--#         Structures,
--#         SystemErrors;

package VCG
--# own Invoked : Boolean;
--# initializes Invoked;
is
   -- The "Invoked" flag is set when the VCG runs and actually generates any VCs.
   -- This is used in MainLoop to warn the user of the common error where a
   -- user runs the Examiner on a package specification expecting VCs to be
   -- generated, but doesn't get any VCs, or (worse) ends up with an old set
   -- of VCs left over from an earlier run.
   Invoked : Boolean := False;

   procedure Generate_VCs
     (Start_Node                    : in     STree.SyntaxNode;
      Scope                         : in     Dictionary.Scopes;
      Do_VCG                        : in     Boolean;
      End_Position                  : in     LexTokenManager.Token_Position;
      Flow_Heap                     : in out Heap.HeapRecord;
      Semantic_Error_In_Subprogram  : in     Boolean;
      Data_Flow_Error_In_Subprogram : in     Boolean;
      Type_Check_Exports            : in     Boolean);
   --# global in     CommandLineData.Content;
   --#        in     STree.Table;
   --#        in out Declarations.State;
   --#        in out Dictionary.Dict;
   --#        in out ErrorHandler.Error_Context;
   --#        in out Graph.Table;
   --#        in out Invoked;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --#        in out StmtStack.S;
   --# derives Declarations.State,
   --#         Dictionary.Dict,
   --#         ErrorHandler.Error_Context,
   --#         Flow_Heap,
   --#         Graph.Table,
   --#         LexTokenManager.State,
   --#         SPARK_IO.File_Sys,
   --#         Statistics.TableUsage,
   --#         StmtStack.S                from *,
   --#                                         CommandLineData.Content,
   --#                                         Data_Flow_Error_In_Subprogram,
   --#                                         Dictionary.Dict,
   --#                                         Do_VCG,
   --#                                         End_Position,
   --#                                         ErrorHandler.Error_Context,
   --#                                         Flow_Heap,
   --#                                         LexTokenManager.State,
   --#                                         Scope,
   --#                                         Semantic_Error_In_Subprogram,
   --#                                         SPARK_IO.File_Sys,
   --#                                         Start_Node,
   --#                                         STree.Table,
   --#                                         Type_Check_Exports &
   --#         Invoked                    from *,
   --#                                         Do_VCG;
end VCG;
