3.4 Échantillons enveloppés

# Échantillons enveloppés

Il est aussi possible de modifier la *durée* et l'*amplitude* d'un 
échantillon en utilisant une enveloppe ADSR. Toutefois, ceci fonctionne 
d'une manière légèrement différente de l'enveloppe ADSR applicable 
aux synthés. Les enveloppes d'échantillon permettent uniquement de 
réduire l'amplitude et la durée de l'échantillon - et jamais de les 
augmenter. Le jeu de l'échantillon s'arrêtera soit quand 
l'échantillon arrivera à sa fin, soit quand  la fin l'enveloppe sera 
atteinte. Donc si vous utilisez une phase de `release:` très longue, cela 
n'allongera pas la durée de l'échantillon.

## Des enveloppes pour Amen


Retournons à notre fidèle ami Amen :

```
sample :loop_amen
```

Sans paramètres, nous entendons la totalité de l'échantillon à son 
amplitude totale. Si nous voulons une attaque progressive, nous pouvons 
utiliser le paramètre `attack:` :

```
sample :loop_amen, attack: 1
```

Pour une attaque plus courte, choisissez une valeur `attack:` plus 
petite :

```
sample :loop_amen, attack: 0.3
```

## Soutien automatique ("Auto Sustain")

Où le comportement de l'enveloppe ADSR diffère de l'enveloppe standard 
des synthés est dans la valeur de *sustain*. Dans l'enveloppe standard 
des synthés, la valeur par défaut du soutien est 0 à moins que vous ne
la fixiez manuellement. Avec les échantillons, la valeur par défaut du 
soutien est une valeur *auto-magique* - le temps qu'il reste pour finir 
l'échantillon. C'est pour cela que nous entendons l'échantillon en 
entier quand une valeur n'est pas spécifiée. Si les valeurs de 
l'attaque, du déclin, du soutien et de l'extinction sont toutes à 0, 
nous n'entendrons pas le moindre gazouillis.  Donc, de la longueur 
de l'échantillon, Sonic Pi déduit les éventuelles durées d'attaque, de 
déclin et d'extinction et utilise le résultat pour votre durée de soutien. 
Si la somme des durées d'attaque, de déclin et d'extinction est 
supérieure à la durée de l'échantillon, le soutien est simplement 
fixé à 0.

## Extinctions progressives

Pour explorer ceci, regardons notre Amen de manière plus détaillée. 
Si nous demandons à Sonic Pi quelle est la longueur de l'échantillon :

```
print sample_duration :loop_amen
```

Il affichera `1.753310657596372`, ce qui est la longueur de 
l'échantillon en secondes. Arrondissons-le ici à `1.75` par 
commodité. Maintenant si nous fixons l'extinction à `0.75`, quelque 
chose de surprenant va se passer :

```
sample :loop_amen, release: 0.75
```

La première seconde de l'échantillon va être jouée à l'amplitude 
totale avant de s'estomper progressivement sur une durée de 0.75 
secondes. C'est l'*auto-soutien* en action. Par défaut, la phase 
d'extinction fonctionne de manière à s'achever à la fin de 
l'échantillon. Si notre échantillon avait 10.75 secondes de longueur, 
il serait joué 10 seconde à l'amplitude totale avant de s'estomper 
progressivement pendant 0.75 secondes.

Rappelez-vous : par défaut,  la phase `release:` amène à l'extinction 
complète à la fin de l'échantillon.

## Attaque et extinction preogressive

On peut utiliser à la fois les paramètres `attack:` et `release:` 
ensemble grâce au comportement du soutien automatique pour des attaques 
et des extinctions progressives :

```
sample :loop_amen, attack: 0.75, release: 0.75
```

Comme la durée totale de l'échantillon est de 1.75 s et que la somme 
des phases d'attaque et d'extinction fait 1.5 s, le soutien est 
automatiquement ajusté à 0.25 s. Ceci nous permet de programmer 
facilement une attaque et une extinction progressives de l'échantillon.

## Soutien explicite

Nous pouvons facilement revenir au comportement normal de l'enveloppe 
ADSR des synthés en fixant manuellement `sustain:` à une valeur comme 0 :

```
sample :loop_amen, sustain: 0, release: 0.75
```

Maintenant, notre échantillon n'est joué que pendant 0.75 s au total. 
Avec les valeurs 0 par défaut pour `attack:` et `decay:` , 
l'échantillon monte directement à l'amplitude totale, se maintient là 
pendant 0 s et redescend progressivement à l'amplitude 0 pendant une 
durée de 0.75 s.

## Cymbales percussives

Nous pouvons utiliser ce comportement pour obtenir de bons effets en 
transformant un échantillon qui sonne longtemps en versions plus 
percussives. Intéressons-nous à l'échantillon `:drum_cymbal_open`:

```
sample :drum_cymbal_open
```

Vous pouvez entendre la cymbale sonnant pendant une certaine durée. 
Toutefois, nous pouvons utiliser notre enveloppe pour la rendre plus 
percussive :

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0, release: 0.1
```

Vous pouvez émuler la frappe de la cymbale suivie d'un étouffement en 
augmentant la phase de soutien :

```
sample :drum_cymbal_open, attack: 0.01, sustain: 0.3, release: 0.1
```

Maintenant allez et prenez plaisir à mettre des enveloppes sur vos 
échantillons. Essayez aussi de changer la vitesse pour des résultats 
vraiment intéressants.
