1.1 Codage en 'live'

# Codage en "Live"

Un des aspects les plus passionnants de Sonic Pi est qu'il vous permet
d'écrire et de *modifier du code en "live"* pour faire de la musique, juste
comme si vous jouiez de la guitare. Cela veut dire qu'au moyen de quelque
expérience, vous pouvez prendre Sonic PI sur scène et jouez avec.

## Libérez vos méninges

Avant que vous ne plongiez dans les détails réels du fonctionnement de Sonic
Pi dans la suite de ce tutoriel, j'aimerais vous faire part d'une expérience
montrant à quoi ressemble le code en "live". Ne vous inquiétez pas si vous
ne comprenez pas beaucoup ou rien de ceci. Essayez juste de rester assis
sur votre siège et de profiter...

## Une boucle en "live"

Démarrons, copiez le code suivant dans un "buffer" 
libre :

```
live_loop :flibble do
  sample :bd_haus, rate: 1
  sleep 0.5
end
```

Maintenant, pressez le bouton `Run` et vous entendrez un joli battement de
grosse caisse. Si vous souhaitez arrêter le son à un moment quelconque,
pressez simplement le bouton `Stop`. Plutôt, ne le pressez pas encore...
A la place, suivez les étapes suivantes :

1. Assurez-vous que le son de la grosse caisse est encore présent
2. Changez la valeur de `sleep` de `0.5` à quelque chose plus élevé comme `1`
3. Pressez à nouveau le bouton `Run`
4. Remarquez le changement de vitesse de la batterie
5. Finalement, *rappelez-vous de cet instant*, c'est la première fois que
   vous avez codé en "live" avec Sonic Pi et ce n'est certainement pas la
   dernière...

Ok, c'était assez simple. Ajoutons quelque chose au mixage. Au dessus de
`sample :bd_haus` ajoutez la ligne `sample :ambi_choir, rate: 0.3`. Votre
code devrait ressembler à ceci :


```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
  sample :bd_haus, rate: 1
  sleep 1
end
```

Maintenant, exécutez-le. Changez les "rates" - Que se passe-t-il lorsque
vous utilisez des valeurs élevées ou des valeurs négatives ? Regardez ce
qui se passe quand vous changez légèrement la valeur de `rate:` pour
l'échantillon `:ambi_choir` (disons 0.29). Que se passe-t-il lorsque vous
choisissez une valeur véritablement petite de `sleep` ? Regardez si vous
arrivez à le faire aller si vite au point que votre ordinateur s'arrêtera
avec une erreur parce que ne pouvant plus continuer comme cela (si cela arrive,
choisissez juste une durée `sleep` plus grande et pressez `Run` à nouveau).

Essayez de commenter une des lignes `sample` en ajoutant un `#` au début :

```
live_loop :flibble do
  sample :ambi_choir, rate: 0.3
#  sample :bd_haus, rate: 1
  sleep 1
end

```

Remarquez comment cela indique à l'ordinateur de l'ignorer, ainsi nous ne
l'entendons pas. On l'appelle commentaire. Dans Sonic Pi, nous pouvons
utilisez des commentaires pour enlever ou additionner des choses au mixage.

Finalement, je vous laisse avec quelque chose de sympa à jouer. Prenez le code
ci-dessous et copiez-le dans un autre "buffer". Maintenant essayez de le
comprendre bien plus que de voir qu'il y a deux boucles - ainsi deux choses
marchent en même temps. Maintenant, faites ce que vous faites le mieux 
- expérimenter et jouez. Voici quelques suggestions :

* Essayez de modifier les valeurs en bleu du `rate:` pour entendre changer
  le son de l'échantillon.
* Essayez de changer les durées de `sleep` et découvrez que les 2 boucles
  peuvent tourner à différentes cadences.
* Essayez de décommenter la ligne "sample" (enlevez le `#`) et apprécier
  le son de la guitare joué en fond.
* Essayez de changer une des valeurs en bleu de `mix:` avec des nombres
  entre `0` (pas dans le mixage) et `1` (entièrement dans le mixage).


Rappelez-vous de presser `Run` et vous entendrez le changement la fois
suivante où la boucle tournera. Si vous êtes dans le pétrin, ne vous
inquiétez pas - pressez `Stop`, effacez le code dans le "buffer",
collez une copie originale et vous serez prêt à improviser à nouveau.
En faisant des fautes, c'est ainsi que vous apprendrez le plus vite...


```
live_loop :guit do
  with_fx :echo, mix: 0.3, phase: 0.25 do
    sample :guit_em9, rate: 0.5
  end
#  sample :guit_em9, rate: -0.5
  sleep 8
end

live_loop :boom do
  with_fx :reverb, room: 1 do
    sample :bd_boom, amp: 10, rate: 1
  end
  sleep 8
end
```

Maintenant, continuez à jouer et à expérimenter jusqu'à ce que votre
curiosité sur comment ça fonctionne s'avive réellement et vous commencerez
à vous demander quoi d'autre puis-je faire avec ceci. Vous êtes maintenant
prêt à lire le reste du tutoriel.

Aussi, qu'attendez-vous...
