#ifndef NORMALIZATION_RULE_H_
#define NORMALIZATION_RULE_H_
#include <cstdio>
namespace sentencepiece {
namespace {

struct BinaryBlob {
 const char *name;
 size_t size;
 const char *data;
};

#if defined(_WIN32) && !defined(__CYGWIN__)
constexpr unsigned long long int kNormalizationRules_blob_uint64[] = {
0x0000FC000002B400, 0x0003243D00031C3E, 0x0002E4CC00032C3C, 0x8000228800000DB8, 0x000005B80002DCCC, 0x0002E4CC8000227C, 0x8000228C00001DB8, 0x000248CC00010D91, 
0x00014D8C000038CD, 0x8000099F8000099C, 0x0000BD8800015D8F, 0x0001598A0000AD89, 0x0000C984800009A2, 0x0000D98680001D3E, 0x000035800000A187, 0x0000258200003D81, 
0x0000E5800000DD83, 0x80001D3600000D81, 0x80001D4E00001D83, 0x0000FD8080001D46, 0x800009A500001581, 0x80000A4100003189, 0x80000A4780001D66, 0x80001D7680001D5E, 
0x0000758180001D6E, 0x0000718300006980, 0x000169A880000C87, 0x0000758080000BDF, 0x00005D8900006981, 0x00003D84000169A5, 0x00000584800009A8, 0x80001D2E80000BD9, 
0x800009AB000181A3, 0x80000C1800000D81, 0x80000C2A80000BA9, 0x001184790011D07A, 0x0011407700100478, 0x0013F87500103076, 0x001358730013A474, 0x80000C3000131C72, 
0x000DF06F0012EC70, 0x000C8C6D000C8C6E, 0x000C006B000CDC6C, 0x000FA069000C646A, 0x000F0467000FF868, 0x000E6865000F6466, 0x0009EC6300099464, 0x0008D0610009D062, 
0x0000058280001D26, 0x80001D7E80001D56, 0x0000198680001ABE, 0x000B48590008EC5A, 0x000B0057000B1858, 0x000AF85500054C56, 0x0005305300043454, 0x80000A4D00050052, 
0x0007004F0005DC50, 0x0007904D00076C4E, 0x0006084B0007D44C, 0x000140490001C84A, 0x0001F0470001E448, 0x0000A04500003446, 0x0000D84300009C44, 0x0002F0410000C842, 
0x0002498180001AC6, 0x0003F58700024180, 0x80001ACE000218CC, 0x000258CC80001AD6, 0x80000A53000248CD, 0x80000A5F80000A59, 0x000130CC80000A65, 0x00000581000134CD, 
0x00045CCC80001ADE, 0x00006D8200006581, 0x000071810001C4CC, 0x80000A6B80001AE6, 0x80001AEE00007587, 0x80001B0680001AFE, 0x00005D8C80001AF6, 0x00046CCC800009B4, 
0x00001D83000364CD, 0x00001D81800009B7, 0x80001DA600001D80, 0x000089A380001D9E, 0x80001DAE80001DB6, 0x0000098980001D96, 0x80001B1680001B0E, 0x80000A7D80000A77, 
0x00005180800009BD, 0x0000658000005181, 0x0000C5B100007D81, 0x0000298280001D8E, 0x000208CC000401A7, 0x80000C3680000A89, 0x80001DBE80000C3C, 0x000005860001E187, 
0x0000298180001B2E, 0x000570CC80000A83, 0x80001B2680001B1E, 0x00016D8080001B36, 0x000544CC00019981, 0x80000C0C000220CD, 0x80000A8F0002ACCC, 0x80000A9580001B3E, 
0x026550EF028B78F0, 0x80000BEB80000A9B, 0x80000AA780000AA1, 0x80001B46026400EA, 0x80000C7E80001B56, 0x0001F0CD80001B4E, 0x024870E30001ECCC, 0x002858E1023874E2, 
0x000144CC0027ECE0, 0x0007358200015CCD, 0x002430DB80001B5E, 0x002494D980001B66, 0x800009C000240CD8, 0x0004A8CC002540D6, 0x0024D0D3000564CD, 0x002534D1800009C3, 
0x0021C0CF002334D0, 0x0016C8CD0019DCCE, 0x001714CB800009C6, 0x80000AB3001788CA, 0x0017FCC700013CCC, 0x0014BCC5001284C6, 0x0014E8C3001464C4, 0x80000AB90015E4C2, 
0x00065587000104CC, 0x0006B18700003D84, 0x000695810006B986, 0x0006BD8300066180, 0x800009BA00003D82, 0x0006C18F0006C18C, 0x0006E5890006758C, 0x80000A7100068988, 
0x80001D8680000ABF, 0x0007298C80000C8D, 0x0006BD9180000ACB, 0x0007058800071D8C, 0x00074981800009C9, 0x0000ED8100073D87, 0x0007218200075D82, 0x00073D8700074184, 
0x0006E5A700074586, 0x0000CDA780001B76, 0x0006F1A380001DC6, 0x0000D9A380000BAF, 0x0007ADAD80000C42, 0x0006C1AD80000C48, 0x80000AC580001DCE, 0x80001B6E0007B1A8, 
0x000755AE80000AD1, 0x0007698080001B7E, 0x80000BF100077981, 0x0006B5B10007C5B0, 0x80000AD780001B86, 0x0003ACCC000769A7, 0x80001B8E000214CD, 0x0007B5A7000791A3, 
0x0006A18000003981, 0x0006C5820006B181, 0x0006E9840006D583, 0x0001258680000ADD, 0x00017D8800015187, 0x000278CC0001A989, 0x0001A58C00024CCD, 0x80001B9680000AE9, 
0x000185810001A18F, 0x000005840001E191, 0x80000AE380001B9E, 0x80001BAE00004181, 0x0000558C80001BA6, 0x000294CC00007181, 0x0000F5A30002E0CD, 0x80001BB60001A58C, 
0x000171B180001BBE, 0x0000F18180001BC6, 0x80000C12000121A3, 0x000198CC0000C9B1, 0x000111A800024CCD, 0x800009CC80000AEF, 0x80000AFB80001BCE, 0x80000AF580001BD6, 
0x000179B080001BE6, 0x000115A380001BDE, 0x0000418000009DA7, 0x000139A700007181, 0x00009D870000E5A3, 0x0005D4CD0000BDAD, 0x0001A4CC0005D0CC, 0x000081810000BCCD, 
0x00039180800009CF, 0x000150CC0003A181, 0x0000FD910003A583, 0x0000818400002981, 0x800009D20003B187, 0x80001DE680001DEE, 0x0003818C80001DFE, 0x000E219B80001DF6, 
0x80000C9980001BEE, 0x000E5987000E4D84, 0x000071810000C586, 0x000E59830003A980, 0x80001BF6000C0182, 0x00008D8F0000858C, 0x0000C9890000DD84, 0x0000C58B000E6188, 
0x80001C0680001BFE, 0x80000B0A0000B189, 0x0000B580000339A3, 0x80000CA50000BD81, 0x00008580000325A7, 0x000CE4CC00008D81, 0x80000C9300008183, 0x80001DDE000309AD, 
0x0001F58280000B10, 0x00018984000301B1, 0x000051810000AD88, 0x000EF9A30000A980, 0x80000BB5800009B1, 0x0000D58180000C4E, 0x80001E1680000C54, 0x00019D81000ED1A8, 
0x00009D840000BD84, 0x0007C0CC00002D89, 0x00079CCC0007C4CD, 0x80001E0E0007D4CD, 0x0001D18080001E26, 0x80001E1E00003D81, 0x80001E2E00003183, 0x0000218180001E06, 
0x80000BFD0001CD80, 0x0002B58000002181, 0x000210CC00016D81, 0x0000F1870003A8CD, 0x00001D8100002587, 0x000104CD80001C0E, 0x0007A0CC000100CC, 0x80001C16000794CC, 
0x0002E4CD80000B19, 0x80001C1E000D84CC, 0x80000B25000FA181, 0x80000C6080000C5A, 0x80000B1F80001C2E, 0x80001C4E80001C36, 0x000DF4CC00009DA3, 0x80000B3100023CCD, 
0x0000058780001C3E, 0x0000058780001C56, 0x000FA18880001C5E, 0x000C20CC80000C72, 0x80001C6680000B37, 0x80001C6E80000B49, 0x80000B4380000C78, 0x80001C7680001C7E, 
0x800009D8000F9581, 0x80000B04000F7981, 0x80000C9F800009DE, 0x80000B9A800009DB, 0x80001DD6000F9587, 0x80001C2680000BF7, 0x000FA18C80000B2B, 0x80001C4680000B3D, 
0x00006D81000FA98F, 0x800009E1000FDD91, 0x000FB187000FF582, 0x000FE587800009E4, 0x000368CC80000B4F, 0x80001C9E00031CCD, 0x80001CA680000B55, 0x80000B5B0000418C, 
0x800009E7000F998C, 0x000F71B100002D84, 0x000031810000A5A3, 0x80000BD300000D80, 0x80000BC7000F3DA7, 0x80000BC10000098C, 0x0000298080000BCD, 0x80001E3E00001581, 
0x000F29A380000B61, 0x0000F1A3000F61B1, 0x000F21A780000B67, 0x000F05A7000F39A6, 0x80000BBB000F09A6, 0x80000C6C80000C66, 0x80001E4E80000BA3, 0x000F0DAD80001E46, 
0x0001558280001E5E, 0x0001058000015983, 0x0001698600014581, 0x0001758480001E56, 0x00019D8A80001E66, 0x0001A9880001E98B, 0x80001E3600019589, 0x0001D98C0001D18F, 
0x0001B18080001C86, 0x80000B6D0001B181, 0x0001A5810001A591, 0x0001A5830001A580, 0x80001C8E80001C96, 0x000DF8CD0001899B, 0x00006589000DCCCC, 0x000175800000FDA3, 
0x80001CAE00013581, 0x80001CB60000B5A3, 0x000194CC80001CBE, 0x0000A5A4000254CD, 0x80000B7380001CC6, 0x0000E1A880001CD6, 0x80001CDE80001CCE, 0x80001CE6000264CC, 
0x00004D800000E1AD, 0x0000A9B000005981, 0x80001CEE00007587, 0x0000C5A380001E6E, 0x0001D0CC800009EA, 0x80000B790001A4CD, 0x0000218880001E86, 0x80000CAB00007583, 
0x00039D8180001CF6, 0x80000B7F00038980, 0x000019880003AD82, 0x0003BD8700000989, 0x0003D98480001E7E, 0x80001E7600038988, 0x0003E5800003D187, 0x0003D1820003E981, 
0x000395800003D183, 0x00022CCC00039981, 0x80000B820002C8CD, 0x80001CFE00003D8C, 0x00003181800009D5, 0x80000B8E80000B88, 0x80001D0600003582, 0x00001D8780001D0E, 
0x0000D181800009ED, 0x000339A300007184, 0x00005189800009F0, 0x000400CC0001DD81, 0x0000D5B10003CCCD, 0x80001D3A80001D42, 0x0000198180001D52, 0x0000158300001180, 
0x80001D4A000095A3, 0x00006D80800009F6, 0x00003D8300006581, 0x00003D8180000A44, 0x80001D6A00003D80, 0x000099A380001D62, 0x80001D7280001D7A, 0x0000098980000BE2, 
0x0001FD8480000BDC, 0x000EDCCC000ED8CC, 0x000FD8CC80001D32, 0x000E08CC000FCCCC, 0x000F28CC000E58CC, 0x000E08CC000F58CC, 0x000FDCCC000E10CD, 0x000FECCC000F24CD, 
0x0001A180000FE8CD, 0x80000C1B0001A181, 0x00012D8080000BAC, 0x80000C2D0001D981, 0x80000C33000EACCC, 0x000E90CD00001582, 0x80001D5A000E94CC, 0x0000F18700000986, 
0x80001AC280001D82, 0x80001ACA80000A50, 0x80001ADA80001AD2, 0x80000A560002F0CC, 0x000031B180000A5C, 0x000268CD80000A62, 0x000124CC0005E8CC, 0x80000A68000104CD, 
0x00007D8180001AE2, 0x000580CC00005D81, 0x0007218280001AEA, 0x000098CD80000A6E, 0x80001AF2000088CC, 0x000065A380001B02, 0x80001AFA80001B0A, 0x0007018680000A02, 
0x800009F380000A05, 0x80000A4A80001DAA, 0x80000C8A00078DA5, 0x800009F9000009A3, 0x800009FC80001D2A, 0x800009FF80001DA2, 0x000334CC80001DBA, 0x0007BDA800037CCD, 
0x0007D98180000A08, 0x80001DB200000D89, 0x80001D9A0007D182, 0x0007FD8700079987, 0x0000658080000A74, 0x80001B1200004181, 0x80001B1A00004183, 0x0007AD8C0007CD8C, 
0x0000898680000A7A, 0x00065D8400009587, 0x0000918200077DB1, 0x0006E58000065183, 0x80000A8000061181, 0x0007E58C0007FD8F, 0x0000918A80000A0B, 0x0000A18880001D92, 
0x80000A8C0007B189, 0x0000CD80000725A3, 0x80000C390000E981, 0x0000F1A7000731A7, 0x000089800007BD91, 0x80000C3F00009581, 0x80001DC280001D8A, 0x80001B3280000C90, 
0x0006FD81000711AD, 0x000159830006F180, 0x80000A8600013182, 0x0001B98700014984, 0x0001958900016186, 0x80001B2200018988, 0x000210CC80001B2A, 0x0001E98F0001F58C, 
0x0001A99100007987, 0x0006BD8080001B3A, 0x0002C4CD0006B181, 0x80000C0F000238CC, 0x80000A920000D98C, 0x0000318100000582, 0x0000F18780001B42, 0x80000A9800000D86, 
0x80000A9E00001184, 0x000165A380000BEE, 0x0000C98180000AA4, 0x00016DA7000198CC, 0x80001B4A80000AAA, 0x80001B5A0000B5A8, 0x000099AD80000C81, 0x80001B6280001B52, 
0x80001D1680001B6A, 0x000184CC0000E9B0, 0x80000A0E0001FCCD, 0x80000A1480000A11, 0x80000ABC80000AB6, 0x80000A1780000AC2, 0x00007DA700001981, 0x80001DCA80001B7A, 
0x00028CCC80000BB2, 0x00001D9100039982, 0x0003B18780000C45, 0x80001DD280000C4B, 0x80001B7280000AC8, 0x80000C0980000AD4, 0x0003E18000038588, 0x80001B820003E181, 
0x00039D830003918C, 0x00039D8100039D82, 0x80000BF400039D80, 0x80001B8A0003B186, 0x00032CCC0003BD84, 0x000391890002F4CD, 0x00007D8F00038588, 0x80001B9280000ADA, 
0x000335A30003818C, 0x80000AE00000A182, 0x000329A70000ADB0, 0x000031840000AD81, 0x0003F4CC80000AEC, 0x80001BA200026CCD, 0x80001BB280000AE6, 0x80001BAA000309AE, 
0x0000D9A30000958C, 0x000309B180001BBA, 0x80001BC200004581, 0x000130CC80001BCA, 0x00002581000134CD, 0x80000AF280000C15, 0x000214CD0000F1A8, 0x001CF8CC0003B4CC, 
0x0001E5800003FCCD, 0x0001C0CD0001ED81, 0x000780CC00016CCC, 0x0006DCCC000784CD, 0x0007B4CC0006D8CD, 0x000638CC80000A1D, 0x000784CC000640CC, 0x0007E4CC0007FCCD, 
0x80001BD200067CCD, 0x0001718100018181, 0x0001D98180000AFE, 0x80000AF880001BDA, 0x80001BEA00018D87, 0x000188CD0001F98C, 0x80001BE200018CCC, 0x80000A2380000A20, 
0x001DCCCC00012D8C, 0x0001F1B1001D5CCD, 0x000129B180001DF2, 0x0000158000003183, 0x80001DEA00003D81, 0x80001DFA80001E02, 0x00003D8080001BF2, 0x80000C9C00001581, 
0x000199A300001589, 0x000165A7000624CC, 0x0001A5A7000119A3, 0x001C01A380001BFA, 0x000151AD000604CC, 0x0000458180001C02, 0x0000158080001C0A, 0x80000B0D00001981, 
0x001EE58080000CA8, 0x00007191001EED81, 0x80000A26001F2983, 0x80000A29001FE984, 0x0000A59B001F5D87, 0x80000CA280000B07, 0x001F7D8C80000A2C, 0x80000C9600000D84, 
0x0000598380001DE2, 0x001F318100005582, 0x00007987001F3980, 0x80000B13001FAD86, 0x0000398B00007984, 0x0000558980000BB8, 0x0000058F00004188, 0x80000C5780000C51, 
0x001F2D810000198C, 0x80001E1A80000B9D, 0x80001E12001FD9A3, 0x80001E2A001F2D84, 0x80001E22001FC5A7, 0x80001E32001F7188, 0x80001E0A80001DDA, 0x00003180001FD5AD, 
0x00006DA300002D81, 0x00007982001FB5B1, 0x80000C0080000BFA, 0x001FAD8000000584, 0x0003ECCC001FA581, 0x001C60CC000218CD, 0x80001C12000021A8, 0x0000098180001C1A, 
0x0001898080000B1C, 0x0001F98100019581, 0x0001E58700019583, 0x000248CC00002591, 0x80001C22000250CD, 0x80000B2800018589, 0x80000C6380000C5D, 0x0000058480001C2A, 
0x80000B2280001C32, 0x0001B58180001C3A, 0x0000D98C00006D87, 0x000238CC0001A981, 0x0000498C0002E8CD, 0x0000E98200001581, 0x80000B2E0000418F, 0x80001C5200000D87, 
0x80000B340000F987, 0x80000B4080001C42, 0x00000987000125A3, 0x80001C5A0000D1B1, 0x0000058780001C4A, 0x80000C7580001C62, 0x0000C18180000B3A, 0x0001A4CC80001C6A, 
0x80000B4C80001D1A, 0x80000C7B80001C72, 0x80000B4600008DA7, 0x80001C7A80001C82, 0x0001BCCC0000E9A3, 0x80000A2F0000DCCD, 0x80000A32000071A3, 0x000051A680000A35, 
0x0003B587000051A7, 0x0000058100012CCC, 0x0000058880001CA2, 0x0000CD9180001CAA, 0x80000BD680000B5E, 0x000390CC000328CC, 0x0006219B0003ED8C, 0x80000BC480000BCA, 
0x000128CC00038188, 0x80000BD000005986, 0x0004018300064D84, 0x0003A9810003A182, 0x0000A98F0003B580, 0x0001918180001E42, 0x0000C18B0000D18C, 0x00001D890000ED8A, 
0x000351A700067588, 0x0000BD8100034DA6, 0x000355A30000AD80, 0x80000B640000DD8C, 0x000095810001ADB0, 0x00037DAD00008580, 0x80000B6A000110CC, 0x000134CC00008D84, 
0x00001D8080000BBE, 0x80000C6900002581, 0x000025A3000035A4, 0x000301B180000C6F, 0x80001E4A80001E52, 0x0001E1AD80001E62, 0x80001E6A80001E5A, 0x80001C8A80001E3A, 
0x000035830001F9A8, 0x80001C9A80000B70, 0x001EE0CD0007C581, 0x00011CCC001EE4CC, 0x001EB8CC000138CC, 0x0001ACCC001E94CD, 0x80001C92001EC0CD, 0x0002D18080001CB2, 
0x80001CBA0002CD81, 0x000195800001A183, 0x000574CC0001AD81, 0x80001CC20002D8CD, 0x00079D8180001CCA, 0x00067D8180000B76, 0x80001CDA00018189, 0x80001D1E80001CD2, 
0x0000C1A380001CE2, 0x0000D58180001CEA, 0x80001CF20000D580, 0x0000098880001E72, 0x80000A3B00015CCC, 0x000244CD00002187, 0x000108CD0005ECCC, 0x80000B7C0000B4CC, 
0x80001E8A00035CB7, 0x80000CAE000135A3, 0x000488CC80001CFA, 0x80001B9A80000A3E, 0x80001D2280001E82, 0x0000498180001E7A, 0x00039CCD00007980, 0x80000B85000564CC, 
0x80000B58000138CC, 0x80000A3800077188, 0x80000BA60007758A, 0x80000B8B80001D02, 0x00077D8100002DA3, 0x80000B9100077D80, 0x80001D0A00074982, 0x0007498780001D12, 
0x0007D58080000000, 0x0007F1820007E581, 0x0007998400078D83, 0x8000001A000061B1, 0x0007B58800079187, 0x0007898A0007B989, 0x8000000A800007E6, 0x80000589800004EA, 
0x80000DDA80000002, 0x800003C780000064, 0x0000ADA000009587, 0x00008D8200076D81, 0x0000898C8000091A, 0x0007D5A3800004B7, 0x0000E9A80000DDAF, 0x0000D5AA800004AB, 
0x0000BDB4800005BB, 0x80000C1E000045B5, 0x0003D0CC000729A3, 0x0000ADB20005DCCD, 0x000045BC0000A5B3, 0x000055BE000051BD, 0x000075B880000BE5, 0x000065BA00007DB9, 
0x0002E08680000C24, 0x00046CCC0001CD81, 0x0001FD84000468CD, 0x00023CCC80000C21, 0x00003581000470CD, 0x00021CCC80000BE8, 0x00000981000218CD, 0x80000C2700001184, 
0x00007DB280000720, 0x8000087200000DB3, 0x800008C280000745, 0x80000D3200000580, 0x00056CCC80000951, 0x0000058C000568CD, 0x0000298980000C03, 0x00034098000039BF, 
0x0003A8A6800006E9, 0x80000837800006ED, 0x800007428000073B, 0x80000768800008B2, 0x800009118000076B, 0x0000F5BF800006E3, 0x80000834800006E6, 0x80000C06000238CC, 
0x800008600000058C, 0x8000087E80000CD8, 0x8000093A80000D02, 0x80000D0880000D05, 0x800000128000096B, 0x8000003080000016, 0x8000097680000068, 0x0003E0B880000006, 
0x00038D8780000034, 0x00038D8500038D86, 0x0001058500037184, 0x0001358500009092, 0x80000D2680000CD2, 0x000951830037D581, 0x0003AD8B00038D8C, 0x0003AD890003AD8A, 
0x000C01A10003AD88, 0x000E49A3000059A0, 0x80000B52000311A2, 0x80000D36000075A4, 0x80000D4180000D39, 0x0005DCCD80000D3C, 0x80000D2F00050CCC, 0x800006A580000074, 
0x00035DB780000024, 0x00035DB500035DB6, 0x000341B3000341B4, 0x00035DB100035DB2, 0x0003459900035DB0, 0x0003459B00034598, 0x00034D9D0003459A, 0x800009990003419C, 
0x000080CC00034DB8, 0x0003ACCC000728CD, 0x000361B3000C98CD, 0x00037DB1000379B2, 0x0005B0CC8000211E, 0x000764CD0005A8CD, 0x001AFCCC0000C8CC, 0x001A74CC80000D44, 
0x000159808000211A, 0x8000211600015981, 0x0001758400016D83, 0x000F018080002062, 0x000668CC000F0181, 0x000F39930007E4CD, 0x000700CC8000206A, 0x00079CCC000F1D94, 
0x000F59800007B0CD, 0x000F6982000F5981, 0x00001D8580002072, 0x001E08CD00003D85, 0x000195810019C4CC, 0x8000205A0001B980, 0x8000206600001D85, 0x8000206E00018984, 
0x000FA58000007586, 0x000DB0CC000FB581, 0x80002076000D38CD, 0x800021228000205E, 0x0000D9858000213A, 0x000570CD80000D47, 0x80001EEE0005E0CC, 0x80001EF280001EF6, 
0x80001EFA00002D85, 0x000CC8CC8000213E, 0x0001A1B4000CA4CD, 0x800020A280000D4A, 0x000FACCC800020AA, 0x00019DBA800020B2, 0x800020A68000209A, 0x000181BE800020AE, 
0x8000096D800020B6, 0x000C7584000EBD87, 0x80001EAE000E7185, 0x80001EB6000FCD85, 0x80001EC680001EBE, 0x80001EB280001EBA, 0x80001EC28000209E, 0x000FA58080001ECA, 
0x000FD985000F9981, 0x80001EE6000CBC97, 0x000EA581000CF495, 0x00004983000E8980, 0x80001EEA000DA491, 0x000009940002BC9F, 0x80001F2680001F1E, 0x80001F2E00003D93, 
0x0000A58000027499, 0x0000BD820000B581, 0x000F4D85000194A5, 0x80001F36000F0185, 0x000F1180000C4CA1, 0x000F1180000F1181, 0x000F1581000F6D81, 0x0000F183000F2980, 
0x000F258500012CA9, 0x80001F2200070CB7, 0x0000A18000073CB5, 0x80001F2A0000AD81, 0x000F118500004CB1, 0x0000318000053CBF, 0x80001F3200001D81, 0x80001F3A000F0185, 
0x000EC580000634B9, 0x000EF585000ED181, 0x00018982000EE185, 0x0001698080002142, 0x0001F98000016581, 0x0001D1820001D581, 0x80000D4D80002162, 0x0002B8CC00011985, 
0x8000215E0002E4CD, 0x80000DA48000215A, 0x0001999400012193, 0x0000398080001F5E, 0x80001F6600002581, 0x000EAD8000010983, 0x001424CC000EB981, 0x80001F6E0015BCCD, 
0x0000AD8000006985, 0x80001F760000B581, 0x0000D18480001F62, 0x0000DD8680001F6A, 0x0000E98880001F72, 0x0000D18100002D82, 0x000025800000CD80, 0x80001F7A00002981, 
0x00005580800021A6, 0x0000718200005981, 0x00005D9400009993, 0x0000F58000008183, 0x80000D500000ED81, 0x0001ECCC80001F96, 0x000009800001D4CD, 0x80001F9E00000981, 
0x0003E18180001FA6, 0x000019800003B980, 0x80001FA200001981, 0x0000B58580001FAA, 0x8000218E00003D94, 0x0002A0CC8000218A, 0x80000D530002ACCD, 0x000385800003D183, 
0x800008B00003DD81, 0x0003AD9380002186, 0x80000DA780002182, 0x0000318000040194, 0x0001CCCD00003181, 0x80001FD200013CCC, 0x00001D8180001FD6, 0x80001FDA00001D80, 
0x0000A58000000582, 0x0000AD800000B581, 0x0000DD860000BD81, 0x0000DD84800021AA, 0x000210CC80000D56, 0x0000F98800033CCD, 0x00002580800020E2, 0x000178CD00002981, 
0x0006D18000010CCC, 0x000005850006D181, 0x000120CD800020EA, 0x0006D994000124CC, 0x0006C194800020F2, 0x0006FD810006FD82, 0x00002D850006FD80, 0x0001F1850001F985, 
0x000EA8CD0006F593, 0x800020DA000EB0CD, 0x000E68CD800020E6, 0x000E98CC000E50CD, 0x000E38CC00019CCD, 0x000F24CD000E64CD, 0x000A88CC000F28CD, 0x0007258000007585, 
0x800020EE00071581, 0x00003D85000144CD, 0x0001F8CC0001C8CD, 0x000040CD0001FCCD, 0x0007498100018CCC, 0x0000F98500077980, 0x0000F58500074182, 0x0001D8CC800020F6, 
0x003A51880001DCCD, 0x800021AE800020DE, 0x8000210200000585, 0x00010D8000079D83, 0x0005C8CC00010181, 0x8000210A000504CD, 0x00001985000178CD, 0x800020FA800020FE, 
0x00001D8500007585, 0x80002042000124CD, 0x000791800000D0CD, 0x0000398500079181, 0x800020528000204A, 0x800020468000203A, 0x00079180000118CD, 0x000110CC00079181, 
0x80001FCE0000DCCD, 0x80001FFE0007ED85, 0x8000200600007985, 0x800020168000200E, 0x800020028000200A, 0x8000201200001993, 0x8000201E8000201A, 0x00006D9480000DAA, 
0x80001E9680001E8E, 0x80001EA680001E9E, 0x000019820007A985, 0x0000198080001E92, 0x80001E9A00001981, 0x0000598080001EA2, 0x0007C98600005981, 0x0007CD848000204E, 
0x0000E18080001EAA, 0x0000F5820000E181, 0x8000205600001D85, 0x8000203E00000D85, 0x000091808000210E, 0x0000358200009181, 0x0000098500009183, 0x8000211200000985, 
0x0003C0CC80002106, 0x800020220003D4CD, 0x80001ECE80000DAD, 0x00000D8080001ED6, 0x80001EDE00003D81, 0x0000198080001ED2, 0x80001EDA00001981, 0x0003F0CC80001EE2, 
0x0001C98000031CCD, 0x000011800001C981, 0x0001D98000002581, 0x800020260001D981, 0x000005850001CD83, 0x80000DB080002126, 0x8000212E00001D85, 0x0000658180001EFE, 
0x80001F0600007D80, 0x00001D8500007193, 0x0001B59400019D93, 0x0000D59480002082, 0x000568CD80001F0E, 0x0000058500056CCC, 0x80001F168000208A, 0x8000209200000D85, 
0x0000C1808000207A, 0x0000F9820000D981, 0x80001F0A80001F02, 0x000009800000E985, 0x0000058500003581, 0x80001F1280002086, 0x8000208E00001D85, 0x0000058580001F1A, 
0x0000518080002096, 0x00007D8200006D81, 0x800021328000207E, 0x0000058500001985, 0x0000F98080002136, 0x000039820000CD81, 0x8000212A0000D983, 0x0001A0CC00000585, 
0x000180CD000124CD, 0x003E0194000138CC, 0x003EC9858000202A, 0x003EF985003E1593, 0x80000DB3000124CD, 0x800021468000214A, 0x8000214E000118CD, 0x0000098080000D59, 
0x0000698600000981, 0x00006D84000124CD, 0x80001F4680002156, 0x0000558080001F9A, 0x80001F4E00007D81, 0x000114CD80001F56, 0x80001F5280001F4A, 0x003C0188000128CD, 
0x00012CCD80001F5A, 0x0000BD810000C982, 0x0000F1810000BD80, 0x003A318F0000C580, 0x0000C582000124CD, 0x0000F980000110CD, 0x0000DD800000CD81, 0x000178CD0000C581, 
0x0000AD80000124CC, 0x0000B5820000B581, 0x00001D8280002152, 0x0000D580003ED583, 0x8000202E0000FD81, 0x000360CC000128CD, 0x80000E2A000378CD, 0x00000D8080001F86, 
0x0006A4CD0001BD81, 0x000150CD000678CD, 0x000628CC0006DCCC, 0x000644CD000670CD, 0x0007FCCD00063CCD, 0x0007C8CD000728CD, 0x000768CC0007C8CD, 0x0007F8CC000740CD, 
0x80001F8E0007D0CD, 0x0001D0CD80001F8A, 0x000148CD80001F92, 0x00001D80000144CD, 0x0001E0CD00001181, 0x000B4CCD000694CC, 0x0006A4CD000280CC, 0x800021720006DCCD, 
0x003E75800006B0CD, 0x0001698080002176, 0x0001618100017D81, 0x003F898300017580, 0x0000D99380002032, 0x00010CCD003FF993, 0x000258CC003F4185, 0x003F3994003D04CD, 
0x003EC18500003994, 0x003FE988003FD593, 0x000138CD00066CCC, 0x003FC19400013CCC, 0x000138CC80000E2D, 0x0000758000013CCD, 0x00000D8600003181, 0x00000D848000216A, 
0x80001F3E80002166, 0x80001F42003C5881, 0x80001F7E8000216E, 0x80001F82003C9485, 0x80000E2780000DB6, 0x000025800003BC89, 0x00003D8000003181, 0x0000058200002981, 
0x0001E5908000217E, 0x0001E5920001ED91, 0x003A0194003A7D93, 0x0001ED960001E595, 0x0000098080001FAE, 0x80001FB600000981, 0x0000198080001FBE, 0x0000058200001981, 
0x80001FB280001FC6, 0x00000D8080001FBA, 0x80001FC200001D81, 0x0000098100003582, 0x80001FCA00001980, 0x0003A0CC8000217A, 0x003F2D8000032CCD, 0x00001D82003F6981, 
0x000179B00000E183, 0x000109B2000179B1, 0x000115B480002036, 0x8000219200011DB5, 0x8000219A80000E30, 0x80001FDE000129B9, 0x00000980800020C2, 0x80001FE600000981, 
0x800020CA80001FEE, 0x0001C58000002D85, 0x0001E9800001D181, 0x000005820001E981, 0x0000058580001FF6, 0x800020BA800020D2, 0x0000098080001FE2, 0x80001FEA00006581, 
0x800020C600007D85, 0x003D70CC0001AD93, 0x80001FF2003DC0CD, 0x0000759400000985, 0x00005980800020CE, 0x0000058200003581, 0x0000098580001FFA, 0x800020D600000985, 
0x00014D80800020BE, 0x0000198200015981, 0x8000219E00016583, 0x0000058500003585, 0x80002196800021A2, 0x80000DCE80000DBC, 0x80000E1880000D95, 0x80000DD480000E06, 
0x80000E0C80000E09, 0x80000DC580000D71, 0x80000E4280000D8F, 0x00000586000214CC, 0x0000058880000E7E, 0x0035C8CC80000E84, 0x80000E3F0035CCCD, 0x00014CCC80000E39, 
0x000254CC003C7CCD, 0x80000E8A0003F8A3, 0x80000E3C000124CD, 0x000178CD0003FCA7, 0x80000E7800012CCC, 0x00011CCD00021CAB, 0x00005D8080000E96, 0x80000E9C000254CC, 
0x0000798800026CAD, 0x000204B00002ECB3, 0x0002A0B600006D86, 0x00013CCD000284B7, 0x000578BA0002C4B5, 0x000550B8000124CD, 0x000574BE80000E48, 0x80000E2400005988, 
0x80000E4E80000EA2, 0x0036ACCD80000EA8, 0x003E6C86003F60CC, 0x003A18CD00008588, 0x80000E45003A14CC, 0x00000981000128CD, 0x000274CC0000A586, 0x0003FCCC00034180, 
0x80000EAE00028CCD, 0x00002C9000001C93, 0x0003E096000394CC, 0x0003E4CC0003D097, 0x0002D49A00001495, 0x0003609800002588, 0x0003709E80000EC0, 0x003DF8CC80000E4B, 
0x0003ACCD003DECCD, 0x000278CC0003A8CC, 0x000138CC80000EC6, 0x80000ECC000124CD, 0x003FD8CC00005188, 0x003E70CC003FDCCD, 0x003FA4CC003E74CD, 0x003F88CC003F9CCD, 
0x0001B586003FFCCD, 0x0001A58400012980, 0x0000098880000ED2, 0x80000ED800012984, 0x0002E4CC0001DD86, 0x000118CD0001E188, 0x80000EBA00010CCC, 0x0000758800006D8B, 
0x000005860002E4CC, 0x80000E8780000E81, 0x0000058100002D80, 0x00020CCC80000E63, 0x80000E5D000208CD, 0x000400CC0000D588, 0x000138CC000220CD, 0x00003188000128CD, 
0x0005D8CC80000E8D, 0x003E1CCD80000E60, 0x80000E7B003E74CD, 0x000128CC80000E99, 0x000234CC0000CCCD, 0x003FE4CD80000E9F, 0x80000EA580000E6C, 0x003FFCCD00001188, 
0x0007D18680000E51, 0x00020CCC0007E980, 0x80000EAB00022CCD, 0x000029810007E584, 0x0007CD800007E186, 0x000234CC00003588, 0x80000E69000230CD, 0x0007ED88000254CC, 
0x00007D8880000EB1, 0x80000EC30002D8CC, 0x80000EC980000E6F, 0x0003C4B580000ECF, 0x000224CC0003C8B4, 0x80000ED500000D88, 0x0000058800023CCC, 0x000224CC80000EDB, 
0x0003F4830000F588, 0x80000EBD0000C986, 0x0003C0870000C584, 0x0000058800022CCC, 0x0003FC8B80000E66, 0x80000E72003800CC, 0x0000E58B000224CC, 0x0003F08D0000758F, 
0x80000E750000ED88, 0x0000058800022CCC, 0x000228CC80000E90, 0x0000058800037096, 0x000224CC80000E93, 0x80000EB400000D88, 0x0000058800023CCC, 0x0000058780000EB7, 
0x0002F49880000EDE, 0x000264D90002E499, 0x80000FD3000360A7, 0x80000FDC80000FD6, 0x00003193000264D9, 0x000019940003008A, 0x80000FD900035488, 0x0000219500007194, 
0x000224D900002994, 0x8000105180000FDF, 0x8000174480001675, 0x000268D9800016D3, 0x00003D9480001738, 0x8000175B000258D9, 0x000254D900000594, 0x8000173200000D94, 
0x0003ACB0000268E0, 0x00064D880002ECA4, 0x800017880003C4B3, 0x000009BC8000179A, 0x8000175E8000179E, 0x0006098000039881, 0x00060D86000284E0, 0x0002FCA4000021BC, 
0x000210A80002BCA4, 0x0002E4E0000218A9, 0x000081B780001765, 0x000091B5000099B6, 0x00031CA88000176C, 0x0003E89280001773, 0x00006DBC0000B9B8, 0x8000177A0003E095, 
0x000140A480001781, 0x8000178C0002E4A5, 0x800017930002B0A7, 0x0002B8E0000055BE, 0x000129BE00006997, 0x000230AE000338AD, 0x000238A8000318AF, 0x0002D4A60002B0A9, 
0x800017B700027CA7, 0x00020CE000039CB5, 0x0003BC920003E4B7, 0x0003DCB2000368B1, 0x000C64BC0003E0B3, 0x000D6CBE000CFCBD, 0x000CA8B8000268E0, 0x000CACBA800017BB, 
0x00032198000C2CBB, 0x0003559A00034999, 0x0003699C0003699B, 0x0000919E0003699D, 0x0003388700008D9F, 0x800017A9800017A2, 0x800017DB800017B0, 0x000200AF800017E2, 
0x00006D9F800017BF, 0x0000619D000075B3, 0x000065B60000699C, 0x800017CD800017C6, 0x00005D99800017D4, 0x0000319B0001B197, 0x0003B0AD0000399A, 0x0001A1BE00022CAC, 
0x0002C8870000219E, 0x800017FB00007597, 0x800017F700028CE0, 0x0000099600029CE0, 0x800017FF00003D97, 0x0003BC870003E086, 0x000288AE0003A086, 0x000338AE800017E9, 
0x00003DBE000264AF, 0x000240B10002C8E0, 0x0000D196800017F0, 0x8000180780001803, 0x000240B30000B98A, 0x0000259D0002C8E0, 0x8000180F0000599C, 0x00039CBF0000F195, 
0x800018138000180B, 0x8000182780001817, 0x000019950002E0E0, 0x8000181B000294E0, 0x000204B300002597, 0x00026CB30003A886, 0x8000181F000C0182, 0x800018338000182B, 
0x0003D4868000182F, 0x8000183700039C87, 0x0002F4B40003AC99, 0x0002E0E0000214B5, 0x000D3CE0000069BE, 0x0002E4B48000183F, 0x0000699580001843, 0x80001847000049BE, 
0x00022CB700004D96, 0x8000183B000FCD8A, 0x0000198F000D78B7, 0x000005B3000FEDB3, 0x0000099C8000185C, 0x8000184E0000159D, 0x80001855000D48E0, 0x8000186300000D8C, 
0x000035B6000055A9, 0x8000186E0000C5B7, 0x000FBD9F00003DB5, 0x80001875000039B3, 0x800018838000187C, 0x800018678000188A, 0x8000189880001891, 0x0000FDB8800018DA, 
0x800018D00000F5B9, 0x800018E1800018EB, 0x800018AD8000189F, 0x800018B40000DD83, 0x800018C2800018BB, 0x800018A6800018C9, 0x000380A50000F58D, 0x0002C08000020CE1, 
0x00007DAE800018F2, 0x000005BC0000A597, 0x00008D92800018F6, 0x0000DC85000218E1, 0x80003A47000114E3, 0x00008D9C80003A4B, 0x00040086000114EF, 0x80003A4F00038887, 
0x00018D8180003A53, 0x80003A5B80003A57, 0x80003A6380003A5F, 0x80003A6B80003A67, 0x0003048080003A6F, 0x80003A7780003A73, 0x0001308400031483, 0x80003A7F80003A7B, 
0x80003A8780003A83, 0x0001D99380003A8B, 0x80003A9380003A8F, 0x80003A9B80003A97, 0x80003AA380003A9F, 0x80003AAB80003AA7, 0x0001E99D80003AAF, 0x000015810000F582, 
0x80003AB300001580, 0x000148BE00004884, 0x021884AC000111A2, 0x000139A7021A94AD, 0x0007208680003ABB, 0x80003ABF0000EC87, 0x80003AC780003AC3, 0x80003ACB000111AC, 
0x80003AD380003ACF, 0x0218D8BA80003AD7, 0x80003ADB0000CC84, 0x0218FCBE0218B8BD, 0x000149B90213DCBF, 0x80003AE380003ADF, 0x021AC0B480003AE7, 0x021000B6021F30B5, 
0x0001508080003AEB, 0x00776882006A0081, 0x00BF60840052B883, 0x00E48C86009B9485, 0x012A248800CE1C87, 0x0113588A0137C489, 0x0158B08C017FA88B, 0x018E3C8E01A2108D, 
0x01F6C09001EAAC8F, 0x023CC89201D34091, 0x00059C840002B1A3, 0x000355A600035DA5, 0x80003AF380003AEF, 0x000371AA80003AF7, 0x000355AC000371AB, 0x00034DAE00035DAD, 
0x000261A1000345AF, 0x00068DA380003AFB, 0x001801A500068DA2, 0x001A1DA7000621A4, 0x001E81A9001ABDA6, 0x001FC1AB001C01A8, 0x001291AD001E9DAA, 0x0016B9AF0012B5AC, 
0x0017DDB10013D1AE, 0x006AE9B30016C1B0, 0x006C01B5006801B2, 0x0003F4BE006A0DB4, 0x80003AFF000514BE, 0x0006A4BE80003B03, 0x80003B0B80003B07, 0x80003B1380003B0F, 
0x0003FDB380003B17, 0x80003B1B006C2CBF, 0x80003B2380003B1F, 0x000211B5000219B6, 0x00023DBB80003B2B, 0x0005088600023DBA, 0x000209BF00058C87, 0x000211BD000201BE, 
0x00005182000219BC, 0x0000418080003B2F, 0x000000D700004181, 0x80003B3780003B33, 0x80003B3B00002CEF, 0x80003B3F00018CE1, 0x00197CBE0000F8E3, 0x80003B4780003B43, 
0x000265AB0018B0BE, 0x000158E0000255AA, 0x0001CDAF80003B4B, 0x000275AD000269AE, 0x00020DA3000275AC, 0x80003B5380003B4F, 0x80003B5780001823, 0x000201A5000209A6, 
0x80003B5F80003B5B, 0x80003B6780003B63, 0x80003B6B000261B3, 0x000265B600026DB5, 0x80003B6F006D6485, 0x000239BA80003B73, 0x000219BC000209BB, 0x000205BE000219BD, 
0x80003AB70001A1BF, 0x80003B7780003B27, 0x80003B7F80003B7B, 0x80003B8780003B83, 0x0005BDA880003B8B, 0x000585AA00058DA9, 0x000589AC00059DAB, 0x0005F9AE000589AD, 
0x000591B00005F9AF, 0x0005A1B20005A1B1, 0x0005ADB40005A1B3, 0x000639B6000609B5, 0x0006E5B8000639B7, 0x00068DBA000685B9, 0x000681BC000681BB, 0x000681BE000681BD, 
0x00079DA8000681BF, 0x0007DDAA0007C1A9, 0x0007F1AC0007D5AB, 0x0007EDAE0007FDAD, 0x0000BD800007E5AF, 0x0000198200000981, 0x80003B9380003B8F, 0x0000C88780003B97, 
0x000711B800039C86, 0x00072DBA000725B9, 0x0000DDBC0000C5BB, 0x0000CDBE0000C5BD, 0x00076DB00000C5BF, 0x000741B2000741B1, 0x00074DB400075DB3, 0x00073DB6000735B5, 
0x000655B3000735B7, 0x80003B9F80003B9B, 0x80003BA780003BA3, 0x000679B500067DB6, 0x000685BB80003BAB, 0x80003BAF0006A9BA, 0x0006F1BF80003BB3, 0x000689BD000689BE, 
0x80003BB7000695BC, 0x80003BBB000611A3, 0x000639A680003BBF, 0x80003BC780003BC3, 0x0006EDAA00063DA5, 0x80003BCB0006C1AB, 0x0006CDAE80003BCF, 0x0006D1AC0006B5AF, 
0x000085A80006CDAD, 0x000085AA00008DA9, 0x00008DAC00009DAB, 0x0000B5AE0000BDAD, 0x80003BD30000DDAF, 0x80003BDB80003BD7, 0x80003BE380003BDF, 0x80003BEB80003BE7, 
0x000069B880003BEF, 0x000079BA000069B9, 0x000069BC000079BB, 0x0003B9BE000069BD, 0x0000A9B00003B9BF, 0x0000BDB20000A9B1, 0x000099B40000B5B3, 0x000059B6000099B5, 
0x000759BC000059B7, 0x000769BE000759BD, 0x000755B8000769BF, 0x000749BA000759B9, 0x000715B4000749BB, 0x000715B600071DB5, 0x000729B000076DB7, 0x00071DB2000729B1, 
0x000749AC000715B3, 0x000759AE000749AD, 0x0006B5A8000759AF, 0x0006A5AA0006ADA9, 0x80003BF3000759AB, 0x80003BFB80003BF7, 0x0000198080003BFF, 0x0000058200001981, 
0x0002C88480003C03, 0x0003D887000389B3, 0x0003B9B6001C2C86, 0x80003C0F80003C0B, 0x0003E9BA000381B5, 0x80003C130003E9BB, 0x0003D9BE80003C17, 0x0003EDBC0003D9BF, 
0x0003CDA30003E5BD, 0x80003C1F80003C1B, 0x80003C2780003C23, 0x0003C5A50003FDA6, 0x0003ADAB80003C2B, 0x80003C2F0003ADAA, 0x00039DAF80003C33, 0x0003A1AD00039DAE, 
0x80003C370003A9AC, 0x000718EF80003C3B, 0x80003C4380003C3F, 0x80003C4B80003C47, 0x0002208480003C4F, 0x80003C5780003C53, 0x000194E180003C5B, 0x0003A8E380003C5F, 
0x80003C6780003C63, 0x80003C6F80003C6B, 0x0000158080003C73, 0x0000158200001D81, 0x001C408680003C7B, 0x80003C7F001D5487, 0x80003C8780003C83, 0x80003C8F80003C8B, 
0x0006B0E180003C93, 0x0007C8E300043CE1, 0x80003C97000450E3, 0x80003C9F80003C9B, 0x80003CA780003CA3, 0x80003CAF80003CAB, 0x80003CB780003CB3, 0x00079CEF80003CBB, 
0x80003CBF00079CEF, 0x001DC08480003CC3, 0x80003CC7000165B3, 0x000111B6000111B5, 0x80003CCF80003CCB, 0x000135BA80003CD3, 0x00011DBC000105BB, 0x0000FDBE0000F5BD, 
0x001E95A80000F1BF, 0x001EA1AA001E9DA9, 0x001ED5AC001EA1AB, 0x001ED5AE001EDDAD, 0x80003C77001ECDAF, 0x80003CDB80003CD7, 0x0000198080003CDF, 0x0000058200001981, 
0x001F59B880003CE3, 0x001F6DBA001F59B9, 0x001F7DBC001F65BB, 0x001F65BE001F61BD, 0x001EBDB0001F1DBF, 0x001E85B2001E8DB1, 0x001F75B4001F6DB3, 0x001F69B6001F79B5, 
0x001E29A3001F69B7, 0x0003C48780003CE7, 0x80003CEB00002C86, 0x001E5DA5001E5DA6, 0x001E49AB80003CEF, 0x80003CF3001E79AA, 0x001FBDAF80003CF7, 0x001FB9AD001FB1AE, 
0x80003CFB001E51AC, 0x80003CFF001FA9B3, 0x001FA9B680003D03, 0x80003D0B80003D07, 0x001F75BA001FA9B5, 0x80003D0F001F7DBB, 0x001F55BE80003D13, 0x001F65BC001F5DBF, 
0x80003D17001F5DBD, 0x80003D1F80003D1B, 0x80003D2780003D23, 0x80003D2B001D80E1, 0x80003D2F001C2CE3, 0x80003D3780003D33, 0x80003D3B0018A4EF, 0x80003D4380003D3F, 
0x001E2DA380003D47, 0x0000158100002D82, 0x80003D4B00001D80, 0x001E2DA5001E2DA6, 0x001EF9AB80003D4F, 0x80003D53001EF1AA, 0x001ED9AF00012084, 0x001ED9AD001ED1AE, 
0x001EDDA8001EE1AC, 0x001EE5AA001EEDA9, 0x001EE5AC001EFDAB, 0x001EE5AE001EEDAD, 0x0001E8BE001E0DAF, 0x0007088680003D5B, 0x80003D5F0000B887, 0x80003D6780003D63, 
0x001E75B880003D6B, 0x001E0DBA001E05B9, 0x001E0DBC001E1DBB, 0x001E3DBE001E35BD, 0x001E75B00001F9BF, 0x001E75B2001E7DB1, 0x001E55B4001E4DB3, 0x001E55B6001E5DB5, 
0x000291A8001E4DB7, 0x0002A1AA000299A9, 0x0002D1AC0002A1AB, 0x0002D5AE0002DDAD, 0x80003D6F0002C9AF, 0x80003D7780003D73, 0x0000008C80003D7B, 0x80003D8380003D7F, 
0x000359B880003D87, 0x00036DBA000365B9, 0x000361BC000365BB, 0x000361BE000361BD, 0x0002B9B0000361BF, 0x000285B200028DB1, 0x000375B400036DB3, 0x000375B600037DB5, 
0x000229B300036DB7, 0x80003D8F80003D8B, 0x80003C0780003D93, 0x000259B500025DB6, 0x000249BB80003D97, 0x80003D9B00027DBA, 0x0003B9BF80003D9F, 0x0003B9BD0003B1BE, 
0x80003DA3000251BC, 0x80003DA700026DA3, 0x000219A680003DAB, 0x80003DB380003DAF, 0x000239AA00021DA5, 0x80003DB700020DAB, 0x0003F5AE80003DBB, 0x000215AC0003FDAF, 
0x000194E10003FDAD, 0x000074E380003DBF, 0x0000158180003DC3, 0x000254BE0001F980, 0x00042CBE00001182, 0x80003DCF80003DCB, 0x80003DD780003DD3, 0x000060EF80003DDB, 
0x0002F5B30002B084, 0x0005648780003DDF, 0x80003DE300056C86, 0x0002E5B5000175B6, 0x000155BB80003DE7, 0x80003DEB000149BA, 0x0001F9BF80003DEF, 0x000145BD0001F1BE, 
0x80003DF3000145BC, 0x80003DFB80003DF7, 0x80003E0380003DFF, 0x80003E0B80003E07, 0x80003E0F001A18EF, 0x80003E13001EDCE1, 0x00043C84001E74E3, 0x80003E1B80003E17, 
0x000275A380003E1F, 0x80003E2780003E23, 0x80003E2B0004CC84, 0x000265A50001F5A6, 0x0001D5AB80003E2F, 0x80003E330001C9AA, 0x000179AF80003E3B, 0x0001C5AD000171AE, 
0x0005A5A80001C5AC, 0x0005BDAA0005B5A9, 0x0005ADAC0005B5AB, 0x00063DAE000635AD, 0x80003DC7000635AF, 0x0007F5810007CD82, 0x80003E370007FD80, 0x0003F88780003E3F, 
0x0006E9B800009C86, 0x000689BA0006E9B9, 0x00069DBC000685BB, 0x000681BE000681BD, 0x00064DB00006B5BF, 0x000651B2000651B1, 0x0006F5B4000651B3, 0x0006F5B60006FDB5, 
0x0007A5A80006E1B7, 0x0007A5AA0007ADA9, 0x0007A5AC0007BDAB, 0x0007C9AE0007D1AD, 0x0000A4BE0007C1AF, 0x80003E4780003E43, 0x80003E4F80003E4B, 0x80003E5780003E53, 
0x000759B880003E5B, 0x000761BA000765B9, 0x000769BC000779BB, 0x00071DBE000769BD, 0x000789B0000715BF, 0x000769B2000789B1, 0x000779B4000769B3, 0x000769B6000779B5, 
0x80003E5F000769B7, 0x80003E6780003E63, 0x80003E6F80003E6B, 0x0004F8EF80003E73, 0x000690E180003E77, 0x000404E380003E7B, 0x80003E8380003E7F, 0x80003E8B80003E87, 
0x00066DB380003E8F, 0x80003E9780003E93, 0x80003E9F80003E9B, 0x00066DB5000611B6, 0x00060DBB80003EA3, 0x80003EA700060DBA, 0x0006FDBF80003EAB, 0x0006FDBD0006FDBE, 
0x0006ADA30006FDBC, 0x0000288680003EAF, 0x80003EB30001A887, 0x0006ADA50006D1A6, 0x0006CDAB80003EB7, 0x80003EBB0006CDAA, 0x00063DAF80003EBF, 0x00063DAD00063DAE, 
0x00008D8000063DAC, 0x0000958200009581, 0x80003EC3000169B3, 0x000169B6000179B5, 0x80003ECB80003EC7, 0x000155BA80003ECF, 0x0000F5BC0000EDBB, 0x0000F5BE0000FDBD, 
0x0005EDA80000EDBF, 0x0002ADAA000231A9, 0x0002BDAC0002A5AB, 0x0002ADAE0002A5AD, 0x0000F9810002A5AF, 0x80003ED30000F580, 0x80003ED70000F182, 0x80003EDF80003EDB, 
0x000365B880003EE3, 0x000379BA000369B9, 0x000369BC000379BB, 0x00031DBE000369BD, 0x0002DDB0000315BF, 0x00036DB2000365B1, 0x00037DB4000365B3, 0x00036DB6000365B5, 
0x80003EE7000361B7, 0x00022DA380003EEB, 0x00023DA580003EEF, 0x80003EF780003EF3, 0x000C00BE00022DA6, 0x0003A9AB80003D57, 0x0003B9AD000211AA, 0x0003A9AF0003B1AC, 
0x80003EFB0003B1AE, 0x80003F0380003EFF, 0x80003F0B80003F07, 0x80003F0F00028CEF, 0x0003F88480003F13, 0x80003F1B000214E3, 0x000CD08600017CE1, 0x80003F1F000CB487, 
0x00026DA880003F23, 0x000299AA000281A9, 0x0002B9AC000291AB, 0x0002C9AE0002B9AD, 0x80003F270002C1AF, 0x80003F2F80003F2B, 0x80003F3780003F33, 0x80003F3F80003F3B, 
0x0001C5B880003F43, 0x0001DDBA0001C9B9, 0x000191BC0001D5BB, 0x000191BE000191BD, 0x000281B0000191BF, 0x000141B2000281B1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x80003F470001FDB7, 0x80003F4F80003F4B, 0x000D10840001D4EF, 0x80003F5780003F53, 0x80003F5B000644EF, 0x80003F5F0006F0E1, 0x80003F6300060CE3, 0x80003F67000190E1, 
0x00026DB6000660E3, 0x80003F6F80003F6B, 0x80003F73000265B5, 0x80003F77000245B3, 0x0001D5BE80003F7B, 0x0001C1BC0001DDBF, 0x000211BA0001DDBD, 0x80003F7F000211BB, 
0x80003F1780003F83, 0x000DE9AA000388BE, 0x000E39AC000DE9AB, 0x000E2DAE000E25AD, 0x80003F87000E25AF, 0x80003F8F80003F8B, 0x80003F93000DBDA3, 0x000D95A6000D9DA5, 
0x000F9D8080003F97, 0x000FB582000FBD81, 0x80003F9B000EB1B3, 0x000F71B6000F71B5, 0x0003408680003F9F, 0x000F5DBA00033487, 0x000F4DBC000F55BB, 0x000FFDBE000FF5BD, 
0x000E69A8000FF5BF, 0x000E75AA000E7DA9, 0x000FB5AC000FADAB, 0x000FB5AE000FBDAD, 0x80003FA3000FADAF, 0x80003FAB80003FA7, 0x80003FB380003FAF, 0x80003FBB80003FB7, 
0x000F61B880003FBF, 0x000F79BA000F6DB9, 0x000F15BC000F75BB, 0x000F09BE000F1DBD, 0x000FD5B0000F05BF, 0x000FD5B2000FDDB1, 0x000F75B4000F6DB3, 0x000F6DB6000F7DB5, 
0x000FFDA3000F65B7, 0x80003FC780003FC3, 0x80003FCF80003FCB, 0x000E3DA5000E3DA6, 0x000E19AB80003FD3, 0x80003FD7000E11AA, 0x000EB9AF80003FDB, 0x000EB9AD000EB1AE, 
0x80003FDF000E01AC, 0x80003FE780003FE3, 0x00001D8080003FEB, 0x0000398200000981, 0x80003FF380003FEF, 0x0001A0BE0001A884, 0x0000D08680003FF7, 0x80003FFB0001E487, 
0x0001A5A880003FFF, 0x0001B9AA0001ADA9, 0x0001C1AC0001B1AB, 0x000139AE0001C9AD, 0x0000A084000139AF, 0x8000400780004003, 0x8000400F8000400B, 0x8000401780004013, 
0x0000CDB88000401B, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 0x00009DBE000095BD, 0x000149B0000095BF, 0x000159B2000149B1, 0x000149B4000159B3, 0x0000FDB6000149B5, 
0x000231B30000F5B7, 0x800040238000401F, 0x8000402B80004027, 0x000249B5000249B6, 0x00028DBB8000402F, 0x8000403300028DBA, 0x00028DBF80004037, 0x00028DBD00028DBE, 
0x007D448500028DBC, 0x8000403B000275A3, 0x00020DA68000403F, 0x8000404780004043, 0x0002C9AA00020DA5, 0x8000404B0002C9AB, 0x0002C9AE8000404F, 0x0002C9AC0002C9AF, 
0x000400BE0002C9AD, 0x8000405780004053, 0x00001D808000405B, 0x00003D8200000981, 0x00052CBE8000405F, 0x8000406B80004063, 0x800040738000406F, 0x8000407B80004077, 
0x0004E0868000407F, 0x8000408300035487, 0x0002A8EF80004087, 0x8000408F8000408B, 0x000150E380004093, 0x000180E180004097, 0x8000409F8000409B, 0x800040A7800040A3, 
0x000279A800047084, 0x0002ADAA000279A9, 0x0002BDAC0002A5AB, 0x0002ADAE0002A5AD, 0x0004A8840002A5AF, 0x800040AF800040AB, 0x800040B7800040B3, 0x800040BF800040BB, 
0x000109B8800040C3, 0x00011DBA000109B9, 0x000139BC000115BB, 0x0001DDBE000139BD, 0x0002DDB00001D5BF, 0x000161B2000161B1, 0x000161B4000161B3, 0x000151B6000169B5, 
0x800040C7000151B7, 0x800040CB000F6CE1, 0x00001980000E0CE3, 0x0000318200003581, 0x800040CF00000CEF, 0x800040D30001DCE1, 0x000000ED0000D8E3, 0x800040DF800040DB, 
0x0004E086000140EF, 0x800040E300057887, 0x800040E7000269B3, 0x000269B6000279B5, 0x800040EF800040EB, 0x000255BA800040F3, 0x0001F9BC0001E9BB, 0x0001E9BE0001F9BD, 
0x800040670001E1BF, 0x800040F7800040D7, 0x800040FB0005A9A3, 0x0005A9A60005B9A5, 0x80004103800040FF, 0x000595AA80004107, 0x000639AC000629AB, 0x000629AE000639AD, 
0x0006F1B3000621AF, 0x8000410F8000410B, 0x8000411780004113, 0x0006E1B50006E9B6, 0x0006B9BB8000411B, 0x8000411F0006B1BA, 0x000681BF80004123, 0x00069DBD000699BE, 
0x000629A80006A1BC, 0x000639AA000629A9, 0x000629AC000639AB, 0x000651AE000629AD, 0x80004127000651AF, 0x8000412F8000412B, 0x8000413780004133, 0x0001B1810001B982, 
0x0007E5B80001B980, 0x0007E5BA0007EDB9, 0x0007E5BC0007FDBB, 0x0007E5BE0007EDBD, 0x000635B000075DBF, 0x000635B200063DB1, 0x00061DB4000609B3, 0x00060DB6000605B5, 
0x0007B1A3000605B7, 0x8000413F8000413B, 0x00019CBE80004143, 0x0007A1A50007A9A6, 0x0007F9AB80004147, 0x000088860007F1AA, 0x0007C1AF00017887, 0x0007DDAD0007D9AE, 
0x8000414B0007E1AC, 0x8000414F00068DB3, 0x0006B1B680004153, 0x8000415B80004157, 0x000171BA000681B5, 0x8000415F000179BB, 0x000135BE80004163, 0x000159BC00013DBF, 
0x000635A8000159BD, 0x000641AA00063DA9, 0x00064DAC00065DAB, 0x00067DAE000675AD, 0x0001AC84000195AF, 0x8000416B80004167, 0x800041738000416F, 0x8000417B80004177, 
0x00019DB88000417F, 0x0001A5BA0001ADB9, 0x000175BC00016DBB, 0x000175BE00017DBD, 0x0001F1B000016DBF, 0x0001C9B20001F9B1, 0x0001B5B40001C9B3, 0x0001B5B60001BDB5, 
0x0005C9A30001ADB7, 0x8000418780004183, 0x8000418F8000418B, 0x0005C5A50005F5A6, 0x00023DAB80004193, 0x80004197000235AA, 0x000279AF8000419B, 0x00021DAD000271AE, 
0x8000419F00021DAC, 0x800041A7800041A3, 0x00000981800041AB, 0x800041AF00001980, 0x800041B300003D82, 0x007CC886000320BE, 0x800041BB00035C87, 0x800041C3800041BF, 
0x007CCC84800041C7, 0x800041CF800041CB, 0x000120E3007CC4BE, 0x0001A8E1800041D3, 0x00023CEF800041D7, 0x800041DF800041DB, 0x800041E7800041E3, 0x800041EF800041EB, 
0x00038DB3005D34BF, 0x800041F7800041F3, 0x800041FF800041FB, 0x000381B50003BDB6, 0x00034DBB80004203, 0x8000420700034DBA, 0x00034DBF8000420B, 0x00034DBD00034DBE, 
0x000241A800034DBC, 0x000245AA00024DA9, 0x000249AC000259AB, 0x000275AE00027DAD, 0x007FA0BE0002B9AF, 0x800042138000420F, 0x00000D8080004217, 0x0000AD820000A581, 
0x00014DB88000421B, 0x000155BA000155B9, 0x00017DBC000165BB, 0x00011DBE000115BD, 0x0002C9B0000115BF, 0x0002D9B20002C9B1, 0x0002C9B40002D9B3, 0x00017DB60002C9B5, 
0x000658E1000175B7, 0x0006B8E300075CE1, 0x8000421F000760E3, 0x007CB88680004223, 0x8000422B007D5487, 0x800042338000422F, 0x000000E980004237, 0x000050EF8000423B, 
0x8000423F0007E4EF, 0x000285A380004243, 0x000289A580004247, 0x8000424F8000424B, 0x800042530002B5A6, 0x000245AB80004257, 0x000245AD000245AA, 0x000245AF000245AC, 
0x007E71A8000245AE, 0x007E71AA007E71A9, 0x007E95AC007E71AB, 0x007E8DAE007E9DAD, 0x80004227007E81AF, 0x8000425F8000425B, 0x8000426780004263, 0x8000426F8000426B, 
0x007E8DB880004273, 0x007E95BA007E95B9, 0x007EBDBC007EA5BB, 0x007F71BE007F71BD, 0x007EC5B0007F71BF, 0x007EC5B2007ECDB1, 0x007EC5B4007EDDB3, 0x007EBDB6007ECDB5, 
0x007EF9B3007EB5B7, 0x8000427B80004277, 0x800042838000427F, 0x007E1DB5007E1DB6, 0x007E09BB80004287, 0x8000428B007E01BA, 0x007E09BF8000428F, 0x007E09BD007E01BE, 
0x00001582007E11BC, 0x00006180007EBDA3, 0x007E59A600006181, 0x8000429780004293, 0x007E45AA007E59A5, 0x00032484007E4DAB, 0x007E45AE8000429B, 0x007E55AC007E4DAF, 
0x007EA9B3007E4DAD, 0x000148868000429F, 0x800042A30002B087, 0x007EADB5007ED5B6, 0x007EF9BB800042A7, 0x800042AB007EF1BA, 0x000119BF800042AF, 0x007EDDBD000111BE, 
0x007DD0E3007EDDBC, 0x007D38E1800042B3, 0x800042BB800042B7, 0x800042C3800042BF, 0x800042CB800042C7, 0x800042D3800042CF, 0x007D04EF800042D7, 0x800042DF800042DB, 
0x007E21A8800042E3, 0x007E21AA007E21A9, 0x007E25AC007E21AB, 0x007E5DAE007E55AD, 0x800042E7007E51AF, 0x800042EF800042EB, 0x800042F7800042F3, 0x0003BD810003BD82, 
0x0001F5B80003BD80, 0x0001F5BA0001FDB9, 0x000159BC000149BB, 0x000149BE000159BD, 0x007E35B0000141BF, 0x007E09B2007E3DB1, 0x0001D5B4007E09B3, 0x0001D5B60001DDB5, 
0x800042FB0001CDB7, 0x80004303800042FF, 0x00028884007DA5A3, 0x007DD9A6007DA1A5, 0x8000430B000390BE, 0x007DFDAA8000430F, 0x007DD1AC007DF5AB, 0x00021DAE007DD1AD, 
0x00036DB6000215AF, 0x0003448480004313, 0x80004317000365B5, 0x00032887000345B3, 0x000301BE0004FC86, 0x000331BC000301BF, 0x000321BA000331BD, 0x8000431B000321BB, 
0x0003D1B08000431F, 0x0003D1B20003D1B1, 0x0003F1B40003D1B3, 0x0003F1B60003F1B5, 0x0003D5B80003F1B7, 0x0003D5BA0003DDB9, 0x000315BC00030DBB, 0x000315BE00031DBD, 
0x8000432300030DBF, 0x0020F08580004327, 0x8000432B800041B7, 0x800043338000432F, 0x00020DA880004337, 0x0003F9AA0003E1A9, 0x0003D9AC0003F1AB, 0x0003BDAE0003D9AD, 
0x000211A30003B1AF, 0x8000433F8000433B, 0x00051CBE80004343, 0x000231A5000239A6, 0x000275AB80004347, 0x8000434B000275AA, 0x000255AF8000434F, 0x000265AD000255AE, 
0x80004353000265AC, 0x8000435B80004357, 0x800043638000435F, 0x80004367000354E3, 0x8000436B00004CE1, 0x8000436F000380EF, 0x0000118080004373, 0x0000158200001D81, 
0x007BD4E18000437B, 0x000354E38000437F, 0x0007308680004383, 0x8000438700047487, 0x8000438B007E44EF, 0x8000438F007E24E1, 0x80004393000154E3, 0x007FF8EF80004397, 
0x000185B3003C00BF, 0x8000439F8000439B, 0x800043A300078084, 0x0001A1B50001A9B6, 0x000135BB800043A7, 0x800043AB000135BA, 0x0000F9BF800043AF, 0x000125BD0000F1BE, 
0x000621A8000125BC, 0x00064DAA000621A9, 0x000669AC00065DAB, 0x0006D9AE000669AD, 0x800043770006D9AF, 0x800043B7800043B3, 0x0004E9A2800043BB, 0x0006F5A00002E5A3, 
0x000769B800041DA1, 0x000709BA000769B9, 0x000719BC000709BB, 0x000709BE000719BD, 0x0006B1B0000705BF, 0x0006B1B20006B1B1, 0x000775B40006B1B3, 0x000775B600077DB5, 
0x0006C5A3000761B7, 0x800043BF006C658F, 0x800043C7800043C3, 0x0006E1A50006E9A6, 0x000675AB800043CB, 0x800043CF000675AA, 0x0007B9AF800043D3, 0x000665AD0007B1AE, 
0x0078C59E000665AC, 0x007DA59C0079D99F, 0x007CD19A0078CD9D, 0x0070E998007CF59B, 0x007245960071B599, 0x0074C9940070C597, 0x0068459200746995, 0x0068F99000766593, 
0x0075858A0068F991, 0x800043D70073A18B, 0x0070798E800043DB, 0x0071398C007D158F, 0x006DC18200712D8D, 0x800043DF00692583, 0x0077A186800043E3, 0x00693D8400751587, 
0x0005619A00698985, 0x000108BE00059D9B, 0x800043EF800043EB, 0x0003899C000510E1, 0x007D4192000504E3, 0x800043F3007C0993, 0x00786D96000484EF, 0x007979940007B997, 
0x0001A1A100797995, 0x000D8DA3800043F7, 0x000CEDA5000C01A2, 0x000991A7000DC5A4, 0x001401A9000999A6, 0x001485AB000965A8, 0x001191AD00158DAA, 0x001C01AF001001AC, 
0x001DF1B1001161AE, 0x0019CDB3001DE5B0, 0x001801B5001801B2, 0x000078860019B5B4, 0x0000ED8000011C87, 0x0000C5820000CD81, 0x800043FF800043FB, 0x8000440780004403, 
0x00057DA88000440B, 0x000585AA000581A9, 0x0005B1AC000595AB, 0x0005A9AE0005BDAD, 0x8000440F0005A9AF, 0x8000441780004413, 0x8000441F8000441B, 0x8000442780004423, 
0x00026DB88000442B, 0x0002C5BA0002CDB9, 0x0002CDBC0002DDBB, 0x0002F5BE0002FDBD, 0x0005A5B0000355BF, 0x0005B9B20005ADB1, 0x000599B40005B1B3, 0x00025DB6000599B5, 
0x00050DB3000255B7, 0x800044338000442F, 0x8000443B80004437, 0x000539B500053DB6, 0x000569BB8000443F, 0x80004443000561BA, 0x00055DBF80004447, 0x000565BD00055DBE, 
0x00001D8000056DBC, 0x00002D8200002581, 0x80004307000541A3, 0x000571A6000575A5, 0x8000444F8000444B, 0x00052DAA80004453, 0x000521AC000525AB, 0x000511AE000529AD, 
0x00024DA8000511AF, 0x000261AA000255A9, 0x0002FDAC000289AB, 0x0002EDAE0002E5AD, 0x000224840002E5AF, 0x000D6887000DA8BE, 0x8000445B000D0C86, 0x800044638000445F, 
0x00017DB880004467, 0x0001C1BA0001C1B9, 0x0001C1BC0001C1BB, 0x0001F1BE0001C9BD, 0x00029DB00001F1BF, 0x00014DB2000145B1, 0x00015DB4000145B3, 0x00014DB6000145B5, 
0x8000446B000145B7, 0x800044738000446F, 0x8000447B80004477, 0x800044838000447F, 0x8000448700002CEF, 0x8000448B00062CE1, 0x000C3CBE000670E3, 0x800044938000448F, 
0x000D408480004497, 0x0002A1B38000449B, 0x00023DB58000449F, 0x800044A7800044A3, 0x000FE0BE00022DB6, 0x0001C9BB800044AB, 0x0001D9BD000211BA, 0x0001C9BF0001D1BC, 
0x000D69A30001D1BE, 0x800044AF80004457, 0x800044B7800044B3, 0x000DF5A5000DE5A6, 0x000E01AB800044BB, 0x800044BF000DD9AA, 0x000E01AF800044C3, 0x000E11AD000E19AE, 
0x00005D80000E19AC, 0x0000658200006D81, 0x800044C7000F75B3, 0x000FDDB6000FD5B5, 0x00036086800044CB, 0x000FF9BA00030487, 0x000FE9BC000FF9BB, 0x000FD1BE000FD5BD, 
0x000FB1A8000FC9BF, 0x000FB1AA000FB1A9, 0x000F11AC000FB1AB, 0x000F11AE000F11AD, 0x800044CF000F11AF, 0x800044D7800044D3, 0x800044DF800044DB, 0x800044E7800044E3, 
0x000F05B8800044EB, 0x000F1DBA000F09B9, 0x000F35BC000F15BB, 0x0000D5BE0000DDBD, 0x000F71B00000CDBF, 0x000F71B2000F71B1, 0x000F59B4000F4DB3, 0x000F41B6000F41B5, 
0x000E39A3000F41B7, 0x800044F3800044EF, 0x800044FB800044F7, 0x000E99A5000E91A6, 0x000EB5AB800044FF, 0x80004503000EB5AA, 0x000E85AF80004507, 0x000E99AD000E9DAE, 
0x8000450B000EA5AC, 0x800045138000450F, 0x8000451B80004517, 0x800045238000451F, 0x00000D8080004527, 0x00001D8200001581, 0x8000452F8000452B, 0x0001F48480004533, 
0x0000208680004537, 0x8000453B00010487, 0x8000453F800043E7, 0x8000454780004543, 0x0001FDA88000454B, 0x00010DAA000105A9, 0x00011DAC000105AB, 0x00010DAE000105AD, 
0x00017DB0000105AF, 0x0000C1B20000C1B1, 0x0000C1B40000C1B3, 0x0000F1B60000C9B5, 0x0000A1B80000F1B7, 0x0000A1BA0000A1B9, 0x0000A1BC0000A1BB, 0x0000A1BE0000A1BD, 
0x000F30E30000A1BF, 0x000DC8E18000454F, 0x8000455780004553, 0x8000455F8000455B, 0x0004008480004563, 0x8000456B80004567, 0x000FECEF8000456F, 0x8000457780004573, 
0x0002E5B38000457B, 0x800045838000457F, 0x8000458B80004587, 0x0002F5B50002E5B6, 0x000365BB8000458F, 0x800045930002D9BA, 0x00036DBF80004597, 0x000375BD000365BE, 
0x00001180000375BC, 0x0000298200001981, 0x8000459B000229A3, 0x000229A6000239A5, 0x800045A38000459F, 0x000215AA800045AB, 0x0003B9AC0003A9AB, 0x0003A9AE0003B9AD, 
0x0002FCEF0003A1AF, 0x00056886000448BE, 0x800045AF00036087, 0x800045B7800045B3, 0x800045BF800045BB, 0x800045C7800045C3, 0x0002C0E3800045CB, 0x000160E1800045CF, 
0x000289A8800045D3, 0x00029DAA000295A9, 0x00028DAC000295AB, 0x000115AE000111AD, 0x800045D700010DAF, 0x800045DF800045DB, 0x800045E7800045E3, 0x800045EF800045EB, 
0x00017DB8800045F3, 0x000101BA000101B9, 0x000101BC000101BB, 0x000131BE000109BD, 0x000175B0000131BF, 0x000175B200017DB1, 0x000159B4000149B3, 0x00014DB6000159B5, 
0x000EB4E1000145B7, 0x000E58E3800045F7, 0x800045FB000000E6, 0x000594BE800045FF, 0x8000460780004603, 0x00001D8100001982, 0x8000460B00001D80, 0x000EF0EF8000460F, 
0x0005488480004613, 0x000528878000461B, 0x8000461F0004EC86, 0x800046230001ACE1, 0x800046270000B4E3, 0x8000462F8000462B, 0x80004633000EF4EF, 0x8000463B80004637, 
0x000595A38000463F, 0x80004617800045A7, 0x8000464780004643, 0x000585A5000611A6, 0x000639AB8000464B, 0x8000464F000631AA, 0x00061DAF80004653, 0x00061DAD00061DAE, 
0x80004657000621AC, 0x8000465B000691B3, 0x0006B1B68000465F, 0x8000466780004663, 0x00068DBA000681B5, 0x8000466B000691BB, 0x000755BE8000466F, 0x000685BC00075DBF, 
0x000655A300075DBD, 0x8000467780004673, 0x8000467F8000467B, 0x000645A5000675A6, 0x000655AB80004683, 0x00006484000649AA, 0x000799AF000064BE, 0x000799AD000791AE, 
0x80004687000641AC, 0x0006DDBA8000468B, 0x0006CDBC0006D5BB, 0x0006F1BE0006F1BD, 0x00006D800006F1BF, 0x0000758200007581, 0x8000468F000579B3, 0x0006FDB6000569B5, 
0x0007A5A880004693, 0x0007DDAA0007D5A9, 0x0007CDAC0007D5AB, 0x0007FDAE0007F5AD, 0x000100860007F5AF, 0x8000469700018487, 0x8000469F8000469B, 0x800046A7800046A3, 
0x000675B8800046AB, 0x000675BA00067DB9, 0x0006C1BC0006C9BB, 0x0006C5BE0006C1BD, 0x00078DB00006FDBF, 0x000795B2000791B1, 0x000655B400064DB3, 0x000655B600065DB5, 
0x000645A800064DB7, 0x000651AA000655A9, 0x000675AC00066DAB, 0x000669AE00067DAD, 0x800046AF000669AF, 0x800046B7800046B3, 0x800046BF800046BB, 0x800046C7800046C3, 
0x000189B8800046CB, 0x00019DBA000189B9, 0x0001B9BC000195BB, 0x00015DBE0001B9BD, 0x000619B0000155BF, 0x0001E5B2000619B1, 0x0001EDB40001FDB3, 0x0001D5B60001DDB5, 
0x0005D9B30001BDB7, 0x800046D3800046CF, 0x800046D7000340BE, 0x0005FDB50005FDB6, 0x0005DDBB800046DB, 0x800046DF0005DDBA, 0x000219BF800046E3, 0x000229BD000229BE, 
0x800046E7000231BC, 0x800046EB00059DA3, 0x0005B9A6800046EF, 0x800046F300039884, 0x000599AA0005B9A5, 0x001CC886000599AB, 0x00026DAE0003FC87, 0x000275AC00025DAF, 
0x000245A800026DAD, 0x000275AA000275A9, 0x0003BDAC0003A5AB, 0x0003ADAE0003A5AD, 0x0000E9800003A5AF, 0x0000F1820000E981, 0x800046FF800046FB, 0x001CF48480004703, 
0x00037DB880004707, 0x0000C1BA0000C1B9, 0x0000CDBC0000DDBB, 0x0000F5BE0000FDBD, 0x0003DDB000009DBF, 0x00034DB2000345B1, 0x00035DB4000345B3, 0x00034DB6000345B5, 
0x0003FDB3000345B7, 0x8000470F8000470B, 0x8000471780004713, 0x000235B5000225B6, 0x000281BB8000471B, 0x8000471F000219BA, 0x000281BF80004723, 0x000291BD000299BE, 
0x80004727000299BC, 0x8000472B00007CE1, 0x8000472F000308E3, 0x8000473780004733, 0x8000473F8000473B, 0x8000474780004743, 0x8000474F8000474B, 0x8000475780004753, 
0x000750E1000388EF, 0x000658E300013CE3, 0x00000D80000658E1, 0x0000318200003181, 0x001DE8BE8000475B, 0x800047638000475F, 0x8000476F8000476B, 0x0006D8EF0001E0EF, 
0x00033DA380004773, 0x001C688680004777, 0x8000477B001CEC87, 0x0002F5A50002E5A6, 0x000241AB8000477F, 0x800047830002D9AA, 0x000241AF80004787, 0x000251AD000259AE, 
0x001EADA8000259AC, 0x001EBDAA001EB5A9, 0x001F15AC001EB1AB, 0x001F15AE001F1DAD, 0x80004767001F0DAF, 0x8000478F8000478B, 0x8000479780004793, 0x8000479F8000479B, 
0x001F1DB8800047A3, 0x001F2DBA001F25B9, 0x001F3DBC001F25BB, 0x001F2DBE001F25BD, 0x001F7DB0001F25BF, 0x001F45B2001F4DB1, 0x001F39B4001F2DB3, 0x001F2DB6001F25B5, 
0x001E35B3001F25B7, 0x800047AB800047A7, 0x800047B3800047AF, 0x001F9DB5001F9DB6, 0x001F89BB800047B7, 0x800047BB001FB9BA, 0x001FE1BF800047BF, 0x001FF9BD001FFDBE, 
0x800047C3001F91BC, 0x800047C7001E71A3, 0x001FD9A6800047CB, 0x800047D3800047CF, 0x001FFDAA001FD9A5, 0x0003AC84001FCDAB, 0x001FB9AE0003A0BE, 0x001FD5AC001FA5AF, 
0x001EADA8001FBDAD, 0x001EB5AA001EB5A9, 0x001EC1AC001EC9AB, 0x001EF1AE001EC9AD, 0x0001ED80001EF1AF, 0x0001F1820001F181, 0x00009486800047D7, 0x800047DB00017487, 
0x0001C9B8800047DF, 0x0001D9BA0001C9B9, 0x0001F9BC0001D1BB, 0x000199BE0001F9BD, 0x000145B0000195BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x800047E30001F9B7, 0x001E35B3800047E7, 0x001E41B5800047EB, 0x800047F3800047EF, 0x800046F7001E41B6, 0x000181BB00012484, 0x000181BD000189BA, 0x000181BF000199BC, 
0x001E7DA3000189BE, 0x800047FB800047F7, 0x80004803800047FF, 0x001E09A5001E09A6, 0x0001C9AB80004807, 0x8000480B0001C1AA, 0x0001C9AF8000480F, 0x0001C9AD0001C1AE, 
0x800048130001D1AC, 0x8000481B80004817, 0x800048238000481F, 0x80004827000258BE, 0x8000482B001F44EF, 0x8000482F001E54E1, 0x80004833001E84E3, 0x8000483B80004837, 
0x000079808000483F, 0x0000198200007981, 0x800048430003CDB3, 0x0003CDB60003D9B5, 0x0004C0868000484B, 0x0003A1BA0003EC87, 0x0003A1BC0003A1BB, 0x000391BE0003A9BD, 
0x8000484F000391BF, 0x8000485780004853, 0x00027CEF8000485B, 0x800048638000485F, 0x000114E380004867, 0x000180E18000486B, 0x800048738000486F, 0x8000487B80004877, 
0x000341A38000487F, 0x8000488780004883, 0x8000488F8000488B, 0x000355A5000341A6, 0x00032DAB80004893, 0x8000489700032DAA, 0x00031DAF8000489B, 0x000325AD00031DAE, 
0x00023DA900032DAC, 0x00028DAB00023DA8, 0x000285AD00028DAA, 0x0002DDAF000299AC, 0x00022C84000285AE, 0x000000CA8000489F, 0x800048A7800048A3, 0x800048AF800048AB, 
0x00014DB9800048B3, 0x000151BB00014DB8, 0x000179BD00015DBA, 0x00016DBF000175BC, 0x0002ADB100016DBE, 0x0002B5B30002ADB0, 0x00029DB50002BDB2, 0x00017DB700029DB4, 
0x0000BD8200017DB6, 0x0000BD80000588BE, 0x800048BB0000B581, 0x800048C3800048BF, 0x0005A084000188EF, 0x800048C7001E74E1, 0x00041086000154E3, 0x800048CB00057487, 
0x000145B3800048CF, 0x800048D7800048D3, 0x800048DF800048DB, 0x000155B5000141B6, 0x00014DBB800048E3, 0x800048E7000141BA, 0x00014DBF800048EB, 0x00014DBD00014DBE, 
0x00065DA800014DBC, 0x00068DAA000685A9, 0x00069DAC000685AB, 0x000681AE000681AD, 0x800048B7000681AF, 0x800048F3800048EF, 0x800048FB800048F7, 0x80004903800048FF, 
0x00068DB880004907, 0x000695BA000695B9, 0x0006BDBC0006A5BB, 0x000775BE000771BD, 0x0006C5B000076DBF, 0x0006D9B20006C9B1, 0x0006C9B40006D9B3, 0x0006BDB60006C9B5, 
0x000605A30006B5B7, 0x8000490F8000490B, 0x8000491780004913, 0x000615A5000601A6, 0x00060DAB8000491B, 0x8000491F000601AA, 0x00060DAF80004923, 0x00060DAD00060DAE, 
0x00005D8000060DAC, 0x0000658200006D81, 0x0003C4BE000755B3, 0x000765B600076DB5, 0x0000E08680004927, 0x000725BA00031487, 0x00072DBC00073DBB, 0x000715BE00071DBD, 
0x000691A80000D9BF, 0x000691AA000691A9, 0x0006A9AC0006A5AB, 0x0006DDAE0006A9AD, 0x8000492B0006D5AF, 0x800049338000492F, 0x8000493B80004937, 0x800049438000493F, 
0x000171B880004947, 0x000171BA000171B9, 0x0001D5BC000171BB, 0x0001D5BE0001DDBD, 0x0006ADB00001CDBF, 0x0006B5B20006B5B1, 0x00069DB4000685B3, 0x000151B6000151B5, 
0x000639A5000151B7, 0x8000494F8000494B, 0x80004953000631A6, 0x000601A380004957, 0x000649AD8000495B, 0x00018DAF000679AC, 0x8000495F000641AE, 0x000669AB80004847, 
0x80004963000671AA, 0x8000496B80004967, 0x800049738000496F, 0x8000497B80004977, 0x800049838000497F, 0x8000498B80004987, 0x000019808000498F, 0x0000058200001981, 
0x0002808480004993, 0x000774EF000388BE, 0x000CB08600030084, 0x8000499B00035487, 0x800049A38000499F, 0x000C24BE800049A7, 0x000648E1800049AB, 0x000708E3800049AF, 
0x800049B7800049B3, 0x800049BF800049BB, 0x800049C3000365B3, 0x00036DB6000365B5, 0x800049CB800049C7, 0x0003EDBA800049CF, 0x0003E1BC0003E5BB, 0x0003E5BE0003E1BD, 
0x800049D30003CDBF, 0x800049DB800049D7, 0x800049E3800049DF, 0x800049EB800049E7, 0x000381A8800049EF, 0x000381AA000381A9, 0x000381AC000381AB, 0x000381AE000381AD, 
0x000345B0000381AF, 0x000359B200034DB1, 0x00034DB4000359B3, 0x000319B6000365B5, 0x000329B8000319B7, 0x000339BA000329B9, 0x000329BC000339BB, 0x000319BE000329BD, 
0x000229A3000319BF, 0x800049F7800049F3, 0x800049FF800049FB, 0x000229A5000221A6, 0x0002A9AB80004A03, 0x80004A0B0002A1AA, 0x000281AF80004A0F, 0x0002ADAD0002A9AE, 
0x00004D800002ADAC, 0x0000558200005581, 0x000340E380004A13, 0x0001A0E180004A17, 0x00039CEF80004A1B, 0x000CC88680004A1F, 0x80004A23000D4087, 0x80004A2B80004A27, 
0x80004A3380004A2F, 0x80004A3B80004A37, 0x80004A4380004A3F, 0x80004A4B80004A47, 0x000CBCBE0001B4EF, 0x80004A4F00060CE1, 0x80004A5300061CE3, 0x80004A5B80004A57, 
0x0001E1B380004A5F, 0x80004A6780004A63, 0x80004A6F80004A6B, 0x0001F5B50001E1B6, 0x0001A9BB80004A73, 0x000DE0840001A1BA, 0x000195BF80004A7B, 0x0001A5BD000195BE, 
0x000E19A80001ADBC, 0x000E29AA000E19A9, 0x000E3DAC000E29AB, 0x000E25AE000E21AD, 0x80004A07000E5DAF, 0x000FF981000FF982, 0x80004A77000FE180, 0x00001C8680004A7F, 
0x000EC9B80003A087, 0x000ED9BA000EC9B9, 0x000EC9BC000ED9BB, 0x000F5DBE000EC9BD, 0x000E25B0000F55BF, 0x000E39B2000E2DB1, 0x000E11B4000E31B3, 0x000EF9B6000E11B5, 
0x000EA1A3000EF9B7, 0x80004A8780004A83, 0x80004A8F80004A8B, 0x000EB5A5000EA1A6, 0x000EE9AB80004A93, 0x80004A97000EE1AA, 0x000ED5AF80004A9B, 0x000EE5AD000ED5AE, 
0x80004A9F000EEDAC, 0x80004AA3000F89B3, 0x000FB5B680004AA7, 0x80004AAF80004AAB, 0x000F99BA000F81B5, 0x80004AB3000F99BB, 0x000F79BE80004AB7, 0x000F79BC000F79BF, 
0x000E29A8000F79BD, 0x000E45AA000E29A9, 0x000E4DAC000E59AB, 0x000E69AE000E71AD, 0x80004ABB000E69AF, 0x80004AC380004ABF, 0x80004ACB80004AC7, 0x80004AD380004ACF, 
0x000ED9B880004AD7, 0x000EF9BA000EEDB9, 0x000EE9BC000EF9BB, 0x000E9DBE000EE9BD, 0x000E19B0000E95BF, 0x000EE9B2000E19B1, 0x000EF9B4000EE9B3, 0x000EE9B6000EF9B5, 
0x80004ADB000EE9B7, 0x000ED5A5000EE1A6, 0x000EDDA380004ADF, 0x0000158100002982, 0x000E2DAF00001D80, 0x000E2DAD000E2DAE, 0x000ECDAB000E2DAC, 0x80004997000ECDAA, 
0x0002C88480004AE3, 0x00010CBE000141B3, 0x000141B680004AEB, 0x80004AF380004AEF, 0x00014DBA000151B5, 0x00004886000125BB, 0x000125BE00007C87, 0x000131BC00012DBF, 
0x80004AF7000131BD, 0x00030484000ED4EF, 0x80004AFB000480BE, 0x80004B0380004AFF, 0x00CEA8BF80004B07, 0x80004B0F80004B0B, 0x80004B130005E084, 0x80004B17000E28E3, 
0x80004B1B000E34E1, 0x0002CDA380004B1F, 0x0002DDA580004B23, 0x80004B2B80004B27, 0x80004B2F0002CDA6, 0x0002A9AB80004B33, 0x0002BDAD0002C1AA, 0x0002A1AF0002BDAC, 
0x0002B5A90002A9AE, 0x000201AB000D69A8, 0x000201AD000209AA, 0x000231AF000219AC, 0x000568BE000201AE, 0x80004B3B80004B37, 0x80004B4380004B3F, 0x80004B4B80004B47, 
0x0003E5B980004B4F, 0x0003E5BB0003E5B8, 0x0003E5BD0003E5BA, 0x0003E5BF0003E5BC, 0x000221B10003E5BE, 0x000225B3000249B0, 0x000229B5000225B2, 0x000215B7000221B4, 
0x0002CDA8000215B6, 0x0002D1AA0002D1A9, 0x000101AC00010DAB, 0x000101AE000101AD, 0x80004B53000101AF, 0x80004B5F80004B5B, 0x000730BE80004B63, 0x80004B6B80004B67, 
0x000119B880004B6F, 0x00012DBA000125B9, 0x0001F9BC0001E9BB, 0x0001E9BE0001F9BD, 0x000145B00001E9BF, 0x000159B200014DB1, 0x000131B4000155B3, 0x000135B6000131B5, 
0x0005A086000129B7, 0x80004B730005D487, 0x000129800000BCEF, 0x0000B98200012981, 0x00076C84000EC4EF, 0x80004B77000ED4E1, 0x80004B7B000E54E3, 0x80004B7F000194E1, 
0x000219B300006CE3, 0x80004B8780004B83, 0x0038008480004B8B, 0x0001C9B50001C1B6, 0x0001C9BB80004B8F, 0x80004B930001C1BA, 0x0001B5BF80004B97, 0x0001C1BD0001B5BE, 
0x0005D9A30001CDBC, 0x80004B9B80004B57, 0x80004BA380004B9F, 0x000609A5000601A6, 0x000609AB80004BA7, 0x80004BAB000601AA, 0x000675AF80004BAF, 0x000601AD000675AE, 
0x80004BB300060DAC, 0x80004BBB80004BB7, 0x0000198080004BBF, 0x0000058200001981, 0x80004BC780004BC3, 0x0003288680004BCB, 0x80004BCF0003AC87, 0x80004BD780004BD3, 
0x0007A5A880004BDB, 0x0007A5AA0007ADA9, 0x0007A9AC0007B9AB, 0x000711AE0007A9AD, 0x80004BDF000735AF, 0x80004BE780004BE3, 0x80004BEF80004BEB, 0x80004BF780004BF3, 
0x0000C9B880004BFB, 0x0000D9BA0000C9B9, 0x0000F9BC0000D1BB, 0x000099BE0000F9BD, 0x000751B0000099BF, 0x00072DB200075DB1, 0x00073DB4000725B3, 0x000711B6000729B5, 
0x00062DB3000711B7, 0x80004C0380004BFF, 0x80004C0B80004C07, 0x000621B5000629B6, 0x000699BB80004C0F, 0x80004C13000695BA, 0x0006EDBF80004C17, 0x0006F1BD0006F9BE, 
0x80004C1B0006F9BC, 0x80004C1F000669A3, 0x00066DA680004C23, 0x80004C2B80004C27, 0x0006D1AA000665A5, 0x80004C2F0006DDAB, 0x0006BDAE80004C33, 0x0006BDAC0006A9AF, 
0x00012DB00006B5AD, 0x00013DB2000135B1, 0x00012DB4000135B3, 0x000091B6000091B5, 0x0000B1B8000091B7, 0x000081BA0000B9B9, 0x0000F1BC000081BB, 0x0000F5BE0000FDBD, 
0x000099800000E9BF, 0x0000A5820000AD81, 0x80004C3780004AE7, 0x0001188780004C3B, 0x000185A800007C86, 0x00019DAA000195A9, 0x00018DAC000195AB, 0x00015DAE000155AD, 
0x000275B3000155AF, 0x80004C4380004C3F, 0x80004C4B80004C47, 0x000265B50002B5B6, 0x000291BB80004C4F, 0x80004C53000289BA, 0x000335BF80004C57, 0x000281BD000289BE, 
0x000658E3000289BC, 0x0005B8E180004C5B, 0x0000009180004C5F, 0x80004C63000190E1, 0x80004C6700079CE3, 0x80004C6F80004C6B, 0x000684EF00024CEF, 0x80004C7780004C73, 
0x80004C7F80004C7B, 0x80004C8780004C83, 0x80004C8B0002F9A3, 0x000239A60002E9A5, 0x80004C9380004C8F, 0x000205AA80004C97, 0x000205AC00021DAB, 0x000205AE00020DAD, 
0x00000D800003B9AF, 0x00001D8200001581, 0x80004C9F80004C9B, 0x003C54BE80004CA3, 0x003CA485001F9CEF, 0x80004CAB000210E1, 0x003E5086003F48E3, 0x80004CAF00033487, 
0x0002D5A880004CB3, 0x000101AA000101A9, 0x000101AC000101AB, 0x000131AE000109AD, 0x80004CB7000131AF, 0x80004CBF80004CBB, 0x80004CC780004CC3, 0x80004CCF80004CCB, 
0x00013DB880004CD3, 0x0001CDBA0001C5B9, 0x0001C1BC0001C5BB, 0x0001F9BE0001C9BD, 0x000125B00001F9BF, 0x000131B2000129B1, 0x000115B400010DB3, 0x00010DB600011DB5, 
0x000618E1000105B7, 0x0007B4E380004CD7, 0x80004CDF80004CDB, 0x80004CE780004CE3, 0x80004CEF80004CEB, 0x80004CF780004CF3, 0x80004CFF80004CFB, 0x0007E0EF80004D03, 
0x0000118080004D07, 0x0000118200001181, 0x80004D0B003C4084, 0x80004D1380004D0F, 0x003FECBE000614EF, 0x80004D1B000194E1, 0x003E508600065CE3, 0x80004D1F003C0087, 
0x003E09A380004D23, 0x80004CA70024258F, 0x80004D1700000884, 0x003E09A5003E09A6, 0x003E6DAB80004D27, 0x80004D2B003E61AA, 0x003E59AF80004D2F, 0x003E59AD003E51AE, 
0x0038619E003E65AC, 0x0034959C0038759F, 0x0035E59A0039F59D, 0x003079980034759B, 0x002CA19600317199, 0x002C6D940031C597, 0x00282192002C6595, 0x0029F59000290993, 
0x00140DB100287991, 0x001801B3001405B0, 0x001879B5001455B2, 0x80004D330018B5B4, 0x0001E0BE80004D37, 0x80004D3F80004D3B, 0x003CD1A280004D43, 0x003D75A0003D65A3, 
0x0000C9A1003CB9A1, 0x000401A380004D47, 0x00047DA50000DDA2, 0x0008F9A70004F5A4, 0x000C01A9000801A6, 0x000CCDAB00086DA8, 0x0010D1AD000CCDAA, 0x0011D5AF001001AC, 
0x80004D4B0010D9AE, 0x003F15B6003F15B5, 0x80004D5380004D4F, 0x80004D5B80004D57, 0x003F79BC003F15B3, 0x003F4DBE003F45BD, 0x80004D5F003F45BF, 0x003F7DBA80004D63, 
0x003FBDB3003F71BB, 0x80004D6B80004D67, 0x80004D7380004D6F, 0x003E7DB5003E7DB6, 0x003E59BB80004D77, 0x80004D7B003E51BA, 0x003EE1BF80004D7F, 0x003EFDBD003EF9BE, 
0x0025A182003E41BC, 0x80004D8300280983, 0x0028ED8680004D8B, 0x00299D84002D9187, 0x002DA98A0029CD85, 0x00070886002D658B, 0x00309D8E00008C87, 0x0030198C0034018F, 
0x0035E19200319D8D, 0x80004D8F00351993, 0x0039E19680004D93, 0x00386194003C1997, 0x003DE59A0039FD95, 0x80004D97003D859B, 0x00009D8180004D9B, 0x003C299C00009D80, 
0x003CE9A800007582, 0x003CF5AA003CFDA9, 0x003D35AC003D2DAB, 0x003D35AE003D3DAD, 0x80004D9F003D2DAF, 0x80004DA780004DA3, 0x80004DAF80004DAB, 0x000470BE80004DB3, 
0x003DDDB880004DB7, 0x003DEDBA003DE5B9, 0x003DFDBC003DE5BB, 0x003DEDBE003DE5BD, 0x003D55B0003DE1BF, 0x003D55B2003D5DB1, 0x003DFDB4003DE9B3, 0x003DEDB6003DE5B5, 
0x003C7DA3003DE5B7, 0x80004DBF80004DBB, 0x80004DC30005C4BE, 0x003DBDA5003DBDA6, 0x003D99AB80004DC7, 0x80004DCB003D91AA, 0x003D21AF80004DCF, 0x003D3DAD003D39AE, 
0x80004DD3003D81AC, 0x003D35B380004DD7, 0x0002F9B580004DDB, 0x80004DE380004DDF, 0x80004DE70002F1B6, 0x000241BB80004DEB, 0x000235BD000249BA, 0x0003F5BF000259BC, 
0x003CE9A80003FDBE, 0x003CF5AA003CFDA9, 0x000339AC000311AB, 0x000381AE000339AD, 0x0001C580000381AF, 0x0000198200000981, 0x80004DF380004DEF, 0x80004DFB00057884, 
0x000259B880004DFF, 0x00027DBA000275B9, 0x000219BC000209BB, 0x000209BE000219BD, 0x0003C5B0000201BF, 0x0003C5B20003CDB1, 0x000271B40003A9B3, 0x000269B6000279B5, 
0x80004E03000269B7, 0x0004C484003E58E3, 0x80004E07003F64E1, 0x80004E0B003E7CE1, 0x00040086000180E3, 0x80004E0F00048487, 0x001A14850001F4EF, 0x80004E13003EACEF, 
0x80004E1B80004E17, 0x80004E2380004E1F, 0x00079084003C31A3, 0x0003F5A60003FDA5, 0x80004E2B80004E27, 0x00034DAA80004E2F, 0x00035DAC000345AB, 0x0002F9AE000331AD, 
0x00058DA80002F1AF, 0x0005C5AA0005CDA9, 0x0005FDAC0005E5AB, 0x00063DAE000635AD, 0x80004DF7000635AF, 0x80004E3780004E33, 0x80004E3F80004E3B, 0x80004E4780004E43, 
0x0006E9B880004E4B, 0x000689BA0006E9B9, 0x00069DBC000689BB, 0x000681BE000681BD, 0x00064DB00006BDBF, 0x00065DB2000655B1, 0x0006F5B4000651B3, 0x0006E9B60006FDB5, 
0x00054DB30006E1B7, 0x80004E5380004E4F, 0x80004E5B80004E57, 0x000575B50006B5B6, 0x000691BB80004E5F, 0x80004E63000689BA, 0x000639BF80004E67, 0x000685BD000631BE, 
0x80004E6B000689BC, 0x80004D87000509A3, 0x0006F1A680004E6F, 0x80004E7780004E73, 0x0006CDAA000531A5, 0x000048860006D5AB, 0x000675AE00006C87, 0x0006CDAC00067DAF, 
0x000639A80006C1AD, 0x000689AA000639A9, 0x000689AC00069DAB, 0x0006A1AE0006BDAD, 0x0001B1800006A1AF, 0x000181820001B981, 0x80004E7F80004E7B, 0x80004E8780004E83, 
0x00016DB880004E8B, 0x00017DBA000175B9, 0x00016DBC000175BB, 0x0001D1BE0001D1BD, 0x0006A1B00001D1BF, 0x0006A1B20006A1B1, 0x000691B40006B1B3, 0x00015DB6000691B5, 
0x000601B3000155B7, 0x80004E9380004E8F, 0x80004E9B80004E97, 0x000601B500063DB6, 0x000665BB80004E9F, 0x80004EA3000665BA, 0x000655BF80004EA7, 0x000665BD000655BE, 
0x80004EAB000675BC, 0x80004EAF000645A3, 0x000679A680004EB3, 0x80004EBB80004EB7, 0x000621AA000645A5, 0x80004EBF000621AB, 0x000611AE80004EC3, 0x000631AC000611AF, 
0x0002C1A8000621AD, 0x0002DDAA0002C9A9, 0x00033DAC0002D5AB, 0x00032DAE000325AD, 0x80004EC7000325AF, 0x80004ECF80004ECB, 0x80004EDB80004ED3, 0x80004EE380004EDF, 
0x000381B8000270BE, 0x000385BA00038DB9, 0x000389BC000399BB, 0x0003B5BE0003BDBD, 0x00035DB000007DBF, 0x0003E1B20003E1B1, 0x0003E1B40003E1B3, 0x0003D1B60003E9B5, 
0x0000A5800003D1B7, 0x0000A5820000AD81, 0x80004EE7000259B3, 0x0003A9B60003B9B5, 0x000C008680004EEB, 0x000395BA0003F487, 0x000339BC000329BB, 0x000329BE000339BD, 
0x000215A3000321BF, 0x80004EF380004EEF, 0x80004EFB80004EF7, 0x0003F5A50003E5A6, 0x000365AB80004EFF, 0x80004F030003D9AA, 0x00036DAF80004F07, 0x000375AD000365AE, 
0x80004F0B000375AC, 0x80004F1380004F0F, 0x0003D4EF80004F17, 0x80004F1F80004F1B, 0x0006E0E380004F23, 0x0001D8E180004F27, 0x80004F2F80004F2B, 0x80004F3780004F33, 
0x80004F3F80004F3B, 0x00024484000660E3, 0x00006D800004FCE1, 0x0000058200001581, 0x000D6CBE80004F43, 0x000CC88680004F4B, 0x80004F4F000D5C87, 0x80004F530007B4EF, 
0x80004F5B80004F57, 0x80004F6380004F5F, 0x80004F6B80004F67, 0x80004F7380004F6F, 0x000DA0840007E8EF, 0x80004F7700061CE1, 0x80004F7B000634E3, 0x80004F8380004F7F, 
0x0001F9B380004F87, 0x80004F8F80004F8B, 0x80004F9780004F93, 0x000145B5000111B6, 0x00013DBB80004F9B, 0x80004F9F000135BA, 0x0000F5BF80004FA3, 0x000115BD0000F5BE, 
0x000E31A8000115BC, 0x000E31AA000E31A9, 0x000E8DAC000E9DAB, 0x000ED1AE000ED1AD, 0x80004F47000ED1AF, 0x80004FAB80004FA7, 0x0000198080004FAF, 0x0000058200001981, 
0x000F55B880004FB3, 0x000F55BA000F5DB9, 0x000F7DBC000F69BB, 0x000F6DBE000F65BD, 0x000EB1B0000F65BF, 0x000E81B2000EB9B1, 0x000F71B4000E81B3, 0x000F71B6000F71B5, 
0x000EB9A3000F71B7, 0x80004FB7000388BE, 0x80004FBF80004FBB, 0x000E05A5000E51A6, 0x000E7DAB80004FC3, 0x00000886000E75AA, 0x000FB5AF00036C87, 0x000E55AD000FB5AE, 
0x80004FC7000E55AC, 0x80004FCF80004FCB, 0x80004FD3000FB5B3, 0x000F5DB6000F55B5, 0x80004FD780004ED7, 0x000F79BA80004FDB, 0x000F69BC000F79BB, 0x000F49BE000F5DBD, 
0x000E65A8000F49BF, 0x000E71AA000E75A9, 0x000E91AC000E71AB, 0x000E91AE000E91AD, 0x80004FDF000E91AF, 0x80004FE780004FE3, 0x80004FEF80004FEB, 0x80004FF780004FF3, 
0x000E85B880004FFB, 0x000E85BA000E8DB9, 0x000E8DBC000E9DBB, 0x000EB5BE000EBDBD, 0x000EF1B0000179BF, 0x000EF1B2000EF1B1, 0x000EC1B4000EC5B3, 0x000EC1B6000EC1B5, 
0x000EF9A3000EC1B7, 0x8000500380004FFF, 0x8000500B80005007, 0x000E19A5000E11A6, 0x000E35AB8000500F, 0x80005013000E35AA, 0x000E05AF80005017, 0x000E11AD000E05AE, 
0x00000D80000E25AC, 0x00001D8200001581, 0x8000501F8000501B, 0x0001948480005023, 0x00074086000194BE, 0x8000502B0000F487, 0x800050338000502F, 0x8000503B80005037, 
0x00028DA88000503F, 0x000295AA000295A9, 0x0002D5AC0002CDAB, 0x0002C9AE0002DDAD, 0x800050430002FDAF, 0x8000504B80005047, 0x0000008C8000504F, 0x8000505780005053, 
0x00037DB88000505B, 0x0003C1BA0003C1B9, 0x0003C1BC0003C1BB, 0x0003F1BE0003C9BD, 0x000285B00003F1BF, 0x00034DB2000345B1, 0x00035DB4000345B3, 0x00034DB6000345B5, 
0x00021DB3000345B7, 0x800050638000505F, 0x8000506B80005067, 0x00025DB500025DB6, 0x000381BB8000506F, 0x80005073000241BA, 0x000381BF80005077, 0x000391BD000399BE, 
0x8000507B000399BC, 0x8000507F000259A3, 0x000219A680005083, 0x8000508B80005087, 0x000205AA000219A5, 0x8000508F0003C5AB, 0x0003DDAE80005093, 0x0003DDAC0003C5AF, 
0x8000509B0003D5AD, 0x000204840000CCE3, 0x0001C9800001BCE1, 0x0001F5820001FD81, 0x8000509F000510BE, 0x800050A3000428BE, 0x800050AB800050A7, 0x800050AF000010EF, 
0x0004E086800050B3, 0x800050B70002F487, 0x000E08E3800050BB, 0x000FE0E1800050BF, 0x000EF8EF800050C3, 0x800050CB800050C7, 0x800050D3800050CF, 0x800050DB800050D7, 
0x800050E3800050DF, 0x800050EB800050E7, 0x800050F3800050EF, 0x800050FB800050F7, 0x001524850001E0EF, 0x800050FF000ED4E1, 0x00002980000E1CE3, 0x0000058200001D81, 
0x000231B380005103, 0x0005CC848000510B, 0x800051138000510F, 0x000221B5000229B6, 0x0001CDBB80005117, 0x8000511B0001CDBA, 0x000175BF8000511F, 0x0001C1BD0001C9BE, 
0x0005E9A80001C9BC, 0x0005F9AA0005E9A9, 0x0005E9AC0005F9AB, 0x000639AE0005E9AD, 0x80005097000639AF, 0x0000888680005107, 0x8000512300030087, 0x8000512B80005127, 
0x0006D1B88000512F, 0x0006E1BA0006D9B9, 0x000691BC0006E1BB, 0x000695BE00069DBD, 0x000649B0000689BF, 0x00065DB2000649B1, 0x00064DB4000655B3, 0x0006F1B60006F1B5, 
0x000571A30006F1B7, 0x8000513780005133, 0x8000513F8000513B, 0x000561A5000569A6, 0x00068DAB80005143, 0x8000514700068DAA, 0x000635AF8000514B, 0x000681AD000689AE, 
0x8000514F000689AC, 0x0007E1B380005153, 0x0007E1B580005157, 0x8000515F8000515B, 0x800050270007E5B6, 0x0007BDBB80005163, 0x000795BD0007A1BA, 0x000795BF0007A9BC, 
0x000601A8000795BE, 0x000621AA000625A9, 0x000621AC000621AB, 0x000625AE00062DAD, 0x80005167000655AF, 0x00001D8100001D82, 0x8000516B00001D80, 0x800051738000516F, 
0x000639B8000130BE, 0x0006C9BA000639B9, 0x0006D9BC0006C9BB, 0x0006C9BE0006D9BD, 0x00062DB00006C9BF, 0x000635B2000631B1, 0x000619B4000609B3, 0x000609B6000619B5, 
0x0006A9A3000609B7, 0x001F288600028C84, 0x8000517B00014487, 0x0006A9A50006ADA6, 0x0006F5AB8000517F, 0x800051830006E9AA, 0x0006DDAF80005187, 0x0006DDAD0006DDAE, 
0x8000518B0006E1AC, 0x8000518F000615B3, 0x00063DB680005193, 0x8000519B80005197, 0x0001D9BA000635B5, 0x8000519F0001D9BB, 0x00017DBE800051A3, 0x00017DBC000165BF, 
0x0005C5A8000175BD, 0x0005D9AA0005C9A9, 0x0005F9AC0005D1AB, 0x000229AE0005F9AD, 0x800051A7000229AF, 0x800051AF800051AB, 0x0000008C800051B3, 0x800051BB800051B7, 
0x0002EDB8800051BF, 0x00028DBA000285B9, 0x000285BC000281BB, 0x0002BDBE00028DBD, 0x000259B000037DBF, 0x0002EDB2000259B1, 0x0002FDB40002E5B3, 0x0002E5B60002E5B5, 
0x000551A30002D5B7, 0x800051C7800051C3, 0x800051CF800051CB, 0x000571A5000579A6, 0x00029DAB800051D3, 0x800051D700029DAA, 0x000221AF800051DB, 0x000231AD000239AE, 
0x00001182000239AC, 0x00006580800051DF, 0x800051E300000981, 0x800051EB000398BE, 0x00032484800051EF, 0x00036887800051F3, 0x800051F7001C8C86, 0x800051FF800051FB, 
0x8000520780005203, 0x0002A1B38000520B, 0x0002D1B5001CC084, 0x800052138000520F, 0x800052170002D5B6, 0x0002C1BB8000521B, 0x000111BD0002F5BA, 0x000111BF0002D9BC, 
0x8000521F000119BE, 0x8000522780005223, 0x8000522F8000522B, 0x8000523780005233, 0x8000523B0006B8EF, 0x8000523F00049CE1, 0x80005243000674E3, 0x8000524B80005247, 
0x0000F9808000524F, 0x000005820000F981, 0x001C58BE80005253, 0x00005CEF001F5884, 0x000190E1000640EF, 0x00003CE30006FCE1, 0x8000525B000674E3, 0x001C98868000525F, 
0x000269A3001CF487, 0x80005263001F0CBE, 0x8000526B80005267, 0x000219A500021DA6, 0x000209AB8000526F, 0x8000527300023DAA, 0x0001D9AF80005277, 0x0001D9AD0001D1AE, 
0x001D91A8000211AC, 0x001DA1AA001D99A9, 0x001DD1AC001DA1AB, 0x001DD5AE001DDDAD, 0x800051E7001DC9AF, 0x8000527B80005257, 0x800052838000527F, 0x8000528B80005287, 
0x001E79B88000528F, 0x001ECDBA001E79B9, 0x001EDDBC001EC5BB, 0x001EC5BE001EC5BD, 0x001DB9B0001EF5BF, 0x001D85B2001D8DB1, 0x001E55B4001E4DB3, 0x001E55B6001E5DB5, 
0x001FCDB8001E49B7, 0x001FDDBA001FD5B9, 0x001FF1BC001FD5BB, 0x001FE9BE001FFDBD, 0x001FA5B0001FE9BF, 0x001FB1B2001FB1B1, 0x001F95B4001F8DB3, 0x001FFDB6001FF5B5, 
0x001E19A8001FF5B7, 0x001E2DAA001E19A9, 0x001E25AC001E3DAB, 0x001E25AE001E2DAD, 0x80005293001FDDAF, 0x8000529B80005297, 0x800052A38000529F, 0x800052A780005177, 
0x001FE5B3800052AB, 0x800052B3800052AF, 0x800052BB800052B7, 0x001FEDB5001FEDB6, 0x001E35BB800052BF, 0x800052C3001E21BA, 0x001E71BF800052C7, 0x001E19BD001E11BE, 
0x00006982001E25BC, 0x00005980001FA1A3, 0x001FA9A600005181, 0x800052CF800052CB, 0x001E65AA001FA9A5, 0x00040086001E71AB, 0x001E55AE0001EC87, 0x001E61AC001E35AF, 
0x001E31A8001E5DAD, 0x001E41AA001E31A9, 0x001E41AC001E41AB, 0x001E71AE001E49AD, 0x800052D3001E71AF, 0x800052DB800052D7, 0x800052E3800052DF, 0x800052EB800052E7, 
0x000129B8800052EF, 0x000139BA000129B9, 0x00012DBC000135BB, 0x0000D1BE0000D1BD, 0x0001C9B00000D1BF, 0x0001D9B20001C9B1, 0x0001C9B40001D9B3, 0x000119B60001C9B5, 
0x001DC9B3000119B7, 0x800052F7800052F3, 0x800052FF800052FB, 0x001DC9B5001DC9B6, 0x00020DBB80005303, 0x8000530700020DBA, 0x00020DBF8000530B, 0x00020DBD00020DBE, 
0x8000530F00020DBC, 0x80005313001D8DA3, 0x001D8DA680005317, 0x8000531F8000531B, 0x000249AA001D8DA5, 0x80005323000249AB, 0x000249AE80005327, 0x000249AC000249AF, 
0x00000D80000249AD, 0x0000118200001181, 0x0002CCEF8000532B, 0x800053338000532F, 0x00022CE300029084, 0x0001D8E1000328BE, 0x000410868000533B, 0x8000533F0003D487, 
0x000361B380005343, 0x8000534B80005347, 0x800053538000534F, 0x000371B5000379B6, 0x00035DBB80005357, 0x8000535B00035DBA, 0x0000E1BF8000535F, 0x0000F1BD0000F9BE, 
0x0002A1A30000F9BC, 0x8000536780005363, 0x8000536F8000536B, 0x0002B1A50002B9A6, 0x00029DAB80005373, 0x8000537700029DAA, 0x000121AF8000537B, 0x000131AD000139AE, 
0x8000537F000139AC, 0x001F64EF80005383, 0x8000538B80005387, 0x800053938000538F, 0x00000D8080005397, 0x0000158200001181, 0x001CE0E18000539B, 0x001F88E38000539F, 
0x00028084800053A3, 0x0005488700058CBE, 0x800053AB00042C86, 0x001EA4EF800053AF, 0x001E00E1001EF4EF, 0x001E2CE3001F50E1, 0x800053B3001EB0E3, 0x800053BB800053B7, 
0x800053C3800053BF, 0x00048484800053C7, 0x800053CB000171B3, 0x000115B600011DB5, 0x800053D3800053CF, 0x000101BA800053D7, 0x0000F5BC000101BB, 0x0000F5BE0000FDBD, 
0x0006ADA80000EDBF, 0x0006B5AA0006BDA9, 0x0006D9AC0006C9AB, 0x0006C9AE0006D9AD, 0x800053DB0006C1AF, 0x800053E3800053DF, 0x800053EB800053E7, 0x800053F3800053EF, 
0x00076DB8800053F7, 0x00070DBA000705B9, 0x000701BC000701BB, 0x000701BE000701BD, 0x000689B0000701BF, 0x00076DB2000689B1, 0x00077DB4000765B3, 0x000765B6000765B5, 
0x80005337000755B7, 0x800053FB000639A3, 0x00065DA6800053A7, 0x80005403800053FF, 0x000649AA000655A5, 0x80005407000649AB, 0x0007BDAE8000540B, 0x0007BDAC0007A5AF, 
0x00006D800007B5AD, 0x0000198200000981, 0x800054138000540F, 0x8000541700039CBE, 0x000040868000541B, 0x8000541F00006087, 0x8000542780005423, 0x8000542F8000542B, 
0x000691A880005433, 0x0006B9AA000691A9, 0x0006A9AC0006B9AB, 0x0006D9AE0006A9AD, 0x800054370006D9AF, 0x8000543F8000543B, 0x8000544780005443, 0x8000544F8000544B, 
0x000171B880005453, 0x000171BA000171B9, 0x0001D9BC000171BB, 0x0001C1BE0001C1BD, 0x0006B1B00001F5BF, 0x000689B20006B9B1, 0x000151B4000689B3, 0x000151B6000151B5, 
0x000631B3000151B7, 0x8000545B80005457, 0x800054638000545F, 0x000621B5000629B6, 0x00067DBB80005467, 0x8000546B000675BA, 0x000195BF8000546F, 0x00065DBD000195BE, 
0x8000547300065DBC, 0x80005477000675A3, 0x00066DA68000547B, 0x800054838000547F, 0x000631AA000665A5, 0x0001AC84000639AB, 0x0001D1AE0001A0BE, 0x000619AC0001D1AF, 
0x0002DDA8000619AD, 0x0002E5AA0002EDA9, 0x0002E5AC0002FDAB, 0x0002E5AE0002EDAD, 0x8000548B00033DAF, 0x800054938000548F, 0x80005497000C64BE, 0x8000549F8000549B, 
0x0003C9B8800054A3, 0x0003D9BA0003C9B9, 0x0003F9BC0003D1BB, 0x000399BE0003F9BD, 0x000345B0000395BF, 0x000345B200034DB1, 0x000345B400035DB3, 0x000345B600034DB5, 
0x000355810003F9B7, 0x000265B300034980, 0x000265B500035582, 0x800054AB800054A7, 0x000C0086000265B6, 0x000381BB0003E487, 0x000381BD000389BA, 0x000381BF000399BC, 
0x00022DA3000389BE, 0x800054B3800054AF, 0x800054BB800054B7, 0x00022DA500022DA6, 0x0003C9AB800054BF, 0x800054C30003C1AA, 0x0003C9AF800054C7, 0x0003C9AD0003C1AE, 
0x0006D8E30003D1AC, 0x00069CE10007ACE1, 0x800054CB00069CE3, 0x800054CF000D5884, 0x800054D7800054D3, 0x800054DF800054DB, 0x00011CEF800054E3, 0x800054EB800054E7, 
0x00007980000640EF, 0x0000118200001581, 0x800054EF000C0084, 0x800054F30000ACE3, 0x800054FB0001A4E1, 0x000CC886000070EF, 0x800054FF000DA487, 0x8000550780005503, 
0x0005C9BA8000550B, 0x0005A5B80005C9BB, 0x0005F9BE0005CDB9, 0x0005CDBC0005F9BF, 0x0005A5B20005C5BD, 0x000611B00005ADB3, 0x0005ADB6000611B1, 0x0005B5B400059DB7, 
0x000661AA0005ADB5, 0x00069DA8000661AB, 0x000661AE000695A9, 0x000671AC000661AF, 0x8000550F000671AD, 0x8000551780005513, 0x8000551F8000551B, 0x000CB0BE80005523, 
0x000E21A880005527, 0x000E21AA000E21A9, 0x000E25AC000E3DAB, 0x000E25AE000E2DAD, 0x800054F7000E89AF, 0x8000552F8000552B, 0x8000553780005533, 0x8000553F8000553B, 
0x000F51B880005543, 0x000F55BA000F5DB9, 0x000F75BC000F6DBB, 0x000F75BE000F7DBD, 0x000EF9B0000F69BF, 0x000EA1B2000EA1B1, 0x000EA1B4000EA1B3, 0x000E91B6000EA9B5, 
0x000EA9B3000E91B7, 0x8000548780005547, 0x8000554F8000554B, 0x000EADB5000EADB6, 0x000E65BB80005553, 0x80005557000E3DBA, 0x000E6DBF8000555B, 0x000E75BD000E65BE, 
0x00001982000E75BC, 0x00006580000EEDA3, 0x000EE9A600001981, 0x800055638000555F, 0x000E79AA000EE9A5, 0x80005567000E21AB, 0x000E21AE8000556B, 0x000E31AC000E29AF, 
0x000E61A8000E31AD, 0x000E7DAA000E75A9, 0x000E6DAC000E75AB, 0x000EFDAE000EF5AD, 0x00018086000EF5AF, 0x8000556F0001A487, 0x8000557780005573, 0x8000557F8000557B, 
0x000175B880005583, 0x000175BA00017DB9, 0x0001DDBC0001C9BB, 0x0001C5BE0001C5BD, 0x000E8DB00001F5BF, 0x000E9DB2000E95B1, 0x000155B4000E91B3, 0x000155B600015DB5, 
0x000EF5B300014DB7, 0x8000558B80005587, 0x800055938000558F, 0x000EE5B5000E75B6, 0x000E51BB80005597, 0x8000559B000E49BA, 0x000199BF8000559F, 0x000E45BD000191BE, 
0x800055A3000E49BC, 0x800055A7000EB1A3, 0x000E31A6800055AB, 0x800055B3800055AF, 0x000E0DAA000EA1A5, 0x800055B7000E15AB, 0x0001D5AE800055BB, 0x000E0DAC0001DDAF, 
0x0002EDA8000E01AD, 0x000325AA00032DA9, 0x000325AC00033DAB, 0x000325AE00032DAD, 0x800055BF000399AF, 0x800055C7800055C3, 0x800055CF800055CB, 0x000274BE800055D3, 
0x00038DB8800055DB, 0x000391BA000391B9, 0x0003BDBC0003A5BB, 0x00007DBE000075BD, 0x0003E9B0000075BF, 0x0003F9B20003E9B1, 0x0003D9B40003F1B3, 0x0003B9B60003D9B5, 
0x0000AD800003B5B7, 0x0000BD820000B581, 0x800055DF0003A1B3, 0x0003A1B60003A1B5, 0x0002E084800055E3, 0x000321BA800055E7, 0x000321BC000321BB, 0x000311BE000329BD, 
0x0003EDA3000311BF, 0x0004E886800055EB, 0x800055EF00034C87, 0x0003EDA50003EDA6, 0x00036DAB800055F3, 0x800055F700036DAA, 0x00035DAF800055FB, 0x000365AD00035DAE, 
0x800055FF00036DAC, 0x0023D4EF000E00E3, 0x80005603000FB4E1, 0x8000560B80005607, 0x0003A9A18000560F, 0x0003C1A3000FFDA0, 0x001284E100030DA2, 0x00F3E4E3000FE0EF, 
0x8000561780005613, 0x000484848000561B, 0x8000561F000484BE, 0x80005623000394EF, 0x8000562B80005627, 0x8000562F0003D4E3, 0x80005633000054E1, 0x8000563B80005637, 
0x0000F9808000563F, 0x000005820000F981, 0x8000564B80005643, 0x001B918F8000564F, 0x0007EC84000E9CEF, 0x80005653000ED4E1, 0x80005657000EF0E3, 0x000718868000565B, 
0x0017E5990004F487, 0x000BE99B0017E598, 0x000AFD9D000B399A, 0x000F559F000BF19C, 0x001F2991000F5D9E, 0x001F4593001BF590, 0x0013D195001FCD92, 0x0017199700132994, 
0x000005A100137596, 0x00FC01A3800055D7, 0x00FC01A5000055A2, 0x00F819A700FC11A4, 0x00F909A900FD45A6, 0x00F409AB00F821A8, 0x00F001AD00F401AA, 0x00F0F1AF00F515AC, 
0x00EC01B100F01DAE, 0x00E801B300EC01B0, 0x00E84DB500EC11B2, 0x8000564700E851B4, 0x800056638000565F, 0x8000566B80005667, 0x800056738000566F, 0x8000567B80005677, 
0x0006BDA88000567F, 0x000615AA000615A9, 0x000655AC000629AB, 0x000645AE000645AD, 0x0000E8BE000675AF, 0x8000568780005683, 0x8000568F8000568B, 0x8000569780005693, 
0x000785B88000569B, 0x000791BA000795B9, 0x0007B1BC000791BB, 0x0007A9BE0007BDBD, 0x00060DB00007A9BF, 0x0007F9B20007E5B1, 0x0007E9B40007F9B3, 0x0007C5B60007E9B5, 
0x00079DB30007BDB7, 0x800056A38000569F, 0x800056AB800056A7, 0x0007DDB50007C5B6, 0x000621BB800056AF, 0x800056B30007C9BA, 0x00062DBF800056BB, 0x00062DBD00062DBE, 
0x0000698200062DBC, 0x000059800007D9A3, 0x000781A600005181, 0x800056C3800056BF, 0x00078DAA000799A5, 0x0000C886000665AB, 0x000669AE0001A487, 0x000669AC000669AF, 
0x000D758F000669AD, 0x0011A98D0011A18E, 0x0015198B00116D8C, 0x800056C70015B58A, 0x00157D87800056CB, 0x0019898500190986, 0x001DA18300196584, 0x800056CF001DBD82, 
0x800056D7800056D3, 0x800056DF800056DB, 0x0005F19B0005259C, 0x800056E300055D9A, 0x00093997800056E7, 0x0009699500096996, 0x000DD593000CC194, 0x800056EB000DD592, 
0x000591A8800056EF, 0x0005A1AA000591A9, 0x0005A5AC0005BDAB, 0x000279AE000249AD, 0x00FCEC84000279AF, 0x800056F7800056F3, 0x800056FF800056FB, 0x8000570780005703, 
0x0002EDB88000570B, 0x0002FDBA0002F5B9, 0x0002EDBC0002F5BB, 0x000351BE000351BD, 0x000209B0000351BF, 0x000219B2000209B1, 0x000209B4000219B3, 0x0002DDB6000209B5, 
0x000529B30002D5B7, 0x8000570F00FD4884, 0x8000571780005713, 0x00052DB50002C9B6, 0x0002CDBB8000571B, 0x8000571F0002CDBA, 0x0002CDBF80005723, 0x0002CDBD0002CDBE, 
0x00006D820002CDBC, 0x0000558000056DA3, 0x00028DA600006581, 0x8000572B00FC1CBE, 0x000289AA000569A5, 0x00FCC886000289AB, 0x000289AE00030487, 0x000289AC000289AF, 
0x00022DA8000289AD, 0x000251AA000251A9, 0x00028DAC000295AB, 0x0002A5AE0002ADAD, 0x8000572F0002DDAF, 0x8000573780005733, 0x8000573F8000573B, 0x8000574780005743, 
0x00016DB88000574B, 0x00017DBA000175B9, 0x00016DBC000175BB, 0x0001D5BE0001DDBD, 0x0002A5B00001CDBF, 0x0002B1B20002ADB1, 0x000289B40002B1B3, 0x00015DB6000289B5, 
0x000750E1000155B7, 0x0006D0E38000574F, 0x8000575780005753, 0x8000575F8000575B, 0x8000576780005763, 0x8000576F8000576B, 0x8000577780005773, 0x00060CEF8000577B, 
0x8000577F00FC74BE, 0x00FCE88680005783, 0x8000578700FC8487, 0x8000578B000664E3, 0x0000158200067CE1, 0x000031800001BCEF, 0x8000578F00001D81, 0x8000579B80005793, 
0x00FD59B38000579F, 0x800056B780005727, 0x80005797800057A3, 0x00FD85B500FDADB6, 0x00FDE9BB800057A7, 0x800057AB00FDE1BA, 0x00FDCDBF800057AF, 0x00FDE5BD00FDCDBE, 
0x800057B300FDE5BC, 0x800057B700FD1DA3, 0x00FDE9A6800057BB, 0x800057C3800057BF, 0x00FDA5AA00FDC1A5, 0x800057C700FDADAB, 0x00FD89AE800057CB, 0x00FDA1AC00FD89AF, 
0x00FE59A800FDA1AD, 0x00FFADAA00FFA5A9, 0x00FFBDAC00FFA5AB, 0x00FFADAE00FFA5AD, 0x800057CF00FFA5AF, 0x800057D7800057D3, 0x800057DF800057DB, 0x800057E7800057E3, 
0x00FF65B8800057EB, 0x00FF65BA00FF6DB9, 0x00FF65BC00FF7DBB, 0x00FF1DBE00FF15BD, 0x00FFDDB000FF0DBF, 0x00FF65B200FF61B1, 0x00FF65B400FF7DB3, 0x00FF65B600FF6DB5, 
0x00FE25B300FF5DB7, 0x800057F3800057EF, 0x800057FB800057F7, 0x00FE35B500FE25B6, 0x00FEA5BB800057FF, 0x8000580300FE19BA, 0x00FEA9BF0001E084, 0x00FEA9BD00FEA1BE, 
0x0000698200FEB1BC, 0x0000598000FE61A3, 0x00FE61A600005181, 0x8000580700019CBE, 0x00FE5DAA00FE71A5, 0x0000C88600FEE1AB, 0x00FEE5AE0001FC87, 0x00FEF5AC00FEEDAF, 
0x00FE79A800FEEDAD, 0x000185AA00FE79A9, 0x0001B9AC000191AB, 0x0001D9AE0001B9AD, 0x0000A0840001D5AF, 0x8000580F8000580B, 0x8000581780005813, 0x8000581F8000581B, 
0x00016DB880005823, 0x00017DBA000175B9, 0x00016DBC000175BB, 0x0000D1BE0000D1BD, 0x0001ADB00000D1BF, 0x0001B1B20001B1B1, 0x00019DB4000185B3, 0x00015DB6000155B5, 
0x00020DB3000155B7, 0x8000582B80005827, 0x800058338000582F, 0x000231B5000239B6, 0x000275BB80005837, 0x8000583B000269BA, 0x000291BF8000583F, 0x000251BD000259BE, 
0x80005843000265BC, 0x80005847000249A3, 0x00027DA68000584B, 0x800058538000584F, 0x00022DAA000275A5, 0x80005857000231AB, 0x00021DAE8000585B, 0x000221AC0002D5AF, 
0x8000585F000215AD, 0x8000586780005863, 0x00001D808000586B, 0x0000398200000981, 0x800058738000586F, 0x8000587B000400BE, 0x800058838000587F, 0x8000588B80005887, 
0x0004E0868000588F, 0x000544BE00030487, 0x8000589300044084, 0x80005897000164E3, 0x8000589B0001ACE1, 0x8000589F0002B8EF, 0x800058A7800058A3, 0x800058AF800058AB, 
0x0002A5A8800058B3, 0x0002A5AA0002ADA9, 0x0002A5AC0002BDAB, 0x0002A5AE0002ADAD, 0x0004A084000119AF, 0x800058BB800058B7, 0x800058C3800058BF, 0x800058CB800058C7, 
0x00010DB80007B0BE, 0x000111BA000111B9, 0x00013DBC000125BB, 0x0001DDBE0001D5BD, 0x000169B00001D5BF, 0x000179B2000169B1, 0x000159B4000171B3, 0x000139B6000159B5, 
0x00FF70E1000135B7, 0x00FF1CE300FFB4E3, 0x800058CF00FCFCE1, 0x800058D300FE44E1, 0x800058D70000A0E3, 0x800058DF800058DB, 0x0006FCBE000000EF, 0x00FEFCEF00FF98EF, 
0x00006580800058E3, 0x0000758200006D81, 0x800058EB000261B3, 0x000261B6000261B5, 0x0004C086800058EF, 0x0001E1BA0004A487, 0x0001E1BC0001E1BB, 0x0001D1BE0001E9BD, 
0x800058770001D1BF, 0x000605AB800058E7, 0x00060DAD000605AA, 0x000635AF000605AC, 0x800058F3000635AE, 0x000585A3800058F7, 0x000585A5800058FB, 0x80005903800058FF, 
0x0006F1B3000585A6, 0x8000590B80005907, 0x800059138000590F, 0x0006E1B50006E9B6, 0x000689BB80005917, 0x8000591B000685BA, 0x000689BF8000591F, 0x000689BD000681BE, 
0x000629A8000691BC, 0x000639AA000629A9, 0x000629AC000639AB, 0x000649AE000629AD, 0x80005923000645AF, 0x8000592B80005927, 0x800059338000592F, 0x8000593B80005937, 
0x0007E9B88000593F, 0x0007F9BA0007E9B9, 0x0007E9BC0007F9BB, 0x000741BE000745BD, 0x000601B000077DBF, 0x000605B200060DB1, 0x000605B400061DB3, 0x000605B600060DB5, 
0x0007B1A30007D9B7, 0x8000594780005943, 0x8000594F8000594B, 0x0007A1A50007A9A6, 0x0007C9AB80005953, 0x800059570007C5AA, 0x0007C9AF8000595B, 0x0007C9AD0007C1AE, 
0x00004D800007D1AC, 0x0000558200005581, 0x8000595F00016DB3, 0x00016DB6000179B5, 0x0000C08680005963, 0x000121BA00010487, 0x000121BC000121BB, 0x000111BE000129BD, 
0x000651A8000111BF, 0x0001A9AA000659A9, 0x0001BDAC0001A9AB, 0x0001A1AE0001A1AD, 0x0001AC840001D9AF, 0x8000596B80005967, 0x800059738000596F, 0x8000597B80005977, 
0x000169B88000597F, 0x000179BA000169B9, 0x000169BC000179BB, 0x0000DDBE000169BD, 0x0001A9B00000D5BF, 0x0001B9B20001A9B1, 0x000199B40001B1B3, 0x000159B6000199B5, 
0x000221A3000159B7, 0x8000598780005983, 0x8000598F8000598B, 0x000235A5000221A6, 0x00026DAB80005993, 0x8000599700026DAA, 0x00025DAF8000599B, 0x000265AD00025DAE, 
0x8000599F00026DAC, 0x800059A7800059A3, 0x800059AF800059AB, 0x800059B7800059B3, 0x00003D80800059BB, 0x0000198200000981, 0x800059C3800059BF, 0x00034487800059CB, 
0x800059CF000CDC86, 0x800059D7800059D3, 0x800059DB000CC084, 0x800059DF0007DCEF, 0x800059E7800059E3, 0x800059EB000114E3, 0x800059EF0001D4E1, 0x800059F7800059F3, 
0x00039DB3800059FB, 0x80005A03800059FF, 0x80005A0B80005A07, 0x000371B5000379B6, 0x00035DBB80005A0F, 0x80005A1300035DBA, 0x0000E1BF80005A17, 0x0000F1BD0000F9BE, 
0x00022DA80000F9BC, 0x000255AA000255A9, 0x0002B9AC0002A9AB, 0x0002A9AE0002B9AD, 0x000D68BE0002A9AF, 0x80005A1F80005A1B, 0x80005A2780005A23, 0x0000AD810000AD82, 
0x00016DB80000AD80, 0x00010DBA000105B9, 0x00011DBC000105BB, 0x00010DBE000105BD, 0x0002D9B0000105BF, 0x00016DB20002D9B1, 0x00017DB4000165B3, 0x000165B6000165B5, 
0x000678E1000155B7, 0x0006B8E300075CE1, 0x80005A2B000750E3, 0x80005A3380005A2F, 0x80005A3F80005A3B, 0x80005A4780005A43, 0x000CF8BE80005A4B, 0x00067CEF80005A4F, 
0x00029DA300078CEF, 0x000C688680005A53, 0x80005A57000D0487, 0x000271A5000279A6, 0x00025DAB80005A5B, 0x80005A5F00025DAA, 0x0001E1AF80005A63, 0x0001F1AD0001F9AE, 
0x000E75A80001F9AC, 0x000E8DAA000E85A9, 0x000E81AC000E85AB, 0x000E85AE000E8DAD, 0x80005A37000EBDAF, 0x80005A6B80005A67, 0x80005A6F800059C7, 0x80005A7780005A73, 
0x000E91B880005A7B, 0x000EA1BA000E99B9, 0x000F75BC000EA1BB, 0x000F75BE000F7DBD, 0x000EC9B0000F6DBF, 0x000EDDB2000ED5B1, 0x000ECDB4000ED5B3, 0x000EB1B6000EB1B5, 
0x000E05B3000EB1B7, 0x80005A8380005A7F, 0x80005A8B80005A87, 0x000E09B5000E0DB6, 0x000E11BB80005A8F, 0x80005A93000E0DBA, 0x000E75BF80005A97, 0x000E01BD000E09BE, 
0x00002982000E09BC, 0x00001D80000E41A3, 0x000E49A600001581, 0x80005A9F80005A9B, 0x000E49AA000E4DA5, 0x80005AA3000E55AB, 0x000E4DAE0003A084, 0x000E4DAC000E31AF, 
0x000E9DA8000E45AD, 0x000EADAA000EA5A9, 0x000EBDAC000EA5AB, 0x000EDDAE000EA1AD, 0x80005AA7000ECDAF, 0x0001888680005AAB, 0x80005AAF0001AC87, 0x80005AB780005AB3, 
0x00017DB880005ABB, 0x0001C1BA0001C1B9, 0x0001C1BC0001C1BB, 0x0001F1BE0001C9BD, 0x000EBDB00001F1BF, 0x000E85B2000E8DB1, 0x000159B4000149B3, 0x00014DB6000145B5, 
0x000E25B3000145B7, 0x80005AC380005ABF, 0x80005ACB80005AC7, 0x000E35B5000E21B6, 0x000E49BB80005ACF, 0x80005AD3000E79BA, 0x000181BF80005AD7, 0x00019DBD00019DBE, 
0x80005ADB000E51BC, 0x80005ADF000E61A3, 0x000E65A680005AE3, 0x80005AEB80005AE7, 0x000E3DAA000E71A5, 0x80005AEF000E0DAB, 0x0001D9AE80005AF3, 0x000E15AC0001C5AF, 
0x000325A80001D9AD, 0x00033DAA000335A9, 0x00032DAC000335AB, 0x000391AE000391AD, 0x80005AF7000391AF, 0x80005AFF80005AFB, 0x80005B0780005B03, 0x80005B0F80005B0B, 
0x000399B880005B13, 0x0003A5BA0003ADB9, 0x000075BC00006DBB, 0x000075BE00007DBD, 0x0003F1B000006DBF, 0x0003C1B20003F9B1, 0x0003B1B40003C1B3, 0x0003B5B60003BDB5, 
0x0000B5800003A9B7, 0x0000B5820000BD81, 0x80005B1B00030CBE, 0x80005B2380005B1F, 0x0002AC840002E8EF, 0x80005B27000194E1, 0x80005B2B00021CE3, 0x0003D88780005B2F, 
0x0003F5B300041C86, 0x001FA48580005B33, 0x80005B3B80005B37, 0x0003E5B5000351B6, 0x00037DBB80005B3F, 0x80005B43000375BA, 0x000339BF80005B47, 0x000355BD000335BE, 
0x80005B4B000355BC, 0x80005B5380005B4F, 0x80005B57000239A3, 0x00029DA6000229A5, 0x80005B5F80005B5B, 0x0002B9AA80005B63, 0x000299AC0002B1AB, 0x0002F9AE000299AD, 
0x80005B670002F5AF, 0x0002448480005B6B, 0x80005B6F000540BE, 0x80005B7780005B73, 0x00003D8080005B7B, 0x0000198200000981, 0x80005B8380005B7F, 0x0005F48780005B8B, 
0x80005B8F0004DC86, 0x80005B9780005B93, 0x000E48EF80005B9B, 0x80005BA380005B9F, 0x000F3CE3000ED4EF, 0x000FCCE1000E74E1, 0x80005BA7000150E3, 0x80005BAF80005BAB, 
0x000159B380005BB3, 0x80005BBB80005BB7, 0x80005BC380005BBF, 0x000169B5000161B6, 0x00013DBB80005BC7, 0x80005BCB000135BA, 0x0000F5BF80005BCF, 0x000115BD0000F5BE, 
0x000691A8000115BC, 0x000691AA000691A9, 0x0006A1AC0006A5AB, 0x0006DDAE0006A1AD, 0x80005B870006D1AF, 0x80005BD780005BD3, 0x80005B1780005BDB, 0x80005BE380005BDF, 
0x00075DB880005BE7, 0x00076DBA000765B9, 0x000715BC00070DBB, 0x00070DBE000705BD, 0x0006B1B0000705BF, 0x000681B20006B9B1, 0x000771B4000681B3, 0x000771B6000771B5, 
0x000619A300076DB7, 0x0000158100002D82, 0x80005BEB00001D80, 0x000629A5000621A6, 0x00067DAB80005BEF, 0x80005BF3000675AA, 0x0007B5AF0002A484, 0x000655AD0007B5AE, 
0x0003CCBE000655AC, 0x80005BF7000741B3, 0x000745B680005BFB, 0x80005C0380005BFF, 0x000755BA000751B5, 0x0000488600075DBB, 0x000739BE00030C87, 0x000745BC000739BF, 
0x000675A8000739BD, 0x00068DAA000685A9, 0x00069DAC000685AB, 0x000681AE000681AD, 0x80005C070006ADAF, 0x80005C0F80005C0B, 0x80005C1780005C13, 0x80005C1F80005C1B, 
0x0006A9B880005C23, 0x00016DBA0006A9B9, 0x00017DBC000165BB, 0x000161BE000161BD, 0x0006D5B0000161BF, 0x0006D5B20006DDB1, 0x0006B9B40006A9B3, 0x0006A9B60006B9B5, 
0x000605A30006A1B7, 0x80005C2B80005C27, 0x80005C3380005C2F, 0x000615A5000601A6, 0x000619AB80005C37, 0x80005C3B000611AA, 0x00067DAF80005C3F, 0x00067DAD00067DAE, 
0x80005C43000601AC, 0x80005C4B80005C47, 0x80005C5380005C4F, 0x80005C5B80005C57, 0x0000398080005C5F, 0x0000058200003981, 0x0001B8BE80005C63, 0x80005C6B0001B884, 
0x0002CDA880005C6F, 0x0002D1AA0002D1A9, 0x000335AC00032DAB, 0x000335AE00033DAD, 0x80005C7300032DAF, 0x80005C7B80005C77, 0x80005C8380005C7F, 0x001C34BE80005C87, 
0x0003E9B880005C8B, 0x000389BA0003E9B9, 0x000399BC000389BB, 0x000389BE000399BD, 0x000355B0000389BF, 0x000355B200035DB1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 
0x000259B30003E1B7, 0x0003948780005C8F, 0x80005C93001C4C86, 0x0003BDB50003BDB6, 0x000399BB80005C97, 0x80005C9B000391BA, 0x00033DBF80005C9F, 0x00033DBD00033DBE, 
0x80005CA3000381BC, 0x80005CA700021DA3, 0x0003F9A680005CAB, 0x80005CB380005CAF, 0x0003D5AA0003F9A5, 0x80005CB70003DDAB, 0x000379AE80005CBB, 0x0003C5AC000379AF, 
0x80005CBF000379AD, 0x0002048480005CC3, 0x80005CC7001C00BE, 0x00003D8100003D82, 0x80005CCB00003D80, 0x80005CD380005CCF, 0x80005CDF80005CDB, 0x80005CE780005CE3, 
0x80005CEF80005CEB, 0x80005CF30000A0E3, 0x001CF0860001BCE1, 0x80005CF7001D0487, 0x80005CFF80005CFB, 0x80005D0780005D03, 0x80005D0F80005D0B, 0x80005D1300007CEF, 
0x80005D1B80005D17, 0x80005D2380005D1F, 0x80005D27000638EF, 0x80005D2F80005D2B, 0x001DA8840001A4EF, 0x80005D330006C0E1, 0x80005D37000110E3, 0x80005D3B000710E1, 
0x0001E1B30006E4E3, 0x80005D4380005D3F, 0x80005D4F80005D4B, 0x0001F1B50001F9B6, 0x000165BB80005D53, 0x001F48860001D9BA, 0x00015DBF001CD087, 0x000165BD00015DBE, 
0x001E3DB000016DBC, 0x001E99B2001E81B1, 0x001EB9B4001E91B3, 0x001ED9B6001EB9B5, 0x001EEDB8001ED5B7, 0x001EF1BA001EF1B9, 0x001EDDBC001EC5BB, 0x001F3DBE001F35BD, 
0x80005CD7001F2DBF, 0x80005D5780005C67, 0x001FE98080005D5B, 0x001F9182001F9181, 0x001D99A880005D47, 0x001E49AA001D99A9, 0x001E59AC001E49AB, 0x001E49AE001E59AD, 
0x001EA1A3001E49AF, 0x80005D6380005D5F, 0x80005D6B80005D67, 0x001EB1A5001EB9A6, 0x001E25AB80005D6F, 0x80005D73001E99AA, 0x001E1DAF80005D77, 0x001E25AD001E1DAE, 
0x80005D7B001E2DAC, 0x80005D7F001FF1B3, 0x001F91B680005D83, 0x80005D8B80005D87, 0x001FBDBA001FE1B5, 0x80005D8F001F85BB, 0x001F9DBE80005D93, 0x001F9DBC001F85BF, 
0x001E2DA8001F95BD, 0x001E3DAA001E35A9, 0x001E2DAC001E35AB, 0x001E51AE001E55AD, 0x80005D97001E45AF, 0x80005D9F80005D9B, 0x80005DA780005DA3, 0x0000B1810000B982, 
0x001EC1B80000B980, 0x001EC1BA001EC1B9, 0x001EC5BC001EDDBB, 0x001EF1BE001ECDBD, 0x001E3DB0001EEDBF, 0x001E0DB2001E05B1, 0x001E1DB4001E05B3, 0x001E01B6001E05B5, 
0x001EB5A3001E01B7, 0x80005DAF80005DAB, 0x0002988480005DB3, 0x001EA5A5001ED5A6, 0x001EC1AB000190BE, 0x00000886001EF9AA, 0x001EC1AF00017C87, 0x001ED1AD001ED9AE, 
0x80005DBB001ED9AC, 0x80005DBF001E19B3, 0x000155B680005DC3, 0x80005DCB80005DC7, 0x000171BA000191B5, 0x80005DCF000179BB, 0x000131BE80005DD3, 0x000151BC00013DBF, 
0x001DCDA8000151BD, 0x001DD5AA001DD5A9, 0x00025DAC000245AB, 0x000291AE000291AD, 0x80005DD7000291AF, 0x80005DDF80005DDB, 0x80005DE780005DE3, 0x80005DEF80005DEB, 
0x000299B880005DF3, 0x0002A5BA0002ADB9, 0x000375BC00036DBB, 0x000375BE00037DBD, 0x0002F1B000036DBF, 0x0002C1B20002F9B1, 0x0002B1B40002C1B3, 0x0002B5B60002BDB5, 
0x001D5DA30002A9B7, 0x80005DFB80005DF7, 0x80005E0380005DFF, 0x0002D5A5000211A6, 0x00023DAB80005E07, 0x80005E0B000235AA, 0x000279AF80005E0F, 0x000215AD000275AE, 
0x00044CBE000215AC, 0x80005E1780005E13, 0x00001D8080005E1B, 0x0000398200000981, 0x80005E2380005E1F, 0x0004C8860003A884, 0x80005E2B0004A887, 0x80005E3380005E2F, 
0x0002C1A880005E37, 0x0002C5AA0002CDA9, 0x0002C9AC0002D9AB, 0x0002F5AE0002FDAD, 0x80005E3B00013DAF, 0x80005E4380005E3F, 0x80005E4B80005E47, 0x80005E5380005E4F, 
0x0001C9B80004F4BE, 0x0001D9BA0001C9B9, 0x0001F9BC0001D1BB, 0x00019DBE0001F9BD, 0x000145B0000195BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x00024DB30001F9B7, 0x80005E5B80005E57, 0x80005E6380005E5F, 0x000241B500027DB6, 0x000189BB80005E67, 0x80005E6B000181BA, 0x000189BF80005E6F, 0x000189BD000181BE, 
0x001F54E1000191BC, 0x001ED0E3001E8CE1, 0x000050E3001E7CE3, 0x001E28E180005E73, 0x000084EF80005E77, 0x80005E7F80005E7B, 0x80005E8780005E83, 0x001F38EF80005E8B, 
0x0005CDA3001E08EF, 0x80005E8F80005E27, 0x0003DC8480005E93, 0x0005C1A50005FDA6, 0x000609AB80005E97, 0x00030886000601AA, 0x000609AF00036487, 0x000609AD000601AE, 
0x00004981000611AC, 0x80005DB70007B180, 0x80005E9B00004182, 0x80005EA380005E9F, 0x80005EAB80005EA7, 0x80005EB380005EAF, 0x80005EBB80005EB7, 0x80005EC380005EBF, 
0x000671A880005EC7, 0x000671AA000671A9, 0x0007B1AC000671AB, 0x0007B1AE0007B1AD, 0x80005ECB0007B1AF, 0x80005ED380005ECF, 0x80005EDB80005ED7, 0x80005EE380005EDF, 
0x000769B880005EE7, 0x00071DBA000769B9, 0x000735BC000711BB, 0x000735BE00073DBD, 0x0007D1B000072DBF, 0x0007D1B20007D1B1, 0x000779B4000769B3, 0x000769B6000779B5, 
0x0007F9B3000761B7, 0x80005EEF80005EEB, 0x80005EF780005EF3, 0x000639B5000631B6, 0x000615BB80005EFB, 0x80005EFF000615BA, 0x0006BDBF80005F03, 0x0006BDBD0006BDBE, 
0x00006D82000605BC, 0x000055800007BDA3, 0x000675A600006581, 0x000190BE00019884, 0x000651AA00067DA5, 0x000C0085000651AB, 0x0006F9AE000F60BE, 0x000641AC0006F9AF, 
0x0001D1A80006F9AD, 0x0001D1AA0001D1A9, 0x0001F1AC0001D1AB, 0x0001F1AE0001F1AD, 0x000F20860001F1AF, 0x80005F0B0000E487, 0x80005F1380005F0F, 0x80005F1B80005F17, 
0x000171B880005F1F, 0x000171BA000171B9, 0x0000D5BC000171BB, 0x0000D5BE0000DDBD, 0x000191B00000CDBF, 0x000191B2000191B1, 0x000151B4000191B3, 0x000151B6000151B5, 
0x000259B3000151B7, 0x80005F2780005F23, 0x80005F2F80005F2B, 0x000279B5000271B6, 0x000255BB80005F33, 0x80005F37000255BA, 0x000295BF80005F3B, 0x000245BD000295BE, 
0x80005F3F000245BC, 0x80005F4300021DA3, 0x000235A680005F47, 0x80005F4F80005F4B, 0x000211AA00023DA5, 0x80005F53000211AB, 0x0002D1AE80005F57, 0x000201AC0002D1AF, 
0x00EA8582000201AD, 0x80005F5B00EADD83, 0x0016818600030C84, 0x001691840017CD87, 0x0012A18A00169985, 0x80005F5F0012A18B, 0x001E918E80005F63, 0x0013918C001F958F, 
0x001AF192001E918D, 0x80005F67001AE593, 0x00069196002458EF, 0x001A119400068997, 0x0002A99A00069995, 0x80005F6B0002E19B, 0x80005F7380005F6F, 0x0002E59C000188E1, 
0x001B319B003728E3, 0x001F2999001E259A, 0x0007519F001F2198, 0x001BD19D0007519E, 0x00173193001B3D9C, 0x0017219100172192, 0x0012199700EB7590, 0x0013399500133196, 
0x0001A98000166594, 0x0001B9820001A981, 0x00EB558F0002FDB3, 0x0002E5B60002EDB5, 0x000CC08680005F7B, 0x000165BA000DE887, 0x00016DBC00017DBB, 0x000155BE00015DBD, 
0x000770E100013DBF, 0x000188E380005F7F, 0x0000D4E380005F83, 0x0001A8E1000D9C84, 0x000000EF80005F87, 0x80005F8F80005F8B, 0x80005F9780005F93, 0x00067CEF80005F9B, 
0x80005FA380005F9F, 0x000CC4BE000730E3, 0x80005FA700047CE1, 0x80005FAF80005FAB, 0x0003FDA380005FB3, 0x0003A1A10003E1A2, 0x80005FB70007B1A0, 0x80005FBB0007CCEF, 
0x80005FC380005FBF, 0x80005F0780005FC7, 0x80005FCB80005F77, 0x80005FD380005FCF, 0x000D89A880005FD7, 0x000D99AA000D89A9, 0x000D89AC000D99AB, 0x000E3DAE000D89AD, 
0x000E4DB0000E35AF, 0x000E55B2000E55B1, 0x000E7DB4000E65B3, 0x000E11B6000E15B5, 0x000E35B8000E11B7, 0x000E01BA000E3DB9, 0x000EF9BC000E01BB, 0x000ED5BE000EDDBD, 
0x000D31A3000EB5BF, 0x0000158100002D82, 0x80005FDB00001D80, 0x000D21A5000D29A6, 0x000EB1AB80005FDF, 0x80005FE3000EA9AA, 0x000EF1AF80005FE7, 0x000E91AD000E99AE, 
0x80005FEB000EA1AC, 0x00006886000F49B3, 0x000F79B600031C87, 0x80005FF380005FEF, 0x000F55BA000F79B5, 0x80005FF7000F59BB, 0x000F25BE80005FFB, 0x000F39BC000F2DBF, 
0x000E5DA8000F2DBD, 0x000E85AA000E81A9, 0x000EB5AC000E91AB, 0x000EB5AE000EBDAD, 0x80005FFF000EADAF, 0x8000600780006003, 0x8000600F8000600B, 0x8000601780006013, 
0x000EB9B88000601B, 0x000149BA000EB9B9, 0x000141BC000149BB, 0x000141BE000141BD, 0x000ED5B0000141BF, 0x000EA9B2000ED9B1, 0x000EA5B4000EBDB3, 0x000EA5B6000EADB5, 
0x000E0DA3000E8DB7, 0x800060238000601F, 0x8000602B80006027, 0x000E3DA5000E3DA6, 0x000E1DAB8000602F, 0x80006033000E11AA, 0x000E69AF80006037, 0x000E69AD000E61AE, 
0x8000603B000E7DAC, 0x800060438000603F, 0x00000D8080006047, 0x00003D8200003581, 0x8000604F8000604B, 0x0001A48480006053, 0x0007D0860001A4BE, 0x8000605B0000F887, 
0x0002C1A88000605F, 0x0002D1AA0002D1A9, 0x0002FDAC0002E5AB, 0x00033DAE000335AD, 0x80006063000335AF, 0x8000606B80006067, 0x800060738000606F, 0x8000607B80006077, 
0x0003D1B88000607F, 0x0003E1BA0003D9B9, 0x000391BC0003E1BB, 0x000391BE000391BD, 0x00034DB0000391BF, 0x00035DB2000355B1, 0x00034DB4000355B3, 0x0003F1B60003F1B5, 
0x000259B30003F1B7, 0x8000608780006083, 0x8000608B000400BE, 0x000275B50003B5B6, 0x000391BB8000608F, 0x80006093000389BA, 0x000335BF80006097, 0x000381BD000389BE, 
0x8000609B000389BC, 0x8000609F00021DA3, 0x0003F1A6800060A3, 0x800060AB800060A7, 0x0003CDAA000231A5, 0x800060AF0003D5AB, 0x0003CDAE800060B3, 0x0003CDAC000371AF, 
0x800060B70003C5AD, 0x0000158100002182, 0x000004EF00001580, 0x800060BB00029484, 0x0000D8E3800060BF, 0x0001F8E1800060C3, 0x800060CF800060CB, 0x800060D7800060D3, 
0x0004E086800060DB, 0x800060DF00051887, 0x800060E300016DB3, 0x000175B600017DB5, 0x800060EB800060E7, 0x000151BA800060EF, 0x0001F5BC000151BB, 0x0001E9BE0001FDBD, 
0x000E04E30001E1BF, 0x000EF0E1000F18E3, 0x800060F3000C34E1, 0x800060FB800060F7, 0x0037ADB2800060FF, 0x0032B9B0003719B3, 0x000E80EF003401B1, 0x002801B4000C20EF, 
0x003C01AA002BBDB5, 0x003BCDA8003FC1AB, 0x0033D5AE003BA1A9, 0x003FC9AC0033DDAF, 0x0003EDA2003001AD, 0x0004A0BE000349A3, 0x000781A60003E5A1, 0x000401A4003801A7, 
0x000621A30007F9A5, 0x80006103800060C7, 0x8000610B80006107, 0x000631A5000639A6, 0x00061DAB8000610F, 0x8000611300061DAA, 0x0006ADAF80006117, 0x0006B1AD0006A5AE, 
0x8000611B0006B9AC, 0x8000611F000430EF, 0x8000612780006123, 0x00003D8100003D82, 0x8000612B00003D80, 0x800061338000612F, 0x8000613700032084, 0x8000613B000570E3, 
0x000579A8000794E1, 0x0006A9AA000579A9, 0x0006B9AC0006A9AB, 0x0006A9AE0006B9AD, 0x000000860006A9AF, 0x8000613F00008487, 0x8000614780006143, 0x8000614F8000614B, 
0x000601B880006153, 0x000605BA00060DB9, 0x000609BC000619BB, 0x000635BE00063DBD, 0x0006D9B00007DDBF, 0x00066DB20006D9B1, 0x000661B4000665B3, 0x000651B6000669B5, 
0x00062DA8000651B7, 0x00063DAA000635A9, 0x00062DAC000635AB, 0x000649AE00065DAD, 0x80006157000641AF, 0x8000615F8000615B, 0x8000616780006163, 0x8000616F8000616B, 
0x000151B880006173, 0x000161BA000159B9, 0x000111BC000161BB, 0x000115BE00011DBD, 0x000601B000010DBF, 0x0006F9B2000601B1, 0x0006E9B40006F9B3, 0x000171B60006E9B5, 
0x0006B5B3000171B7, 0x8000617B80006177, 0x800061838000617F, 0x0006A5B50006DDB6, 0x0006C5BB80006187, 0x8000618B0006C5BA, 0x00062DBF8000618F, 0x00062DBD00062DBE, 
0x8000619300062DBC, 0x800061970006F1A3, 0x000699A68000619B, 0x800061A38000619F, 0x000681AA0006E1A5, 0x0001B4BE000681AB, 0x000669AE0001A884, 0x000669AC000669AF, 
0x000279A8000669AD, 0x0002A5AA0002ADA9, 0x0002A5AC0002BDAB, 0x0002A5AE0002ADAD, 0x0003ED8000033DAF, 0x0003F1820003F181, 0x800061AF800061AB, 0x0003AC87800061B3, 
0x0003C9B800039C86, 0x0003D9BA0003C9B9, 0x0003F9BC0003D1BB, 0x000399BE0003F9BD, 0x000345B0000395BF, 0x000345B200034DB1, 0x000345B400035DB3, 0x000345B600034DB5, 
0x800061B70003F9B7, 0x000225B3800061BB, 0x000225B5003C4084, 0x800061C3800061BF, 0x800061C7000225B6, 0x000381BB800061CB, 0x000381BD000389BA, 0x000381BF000399BC, 
0x800061CF000389BE, 0x00027DA500027DA6, 0x00027DA3800061D3, 0x800061DB800061D7, 0x0003D9AF800061DF, 0x0003D9AD0003D1AE, 0x0003D9AB0003C1AC, 0x800061E30003D1AA, 
0x00012DA8800061E7, 0x00013DAA000135A9, 0x000195AC00018DAB, 0x000181AE000181AD, 0x800061EB0001BDAF, 0x800061F3800061EF, 0x800061FB800061F7, 0x80006203800061FF, 
0x000061B880006207, 0x000061BA000061B9, 0x000061BC000061BB, 0x000061BE000061BD, 0x0001C5B0000061BF, 0x0001A5B20001A5B1, 0x0001A9B40001B9B3, 0x000181B60001A9B5, 
0x0006D8E1000181B7, 0x0001F4E38000620B, 0x00001D818000620F, 0x8000621300001180, 0x003DACBE00000582, 0x003C08868000621B, 0x8000621F003DFC87, 0x0006A8EF80006223, 
0x8000622B80006227, 0x800062338000622F, 0x800062370000DCEF, 0x8000623F8000623B, 0x8000624780006243, 0x8000624F8000624B, 0x8000625780006253, 0x8000605700014CE1, 
0x003E35B3000000E3, 0x8000625B80006217, 0x800062638000625F, 0x003E9DB5003E81B6, 0x003EE1BB80006267, 0x8000626B003E81BA, 0x003EEDBF8000626F, 0x003EEDBD003EEDBE, 
0x80006273003EF1BC, 0x003D10EF80006277, 0x00001D808000627B, 0x0000398200000981, 0x800062838000627F, 0x000364BE00026C84, 0x003C54E180006287, 0x003CE4E38000628B, 
0x003EB5A38000628F, 0x0003488780006293, 0x8000629700002C86, 0x003E1DA5003E01A6, 0x003E61AB8000629B, 0x8000629F003E01AA, 0x003E6DAF800062A3, 0x003E6DAD003E6DAE, 
0x800062A7003E71AC, 0x800062AB003F71B3, 0x003F15B6800062AF, 0x800062B7800062B3, 0x003F35BA003F1DB5, 0x800062BB003F3DBB, 0x003F15BE800062BF, 0x003F25BC003F1DBF, 
0x003EA5A8003F1DBD, 0x003EBDAA003EB5A9, 0x003ED1AC003EB1AB, 0x003ED1AE003ED1AD, 0x800062C3003ECDAF, 0x800062CB800062C7, 0x800062D3800062CF, 0x800062DB800062D7, 
0x000149B8800062DF, 0x000159BA000149B9, 0x000179BC000151BB, 0x000119BE000179BD, 0x003EB5B0000119BF, 0x003EB5B2003EBDB1, 0x003E95B4003E8DB3, 0x003E95B6003E9DB5, 
0x003E35A3003E8DB7, 0x800062E7800062E3, 0x800062EF800062EB, 0x003E59A5003E51A6, 0x003E79AB800062F3, 0x0002A884003E71AA, 0x003E59AF0001ACBE, 0x003E59AD003E51AE, 
0x00004D80003E61AC, 0x0000558200005581, 0x800062FB000149B3, 0x000171B6000149B5, 0x00004086800062FF, 0x000121BA00011487, 0x000125BC000121BB, 0x000111BE00012DBD, 
0x000275A8000111BF, 0x00028DAA000279A9, 0x00028DAC00029DAB, 0x0002B5AE0002BDAD, 0x800063030002DDAF, 0x8000630B80006307, 0x800063138000630F, 0x8000631B80006317, 
0x000369B88000631F, 0x000379BA000369B9, 0x000369BC000379BB, 0x0003DDBE000369BD, 0x0002A9B00003D5BF, 0x0002BDB20002A9B1, 0x000299B40002B5B3, 0x000359B6000299B5, 
0x80006323000359B7, 0x8000632B80006327, 0x00045C84000209A3, 0x000231A6000209A5, 0x800063338000632F, 0x000261AA80006337, 0x000265AC000261AB, 0x000251AE00026DAD, 
0x8000633B000251AF, 0x800063438000633F, 0x800063470004C0BE, 0x8000634F8000634B, 0x8000635780006353, 0x8000635F8000635B, 0x0000158080006363, 0x0000158200001D81, 
0x0002D1A88000636B, 0x000129AA0002D9A9, 0x000139AC000129AB, 0x000129AE000139AD, 0x8000636F000129AF, 0x8000637780006373, 0x8000637F8000637B, 0x8000638780006383, 
0x000181B88000638B, 0x000181BA000181B9, 0x000185BC00019DBB, 0x000185BE00018DBD, 0x000159B00001BDBF, 0x0001E9B2000159B1, 0x0001F9B40001E9B3, 0x0001D9B60001E9B5, 
0x003E30E10001D9B7, 0x0001FCE38000638F, 0x8000639780006393, 0x000438868000639B, 0x0005A88400026487, 0x800063A38000639F, 0x800063AB800063A7, 0x000128EF800063AF, 
0x0013FC85800063B3, 0x800063BB800063B7, 0x000084EF800063BF, 0x800063C7800063C3, 0x000058E3800063CB, 0x00017CE1800063CF, 0x00001D82800063D3, 0x00002580800061A7, 
0x000621B300001981, 0x000304BE80006367, 0x800063D7800063DB, 0x000631B5000639B6, 0x00061DBB800063DF, 0x0000888600061DBA, 0x0006ADBF00030C87, 0x0006BDBD0006BDBE, 
0x800063E30006BDBC, 0x800063E70007BCE1, 0x800063EB0004CCE3, 0x800063F3800063EF, 0x800063FB800063F7, 0x80006403800063FF, 0x8000640B80006407, 0x800064138000640F, 
0x0006A1A3000448EF, 0x8000641B80006417, 0x800064238000641F, 0x0006B1A50006B9A6, 0x00069DAB80006427, 0x8000642B00069DAA, 0x00062DAF8000642F, 0x00063DAD00063DAE, 
0x8000643300063DAC, 0x800064370007E1B3, 0x0007E1B68000643B, 0x800064438000643F, 0x0007DDBA0007F1B5, 0x0003E084000761BB, 0x000765BE0000E4BE, 0x000775BC000751BF, 
0x0007FDA800076DBD, 0x00062DAA000625A9, 0x00063DAC000625AB, 0x00062DAE000625AD, 0x0001ED80000625AF, 0x0001F1820001F181, 0x000090868000644B, 0x8000644F0001F087, 
0x0006F1B880006453, 0x0006F5BA0006F1B9, 0x000699BC000689BB, 0x00068DBE000699BD, 0x00065DB0000685BF, 0x0006E5B20006E1B1, 0x0006E5B40006FDB3, 0x0006D1B60006D1B5, 
0x0006A5A30006D1B7, 0x8000645B80006457, 0x800064638000645F, 0x0006B5A50006A5A6, 0x000625AB80006467, 0x8000646B000699AA, 0x000615AF8000646F, 0x000629AD000621AE, 
0x80006473000631AC, 0x80006477000185B3, 0x000185B68000647B, 0x800064838000647F, 0x000181BA00018DB5, 0x80006487000181BB, 0x000181BE8000648B, 0x000191BC000181BF, 
0x00020DA8000191BD, 0x000249AA000219A9, 0x000241AC000245AB, 0x000241AE000241AD, 0x8000648F000241AF, 0x8000649780006493, 0x000338848000649B, 0x800064A38000649F, 
0x0002C9B8800064A7, 0x0002D9BA0002C9B9, 0x0002F9BC0002D1BB, 0x000299BE0002F9BD, 0x000201B0000295BF, 0x000201B2000201B1, 0x000201B4000201B3, 0x000201B6000201B5, 
0x800064AB0002F9B7, 0x800064AF0002C5A3, 0x0002C5A6800064B3, 0x800064BF800064BB, 0x0002C1AA0002CDA5, 0x000C88860002C1AB, 0x0002C1AE00031887, 0x0002D1AC0002C1AF, 
0x000049810002D1AD, 0x000C44BE00004580, 0x800064C300004182, 0x800064CB800064C7, 0x800064D3800064CF, 0x800064DB800064D7, 0x000D3C84800064DF, 0x000D30BE800064E3, 
0x00022DA8800064E7, 0x000235AA00023DA9, 0x000299AC000289AB, 0x000289AE000299AD, 0x000FEC84000281AF, 0x000FE0BE800064EB, 0x800064F3800064EF, 0x800064FB800064F7, 
0x0002ADB8800064FF, 0x00016DBA000165B9, 0x00017DBC000165BB, 0x000161BE000161BD, 0x0002C9B0000161BF, 0x0002A9B20002C9B1, 0x0002BDB40002A5B3, 0x0002A1B60002A1B5, 
0x000600E1000295B7, 0x000638E380006503, 0x8000650B80006507, 0x8000650F0001A4E1, 0x000FA084000164E3, 0x8000651780006513, 0x00007D810001B8EF, 0x000148EF00007D80, 
0x800062F700006982, 0x8000651B0002F9B3, 0x00025DB68000651F, 0x8000652B80006523, 0x000249BA000255B5, 0x000CC886000249BB, 0x00023DBE000D5087, 0x000239BC000221BF, 
0x000D3DA3000235BD, 0x80006527800064B7, 0x800065338000652F, 0x000D91A5000D99A6, 0x000D8DAB80006537, 0x8000653B000D8DAA, 0x000DE5AF8000653F, 0x000DF1AD000DF9AE, 
0x80006543000DFDAC, 0x8000654B80006547, 0x000C70E38000654F, 0x000F70E180006553, 0x000C50EF80006557, 0x8000655F8000655B, 0x8000656780006563, 0x8000656F8000656B, 
0x000E15A880006573, 0x000E59AA000E1DA9, 0x000E49AC000E59AB, 0x000E79AE000E49AD, 0x80006577000E79AF, 0x8000657F8000657B, 0x8000658780006583, 0x0001B1810001B982, 
0x000FF9B80001B980, 0x000F4DBA000FF9B9, 0x000F41BC000F41BB, 0x000F7DBE000F4DBD, 0x000E09B0000F75BF, 0x000E1DB2000E09B1, 0x000FD5B4000E11B3, 0x000FC9B6000FD9B5, 
0x000FD1B3000FC9B7, 0x8000658F8000658B, 0x8000659780006593, 0x000FC1B5000FC9B6, 0x000FCDBB8000659B, 0x00008886000FCDBA, 0x000E1DBF0001AC87, 0x000FC5BD000E11BE, 
0x8000659F000FC9BC, 0x800065A3000F95A3, 0x000F8DA6800065A7, 0x800065AF800065AB, 0x000F89AA000F85A5, 0x800065B3000F89AB, 0x000E55AE800065B7, 0x000F8DAC000E59AF, 
0x000E59A8000F81AD, 0x000199AA000189A9, 0x0001B9AC000191AB, 0x0001D9AE0001B9AD, 0x0000FCBE0001D9AF, 0x800065BF800065BB, 0x800065C7800065C3, 0x800065CF800065CB, 
0x0001B5B8800065D3, 0x0001B5BA0001BDB9, 0x000175BC00016DBB, 0x000175BE00017DBD, 0x0001A9B000016DBF, 0x0001BDB20001A9B1, 0x000195B40001B1B3, 0x000195B600019DB5, 
0x000211B300018DB7, 0x800065DB800065D7, 0x800065E3800065DF, 0x000231B5000239B6, 0x00026DBB800065E7, 0x800065EB00026DBA, 0x000259BF800065EF, 0x000265BD000251BE, 
0x800065F3000269BC, 0x800065F7000255A3, 0x00027DA6800065FB, 0x80006603800065FF, 0x000229AA000275A5, 0x8000660B000229AB, 0x000215AE8000660F, 0x00022DAC00021DAF, 
0x0000CD80000221AD, 0x0000D1820000D181, 0x8000661300040084, 0x800066170001A4E1, 0x00048086000F2CE3, 0x8000661B0004A487, 0x8000661F0001F4EF, 0x8000662780006623, 
0x8000662B000000AA, 0x800066338000662F, 0x80006637000385B3, 0x000381B6000381B5, 0x8000663F8000663B, 0x00034DBA80006643, 0x00035DBC000345BB, 0x00034DBE000345BD, 
0x00021DA8000345BF, 0x000241AA000245A9, 0x000245AC000241AB, 0x000271AE00024DAD, 0x0004ACBE000271AF, 0x8000664B80006647, 0x0004B8848000664F, 0x8000665780006653, 
0x000149B88000665B, 0x000159BA000149B9, 0x000179BC000151BB, 0x000119BE000179BD, 0x0002C5B0000115BF, 0x0002C5B20002CDB1, 0x0002C5B40002DDB3, 0x0002C5B60002CDB5, 
0x000F30E1000179B7, 0x000F68E3000EB4E3, 0x8000665F000E7CE1, 0x8000666780006663, 0x8000666F8000666B, 0x8000667B80006673, 0x800066838000667F, 0x000FB8EF000E64EF, 
0x8000668B80006687, 0x00029DA500029DA6, 0x000299A3000740BE, 0x800066938000668F, 0x000259AF80006447, 0x000259AD000251AE, 0x000259AB000241AC, 0x0004D886000251AA, 
0x00079D8000055087, 0x0007AD820007A581, 0x0005C8EF80006677, 0x8000669B80006697, 0x0004BCE38000669F, 0x000490E1800066A3, 0x800066AB800066A7, 0x800066B3800066AF, 
0x0006D1B3800066B7, 0x800066BF800066BB, 0x800066C7800066C3, 0x0006F1B50006E5B6, 0x0006A5BB800066CB, 0x800066CF0006A5BA, 0x000691BF800066D3, 0x0006A9BD0006A9BE, 
0x0006E9A80006B5BC, 0x000619AA0006E9A9, 0x000639AC000615AB, 0x00062DAE000625AD, 0x800066D7000625AF, 0x00001D8100001D82, 0x800066DB00001D80, 0x800066E3800066DF, 
0x0007E9B8800066E7, 0x0007FDBA0007E9B9, 0x0007EDBC0007F5BB, 0x00074DBE000745BD, 0x000621B0000745BF, 0x000621B2000621B1, 0x00062DB400063DB3, 0x00061DB6000615B5, 
0x000791A30007D9B7, 0x00012886800066EB, 0x800066EF00014C87, 0x0007B1A50007A5A6, 0x0007E5AB800066F3, 0x800066F70007E5AA, 0x0007D1AF800066FB, 0x0007E9AD0007E9AE, 
0x800066FF0007F5AC, 0x800067030006F5B3, 0x000685B680006707, 0x8000670F8000670B, 0x000179BA00069DB5, 0x80006713000179BB, 0x000141BE80006717, 0x00015DBC000141BF, 
0x000629A8000151BD, 0x000639AA000629A9, 0x000651AC000631AB, 0x000641AE000641AD, 0x8000671B000189AF, 0x800067238000671F, 0x8000672B80006727, 0x800067338000672F, 
0x000185B880006737, 0x000185BA00018DB9, 0x00018DBC00019DBB, 0x0001B5BE0001BDBD, 0x0001F9B000017DBF, 0x0001CDB20001F9B1, 0x0001C1B40001C1B3, 0x0001C1B60001C1B5, 
0x0005B1A30001C1B7, 0x8000673F8000673B, 0x8000674780006743, 0x0005D9A50005C1A6, 0x00023DAB8000674B, 0x8000674F00023DAA, 0x000205AF80006753, 0x000215AD000205AE, 
0x00005D80000219AC, 0x0000658200006D81, 0x00039CBE000351B3, 0x000319B6000379B5, 0x0002E0848000675B, 0x00033DBA8000675F, 0x000319BC000335BB, 0x0003D9BE000319BD, 
0x000385A80003D9BF, 0x000395AA000395A9, 0x0003BDAC0003A5AB, 0x0003D1AE0003D5AD, 0x800067630003D1AF, 0x8000676B80006767, 0x00032087001C60BE, 0x8000676F001C9486, 
0x000371B880006773, 0x000371BA000371B9, 0x0000D5BC000371BB, 0x0000D5BE0000DDBD, 0x0003B5B00000CDBF, 0x000381B20003BDB1, 0x000351B4000381B3, 0x000351B6000351B5, 
0x0003A8EF000351B7, 0x8000677B80006777, 0x00021C848000677F, 0x8000678780006783, 0x001C6C848000678B, 0x800067938000678F, 0x000340E380006797, 0x000028E18000679B, 
0x00025DA38000679F, 0x800067A7800067A3, 0x800067AF800067AB, 0x000275A5000215A6, 0x000239AB800067B3, 0x800067B7000231AA, 0x0002D5AF800067BB, 0x000215AD0002D5AE, 
0x0006A0E3000215AC, 0x000668E1800067BF, 0x0000FD80001CC4BE, 0x0000058200001181, 0x800067CB800067C3, 0x800067D3800067CF, 0x000684EF80006607, 0x800067DB800067D7, 
0x000161B3800067DF, 0x001C6886800067E3, 0x800067E7001D6C87, 0x000171B500016DB6, 0x0000EDBB800067EB, 0x800067EF0000EDBA, 0x0000D5BF800067F3, 0x0000E1BD0000E9BE, 
0x800067C70000E9BC, 0x800067F7001C50EF, 0x800067FF800067FB, 0x8000680780006803, 0x8000680F8000680B, 0x8000681780006813, 0x8000681F8000681B, 0x80006823001D34E3, 
0x001EE1A3001C90E1, 0x8000682B80006827, 0x800068338000682F, 0x001EF1A5001EEDA6, 0x001F6DAB00001C85, 0x000160BF001F6DAA, 0x001F55AF80006837, 0x001F61AD001F69AE, 
0x001EDDA8001F69AC, 0x001E29AA001EE1A9, 0x001E39AC001E29AB, 0x001E25AE001E2DAD, 0x0000E980001F99AF, 0x0000F9820000E981, 0x000400868000683B, 0x8000683F00001487, 
0x001FF5B880006843, 0x001F8DBA001FF9B9, 0x001F9DBC001F85BB, 0x001F85BE001F85BD, 0x001FE9B0001FB5BF, 0x001FFDB2001FE9B1, 0x001FEDB4001FF5B3, 0x001FD1B6001FD1B5, 
0x001EA1A8001FD1B7, 0x001EA1AA001EA1A9, 0x001EA9AC001EB9AB, 0x001EDDAE001EA9AD, 0x80006847001ECDAF, 0x8000684F8000684B, 0x8000685780006853, 0x8000685F8000685B, 
0x00015DB880006863, 0x00016DBA000165B9, 0x00017DBC000165BB, 0x000161BE000165BD, 0x001EBDB0000119BF, 0x001E85B2001E8DB1, 0x00017DB4000165B3, 0x00016DB6000165B5, 
0x001E29B3000165B7, 0x8000686B80006867, 0x800068738000686F, 0x001E21B5001E29B6, 0x001E49BB80006877, 0x8000687B001E79BA, 0x0001A1BF8000687F, 0x0001B1BD0001B9BE, 
0x80006883001E51BC, 0x80006887001E6DA3, 0x001E6DA68000688B, 0x800068938000688F, 0x001E3DAA001E65A5, 0x80006897001E0DAB, 0x0001FDAE8000689B, 0x001E15AC0001E5AF, 
0x002A098F0001F5AD, 0x8000689F00004CE1, 0x800068A3000A58E3, 0x0004D0BE0004D884, 0x0005E8BE800068AB, 0x00038887800068AF, 0x800068B300040C86, 0x800068BB800068B7, 
0x001DED9F007B4CEF, 0x001A419D001B559E, 0x00198D9B001A499C, 0x00165D990016459A, 0x00120D9700159D98, 0x00119D9500126196, 0x002E7593002E1D94, 0x002AD591002D8D92, 
0x007629B0002A7190, 0x007AA9B2007801B1, 0x007C01B4007AB1B3, 0x800068BF007E91B5, 0x00034D80800068C3, 0x0000B9820000AD81, 0x0002B1A3800068C7, 0x001E05A100010DA2, 
0x800068CB001EB1A0, 0x0006CDA20002A9A1, 0x000801A40006C5A3, 0x000AD1A6000AD1A5, 0x000EE1A8000BB9A7, 0x000FF9AA000EE1A9, 0x0072D1AC007001AB, 0x007401AE00722DAD, 
0x002B09820076DDAF, 0x800068CF002B0983, 0x002F1586800068D3, 0x002BB584002F6587, 0x0010D58A002CE585, 0x800068D70013218B, 0x0017358E800068DB, 0x0013558C0017258F, 
0x00189D920014FD8D, 0x00048484001B4193, 0x001CFD9600070884, 0x001B5194001F5997, 0x001FDD9A001A4D95, 0x800068DF0000DD9B, 0x800068E7800068E3, 0x0003799C800068EB, 
0x800068F3800068EF, 0x800068F7001E54E1, 0x800068FB001EBCE3, 0x80006903800068FF, 0x00000D8080006907, 0x00001D8200001581, 0x8000690F8000690B, 0x8000675780006913, 
0x00056C87001EC8EF, 0x8000691B0004E486, 0x000330EF8000691F, 0x8000692780006923, 0x0003E4E38000692B, 0x000140E18000692F, 0x8000693780006933, 0x8000693F8000693B, 
0x0004BDB380006943, 0x80006917800068A7, 0x8000694B80006947, 0x00053DB500053DB6, 0x000519BB8000694F, 0x80006953000511BA, 0x0005BDBF80006957, 0x0005BDBD0005BDBE, 
0x8000695B000501BC, 0x8000695F0004F9A3, 0x000579A680006963, 0x8000696B80006967, 0x000555AA000579A5, 0x8000696F00055DAB, 0x0005F9AE80006973, 0x000545AC0005F9AF, 
0x00069DA80005F9AD, 0x0006B9AA0006A1A9, 0x0006A9AC0006B9AB, 0x000605AE00060DAD, 0x80006977000631AF, 0x0000118100001982, 0x0000ECBE00001980, 0x8000697F8000697B, 
0x0007B5B880006983, 0x000749BA0007B9B9, 0x000741BC000745BB, 0x000741BE000741BD, 0x000621B0000741BF, 0x0007E5B20007EDB1, 0x0007DDB40007C5B3, 0x000795B600079DB5, 
0x000731B300078DB7, 0x0000A8868000698B, 0x8000698F00018887, 0x000721B500078DB6, 0x000629BB80006993, 0x800069970007E5BA, 0x000659BF8000699B, 0x000611BD000619BE, 
0x8000699F000631BC, 0x800069A3000775A3, 0x0007C9A6800069A7, 0x800069AF800069AB, 0x0007A1AA000765A5, 0x800069B300066DAB, 0x00065DAE800069B7, 0x000675AC00061DAF, 
0x000649A8000655AD, 0x00065DAA000649A9, 0x00064DAC000655AB, 0x000675AE000671AD, 0x0000AC8400066DAF, 0x800069BF800069BB, 0x800069C7800069C3, 0x800069CF800069CB, 
0x000181B8800069D3, 0x000185BA00018DB9, 0x000189BC000199BB, 0x0001B5BE0001BDBD, 0x000615B000017DBF, 0x000615B200061DB1, 0x0001E1B40001E1B3, 0x0001D1B60001E9B5, 
0x000725AC0001D1B7, 0x000725AE00072DAD, 0x0006BDA800073DAF, 0x0006A5AA0006ADA9, 0x000CACBE00073DAB, 0x800069DB800069D7, 0x800069E3800069DF, 0x800069EB800069E7, 
0x00078DBC800069EF, 0x000791BE000791BD, 0x0007F9B80007A5BF, 0x000799BA0007F9B9, 0x0007E9B4000795BB, 0x0007F9B60007E9B5, 0x000745B00007F1B7, 0x000745B200074DB1, 
0x0000BD810007F9B3, 0x00055DB30000BD80, 0x00054DB500001982, 0x800069FB800069F3, 0x800069FF000579B6, 0x000551BB80006A03, 0x0002BDBD000559BA, 0x0002A5BF000549BC, 
0x80006A070002ADBE, 0x000515A5000521A6, 0x000505A3000C4C84, 0x000CF88680006A0B, 0x0002FDAF000C9C87, 0x0002E5AD0002F5AE, 0x000509AB000511AC, 0x80006A0F000501AA, 
0x000205A880006A13, 0x000215AA000215A9, 0x00023DAC000225AB, 0x000251AE000255AD, 0x000CACBE000251AF, 0x80006A1B80006A17, 0x80006A2380006A1F, 0x80006A2B80006A27, 
0x0002F5B880006A2F, 0x0002F5BA0002FDB9, 0x000179BC000169BB, 0x000169BE000179BD, 0x000235B0000169BF, 0x000201B200023DB1, 0x0002D5B4000201B3, 0x0002D5B60002DDB5, 
0x0007B4E10002CDB7, 0x0006D0E30006D8E3, 0x80006A33000650E1, 0x80006A3B80006A37, 0x80006A4380006A3F, 0x80006A4B80006A47, 0x000000EC80006A4F, 0x000760EF0001FCEF, 
0x0002DDB380006A53, 0x000CE88680006A57, 0x80006A5B000C8C87, 0x0002F5B5000295B6, 0x0002B9BB80006A5F, 0x80006A630002B1BA, 0x000259BF80006A6B, 0x000295BD000251BE, 
0x000D1DA3000295BC, 0x80006A67800069F7, 0x80006A7380006A6F, 0x000D35A5000D55A6, 0x000D79AB80006A77, 0x80006A7B000D71AA, 0x000D99AF80006A7F, 0x000D55AD000D91AE, 
0x000F9180000D55AC, 0x000FA182000F9981, 0x80006A83000EE9B3, 0x000EA1B6000E81B5, 0x80006A8B80006A87, 0x000F41BA80006A8F, 0x000F41BC000F41BB, 0x000F41BE000F41BD, 
0x000E19A8000F41BF, 0x000E2DAA000E25A9, 0x000E45AC000E4DAB, 0x000E65AE000E6DAD, 0x80006A93000FB9AF, 0x80006A9B80006A97, 0x80006AA380006A9F, 0x80006AAB80006AA7, 
0x000F59B880006AAF, 0x000F69BA000F59B9, 0x000F79BC000F69BB, 0x000F65BE000F79BD, 0x000FC9B0000F19BF, 0x000FD9B2000FC9B1, 0x000FC9B4000FD9B3, 0x000F69B6000FC9B5, 
0x000FA5A3000F69B7, 0x80006AB780006AB3, 0x80006ABF80006ABB, 0x000FCDA5000FEDA6, 0x000E0DAB80006AC3, 0x80006AC7000E0DAA, 0x000E0DAF80006ACB, 0x000E0DAD000E0DAE, 
0x00006D80000E0DAC, 0x0000198200000981, 0x80006AD380006ACF, 0x00019484000E44E1, 0x0001A8BE000EECE3, 0x80006ADB80006AD7, 0x0000D086000DB4EF, 0x80006ADF0001FC87, 
0x000E6DA880006AE3, 0x000199AA000189A9, 0x0001B9AC000191AB, 0x0001C9AE0001B9AD, 0x0000A0840001C1AF, 0x80006AEB80006AE7, 0x80006AF380006AEF, 0x80006AFB80006AF7, 
0x000179B880006AFF, 0x0000CDBA000179B9, 0x0000DDBC0000C5BB, 0x0000C5BE0000C5BD, 0x000181B00000F5BF, 0x000149B2000181B1, 0x000159B4000149B3, 0x000149B6000159B5, 
0x000211B3000149B7, 0x80006B0780006B03, 0x80006B0F80006B0B, 0x000231B5000239B6, 0x000245BB80006B13, 0x80006B17000245BA, 0x00029DBF80006B1B, 0x00029DBD00029DBE, 
0x0075FC8500029DBC, 0x80006B1F000255A3, 0x00027DA680006B23, 0x80006B2B80006B27, 0x000201AA000275A5, 0x80006B2F000201AB, 0x0002D9AE80006B33, 0x0002D9AC0002D9AF, 
0x000019820002D9AD, 0x0000198080006B37, 0x80006B3B00001981, 0x80006B4380006B3F, 0x000400BE80006B4B, 0x80006B5380006B4F, 0x80006B5B80006B57, 0x80006B6380006B5F, 
0x0004E08680006B67, 0x80006B6B00035487, 0x8000698780006B6F, 0x000280EF80006B73, 0x000188E180006B77, 0x000158E380006B7B, 0x80006B8380006B7F, 0x80006B8B80006B87, 
0x000269A880006B8F, 0x000275AA00027DA9, 0x0002B9AC0002A9AB, 0x0002A9AE0002B9AD, 0x0005AC840002A9AF, 0x80006B9780006B93, 0x80006B9F80006B9B, 0x80006BA780006BA3, 
0x00016DB880006BAB, 0x000105BA00010DB9, 0x000109BC000119BB, 0x000135BE00013DBD, 0x0002D9B00001D9BF, 0x00016DB20002D9B1, 0x00017DB4000165B3, 0x000165B6000165B5, 
0x000F40E1000155B7, 0x000F54E30000CCE3, 0x0000AD80000E5CE1, 0x0000398200000981, 0x80006BB380006BAF, 0x80006BBB000428BE, 0x00073CBE80006BBF, 0x000E60EF00002CEF, 
0x0004E08680006BC3, 0x80006BC700057487, 0x80006BCB0002B1B3, 0x000275B600027DB5, 0x80006BD380006BCF, 0x000251BA80006BD7, 0x0001F5BC000251BB, 0x0001F5BE0001FDBD, 
0x80006B470001EDBF, 0x0005B1AA80006BB7, 0x000615AC0005B1AB, 0x000615AE00061DAD, 0x80006BDB00060DAF, 0x80006BE380006BDF, 0x80006BE7000551A3, 0x000595A600059DA5, 
0x0006E9B380006BEB, 0x80006BF380006BEF, 0x80006BFB80006BF7, 0x0006E9B50006E1B6, 0x0006ADBB80006BFF, 0x80006C030006ADBA, 0x00069DBF80006C07, 0x0006A5BD000691BE, 
0x00061DA80006A9BC, 0x000621AA000621A9, 0x000621AC000621AB, 0x000621AE000621AD, 0x80006C0B000621AF, 0x80006C1380006C0F, 0x00000D8080006C17, 0x0001B1820001B181, 
0x000639B880006C1B, 0x0007EDBA000639B9, 0x0007FDBC0007E5BB, 0x0007EDBE0007E5BD, 0x000629B00007E5BF, 0x00063DB2000629B1, 0x000615B4000631B3, 0x000609B6000619B5, 
0x0007A9A3000609B7, 0x80006C2380006C1F, 0x80006C2700028484, 0x0007A9A50007A1A6, 0x0007EDAB80006C2B, 0x000088860007EDAA, 0x0007DDAF00017887, 0x0007E5AD0007D1AE, 
0x80006C2F0007E9AC, 0x80006C330006F9B3, 0x00068DB680006C37, 0x80006C3F80006C3B, 0x000141BA00068DB5, 0x80006C43000141BB, 0x00014DBE80006C47, 0x000151BC000131BF, 
0x000629A800014DBD, 0x000635AA000629A9, 0x000641AC000645AB, 0x000679AE000649AD, 0x0001AC84000679AF, 0x80006C4F80006C4B, 0x80006C5780006C53, 0x80006C5F80006C5B, 
0x000191B880006C63, 0x0001A1BA000199B9, 0x000171BC0001A1BB, 0x000171BE000171BD, 0x0001C1B0000171BF, 0x0001C1B20001C1B1, 0x0001CDB40001DDB3, 0x0001B1B60001B1B5, 
0x0005BDA30001B1B7, 0x80006C6B80006C67, 0x80006C7380006C6F, 0x0005C9A50005C9A6, 0x000205AB80006C77, 0x80006C7B000205AA, 0x000275AF80006C7F, 0x000209AD000209AE, 
0x80006C83000215AC, 0x80006C8B80006C87, 0x00001D8180006C8F, 0x80006C9300001D80, 0x000324BE00000582, 0x007CC88680006C9B, 0x80006C9F00035C87, 0x80006CA780006CA3, 
0x80006CAF80006CAB, 0x80006CB780006CB3, 0x80006CBB007CC084, 0x80006CBF0001A4E1, 0x007CE8BE00012CE3, 0x80006CC780006CC3, 0x000000AE000234EF, 0x80006CCF80006CCB, 
0x000389B380006CD3, 0x80006CDB80006CD7, 0x80006CE380006CDF, 0x00038DB500038DB6, 0x000349BB80006CE7, 0x80006CEB000341BA, 0x000349BF80006CEF, 0x000349BD000341BE, 
0x00021DA8000351BC, 0x000241AA000245A9, 0x000245AC000241AB, 0x000271AE00024DAD, 0x007FA0BE000271AF, 0x80006CF780006CF3, 0x00001D8080006CFB, 0x0000A98200000981, 
0x000149B880006CFF, 0x000159BA000149B9, 0x000179BC000151BB, 0x000119BE000179BD, 0x0002C5B0000119BF, 0x0002C5B20002CDB1, 0x0002C5B40002DDB3, 0x0002C5B60002CDB5, 
0x000658E1000179B7, 0x000094E300075CE1, 0x80006D030006BCE3, 0x007CB88680006D0B, 0x80006D0F007D5487, 0x80006D1780006D13, 0x000000EE80006D1B, 0x0006F0EF80006D1F, 
0x80006D230006E0EF, 0x000281A380006D27, 0x000285A580006D2B, 0x80006D3380006D2F, 0x80006D37000285A6, 0x000241AB80006D3B, 0x000241AD000249AA, 0x000241AF000259AC, 
0x007E65A8000249AE, 0x007E7DAA007E75A9, 0x007E6DAC007E75AB, 0x007E9DAE007E95AD, 0x80006D07007E95AF, 0x80006D4380006D3F, 0x80006D4B80006D47, 0x80006D5380006D4F, 
0x007E89B880006D57, 0x007E99BA007E89B9, 0x007EB9BC007E91BB, 0x007F7DBE007EB9BD, 0x007EF1B0007F75BF, 0x007ECDB2007EFDB1, 0x007EC5B4007EC5B3, 0x007EC5B6007ECDB5, 
0x007EF5B3007EB9B7, 0x80006D5F80006D5B, 0x80006D6780006D63, 0x007EE5B5007E15B6, 0x007E39BB80006D6B, 0x80006D6F007E35BA, 0x007E09BF80006D73, 0x007E11BD007E01BE, 
0x00006D82007E19BC, 0x00005580007EB1A3, 0x007E51A600006581, 0x80006D7700031884, 0x007E71AA007EA1A5, 0x00008886007E7DAB, 0x007E45AE00035C87, 0x007E5DAC007E4DAF, 
0x007EA5B3007E55AD, 0x80006D7F80006D7B, 0x80006D8780006D83, 0x007EB5B5007EA1B6, 0x007EF5BB80006D8B, 0x80006D8F007EE9BA, 0x000115BF80006D93, 0x007ED9BD007ED1BE, 
0x80006D97007EE5BC, 0x80006D9F80006D9B, 0x007D08EF80006DA3, 0x80006DAB80006DA7, 0x007DFCE380006DAF, 0x007D18E180006DB3, 0x80006DBB80006DB7, 0x80006DC380006DBF, 
0x007E15A880006DC7, 0x007E2DAA007E25A9, 0x007E3DAC007E25AB, 0x007E59AE007E21AD, 0x80006DCB007E59AF, 0x80006DD380006DCF, 0x00000D8080006DD7, 0x0003BD820003B581, 
0x0001F1B880006DDB, 0x0001F1BA0001F1B9, 0x000155BC0001F1BB, 0x000155BE00015DBD, 0x007E2DB000014DBF, 0x007E31B2007E31B1, 0x007E15B4007E0DB3, 0x0001D1B60001D1B5, 
0x80006DDF0001D1B7, 0x0002908480006DE3, 0x00039CBE007DA9A3, 0x007DADA6007DB9A5, 0x80006DEF80006DEB, 0x007DE5AA80006DF3, 0x007DE9AC007DF9AB, 0x007DDDAE007DD5AD, 
0x000369B6000219AF, 0x0003488480006DF7, 0x80006DFB000351B5, 0x0004F886000359B3, 0x000339BE00033487, 0x000325BC000339BF, 0x000335BA000339BD, 0x80006DFF00033DBB, 
0x0003F1B880006E03, 0x0003F1BA0003F1B9, 0x000331BC0003F1BB, 0x000331BE000331BD, 0x0003E5B0000331BF, 0x0003E5B20003EDB1, 0x0003E9B40003F9B3, 0x0003DDB60003E9B5, 
0x0003C5A80003D1B7, 0x0003C5AA0003CDA9, 0x0003CDAC0003DDAB, 0x0003F5AE0003FDAD, 0x80006E0700039DAF, 0x80006E0F80006E0B, 0x0004FCBE80006C97, 0x80006E1780006E13, 
0x00020DA380006E1B, 0x80006E2380006E1F, 0x80006E2B80006E27, 0x000205A500023DA6, 0x000269AB80006E2F, 0x80006E33000261AA, 0x00026DAF80006E37, 0x00026DAD00026DAE, 
0x80006E3B000271AC, 0x80006E4380006E3F, 0x80006E4B80006E47, 0x80006E4F00034CE3, 0x000011820001ACE1, 0x0000398000038CEF, 0x80006E5300003581, 0x0004588680006E5B, 
0x80006E5F00054087, 0x80006E6780006E63, 0x80006E6F80006E6B, 0x80006E7780006E73, 0x80006E7B007E44EF, 0x80006E7F007E24E1, 0x000000EC000168E3, 0x80006E8780006E83, 
0x80006E8F80006E8B, 0x80006E9780006E93, 0x80006E9B0001E9B3, 0x0001A1B6000185B5, 0x80006EA380006E9F, 0x00010DBA80006EA7, 0x000105BC000105BB, 0x000105BE00010DBD, 
0x00061DA80000F9BF, 0x00062DAA000625A9, 0x000641AC000649AB, 0x000665AE00066DAD, 0x80006E570006FDAF, 0x80006EAF80006EAB, 0x80006EB780006EB3, 0x0000B1810000B982, 
0x000751B80000B980, 0x000761BA000759B9, 0x000711BC000761BB, 0x000711BE000711BD, 0x000685B0000711BF, 0x00069DB200068DB1, 0x00068DB4000695B3, 0x000771B6000771B5, 
0x0006A5A3000771B7, 0x80006EBF80006EBB, 0x0002988480006EC3, 0x0006C9A50006EDA6, 0x000649AB000310BE, 0x80006EC7000641AA, 0x0007B5AF80006ECB, 0x000641AD000649AE, 
0x80006ECF000649AC, 0x00006886000741B3, 0x000741B600036C87, 0x80006ED780006ED3, 0x000741BA000751B5, 0x80006EDB00074DBB, 0x00074DBE80006EDF, 0x00074DBC000735BF, 
0x000685A3000745BD, 0x80006EE780006EE3, 0x80006EEF80006EEB, 0x000695A5000685A6, 0x000689AB80006EF3, 0x80006EF7000685AA, 0x0006F1AF80006EFB, 0x000681AD000689AE, 
0x80006EFF000689AC, 0x80006F0300054CEF, 0x80006F0B80006F07, 0x80006F1380006F0F, 0x80006F1B80006F17, 0x80006F2380006F1F, 0x80006F2B80006F27, 0x80006F2F00052CE3, 
0x0006F5A800053CE1, 0x00060DAA000605A9, 0x00061DAC000605AB, 0x00060DAE000605AD, 0x0000D180000605AF, 0x000005820000DD81, 0x0001ECBE80006F33, 0x80006F3B0001F884, 
0x000611B880006F3F, 0x000629BA000619B9, 0x0001F5BC000629BB, 0x0001F5BE0001FDBD, 0x000641B00001EDBF, 0x00065DB200064DB1, 0x00064DB4000655B3, 0x00063DB6000635B5, 
0x0002ADA8000635B7, 0x0002DDAA0002C5A9, 0x0002F9AC0002D5AB, 0x00031DAE0002F9AD, 0x000C8086000315AF, 0x80006F4300033C87, 0x80006F4B80006F47, 0x80006F5380006F4F, 
0x000311B8000378BE, 0x000311BA000311B9, 0x000331BC000311BB, 0x000331BE000331BD, 0x00036DB0000331BF, 0x000375B2000375B1, 0x00035DB4000345B3, 0x000331B6000335B5, 
0x000255B3000331B7, 0x80006F5B80006F57, 0x80006F6380006F5F, 0x000271B5000279B6, 0x0003B1BB80006F67, 0x80006F6B0003A9BA, 0x0003F1BF80006F6F, 0x000391BD000399BE, 
0x80006F730003A1BC, 0x000221A5000229A6, 0x000205A380006F77, 0x80006F7F80006F7B, 0x0003A1AF80006F83, 0x0003C1AD0003C9AE, 0x0003E1AB0003F1AC, 0x80006DE70003F9AA, 
0x80006F8B80006F87, 0x80006F9380006F8F, 0x0000258280006F97, 0x0000318000005CEF, 0x0002AC8400002D81, 0x80006F9B000080E3, 0x80006F9F0001FCE1, 0x000D188680006FA3, 
0x000169B3000D1087, 0x000C44BE80006FAB, 0x80006FB380006FAF, 0x000169B5000161B6, 0x0001EDBB80006FB7, 0x80006FBB0001EDBA, 0x0001DDBF80006FBF, 0x0001E5BD0001DDBE, 
0x80006FC30001EDBC, 0x80006FCB80006FC7, 0x80006FCF000C0084, 0x80006FD780006FD3, 0x000BEC850001F8EF, 0x80006FDB0006C4E1, 0x80006FDF00012CE3, 0x80006FE780006FE3, 
0x80006FEF80006FEB, 0x0001E1A380006FF3, 0x0001E1A580006FF7, 0x80006FFF80006FFB, 0x800070030001E9A6, 0x000165AB80007007, 0x00016DAD000165AA, 0x000155AF000165AC, 
0x000DB9A8000155AE, 0x000E21AA000DB9A9, 0x000E21AC000E21AB, 0x000E21AE000E21AD, 0x80006FA7000E99AF, 0x00001D8100001D82, 0x8000700B00001D80, 0x800070138000700F, 
0x000E95B880007017, 0x000E95BA000E9DB9, 0x000F51BC000EB1BB, 0x000F51BE000F51BD, 0x000EE9B0000F51BF, 0x000EF9B2000EE9B1, 0x000ED9B4000EF1B3, 0x000EB9B6000ED9B5, 
0x000FC5A8000EB1B7, 0x000FD9AA000FC9A9, 0x000FF9AC000FD1AB, 0x000F19AE000FF9AD, 0x00000086000F19AF, 0x8000701B00036487, 0x800070238000701F, 0x8000702B80007027, 
0x000F7DB88000702F, 0x000F0DBA000F05B9, 0x000F05BC000F01BB, 0x000F39BE000F0DBD, 0x000F69B0000F39BF, 0x000F7DB2000F75B1, 0x000F59B4000F75B3, 0x000F4DB6000F45B5, 
0x000D38E1000F45B7, 0x000C38E380007033, 0x8000703B80007037, 0x800070438000703F, 0x8000704B80007047, 0x800070538000704F, 0x8000705B80007057, 0x000DFCEF8000705F, 
0x000E11B380007063, 0x8000706B80007067, 0x800070738000706F, 0x000E31B5000E39B6, 0x000EF1BB80007077, 0x8000707B000EEDBA, 0x000EC1BF8000707F, 0x000EE1BD000EDDBE, 
0x000ED1A3000EE9BC, 0x0002888480007083, 0x8000708B000180BE, 0x000EF1A5000EF9A6, 0x000E31AB8000708F, 0x00000886000E2DAA, 0x000E01AF00014C87, 0x000E21AD000E1DAE, 
0x0000A980000E29AC, 0x00004D820000A981, 0x8000709300017DB3, 0x000165B600016DB5, 0x8000709B80007097, 0x0000F9BA8000709F, 0x0000E9BC0000F9BB, 0x0000D9BE0000E9BD, 
0x0002A9A80000D9BF, 0x0002B9AA0002A9A9, 0x0002A9AC0002B9AB, 0x00031DAE0002A9AD, 0x0004ACBE000311AF, 0x800070A7800070A3, 0x800070AB0005E0BE, 0x800070B3800070AF, 
0x000371B8800070B7, 0x000375BA000371B9, 0x000319BC000309BB, 0x000309BE000319BD, 0x000371B0000301BF, 0x000371B2000371B1, 0x000351B4000371B3, 0x000351B6000351B5, 
0x000231A3000351B7, 0x800070BB80006F37, 0x800070C3800070BF, 0x000221A5000229A6, 0x0003B5AB800070C7, 0x800070CB0003B5AA, 0x000395AF800070CF, 0x0003A5AD000395AE, 
0x800070D30003A5AC, 0x800070DB800070D7, 0x800070E3800070DF, 0x800070EB800070E7, 0x00003980800070EF, 0x0000058200003981, 0x800070FB800070F3, 0x800070FF0003FC84, 
0x000291A880007103, 0x0002D9AA000299A9, 0x0002F1AC0002D1AB, 0x00013DAE0002F1AD, 0x00050086000135AF, 0x8000710700056487, 0x8000710F8000710B, 0x8000711780007113, 
0x0001E9B88000711B, 0x000189BA0001E9B9, 0x000199BC000189BB, 0x000189BE000199BD, 0x000151B0000189BF, 0x000151B2000151B1, 0x0001F9B4000151B3, 0x0001E9B60001F9B5, 
0x0000F4EF0001E1B7, 0x800071238000711F, 0x8000712700078CBF, 0x000518848000712B, 0x8000712F000E2CEF, 0x80007133000E84E1, 0x000028E3000E30E3, 0x000100E180007137, 
0x0020FC858000713B, 0x8000713F000215B3, 0x000235B680007143, 0x8000714B80007147, 0x0001D1BA00023DB5, 0x8000714F0001D1BB, 0x000179BE80007153, 0x0001C1BC000179BF, 
0x0005D1A30001C1BD, 0x80007157800070F7, 0x8000715F8000715B, 0x0005F9A50005F1A6, 0x000615AB80007163, 0x80007167000615AA, 0x0006BDAF8000716B, 0x000605AD0006BDAE, 
0x00004D80000605AC, 0x0000558200005581, 0x8000716F0006B1B3, 0x000769B6000779B5, 0x0001C08680007173, 0x000755BA0003E887, 0x0007F9BC0007E9BB, 0x0007EDBE0007E5BD, 
0x000671A80007DDBF, 0x000675AA00067DA9, 0x0007BDAC0007A5AB, 0x0007ADAE0007A5AD, 0x800071770007A5AF, 0x8000717F8000717B, 0x8000718780007183, 0x8000718F8000718B, 
0x00077DB880007193, 0x000705BA00070DB9, 0x000709BC000719BB, 0x000735BE00073DBD, 0x0007DDB00000D5BF, 0x000761B2000761B1, 0x000765B400077DB3, 0x000751B6000755B5, 
0x80007197000749B7, 0x8000719F8000719B, 0x0008A4E1800071A3, 0x0004CCE30006A4E1, 0x800071A70005F8E3, 0x00187CEF800071AB, 0x000135A30005F4EF, 0x000505A10003A5A2, 
0x0007BDA300051DA0, 0x800071B3800071AF, 0x800071BB800071B7, 0x000675A5000665A6, 0x0006E5AB800071BF, 0x800071C3000659AA, 0x0006D1AF800071C7, 0x0006E9AD0006E1AE, 
0x007DED8F0006F5AC, 0x00001D8100001D82, 0x800071CB00001D80, 0x800071D3800071CF, 0x0000BC84001C00BE, 0x00009887800071DB, 0x800071DF001F2C86, 0x800071E7800071E3, 
0x0007459F800071EB, 0x0009E99D00096D9E, 0x000D099B000B359C, 0x000F3599000DF59A, 0x0071E5970070CD98, 0x00748D950071E596, 0x0075F5930075E594, 0x0079F19100772592, 
0x800071EF0079F990, 0x007E6582800071F3, 0x007A1984007A0983, 0x00761D860074C585, 0x001C6C8400761587, 0x00774D8A800071F7, 0x0072358C00722D8B, 0x000CD58E0073258D, 
0x00250485000E1D8F, 0x000E9192800071FB, 0x000A71940008B593, 0x0004DD96000AFD95, 0x800071FF00067D97, 0x0006559A80007203, 0x0002759C0000FD9B, 0x001C30BE80007207, 
0x002AA1B38000720B, 0x002FA9B1002801B2, 0x80007087002E85B0, 0x002401B5001DD884, 0x8000720F002BA9B4, 0x8000721780007213, 0x8000721F8000721B, 0x8000722780007223, 
0x001EC5A38000722B, 0x0002E1A1001EC5A2, 0x001A01A78000722F, 0x001801A5001AF5A6, 0x001001AB001E05A4, 0x0016C9A90016D5AA, 0x002EF5AF001401A8, 0x0012A5AD00138DAE, 
0x00032DA80012F9AC, 0x000355AA000355A9, 0x0003B5AC0003ADAB, 0x0003B5AE0003BDAD, 0x800072330003ADAF, 0x8000723B80007237, 0x000019808000723F, 0x0000058200001981, 
0x000265B880007243, 0x000201BA000201B9, 0x000201BC000201BB, 0x000231BE000209BD, 0x0003D5B0000231BF, 0x0003D5B20003DDB1, 0x000275B400026DB3, 0x000275B600027DB5, 
0x0006B8E100025DB7, 0x000600E38000724B, 0x8000724F001CC4BE, 0x001C38860000F0EF, 0x80007253001CBC87, 0x80007257000014E3, 0x001F10860001D4E1, 0x00076CEF001F8487, 
0x8000725B001FF084, 0x00036DB500036DB6, 0x00038DB3001F84BE, 0x800072638000725F, 0x0002E9BF80007267, 0x0002E9BD0002E1BE, 0x000349BB000351BC, 0x8000726B000341BA, 
0x800071D78000726F, 0x8000727380007247, 0x8000727B80007277, 0x800072838000727F, 0x001D85A880007287, 0x001D9DAA001D95A9, 0x001D8DAC001D95AB, 0x001E3DAE001E35AD, 
0x001E05B0001E19AF, 0x001E2DB2001E25B1, 0x001E2DB4001E39B3, 0x001EFDB6001EF5B5, 0x001ECDB8001EF5B7, 0x001EDDBA001ED5B9, 0x001ECDBC001ED5BB, 0x001F59BE001EB9BD, 
0x001D35B3001F59BF, 0x8000728F8000728B, 0x8000729780007293, 0x001D25B5001E95B6, 0x001EC1BB8000729B, 0x8000729F001EE1BA, 0x001E11BF800072A3, 0x001ECDBD001EC9BE, 
0x800072A7001ED9BC, 0x800072AB001D71A3, 0x001ED1A6800072AF, 0x800072B7800072B3, 0x001EA5AA001D61A5, 0x800072BB001E85AB, 0x001E8DAE800072BF, 0x001E9DAC001E55AF, 
0x001E85A8001E89AD, 0x001EA9AA001E95A9, 0x001ED1AC001EA5AB, 0x001EC1AE001EC1AD, 0x0001E980001EC1AF, 0x0001FD820001E981, 0x800072C7800072C3, 0x800072CF800072CB, 
0x0001C5B8800072D3, 0x0001C5BA0001CDB9, 0x0001CDBC0001DDBB, 0x0001F5BE0001FDBD, 0x001E99B000019DBF, 0x000161B2001E99B1, 0x000161B4000161B3, 0x000161B6000161B5, 
0x001E21B3000161B7, 0x800072DB800072D7, 0x800072E3800072DF, 0x001E59B5001E41B6, 0x001E5DBB00009084, 0x800072E7001E5DBA, 0x0001A5BF800072EB, 0x0001B5BD0001A5BE, 
0x800072EF0001B5BC, 0x800072F3001E65A3, 0x001E05A6800072F7, 0x800072FF800072FB, 0x001E19AA001E1DA5, 0x80007303001E19AB, 0x0001E1AE80007307, 0x0001F1AC0001E1AF, 
0x0002E9A80001F1AD, 0x000325AA0002E9A9, 0x000325AC00033DAB, 0x000325AE00032DAD, 0x8000730B000399AF, 0x800073138000730F, 0x00000D8080007317, 0x0000B1820000B181, 
0x000395B88000731B, 0x0003A1BA00039DB9, 0x000071BC0003A1BB, 0x000071BE000071BD, 0x0003E9B0000071BF, 0x0003F9B20003E9B1, 0x0003DDB40003C5B3, 0x0003B1B60003B5B5, 
0x0003ADB30003B1B7, 0x800073238000731F, 0x8000732F8000732B, 0x0003ADB50003ADB6, 0x00032DBB80007333, 0x0004088600032DBA, 0x000371BF0003DC87, 0x000311BD000319BE, 
0x8000733700032DBC, 0x8000733B0003E9A3, 0x0003E9A68000733F, 0x8000734780007343, 0x000369AA0003E9A5, 0x8000734B000369AB, 0x00035DAE8000734F, 0x000369AC000335AF, 
0x80007353000355AD, 0x001FADA5001FADA6, 0x001F4DA380007357, 0x8000735F8000735B, 0x001E29AF80007363, 0x001E29AD001E21AE, 0x001F89AB001F91AC, 0x80007367001F81AA, 
0x8000736F8000736B, 0x000544BE80007373, 0x8000737700048084, 0x8000737B001EF8E3, 0x8000737F001EF4E1, 0x80007383001E50EF, 0x00000D8080007387, 0x0000ED820000E581, 
0x001E00E18000738B, 0x001F0CE3001C30E1, 0x8000738F001FBCE3, 0x0004B88680007393, 0x000720BE00055C87, 0x8000739F8000739B, 0x800073A7800073A3, 0x001ECCEF800073AB, 
0x00015DB3001F3CEF, 0x800073B3800073AF, 0x800073BB800073B7, 0x000111B5000119B6, 0x00010DBB800073BF, 0x800073C300010DBA, 0x0000E9BF800073C7, 0x0000F5BD0000E1BE, 
0x00068DA80000FDBC, 0x000695AA000695A9, 0x0006D9AC0006CDAB, 0x0006CDAE0006D9AD, 0x800073970006C5AF, 0x800073CF800073CB, 0x800073D7800073D3, 0x800073DF800073DB, 
0x00077DB8800073E3, 0x00070DBA000705B9, 0x000709BC00071DBB, 0x000731BE000735BD, 0x000689B0000731BF, 0x000769B2000689B1, 0x000765B4000761B3, 0x000765B600076DB5, 
0x00061DA3000745B7, 0x800073EB800073E7, 0x800073F3800073EF, 0x000651A5000659A6, 0x00064DAB800073F7, 0x800073FB00064DAA, 0x0007A9AF800073FF, 0x0007B5AD0007A1AE, 
0x000069800007BDAC, 0x0000058200006981, 0x8000740780007403, 0x0003A8878000740B, 0x8000740F00009C86, 0x8000741780007413, 0x8000741F8000741B, 0x8000742780007423, 
0x0006ADB38000742B, 0x800074338000742F, 0x8000743B80007437, 0x0006ADB50006D1B6, 0x0006FDBB8000743F, 0x800074430006F5BA, 0x000119BF80007447, 0x0006D5BD000111BE, 
0x8000744B0006D5BC, 0x800074538000744F, 0x8000745B80007457, 0x8000745F0006D8E3, 0x800074630005ECE1, 0x800074670004D4EF, 0x00001D808000746B, 0x0000D98200000981, 
0x000625A88000746F, 0x000625AA00062DA9, 0x000625AC00063DAB, 0x000651AE000651AD, 0x80007473000651AF, 0x000024BE00013C84, 0x000F10868000747B, 0x8000747F0000C487, 
0x0001F5B880007483, 0x0001F5BA0001FDB9, 0x000159BC000149BB, 0x000149BE000159BD, 0x000631B0000141BF, 0x000601B2000639B1, 0x0001D5B4000601B3, 0x0001D5B60001DDB5, 
0x800074870001CDB7, 0x8000748F8000748B, 0x800074930005A1A3, 0x0005DDA60005A1A5, 0x8000749B80007497, 0x0005F9AA8000749F, 0x0005D9AC0005F1AB, 0x00021DAE0005D9AD, 
0x0002B1B6000215AF, 0x800074A7800074A3, 0x800074AB0002A1B5, 0x800074AF0002B1B3, 0x000371BE800074B3, 0x000361BC000379BF, 0x00028DBA000361BD, 0x800074B7000371BB, 
0x00027DB0800074BB, 0x000381B2000381B1, 0x000381B4000381B3, 0x0003B1B6000389B5, 0x0003E1B80003B1B7, 0x0003E1BA0003E1B9, 0x0003E1BC0003E1BB, 0x0003D9BE0003EDBD, 
0x000DE0860003D5BF, 0x800074BF000CE887, 0x800074C7800074C3, 0x80007327800074CB, 0x000235A8800074CF, 0x00020DAA000205A9, 0x00021DAC000205AB, 0x00020DAE000205AD, 
0x0003E5A3000205AF, 0x800074D7800074D3, 0x800074DF800074DB, 0x0003F5A50003E5A6, 0x000225AB800074E3, 0x000228840003D9AA, 0x00022DAF000D20BE, 0x000235AD000225AE, 
0x800074EB000235AC, 0x800074F3800074EF, 0x000CDCBE800074F7, 0x800074FB000190E1, 0x800074FF0000E8E3, 0x8000750780007503, 0x00007D8000003CEF, 0x0000658200006581, 
0x8000750F8000750B, 0x8000751780007513, 0x8000751F8000751B, 0x8000752780007523, 0x8000752B0006C4EF, 0x003FA0BF000624E1, 0x8000752F0006F0E3, 0x80007533000DBC84, 
0x8000753B80007537, 0x800075438000753F, 0x80007547000271B3, 0x0001D1B60001D1B5, 0x8000754F8000754B, 0x0001C9BA80007553, 0x0001B5BC0001C9BB, 0x0001A9BE0001BDBD, 
0x000DADA80001A5BF, 0x000DB5AA000DBDA9, 0x000E15AC000E0DAB, 0x000E09AE000E1DAD, 0x800074E7000E01AF, 0x000FC981000FC182, 0x80007557000FF180, 0x000098868000755B, 
0x000E3DB800036087, 0x000E85BA000E8DB9, 0x000E85BC000E9DBB, 0x000F5DBE000E89BD, 0x000E41B0000F55BF, 0x000E2DB2000E41B1, 0x000E21B4000E25B3, 0x000E25B6000E2DB5, 
0x000D3DA3000E05B7, 0x800075638000755F, 0x8000756B80007567, 0x000E9DA5000E9DA6, 0x000E85AB8000756F, 0x80007573000E85AA, 0x000EE9AF80007577, 0x000EF1AD000EE5AE, 
0x8000757B000EF9AC, 0x8000757F000F8DB3, 0x000FB1B680007583, 0x8000758B80007587, 0x000F9DBA000F85B5, 0x8000758F000F65BB, 0x000F7DBE80007593, 0x000F7DBC000F65BF, 
0x000E49A3000F75BD, 0x8000759B80007597, 0x800075A38000759F, 0x000E41A5000E75A6, 0x000EA1AB800075A7, 0x800075AB000E59AA, 0x000EA1AF800075AF, 0x000EB1AD000EB9AE, 
0x800075B3000EB9AC, 0x800075BB800075B7, 0x000C84EF800075BF, 0x0000158100003182, 0x000C58E300001580, 0x000EC0E1800075C3, 0x000138BE00012084, 0x0000D886800075CB, 
0x000EC1A800005C87, 0x000EC1AA000EC1A9, 0x000EC9AC000EC1AB, 0x000EFDAE000EF5AD, 0x0000A084000EF5AF, 0x800075D3800075CF, 0x800075DB800075D7, 0x800075E3800075DF, 
0x000E61B8800075E7, 0x000E71BA000E75B9, 0x000E11BC000E71BB, 0x000E11BE000E11BD, 0x000E9DB0000E0DBF, 0x000E6DB2000E65B1, 0x000E7DB4000E65B3, 0x000E6DB6000E65B5, 
0x000235A8000E65B7, 0x000281AA000281A9, 0x000281AC000281AB, 0x0002B1AE000289AD, 0x01DD28BF0002B1AF, 0x800075EF800075EB, 0x800075F30005E084, 0x800075FB800075F7, 
0x000349B8800075FF, 0x000359BA000349B9, 0x000379BC000351BB, 0x000319BE000379BD, 0x0002A1B0000319BF, 0x0002A5B20002ADB1, 0x0002A9B40002B9B3, 0x000295B600029DB5, 
0x000209B3000379B7, 0x8000760780007603, 0x8000760F8000760B, 0x000209B5000209B6, 0x000269BB80007613, 0x80007617000265BA, 0x000259BF8000761B, 0x00026DBD00026DBE, 
0x8000761F000271BC, 0x8000762300024DA3, 0x00024DA680007627, 0x8000762F8000762B, 0x000221AA00024DA5, 0x8000763300022DAB, 0x000229AE80007477, 0x000235AC00021DAF, 
0x000275A8000229AD, 0x0002A1AA0002A1A9, 0x0002A1AC0002A1AB, 0x0002A1AE0002A1AD, 0x0001F5800002A1AF, 0x0001C1820001FD81, 0x8000763B0005A0BE, 0x000574878000763F, 
0x0001CDB800051C86, 0x0001D5BA0001D5B9, 0x0001FDBC0001E5BB, 0x000191BE000195BD, 0x000145B0000191BF, 0x000159B200014DB1, 0x000149B4000159B3, 0x0001FDB6000149B5, 
0x800076430001F5B7, 0x000484BE80007647, 0x8000764B000004EF, 0x800076538000764F, 0x80007657000E34EF, 0x8000765B000F7CE1, 0x000000EC000E08E3, 0x8000765F000194E1, 
0x800076630000C0E3, 0x8000766B80007667, 0x8000766F000265B3, 0x00026DB6000265B5, 0x8000767780007673, 0x0001CDBA8000767B, 0x0001C1BC0001C5BB, 0x0001C1BE0001C1BD, 
0x0005A9A30001C1BF, 0x8000767F80007637, 0x8000768780007683, 0x0005A9A50005A1A6, 0x000609AB8000768B, 0x8000768F000601AA, 0x00060DAF80007693, 0x00060DAD00060DAE, 
0x8000769700060DAC, 0x00001D8100001D82, 0x8000769B00001D80, 0x800076A38000769F, 0x0000C086800076A7, 0x800076AB00033487, 0x800076B3800076AF, 0x800076BB800076B7, 
0x0007B1A8800076BF, 0x000709AA0007B1A9, 0x000701AC000709AB, 0x000701AE000701AD, 0x0003A88400073DAF, 0x800076C7800076C3, 0x800076CF800076CB, 0x800076D7800076D3, 
0x000725B8800076DB, 0x0000C5BA0000CDB9, 0x0000CDBC0000DDBB, 0x0000F5BE0000FDBD, 0x000749B000009DBF, 0x000729B200075DB1, 0x000739B4000729B3, 0x000725B6000725B5, 
0x000681B300071DB7, 0x800076E3800076DF, 0x800076EB800076E7, 0x000689B5000681B6, 0x000699BB800076EF, 0x800076F300068DBA, 0x0006E1BF800076F7, 0x0006FDBD0006FDBE, 
0x800076FB0006FDBC, 0x80007703800076FF, 0x0000318080007707, 0x0000298200003D81, 0x8000770B000488EF, 0x8000770F000604E1, 0x800077130006DCE3, 0x80007717000174BE, 
0x000601A38000771B, 0x000028868000771F, 0x8000772300014487, 0x000609A5000601A6, 0x000619AB80007727, 0x8000772B00060DAA, 0x000661AF8000772F, 0x00067DAD00067DAE, 
0x8000773300067DAC, 0x800077370001B5B3, 0x0001ADB68000773B, 0x800077438000773F, 0x00014DBA0001A5B5, 0x80007747000155BB, 0x00014DBE8000774B, 0x00014DBC0000F1BF, 
0x000269A8000145BD, 0x000279AA000269A9, 0x000269AC000279AB, 0x0002BDAE000269AD, 0x003C00840002B5AF, 0x800077538000774F, 0x8000775B80007757, 0x800077638000775F, 
0x000351B880007767, 0x000361BA000359B9, 0x000311BC000361BB, 0x000311BE000311BD, 0x0002CDB0000311BF, 0x0002DDB20002D5B1, 0x0002CDB40002D5B3, 0x000371B6000371B5, 
0x8000776B000371B7, 0x800077738000776F, 0x800077770002FDA3, 0x0002E5A60002EDA5, 0x8000777F8000777B, 0x000205AA80007783, 0x000205AC00021DAB, 0x000205AE00020DAD, 
0x000065820003B9AF, 0x000055800002E4EF, 0x0003148700006D81, 0x003C54BE003D7486, 0x800075C78000778B, 0x800077938000778F, 0x8000779B80007797, 0x8000779F0002C4E3, 
0x00027DA800016CE1, 0x000299AA000281A9, 0x0002B9AC000291AB, 0x0002D9AE0002B9AD, 0x800077A30002D5AF, 0x800077AB800077A7, 0x800077B3800077AF, 0x800077BB800077B7, 
0x000171B8800077BF, 0x000171BA000171B9, 0x0001D1BC000171BB, 0x0001D1BE0001D1BD, 0x0002ADB00001CDBF, 0x0002B1B20002B1B1, 0x00029DB4000285B3, 0x000151B6000151B5, 
0x0006A4E1000151B7, 0x0007B4E3800077C3, 0x003D1884003D80BE, 0x800077CB800077C7, 0x800077D3800077CF, 0x800077DB800077D7, 0x800077E3800077DF, 0x0006C8EF800077E7, 
0x00000981800077EB, 0x800077EF00007980, 0x000160E300001982, 0x0001A0E1800077F3, 0x00006CEF800077FB, 0x003CC886800077FF, 0x80007803003D0C87, 0x8000780B80007807, 
0x003D91A38000780F, 0x800077F780007787, 0x8000781780007813, 0x003DB1A5003DB9A6, 0x003DF5AB8000781B, 0x8000781F003DE9AA, 0x003E15AF80007823, 0x003DD1AD003DD9AE, 
0x80007827003DE5AC, 0x8000782B003EADB3, 0x003EA9B68000782F, 0x8000783780007833, 0x003F49BA003EADB5, 0x8000783B003F49BB, 0x003F49BE8000783F, 0x003F49BC003F49BF, 
0x003E69A3003F49BD, 0x8000784780007843, 0x8000784F8000784B, 0x003E69A5003E6DA6, 0x003F8DAB80007853, 0x80007857003F8DAA, 0x003F8DAF8000785B, 0x003F8DAD003F8DAE, 
0x8000785F003F8DAC, 0x003D05BA80007863, 0x003D09BC003D19BB, 0x003D35BE003D3DBD, 0x00004D80003EF9BF, 0x00002D8200002581, 0x000038BE003D7DB3, 0x003D55B6003D5DB5, 
0x003FDDA800003084, 0x003FE1AA003FE1A9, 0x003FE1AC003FE1AB, 0x003E39AE003FEDAD, 0x80007867003E39AF, 0x000088868000786B, 0x8000786F0001AC87, 0x8000787780007873, 
0x003ED9B88000787B, 0x003EE9BA003ED9B9, 0x003EF9BC003EE9BB, 0x003EE9BE003EF9BD, 0x003E49B0003EE9BF, 0x003E59B2003E49B1, 0x003E49B4003E59B3, 0x003EFDB6003E49B5, 
0x003E5DA8003EE9B7, 0x003E79AA003E61A9, 0x003E69AC003E79AB, 0x000195AE003E69AD, 0x0001A08400018DAF, 0x800078838000787F, 0x8000788B80007887, 0x800078938000788F, 
0x0001A9B880007897, 0x00014DBA0001A9B9, 0x00015DBC000145BB, 0x000145BE000145BD, 0x0001FDB0000175BF, 0x0001C5B20001CDB1, 0x0001B9B40001ADB3, 0x0001ADB60001B9B5, 
0x003DF1B30001A5B7, 0x000344BE8000789B, 0x8000789F000444BE, 0x003DE1B5003DE9B6, 0x000209BB800078A3, 0x800078A7000239BA, 0x00027DBF800078AB, 0x000279BD00027DBE, 
0x800078AF000211BC, 0x800078B3003DB5A3, 0x003DADA6800078B7, 0x800078BF800078BB, 0x00027DAA003DA5A5, 0x800078C300024DAB, 0x000239AE800078C7, 0x000255AC000239AF, 
0x0000118000023DAD, 0x0000118200001181, 0x800078CB00060CBE, 0x800078D3800078CF, 0x800078DB00026CEF, 0x800078DF000194E1, 0x800078E300011CE3, 0x00041886800078E7, 
0x800078EB00037087, 0x800078F3800078EF, 0x800078F70003F9B3, 0x00037DB60003E9B5, 0x0007ACBE800078FB, 0x000359BA800078FF, 0x000349BC000359BB, 0x0000FDBE000349BD, 
0x000225A80000EDBF, 0x00023DAA000235A9, 0x00022DAC000235AB, 0x0002B1AE0002B1AD, 0x000968BE0002B1AF, 0x8000790780007903, 0x000AF8BE8000790B, 0x800079138000790F, 
0x00016DB880007917, 0x000101BA000105B9, 0x000105BC000101BB, 0x000131BE00010DBD, 0x0002D1B0000131BF, 0x0002D1B20002D1B1, 0x000175B40002D1B3, 0x000165B6000165B5, 
0x003F4CE1000155B7, 0x003E08E3000168E3, 0x8000791B003E7CE1, 0x800079238000791F, 0x000D2CBE80007927, 0x8000792F8000792B, 0x000C3CBE80007933, 0x003ECCEF0001BCEF, 
0x0002F5A380007937, 0x0000158100002D82, 0x8000793B00001D80, 0x0002E5A5000271A6, 0x000255AB8000793F, 0x80007943000255AA, 0x0001E1AF0005A084, 0x000245AD0001F1AE, 
0x0006A1A8000245AC, 0x0006B9AA0006ADA9, 0x0006D1AC0006B9AB, 0x0006D1AE0006D1AD, 0x800079470006CDAF, 0x000308868000794B, 0x8000794F00030887, 0x8000795780007953, 
0x0007D1B88000795B, 0x0007D1BA0007D1B9, 0x0007F5BC0007D1BB, 0x0007F5BE0007FDBD, 0x0006BDB00007E1BF, 0x00074DB2000681B1, 0x00075DB4000745B3, 0x000741B6000741B5, 
0x000631B3000741B7, 0x800079638000795F, 0x8000796B80007967, 0x000659B5000651B6, 0x000645BB8000796F, 0x80007973000679BA, 0x000785BF80007977, 0x000791BD000799BE, 
0x8000797B000799BC, 0x8000797F000675A3, 0x000615A680007983, 0x8000798B80007987, 0x00063DAA00061DA5, 0x8000798F000601AB, 0x0007DDAE80007993, 0x0007DDAC0007C1AF, 
0x0005A0E10007D5AD, 0x0004F4E380007997, 0x8000799F8000799B, 0x800079A7800079A3, 0x00000981800079AB, 0x800079AF00003980, 0x800079B300001D82, 0x0005CCEF800079B7, 
0x000175B30002B084, 0x0000E886800079BB, 0x800079BF00012C87, 0x000165B50001D1B6, 0x0001FDBB800079C3, 0x800079C70001F5BA, 0x0001B9BF800079CB, 0x0001D5BD0001B5BE, 
0x0001A5A80001D5BC, 0x0001BDAA0001B5A9, 0x0001ADAC0001B5AB, 0x000111AE000111AD, 0x0001AC84000111AF, 0x800079D3800079CF, 0x800079DB800079D7, 0x800079E3800079DF, 
0x000119B8800079E7, 0x000125BA00012DB9, 0x0000DDBC0000C9BB, 0x0000CDBE0000C5BD, 0x000171B00000C5BF, 0x000141B2000179B1, 0x000131B4000141B3, 0x000135B600013DB5, 
0x800079EB000129B7, 0x800079F3800079EF, 0x800079F7000239A3, 0x00029DA6000229A5, 0x800079FF800079FB, 0x0002B9AA80007A03, 0x000299AC0002B1AB, 0x0002F9AE000299AD, 
0x80007A070002F5AF, 0x000CE88680007A0B, 0x80007A0F00036887, 0x80007A1780007A13, 0x00003D8080007A1B, 0x0000198200000981, 0x80007A2380007A1F, 0x80007A2F80007A2B, 
0x80007A3780007A33, 0x000690EF800078D7, 0x80007A3F80007A3B, 0x80007A4780007A43, 0x000CEC8480007A4B, 0x80007A5380007A4F, 0x0001E0E180007A57, 0x000108E380007A5B, 
0x00039DB380007A5F, 0x80007A6780007A63, 0x80007A6F80007A6B, 0x0003B5B5000371B6, 0x000355BB80007A73, 0x80007A77000355BA, 0x0000F5BF80007A7B, 0x000345BD0000F5BE, 
0x000245A8000345BC, 0x000255AA000255A9, 0x00027DAC000265AB, 0x0002B1AE0002B1AD, 0x00001D810002B1AF, 0x80007A7F00001D80, 0x80007A830000AD82, 0x80007A8B80007A87, 
0x00015DB880007A8F, 0x00016DBA000165B9, 0x000115BC00010DBB, 0x00010DBE000105BD, 0x0002D1B0000105BF, 0x0002D1B20002D1B1, 0x000171B40002D1B3, 0x000171B6000171B5, 
0x80007A9300016DB7, 0x80007A9B002BD0E1, 0x000F90860017D8E3, 0x80007A9F000D5C87, 0x80007AA30007E8EF, 0x80007AA7000194E1, 0x000BB0BE000080E3, 0x80007AAF80007AAB, 
0x00029DA3003F60EF, 0x80007AB780007AB3, 0x80007ABF80007ABB, 0x0002B5A5000271A6, 0x000255AB80007AC3, 0x80007AC7000255AA, 0x0001F5AF80007ACB, 0x000245AD0001F5AE, 
0x000E75A8000245AC, 0x000E75AA000E7DA9, 0x000E9DAC000E8DAB, 0x000E8DAE000E85AD, 0x80007A97000E85AF, 0x80007AD380007ACF, 0x80007ADB80007AD7, 0x80007AE380007ADF, 
0x000E8DB880007AE7, 0x000E95BA000E95B9, 0x000EBDBC000EA5BB, 0x000F69BE000F7DBD, 0x000EFDB0000F69BF, 0x000EC1B2000EC1B1, 0x000EC5B4000EC1B3, 0x000EBDB6000EC9B5, 
0x000EFDB3000EB5B7, 0x80007AEF80007AEB, 0x80007AF780007AF3, 0x000E15B5000E05B6, 0x000E05BB80007AFB, 0x80007AFF000E39BA, 0x000E0DBF80007B03, 0x000E15BD000E01BE, 
0x00006D82000E15BC, 0x00005580000EB9A3, 0x000E41A600006581, 0x80007B0B00011884, 0x000E7DAA000E51A5, 0x00040086000E41AB, 0x000E45AE00007887, 0x000E51AC000E49AF, 
0x0025298F000E51AD, 0x80007B0F0003F4E1, 0x80007B13000154E3, 0x80007B17000DA4E3, 0x80007B1B000D4CE1, 0x80007B1F0008FCEF, 0x80007B2780007B23, 0x80007B2F80007B2B, 
0x0008619F000864EF, 0x00094D9D00094D9E, 0x00350D9B0034359C, 0x0037B9990035519A, 0x0031419700316D98, 0x003DB99500338996, 0x003FA993003D4D94, 0x00397D910039AD92, 
0x0015A5B100397D90, 0x01E989B30015A5B0, 0x01E855B5001441B2, 0x80007B3301E989B4, 0x80007B3B80007B37, 0x80007B4380007B3F, 0x000329A380007B47, 0x000D99A1000C81A2, 
0x0001E1A1000F39A0, 0x0005CDA380007B4B, 0x000481A500034DA2, 0x0019D5A70005DDA4, 0x001DE1A90019DDA6, 0x001CE5AB00188DA8, 0x0011D1AD001DE9AA, 0x001401AF001001AC, 
0x00262982001151AE, 0x80007B4F003A0583, 0x003CC98680007B53, 0x003A1D84003E3587, 0x003EF18A003AC585, 0x80007B570030C98B, 0x0034D18E80007B5B, 0x0032198C0036318F, 
0x00361D9200320D8D, 0x0003448400373D93, 0x000B71960004C484, 0x000A5D94000CD197, 0x000E419A000A5595, 0x80007B5F000F519B, 0x80007B6780007B63, 0x0000E19C80007B6B, 
0x80007B0780007B6F, 0x80007B7B80007B73, 0x0000ED8180007B7F, 0x80007A270000E180, 0x000D29A800001982, 0x000D09AA000D3DA9, 0x000D05AC000D05AB, 0x000D7DAE000D0DAD, 
0x000D0DB0000D75AF, 0x000D15B2000D15B1, 0x000D3DB4000D25B3, 0x0002F1B60002F1B5, 0x0002D1B80002F1B7, 0x0002D1BA0002D1B9, 0x000275BC0002D1BB, 0x000275BE00027DBD, 
0x000CA1B300026DBF, 0x0002B48780007B83, 0x80007B8700052C86, 0x000CADB5000CADB6, 0x000CF1BB80007B8B, 0x80007B8F000CE9BA, 0x000315BF80007B93, 0x000CD1BD000CD9BE, 
0x80007B97000CE1BC, 0x80007B9B000CE5A3, 0x000CE9A680007B9F, 0x80007BA780007BA3, 0x000CADAA000CE9A5, 0x80007BAB000CB5AB, 0x000C9DAE80007BAF, 0x000CA5AC000351AF, 
0x80007BB3000C95AD, 0x80007BBB80007BB7, 0x80007BC380007BBF, 0x80007BCB80007BC7, 0x80007BCF000A54EF, 0x80007BD3000E2CE1, 0x80007BD7000168E3, 0x0000718100007982, 
0x0002D1B300007980, 0x80007BDF80007BDB, 0x80007BEB80007BE3, 0x0002F9B50002FDB6, 0x0002D9BB80007BEF, 0x0004C8860002D1BA, 0x000255BF0004AC87, 0x000265BD000255BE, 
0x000511A3000265BC, 0x80007BE780007B77, 0x80007BF780007BF3, 0x000539A500053DA6, 0x000519AB80007BFB, 0x80007BFF000511AA, 0x000595AF80007C03, 0x0005A5AD000595AE, 
0x80007C070005A5AC, 0x80007C0B000741B3, 0x000779B680007C0F, 0x80007C1780007C13, 0x000729BA000741B5, 0x80007C1B000729BB, 0x000719BE80007C1F, 0x00072DBC000719BF, 
0x000609A8000725BD, 0x00078DAA000609A9, 0x00078DAC00079DAB, 0x0007B5AE0007BDAD, 0x80007C230007DDAF, 0x80007C2B80007C27, 0x80007C3380007C2F, 0x80007C3B80007C37, 
0x000749B880007C3F, 0x000759BA000749B9, 0x000749BC000759BB, 0x000771BE000775BD, 0x0007A9B000076DBF, 0x0007BDB20007A9B1, 0x000799B40007B5B3, 0x000779B6000799B5, 
0x000605A3000779B7, 0x80007C4780007C43, 0x80007C4F80007C4B, 0x000605A500063DA6, 0x00066DAB80007C53, 0x0002A88400066DAA, 0x00065DAF80007C5B, 0x000661AD00065DAE, 
0x00004D80000669AC, 0x0000558200005581, 0x80007C57000141B3, 0x000171B6000149B5, 0x0000C08680007C5F, 0x000121BA0001A887, 0x000125BC000121BB, 0x000111BE00012DBD, 
0x000651A8000111BF, 0x000185AA000659A9, 0x00018DAC00019DAB, 0x0001B5AE0001BDAD, 0x0000A0840001DDAF, 0x80007C6780007C63, 0x80007C6F80007C6B, 0x80007C7780007C73, 
0x000169B880007C7B, 0x000179BA000169B9, 0x000169BC000179BB, 0x0000DDBE000169BD, 0x0001A9B00000D5BF, 0x0001BDB20001A9B1, 0x000199B40001B5B3, 0x000159B6000199B5, 
0x00040DBA000159B7, 0x0007CDB800042DBB, 0x00047DBE000405B9, 0x000435BC000465BF, 0x0007B9B2000475BD, 0x00071DB00007B9B3, 0x000799B6000715B1, 0x000799B4000799B7, 
0x000751AA000799B5, 0x000691A800075DAB, 0x00077DAE000745A9, 0x000779AC000765AF, 0x80007C7F000775AD, 0x80007C8780007C83, 0x80007C8F80007C8B, 0x80007C9780007C93, 
0x80007C9F80007C9B, 0x001C00BE80007CA3, 0x80007CA7000281A3, 0x0002B1A6000289A5, 0x80007CAF80007CAB, 0x0002E1AA80007CB3, 0x0002E5AC0002E1AB, 0x0002D1AE0002EDAD, 
0x80007CB70002D1AF, 0x0000118100002582, 0x80007CBB00001D80, 0x80007CBF0001ACE1, 0x80007CC300016CE3, 0x80007CCF80007CCB, 0x001CB08700029CEF, 0x80007CD3001CD486, 
0x00022DA880007CD7, 0x0002ADAA000259A9, 0x0002BDAC0002A5AB, 0x0002ADAE0002A5AD, 0x001DA0840002A5AF, 0x80007CDF80007CDB, 0x80007CE780007CE3, 0x001CB4BE80007CEB, 
0x00013DB880007CEF, 0x0001CDBA0001C5B9, 0x0001CDBC0001DDBB, 0x0001FDBE0001F5BD, 0x0002DDB000019DBF, 0x00010DB2000105B1, 0x00011DB4000105B3, 0x00010DB6000105B5, 
0x000694E1000105B7, 0x0007D4E30000BCE3, 0x80007CF300067CE1, 0x80007CFB80007CF7, 0x80007D0380007CFF, 0x80007D0B80007D07, 0x001F78BE80007D0F, 0x000EF0EF000AFCEF, 
0x80007D1780007D13, 0x80007D1F80007D1B, 0x80007D23000269B3, 0x000269B6000279B5, 0x80007D2B80007D27, 0x000255BA80007D2F, 0x000195BC00018DBB, 0x000195BE00019DBD, 
0x80007CC700018DBF, 0x80007D33001DA1A3, 0x001DA1A680007D37, 0x80007D3F80007D3B, 0x001D9DAA001DB1A5, 0x00030886001E45AB, 0x001E5DAE00037C87, 0x001E5DAC001E45AF, 
0x001FA180001E55AD, 0x00004182001FA181, 0x80007D43001EB5B3, 0x001F71B6001F71B5, 0x80007D4B80007D47, 0x001F5DBA80007D4F, 0x001FE1BC001F51BB, 0x001FE1BE001FE1BD, 
0x001E65A8001FE1BF, 0x001E71AA001E6DA9, 0x001FB5AC001E71AB, 0x001FB5AE001FBDAD, 0x80007D53001FADAF, 0x80007D5B80007D57, 0x80007D6380007D5F, 0x80007D6B80007D67, 
0x001F69B880007D6F, 0x001F75BA001F69B9, 0x001F15BC001F0DBB, 0x001F09BE001F1DBD, 0x001FD5B0001F01BF, 0x001F79B2001FD9B1, 0x001F69B4001F79B3, 0x001F59B6001F69B5, 
0x001FF9A3001F59B7, 0x80007D7780007D73, 0x80007D7F80007D7B, 0x001E3DA5001E3DA6, 0x001E1DAB80007D83, 0x80007D87001E11AA, 0x001EADAF80007D8B, 0x001EADAD001EADAE, 
0x80007D8F001EADAC, 0x80007D9780007D93, 0x00001D8080007D9B, 0x0000398200000981, 0x80007DA380007D9F, 0x80007DA70001A884, 0x0000D08680007DAB, 0x80007DAF0001FC87, 
0x000195A880007DB3, 0x0001D9AA00019DA9, 0x0001F1AC0001D1AB, 0x000139AE0001F1AD, 0x0000A084000139AF, 0x80007DBB80007DB7, 0x80007DC380007DBF, 0x80007DCB80007DC7, 
0x0000CDB880007DCF, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 0x00009DBE000095BD, 0x000149B0000095BF, 0x000159B2000149B1, 0x000149B4000159B3, 0x0000FDB6000149B5, 
0x000251B30000F5B7, 0x80007DD780007DD3, 0x80007DDF80007DDB, 0x000279B5000271B6, 0x00028DBB80007DE3, 0x80007DE700028DBA, 0x00028DBF80007DEB, 0x00028DBD00028DBE, 
0x01F43C8500028DBC, 0x80007DEF000215A3, 0x000235A680007DF3, 0x80007DFB80007DF7, 0x0002C9AA00023DA5, 0x80007DFF0002C9AB, 0x0002C9AE80007E03, 0x0002C9AC0002C9AF, 
0x000019820002C9AD, 0x0000198080007E07, 0x80007E0B00001981, 0x80007E1380007E0F, 0x000400BE80007E1B, 0x80007E2380007E1F, 0x80007E2B80007E27, 0x80007E3380007E2F, 
0x0004E08680007E37, 0x80007E3B00035487, 0x80007E4380007E3F, 0x80007E4700028CEF, 0x80007E4F80007E4B, 0x80007E53000154E3, 0x80007E57000184E1, 0x80007E5F80007E5B, 
0x00026DA880007E63, 0x000275AA00027DA9, 0x0002B9AC0002A9AB, 0x0002A9AE0002B9AD, 0x0005AC840002A9AF, 0x80007E6B80007E67, 0x80007E7380007E6F, 0x80007E7B80007E77, 
0x00016DB880007E7F, 0x000105BA00010DB9, 0x000109BC000119BB, 0x000135BE00013DBD, 0x0002D9B00001D9BF, 0x00016DB20002D9B1, 0x00017DB4000165B3, 0x000165B6000165B5, 
0x0000F4E3000155B7, 0x0001B8E1001F68E1, 0x0000A980001EBCE3, 0x000005820000A981, 0x00042CBE80007E83, 0x80007E8F80007E8B, 0x001EF8EF80007E93, 0x80007E9B80007E97, 
0x0004E086001E7CEF, 0x80007E9F00057487, 0x80007EA30002B1B3, 0x000275B600027DB5, 0x80007EAB80007EA7, 0x000251BA80007EAF, 0x0001F5BC000251BB, 0x0001F5BE0001FDBD, 
0x80007E170001EDBF, 0x0005B1AA80007E87, 0x000615AC0005B1AB, 0x000615AE00061DAD, 0x80007EB300060DAF, 0x80007EBB80007EB7, 0x80007EBF000551A3, 0x000595A600059DA5, 
0x0006E9B380007EC3, 0x80007ECB80007EC7, 0x80007ED380007ECF, 0x0006E9B50006E1B6, 0x0006ADBB80007ED7, 0x80007EDB0006ADBA, 0x000691BF80007EDF, 0x0006A1BD0006A9BE, 
0x00061DA80006ADBC, 0x000621AA000621A9, 0x000621AC000621AB, 0x000621AE000621AD, 0x80007EE3000621AF, 0x80007EEB80007EE7, 0x0000198080007EEF, 0x0000058200001981, 
0x000635B880007EF3, 0x000635BA00063DB9, 0x0007F9BC0007E9BB, 0x0007E9BE0007F9BD, 0x000629B00007E9BF, 0x000639B2000629B1, 0x00062DB4000635B3, 0x000611B6000615B5, 
0x0007A9A300060DB7, 0x000184BE00028C84, 0x80007EFB80007EF7, 0x0007A9A50007A1A6, 0x0007EDAB80007EFF, 0x000088860007EDAA, 0x0007D1AF00017887, 0x0007E1AD0007E9AE, 
0x80007F030007EDAC, 0x80007F070006E9B3, 0x000699B680007F0B, 0x80007F1380007F0F, 0x000681BA0006E5B5, 0x80007F17000681BB, 0x000159BE80007F1B, 0x000159BC000145BF, 
0x000625A8000159BD, 0x000625AA00062DA9, 0x000629AC000639AB, 0x000649AE00065DAD, 0x0001AC84000641AF, 0x80007F2380007F1F, 0x80007F2B80007F27, 0x80007F3380007F2F, 
0x000189B880007F37, 0x000199BA000189B9, 0x0001B9BC000191BB, 0x000179BE0001B9BD, 0x000601B0000179BF, 0x0001C9B2000601B1, 0x0001D9B40001C9B3, 0x0001C5B60001C5B5, 
0x0005ADA30001B9B7, 0x80007F3F80007F3B, 0x80007F4780007F43, 0x0005A1A50005DDA6, 0x0005C5AB80007F4B, 0x80007F4F0005C5AA, 0x000201AF80007F53, 0x00021DAD00021DAE, 
0x80007F5700021DAC, 0x80007F5F80007F5B, 0x0000198180007F63, 0x80007F6B00001180, 0x000324BE00001182, 0x000CC88680007F6F, 0x80007F7300034C87, 0x80007F7B80007F77, 
0x000130E380007F7F, 0x0001B8E180007F83, 0x80007F87000CC084, 0x80007F8F80007F8B, 0x000CE8BE80007F93, 0x80007F9B80007F97, 0x000228EF80007F9F, 0x80007FA780007FA3, 
0x000381B380007FAB, 0x80007FB380007FAF, 0x80007FBB80007FB7, 0x000395B5000381B6, 0x000345BB80007FBF, 0x80007FC3000389BA, 0x000345BF80007FC7, 0x000355BD000345BE, 
0x000211A8000355BC, 0x000249AA000219A9, 0x00025DAC000245AB, 0x000241AE000241AD, 0x00000D80000275AF, 0x0000118200001181, 0x000C64BE80007FCB, 0x80007FD380007FCF, 
0x000145B880007FDB, 0x000145BA00014DB9, 0x00014DBC00015DBB, 0x000175BE00017DBD, 0x00020DB000011DBF, 0x0002C1B20002C1B1, 0x0002C1B40002C1B3, 0x0002C1B60002C1B5, 
0x000658E10002C1B7, 0x00009CE300075CE1, 0x000C30860006BCE3, 0x80007FDF000D5C87, 0x80007FE780007FE3, 0x80007FEF80007FEB, 0x000000EE80007FF3, 0x000048EF80007FF7, 
0x80007FFB0006E4EF, 0x000289A380007FFF, 0x00029DA580008003, 0x8000800B80008007, 0x8000800F000289A6, 0x00024DAB80008013, 0x00025DAD000281AA, 0x00024DAF00025DAC, 
0x000E59A800024DAE, 0x000E79AA000E61A9, 0x000E69AC000E79AB, 0x000E9DAE000E69AD, 0x80007FD7000E8DAF, 0x8000801B80008017, 0x800080238000801F, 0x8000802B80008027, 
0x000EFDB88000802F, 0x000E81BA000E81B9, 0x000E81BC000E81BB, 0x000EB1BE000E89BD, 0x000EF5B0000EB1BF, 0x000EF5B2000EFDB1, 0x000ED9B4000EC9B3, 0x000ECDB6000ED9B5, 
0x000EF1B3000EC5B7, 0x8000803780008033, 0x8000803F8000803B, 0x000EE1B5000EE9B6, 0x000E39BB80008043, 0x0003E484000E31BA, 0x000E1DBF80008047, 0x000E1DBD000E1DBE, 
0x00005D82000E21BC, 0x00004580000EB5A3, 0x000EADA600005D81, 0x8000804F8000804B, 0x000E75AA000EA5A5, 0x0000E886000E7DAB, 0x000E59AE0000E087, 0x000E65AC000E59AF, 
0x000E3DA8000E59AD, 0x000E95AA000E9DA9, 0x000EB5AC000EADAB, 0x000EB5AE000EBDAD, 0x80008053000EA9AF, 0x8000805B80008057, 0x800080638000805F, 0x8000806B80008067, 
0x000169B88000806F, 0x000179BA000169B9, 0x000169BC000179BB, 0x0001DDBE000169BD, 0x000EA1B00001D5BF, 0x000EA5B2000EA1B1, 0x000EA9B4000EB9B3, 0x000E9DB6000E95B5, 
0x000E1DB3000159B7, 0x8000807780008073, 0x8000807F8000807B, 0x000E3DB5000E3DB6, 0x000E65BB80008083, 0x80008087000E65BA, 0x000E51BF8000808B, 0x000E6DBD000E6DBE, 
0x000E65A5000E71BC, 0x800080938000808F, 0x80008097000E65A6, 0x000E45A38000809B, 0x000E35AD8000809F, 0x000E09AF000E29AC, 0x800080A3000E35AE, 0x000E3DAB80007F67, 
0x800080A7000E3DAA, 0x00001D8100001D82, 0x800080AB00001D80, 0x800080B3800080AF, 0x800080BB000350BE, 0x800080C3800080BF, 0x800080CB800080C7, 0x800080D3800080CF, 
0x0003C084800080D7, 0x000E10EF800080DB, 0x0004F08600040084, 0x800080DF00035487, 0x800080E7800080E3, 0x800080EF800080EB, 0x000E00E1800080F3, 0x000EE4E3800080F7, 
0x800080FF800080FB, 0x8000810780008103, 0x8000810F8000810B, 0x8000811780008113, 0x000275A88000811B, 0x000389AA00027DA9, 0x000399AC000389AB, 0x000389AE000399AD, 
0x0003F9B0000389AF, 0x00034DB20003F9B1, 0x00035DB4000345B3, 0x000345B6000345B5, 0x00034DB8000375B7, 0x000321BA000321B9, 0x000325BC00033DBB, 0x000309BE000329BD, 
0x00019D800000FDBF, 0x00001D8200000981, 0x0003F4EF8000811F, 0x000550BE80008123, 0x000370E38000812B, 0x0001D8E18000812F, 0x8000813780008133, 0x8000813F8000813B, 
0x0004E08680008143, 0x8000814700028887, 0x8000814B00026DB3, 0x000275B600027DB5, 0x800081538000814F, 0x000251BA80008157, 0x0002F5BC000251BB, 0x0002F5BE0002FDBD, 
0x8000815B0002EDBF, 0x800081638000815F, 0x8000816B80008167, 0x800081738000816F, 0x0004EC84000E54EF, 0x80008177000E2CE1, 0x8000817B000114E3, 0x800081838000817F, 
0x0002E1A380008187, 0x0000158100002D82, 0x8000818B00001D80, 0x0002F1A50002F9A6, 0x0002DDAB8000818F, 0x800081930002DDAA, 0x000261AF0004B0BE, 0x000271AD000279AE, 
0x000621A8000279AC, 0x000621AA000621A9, 0x000621AC000621AB, 0x000621AE000621AD, 0x80008127000621AF, 0x0000008680008197, 0x8000819B0003A087, 0x800081A38000819F, 
0x00063DB8800081A7, 0x0006CDBA0006C5B9, 0x0006DDBC0006C5BB, 0x0006CDBE0006C5BD, 0x000625B00006C5BF, 0x000635B200063DB1, 0x000615B400060DB3, 0x000615B600061DB5, 
0x0006A9B3000609B7, 0x800081AF800081AB, 0x800081B7800081B3, 0x0006A9B50006A1B6, 0x0006F9BB800081BB, 0x800081BF0006E1BA, 0x0006D9BF800081C3, 0x0006D9BD0006D1BE, 
0x800081C70006E1BC, 0x800081CB0006EDA3, 0x0006E5A6800081CF, 0x800081D7800081D3, 0x0006A5AA0006EDA5, 0x800081DB0006BDAB, 0x000695AE800081DF, 0x0006A5AC00069DAF, 
0x00061DA800069DAD, 0x000625AA000621A9, 0x000625AC00063DAB, 0x000625AE00062DAD, 0x800081E3000655AF, 0x800081EB800081E7, 0x800081F3800081EF, 0x800081FB800081F7, 
0x0006D1B8800081FF, 0x0006D1BA0006D1B9, 0x0006E1BC0006E5BB, 0x0006E1BE0006E1BD, 0x000631B00006E1BF, 0x000609B2000639B1, 0x0006F1B4000609B3, 0x0006F1B60006F1B5, 
0x0006ADB30006F1B7, 0x0000B58100001582, 0x800082030000B580, 0x0006ADB50006ADB6, 0x0006FDBB000010BE, 0x00016C840006F5BA, 0x000635BF8000820B, 0x0006DDBD000635BE, 
0x8000820F0006DDBC, 0x0006FDA50006FDA6, 0x0006FDA380008207, 0x01FC008680008213, 0x000665AF00016087, 0x00068DAD000665AE, 0x0006ADAB00068DAC, 0x800080B70006A5AA, 
0x8000821B80008217, 0x000231B38000821F, 0x000295B580008223, 0x8000822B80008227, 0x8000822F000295B6, 0x000281BB80008233, 0x0002F1BD0002B1BA, 0x0002F5BF000299BC, 
0x00021CE30002F5BE, 0x000188E10007A4EF, 0x800082370003C484, 0x8000823F8000823B, 0x8000824780008243, 0x8000824F8000824B, 0x000228EF80008253, 0x80008257000628E3, 
0x0002B9AA000634E1, 0x0002B9A80002B9AB, 0x00021DAE0002B9A9, 0x00021DAC000205AF, 0x0003ECBE000215AD, 0x8000825F8000825B, 0x8000826780008263, 0x0001B1810001B982, 
0x0003E1BA0001B980, 0x000221B80003E1BB, 0x0003E1BE000221B9, 0x0003F1BC0003E1BF, 0x00024DB20003F1BD, 0x000275B0000225B3, 0x000225B6000245B1, 0x000231B400022DB7, 
0x000339A3000231B5, 0x8000826F8000826B, 0x8000827B80008273, 0x00039DA500039DA6, 0x000389AB8000827F, 0x800082830003B9AA, 0x0003FDAF80008287, 0x0003F9AD0003FDAE, 
0x8000828B000391AC, 0x01FDC886000291B3, 0x000155B601FD4087, 0x800082938000828F, 0x000179BA00015DB5, 0x80008297000145BB, 0x000125BE8000829B, 0x00015DBC00012DBF, 
0x8000829F00012DBD, 0x800082A7800082A3, 0x800082AB01FDC084, 0x0000FCEF800082AF, 0x000190E1000688EF, 0x000010E30006FCE1, 0x800082B300061CE3, 0x01FDF0BE800082B7, 
0x000215A3800082BB, 0x800082C3800082BF, 0x800082CB800082C7, 0x0001D9A50001D1A6, 0x0001C1AB800082CF, 0x800082D30001FDAA, 0x0001A9AF800082D7, 0x0001A9AD0001A1AE, 
0x800082770001D9AC, 0x00001D8100001D82, 0x800082DB00001D80, 0x800082E3800082DF, 0x01FF31A8800082E7, 0x01FF01AA01FF39A9, 0x01FF71AC01FF01AB, 0x01FF61AE01FF61AD, 
0x01FF2DB001FF55AF, 0x01FFCDB201FFC5B1, 0x01FFC1B401FFC5B3, 0x01FFE9B601FFC1B5, 0x01FFDDB801FFE9B7, 0x01FFA1BA01FFA1B9, 0x01FFA1BC01FFA1BB, 0x01FF91BE01FFA9BD, 
0x01FFA9B301FF91BF, 0x00032886800082EB, 0x800082EF00031C87, 0x01FFD9B501FFC1B6, 0x01FF21BB800082F3, 0x800082F701FFC9BA, 0x01FF25BF800082FB, 0x01FF31BD01FF25BE, 
0x800082FF01FF39BC, 0x8000830301FFEDA3, 0x01FF85A680008307, 0x8000830F8000830B, 0x01FF8DAA01FF9DA5, 0x8000831301FF65AB, 0x01FF61AE80008317, 0x01FF7DAC01FF61AF, 
0x000185A801FF75AD, 0x000195AA000195A9, 0x0001BDAC0001A5AB, 0x0001D1AE0001D5AD, 0x8000831B0001D1AF, 0x800083238000831F, 0x8000832B80008327, 0x800083338000832F, 
0x000071B880008337, 0x000071BA000071B9, 0x0000D1BC000071BB, 0x0000D1BE0000D1BD, 0x0001B5B00000D1BF, 0x000181B20001BDB1, 0x000051B4000181B3, 0x000051B6000051B5, 
0x8000833B000051B7, 0x800083438000833F, 0x00000D8080008347, 0x00003D8200003581, 0x8000834F8000834B, 0x0002A48480008353, 0x00019086000120BE, 0x8000835B00011487, 
0x00015DB38000835F, 0x8000836380008357, 0x8000836B80008367, 0x000175B5000115B6, 0x000139BB8000836F, 0x80008373000131BA, 0x0000D5BF80008377, 0x000115BD0000D5BE, 
0x00029DA3000115BC, 0x8000837F8000837B, 0x80008383000400BE, 0x0002B5A50002D5A6, 0x0002F9AB80008387, 0x8000838B0002F1AA, 0x000315AF8000838F, 0x0002D5AD000315AE, 
0x0001E8E10002D5AC, 0x000214E380008393, 0x8000839700034084, 0x8000839F8000839B, 0x800083A7800083A3, 0x800083AF800083AB, 0x800083B7800083B3, 0x00028CEF800083BB, 
0x000339A8800083BF, 0x000341AA000339A9, 0x000341AC000341AB, 0x000371AE000349AD, 0x0000D580000371AF, 0x000005820000D981, 0x0005B485800083C3, 0x800083CF800083CB, 
0x000095B8800083D3, 0x000095BA00009DB9, 0x0000B5BC0000ADBB, 0x0000B5BE0000BDBD, 0x0000E5B00000ADBF, 0x0000F9B20000EDB1, 0x0000D9B40000F1B3, 0x0000BDB60000D9B5, 
0x01FD5DB60000ADB7, 0x01FD5DB401FD65B7, 0x01FD35B201FD55B5, 0x01FD01B001FD45B3, 0x01FD8DBE01FD3DB1, 0x01FD8DBC01FD95BF, 0x01FD5DBA01FD85BD, 0x01FD5DB801FD4DBB, 
0x0007E08601FD55B9, 0x800083D700051887, 0x800083DF800083DB, 0x800083E300071484, 0x01FD6DAE800083E7, 0x01FD69AC01FD71AF, 0x01FEA5AA01FD69AD, 0x01FED5A801FE89AB, 
0x000324E101FEBDA9, 0x001FDCE301FED4E1, 0x000028E301FE10E3, 0x000108E1800083EB, 0x0000F4EF800083EF, 0x0007F4BE800083F3, 0x800083FB800083F7, 0x001F7CEF800083FF, 
0x000209B301FEFCEF, 0x8000840780008403, 0x8000840F8000840B, 0x000209B5000209B6, 0x0001E9BB80008413, 0x800084170001E1BA, 0x0001DDBF8000841B, 0x0001E5BD0001DDBE, 
0x01F8259F0001EDBC, 0x01F9F19D01F8259E, 0x01FC319B01FCA19C, 0x01F1159901FDE19A, 0x01F0219701F01998, 0x01F4259501F54D96, 0x01E9619301F42D94, 0x01E83D9101E83D92, 
0x01EC618F01EEBD90, 0x8000841F800083C7, 0x8000842780008423, 0x00003D8100003D82, 0x8000842B00003D80, 0x800084338000842F, 0x0001D08680008437, 0x8000843B00030087, 
0x000549A38000843F, 0x8000844780008443, 0x8000844F8000844B, 0x000549A5000549A6, 0x0006A9AB80008453, 0x800084570006A1AA, 0x00069DAF8000845B, 0x0006A5AD00069DAE, 
0x8000845F0006ADAC, 0x8000846780008463, 0x8000846F8000846B, 0x8000847780008473, 0x8000847F8000847B, 0x8000848780008483, 0x000535A38000848B, 0x0004F9A10004E9A2, 
0x01ED218201F931A0, 0x8000848F01EF8583, 0x01E8418680008493, 0x01E91D8401F51587, 0x01F52D8A01E91585, 0x8000849701F44D8B, 0x01F03D8E8000849B, 0x01F1398C01FCC18F, 
0x01FD619201F1398D, 0x8000849F01FDE993, 0x01F97596800084A3, 0x01F8A19401F89997, 0x0005619A01F97D95, 0x00002C840005799B, 0x00003981000C00BE, 0x0004BD9C00005980, 
0x0001C5A100003182, 0x000D89A3800084AB, 0x000D01A50001E1A2, 0x0009B9A7000D91A4, 0x001401A9000801A6, 0x001599AB00090DA8, 0x0011B1AD00158DAA, 0x001C01AF001421AC, 
0x001DCDB1001115AE, 0x001801B3001DC5B0, 0x001939B5001C55B2, 0x000F58860019F5B4, 0x800084AF0000FC87, 0x800084B7800084B3, 0x800084BF800084BB, 0x800084C7800084C3, 
0x0004B5A8800084CB, 0x0004B5AA0004BDA9, 0x00055DAC000545AB, 0x000541AE000545AD, 0x800084CF000541AF, 0x800084D7800084D3, 0x800084DF800084DB, 0x800084E7800084E3, 
0x00058DB8800084EB, 0x000595BA000595B9, 0x0005BDBC0005A5BB, 0x000215BE00021DBD, 0x0005F5B000020DBF, 0x0005CDB20005F9B1, 0x0005C1B40005C1B3, 0x0005BDB60005C1B5, 
0x800084EF0005B5B7, 0x800084F7800084F3, 0x800084FB000431B3, 0x0005C9B60005D9B5, 0x80008503800084FF, 0x00053DBA80008507, 0x000515BC000531BB, 0x000509BE000519BD, 
0x8000850B000509BF, 0x000585A5000595A6, 0x00046DA38000850F, 0x000C90BE80008513, 0x000555AF8000851B, 0x000545AD000555AE, 0x00056DAB000549AC, 0x8000851F000561AA, 
0x000379A880008523, 0x00038DAA000379A9, 0x00039DAC000385AB, 0x000385AE000385AD, 0x0001E1800003B5AF, 0x0001FD820001E981, 0x80008527000D6084, 0x000D24878000852B, 
0x00039DB8000C9C86, 0x0003ADBA0003A5B9, 0x0003BDBC0003A5BB, 0x000255BE00025DBD, 0x0003CDB0000275BF, 0x0003ADB20003A5B1, 0x0003BDB40003A5B3, 0x0003ADB60003A5B5, 
0x8000852F0003A5B7, 0x00030DB380008533, 0x00031DB580008537, 0x8000853B000CDCBE, 0x8000853F00030DB6, 0x000369BB80008543, 0x000379BD000301BA, 0x000369BF000371BC, 
0x000698E1000371BE, 0x00068CE380008547, 0x000044EF8000854B, 0x800085538000854F, 0x000098E380008557, 0x000180E18000855B, 0x800085638000855F, 0x0006A8EF80008567, 
0x800084A78000856B, 0x8000856F80008517, 0x8000857780008573, 0x0000918100009982, 0x000DA5A800009980, 0x000DCDAA000DC5A9, 0x000DDDAC000DC5AB, 0x000DCDAE000DC5AD, 
0x000DBDB0000DC5AF, 0x000E6DB2000E65B1, 0x000E7DB4000E65B3, 0x000E6DB6000E65B5, 0x000E5DB8000E65B7, 0x000EEDBA000EE5B9, 0x000EE1BC000EE5BB, 0x000ED9BE000EE9BD, 
0x000D65B3000ED9BF, 0x8000857F8000857B, 0x8000858780008583, 0x000D75B5000D65B6, 0x000E81BB0003D084, 0x00000886000D59BA, 0x000E81BF00008C87, 0x000E91BD000E99BE, 
0x8000858B000E99BC, 0x8000858F000D21A3, 0x000D21A680008593, 0x8000859B80008597, 0x000D1DAA000D31A5, 0x8000859F000EC5AB, 0x000EDDAE800085A3, 0x000EDDAC000EC5AF, 
0x000FDDA8000ED5AD, 0x000FF5AA000FFDA9, 0x000E25AC000E3DAB, 0x000E9DAE000E95AD, 0x800085A7000E91AF, 0x800085AF800085AB, 0x800085B7800085B3, 0x800085BF800085BB, 
0x000EA5B8800085C3, 0x000EB9BA000EA9B9, 0x000EADBC000EB9BB, 0x000155BE00015DBD, 0x000EF9B000014DBF, 0x000ECDB2000EC5B1, 0x000EBDB4000EA9B3, 0x000EA1B6000EA1B5, 
0x000F7DB3000EA1B7, 0x800085CB800085C7, 0x800085D3800085CF, 0x000EADB5000E15B6, 0x000E01BB800085D7, 0x800085DB000E3DBA, 0x000E65BF800085DF, 0x000E7DBD000E79BE, 
0x800085E3000E19BC, 0x800085E7000F39A3, 0x000E51A6800085EB, 0x800085F3800085EF, 0x000E79AA000EE9A5, 0x0001A484000E45AB, 0x000E3DAE0001A4BE, 0x000E5DAC000E21AF, 
0x0002C1A8000E39AD, 0x0002C5AA0002CDA9, 0x0002C9AC0002D9AB, 0x0002F5AE0002FDAD, 0x0003ED8000033DAF, 0x0003F1820003F181, 0x00049086800085FB, 0x800085FF00037487, 
0x0003C9B880008603, 0x0003D9BA0003C9B9, 0x0003F9BC0003D1BB, 0x000399BE0003F9BD, 0x000345B0000395BF, 0x000345B200034DB1, 0x000345B400035DB3, 0x000345B600034DB5, 
0x00024DB30003F9B7, 0x8000860B80008607, 0x8000860F00030C84, 0x000241B500027DB6, 0x000389BB80008613, 0x80008617000381BA, 0x000389BF8000861B, 0x000389BD000381BE, 
0x8000861F000391BC, 0x80008623000209A3, 0x000239A680008627, 0x8000862F8000862B, 0x0003C5AA000205A5, 0x800086330003CDAB, 0x0003C5AE80008637, 0x0003D5AC0003CDAF, 
0x8000863B0003CDAD, 0x800086438000863F, 0x8000864B80008647, 0x8000864F0001A4E1, 0x800086530000E4E3, 0x8000865B80008657, 0x8000865F000038EF, 0x8000866B80008663, 
0x00006980000530BE, 0x00007D8200007581, 0x8000866F000171B3, 0x0001C9B60001DDB5, 0x0004C08680008673, 0x0001C5BA0005E887, 0x0001B9BC0001ADBB, 0x0001ADBE0001B9BD, 
0x000EA4E10001A5BF, 0x000104E3000C44E1, 0x80008677000EB0E3, 0x8000867F8000867B, 0x0005A88480008683, 0x8000868B80008687, 0x800086938000868F, 0x000ED4EF80008697, 
0x000F01AB000F9CEF, 0x8000869B000F69AA, 0x000F01AF8000869F, 0x000F11AD000F19AE, 0x000F65A3000F19AC, 0x800086A7800086A3, 0x800086AF800086AB, 0x000F75A5000F65A6, 
0x00062DA8800086B3, 0x000635AA00063DA9, 0x000699AC000689AB, 0x000685AE000685AD, 0x800086670006B5AF, 0x800086BB800086B7, 0x800086C3800086BF, 0x800086CB800086C7, 
0x000741B8800086CF, 0x000741BA000741B9, 0x000741BC000741BB, 0x000779BE00074DBD, 0x0006CDB0000779BF, 0x0006A1B20006A5B1, 0x0006A5B40006A1B3, 0x000691B60006ADB5, 
0x0006BDA3000691B7, 0x0000B58100001582, 0x800086D30000B580, 0x000611A5000605A6, 0x000661AB000390BE, 0x800086D7000609AA, 0x000669AF800086DB, 0x000675AD000661AE, 
0x800086DF000675AC, 0x0000C886000799B3, 0x000749B600031C87, 0x800086E7800086E3, 0x000749BA000749B5, 0x800086EB000749BB, 0x000739BE800086EF, 0x000749BC000739BF, 
0x000639A8000749BD, 0x000655AA000655A9, 0x000685AC00069DAB, 0x000685AE00068DAD, 0x800086F30006B9AF, 0x800086FB800086F7, 0x80008703800086FF, 0x8000870B80008707, 
0x0006ADB88000870F, 0x0006B5BA0006B5B9, 0x000179BC000169BB, 0x000169BE000179BD, 0x0006C9B0000169BF, 0x0006D9B20006C9B1, 0x0006B9B40006D9B3, 0x00069DB60006B9B5, 
0x0006DDA3000695B7, 0x8000871780008713, 0x8000871F8000871B, 0x00060DA500060DA6, 0x00060DAB800085F7, 0x8000872300060DAA, 0x00067DAF80008727, 0x00060DAD00067DAE, 
0x8000872B00060DAC, 0x800087338000872F, 0x00000D8080008737, 0x00003D8200003581, 0x8000873F8000873B, 0x0001648480008743, 0x001F5086000034BE, 0x8000874B00016887, 
0x800087538000874F, 0x0003048480008757, 0x00068CE3001C00BE, 0x000630E18000875B, 0x0007E4EF8000875F, 0x8000876780008763, 0x8000876F8000876B, 0x8000877780008773, 
0x000295B38000877B, 0x800087838000877F, 0x8000878B80008787, 0x0002B1B50002B9B6, 0x00034DBB8000878F, 0x8000879300034DBA, 0x00034DBF80008797, 0x00034DBD00034DBE, 
0x8000879B00034DBC, 0x800087A38000879F, 0x800087A7001D88BE, 0x00019D8100019D82, 0x00020DA800019D80, 0x00027DAA000265A9, 0x000259AC000275AB, 0x000399AE000259AD, 
0x0003E9B0000399AF, 0x0003F9B20003E9B1, 0x0003E9B40003F9B3, 0x00035DB60003E9B5, 0x00036DB8000355B7, 0x000341BA000375B9, 0x000331BC000341BB, 0x000331BE000331BD, 
0x800087AB000331BF, 0x800087B3800087AF, 0x800087BB001D0484, 0x001CB886000000EF, 0x800087BF001D3087, 0x800087C30000DCE3, 0x800087C70001FCE1, 0x800087CF800087CB, 
0x0003ADA6800087D3, 0x800087DB800087D7, 0x800087DF0003A5A5, 0x800087E3000381A3, 0x000259AE800087E7, 0x000259AC000259AF, 0x000259AA000259AD, 0x800087EB000259AB, 
0x800087F3800087EF, 0x800087FB800087F7, 0x80008803800087FF, 0x8000880B80008807, 0x001CAC840001F8EF, 0x8000880F0006DCE1, 0x8000881300061CE3, 0x8000881B80008817, 
0x0001C1B38000881F, 0x001FEC8680008823, 0x000000F5001CF087, 0x0001CDB50001C9B6, 0x0001D1BB8000882B, 0x001F2CBE0001C9BA, 0x0001B5BF8000882F, 0x0001C1BD0001C9BE, 
0x001DF9A80001C9BC, 0x001E09AA001DF9A9, 0x001E05AC001E09AB, 0x001E3DAE001E09AD, 0x800087B7001E35AF, 0x001F9581001FE182, 0x80008827001F9580, 0x8000883780008833, 
0x001E11B88000883B, 0x001E21BA001E19B9, 0x001ED1BC001E21BB, 0x001ED1BE001ED1BD, 0x001E4DB0001ECDBF, 0x001E5DB2001E55B1, 0x001E4DB4001E55B3, 0x001E31B6001E31B5, 
0x001E81A3001E31B7, 0x800088438000883F, 0x8000884B80008847, 0x001E8DA5001E89A6, 0x001E91AB8000884F, 0x80008853001E89AA, 0x001EF5AF80008857, 0x001E81AD001E89AE, 
0x8000885B001E89AC, 0x8000885F001FEDB3, 0x001FE9B680008863, 0x8000886B80008867, 0x001FA9BA001FE9B5, 0x8000886F001FB5BB, 0x001F89BE80008873, 0x001FA1BC001F89BF, 
0x001E11A8001FA1BD, 0x001E21AA001E25A9, 0x001E25AC001E3DAB, 0x001E25AE001E2DAD, 0x80008877001E59AF, 0x8000887F8000887B, 0x8000888780008883, 0x0000BD810000B982, 
0x001EC9B80000BD80, 0x001ED9BA001EC9B9, 0x001EC9BC001ED9BB, 0x001EE9BE001EFDBD, 0x001E29B0001EE9BF, 0x001E31B2001E35B1, 0x001E09B4001E31B3, 0x001EF9B6001E09B5, 
0x8000888B001EF9B7, 0x001EA1A38000888F, 0x001EA5A580008893, 0x8000889B80008897, 0x80008747001EA5A6, 0x001EF9AB0000A884, 0x001EEDAD001EE5AA, 0x001EC5AF001EEDAC, 
0x0001F5B3001EC5AE, 0x00006C868000889F, 0x800088A300017C87, 0x0001E5B5000151B6, 0x00017DBB800088A7, 0x800088AB000175BA, 0x000139BF800088AF, 0x000155BD000135BE, 
0x800088B3000155BC, 0x000400BE800088B7, 0x0001C0E100040084, 0x0001ACE3800088BB, 0x800088BF001EE8EF, 0x0002D8EF001DCCE1, 0x800088C3001E34E3, 0x800088CB800088C7, 
0x800088D3800088CF, 0x00027DA3800088D7, 0x00026DA5800088DB, 0x800088E3800088DF, 0x800088E70002D9A6, 0x0002F5AB800088EB, 0x0002DDAD0002FDAA, 0x0002B1AF0002DDAC, 
0x001D6DA90002BDAE, 0x0002B1AB001D59A8, 0x000215AD0002B9AA, 0x000215AF0002A9AC, 0x00052CBE000215AE, 0x800088F3800088EF, 0x00000D80800088F7, 0x00019D8200019581, 
0x000229B9800088FB, 0x0003E9BB00021DB8, 0x0003F9BD000221BA, 0x0003E9BF0003F1BC, 0x00027DB10003F1BE, 0x000245B3000275B0, 0x000239B5000245B2, 0x00022DB7000235B4, 
0x0002C5A9000231B6, 0x0002D5AB00029DA8, 0x0002FDAD0002DDAA, 0x00011DAF0002FDAC, 0x800088FF00011DAE, 0x0005A08780008903, 0x8000890B0005AC86, 0x800089138000890F, 
0x000115B9000000CF, 0x000129BB000109B8, 0x0001F5BD000115BA, 0x0001F5BF000131BC, 0x000141B10001F5BE, 0x00015DB3000171B0, 0x00014DB500015DB2, 0x00013DB700014DB4, 
0x8000891700013DB6, 0x8000891F8000891B, 0x80008923001E9CEF, 0x8000892B80008927, 0x00076C84001FE8EF, 0x8000892F001EA4E1, 0x80008933001EB0E3, 0x80008937001E64E1, 
0x000211B3001E0CE3, 0x8000893F8000893B, 0x00065C8480008943, 0x000231B5000239B6, 0x0001C1BB80008947, 0x8000894B0001F1BA, 0x0001CDBF8000894F, 0x0001CDBD0001CDBE, 
0x800089070001CDBC, 0x8000895780008953, 0x8000895F8000895B, 0x8000896780008963, 0x000711A88000896B, 0x000711AA000711A9, 0x0007B5AC0007ADAB, 0x0007A9AE0007BDAD, 
0x0007D9B00007A9AF, 0x0007F9B20007EDB1, 0x000795B40007F5B3, 0x000795B600079DB5, 0x000789B8000781B7, 0x00006DBA000789B9, 0x00007DBC000065BB, 0x00006DBE000065BD, 
0x00001982000065BF, 0x00009580000555A3, 0x00057DA600001981, 0x800089738000896F, 0x0006B5AA000575A5, 0x80008977000685AB, 0x000689AE8000897B, 0x000689AC000689AF, 
0x0007F9B3000689AD, 0x0003E8868000897F, 0x800089830003BC87, 0x00075DB500075DB6, 0x000749BB80008987, 0x8000898B00077DBA, 0x000739BF8000898F, 0x000741BD000731BE, 
0x000639A300074DBC, 0x8000899780008993, 0x8000899F8000899B, 0x00069DA500069DA6, 0x000689AB800089A3, 0x800089A70006BDAA, 0x0006F9AF800089AB, 0x000681AD0006F1AE, 
0x800089AF00068DAC, 0x800089B7800089B3, 0x800089BF800089BB, 0x800089C7800089C3, 0x800089CF800089CB, 0x800089D7800089D3, 0x00001D80800089DB, 0x0000D98200000981, 
0x00012DA8800089DF, 0x000159AA000141A9, 0x000179AC000151AB, 0x00009DAE000179AD, 0x800089E3000095AF, 0x0001888600016CBE, 0x800089EB0000AC87, 0x800089F3800089EF, 
0x00008DB8800089F7, 0x00009DBA000095B9, 0x00008DBC000095BB, 0x0000BDBE0000B5BD, 0x0000EDB00000B5BF, 0x0000F5B20000F5B1, 0x0000DDB40000C5B3, 0x0000BDB60000B5B5, 
0x0002D1B30000B5B7, 0x000370BE800089FB, 0x800089FF000C44BE, 0x0002F1B50002F9B6, 0x000331BB80008A03, 0x80008A07000329BA, 0x000371BF80008A0B, 0x000311BD000319BE, 
0x80008A0F000321BC, 0x80008A13000295A3, 0x0002BDA680008A17, 0x80008A1F80008A1B, 0x00036DAA0002B5A5, 0x80008A23000375AB, 0x00035DAE80008A27, 0x000365AC000335AF, 
0x000331A8000355AD, 0x000331AA000331A9, 0x000095AC000331AB, 0x000085AE000085AD, 0x80008A2B0000B5AF, 0x80008A3380008A2F, 0x80008A3B80008A37, 0x80008A4380008A3F, 
0x000061B880008A47, 0x000061BA000061B9, 0x000061BC000061BB, 0x000061BE000061BD, 0x0000CDB0000061BF, 0x0000A1B20000A5B1, 0x0000A5B40000A1B3, 0x000091B60000ADB5, 
0x00000D80000091B7, 0x0000118200001581, 0x80008A4F80008A4B, 0x80008A53000048EF, 0x000D6C8480008A5B, 0x80008A5F000694E3, 0x80008A630001FCE1, 0x000DB88680008A67, 
0x0002F9B30002C487, 0x80008A6F80008A6B, 0x80008A7780008A73, 0x00015DB5000145B6, 0x000121BB000F98BE, 0x80008A7B000149BA, 0x000129BF80008A7F, 0x000135BD000121BE, 
0x80008A83000135BC, 0x80008A870006B0E1, 0x80008A8B000790E3, 0x80008A9380008A8F, 0x80008A9B80008A97, 0x80008AA380008A9F, 0x000000E580008AA7, 0x80008AAF80008AAB, 
0x000195AE0007E4EF, 0x000181AC00019DAF, 0x0001FDAA000181AD, 0x80008AB3000195AB, 0x0001F1A680008AB7, 0x80008ABF80008ABB, 0x000FF5820001E9A5, 0x00001D8000024DA3, 
0x80008A5700001581, 0x80008ACB80008AC3, 0x0003B08680008AC7, 0x80008ACF00039487, 0x000F3DA880008AD3, 0x000F19AA000F0DA9, 0x000F75AC000F19AB, 0x000F75AE000F7DAD, 
0x000F29B0000F6DAF, 0x000FC9B2000F29B1, 0x000FC1B4000FC5B3, 0x000FC1B6000FC1B5, 0x000FC1B8000FC1B7, 0x000FC1BA000FC1B9, 0x000FC5BC000FC1BB, 0x000FA1BE000FCDBD, 
0x000FB1B3000FA1BF, 0x80008ADB80008AD7, 0x80008AE380008ADF, 0x000FDDB5000FDDB6, 0x000FCDBB80008AE7, 0x80008AEB000FCDBA, 0x000F25BF80008AEF, 0x000F31BD000F25BE, 
0x80008AF3000F3DBC, 0x80008AF7000FF5A3, 0x000F99A680008AFB, 0x80008B0380008AFF, 0x000F89AA000F99A5, 0x80008B07000F89AB, 0x000F61AE80008B0B, 0x000F79AC000F61AF, 
0x000109A8000F75AD, 0x000115AA00011DA9, 0x000199AC000189AB, 0x000189AE000199AD, 0x80008B0F000181AF, 0x80008B1780008B13, 0x80008B1F80008B1B, 0x80008B2780008B23, 
0x0001ADB880008B2B, 0x00006DBA000065B9, 0x00007DBC000065BB, 0x00006DBE000065BD, 0x0001C9B0000065BF, 0x0001A9B20001C9B1, 0x0001BDB40001A5B3, 0x0001A1B60001A1B5, 
0x0000BD80000195B7, 0x0000198200000981, 0x80008B3380008B2F, 0x80008B3700029884, 0x0001808680008B3B, 0x80008B3F00010487, 0x80008B4780008B43, 0x800089E780008B4B, 
0x0001DDB380008B4F, 0x80008B5780008B53, 0x80008B5F80008B5B, 0x000151B5000159B6, 0x00014DBB80008B63, 0x80008B6700014DBA, 0x000125BF80008B6B, 0x000131BD000139BE, 
0x80008B6F00013DBC, 0x0003D0BE000EF4EF, 0x80008B7780008B73, 0x80008B7B000248E3, 0x80008B7F0001A4E1, 0x80008B830002D4EF, 0x80008B8B80008B87, 0x80008B8F000BF4E3, 
0x80008B93000D8CE1, 0x000255A380008B97, 0x0002D9A500038C84, 0x80008B9F80008B9B, 0x80008BA30002D1A6, 0x0002C5AB80008BAB, 0x0002B9AD0002C5AA, 0x0002ADAF0002B5AC, 
0x00031DA80002B1AE, 0x000325AA00032DA9, 0x000325AC00033DAB, 0x00035DAE000329AD, 0x0000F580000355AF, 0x0000C9820000FD81, 0x80008BB380008BAF, 0x00036C8780008BB7, 
0x0000D9B800041C86, 0x0000E1BA0000E5B9, 0x0000E1BC0000E1BB, 0x000099BE0000EDBD, 0x00032DB0000099BF, 0x000335B2000335B1, 0x00031DB4000305B3, 0x0000F5B60000F5B5, 
0x80008BBB0000EDB7, 0x80008BC380008BBF, 0x80008BC70002A1B3, 0x0002A5B60002A1B5, 0x80008BCF80008BCB, 0x0002E5BA80008BD3, 0x0002EDBC0002FDBB, 0x0002D5BE0002DDBD, 
0x0002FDA600013DBF, 0x80008BDB80008BD7, 0x80008BDF0002F9A5, 0x80008BE30002F9A3, 0x00028DAE80008BE7, 0x0002B5AC000165AF, 0x0002BDAA000285AD, 0x80008BEB0002A5AB, 
0x000004E380008BEF, 0x000180E1000EA4E1, 0x80008BF3000EBCE3, 0x80008BFB80008BF7, 0x0005E8BE80008BFF, 0x80008C0780008C03, 0x000E14EF80008C0B, 0x0004F0BE80008C0F, 
0x80008C13000F48EF, 0x80008C1F80008C1B, 0x0000658180008C23, 0x80008C2700007980, 0x0005AC8400001D82, 0x0004C88780008C2B, 0x80008C2F00044C86, 0x80008C3780008C33, 
0x000665A880008C3B, 0x0006B9AA0006A9A9, 0x000711AC0006B9AB, 0x000711AE000711AD, 0x80008C1700070DAF, 0x80008C4380008C3F, 0x80008C4B80008C47, 0x80008C5380008C4F, 
0x000739B880008C57, 0x0007D9BA000739B9, 0x0007C9BC0007D9BB, 0x0007FDBE0007C9BD, 0x00077DB00007F5BF, 0x00074DB2000745B1, 0x000739B4000729B3, 0x000721B6000725B5, 
0x000631B3000721B7, 0x80008C5F80008C5B, 0x80008C6780008C63, 0x000799B5000791B6, 0x000781BB80008C6B, 0x80008C6F0007B9BA, 0x0007E1BF80008C73, 0x0007FDBD0007FDBE, 
0x80008C77000799BC, 0x80008C7B000675A3, 0x0007D5A680008C7F, 0x0003948480008C83, 0x0007FDAA0007DDA5, 0x80008C870007C5AB, 0x0007B9AE80008C8B, 0x0007DDAC0007A5AF, 
0x0006C5A80007B9AD, 0x0006C5AA0006CDA9, 0x0006F5AC0006D5AB, 0x0006EDAE0006E5AD, 0x0001E9800006E5AF, 0x0001FD820001E981, 0x0001308680008C8F, 0x80008C9300016487, 
0x0001C5B880008C97, 0x0001C5BA0001CDB9, 0x0001CDBC0001DDBB, 0x0001F5BE0001FDBD, 0x00069DB000019DBF, 0x000141B2000141B1, 0x000141B4000141B3, 0x000141B6000141B5, 
0x00064DB3000141B7, 0x80008C9F80008C9B, 0x80008CA780008CA3, 0x00067DB5000665B6, 0x000185BB80008CAB, 0x80008CAF000659BA, 0x000185BF80008CB3, 0x000195BD000185BE, 
0x80008CB7000195BC, 0x80008BA7000609A3, 0x000621A680008CBB, 0x80008CC380008CBF, 0x00061DAA000639A5, 0x80008CC70001C1AB, 0x0001C1AE80008CCB, 0x0001D1AC0001C1AF, 
0x80008CCF0001D1AD, 0x80008CD780008CD3, 0x80008CDF80008CDB, 0x80008CE780008CE3, 0x80008CEF80008CEB, 0x000364BE80008CF3, 0x80008CFF80008CFB, 0x003D30BF80008D03, 
0x003C008580008D07, 0x00038C840007B4E3, 0x00004D800006E8E1, 0x00007D8200007581, 0x003C4485002A8CEF, 0x80008D0B000210E1, 0x80008D0F002EA8E3, 0x003D588600072CEF, 
0x80008D1300030C87, 0x80008D1B80008D17, 0x80008D2380008D1F, 0x80008D2B80008D27, 0x00024DA880008D2F, 0x000391AA000389A9, 0x000335AC000391AB, 0x000335AE00033DAD, 
0x00035DB000032DAF, 0x000365B200036DB1, 0x00031DB400030DB3, 0x000301B6000301B5, 0x00030DB8000335B7, 0x0000EDBA0000E5B9, 0x0000FDBC0000E5BB, 0x0000EDBE0000E5BD, 
0x80008D330000E5BF, 0x000231B380008D37, 0x000295B580008D3B, 0x80008D4380008D3F, 0x003DBC84000295B6, 0x000281BB80008D47, 0x0002F1BD0002B1BA, 0x0002EDBF000299BC, 
0x80008D4B0002F1BE, 0x003FC4BE80008D4F, 0x80008D53003FC484, 0x80008D57000384EF, 0x80008D5F80008D5B, 0x80008D6300033CE3, 0x00002D80000044E1, 0x0000118200001581, 
0x003FA08680008D6B, 0x80008D6F003D5887, 0x80008D7780008D73, 0x80008D7F80008D7B, 0x003E2CBE0006DCEF, 0x80008D83000650E1, 0x80008D87000164E3, 0x80008D8F80008D8B, 
0x0002F9A380008D93, 0x80008D9B80008D97, 0x80008DA380008D9F, 0x00025DA500025DA6, 0x000249AB80008DA7, 0x80008DAB000279AA, 0x000225AF80008DAF, 0x000239AD000239AE, 
0x00246D90000251AC, 0x00280D9200280591, 0x002D8D9400289D93, 0x002CB196002C3595, 0x003001980031BD97, 0x0031BD9A00301599, 0x0034999C00342D9B, 0x0038399E00398D9D, 
0x80008CF70038319F, 0x003E21B5003E35B6, 0x003E65B380008D67, 0x80008DB780008DB3, 0x003EFDBF80008DBB, 0x003EFDBD003EFDBE, 0x003EFDBB003EFDBC, 0x80008DBF003EFDBA, 
0x000945A90024398F, 0x000CA9AB00089DA8, 0x001001AD000C01AA, 0x001035AF000D1DAC, 0x0000E1A10010BDAE, 0x000401A380008DC3, 0x000495A50000E1A2, 0x0008B9A7000495A4, 
0x003959A0000801A6, 0x003CE9A2003D0DA1, 0x80008DC7003C25A3, 0x000025810001DD82, 0x0014C1B100002580, 0x001801B3001401B0, 0x0018D5B50014D5B2, 0x80008DCB0018D5B4, 
0x0025458280008DCF, 0x80008DD300256983, 0x0029818680008DDB, 0x00291984002C8987, 0x002D018A00291985, 0x00078886002D8D8B, 0x0031018E00018C87, 0x0030998C0030A18F, 
0x0035419200311D8D, 0x80008DDF0035ED93, 0x00395D9680008DE3, 0x0038E1940038CD97, 0x003CA99A00395D95, 0x80008DE7003D459B, 0x80008DEF80008DEB, 0x003D919C80008DF3, 
0x003FADA880008DF7, 0x003FBDAA003FB5A9, 0x003FF9AC003FB1AB, 0x003F19AE003FE5AD, 0x80008DFB003F19AF, 0x80008E0380008DFF, 0x80008E0B80008E07, 0x80008E1380008E0F, 
0x003ECDB880008E17, 0x003ED1BA003ED1B9, 0x003E91BC003EE9BB, 0x003E89BE003E91BD, 0x003F69B0003E85BF, 0x003F79B2003F69B1, 0x003F69B4003F79B3, 0x003EF9B6003F69B5, 
0x003C35A3003EF9B7, 0x80008E1F80008E1B, 0x80008E2780008E23, 0x003C71A5003C65A6, 0x003CADAB80008E2B, 0x80008E2F003CADAA, 0x003CADAF80008E33, 0x003CADAD003CADAE, 
0x0003C884003CADAC, 0x80008E37003DC9B3, 0x003DC9B680008E3B, 0x80008E4380008E3F, 0x003DD5BA003DC9B5, 0x00036CBE003DDDBB, 0x003DB9BE80008E4B, 0x003DC5BC003DB9BF, 
0x003DFDA8003DB9BD, 0x003D05AA003D0DA9, 0x003D05AC003D1DAB, 0x003D31AE003D0DAD, 0x0000ED80003D2DAF, 0x0000F1820000F181, 0x0004908680008E4F, 0x80008E5300036487, 
0x003D29B880008E57, 0x00029DBA003D29B9, 0x00028DBC000295BB, 0x00027DBE0002ADBD, 0x003D55B000020DBF, 0x003D55B2003D5DB1, 0x003D39B4003D29B3, 0x003D29B6003D39B5, 
0x003C8DA3003D21B7, 0x0004C48480008E5B, 0x80008E6380008E5F, 0x003C8DA5003C8DA6, 0x003C99AB80008E67, 0x80008E6B003C91AA, 0x003CFDAF80008E6F, 0x003CFDAD003CFDAE, 
0x80008E73003C81AC, 0x80008E77000209B3, 0x000221B680008E7B, 0x80008E8380008E7F, 0x0002C1BA000231B5, 0x80008E870002C1BB, 0x0002C1BE80008E8B, 0x0002D1BC0002C1BF, 
0x80008E8F0002D1BD, 0x0002C5A380008E93, 0x0002FDA580008E97, 0x80008E9F80008E9B, 0x80008EA30002EDA6, 0x00020DAB80008EA7, 0x00021DAD00020DAA, 0x00020DAF00021DAC, 
0x003E9CE300020DAE, 0x003E50E1003FA4E1, 0x00000D80003EFCE3, 0x00003D8200003581, 0x80008EAF80008EAB, 0x000420BE80008EB3, 0x003EA8EF80008EBB, 0x80008EC380008EBF, 
0x00050DA8003E4CEF, 0x000545AA00054DA9, 0x00057DAC000565AB, 0x00056DAE000565AD, 0x80008E47000561AF, 0x0003088680008EB7, 0x80008EC700038C87, 0x80008ECF80008ECB, 
0x000645B880008ED3, 0x000645BA00064DB9, 0x00064DBC00065DBB, 0x000675BE00067DBD, 0x0005C1B0000615BF, 0x0005C1B20005C1B1, 0x0005C1B40005C1B3, 0x0005C1B60005C1B5, 
0x0006EDA80005C1B7, 0x000631AA000629A9, 0x000795AC000631AB, 0x000789AE000799AD, 0x80008ED7000781AF, 0x80008DD780008EDB, 0x80008EE380008EDF, 0x80008EEB80008EE7, 
0x0007ADB880008EEF, 0x00074DBA000745B9, 0x000745BC000741BB, 0x000779BE00074DBD, 0x0007C9B0000779BF, 0x0007A9B20007C9B1, 0x0007BDB40007A5B3, 0x0007A1B60007A1B5, 
0x0007B9B3000795B7, 0x80008EF780008EF3, 0x80008EFF80008EFB, 0x00061DB5000619B6, 0x00060DBB80008F03, 0x80008F0700060DBA, 0x000665BF80008F0B, 0x000671BD000679BE, 
0x80008F0F00067DBC, 0x80008F130007FDA3, 0x00065DA680008F17, 0x80008F1F80008F1B, 0x000649AA000659A5, 0x80008F23000649AB, 0x00063DAE0001A084, 0x000639AC000621AF, 
0x00066DA8000635AD, 0x000671AA000671A9, 0x0001A5AC0001BDAB, 0x0001A5AE0001ADAD, 0x0000F58000013DAF, 0x0000C1820000FD81, 0x00019886000164BE, 0x80008F2B0000AC87, 
0x0000CDB880008F2F, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 0x000091BE000095BD, 0x000145B0000091BF, 0x000159B2000149B1, 0x000149B4000159B3, 0x0000FDB6000149B5, 
0x0005F9B30000F5B7, 0x80008F3780008F33, 0x80008F3F80008F3B, 0x00022DB500022DB6, 0x00028DBB80008F43, 0x80008F47000281BA, 0x00028DBF80008F4B, 0x00028DBD00028DBE, 
0x80008F4F00028DBC, 0x80008F530005BDA3, 0x000269A680008F57, 0x80008F5F80008F5B, 0x0002C5AA000269A5, 0x80008F630002C9AB, 0x0002C9AE80008F67, 0x0002C9AC0002C9AF, 
0x000085AA0002C9AD, 0x000331A800008DAB, 0x00008DAE000331A9, 0x000095AC0000BDAF, 0x0003E4BE00008DAD, 0x80008F6F80008F6B, 0x80008F7780008F73, 0x80008F7F80008F7B, 
0x00006DBA80008F83, 0x00006DB8000075BB, 0x00006DBE000065B9, 0x00006DBC0001D5BF, 0x0000A9B2000065BD, 0x0000C5B00000A9B3, 0x000099B60000ADB1, 0x0000ADB4000099B7, 
0x80008F870000A5B5, 0x80008F8F80008F8B, 0x00001D8280008F93, 0x00001D80000784EF, 0x0002AC8400001581, 0x80008F9B000774E3, 0x80008F9F00041CE1, 0x000DB88680008FA3, 
0x000145B3000D3087, 0x80008FAB80008FA7, 0x80008FB380008FAF, 0x000155B5000145B6, 0x000121BB80008FB7, 0x80008FBB000149BA, 0x000129BF80008FBF, 0x000135BD000121BE, 
0x80008FC3000135BC, 0x80008FCB80008FC7, 0x80008FD380008FCF, 0x0000CCEF80008FD7, 0x000190E100068CEF, 0x0000D4E300070CE1, 0x80008FDB0006B4E3, 0x80008FE380008FDF, 
0x80008FEB80008FE7, 0x0001CDA380008FEF, 0x0001DDA5000D9084, 0x80008FF780008FF3, 0x80008FFB0001CDA6, 0x0001A9AB80008FFF, 0x0001BDAD0001C1AA, 0x0001A1AF0001BDAC, 
0x80008F970001A9AE, 0x000FED8100001582, 0x80009003000FED80, 0x80009007000258BE, 0x000F09A88000900B, 0x000F1DAA000F15A9, 0x000F79AC000F69AB, 0x000F69AE000F79AD, 
0x000F29B0000F61AF, 0x000FC9B2000F29B1, 0x000FD9B4000FC9B3, 0x000FC9B6000FD9B5, 0x000FD1B8000FC9B7, 0x000FD1BA000FD1B9, 0x000FB1BC000FD1BB, 0x000FADBE000FB1BD, 
0x8000900F000FA5BF, 0x000FC1B5000FC9B6, 0x000FA5B380009013, 0x0003088780009017, 0x000F2DBF00033C86, 0x000F2DBD000F2DBE, 0x000FDDBB000F2DBC, 0x8000901B000FDDBA, 
0x000FF5A380008F27, 0x800090238000901F, 0x8000902B80009027, 0x000F91A5000F99A6, 0x000F8DAB8000902F, 0x80009033000F8DAA, 0x000F7DAF80009037, 0x000F7DAD000F7DAE, 
0x00011DA8000F7DAC, 0x000185AA000185A9, 0x0001A9AC000199AB, 0x0001D1AE0001D1AD, 0x8000903B0001D1AF, 0x800090438000903F, 0x8000904B80009047, 0x800090538000904F, 
0x000071B880009057, 0x000071BA000071B9, 0x0000D1BC000071BB, 0x0000D1BE0000D1BD, 0x0001B1B00000D1BF, 0x000181B20001B9B1, 0x000051B4000181B3, 0x000051B6000051B5, 
0x8000905B000051B7, 0x800090638000905F, 0x00000D8080009067, 0x00003D8200003581, 0x8000906F8000906B, 0x0002A48480009073, 0x00019086000124BE, 0x8000907B00011487, 
0x00014DB38000907F, 0x8000908380009077, 0x8000908B80009087, 0x000161B5000111B6, 0x00013DBB8000908F, 0x80009093000135BA, 0x0000D5BF80009097, 0x000115BD0000D5BE, 
0x8000909B000115BC, 0x8000909F000289A3, 0x0002D5A6000340BE, 0x800090A7800090A3, 0x0002F1AA0002A5A5, 0x800090AB0002F9AB, 0x000311AE800090AF, 0x0002D1AC000311AF, 
0x0001E8E10002D1AD, 0x000214E3800090B3, 0x800090B70003D484, 0x800090BF800090BB, 0x800090C300041084, 0x800090CB800090C7, 0x800090D3800090CF, 0x00028CEF800090D7, 
0x000339A8800090DB, 0x000341AA000339A9, 0x000341AC000341AB, 0x000371AE000349AD, 0x0000DD80000371AF, 0x0000198200000981, 0x800090E3800090DF, 0x00030887800090EB, 
0x000095B800041C86, 0x0000A9BA00009DB9, 0x0000B9BC0000A9BB, 0x0000A9BE0000B9BD, 0x0000E1B00000A9BF, 0x0000FDB20000EDB1, 0x0000D9B40000F5B3, 0x0000BDB60000D9B5, 
0x000F58EF0000ADB7, 0x800090F3800090EF, 0x800090F7000544BE, 0x800090FF800090FB, 0x8000910780009103, 0x8000910F8000910B, 0x000E00E380009113, 0x000C90E180009117, 
0x00029DB68000911B, 0x800091238000911F, 0x8000912700029DB5, 0x8000912B00029DB3, 0x000149BE8000912F, 0x00017DBC000149BF, 0x000171BA000175BD, 0x8000913300017DBB, 
0x8000913B80009137, 0x8000913F000EA4E1, 0x0004DCBE000E50E3, 0x8000914300002CE3, 0x0006ECBE000118E1, 0x0019E0BE0000F0EF, 0x0000758080009147, 0x0000758200007D81, 
0x000209A3000150EF, 0x8000914F8000914B, 0x8000915B80009153, 0x000209A5000209A6, 0x0001E9AB8000915F, 0x000448860001E5AA, 0x0001DDAF0004DC87, 0x0001E1AD0001DDAE, 
0x0006B5A80001E9AC, 0x000701AA000701A9, 0x000705AC00071DAB, 0x000705AE00070DAD, 0x8000915700073DAF, 0x8000916780009163, 0x8000916F8000916B, 0x8000917780009173, 
0x000719B88000917B, 0x000731BA000719B9, 0x0007D1BC000731BB, 0x0007C1BE0007DDBD, 0x000745B00007F1BF, 0x000745B200074DB1, 0x00074DB4000759B3, 0x000731B6000731B5, 
0x000789B300072DB7, 0x800091838000917F, 0x80009187800090E7, 0x00078DB500078DB6, 0x000789BB8000918B, 0x8000918F000781BA, 0x0007F5BF80009193, 0x00078DBD000789BE, 
0x80009197000791BC, 0x8000919B0007CDA3, 0x0007C9A68000919F, 0x800091A7800091A3, 0x0007C5AA0007C9A5, 0x800091AB0007CDAB, 0x0007CDAE800091AF, 0x0007D5AC0007B1AF, 
0x0006D1A80007C9AD, 0x00012DAA0006D9A9, 0x00013DAC000125AB, 0x00012DAE000125AD, 0x800091B3000125AF, 0x800091BB800091B7, 0x00001980800091BF, 0x0000058200001981, 
0x000189B8800091C3, 0x00019DBA000189B9, 0x0001B9BC000195BB, 0x000079BE0001B9BD, 0x00015DB0000079BF, 0x0001E1B20001E1B1, 0x0001EDB40001FDB3, 0x0001D5B60001DDB5, 
0x0002C8840001BDB7, 0x800091C70001A1B3, 0x0001A1B6800091CB, 0x800091D3800091CF, 0x00019DBA0001B1B5, 0x0001A886000121BB, 0x00012DBE0001E087, 0x000131BC00011DBF, 
0x0001E5A300012DBD, 0x800091DB800091D7, 0x800091E3800091DF, 0x0001F5A50001E5A6, 0x000165AB800091E7, 0x800091EB0001D9AA, 0x000159AF800091EF, 0x000169AD000169AE, 
0x800091F3000175AC, 0x800091F7000274E3, 0x800091FB0001BCE1, 0x80009203800091FF, 0x8000920B80009207, 0x800092138000920F, 0x8000921B80009217, 0x8000921F00076CEF, 
0x8000922780009223, 0x00001D8100001D82, 0x8000922B00001D80, 0x800092338000922F, 0x0003E4848000923B, 0x00032C878000923F, 0x80009243001CCC86, 0x8000924B80009247, 
0x800092538000924F, 0x8000925B80009257, 0x800092638000925F, 0x8000926B80009267, 0x00032DA88000926F, 0x000331AA000331A9, 0x000379AC000369AB, 0x000369AE000379AD, 
0x000329B0000361AF, 0x0000C9B2000329B1, 0x0000C1B40000C5B3, 0x0000C1B60000C1B5, 0x0000C1B80000C1B7, 0x0000C1BA0000C1B9, 0x0000C1BC0000C1BB, 0x0000C5BE0000CDBD, 
0x00074CE30000BDBF, 0x0007ACE180009273, 0x8000927B80009277, 0x800092838000927F, 0x8000928B80009287, 0x800092938000928F, 0x0006C4EF80009297, 0x8000929F8000929B, 
0x00007981800092A3, 0x0002D1B300007180, 0x000299B500007182, 0x001D1484800092AB, 0x001CC086000291B6, 0x000285BB001DE887, 0x000179BD000285BA, 0x00016DBF000175BC, 
0x800092AF00016DBE, 0x800092B7800092B3, 0x001CDC84800092BB, 0x800092C3800092BF, 0x001CE8BE0006F4EF, 0x800092C7000654E1, 0x001FF08400003CE3, 0x800092CF800092CB, 
0x000259A3800092D3, 0x800092DB800092D7, 0x800092E3800092DF, 0x000211A5000219A6, 0x00020DAB800092E7, 0x800092EB00020DAA, 0x0001E5AF800092EF, 0x0001F1AD0001E5AE, 
0x001E5DA80001FDAC, 0x001E79AA001E61A9, 0x001E69AC001E79AB, 0x001E99AE001E69AD, 0x800092A7001E99AF, 0x800092F7800092F3, 0x800092FF800092FB, 0x8000930780009303, 
0x001F51B88000930B, 0x001F51BA001F51B9, 0x001F71BC001F51BB, 0x001F71BE001F71BD, 0x001EE9B0001F71BF, 0x001EF9B2001EE9B1, 0x001EE9B4001EF9B3, 0x001F7DB6001EE9B5, 
0x001EF1B3001F71B7, 0x0000158100002D82, 0x800092370000B180, 0x001EE1B5001EE9B6, 0x001E2DBB8000930F, 0x80009313001E2DBA, 0x001E2DBF80009317, 0x001E2DBD001E2DBE, 
0x8000931B001E2DBC, 0x00006886001EB5A3, 0x001EADA600004C87, 0x800093238000931F, 0x001E69AA001EA5A5, 0x80009327001E69AB, 0x001E69AE8000932B, 0x001E69AC001E69AF, 
0x001E55A8001E69AD, 0x001E8DAA001E85A9, 0x001E9DAC001E85AB, 0x001E81AE001E81AD, 0x8000932F001EB5AF, 0x8000933780009333, 0x8000933F8000933B, 0x8000934780009343, 
0x001EA9B88000934B, 0x00016DBA001EA9B9, 0x00017DBC000165BB, 0x00016DBE000165BD, 0x001ED5B0000165BF, 0x001ED5B2001EDDB1, 0x001EB9B4001EA9B3, 0x001EA9B6001EB9B5, 
0x001E05B3001EA1B7, 0x800093538000934F, 0x8000935B80009357, 0x001E15B5001E01B6, 0x001E19BB8000935F, 0x80009363001E11BA, 0x001E7DBF80009367, 0x001E7DBD001E7DBE, 
0x8000936B001E01BC, 0x8000936F001E41A3, 0x001E45A680009373, 0x8000937B80009377, 0x001E55AA001E51A5, 0x8000937F001E5DAB, 0x001E39AE80009383, 0x001E45AC001E39AF, 
0x0002C1A8001E39AD, 0x0002D1AA0002D1A9, 0x0002FDAC0002E5AB, 0x00033DAE000335AD, 0x8000938B000335AF, 0x8000938F000268BE, 0x8000939780009393, 0x8000939F8000939B, 
0x0003D1B8800093A3, 0x0003E1BA0003D9B9, 0x000391BC0003E1BB, 0x000395BE00039DBD, 0x00034DB0000389BF, 0x00035DB2000355B1, 0x00034DB4000355B3, 0x0003F1B60003F1B5, 
0x000359800003F1B7, 0x0003658200036D81, 0x800093A7000255B3, 0x0003B9B6000279B5, 0x00040086800093AB, 0x000385BA0003E487, 0x000385BC00039DBB, 0x000385BE00038DBD, 
0x000219A3000339BF, 0x800093B3800093AF, 0x000BAC85800093B7, 0x000235A50003F5A6, 0x0003D1AB800093BB, 0x800093BF0003C9AA, 0x000375AF800093C3, 0x0003C1AD0003C9AE, 
0x800093C70003C9AC, 0x800093CF800093CB, 0x0003CCEF800093D3, 0x800093D7001F60E1, 0x001E80E3001E54E3, 0x0001F8E1800093DB, 0x800093DF001A7CEF, 0x800093E7800093E3, 
0x00007D80800093EB, 0x00001D8200001581, 0x800093EF00024084, 0x000554BE800093F3, 0x0004C086800093FB, 0x800093FF00054887, 0x8000940780009403, 0x8000940F8000940B, 
0x8000941780009413, 0x8000941F8000941B, 0x8000942780009423, 0x8000942F8000942B, 0x0005A484001EC4EF, 0x80009433001EDCE1, 0x80009437001E2CE3, 0x8000943F8000943B, 
0x0001EDB380009443, 0x8000944B80009447, 0x800094538000944F, 0x0001EDB50001EDB6, 0x000125BB80009457, 0x8000945B000179BA, 0x000119BF8000945F, 0x000135BD000129BE, 
0x000621A8000135BC, 0x000625AA00062DA9, 0x000625AC00063DAB, 0x000625AE00062DAD, 0x800093F700068DAF, 0x0007C58100001582, 0x800094630007C580, 0x80009467000338BE, 
0x000745B88000946B, 0x000745BA00074DB9, 0x000775BC000755BB, 0x00076DBE000765BD, 0x0006FDB0000765BF, 0x0006A1B20006A1B1, 0x0006ADB40006A1B3, 0x000695B600069DB5, 
0x0006ADA300077DB7, 0x000028868000946F, 0x8000947300034C87, 0x0006ADA50006ADA6, 0x000665AB80009477, 0x8000947B000639AA, 0x000659AF8000947F, 0x000675AD000669AE, 
0x80009483000675AC, 0x0007A5B380009487, 0x0007A5B58000948B, 0x800094938000948F, 0x800094970007A5B6, 0x000761BB80009387, 0x000761BD000769BA, 0x000761BF000779BC, 
0x00065DA8000769BE, 0x000665AA00066DA9, 0x000665AC00067DAB, 0x000665AE00066DAD, 0x8000949B00069DAF, 0x800094A38000949F, 0x800094AB800094A7, 0x800094B3800094AF, 
0x0006F5B8800094B7, 0x0006F5BA0006FDB9, 0x000699BC000689BB, 0x000689BE000699BD, 0x0006E5B0000681BF, 0x0006E5B20006EDB1, 0x0006E5B40006FDB3, 0x0006D1B60006EDB5, 
0x0006EDA30006CDB7, 0x800094BF800094BB, 0x800094C7800094C3, 0x0006EDA50006EDA6, 0x000629AB800094CB, 0x800094CF000621AA, 0x000629AF800094D3, 0x000629AD000621AE, 
0x00005D80000631AC, 0x0000658200006D81, 0x000198BE00018084, 0x0000D887800094DB, 0x800094DF000F7C86, 0x800094E7800094E3, 0x800094EF800094EB, 0x800094F7800094F3, 
0x00023DA8800094FB, 0x000299AA000281A9, 0x0002B9AC000291AB, 0x0002D9AE0002B9AD, 0x800094FF0002D9AF, 0x8000950780009503, 0x8000950B000EA4BF, 0x800095138000950F, 
0x000371B880009517, 0x000371BA000371B9, 0x0003D5BC000371BB, 0x0003D5BE0003DDBD, 0x0002ADB00003CDBF, 0x0002B1B20002B1B1, 0x000351B400028DB3, 0x000351B6000351B5, 
0x000211B3000351B7, 0x8000951F8000951B, 0x0003508480009523, 0x000231B5000239B6, 0x000275BB80009527, 0x8000952B000269BA, 0x000395BF8000952F, 0x000259BD000395BE, 
0x80009533000265BC, 0x80009537000255A3, 0x00027DA6000380BE, 0x8000953F8000953B, 0x00022DAA000275A5, 0x80009543000231AB, 0x0003D1AE8000954B, 0x000221AC0003D1AF, 
0x0001D58000021DAD, 0x0001E1820001DD81, 0x8000954F0002E9B3, 0x0002E9B60002F9B5, 0x8000955780009553, 0x0002D5BA8000955B, 0x000115BC00010DBB, 0x000109BE00011DBD, 
0x000D2086000109BF, 0x8000955F00028887, 0x8000956780009563, 0x0006F8EF8000956B, 0x0007D8E18000956F, 0x000634E380009573, 0x8000957B80009577, 0x800095838000957F, 
0x8000958B80009587, 0x8000958F0000ACEF, 0x8000959780009593, 0x8000959F8000959B, 0x000C6C84000150EF, 0x800095A30006DCE1, 0x800095A700061CE3, 0x800095AB000068E3, 
0x000225A300012CE1, 0x0000198100002D82, 0x800095AF00007580, 0x000235A5000225A6, 0x0001C1AB00080085, 0x800095B3000219AA, 0x0001C5AF000C24BE, 0x0001D1AD0001C5AE, 
0x000DD5A80001D9AC, 0x000DEDAA000DE5A9, 0x000DFDAC000DE5AB, 0x000DEDAE000DE5AD, 0x80009547000DE5AF, 0x00030886800095B7, 0x800095BB00038C87, 0x800095C3800095BF, 
0x000EC5B8800095C7, 0x000EC5BA000ECDB9, 0x000EF9BC000ED1BB, 0x000E99BE000EF9BD, 0x000D9DB0000E95BF, 0x000E4DB2000E45B1, 0x000E41B4000E45B3, 0x000E41B6000E41B5, 
0x000F01B8000E41B7, 0x000F05BA000F0DB9, 0x000F05BC000F1DBB, 0x000F31BE000F0DBD, 0x000FF5B0000F2DBF, 0x000FCDB2000FF9B1, 0x000FC1B4000FC1B3, 0x000FC1B6000FC1B5, 
0x000E2DA8000FC1B7, 0x000FD5AA000FD5A9, 0x000FF5AC000FEDAB, 0x000F95AE000F9DAD, 0x800095CB000F8DAF, 0x800094D7800095CF, 0x800095D7800095D3, 0x800095DF800095DB, 
0x000E1DB3800095E3, 0x800095EB800095E7, 0x800095F3800095EF, 0x000E3DB5000E5DB6, 0x000E7DBB800095F7, 0x800095FB000E71BA, 0x000E45BF800095FF, 0x000E55BD000E45BE, 
0x80009603000E59BC, 0x80009607000E59A3, 0x000E19A68000960B, 0x800096138000960F, 0x000E35AA000E79A5, 0x80009617000E39AB, 0x000E01AE8000961B, 0x000E1DAC000E01AF, 
0x0001B1A8000E11AD, 0x0001B1AA0001B1A9, 0x000171AC0001B1AB, 0x000175AE000171AD, 0x0000CD8000016DAF, 0x0000198200000981, 0x800096238000961F, 0x000170BE00017884, 
0x0000E9B88000962B, 0x000089BA0000E9B9, 0x00009DBC000085BB, 0x000081BE000081BD, 0x000115B00000B5BF, 0x000115B200011DB1, 0x0000F9B40000E9B3, 0x0000E9B60000F9B5, 
0x000239B30000E1B7, 0x000488868000962F, 0x8000963300037887, 0x0002F9B50002F1B6, 0x0002D9BB80009637, 0x8000963B0002D1BA, 0x00033DBF8000963F, 0x00033DBD00033DBE, 
0x800096430002C1BC, 0x8000964700027DA3, 0x0002B5A68000964B, 0x800096538000964F, 0x000295AA0002BDA5, 0x8000965700029DAB, 0x000379AE8000965B, 0x000285AC000379AF, 
0x001AC182000379AD, 0x8000965F001AC983, 0x001EB58680009663, 0x001E318400122987, 0x0012A18A001EBD85, 0x800096670012BD8B, 0x0016918E8000966B, 0x00137D8C00173D8F, 
0x000A51920016318D, 0x8000966F000AE593, 0x000EF196006CDCEF, 0x000A7594000EED97, 0x0002099A000E3995, 0x800096730002C59B, 0x8000967B80009677, 0x0002DD9C000F3CE1, 
0x000F219F0076A8E3, 0x000BA59D000FE19E, 0x000B819B000B2D9C, 0x0017399900169D9A, 0x0012E59700179198, 0x0013299500133D96, 0x001F159300139194, 0x001F9191001F1592, 
0x001B018F001B7190, 0x800096838000967F, 0x8000968B80009687, 0x8000968F000F60EF, 0x000528BE80009693, 0x00052484000FE4E3, 0x00002981000CA8E1, 0x8000969B00002580, 
0x00050C8700002182, 0x8000969F0004A486, 0x800096A7800096A3, 0x0000D8EF800096AB, 0x000190E1000E88EF, 0x00000CE3000EFCE1, 0x800096AF000E1CE3, 0x800096B7800096B3, 
0x800096BF800096BB, 0x00070484800096C3, 0x800096C7000704BE, 0x800096CF800096CB, 0x800096D7800096D3, 0x800096DF800096DB, 0x0003D5A3800096E3, 0x000311A10003D5A2, 
0x80009627000FC5A0, 0x800096E780009697, 0x800096EF800096EB, 0x800096F7800096F3, 0x00059DA8800096FB, 0x000639AA000621A9, 0x000619AC000631AB, 0x000679AE000619AD, 
0x00060DB0000675AF, 0x000611B2000611B1, 0x00063DB4000625B3, 0x0006D5B60006DDB5, 0x0006CDB80006F5B7, 0x000681BA0006ADB9, 0x000681BC000681BB, 0x000731BE000731BD, 
0x000691B3000731BF, 0x0000198100001982, 0x800096FF00009180, 0x0006B1B50006B9B6, 0x0006F5BB80009703, 0x800097070006E9BA, 0x000639BF8000970B, 0x0006D1BD0006D9BE, 
0x8000970F0006E5BC, 0x0000E8860006D5A3, 0x0006FDA600008487, 0x8000971780009713, 0x0006ADAA0006F5A5, 0x8000971B0006B1AB, 0x00069DAE8000971F, 0x0006A1AC00067DAF, 
0x80009723000695AD, 0x006929B580009727, 0x006C51B3006801B4, 0x006D19B1006D11B2, 0x8000972B007071B0, 0x800097338000972F, 0x8000973B80009737, 0x800097438000973F, 
0x007801A780009747, 0x007D69A5007DE9A6, 0x0001F9A3007C01A4, 0x000159A1000151A2, 0x007169AF8000974B, 0x007001AD007161AE, 0x007551AB007549AC, 0x0079F5A9007401AA, 
0x0006F9A800795DA8, 0x000605AA00060DA9, 0x000605AC00061DAB, 0x00062DAE000625AD, 0x8000974F000625AF, 0x8000975780009753, 0x8000975F8000975B, 0x8000976780009763, 
0x000625B88000976B, 0x000625BA00062DB9, 0x0001DDBC0001C5BB, 0x0001CDBE0001C5BD, 0x00065DB00001C5BF, 0x00062DB2000625B1, 0x000625B400063DB3, 0x000625B600062DB5, 
0x00058DB300061DB7, 0x800097738000976F, 0x8000977B000340BE, 0x00058DB50005A5B6, 0x0005E1BB8000977F, 0x0003A484000599BA, 0x0005E9BF80009783, 0x0005E9BD0005E1BE, 
0x000049820005F9BC, 0x0003F5800005C9A3, 0x0005E1A600004981, 0x8000978B80009787, 0x0005DDAA0005C9A5, 0x007CC8860005A5AB, 0x0005A5AE0003FC87, 0x0005BDAC0005ADAF, 
0x00022DA80005ADAD, 0x00025DAA000245A9, 0x000279AC000255AB, 0x000399AE000279AD, 0x8000978F000399AF, 0x8000979780009793, 0x8000979F8000979B, 0x800097A7800097A3, 
0x00039DB8800097AB, 0x00036DBA000365B9, 0x00037DBC000365BB, 0x00036DBE000365BD, 0x0003C1B0000365BF, 0x0003C1B20003C1B1, 0x0003C1B40003C1B3, 0x0003C1B60003C1B5, 
0x800097AF0003C1B7, 0x800097B7800097B3, 0x800097BF800097BB, 0x800097C30003E0EF, 0x007D68BE800097C7, 0x800097CB00031CE3, 0x800097CF0001FCE1, 0x800097D7800097D3, 
0x000395B3800097DB, 0x800097E3800097DF, 0x007D1C84800097EB, 0x0003B1B50003B9B6, 0x000245BB800097EF, 0x007CA886000245BA, 0x000245BF007DA487, 0x000255BD000245BE, 
0x00061CE1000255BC, 0x000650E3000794E1, 0x0000AD800006F4E3, 0x0000D1820000D181, 0x800097F7800097F3, 0x800097FF800097FB, 0x8000980780009803, 0x00068CEF8000980B, 
0x000315A3000624EF, 0x800098138000980F, 0x8000981B80009817, 0x000331A5000339A6, 0x0002C5AB007C9084, 0x8000981F0002C5AA, 0x0002C5AF80009823, 0x0002D5AD0002C5AE, 
0x007E11A80002D5AC, 0x007E25AA007E19A9, 0x007E49AC007E59AB, 0x007EBDAE007EB5AD, 0x800097E7007EB5AF, 0x8000982B80009827, 0x800098338000982F, 0x8000983B80009837, 
0x007F4DB88000983F, 0x007F51BA007F55B9, 0x007F79BC007F51BB, 0x007F6DBE007F65BD, 0x007ECDB0007F65BF, 0x007EDDB2007ED5B1, 0x007ECDB4007ED5B3, 0x007F7DB6007F75B5, 
0x007EADB3007F75B7, 0x8000984780009843, 0x8000984F8000984B, 0x007EC1B5007E35B6, 0x007E11BB80009853, 0x0003E0BE007E09BA, 0x007FB1BF80009857, 0x007E01BD007E09BE, 
0x00005D82007E09BC, 0x00004580007EE9A3, 0x007E71A600005D81, 0x8000985F8000985B, 0x007E4DAA007E85A5, 0x00004886007E55AB, 0x007E4DAE00006C87, 0x007E4DAC007FF5AF, 
0x007EB5B0007E45AD, 0x007EC1B2007EC1B1, 0x007EC1B4007EC1B3, 0x007EF5B6007EFDB5, 0x000109B8000139B7, 0x000119BA000109B9, 0x000109BC000119BB, 0x0001BDBE000109BD, 
0x800098630001B5BF, 0x8000986B80009867, 0x8000986F80009777, 0x8000987780009873, 0x007E2DA88000987B, 0x007EF5AA007E39A9, 0x007ED5AC007ECDAB, 0x007ED5AE007EDDAD, 
0x007E1DB3007ECDAF, 0x800098838000987F, 0x8000988B80009887, 0x007E3DB5007E3DB6, 0x007E65BB8000988F, 0x80009893007E11BA, 0x007E59BF80009897, 0x007E75BD007E65BE, 
0x8000989B007E75BC, 0x8000989F007E59A3, 0x007E79A6800098A3, 0x800098AB800098A7, 0x007E55AA007E79A5, 0x800098AF007E21AB, 0x007E21AE800098B3, 0x007E31AC007E1DAF, 
0x0002D5A8007E31AD, 0x000349AA0002DDA9, 0x000359AC000349AB, 0x00034DAE000345AD, 0x800098B7000345AF, 0x800098BF800098BB, 0x0003F4BE800098C3, 0x800098CF800098CB, 
0x000381B8800098D3, 0x000385BA00038DB9, 0x000389BC000399BB, 0x0003B5BE0003BDBD, 0x00033DB000007DBF, 0x0003E1B20003E1B1, 0x0003E1B40003E1B3, 0x0003D1B60003E9B5, 
0x0000A5800003D1B7, 0x0000A5820000AD81, 0x800098D70003CDB3, 0x0003C9B60003DDB5, 0x0002E084800098DB, 0x0003F5BA800098DF, 0x000339BC000329BB, 0x000329BE000339BD, 
0x007F80E3000321BF, 0x007EB8E1800098E3, 0x0003E087800098E7, 0x800098EB00047486, 0x800098F3800098EF, 0x800098FB800098F7, 0x007F28EF800098FF, 0x8000990780009903, 
0x8000990F8000990B, 0x8000991780009913, 0x0003D8EF8000991B, 0x800099238000991F, 0x000390E380009927, 0x0001D8E18000992B, 0x000015808000992F, 0x0000058200001981, 
0x00054CBE80009933, 0x000209A38000993B, 0x000219A5000440BE, 0x800099438000993F, 0x00026C8400020DA6, 0x0002EDAB80009947, 0x0002FDAD000231AA, 0x0002E5AF0002FDAC, 
0x000440860002EDAE, 0x8000994B0005B487, 0x800099538000994F, 0x8000995B80009957, 0x8000995F0001CCEF, 0x80009963007ED4E1, 0x80009967007E60E3, 0x8000996F8000996B, 
0x0001FDB380009973, 0x8000997B80009977, 0x800099838000997F, 0x000145B5000171B6, 0x00013DBB80009987, 0x8000998B00013DBA, 0x00011DBF8000998F, 0x00011DBD00011DBE, 
0x000635A800011DBC, 0x000635AA00063DA9, 0x00068DAC00069DAB, 0x0006DDAE0006B1AD, 0x800099370006D1AF, 0x8000999780009993, 0x00001D808000999B, 0x0000BD8200000981, 
0x0006BDB88000999F, 0x00074DBA000745B9, 0x00075DBC000745BB, 0x000741BE000741BD, 0x0006B9B0000741BF, 0x000689B20006B9B1, 0x000699B4000689B3, 0x00068DB6000699B5, 
0x0006BDA3000685B7, 0x00028084800099A3, 0x800099AB800099A7, 0x000605A5000631A6, 0x00067DAB800099AF, 0x0000088600067DAA, 0x00065DAF00036087, 0x00065DAD00065DAE, 
0x800099B300065DAC, 0x800099B700079DB3, 0x00075DB6800099BB, 0x800099C3800099BF, 0x000779BA000755B5, 0x800099C7000745BB, 0x000745BE800099CB, 0x000751BC00074DBF, 
0x000699B000074DBD, 0x0006A1B20006A5B1, 0x0006A5B40006BDB3, 0x0006A5B60006ADB5, 0x0006E9B80006D9B7, 0x0006F9BA0006E9B9, 0x0006D9BC0006F1BB, 0x00011DBE0006D9BD, 
0x800098C7000115BF, 0x800099D3800099CF, 0x800099DB800099D7, 0x800099E3800099DF, 0x000625A8800099E7, 0x000631AA000631A9, 0x0006F9AC000609AB, 0x0006E9AE0006F9AD, 
0x0006D9A30006E9AF, 0x800099EF800099EB, 0x800099F7800099F3, 0x000611A5000619A6, 0x000601AB800099FB, 0x800099FF00063DAA, 0x000609AF80009A03, 0x000609AD000601AE, 
0x80009A07000615AC, 0x00001D8100001D82, 0x80009A0B00001D80, 0x80009A1380009A0F, 0x0001AC84000010BE, 0x0001088780009A1B, 0x80009A1F000F4C86, 0x80009A2780009A23, 
0x000291A880009A2B, 0x0002C9AA000299A9, 0x0002DDAC0002C5AB, 0x0002C1AE0002C1AD, 0x80009A2F0002F5AF, 0x80009A3780009A33, 0x0000008D80009A3B, 0x80009A4380009A3F, 
0x0003C5B880009A47, 0x0003C5BA0003CDB9, 0x0003CDBC0003DDBB, 0x0003F5BE0003FDBD, 0x00028DB000039DBF, 0x000321B2000321B1, 0x000321B4000321B3, 0x000321B6000321B5, 
0x000241B3000321B7, 0x80009A4F80009A4B, 0x80009A5780009A53, 0x000255B5000241B6, 0x0003E5BB80009A5B, 0x80009A5F000249BA, 0x0003E5BF80009A63, 0x0003F5BD0003E5BE, 
0x80009A670003F5BC, 0x80009A6B000608E1, 0x80009A6F0007BCE3, 0x80009A7780009A73, 0x00003D8080009A7B, 0x0000198200000981, 0x80009A8380009A7F, 0x000CF4BE0003F884, 
0x0000F0E3000744EF, 0x0001B8E180009A8B, 0x000CF086000D0484, 0x80009A8F0002A487, 0x80009A9780009A93, 0x80009A9B000C28BE, 0x000014EF80009A9F, 0x80009AA780009AA3, 
0x000381A380009AAB, 0x80009AB380009AAF, 0x80009ABB80009AB7, 0x000395A5000381A6, 0x000225AB80009ABF, 0x80009AC3000389AA, 0x000225AF80009AC7, 0x000235AD000225AE, 
0x80009ACB000235AC, 0x80009AD380009ACF, 0x80009ADB80009AD7, 0x80009AE380009ADF, 0x80009AE7000628EF, 0x80009AEB00063CE1, 0x00001980000134E3, 0x00007D8200000981, 
0x000235B380009AEF, 0x80009AFB80009AF3, 0x80009AFF000FC0BE, 0x000225B50001F5B6, 0x0001D5BB80009B03, 0x80009B070001C9BA, 0x000179BF80009B0B, 0x0001C5BD000171BE, 
0x000DE5A80001C5BC, 0x000DFDAA000DF5A9, 0x000DEDAC000DF5AB, 0x000E3DAE000E35AD, 0x80009A87000E35AF, 0x0000888680009AF7, 0x80009B0F00034087, 0x80009B1780009B13, 
0x000EDDB880009B1B, 0x000EE5BA000EEDB9, 0x000E99BC000E8DBB, 0x000E8DBE000E85BD, 0x000E4DB0000E85BF, 0x000E51B2000E51B1, 0x000EF5B4000E51B3, 0x000EF5B6000EFDB5, 
0x000D75A3000EEDB7, 0x80009B2380009B1F, 0x80009B2B80009B27, 0x000D65A5000EB5A6, 0x000E95AB80009B2F, 0x80009B33000E89AA, 0x000E39AF80009B37, 0x000E85AD000E31AE, 
0x80009B3B000E85AC, 0x80009B3F000FD9B3, 0x000FFDB680009B43, 0x80009B4B80009B47, 0x000FDDBA000FF5B5, 0x80009B4F000FA1BB, 0x000FA1BE80009B53, 0x000FB1BC000FA9BF, 
0x000E81B8000FB1BD, 0x000E81BA000E81B9, 0x000E81BC000E81BB, 0x000E81BE000E81BD, 0x000E1DB0000EBDBF, 0x000E61B2000E61B1, 0x000E61B4000E61B3, 0x000E51B6000E69B5, 
0x000E45A8000E51B7, 0x000E55AA000E5DA9, 0x000E79AC000E6DAB, 0x000E6DAE000E79AD, 0x80009B57000E65AF, 0x0000118100001982, 0x80009B5B00001D80, 0x80009B5F80009A17, 
0x000E9DA380009B63, 0x0000288600028C84, 0x80009B6B00014887, 0x000EB1A5000EB9A6, 0x000EE5AB80009B6F, 0x80009B73000E99AA, 0x000EEDAF80009B77, 0x000EF5AD000EE5AE, 
0x80009B7B000EF5AC, 0x80009B7F000E19B3, 0x0001E1B680009B83, 0x80009B8B80009B87, 0x0001DDBA000E31B5, 0x80009B8F000161BB, 0x000161BE80009B93, 0x000171BC000169BF, 
0x000DC9A8000171BD, 0x000DD5AA000DD5A9, 0x000DFDAC000DE5AB, 0x00022DAE000225AD, 0x80009B97000225AF, 0x80009B9F80009B9B, 0x0000008C80009BA3, 0x80009BAB80009BA7, 
0x000281B880009BAF, 0x000285BA00028DB9, 0x000289BC000299BB, 0x0002B5BE0002BDBD, 0x00025DB000033DBF, 0x0002E1B20002E1B1, 0x0002E1B40002E1B3, 0x0002D1B60002E9B5, 
0x000D5DA30002D1B7, 0x80009BB780009BB3, 0x80009BBF80009BBB, 0x000D75A50002A5A6, 0x000225AB80009BC3, 0x80009BC7000299AA, 0x00022DAF80009BCB, 0x000235AD000225AE, 
0x00001181000235AC, 0x000EC8EF00006980, 0x80009BCF00001982, 0x80009BDB80009BD3, 0x0003EC8480009BDF, 0x0004A887000468BE, 0x000D04E10004CC86, 0x000E1CE380009BE3, 
0x000291A880009BE7, 0x0002A1AA000299A9, 0x0002D1AC0002A1AB, 0x0002D5AE0002DDAD, 0x80009BEB0002C9AF, 0x80009BF380009BEF, 0x80009BFB80009BF7, 0x80009C0380009BFF, 
0x000179B880009C07, 0x0001CDBA000179B9, 0x0001DDBC0001C5BB, 0x0001C5BE0001C5BD, 0x0002B9B00001F5BF, 0x000285B200028DB1, 0x000155B400014DB3, 0x000155B600015DB5, 
0x80009C0B000149B7, 0x80009C1380009C0F, 0x0005108480009C17, 0x000EACEF000418BE, 0x000190E1000E40EF, 0x00003CE3000EACE1, 0x80009C1B000EB0E3, 0x80009C2380009C1F, 
0x000269B380009C27, 0x80009C2F80009C2B, 0x80009C3780009C33, 0x000219B500021DB6, 0x000209BB80009C3B, 0x80009C3F00023DBA, 0x0001D9BF80009C43, 0x0001D9BD0001D1BE, 
0x0005A9A3000211BC, 0x80009C4780009BD7, 0x80009C4F80009C4B, 0x0005D9A50005DDA6, 0x0005C9AB80009C53, 0x000308860005FDAA, 0x000619AF00037C87, 0x000619AD000611AE, 
0x00079D800005D1AC, 0x0007A5820007AD81, 0x80009C570006B9B3, 0x00077DB6000775B5, 0x80009C5F80009C5B, 0x000759BA80009C63, 0x000749BC000759BB, 0x0007F9BE000749BD, 
0x000659A80007F9BF, 0x00067DAA000659A9, 0x0007B1AC000671AB, 0x0007B1AE0007B1AD, 0x80009C670007B1AF, 0x80009C6F80009C6B, 0x80009C7780009C73, 0x80009C7F80009C7B, 
0x000771B880009C83, 0x000771BA000771B9, 0x000715BC000771BB, 0x000715BE00071DBD, 0x0007D1B000070DBF, 0x0007D1B20007D1B1, 0x000771B40007D1B3, 0x000771B6000771B5, 
0x0007F5A3000771B7, 0x80009C8B80009C87, 0x80009C9380009C8F, 0x000639A5000631A6, 0x000615AB80009C97, 0x80009C9B000615AA, 0x0006B5AF80009C9F, 0x000605AD0006B5AE, 
0x80009CA3000605AC, 0x80009CAB80009CA7, 0x0000198080009CAF, 0x0000058200001981, 0x0001AC8480009CB3, 0x80009B670001ACBE, 0x0000D08680009CB7, 0x80009CBB0001E487, 
0x00018DA880009CBF, 0x000195AA000195A9, 0x0001CDAC0001DDAB, 0x0001FDAE0001F5AD, 0x0000A08400013DAF, 0x80009CC780009CC3, 0x80009CCF80009CCB, 0x80009CD780009CD3, 
0x0000C9B880009CDB, 0x0000D9BA0000C9B9, 0x0000F9BC0000D1BB, 0x000099BE0000F9BD, 0x000145B0000099BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x00021DB30000F9B7, 0x80009CE380009CDF, 0x80009CEB80009CE7, 0x000245B5000275B6, 0x000289BB80009CEF, 0x80009CF3000281BA, 0x000289BF80009CF7, 0x000289BD000281BE, 
0x001A5C85000291BC, 0x80009CFB000259A3, 0x000231A680009CFF, 0x80009D0780009D03, 0x0002C5AA000201A5, 0x80009D0B0002CDAB, 0x0002C5AE80009D0F, 0x0002D5AC0002CDAF, 
0x001C00BE0002CDAD, 0x80009D1780009D13, 0x00000D80001C0084, 0x00003D8200003581, 0x80009D1F80009D1B, 0x80009D2B80009D23, 0x80009D3380009D2F, 0x80009D3B80009D37, 
0x001CE08680009D3F, 0x80009D4300030487, 0x0002A8EF80009D47, 0x80009D4B0006C8EF, 0x000150E380009D4F, 0x000180E1000614E3, 0x80009D5300057CE1, 0x80009D5B80009D57, 
0x000279A880009D5F, 0x0002ADAA000279A9, 0x0002BDAC0002A5AB, 0x0002ADAE0002A5AD, 0x001CACBE0002A5AF, 0x80009D6780009D63, 0x80009D6F80009D6B, 0x80009D7780009D73, 
0x000109B880009D7B, 0x00011DBA000109B9, 0x000139BC000115BB, 0x0001DDBE000139BD, 0x0002DDB00001D5BF, 0x000161B2000161B1, 0x000161B4000161B3, 0x000151B6000169B5, 
0x000774E1000151B7, 0x000608E30000F4E3, 0x80009D7F0001BCE1, 0x80009D8780009D83, 0x80009D8B001C1484, 0x80009D9380009D8F, 0x000000EC80009D9B, 0x0006D4EF000028EF, 
0x0000618080009D9F, 0x0000618200006181, 0x80009DA3000269B3, 0x000269B6000279B5, 0x001CC08680009DA7, 0x000255BA001CE887, 0x0001F9BC0001E9BB, 0x0001E9BE0001F9BD, 
0x80009D270001E1BF, 0x80009DAB80009D97, 0x80009DAF001DA9A3, 0x001DA9A6001DB9A5, 0x80009DB780009DB3, 0x001D95AA80009DBB, 0x001E39AC001E29AB, 0x001E29AE001E39AD, 
0x001EF1B3001E21AF, 0x80009DC380009DBF, 0x80009DCB80009DC7, 0x001EE1B5001EE9B6, 0x001EBDBB80009DCF, 0x80009DD3001EBDBA, 0x001E8DBF80009DD7, 0x001E8DBD001E8DBE, 
0x001E29A8001E8DBC, 0x001E39AA001E29A9, 0x001E29AC001E39AB, 0x001E51AE001E29AD, 0x80009DDB001E51AF, 0x80009DE380009DDF, 0x80009DEB80009DE7, 0x80009DF380009DEF, 
0x001FEDB880009DF7, 0x001FFDBA001FF5B9, 0x001FEDBC001FF5BB, 0x001F4DBE001F45BD, 0x001E39B0001F45BF, 0x001E19B2001E39B1, 0x001E09B4001E19B3, 0x001FDDB6001E09B5, 
0x001FB1A3001FD5B7, 0x0000158100002D82, 0x80009DFB00001D80, 0x001FA1A5001FA9A6, 0x001FFDAB80009DFF, 0x80009E03001FFDAA, 0x001FCDAF0001A0BE, 0x001FCDAD001FCDAE, 
0x80009E07001FCDAC, 0x0000E886001E95B3, 0x000141B600012C87, 0x80009E0F80009E0B, 0x000145BA000155B5, 0x80009E13000121BB, 0x000121BE80009E17, 0x000131BC000129BF, 
0x001E2DA8000131BD, 0x001E59AA001E39A9, 0x000199AC001E51AB, 0x000185AE000185AD, 0x0001E0840001BDAF, 0x80009E1F80009E1B, 0x80009E2780009E23, 0x80009E2F80009E2B, 
0x000161B880009E33, 0x000161BA000161B9, 0x000161BC000161BB, 0x000161BE000161BD, 0x0001C5B0000161BF, 0x0001A1B20001A1B1, 0x0001A1B40001A1B3, 0x000191B60001A9B5, 
0x001DD1A3000191B7, 0x80009E3B80009E37, 0x80009E4380009E3F, 0x000211A5000205A6, 0x000265AB80009E47, 0x80009E4B000201AA, 0x00026DAF80009E4F, 0x000275AD000265AE, 
0x80009E53000275AC, 0x80009E5B80009E57, 0x80009E6380009E5F, 0x80009E6B80009E67, 0x0000398080009E6F, 0x0000058200003981, 0x00033CBE80009E73, 0x0003448780009E7B, 
0x0004CC840004DC86, 0x80009E8380009E7F, 0x80009E870003E5B3, 0x000331B6000331B5, 0x80009E8F80009E8B, 0x00031DBA80009E93, 0x00030DBC000315BB, 0x0000B1BE0000B1BD, 
0x80009E970000B1BF, 0x80009E9B000194E1, 0x80009E9F00017CE3, 0x80009EA780009EA3, 0x80009EAF80009EAB, 0x80009EB780009EB3, 0x80009EBF80009EBB, 0x80009EC780009EC3, 
0x000255A8000274EF, 0x000261AA00025DA9, 0x0002B5AC000261AB, 0x0002B5AE0002BDAD, 0x000568BE0002ADAF, 0x80009ECF80009ECB, 0x80009ED780009ED3, 0x0000AD810000AD82, 
0x000169B80000AD80, 0x000109BA000169B9, 0x000119BC000109BB, 0x000109BE000119BD, 0x0002D5B0000109BF, 0x0002D5B20002DDB1, 0x000179B4000169B3, 0x000169B6000179B5, 
0x001E78E1000161B7, 0x001E04E3001F5CE1, 0x80009EDB001F10E3, 0x80009EE380009EDF, 0x80009EEF80009EEB, 0x80009EF780009EF3, 0x0004F8BE80009EFB, 0x00006CEF80009EFF, 
0x0002A9A3001E64EF, 0x0004488680009F03, 0x80009F0700050487, 0x00027DA500027DA6, 0x000259AB80009F0B, 0x80009F0F000251AA, 0x0001FDAF80009F13, 0x0001FDAD0001FDAE, 
0x000675A8000241AC, 0x000681AA000681A9, 0x00068DAC00069DAB, 0x0006BDAE0006B5AD, 0x80009EE70006DDAF, 0x80009F1B80009F17, 0x80009F2380009F1F, 0x80009F2B80009F27, 
0x0006ADB880009F2F, 0x0006BDBA0006B5B9, 0x000775BC0006B5BB, 0x000775BE00077DBD, 0x0006A9B000076DBF, 0x0006BDB20006B5B1, 0x0006ADB40006B5B3, 0x00069DB6000695B5, 
0x000609B3000695B7, 0x80009F3780009F33, 0x80009F3F80009F3B, 0x000605B5000635B6, 0x000671BB80009F43, 0x80009F4700066DBA, 0x000651BF80009F4B, 0x000661BD000669BE, 
0x00001982000669BC, 0x0000658000064DA3, 0x000671A600001981, 0x80009F5380009F4F, 0x000629AA000641A5, 0x0003A484000635AB, 0x00062DAE0001E4BF, 0x00062DAC000615AF, 
0x00016C85000625AD, 0x0000088480009F5B, 0x000C008680009E77, 0x80009F5F00006087, 0x0006BDA880009F63, 0x00068DAA000685A9, 0x00069DAC000685AB, 0x0006FDAE000681AD, 
0x00069DB00006EDAF, 0x0006A5B20006ADB1, 0x000179B4000169B3, 0x000169B6000179B5, 0x000159B8000169B7, 0x0001EDBA000159B9, 0x0001FDBC0001E5BB, 0x0001E5BE0001E5BD, 
0x000625B30001D5BF, 0x80009F57000F08BE, 0x80009F6B80009F67, 0x000635B5000621B6, 0x000649BB80009F6F, 0x80009F73000679BA, 0x00019DBF80009F77, 0x00019DBD00019DBE, 
0x80009F7B000651BC, 0x80009F7F000661A3, 0x000665A680009F83, 0x80009F8B80009F87, 0x00063DAA000671A5, 0x80009F8F00060DAB, 0x0001D9AE80009F93, 0x000615AC0001D9AF, 
0x000114E10001D9AD, 0x0036D0E300011CE3, 0x000C9084000104E1, 0x80009F9B80009F97, 0x006A218F80009F9F, 0x80009FA780009FA3, 0x80009FAF80009FAB, 0x0037FCEF000148EF, 
0x0012CD9780009FB3, 0x0013099500126596, 0x001671930016E194, 0x006AF19100171992, 0x0006619F006A5990, 0x001A619D001B099E, 0x001B199B001A699C, 0x001E5999001E519A, 
0x000610E3001F0998, 0x0006ECE180009FB7, 0x0002B1A380009FBB, 0x0007D9A1000399A2, 0x003A9DB3000699A0, 0x003801B1003A85B2, 0x000768EF003E01B0, 0x0026BDB580009FBF, 
0x003001AB002401B4, 0x003645A9003619AA, 0x003EF1AF00364DA8, 0x0033C5AD003C01AE, 0x000E65A30032FDAC, 0x000361A1000E65A2, 0x000BE1A780009FC3, 0x000A79A5000A71A6, 
0x006B0182000F89A4, 0x000D0886006B0183, 0x00173186000D4C87, 0x006BB1840017B987, 0x0012618A00165185, 0x80009FCB0013058B, 0x001F118E80009FCF, 0x0013B58C001F118F, 
0x001A2992001E498D, 0x000CC4BE001B4193, 0x00075196000F8084, 0x001B519400075197, 0x0006219A001A3195, 0x80009FD30002699B, 0x0001C58180009FD7, 0x0003599C0001F980, 
0x000F48BE00019182, 0x80009FDF80009FDB, 0x80009FE780009FE3, 0x80009FEF80009FEB, 0x80009FF30006D4EF, 0x80009FF7000674E1, 0x80009FFB000154E3, 0x8000A00380009FFF, 
0x8000A00B8000A007, 0x8000A0138000A00F, 0x8000A0170002D1B3, 0x000245B6000245B5, 0x8000A01F8000A01B, 0x000229BA8000A023, 0x00023DBC000225BB, 0x000221BE000221BD, 
0x000D1DA3000215BF, 0x8000A02B8000A027, 0x8000A0338000A02F, 0x000D89A5000D89A6, 0x000DE9AB8000A03B, 0x00030886000DE5AA, 0x000DD9AF00034C87, 0x000DEDAD000DEDAE, 
0x00004980000DF1AC, 0x0000598200004981, 0x8000A03F000F25B3, 0x000FD1B6000FD1B5, 0x8000A0478000A043, 0x000FFDBA8000A04B, 0x000FD1BC000FF5BB, 0x000FC9BE000FDDBD, 
0x80009FC7000FC9BF, 0x8000A04F8000A037, 0x8000A0578000A053, 0x8000A05F8000A05B, 0x000F89A88000A063, 0x000FC1AA000F89A9, 0x000F35AC000FC1AB, 0x000F35AE000F3DAD, 
0x000F55B0000F2DAF, 0x000F69B2000F5DB1, 0x000F61B4000F65B3, 0x000F61B6000F61B5, 0x000F21B8000F61B7, 0x000F21BA000F21B9, 0x000F2DBC000F3DBB, 0x000F1DBE000F15BD, 
0x000E69A30000F9BF, 0x8000A06B8000A067, 0x00009C848000A06F, 0x000E9DA5000E9DA6, 0x000EB9AB8000A073, 0x8000A077000EB1AA, 0x000E85AF8000A07B, 0x000E91AD000E85AE, 
0x8000A07F000E9DAC, 0x8000A0878000A083, 0x8000A08F8000A08B, 0x8000A0978000A093, 0x00003D808000A09B, 0x0000198200000981, 0x8000A0A38000A09F, 0x0001D8878000A0A7, 
0x00019DA800040086, 0x0001D5AA0001D5A9, 0x0001F5AC0001EDAB, 0x000115AE00011DAD, 0x8000A0AB00010DAF, 0x8000A0B38000A0AF, 0x8000A0BB8000A0B7, 0x8000A0C38000A0BF, 
0x0000EDB88000A0C7, 0x00008DBA000085B9, 0x00009DBC000085BB, 0x00008DBE000085BD, 0x000175B0000085BF, 0x000175B200017DB1, 0x0000F9B40000E9B3, 0x0000E5B60000F9B5, 
0x00025DB30000D5B7, 0x8000A0CF8000A0CB, 0x8000A0D78000A0D3, 0x00027DB500029DB6, 0x0002B9BB8000A0DB, 0x8000A0DF0002B1BA, 0x00033DBF8000A0E3, 0x00033DBD00033DBE, 
0x0004CCBE0002A1BC, 0x8000A0E7000219A3, 0x0002D9A68000A0EB, 0x8000A0F38000A0EF, 0x0002F5AA000239A5, 0x8000A0F70002FDAB, 0x000379AE8000A0FB, 0x0002E5AC000379AF, 
0x00050CBE000379AD, 0x8000A1038000A0FF, 0x8000A107000610BE, 0x8000A10F8000A10B, 0x000035808000A113, 0x0000358200003D81, 0x0004B0868000A11B, 0x8000A11F00033487, 
0x8000A1278000A123, 0x000270EF8000A12B, 0x8000A1338000A12F, 0x8000A13B8000A137, 0x8000A1438000A13F, 0x8000A14B8000A147, 0x000194E18000A14F, 0x0001F8E38000A153, 
0x000130E18000A157, 0x000E54E3000E14E1, 0x8000A15B000F0CE3, 0x8000A1638000A15F, 0x0005A8848000A167, 0x8000A16F8000A16B, 0x8000A1778000A173, 0x000E40EF8000A17B, 
0x0002E9B3000E8CEF, 0x8000A1838000A17F, 0x8000A18F8000A18B, 0x0002E9B50002E1B6, 0x000169BB8000A193, 0x8000A197000161BA, 0x000159BF8000A19B, 0x000169BD000169BE, 
0x0000B580000171BC, 0x0000C1820000C181, 0x0004B08600040484, 0x8000A19F00050887, 0x000E31AC8000A1A3, 0x000E01AE000E39AD, 0x000EB5A8000E01AF, 0x000EA5AA000EADA9, 
0x000E19B4000E31AB, 0x000E25B6000E2DB5, 0x000E11B0000DD9B7, 0x000E15B2000E1DB1, 0x000DCDBC000E09B3, 0x000DD5BE000DD5BD, 0x000DE9B8000D69BF, 0x000DDDBA000DE9B9, 
0x0005A9A3000DD5BB, 0x8000A1AB8000A1A7, 0x8000A1B38000A1AF, 0x0005A9A50005A1A6, 0x000629AB8000A1B7, 0x8000A1BB000621AA, 0x000619AF8000A1BF, 0x000629AD000629AE, 
0x8000A1C3000631AC, 0x8000A1C70006F9B3, 0x00069DB68000A1CB, 0x8000A1D38000A1CF, 0x0006B9BA000699B5, 0x8000A1D70006B9BB, 0x000699BE8000A1DB, 0x000699BC000699BF, 
0x8000A117000699BD, 0x8000A1DF8000A187, 0x8000A1E78000A1E3, 0x0001918100019982, 0x00060DA800019980, 0x000615AA00061DA9, 0x000675AC00066DAB, 0x000669AE000679AD, 
0x000619B0000669AF, 0x000629B2000619B1, 0x000639B4000629B3, 0x00062DB6000639B5, 0x0007F1B8000621B7, 0x0007F1BA0007F1B9, 0x0007D5BC0007F1BB, 0x0007D5BE0007DDBD, 
0x0007BDA30007CDBF, 0x8000A1EF8000A1EB, 0x8000A1F78000A1F3, 0x0007DDA50007D9A6, 0x0007FDAB8000A1FB, 0x003C00860007FDAA, 0x0007DDAF00017C87, 0x0007DDAD0007DDAE, 
0x8000A1FF0007DDAC, 0x8000A203000619B3, 0x0006C9B68000A207, 0x8000A20F8000A20B, 0x000169BA000631B5, 0x8000A213000169BB, 0x000159BE8000A217, 0x000169BC000159BF, 
0x0006CDA8000161BD, 0x0006D5AA0006D5A9, 0x0006FDAC0006E5AB, 0x000605AE00060DAD, 0x8000A21B000199AF, 0x8000A2238000A21F, 0x8000A22B8000A227, 0x8000A2338000A22F, 
0x00018DB88000A237, 0x000191BA000191B9, 0x0001BDBC0001A5BB, 0x000155BE00015DBD, 0x0001E9B000014DBF, 0x0001F9B20001E9B1, 0x0001D9B40001F1B3, 0x0001B9B60001D9B5, 
0x0003CCBE0001B5B7, 0x000565A500059DA6, 0x00054DA38000A23B, 0x8000A2438000A23F, 0x00020DAF8000A247, 0x000235AD00020DAE, 0x00023DAB00023DAC, 0x8000A24B00023DAA, 
0x8000A2538000A24F, 0x8000A25B8000A257, 0x000019808000A25F, 0x0000058200001981, 0x000260848000A263, 0x000348878000A26B, 0x8000A26F003CCC86, 0x8000A2778000A273, 
0x8000A27F8000A27B, 0x003CC0848000A283, 0x8000A287000000A6, 0x8000A28B0001A4E1, 0x8000A28F0002ECE3, 0x8000A2978000A293, 0x8000A29B000254EF, 0x8000A2A38000A29F, 
0x8000A2AB8000A2A7, 0x8000A2B38000A2AF, 0x8000A2B7000385B3, 0x000381B6000381B5, 0x8000A2BF8000A2BB, 0x000349BA8000A2C3, 0x000359BC000349BB, 0x000349BE000359BD, 
0x000688E1000349BF, 0x000694E30007ACE1, 0x8000A2C700063CE3, 0x8000A2CF8000A2CB, 0x000035808000A2D3, 0x0000358200003D81, 0x003C9086003D60BE, 0x00074CEF003DF887, 
0x000209A3000744EF, 0x8000A2DF8000A2DB, 0x8000A2E78000A2E3, 0x00020DA500020DA6, 0x0002C5AB8000A2EB, 0x8000A2EF0002C5AA, 0x0002C5AF8000A2F3, 0x0002D5AD0002C5AE, 
0x000511BF0002D5AC, 0x00050DBD00050DBE, 0x0005F9BB0005E1BC, 0x0005CDB90005CDBA, 0x0005E9B70005D1B8, 0x000581B5000589B6, 0x0005A1B30005B1B4, 0x0005B1B10005B9B2, 
0x00067DAF0005B9B0, 0x00067DAD00067DAE, 0x00067DAB00067DAC, 0x00067DA900067DAA, 0x8000A2F700067DA8, 0x8000A2FF8000A2FB, 0x8000A3078000A303, 0x8000A30F8000A30B, 
0x003E65A88000A313, 0x003E7DAA003E75A9, 0x003E6DAC003E75AB, 0x003E9DAE003E95AD, 0x8000A317003E8DAF, 0x8000A31F8000A31B, 0x8000A3278000A323, 0x8000A32F8000A32B, 
0x003E81B88000A333, 0x003E81BA003E81B9, 0x003E8DBC003E9DBB, 0x003EBDBE003EB5BD, 0x003EF9B0003F4DBF, 0x003ECDB2003EC5B1, 0x003EC1B4003EC5B3, 0x003EC1B6003EC1B5, 
0x8000A267003EC1B7, 0x8000A337003EF1B3, 0x003E11B68000A2D7, 0x8000A33F8000A33B, 0x003E39BA003EE1B5, 0x8000A343003E05BB, 0x003E01BE0003E084, 0x003E1DBC003E01BF, 
0x003EB5A3003E15BD, 0x0000518100006D82, 0x000398BE00005980, 0x003EA5A5003E55A6, 0x003E41AB8000A347, 0x00004886003E7DAA, 0x003E45AF00006887, 0x003E51AD003E45AE, 
0x003E45A8003E59AC, 0x003E45AA003E4DA9, 0x003E4DAC003E5DAB, 0x003E75AE003E7DAD, 0x8000A34B003EFDAF, 0x00016C848000A34F, 0x8000A3578000A353, 0x8000A35F8000A35B, 
0x000165B88000A363, 0x000165BA00016DB9, 0x000165BC00017DBB, 0x000165BE00016DBD, 0x003E85B00001D5BF, 0x003E85B2003E8DB1, 0x003E85B4003E9DB3, 0x003E85B6003E8DB5, 
0x003ECDB300015DB7, 0x8000A36B8000A367, 0x8000A3738000A36F, 0x003EC5B5003EFDB6, 0x003E49BB8000A377, 0x8000A37B003E41BA, 0x003E49BF8000A37F, 0x003E49BD003E41BE, 
0x8000A383003E51BC, 0x8000A387003E89A3, 0x003EB9A68000A38B, 0x8000A3938000A38F, 0x003E05AA003E81A5, 0x8000A397003E0DAB, 0x003E05AE8000A39B, 0x003E15AC003E0DAF, 
0x000321A8003E0DAD, 0x000325AA000321A9, 0x000325AC00033DAB, 0x000325AE00032DAD, 0x8000A39F000399AF, 0x000264BE8000A3A3, 0x8000A3AB8000A3A7, 0x8000A3B38000A3AF, 
0x00038DB88000A3BB, 0x000391BA000391B9, 0x0003BDBC0003A5BB, 0x00007DBE000075BD, 0x0003E9B0000071BF, 0x0003F9B20003E9B1, 0x0003D9B40003F1B3, 0x0003B9B60003D9B5, 
0x0000B5810003B5B7, 0x0003A5B30000B580, 0x0003A5B50000B582, 0x8000A3C38000A3BF, 0x000400860003A5B6, 0x000325BB0003D487, 0x00032DBD000325BA, 0x000315BF000325BC, 
0x0003EDA3000315BE, 0x8000A3CB8000A3C7, 0x8000A3CF00116085, 0x0003EDA50003EDA6, 0x00036DAB8000A3D3, 0x8000A3D700036DAA, 0x00035DAF8000A3DB, 0x000365AD00035DAE, 
0x0001BCE300036DAC, 0x003E20E1003F70E1, 0x8000A3DF003F94E3, 0x8000A3E78000A3E3, 0x8000A3EF8000A3EB, 0x8000A3F78000A3F3, 0x000118EF8000A3FB, 0x001338BF8000A3FF, 
0x8000A403003EE8EF, 0x000504848000A407, 0x000068E3000504BE, 0x0001A8E18000A40B, 0x0003B0EF8000A40F, 0x8000A4178000A413, 0x00001D808000A41B, 0x0000DD8200000981, 
0x003EC9AA8000A41F, 0x003E95A8003EC9AB, 0x003EF9AE003ECDA9, 0x003ECDAC003EF9AF, 0x00EFA8BF003EC5AD, 0x000488868000A423, 0x8000A42B0004AC87, 0x8000A4338000A42F, 
0x003DD9BA8000A437, 0x003DC5B8003DD9BB, 0x003D91BE003DD9B9, 0x003DE1BC003D91BF, 0x003E49B2003DE1BD, 0x003E49B0003E49B3, 0x003E49B6003E49B1, 0x003E49B4003E49B7, 
0x00063DA8003E49B5, 0x000691AA000691A9, 0x0006D9AC0006C9AB, 0x0006C5AE0006C5AD, 0x8000A4270006F5AF, 0x8000A43F8000A43B, 0x8000A4478000A443, 0x8000A44F8000A44B, 
0x00076DB88000A453, 0x000709BA000771B9, 0x000705BC000709BB, 0x00073DBE000709BD, 0x00068DB0000735BF, 0x00077DB2000775B1, 0x00076DB4000775B3, 0x00075DB6000755B5, 
0x000619B3000755B7, 0x8000A45B8000A457, 0x8000A4638000A45F, 0x000651B5000645B6, 0x0007B1BB8000A467, 0x8000A46B000649BA, 0x000791BF8000A46F, 0x0007A1BD0007A9BE, 
0x8000A4730007A9BC, 0x8000A47700065DA3, 0x000601A68000A47B, 0x8000A4838000A47F, 0x00060DAA000615A5, 0x8000A4870007F5AB, 0x0007EDAE8000A48B, 0x0007EDAC0007D5AF, 
0x0001ED800007E5AD, 0x0000198200000981, 0x8000A4938000A48F, 0x0001C4BE0001D084, 0x000080868000A497, 0x8000A49B00012087, 0x8000A4A38000A49F, 0x8000A4AB8000A4A7, 
0x8000A4B38000A4AF, 0x8000A4B70005FCE1, 0x8000A4BB000414E3, 0x8000A4C38000A4BF, 0x8000A4CB8000A4C7, 0x8000A4D38000A4CF, 0x8000A4DB8000A4D7, 0x8000A4E38000A4DF, 
0x000631A80004C8EF, 0x000631AA000631A9, 0x0001B5AC000631AB, 0x0001B5AE0001BDAD, 0x0001A8840001ADAF, 0x8000A4EB8000A4E7, 0x8000A4F38000A4EF, 0x8000A4FB8000A4F7, 
0x000169B88000A4FF, 0x000109BA000169B9, 0x00011DBC000105BB, 0x000101BE000101BD, 0x0001D5B0000135BF, 0x0001D5B20001DDB1, 0x000179B4000169B3, 0x000169B6000179B5, 
0x0003BD81000161B7, 0x0005B1B30003BD80, 0x000235B500001982, 0x000354BE8000A503, 0x8000A50B000235B6, 0x000211BB8000A50F, 0x0002B5BD000219BA, 0x0002B5BF000209BC, 
0x8000A5130002B5BE, 0x00026DA500026DA6, 0x0005E9A3000C0084, 0x000CF8868000A517, 0x0002EDAF00037C87, 0x0002EDAD0002EDAE, 0x000249AB000251AC, 0x8000A51B000241AA, 
0x8000A5238000A51F, 0x8000A52B8000A527, 0x000120E38000A52F, 0x0001A0E18000A533, 0x000240EF8000A537, 0x8000A53F8000A53B, 0x8000A5478000A543, 0x8000A54F8000A54B, 
0x8000A3B78000A553, 0x8000A5570003F5B3, 0x0003EDB68000A55B, 0x8000A5638000A55F, 0x0003B1BA0003E5B5, 0x8000A5670003B1BB, 0x000391BE8000A56B, 0x0003A1BC000391BF, 
0x000229A80003A1BD, 0x000239AA000229A9, 0x000229AC000239AB, 0x000259AE000229AD, 0x0001CD80000255AF, 0x0000198200000981, 0x8000A5738000A56F, 0x000DB487000D7CBE, 
0x000231B8000C1C86, 0x000231BA000231B9, 0x0002F9BC0002E9BB, 0x0002E9BE0002F9BD, 0x000231B00002E9BF, 0x000231B2000231B1, 0x000211B4000231B3, 0x000211B6000211B5, 
0x8000A57B000211B7, 0x8000A5838000A57F, 0x8000A58B8000A587, 0x8000A5938000A58F, 0x8000A59700007CEF, 0x8000A59B000614E1, 0x000000EC0000A8E3, 0x8000A5A38000A59F, 
0x0002F1A38000A5A7, 0x8000A5AF8000A5AB, 0x8000A5B78000A5B3, 0x0002E1A50002E9A6, 0x0002B5AB8000A5BB, 0x8000A5BF0002B5AA, 0x000295AF8000A5C3, 0x0002A5AD000295AE, 
0x000E21A80002A5AC, 0x000E49AA000E21A9, 0x000E69AC000E59AB, 0x000E99AE000E69AD, 0x8000A577000E99AF, 0x8000A5CB8000A5C7, 0x8000A5D38000A5CF, 0x8000A5DB8000A5D7, 
0x000EF5B88000A5DF, 0x000EF5BA000EFDB9, 0x000E9DBC000E85BB, 0x000E81BE000E81BD, 0x000EE9B0000EB5BF, 0x000EFDB2000EE9B1, 0x000ED5B4000EF1B3, 0x000ED5B6000EDDB5, 
0x000EC1B3000ECDB7, 0x0000B58100001582, 0x8000A5E30000B580, 0x000EE1B5000EE9B6, 0x000E2DBB000010BE, 0x00036484000E2DBA, 0x000E19BF8000A5E7, 0x000E25BD000E11BE, 
0x8000A5EB000E29BC, 0x00008886000E85A3, 0x000EADA600036C87, 0x8000A5F38000A5EF, 0x000E69AA000EA5A5, 0x8000A5F7000E69AB, 0x000E55AE8000A5FB, 0x000E6DAC000E5DAF, 
0x000E89B3000E61AD, 0x8000A6038000A5FF, 0x8000A60B8000A607, 0x000E89B5000E81B6, 0x000E95BB8000A60F, 0x8000A613000E8DBA, 0x000EF9BF8000A617, 0x000E85BD000EF1BE, 
0x8000A61B000E85BC, 0x8000A6238000A61F, 0x000D10E18000A627, 0x000D04E38000A62B, 0x8000A6338000A62F, 0x000CA4EF8000A637, 0x8000A63F8000A63B, 0x8000A6478000A643, 
0x000E01A88000A64B, 0x000E01AA000E01A9, 0x000E01AC000E01AB, 0x000E01AE000E01AD, 0x0000DD80000E3DAF, 0x0000198200000981, 0x8000A6538000A64F, 0x000074BE00013C84, 
0x000E1DB88000A65B, 0x000E25BA000E2DB9, 0x0001F9BC0001E9BB, 0x0001E9BE0001F9BD, 0x000E49B00001E9BF, 0x000E51B2000E51B1, 0x000E35B4000E51B3, 0x000E35B6000E3DB5, 
0x000D89A3000E2DB7, 0x0004A8868000A65F, 0x8000A66300033C87, 0x000D89A5000D81A6, 0x000D95AB8000A667, 0x8000A66B000D8DAA, 0x000DF9AF8000A66F, 0x000D85AD000DF1AE, 
0x8000A673000D85AC, 0x0003488400029DB3, 0x000355B6000440BE, 0x8000A67B8000A677, 0x000371BA0002B1B5, 0x8000A67F000379BB, 0x000331BE8000A683, 0x000351BC000331BF, 
0x000391B0000351BD, 0x0003A1B2000399B1, 0x0003D1B40003A1B3, 0x0003D1B60003D1B5, 0x0003F5B80003D1B7, 0x0003C9BA0003F9B9, 0x0003DDBC0003C9BB, 0x0003CDBE0003C5BD, 
0x8000A6870003C5BF, 0x8000A68F8000A68B, 0x001AEC858000A693, 0x8000A6978000A507, 0x000221A88000A69B, 0x000231AA000231A9, 0x00021DAC000205AB, 0x0003F1AE0003F1AD, 
0x8000A69F0003F1AF, 0x8000A6A78000A6A3, 0x000050EF8000A6AB, 0x8000A6B38000A6AF, 0x000084E38000A6B7, 0x0001F8E18000A6BB, 0x000015808000A6BF, 0x0000058200001981, 
0x000399A38000A6C3, 0x000468868000A6CB, 0x8000A6CF00056087, 0x0003B5A5000251A6, 0x00027DAB8000A6D3, 0x8000A6D7000275AA, 0x000235AF8000A6DB, 0x000255AD000235AE, 
0x8000A6DF000255AC, 0x8000A6E78000A6E3, 0x8000A6EF8000A6EB, 0x8000A6F78000A6F3, 0x00046CBE0001F8EF, 0x8000A6FB000E80E1, 0x8000A6FF000114E3, 0x8000A7078000A703, 
0x8000A70F8000A70B, 0x8000A7178000A713, 0x8000A71B0001DDB3, 0x0001F5B60001FDB5, 0x8000A7238000A71F, 0x0001B1BA8000A727, 0x00019DBC000185BB, 0x00013DBE000135BD, 
0x0005BDA8000135BF, 0x000619AA000601A9, 0x000639AC000611AB, 0x000659AE000639AD, 0x8000A6C7000649AF, 0x00001D8100001D82, 0x8000A72B00001D80, 0x8000A7338000A72F, 
0x00069DB88000A737, 0x00074DBA000745B9, 0x00075DBC000745BB, 0x000741BE000741BD, 0x000639B0000741BF, 0x000605B200060DB1, 0x0006B5B40006ADB3, 0x0006B5B60006BDB5, 
0x000691A30006A5B7, 0x0000288600028C84, 0x8000A73B0003C087, 0x0006B1A50006B9A6, 0x0006C9AB8000A73F, 0x8000A7430006FDAA, 0x000679AF8000A747, 0x000679AD000671AE, 
0x8000A74B0006D1AC, 0x8000A74F000799B3, 0x000751B68000A753, 0x8000A75B8000A757, 0x00076DBA0007B1B5, 0x8000A75F000775BB, 0x000759BE8000A763, 0x00076DBC000745BF, 
0x8000A767000765BD, 0x8000A76F8000A76B, 0x8000A7778000A773, 0x8000A77B0005A0EF, 0x8000A7838000A77F, 0x8000A78700057CE3, 0x8000A78B00053CE1, 0x8000A7938000A78F, 
0x00061DA38000A797, 0x0000158100002D82, 0x8000A79B00001D80, 0x000635A50006D5A6, 0x0006F1AB8000A79F, 0x8000A7A30006E9AA, 0x0006C1AF00012084, 0x0006E1AD0006DDAE, 
0x0006C5A80006E9AC, 0x0006D5AA0006D5A9, 0x0006FDAC0006E5AB, 0x00061DAE000615AD, 0x0001E8BE000615AF, 0x000008868000A7AB, 0x8000A7AF00008887, 0x8000A7B78000A7B3, 
0x00067DB88000A7BB, 0x00060DBA000605B9, 0x000601BC000605BB, 0x000639BE000609BD, 0x00066DB0000639BF, 0x00067DB2000675B1, 0x000659B4000675B3, 0x00064DB6000645B5, 
0x000291A8000645B7, 0x0002A1AA000299A9, 0x0002D1AC0002A1AB, 0x0002D5AE0002DDAD, 0x8000A7BF0002C9AF, 0x8000A7C78000A7C3, 0x8000A7CB00C524BF, 0x8000A7D38000A7CF, 
0x000359B88000A7D7, 0x000369BA000359B9, 0x000361BC000365BB, 0x000361BE000361BD, 0x0002B9B0000361BF, 0x000285B200028DB1, 0x000375B400036DB3, 0x000375B600037DB5, 
0x000229B300036DB7, 0x8000A7DF8000A7DB, 0x000384848000A7E3, 0x000259B500025DB6, 0x000249BB8000A7E7, 0x8000A65700027DBA, 0x0003B9BF8000A7EB, 0x0003B9BD0003B1BE, 
0x8000A7EF000251BC, 0x8000A7F300026DA3, 0x000219A68000A7F7, 0x8000A7FF8000A7FB, 0x000239AA00021DA5, 0x8000A80300020DAB, 0x0003F5AE8000A807, 0x000215AC0003FDAF, 
0x0002A5A80003FDAD, 0x0002BDAA0002B5A9, 0x0002ADAC0002B5AB, 0x00013DAE000135AD, 0x00001181000135AF, 0x8000A80B00000D80, 0x8000A80F00001982, 0x001DB4BE8000A813, 
0x0001EDB88000A81B, 0x000181BA000185B9, 0x000185BC000181BB, 0x0001B1BE00018DBD, 0x000151B00001B1BF, 0x000151B2000151B1, 0x0001F5B4000151B3, 0x0001F5B60001FDB5, 
0x0000D8EF0001E1B7, 0x001DA8868000A81F, 0x8000A823001DDC87, 0x8000A82B8000A827, 0x8000A82F0006C4EF, 0x8000A8330006F4E1, 0x0000CCE3000138E3, 0x000128E18000A837, 
0x00027DB58000A83B, 0x8000A8438000A83F, 0x8000A8470001EDB6, 0x00026DB38000A84B, 0x0001DDBD8000A84F, 0x000161BF0001DDBC, 0x8000A853000169BE, 0x0001CDBB8000A857, 
0x001DB5A30001CDBA, 0x8000A85B8000A817, 0x8000A8638000A85F, 0x001DA5A5001E35A6, 0x001E15AB8000A867, 0x8000A86B001E15AA, 0x001EB9AF8000A86F, 0x001E05AD001EB1AE, 
0x8000A873001E05AC, 0x8000A87B8000A877, 0x000019808000A87F, 0x0000058200001981, 0x0003EC848000A883, 0x8000A887000368BE, 0x0001D0868000A88B, 0x8000A88F0000B487, 
0x001FBDA88000A893, 0x001F19AA001F01A9, 0x001F09AC001F19AB, 0x001F31AE001F35AD, 0x8000A897001F29AF, 0x8000A89F8000A89B, 0x8000A8A78000A8A3, 0x8000A8AF8000A8AB, 
0x0000C9B88000A8B3, 0x0000D9BA0000C9B9, 0x0000F9BC0000D1BB, 0x000099BE0000F9BD, 0x001F5DB0000099BF, 0x001F21B2001F21B1, 0x001F25B4001F3DB3, 0x001F09B6001F29B5, 
0x001CC0EF001F09B7, 0x8000A8B70019C0E1, 0x8000A8BB0009D0E3, 0x8000A8C38000A8BF, 0x000125A38000A8C7, 0x001D15A1000399A2, 0x001DB0E3001D0DA0, 0x001E88E18000A8CB, 
0x001ED1B3001060EF, 0x8000A8D38000A8CF, 0x8000A8DB8000A8D7, 0x001EC1B5001EF5B6, 0x001EA5BB8000A8DF, 0x8000A8E3001ED9BA, 0x001EADBF8000A8E7, 0x001EA9BD001EA1BE, 
0x001E11A3001EB5BC, 0x8000A8EF8000A8EB, 0x0024198F8000A8F3, 0x001E01A5001E35A6, 0x001E65AB000710BE, 0x00040084001E19AA, 0x001E6DAF8000A8FB, 0x001E69AD001E61AE, 
0x0014DD9B001E75AC, 0x001709990015E59A, 0x001F799F00111198, 0x0019F99D0019799E, 0x002D6193001B099C, 0x00296D9100289192, 0x00117D9700296D90, 0x002CE99500117596, 
0x00042086002D7994, 0x0027818200039487, 0x002A9584002A8D83, 0x002E9986002B6185, 0x0004A884002E9987, 0x002F398A8000A8FF, 0x0012BD8C0012AD8B, 0x0014F98E0012E98D, 
0x8000A90300161D8F, 0x001755928000A907, 0x001A719400189993, 0x001CF196001AF995, 0x8000A90B001E7D97, 0x001E559A8000A90F, 0x0002759C0000D19B, 0x8000A9178000A913, 
0x00F685AF8000A91B, 0x00F2F1AD00F401AE, 0x00F001AB00F289AC, 0x000E9DA9000E85AA, 0x000A75A7000E9DA8, 0x000801A5000A85A6, 0x0006B9A3000601A4, 0x0002D1A10006B1A2, 
0x000345808000A7A7, 0x0003458200034D81, 0x8000A9238000A91F, 0x8000A92B8000A927, 0x8000A9338000A92F, 0x00FC01B58000A937, 0x00FAF5B300FBC1B4, 0x00F7BDB100FAF5B2, 
0x00036DA800F6F5B0, 0x000375AA00037DA9, 0x0003B5AC0003ADAB, 0x0003B5AE0003BDAD, 0x8000A93B0003ADAF, 0x8000A9438000A93F, 0x8000A94B8000A947, 0x8000A9538000A94F, 
0x000275B88000A957, 0x000201BA000201B9, 0x000201BC000201BB, 0x000231BE000209BD, 0x0003D5B0000231BF, 0x0003D5B20003DDB1, 0x000261B4000265B3, 0x000261B6000261B5, 
0x001E10E1000261B7, 0x0001F8E38000A95B, 0x00001580000400BE, 0x0000398200000981, 0x8000A9638000A95F, 0x000488868000A96B, 0x8000A96F00050C87, 0x000124EF8000A973, 
0x8000A97B8000A977, 0x8000A9838000A97F, 0x8000A98B8000A987, 0x8000A98F0000B0EF, 0x8000A9978000A993, 0x8000A99B00005CE3, 0x8000A99F000184E1, 0x8000A9A78000A9A3, 
0x00047DA38000A9AB, 0x8000A9678000A8F7, 0x8000A9B38000A9AF, 0x0004BDA50004BDA6, 0x000499AB8000A9B7, 0x8000A9BB000491AA, 0x000525AF8000A9BF, 0x000531AD000525AE, 
0x8000A9C3000481AC, 0x8000A9C7000605B3, 0x000635B68000A9CB, 0x8000A9D38000A9CF, 0x00061DBA00063DB5, 0x0003E0840006A9BB, 0x0006A9BE0000E0BE, 0x0006A9BC0006A9BF, 
0x00052DA80006A9BD, 0x0006C9AA0006A1A9, 0x0006F1AC0006C9AB, 0x0006EDAE0006F1AD, 0x0000ED800006E5AF, 0x0000F1820000F181, 0x000090868000A9D7, 0x8000A9DB0000F087, 
0x0007E1B88000A9DF, 0x0007E1BA0007E1B9, 0x0007E1BC0007E1BB, 0x0007E1BE0007E1BD, 0x00069DB00007E1BF, 0x000639B2000629B1, 0x000629B4000639B3, 0x000619B6000629B5, 
0x000741A3000619B7, 0x8000A9E78000A9E3, 0x8000A9EF8000A9EB, 0x000779A5000771A6, 0x0007EDAB8000A9F3, 0x8000A9F7000759AA, 0x0007EDAF8000A9FB, 0x0007EDAD0007EDAE, 
0x8000A9FF0007EDAC, 0x8000AA030006F1B3, 0x000695B68000AA07, 0x8000AA0F8000AA0B, 0x0006B1BA00069DB5, 0x8000AA130006BDBB, 0x000699BE8000AA17, 0x0006A5BC000685BF, 
0x000625A800069DBD, 0x00063DAA000635A9, 0x000651AC000631AB, 0x000651AE000651AD, 0x8000AA1B000651AF, 0x00012C848000AA1F, 0x8000AA278000AA23, 0x8000AA2F8000AA2B, 
0x00063DB88000AA33, 0x0001D9BA0001C9B9, 0x0001F9BC0001D1BB, 0x000199BE0001F9BD, 0x000631B0000195BF, 0x000635B200063DB1, 0x000619B400060DB3, 0x00060DB6000605B5, 
0x0005B5A3000605B7, 0x8000AA3B8000AA37, 0x8000AA438000AA3F, 0x0005D9A50005D1A6, 0x0005F9AB000358BE, 0x000C88860005F5AA, 0x0005C1AF0003BC87, 0x0005D9AD0005DDAE, 
0x00004D810005E1AC, 0x00034DB300004D80, 0x00035DB500005D82, 0x8000AA4F8000AA4B, 0x8000AA5300034DB6, 0x000329BB8000AA57, 0x00033DBD000341BA, 0x000321BF00033DBC, 
0x000239A8000329BE, 0x00038DAA000239A9, 0x00039DAC000385AB, 0x000385AE000385AD, 0x000CEC840003B5AF, 0x000CE0BE8000AA5B, 0x8000AA638000AA5F, 0x8000AA6B8000AA67, 
0x000361B88000AA6F, 0x000365BA000361B9, 0x000365BC00037DBB, 0x000365BE00036DBD, 0x0003CDB00000D9BF, 0x0003A1B20003A5B1, 0x0003A5B40003A1B3, 0x000391B60003ADB5, 
0x8000AA73000391B7, 0x8000AA7B8000AA77, 0x0003F4EF8000AA7F, 0x8000AA878000AA83, 0x000098E38000AA8B, 0x000180E18000AA8F, 0x8000AA978000AA93, 0x8000AA9F8000AA9B, 
0x0007F5BA8000AAA3, 0x8000AAA70007FDBB, 0x000641BE8000AAAB, 0x0007E5BC000641BF, 0x8000AAAF000655BD, 0x8000AAB3000719B3, 0x0007D9B68000AABB, 0x8000AAC38000AABF, 
0x000798E10007D9B5, 0x0007B8E30001FCE3, 0x0000DD8000063CE1, 0x0000F1820000F581, 0x8000AACB8000AAC7, 0x8000AAD38000AACF, 0x8000AADB8000AAD7, 0x0006CCEF000120EF, 
0x000CE0868000AADF, 0x0002CDA3000D0C87, 0x0002DDA58000AAE3, 0x8000AAEB8000AAE7, 0x8000AAEF0002CDA6, 0x0002A9AB8000AAF3, 0x0002BDAD0002C1AA, 0x0002A1AF0002BDAC, 
0x000E55A80002A9AE, 0x000E69AA000E5DA9, 0x000EB5AC000E69AB, 0x000EA9AE000EB9AD, 0x8000AAB7000EA9AF, 0x8000AAFB8000AAF7, 0x8000AB038000AAFF, 0x8000AB0B8000AB07, 
0x000F5DB88000AB0F, 0x000F65BA000F61B9, 0x000F65BC000F7DBB, 0x000F65BE000F6DBD, 0x000ED9B0000F15BF, 0x000F69B2000ED9B1, 0x000F79B4000F69B3, 0x000F6DB6000F79B5, 
0x000EE1B3000F65B7, 0x8000AB178000AB13, 0x8000AB1F8000AB1B, 0x000E3DB5000E39B6, 0x000E1DBB8000AB23, 0x00032484000E1DBA, 0x000FBDBF00002CBE, 0x000FBDBD000FBDBE, 
0x00005D82000FBDBC, 0x00004580000EA5A3, 0x000E7DA600005D81, 0x8000AB2B8000AB27, 0x000E59AA000E79A5, 0x00040086000E59AB, 0x000FF9AE00035C87, 0x000FF9AC000FF9AF, 
0x8000AB2F000FF9AD, 0x8000AB378000AB33, 0x8000AB3F8000AB3B, 0x8000AB43000D44EF, 0x8000AB4B8000AB47, 0x8000AB4F000D94E3, 0x8000AB53000D1CE1, 0x8000AB5B8000AB57, 
0x000E39B38000AB5F, 0x8000AB678000AB63, 0x8000AB6F8000AB6B, 0x000EF9B5000EF1B6, 0x000EDDBB8000AB73, 0x8000AB77000ED5BA, 0x000E91BF8000AB7B, 0x000EADBD000EADBE, 
0x000EEDA8000EB1BC, 0x000EF1AA000EF1A9, 0x000E31AC000E11AB, 0x000E31AE000E31AD, 0x8000AB7F000E31AF, 0x8000AB878000AB83, 0x00001D808000AB8B, 0x0003B98200000981, 
0x0001E9B88000AB8F, 0x0001F9BA0001E9B9, 0x0001E9BC0001F9BB, 0x00015DBE0001E9BD, 0x000E51B0000155BF, 0x000E25B2000E59B1, 0x000E29B4000E39B3, 0x000E1DB6000E15B5, 
0x8000AB930001D9B7, 0x000204BE00029C84, 0x8000AB9B000D75A3, 0x000DBDA6000DB5A5, 0x8000ABA38000AB9F, 0x000D99AA8000ABA7, 0x000DFDAC000D91AB, 0x000DE1AE000DE1AD, 
0x000351B6000DDDAF, 0x000380848000ABAB, 0x8000ABAF000341B5, 0x0004D886000351B3, 0x000359BE0002A887, 0x000359BC000359BF, 0x000351BA000359BD, 0x8000ABB300035DBB, 
0x000385A38000ABB7, 0x8000ABBF8000ABBB, 0x8000ABC78000ABC3, 0x000395A5000385A6, 0x000389AB8000ABCB, 0x8000AA47000385AA, 0x00038DAF8000ABCF, 0x00038DAD00038DAE, 
0x8000ABD300038DAC, 0x00F5B4858000ABD7, 0x8000ABDF8000ABDB, 0x8000ABE78000ABE3, 0x8000ABEF8000ABEB, 0x8000ABF78000ABF3, 0x000009818000ABFB, 0x8000ABFF00001980, 
0x8000AC030001FD82, 0x000248BE000125B3, 0x000141B68000AC0B, 0x8000AC138000AC0F, 0x0001A5BA000159B5, 0x8000AC170001ADBB, 0x0001ADBE8000AC1B, 0x0001B5BC000199BF, 
0x000560860001ADBD, 0x8000AC1F0002F487, 0x0001A0E18000AC23, 0x00034CE38000AC27, 0x8000AC2F8000AC2B, 0x000398EF8000AC33, 0x8000AC3B8000AC37, 0x8000AC438000AC3F, 
0x8000AC4B8000AC47, 0x8000AC538000AC4F, 0x8000AC5700044084, 0x8000AC5F8000AC5B, 0x8000AC630001C8EF, 0x8000AC67000E7CE1, 0x00000D80000114E3, 0x00007D8200007581, 
0x8000AC6F8000AC6B, 0x8000AC7B8000AC73, 0x8000AC7F0001EDA3, 0x000189A6000191A5, 0x0004C086000414BE, 0x00016DAA00044487, 0x00017DAC000165AB, 0x000165AE000165AD, 
0x8000AB97000151AF, 0x8000AC838000AC07, 0x8000AC778000AC87, 0x8000AC8F8000AC8B, 0x000631A88000AC93, 0x000609AA000639A9, 0x000675AC000609AB, 0x000641AE000665AD, 
0x0006C5B0000641AF, 0x0006C5B20006CDB1, 0x0006CDB40006DDB3, 0x000699B60006F9B5, 0x0006ADB8000699B7, 0x0006BDBA0006B5B9, 0x0006ADBC0006B5BB, 0x00069DBE000695BD, 
0x00078DA8000695BF, 0x000791AA000791A9, 0x0007BDAC0007A5AB, 0x0007D5AE0007DDAD, 0x8000AC970007C9AF, 0x8000AC9F8000AC9B, 0x8000ACA78000ACA3, 0x8000ACAF8000ACAB, 
0x000741B88000ACB3, 0x000741BA000741B9, 0x000745BC00075DBB, 0x000779BE00074DBD, 0x0007BDB0000775BF, 0x00078DB2000785B1, 0x000781B4000781B3, 0x000781B6000781B5, 
0x000619B3000781B7, 0x8000ACBB8000ACB7, 0x8000ACC38000ACBF, 0x000635B500065DB6, 0x000641BB8000ACC7, 0x8000ACCB000679BA, 0x000645BF8000ACCF, 0x000655BD000645BE, 
0x8000ACD3000659BC, 0x8000ACD700065DA3, 0x000619A68000ACDB, 0x8000ACE38000ACDF, 0x00063DAA000671A5, 0x00012484000605AB, 0x000601AE000124BE, 0x00061DAC000601AF, 
0x000649A8000611AD, 0x000181AA000655A9, 0x000185AC000181AB, 0x000185AE00018DAD, 0x0000ED8000013DAF, 0x0000F1820000F181, 0x000010868000ACEB, 0x8000ACEF00009487, 
0x0000C9B88000ACF3, 0x0000D9BA0000C9B9, 0x0000F9BC0000D1BB, 0x000099BE0000F9BD, 0x000145B0000095BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x00075DBA0000F9B7, 0x000745B800076DBB, 0x0007B5BE00075DB9, 0x000775BC0007BDBF, 0x000711B20007BDBD, 0x000709B0000711B3, 0x000775B6000705B1, 0x000701B400077DB7, 
0x000745AA000701B5, 0x000691A800074DAB, 0x000749AE00074DA9, 0x000755AC000749AF, 0x8000ACF700074DAD, 0x8000ACFF8000ACFB, 0x8000AD078000AD03, 0x8000AD0F8000AD0B, 
0x000289B38000AD13, 0x8000AD1B8000AD17, 0x8000AD238000AD1F, 0x00028DB500028DB6, 0x000209BB8000AD27, 0x8000AD2B000201BA, 0x000209BF8000AD2F, 0x000209BD000201BE, 
0x8000AD33000211BC, 0x8000AD370002CDA3, 0x0002C9A68000AD3B, 0x8000AD438000AD3F, 0x000245AA0002C9A5, 0x8000AD4700024DAB, 0x000245AE8000AD4B, 0x000255AC00024DAF, 
0x0002ADA800024DAD, 0x0002B5AA0002BDA9, 0x000175AC00016DAB, 0x000175AE00017DAD, 0x0001CD8000016DAF, 0x0000198200000981, 0x8000AD538000AD4F, 0x00FDB4BE00023484, 
0x0001E9B88000AD5B, 0x000189BA0001E9B9, 0x00019DBC000185BB, 0x000181BE000181BD, 0x000115B00001B5BF, 0x000115B200011DB1, 0x0001F9B40001E9B3, 0x0001E9B60001F9B5, 
0x0006D8E10001E1B7, 0x000614E30007C4E1, 0x8000AD5F0007D4E3, 0x8000AD6300066CE1, 0x00FC2C840000E4E3, 0x00FCA4BE8000AD67, 0x00FD9086000038EF, 0x00069CEF00FDD487, 
0x8000AD6B00064CEF, 0x00FCC8848000AD6F, 0x8000AD73000271B3, 0x0001B1B60001B1B5, 0x8000AD7B8000AD77, 0x00019DBA8000AD7F, 0x00018DBC000195BB, 0x000171BE000171BD, 
0x00FDBDA3000171BF, 0x8000AD838000AD57, 0x8000AD8B8000AD87, 0x00FE7DA500FE7DA6, 0x00FE59AB8000AD8F, 0x8000AD9300FE51AA, 0x00FEBDAF8000AD97, 0x00FEBDAD00FEBDAE, 
0x8000AD9B00FE41AC, 0x8000ADA38000AD9F, 0x8000ADAB8000ADA7, 0x8000ADB38000ADAF, 0x00000D808000ADB7, 0x00001D8200001581, 0x8000ADBF8000ADBB, 0x8000ADC78000ADC3, 
0x00FFBDA88000ADCB, 0x00FF11AA00FF15A9, 0x00FF51AC00FF29AB, 0x00FF49AE00FF51AD, 0x0000008600FF41AF, 0x8000ADCF00036487, 0x8000ADD78000ADD3, 0x8000ADDF8000ADDB, 
0x000081B88000ADE3, 0x000081BA000081B9, 0x000081BC000081BB, 0x000081BE000081BD, 0x00FF01B0000081BF, 0x0000E1B200FF01B1, 0x0000E1B40000E1B3, 0x0000D1B60000E9B5, 
0x8000ADE70000D1B7, 0x8000ADEF8000ADEB, 0x8000ADF78000ADF3, 0x8000ADFB00FEBCE1, 0x8000ADFF00FC38E3, 0x8000AE078000AE03, 0x8000AE0B00FCECEF, 0x8000AE138000AE0F, 
0x00FED9B38000AE17, 0x8000AE1F8000AE1B, 0x8000AE278000AE23, 0x00FE99B500FE91B6, 0x00FE85BB8000AE2B, 0x8000AE2F00FE85BA, 0x00016DBF8000AE33, 0x000175BD000165BE, 
0x00FE19A3000175BC, 0x00002886000184BE, 0x8000AE4200015C87, 0x00FE59A500FE51A6, 0x00FE45AB8000AE46, 0x8000AE4A00FE45AA, 0x0001ADAF8000AE4E, 0x0001B5AD0001A5AE, 
0x00009D800001B5AC, 0x0000A5820000AD81, 0x8000AE52000161B3, 0x000161B6000161B5, 0x8000AE5A8000AE56, 0x0000EDBA8000AE5E, 0x0000FDBC0000E5BB, 0x0000E1BE0000E5BD, 
0x00027DA80000DDBF, 0x0002A5AA0002ADA9, 0x0002A5AC0002BDAB, 0x0002A5AE0002ADAD, 0x0004EC8400031DAF, 0x8000AE668000AE62, 0x8000AE6E8000AE6A, 0x8000AE768000AE72, 
0x000371B88000AE7A, 0x000371BA000371B9, 0x000315BC000371BB, 0x000315BE00031DBD, 0x000365B000030DBF, 0x000365B200036DB1, 0x000369B400037DB3, 0x00035DB6000355B5, 
0x8000AE7E000355B7, 0x8000AE868000AE82, 0x8000ACE7000221A3, 0x000221A6000221A5, 0x8000AE8E8000AE8A, 0x0003ADAA8000AE92, 0x0003BDAC0003A5AB, 0x0003A1AE0003A5AD, 
0x8000AE9600039DAF, 0x8000AE9E8000AE9A, 0x00001D808000AEA2, 0x0000398200000981, 0x8000AEAA8000AEA6, 0x8000AEB68000AEB2, 0x0004D086000424BE, 0x8000AEBA00032087, 
0x000291A88000AEBE, 0x0002A1AA000299A9, 0x0002C1AC0002A1AB, 0x0002F9AE0002C9AD, 0x8000AEC20002F9AF, 0x8000AECA8000AEC6, 0x8000AED28000AECE, 0x8000AEDA8000AED6, 
0x0001C5B88000AEDE, 0x0001D5BA0001CDB9, 0x0001F5BC0001EDBB, 0x00019DBE000195BD, 0x000145B0000195BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x00FE28E10001FDB7, 0x00FE38E38000AEE2, 0x00041C84000480BE, 0x8000AEEA8000AEE6, 0x8000AEF28000AEEE, 0x8000AEFA8000AEF6, 0x8000AF028000AEFE, 0x00FEE8EF8000AF06, 
0x000000F68000AF0A, 0x8000AF0E0000B8EF, 0x000009818000AF12, 0x8000AF1600001980, 0x8000AF1A00003D82, 0x000748868000AF22, 0x8000AF260004FC87, 0x8000AF2A00FE2CE3, 
0x0005A9B3000144E1, 0x8000AF1E8000AEAE, 0x8000AF328000AF2E, 0x0005C9B50005C9B6, 0x000609BB8000AF36, 0x8000AF3A000601BA, 0x000609BF8000AF3E, 0x000609BD000601BE, 
0x8000AF42000611BC, 0x8000AF460005EDA3, 0x00058DA68000AF4A, 0x8000AF528000AF4E, 0x000645AA00058DA5, 0x8000AF5600064DAB, 0x000645AE8000AF5A, 0x000655AC00064DAF, 
0x000665A800064DAD, 0x000671AA00066DA9, 0x0007B1AC000671AB, 0x0007B1AE0007B1AD, 0x0003A8840007B1AF, 0x8000AF628000AF5E, 0x8000AF6A8000AF66, 0x8000AF728000AF6E, 
0x000761B88000AF76, 0x000761BA000761B9, 0x000761BC000761BB, 0x000765BE000761BD, 0x0007D1B0000715BF, 0x0007D1B20007D1B1, 0x000775B40007D1B3, 0x000761B6000761B5, 
0x000690E1000761B7, 0x000538E38000AF7A, 0x00000D808000AF7E, 0x00003D8200003581, 0x8000AF868000AF82, 0x000128BE8000AF8A, 0x000090868000AF92, 0x00052CEF00010487, 
0x0007B9B38000AF96, 0x8000AF9A8000AF8E, 0x8000AFA28000AF9E, 0x000679B5000671B6, 0x000655BB8000AFA6, 0x8000AFAA000655BA, 0x0006E5BF8000AFAE, 0x000645BD0006F1BE, 
0x000779A3000645BC, 0x8000AFB68000AFB2, 0x8000AFBE8000AFBA, 0x0006B9A50006B1A6, 0x000695AB8000AFC2, 0x8000AFC6000695AA, 0x000625AF8000AFCA, 0x000685AD000631AE, 
0x8000AFCE000685AC, 0x8000AFD200063DB3, 0x0001CDB68000AFD6, 0x8000AFDE8000AFDA, 0x0001A1BA0001CDB5, 0x8000AFE20001ADBB, 0x0001A9BE8000AFE6, 0x0001B5BC00019DBF, 
0x0005E5A80001A9BD, 0x0005F1AA0005F5A9, 0x000201AC000201AB, 0x000231AE000209AD, 0x000C00BE000231AF, 0x8000AFEE8000AFEA, 0x00001D808000AFF2, 0x0000B98200000981, 
0x0002E9B88000AFF6, 0x0002F9BA0002E9B9, 0x0002E9BC0002F9BB, 0x00035DBE0002E9BD, 0x000221B0000351BF, 0x000225B200022DB1, 0x000229B4000239B3, 0x000215B600021DB5, 
0x8000AFFA0002D9B7, 0x000380848000AE37, 0x8000B002000575A3, 0x000285A6000285A5, 0x8000B00A8000B006, 0x0002E9AA8000B00E, 0x0002FDAC0002E5AB, 0x0002E1AE0002E1AD, 
0x0001E8E10002D5AF, 0x000250E38000B012, 0x000C5086000CC084, 0x8000B01600037087, 0x8000B01E8000B01A, 0x8000B0268000B022, 0x8000B02E8000B02A, 0x000220EF8000B032, 
0x00022DA88000B036, 0x000241AA000239A9, 0x000241AC000241AB, 0x000271AE000249AD, 0x8000B03A000271AF, 0x000CA4BE8000B03E, 0x8000B0468000B042, 0x8000B04E8000B04A, 
0x000289B88000B052, 0x00029DBA000289B9, 0x0002B9BC000295BB, 0x00017DBE0002B9BD, 0x0002E5B0000175BF, 0x0002E5B20002EDB1, 0x0002EDB40002FDB3, 0x0002D5B60002DDB5, 
0x000768E10002BDB7, 0x000608E3000134E3, 0x8000B05600067CE1, 0x8000B05E8000B05A, 0x000009818000B062, 0x8000B06600003980, 0x8000B06A00001D82, 0x0006CCEF000064EF, 
0x8000B0768000B072, 0x8000B07A00028DB3, 0x00028DB68000B07E, 0x8000B0868000B082, 0x000265BA00028DB5, 0x000CC88600026DBB, 0x00026DBE000CE087, 0x000275BC00025DBF, 
0x8000AFFE00026DBD, 0x8000B08A8000B06E, 0x8000B0928000B08E, 0x8000B09A8000B096, 0x000EB1A88000B09E, 0x000E89AA000EB9A9, 0x000EF5AC000E89AB, 0x000EE5AE000EEDAD, 
0x000EA5B0000EDDAF, 0x000EA5B2000EADB1, 0x000EA5B4000EBDB3, 0x000F79B6000EA9B5, 0x000F4DB8000F79B7, 0x000F5DBA000F55B9, 0x000F4DBC000F55BB, 0x000FEDBE000FE5BD, 
0x8000B0A2000FE5BF, 0x000D0DAA8000B0A6, 0x000D1DAC000D05AB, 0x000D05AE000D05AD, 0x8000B0AA000D35AF, 0x8000B0B28000B0AE, 0x8000B0B6000DE5A3, 0x000DE5A6000DE5A5, 
0x000E61B38000B0BA, 0x8000B0C28000B0BE, 0x8000B0CA8000B0C6, 0x000E1DB5000E0DB6, 0x000E09BB8000B0CE, 0x8000B0D2000E01BA, 0x000E0DBF8000B0D6, 0x000E09BD000E01BE, 
0x000FA1A3000E11BC, 0x0001E58100001582, 0x8000B0DA0001E580, 0x000FDDA5000FCDA6, 0x000FC9AB000190BE, 0x0002A084000FC1AA, 0x000FCDAF8000B0DE, 0x000FC9AD000FC1AE, 
0x8000B0E2000FD1AC, 0x0000E886000E8DB3, 0x000E89B600012C87, 0x8000B0EA8000B0E6, 0x000171BA000E89B5, 0x8000B0EE000171BB, 0x0001F1BE8000B0F2, 0x000161BC0001F1BF, 
0x000E3DA8000161BD, 0x000E41AA000E45A9, 0x000E45AC000E41AB, 0x000191AE000E4DAD, 0x00018C84000191AF, 0x8000B0FA8000B0F6, 0x8000B1028000B0FE, 0x8000B10A8000B106, 
0x000169B88000B10E, 0x000175BA000175B9, 0x000119BC000109BB, 0x000109BE000119BD, 0x0001F1B0000101BF, 0x0001F1B20001F1B1, 0x000171B40001F1B3, 0x000159B6000171B5, 
0x000DC9A3000159B7, 0x8000B1168000B112, 0x8000B11A000340BE, 0x000DCDA5000DCDA6, 0x000235AB8000B11E, 0x8000B122000235AA, 0x0002B5AF8000B126, 0x000225AD0002B5AE, 
0x8000B12A000225AC, 0x8000B1328000B12E, 0x8000B13A8000B136, 0x8000B1428000B13E, 0x000039808000B146, 0x0000058200003981, 0x0004D0868000B14A, 0x8000B15200034487, 
0x0004CC848000B156, 0x8000B15E8000B15A, 0x000264EF8000B162, 0x8000B16A8000B166, 0x000110E38000B16E, 0x0001F8E18000B172, 0x8000B17A8000B176, 0x8000B1828000B17E, 
0x000375BB8000B186, 0x8000B18A000375BA, 0x0000D9BF8000B18E, 0x000365BD0000D1BE, 0x0003B9B3000365BC, 0x8000B1968000B192, 0x8000B19E8000B19A, 0x000395B5000351B6, 
0x000241A88000B1A2, 0x000251AA000251A9, 0x00027DAC000265AB, 0x0002B1AE0002B1AD, 0x000568BE0002B1AF, 0x8000B1AA8000B1A6, 0x00000D808000B1AE, 0x0000AD820000A581, 
0x000169B88000B1B2, 0x000109BA000169B9, 0x000119BC000109BB, 0x000109BE000119BD, 0x0002D1B0000109BF, 0x0002D1B20002D1B1, 0x000175B40002D1B3, 0x000169B600017DB5, 
0x000E70E1000161B7, 0x0000B0E3000F4CE1, 0x8000B1B6000F50E3, 0x00E748EF8000B1BA, 0x000228E100049885, 0x001370E38000B1C2, 0x000678BE8000B1C6, 0x00005CEF8000B1CA, 
0x000299A3000E6CEF, 0x0007A8868000B1CE, 0x8000B1D200048087, 0x0002B5A5000271A6, 0x000255AB8000B1D6, 0x8000B1DA000255AA, 0x0001F9AF8000B1DE, 0x000245AD0001F1AE, 
0x000679A8000245AC, 0x00068DAA000679A9, 0x00069DAC000685AB, 0x000681AE000681AD, 0x8000B1BE000681AF, 0x8000B1E68000B1E2, 0x8000B1EE8000B1EA, 0x8000B1F68000B1F2, 
0x0006A5B88000B1FA, 0x0006A5BA0006ADB9, 0x0006ADBC0006BDBB, 0x000771BE000771BD, 0x0006C5B0000771BF, 0x0006D9B20006C9B1, 0x0006C9B40006D9B3, 0x0006B1B60006C9B5, 
0x000605B30006B1B7, 0x8000B2028000B1FE, 0x8000B20A8000B206, 0x000615B5000601B6, 0x00060DBB8000B20E, 0x8000B212000601BA, 0x00060DBF8000B216, 0x00060DBD00060DBE, 
0x8000B21A00060DBC, 0x8000B21E000641A3, 0x000645A68000B222, 0x8000B22A8000B226, 0x000645AA000651A5, 0x00012484000649AB, 0x000649AE8000B232, 0x000649AC000649AF, 
0x0008459F000649AD, 0x00090D9D00090D9E, 0x000D699B000B899C, 0x000F8999000D119A, 0x00F1259700F10D98, 0x00F5FD9500F12596, 0x00F7999300F50D94, 0x00F9319100F99992, 
0x00FD298F00F93990, 0x00019D8100019D82, 0x8000B23600018180, 0x0001ECEF00048CEF, 0x000208E18000B23A, 0x000130E30005F4E3, 0x001C0086000504E1, 0x8000B23E00018887, 
0x0001A1A18000B242, 0x001D09A38000B246, 0x001CF9A5000369A2, 0x00191DA7001D11A4, 0x001521A900191DA6, 0x001579AB0018B5A8, 0x001191AD001521AA, 0x002C01AF001001AC, 
0x002D5DB1001089AE, 0x0029E9B3002DE5B0, 0x002801B5002801B2, 0x8000B24A0029EDB4, 0x8000B2528000B24E, 0x8000B25A8000B256, 0x000319A38000B25E, 0x0005FDA10004D9A2, 
0x00FE69820005FDA0, 0x8000B26200FA0183, 0x00F4B9868000B266, 0x00FA118400F63587, 0x00F6F58A00FAB185, 0x8000B26A00F2258B, 0x000CA18E8000B26E, 0x00F23D8C000E318F, 
0x000E399200F22D8D, 0x000344840008C193, 0x000B1596001CC0BE, 0x000A5D9400065597, 0x0006659A000A5595, 0x8000B2720007499B, 0x8000B27A8000B276, 0x0000919C8000B27E, 
0x000209B88000B282, 0x000219BA000209B9, 0x000239BC000211BB, 0x000259BE000239BD, 0x000285B0000255BF, 0x000285B200028DB1, 0x000285B400029DB3, 0x000285B600028DB5, 
0x000565A8000239B7, 0x00057DAA000569A9, 0x000501AC000509AB, 0x000531AE000509AD, 0x8000B286000531AF, 0x8000B14E8000B22E, 0x8000B28E8000B28A, 0x0001F5810001E582, 
0x0004B5B30001F580, 0x8000B292001D8C84, 0x8000B29A8000B296, 0x0004C9B50004C9B6, 0x000309BB8000B2A2, 0x001D2886000301BA, 0x000309BF001D2087, 0x000309BD000301BE, 
0x8000B2A6000311BC, 0x8000B2AA0004F1A3, 0x00048DA6001CC0BE, 0x8000B2B28000B2AE, 0x000345AA00048DA5, 0x001FA0BE00034DAB, 0x000345AE8000B2B6, 0x000355AC00034DAF, 
0x8000B2BA00034DAD, 0x8000B2C28000B2BE, 0x8000B2CA8000B2C6, 0x8000B2D28000B2CE, 0x8000B2D60006D4EF, 0x8000B2DA000674E1, 0x8000B2DE000154E3, 0x8000B2E68000B2E2, 
0x00029DB38000B2EA, 0x8000B2F28000B2EE, 0x8000B2FA8000B2F6, 0x0002A5B5000251B6, 0x000205BB8000B2FE, 0x8000B302000205BA, 0x0001FDBF8000B306, 0x000215BD0001FDBE, 
0x001D5DA3000215BC, 0x001FE58100001582, 0x8000B30A001FE580, 0x001D65A5001D91A6, 0x001DC5AB8000B312, 0x00030886001DC5AA, 0x001E3DAF00037C87, 0x001DD5AD001E3DAE, 
0x8000B316001DD5AC, 0x8000B31A001F0DB3, 0x001F3DB68000B31E, 0x8000B3268000B322, 0x001FE9BA001F05B5, 0x8000B32A001FE9BB, 0x001FE9BE8000B32E, 0x001FE9BC001FD5BF, 
0x8000B29E001FE9BD, 0x8000B3328000B30E, 0x8000B33A8000B336, 0x8000B3428000B33E, 0x001FBDA88000B346, 0x001FE1AA001FE5A9, 0x001FE9AC001FF9AB, 0x001F39AE001FD9AD, 
0x001F49B0001F39AF, 0x001F59B2001F49B1, 0x001F49B4001F59B3, 0x001F71B6001F75B5, 0x001F55B8001F6DB7, 0x001F55BA001F5DB9, 0x001F39BC001F29BB, 0x001F29BE001F39BD, 
0x001E49A3001F21BF, 0x8000B34E8000B34A, 0x8000B3568000B352, 0x001E41A5001E79A6, 0x001EADAB8000B35A, 0x8000B35E001EADAA, 0x001E91AF8000B362, 0x001EADAD001EADAE, 
0x8000B366001EADAC, 0x8000B36E8000B36A, 0x00001D808000B372, 0x0000398200000981, 0x8000B37A8000B376, 0x8000B37E0001A884, 0x000400868000B382, 0x8000B3860001D487, 
0x00019DA88000B38A, 0x0001C1AA0001C5A9, 0x0001C5AC0001C1AB, 0x0001F1AE0001CDAD, 0x8000B38E0001F1AF, 0x8000B3968000B392, 0x8000B39E8000B39A, 0x8000B3A68000B3A2, 
0x0000CDB88000B3AA, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 0x00009DBE000095BD, 0x000169B0000095BF, 0x000179B2000169B1, 0x000169B4000179B3, 0x0000FDB6000169B5, 
0x000249B30000F5B7, 0x8000B3B28000B3AE, 0x8000B3B6000480BE, 0x00024DB500024DB6, 0x0002ADBB8000B3BA, 0x8000B3BE0002ADBA, 0x0002ADBF8000B3C2, 0x0002ADBD0002ADBE, 
0x8000B3C60002ADBC, 0x8000B3CA00020DA3, 0x000209A68000B3CE, 0x8000B3D68000B3D2, 0x0002E9AA000209A5, 0x8000B3DA0002E9AB, 0x0002E9AE8000B3DE, 0x0002E9AC0002E9AF, 
0x8000B3E20002E9AD, 0x000504BE8000B3E6, 0x8000B3EA000614BE, 0x8000B3F68000B3F2, 0x000021808000B3FA, 0x0000398200002181, 0x0004B08600032084, 0x8000B3FE00035487, 
0x8000B4068000B402, 0x8000B40E8000B40A, 0x8000B4168000B412, 0x8000B41A000220EF, 0x8000B4228000B41E, 0x8000B426000258E3, 0x8000B42A000184E1, 0x8000B4328000B42E, 
0x000130E18000B436, 0x00007CE3001E34E1, 0x8000B43A001E18E3, 0x8000B4428000B43E, 0x0005A8848000B446, 0x8000B44E8000B44A, 0x8000B4568000B452, 0x001EA8EF8000B45A, 
0x00023DB3001E88EF, 0x000468868000B462, 0x000000D40005DC87, 0x0002FDB50002FDB6, 0x0002D9BB8000B466, 0x0006A4BE0002D1BA, 0x000161BF8000B46A, 0x00017DBD00017DBE, 
0x001DFDBC0002C1BC, 0x001D65BE001D65BD, 0x001DF9B8001D7DBF, 0x001DE9BA001DF9B9, 0x001DA9B4001DE9BB, 0x001D81B6001DA9B5, 0x001E51B0001D81B7, 0x001E51B2001E51B1, 
0x001EBDAC001E51B3, 0x001E11AE001E41AD, 0x001F3DA8001E11AF, 0x001E85AA001E85A9, 0x0000CD80001EA5AB, 0x0000DD820000D581, 0x8000B4728000B46E, 0x8000B47A8000B476, 
0x00057DA38000B47E, 0x8000B4868000B482, 0x8000B48E8000B48A, 0x0005BDA50005BDA6, 0x000599AB8000B492, 0x8000B496000591AA, 0x000621AF8000B49A, 0x00063DAD00063DAE, 
0x8000B49E000581AC, 0x8000B4A20006D9B3, 0x000691B68000B4A6, 0x8000B4AE8000B4AA, 0x0006ADBA0006E1B5, 0x8000B4B20006B5BB, 0x000691BE8000B4B6, 0x0006A1BC00069DBF, 
0x8000B3EE0006A1BD, 0x8000B4BA8000B45E, 0x00000D808000B4BE, 0x0001918200019181, 0x000635A88000B4C2, 0x000635AA00063DA9, 0x00060DAC000615AB, 0x00067DAE000675AD, 
0x00060DB0000675AF, 0x000611B2000615B1, 0x000631B4000611B3, 0x000629B600063DB5, 0x000619B8000629B7, 0x0007F9BA000619B9, 0x0007E9BC0007F9BB, 0x0007DDBE0007E9BD, 
0x00079DA30007D5BF, 0x8000B4CA8000B4C6, 0x8000B4CE00028484, 0x0007A5A50007D5A6, 0x0007F1AB8000B4D2, 0x000C00860007E9AA, 0x0007D9AF00017C87, 0x0007E5AD0007D5AE, 
0x8000B4D60007E5AC, 0x8000B4DA000629B3, 0x0006A5B68000B4DE, 0x8000B4E68000B4E2, 0x000165BA0006ADB5, 0x8000B4EA00016DBB, 0x00016DBE8000B4EE, 0x000175BC00015DBF, 
0x0006C5A800016DBD, 0x0006E5AA0006D9A9, 0x000661AC000661AB, 0x000661AE000661AD, 0x8000B4F2000661AF, 0x8000B4FA8000B4F6, 0x8000B5028000B4FE, 0x8000B50A8000B506, 
0x000189B88000B50E, 0x00019DBA000189B9, 0x0001B9BC000195BB, 0x000151BE0001B9BD, 0x0001E5B0000151BF, 0x0001E5B20001EDB1, 0x0001EDB40001FDB3, 0x0001D5B60001DDB5, 
0x0005F5A60001BDB7, 0x8000B5168000B512, 0x8000B51A0005FDA5, 0x8000B51E000579A3, 0x00023DAE8000B522, 0x000225AC00020DAF, 0x000235AA00023DAD, 0x8000B52600023DAB, 
0x8000B52E8000B52A, 0x8000B5368000B532, 0x000015808000B53A, 0x0000158200001D81, 0x000260848000B542, 0x000348878000B546, 0x8000B54A000CCC86, 0x8000B5528000B54E, 
0x8000B55A8000B556, 0x000D28868000B55E, 0x000000A1000C4087, 0x8000B5620001A4E1, 0x8000B5660002ECE3, 0x8000B56E8000B56A, 0x8000B57200073CEF, 0x8000B57A8000B576, 
0x8000B5828000B57E, 0x8000B58A8000B586, 0x8000B58E000385B3, 0x000381B6000381B5, 0x8000B5968000B592, 0x000349BA8000B59A, 0x000359BC000349BB, 0x000349BE000359BD, 
0x000650E1000349BF, 0x000014E30007ACE1, 0x8000B59E00063CE3, 0x8000B5A68000B5A2, 0x00003580000D5484, 0x0000058200003D81, 0x000D7CBE8000B5AA, 0x00074CEF8000B5B2, 
0x000209A300074CEF, 0x8000B5BA8000B5B6, 0x8000B5C28000B5BE, 0x00020DA500020DA6, 0x0002C5AB8000B5C6, 0x8000B5CA0002C5AA, 0x0002C5AF8000B5CE, 0x0002D5AD0002C5AE, 
0x0005D5BC0002D5AC, 0x0005E1BE0005DDBD, 0x0005BDB80005E1BF, 0x0005D1BA0005D5B9, 0x0005A9B40005D1BB, 0x0005B5B60005B5B5, 0x000605B0000585B7, 0x000605B200060DB1, 
0x000665AC0005B9B3, 0x000665AE00066DAD, 0x0006BDA800067DAF, 0x0006A5AA0006ADA9, 0x8000B5D200067DAB, 0x8000B5DA8000B5D6, 0x8000B5E28000B5DE, 0x8000B5EA8000B5E6, 
0x000E5DA88000B5EE, 0x000E79AA000E61A9, 0x000E69AC000E79AB, 0x000E99AE000E69AD, 0x8000B5F2000E99AF, 0x8000B5FA8000B5F6, 0x8000B6028000B5FE, 0x8000B60A8000B606, 
0x000E81B88000B60E, 0x000E81BA000E81B9, 0x000E8DBC000E9DBB, 0x000EBDBE000EB5BD, 0x000EF9B0000F4DBF, 0x000ECDB2000EC5B1, 0x000EC1B4000EC5B3, 0x000EC1B6000EC1B5, 
0x8000B53E000EC1B7, 0x8000B612000EF5B3, 0x000EEDB68000B5AE, 0x8000B61A8000B616, 0x000E39BA000EE5B5, 0x0003E484000E05BB, 0x000E01BE0003E4BE, 0x000E1DBC000E01BF, 
0x000EB1A3000E15BD, 0x00005D8100005D82, 0x8000B61E00004580, 0x000EA1A5000EA9A6, 0x000E41AB8000B622, 0x00004886000E7DAA, 0x000E45AF00006887, 0x000E51AD000E45AE, 
0x000E35A8000E59AC, 0x000E41AA000E41A9, 0x000E41AC000E41AB, 0x000E71AE000E49AD, 0x8000B626000E71AF, 0x00016C848000B62A, 0x8000B6328000B62E, 0x8000B63A8000B636, 
0x000161B88000B63E, 0x000161BA000161B9, 0x000161BC000161BB, 0x000161BE000161BD, 0x000E81B0000161BF, 0x000E81B2000E81B1, 0x000E81B4000E81B3, 0x000E81B6000E81B5, 
0x000EC9B3000E81B7, 0x8000B6468000B642, 0x8000B64E8000B64A, 0x000EC9B5000EC9B6, 0x000E45BB8000B652, 0x8000B656000E45BA, 0x000E45BF8000B65A, 0x000E55BD000E45BE, 
0x8000B65E000E55BC, 0x8000B662000E8DA3, 0x000E8DA68000B666, 0x8000B66E8000B66A, 0x000E01AA000E8DA5, 0x8000B672000E01AB, 0x000E01AE8000B676, 0x000E11AC000E01AF, 
0x0002DDA8000E11AD, 0x00032DAA000325A9, 0x000321AC000321AB, 0x000321AE000321AD, 0x8000B67A000321AF, 0x8000B6828000B67E, 0x8000B68A8000B686, 0x8000B692000278BE, 
0x000389B88000B696, 0x00039DBA000389B9, 0x0003B9BC000395BB, 0x000079BE0003B9BD, 0x0003E5B0000079BF, 0x0003E5B20003EDB1, 0x0003EDB40003FDB3, 0x0003D5B60003DDB5, 
0x0000AD810003BDB7, 0x0003ADB30000AD80, 0x0003A1B50000BD82, 0x8000B69E8000B69A, 0x000400860003A9B6, 0x000321BB0003D487, 0x000321BD000329BA, 0x000311BF000339BC, 
0x0003E5A3000321BE, 0x8000B6A68000B6A2, 0x8000B6AA0030F085, 0x0003E9A50003E1A6, 0x000369AB8000B6AE, 0x8000B6B2000361AA, 0x000359AF8000B6B6, 0x000369AD000369AE, 
0x0001B8E3000371AC, 0x000F98E1000F70E1, 0x8000B6BA000E00E3, 0x8000B6C28000B6BE, 0x8000B6CA8000B6C6, 0x8000B6D28000B6CE, 0x000164EF8000B6D6, 0x005D30BF8000B6DA, 
0x8000B6DE000EF4EF, 0x000504848000B6E2, 0x8000B6E6000504BE, 0x8000B6EA0001A4E1, 0x8000B6EE000064E3, 0x8000B6F68000B6F2, 0x000015800003A0EF, 0x0000058200001D81, 
0x000EC9AA8000B6FA, 0x000E95A8000EC9AB, 0x000EF9AE000ECDA9, 0x000ECDAC000EF9AF, 0x00040086000EC5AD, 0x8000B70200048487, 0x8000B70A8000B706, 0x8000B7128000B70E, 
0x000DD1BA8000B716, 0x000DCDB8000DDDBB, 0x000DEDBE000DC5B9, 0x000DC5BC000D95BF, 0x000E49B2000DE5BD, 0x000E49B0000E49B3, 0x000E49B6000E49B1, 0x000E49B4000E49B7, 
0x000639A8000E49B5, 0x00069DAA000639A9, 0x0006D5AC000695AB, 0x0006C9AE0006DDAD, 0x8000B6FE0006C1AF, 0x8000B71E8000B71A, 0x8000B7268000B722, 0x8000B72E8000B72A, 
0x000769B88000B732, 0x00077DBA000769B9, 0x000715BC00070DBB, 0x000701BE000705BD, 0x000689B000073DBF, 0x000779B2000689B1, 0x000769B4000779B3, 0x000759B6000769B5, 
0x000615B3000759B7, 0x8000B73A8000B736, 0x8000B7428000B73E, 0x00065DB500065DB6, 0x00064DBB8000B746, 0x8000B74A00064DBA, 0x0007ADBF8000B74E, 0x0007ADBD0007ADBE, 
0x8000B7520007ADBC, 0x8000B756000651A3, 0x000619A68000B75A, 0x8000B7628000B75E, 0x000609AA000619A5, 0x8000B766000609AB, 0x0007E9AE8000B76A, 0x0007E9AC0007E9AF, 
0x0006A9A80007E9AD, 0x0006B9AA0006A9A9, 0x0006A9AC0006B9AB, 0x00013DAE0006A9AD, 0x0001F980000135AF, 0x0001C5820001CD81, 0x00027CBE00027884, 0x000178878000B76E, 
0x0001D1B800009C86, 0x0001E1BA0001D9B9, 0x000191BC0001E1BB, 0x000195BE00019DBD, 0x00014DB0000189BF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x0001F1B60001F1B5, 
0x000639B50001F1B7, 0x8000B7768000B772, 0x8000B77A000631B6, 0x000629B38000B77E, 0x000199BD8000B782, 0x00012DBF000191BC, 0x8000B786000191BE, 0x000189BB8000B68E, 
0x000671A3000191BA, 0x8000B78E8000B78A, 0x8000B7968000B792, 0x000661A5000669A6, 0x0001D1AB8000B79A, 0x8000B79E0001C9AA, 0x000175AF8000B7A2, 0x0001C1AD0001C9AE, 
0x8000B7A60001C9AC, 0x0007BCEF8000B7AA, 0x8000B7B28000B7AE, 0x8000B7BA8000B7B6, 0x8000B7C28000B7BE, 0x8000B7CA8000B7C6, 0x000688E18000B7CE, 0x000760E38000B7D2, 
0x000075808000B7D6, 0x0000198200007981, 0x8000B7DA00024084, 0x000314BE8000B7E2, 0x003CC0868000B7E6, 0x8000B7EA00034487, 0x8000B7F28000B7EE, 0x8000B7FA8000B7F6, 
0x8000B8028000B7FE, 0x000228EF8000B806, 0x8000B80E8000B80A, 0x8000B8168000B812, 0x003CEC848000B81A, 0x8000B8228000B81E, 0x000194E18000B826, 0x0002E4E38000B82A, 
0x000351B38000B82E, 0x8000B8368000B832, 0x8000B83E8000B83A, 0x000345B5000365B6, 0x000331BB8000B842, 0x8000B846000329BA, 0x0000F1BF8000B84A, 0x000311BD000319BE, 
0x000285A8000321BC, 0x000299AA00028DA9, 0x00028DAC000299AB, 0x0002DDAE0002A5AD, 0x0001FD800002D5AF, 0x0001C5820001CD81, 0x003C9086003D64BE, 0x8000B852003DB887, 
0x000151B8003C6084, 0x000151BA000151B9, 0x000171BC000151BB, 0x000171BE000171BD, 0x0002ADB0000171BF, 0x0002B5B20002B5B1, 0x00029DB4000285B3, 0x00017DB6000175B5, 
0x8000B856000171B7, 0x8000B85E8000B85A, 0x8000B8668000B862, 0x8000B86E8000B86A, 0x003CECBE000054EF, 0x8000B87200061CE1, 0x8000B876000090E3, 0x8000B87E8000B87A, 
0x000251A38000B882, 0x003F44848000B886, 0x8000B88E8000B88A, 0x000245A5000265A6, 0x000231AB8000B892, 0x8000B896000229AA, 0x0001F1AF8000B89A, 0x000211AD000219AE, 
0x003E55A8000221AC, 0x003E61AA003E59A9, 0x003E61AC003E61AB, 0x003E61AE003E61AD, 0x8000B84E003E61AF, 0x8000B8A28000B89E, 0x8000B8AA8000B8A6, 0x8000B8B28000B8AE, 
0x003EE9B88000B8B6, 0x003EFDBA003EE9B9, 0x003E95BC003EF1BB, 0x003E95BE003E9DBD, 0x003EE1B0003E8DBF, 0x003EE5B2003EE1B1, 0x003EE5B4003EFDB3, 0x003EE5B6003EEDB5, 
0x003EE9B3003ED9B7, 0x0000B58100001582, 0x8000B8BA0000B580, 0x003EE9B5003EE1B6, 0x003E25BB8000B8BE, 0x0000A886003E25BA, 0x003E29BF0000A487, 0x003E29BD003E21BE, 
0x8000B8C2003E31BC, 0x8000B8C6003EADA3, 0x003EA5A68000B8CA, 0x8000B8D28000B8CE, 0x003E61AA003EADA5, 0x8000B8D6003E61AB, 0x003E65AE8000B8DA, 0x003E75AC003E6DAF, 
0x003E39A8003E6DAD, 0x003E8DAA003E85A9, 0x003E9DAC003E85AB, 0x003E8DAE003E85AD, 0x8000B8DE003E85AF, 0x8000B8E68000B8E2, 0x8000B8EE8000B8EA, 0x8000B8F68000B8F2, 
0x003E9DB88000B8FA, 0x003EA5BA003EADB9, 0x000179BC000169BB, 0x000169BE000179BD, 0x003EC9B0000169BF, 0x003EDDB2003ED5B1, 0x003ECDB4003ED5B3, 0x003EB5B6003EB1B5, 
0x8000B8FE003EADB7, 0x003E05B5003E15B6, 0x003E15B38000B902, 0x8000B90A8000B906, 0x003E65BF8000B90E, 0x003E11BD003E19BE, 0x003E01BB003E19BC, 0x8000B7DE003E1DBA, 
0x003E45A38000B912, 0x8000B91A8000B916, 0x8000B9228000B91E, 0x003E55A5003E45A6, 0x003E51AB8000B926, 0x8000B92A003E4DAA, 0x003E35AF00002CBE, 0x003E41AD003E49AE, 
0x0003E982003E49AC, 0x0003D980003FD0EF, 0x000350870003D181, 0x8000B9320004B486, 0x8000B93A8000B936, 0x8000B9428000B93E, 0x8000B94A8000B946, 0x8000B94E003E84E3, 
0x00028DB3003E44E1, 0x000344848000B952, 0x8000B956000440BE, 0x000281B50002BDB6, 0x000349BB8000B95A, 0x8000B95E000341BA, 0x000349BF8000B962, 0x000349BD000341BE, 
0x8000B966000351BC, 0x8000B96E8000B96A, 0x8000B972000580BE, 0x8000B97A8000B976, 0x000261A88000B97E, 0x000265AA00026DA9, 0x000269AC000279AB, 0x000255AE00025DAD, 
0x0003E5B000039DAF, 0x0003E5B20003EDB1, 0x0003E5B40003FDB3, 0x0003E5B60003EDB5, 0x00036DB800035DB7, 0x000371BA000371B9, 0x00034DBC000371BB, 0x000331BE000331BD, 
0x8000B982000331BF, 0x8000B98A8000B986, 0x003EC8E38000B98E, 0x0001A8E100051C84, 0x000034EF8000B992, 0x8000B99A8000B996, 0x8000B9A68000B9A2, 0x8000B9AE8000B9AA, 
0x00005D808000B9B2, 0x0000618200006181, 0x8000B9B6000381A3, 0x0003B1A600038DA5, 0x0004C08600079884, 0x00024DAA00054887, 0x00025DAC000245AB, 0x00024DAE000245AD, 
0x8000B9BA000245AF, 0x8000B9C28000B9BE, 0x8000B9CA8000B9C6, 0x8000B9D28000B9CE, 0x000620BE003EC4EF, 0x8000B9D6003E8CE1, 0x8000B9DA003E80E3, 0x8000B9E28000B9DE, 
0x0001E1B38000B9E6, 0x8000B9EE8000B9EA, 0x8000B9F68000B9F2, 0x0001F1B50001F9B6, 0x0001B1BB8000B9FA, 0x8000B9FE0001A1BA, 0x000171BF8000BA02, 0x000191BD000199BE, 
0x000619A80001A1BC, 0x000629AA000619A9, 0x000639AC000629AB, 0x000629AE000639AD, 0x8000B99E000625AF, 0x0000198100001182, 0x8000BA060007C180, 0x8000BA0E8000BA0A, 
0x0006D1B88000BA12, 0x0006D1BA0006D1B9, 0x000751BC0006D1BB, 0x000751BE000751BD, 0x000625B0000751BF, 0x000635B2000635B1, 0x00061DB4000605B3, 0x0006FDB60006F5B5, 
0x0006A1A30006F5B7, 0x0000AC868000BA16, 0x8000BA1A00034C87, 0x0006B1A50006B9A6, 0x0006F1AB8000BA1E, 0x8000BA220006E1AA, 0x000631AF8000BA26, 0x0006D1AD0006D9AE, 
0x8000BA2A0006E1AC, 0x8000BA2E0007F1B3, 0x000781B68000BA32, 0x8000BA3A8000BA36, 0x000769BA0007E1B5, 0x8000BA3E000769BB, 0x000769BE8000BA42, 0x000769BC00075DBF, 
0x00062DA8000769BD, 0x00063DAA000635A9, 0x00062DAC000635AB, 0x000699AE000645AD, 0x8000BA46000699AF, 0x8000BA4E8000BA4A, 0x8000BA568000BA52, 0x8000BA5E8000BA5A, 
0x0006F9B88000BA62, 0x00068DBA0006F9B9, 0x00069DBC000685BB, 0x000685BE000685BD, 0x0006E9B00006B5BF, 0x0006F9B20006E9B1, 0x0006E9B40006F9B3, 0x0006C9B60006DDB5, 
0x0006B5A30006C9B7, 0x8000BA6A8000BA66, 0x8000BA728000BA6E, 0x0006A5A50006C5A6, 0x00062DAB8000BA76, 0x8000BA7A00062DAA, 0x000619AF8000BA82, 0x00062DAD00062DAE, 
0x0000518000062DAC, 0x0000618200005981, 0x8000BA7E8000B92E, 0x000178878000BA86, 0x8000BA8A000C0086, 0x8000BA928000BA8E, 0x8000BA9A8000BA96, 0x8000BAA28000BA9E, 
0x8000BAAA8000BAA6, 0x000299B38000BAAE, 0x0002B9B500039484, 0x8000BAB68000BAB2, 0x8000BABA0002B1B6, 0x0002FDBB8000BABE, 0x0002D9BD0002E1BA, 0x000319BF0002EDBC, 
0x000618E30002D1BE, 0x000644E18000BAC2, 0x8000BACA8000BAC6, 0x8000BACE000190E1, 0x8000BAD2000240E3, 0x8000BADA8000BAD6, 0x0006C4EF000224EF, 0x8000BAE28000BADE, 
0x000205A98000BAE6, 0x000215AB0002B9A8, 0x00023DAD00021DAA, 0x000251AF00023DAC, 0x0000D98000025DAE, 0x000005820000D981, 0x0003FCBE8000BAEA, 0x000CA8878000BAF2, 
0x0003F1B9000D9C86, 0x0003F1BB0003E9B8, 0x000355BD0003F9BA, 0x000355BF0003E9BC, 0x000235B1000355BE, 0x000201B3000229B0, 0x0003D1B5000235B2, 0x0003D1B7000219B4, 
0x000D44850003D9B6, 0x8000BAFA8000BAF6, 0x8000BAFE00039DA3, 0x0003B5A60003BDA5, 0x8000BB068000BB02, 0x0003E5AA8000BB0A, 0x0003E9AC0003F9AB, 0x0003D5AE0003DDAD, 
0x0002ADB600021DAF, 0x8000BB128000BB0E, 0x8000BB160002A5B5, 0x8000BB1A0002B5B3, 0x000175BE8000BB1E, 0x000169BC00017DBF, 0x000289BA000169BD, 0x8000BB22000289BB, 
0x000294E18000BB26, 0x00123CE30006DCEF, 0x8000BB2E8000BB2A, 0x8000BB3D8000BB39, 0x000F6C840007E8EF, 0x8000BB410006DCE1, 0x8000BB450006A8E3, 0x003E7CEF0006F8E3, 
0x000221A300012CE1, 0x8000BB49000000F1, 0x8000BB518000BB4D, 0x000231A5000239A6, 0x00021DAB8000BB55, 0x8000BB5900021DAA, 0x0001E9AF8000BB5D, 0x0001FDAD0001E1AE, 
0x0024218F0001FDAC, 0x8000BB618000BAEE, 0x000FF9800000C4BE, 0x00001182000FF981, 0x000000868000BB65, 0x8000BB6900038487, 0x8000BB718000BB6D, 0x8000BB798000BB75, 
0x0008DD9F8000BB7D, 0x0009F19D0008659E, 0x0034719B0035799C, 0x003089990035E19A, 0x0030E1970030D198, 0x003CED95003D7596, 0x00391993003CED94, 0x0038F9910038F192, 
0x0014A5B100269990, 0x006809B30014A5B0, 0x006805B50015E9B2, 0x8000BB81006819B4, 0x8000BB898000BB85, 0x8000BB918000BB8D, 0x000D61A38000BB95, 0x000C99A1000C8DA2, 
0x0000C5A1000D71A0, 0x0004C9A38000BB99, 0x000439A50000D1A2, 0x0018F9A70004D1A4, 0x001C01A9001801A6, 0x001C6DAB001879A8, 0x0010D1AD001CCDAA, 0x001401AF001001AC, 
0x002521820010D9AE, 0x8000BB9D0027E183, 0x003879868000BBA1, 0x00399984003D9587, 0x003DA58A00399985, 0x8000BBA5003C358B, 0x0031E18E8000BBA9, 0x0031B98C0034818F, 
0x003561920031B18D, 0x8000BBAD00347193, 0x0009CD968000BBB1, 0x0008E194000C9997, 0x000D419A00097D95, 0x8000BBB5000D5D9B, 0x8000BBBD8000BBB9, 0x000CA99C8000BBC1, 
0x000F35A88000BBC5, 0x000E81AA000E81A9, 0x000E8DAC000E9DAB, 0x000EBDAE000EB5AD, 0x00000D80000ED9AF, 0x00001D8200001581, 0x8000BBCD8000BBC9, 0x0000BC848000BBD1, 
0x000E55B8000400BE, 0x000E61BA000E5DB9, 0x000E19BC000E7DBB, 0x000E09BE000E19BD, 0x000EA9B0000E01BF, 0x000EB1B2000EB5B1, 0x000E89B4000EB1B3, 0x000E75B6000E89B5, 
0x000D09B3000E6DB7, 0x000488868000BBD9, 0x00045C840003C887, 0x000D05B5000D35B6, 0x000D71BB8000BBDD, 0x8000BBE1000D6DBA, 0x000D4DBF8000BBE5, 0x000D65BD000D4DBE, 
0x8000BBE9000D65BC, 0x8000BBED000D4DA3, 0x000D71A68000BBF1, 0x8000BBF98000BBF5, 0x000D29AA000D41A5, 0x8000BBFD000D35AB, 0x000D09AE8000BC01, 0x000D21AC000D09AF, 
0x0002A9A8000D21AD, 0x0002B9AA0002A9A9, 0x0002A9AC0002B9AB, 0x000201AE0002A9AD, 0x8000BC05000201AF, 0x8000BC0D8000BC09, 0x8000BC158000BC11, 0x8000BC1D8000BC19, 
0x0003EDB88000BC21, 0x000385BA00038DB9, 0x0003BDBC0003A5BB, 0x0003ADBE0003A5BD, 0x000241B00003A1BF, 0x000241B2000241B1, 0x000235B4000241B3, 0x0003F5B60003FDB5, 
0x000D25B70003D5B7, 0x000D11B5000D25B6, 0x000D15B3000D19B4, 0x000EE5B1000D15B2, 0x000D55BF000EE5B0, 0x000D4DBD000D4DBE, 0x000D69BB000D4DBC, 0x000D75B9000D65BA, 
0x8000BC25000D79B8, 0x8000BC2900050CBE, 0x8000BC318000BC2D, 0x8000BC398000BC35, 0x000E95AF8000BC3D, 0x000E85AD000E95AE, 0x000E95AB000E85AC, 0x000EADA9000E95AA, 
0x000F24E1000ED1A8, 0x000E38E38000BC41, 0x000038E38000BC49, 0x0001A0E18000BC4D, 0x0000E4EF8000BC51, 0x0004E4848000BC55, 0x000410868000BC59, 0x00014CEF00049487, 
0x00009D818000BC5D, 0x0003F9B300009D80, 0x0003E9B500004982, 0x8000BC658000BC61, 0x8000BC690003E1B6, 0x00034DBB8000BC6D, 0x00035DBD00034DBA, 0x0002F1BF00035DBC, 
0x8000BBD5000339BE, 0x8000BC718000BC45, 0x8000BC798000BC75, 0x8000BC818000BC7D, 0x000625A88000BC85, 0x000601AA000639A9, 0x000671AC000601AB, 0x000675AE00067DAD, 
0x000619B0000669AF, 0x000625B200062DB1, 0x0006F5B40006EDB3, 0x0006F5B60006FDB5, 0x0006D5B80006EDB7, 0x0006D5BA0006DDB9, 0x000739BC00072DBB, 0x000729BE000739BD, 
0x0006A9B3000729BF, 0x8000BC8D8000BC89, 0x8000BC958000BC91, 0x0006D9B50006DDB6, 0x0006C9BB8000BC99, 0x8000BC9D0006FDBA, 0x000619BF8000BCA1, 0x000619BD000611BE, 
0x8000BCA50006D1BC, 0x8000BCA90006EDA3, 0x000699A68000BCAD, 0x000390BE8000BCB1, 0x0006B9AA00069DA5, 0x8000BCB500068DAB, 0x000655AE8000BCB9, 0x000695AC00065DAF, 
0x00068DA800065DAD, 0x000695AA000691A9, 0x0006BDAC0006A9AB, 0x0006CDAE0006A9AD, 0x0001E9800006C5AF, 0x0001FD820001E981, 0x000190868000BCBD, 0x8000BCC10001B487, 
0x0001C5B88000BCC5, 0x0001C5BA0001CDB9, 0x0001CDBC0001DDBB, 0x0001F5BE0001FDBD, 0x000681B000019DBF, 0x000161B2000681B1, 0x000161B4000161B3, 0x000161B6000161B5, 
0x00061DB3000161B7, 0x8000BCCD8000BCC9, 0x8000BCD58000BCD1, 0x000635B5000629B6, 0x000645BB8000BCD9, 0x8000BCDD000645BA, 0x0001A5BF8000BCE1, 0x0001B5BD0001A5BE, 
0x8000BCE50001B5BC, 0x8000BCE9000659A3, 0x00066DA68000BCED, 0x8000BCF58000BCF1, 0x000601AA000671A5, 0x8000BCF9000601AB, 0x0001E1AE8000BCFD, 0x0001F1AC0001E1AF, 
0x0002EDA80001F1AD, 0x000331AA000329A9, 0x000395AC000331AB, 0x000395AE00039DAD, 0x00020C8400038DAF, 0x8000BD058000BD01, 0x8000BD0D8000BD09, 0x8000BD158000BD11, 
0x0003A9B88000BD19, 0x00006DBA0003A9B9, 0x00007DBC000065BB, 0x00006DBE000065BD, 0x0003FDB0000065BF, 0x0003C5B20003CDB1, 0x0003B9B40003ADB3, 0x0003ADB60003B9B5, 
0x0000BD800003A5B7, 0x0000198200000981, 0x8000BD218000BD1D, 0x8000BD290003D8BE, 0x001C00868000BD2D, 0x8000BD310003D487, 0x8000BD398000BD35, 0x8000BD418000BD3D, 
0x000369BB8000BD45, 0x8000BD49000359BA, 0x00031DBF8000BD4D, 0x000319BD00031DBE, 0x0003D9B3000371BC, 0x8000BD558000BD51, 0x8000BD5D8000BD59, 0x00037DB500037DB6, 
0x000609AF8000BD61, 0x0007A5AD0007C1AE, 0x0007B5AB0007A5AC, 0x8000BD650007B5AA, 0x001D6C848000BD69, 0x000711A5000719A6, 0x000701A38000BD6D, 0x8000BD758000BD71, 
0x8000BD7D8000BD79, 0x001D08BE8000BD81, 0x8000BD85001C0084, 0x8000BD89000338EF, 0x8000BD918000BD8D, 0x8000BD99000354E3, 0x00002980000044E1, 0x0000198200002981, 
0x000628E18000BD9D, 0x000630E3000794E1, 0x8000BDA100078CE3, 0x001C38868000BDA5, 0x001CE8BE001D5C87, 0x8000BDAD8000BDA9, 0x8000BDB58000BDB1, 0x000198EF8000BDB9, 
0x0002F9A3000600EF, 0x8000BDC18000BDBD, 0x8000BDC98000BDC5, 0x00025DA500025DA6, 0x000249AB8000BDCD, 0x8000BDD1000279AA, 0x00023DAF8000BDD5, 0x000239AD00023DAE, 
0x001E99A8000251AC, 0x001EA1AA001E99A9, 0x001EA1AC001EA1AB, 0x001EA1AE001EA1AD, 0x8000BD95001EA1AF, 0x8000BDDD8000BDD9, 0x8000BDE58000BDE1, 0x8000BDED8000BDE9, 
0x001F5DB88000BDF1, 0x001F7DBA001F69B9, 0x001F6DBC001F75BB, 0x001F1DBE001F15BD, 0x001EA9B0001F0DBF, 0x001E8DB2001EA9B1, 0x001E9DB4001E85B3, 0x001E85B6001E85B5, 
0x001E29B3001F65B7, 0x8000BDF98000BDF5, 0x8000BE018000BDFD, 0x001E29B5001E21B6, 0x001E6DBB8000BE05, 0x00000886001E6DBA, 0x001E41BF00002C87, 0x001E51BD001E59BE, 
0x00004980001E59BC, 0x0000598200004981, 0x8000BE09001E65A3, 0x001E6DA6001E65A5, 0x8000BE0D8000BD25, 0x001E21AA8000BE11, 0x001E15AC001E21AB, 0x001E15AE001E1DAD, 
0x001E69A8001E0DAF, 0x001E99AA001E79A9, 0x001EB5AC001E99AB, 0x001EB5AE001EBDAD, 0x8000BE15001EADAF, 0x8000BE1D8000BE19, 0x8000BE258000BE21, 0x8000BE2D8000BE29, 
0x000165B88000BE31, 0x000165BA00016DB9, 0x000165BC00017DBB, 0x000165BE00016DBD, 0x001ED5B00001D9BF, 0x001EA1B2001EA1B1, 0x001EA1B4001EA1B3, 0x001E91B6001EA9B5, 
0x001E11B3001E91B7, 0x8000BE398000BE35, 0x8000BE418000BE3D, 0x001E3DB5001E3DB6, 0x001E65BB8000BE45, 0x8000BE49001E11BA, 0x001E6DBF8000BE4D, 0x001E75BD001E65BE, 
0x8000BE51001E75BC, 0x8000BE55001E55A3, 0x001E79A68000BE59, 0x8000BE618000BE5D, 0x001E55AA001E79A5, 0x8000BE65001E21AB, 0x001E21AE8000BE69, 0x001E31AC001E29AF, 
0x0002D1A8001E31AD, 0x0002EDAA0002E5A9, 0x000335AC00032DAB, 0x000335AE00033DAD, 0x8000BE6D00032DAF, 0x8000BE798000BE71, 0x8000BE7D000260BE, 0x8000BE858000BE81, 
0x0003E9B88000BE89, 0x000389BA0003E9B9, 0x00039DBC000385BB, 0x000381BE000381BD, 0x000355B00003B5BF, 0x000355B200035DB1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 
0x00036D800003E1B7, 0x0000AD820000A581, 0x8000BE8D000269B3, 0x0003B1B60003B1B5, 0x0002E0848000BE91, 0x00039DBA8000BE95, 0x00038DBC000395BB, 0x000331BE000331BD, 
0x000225A3000331BF, 0x8000BE9D8000BE99, 0x8000BEA58000BEA1, 0x0003FDA50003FDA6, 0x0003D9AB8000BEA9, 0x000448860003D1AA, 0x00037DAF0003AC87, 0x00037DAD00037DAE, 
0x8000BEAD0003C1AC, 0x8000BEB58000BEB1, 0x0003A0E38000BEB9, 0x0001A8E18000BEBD, 0x0003F4EF8000BEC1, 0x8000BEC98000BEC5, 0x8000BED18000BECD, 0x8000BED98000BED5, 
0x000079808000BEDD, 0x00001D8200007981, 0x001E60E300024084, 0x001FE0E18000BEE1, 0x001ED0EF000550BE, 0x0004C8868000BEE9, 0x8000BEED00054087, 0x8000BEF58000BEF1, 
0x8000BEFD8000BEF9, 0x8000BF058000BF01, 0x8000BF0D8000BF09, 0x8000BF158000BF11, 0x0005A484001EC4EF, 0x8000BF19001E24E1, 0x8000BF1D001EF0E3, 0x8000BF258000BF21, 
0x0001F5B38000BF29, 0x8000BF318000BF2D, 0x8000BF398000BF35, 0x0001E5B5000145B6, 0x000129BB8000BF3D, 0x8000BF41000121BA, 0x0000F1BF8000BF45, 0x000129BD000129BE, 
0x000629A8000131BC, 0x00063DAA000635A9, 0x00062DAC000635AB, 0x000685AE000685AD, 0x8000BEE50006B9AF, 0x00001D8100001D82, 0x8000BF4900001D80, 0x8000BF518000BF4D, 
0x00074DB8000330BE, 0x000755BA000751B9, 0x000779BC000769BB, 0x000769BE000779BD, 0x0006A5B0000769BF, 0x0006A5B20006ADB1, 0x0006ADB40006BDB3, 0x00077DB6000775B5, 
0x0006B5A3000775B7, 0x000028868000BF55, 0x8000BF5900034C87, 0x0006A5A5000605A6, 0x000669AB8000BF5D, 0x8000BF61000661AA, 0x0007B1AF8000BF65, 0x000669AD000669AE, 
0x8000BF69000671AC, 0x0007BDB38000BF6D, 0x0007ADB58000BF71, 0x8000BF798000BF75, 0x8000BE7500075DB6, 0x000779BB8000BF7D, 0x000769BD000761BA, 0x000749BF000761BC, 
0x000665A8000755BE, 0x00067DAA000675A9, 0x00066DAC000675AB, 0x00069DAE000695AD, 0x8000BF81000695AF, 0x8000BF898000BF85, 0x8000BF918000BF8D, 0x8000BF998000BF95, 
0x0006FDB88000BF9D, 0x000681BA000681B9, 0x000681BC000681BB, 0x0006B1BE000689BD, 0x0006EDB00006B1BF, 0x0006FDB20006F5B1, 0x0006D9B40006F5B3, 0x0006CDB60006C5B5, 
0x0006F5A30006C5B7, 0x8000BFA58000BFA1, 0x8000BFAD8000BFA9, 0x0006E5A5000615A6, 0x000631AB8000BFB1, 0x8000BFB5000629AA, 0x000601AF8000BFB9, 0x000621AD00061DAE, 
0x00006D80000629AC, 0x0000198200000981, 0x8000BFC18000BFBD, 0x000190BE00019884, 0x000F40868000BFC9, 0x8000BFCD0000F487, 0x8000BFD58000BFD1, 0x8000BFDD8000BFD9, 
0x000291A88000BFE1, 0x0002A1AA000299A9, 0x0002D1AC0002A1AB, 0x0002D5AE0002D1AD, 0x8000BFE50002C9AF, 0x8000BFED8000BFE9, 0x8000BFF100032084, 0x8000BFF98000BFF5, 
0x000379B88000BFFD, 0x0003CDBA000379B9, 0x0003DDBC0003C5BB, 0x0003C5BE0003C5BD, 0x0002B9B00003F5BF, 0x000349B2000281B1, 0x000359B4000349B3, 0x000349B6000359B5, 
0x000229B3000349B7, 0x8000C0058000C001, 0x000C9CBE8000C009, 0x000259B5000251B6, 0x000245BB8000C00D, 0x8000C01100027DBA, 0x00039DBF8000C015, 0x00039DBD00039DBE, 
0x8000C01900039DBC, 0x8000C01D00026DA3, 0x000215A68000C021, 0x8000C0298000C025, 0x000239AA00021DA5, 0x8000C02D000201AB, 0x0003D9AE8000C031, 0x0003D9AC0003D9AF, 
0x000190E10003D9AD, 0x0000CCE38000C039, 0x0001C980000D1884, 0x0001F5820001FD81, 0x000C2CBE8000C03D, 0x8000C0458000C041, 0x8000C04D8000C049, 0x000018EF8000C051, 
0x000CE0868000C055, 0x8000C0590002F487, 0x8000C0618000C05D, 0x8000C0698000C065, 0x8000C06D0006F8EF, 0x8000C071000794E1, 0x8000C075000630E3, 0x8000C07D8000C079, 
0x8000C0858000C081, 0x8000C08D8000C089, 0x8000C0958000C091, 0x8000C09D8000C099, 0x00700085000158EF, 0x8000C0A10006D4E1, 0x0000258000061CE3, 0x0000118200002D81, 
0x00022DB38000C0A9, 0x000CE887000000F1, 0x8000C0AD000F6C86, 0x00022DB500022DB6, 0x0001C9BB8000C0B1, 0x8000C0B50001C1BA, 0x0001CDBF8000C0B9, 0x0001CDBD0001CDBE, 
0x000DDDA80001CDBC, 0x000DE5AA000DEDA9, 0x000DE5AC000DFDAB, 0x000DE5AE000DEDAD, 0x8000C035000E3DAF, 0x8000C0BD8000C0A5, 0x8000C0C58000C0C1, 0x8000C0CD8000C0C9, 
0x000ECDB88000C0D1, 0x000EE1BA000ED9B9, 0x000E91BC000EE1BB, 0x000E95BE000E9DBD, 0x000E45B0000E89BF, 0x000E59B2000E4DB1, 0x000E49B4000E59B3, 0x000EFDB6000E49B5, 
0x000D6DA3000EF5B7, 0x8000C0D98000C0D5, 0x8000C0E18000C0DD, 0x000D6DA5000D6DA6, 0x000E89AB8000C0E5, 0x8000C0E9000E81AA, 0x000E8DAF8000C0ED, 0x000E8DAD000E8DAE, 
0x000FEDB5000E8DAC, 0x8000C0F58000C0F1, 0x8000C0F9000FFDB6, 0x000FFDB38000C0FD, 0x000FB5BD8000C101, 0x000F89BF000FB5BC, 0x8000C105000FB5BE, 0x000FB5BB8000BFC5, 
0x000E05A8000FB5BA, 0x000E2DAA000E19A9, 0x000E3DAC000E25AB, 0x000E2DAE000E25AD, 0x00000D80000E21AF, 0x00001D8200001581, 0x8000C10D8000C109, 0x000230848000C111, 
0x000E35B8000130BE, 0x000E35BA000E3DB9, 0x000ED5BC000ECDBB, 0x000ED5BE000EDDBD, 0x000E29B0000ECDBF, 0x000E39B2000E29B1, 0x000E29B4000E39B3, 0x000E11B6000E15B5, 
0x000EA5A3000E0DB7, 0x000728868000C119, 0x8000C11D00014C87, 0x000EB5A5000EA5A6, 0x000EEDAB8000C121, 0x8000C125000EEDAA, 0x000ED1AF8000C129, 0x000EEDAD000EEDAE, 
0x8000C12D000EEDAC, 0x8000C131000E19B3, 0x0001F9B68000C135, 0x8000C13D8000C139, 0x0001D5BA000E31B5, 0x8000C1410001DDBB, 0x000179BE8000C145, 0x0001C5BC000179BF, 
0x000DBDA8000179BD, 0x000DD5AA000DD5A9, 0x000DFDAC000DE5AB, 0x000235AE00023DAD, 0x8000C14900022DAF, 0x8000C1518000C14D, 0x8000C1598000C155, 0x8000C1618000C15D, 
0x0002E9B88000C165, 0x00028DBA0002E9B9, 0x000281BC000285BB, 0x000285BE000281BD, 0x000255B00002ADBF, 0x000255B200025DB1, 0x0002F9B40002E9B3, 0x0002E9B60002F9B5, 
0x000D5DA30002E1B7, 0x8000C16D8000C169, 0x8000C1758000C171, 0x000D75A50002BDA6, 0x000299AB8000C179, 0x8000C17D000291AA, 0x00023DAF8000C181, 0x00023DAD00023DAE, 
0x00005D80000281AC, 0x0000658200006D81, 0x8000C189000351B3, 0x000319B6000379B5, 0x00036CBE0002DC84, 0x00033DBA8000C18D, 0x000319BC000335BB, 0x0000D9BE000319BD, 
0x00029DA30000D9BF, 0x000568868000C191, 0x8000C1950002BC87, 0x0002B5A50002D5A6, 0x0002F9AB8000C199, 0x000220840002F1AA, 0x000115AF8000C19D, 0x0002D5AD000115AE, 
0x8000C1A10002D5AC, 0x000F20EF8000C1A5, 0x8000C1AD8000C1A9, 0x8000C1B58000C1B1, 0x8000C1BD8000C1B9, 0x8000C1C58000C1C1, 0x000C88E18000C1C9, 0x000F44E38000C1CD, 
0x8000C1D58000C1D1, 0x8000C1DD8000C1D9, 0x00041CBE8000C1E1, 0x00005CEF8000C1E5, 0x000E74E1000E44EF, 0x000080E3000EFCE1, 0x00000D80000EB0E3, 0x0000718200007581, 
0x8000C1ED8000C1E9, 0x8000C1F10000C1B3, 0x0000FDB68000C1F9, 0x8000C2018000C1FD, 0x0000ADBA0000C1B5, 0x0004C8860000B5BB, 0x0000ADBE0004A087, 0x0000ADBC000095BF, 
0x000585A80000A5BD, 0x000595AA000595A9, 0x0005BDAC0005A5AB, 0x0005D1AE0005D5AD, 0x8000C1850005D1AF, 0x8000C2058000C1F5, 0x8000C20D8000C209, 0x8000C2158000C211, 
0x000671B88000C219, 0x000671BA000671B9, 0x0006D5BC000671BB, 0x0006D5BE0006DDBD, 0x0005B5B00006CDBF, 0x000581B20005BDB1, 0x000651B4000581B3, 0x000651B6000651B5, 
0x0007EDB8000651B7, 0x0007F5BA0007F1B9, 0x000715BC00070DBB, 0x000715BE00071DBD, 0x0007EDB0000709BF, 0x0007FDB20007F5B1, 0x0007EDB40007F5B3, 0x0007DDB60007D5B5, 
0x000611A80007D5B7, 0x0007CDAA000621A9, 0x0007CDAC0007DDAB, 0x000799AE0007F9AD, 0x8000C21D000799AF, 0x8000C2258000C221, 0x8000C22D8000C229, 0x8000C1158000C231, 
0x000605A38000C235, 0x8000C23D8000C239, 0x8000C2458000C241, 0x000605A5000639A6, 0x000671AB8000C249, 0x8000C24D000669AA, 0x000651AF8000C251, 0x000661AD000669AE, 
0x8000C255000669AC, 0x00001D8100001D82, 0x8000C25900001D80, 0x8000C2618000C25D, 0x0001AC84000194BE, 0x0001E8878000C265, 0x8000C269007C0086, 0x8000C2718000C26D, 
0x00064DA88000C275, 0x000651AA000651A9, 0x0001BDAC0001A5AB, 0x0001ADAE0001A5AD, 0x8000C2790001A5AF, 0x8000C2818000C27D, 0x8000C2898000C285, 0x8000C2918000C28D, 
0x0000C5B88000C295, 0x0000C5BA0000CDB9, 0x0000CDBC0000DDBB, 0x0000F5BE0000FDBD, 0x0001DDB000009DBF, 0x00010DB2000105B1, 0x00011DB4000105B3, 0x00010DB6000105B5, 
0x0005D9B3000101B7, 0x8000C29D8000C299, 0x8000C2A58000C2A1, 0x000235B5000225B6, 0x0002C1BB8000C2A9, 0x8000C2AD000219BA, 0x0002C1BF8000C2B1, 0x0002D1BD0002D9BE, 
0x8000C2B50002D9BC, 0x8000C2B900059DA3, 0x000261A68000C2BD, 0x8000C2C58000C2C1, 0x00025DAA000271A5, 0x8000C2C9000285AB, 0x00029DAE8000C2CD, 0x00029DAC000285AF, 
0x0000E980000295AD, 0x000005820000E981, 0x0003DCBE8000C2D1, 0x8000C2D900035884, 0x007C00868000C2DD, 0x8000C2E10003EC87, 0x8000C2E98000C2E5, 0x8000C2F18000C2ED, 
0x8000C2F98000C2F5, 0x8000C3018000C2FD, 0x8000C3098000C305, 0x0002B0EF8000C30D, 0x000194E18000C311, 0x00026CE38000C315, 0x8000C31D8000C319, 0x8000C3258000C321, 
0x000279B38000C329, 0x8000C3318000C32D, 0x8000C3398000C335, 0x0002B9B50002B1B6, 0x000295BB8000C33D, 0x8000C341000295BA, 0x000139BF007D6484, 0x000285BD000131BE, 
0x00006982000285BC, 0x0000598000075CEF, 0x8000C34900005181, 0x007D68878000C34D, 0x007D2CBE007CFC86, 0x8000C3558000C351, 0x007C3C848000C359, 0x8000C35D0007B8E3, 
0x8000C3610004ECE1, 0x8000C3698000C365, 0x8000C36D007FC084, 0x00003CEF8000C371, 0x000650E10006F4EF, 0x0000D8E30006B4E1, 0x8000C375000694E3, 0x8000C37D8000C379, 
0x0002B9A38000C381, 0x8000C3898000C385, 0x8000C3918000C38D, 0x000279A5000271A6, 0x000255AB8000C395, 0x8000C399000255AA, 0x0001F9AF8000C39D, 0x000245AD0001F1AE, 
0x007E99A8000245AC, 0x007EA1AA007E99A9, 0x007EA1AC007EA1AB, 0x007EA1AE007EA1AD, 0x8000C3A1007EA1AF, 0x8000C3A98000C3A5, 0x000019808000C3AD, 0x0000058200001981, 
0x007EADB88000C3B1, 0x007EBDBA007EB5B9, 0x007EADBC007EB5BB, 0x007F51BE007F51BD, 0x007EA1B0007F51BF, 0x007EA1B2007EA1B1, 0x007EA1B4007EA1B3, 0x007EA5B6007EA1B5, 
0x8000C2D5007E99B7, 0x0003C0BE007E2DB3, 0x007E25B68000C345, 0x8000C3B98000C3B5, 0x007E61BA007E2DB5, 0x00000886007E61BB, 0x007E61BE00009C87, 0x007E71BC007E61BF, 
0x007E69A3007E71BD, 0x8000C3C18000C3BD, 0x8000C3C98000C3C5, 0x007E69A5007E61A6, 0x007E25AB8000C3CD, 0x8000C3D1007E25AA, 0x007E25AF8000C3D5, 0x007E35AD007E25AE, 
0x007E51A8007E35AC, 0x007E6DAA007E51A9, 0x007E7DAC007E65AB, 0x007E99AE007E6DAD, 0x8000C3D9007E99AF, 0x8000C3E18000C3DD, 0x8000C3E98000C3E5, 0x8000C3F18000C3ED, 
0x007E89B88000C3F5, 0x007E99BA007E89B9, 0x007EB9BC007E91BB, 0x000179BE007EB9BD, 0x007EE9B0000179BF, 0x007EFDB2007EF5B1, 0x007EC5B4007EDDB3, 0x007EC5B6007ECDB5, 
0x007EE5B3007EB9B7, 0x8000C3FD8000C3F9, 0x8000C4058000C401, 0x007EF5B5007EEDB6, 0x007E31BB8000C409, 0x8000C40D007E2DBA, 0x007E09BF8000C411, 0x007E09BD007E01BE, 
0x8000C415007E29BC, 0x8000C419007EA1A3, 0x007EA9A68000C41D, 0x000190BE8000C421, 0x007E69AA007EB1A5, 0x0007EC85007E75AB, 0x007E45AE8000C429, 0x007E6DAC007E4DAF, 
0x000299A8007E4DAD, 0x0002C1AA0002C1A9, 0x0002C1AC0002C1AB, 0x0002F1AE0002C9AD, 0x000584860002F1AF, 0x8000C42D00037887, 0x0003F9808000C431, 0x0003ED820003F981, 
0x0003C5B88000C435, 0x0003C5BA0003CDB9, 0x0003CDBC0003DDBB, 0x0003F5BE0003FDBD, 0x000341B000039DBF, 0x000341B2000341B1, 0x000341B4000341B3, 0x000341B6000341B5, 
0x000249B3000341B7, 0x8000C43D8000C439, 0x8000C4458000C441, 0x000249B5000249B6, 0x000385BB8000C449, 0x8000C44D000385BA, 0x000385BF8000C451, 0x000395BD000385BE, 
0x8000C455000395BC, 0x8000C45900020DA3, 0x00020DA68000C45D, 0x8000C4658000C461, 0x0003C1AA00020DA5, 0x8000C4690003C1AB, 0x0003C1AE8000C46D, 0x0003D1AC0003C1AF, 
0x007E60E30003D1AD, 0x007E4CE1007FBCE1, 0x0001A0E1007E30E3, 0x007E84E30000E8E1, 0x0007ACBE0017C4E3, 0x000008EF8000C471, 0x000140EF001C7CEF, 0x8000C4798000C475, 
0x8000C47D007EA4EF, 0x000404848000C481, 0x8000C4850006C0BE, 0x00003D8100003D82, 0x8000C48900003D80, 0x8000C4918000C48D, 0x000750868000C499, 0x8000C49D00058487, 
0x007DC1BB8000C4A1, 0x007DA1B9007DA9BA, 0x007DC9BF007D91B8, 0x007DD5BD007DC1BE, 0x007E1DB3007DD5BC, 0x007E1DB1007E1DB2, 0x007DA1B7007E1DB0, 0x007DB1B5007DB9B6, 
0x007EBDAB007DB9B4, 0x007EBDA9007EBDAA, 0x007E7DAF007EBDA8, 0x007E7DAD007E7DAE, 0x8000C4A5007E7DAC, 0x8000C4AD8000C4A9, 0x8000C4B58000C4B1, 0x8000C4BD8000C4B9, 
0x006C05820006B0BE, 0x8000C425006C1983, 0x0068F9868000C495, 0x006819840074C987, 0x0074018A00681985, 0x8000C4C10074B98B, 0x0070B58E8000C4C5, 0x0070D98C007CC18F, 
0x007C619200701D8D, 0x8000C4C9007C6193, 0x007875968000C4CD, 0x0078A19400793197, 0x0004E19A00787D95, 0x8000C4D10004E99B, 0x8000C4D98000C4D5, 0x0004ED9C8000C4DD, 
0x000089A18000C4E1, 0x000C01A38000C4E5, 0x000C15A5000081A2, 0x0008B9A7000CB5A4, 0x0009F9A9000801A6, 0x001425AB000881A8, 0x001001AD00142DAA, 0x001199AF001421AC, 
0x001CE1B100109DAE, 0x001801B3001C01B0, 0x0018F5B5001C65B2, 0x8000C4E90018F5B4, 0x8000C4F18000C4ED, 0x8000C4F98000C4F5, 0x000019808000C4FD, 0x0000058200001981, 
0x000729A98000C501, 0x000735AB0004E9A8, 0x000799AD000721AA, 0x000789AF000791AC, 0x007845A0000791AE, 0x0005A5A20005A5A1, 0x0001B8840005B9A3, 0x000034878000C509, 
0x0007ADB9000F9C86, 0x00067DBB0007ADB8, 0x000611BD000669BA, 0x000609BF00066DBC, 0x0007C9B1000619BE, 0x0007A9B30007F9B0, 0x0007BDB50007C1B2, 0x0007A1B70007BDB4, 
0x0007ADB30007A9B6, 0x8000C5118000C50D, 0x8000C51500000C84, 0x00071DB500071DB6, 0x000709BB006D998F, 0x8000C519000739BA, 0x00077DBF8000C51D, 0x000779BD00077DBE, 
0x0071E198000711BC, 0x007D3D9A00714199, 0x007DF59C007DED9B, 0x0079F99E00792D9D, 0x006DFD900079F99F, 0x0069ED920069E591, 0x00752D9400690593, 0x007565960075D595, 
0x00042DA300711D97, 0x000DC0BE000DC884, 0x8000C5258000C521, 0x00049DA500049DA6, 0x000489AB8000C529, 0x8000C52D0004B9AA, 0x0004FDAF8000C531, 0x0004F9AD0004FDAE, 
0x8000C535000491AC, 0x8000C539000539B3, 0x0005B9B68000C53D, 0x8000C5458000C541, 0x000595BA0005B9B5, 0x8000C54900059DBB, 0x000239BE8000C54D, 0x000251BC000239BF, 
0x0005EDA8000251BD, 0x0005F5AA0005FDA9, 0x000575AC00056DAB, 0x000575AE00057DAD, 0x8000C55100056DAF, 0x8000C5598000C555, 0x8000C5618000C55D, 0x8000C5698000C565, 
0x0002B1B88000C56D, 0x0002B5BA0002B1B9, 0x000209BC000249BB, 0x000239BE000209BD, 0x000515B0000239BF, 0x0002C1B200051DB1, 0x0002B9B40002C1B3, 0x000291B60002B9B5, 
0x00047DA3000291B7, 0x0001B58100001582, 0x8000C5710001B580, 0x0004FDA50004FDA6, 0x0004D9AB8000C579, 0x000D28860004D1AA, 0x00037DAF000D1C87, 0x000315AD00037DAE, 
0x8000C57D000315AC, 0x8000C5858000C581, 0x8000C5890002C5B3, 0x0002F5B60002FDB5, 0x8000C5918000C58D, 0x000175BA8000C595, 0x00015DBC000145BB, 0x000131BE000135BD, 
0x0000A0E3000131BF, 0x0006E0E10006DCE3, 0x8000C5990007B4E1, 0x8000C5A18000C59D, 0x000C8086000F90BE, 0x8000C5A5000C1887, 0x000604EF8000C5A9, 0x8000C5AD00066CEF, 
0x000249A38000C5B1, 0x8000C5B98000C5B5, 0x8000C5C18000C5BD, 0x000271A5000279A6, 0x0001C9AB8000C5C5, 0x8000C5C90001F9AA, 0x0001BDAF8000C5CD, 0x0001B9AD0001BDAE, 
0x000D35A80001D1AC, 0x000D81AA000D81A9, 0x000DB9AC000D9DAB, 0x000E15AE000DB9AD, 0x8000C575000E0DAF, 0x8000C5D58000C5D1, 0x00001D808000C5D9, 0x0000B98200000981, 
0x000E29B88000C5DD, 0x000EE9BA000E29B9, 0x000EF9BC000EE9BB, 0x000EE9BE000EF9BD, 0x000E7DB0000EE9BF, 0x000E45B2000E4DB1, 0x000E39B4000E2DB3, 0x000E2DB6000E39B5, 
0x8000C5E1000E25B7, 0x8000C5058000C5E5, 0x8000C5ED8000C5E9, 0x8000C5F58000C5F1, 0x000FBDA88000C5F9, 0x000FEDAA000FE5A9, 0x000FE1AC000FE5AB, 0x000FD9AE000FE9AD, 
0x000F51B0000FD9AF, 0x000F51B2000F51B1, 0x000F7DB4000F65B3, 0x000F65B6000F6DB5, 0x000F29B8000F19B7, 0x000F39BA000F29B9, 0x000F19BC000F31BB, 0x0000DDBE000F19BD, 
0x000E45B30000D5BF, 0x8000C6018000C5FD, 0x8000C6098000C605, 0x000E49B5000E49B6, 0x000EB5BB8000C60D, 0x8000C611000EB5BA, 0x000E89BF8000C615, 0x000E91BD000E99BE, 
0x8000C619000EA5BC, 0x8000C61D000E01A3, 0x000E0DA68000C621, 0x8000C6298000C625, 0x000EF1AA000E0DA5, 0x8000C62D000EF1AB, 0x000EDDAE8000C631, 0x000EE1AC000ECDAF, 
0x00010DA8000ED5AD, 0x00011DAA000115A9, 0x00010DAC000115AB, 0x000091AE000091AD, 0x8000C635000091AF, 0x8000C63D8000C639, 0x8000C6458000C641, 0x0003B1810003B982, 
0x000099B80003B980, 0x0000A5BA0000ADB9, 0x000075BC00006DBB, 0x000075BE00007DBD, 0x0000F1B000006DBF, 0x0000C1B20000F9B1, 0x0000B1B40000C1B3, 0x0000B5B60000BDB5, 
0x0002AC840000A9B7, 0x8000C64D8000C649, 0x0004B0868000C651, 0x8000C6590002D887, 0x8000C6618000C65D, 0x8000C6698000C665, 0x000374BE8000C66D, 0x8000C6758000C671, 
0x00035DBB8000C679, 0x8000C67D000355BA, 0x000319BF8000C681, 0x000375BD000315BE, 0x0002F5B3000375BC, 0x8000C6898000C685, 0x8000C6918000C68D, 0x0002E5B5000371B6, 
0x000215A38000C695, 0x8000C69D8000C699, 0x8000C6A58000C6A1, 0x000205A5000391A6, 0x0003BDAB8000C6A9, 0x8000C6AD0003B5AA, 0x0003F9AF8000C6B1, 0x000395AD0003F5AE, 
0x8000C6B5000395AC, 0x00001D8100001D82, 0x8000C6B900001D80, 0x8000C6C18000C6BD, 0x00036C848000C6C9, 0x000378878000C6CD, 0x8000C6D10004EC86, 0x8000C6D98000C6D5, 
0x000EB8E18000C6DD, 0x000318E3000C98E3, 0x8000C6E1000C28E1, 0x8000C6E98000C6E5, 0x0004EC848000C6ED, 0x8000C6F58000C6F1, 0x8000C6FD8000C6F9, 0x000E5CEF000A30EF, 
0x000161B38000C701, 0x8000C7098000C705, 0x8000C7118000C70D, 0x000171B5000179B6, 0x000129BB8000C715, 0x8000C719000159BA, 0x00011DBF8000C71D, 0x00011DBD00011DBE, 
0x8000C721000131BC, 0x8000C7298000C725, 0x000019808000C72D, 0x0000398200001981, 0x8000C731000F6CEF, 0x000460BE000E94E1, 0x8000C739000FB8E3, 0x8000C7418000C73D, 
0x0004E086000000EF, 0x0001E9A300048C87, 0x0001F9A500070084, 0x8000C7498000C745, 0x8000C74D0001F1A6, 0x0001A1AB8000C751, 0x000195AD0001D1AA, 0x000195AF0001B9AC, 
0x000619A8000195AE, 0x000629AA000619A9, 0x000639AC000629AB, 0x00062DAE000639AD, 0x8000C6C5000625AF, 0x8000C7558000C735, 0x8000C75D8000C759, 0x8000C7658000C761, 
0x0006C5B88000C769, 0x0006C5BA0006CDB9, 0x0006CDBC0006DDBB, 0x0006F5BE0006FDBD, 0x00065DB000069DBF, 0x000625B200062DB1, 0x000619B4000609B3, 0x000609B6000619B5, 
0x8000C76D000601B7, 0x8000C7758000C771, 0x8000C77D8000C779, 0x8000C7858000C781, 0x00067DA88000C655, 0x000659AA000641A9, 0x000649AC000659AB, 0x0007A9AE000649AD, 
0x0007D9B00007A9AF, 0x0007EDB20007D9B1, 0x0007FDB40007E5B3, 0x0007E5B60007E5B5, 0x0007A9B8000799B7, 0x0007B9BA0007A9B9, 0x000799BC0007B1BB, 0x000779BE000799BD, 
0x0007F1B3000779BF, 0x8000C78D8000C789, 0x8000C7958000C791, 0x0007E1B50007E9B6, 0x00063DBB8000C799, 0x8000C79D00063DBA, 0x000601BF8000C7A1, 0x000611BD000619BE, 
0x00006D82000619BC, 0x000055800007B5A3, 0x0007ADA600006581, 0x8000C7A500019CBE, 0x000679AA0007A5A5, 0x001C0086000679AB, 0x00065DAE0001CC87, 0x00065DAC000645AF, 
0x000631A8000655AD, 0x000631AA000631A9, 0x000649AC000659AB, 0x00067DAE000675AD, 0x8000C7A90001B5AF, 0x8000C7B18000C7AD, 0x8000C7B98000C7B5, 0x8000C7C18000C7BD, 
0x00014DB88000C7C5, 0x00015DBA000155B9, 0x0000D5BC000155BB, 0x0000D5BE0000DDBD, 0x0001CDB00000CDBF, 0x0001DDB20001D5B1, 0x0001CDB40001D5B3, 0x00017DB6000175B5, 
0x0005B9B3000175B7, 0x8000C7CD8000C7C9, 0x8000C7D58000C7D1, 0x0005C1B50005F5B6, 0x000211BB8000C7D9, 0x8000C7DD000209BA, 0x0002B1BF8000C7E1, 0x000201BD000209BE, 
0x8000C7E5000209BC, 0x8000C7E90005FDA3, 0x0005B1A68000C7ED, 0x8000C7F58000C7F1, 0x00024DAA000585A5, 0x8000C7F9000255AB, 0x00024DAE8000C7FD, 0x00024DAC0002F5AF, 
0x8000C801000245AD, 0x8000C8098000C805, 0x8000C8118000C80D, 0x8000C8190003D8BE, 0x000029808000C81D, 0x0000398200002981, 0x001C108600032084, 0x8000C82100038487, 
0x8000C8298000C825, 0x8000C8318000C82D, 0x8000C8398000C835, 0x8000C83D000268E3, 0x8000C8410001ACE1, 0x8000C845000288EF, 0x8000C84D8000C849, 0x8000C8558000C851, 
0x8000C85D8000C859, 0x8000C8658000C861, 0x0007E0E38000C869, 0x000710E18000C86D, 0x0007E8EF8000C871, 0x8000C8798000C875, 0x000019808000C87D, 0x0000058200001981, 
0x0002E9B38000C881, 0x001CE886001D0C84, 0x8000C889001D8087, 0x0002E9B50002E1B6, 0x000169BB8000C88D, 0x001D24BE000161BA, 0x000159BF8000C891, 0x000169BD000169BE, 
0x8000C895000171BC, 0x8000C89D8000C899, 0x8000C8A58000C8A1, 0x000034EF8000C8A9, 0x000678E10006CCEF, 0x000674E3000750E1, 0x8000C8AD00069CE3, 0x8000C8B58000C8B1, 
0x000269A38000C8B9, 0x001C84848000C8BD, 0x8000C8C1001C84BE, 0x000269A5000261A6, 0x0001E9AB8000C8C5, 0x8000C8C90001E1AA, 0x0001D9AF8000C8CD, 0x0001E9AD0001E9AE, 
0x001E99A80001F1AC, 0x001EB1AA001E99A9, 0x001ED1AC001EB1AB, 0x001ED1AE001ED1AD, 0x8000C8D1001ED1AF, 0x8000C8D98000C8D5, 0x8000C8E18000C8DD, 0x8000C8E98000C8E5, 
0x001EBDB88000C8ED, 0x001F4DBA001F45B9, 0x001F5DBC001F45BB, 0x001F45BE001F41BD, 0x001EB1B0001F79BF, 0x001E89B2001EBDB1, 0x001E9DB4001E85B3, 0x001E8DB6001E85B5, 
0x8000C815001E85B7, 0x8000C8F1001E3DB3, 0x001E55B68000C885, 0x8000C8F98000C8F5, 0x001E71BA001E5DB5, 0x00000886001E7DBB, 0x001E5DBE00002887, 0x001E59BC001E45BF, 
0x001E79A3001E55BD, 0x0000F58100004D82, 0x8000C8FD0000F580, 0x001E19A5001E11A6, 0x001E39AB8000C901, 0x8000C905001E35AA, 0x001E01AF8000C909, 0x001E11AD001E19AE, 
0x001E51A8001E1DAC, 0x001E65AA001E59A9, 0x001E95AC001E8DAB, 0x001E95AE001E9DAD, 0x8000C90D001E8DAF, 0x8000C9158000C911, 0x8000C91D8000C919, 0x8000C9258000C921, 
0x001EA9B88000C929, 0x000169BA001EA9B9, 0x000179BC000169BB, 0x000169BE000179BD, 0x001EF5B0000169BF, 0x001EDDB2001ED5B1, 0x001ECDB4001ED5B3, 0x001EA9B6001EB1B5, 
0x001EEDB3001EA1B7, 0x8000C9318000C92D, 0x8000C9398000C935, 0x001E1DB5001E1DB6, 0x001E11BB8000C93D, 0x8000C941001E31BA, 0x001E75BF8000C945, 0x001E01BD001E09BE, 
0x8000C949001E09BC, 0x8000C94D001EA9A3, 0x001E59A68000C951, 0x8000C9598000C955, 0x001E75AA001E59A5, 0x8000C95D001E55AB, 0x001E4DAE8000C961, 0x001E4DAC001E31AF, 
0x000299A8001E45AD, 0x0002D5AA0002D5A9, 0x0002FDAC0002E5AB, 0x00033DAE000335AD, 0x00026CBE000335AF, 0x8000C96D8000C969, 0x8000C9758000C971, 0x8000C97D8000C979, 
0x0003D1B88000C981, 0x0003E1BA0003D9B9, 0x000391BC0003E1BB, 0x000395BE00039DBD, 0x00034DB0000389BF, 0x00035DB2000355B1, 0x00034DB4000355B3, 0x0003F1B60003F1B5, 
0x000369810003F1B7, 0x000255B300035D80, 0x00027DB500036182, 0x8000C9898000C985, 0x0002E4840003BDB6, 0x000399BB8000C98D, 0x000389BD000381BA, 0x00033DBF000381BC, 
0x00021DA3000381BE, 0x000398878000C991, 0x8000C99500046C86, 0x000235A50003F5A6, 0x0003D1AB8000C999, 0x8000C99D0003C9AA, 0x000375AF8000C9A1, 0x0003C1AD0003C9AE, 
0x001ED8E30003C9AC, 0x001E58E1001FACE1, 0x0001A0E1001E58E3, 0x0003A8E38000C9A5, 0x8000C9AD8000C9A9, 0x0003F0EF8000C9B1, 0x001E04EF8000C9B5, 0x8000C9BD8000C9B9, 
0x8000C9C1001EACEF, 0x00051C848000C9C5, 0x00000D80000500BE, 0x00003D8200003581, 0x8000C9CD8000C9C9, 0x0004C8868000C9D1, 0x8000C9D90005A087, 0x8000C9E18000C9DD, 
0x001DD5BA8000C9E5, 0x001DC1B8001DDDBB, 0x001D11BE001DC1B9, 0x001DF1BC001D11BF, 0x001DADB2001DF1BD, 0x001DADB0001DB5B3, 0x001D9DB6001DA5B1, 0x001DA5B4001DF5B7, 
0x001E69AA001D95B5, 0x001E69A8001E69AB, 0x001E69AE001E69A9, 0x001E69AC001E69AF, 0x8000C9E9001E69AD, 0x8000C9F18000C9ED, 0x8000C9F98000C9F5, 0x8000CA018000C9FD, 
0x000625A88000CA05, 0x000625AA00062DA9, 0x000625AC00063DAB, 0x000625AE00062DAD, 0x8000C9D5000689AF, 0x8000CA0D8000CA09, 0x8000CA158000CA11, 0x8000CA1D8000CA19, 
0x00075DB88000CA21, 0x00076DBA000765B9, 0x000765BC000761BB, 0x000719BE00076DBD, 0x0006F9B0000719BF, 0x0006ADB20006C1B1, 0x0006ADB40006BDB3, 0x000695B600069DB5, 
0x0006B5B5000769B7, 0x8000CA298000CA25, 0x8000CA2D0006B5B6, 0x0006B5B38000CA31, 0x000671BD8000CA35, 0x000641BF000661BC, 0x8000C965000671BE, 0x00061DBB8000CA39, 
0x0006EDA3000625BA, 0x0000198100001982, 0x8000CA3D00007980, 0x0006EDA50006EDA6, 0x000645AB8000CA41, 0x0003A48400067DAA, 0x000619AF0003A4BE, 0x000629AD000629AE, 
0x000671A8000639AC, 0x000671AA000671A9, 0x0006F1AC000671AB, 0x0006F1AE0006F1AD, 0x8000CA450006F1AF, 0x000188868000CA49, 0x8000CA4D0001AC87, 0x8000CA558000CA51, 
0x000175B88000CA59, 0x000175BA00017DB9, 0x0001D9BC0001C9BB, 0x0001CDBE0001C5BD, 0x000691B00001C1BF, 0x000691B2000691B1, 0x000155B4000691B3, 0x000155B600015DB5, 
0x0006F9B300014DB7, 0x8000CA618000CA5D, 0x8000CA698000CA65, 0x000679B5000671B6, 0x000655BB8000CA6D, 0x8000CA71000655BA, 0x000199BF8000CA75, 0x000645BD000191BE, 
0x8000CA79000645BC, 0x8000CA7D0006BDA3, 0x000635A68000CA81, 0x8000CA898000CA85, 0x000611AA00063DA5, 0x8000CA8D000611AB, 0x0001D5AE8000CA91, 0x000601AC0001DDAF, 
0x000325A8000601AD, 0x00033DAA000335A9, 0x00032DAC000335AB, 0x000391AE000391AD, 0x8000CA95000391AF, 0x8000CA9D8000CA99, 0x8000CAA58000CAA1, 0x8000CAAD8000CAA9, 
0x000399B88000CAB1, 0x0003A5BA0003ADB9, 0x000075BC00006DBB, 0x000075BE00007DBD, 0x0003F1B000006DBF, 0x0003C1B20003F9B1, 0x0003B1B40003C1B3, 0x0003B5B60003BDB5, 
0x0000B5800003A9B7, 0x0000B5820000BD81, 0x00031087000348BE, 0x8000CAB9000C3486, 0x000CACBE0002E8EF, 0x0002A484000194E1, 0x8000CABD000214E3, 0x8000CAC58000CAC1, 
0x0003F5B38000CAC9, 0x8000CAD18000CACD, 0x8000CAD5000A7485, 0x0003E5B5000351B6, 0x00037DBB8000CAD9, 0x8000CADD000375BA, 0x000339BF8000CAE1, 0x000355BD000335BE, 
0x8000CAE5000355BC, 0x8000CAED8000CAE9, 0x8000CAF10006B8EF, 0x8000CAF98000CAF5, 0x8000CB018000CAFD, 0x8000CB098000CB05, 0x000000CC8000CB0D, 0x8000CB110007E0E1, 
0x8000CB15000664E3, 0x00027DA38000CB19, 0x00026DA500024084, 0x8000CB218000CB1D, 0x000CC0860002D9A6, 0x0002F5AB000DAC87, 0x0002DDAD0002FDAA, 0x0002B1AF0002DDAC, 
0x0000C5800002BDAE, 0x0000D1820000D181, 0x8000CB2D8000CB29, 0x8000CB358000CB31, 0x000CEC84000188EF, 0x8000CB390006D4E1, 0x8000CB3D000154E3, 0x8000CB458000CB41, 
0x000175B38000CB49, 0x8000CB518000CB4D, 0x8000CB598000CB55, 0x000165B5000111B6, 0x000109BB8000CB5D, 0x8000CB61000139BA, 0x0000F9BF8000CB65, 0x0000F9BD0000F1BE, 
0x000E99A8000111BC, 0x000EBDAA000EB5A9, 0x000EADAC000EB5AB, 0x000ED1AE000ED1AD, 0x8000CB25000ECDAF, 0x8000CB6D8000CB69, 0x8000CB758000CB71, 0x8000CB7D8000CB79, 
0x000F59B88000CB81, 0x000F69BA000F59B9, 0x000F79BC000F69BB, 0x000F61BE000F79BD, 0x000EBDB0000F1DBF, 0x000E85B2000E8DB1, 0x000F75B4000F6DB3, 0x000F69B6000F7DB5, 
0x000E35A3000F69B7, 0x8000CB898000CB85, 0x8000CB918000CB8D, 0x000E25A5000E51A6, 0x000E49AB0003D4BE, 0x8000CB95000E79AA, 0x000FB9AF8000CB99, 0x000FB9AD000FB1AE, 
0x00005182000E51AC, 0x000041808000CAB5, 0x0003188700004181, 0x8000CB9D00007486, 0x8000CBA58000CBA1, 0x8000CBAD8000CBA9, 0x8000CBB58000CBB1, 0x8000CBBD8000CBB9, 
0x000E8DA88000CBC1, 0x000E9DAA000E95A9, 0x000EB9AC000E95AB, 0x000EADAE000EA5AD, 0x8000CBC5000EA5AF, 0x8000CBCD8000CBC9, 0x8000CBD58000CBD1, 0x8000CBDD8000CBD9, 
0x000165B88000CBE1, 0x000165BA00016DB9, 0x000165BC00017DBB, 0x000165BE00016DBD, 0x000EDDB00001D9BF, 0x000EA1B2000EA1B1, 0x000EA1B4000EA1B3, 0x000E91B6000EA9B5, 
0x000E15B3000E91B7, 0x8000CBE98000CBE5, 0x8000CBF18000CBED, 0x000E31B5000E25B6, 0x000E65BB8000CBF5, 0x8000CBF9000E19BA, 0x000E6DBF8000CBFD, 0x000E75BD000E65BE, 
0x00001582000E75BC, 0x00006180000E51A3, 0x000E61A600006181, 0x000190BE8000CC01, 0x000E5DAA000E75A5, 0x0001A484000E21AB, 0x000E21AE8000CC09, 0x000E31AC000E29AF, 
0x0002ADA8000E31AD, 0x0002D5AA0002DDA9, 0x0002F5AC0002EDAB, 0x0002F5AE0002FDAD, 0x8000CC0D0002EDAF, 0x8000CC158000CC11, 0x8000CC1D8000CC19, 0x8000CC258000CC21, 
0x000375B88000CC29, 0x000375BA00037DB9, 0x0003D9BC0003C9BB, 0x0003C9BE0003D9BD, 0x000295B00003C1BF, 0x000295B200029DB1, 0x000355B400034DB3, 0x000355B600035DB5, 
0x00025DB300034DB7, 0x0003D8878000CC2D, 0x8000CC3100042C86, 0x00027DB500027DB6, 0x000259BB8000CC35, 0x8000CC39000251BA, 0x000399BF8000CC3D, 0x000399BD000391BE, 
0x8000CC41000241BC, 0x00056886000219A3, 0x000239A600030087, 0x8000CC498000CC45, 0x000215AA000239A5, 0x8000CC4D00021DAB, 0x0003D5AE8000CC51, 0x000205AC0003DDAF, 
0x8000CC550003DDAD, 0x8000CC5D8000CC59, 0x8000CC658000CC61, 0x8000CC69000034EF, 0x00052CBE8000CC6D, 0x8000CC710000DCE3, 0x8000CC790001E0E1, 0x8000CC818000CC7D, 
0x000FCCE18000CC85, 0x000E14E300024884, 0x0000498000054484, 0x0000718200004981, 0x8000CC8D8000CC89, 0x8000CC958000CC91, 0x8000CC9D8000CC99, 0x000F20EF8000CCA1, 
0x8000CCA98000CCA5, 0x8000CCB18000CCAD, 0x8000CCB98000CCB5, 0x8000CCC18000CCBD, 0x0004ACBE0001F8EF, 0x8000CCC5000EDCE1, 0x8000CCC9000E1CE3, 0x8000CCD18000CCCD, 
0x0001E5B38000CCD5, 0x0000158100002D82, 0x8000CCD900001D80, 0x0001F5B50001E5B6, 0x000165BB8000CCDD, 0x8000CCE10001D9BA, 0x00015DBF8000CCE9, 0x000165BD00015DBE, 
0x0005EDA800016DBC, 0x00062DAA000625A9, 0x00063DAC000625AB, 0x00062DAE000625AD, 0x8000CC75000625AF, 0x000088868000CCE5, 0x8000CCED0003A087, 0x8000CCF58000CCF1, 
0x000699B88000CCF9, 0x0006A5BA0006ADB9, 0x000755BC00074DBB, 0x000755BE00075DBD, 0x00065DB000074DBF, 0x0006F9B20006E1B1, 0x0006D9B40006F1B3, 0x0006B9B60006D9B5, 
0x0006A5A30006A9B7, 0x8000CD018000CCFD, 0x8000CD098000CD05, 0x0006B5A50006A5A6, 0x000625AB8000CD0D, 0x8000CD11000699AA, 0x00061DAF8000CD15, 0x000625AD00061DAE, 
0x8000CD1900062DAC, 0x8000CC050007FDB3, 0x0007B1B68000CD1D, 0x8000CD258000CD21, 0x00078DBA000781B5, 0x8000CD29000795BB, 0x000771BE8000CD2D, 0x00078DBC000771BF, 
0x000631A8000781BD, 0x000631AA000631A9, 0x00064DAC000631AB, 0x00067DAE000675AD, 0x8000CD31000675AF, 0x8000CD398000CD35, 0x8000CD418000CD3D, 0x8000CD498000CD45, 
0x0006D1B88000CD4D, 0x0006D1BA0006D1B9, 0x0006E1BC0006E5BB, 0x0006E1BE0006E1BD, 0x00060DB00006E1BF, 0x00061DB2000615B1, 0x0006F1B4000611B3, 0x0006F1B60006F1B5, 
0x0006B9A30006F1B7, 0x0000B58100001582, 0x8000CD510000B580, 0x0006C5A50006F5A6, 0x0006D1AB000190BE, 0x0002A0840006C9AA, 0x000635AF003C00BF, 0x0006C5AD000635AE, 
0x000084850006C9AC, 0x003F08860001F1B3, 0x000155B600009C87, 0x8000CD5D8000CD59, 0x000171BA0001E1B5, 0x8000CD61000179BB, 0x000131BE8000CD65, 0x000151BC000139BF, 
0x0005EDA8000151BD, 0x00023DAA000235A9, 0x00022DAC000235AB, 0x000291AE000291AD, 0x8000CD69000291AF, 0x8000CD718000CD6D, 0x000211A28000CD75, 0x000691A0000211A3, 
0x0002A9B80002F5A1, 0x000369BA0002A9B9, 0x000379BC000369BB, 0x000369BE000379BD, 0x0002F1B0000369BF, 0x0002C1B20002F9B1, 0x0002B1B40002C1B3, 0x0002ADB60002B9B5, 
0x0002B5A30002A5B7, 0x8000CD79001A8D8F, 0x8000CD818000CD7D, 0x0002A5A5000211A6, 0x00023DAB8000CD85, 0x8000CD89000235AA, 0x00027DAF8000CD8D, 0x000215AD000275AE, 
0x0006059E000215AC, 0x000AE99C0006E59F, 0x000E459A000BED9D, 0x000E5998000A659B, 0x0012C596000E5199, 0x001275940013BD97, 0x0016D1920012CD95, 0x001AF59000167193, 
0x8000CD9100167591, 0x003D44840000D0E1, 0x8000CD95002410E3, 0x8000CD9D8000CD99, 0x8000CDA58000CDA1, 0x8000CDAD8000CDA9, 0x8000CDB58000CDB1, 0x8000CDBD8000CDB9, 
0x8000CDC10024CCEF, 0x003D00BE000610E3, 0x000065800007D8E1, 0x0000198200006D81, 0x003CC0868000CDC9, 0x8000CDCD003C4487, 0x8000CDD58000CDD1, 0x8000CDD90006ACEF, 
0x002B85B18000CDDD, 0x002AA1B3002801B0, 0x002791B5002B9DB2, 0x0000FCEF002401B4, 0x000190E10006C4EF, 0x000010E3000774E1, 0x8000CDE10006F0E3, 0x003CF4848000CDE5, 
0x003F95A18000CDE9, 0x003F21A38000CDED, 0x003BD5A5003F49A2, 0x003401A7003BD5A4, 0x003741A9003B01A6, 0x0033E9AB0037E1A8, 0x002C01AD003001AA, 0x002FA1AF0033C1AC, 
0x003E89B0002FF9AE, 0x003E99B2003E89B1, 0x003EB9B4003E91B3, 0x003F19B6003EB9B5, 0x003F35B8003F0DB7, 0x003F35BA003F3DB9, 0x003F15BC003F0DBB, 0x003F15BE003F1DBD, 
0x8000CDF1003F0DBF, 0x8000CDF98000CDF5, 0x8000CE018000CDFD, 0x8000CE058000CD55, 0x003DB5A88000CE09, 0x003D81AA003DBDA9, 0x003E51AC003D81AB, 0x003E51AE003E51AD, 
0x003D69B3003E51AF, 0x8000CE0D8000CDC5, 0x8000CE158000CE11, 0x003EB9B5003EB1B6, 0x003E2DBB8000CE19, 0x8000CE1D003E2DBA, 0x003E1DBF8000CE21, 0x003E25BD003E1DBE, 
0x8000CE25003E2DBC, 0x8000CE29003D2DA3, 0x003EF5A68000CE2D, 0x000390BE8000CE31, 0x003E69AA003EFDA5, 0x8000CE35003E69AB, 0x003E59AE8000CE39, 0x003E69AC003E59AF, 
0x003E5DA8003E61AD, 0x003E65AA003E6DA9, 0x003E69AC003E7DAB, 0x003EA9AE003E69AD, 0x0001E980003EA9AF, 0x0001FD820001E981, 0x000190868000CE3D, 0x8000CE410001B487, 
0x00011DB88000CE45, 0x0001C5BA0001CDB9, 0x0001CDBC0001DDBB, 0x0001F5BE0001FDBD, 0x003EDDB000019DBF, 0x000129B2003EA1B1, 0x000139B4000129B3, 0x000129B6000139B5, 
0x003EEDB3000125B7, 0x8000CE4D8000CE49, 0x8000CE558000CE51, 0x003EE1B5003EE9B6, 0x003E65BB8000CE59, 0x8000CE5D003E19BA, 0x0001FDBF0001A084, 0x0001FDBD0001FDBE, 
0x8000CE610001FDBC, 0x8000CE65003EA9A3, 0x003EADA68000CE69, 0x8000CE718000CE6D, 0x003E5DAA003EA5A5, 0x8000CE75003E21AB, 0x0001B9AE8000CE79, 0x0001B9AC0001B9AF, 
0x0002EDA80001B9AD, 0x000331AA000329A9, 0x000395AC000331AB, 0x000395AE00039DAD, 0x000400BE00038DAF, 0x8000CE818000CE7D, 0x8000CE898000CE85, 0x8000CE918000CE8D, 
0x0003ADB88000CE95, 0x000061BA000061B9, 0x000061BC000061BB, 0x000061BE000061BD, 0x0003FDB0000061BF, 0x0003A9B20003CDB1, 0x0003BDB40003A5B3, 0x0003A1B60003A1B5, 
0x00000D80000395B7, 0x00001D8200001581, 0x8000CE9D8000CE99, 0x8000CEA98000CEA1, 0x000420868000CEAD, 0x8000CEB10003E487, 0x8000CEB98000CEB5, 0x8000CEC18000CEBD, 
0x0003F9B38000CEC5, 0x8000CECD8000CEC9, 0x8000CED58000CED1, 0x00035DB500035DB6, 0x000349BB8000CED9, 0x8000CEDD000379BA, 0x000325BF8000CEE1, 0x000331BD000339BE, 
0x003E78E100033DBC, 0x003EA0E38000CEE5, 0x8000CEED8000CEE9, 0x8000CEF58000CEF1, 0x00052C848000CEF9, 0x0004A4BE8000CEFD, 0x8000CF058000CF01, 0x000118EF8000CF09, 
0x000075808000CF0D, 0x0000198200007981, 0x8000CF110004C484, 0x0005948700038CEF, 0x8000CF1900047C86, 0x8000CF1D0000D8E3, 0x8000CF21000044E1, 0x8000CF298000CF25, 
0x002FA58B8000CF2D, 0x8000CF31002FA58A, 0x0033058F8000CF35, 0x0033198D0033198E, 0x0027AD83002EC58C, 0x8000CF390027AD82, 0x002F2D878000CF3D, 0x002B9985002B3186, 
0x003FE19B002B3584, 0x8000CF41003F0D9A, 0x003C00E18000CF45, 0x003EC0E38000CF49, 0x0037C193003FF99C, 0x003E58EF00375592, 0x003B59978000CF4D, 0x003B3D95003BD596, 
0x8000CEA50036DD94, 0x8000CF518000CF15, 0x8000CF598000CF55, 0x8000CF618000CF5D, 0x0006B9A88000CF65, 0x000681AA0006B9A9, 0x000681AC000681AB, 0x000681AE000681AD, 
0x000685B0000681AF, 0x000685B200068DB1, 0x00068DB400069DB3, 0x0006B5B60006BDB5, 0x00076DB8000759B7, 0x00077DBA000775B9, 0x00076DBC000775BB, 0x000755BE000751BD, 
0x8000CF6900074DBF, 0x000515AA8000CF6D, 0x000551AC000525AB, 0x000555AE00055DAD, 0x8000CF71000549AF, 0x8000CF798000CF75, 0x8000CF7D000595A3, 0x000531A6000531A5, 
0x000669B38000CF81, 0x0000798100007982, 0x00005CBE00006580, 0x000669B5000661B6, 0x000629BB8000CF85, 0x0000C886000621BA, 0x000619BF0000AC87, 0x000629BD000629BE, 
0x0007A9A3000631BC, 0x8000CF8D8000CF89, 0x8000CF958000CF91, 0x0007A9A50007A1A6, 0x0007E9AB8000CF99, 0x8000CF9D0007E1AA, 0x0007D9AF8000CFA1, 0x0007E9AD0007E9AE, 
0x8000CFA50007F1AC, 0x8000CFA9000635B3, 0x00062DB68000CFAD, 0x8000CFB58000CFB1, 0x0006C9BA000625B5, 0x8000CFB90006C9BB, 0x0006A5BE8000CFBD, 0x0006B1BC000699BF, 
0x0006E1A80006B1BD, 0x0006F9AA0006EDA9, 0x0006E9AC0006F9AB, 0x000611AE0006E9AD, 0x8000CFC1000611AF, 0x8000CFC98000CFC5, 0x8000CFD18000CFCD, 0x8000CFD98000CFD5, 
0x0001D1B88000CFDD, 0x0001D1BA0001D1B9, 0x000151BC0001D1BB, 0x000179BE000151BD, 0x000649B0000179BF, 0x000621B2000649B1, 0x000625B4000621B3, 0x0001F1B6000619B5, 
0x000571A30001F1B7, 0x8000CFE58000CFE1, 0x8000CFE90002CCBE, 0x000561A5000569A6, 0x00058DAB8000CFED, 0x0003E48400058DAA, 0x0005DDAF8000CFF1, 0x0005F5AD0005E1AE, 
0x000051800005F5AC, 0x0000658200005981, 0x8000CFF9000341A3, 0x000371A6000349A5, 0x000C40868000CFFD, 0x000321AA00031487, 0x000325AC000321AB, 0x000311AE00032DAD, 
0x000385A8000311AF, 0x000385AA00038DA9, 0x00038DAC00039DAB, 0x0003B5AE0003BDAD, 0x8000D0010003DDAF, 0x8000D0098000D005, 0x8000D0118000D00D, 0x8000D0198000D015, 
0x000369B88000D01D, 0x000379BA000369B9, 0x000369BC000379BB, 0x0000DDBE000369BD, 0x0003A9B00000D5BF, 0x0003BDB20003A9B1, 0x000399B40003B5B3, 0x000359B6000399B5, 
0x00020DB3000359B7, 0x8000D0258000D021, 0x8000D02D8000D029, 0x000205B500023DB6, 0x00026DBB8000D031, 0x8000D03500026DBA, 0x00025DBF8000D039, 0x000261BD00025DBE, 
0x8000D03D000269BC, 0x8000D0458000D041, 0x000368E38000D049, 0x0001A8E18000D04D, 0x000394EF8000D051, 0x8000D0598000D055, 0x000019808000D05D, 0x0000058200001981, 
0x0006C4E18000D061, 0x0006D4E300073CE1, 0x000290840006BCE3, 0x000D14BE8000D069, 0x8000D0718000D06D, 0x8000D0798000D075, 0x8000D0818000D07D, 0x000190EF8000D085, 
0x000C608600066CEF, 0x8000D089000DAC87, 0x8000D08D00016DB3, 0x000175B600017DB5, 0x8000D0958000D091, 0x000151BA8000D099, 0x0000F5BC000151BB, 0x0000F5BE0000FDBD, 
0x000EA1A30000EDBF, 0x8000D09D8000D065, 0x8000D0A58000D0A1, 0x000EB1A5000EB9A6, 0x000E9DAB8000D0A9, 0x8000D0AD000E9DAA, 0x000F21AF8000D0B1, 0x000F31AD000F39AE, 
0x8000D0B5000F39AC, 0x8000D0BD8000D0B9, 0x8000D0C58000D0C1, 0x8000D0C9000DD4E3, 0x00001582000C24E1, 0x00003180000D04EF, 0x8000D0CD00001D81, 0x000330BE8000D0D1, 
0x000ED1A800033084, 0x000E29AA000ED9A9, 0x000E39AC000E29AB, 0x000E29AE000E39AD, 0x8000D0D5000E29AF, 0x00000C860000F884, 0x8000D0D900008C87, 0x8000D0E18000D0DD, 
0x000FEDB88000D0E5, 0x000F8DBA000F85B9, 0x000F9DBC000F85BB, 0x000F85BE000F81BD, 0x000E59B0000FB9BF, 0x000FEDB2000E59B1, 0x000FFDB4000FE5B3, 0x000FE5B6000FE5B5, 
0x000E95A8000FD5B7, 0x000EA9AA000E99A9, 0x000EB9AC000EA9AB, 0x000EA9AE000EB9AD, 0x8000D0E9000EA9AF, 0x8000D0F18000D0ED, 0x8000D0F98000D0F5, 0x8000D1018000D0FD, 
0x00015DB88000D105, 0x000165BA00016DB9, 0x000115BC00010DBB, 0x000115BE00011DBD, 0x000EA9B000010DBF, 0x000EB5B2000EB5B1, 0x000E95B4000E8DB3, 0x000175B600017DB5, 
0x000E21B300016DB7, 0x8000D10D8000D109, 0x8000D1158000D111, 0x000E31B5000E39B6, 0x000E71BB8000D119, 0x8000D11D000E6DBA, 0x0001B9BF8000D121, 0x000E59BD000E51BE, 
0x8000D125000E61BC, 0x8000D129000E65A3, 0x000E7DA68000D12D, 0x8000D1358000D131, 0x000E29AA000E75A5, 0x8000D139000E35AB, 0x000E15AE8000D13D, 0x000E25AC0001FDAF, 
0x0002B5A9000E1DAD, 0x0002B5AB0002B5A8, 0x000335AD0002B5AA, 0x000335AF000335AC, 0x0003C980000335AE, 0x000005820003C981, 0x000264BE8000D141, 0x000378878000D149, 
0x0003E9B900041C86, 0x000389BB0003D9B8, 0x00039DBD0003E1BA, 0x000381BF00039DBC, 0x000355B1000389BE, 0x000355B3000355B0, 0x0003F9B5000355B2, 0x0003E9B70003F1B4, 
0x000300840003F1B6, 0x0003A9B50003A1B6, 0x000229B30005C084, 0x8000D1518000D14D, 0x000329BF8000D155, 0x000395BD000321BE, 0x000385BB000395BC, 0x8000D159000385BA, 
0x0003E1A58000D15D, 0x8000D1658000D161, 0x8000D1690003E9A6, 0x000261A38000D16D, 0x0003DDAD8000D171, 0x000361AF0003DDAC, 0x8000D175000369AE, 0x0003CDAB8000D179, 
0x8000D17D0003CDAA, 0x8000D1858000D181, 0x8000D18D8000D189, 0x8000D1958000D191, 0x8000D1990003D4EF, 0x8000D19D000194E1, 0x8000D1A1000198E3, 0x8000D1A98000D1A5, 
0x000079808000D1AD, 0x0000198200007981, 0x8000D1B10001D5B3, 0x0001E5B60001EDB5, 0x0004C086000214BE, 0x0001B9BA00054087, 0x0001ADBC0001B9BB, 0x00018DBE000185BD, 
0x000E58E100007DBF, 0x0001E4E38000D1B9, 0x8000D1C18000D1BD, 0x8000D1C98000D1C5, 0x0004E8BE8000D1CD, 0x8000D1D58000D1D1, 0x8000D1DD8000D1D9, 0x000138EF8000D1E1, 
0x8000D1E98000D1E5, 0x8000D1ED00015DA3, 0x00016DA68000D1F1, 0x8000CFF58000D1F5, 0x000131AA000165A5, 0x8000D1F9000131AB, 0x000105AE8000D1FD, 0x000125AC0000F5AF, 
0x8000D1B500010DAD, 0x8000D2058000D201, 0x8000D20D8000D209, 0x8000D2158000D211, 0x000009818000D219, 0x8000D21D00003980, 0x8000D22100001D82, 0x8000D2298000D225, 
0x0000E0868000D22D, 0x8000D23100037487, 0x0005F4EF8000D235, 0x8000D23D8000D239, 0x0004F0E38000D241, 0x00044CE18000D245, 0x8000D24D8000D249, 0x8000D2558000D251, 
0x0006B5A88000D259, 0x000611AA000611A9, 0x000629AC000611AB, 0x00065DAE000629AD, 0x0000E484000655AF, 0x8000D2618000D25D, 0x8000D2698000D265, 0x8000D2718000D26D, 
0x0007CDB88000D275, 0x0007DDBA0007D5B9, 0x0007F1BC0007D5BB, 0x0007E9BE0007FDBD, 0x000631B00007E9BF, 0x000635B2000631B1, 0x000605B400061DB3, 0x0007FDB60007F5B5, 
0x000685A80007F5B7, 0x000699AA000689A9, 0x000689AC000699AB, 0x0006BDAE000689AD, 0x8000D2790006B5AF, 0x8000D2818000D27D, 0x00000D808000D285, 0x0000B1820000B181, 
0x0006A9B88000D289, 0x00014DBA0006A9B9, 0x00015DBC000145BB, 0x00014DBE000145BD, 0x0006CDB0000145BF, 0x0006DDB20006D5B1, 0x0006B1B40006D1B3, 0x0006B5B60006BDB5, 
0x000611B30006A9B7, 0x8000D2918000D28D, 0x8000D2990001CCBE, 0x000601B5000609B6, 0x000611BB8000D29D, 0x00000886000609BA, 0x000679BF00009C87, 0x000605BD000675BE, 
0x8000D2A1000609BC, 0x8000D2A5000655A3, 0x00064DA68000D2A9, 0x8000D2B18000D2AD, 0x00064DAA000645A5, 0x8000D2B5000655AB, 0x000631AE8000D2B9, 0x00064DAC00063DAF, 
0x000239A8000641AD, 0x000241AA000239A9, 0x000245AC000241AB, 0x000245AE00024DAD, 0x001CACBE000279AF, 0x8000D2BD001DECBE, 0x8000D2C58000D2C1, 0x8000D2CD8000D2C9, 
0x0002F1B88000D2D1, 0x0002F1BA0002F1B9, 0x000371BC0002F1BB, 0x000371BE000371BD, 0x00020DB0000371BF, 0x00021DB2000215B1, 0x00020DB4000215B3, 0x0002D1B60002D1B5, 
0x8000D2D50002D1B7, 0x0002C1B38000D2D9, 0x0002C5B58000D2DD, 0x8000D2E58000D2E1, 0x8000D2E90002C5B6, 0x0002D9BB8000D2ED, 0x0002C9BD0002C1BA, 0x00021DBF0002C1BC, 
0x8000D2F10002C1BE, 0x8000D2F98000D2F5, 0x8000D2FD000285A3, 0x000281A6000281A5, 0x0003EC848000D301, 0x000285AA8000D309, 0x000285AC00029DAB, 0x000285AE00028DAD, 
0x000291A8000259AF, 0x0002C9AA000299A9, 0x0002DDAC0002C5AB, 0x0002C1AE0002C1AD, 0x001D00860002F5AF, 0x8000D30D001D6487, 0x0001F9808000D311, 0x0001E5820001E581, 
0x0001C5B88000D315, 0x0001DDBA0001C9B9, 0x0001F1BC0001D5BB, 0x000199BE0001F1BD, 0x00028DB0000199BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 
0x8000D3190001FDB7, 0x0000FCEF0006FCE1, 0x8000D31D000710E3, 0x8000D3258000D321, 0x001C6C848000D329, 0x8000D3318000D32D, 0x0001E8E18000D335, 0x000108E38000D339, 
0x000201B30006E4EF, 0x8000D3418000D33D, 0x8000D3498000D345, 0x000215B5000201B6, 0x0001C9BB8000D34D, 0x8000D351000209BA, 0x0001C9BF8000D145, 0x0001C9BD0001C1BE, 
0x001DC1A30001D1BC, 0x8000D3558000D305, 0x8000D35D8000D359, 0x001DD5A5001DC1A6, 0x001E09AB8000D361, 0x8000D365001DC9AA, 0x001E09AF8000D369, 0x001E09AD001E01AE, 
0x00006D80001E11AC, 0x00001D8200001581, 0x8000D36D001C94EF, 0x8000D3758000D371, 0x000340868000D379, 0x8000D37D0003C487, 0x8000D3858000D381, 0x8000D389001FC4E1, 
0x001E65A8001C8CE3, 0x001FA5AA001FADA9, 0x001F11AC001FB1AB, 0x001F0DAE001F05AD, 0x8000D38D001F05AF, 0x8000D3958000D391, 0x8000D39D8000D399, 0x8000D3A58000D3A1, 
0x001F11B88000D3A9, 0x001F21BA001F19B9, 0x0000DDBC0000C5BB, 0x0000C5BE0000C5BD, 0x001F7DB00000F5BF, 0x001F41B2001F41B1, 0x001F45B4001F41B3, 0x001F31B6001F31B5, 
0x001E2DB3001F31B7, 0x8000D3B18000D3AD, 0x8000D3B98000D3B5, 0x001E99B5001E85B6, 0x001E85BB8000D3BD, 0x8000D3C1001EB9BA, 0x001EF5BF8000D3C5, 0x001E95BD001E81BE, 
0x8000D3C9001E95BC, 0x8000D3CD001E69A3, 0x001EC1A68000D3D1, 0x8000D3D98000D3D5, 0x001EFDAA001EDDA5, 0x8000D3DD001EC1AB, 0x001EC5AE8000D3E1, 0x001ED1AC001EB1AF, 
0x0001DDA8001ED1AD, 0x0001E5AA0001EDA9, 0x0001E9AC0001FDAB, 0x00013DAE000135AD, 0x0000F980000135AF, 0x0000C5820000CD81, 0x000178BE00016084, 0x0000AC878000D3E9, 
0x0000D1B800019C86, 0x0000E1BA0000D9B9, 0x000091BC0000E1BB, 0x000095BE00009DBD, 0x00014DB0000089BF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x0000F1B60000F1B5, 
0x00026DB30000F1B7, 0x8000D3F18000D3ED, 0x8000D3F98000D3F5, 0x000261B50002B5B6, 0x000291BB8000D3FD, 0x8000D401000289BA, 0x000335BF8000D405, 0x000281BD000289BE, 
0x00000090000289BC, 0x8000D409000229A3, 0x0002F1A68000D40D, 0x8000D4158000D411, 0x0002CDAA000225A5, 0x8000D4190002D5AB, 0x0002CDAE8000D41D, 0x0002CDAC000371AF, 
0x000335A80002C5AD, 0x000081AA000081A9, 0x000081AC000081AB, 0x0000B1AE000089AD, 0x8000D4210000B1AF, 0x8000D4298000D425, 0x8000D4318000D42D, 0x8000D4398000D435, 
0x000069B88000D43D, 0x000079BA000069B9, 0x000069BC000079BB, 0x0001D9BE000069BD, 0x0000A9B00001D9BF, 0x0000BDB20000A9B1, 0x000099B40000B5B3, 0x000059B6000099B5, 
0x8000D441000059B7, 0x8000D4498000D445, 0x00001D818000D44D, 0x8000D45100001D80, 0x0002AC8400000582, 0x0002C0870005E8BE, 0x8000D45900050C86, 0x8000D4618000D45D, 
0x000149B38000D465, 0x000000D28000D469, 0x8000D4718000D46D, 0x000149B5000149B6, 0x00012DBB8000D475, 0x8000D47900012DBA, 0x00011DBF8000D47D, 0x000121BD00011DBE, 
0x001EB8E1000129BC, 0x001E38E38000D481, 0x8000D4898000D485, 0x8000D4918000D48D, 0x00046C848000D495, 0x8000D49900046CBE, 0x8000D4A18000D49D, 0x001F64EF8000D4A5, 
0x8000D4A900077084, 0x0004E8868000D4AD, 0x8000D4B10004C087, 0x8000D4B5000068E3, 0x00001D820001A4E1, 0x00001D800000ACEF, 0x8000D29500001581, 0x8000D4BD8000D4B9, 
0x0007A4E18000D4C1, 0x000538E38000D455, 0x8000D4C58000D4C9, 0x8000D4D18000D4CD, 0x8000D4D98000D4D5, 0x8000D4E18000D4DD, 0x8000D4E98000D4E5, 0x0005E4EF8000D4ED, 
0x000649A38000D4F1, 0x8000D4F98000D4F5, 0x8000D5018000D4FD, 0x000649A5000649A6, 0x00062DAB8000D505, 0x8000D50900062DAA, 0x00061DAF8000D50D, 0x000621AD00061DAE, 
0x0007B1A8000629AC, 0x0007B1AA0007B1A9, 0x0007D5AC0007B1AB, 0x0007C9AE0007D9AD, 0x8000D5110007C1AF, 0x8000D5198000D515, 0x8000D5218000D51D, 0x8000D5298000D525, 
0x000769B88000D52D, 0x000779BA000769B9, 0x000711BC000779BB, 0x000709BE000711BD, 0x000789B0000705BF, 0x00076DB2000789B1, 0x000761B4000761B3, 0x000761B6000761B5, 
0x000639B3000761B7, 0x0001B58100001582, 0x8000D5310001B580, 0x00065DB5000659B6, 0x00064DBB0001D4BE, 0x8000D53500064DBA, 0x0006A5BF8000D539, 0x0006B5BD0006A5BE, 
0x8000D53D0006B9BC, 0x0000E88600067DA3, 0x00061DA60001CC87, 0x8000D5458000D541, 0x000609AA000619A5, 0x8000D549000609AB, 0x0006E1AE8000D54D, 0x0006FDAC0006E1AF, 
0x00018DA80006F1AD, 0x000191AA000191A9, 0x0001B1AC000191AB, 0x0001B1AE0001B1AD, 0x0001A8840001B1AF, 0x8000D5558000D551, 0x8000D55D8000D559, 0x8000D5658000D561, 
0x0001A9B88000D569, 0x000169BA0001A9B9, 0x000179BC000169BB, 0x000169BE000179BD, 0x0001D1B0000169BF, 0x0001D5B20001D1B1, 0x0001B9B40001A9B3, 0x0001A9B60001B9B5, 
0x000219B30001A1B7, 0x8000D5718000D56D, 0x8000D5798000D575, 0x000239B5000231B6, 0x000215BB8000D57D, 0x8000D581000215BA, 0x00027DBF8000D585, 0x00027DBD00027DBE, 
0x8000D589000201BC, 0x8000D58D00025DA3, 0x000275A68000D591, 0x8000D5998000D595, 0x000251AA00027DA5, 0x8000D59D000251AB, 0x000239AE8000D5A1, 0x000245AC000239AF, 
0x0000D980000239AD, 0x0000E5820000ED81, 0x8000D5A90003C0BE, 0x000354870002E0EF, 0x8000D5AD000CBC86, 0x8000D5B1000114E3, 0x8000D5B50001FCE1, 0x8000D5BD8000D5B9, 
0x8000D5C58000D5C1, 0x8000D5C9000391B3, 0x0003BDB6000C4084, 0x8000D5D18000D5CD, 0x00034DBA0003B5B5, 0x8000D5D5000355BB, 0x00034DBE8000D5D9, 0x00034DBC0000F1BF, 
0x00022DA8000345BD, 0x00025DAA000245A9, 0x000279AC000255AB, 0x0002BDAE000279AD, 0x000CACBE0002B5AF, 0x8000D5E18000D5DD, 0x8000D5E98000D5E5, 0x8000D5F18000D5ED, 
0x000151B88000D5F5, 0x000161BA000159B9, 0x000111BC000161BB, 0x000115BE00011DBD, 0x0002CDB0000109BF, 0x0002DDB20002D5B1, 0x0002CDB40002D5B3, 0x000171B6000171B5, 
0x0006B4E1000171B7, 0x000638E38000D3E5, 0x8000D5FD8000D5F9, 0x8000D601000644E1, 0x8000D605000630E3, 0x8000D60D8000D609, 0x000F3CBE000048EF, 0x0006E4EF8000D611, 
0x000295A38000D619, 0x0000618100007182, 0x8000D61D00006980, 0x0002B1A50002B9A6, 0x000251AB8000D621, 0x000CC886000249AA, 0x0001F5AF000D5C87, 0x000241AD000249AE, 
0x8000D615000249AC, 0x8000D6298000D625, 0x000C94E18000D62D, 0x000CC4E38000D631, 0x8000D6398000D635, 0x000DF0EF8000D63D, 0x8000D6458000D641, 0x8000D64D8000D649, 
0x000EE9B38000D651, 0x8000D6598000D655, 0x8000D6618000D65D, 0x000EEDB5000EEDB6, 0x000EB5BB8000D665, 0x8000D669000EADBA, 0x000F55BF8000D66D, 0x000E91BD000E99BE, 
0x000E11A8000EA5BC, 0x000E21AA000E25A9, 0x000E25AC000E3DAB, 0x000E25AE000E2DAD, 0x8000D671000E5DAF, 0x8000D6798000D675, 0x000019808000D67D, 0x0000058200001981, 
0x000FF1B88000D681, 0x000FF1BA000FF1B9, 0x000F5DBC000FF1BB, 0x000F41BE000F45BD, 0x000E29B0000F7DBF, 0x000E31B2000E31B1, 0x000E1DB4000E05B3, 0x000FD1B6000FD1B5, 
0x000FA9A3000FD1B7, 0x0001188500028C84, 0x00017485000004BF, 0x000FADA5000FADA6, 0x000FF5AB8000D689, 0x00078886000FEDAA, 0x000E15AF00005887, 0x000FD1AD000FD9AE, 
0x8000D68D000FE5AC, 0x8000D691000E99B3, 0x00015DB68000D695, 0x8000D69D8000D699, 0x000141BA000155B5, 0x8000D6A1000141BB, 0x000145BE8000D6A5, 0x000155BC00014DBF, 
0x000E3DA800014DBD, 0x000E55AA000E55A9, 0x000199AC000189AB, 0x00018DAE000199AD, 0x8000D6A9000181AF, 0x8000D6B18000D6AD, 0x8000D6B98000D6B5, 0x8000D6C18000D6BD, 
0x000189B88000D6C5, 0x000199BA000189B9, 0x0001B9BC000191BB, 0x000179BE0001B9BD, 0x0001C1B0000179BF, 0x0001C5B20001C1B1, 0x0001C5B40001DDB3, 0x0001C5B60001CDB5, 
0x000DDDA30001B9B7, 0x8000D6CD8000D6C9, 0x8000D6D58000D6D1, 0x000211A5000219A6, 0x000205AB8000D6D9, 0x8000D6DD000205AA, 0x000209AF001A798F, 0x000209AD000201AE, 
0x001E9D94000211AC, 0x00124D9600119D95, 0x001AD5900012ED97, 0x001E5992001ABD91, 0x000A659C001E5993, 0x000DED9E000A3D9D, 0x00159D98000E699F, 0x00164D9A00167599, 
0x000184E100098D9B, 0x03FEDCE38000D6E1, 0x000E81A000038084, 0x00010DA2000FBDA1, 0x03E801B100029DA3, 0x03EA69B303F649B0, 0x03EE91B503EA8DB2, 0x03EC60EF03EC01B4, 
0x03FED1A98000D6E5, 0x03F2CDAB03FEC1A8, 0x03F391AD03FFBDAA, 0x03F6F9AF03F2DDAC, 0x000401A103F401AE, 0x000679A38000D6E9, 0x03FAD1A50006CDA2, 0x03FC01A703F801A4, 
0x001B558203FAC1A6, 0x8000D6ED001B8183, 0x001F15868000D6F1, 0x001BF184001FC987, 0x0010F98A001F1D85, 0x000524BE0013218B, 0x0017318E8000D6F9, 0x0013998C0017018F, 
0x0008B1920014D18D, 0x00046886000B4193, 0x000F559600057C87, 0x000B0194000F4597, 0x000E499A000CD995, 0x8000D6FD0000F19B, 0x000079818000D701, 0x0003799C00019180, 
0x8000D70500007182, 0x00058084000E74E1, 0x8000D709000098E3, 0x8000D70D8000D5A5, 0x8000D7158000D711, 0x8000D71D8000D719, 0x8000D7258000D721, 0x8000D72D8000D729, 
0x000289B3000EF4EF, 0x8000D7358000D731, 0x8000D73D8000D739, 0x00028DB500028DB6, 0x000245BB8000D741, 0x8000D745000245BA, 0x000245BF8000D749, 0x000255BD000245BE, 
0x00051DA8000255BC, 0x000541AA000545A9, 0x000545AC000541AB, 0x000571AE00054DAD, 0x8000D6F5000571AF, 0x8000D7518000D74D, 0x00000D808000D755, 0x0000B1820000B181, 
0x000645B88000D759, 0x000645BA00064DB9, 0x00064DBC00065DBB, 0x0006DDBE00067DBD, 0x0005C1B00006E1BF, 0x0005C1B20005C1B1, 0x0005C1B40005C1B3, 0x0005C1B60005C1B5, 
0x0005C9A30005C1B7, 0x8000D7618000D75D, 0x8000D765000300BE, 0x0005CDA50005CDA6, 0x000505AB8000D769, 0x00000886000505AA, 0x000505AF0003DC87, 0x000515AD000505AE, 
0x8000D76D000515AC, 0x8000D7710007A9B3, 0x000749B68000D775, 0x8000D77D8000D779, 0x000745BA00074DB5, 0x8000D78100074DBB, 0x000745BE8000D785, 0x000755BC00074DBF, 
0x00066DA300074DBD, 0x8000D78D8000D789, 0x8000D7958000D791, 0x000689A500068DA6, 0x000689AB8000D799, 0x8000D79D000681AA, 0x000689AF8000D7A1, 0x000689AD000681AE, 
0x8000D7A5000691AC, 0x8000D7AD8000D7A9, 0x8000D7B58000D7B1, 0x8000D7BD8000D7B9, 0x8000D7C100048CEF, 0x8000D7C5000654E1, 0x00000D800005F0E3, 0x0000DD820000D581, 
0x0006ADA88000D7C9, 0x0006E5AA0006EDA9, 0x000601AC00060DAB, 0x000605AE00060DAD, 0x8000D7CD00063DAF, 0x0001E4848000D7D1, 0x03FF10860001E8BE, 0x8000D7D900009487, 
0x00060DB88000D7DD, 0x000615BA000615B9, 0x00063DBC000625BB, 0x0001F1BE0001F1BD, 0x000645B00001F1BF, 0x000645B200064DB1, 0x000645B400065DB3, 0x00063DB600064DB5, 
0x00029DA8000635B7, 0x0002C1AA0002C5A9, 0x0002C5AC0002C1AB, 0x0002F1AE0002CDAD, 0x8000D7E10002F1AF, 0x8000D7E98000D7E5, 0x000328E18000D7ED, 0x8000D7F58000D7F1, 
0x000305B88000D7F9, 0x000305BA00030DB9, 0x000305BC00031DBB, 0x000339BE00030DBD, 0x000365B0000335BF, 0x000365B200036DB1, 0x00036DB400037DB3, 0x000355B600035DB5, 
0x000249B300033DB7, 0x8000D8018000D7FD, 0x8000D8098000D805, 0x00024DB500024DB6, 0x0003A9BB8000D80D, 0x8000D8110003A1BA, 0x000399BF8000D815, 0x0003A9BD0003A9BE, 
0x8000D8190003B1BC, 0x000201A38000D81D, 0x000205A58000D821, 0x8000D8298000D825, 0x8000D685000205A6, 0x0003E1AB8000D82D, 0x0003E1AD0003E9AA, 0x0003D1AF0003F9AC, 
0x8000D8310003E1AE, 0x8000D8398000D835, 0x8000D8418000D83D, 0x000244BE0001A4E1, 0x000029800000A4E3, 0x0000398200002981, 0x8000D849000078EF, 0x8000D84D0002B884, 
0x000161B38000D851, 0x8000D8598000D855, 0x8000D8618000D85D, 0x000171B5000179B6, 0x0001E5BB8000D865, 0x03FD4886000159BA, 0x0001EDBF03FD4087, 0x0001F5BD0001E5BE, 
0x8000D8690001F5BC, 0x8000D8718000D86D, 0x8000D87503FC4084, 0x8000D87D8000D879, 0x8000D8810001E8EF, 0x03F3B4AC0006F4E1, 0x8000D885000634E3, 0x03FCB0848000D889, 
0x8000D8918000D88D, 0x0001E1A50001E9A6, 0x0001F1A38000D895, 0x8000D89D8000D899, 0x00017DAF8000D8A1, 0x000165AD000175AE, 0x000175AB000165AC, 0x8000D8A50001C9AA, 
0x03FDB9A88000D8A9, 0x03FE29AA03FDB9A9, 0x03FE39AC03FE29AB, 0x03FE2DAE03FE39AD, 0x8000D84503FE25AF, 0x0000198100001182, 0x8000D8AD03FFD180, 0x000334BE8000D8B1, 
0x03FE81B88000D8B5, 0x03FE85BA03FE81B9, 0x03FE89BC03FE99BB, 0x03FF59BE03FEB1BD, 0x03FE5DB003FF59BF, 0x03FEE1B203FEE1B1, 0x03FEE1B403FEE1B3, 0x03FED1B603FEE9B5, 
0x03FFB1A803FED1B7, 0x03FFB5AA03FFBDA9, 0x03FFD9AC03FFC9AB, 0x03FFC9AE03FFD9AD, 0x0000008603FFC1AF, 0x8000D8B900032887, 0x8000D8C18000D8BD, 0x8000D8C98000D8C5, 
0x03FF75B88000D8CD, 0x03FF09BA03FF79B9, 0x03FF05BC03FF01BB, 0x03FF05BE03FF0DBD, 0x03FF61B003FF25BF, 0x03FF61B203FF61B1, 0x03FF65B403FF7DB3, 0x03FF59B603FF6DB5, 
0x03FE3DB303FF4DB7, 0x8000D8D58000D8D1, 0x8000D8DD8000D8D9, 0x03FE51B503FE59B6, 0x03FEA5BB8000D8E1, 0x8000D8E503FEA5BA, 0x03FEA9BF8000D8E9, 0x03FEA9BD03FEA1BE, 
0x8000D8ED03FEB5BC, 0x03FCA8EF8000D8F1, 0x8000D8F98000D8F5, 0x8000D9018000D8FD, 0x8000D9098000D905, 0x8000D9118000D90D, 0x03FED8E18000D915, 0x03FC5CE38000D919, 
0x03FEBDA38000D91D, 0x0000F58100001582, 0x8000D9210000F980, 0x03FED1A503FED9A6, 0x03FE25AB000190BE, 0x0000088603FE25AA, 0x03FE29AF00017087, 0x03FE29AD03FE21AE, 
0x8000D92903FE35AC, 0x8000D92D000175B3, 0x00016DB68000D931, 0x8000D9398000D935, 0x0000EDBA000165B5, 0x8000D93D0000F5BB, 0x0000DDBE8000D941, 0x0000E5BC0000B5BF, 
0x0002A9A80000D5BD, 0x0002B9AA0002A9A9, 0x0002A9AC0002B9AB, 0x00031DAE0002A9AD, 0x0004ACBE000315AF, 0x8000D9498000D945, 0x8000D94D0005A0BE, 0x8000D9558000D951, 
0x000311B88000D959, 0x000311BA000311B9, 0x000331BC000311BB, 0x000331BE000331BD, 0x00036DB0000331BF, 0x000375B2000375B1, 0x00035DB4000345B3, 0x00033DB6000335B5, 
0x000231A3000331B7, 0x8000D9618000D95D, 0x8000D9698000D965, 0x000221A5000229A6, 0x0003B1AB8000D96D, 0x8000D9710003A9AA, 0x0003F1AF8000D975, 0x000391AD000399AE, 
0x0003C0840003A1AC, 0x8000D97D8000D979, 0x8000D9858000D981, 0x00003D8100003D82, 0x8000D98900003D80, 0x8000D9918000D98D, 0x8000D99D8000D999, 0x0004D8868000D7D5, 
0x0002C1A80004BC87, 0x0002C5AA0002CDA9, 0x0002C9AC0002D9AB, 0x0002F5AE0002FDAD, 0x8000D9A1000139AF, 0x8000D9A98000D9A5, 0x8000D9B18000D9AD, 0x8000D9B98000D9B5, 
0x0001D1B88000D9BD, 0x0001E1BA0001D9B9, 0x000195BC0001E1BB, 0x000195BE00019DBD, 0x000149B000018DBF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x0001F1B60001F1B5, 
0x0000E4EF0001F1B7, 0x8000D9C58000D9C1, 0x8000D9C900050C84, 0x8000D9D18000D9CD, 0x8000D9D500015CEF, 0x8000D9D903FED4E1, 0x03FE18E303FE30E3, 0x000100E18000D9DD, 
0x8000D9E58000D9E1, 0x8000D9ED8000D9E9, 0x8000D9F1000201B3, 0x000231B600020DB5, 0x8000D9F98000D9F5, 0x0001C1BA8000D9FD, 0x0001C5BC0001DDBB, 0x0001C5BE0001CDBD, 
0x0005CDA3000179BF, 0x8000DA018000D995, 0x8000DA058000DA09, 0x0005C1A50005FDA6, 0x000611AB8000DA0D, 0x0003088600060DAA, 0x0006B5AF00037C87, 0x000601AD000609AE, 
0x0007A180000609AC, 0x000041820007A181, 0x8000DA1100076DB3, 0x000775B600077DB5, 0x8000DA198000DA15, 0x000751BA8000DA1D, 0x0007F5BC000751BB, 0x0007E9BE0007FDBD, 
0x00066DA80007E9BF, 0x0007A9AA000675A9, 0x0007B9AC0007A9AB, 0x0007A9AE0007B9AD, 0x8000DA210007A9AF, 0x8000DA298000DA25, 0x8000DA318000DA2D, 0x8000DA398000DA35, 
0x000769B88000DA3D, 0x000775BA000771B9, 0x000715BC00070DBB, 0x000709BE00071DBD, 0x0007D9B0000701BF, 0x00076DB20007D9B1, 0x000761B4000765B3, 0x000761B6000761B5, 
0x000621A300075DB7, 0x8000DA458000DA41, 0x8000DA4D8000DA49, 0x000631A5000639A6, 0x00061DAB8000DA51, 0x8000DA5500061DAA, 0x0006A5AF8000DA59, 0x0006B1AD0006A5AE, 
0x8000DA5D0006B9AC, 0x8000DA6100059CEF, 0x00000D808000DA65, 0x00003D8200003581, 0x8000DA6D8000DA69, 0x0001A4848000DA71, 0x8000DA750001A4BE, 0x8000DA790005A4E3, 
0x00018DA80006CCE1, 0x0001D9AA000199A9, 0x0001F1AC0001D1AB, 0x000139AE0001F1AD, 0x00000086000139AF, 0x8000DA7D00016487, 0x8000DA858000DA81, 0x8000DA8D8000DA89, 
0x0000CDB88000DA91, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 0x000091BE000095BD, 0x000149B0000091BF, 0x000159B2000149B1, 0x000149B4000159B3, 0x0000FDB6000149B5, 
0x000251B30000F5B7, 0x8000DA998000DA95, 0x8000DAA18000DA9D, 0x000279B5000271B6, 0x00028DBB8000DAA5, 0x8000DAA900028DBA, 0x00028DBF8000DAAD, 0x00028DBD00028DBE, 
0x00126C8500028DBC, 0x8000DAB1000215A3, 0x000235A68000DAB5, 0x8000DABD8000DAB9, 0x0002C9AA00023DA5, 0x8000DAC10002C9AB, 0x0002C9AE8000DAC5, 0x0002C9AC0002C9AF, 
0x000380840002C9AD, 0x8000DACD8000DAC9, 0x8000DAD1000C00BE, 0x8000DAD98000DAD5, 0x8000DAE18000DADD, 0x8000DAED8000DAE9, 0x8000DAF58000DAF1, 0x8000DAFD8000DAF9, 
0x000059808000DB01, 0x0000698200005981, 0x8000DB050002B8EF, 0x000318878000DB09, 0x8000DB0D000CFC86, 0x8000DB158000DB11, 0x8000DB1D8000DB19, 0x8000D92500014CE1, 
0x000279A800026CE3, 0x0002A5AA0002ADA9, 0x0002A5AC0002BDAB, 0x0002A5AE0002ADAD, 0x000DA884000119AF, 0x8000DB258000DB21, 0x8000DB2D8000DB29, 0x8000DB358000DB31, 
0x000115B88000DB39, 0x000121BA00011DB9, 0x0001D5BC000121BB, 0x0001C9BE0001DDBD, 0x000169B00001C9BF, 0x000179B2000169B1, 0x000159B4000171B3, 0x000131B6000159B5, 
0x000760E1000131B7, 0x000614E38000DB3D, 0x8000DB41000C00BE, 0x8000DB450001A4E1, 0x8000DB490000E4E3, 0x8000DB518000DB4D, 0x8000DB59000038EF, 0x00076CEF8000DB5D, 
0x000061808000DB61, 0x0000618200006181, 0x8000DB65000261B3, 0x000261B6000261B5, 0x000CC0868000DB69, 0x0001E1BA000CE887, 0x0001E1BC0001E1BB, 0x0001D1BE0001E9BD, 
0x000DADA30001D1BF, 0x8000DB558000DAE5, 0x8000DB718000DB6D, 0x000DADA5000DADA6, 0x000E2DAB8000DB75, 0x8000DB79000E2DAA, 0x000E1DAF8000DB7D, 0x000E25AD000E1DAE, 
0x8000DB81000E2DAC, 0x8000DB85000EE9B3, 0x000EE9B68000DB89, 0x8000DB918000DB8D, 0x000EB5BA000EE9B5, 0x8000DB95000E85BB, 0x000E9DBE8000DB99, 0x000E9DBC000E85BF, 
0x000E25A8000E95BD, 0x000E25AA000E2DA9, 0x000E25AC000E3DAB, 0x000E25AE000E2DAD, 0x8000DB9D000E4DAF, 0x8000DBA58000DBA1, 0x8000DBAD8000DBA9, 0x8000DBB58000DBB1, 
0x000FEDB88000DBB9, 0x000FFDBA000FF5B9, 0x000FEDBC000FF5BB, 0x000F49BE000F51BD, 0x000E35B0000F45BF, 0x000E0DB2000E05B1, 0x000E1DB4000E05B3, 0x000FDDB6000E05B5, 
0x000FADA3000FD5B7, 0x0000198100001982, 0x8000DBBD0001B180, 0x000FADA5000FADA6, 0x000FC1AB8000DBC1, 0x0002A084000FF1AA, 0x000FC1AF0001A0BE, 0x000FD1AD000FD9AE, 
0x8000DBC5000FD9AC, 0x0000E886000EF9B3, 0x00015DB600012C87, 0x8000DBCD8000DBC9, 0x000149BA000E81B5, 0x8000DBD1000149BB, 0x00013DBE8000DBD5, 0x000139BC000121BF, 
0x000E31A8000135BD, 0x000E35AA000E31A9, 0x000E4DAC000E5DAB, 0x000189AE000199AD, 0x0001E484000181AF, 0x8000DBDD8000DBD9, 0x8000DBE58000DBE1, 0x8000DBED8000DBE9, 
0x0001ADB88000DBF1, 0x00016DBA000165B9, 0x00017DBC000165BB, 0x00016DBE000165BD, 0x0001C9B0000165BF, 0x0001A9B20001C9B1, 0x0001BDB40001A5B3, 0x0001A1B60001A1B5, 
0x000DBDA3000195B7, 0x8000DBF98000DBF5, 0x8000DC018000DBFD, 0x000DC5A5000219A6, 0x00020DAB8000DC05, 0x8000DC0900020DAA, 0x000265AF8000DC0D, 0x000271AD000279AE, 
0x8000DC1100027DAC, 0x8000DC198000DC15, 0x8000DC218000DC1D, 0x8000DC298000DC25, 0x000039808000DC2D, 0x0000058200003981, 0x00033CBE8000DC31, 0x000344878000DC39, 
0x8000DC3D0004DC86, 0x0003E1B38000DC41, 0x000335B50004C084, 0x8000DC498000DC45, 0x8000DC4D000335B6, 0x000311BB8000DC51, 0x0000B5BD000319BA, 0x0000B5BF000309BC, 
0x8000DC550000B5BE, 0x8000DC59000194E1, 0x8000DC5D00017CE3, 0x8000DC658000DC61, 0x8000DC6D8000DC69, 0x8000DC758000DC71, 0x8000DC7D8000DC79, 0x8000DC858000DC81, 
0x000255A8000274EF, 0x000261AA00025DA9, 0x0002B5AC000261AB, 0x0002B5AE0002BDAD, 0x000568BE0002ADAF, 0x8000DC8D8000DC89, 0x8000DC958000DC91, 0x0000AD810000AD82, 
0x000169B80000AD80, 0x000109BA000169B9, 0x000119BC000109BB, 0x000109BE000119BD, 0x0002D5B0000109BF, 0x0002D5B20002DDB1, 0x000179B4000169B3, 0x000169B6000179B5, 
0x000F44E1000161B7, 0x000EB8E30000BCE3, 0x8000DC99000E74E1, 0x8000DCA18000DC9D, 0x8000DCAD8000DCA9, 0x8000DCB58000DCB1, 0x000730BE8000DCB9, 0x000ECCEF000060EF, 
0x0002A9A38000DCBD, 0x0004E8868000DCC1, 0x8000DCC500050487, 0x00027DA500027DA6, 0x000259AB8000DCC9, 0x8000DCCD000251AA, 0x0001FDAF8000DCD1, 0x0001FDAD0001FDAE, 
0x000675A8000241AC, 0x00068DAA000685A9, 0x000689AC000699AB, 0x0006BDAE0006B5AD, 0x8000DCA50006DDAF, 0x8000DCD98000DCD5, 0x8000DCE18000DCDD, 0x8000DCE98000DCE5, 
0x0006ADB88000DCED, 0x0006BDBA0006B5B9, 0x000775BC0006B5BB, 0x000775BE00077DBD, 0x0006A9B000076DBF, 0x0006BDB20006B5B1, 0x0006ADB40006B5B3, 0x00069DB6000695B5, 
0x000605B3000695B7, 0x8000DCF58000DCF1, 0x8000DCFD8000DCF9, 0x000601B5000635B6, 0x000671BB8000DD01, 0x8000DD0500066DBA, 0x000651BF8000DD09, 0x000661BD000669BE, 
0x00001982000669BC, 0x00006580000641A3, 0x000671A600001981, 0x8000DD118000DD0D, 0x000629AA000645A5, 0x00032484000635AB, 0x00062DAE8000DD15, 0x00062DAC000615AF, 
0x0006A5B3000625AD, 0x000148868000DD19, 0x8000DD1D00010C87, 0x0006B5B50006A9B6, 0x0006C9BB8000DD21, 0x8000DD250006F9BA, 0x00011DBF8000DD29, 0x00011DBD00011DBE, 
0x8000DD2D0006D1BC, 0x8000DD358000DD31, 0x0005CCE38000DD39, 0x00053CE18000DD3D, 0x0004B8EF8000DD41, 0x8000DD498000DD45, 0x8000DD518000DD4D, 0x8000DD598000DD55, 
0x00061DA88000DD5D, 0x00062DAA000625A9, 0x00063DAC000625AB, 0x00065DAE000629AD, 0x8000DD6100064DAF, 0x8000DD698000DD65, 0x8000DD718000DD6D, 0x8000DD798000DD75, 
0x0001F9B88000DD7D, 0x00014DBA0001F9B9, 0x00015DBC000145BB, 0x000145BE000145BD, 0x00063DB0000175BF, 0x000605B200060DB1, 0x0001D9B40001C9B3, 0x0001C9B60001D9B5, 
0x0003B9800001C9B7, 0x000019820003B981, 0x8000DD810005A9A3, 0x0005A5A60005B9A5, 0x8000DD8900028484, 0x0005F5AA0003A8BE, 0x0005DDAC0005C5AB, 0x000211AE000211AD, 
0x000301B6000211AF, 0x000344848000DD8D, 0x8000DD91000361B5, 0x0003D887000349B3, 0x000309BE001CF886, 0x000335BC000309BF, 0x00033DBA000309BD, 0x8000DD95000321BB, 
0x0003CDB08000DD99, 0x0003D5B20003D1B1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 0x0003D9B80003E9B7, 0x000309BA0003D9B9, 0x000319BC000309BB, 0x000309BE000319BD, 
0x8000DD9D000309BF, 0x002169B58000DDA1, 0x8000DDA98000DDA5, 0x8000DDB18000DDAD, 0x0003E5A88000DC35, 0x0003F5AA0003F5A9, 0x0003DDAC0003C5AB, 0x0003BDAE0003B5AD, 
0x00021DA30003B5AF, 0x8000DDB98000DDB5, 0x001D1CBE8000DDBD, 0x000235A5000255A6, 0x000275AB8000DDC1, 0x8000DDC5000269AA, 0x00025DAF8000DDC9, 0x00025DAD00025DAE, 
0x8000DDCD000261AC, 0x8000DDD58000DDD1, 0x00038CEF8000DDD9, 0x8000DDE18000DDDD, 0x00036CE38000DDE5, 0x000078E18000DDE9, 0x8000DDF18000DDED, 0x001C58868000DDF9, 
0x0000E580001DF087, 0x0000F9820000E981, 0x8000DE018000DDFD, 0x8000DE098000DE05, 0x8000DE0D0006D4EF, 0x8000DE11000674E1, 0x8000DE15000154E3, 0x8000DE1D8000DE19, 
0x000191B38000DE21, 0x8000DE298000DE25, 0x8000DE2D001DC484, 0x0001A5B5000115B6, 0x000135BB8000DE31, 0x8000DE35000135BA, 0x0000FDBF8000DE39, 0x0000FDBD0000FDBE, 
0x001E45A9000125BC, 0x001E71AB001E25A8, 0x001ED1AD001E5DAA, 0x001ED5AF001E69AC, 0x8000DDF5001ED9AE, 0x8000DE418000DE3D, 0x8000DE498000DE45, 0x8000DE518000DE4D, 
0x001F01B98000DE55, 0x001F01BB001F69B8, 0x001F05BD001F09BA, 0x001F05BF001F19BC, 0x001EB5B1001F05BE, 0x001F6DB3001EB5B0, 0x001F7DB5001EB5B2, 0x001F51B7001F7DB4, 
0x001ED1A3001F61B6, 0x0000158100002D82, 0x8000DE5900001D80, 0x001EE5A5001E55A6, 0x001E75AB8000DE5D, 0x8000DE61001E75AA, 0x001FBDAF000360BE, 0x001FBDAD001FBDAE, 
0x8000DE65001E65AC, 0x00006886001F55B3, 0x001F71B600036C87, 0x8000DE6D8000DE69, 0x001F55BA001F45B5, 0x8000DE71001F5DBB, 0x001F39BE8000DE75, 0x001F45BC001F25BF, 
0x8000DE79001F39BD, 0x8000DE818000DE7D, 0x8000DE898000DE85, 0x8000DE918000DE8D, 0x8000DE95001CF4EF, 0x8000DE99001D60E1, 0x8000DE9D001D74E3, 0x8000DEA58000DEA1, 
0x001ED1A38000DEA9, 0x8000DEB18000DEAD, 0x8000DEB98000DEB5, 0x001EC1A5001EF5A6, 0x001ED9AB8000DEBD, 0x8000DEC1001ED1AA, 0x001EA1AF8000DEC5, 0x001EBDAD001EBDAE, 
0x001EF5A8001EC1AC, 0x001E19AA001E09A9, 0x001E09AC001E19AB, 0x001E31AE001E35AD, 0x00000D80001E2DAF, 0x00001D8200001581, 0x8000DECD8000DEC9, 0x0001FC848000DED1, 
0x001E2DB80001F0BE, 0x0001E1BA0001E1B9, 0x0001E1BC0001E1BB, 0x0001E1BE0001E1BD, 0x001E55B00001E1BF, 0x001E55B2001E5DB1, 0x001E39B4001E29B3, 0x001E25B6001E25B5, 
0x0002D5A8001E15B7, 0x0002E1AA0002DDA9, 0x000311AC0002E1AB, 0x000311AE000311AD, 0x8000DED9000311AF, 0x8000DEE18000DEDD, 0x8000DEE98000DEE5, 0x8000DEF18000DEED, 
0x00037DB88000DEF5, 0x000301BA000301B9, 0x000301BC000301BB, 0x000331BE000309BD, 0x000371B0000331BF, 0x000371B2000371B1, 0x000359B400034DB3, 0x00034DB6000345B5, 
0x00042086000345B7, 0x000261B30003A087, 0x000391B5000480BE, 0x8000DEFD8000DEF9, 0x8000DD85000399B6, 0x0003BDBB0003B884, 0x000391BD0003BDBA, 0x000389BF0003ADBC, 
0x000229A3000395BE, 0x8000DF058000DF01, 0x000694858000DF09, 0x0003D9A50003D1A6, 0x0003F5AB8000DF0D, 0x8000DF110003F5AA, 0x0003C1AF8000DF15, 0x0003D9AD0003DDAE, 
0x8000DF190003E5AC, 0x8000DF218000DF1D, 0x8000DF298000DF25, 0x8000DF318000DF2D, 0x000011818000DF35, 0x8000DF3900000D80, 0x8000DF3D00001982, 0x8000DF498000DF41, 
0x8000DF518000DF4D, 0x8000DF55000194E1, 0x8000DF590000E4E3, 0x000478868000DF5D, 0x8000DF6100028087, 0x8000DF698000DF65, 0x8000DF718000DF6D, 0x8000DF798000DF75, 
0x8000DF7D000038EF, 0x8000DF858000DF81, 0x8000DF8D8000DF89, 0x8000DF958000DF91, 0x00046CBE0001C8EF, 0x0005A084001EC4E1, 0x8000DF99001E70E3, 0x8000DFA18000DF9D, 
0x8000DFA98000DFA5, 0x0001F9B50001F1B6, 0x0001F9B30020F485, 0x0000218100002982, 0x00013DBF00001D80, 0x000121BD000129BE, 0x000169BB000129BC, 0x8000DFAD000161BA, 
0x000621A88000DFB1, 0x000621AA000621A9, 0x000621AC000621AB, 0x000621AE000621AD, 0x8000DF45000621AF, 0x000C008600012CBF, 0x8000DFB500036087, 0x8000DFBD8000DFB9, 
0x000741B88000DFC1, 0x000741BA000741B9, 0x000741BC000741BB, 0x000741BE000741BD, 0x0006F5B0000741BF, 0x0006ADB20006FDB1, 0x0006BDB40006A5B3, 0x000691B60006A9B5, 
0x0006A9A3000691B7, 0x8000DFC98000DFC5, 0x8000DFD18000DFCD, 0x0006A9A50006A1A6, 0x000639AB8000DFD5, 0x8000DFD9000631AA, 0x00066DAF8000DFDD, 0x000671AD000679AE, 
0x8000DFE1000679AC, 0x8000DFE5000785B3, 0x000785B68000DFE9, 0x8000DFF18000DFED, 0x000789BA00078DB5, 0x8000DFF5000789BB, 0x000789BE8000DFF9, 0x000789BC000775BF, 
0x8000DFFD000789BD, 0x00057CEF0005C0E1, 0x8000E0010004D4E3, 0x8000E0098000E005, 0x8000E0118000E00D, 0x8000E0198000E015, 0x0005A8E18000E01D, 0x00058CE38000E021, 
0x000601A3000CF8EF, 0x0000658100007182, 0x0001808400006580, 0x000609A5000601A6, 0x00060DAB000010BE, 0x000FE88600060DAA, 0x0006F1AF00001887, 0x00060DAD00060DAE, 
0x0006B9A800060DAC, 0x0006C9AA0006B9A9, 0x0006C1AC0006C5AB, 0x0006F9AE0006C1AD, 0x8000E0290006F9AF, 0x8000E0318000E02D, 0x8000E0398000E035, 0x8000E0418000E03D, 
0x00064DB88000E045, 0x00065DBA000655B9, 0x000661BC000655BB, 0x000661BE000661BD, 0x000689B0000661BF, 0x000699B2000689B1, 0x000689B4000699B3, 0x00067DB6000675B5, 
0x8000E049000675B7, 0x000285B600028DB5, 0x03E8F18F000C4084, 0x8000E0518000E04D, 0x0002E1BC000221B3, 0x0002E5BE0002EDBD, 0x0032C8AC0002F9BF, 0x000291BA8000E055, 
0x001F019B000291BB, 0x001E4D99001E4D9A, 0x0004F19F00133D98, 0x001A799D001AB99E, 0x001641930018819C, 0x03EAF99100149192, 0x0012619703EA4D90, 0x0010819500127196, 
0x003801B100164194, 0x003A81B3003EE1B0, 0x002691B5003A89B2, 0x8000E059003BD1B4, 0x000281A38000E05D, 0x000669A1000011A2, 0x8000E06100068DA0, 0x8000E0658000DED5, 
0x0002F1A18000E069, 0x000ECDA38000E06D, 0x000801A5000ECDA2, 0x000BC5A7000F51A4, 0x0036C1A9000AFDA6, 0x003001AB003401A8, 0x0032CDAD003641AA, 0x003EFDAF0032D5AC, 
0x03E9E182003C01AE, 0x8000E07103EB2583, 0x001731868000E075, 0x03EB898400172987, 0x0011D98A0015E985, 0x8000E0790013218B, 0x001F358E8000E07D, 0x0013298C001F3D8F, 
0x001E019200124D8D, 0x8000E08100199993, 0x0005F196000C0084, 0x001B799400077597, 0x0007A19A001BB195, 0x8000E0850001D19B, 0x0000F1818000E089, 0x0003599C00001980, 
0x8000E08D0000F982, 0x000DC0BE8000E091, 0x000C3086000028EF, 0x8000E099000D5C87, 0x8000E09D0006C4EF, 0x8000E0A10006E4E1, 0x8000E0A5000614E3, 0x8000E0A9000184E1, 
0x0003FDA30000FCE3, 0x8000E0B18000E0AD, 0x8000E0B5000F4C84, 0x000351A5000359A6, 0x00034DAB8000E0B9, 0x8000E0BD00034DAA, 0x000325AF8000E0C1, 0x000331AD000339AE, 
0x8000E02500033DAC, 0x8000E0C58000E095, 0x8000E0CD8000E0C9, 0x8000E0D58000E0D1, 0x000D81A88000E0D9, 0x000D81AA000D81A9, 0x000D81AC000D81AB, 0x000D81AE000D81AD, 
0x000E41B0000D81AF, 0x000E51B2000E51B1, 0x000EC9B4000E79B3, 0x000EE9B6000EC9B5, 0x000EDDB8000EE5B7, 0x000F61BA000EA1B9, 0x000F59BC000F61BB, 0x000F31BE000F59BD, 
0x000D29B3000F15BF, 0x8000E0E18000E0DD, 0x8000E0E98000E0E5, 0x000D29B5000D21B6, 0x000EB5BB8000E0ED, 0x8000E0F1000EA5BA, 0x000E2DBF8000E0F5, 0x000E8DBD000E2DBE, 
0x00002982000EA5BC, 0x00001D80000D6DA3, 0x000D65A600001581, 0x8000E0FD8000E0F9, 0x000EE1AA000D6DA5, 0x8000E101000EF1AB, 0x000E69AE0003A4BE, 0x000EE1AC000E69AF, 
0x000E99A8000EC9AD, 0x000EA1AA000EA5A9, 0x000EA9AC000EBDAB, 0x000ED1AE000ED1AD, 0x00008086000ECDAF, 0x8000E10900010487, 0x8000E1118000E10D, 0x8000E1198000E115, 
0x00015DB88000E11D, 0x0001C1BA0001C1B9, 0x0001C1BC0001C1BB, 0x0001F1BE0001C9BD, 0x000EBDB00001F1BF, 0x000E85B2000E8DB1, 0x00017DB4000165B3, 0x00016DB6000165B5, 
0x000E29B3000165B7, 0x8000E1218000E105, 0x8000E1298000E125, 0x000E21B5000E51B6, 0x000E49BB8000E12D, 0x8000E131000E79BA, 0x0001A1BF8000E135, 0x0001B1BD0001B9BE, 
0x8000E139000E51BC, 0x8000E13D000E6DA3, 0x000E15A68000E141, 0x8000E1498000E145, 0x000E3DAA000E65A5, 0x8000E14D000E0DAB, 0x0001FDAE8000E151, 0x000E15AC0001E5AF, 
0x000138E10001F5AD, 0x000FD4E38000E155, 0x8000E15D8000E159, 0x8000E161000358BE, 0x00000D808000E165, 0x00001D8200001581, 0x8000E16D8000E169, 0x0002D4EF8000E171, 
0x0004E0868000E179, 0x000400BE0003E087, 0x8000E17D00037DB3, 0x000365B600036DB5, 0x8000E1858000E181, 0x0003F9BA8000E189, 0x0003D9BC0003F1BB, 0x0003B9BE0003D9BD, 
0x000EBDAA0003B5BF, 0x000EBDA8000E01AB, 0x000E01AE000EB5A9, 0x000E11AC000E09AF, 0x8000E18D000E11AD, 0x8000E1958000E191, 0x8000E19D8000E199, 0x8000E1A58000E1A1, 
0x000FD1BA8000E1A9, 0x000E25B8000FD1BB, 0x000FF1BE000FCDB9, 0x000FC1BC000FF1BF, 0x000E21B2000FC1BD, 0x000E41B0000E2DB3, 0x000E29B6000E41B1, 0x000E35B4000E1DB7, 
0x000229A8000E29B5, 0x000239AA000229A9, 0x000229AC000239AB, 0x000291AE000229AD, 0x8000E1AD000291AF, 0x8000E1B58000E1B1, 0x8000E1BD8000E1B9, 0x002B30BF8000E1C1, 
0x000299B88000E1C5, 0x0002A5BA0002ADB9, 0x00015DBC000149BB, 0x000141BE000145BD, 0x0002F1B0000141BF, 0x0002C1B20002F9B1, 0x0002B1B40002C1B3, 0x0002B5B60002BDB5, 
0x000E08E10002A9B7, 0x000ED4E3000CF4E1, 0x8000E1C9000F90E3, 0x8000E1D18000E1CD, 0x000011818000E1D5, 0x8000E1D900000D80, 0x8000E1DD00001982, 0x0001ACEF8000E1E1, 
0x0002F1A3000ECCEF, 0x8000E1ED8000E1E9, 0x8000E1F100058084, 0x0002E1A50002E9A6, 0x00027DAB8000E1F5, 0x0004C886000275AA, 0x000239AF0004EC87, 0x000255AD000235AE, 
0x00063DA8000255AC, 0x000655AA000655A9, 0x000675AC00066DAB, 0x0006BDAE0006B5AD, 0x8000E1E50006B5AF, 0x8000E1FD8000E1F9, 0x8000E2058000E201, 0x8000E20D8000E209, 
0x00076DB88000E211, 0x00077DBA000775B9, 0x0007C1BC000771BB, 0x0007C1BE0007C1BD, 0x0006CDB00007C1BF, 0x0006DDB20006D5B1, 0x0006CDB40006D5B3, 0x00075DB6000755B5, 
0x0006DDB3000755B7, 0x8000E2198000E215, 0x8000E2218000E21D, 0x0006FDB5000635B6, 0x000611BB8000E225, 0x8000E229000609BA, 0x000791BF8000E22D, 0x000601BD000609BE, 
0x8000E231000609BC, 0x8000E235000699A3, 0x000671A68000E239, 0x8000E2418000E23D, 0x00064DAA0006B9A5, 0x8000E245000655AB, 0x00064DAE8000E249, 0x00064DAC0007D5AF, 
0x0001ED80000645AD, 0x0000198200000981, 0x8000E2518000E24D, 0x0001C4BE0001D084, 0x000080868000E255, 0x8000E25900012087, 0x8000E2618000E25D, 0x8000E2698000E265, 
0x8000E2718000E26D, 0x8000E2798000E275, 0x8000E2818000E27D, 0x8000E28500050CE1, 0x8000E289000480E3, 0x8000E2918000E28D, 0x8000E2950005DCEF, 0x8000E29D8000E299, 
0x000645A88000E2A1, 0x000659AA00064DA9, 0x0001B5AC000651AB, 0x0001B5AE0001BDAD, 0x0001AC840001ADAF, 0x8000E2A98000E2A5, 0x8000E2B18000E2AD, 0x8000E2B98000E2B5, 
0x000169B88000E2BD, 0x000109BA000169B9, 0x00011DBC000105BB, 0x000101BE000101BD, 0x0001D5B0000135BF, 0x0001D5B20001DDB1, 0x000179B4000169B3, 0x000169B6000179B5, 
0x0003BD81000161B7, 0x0005D9B30003BD80, 0x000235B500001982, 0x000344BE8000E2C1, 0x8000E2C9000235B6, 0x000211BB8000E2CD, 0x0002B5BD000219BA, 0x0002B5BF000209BC, 
0x8000E2D10002B5BE, 0x00026DA500026DA6, 0x000581A3003C0084, 0x003CF8868000E2D5, 0x0002EDAF00037C87, 0x0002EDAD0002EDAE, 0x000249AB000251AC, 0x8000E2D9000241AA, 
0x8000E2E18000E2DD, 0x8000E2E98000E2E5, 0x000120E38000E2ED, 0x0001A0E18000E2F1, 0x000240EF8000E2F5, 0x8000E2FD8000E2F9, 0x8000E3058000E301, 0x8000E30D8000E309, 
0x0003F1B38000E311, 0x8000E3198000E315, 0x8000E1758000E31D, 0x0003E1B50003E9B6, 0x0003ADBB8000E321, 0x8000E3250003ADBA, 0x000395BF8000E329, 0x0003A1BD000395BE, 
0x000229A80003ADBC, 0x000239AA000229A9, 0x000229AC000239AB, 0x000259AE000229AD, 0x0001CD80000259AF, 0x0000198200000981, 0x8000E3318000E32D, 0x003DB487003D7CBE, 
0x000235B8003C1C86, 0x000235BA00023DB9, 0x0002F9BC0002E9BB, 0x0002E9BE0002F9BD, 0x000229B00002E9BF, 0x000239B2000229B1, 0x000211B4000235B3, 0x000211B6000211B5, 
0x8000E33900020DB7, 0x8000E3418000E33D, 0x8000E3498000E345, 0x8000E3518000E34D, 0x8000E35500007CEF, 0x8000E359000654E1, 0x0032CCAC0000A8E3, 0x8000E3618000E35D, 
0x8000E3698000E365, 0x0002F1A50002F9A6, 0x0002E1A38000E36D, 0x8000E3758000E371, 0x000285AF8000E379, 0x0002B1AD000285AE, 0x0002BDAB0002BDAC, 0x8000E37D0002BDAA, 
0x003E21A88000E381, 0x003E49AA003E21A9, 0x003E69AC003E59AB, 0x003E99AE003E69AD, 0x8000E335003E99AF, 0x8000E3898000E385, 0x8000E3918000E38D, 0x8000E3998000E395, 
0x003EF5B88000E39D, 0x003EF5BA003EFDB9, 0x003E99BC003E89BB, 0x003E85BE003E99BD, 0x003EE9B0003EB5BF, 0x003EFDB2003EE9B1, 0x003ED5B4003EF1B3, 0x003ED5B6003EDDB5, 
0x003EC1B3003ECDB7, 0x0000B58100001582, 0x8000E3A10000B580, 0x003EE1B5003EE9B6, 0x003E2DBB000010BE, 0x00036484003E2DBA, 0x003E19BF8000E3A5, 0x003E25BD003E11BE, 
0x8000E3A9003E29BC, 0x0000A886003E85A3, 0x003EADA600036C87, 0x8000E3B18000E3AD, 0x003E69AA003EA5A5, 0x8000E3B5003E69AB, 0x003E55AE8000E3B9, 0x003E6DAC003E5DAF, 
0x003E89B3003E61AD, 0x8000E3C18000E3BD, 0x8000E3C98000E3C5, 0x003E89B5003E81B6, 0x003E95BB8000E3CD, 0x8000E3D1003E8DBA, 0x003EFDBF8000E3D5, 0x003E85BD003EF5BE, 
0x8000E3D9003E85BC, 0x8000E3E18000E3DD, 0x8000E3E98000E3E5, 0x003C94EF8000E3ED, 0x003D20E18000E3F1, 0x003D34E38000E3F5, 0x8000E3FD8000E3F9, 0x8000E4058000E401, 
0x003E01A88000E409, 0x003E01AA003E01A9, 0x003E01AC003E01AB, 0x003E01AE003E01AD, 0x0000DD80003E3DAF, 0x0000198200000981, 0x8000E4118000E40D, 0x000074BE00013C84, 
0x003E1DB88000E419, 0x003E35BA003E3DB9, 0x0001F9BC0001E9BB, 0x0001E9BE0001F9BD, 0x003E49B00001E9BF, 0x003E51B2003E51B1, 0x003E31B4003E51B3, 0x003E2DB6003E39B5, 
0x003D89A3003E25B7, 0x0004A8868000E41D, 0x8000E42100033C87, 0x003D89A5003D81A6, 0x003D95AB8000E425, 0x8000E429003D8DAA, 0x003DFDAF8000E42D, 0x003D85AD003DF5AE, 
0x8000E431003D85AC, 0x0003488400029DB3, 0x000355B6000440BE, 0x8000E4398000E435, 0x000371BA0002B1B5, 0x8000E43D000379BB, 0x000331BE8000E441, 0x000351BC000331BF, 
0x0003D1B8000351BD, 0x0003D5BA0003D1B9, 0x0003FDBC0003E9BB, 0x0003EDBE0003E5BD, 0x0003B1B00003E5BF, 0x000381B20003B9B1, 0x0003F1B4000381B3, 0x0003F1B60003F1B5, 
0x000201A80003F1B7, 0x000211AA000211A9, 0x00023DAC000225AB, 0x0003D1AE0003D1AD, 0x8000E4450003D1AF, 0x8000E4498000E2C5, 0x8000E4518000E44D, 0x8000E4598000E455, 
0x8000E4618000E45D, 0x8000E4698000E465, 0x000050EF8000E46D, 0x8000E4758000E471, 0x000084E38000E479, 0x0001F8E18000E47D, 0x00002D808000E481, 0x0000158200001181, 
0x000399A38000E489, 0x8000E4918000E48D, 0x8000E4998000E495, 0x0003B5A5000251A6, 0x00027DAB8000E49D, 0x8000E4A1000275AA, 0x000235AF8000E4A5, 0x000255AD000235AE, 
0x0004A086000255AC, 0x8000E4A90005A887, 0x8000E4B18000E4AD, 0x8000E4B98000E4B5, 0x00042CBE0001F8EF, 0x8000E4BD003E80E1, 0x8000E4C1000114E3, 0x8000E4C98000E4C5, 
0x8000E4D18000E4CD, 0x8000E4D98000E4D5, 0x8000E4DD0001DDB3, 0x0001F5B60001FDB5, 0x8000E4E58000E4E1, 0x0001B1BA8000E4E9, 0x00019DBC000185BB, 0x000111BE000115BD, 
0x0005BDA8000111BF, 0x000619AA000601A9, 0x000639AC000611AB, 0x000659AE000639AD, 0x8000E485000649AF, 0x0000198100001182, 0x8000E4ED0007C980, 0x000230848000E4F1, 
0x0006B9B88000E4F5, 0x000749BA0006B9B9, 0x000759BC000749BB, 0x00074DBE000759BD, 0x000639B0000745BF, 0x000605B200060DB1, 0x000699B400068DB3, 0x000689B6000699B5, 
0x000691A3000689B7, 0x000028868000E4F9, 0x8000E4FD0003FC87, 0x0006B1A50006B9A6, 0x0006C9AB8000E501, 0x8000E5050006FDAA, 0x00065DAF8000E509, 0x000659AD00065DAE, 
0x8000E50D0006D1AC, 0x8000E51100078DB3, 0x00078DB68000E515, 0x8000E51D8000E519, 0x000769BA00078DB5, 0x8000E521000769BB, 0x000769BE8000E525, 0x000769BC00075DBF, 
0x000649A3000769BD, 0x8000E52D8000E529, 0x8000E5358000E531, 0x000649A5000649A6, 0x0006ADAB8000E539, 0x8000E53D0006ADAA, 0x000699AF8000E541, 0x0006ADAD0006ADAE, 
0x8000E5450006ADAC, 0x8000E54D8000E549, 0x8000E5558000E551, 0x8000E5590005E0EF, 0x8000E5618000E55D, 0x0001248400053CE3, 0x0000298000057CE1, 0x0000198200002981, 
0x0006BDA8000134BE, 0x0006C1AA0006C1A9, 0x0006C1AC0006C1AB, 0x0006F1AE0006C9AD, 0x000000860006F1AF, 0x8000E56900008487, 0x8000E5718000E56D, 0x8000E5798000E575, 
0x000679B88000E57D, 0x000609BA000679B9, 0x000619BC000609BB, 0x000605BE000605BD, 0x000669B000063DBF, 0x000679B2000669B1, 0x000669B4000679B3, 0x000649B600065DB5, 
0x000285A8000649B7, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 0x0002D1AE0002D5AD, 0x8000E5810002D1AF, 0x000328848000E585, 0x8000E589000989B5, 0x8000E5918000E58D, 
0x00035DB88000E595, 0x000365BA00036DB9, 0x000315BC00030DBB, 0x000315BE00031DBD, 0x0002B5B000030DBF, 0x000281B20002BDB1, 0x000375B4000281B3, 0x000375B600037DB5, 
0x00021DB300036DB7, 0x8000E59D8000E599, 0x000C1CBE8000E5A1, 0x000235B5000255B6, 0x000279BB8000E5A5, 0x8000E5A9000271BA, 0x0003B9BF8000E5AD, 0x000255BD0003B1BE, 
0x8000E5B1000255BC, 0x8000E5B5000259A3, 0x000211A68000E5B9, 0x8000E5C18000E5BD, 0x000235AA000271A5, 0x8000E41500023DAB, 0x0003F5AE8000E5C5, 0x000211AC0003FDAF, 
0x0002A9A8000211AD, 0x0002B9AA0002A9A9, 0x0002A9AC0002B9AB, 0x000139AE0002A9AD, 0x00000D80000139AF, 0x00001D8200001581, 0x8000E5CD8000E5C9, 0x000D68878000E5D1, 
0x0001E9B8000D1C86, 0x000189BA0001E9B9, 0x00019DBC000185BB, 0x000181BE000181BD, 0x000151B00001B1BF, 0x000151B2000151B1, 0x0001F5B4000151B3, 0x0001F5B60001FDB5, 
0x000004EF0001E1B7, 0x8000E5D9000C4884, 0x8000E5DD000C80BE, 0x8000E5E58000E5E1, 0x8000E5E90006C4EF, 0x8000E5ED00063CE1, 0x0000C8E3000184E3, 0x000128E18000E5F1, 
0x8000E5F98000E5F5, 0x8000E6018000E5FD, 0x8000E60500027DB3, 0x000265B600026DB5, 0x8000E60D8000E609, 0x0001D9BA8000E611, 0x0001C9BC0001D9BB, 0x00017DBE0001C9BD, 
0x000DB1A3000175BF, 0x8000E6158000E5D5, 0x8000E61D8000E619, 0x000DA1A5000DA9A6, 0x000E15AB8000E621, 0x8000E625000E15AA, 0x000EB9AF8000E629, 0x000E05AD000EB1AE, 
0x8000E62D000E05AC, 0x8000E6358000E631, 0x00001D808000E639, 0x0000398200000981, 0x8000E6418000E63D, 0x0000C8868000E645, 0x8000E64900030C87, 0x8000E6518000E64D, 
0x000F09A88000E655, 0x000F1DAA000F15A9, 0x000F31AC000F15AB, 0x000F2DAE000F3DAD, 0x0003A884000F21AF, 0x8000E65D8000E659, 0x8000E6658000E661, 0x8000E66D8000E669, 
0x0000CDB88000E671, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 0x00009DBE000095BD, 0x000F21B0000095BF, 0x000F21B2000F21B1, 0x000F2DB4000F3DB3, 0x000F1DB6000F15B5, 
0x000E95B30000F5B7, 0x8000E6798000E675, 0x8000E6818000E67D, 0x000EB9B5000EBDB6, 0x000EE5BB8000E685, 0x8000E689000EE5BA, 0x000ED1BF8000E68D, 0x000EE9BD000EE9BE, 
0x000D28EF000EF5BC, 0x8000E6958000E691, 0x8000E69D8000E699, 0x8000E6A58000E6A1, 0x00003D808000E6A9, 0x00001D8200000981, 0x000D48E38000E6AD, 0x000EC0E18000E6B1, 
0x000E15A300017CBE, 0x000028868000E6B9, 0x8000E6BD00014C87, 0x000E39A5000E3DA6, 0x000E65AB8000E6C1, 0x8000E6C5000E65AA, 0x000E51AF8000E6C9, 0x000E69AD000E69AE, 
0x8000E6CD000E75AC, 0x8000E6D10001BDB3, 0x000179B68000E6D5, 0x8000E6DD8000E6D9, 0x000155BA000179B5, 0x8000E6E100015DBB, 0x0000F9BE8000E6E5, 0x000145BC0000F9BF, 
0x000271A80000F9BD, 0x000271AA000271A9, 0x0002B5AC000271AB, 0x0002B5AE0002BDAD, 0x0004EC840002ADAF, 0x8000E6ED8000E6E9, 0x8000E6F58000E6F1, 0x8000E6FD8000E6F9, 
0x000369B88000E701, 0x00030DBA000369B9, 0x00031DBC000305BB, 0x00030DBE000305BD, 0x0002D5B0000305BF, 0x0002D5B20002DDB1, 0x000379B4000369B3, 0x000369B6000379B5, 
0x8000E705000361B7, 0x8000E70D8000E709, 0x8000E7110002F5A3, 0x000231A6000231A5, 0x8000E7198000E715, 0x00021DAA8000E71D, 0x00020DAC000215AB, 0x0003B1AE0003B1AD, 
0x000061800003B1AF, 0x0000058200006181, 0x0004F0868000E721, 0x000410BE00036087, 0x8000E72D8000E729, 0x8000E7358000E731, 0x8000E73D8000E739, 0x8000E7458000E741, 
0x000285A88000E565, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 0x0002D1AE0002D5AD, 0x8000E7490002D1AF, 0x8000E7518000E74D, 0x8000E7598000E755, 0x8000E7618000E75D, 
0x000175B88000E765, 0x000175BA00017DB9, 0x0001D5BC0001CDBB, 0x0001C9BE0001DDBD, 0x0002B5B00001C1BF, 0x000281B20002BDB1, 0x000155B4000281B3, 0x000155B600015DB5, 
0x000EA4E100014DB7, 0x000E1CE300040884, 0x00049CBE8000E769, 0x8000E7718000E76D, 0x8000E7798000E775, 0x8000E7818000E77D, 0x000075818000E785, 0x000ECCEF00007580, 
0x8000E78900007582, 0x8000E7918000E78D, 0x8000E7990004C484, 0x00005CEF8000E79D, 0x000190E18000E7A1, 0x000158E38000E7A5, 0x8000E7AD8000E7A9, 0x000758868000E7B1, 
0x00059DB30004EC87, 0x8000E7958000E725, 0x8000E7B98000E7B5, 0x0005B5B50005D5B6, 0x0005F9BB8000E7BD, 0x8000E7C10005F1BA, 0x000619BF8000E7C5, 0x0005D5BD000611BE, 
0x8000E7C90005D5BC, 0x8000E7CD0005D9A3, 0x000591A68000E7D1, 0x8000E7D98000E7D5, 0x0005B5AA0005F1A5, 0x8000E7DD0005BDAB, 0x000655AE8000E7E1, 0x000591AC00065DAF, 
0x00065DA8000591AD, 0x00066DAA000665A9, 0x00067DAC000665AB, 0x00066DAE000665AD, 0x0000A0BE000665AF, 0x8000E7E98000E7E5, 0x8000E7F18000E7ED, 0x8000E7F98000E7F5, 
0x00074DB88000E7FD, 0x000751BA000751B9, 0x000771BC000751BB, 0x000771BE000771BD, 0x0007C1B0000771BF, 0x0007C1B20007C1B1, 0x0007C1B40007C1B3, 0x0007C1B60007C1B5, 
0x8000E8010007C1B7, 0x8000E809000694E1, 0x0001A98000053CE3, 0x000019820001A981, 0x000080868000E80D, 0x8000E81100010487, 0x8000E8198000E815, 0x8000E8218000E81D, 
0x0007A5B300051CEF, 0x8000E8258000E805, 0x8000E82D8000E829, 0x0007B5B50007A5B6, 0x000645BB8000E831, 0x8000E835000645BA, 0x000645BF8000E839, 0x000655BD000645BE, 
0x000765A3000655BC, 0x8000E8418000E83D, 0x8000E8498000E845, 0x000775A5000765A6, 0x000685AB8000E84D, 0x8000E851000685AA, 0x000685AF8000E855, 0x000695AD000685AE, 
0x8000E859000695AC, 0x8000E85D000619B3, 0x000621B68000E861, 0x8000E8698000E865, 0x0001F1BA000631B5, 0x8000E86D0001F9BB, 0x0001B1BE8000E871, 0x0001D1BC0001BDBF, 
0x0005D1A80001D1BD, 0x0005D5AA0005D1A9, 0x0005FDAC0005E9AB, 0x0005EDAE0005E5AD, 0x0003F980000211AF, 0x0003C5820003CD81, 0x001C00BE00032084, 0x000304878000E879, 
0x000219B8001CBC86, 0x000225BA00022DB9, 0x0002F9BC0002E9BB, 0x0002E9BE0002F9BD, 0x000271B00002E9BF, 0x000241B2000279B1, 0x000231B4000241B3, 0x000235B600023DB5, 
0x8000E6B5000229B7, 0x8000E8818000E87D, 0x8000E885000551A3, 0x000569A6000579A5, 0x8000E88D8000E889, 0x0002B9AA8000E891, 0x000299AC0002B1AB, 0x0002F9AE000299AD, 
0x0001F8E10002F5AF, 0x0002F4E38000E895, 0x8000E899001CC084, 0x8000E8A18000E89D, 0x8000E8A98000E8A5, 0x8000E8B18000E8AD, 0x8000E8B98000E8B5, 0x000230EF8000E8BD, 
0x000209A88000E8C1, 0x000221AA000219A9, 0x000221AC000221AB, 0x000221AE000221AD, 0x8000E8C5000255AF, 0x8000E8CD8000E8C9, 0x8000E8D58000E8D1, 0x0000AD810000AD82, 
0x0002D1B80000AD80, 0x0002E1BA0002D9B9, 0x000291BC0002E1BB, 0x000295BE00029DBD, 0x00022DB0000289BF, 0x000235B2000235B1, 0x00021DB4000205B3, 0x0002F1B60002F1B5, 
0x000748E10002F1B7, 0x00061CE3000658E3, 0x8000E8D900066CE1, 0x8000E8E18000E8DD, 0x80001A72001C10BE, 0x000005B580001A76, 0x003B30E180001A7A, 0x0006D0EF0001ECEF, 
0x0002E9B30032BCE1, 0x80001A7E0002DCAC, 0x001D0CAC000005B5, 0x0002E9B50002E1B6, 0x0002B1BB80001A82, 0x001D28AC0002A9BA, 0x000275BF80001A86, 0x000291BD000299BE, 
0x8000E8750002A1BC, 0x001FD5B5001D70E1, 0x001D48E1001D6CE1, 0x0002B4E1001FF9B5, 0x001E15A8000258AC, 0x001EA1AA001EA1A9, 0x001EADAC001EBDAB, 0x001E9DAE001E95AD, 
0x001E91B0001EF9AF, 0x001E91B2001E91B1, 0x001EB1B4001E91B3, 0x001EB1B6001EB1B5, 0x001E91B8001EB1B7, 0x001E95BA001E91B9, 0x001F55BC001F4DBB, 0x001F55BE001F5DBD, 
0x001DDDAC001F4DBF, 0x001DE5AE001DEDAD, 0x000005B5001D09AF, 0x001DD5AA80001A8A, 0x0002BCE1001DCDAB, 0x001D9DA6001D95A5, 0x000005B50002C8AC, 0x0002CCE180001A8E, 
0x001E49B3001D95A3, 0x80001A920002DCAC, 0x0002BCE1000005B5, 0x001E45B5001E75B6, 0x001E35BB0002E0AC, 0x000005B5001E35BA, 0x001E15BF80001A96, 0x001E25BD001E15BE, 
0x001F89A3001E25BC, 0x000380820025358F, 0x0002D8AC0002ACE1, 0x001F85A5001FB5A6, 0x001FF5AB000035B5, 0x80001A9A001FF5AA, 0x001FD5AF80000B94, 0x001FE5AD001FD5AE, 
0x0019259E001FE5AC, 0x001BB59C001FC59F, 0x0015719A0019499D, 0x0011F5980015699B, 0x001385960017B599, 0x002D499400114597, 0x0028F592002C7195, 0x00297990002FA593, 
0x00000DAC00297991, 0x000011AE000015AD, 0x800009AE800006BE, 0x800006C980000C84, 0x800006F1800006DE, 0x800006F980000CB4, 0x001CF5A280000CB7, 0x001DBDA00001B5A3, 
0x0005E9BC001DB5A1, 0x0005F9BE000051BD, 0x0005C1B80005F5BF, 0x0005F9BA0005CDB9, 0x00003DB480000709, 0x0005E9B6000401B5, 0x00006DB00005E5B7, 0x0000D5B2000055B1, 
0x00263182000055B3, 0x80001A9E002A0583, 0x002CC186000280CC, 0x002A1D84002E3587, 0x002F3D8A002B9985, 0x80000CC30010C18B, 0x0014D98E80000CC6, 0x0012198C0016158F, 
0x00167D920012918D, 0x80000CC90018B993, 0x001CD19680000B01, 0x001A5D94001E5197, 0x001E699A001A3995, 0x80000CBD001F219B, 0x80001AA2000515B8, 0x0002799C000214CC, 
0x0005FDB880001AA6, 0x0002A8CC80001AAE, 0x023484CC80000CEA, 0x0234FCCC02338CCD, 0x0225A0CC023398CD, 0x0232BCCC0223ACCD, 0x80001AB20234B0CC, 0x0232BCCD80000DBF, 
0x000541B80230CCCC, 0x80000E1B80000DC2, 0x80000CBA80000E54, 0x80000A1A80000CC0, 0x80000CCC000318CC, 0x80000CD580000CCF, 0x80000CDB023494CC, 0x80000CE180000CDE, 
0x03CEB48580001AB6, 0x001F3C8780000D29, 0x80001ABA80000CE7, 0x80000CF080000D2C, 0x0000A88D80000CED, 0x80000CF30004A1B8, 0x001F088980000CF6, 0x0000B88B80000CF9, 
0x80000CFC000288CC, 0x80000D0B80000CFF, 0x0000C49180000D0E, 0x80000BA00004DDB8, 0x80000D1480000D11, 0x80000D1780001AAA, 0x80000D1D80000D1A, 0x0000E99A80000D20, 
0x022C5DBB0222F99B, 0x022D79B9001FA0E1, 0x800007F5001F50E3, 0x00002DBD0002E8CC, 0x022F6DB3000411B8, 0x00000DB180000DAA, 0x022D91B780000DB0, 0x000015B580000E30, 
0x80000038001ED8EF, 0x02253DBB80000070, 0x000011BD8000002A, 0x000019BF8000003C, 0x8000004200068DBE, 0x0000BCBF0000C0BC, 0x800000480000D0BE, 0x8000005880000052, 
0x8000072C000060BA, 0x8000072E8000079F, 0x800007398000005E, 0x800007498000001E, 0x80000766800007E4, 0x800007710006E9B8, 0x800007738000004E, 0x8000078C800021B2, 
0x000689A18000006C, 0x022199A30215F5A0, 0x000175A500017DA2, 0x0006EDA700017DA4, 0x0215D1A90215F9A6, 0x800007AC0215D9A8, 0x800007C20006A5AA, 0x800007F9800003A9, 
0x0006CD918000081E, 0x0006E19300019590, 0x0006ED9502201192, 0x0001B9970006E594, 0x0006259900018596, 0x00018D9B00018D98, 0x0215159D0006219A, 0x00067D9F0006059C, 
0x0000A9810006099E, 0x0220A5830000C180, 0x00057D850000BD82, 0x0000A18700057184, 0x00001D890006D586, 0x0006C58B00009988, 0x0001F18D0006C58A, 0x0001F18F0006BD8C, 
0x8000085A8000083B, 0x80000880800003AB, 0x800008C6800003AE, 0x8000091F800021BE, 0x80000959800021C5, 0x8000095B8000095D, 0x80000869800021DC, 0x800007FF800021E3, 
0x80000844800000C8, 0x8000097880000D23, 0x80000DD18000000E, 0x800006B6800006B9, 0x800021CF800000CB, 0x800005DC800003B4, 0x8000063D80000617, 0x8000067180000654, 
0x800003A380000688, 0x800006A980002231, 0x8000039F800000DA, 0x8000078E80000903, 0x800007F1800007ED, 0x80000991800006CE, 0x8000080580000801, 0x8000099580000B97, 
0x8000076E80000AB0, 0x800007968000078A, 0x800007A9800007A1, 0x80000DA1800007D8, 0x80000EFC800009AB, 0x800006F380000717, 0x80000F2080000F13, 0x800006F580000F28, 
0x023A4CCC80000D62, 0x02384CCC023A34CD, 0x02260CCC023FCCCD, 0x022644CC022718CC, 0x023B60CC022724CD, 0x022524CC023AC0CD, 0x02395CCC0224D0CD, 0x023B74CC0239A0CD, 
0x80000D89023AACCD, 0x800004C98000222D, 0x800004A4800004D5, 0x8000056E800004B1, 0x022A38CC800004BD, 0x80000574022ABCCD, 0x023950CC800005C1, 0x0220E8CC0221F8CC, 
0x80000602022610CD, 0x80000622800004C3, 0x0236C4CD800004CF, 0x800005C70236D4CC, 0x023BA0CD80000628, 0x8000065C0224A4CC, 0x800007198000049F, 0x023478CC8000071C, 
0x800007B080000726, 0x800007B3000151B8, 0x023018CD800007B7, 0x023630CC0231D4CC, 0x023E64CD80000729, 0x022E58CC023E80CC, 0x800007CF022F74CD, 0x8000086B800007D2, 
0x023240CC8000086E, 0x023D08CC0233F8CD, 0x023310CC023268CD, 0x02334CCC0230C4CD, 0x023070CC023254CD, 0x0230D4CC023044CD, 0x0236B0CC0230A0CD, 0x02307CCC023D78CC, 
0x023F44CC0231C4CD, 0x023E2CCC023C84CD, 0x80000878023904CC, 0x023C50CC8000095F, 0x80000962023C24CD, 0x8000087B80000966, 0x800009728000096F, 0x80002201800003BC, 
0x8000220980002205, 0x800022158000220D, 0x0003B4CC80002211, 0x000D74CC8000221D, 0x000D54CC80002225, 0x000D54CC80002229, 0x000D70CC80002235, 0x8000223D80002239, 
0x8000225B80002244, 0x023880CD80002262, 0x000D18CC0238C8CC, 0x000D78CC8000226C, 0x000D48CC80002270, 0x000D58CC80002274, 0x000D48CC80002278, 0x000D78CC80002284, 
0x000BC58080002280, 0x0008AC94000BC981, 0x00081C92000F91B8, 0x0009F490000FB1B8, 0x000F95B8000FB1B8, 0x000FFDB8022F8189, 0x000F4589022FF98B, 0x000BD98E000BE18D, 
0x000F9DB8000BCD8F, 0x000FADB80009FC94, 0x000FBDB802267993, 0x000FADB800096890, 0x000F9DB800091892, 0x000019B80002ECCC, 0x8000229002215D9B, 0x000B819E000B819D, 
0x800007AE000C719F, 0x0002F8CC800007CD, 0x000005B8021891A3, 0x0002E4CC80002294, 0x8000229800003DB8, 0x000019B80002ECCC, 0x8000229C02229DAB, 0x022EC5AE000CA1AD, 
0x0002E4CC000CA1AF, 0x800022A000000DB8, 0x000005B80002FCCC, 0x0002E4CC800022A4, 0x800022A800003DB8, 0x0002F8CC022105B9, 0x00000DB8022271BB, 0x000CD5BE022C89BD, 
0x00010080800022AC, 0x0007088200040081, 0x00061084000039B8, 0x00030C8600051485, 0x0004A48800034487, 0x007B208A00780089, 0x0001C08C0002C0CC, 0x0002E4CC800022D0, 
0x800022D400007DB8, 0x00794892007AC491, 0x0002E4CC007C0093, 0x800022B000000DB8, 0x000005B80002DCCC, 0x000019B8800022B4, 0x800022B80002E4CC, 0x000005B80002ECCC, 
0x000009B8800022BC, 0x800022D80002E4CC, 0x000005B80002FCCC, 0x000031B8800022DC, 0x0001F0A80002E4CC, 0x800022C00001F0A9, 0x000009B80001B0AB, 0x800022C40002E4CC, 
0x000009B800029CCC, 0x800022C800019CB1, 0x0002FCCC000015B8, 0x800022CC000118B5, 0x0002DCCC000039B8, 0x00011CBA800022E0, 0x007FF0BC000180BB, 0x007DF8BE007EF4BD, 
0x022E3D8000737CBF, 0x022E3582022E3981, 0x022E2D84022E3183, 0x022E2586022E2985, 0x022E1D88022E2187, 0x022E158A022E1989, 0x000005B80002FCCC, 0x0002E4CC800022E4, 
0x800022E800007DB8, 0x0002E4CC000E7191, 0x800022EC00001DB8, 0x000031AA000031A9, 0x00044D8C000E6197, 0x8000231A80002316, 0x000575AF0004519C, 0x800003E8800003CF, 
0x0004B5B50002D882, 0x0005859F0004B5B4, 0x000EE5A40004B5B6, 0x000F95A6000F91A5, 0x0005B5B380000401, 0x022F61BC8000041A, 0x000270BE00022DBD, 0x0072419E00023C82, 
0x00723999022E81AF, 0x000250BE8000042D, 0x000FCDB4000FD9B3, 0x000FF5B680000440, 0x00721D9E000FE9B7, 0x8000046680000453, 0x000FCDBC00721199, 0x000FB5BE0073B599, 
0x000E45BE000378BE, 0x000879BC021AADBF, 0x00087DBA000879BD, 0x00087DB8000E5DBB, 0x00087DB6000875B9, 0x000865B4000845B7, 0x000875B2000875B5, 0x00080DB000087DB3, 
0x000869AE00087DB1, 0x000851AC000869AF, 0x000841AA000851AD, 0x00085DA8000841AB, 0x000999A6000851A9, 0x000999A4000999A7, 0x000995A2000999A5, 0x000E39A000099DA3, 
0x0009599E00099DA1, 0x000EB19C0009CD9F, 0x800004790009599D, 0x0003ECE30009459B, 0x800004F28000048C, 0x0003E0EF800000DC, 0x023048CC80000112, 0x00032882023064CC, 
0x8000011F8000011B, 0x8000012780000123, 0x8000012F8000012B, 0x0003E8EF80000133, 0x800000E00003D8EF, 0x000354E3800000E5, 0x006481B000025CE3, 0x800000EF800000EA, 
0x000965800072BD9E, 0x02287D8202288D81, 0x0009798402287583, 0x0009698600097985, 0x0009598800096987, 0x0009A98A00095989, 0x0009B98C0009A98B, 0x0009A98E0009B98D, 
0x02282D90800000F4, 0x0228D5920008B991, 0x000E799402244D93, 0x0009519602299595, 0x0009719802261D97, 0x0009719A0009F199, 0x0009519C0229319B, 0x800000FE800000F9, 
0x8000010880000103, 0x800001168000010D, 0x800004EF800003CC, 0x800005E18000058E, 0x000939A88000061C, 0x8000065980000642, 0x8000068D80000676, 0x800003EB800003D2, 
0x8000041D80000404, 0x8000044380000430, 0x8000046980000456, 0x8000048F8000047C, 0x8000019F800004F5, 0x800001A7800001A3, 0x800001AF800001AB, 0x800001B7800001B3, 
0x00089D80800001BB, 0x0008AD820008A581, 0x800001BF0008A583, 0x0008A9860008B985, 0x800001C30008A987, 0x0008298A00089D89, 0x000CED8C000CF18B, 0x0228F98E000CE98D, 
0x0008A5900008818F, 0x000959920008A191, 0x800001C702270D93, 0x0008999600097595, 0x800001CF800001CB, 0x0008AD9A00095599, 0x0009499C0009559B, 0x800001D300094D9D, 
0x000849A0800001D7, 0x000859A2000849A1, 0x000845A4800001DB, 0x000841A6800001DF, 0x000875A8800001E3, 0x0009A1AA800001E7, 0x000C29AC000871AB, 0x800001EB000811AD, 
0x000C61B0000941AF, 0x800001EF00082DB1, 0x02294DB40009D5B3, 0x000835B6000835B5, 0x000815B800082DB7, 0x800001F30008D5B9, 0x021C45BC000815BB, 0x000805BE000F41BD, 
0x00084580000BBDBF, 0x800001FB800001F7, 0x80000203800001FF, 0x000A6586000F8985, 0x000B1188000AE187, 0x80000938022BED89, 0x800006A18000224E, 0x800006AE800006AB, 
0x0008099080002304, 0x0008199200080991, 0x0008099400081993, 0x0008319600080995, 0x0008E19800083197, 0x0008E19A0008E199, 0x0008E99C0008E19B, 0x0008D19E0008E99D, 
0x000B65A00008D19F, 0x00083DA2000835A1, 0x000611A4000831A3, 0x000851A6000855A5, 0x00087DA8000851A7, 0x000859AA000621A9, 0x000AA1AC000859AB, 0x000F25AE000B11AD, 
0x000BF1B0000AA5AF, 0x000835B200083DB1, 0x000BF5B400099DB3, 0x0009B9B6000981B5, 0x000989B80009B9B7, 0x000985BA0226E5B9, 0x0224B1BC00099DBB, 0x000A85BE000BCDBD, 
0x00742C82000BEDBF, 0x000B90A38000230A, 0x000B90A5800031C7, 0x000A4D8780003A2F, 0x000A7D8980002A9A, 0x80002ABE000A7D88, 0x00088DAD80002ACA, 0x0008F9AF00088DAC, 
0x80002AE280002ADA, 0x80002AEE000881B0, 0x80002AFE80002AF6, 0x000A399780002B0A, 0x80002B7680002B5E, 0x80002B9680002B86, 0x80002BB680002BA6, 0x022B459F000B94BC, 
0x80002BDA80002BD6, 0x000B288380002BDE, 0x80002C3A80002C12, 0x80002C5280002C4A, 0x80002C6280002C56, 0x000B388B000B0C88, 0x80002C8280002C7E, 0x80002C9E80002C9A, 
0x000AF1B180002CA6, 0x80002CB6000AA1B0, 0x000ABDB580002D52, 0x000AADB7000ABDB4, 0x000A9DB9000AADB6, 0x000A6DBB000A9DB8, 0x000A7DBD000A6DBA, 0x000A6DBF000A7DBC, 
0x007A6082000A6DBE, 0x80000791007A6883, 0x007A4C8680002D66, 0x80002DA6007A5087, 0x80002DC280002DBA, 0x800007D680002DC6, 0x80002DF980002DD6, 0x80002E3180002E25, 
0x007AFC9280002E51, 0x80002E6180002E5D, 0x80002E65007AF891, 0x80002E8180002E7D, 0x80002EB980002EAD, 0x80002EC980002EC1, 0x80002EE880002ED9, 0x80002F1C80002EF0, 
0x007A2CA280002F20, 0x80002F2C80002F28, 0x80002F3C80002F34, 0x80002F6880002F4C, 0x80002FF480002FE0, 0x007A2CA8007A44AB, 0x80002FF8007A20A9, 0x8000307C80003078, 
0x007A10B280003090, 0x800030940079D8B3, 0x800030A48000309C, 0x0079D0B4800030AC, 0x800030B80079A4B5, 0x800030FE800030EE, 0x8000318F80003112, 0x800031AB8000319B, 
0x025589A0800031B7, 0x025571A2025571A1, 0x00747DA4007465A3, 0x00746DA6007465A5, 0x00745DA8007465A7, 0x007B51AA007B51A9, 0x007B95AC007BB1AB, 0x007BEDAE007BF1AD, 
0x007BA9B0007BD9AF, 0x007AD5B2007AD5B1, 0x007AF5B4007AEDB3, 0x007AE5B6007AF9B5, 0x007AA5B8007A9DB7, 0x007AA5BA007AADB9, 0x007AA5BC007ABDBB, 0x007A9DBE007A95BD, 
0x800031C3007A89BF, 0x800031CF800031CB, 0x800031D7800031D3, 0x80003293800031DB, 0x800032E7800032DB, 0x800032EF800032EB, 0x800032FB800032F3, 0x80003313800032FF, 
0x800033378000332F, 0x8000337B80003377, 0x8000338780003383, 0x800033938000338F, 0x800033BB800033B7, 0x800033DB800033D7, 0x800033E3800033DF, 0x8000341B800033F7, 
0x0079F9808000341F, 0x007E7D82007E3981, 0x007E6D84007E7583, 0x007E9D86007E9585, 0x007EAD88007E9587, 0x007EBD8A007EB589, 0x007EAD8C007EB58B, 0x007E918E007E918D, 
0x007EF190007E918F, 0x007EF192007EF191, 0x007E9194007EF193, 0x007E9196007E9195, 0x007EB198007E9197, 0x007EB19A007EB199, 0x007E919C007EB19B, 0x007E919E007E919D, 
0x007E71A0007E919F, 0x007E71A2007E71A1, 0x007F81A4007E71A3, 0x007FC9A6007FB5A5, 0x007FC1A8007FC1A7, 0x007FD5AA007FDDA9, 0x007F25AC007F21AB, 0x007F1DAE007F29AD, 
0x007F09B0007F05AF, 0x007CCDB2007F2DB1, 0x007CDDB4007CC5B3, 0x007355B6007CC5B5, 0x007745B8007345B7, 0x007349BA007379B9, 0x007359BC007705BB, 0x00771DBE007329BD, 
0x800034230076FDBF, 0x800034470077DC88, 0x0077D08D80003487, 0x024B28CC8000348B, 0x800034AB024B5CCD, 0x0077C083800034BB, 0x0077E085800034C3, 0x02497CCC800034E3, 
0x800035070246B4CD, 0x800035538000354B, 0x8000357380003567, 0x800035838000357B, 0x8000358B80003587, 0x800035A7800035A3, 0x800035CB800035C3, 0x800035D7800035D3, 
0x0008A8BE800035E3, 0x800035EF800035EB, 0x800035FB800035F3, 0x8000369F800035FF, 0x007768A1800036B3, 0x800036EB800036E7, 0x007808A5800036F3, 0x8000371F0078E0A4, 
0x8000372F80003727, 0x007810BB80003737, 0x0079D8BD007824BA, 0x800037730079C8BC, 0x8000377F80003777, 0x00787CB380003783, 0x80003787007844B2, 0x007804B7800037B3, 
0x007B1D8000780CB6, 0x007B2582007B2D81, 0x007B5184007B3183, 0x007B5586007B5D85, 0x007B7588007B4D87, 0x007B498A007B7989, 0x007B598C007B498B, 0x007B498E007B598D, 
0x007BC190007B418F, 0x007BC592007BC191, 0x007BC594007BDD93, 0x007BC596007BCD95, 0x007BCD98007BFD97, 0x007BDD9A007BD599, 0x007BCD9C007BD59B, 0x007BB59E007BBD9D, 
0x000499A00004719F, 0x0004A9A2000499A1, 0x0004BDA40004A9A3, 0x0004ADA60004A5A5, 0x00049DA80004A5A7, 0x0004E1AA0004E1A9, 0x0004E5AC0004FDAB, 0x0004E5AE0004EDAD, 
0x0004A5B00004DDAF, 0x0004A5B20004ADB1, 0x0004A5B40004BDB3, 0x0004A5B60004ADB5, 0x000469B8000459B7, 0x000479BA000469B9, 0x000469BC000479BB, 0x000459BE000469BD, 
0x0005B58000044DBF, 0x0005B5820005BD81, 0x0005DD840005C583, 0x0005CD860005C585, 0x0005C5880005FD87, 0x0005C58A0005CD89, 0x0005C58C0005DD8B, 0x0005C58E0005CD8D, 
0x0004C5900004BD8F, 0x0004C5920004CD91, 0x0004C5940004DD93, 0x0004C5960004CD95, 0x0004C5980004FD97, 0x0004C59A0004CD99, 0x0004C59C0004DD9B, 0x0004C59E0004CD9D, 
0x000445A00004BD9F, 0x000445A200044DA1, 0x000445A400045DA3, 0x000445A600044DA5, 0x000445A800047DA7, 0x000445AA00044DA9, 0x000445AC00045DAB, 0x000445AE00044DAD, 
0x0006C9B00006BDAF, 0x0006DDB20006C9B1, 0x0006F5B40006EDB3, 0x0006EDB60006F9B5, 0x0006A5B800069DB7, 0x0006A5BA0006ADB9, 0x0006A5BC0006BDBB, 0x0006A5BE0006ADBD, 
0x0005658000069DBF, 0x0005658200056D81, 0x0005658400057D83, 0x0005658600056D85, 0x0005A98800059987, 0x0005B98A0005A989, 0x0005A98C0005B98B, 0x00059D8E0005A98D, 
0x0005ED900005958F, 0x0005F5920005FD91, 0x0005959400058D93, 0x0005859600058D95, 0x000585980005BD97, 0x00059D9A00059599, 0x0001F59C0001ED9B, 0x0001F59E0001FD9D, 
0x000115A00001ED9F, 0x000115A200011DA1, 0x000135A400012DA3, 0x000135A600013DA5, 0x000115A800012DA7, 0x000115AA00011DA9, 0x000141AC00014DAB, 0x000141AE000141AD, 
0x000C01B0000141AF, 0x000ECDB2000EC5B1, 0x000EDDB4000EC5B3, 0x000ECDB6000EC5B5, 0x000EFDB8000EC5B7, 0x000ECDBA000EC5B9, 0x000EDDBC000EC5BB, 0x000ECDBE000EC5BD, 
0x00737D93000EC5BF, 0x0073719100723D92, 0x0252D19702536190, 0x0072599500721596, 0x025D619B0073E194, 0x0252E19900722D9A, 0x0072299F00721D98, 0x0072AD9D0253A99E, 
0x0073618300722D9C, 0x0073598100735D82, 0x0073698700734580, 0x0073698500729186, 0x007FE18B00737584, 0x00736D8900730D8A, 0x0072A58F00076588, 0x007FFD8D00075D8E, 
0x800037B700730D8C, 0x800037D3800037BF, 0x800037F3800037D7, 0x800037FF800037FB, 0x8000384380003823, 0x8000385780003853, 0x8000388B8000385F, 0x8000389F8000388F, 
0x0072E1A3800038C3, 0x025219A1025299A2, 0x025FD1A70079E5A0, 0x0072FDA5025209A6, 0x800038CF0072F5A4, 0x0072A1A9007281AA, 0x800038DF02521DA8, 0x800038FF800038F7, 
0x8000390B80003903, 0x8000391B80003917, 0x8000393F80003923, 0x8000394780003943, 0x800039638000395F, 0x8000397F8000396B, 0x8000398780003983, 0x800039938000398F, 
0x8000399B80003997, 0x800039AF8000399F, 0x800039CB800039C7, 0x800039DB800039D7, 0x800039E3800039DF, 0x800039EF800039EB, 0x800039FF800039F3, 0x80003A0F80003A07, 
0x0000BD8080003A13, 0x0000CD820000C581, 0x0000DD840000C583, 0x0000CD860000C585, 0x0000FD880000C587, 0x0000CD8A0000C589, 0x0000DD8C0000C58B, 0x0000CD8E0000C58D, 
0x0000BD900000C58F, 0x0000159200001D91, 0x0000359400002D93, 0x80003A1B00003D95, 0x80003A2380003A1F, 0x80003A3380003A2B, 0x80002C668000233E, 0x8000242680002C6A, 
0x00021C80800023B4, 0x0007248200019C81, 0x00041C8400050883, 0x00198086001A1485, 0x001C0088025D2180, 0x0010008A001E2489, 0x0028008C00122C8B, 0x002A388E002B348D, 
0x800023B800293C8F, 0x0000059900744CE3, 0x00001D9E800023BC, 0x00026082000204E3, 0x800023C000003D99, 0x00027CBE0002F4EF, 0x0002688200000D9E, 0x800023C400080CEF, 
0x0002F8E300000599, 0x0000F19E000274BE, 0x00026C82000214E3, 0x00000D99800023C8, 0x0000359E000244BE, 0x0000059900026882, 0x0002CCEF800023CC, 0x0000159E000274BE, 
0x00026CE30002D8EF, 0x800023D0000129B6, 0x000214E300027C82, 0x00027CBE00001D99, 0x0002C0EF0000159E, 0x0000059900026882, 0x0002BCEF800023D4, 0x000109B9000101BA, 
0x0002ACA600765DB8, 0x0003D8A40001E8E3, 0x800023D8000280E3, 0x800023E0800023DC, 0x800023E40003C4A1, 0x0002E0BE0005A8AF, 0x800023E80002ECBE, 0x000400A80002E4EF, 
0x0002C0E30002E8EF, 0x800023EC0002F4BE, 0x0005D8B20005C8B5, 0x0002C8BE0002D0E3, 0x800023F00002C0E3, 0x800023F40002C4EF, 0x0002CCEF000394EF, 0x0005F8B80005E8BB, 
0x00729486800023F8, 0x0002448200024082, 0x800023FC00023882, 0x8000240000020082, 0x0000B19980002404, 0x0000BD9900006C8F, 0x00035D9E0072CC8D, 0x0000A99E0072D08B, 
0x8000390780002408, 0x0000DD9E00008897, 0x0000C9990000CC95, 0x000000940000D893, 0x8000240C00000491, 0x0000F19E0003289F, 0x0000D19900036C9D, 0x8000241700037C9B, 
0x00027CBE0000A099, 0x000260820001259E, 0x0002F0EF00013D99, 0x000274BE0001259E, 0x000220E300025482, 0x0001619E000274BE, 0x00026C8200016599, 0x0001599900015D9A, 
0x0001299F000200BE, 0x000250BE0001259E, 0x00012D9900027882, 0x0001C59A0001CD99, 0x00011D9E0001CD9A, 0x000260BE0001F59F, 0x0001E99E00025C82, 0x00029C820001E99F, 
0x00013D99000294BE, 0x8000241B00024482, 0x00012D9E00016D9A, 0x000021990001759F, 0x000218BE800000BC, 0x0000219A00015D99, 0x000000CE00025082, 0x80002432800000C1, 
0x0001399E8000241F, 0x8000296E00004D9F, 0x000264BE0000759E, 0x0000119900024CBE, 0x0000299E00026082, 0x0005D8BE80002509, 0x000000DE000000D9, 0x0005D8828000256C, 
0x000538E30005F882, 0x00056CE3000540E3, 0x00059CE300057CE3, 0x0005CCE30005B0E3, 0x000578EF0005ECE3, 0x000504EF00050CEF, 0x0005F4EF00053CEF, 0x0005A8EF000584EF, 
0x0007DD9B0005B8EF, 0x0007AD9E0007A199, 0x0007ED9F0005B8E3, 0x0003C09D000248BE, 0x000795990007E99C, 0x000260820007919E, 0x800025AF00001D99, 0x0000099E000274BE, 
0x000310AB0002D0EF, 0x0002E8E300001999, 0x000394AF000210E3, 0x000358AD00027482, 0x00027CBE800025DB, 0x000260820000399E, 0x8000260500001D99, 0x000234EF000320A6, 
0x000204BB0002E4EF, 0x000204B9000264E3, 0x0002C8BF000268BE, 0x00020CBD000230E3, 0x0003A8B300006D9E, 0x0003E8B1000318EF, 0x000270B700027482, 0x0003A0B50002C0EF, 
0x8000262A0001FD99, 0x0000099E000274BE, 0x00026C82000214E3, 0x00000D998000263F, 0x00026C82000240BE, 0x000005990000319E, 0x000270BE80002647, 0x0000159E00021482, 
0x000268E30002D8EF, 0x000274E300000999, 0x00027CBE80002663, 0x00020CE30000199E, 0x8000266B00025482, 0x000210EF0000059E, 0x0002B8EF00000D99, 0x0002D0EF0000FD99, 
0x00029CBE00026C82, 0x80002673000458EF, 0x000264BE0000059E, 0x00023CE30002E0E3, 0x8000268500003D99, 0x0002ECEF0002CCEF, 0x0000799900025482, 0x00026C820004A0E3, 
0x0000619E000204BE, 0x80002691000274E3, 0x000200E3000260BE, 0x0001B88200001D9E, 0x0002F4EF80002699, 0x800026AF00018882, 0x800026ED000198BE, 0x0001AC820002C0EF, 
0x00001481800026FE, 0x0003E1990003D999, 0x0001FCE30003D19E, 0x000248BE00005C84, 0x0002C0EF00004086, 0x0003C19E0003B888, 0x0003C19900020CBE, 0x0003F48F00023C82, 
0x0001B0E30003C19A, 0x000274E380002720, 0x00034C9500038892, 0x0003A99E8000272B, 0x0000359A0003A19F, 0x0002E09B00035498, 0x0002A4EF00002999, 0x0002F4EF00028CBE, 
0x0000C59E8000277B, 0x000278820000D19F, 0x000210E30002BCEF, 0x0000319A0000E999, 0x0002C4EF000254BE, 0x8000278F00021082, 0x0000CD9E0003C882, 0x00023CAF00001D9F, 
0x000204B1000210E3, 0x000250BE000208B0, 0x00000999000228B2, 0x800027B10003BCBE, 0x0000399E0000359A, 0x800027BF00000D9F, 0x0002FCBD80002807, 0x000145BF80002815, 
0x0001ED9900038082, 0x0003FCE30003A0E3, 0x0001FD9E0001F99A, 0x00003D990001E19F, 0x0000059E000244BE, 0x0002608280002972, 0x8000297600001D99, 0x0002DCEF000318EF, 
0x000260E300000D9E, 0x000214E3000200BE, 0x8000297A00001D99, 0x0002D4EF00027C82, 0x0000319E000244BE, 0x000204E300026C82, 0x0002CCEF0000CD99, 0x0002DCEF000270BE, 
0x000200E30000DD9E, 0x0002688200003199, 0x000000E4000260BE, 0x0010EDB80000219E, 0x8000297E0010E5B9, 0x0010C19C000000E9, 0x0002C4EF0010C19D, 0x000000EE8000298A, 
0x00000DB3800025EA, 0x001C01B1001FC5B2, 0x001FC1B780001A22, 0x001FD1B5001FD9B6, 0x001FFDBB001FD9B4, 0x001FA9B9001FFDBA, 0x001FDDBF001FF9B8, 0x001FDDBD001FDDBE, 
0x800018FE001FDDBC, 0x80001A2680001902, 0x8000190680001A2A, 0x80001A2E8000190A, 0x80001A3680001A32, 0x80001A3E80001A3A, 0x8000194E80001A42, 0x800019AE80001962, 
0x8000190E800019B2, 0x800019B602798CE3, 0x80001912027A80E1, 0x800019BA80001916, 0x800019C2800019BE, 0x800019CA800019C6, 0x800019D2800019CE, 0x800019D602798CEF, 
0x8000191E8000191A, 0x800019DA80001922, 0x80001926800019DE, 0x00495CEF8000192A, 0x004064E1004644EF, 0x004170E303ABA0E1, 0x800019E20054F8E3, 0x800019EA800019E6, 
0x8000192E800019EE, 0x800019F280001932, 0x80001936800019F6, 0x800019FA8000193A, 0x800019AA800019FE, 0x8000194A80001946, 0x80001A4A80001A46, 0x80001A5280001A4E, 
0x0001318080001A56, 0x00015D8200015581, 0x0001258400017183, 0x00019D8600019585, 0x0001B58800018D87, 0x0001ED8A0001E589, 0x0001E58C0001FD8B, 0x00021D8E0002158D, 
0x00017D900001058F, 0x0001119200010D91, 0x0001319400011193, 0x0001319600013195, 0x0001119800013197, 0x0001E19A00011D99, 0x0001C19C0001E19B, 0x0001C19E0001C19D, 
0x000149A00001C19F, 0x000151A2000149A1, 0x000171A4000151A3, 0x000171A6000171A5, 0x000151A8000171A7, 0x000151AA000151A9, 0x0003B1AC000151AB, 0x0003B1AE0003B1AD, 
0x0003D1B00003B1AF, 0x0003D1B20003D1B1, 0x0003F1B40003D1B3, 0x0003F1B60003F1B5, 0x0003D1B80003F1B7, 0x0003D1BA0003D1B9, 0x0003B1BC0003D1BB, 0x0003B1BE0003B1BD, 
0x80001A5A0003B1BF, 0x8000195280001A5E, 0x80001A6680001A62, 0x8000195A80001956, 0x800019668000195E, 0x8000196E8000196A, 0x8000197680001972, 0x8000197E8000197A, 
0x8000198680001982, 0x8000198E8000198A, 0x8000199680001992, 0x80001A6A8000199A, 0x8000199E80001A6E, 0x800019A6800019A2, 0x80001A0680001A02, 0x80001A0E80001A0A, 
0x0000E98680001A12, 0x0000E9840000E987, 0x0000C9820000E985, 0x0000C9800000C983, 0x00007D8E0000C981, 0x00000D8C80001A16, 0x0000C98A0000758D, 0x0000C9880000C98B, 
0x0001A1960000C989, 0x0001F9940001A197, 0x006DCD920001F995, 0x80001A1A006D9993, 0x0001559E80001A1E, 0x00014D9C006DB19F, 0x006DB19A00015D9D, 0x000189980001559B, 
0x0366C8E100018999, 0x031F5CE3034F70E1, 0x033BD4E10363C8E3, 0x032BC4E3030400E1, 0x8000193E0333C4E3, 0x033274EF80001942, 0x80002AA60332E8EF, 0x030528EF80002D56, 
0x03F654E10367ECEF, 0x03E6FCE303DACCE1, 0x038C84E103CB94E3, 0x03A844E30390A8E1, 0x80002AAA038784E3, 0x03A898EF80002AC2, 0x80002AAE038C3CEF, 0x03CABCEF80003397, 
0x020F74E1033FACEF, 0x02322CE3026BD0E1, 0x02C4ECE1021350E3, 0x02F24CE3023A20E1, 0x80002AB602DB40E3, 0x02E13CEF80002A9E, 0x80002DE1020B70EF, 0x0212F8EF80002D6A, 
0x034F04EF026FFCEF, 0x800018FA02E18CE1, 0x029F84E102EB98E3, 0x02A38CE3029660E1, 0x80000207029A08E3, 0x028B34EF8000020D, 0x034FA4E30286B8EF, 0x03535CE180000213, 
0x80000219029A8CEF, 0x800002258000021F, 0x800002318000022B, 0x8000023D80000237, 0x8000024980000243, 0x800002558000024F, 0x8000033980000333, 0x800003458000033F, 
0x800003518000034B, 0x8000035D80000357, 0x8000038180000375, 0x8000038D80000387, 0x8000039980000393, 0x800003638000037B, 0x8000025B8000036C, 0x8000026780000273, 
0x80000279800002BB, 0x8000026180000297, 0x8000026D80000291, 0x800002D3800002A3, 0x800002EB800002F1, 0x8000032D800002DF, 0x800002CD800002C1, 0x800002D9800002E5, 
0x800002AF80000303, 0x80000321800002F7, 0x8000029D80000309, 0x800002B58000027F, 0x800002FD800002C7, 0x8000032780000285, 0x8000030F800002A9, 0x800003158000028B, 
0x0001F1808000031B, 0x0001F1820001F181, 0x000035840001F183, 0x0015A58600003D85, 0x003C289100003187, 0x80002EEC80002D0A, 0x80000783800034CB, 0x8000051480000505, 
0x0000719080000523, 0x0000719200007191, 0x0000AD9400007193, 0x00035D9600035595, 0x00036D9800035597, 0x00037D9A00037599, 0x00036D9C0003759B, 0x00035D9E0003559D, 
0x000649A00003559F, 0x000599A2000581A1, 0x0005C1A40005CDA3, 0x000519A60005C1A5, 0x000535A800050DA7, 0x000579AA000561A9, 0x000691AC000579AB, 0x000395AE000691AD, 
0x0003F5B000038DAF, 0x0003F5B20003FDB1, 0x000395B400038DB3, 0x000395B600039DB5, 0x0003B5B800038DB7, 0x0003B5BA0003BDB9, 0x000395BC00038DBB, 0x000395BE00039DBD, 
0x8000054180000532, 0x800005538000054A, 0x800005658000055C, 0x8000059A80000591, 0x800005A6800005A3, 0x800005AC800005A9, 0x80004CA780003A47, 0x80006837800055D7, 
0x80007A9780007167, 0x80009F5780008CF7, 0x8000BAEE8000A887, 0x8000CD558000C425, 0x8000DFB58000D685, 0x8000AE3B8000BB32, 0x80002AFA8000A507, 0x80002AA280002B8A, 
0x8000314280002AE6, 0x8000344F80003102, 0x8000330780002CD6, 0x800034638000378B, 0x8000349380002C1E, 0x800038138000339F, 0x80002C8680002B5A, 0x80003927800031FB, 
0x80002BAE80002B1E, 0x80002EBD8000319F, 0x80002C5A80002CCA, 0x80002E2D80002E39, 0x80002B1A800033EF, 0x80002C768000379F, 0x800005AF80002DCE, 0x800005B5800005B2, 
0x00031588800005B8, 0x0003158A00031D89, 0x0003358C00032D8B, 0x0003358E00033D8D, 0x0004C18000032D8F, 0x0004DD820004C181, 0x0003358400032D83, 0x0003358600033D85, 
0x0003159800032D87, 0x0003159A00031D99, 0x0003359C00032D9B, 0x0003359E00033D9D, 0x00035590800005E4, 0x0003559200035D91, 0x0003359400032D93, 0x0003359600033D95, 
0x000311A800032D97, 0x000311AA000311A9, 0x000331AC000311AB, 0x000331AE000331AD, 0x0003D1A0000331AF, 0x0003D1A20003D1A1, 0x000331A40003D1A3, 0x000331A6000331A5, 
0x000311B8000331A7, 0x000311BA000311B9, 0x000331BC000311BB, 0x000331BE000331BD, 0x000351B0000331BF, 0x000351B2000351B1, 0x000331B4000351B3, 0x000331B6000331B5, 
0x800005E7000331B7, 0x800005ED800005EA, 0x800005F3800005F0, 0x800005F9800005F6, 0x800005FF800005FC, 0x800004E08000061F, 0x800005D28000057F, 0x800006338000060D, 
0x800006678000064A, 0x800006958000067E, 0x800003F5800003DC, 0x800007118000040E, 0x8000083D80000840, 0x8000243A8000073E, 0x800024A480002473, 0x800026BA800024C9, 
0x800026C9800026C5, 0x800026D1800026CD, 0x8000286F80002830, 0x8000289B80002897, 0x800028C8800028C0, 0x800028F6800028E4, 0x800028FE800028FA, 0x8000293180002916, 
0x8000243E8000294C, 0x800024588000244B, 0x8000247780002465, 0x8000249680002484, 0x800024B8800024A8, 0x800024D7800024CD, 0x800024EF800024E5, 0x8000250D800024FC, 
0x0001298080002517, 0x0001398200012981, 0x0001298400013983, 0x0001598600012985, 0x0001698800015987, 0x0001798A00016989, 0x0001698C0001798B, 0x0001598E0001698D, 
0x000129900001598F, 0x0000B59200012991, 0x0001259400013D93, 0x0005599600040195, 0x0005699800055997, 0x0005799A00056999, 0x0005699C0005799B, 0x0005399E0005699D, 
0x0005C9A00005399F, 0x0005D9A20005C9A1, 0x0001E9A40005D9A3, 0x000119A60001E9A5, 0x000129A8000119A7, 0x0005F5AA0005FDA9, 0x000535AC00052DAB, 0x000135AE00053DAD, 
0x000155B000012DAF, 0x000155B200015DB1, 0x000175B400016DB3, 0x000175B600017DB5, 0x000155B800016DB7, 0x000155BA00015DB9, 0x000561BC000561BB, 0x000561BE000561BD, 
0x8000257080002492, 0x8000252580002577, 0x8000253280002581, 0x8000254980002539, 0x800025B38000255C, 0x80002592800025BD, 0x800025D1800025A2, 0x800025FB800025F1, 
0x00136CEF8000260D, 0x800026328000261A, 0x800026598000264F, 0x8000269D80002677, 0x800026A8800026B3, 0x800026D5800026BE, 0x0013A4E3800026E3, 0x8000271280002702, 
0x8000272F800026F1, 0x800027498000273F, 0x8000275480002724, 0x8000277F80002764, 0x8000279780002771, 0x800027CA800027C3, 0x800027D4800027A7, 0x800027B5800027DE, 
0x8000280B80002819, 0x80002826800027EC, 0x800027FD800027F3, 0x8000284180002834, 0x800028558000284B, 0x800028738000285F, 0x8000288780002880, 0x800028A68000289F, 
0x001BE98A800028B3, 0x000D7588001A9D8B, 0x001CBD8E0064AD89, 0x001A8D8C001B198F, 0x00081182001BF18D, 0x0064358000081183, 0x000D498600646181, 0x000D498400645187, 
0x000DE59A000D4985, 0x000DD598001B759B, 0x000DE19E000DED99, 0x000DF19C000DE19F, 0x000DE592000DF19D, 0x001B8990000DED93, 0x000DE596000DED91, 0x000DF594000DED97, 
0x000D55AA000DED95, 0x000D45A8000D5DAB, 0x000D75AE000D5DA9, 0x000D45AC000D7DAF, 0x000D61A2000D7DAD, 0x000D11A0000D61A3, 0x0008C1A6000D11A1, 0x0008D9A4000D7DA7, 
0x0003D1BA0008D9A5, 0x0003C1B80003D1BB, 0x0003F1BE0003C1B9, 0x0003C1BC0003F1BF, 0x000D15B20003C1BD, 0x000D05B0000D1DB3, 0x0003F1B6000D1DB1, 0x000D05B40003F1B7, 
0x80002521000CA1B5, 0x800025CD8000258E, 0x80002609800025DF, 0x800026438000262E, 0x800028CC8000264B, 0x800028E8800028D6, 0x8000290F80002902, 0x800029248000291A, 
0x8000266780002935, 0x800026818000266F, 0x800026958000268D, 0x800026DF800026A4, 0x8000293C8000271C, 0x800003C280002954, 0x80000584800004E5, 0x80000612800005D7, 
0x8000275080000638, 0x800027E880002793, 0x8000295E80002950, 0x8000296680002962, 0x8000066C8000064F, 0x8000069A80000683, 0x800003FB800003E2, 0x8000042780000414, 
0x8000044D8000043A, 0x8000047380000460, 0x8000049980000486, 0x8000050E800004FF, 0x8000052C8000051D, 0x800008628000053B, 0x800006C080000823, 0x8000091C800007FB, 
0x8000082980000932, 0x800008308000082C, 0x80002EDD80000723, 0x80002DDA800030CB, 0x80003146800030BC, 0x8000090580000926, 0x800008CE80000DDD, 0x8000073080000882, 
0x800006FB8000074B, 0x8000089380000809, 0x8000090880000929, 0x80000DE1800024E1, 0x800008DA80000DED, 0x8000071480000898, 0x8000075480000885, 0x800007A5800006FE, 
0x800008E180000DF1, 0x8000089B80000826, 0x8000091480000857, 0x800008E480000DF5, 0x8000089E80000813, 0x80000816800008E7, 0x800008A1800008C8, 0x8000081A800008EB, 
0x800008A5800008CB, 0x800008FC800008F6, 0x8000088980000787, 0x8000070280000758, 0x800009408000093C, 0x8000093580000948, 0x80000DF980000917, 0x8000092C800008F3, 
0x80000DE58000090B, 0x8000088D800008D1, 0x8000092F8000075C, 0x80000DE98000090E, 0x80000890800008D4, 0x800008AC8000075F, 0x800007E880000762, 0x8000080D800006CB, 
0x800006D780000810, 0x80000820800006D3, 0x8000086680000706, 0x800008758000070B, 0x8000073680000733, 0x800008B5800008A9, 0x800008BB800008B8, 0x800008D7800008BF, 
0x800008EF800008DD, 0x8000092180000775, 0x8000078080000778, 0x8000079C80000953, 0x800007BC800007CA, 0x800004DB800006C3, 0x800005CD8000057A, 0x8000062E80000608, 
0x8000066280000645, 0x8000069080000679, 0x800003EF800003D6, 0x001728E380000408, 0x8000043480000421, 0x0017F8EF80000447, 0x8000046D8000045A, 0x8000049380000480, 
0x0013F4E3800004F9, 0x0013A4E30013A0E3, 0x8000050800138CE3, 0x001244E3001278E3, 0x8000051700123CE3, 0x00128CEF0012A8EF, 0x0012D4EF001290EF, 0x001308EF001318EF, 
0x80000526001358EF, 0x8000054480000535, 0x800005568000054D, 0x800005688000055F, 0x8000059D80000594, 0x80000E578000085C, 0x80003A3B80000E5A, 0x80000B1680000AAD, 
0x001120E380003A37, 0x0011E8E3001118E3, 0x0010ACE3001678E3, 0x001080E30010BCE3, 0x001008EF001178E3, 0x00104CEF00106CEF, 0x001184EF001050EF, 0x001134EF0011ECEF, 
0x001070E3001110EF, 0x0010BCE3001060E3, 0x0013ECE3001098E3, 0x001034E3001024E3, 0x00136CEF00100CE3, 0x001308EF001330EF, 0x0010C4EF0010F8EF, 0x001090EF0010B0EF, 
0x003AC980001084EF, 0x003AD982003AC981, 0x003AC984003AD983, 0x003AF986003AC985, 0x003AC988003AF987, 0x003AD98A003AC989, 0x003AC98C003AD98B, 0x003C198E003AC98D, 
0x003C6990003C198F, 0x003C7992003C6991, 0x003C6994003C7993, 0x003C3996003C6995, 0x003C0998003C3997, 0x003C199A003C0999, 0x003C099C003C199B, 0x003CE59E003C099D, 
0x003C25A0003CDD9F, 0x003C25A2003C2DA1, 0x003C25A4003C3DA3, 0x003C25A6003C2DA5, 0x003C65A8003C5DA7, 0x003C65AA003C6DA9, 0x003C65AC003C7DAB, 0x003C65AE003C6DAD, 
0x003C25B0003C5DAF, 0x003C25B2003C2DB1, 0x003C25B4003C3DB3, 0x003C25B6003C2DB5, 0x003DE5B8003DDDB7, 0x003DE5BA003DEDB9, 0x003DE5BC003DFDBB, 0x003DE5BE003DEDBD, 
0x003C2580003DDDBF, 0x003C2582003C2D81, 0x003C2584003C3D83, 0x003C2586003C2D85, 0x003C6588003C5D87, 0x003C658A003C6D89, 0x003C698C003C7D8B, 0x003C598E003C698D, 
0x003C2990003C598F, 0x003C3992003C2991, 0x003C2994003C3993, 0x003CD996003C2995, 0x003CE998003CD997, 0x003CF99A003CE999, 0x003CE99C003CF99B, 0x003CD99E003CE99D, 
0x003C29A0003CD99F, 0x003C39A2003C29A1, 0x003C29A4003C39A3, 0x003C59A6003C29A5, 0x003C69A8003C59A7, 0x003C79AA003C69A9, 0x003C69AC003C79AB, 0x003C59AE003C69AD, 
0x003C29B0003C59AF, 0x003C39B2003C29B1, 0x003C29B4003C39B3, 0x003FD9B6003C29B5, 0x003FE9B8003FD9B7, 0x003FF9BA003FE9B9, 0x003FE9BC003FF9BB, 0x003FD9BE003FE9BD, 
0x003C2980003FD9BF, 0x003C3982003C2981, 0x003C2984003C3983, 0x003C5986003C2985, 0x003C6988003C5987, 0x003C798A003C6989, 0x003C698C003C798B, 0x003C598E003C698D, 
0x003C2990003C598F, 0x003C3992003C2991, 0x003C2994003C3993, 0x003CD996003C2995, 0x003CE998003CD997, 0x003CF99A003CE999, 0x003CE99C003CF99B, 0x003CD99E003CE99D, 
0x003C29A0003CD99F, 0x003C39A2003C29A1, 0x003C29A4003C39A3, 0x003C59A6003C29A5, 0x003C69A8003C59A7, 0x003C79AA003C69A9, 0x003C6DAC003C79AB, 0x003C5DAE003C55AD, 
0x003C31B0003C51AF, 0x003C31B2003C31B1, 0x003DC1B4003C31B3, 0x003D99B6003DF5B5, 0x003DA9B8003D99B7, 0x003DB9BA003DA9B9, 0x003DA9BC003DB9BB, 0x003D99BE003DA9BD, 
0x003BF18C003D99BF, 0x003BF18E003BF18D, 0x003BF188003BF18F, 0x003BF18A003BF189, 0x003BF184003BF18B, 0x003BF186003BF185, 0x003BF180003BF187, 0x003BF182003BF181, 
0x0039719C003BF183, 0x0039719E0039719D, 0x003971980039719F, 0x0039719A00397199, 0x003971940039719B, 0x0039719600397195, 0x0039719000397197, 0x0039719200397191, 
0x0039F9AC00397193, 0x003909AE0039F9AD, 0x0039F5A8003909AF, 0x0039F5AA0039FDA9, 0x0039F5A40039E9AB, 0x0039F5A60039FDA5, 0x0039F5A00039CDA7, 0x0039F5A20039FDA1, 
0x003979BC0039EDA3, 0x003909BE003979BD, 0x003979B8003909BF, 0x003969BA003979B9, 0x003979B4003969BB, 0x003949B6003979B5, 0x003979B0003949B7, 0x003969B2003979B1, 
0x003B7D9C003969B3, 0x00001D9E0000159D, 0x80003A3F0000159F, 0x80003A4380000CE4, 0x800030F28000377B, 0x8000325B800037A3, 0x80002CBA80002AC6, 0x80002D1E80002DED, 
0x80002FD880002DE9, 0x80003563800033D3, 0x800036D78000369B, 0x8000381F8000370B, 0x8000320380003177, 0x80003347800032AF, 0x8000384780003663, 0x80002AEA80003973, 
0x000080A480002C8E, 0x000F88A60001A4A5, 0x8000318B000800A7, 0x80003697800032D3, 0x001590AC800039C3, 0x0012A8AE001000AD, 0x000AB0A80013E0AF, 0x001400AA000BB4A9, 
0x001BC0B400163CAB, 0x00E400B6001984B5, 0x001C00B000E7CCB7, 0x001D70B2001ED4B1, 0x00E1E4BC001800B3, 0x00EF50BE00E800BD, 0x00E5B0B800EE24BF, 0x00E2F8BA00E000B9, 
0x80002E9500E30CBB, 0x800036878000327B, 0x8000300C8000371B, 0x800036E3800035BF, 0x005C109D80002F08, 0x0028509F80003106, 0x8000331F8000321B, 0x80002B2A8000382B, 
0x80002BC20028E49A, 0x8000307480002C2E, 0x800032CF80003183, 0x8000368F800033F3, 0x800037CB800036A7, 0x800039A3800038EF, 0x8000342F800039BF, 0x800035278000346F, 
0x8000387B80003647, 0x80002DA28000374F, 0x800034DF80002F24, 0x800033038000359F, 0x8000379B80003437, 0x80002D9E800038E7, 0x8000317B80002E71, 0x800032638000322F, 
0x8000353F80003517, 0x80002C2A800038A7, 0x80002BCE800035AB, 0x8000349B80002BCA, 0x000390AD8000352B, 0x800038AF8000365F, 0x800030108000376B, 0x80002AD28000375B, 
0x00021D8080002E45, 0x0021858200022581, 0x0002398400022983, 0x0002298600023985, 0x002EC588002EF987, 0x0021858A00021189, 0x00020D8C0002158B, 0x00027D8E0002758D, 
0x00020D900002758F, 0x00021D9200021591, 0x00020D9400021593, 0x00023D9600023595, 0x00020D9800023597, 0x00021D9A00021599, 0x00020D9C0002159B, 0x0002ED9E0002E59D, 
0x00021DA00002E59F, 0x00038DA2000385A1, 0x00039DA4000385A3, 0x00038DA6000385A5, 0x0003BDA8000385A7, 0x000385AA000381A9, 0x000385AC00039DAB, 0x0003F9AE00038DAD, 
0x000389B00003F9AF, 0x000399B2000389B1, 0x002585B4000399B3, 0x000385B600038DB5, 0x000385B80003BDB7, 0x000385BA00038DB9, 0x000385BC00039DBB, 0x000385BE00038DBD, 
0x0002A18800037DBF, 0x0002A18A0002A189, 0x0002A18C0002A18B, 0x0002A18E0002A18D, 0x002F71800002A18F, 0x0002A1820002A181, 0x0002A1840002A183, 0x0002A1860002A185, 
0x0002A5980002A187, 0x0002A59A0002AD99, 0x00030D9C0002BD9B, 0x0002A19E0002A19D, 0x0002A1900002A19F, 0x0002A1920002A191, 0x0002A1940002A193, 0x0002A1960002A195, 
0x000F9DA80002A197, 0x000FADAA000FA5A9, 0x000FBDAC000FA5AB, 0x000FADAE000FA5AD, 0x000C01A0000FA5AF, 0x000FADA2000FA5A1, 0x000FBDA4000FA5A3, 0x000FADA6000FA5A5, 
0x000F99B8000FA5A7, 0x000FA9BA000F99B9, 0x000FB9BC000FA9BB, 0x000FA9BE000FB9BD, 0x000FDDB0000FA9BF, 0x000FA9B2002071B1, 0x000FB9B4000FA9B3, 0x000FA9B6000FB9B5, 
0x80003333000FA9B7, 0x80002C4E800033B3, 0x80002B3A8000343F, 0x80002AB280002F60, 0x8000308C800031EF, 0x80002CA280003513, 0x800033FF80002D8E, 0x8000373F80003667, 
0x800031E7800031BB, 0x8000361F80003020, 0x800033AF80003040, 0x80002B8280002B06, 0x8000315780002BC6, 0x800035F7800034FF, 0x8000385B8000374B, 0x80002CEA80002C36, 
0x800030A880002F18, 0x800034438000327F, 0x8000397B80003897, 0x800039E7800039CF, 0x800031A7800030EA, 0x80002EE4800037EF, 0x80002FDC80002FC0, 0x8000326F8000306C, 
0x8000336B800032BB, 0x800035338000348F, 0x800037DF80003597, 0x800038078000366F, 0x80002BEA8000387F, 0x80002CFE80002C16, 0x800036F7800032AB, 0x80002F7480002F04, 
0x0001798080003038, 0x0001758200293581, 0x0001958400018D83, 0x0001958600019D85, 0x0001B58800018D87, 0x0056A58A0001BD89, 0x0001918C0001B18B, 0x0001918E0001918D, 
0x0001F1900001918F, 0x0001F1920001F191, 0x000191940001F193, 0x0001919600019195, 0x0001B19800019197, 0x0001B19A0001B199, 0x0001919C0001B19B, 0x0001919E0001919D, 
0x000171A00001919F, 0x00017DA20001BDA1, 0x00016DA4000175A3, 0x00039DA6000395A5, 0x0003ADA8000395A7, 0x000C55AA0003B5A9, 0x0003A9AC0003B9AB, 0x000399AE0003A9AD, 
0x0003E9B0000399AF, 0x0003F9B20003E9B1, 0x0003E9B40003F9B3, 0x000399B60003E9B5, 0x0003A9B8000399B7, 0x0003B9BA0003A9B9, 0x0003A9BC0003B9BB, 0x000399BE0003A9BD, 
0x800031B3000DA1BF, 0x80003327800034DB, 0x80002D5A80002B16, 0x80002F8080002EA9, 0x8000335F80003343, 0x8000358F8000356F, 0x800038E380003863, 0x8000392F800038F3, 
0x8000348380002B2E, 0x800038CB8000384F, 0x80002AF280002F98, 0x80002E4980002B52, 0x8000309880002E69, 0x800033CF800032C7, 0x8000381B8000367B, 0x800038A3800030DA, 
0x8000312680002C0E, 0x8000321380003132, 0x8000334F8000324B, 0x8000342B800033AB, 0x8000393B8000350F, 0x800038B380002FEC, 0x80002E8D80002B42, 0x800037E380003233, 
0x80002FA080002F50, 0x800038BB8000313A, 0x80002CDA80002BF2, 0x800030C380002E79, 0x8000316380003116, 0x8000334B800031F7, 0x8000355B800033BF, 0x80003707800036FB, 
0x00056482800038D7, 0x8000324F80002C5E, 0x800032CB80002CDE, 0x8000368B8000336F, 0x800039AB800038BF, 0x8000312E800039D3, 0x800035C78000322B, 0x800034EB800034C7, 
0x800032A38000331B, 0x80002B0E80003767, 0x80002BF68000362F, 0x80002EF480002BE6, 0x800034F780003014, 0x8000320780002E35, 0x800037EB800030E6, 0x80002F10800038AB, 
0x80002D3680002B62, 0x800030D680002D8A, 0x8000332380002BD2, 0x8000344B800033E7, 0x80002F7C80003467, 0x8000347F8000346B, 0x800034EF800038FB, 0x8000375780003693, 
0x800038378000380B, 0x800039538000394F, 0x800039BB80003957, 0x800038C78000382F, 0x80002B5680002B32, 0x80002C2680002B6A, 0x80002C7280002C32, 0x80002D4280002D26, 
0x0007558080002D4A, 0x0007558200075D81, 0x0007758400076D83, 0x0007758600077D85, 0x002F898800076D87, 0x002F958A00075189, 0x00074D8C0007558B, 0x80002D860007B58D, 
0x0007C59080002D92, 0x0007C19280002E75, 0x80002FB480002F8C, 0x0007C9960007D995, 0x0007F9980007C997, 0x0007CD9A0007F999, 0x0007DD9C0007C59B, 0x002F299E0007C59D, 
0x000735A080002FBC, 0x000731A280002FD4, 0x8000308000E405BA, 0x000759A6000729A5, 0x800030DE800030B0, 0x00076DAA8000315B, 0x00077DAC000765AB, 0x00076DAE000765AD, 
0x00071DB0000765AF, 0x00072DB2000725B1, 0x00073DB4000725B3, 0x00072DB6000725B5, 0x00071DB8000725B7, 0x0000D5BA0000DDB9, 0x002CA5BC0000A9BB, 0x0000A9BE0000B9BD, 
0x00018580000081BF, 0x0001958200019581, 0x0001B5840001AD83, 0x0000A5860000AD85, 0x0002298800021987, 0x0002398A00022989, 0x003BB98C0002398B, 0x0002258E00022D8D, 
0x0002659000021D8F, 0x00026192003BDD91, 0x0002619400026193, 0x0002619600026195, 0x00025D9800059597, 0x00022D9A00022599, 0x00023D9C0002259B, 0x0002299E0002259D, 
0x0002D9A00002299F, 0x0002E9A20002D9A1, 0x0002F9A40002E9A3, 0x0002E9A60002F9A5, 0x0002D5A8000621A7, 0x0002D5AA0002DDA9, 0x000235AC00022DAB, 0x8000321F00023DAD, 
0x00024DB08000323B, 0x00025DB2000255B1, 0x00024DB4000255B3, 0x00027DB6000275B5, 0x000615B8000275B7, 0x000259BA000249B9, 0x000675BC000259BB, 0x000245BE00024DBD, 
0x0004E5A300023DBF, 0x0004D5A10004E5A2, 0x0004E5A70004D5A0, 0x0004F5A50004E5A6, 0x000525AB0004F5A4, 0x002981A90004D9AA, 0x000525AF0004D5A8, 0x000535AD000525AE, 
0x000565B3000535AC, 0x000555B1000565B2, 0x002D75B7000555B0, 0x000575B5000565B6, 0x000521BB000575B4, 0x000551B9000559BA, 0x000521BF000559B8, 0x000531BD000539BE, 
0x0004F183000539BC, 0x0004E1810004E982, 0x0004ED870004E980, 0x0004ED850004ED86, 0x00042D8B00267D84, 0x00042D8900042D8A, 0x00042D8F00042D88, 0x00042D8D00042D8E, 
0x0004699300042D8C, 0x0038BD9100046192, 0x0004699700046D90, 0x0004699500046196, 0x0006E19B00047194, 0x000429990004219A, 0x0004259F00045198, 0x0004359D0004259E, 
0x003864F00004359C, 0x800032BF8000326B, 0x80003353800032DF, 0x8000345780003433, 0x8000345B80003453, 0x800034778000345F, 0x8000349F8000347B, 0x800034CF800034B3, 
0x800035438000353B, 0x8000357F80003557, 0x80003603800035CF, 0x800037138000366B, 0x8000375F8000372B, 0x800037A780003763, 0x80003803800037AB, 0x8000391F800038DB, 
0x80002F8480003937, 0x800035E78000EA91, 0x80002BBE80002ABA, 0x80002B2680002B7E, 0x80002B9280002B66, 0x80002C3E80002C22, 0x80002D2280002D12, 0x80002D9A80002D3E, 
0x80002DF180002DE5, 0x80002E1D80002E0D, 0x80002F1480002F0C, 0x80002F6480002F44, 0x80002FAC80002F94, 0x80002FB080002F9C, 0x8000304880002FF0, 0x8000305C80003054, 
0x8000310A80003084, 0x8000325F8000311E, 0x8000328780003257, 0x800032E380003417, 0x8000336380003317, 0x800033A38000337F, 0x800033CB800033C7, 0x800033FB800033EB, 
0x8000340B8000340F, 0x800034B78000343B, 0x8000351F800034E7, 0x800036338000354F, 0x800036CF8000365B, 0x8000372380003717, 0x8000374780003743, 0x8000376F80003753, 
0x0000F980800037E7, 0x0000F582001FE981, 0x00007D8400006583, 0x00006D8600006585, 0x001B0D88001FE987, 0x001FD18A00005D89, 0x001FCD8C0000518B, 0x00385D8E0001B58D, 
0x0001C9900001B98F, 0x0001D9920001C991, 0x0001C9940001D993, 0x0001F9960001C995, 0x0001C9980001F997, 0x800038170001C999, 0x8000386B8000384B, 0x8000390F800038B7, 
0x8000398B8000392B, 0x8000EA238000EA28, 0x800029E28000EA55, 0x80002A0E80002A0A, 0x8000EB048000EAD7, 0x80003A178000EB7C, 0x000ADCF080003A27, 0x8000085180000846, 
0x8000084980000854, 0x800009568000084D, 0x80000EE380000EF2, 0x80000EF780000EE8, 0x80000F4C80000EED, 0x80000F8280000FCB, 0x80000F5B80000F30, 0x80000F7080000F68, 
0x80000FC380000F9E, 0x80000FBE80000FB9, 0x80000FB280000FAB, 0x80000F0480000EFF, 0x80000F1680000F09, 0x80000F2B80000F23, 0x80000F3D80000F33, 0x80000F4780000F42, 
0x80000F5680000F51, 0x80000F6B80000F5E, 0x80000F7880000F73, 0x80000F8580000F7D, 0x80000F9480000F8A, 0x80000FA180000F99, 0x80000FC680000FA6, 0x80000F1B80000F38, 
0x00024DAE80000F63, 0x000241AC000255AF, 0x000251AA001D35AD, 0x000221A8000251AB, 0x0019B5A6000221A9, 0x000205A4000211A7, 0x000215A200021DA5, 0x0019A9A000021DA3, 
0x000235BE00021DA1, 0x001D29BC001D21BF, 0x0019E9BA0017B9BD, 0x001D05B8000225BB, 0x000205B6000231B9, 0x000235B400020DB7, 0x001D39B200020DB5, 0x001AB1B000022DB3, 
0x001D758E000229B1, 0x001D658C001D7D8F, 0x001D798A001D7D8D, 0x001D7D88001E118B, 0x001D7D86001EE189, 0x001D7D84001D4587, 0x001D7D82001D7585, 0x001D7D80001D6583, 
0x0002D99E001D7581, 0x001DC19C0002D99F, 0x001DD59A0002D99D, 0x0002D1980002C59B, 0x001ADD960002D199, 0x0002ED9400186D97, 0x0017D59200321595, 0x001D05900002F593, 
0x80000F8F00197591, 0x800016DE80000F0E, 0x800016EA800016E7, 0x800016E4800016F0, 0x00026584800016ED, 0x0002618600026D85, 0x00020580800016E1, 0x0002058200020D81, 
0x8000171400027D83, 0x800017170002259D, 0x800016F60002299F, 0x800016F9800016F3, 0x00023194800016FC, 0x0002319600023195, 0x8000170500023197, 0x8000170880001702, 
0x00020DAC00023193, 0x00021DAE000215AD, 0x000211A8000215AF, 0x00021DAA004615A9, 0x0002D1A4000215AB, 0x0002D1A60002D1A5, 0x0002D9A00002D1A7, 0x00464DA2004655A1, 
0x000209BC0002D1A3, 0x000205BE800016FF, 0x000269B88000170E, 0x000219BA000269B9, 0x00024DB4000219BB, 0x00025DB6000255B5, 0x00026DB08000170B, 0x00025DB2000255B1, 
0x00075D80000255B3, 0x0007798200075981, 0x0007658400077D83, 0x0007618600076185, 0x0007E58800076587, 0x0007E58A0007E189, 0x0007DD8C0007E18B, 0x0000F18E0007D98D, 
0x000089900000F58F, 0x0000859200008D91, 0x00009D9400008193, 0x0000899600009995, 0x0000B19800008D97, 0x0000BD9A0000B599, 0x0000A59C0000B99B, 0x0000A19E0000A19D, 
0x00005DA00000A59F, 0x000055A2000059A1, 0x0251E9A4000051A3, 0x000079A60251EDA5, 0x000041A800007DA7, 0x00004DAA000045A9, 0x000055AC000049AB, 0x000051AE000051AD, 
0x0251A9B0000055AF, 0x8000171A0251ADB1, 0x8000172680001720, 0x8000172980001723, 0x800017358000172C, 0x800017588000172F, 0x800017418000171D, 0x800017498000173E, 
0x0001ED938000174F, 0x8000174C8000173B, 0x0001E19780001755, 0x0001F5950001F996, 0x0001D99B0001F194, 0x0001DD990001D19A, 0x0001CD9F0001DD98, 0x0250699D0001C99E, 
0x8000167A0001C59C, 0x8000103280000FE2, 0x800010238000100F, 0x800010288000101E, 0x800010148000102D, 0x80000FE780001752, 0x8000100080000FEC, 0x8000105980001019, 
0x0000D5B38000105E, 0x0000D9B10000D1B2, 0x0000CDB70000DDB0, 0x0000C1B50000C9B6, 0x0000C1BB0000C5B4, 0x0000C9B90000C5BA, 0x0000D5BF0000F1B8, 0x0000DDBD0000D1BE, 
0x0000C9A30000D9BC, 0x0000CDA10000CDA2, 0x0000DDA70000C9A0, 0x0000D5A50000D9A6, 0x0000A5AB0000D1A4, 0x0000A9A90000A1AA, 0x0000BDAF0000ADA8, 0x0000B1AD0000B9AE, 
0x00052DA90000B5AC, 0x000549AB000529A8, 0x000551AD00054DAA, 0x000551AF000555AC, 0x000539A1000555AE, 0x000535A300053DA0, 0x00052DA5000531A2, 0x000515A7000529A4, 
0x000515B9000511A6, 0x000511BB000511B8, 0x000509BD000515BA, 0x000505BF00050DBC, 0x000529B1000501BE, 0x000539B300052DB0, 0x000521B500053DB2, 0x00052DB7000525B4, 
0x00076D89000529B6, 0x00077D8B00076D88, 0x00076D8D00077D8A, 0x00059D8F00076D8C, 0x0007758100059D8E, 0x0007718300077580, 0x800010808000106A, 0x00075D8700076984, 
0x0005D19900075D86, 0x0005DD9B0005D598, 0x0005C59D0005D99A, 0x0005C19F0005C19C, 0x0005E9910005C59E, 0x0005E5930005ED90, 0x0005FD950005E192, 0x0005E9970005F994, 
0x8000108F0005ED96, 0x8000109F80001094, 0x800010CC800010B9, 0x80001122800010F0, 0x8000112F80001127, 0x8000114D8000113E, 0x8000115A80001152, 0x800011A48000117D, 
0x800011D0800011B0, 0x800011DA800011D5, 0x8000121400FFC1BA, 0x8000123380001227, 0x800012C58000124B, 0x800013348000131B, 0x8000134C80001339, 0x8000136F8000135D, 
0x8000139B80001374, 0x800013A30250B4D9, 0x800013B80250B0D9, 0x800013E4800013DF, 0x800014438000143E, 0x8000145480001448, 0x8000146580001460, 0x800014798000146D, 
0x8000149880001493, 0x800014A5800014A0, 0x800014AF800014AA, 0x800014B9800014B4, 0x800014D1800014CC, 0x80001507800014ED, 0x8000152D80001521, 0x8000154A80001545, 
0x000FE98080001557, 0x000FF982000FE981, 0x000FE984000FF983, 0x00011986000FE985, 0x0001298800011987, 0x0001398A00012989, 0x0001298C0001398B, 0x0001198E0001298D, 
0x000169900001198F, 0x0001799200016991, 0x0001699400017993, 0x0001199600016995, 0x0001299800011997, 0x0001399A00012999, 0x0001299C0001399B, 0x0001199E0001299D, 
0x0001E9A00001199F, 0x0001F9A20001E9A1, 0x0001E9A40001F9A3, 0x000DE9A60001E9A5, 0x000DC1A800011DA7, 0x00012DAA000DD1A9, 0x000E01AC000125AB, 0x000FB9AE000139AD, 
0x000151B0000FB9AF, 0x000FDDB2000151B1, 0x000FC9B4000155B3, 0x000145B6000FC9B5, 0x000FC5B800017DB7, 0x000FC1BA000141B9, 0x000F5DBC000FC1BB, 0x000F45BE000F45BD, 
0x80001578000F3DBF, 0x800015B58000159B, 0x800015C6800015C1, 0x800015EF800015CE, 0x8000161880001609, 0x8000163A80001635, 0x8000164780001642, 0x8000165F8000165A, 
0x8000169180001685, 0x800016AC8000169D, 0x800016CE800016C9, 0x80001200800011EF, 0x800000808000167D, 0x800000948000008A, 0x800000A88000009E, 0x80000FF6800000B2, 
0x8000100580000FFB, 0x8000107B80001076, 0x800010E680001085, 0x80001118800010EB, 0x8000113980001134, 0x00077C9180001143, 0x8000160E80001552, 0x8000162B80001613, 
0x800016A7800016A2, 0x80000FF1800016BF, 0x8000108A8000100A, 0x800012D88000111D, 0x8000163080001540, 0x800016C480001664, 0x8000126580001148, 0x800012B3800012A0, 
0x000DB9B480001412, 0x000DC9B6000DB9B5, 0x000DB9B0000DC9B7, 0x000DA9B2000DB9B1, 0x000DF9BC000DA9B3, 0x000DC9BE000DF9BD, 0x000DF9B8000DC9BF, 0x000DE9BA000DF9B9, 
0x000D31A4000DE9BB, 0x000D31A6000D31A5, 0x000D31A0000D31A7, 0x000D31A2000D31A1, 0x000DF9AC000D31A3, 0x000DC9AE000DF9AD, 0x000DF1A8000DC9AF, 0x000DE9AA000DFDA9, 
0x000DAD94000DE9AB, 0x000DBD96000DB595, 0x000D8D90000DB597, 0x000DBD92000DB591, 0x000DF19C000DB593, 0x000DF19E000DF19D, 0x000D8D98000DF19F, 0x000DFD9A000DF599, 
0x000FB584000DF59B, 0x000FB586000FBD85, 0x000FB980000C6187, 0x000FA982000FB981, 0x000DED8C000FBD83, 0x000DFD8E000DF58D, 0x000C4188000DF58F, 0x000DFD8A000DF589, 
0x000C3DAA000DF58B, 0x000C3DA8000C45AB, 0x000C45AE000C35A9, 0x000C51AC000C4DAF, 0x000C2DA2000C4DAD, 0x0002F9A0000C35A3, 0x000C15A6000C25A1, 0x000C2DA4000C05A7, 
0x000CC9BA0002E9A5, 0x000C31B8000CD5BB, 0x000CCDBE000CCDB9, 0x000CCDBC000CF5BF, 0x0002B9B2000CC5BD, 0x000C35B0000C01B3, 0x000C01B6000C0DB1, 0x000C11B4000C01B7, 
0x0002318A000C11B5, 0x000225880002318B, 0x0002B58E00028589, 0x0002B98C0002BD8F, 0x000C79820002258D, 0x000C6D80000C7983, 0x000C4586000C7981, 0x000C5984000C4D87, 
0x000EB19A000C4D85, 0x000EA5980002099B, 0x000D7D9E00020599, 0x000EA19C000D659F, 0x00022192000EA19D, 0x0002B5900002AD93, 0x0002A19600025191, 0x00023D94000E9D97, 
0x8000141E0002B195, 0x8000138E8000142A, 0x800013D280001393, 0x800013FE800013D7, 0x8000126A80001403, 0x800012B88000126F, 0x800011C3800012BD, 0x80001197800011C8, 
0x800011DF8000119C, 0x80001327800011E4, 0x800013628000132C, 0x8000127780001367, 0x8000129680001283, 0x800012468000129B, 0x80001358800012DD, 0x800010A48000104C, 
0x800010C5800010BE, 0x800010F5800010D1, 0x80001103800010FC, 0x800011BC80001182, 0x8000122C800011B5, 0x8000122080001219, 0x8000125080001257, 0x800012CA8000125E, 
0x8000128880001320, 0x800012A58000127C, 0x8000133E800012AC, 0x8000137980001351, 0x8000138000097882, 0x800013A880001387, 0x800013C4800013BD, 0x800013F7800013E9, 
0x00013580800013F0, 0x0001358200013D81, 0x0001558400014D83, 0x0001558600015D85, 0x0001758800014D87, 0x0001758A00017D89, 0x0004C58C00014D8B, 0x0001518E0001518D, 
0x000131900001518F, 0x0001459200014D91, 0x0001459400015D93, 0x0001459600014D95, 0x0001459800017D97, 0x0001459A00014D99, 0x0001459C00015D9B, 0x0001459E00014D9D, 
0x0001C5A000013D9F, 0x0001C5A20001CDA1, 0x0001C5A40001DDA3, 0x0001C5A60001CDA5, 0x000455A80001FDA7, 0x0001C1AA0001C1A9, 0x0001C1AC0001C1AB, 0x0001E5AE0001EDAD, 
0x000435B00001DDAF, 0x000431B2000435B1, 0x000A81B4000AB1B3, 0x000A81B6000A81B5, 0x0001BDB8000185B7, 0x000A95BA000185B9, 0x000185BC000A6DBB, 0x8000144D000181BD, 
0x000211B78000147E, 0x000201B5000209B6, 0x000211B3000209B4, 0x0007F1B10007E9B2, 0x000211BF000755B0, 0x000201BD000209BE, 0x000211BB000209BC, 0x000221B9000229BA, 
0x00091DA7000229B8, 0x00096DA50007A9A6, 0x000945A3000799A4, 0x0008E9A1000785A2, 0x000781AF000791A0, 0x000999AD000745AE, 0x0009A5AB0009B5AC, 0x00078DA900078DAA, 
0x0007AD9700078DA8, 0x0007A99500076596, 0x0007899300079194, 0x0007919100078192, 0x000BD19F00079990, 0x0007E19D00074D9E, 0x0007F19B0007E99C, 0x00075D990007899A, 
0x0009158700078D98, 0x0009058500091586, 0x0009698300090584, 0x0009718100096182, 0x0007E18F00097980, 0x0007358D0009198E, 0x00091D8B00091D8C, 0x00091D8900091D8A, 
0x0003799000092588, 0x0003759200037991, 0x0003959400038D93, 0x0003959600039D95, 0x0003B59800038D97, 0x0003B19A0003B199, 0x0003919C0003B19B, 0x0003919E0003919D, 
0x800014850003919F, 0x8000151A8000150C, 0x800014F280001513, 0x8000153280001526, 0x800015848000157D, 0x8000155C80001594, 0x800015A08000156A, 0x80001563800015A7, 
0x000355B08000164C, 0x000351B200035DB1, 0x000375B400036DB3, 0x000375B600037DB5, 0x000351B8000371B7, 0x000351BA000351B9, 0x000249BC000351BB, 0x000245BE00024DBD, 
0x00036DA00000FDBF, 0x00037DA2000375A1, 0x000369A4000379A3, 0x000365A600036DA5, 0x000321A800031DA7, 0x000321AA000321A9, 0x00033DAC000325AB, 0x000329AE000339AD, 
0x80001653000329AF, 0x800015FB800015F4, 0x800015E1800015DA, 0x8000161D80001624, 0x8000106F800016B1, 0x800010AB800010B2, 0x800010D8800010DF, 0x8000110A80001111, 
0x8000115F80001190, 0x8000123880001189, 0x8000128F800012D1, 0x8000150080001345, 0x8000169680001539, 0x800016B88000168A, 0x8000148C800015BA, 0x800013CB80001602, 
0x800015D3800014C5, 0x800014F9800015AE, 0x80001166800014BE, 0x80001571800011A9, 0x8000106380001459, 0x800015E88000123F, 0x8000147280001314, 0x8000103A80001043, 
0x800012E28000158B, 0x0003CCF0800011F7, 0x8000166C800013AF, 0x800012F2800012EB, 0x800012058000116D, 0x8000230E800003A5, 0x8000069F80002312, 0x800006B4800000C6, 
0x00019980800023AC, 0x0001A98200019981, 0x00FDF98400018183, 0x0001BD8600FDA985, 0x800023B00001B587, 0x800021B6800021BA, 0x8000097A800007E2, 0x800023428000097E, 
0x00064C91800023A8, 0x8000233A80002336, 0x800023228000231E, 0x8000232A80002326, 0x800023328000232E, 0x800007DE800007DA, 0x800000D6800000D0, 0x800003A7800003A1, 
0x800000D2800007DC, 0x800006BC800000D4, 0x8000140880000078, 0x800000868000007C, 0x8000140D80000090, 0x800014198000009A, 0x80001425800000A4, 0x800006A7800000AE, 
0x00016DB0800006B2, 0x00017DB2000175B1, 0x00016DB4000175B3, 0x00011DB6000115B5, 0x000131B8000111B7, 0x000131BA000131B9, 0x000111BC000131BB, 0x800000B880001431, 
0x000271B280001436, 0x000261B0000271B3, 0x000269B6000261B1, 0x00FFE5B4000269B7, 0x0002A9BA00FD59B5, 0x0002A9B80002A9BB, 0x0002A1BE0002A9B9, 0x0002B1BC0002A1BF, 
0x000271A20002BDBD, 0x000261A0000271A3, 0x000211A6000261A1, 0x000261A4000211A7, 0x000231AA000261A5, 0x000221A8000231AB, 0x000211AE000221A9, 0x000221AC000211AF, 
0x00FDF992000221AD, 0x02807CCC00FDF993, 0x00029996028040CC, 0x0002999400029997, 0x0002B59A00029995, 0x0002A5980002BD9B, 0x0002919E0002BD99, 0x0002A59C0002919F, 
0x00FD8D820002A19D, 0x00FD8D8000FD9583, 0x00FD858600FD8581, 0x00FD898400FD8D87, 0x00FD818A00FD8985, 0x00FDB18800FD818B, 0x00FD818E00FDB189, 0x00FD918C00FD818F, 
0x0003E59000FD918D, 0x0003E5920003ED91, 0x029569940003FD93, 0x0003E1960003E195, 0x000201980003E197, 0x80000FD000B62999, 0x8000109980001056, 0x8000112C8000109C, 
0x800011A180001157, 0x800011E9800011CD, 0x800011F4800011EC, 0x800012118000120E, 0x800012C280001274, 0x8000136C80001331, 0x800013A080001398, 0x8000143B800013DC, 
0x00B685B08000146A, 0x0002A1B20002A1B1, 0x0002BDB40002A1B3, 0x00B609B600B619B5, 0x000295B80002ADB7, 0x000295BA00029DB9, 0x0002F9BC0002E9BB, 0x0002E9BE0002F9BD, 
0x8000149D00B9D9BF, 0x8000154F800014D6, 0x8000163F800015CB, 0x800014DE800014D9, 0x800014E8800014E3, 0x800000D8800000CE, 0x800007E0800003B2, 0x800009808000097C, 
0x00072980800022FC, 0x02A1198202A11581, 0x02A1058402A11983, 0x02A1298602A12585, 0x02A1398802A10587, 0x02A16D8A02A16189, 0x02A1758C02A1698B, 0x0001358E0001398D, 
0x00076D900007118F, 0x0007659200076991, 0x0007619400077D93, 0x00076D9600076195, 0x0007559800076997, 0x0007519A00075D99, 0x0007499C0007559B, 0x0007459E0007499D, 
0x0007BDA00007419F, 0x0007C9A20007C5A1, 0x0007D1A40007CDA3, 0x0007DDA60007D1A5, 0x0007E5A80007D9A7, 0x0007E1AA0007EDA9, 0x0007FDAC0007E1AB, 0x0007E9AE0007E5AD, 
0x000795B00007E9AF, 0x000791B200079DB1, 0x000789B4000795B3, 0x000785B6000789B5, 0x0007BDB8000781B7, 0x000789BA000785B9, 0x000791BC00078DBB, 0x00079DBE000791BD, 
0x0006E1BC000799BF, 0x80002300000F4482, 0x0006C9B880001037, 0x0006C5BA0006C9B9, 0x000D21B40006FDBB, 0x0006FDB60006F1B5, 0x00F071B00006F5B7, 0x000D39B2000D35B1, 
0x000691AC000D3DB3, 0x000C0DAE000C01AD, 0x00069DA800F00DAF, 0x000689AA000685A9, 0x0006A9A400068DAB, 0x0006A5A60006A9A5, 0x0006B5A00006A1A7, 0x0006B1A20006BDA1, 
0x0006419C0006B5A3, 0x00064D9E0006419D, 0x0006ED980006499F, 0x0006599A00065599, 0x0006D99400065D9B, 0x0006D5960006D995, 0x0006C5900006D197, 0x0006C1920006CD91, 
0x0006B18C0006C593, 0x0006BD8E0006B18D, 0x0006BD880006B98F, 0x0006A98A0006A589, 0x000689840006AD8B, 0x0006858600068985, 0x0006958000068187, 0x0006918200069D81, 
0x0007F5BD00069583, 0x0007F5BF0007B1BC, 0x0007B9B90007F5BE, 0x0007A9BB0007B1B8, 0x800029820007B1BA, 0x000789B70007BDB4, 0x0007A1B10007B1B6, 0x800024360007B9B0, 
0x8000246F0007A9B2, 0x800024A08000248E, 0x0007D1A9800024C5, 0x0007D1AB000729A8, 0x0007DDA50007D9AA, 0x02A104D90007DDA4, 0x000705A100B3E5A6, 0x000701A3000705A0, 
0x0007B99D00B3FDA2, 0x0007E59F0007B19C, 0x00B31D990007B19E, 0x0007A99B0007B198, 0x0006519500B30D9A, 0x00065D970290DD94, 0x0006599100065596, 0x800028C400065190, 
0x0007ED8D00B2C992, 0x0007E58F00B3898C, 0x00B39D890007E18E, 0x00B3958B0007BD88, 0x800028E000B3918A, 0x00078D8700078584, 0x0007A581800028F2, 0x0007A58300BC9D80, 
0x0007F5810007A582, 0x0006658380002689, 0x000695850004E982, 0x0004F18700069584, 0x00B2B18900066D86, 0x00B2A98B00B2A988, 0x0006498D0006598A, 0x0004D58F0007D18C, 
0x0293C99100B3498E, 0x0293319300B22190, 0x00B23D9502933992, 0x00B22D9700B23D94, 0x00B21D9900B22D96, 0x0291119B00B21D98, 0x00B2F99D00079D9A, 0x0007819F0006CD9C, 
0x00B60DA10006C19E, 0x00B22DA300060DA0, 0x00B631A500B615A2, 0x00B631A700B609A4, 0x00B245A900B275A6, 0x00B3A1AB00B679A8, 0x00B3A9AD00B3ADAA, 0x00B391AF00B3A5AC, 
0x00B205B100B39DAE, 0x00C7C1B300B3F5B0, 0x00B3B9B500B3F5B2, 0x00B3A9B700B3D1B4, 0x00C7C9B900BF5DB6, 0x00068DBB00BF61B8, 0x000699BD00B239BA, 0x0006D5BF000689BC, 
0x8000168200040DBE, 0x8000296A80002986, 0x8000242E8000242A, 0x8000098580000982, 0x8000098B8000098E, 0x800021ED80000988, 0x800021F1800022F0, 0x800021F9800021F5, 
0x00005DA2800021FD, 0x00005DA0029C35A3, 0x000079A6000055A1, 0x000079A4800022F4, 0x000055AA000079A5, 0x000045A800005DAB, 0x000005AE00005DA9, 0x000045AC800022F8, 
0x00D80D92000029AD, 0x8000E8E500D83593, 0x00D82D968000E8EA, 0x00D82D9400D85D97, 0x00D86D9A00D82595, 0x000005BA00D87D9B, 0x0003C4B18000E8EF, 0x00D8659C000238F0, 
0x00D8F982000174B2, 0x0002149100D8F983, 0x00D88D860002BC84, 0x00D8918400D8B587, 0x00D8858A00D88585, 0x8000E8F400D88D8B, 0x00D8898E000005A7, 0x00D8958C00D87D8F, 
0x00D929AE00D88D8D, 0x00D929AC00D929AF, 0x00D909AA00D929AD, 0x00D90DA800D909AB, 0x00D92DA600D95DA9, 0x00D92DA400D935A7, 0x00D931A200D925A5, 0x00D9D9A000C6F9A3, 
0x00DA65BE00DAF5A1, 0x00D99DBC80001669, 0x00D995BA00DA6DBD, 0x00D9CDB800D985BB, 0x00D9E5B600D99DB9, 0x00D95DB400D9F5B7, 0x00D925B200D9EDB5, 0x00D949B000D909B3, 
0x00D5098E00D92DB1, 0x00D5098C00D1098F, 0x00D5C98A00D5098D, 0x00D11D8800D5C98B, 0x00D1DD8600D11589, 0x00D5FD8400D12587, 0x00D5FD8200D1D585, 0x00D5FD8000D5E583, 
0x0001CD9E00D5F581, 0x00D5459C0001D59F, 0x00D1699A0001C59D, 0x00D1699800D1699B, 0x00D1499600D16999, 0x00D1499400D14997, 0x00D1699200D14995, 0x00D1699000D16993, 
0x00024C9100D16991, 0x000240F00002B892, 0x00F8E09B00025C91, 0x00E6D89900028496, 0x02AD58D9000039A7, 0x000240F08000E8F9, 0x0003A49D00024C91, 0x0010789F00007DBE, 
0x0002C0840007589E, 0x8000E8FE00023882, 0x00029C8C8000E903, 0x0003F8B90002888D, 0x0002A0F000002884, 0x8000E90D00038C87, 0x000338B88000E908, 0x0002008D000328B9, 
0x0000CD978000E912, 0x00025CF000024091, 0x000268910002D492, 0x0000F1B08000E917, 0x0002D09600027CF0, 0x0002C49600025491, 0x0000DDBA0000D1BD, 0x8000E9218000E91C, 
0x8000E9338000E92A, 0x0001CD808000E940, 0x000065AF000059AF, 0x8000E95A8000E94D, 0x8000E96700127590, 0x0009E0A58000E974, 0x8000E97D8000E997, 0x002B54AF8000E9A0, 
0x00BB8CCC8000E98A, 0x00BB68CC8000E9AD, 0x0001FDBC0001E9BB, 0x0001EDBE0001E5BD, 0x80000ACE0001E1BF, 0x80000D5F80000CB1, 0x80000D6B80000D65, 0x80000D7A80000D77, 
0x0001F99E80000D7D, 0x80000D800001F99F, 0x80000D9280000D83, 0x80000D9B80000D98, 0x8000222180000D9E, 0x80000DC802AC00D9, 0x80000DFD80000DD7, 0x80000E00000000CD, 
0x0002B88580000E0F, 0x0003408780000E12, 0x80000E1E00026C86, 0x80000E3380002219, 0x800016D880000E36, 0x000149A480001711, 0x000165A2800016DB, 0x000179A000016DA3, 
0x001BC095000179A1, 0x001C00970019C494, 0x0004D091001ACC96, 0x001800930005D490, 0x0014009D0006DC92, 0x0017E89F0013E09C, 0x001FF0990015EC9E, 0x0010F89B001DF498, 
0x00BD8D80001EFC9A, 0x00B9AD8200BD9D81, 0x00BDB18400BD9183, 0x00BDB18600B9FD85, 0x00B9C58800BDC187, 0x00B8218A00B82589, 0x00B8298C00B83D8B, 0x00B8118E00B8158D, 
0x00B9859000B80D8F, 0x00CC419200B87D91, 0x00B8399400B84993, 0x00B8299600B4D595, 0x00CC499800B4D997, 0x0298059A00B9B199, 0x00B9499C00B8159B, 0x00B8859E00B8099D, 
0x00B981A000B93D9F, 0x00B9B9A2029945A1, 0x00B999A4029945A3, 0x00B989A60296D5A5, 0x02983DA800B909A7, 0x00B281AA00B9BDA9, 0x0299EDAC02997DAB, 0x00B991AE00B995AD, 
0x02991DB000B999AF, 0x029939B20294C5B1, 0x00BD5DB400B985B3, 0x00B97DB600BD4DB5, 0x00BD41B800BD41B7, 0x00BD41BA00B90DB9, 0x00B915BC00BD31BB, 0x00B8F1BE00B8F5BD, 
0x00B9198000B8EDBF, 0x00B9218200B92581, 0x00B8D58400B93D83, 0x00CD118600B92D85, 0x00B9498800B91987, 0x00B9598A00B5A589, 0x00CD198C00B5A98B, 0x0299558E00B8E18D, 
0x00B8799000B9458F, 0x00B9B59200B93991, 0x00B8519400B80D93, 0x00B86996800003B9, 0x00B8699802989597, 0x00B8799A02972599, 0x0299ED9C00B8F99B, 0x00B3519E00B86D9D, 
0x0298DDA00298AD9F, 0x00B8A1A200B8A5A1, 0x02984DA400B8A9A3, 0x029869A6029595A5, 0x00BC2DA800B8D5A7, 0x00B80DAA00BC3DA9, 0x00BC11AC00BC31AB, 0x00BC11AE00B85DAD, 
0x00B825B000BC61AF, 0x00B9C1B200B9C5B1, 0x00B9C9B400B9DDB3, 0x00B9F1B600B9F5B5, 0x00B825B800B9EDB7, 0x00CDE1BA00B9DDB9, 0x00B999BC00B9E9BB, 0x00B989BE00B575BD, 
0x00D209B900B579BF, 0x00D219BB00D201B8, 0x00D209BD00D201BA, 0x00D259BF00D201BC, 0x00D649B100D201BE, 0x00D7D5B3000621B0, 0x00D645B500D641B2, 0x00D239B700D645B4, 
0x000805A900D369B6, 0x000805AB000805A8, 0x0008B1AD000805AA, 0x00095DAF0008EDAC, 0x000E8DA10008B1AE, 0x000F31A3000B6DA0, 0x000851A5000F39A2, 0x000841A7000E9DA4, 
0x029B719900D2E5A6, 0x000FB99B02968598, 0x000FA59D00BBC59A, 0x000D659F000D619C, 0x00B08991000D659E, 0x029BF59300BBBD90, 0x00BB9995029B7D92, 0x029B659700BB9594, 
0x00BBF18900BB9996, 0x00BBC18B029B0588, 0x00BBC18D029B058A, 0x029A458F0294958C, 0x029A8D8100BB498E, 0x00BBD18300BAF980, 0x00BA0D8500BA9582, 0x00BBF98700BA8984, 
0x00CF298000BBBD86, 0x029B658200BAD181, 0x00BA298400BB7583, 0x00BBE58600BB6985, 0x00BA218800BA5D87, 0x00BA198A029AE589, 0x00BA398C029AE58B, 0x00BA298E0295758D, 
0x029BDD9000BAA98F, 0x00B1619200BA5D91, 0x029A0D94029A9D93, 0x00BA719600BA7595, 0x029ABD9800BA7997, 0x029A999A02976599, 0x00BEFD9C00BA259B, 0x00BADD9E800003B6, 
0x002C00B900BEE19F, 0x00BE21A2001284B8, 0x800003C9002D8CBA, 0x00BB91A600BB95A5, 0x8000058B800004EC, 0x00BB81AA00BB85A9, 0x00BA75AC00BB9DAB, 0x00CFB1AE800005DE, 
0x00BBA9B000BBB9AF, 0x00BBB9B200B745B1, 0x00CFF9B400B749B3, 0x029BB5B600BA01B5, 0x00BAD9B800BBA5B7, 0x8000061900BB99B9, 0x8000063F00BAADBB, 0x00BAC9BE029A35BD, 
0x0285DD80029A35BF, 0x0285F98202880581, 0x00A19D8400A54583, 0x8000065600A18D85, 0x00A1818800A18187, 0x00A1818A00A5CD89, 0x8000068A80000673, 0x00A4318E00A4358D, 
0x00A4599000A42D8F, 0x00A4619200A46591, 0x00A5959400A47D93, 0x00D0519680000137, 0x00A4099800A45997, 0x00A4199A00A8E599, 0x00D0599C00A8E99B, 0x0284159E8000013B, 
0x00A5B9A000A4059F, 0x00A475A200A4F9A1, 0x00A591A400A5CDA3, 0x00A5A9A6028555A5, 0x00A5A9A8028555A7, 0x00A5B9AA028AE5A9, 0x02842DAC00A539AB, 0x00AE91AE00A5ADAD, 
0x02859DB002856DAF, 0x00A5E1B200A5E5B1, 0x02850DB400A5E9B3, 0x028529B60288D5B5, 0x00A16DB800A595B7, 0x8000013F00A17DB9, 0x00A151BC00A171BB, 0x00A151BE00A51DBD, 
0x00A411B680000143, 0x00A401B400A491B7, 0x00A421B2028B4DB5, 0x00A419B00284DDB3, 0x00A409BE0284DDB1, 0x028475BC00A401BF, 0x00AF19BA00A40DBD, 0x0285A5B80284E5BB, 
0x00A531A600A425B9, 0x00A521A400A9C1A7, 0x00D159A200A9CDA5, 0x00A49DA000A551A3, 0x00A59DAE00A565A1, 0x00A451AC00A425AF, 0x02851DAA00A511AD, 0x00D151A800A50DAB, 
0x00A0299600A4A9A9, 0x00A0299400A05997, 0x00A4359200A46595, 0x00A0159000A00993, 0x00A5899E00A00591, 0x00A5B19C00A5959F, 0x00A5B99A00A58D9D, 0x00A45D9800A5A59B, 
0x00AFE98600A5BD99, 0x8000014702841587, 0x00A4C18200A4D585, 0x00A4D18000A44183, 0x0284118E028B9D81, 0x0284358C00A4AD8F, 0x00A4D98A0289ED8D, 0x0284A58800A4D18B, 
0x00A7E58000A4DD89, 0x00A6018200A60581, 0x00A6098400A61D83, 0x00A631868000014B, 0x800001538000014F, 0x00D2218A80000157, 0x00A6598C00A6298B, 0x00A6498E00AAB58D, 
0x00D2699000AAB98F, 0x028625928000015B, 0x00A7699400A63593, 0x00A6A59600A62995, 0x00A7619800A71D97, 0x00A7599A0287A599, 0x00A7799C0287A59B, 0x00A7699E0288359D, 
0x02861DA000A7E99F, 0x00ACA1A200A79DA1, 0x0287CDA402875DA3, 0x00A7B1A600A7B5A5, 0x02877DA800A7B9A7, 0x028759AA028AA5A9, 0x00A33DAC00A7E5AB, 0x00A71DAE00A32DAD, 
0x00A361B000A321AF, 0x00A361B200A72DB1, 0x00A735B400A311B3, 0x00A6D1B600A6D5B5, 0x00A6F9B800A6CDB7, 0x00A6C1BA00A6C5B9, 0x00A735BC00A6DDBB, 0x00D2F1BE00A6CDBD, 
0x00A7698000A6F9BF, 0x00A7798200AB8581, 0x00D3398400AB8983, 0x0287758600A6C185, 0x00A6198800A76587, 0x00A7D58A00A75989, 0x00A6318C00A66D8B, 0x00A6098E0286F58D, 
0x00A649900286F58F, 0x00A6599202890591, 0x0287CD9400A6D993, 0x00AD719600A64D95, 0x02863D9802868D97, 0x00A6419A00A64599, 0x0286AD9C00A6499B, 0x0286899E028B759D, 
0x00A20DA000A6359F, 0x00A62DA200A21DA1, 0x00A231A400A211A3, 0x00A231A600A67DA5, 0x00A645A800A241A7, 0x00A7A1AA00A7A5A9, 0x00A7A9AC00A7BDAB, 0x00A791AE00A795AD, 
0x00A605B000A78DAF, 0x00D3C1B200A7FDB1, 0x00A7B9B400A7C9B3, 0x00A7A9B600AB55B5, 0x00D3C9B800AB59B7, 0x028785BA00A631B9, 0x00A6C9BC00A795BB, 0x00A705BE00A789BD, 
0x02815D8000A6BDBF, 0x00A1218200A12581, 0x0281CD8400A12983, 0x0281E986028C1585, 0x00A5AD8800A15587, 0x00A18D8A00A5BD89, 0x00A5918C00A5B18B, 0x00A5918E00A1DD8D, 
0x00A1A59000A5E18F, 0x00A0419200A04591, 0x00A0499400A05D93, 0x00A0719600A07595, 0x00A1A59800A06D97, 0x00D4619A00A05D99, 0x00A0199C00A0699B, 0x00A0099E00ACF59D, 
0x00D4A9A000ACF99F, 0x0280E5A200A151A1, 0x00A1A9A400A0F5A3, 0x00A065A600A0E9A5, 0x00A1A1A800A1DDA7, 0x00A199AA028165A9, 0x00A1B9AC028165AB, 0x00A1A9AE028EF5AD, 
0x02805DB000A129AF, 0x00AAE1B200A1DDB1, 0x02818DB402811DB3, 0x00A1F1B600A1F5B5, 0x02813DB800A1F9B7, 0x028119BA028CE5B9, 0x00A57DBC00A1A5BB, 0x00A15DBE00A56DBD, 
0x00A1FDB200A561BF, 0x00A031B000A045B3, 0x00A021B600A171B1, 0x00A019B40280DDB7, 0x00A031BA0280DDB5, 0x00A021B800A0B1BB, 0x00AB19BE028F6DB9, 0x0281A5BC0280E5BF, 
0x00A169A200A025BD, 0x00A151A000A175A3, 0x00D559A600A16DA1, 0x00A09DA400A151A7, 0x00A111AA00A165A5, 0x00A101A800ADE1AB, 0x02811DAE00ADEDA9, 0x00D551AC00A10DAF, 
0x0280719200A0A9AD, 0x0280559000A0CD93, 0x00A03596028D8D91, 0x00A4159400A40997, 0x00A4099A00A40595, 0x00A4099800A4799B, 0x00A1B99E00A04599, 0x00A05D9C00A1A59F, 
0x00A0F18200A1BD9D, 0x00A0C98002800D83, 0x00A0C18602800D81, 0x00A0D18400A04187, 0x00ABC98A028F9D85, 0x028175880280358B, 0x00A0D98E00A0F589, 0x0280A58C00A0D18F, 
0x00A7A18000A0DD8D, 0x00A7A18200A3ED81, 0x00A3F58400A7D183, 0x00A2118600A21585, 0x00A2398800A20D87, 0x00A2018A00A20589, 0x00A3F58C00A21D8B, 0x00D6318E00A20D8D, 
0x00A2299000A2398F, 0x00A2399200AEC591, 0x00D6799400AEC993, 0x0282359600A38195, 0x00A3599800A22597, 0x00A2959A00A21999, 0x00A3719C00A32D9B, 0x00A3499E0283B59D, 
0x00A389A00283B59F, 0x00A399A2028CC5A1, 0x02820DA400A319A3, 0x00A8B1A600A38DA5, 0x0283FDA802834DA7, 0x00A381AA00A385A9, 0x02836DAC00A389AB, 0x028349AE028EB5AD, 
0x00A74DB000A3F5AF, 0x00A36DB200A75DB1, 0x00A771B400A751B3, 0x00A771B600A33DB5, 0x00A305B800A701B7, 0x00A2E1BA00A2E5B9, 0x00A2E9BC00A2FDBB, 0x00A2D1BE00A2D5BD, 
0x00A2C58000A2CDBF, 0x00D7018200A33D81, 0x00A3798400A30983, 0x00A3698600AF9585, 0x00D7098800AF9987, 0x0283458A00A2F189, 0x00A2098C00A3558B, 0x00A3C58E00A3498D, 
0x00A2419000A27D8F, 0x00A2799202828591, 0x00A2599402828593, 0x00A24996028D1595, 0x0283FD9800A2C997, 0x00A9419A00A27D99, 0x02822D9C0282BD9B, 0x00A2519E00A2559D, 
0x02825DA000A2599F, 0x028279A2028F85A1, 0x001CB1A400A2C5A3, 0x8000015F001CB1A5, 0x000C01A880000163, 0x00A255AA001C8DA9, 0x000FB1AC001C81AB, 0x000FB1AE001C85AD, 
0x000FD1B002B679AF, 0x001CF1B2001CF1B1, 0x001C99B4001CF1B3, 0x000FC1B6001C99B5, 0x000FC1B800A19DB7, 0x02B625BA02B621B9, 0x02B65DBC001CBDBB, 0x001CA1BE001CA1BD, 
0x80000D68001CA1BF, 0x80000D6E00000015, 0x80000D7480000167, 0x80000D868000016B, 0x80000D8C8000016F, 0x80000DB980000173, 0x80000DCB80000177, 0x80000E038000017B, 
0x80000E158000017F, 0x80000E2180000183, 0x0038508480000187, 0x0010C48600019485, 0x003960888000018B, 0x8000018F003C0089, 0x8000019780000193, 0x800023468000019B, 
0x800007C7800006D0, 0x800007938000070E, 0x028DF4CC80000799, 0x8000077C0282C0CD, 0x8000074E800007C4, 0x800006E080000751, 0x800025E380002410, 0x80002CAE80002E29, 
0x8000373380002DCA, 0x800030C780002B02, 0x80002C02800032B3, 0x80002B9A80002F54, 0x80002BEE800030A0, 0x8000378F8000351B, 0x80002CE680002DAE, 0x8000300480003267, 
0x00ACD98080003030, 0x0001218200126581, 0x00ABA58402B8A983, 0x02B8D18600ABD185, 0x0001118800127587, 0x00AC798A02B88D89, 0x00125D8C02B8958B, 0x0012498E028DB58D, 
0x000179900012458F, 0x02B8F59202B8F191, 0x00122D9402B88D93, 0x000119960012D195, 0x00ABA99802B8ED97, 0x0001219A0012F599, 0x02B8B99C0012F99B, 0x02B8C19E02B8DD9D, 
0x02B83DA002B8CD9F, 0x000229A202B831A1, 0x00AC6DA40012A5A3, 0x000199A60012B9A5, 0x0001A9A80012ADA7, 0x0001B9AA02B861A9, 0x001289AC001299AB, 0x0012F1AE001289AD, 
0x0001D9B00012F1AF, 0x0001E9B200AF85B1, 0x02B81DB402B809B3, 0x02B875B6001285B5, 0x0012B9B8001289B7, 0x00AC31BA0012B9B9, 0x0001D9BC00128DBB, 0x00AB4DBE02B851BD, 
0x0011698100AB39BF, 0x02BBA18302BBCD80, 0x02BBA98500023D82, 0x028E998700AF4584, 0x0011598900117186, 0x02BB9D8B00115588, 0x02BBF18D0002158A, 0x0011BD8F02BB898C, 
0x02BBF1910011418E, 0x0011D99300020590, 0x0011C59500A88592, 0x02BBF19700021D94, 0x02BBD19902BB9596, 0x02BBDD9B02BBDD98, 0x0011599D02BBD19A, 0x0011559F0001D59C, 
0x0011B1A100AF819E, 0x02BB4DA3000285A0, 0x0011A5A5000285A2, 0x0011A5A7000285A4, 0x0011EDA90011A5A6, 0x00ACE9AB0011EDA8, 0x02BB75AD0002B5AA, 0x0011E9AF000295AC, 
0x001195B102BB71AE, 0x001195B302BB69B0, 0x0011B1B5001195B2, 0x02BB7DB700AF0DB4, 0x00A825B90002F5B6, 0x001181BB00A851B8, 0x02BB59BD02BB25BA, 0x02BB41BF0002C5BC, 
0x028408CC00AFADBE, 0x028680CC0284E4CD, 0x02835CCC028698CD, 0x028570CC8000380F, 0x0280A0CC0285BCCD, 0x02832CCC0280FCCD, 0x028108CC028314CD, 0x028038CC028180CD, 
0x80003024028054CD, 0x8000347380002FFC, 0x80002CD2800034AF, 0x8000339B80003247, 0x80002D3280002C06, 0x0003C9AA8000238A, 0x028698CC0003C9AB, 0x02B870CC02B9C4CD, 
0x8000234E02B8FCCD, 0x8000236C80002358, 0x8000237680002394, 0x800023628000239E, 0x80000D5C80002380, 0x80002CC280002F58, 0x80002ACE80002AD6, 0x8000E9BA80002ADE, 
0x00AE058080002B22, 0x00DBC18200AFFD81, 0x00AFB98400AFC983, 0x00AFA98600A35585, 0x00DBC98800A35987, 0x00036D8A00AE3189, 0x0003798C00C5E18B, 0x0003618E0003798D, 
0x02BDBD800003618F, 0x0017758202BDC581, 0x0004518400178983, 0x00AED18602BDA585, 0x0004698800178D87, 0x02BDE18A0017B189, 0x02BD898C02BD858B, 0x02BD858E02BD858D, 
0x0007E19002BD898F, 0x00A9B59200176D91, 0x0004519400176193, 0x0004519600176595, 0x0004719802BD9997, 0x0017519A00175199, 0x0017399C0017519B, 0x0004619E0017399D, 
0x0004A1A000AA3D9F, 0x02BD45A202BD41A1, 0x02BD3DA40017DDA3, 0x0017C1A60017C1A5, 0x00A979A80017C1A7, 0x000481AA0017C5A9, 0x00AE05AC02BD09AB, 0x02BD71AE00AE71AD, 
0x0004F1B00017D5AF, 0x00A999B202BD6DB1, 0x0017BDB402BD75B3, 0x0017A9B6028855B5, 0x0004D9B80017A5B7, 0x02BD55BA02BD51B9, 0x00178DBC02BD2DBB, 0x0004B9BE001771BD, 
0x00A851B802BD4DBF, 0x001665BA02BCBDB9, 0x001661BC02898DBB, 0x000521BE00166DBD, 0x000509B002BCA9BF, 0x00AF9DB202BC81B1, 0x02BCF9B400AFE9B3, 0x000509B600165DB5, 
0x02BC8DA802BC95B7, 0x02BCE5AA001615A9, 0x001609AC001619AB, 0x00A881AE001609AD, 0x001659A000163DAF, 0x001621A2001659A1, 0x000569A4001621A3, 0x000559A600AB35A5, 
0x00A87D9802BCB9A7, 0x0005899A0016A999, 0x0005999C0016BD9B, 0x0005899E02BC519D, 0x02BC69900016A99F, 0x02BC119202BC0D91, 0x02BC0D9402BC1D93, 0x0006199602BC0195, 
0x0016BD8800169597, 0x0005898A00164189, 0x00AF198C02BC7D8B, 0x0005918E0016458D, 0x00168D800016498F, 0x0016998202896581, 0x0005C98400169583, 0x02BC458602BC4185, 
0x00ACC98002BC3D87, 0x0006418200159581, 0x02BFD98400159983, 0x02BFA18602BFBD85, 0x02BF9D8802BFAD87, 0x0015B18A02BF9189, 0x80002B360015B18B, 0x00AB5D8E80002B3E, 
0x028A3590028AB58F, 0x00AB2192028A3D91, 0x00AB219400AB2193, 0x00AB219600AB2195, 0x00AB059800AB2197, 0x028A1D9A028AED99, 0x00AB199C028A159B, 0x00AB099E00AB199D, 
0x00ABF9A000AB099F, 0x00ABEDA200ABF9A1, 0x028AE5A4028A05A3, 0x00ABF1A6028AEDA5, 0x00ABD1A800ABF1A7, 0x00ABD1AA00ABD1A9, 0x00ABD5AC00ABD1AB, 0x028ACDAE028A3DAD, 
0x00ABA9B0028AC5AF, 0x00ABB9B200ABA9B1, 0x00ABA9B400ABB9B3, 0x00ABBDB600ABA9B5, 0x028A95B8028A55B7, 0x00AB81BA028A9DB9, 0x00AB81BC00AB81BB, 0x00AB81BE00AB81BD, 
0x001A0D8000AB81BF, 0x001C3582001C2981, 0x80002B46001C4583, 0x001C4D8600165185, 0x001C4988001C5D87, 0x001CE98A00172589, 0x001CF98C001CE98B, 0x001C618E001CF98D, 
0x001C3990001C4D8F, 0x001C3592001C2591, 0x001C0D94001C1D93, 0x001C6196001C6195, 0x001C2D98001C1997, 0x001C059A001C0199, 0x0014D19C001C199B, 0x0014DD9E00EBAD9D, 
0x80002B4A0014D19F, 0x001CB5A2001CA9A1, 0x001C41A480002B4E, 0x8000E9CE8000298E, 0x80002B6E001CDDA7, 0x001C69AA0017A5A9, 0x001C79AC001C69AB, 0x001CE1AE001C79AD, 
0x001CB9B0001CCDAF, 0x001CB5B2001CA5B1, 0x001C8DB480002B72, 0x001CE1B6001CE1B5, 0x000000F9001C99B7, 0x80002B8E001C81B9, 0x8000E9BF001C99BB, 0x80002B7A80002992, 
0x00250D808000E9C9, 0x0023358200232981, 0x0023C18400234583, 0x00234D8600295185, 0x0023498800235D87, 0x80002BAA00282589, 0x0023F98C0023E98B, 0x0023618E0023F98D, 
0x0023399000234D8F, 0x0023359200232591, 0x00230D9400231D93, 0x0023619600236195, 0x00232D9800231997, 0x0023059A00230199, 0x80002BB20023199B, 0x80002BBA80002B12, 
0x80002BE28000EBA4, 0x0023B5A20023A9A1, 0x8000299A0023C5A3, 0x0023CDA60029D1A5, 0x0023C9A80023DDA7, 0x80002BFA0028A5A9, 0x002379AC002369AB, 0x0023E1AE002379AD, 
0x0023B9B00023CDAF, 0x0023B5B20023A5B1, 0x00238DB400239DB3, 0x0023E1B60023E1B5, 0x0023ADB8002399B7, 0x002385BA002381B9, 0x80002BFE002399BB, 0x8000299E80002C0A, 
0x0000004180002C42, 0x002235A2002229A1, 0x0022C1A480002C46, 0x80002C7A80002C6E, 0x002249A800225DA7, 0x0022E9AA002925A9, 0x0022F9AC80002C8A, 0x002261AE0022F9AD, 
0x002239B000224DAF, 0x002235B2002225B1, 0x00220DB480002C92, 0x002261B6002261B5, 0x80002C96002219B7, 0x002205BA002201B9, 0x002AD1BC002219BB, 0x002ADDBE8000E9DD, 
0x80002CAA80003297, 0x0022B58280002CB2, 0x80002CBE8000E9E2, 0x80002CCE80002CC6, 0x80002CF60022DD87, 0x80002CE20029A589, 0x80002CEE0022698B, 0x0022E18E0022798D, 
0x80002CF20022CD8F, 0x0022B5920022A591, 0x00228D9480002CFA, 0x80002D0680002D02, 0x80002D0E00229997, 0x80002D1600228199, 0x80002D1A0022999B, 0x80002D2A00D52D9D, 
0x002F5580002A519F, 0x002D9982002D7181, 0x002DB184002D9183, 0x002DF186002DA185, 0x00323988002DED87, 0x0032198A00320989, 0x80002D3A80002D2E, 0x80002D6280002D5E, 
0x0032159080002D46, 0x0032A19200323191, 0x003399940032B193, 0x0030459600304195, 0x0030459800307D97, 0x0035F19A00302199, 0x003A7D9C0035F19B, 0x003A659E003A619D, 
0x003AADA0003A599F, 0x003AB5A2003AB1A1, 0x003ADDA4003AC9A3, 0x003AF1A6003AC9A5, 0x003AD1A8003AF1A7, 0x003AD1AA003AD1A9, 0x009689AC009709AB, 0x003A39AE003AC9AD, 
0x00934DB080002D4E, 0x00976DB200935DB1, 0x009371B4009351B3, 0x009371B600973DB5, 0x009705B8009301B7, 0x0096E1BA0096E5B9, 0x0096E9BC0096FDBB, 0x0096D1BE0096D5BD, 
0x003BAD800096CDBF, 0x00FF1982003BB581, 0x80002DAA0013F4A8, 0x80002D7680002D72, 0x000820A380002D7A, 0x000428A1000624A2, 0x001030A700052CA0, 0x000D38A5000E34A6, 
0x00E3F190000C00A4, 0x003BF192003BF191, 0x009C1D9400EE9193, 0x003B9996003BE995, 0x003BA59800F0ED97, 0x003BA59A003BAD99, 0x003BA19C00C90D9B, 0x003BA19E003BA19D, 
0x003B61A0003BA19F, 0x00E259A2003B61A1, 0x003B7DA4003B65A3, 0x003B6DA6003B65A5, 0x003B5DA8003B65A7, 0x00F099AA009CB9A9, 0x00F579AC0038B9AB, 0x00F575AE00F0D1AD, 
0x00E441B00038FDAF, 0x003881B2003881B1, 0x003881B4003881B3, 0x00F55DB6003881B5, 0x0038B9B800E335B7, 0x003889BA0038B9B9, 0x80002D8280002D6E, 0x80002D9680002D7E, 
0x003FAD808000E9E7, 0x003FBD82003FB581, 0x003FAD84003FB583, 0x003A298600CFC985, 0x003B3188003A2987, 0x00CFC98A003BA589, 0x003BA58C003BA18B, 0x00CFDD8E003BAD8D, 
0x003B8D90003B9D8F, 0x003BB992003BAD91, 0x003BA994003BB993, 0x003BA596003C8D95, 0x0004119800047597, 0x0004119A00041199, 0x00040D9C00CBFD9B, 0x0004F99E009BF59D, 
0x000429A00004ED9F, 0x003FD5A2000475A1, 0x000469A4000479A3, 0x00CF71A600CB31A5, 0x00CB09A800CF71A7, 0x0005A5AA000459A9, 0x0005A5AC00CCA5AB, 0x0005A1AE00CF45AD, 
0x00058DB0000591AF, 0x0005A9B20005A5B1, 0x0005A5B40005ADB3, 0x000559B60005A9B5, 0x00056DB8000559B7, 0x00057DBA000575B9, 0x000551BC000575BB, 0x000549BE00055DBD, 
0x0004CD8000053DBF, 0x0004D1820004D181, 0x0004F9840004ED83, 0x0004E9860004E585, 0x0004D98800CAAD87, 0x0007198A00070989, 0x00CEC98C0007198B, 0x0007058E00070D8D, 
0x00CE15900007818F, 0x00065D9200065591, 0x00064D9400065593, 0x0006A9960006B995, 0x000699980006A997, 0x00036D9A00069999, 0x00037D9C0003659B, 0x0003699E003DC99D, 
0x000399A00003699F, 0x0003A1A2000399A1, 0x0003A1A40003A1A3, 0x0003A1A60003A1A5, 0x0003E1A80003A1A7, 0x0003E5AA0003EDA9, 0x0003E1AC0003E1AB, 0x0003E1AE0003E1AD, 
0x00039DB000C041AF, 0x00034DB2000345B1, 0x00035DB4000345B3, 0x000349B600E59DB5, 0x00E5B5B8000349B7, 0x000375BA00037DB9, 0x000355BC00034DBB, 0x000355BE00035DBD, 
0x0000008000034DBF, 0x80002DB680002DB2, 0x80002DD280002DBE, 0x8000E9EC80002DF5, 0x003D89918000E9F1, 0x80002E01003D8190, 0x80002E0980002E05, 0x80002E1180002DFD, 
0x800029A6800029A2, 0x80002E19003DD988, 0x8000E9F680002E21, 0x80002E4180002E3D, 0x003DE18180002E4D, 0x003DE183003D0180, 0x003DE185003DE982, 0x003DE187003DF984, 
0x8000E9FB003DE986, 0x80002E5980002E55, 0x800029AA80002F38, 0x80002E8980002E6D, 0x8000EA0580002E85, 0x8000EA0A80002E91, 0x80002E9980002E9D, 0x80002EB180002EA1, 
0x800029AE80002EB5, 0x80002ECD80002EC5, 0x80002ED580002ED1, 0x8000EA0F800029B2, 0x80002EF8800029B6, 0x80002F0080002EFC, 0x8000EA198000EBD6, 0x80002F30800035DB, 
0x0001B580800029BA, 0x0001B5820001BD81, 0x0001D5840001CD83, 0x0001D5860001DD85, 0x0001F5880001CD87, 0x0001F58A0001FD89, 0x0001D58C0001CD8B, 0x00C2258E0001DD8D, 
0x00E73D900001D18F, 0x0001B9920001B591, 0x0001A9940001B993, 0x0001A5960001AD95, 0x000F6198000C0197, 0x000F619A000F6199, 0x000F619C000F619B, 0x000F619E000F619D, 
0x000FA1A0000F619F, 0x000FA1A2000FA1A1, 0x000FBDA400CBC1A3, 0x000FADA6000FA5A5, 0x00C841A8000FA5A7, 0x000F95AA000F9DA9, 0x000FF1AC00CBD1AB, 0x000FF1AE000FF1AD, 
0x00CB45B0000FF1AF, 0x000F99B200C385B1, 0x000F89B4000F99B3, 0x000FB9B6000F89B5, 0x000F89B8000FB9B7, 0x000F99BA000F89B9, 0x000F89BC000F99BB, 0x000F79BE000F89BD, 
0x8000EB0E000F79BF, 0x80002F4880002F40, 0x80002F5C800029BE, 0x80002F7080002F6C, 0x80002F8880002F78, 0x800029C2800029C6, 0x80002F908000EA1E, 0x80002FA880002FA4, 
0x80002FCC80002FB8, 0x80002FC880002FC4, 0x80002FE480002FD0, 0x8000300080002FE8, 0x8000301880003008, 0x8000EA2D8000302C, 0x8000301C80003028, 0x8000303C80003034, 
0x8000EA3280003050, 0x8000304C80003058, 0x800029CA80003044, 0x8000306880003060, 0x8000306480003070, 0x80003088800029CE, 0x800030B48000EA37, 0x800030D2800030F6, 
0x800029D6800029DA, 0x80002B9E800029D2, 0x800030FA80002BA2, 0x800035AF800030E2, 0x8000310E80002A3E, 0x8000311A80003122, 0x800029DE8000EA50, 0x8000312A80003136, 
0x0001898080003153, 0x0001998200018981, 0x0001898400019983, 0x0001B98600018985, 0x00C5B1880001B987, 0x0001858A00018D89, 0x0001858C00019D8B, 0x0001858E00018D8D, 
0x0001819000C59D8F, 0x0001819200018191, 0x0001819400018193, 0x0001819600018195, 0x00CC459800018197, 0x0001899A00D96599, 0x0001999C0001899B, 0x0001899E0001999D, 
0x000179A00001899F, 0x00C52DA2000179A1, 0x000395A400038DA3, 0x000395A600039DA5, 0x0003B1A800D88DA7, 0x0003B1AA0003B1A9, 0x000391AC0003B1AB, 0x000391AE000391AD, 
0x0003F1B0000391AF, 0x0003F1B20003F1B1, 0x000391B40003F1B3, 0x00039DB600C1E9B5, 0x0003ADB8000395B7, 0x0003BDBA0003B5B9, 0x0003ADBC0003B5BB, 0x00039DBE000395BD, 
0x8000EA5A000395BF, 0x8000313E8000315F, 0x8000316B80003167, 0x800031738000316F, 0x8000EA5F8000317F, 0x800029E680003187, 0x8000EA6480003193, 0x800029EA80003197, 
0x800031AF800031A3, 0x8000EA69800031BF, 0x8000EA6E8000EA00, 0x8000EA73800031DF, 0x800031F3800031EB, 0x800031FF800031E3, 0x800032178000320F, 0x8000322780003223, 
0x8000320B8000EA78, 0x800032438000323F, 0x80003253800029EE, 0x800032378000EA7D, 0x8000EA8280003273, 0x800032778000EA87, 0x800032838000328B, 0x8000328F800029F2, 
0x8000329B8000329F, 0x8000E9C4800032A7, 0x8000EA8C800032B7, 0x8000EA96800032C3, 0x800032F7800032D7, 0x8000330B8000EA9B, 0x8000EAA08000330F, 0x8000332B8000EAA5, 
0x000000808000333B, 0x8000333F800029F6, 0x80003357800029FA, 0x800033678000335B, 0x800029FE80003373, 0x8000EAAA8000338B, 0x8000EAAF800033A7, 0x800033C38000EA14, 
0x8000EAB98000EAB4, 0x80002A028000EABE, 0x8000EAC880002A06, 0x8000EACD8000EAC3, 0x8000EAD28000EA3C, 0x8000340780003403, 0x80002A1280003413, 0x8000EADC80002A16, 
0x80002A1A80003427, 0x8000EAE68000EAE1, 0x800034978000EAEB, 0x800034A380002A1E, 0x8000EAF0800034A7, 0x800034BF8000EAF5, 0x8000EAFA80002A22, 0x800034D7800034D3, 
0x8000EAFF80002A26, 0x80002A2A800034F3, 0x800034FB80003503, 0x8000EB098000350B, 0x80002A2E80003523, 0x800035378000352F, 0x80002A3280003547, 0x8000EB188000EB13, 
0x00DC398080002A36, 0x00075D8200075581, 0x0007718400075583, 0x0007718600077185, 0x00DC1D8800077587, 0x0007458A00DD3D89, 0x0007458C00075D8B, 0x0007458E00074D8D, 
0x00DC059000C94D8F, 0x0007CD920007C591, 0x0007D99400C36993, 0x00C7F1960007D995, 0x0007F5980007CD97, 0x0007F19A00C35599, 0x0007D19C0007F19B, 0x0007DD9E0007D19D, 
0x00072DA00007D59F, 0x00073DA2000735A1, 0x00072DA4000735A3, 0x00075DA6000755A5, 0x00076DA8000755A7, 0x00077DAA000775A9, 0x00076DAC000775AB, 0x00075DAE000755AD, 
0x00072DB0000755AF, 0x00073DB2000735B1, 0x00072DB4000735B3, 0x0002D1B60002D1B5, 0x0002F1B80002D1B7, 0x00C3A1BA0002F1B9, 0x0002EDBC0002F5BB, 0x0002DDBE0002D5BD, 
0x00079D8F0002D5BF, 0x00079D8D00079D8E, 0x00DD1D8B00079D8C, 0x000791890007998A, 0x0007A18700079988, 0x0007518500075986, 0x0007418300075984, 0x00C0818100C7BD82, 
0x0007999F00075180, 0x0007999D0007919E, 0x0007999B0007819C, 0x000799990007919A, 0x0007D9970007E198, 0x0007D9950007D196, 0x0007DD9300DD7D94, 0x0007DD910007DD92, 
0x000695AF0007DD90, 0x000685AD000695AE, 0x000699AB000681AC, 0x000765A9000691AA, 0x000755A7000765A8, 0x000745A5000755A6, 0x000755A3000745A4, 0x00DDA1A1000755A2, 
0x00068DBF000761A0, 0x00068DBD00068DBE, 0x0006EDBB00068DBC, 0x0006EDB90006EDBA, 0x0006D1B700C5D9B8, 0x0006C1B50006C9B6, 0x0006D1B30006C9B4, 0x0006E1B10006E9B2, 
0x0000008000DDDDB0, 0x8000355F8000EB1D, 0x8000356B8000EB22, 0x8000EB2780003577, 0x800035938000EB2C, 0x8000359B8000EB31, 0x80002A3A8000EA41, 0x800035B7800035B3, 
0x800035BB80002A42, 0x8000EB3680002E15, 0x8000EA468000EB3B, 0x800035DF8000EA4B, 0x80002A46800037F7, 0x800036078000360B, 0x80002C1A8000360F, 0x8000361780003613, 
0x800036238000361B, 0x800036278000EB40, 0x8000363F8000363B, 0x800036438000362B, 0x8000363780003657, 0x8000364F8000364B, 0x8000EB4580003653, 0x8000EB4A8000EB4F, 
0x8000367380002A4A, 0x8000367F80003677, 0x800036838000EB63, 0x80002A4E8000EB54, 0x8000EB5980002A52, 0x80002A568000EB5E, 0x800036AB800036A3, 0x800036BB800036AF, 
0x00012D80800036B7, 0x00013D8200013581, 0x00012D8400013583, 0x00015D8600015585, 0x00016D8800015587, 0x00017D8A00017589, 0x0001698C0009D98B, 0x0001598E0001698D, 
0x000129900001598F, 0x0001399200012991, 0x0001299400013993, 0x0001D99600012995, 0x00C729980001D997, 0x0001E59A0001ED99, 0x0001E59C0001FD9B, 0x0001E59E0001ED9D, 
0x000121A000C0299F, 0x000121A2000121A1, 0x000121A4000121A3, 0x000121A6000121A5, 0x000161A8000121A7, 0x000161AA000161A9, 0x000161AC000161AB, 0x000161AE000161AD, 
0x000121B0000161AF, 0x000121B2000121B1, 0x00CA8DB4000121B3, 0x00012DB6000125B5, 0x00011DB8000125B7, 0x001FE9BA001C01B9, 0x001FF5BC00DF8DBB, 0x001FF5BE001FFDBD, 
0x800036BF001FEDBF, 0x800036CB800036C7, 0x80002A5A800036D3, 0x800036DF800036DB, 0x800036EF80002A5E, 0x800036FF8000EB68, 0x80002A6280003703, 0x800029968000370F, 
0x8000EB728000EB6D, 0x80002A6A80002A66, 0x8000EB778000373B, 0x8000379780003793, 0x800037BB800037AF, 0x8000E9D38000EB81, 0x800037C3800037C7, 0x8000E9D8800037CF, 
0x8000EB86800037DB, 0x800038278000EB8B, 0x8000383B80003833, 0x8000383F8000EB90, 0x8000387380003867, 0x8000386F80003877, 0x8000388780003883, 0x800038938000EB95, 
0x8000389B80002A6E, 0x80002A728000EB9A, 0x80002EA5800038D3, 0x8000EB9F800038EB, 0x80002A768000EBA9, 0x8000391380002A7A, 0x80002A7E8000EBAE, 0x0000007E8000EBB3, 
0x0001158080003933, 0x0001158200011D81, 0x00F2BD8400012D83, 0x0001318600013185, 0x0001118800013187, 0x0001118A00011189, 0x0001718C0001118B, 0x0001718E0001718D, 
0x00C135900001718F, 0x00F2A99200C13D91, 0x0001059400011D93, 0x0001059600010D95, 0x0001059800013D97, 0x0001059A00010D99, 0x0001059C00011D9B, 0x0001059E00010D9D, 
0x000101A000C1019F, 0x000101A2000101A1, 0x000101A4000101A3, 0x000101A6000101A5, 0x000101A8000101A7, 0x000101AA000101A9, 0x000101AC000101AB, 0x000101AE000101AD, 
0x000101B0000101AF, 0x000101B2000101B1, 0x000101B4000101B3, 0x000101B6000101B5, 0x000101B8000101B7, 0x000101BA000101B9, 0x000101BC000101BB, 0x00C105BE000101BD, 
0x8000EBB800C101BF, 0x80002A828000394B, 0x800039678000395B, 0x800039778000396F, 0x8000EBBD80002A86, 0x800039B3800039A7, 0x80002A8E80002A8A, 0x8000EBC2800039B7, 
0x8000EBC780002A92, 0x8000EBD18000EBCC, 0x800039F780002A96, 0x80003A03800039FB, 0x8000EBDB80003A0B, 0x000000DA000000D9, 0x000000DC000000DB, 0x000000DE000000DD, 
0x000000E0000000DF, 0x00FAF59C000000E1, 0x0000C99A0000ED9D, 0x0000C9980000C99B, 0x0000ED960000C999, 0x0000E19400FACD97, 0x0000F19200FAF595, 0x000081900000F193, 
0x0000F18E00008191, 0x0000E18C0000F18F, 0x00C3D18A0000E18D, 0x0000C5880000F18B, 0x0000F5860000FD89, 0x0000E5840000FD87, 0x0000F5820000FD85, 0x000205800000FD83, 
0x000000800000FD81, 0x0000008200000081, 0x0000008400000083, 0x0000008600000085, 0x0000008800000087, 0x0000008A00000089, 0x0000008C0000008B, 0x0000008E0000008D, 
0x000000900000008F, 0x0000009200000091, 0x0000009400000093, 0x0000009600000095, 0x0000009800000097, 0x0000009A00000099, 0x0000009C0000009B, 0x0000009E0000009D, 
0x000000A00000009F, 0x000000A2000000A1, 0x000000A4000000A3, 0x000000A6000000A5, 0x000000A8000000A7, 0x000000AA000000A9, 0x000000AC000000AB, 0x000000AE000000AD, 
0x000000B0000000AF, 0x000000B2000000B1, 0x000000B4000000B3, 0x000000B6000000B5, 0x000000B8000000B7, 0x000000BA800036C3, 0x000000BC000000BB, 0x000000BE000000BD, 
0xCC200020000000BF, 0xCC200083CC200081, 0xCC200085CC200084, 0xCC200087CC200086, 0x0080CC88CC200088, 0xCC200081CC88CC20, 0x008ACC200082CD88, 0x0093CC20008BCC20, 
0xCC200080CC93CC20, 0xCD93CC200081CC93, 0xCC200094CC200082, 0xCC94CC200080CC94, 0x0082CD94CC200081, 0x00A8CC2000A7CC20, 0x0082CD2000B3CC20, 0x008BD9200085CD20, 
0xD98CD920008CD920, 0xD920008DD9200091, 0x008ED9200091D98D, 0xD9200091D98ED920, 0x0091D98FD920008F, 0xD990D9200090D920, 0xD9200091D9200091, 0x0092D92000B0D991, 
0x82E320009982E320, 0x210021210021009A, 0x002400230022003F, 0x0028002700260025, 0x2930312800293128, 0x3128002931312800, 0x0029333128002932, 0x3531280029343128, 
0x2800293631280029, 0x2938312800293731, 0x3228002939312800, 0x2800293032280029, 0x2800293428002933, 0x2800293628002935, 0x2800293828002937, 0x2800294128002939, 
0x2800294328002942, 0x2800294528002944, 0x2800294728002946, 0x2800294928002948, 0x2800294B2800294A, 0x2800294D2800294C, 0x2800294F2800294E, 0x2800295128002950, 
0x2800295328002952, 0x2800295528002954, 0x2800295728002956, 0x2800295928002958, 0x280029612800295A, 0x2800296328002962, 0x2800296528002964, 0x2800296728002966, 
0x2800296928002968, 0x2800296B2800296A, 0x2800296D2800296C, 0x2800296F2800296E, 0x2800297128002970, 0x2800297328002972, 0x2800297528002974, 0x2800297728002976, 
0x2800297928002978, 0x298084E12800297A, 0x2800298284E12800, 0x84E12800298384E1, 0x298684E128002985, 0x2800298784E12800, 0x84E12800298984E1, 0x298C84E12800298B, 
0x2800298E84E12800, 0x84E12800298F84E1, 0x299184E128002990, 0x2800299284E12800, 0xB8E428002980B8E4, 0x2989B8E428002983, 0x2800299DB9E42800, 0xBAE42800298CBAE4, 
0x29A3BBE428002994, 0x28002981BCE42800, 0x85E528002991BCE4, 0x29AD85E5280029AB, 0x280029B48AE52800, 0x8DE5280029818DE5, 0x298D90E528002994, 0x280029BC91E52800, 
0x9CE52800299B9BE5, 0x29A6ADE52800299F, 0x280029A597E62800, 0x9CE6280029889CE6, 0x29A89CE628002989, 0x280029AAA0E62800, 0x81E7280029B4B0E6, 0x29B989E7280029AB, 
0x280029A39BE72800, 0xA5E7280029BEA4E7, 0x29ADA5E72800299D, 0x280029AA87E82800, 0xB2E8280029B387E8, 0x2987B3E8280029A1, 0x2800299187E92800, 0x82EB28002980B0EA, 
0x29A48BEB28002998, 0x280029BC9DEB2800, 0xB0EB28002988A7EB, 0x29AC82EC28002994, 0x2800298495EC2800, 0x002984A0ECA498EC, 0x29849BEDA498EC28, 0x280029909EEC2800, 
0xB0EC280029BCA3EC, 0x29B4B9EC280029A8, 0x2800298083ED2800, 0x95ED2800298C8CED, 0x2B002A0029002998, 0x2E002E002D002C00, 0x002F002E2E2E002E, 0x002E30002C300030, 
0xE73000338481E230, 0x002C31003100B982, 0x3031003031002E31, 0x00A597E63031002E, 0x303100889CE63031, 0x3100313100B982E7, 0xA597E63131002E31, 0x3100889CE6313100, 
0x00323100B982E731, 0x97E63231002E3231, 0x00889CE6323100A5, 0x333100B982E73231, 0xE63331002E333100, 0xB982E7333100A597, 0x002E343100343100, 0x343100A597E63431, 
0x3100353100B982E7, 0xA597E63531002E35, 0x3100B982E7353100, 0x3631002E36310036, 0x82E7363100A597E6, 0x2E373100373100B9, 0x3100A597E6373100, 0x00383100B982E737, 
0x97E63831002E3831, 0x00B982E7383100A5, 0x31002E3931003931, 0xE7393100A597E639, 0x008481E23100B982, 0x310030318481E231, 0x81E23100328481E2, 0x348481E231003384, 
0x3100358481E23100, 0x81E23100368481E2, 0x388481E231003784, 0x3100398481E23100, 0x889CE63100A597E6, 0x003200B982E73100, 0x3032002E32002C32, 0xE63032002E303200, 
0xB982E7303200A597, 0x97E6313200313200, 0x00B982E7313200A5, 0xA597E63232003232, 0x3200B982E7323200, 0x00A597E633320033, 0x343200B982E73332, 0x3200A597E6343200, 
0x00353200B982E734, 0x363200A597E63532, 0x3200A597E6363200, 0x00A597E637320037, 0xA597E63832003832, 0x97E6393200393200, 0x00338481E23200A5, 0xE63200358481E232, 
0x00889CE63200A597, 0x33003300B982E732, 0x003033002E33002C, 0x313300A597E63033, 0x3300A597E6313300, 0x0034330033330032, 0x3733003633003533, 0x3300393300383300, 
0x81E23300348481E2, 0x388481E233003584, 0xE63300A597E63300, 0x00B982E73300889C, 0x002E34002C340034, 0x3234003134003034, 0x3400343400333400, 0x0037340036340035, 
0xE234003934003834, 0xA597E63400358481, 0xE73400889CE63400, 0x002C35003500B982, 0xE235003035002E35, 0x8481E23500368481, 0x3500A597E6350038, 0xB982E73500889CE6, 
0x2E36002C36003600, 0xE63600A597E63600, 0x00B982E73600889C, 0x002E37002C370037, 0xE63700388481E237, 0x00889CE63700A597, 0x38003800B982E737, 0x97E638002E38002C, 
0x3800889CE63800A5, 0x2C39003900B982E7, 0xA597E639002E3900, 0xE73900889CE63900, 0x3D3A3A003A00B982, 0x3D003D003C003B00, 0x003E003D3D3D003D, 0x003F3F00213F003F, 
0x4100554100410040, 0x420042006D9588E2, 0x4300444300430071, 0x6B9588E243002E6F, 0x44004A4400440067, 0xBDC544007A44005A, 0x46004500BEC54400, 0x4700470058414600, 
0x5047007A48470042, 0x4800480079470061, 0x0067480056480050, 0x0049490049007A48, 0x49004A4900494949, 0x0058490056490055, 0x4B00424B004B004A, 0x4C004C004D4B004B, 
0x6A4C0044544C004A, 0x4D004D00B7C24C00, 0x00444D00434D0042, 0x0061504D007A484D, 0xCE4D00574D00564D, 0x4E004A4E004E00A9, 0x50004F006F4E006A, 0x004D505000485000, 
0x5000525000565050, 0x0051006150004554, 0x5300530073520052, 0x005353004D530044, 0x4C45540054007653, 0x004D54007A485400, 0x5600495600560055, 0x0049494956004949, 
0x0057006D9588E256, 0x6257005A57004357, 0x4958004958005800, 0x005B005A00590049, 0x005F005E005D005C, 0x2E6D2E6100610060, 0x732F6100632F6100, 0x62006200BECA6100, 
0x6F2F630063007261, 0x6C616300752F6300, 0x6300646300636300, 0x6D6300326D63006D, 0x6400426400640033, 0x006D64006C640061, 0x00336D6400326D64, 0x6500BEC564007A64, 
0x0067726500566500, 0x6966660066660066, 0x006966006C666600, 0x0067006D66006C66, 0x50680068006C6167, 0x6900690061680061, 0x6A69006969690069, 0x69007669006E6900, 
0x416B006B006A0078, 0x61506B007A486B00, 0x6B00576B00566B00, 0x6B00676B006C6163, 0x326D6B006D6B006C, 0x00746B00336D6B00, 0x6A6C006C00A9CE6B, 0x6C006E6C006D6C00, 
0xC26C00786C00676F, 0x6D00326D006D00B7, 0x00566D00416D0033, 0x676D00626D00576D, 0x006C6D006C696D00, 0x6D00326D6D006D6D, 0x6D006C6F6D00336D, 0x00739588E26D0073, 
0x6E0032739588E26D, 0x6E00466E00416E00, 0x006A6E00576E0056, 0x006F00736E006D6E, 0x6D2E70007000566F, 0x004670004170002E, 0x6370005770005670, 0x0072007100737000, 
0xE264617200646172, 0xE264617200739588, 0x7300730032739588, 0x7500740074730072, 0x6976006976007600, 0x7700696969760069, 0x6978006978007800, 0x007B007A00790069, 
0xA2C2007E007D007C, 0xC200A5C200A3C200, 0x43B0C200ACC200A6, 0x00B7C20046B0C200, 0x82C30081C30080C3, 0xC30084C30083C300, 0x0087C30086C30085, 0x8AC30089C30088C3, 
0xC3008CC3008BC300, 0x008FC3008EC3008D, 0x93C30092C30091C3, 0xC30095C30094C300, 0x009AC30099C30096, 0x9DC3009CC3009BC3, 0xC300A1C300A0C300, 0x00A4C300A3C300A2, 
0xA8C300A7C300A5C3, 0xC300AAC300A9C300, 0x00ADC300ACC300AB, 0xB0C300AFC300AEC3, 0xC300B2C300B1C300, 0x00B5C300B4C300B3, 0xBAC300B9C300B6C3, 0xC300BCC300BBC300, 
0x0080C400BFC300BD, 0x83C40082C40081C4, 0xC40085C40084C400, 0x0088C40087C40086, 0x8BC4008AC40089C4, 0xC4008DC4008CC400, 0x0092C4008FC4008E, 0x95C40094C40093C4, 
0xC40097C40096C400, 0x009AC40099C40098, 0x9DC4009CC4009BC4, 0xC4009FC4009EC400, 0x00A2C400A1C400A0, 0xA5C400A4C400A3C4, 0xC400A7C400A6C400, 0x00AAC400A9C400A8, 
0xADC400ACC400ABC4, 0xC400AFC400AEC400, 0x00B4C400B1C400B0, 0xB7C400B6C400B5C4, 0xC400BAC400B9C400, 0x00BDC400BCC400BB, 0x84C50083C500BEC4, 0xC50086C50085C500, 
0x008BC50088C50087, 0x8EC5008DC5008CC5, 0xC50090C5008FC500, 0x0094C50093C50091, 0x97C50096C50095C5, 0xC50099C50098C500, 0x009CC5009BC5009A, 0x9FC5009EC5009DC5, 
0xC500A1C500A0C500, 0x00A4C500A3C500A2, 0xA9C500A8C500A5C5, 0xC500ABC500AAC500, 0x00AEC500ADC500AC, 0xB1C500B0C500AFC5, 0xC500B3C500B2C500, 0x00B6C500B5C500B4, 
0xB9C500B8C500B7C5, 0xC500BBC500BAC500, 0x00BEC500BDC500BC, 0xA0C60090C6008EC6, 0xC600ABC600A1C600, 0x008DC700B0C600AF, 0x90C7008FC7008EC7, 0xC70092C70091C700, 
0x0095C70094C70093, 0x98C70097C70096C7, 0xC7009AC70099C700, 0x009EC7009CC7009B, 0xA1C700A0C7009FC7, 0xC700A3C700A2C700, 0x00A8C700A7C700A6, 0xABC700AAC700A9C7, 
0xC700ADC700ACC700, 0x00B0C700AFC700AE, 0xB8C700B5C700B4C7, 0xC700BAC700B9C700, 0x00BDC700BCC700BB, 0x80C800BFC700BEC7, 0xC80082C80081C800, 0x0085C80084C80083, 
0x88C80087C80086C8, 0xC8008AC80089C800, 0x008DC8008CC8008B, 0x90C8008FC8008EC8, 0xC80092C80091C800, 0x0095C80094C80093, 0x98C80097C80096C8, 0xC8009AC80099C800, 
0x009FC8009EC8009B, 0xA7C800A6C800A2C8, 0xC800A9C800A8C800, 0x00ACC800ABC800AA, 0xAFC800AEC800ADC8, 0xC800B1C800B0C800, 0x00B7C800B3C800B2, 0x92C90091C90090C9, 
0xC90095C90094C900, 0x009CC9009BC90099, 0xA3C900A1C9009FC9, 0xC900A6C900A5C900, 0x00AAC900A9C900A8, 0xAFC900ADC900ABC9, 0xC900B1C900B0C900, 0x00B4C900B3C900B2, 
0xB9C900B8C900B5C9, 0xCA0081CA00BBC900, 0x0089CA0083CA0082, 0x8CCA008BCA008ACA, 0xCA0091CA0090CA00, 0x009DCA0095CA0092, 0xBCCA00B9CA009FCA, 0x0081CC0080CC006E, 
0x0093CC0081CC88CC, 0x89CE0088CE0086CE, 0xCE008CCE008ACE00, 0x0090CE008FCE008E, 0x93CE0092CE0091CE, 0xCE0095CE0094CE00, 0x0098CE0097CE0096, 0x9BCE009ACE0099CE, 
0xCE009DCE009CCE00, 0x00A0CE009FCE009E, 0xA4CE00A3CE00A1CE, 0xCE00A6CE00A5CE00, 0x00A9CE00A8CE00A7, 0xACCE00ABCE00AACE, 0xCE00AECE00ADCE00, 0x00B1CE00B0CE00AF, 
0xB4CE00B3CE00B2CE, 0xCE00B6CE00B5CE00, 0x00B9CE00B8CE00B7, 0xBCCE00BBCE00BACE, 0x46BCCE0041BCCE00, 0x57BCCE0056BCCE00, 0x6CBCCE0067BCCE00, 0x73BCCE006DBCCE00, 
0xCE00BECE00BDCE00, 0x0081CF0080CF00BF, 0x84CF0083CF0082CF, 0xCF0086CF0085CF00, 0x0089CF0088CF0087, 0x8CCF008BCF008ACF, 0xCF008ECF008DCF00, 0x0080D0009DCF009C, 
0x87D00083D00081D0, 0xD0008DD0008CD000, 0x00B9D00099D0008E, 0x8CD1008AD100BDD0, 0xD10091D10090D100, 0x009CD10097D10093, 0xB6D1009ED1009DD1, 0xD30081D300B7D100, 
0x0091D30090D30082, 0x96D30093D30092D3, 0xD3009AD30097D300, 0x009DD3009CD3009B, 0xA2D3009FD3009ED3, 0xD300A4D300A3D300, 0x00A7D300A6D300A5, 0xACD300ABD300AAD3, 
0xD300AED300ADD300, 0x00B1D300B0D300AF, 0xB4D300B3D300B2D3, 0xD300B8D300B5D300, 0xD50082D6A5D500B9, 0xABD5B4D500A5D5B4, 0xB4D500ADD5B4D500, 0x00B6D5BED500B6D5, 
0x00B7D690D70090D7, 0xD690D700B8D690D7, 0xD7009CD790D700BC, 0xD700BCD691D70091, 0xD70092D700BFD691, 0xD70093D700BCD692, 0xD70094D700BCD693, 0xB9D695D700BCD694, 
0x96D700BCD695D700, 0x00BCD698D700BCD6, 0xD699D700B4D699D7, 0xD700BCD69AD700BC, 0xD700BCD69BD7009B, 0xD7009CD700BFD69B, 0xD7009DD700BCD69C, 0xBCD6A0D700BCD69E, 
0xA2D700BCD6A1D700, 0xA4D700BCD6A3D700, 0x00BFD6A4D700BCD6, 0xD6A7D700BCD6A6D7, 0xD6A8D700A8D700BC, 0xD700BCD6A9D700BC, 0xA9D70081D7BCD6A9, 0xD7A9D70082D7BCD6, 
0xD70082D7A9D70081, 0xD700BCD6AAD700AA, 0xD800A1D800B7D6B2, 0x00A4D800A3D800A2, 0xA6D800A6D800A5D8, 0x00ACD8A6D800A7D8, 0xD8A6D800ADD8A6D8, 0xD800B1D8A6D800AE, 
0x85D9A6D800B2D8A6, 0xA6D80086D9A6D800, 0x0088D9A6D80087D9, 0xD9A6D80089D9A6D8, 0xD80086DBA6D8008A, 0x88DBA6D80087DBA6, 0xA6D80090DBA6D800, 0xA7D800A7D80095DB, 
0xD800B1D8A8D883D9, 0x0087D984D984D9A7, 0xD9A7D8008BD9A7D8, 0xD8A8D800A8D800B4, 0xD800ADD8A8D800AC, 0xA8D8008AD9ADD8A8, 0xD9AED8A8D800AED8, 0xD800B1D8A8D8008A, 
0x85D9A8D800B2D8A8, 0xA8D80086D9A8D800, 0x0089D9A8D80087D9, 0x00A9D8008AD9A8D8, 0x00ACD8AAD800AAD8, 0xD80085D9ACD8AAD8, 0xAAD80089D9ACD8AA, 0xD8AAD8008AD9ACD8, 
0xACD8ADD8AAD800AD, 0x0085D9ADD8AAD800, 0xD8AAD800AED8AAD8, 0xAED8AAD80085D9AE, 0xD9AED8AAD80089D9, 0xD800B1D8AAD8008A, 0x85D9AAD800B2D8AA, 0x00ACD885D9AAD800, 
0xD800ADD885D9AAD8, 0xAAD800AED885D9AA, 0xD9AAD80089D985D9, 0x86D9AAD8008AD985, 0xAAD80087D9AAD800, 0x008AD9AAD80089D9, 0x00ACD8ABD800ABD8, 0xD8ABD800B1D8ABD8, 
0xD80085D9ABD800B2, 0x87D9ABD80086D9AB, 0xABD80089D9ABD800, 0xACD800ACD8008AD9, 0xD9ADD8ACD800ADD8, 0x8AD9ADD8ACD80089, 0xACD82084D9ACD800, 0x87D984D9A7D884D9, 
0xACD80085D9ACD800, 0xD9ACD800ADD885D9, 0x85D9ACD80089D985, 0x0089D9ACD8008AD9, 0x00ADD8008AD9ACD8, 0xD8ADD800ACD8ADD8, 0x85D9ADD8008AD9AC, 0x0089D985D9ADD800, 
0xD8008AD985D9ADD8, 0x8AD9ADD80089D9AD, 0xACD8AED800AED800, 0xAED800ADD8AED800, 0x0089D9AED80085D9, 0x00AFD8008AD9AED8, 0x00B0D9B0D800B0D8, 0xD9B3D8B1D800B1D8, 
0xB0D9B1D80084D988, 0xD9A7D88CDBB1D800, 0x00B3D800B2D80084, 0xD8B3D800ACD8B3D8, 0xACD8B3D800ADD8AC, 0x00ADD8B3D80089D9, 0xD800ACD8ADD8B3D8, 0xAED8B3D800AED8B3, 
0xD9AED8B3D80089D9, 0xD800B1D8B3D8008A, 0x85D9B3D80085D9B3, 0xD885D9B3D800ACD8, 0x85D985D9B3D800AD, 0xB3D80087D9B3D800, 0x008AD9B3D80089D9, 0x00ACD8B4D800B4D8, 
0xD8008AD9ACD8B4D8, 0xADD8B4D800ADD8B4, 0xD9ADD8B4D80085D9, 0xD800AED8B4D8008A, 0x85D9B4D800B1D8B4, 0x00AED885D9B4D800, 0xD80085D985D9B4D8, 0x89D9B4D80087D9B4, 
0xB5D8008AD9B4D800, 0xB5D800ADD8B5D800, 0xD8B5D800ADD8ADD8, 0xAED8B5D8008AD9AD, 0xB5D800B1D8B5D800, 0xD80085D9B9D884D9, 0xB5D80089D984D9B5, 0xD9A7D82089D984D9, 
0xB9D82087D984D984, 0xD92087D98AD984D9, 0x0085D984D9B3D888, 0xD80092DB84D9B5D8, 0x85D9B5D80085D9B5, 0x0089D9B5D80085D9, 0x00B6D8008AD9B5D8, 0xD8B6D800ACD8B6D8, 
0x89D9ADD8B6D800AD, 0x008AD9ADD8B6D800, 0xD8B6D800AED8B6D8, 0xB1D8B6D80085D9AE, 0xB6D80085D9B6D800, 0x008AD9B6D80089D9, 0x00ADD8B7D800B7D8, 0xD9B7D80085D9B7D8, 
0x85D9B7D800ADD885, 0xD985D9B7D80085D9, 0xD80089D9B7D8008A, 0xD800B8D8008AD9B7, 0xD800B9D80085D9B8, 0xACD8B9D800ACD8B9, 0xD984D9B9D80085D9, 0x85D9B9D80087D98A, 
0x0085D985D9B9D800, 0xD80089D985D9B9D8, 0xB9D8008AD985D9B9, 0x008AD9B9D80089D9, 0x00ACD8BAD800BAD8, 0xD9BAD80085D9BAD8, 0x85D9BAD80085D985, 0xD985D9BAD80089D9, 
0xD80089D9BAD8008A, 0x8BD980D9008AD9BA, 0x80D9008ED980D900, 0xD980D90091D98ED9, 0x91D98FD980D9008F, 0x80D90090D980D900, 0xD980D90091D990D9, 0xD90092D980D90091, 
0xD900ACD881D90081, 0xAED881D900ADD881, 0x0085D9AED881D900, 0xD981D90085D981D9, 0x89D981D9008AD985, 0x82D9008AD981D900, 0x82D900ADD882D900, 0xD982D90092DB84D9, 
0xADD885D982D90085, 0x0085D985D982D900, 0xD9008AD985D982D9, 0x8AD982D90089D982, 0xA7D883D90083D900, 0x83D900ACD883D900, 0x00AED883D900ADD8, 0xD983D90084D983D9, 
0x85D985D983D90085, 0x008AD985D983D900, 0xD983D90089D983D9, 0xD884D90084D9008A, 0xD900A3D884D900A2, 0xA7D884D900A5D884, 0x84D900ACD884D900, 0xD884D900ACD8ACD8, 
0xACD884D90085D9AC, 0x00ADD884D9008AD9, 0xD90085D9ADD884D9, 0x84D90089D9ADD884, 0xD884D9008AD9ADD8, 0x85D9AED884D900AE, 0x84D90085D984D900, 0xD984D900ADD885D9, 
0x87D984D9008AD985, 0x84D90089D984D900, 0x85D90085D9008AD9, 0x00ACD885D900A7D8, 0xD900ADD8ACD885D9, 0x85D900AED8ACD885, 0xD885D90085D9ACD8, 0xADD885D9008AD9AC, 
0x00ACD8ADD885D900, 0xD90085D9ADD885D9, 0x00AFD885D9ADD885, 0xD9008AD9ADD885D9, 0xAED885D900AED885, 0xD9AED885D900ACD8, 0x8AD9AED885D90085, 0x85D90085D985D900, 
0xD985D9008AD985D9, 0xD9008AD985D90089, 0xD900ACD886D90086, 0x86D900ADD8ACD886, 0xD886D90085D9ACD8, 0xACD886D90089D9AC, 0x00ADD886D9008AD9, 0xD90085D9ADD886D9, 
0x86D90089D9ADD886, 0xD886D9008AD9ADD8, 0xD900B1D886D900AE, 0x85D986D900B2D886, 0x0089D985D986D900, 0xD9008AD985D986D9, 0x87D986D90086D986, 0x86D90089D986D900, 
0x87D90087D9008AD9, 0x0085D987D900ACD8, 0xD900ACD885D987D9, 0x87D90085D985D987, 0x008AD987D90089D9, 0x0088D900B0D987D9, 0x85D984D9B3D888D9, 0x89D900B4D988D900, 
0x8AD900B0D989D900, 0x8AD900ACD88AD900, 0xD88AD9008AD9ACD8, 0x8AD9ADD88AD900AD, 0x8AD900AED88AD900, 0x00B2D88AD900B1D8, 0xD98AD90085D98AD9, 0x85D98AD90085D985, 
0x0086D98AD9008AD9, 0xD98AD90087D98AD9, 0xD9008AD98AD90089, 0xD900AED900B4D98A, 0x00B9D900B1D900AF, 0xBED900BBD900BAD9, 0xDA0080DA00BFD900, 0x0086DA0084DA0083, 
0x8CDA0088DA0087DA, 0xDA008EDA008DDA00, 0x00A1DA0098DA0091, 0xA9DA00A6DA00A4DA, 0xDA00AFDA00ADDA00, 0x00BADA00B3DA00B1, 0x80DB00BEDA00BBDA, 0xDB0082DB0081DB00, 
0x0087DB0086DB0085, 0x0088DB00B4D987DB, 0x8CDB008BDB0089DB, 0xDB0092DB0090DB00, 0xBCA4E095A4E00093, 0x00BCA4E096A4E000, 0xE000BCA4E097A4E0, 0xA4E000BCA4E09CA4, 
0xA2A4E000BCA4E0A1, 0x00A9A4E000BCA4E0, 0xE000BCA4E0ABA4E0, 0xA4E000BCA4E0AFA4, 0xA6E000B4A4E000B1, 0xA2A6E000BCA6E0A1, 0xE0AFA6E000BCA6E0, 0xE0008BA7E000BCA6, 
0xA8E096A8E0008CA7, 0xBCA8E097A8E000BC, 0x00BCA8E09CA8E000, 0xE000BCA8E0ABA8E0, 0xA8E000BCA8E0B2A8, 0xA1ACE000BCA8E0B8, 0xE0A2ACE000BCACE0, 0xE00088ADE000BCAC, 
0xE0008CADE0008BAD, 0xE0008AAFE00094AE, 0xE0008CAFE0008BAF, 0xE00080B3E00088B1, 0xE00088B3E00087B3, 0xE0008BB3E0008AB3, 0xE0008BB5E0008AB5, 0xE0009AB7E0008CB5, 
0xE0009DB7E0009CB7, 0xB8E08DB9E0009EB7, 0x99BAE0ABBAE000B2, 0x00A1BAE0ABBAE000, 0xE000B2BAE08DBBE0, 0xBEE080BDE0008BBC, 0xB7BEE082BDE000B5, 0x00B7BEE08CBDE000, 
0xE000B7BEE091BDE0, 0xBDE000B7BEE096BD, 0xB1BDE000B7BEE09B, 0xE0B1BDE000B2BDE0, 0xBEE0B1BDE000B4BD, 0xB5BEE090BEE00080, 0x00B7BEE092BEE000, 0xE000B7BEE09CBEE0, 
0xBEE000B7BEE0A1BE, 0xABBEE000B7BEE0A6, 0xE0B2BEE000B7BEE0, 0xBEE00080BEE0B1BD, 0xB3BEE00080BEE0B2, 0xE00080BEE0B1BDE0, 0x80E10080BEE0B3BE, 0x84E1009C83E100A6, 
0x84E1008184E10080, 0x84E1008384E10082, 0x84E1008584E10084, 0x84E1008784E10086, 0x84E1008984E10088, 0x84E1008B84E1008A, 0x84E1008D84E1008C, 0x84E1008F84E1008E, 
0x84E1009184E10090, 0x84E1009484E10092, 0x84E1009A84E10095, 0x84E1009D84E1009C, 0x84E100A084E1009E, 0x84E100A284E100A1, 0x84E100A784E100A3, 0x84E100AB84E100A9, 
0x84E100AD84E100AC, 0x84E100AF84E100AE, 0x85E100B684E100B2, 0x85E1008785E10080, 0x85E1009785E1008C, 0x85E1009985E10098, 0x85E100A185E100A0, 0x85E100A385E100A2, 
0x85E100A585E100A4, 0x85E100A785E100A6, 0x85E100A985E100A8, 0x85E100AB85E100AA, 0x85E100AD85E100AC, 0x85E100AF85E100AE, 0x85E100B185E100B0, 0x85E100B385E100B2, 
0x86E100B585E100B4, 0x86E1008586E10084, 0x86E1009186E10088, 0x86E1009486E10092, 0x86E100A186E1009E, 0x86E100AC86E100AA, 0x86E100B086E100AD, 0x86E100B286E100B1, 
0x86E100B486E100B3, 0x87E1008787E100B5, 0x87E1008C87E10088, 0x87E1009387E1008E, 0x87E1009987E10097, 0x87E1009F87E1009D, 0xACE100B287E100B1, 0xACE10088ACE10086, 
0xACE1008CACE1008A, 0xACE10092ACE1008E, 0xADE100BDACE100BB, 0xADE10081ADE10080, 0xB4E10082B4E10083, 0xB4E10097B4E10096, 0xB4E1009DB4E1009C, 0xB6E100BBB5E100A5, 
0xB8E10080B8E10085, 0xB8E10082B8E10081, 0xB8E10084B8E10083, 0xB8E10086B8E10085, 0xB8E10088B8E10087, 0xB8E1008AB8E10089, 0xB8E1008CB8E1008B, 0xB8E1008EB8E1008D, 
0xB8E10090B8E1008F, 0xB8E10092B8E10091, 0xB8E10094B8E10093, 0xB8E10096B8E10095, 0xB8E10098B8E10097, 0xB8E1009AB8E10099, 0xB8E1009CB8E1009B, 0xB8E1009EB8E1009D, 
0xB8E100A0B8E1009F, 0xB8E100A2B8E100A1, 0xB8E100A4B8E100A3, 0xB8E100A6B8E100A5, 0xB8E100A8B8E100A7, 0xB8E100AAB8E100A9, 0xB8E100ACB8E100AB, 0xB8E100AEB8E100AD, 
0xB8E100B0B8E100AF, 0xB8E100B2B8E100B1, 0xB8E100B4B8E100B3, 0xB8E100B6B8E100B5, 0xB8E100B8B8E100B7, 0xB8E100BAB8E100B9, 0xB8E100BCB8E100BB, 0xB8E100BEB8E100BD, 
0xB9E10080B9E100BF, 0xB9E10082B9E10081, 0xB9E10084B9E10083, 0xB9E10086B9E10085, 0xB9E10088B9E10087, 0xB9E1008AB9E10089, 0xB9E1008CB9E1008B, 0xB9E1008EB9E1008D, 
0xB9E10090B9E1008F, 0xB9E10092B9E10091, 0xB9E10094B9E10093, 0xB9E10096B9E10095, 0xB9E10098B9E10097, 0xB9E1009AB9E10099, 0xB9E1009CB9E1009B, 0xB9E1009EB9E1009D, 
0xB9E100A0B9E1009F, 0xB9E100A2B9E100A1, 0xB9E100A4B9E100A3, 0xB9E100A6B9E100A5, 0xB9E100A8B9E100A7, 0xB9E100AAB9E100A9, 0xB9E100ACB9E100AB, 0xB9E100AEB9E100AD, 
0xB9E100B0B9E100AF, 0xB9E100B2B9E100B1, 0xB9E100B4B9E100B3, 0xB9E100B6B9E100B5, 0xB9E100B8B9E100B7, 0xB9E100BAB9E100B9, 0xB9E100BCB9E100BB, 0xB9E100BEB9E100BD, 
0xBAE10080BAE100BF, 0xBAE10082BAE10081, 0xBAE10084BAE10083, 0xBAE10086BAE10085, 0xBAE10088BAE10087, 0xBAE1008ABAE10089, 0xBAE1008CBAE1008B, 0xBAE1008EBAE1008D, 
0xBAE10090BAE1008F, 0xBAE10092BAE10091, 0xBAE10094BAE10093, 0xBAE10096BAE10095, 0xBAE10098BAE10097, 0xBAE100A0BAE10099, 0xBAE100A2BAE100A1, 0xBAE100A4BAE100A3, 
0xBAE100A6BAE100A5, 0xBAE100A8BAE100A7, 0xBAE100AABAE100A9, 0xBAE100ACBAE100AB, 0xBAE100AEBAE100AD, 0xBAE100B0BAE100AF, 0xBAE100B2BAE100B1, 0xBAE100B4BAE100B3, 
0xBAE100B6BAE100B5, 0xBAE100B8BAE100B7, 0xBAE100BABAE100B9, 0xBAE100BCBAE100BB, 0xBAE100BEBAE100BD, 0xBBE10080BBE100BF, 0xBBE10082BBE10081, 0xBBE10084BBE10083, 
0xBBE10086BBE10085, 0xBBE10088BBE10087, 0xBBE1008ABBE10089, 0xBBE1008CBBE1008B, 0xBBE1008EBBE1008D, 0xBBE10090BBE1008F, 0xBBE10092BBE10091, 0xBBE10094BBE10093, 
0xBBE10096BBE10095, 0xBBE10098BBE10097, 0xBBE1009ABBE10099, 0xBBE1009CBBE1009B, 0xBBE1009EBBE1009D, 0xBBE100A0BBE1009F, 0xBBE100A2BBE100A1, 0xBBE100A4BBE100A3, 
0xBBE100A6BBE100A5, 0xBBE100A8BBE100A7, 0xBBE100AABBE100A9, 0xBBE100ACBBE100AB, 0xBBE100AEBBE100AD, 0xBBE100B0BBE100AF, 0xBBE100B2BBE100B1, 0xBBE100B4BBE100B3, 
0xBBE100B6BBE100B5, 0xBBE100B8BBE100B7, 0xBCE10080BCE100B9, 0xBCE10082BCE10081, 0xBCE10084BCE10083, 0xBCE10086BCE10085, 0xBCE10088BCE10087, 0xBCE1008ABCE10089, 
0xBCE1008CBCE1008B, 0xBCE1008EBCE1008D, 0xBCE10090BCE1008F, 0xBCE10092BCE10091, 0xBCE10094BCE10093, 0xBCE10098BCE10095, 0xBCE1009ABCE10099, 0xBCE1009CBCE1009B, 
0xBCE100A0BCE1009D, 0xBCE100A2BCE100A1, 0xBCE100A4BCE100A3, 0xBCE100A6BCE100A5, 0xBCE100A8BCE100A7, 0xBCE100AABCE100A9, 0xBCE100ACBCE100AB, 0xBCE100AEBCE100AD, 
0xBCE100B0BCE100AF, 0xBCE100B2BCE100B1, 0xBCE100B4BCE100B3, 0xBCE100B6BCE100B5, 0xBCE100B8BCE100B7, 0xBCE100BABCE100B9, 0xBCE100BCBCE100BB, 0xBCE100BEBCE100BD, 
0xBDE10080BDE100BF, 0xBDE10082BDE10081, 0xBDE10084BDE10083, 0xBDE10088BDE10085, 0xBDE1008ABDE10089, 0xBDE1008CBDE1008B, 0xBDE10090BDE1008D, 0xBDE10092BDE10091, 
0xBDE10094BDE10093, 0xBDE10096BDE10095, 0xBDE10099BDE10097, 0xBDE1009DBDE1009B, 0xBDE100A0BDE1009F, 0xBDE100A2BDE100A1, 0xBDE100A4BDE100A3, 0xBDE100A6BDE100A5, 
0xBDE100A8BDE100A7, 0xBDE100AABDE100A9, 0xBDE100ACBDE100AB, 0xBDE100AEBDE100AD, 0xBDE100B0BDE100AF, 0xBDE100B4BDE100B2, 0xBDE100B8BDE100B6, 0xBEE100BCBDE100BA, 
0xBEE10081BEE10080, 0xBEE10083BEE10082, 0xBEE10085BEE10084, 0xBEE10087BEE10086, 0xBEE10089BEE10088, 0xBEE1008BBEE1008A, 0xBEE1008DBEE1008C, 0xBEE1008FBEE1008E, 
0xBEE10091BEE10090, 0xBEE10093BEE10092, 0xBEE10095BEE10094, 0xBEE10097BEE10096, 0xBEE10099BEE10098, 0xBEE1009BBEE1009A, 0xBEE1009DBEE1009C, 0xBEE1009FBEE1009E, 
0xBEE100A1BEE100A0, 0xBEE100A3BEE100A2, 0xBEE100A5BEE100A4, 0xBEE100A7BEE100A6, 0xBEE100A9BEE100A8, 0xBEE100ABBEE100AA, 0xBEE100ADBEE100AC, 0xBEE100AFBEE100AE, 
0xBEE100B1BEE100B0, 0xBEE100B3BEE100B2, 0xBEE100B6BEE100B4, 0xBEE100B8BEE100B7, 0xBEE100BABEE100B9, 0xBFE10082BFE100BC, 0xBFE10084BFE10083, 0xBFE10087BFE10086, 
0xBFE1008ABFE10088, 0xBFE10090BFE1008C, 0xBFE10092BFE10091, 0xBFE10097BFE10096, 0xBFE10099BFE10098, 0xBFE100A0BFE1009A, 0xBFE100A2BFE100A1, 0xBFE100A5BFE100A4, 
0xBFE100A7BFE100A6, 0xBFE100A9BFE100A8, 0xBFE100ACBFE100AA, 0xBFE100B3BFE100B2, 0xBFE100B6BFE100B4, 0xBFE100B8BFE100B7, 0x80E200BCBFE100BA, 0x80E2009380E20090, 
0xB280E2B280E20094, 0xE2B280E2B280E200, 0x80E2B280E200B280, 0x00B280E2B280E2B2, 0xE200B580E2B580E2, 0xB580E2B580E2B580, 0x9086E200A982E200, 0x9286E2009186E200, 
0x9A86E2009386E200, 0xAE86E2009B86E200, 0x8E87E2008D87E200, 0x8288E2008F87E200, 0x8788E2008488E200, 0x8C88E2008988E200, 0x9288E2009188E200, 0xA688E200A488E200, 
0x00AB88E2AB88E200, 0x88E2AB88E2AB88E2, 0xAB88E2AB88E200AB, 0xE200AB88E2AB88E2, 0x88E200AE88E2AE88, 0x00AE88E2AE88E2AE, 0x008489E2008189E2, 0x008989E2008789E2, 
0x00A289E200A089E2, 0x00AE89E200AD89E2, 0x00B089E200AF89E2, 0x00B489E200B189E2, 0x00B889E200B589E2, 0x00808AE200B989E2, 0x00848AE200818AE2, 0x00888AE200858AE2, 
0x00AC8AE200898AE2, 0x00AE8AE200AD8AE2, 0x00A08BE200AF8AE2, 0x00A28BE200A18BE2, 0x00AA8BE200A38BE2, 0x00AC8BE200AB8BE2, 0x008294E200AD8BE2, 0x008B97E200A096E2, 
0x0086A6E20085A6E2, 0xB5E200B8CC9DABE2, 0x80E3008180E300A1, 0x80E3008880E30082, 0x80E3008A80E30089, 0x80E3008C80E3008B, 0x80E3008E80E3008D, 0x80E3009080E3008F, 
0x80E3009280E30091, 0x80E3539480E30094, 0x89B8E49480E30095, 0xE49480E3009580E3, 0x80E3009580E38CBA, 0x009580E39D8BE594, 0x80E389AEE59480E3, 0x9389E69480E30095, 
0xE69480E3009580E3, 0x80E3009580E39795, 0x009580E3AC9CE694, 0x80E3B982E79480E3, 0x979BE79480E30095, 0x009580E3009580E3, 0x009780E3009680E3, 0x008E81E3008C81E3, 
0x009281E3009081E3, 0x009681E3009481E3, 0x009A81E3009881E3, 0x009E81E3009C81E3, 0x00A281E300A081E3, 0x00A781E300A581E3, 0x00B081E300A981E3, 0x00B381E300B181E3, 
0x00B681E300B481E3, 0x00B981E300B781E3, 0xE3BB81E300BA81E3, 0xE300BC81E3008B81, 0x82E38882E300BD81, 0x82E3009482E3008A, 0x82E3009A82E30099, 0x82E300A182E3009E, 
0x9183E3A282E300A2, 0xE3008883E3BC83E3, 0x9583E3AB83E3A282, 0xE3A282E300A182E3, 0xA282E39A83E3B383, 0xE3BC83E3A282E300, 0xE300A382E300AB83, 0x83E3A482E300A482, 
0x00B082E3B383E38B, 0x83E3B383E3A482E3, 0x82E300A582E30081, 0xA982E3A682E300A6, 0x00A782E300B383E3, 0xE3A882E300A882E3, 0xBC83E3AF82E3B982, 0xE3A882E3008983E3, 
0xBC83E3AB82E3BC83, 0xAA82E300A982E300, 0xE3B383E3AA82E300, 0x83E3AA82E300B982, 0xAB82E300A083E3BC, 0xE3A482E3AB82E300, 0x83E3AB82E300AA83, 0x008883E38383E3A9, 
0x83E3AD83E3AB82E3, 0xAC82E300BC83E3AA, 0xE3AD83E3AC82E300, 0x83E3AC82E300B383, 0xAD82E3009E83E3B3, 0xE3A583E3AD82E300, 0x82E300BC83E3AA83, 0xAD82E300AD83E3AD, 
0x83E3B082E3AD83E3, 0xAD82E300A083E3A9, 0x83E3A183E3AD83E3, 0x00AB83E38883E3BC, 0x83E3AD83E3AD82E3, 0x008883E38383E3AF, 0xE3AE82E300AE82E3, 0x83E3AE82E300AC82, 
0xAE82E300BC83E38B, 0x83E38083E3AB83E3, 0x82E300AF82E300BC, 0xE3BC82E3AB83E3AF, 0x82E300AD83E3A482, 0xE3BC83E3AD83E3AF, 0xE300B082E3008D83, 0xA083E3A983E3B082, 
0xE3A983E3B082E300, 0xB383E38883E3A083, 0xB182E300B182E300, 0xE300B982E3BC83E3, 0xE300B382E300B282, 0x82E300B382E3B382, 0xB382E3008883E3B3, 0xE3008A83E3AB83E3, 
0x9D83E3BC83E3B382, 0xB582E300B482E300, 0xE3A482E3B582E300, 0x82E300AB83E3AF82, 0xE38183E3B383E3B5, 0x82E300A083E3BC83, 0x82E300B782E300B6, 0xE3B383E3AA83E3B7, 
0xE300B882E300B082, 0xE300BA82E300B982, 0x83E3BB82E300BB82, 0xBB82E3008183E3B3, 0xE3008883E3B383E3, 0xE300BD82E300BC82, 0xE300BF82E300BE82, 0x83E38083E3008083, 
0x8183E300B982E3BC, 0x8383E3008283E300, 0x8583E3008483E300, 0x8783E3008683E300, 0x00B782E38783E300, 0xE38883E3008883E3, 0xE3008983E300B383, 0x83E300AB83E38983, 
0x8E83E38A83E3008A, 0x8C83E3008B83E300, 0x8E83E3008D83E300, 0xE38383E38E83E300, 0xE3008F83E3008883, 0x8483E3A482E38F83, 0x9083E3009083E300, 0x83E3AC83E3BC83E3, 
0x83E3009183E300AB, 0xE3BB82E3BC83E391, 0x83E3008883E3B383, 0x008483E3BC83E391, 0x009383E3009283E3, 0xE300AB83E39383E3, 0x82E39483E3009483, 0xE38883E3B982E3A2, 
0x82E39483E300AB83, 0x9483E300AB83E3AF, 0x009583E300B382E3, 0x83E3A182E39583E3, 0x008983E38383E3A9, 0x83E3A382E39583E3, 0x9583E3008883E3BC, 0xE300B383E3A983E3, 
0x83E39683E3009683, 0xE3A782E3B782E383, 0xE3009783E300AB83, 0x82E39883E3009883, 0xE3BC83E3BF82E3AF, 0x83E39883E300AB83, 0x9983E3008483E3AB, 0xE3BC83E39983E300, 
0xE3009A83E300BF82, 0x83E300BD82E39A83, 0x009283E38B83E39A, 0x82E3B383E39A83E3, 0xBC83E39A83E300B9, 0x009B83E300B882E3, 0xE300B383E39B83E3, 0xAB83E3BC83E39B83, 
0xE3BC83E39B83E300, 0xE3009C83E300B383, 0x8883E3AB83E39C83, 0x9D83E3009D83E300, 0x83E3B383E3A482E3, 0xB383E39D83E30088, 0x009E83E3008983E3, 0x82E3A482E39E83E3, 
0x9E83E300AD83E3AF, 0xE300AB83E3A482E3, 0x8F83E38383E39E83, 0xE3AB83E39E83E300, 0x83E39E83E300AF82, 0xE3A783E3B782E3B3, 0xE3009F83E300B383, 0xAD83E3AF82E39F83, 
0xE39F83E300B383E3, 0x83E39F83E300AA83, 0xE3BC83E39083E3AA, 0xE300A083E300AB83, 0x82E3A183E300A183, 0xAC82E3A183E300AC, 0xE300B383E38883E3, 0x8883E3BC83E3A183, 
0x00A283E300AB83E3, 0x00A483E300A383E3, 0x83E3BC83E3A483E3, 0xBC83E3A483E30089, 0x00A583E300AB83E3, 0xE3A683E300A683E3, 0x83E300B383E3A282, 0x83E300A883E300A7, 
0x83E300AA83E300A9, 0xE38883E38383E3AA, 0x83E3AA83E300AB83, 0x83E300AB83E300A9, 0x00BC83E39483E3AB, 0x83E3BC83E3AB83E3, 0xAC83E300AB83E396, 0x00A083E3AC83E300, 
0x83E3B383E3AC83E3, 0x00B383E3B282E388, 0x00AF83E300AD83E3, 0x83E38383E3AF83E3, 0x83E300B083E30088, 0x83E300B283E300B1, 0x83E300B483E300B3, 0x83E300B883E300B7, 
0x83E300BA83E300B9, 0x83E300BC83E300BB, 0x92E3009E92E300BE, 0x93E300BB92E300B9, 0x9BE3009594E3009F, 0x9EE300BC9BE300AE, 0xA1E300AFA0E30081, 0xA3E300BCA1E300A2, 
0xA4E300A3A3E30087, 0xA8E300BAA4E3009C, 0xABE300ACA9E300AE, 0xACE30088ACE300A4, 0xAEE30089ADE30099, 0xB1E30098B0E3009D, 0xB6E300B3B4E3008E, 0xBAE300ACBAE30096, 
0xBFE3009BBCE300B8, 0x80E4008880E400BC, 0x81E400B980E40098, 0x83E4009682E40086, 0x88E400AF84E400A3, 0x8AE400A788E40082, 0x8CE400818CE400A0, 0x8FE400998DE400B4, 
0x90E400998FE40095, 0x94E400AB91E4008B, 0x95E4009D95E400AB, 0x97E400AB95E400A1, 0x98E400B997E40097, 0x9BE400BE9AE400B5, 0xA7E40095A6E40087, 0xA9E400AEA9E400A6, 
0xACE400B2AAE400B6, 0xB3E4008EAFE400B3, 0xB3E400ADB3E4008E, 0xB8E40096B5E400B8, 0xB8E40081B8E40080, 0xB8E40089B8E40083, 0xB8E4008BB8E4008A, 0xB8E40099B8E4008D, 
0xB8E400A8B8E400A6, 0xB8E400B2B8E400AD, 0xB8E400B8B8E400B6, 0xB8E400BDB8E400B9, 0xB9E40081B9E400BF, 0xBAE4009DB9E40099, 0xBAE40085BAE40082, 0xBAE4008CBAE40086, 
0xBAE400A0BAE40094, 0xBAE400AEBAE400A4, 0xBBE40080BBE400BA, 0xBCE400A4BBE4008C, 0xBDE40091BCE40081, 0xBEE40080BEE400A0, 0xBEE4008BBEE40086, 0xBEE400BBBEE400AE, 
0x80E5008280E500BF, 0x82E500BA81E500AB, 0x83E5008F83E50099, 0x84E500A783E5009A, 0x85E500BF84E500AA, 0x85E5008585E50080, 0x85E5009485E5008D, 0x85E500A585E500A4, 
0x85E500A885E500A7, 0x85E500AB85E500A9, 0x86E500B785E500AD, 0x86E5008286E50080, 0x86E5009286E5008D, 0x86E5009686E50095, 0x86E5009986E50097, 0x86E500AB86E500A4, 
0x86E500B586E500AC, 0x87E5008987E500B7, 0x87E5009C87E5008C, 0x87E500A087E5009E, 0x88E5008088E500B5, 0x88E5008788E50083, 0x88E5009D88E50097, 0x88E500BA88E500A9, 
0x89E5008689E500BB, 0x89E500B289E5008D, 0x8AE500898AE500B7, 0x8AE500A38AE5009B, 0x8BE500B48AE500B3, 0x8BE500898BE50087, 0x8BE5009E8BE50092, 0x8BE500B58BE500A4, 
0x8CE500BA8BE500B9, 0x8CE500868CE50085, 0x8CE500978CE50095, 0x8CE500B88CE5009A, 0x8DE500BF8CE500BB, 0x8DE500848DE50081, 0x8DE500898DE50085, 0x8DE500948DE50091, 
0x8DE5009C8DE5009A, 0x8DE500B08DE500A9, 0x8DE500B58DE500B3, 0x8EE500BF8DE500BD, 0x8FE500B68EE50082, 0x8FE500888FE50083, 0x8FE5008C8FE5008A, 0x8FE500A38FE5009F, 
0x8FE500AB8FE500A5, 0x8FE500B18FE500AF, 0x90E5008690E500B3, 0x90E5008D90E50088, 0x90E5009D90E5008F, 0x91E500B990E500B8, 0x91E5008891E50082, 0x92E5009E92E500A8, 
0x93E500BD92E500A2, 0x95E5009094E500B6, 0x95E5009395E5008F, 0x96E500A395E50095, 0x96E5008796E50084, 0x96E5009D96E50099, 0x96E500B396E500AB, 0x97E5008097E500B6, 
0x98E500A297E50082, 0x99E5009199E50086, 0x9BE500B499E500A8, 0x9BE5009B9BE50097, 0x9CE500969CE500B9, 0x9CE5009F9CE50097, 0x9FE5008B9EE500B0, 0xA0E500B49FE5008E, 
0xA0E500B1A0E5008D, 0xA1E50080A1E500B2, 0xA2E5009EA1E5009A, 0xA2E500ACA2E500A8, 0xA3E50098A3E500B3, 0xA3E500ABA3E5009F, 0xA3E500B0A3E500AE, 0xA4E500B7A3E500B2, 
0xA4E50086A4E50082, 0xA4E50095A4E5008A, 0xA4E5009CA4E5009A, 0xA4E500A7A4E500A2, 0xA9A4E500A3ADE6A7, 0x88A5E50084A5E500, 0x94A5E50091A5E500, 0xB3A5E500A2A5E500, 
0xACA7E50098A7E500, 0xA7A8E5009BA8E500, 0xA6A9E500A2A9E500, 0x88ACE500B5AAE500, 0xBEACE500A8ACE500, 0x97ADE50090ADE500, 0x80AEE500A6ADE500, 0x97AEE50085AEE500, 
0x98AFE50083AFE500, 0xAEAFE500A7AFE500, 0xB8AFE500B3AFE500, 0x86B0E500BFAFE500, 0xA2B0E5008FB0E500, 0xBFB0E500B8B0E500, 0xA2B1E500A0B1E500, 0xA5B1E500A4B1E500, 
0xB1B1E500AEB1E500, 0x80B3E5008DB2E500, 0x83B5E50099B4E500, 0xABB5E50090B5E500, 0xBCB5E500AEB5E500, 0xBAB6E500B2B6E500, 0xA1B7E5009BB7E500, 0xA5B7E500A2B7E500, 
0xB1B7E500A6B7E500, 0xBEB7E500BDB7E500, 0xBDB8E500A8B8E500, 0xB2B9E500A9B9E500, 0x009088E6B3B9E500, 0x00BAB9E500B4B9E5, 0x00BFB9E500BCB9E5, 0x00B0BAE500A6BAE5, 
0x00B6BAE500B3BAE5, 0x008ABBE50089BBE5, 0x0093BBE50092BBE5, 0x00ACBBE50099BBE5, 0x00BEBBE500B4BBE5, 0x008BBCE50084BCE5, 0x00A2BCE50093BCE5, 0x0093BDE50090BDE5, 
0x00A2BDE500A1BDE5, 0x00ABBDE500A9BDE5, 0x008BBEE500B3BDE5, 0x0097BEE5008CBEE5, 0x00A9BEE5009ABEE5, 0x0083BFE500ADBEE5, 0x0097BFE5008DBFE5, 0x00B9BFE500B5BFE5, 
0x009C80E6009280E6, 0x008182E600B581E6, 0x008783E6009482E6, 0x00A183E6009883E6, 0x008485E6008884E6, 0x008C85E6008885E6, 0x00A085E6008E85E6, 0x00BA85E600A885E6, 
0x009086E6008E86E6, 0x00AF86E600A486E6, 0x009E87E600B286E6, 0x00B687E600B287E6, 0x008888E6008088E6, 0x009B88E6009088E6, 0x00B488E600AE88E6, 0x008B89E600B688E6, 
0x009D89E6009389E6, 0x00B18AE600958AE6, 0x008F8BE600898BE6, 0x00948BE600938BE6, 0x00BE8BE600BC8BE6, 0x00BD8CE600878CE6, 0x00958DE600908DE6, 0x00BB8DE600A88DE6, 
0x00A08EE600838EE6, 0x00848FE600A98EE6, 0x00A48FE600858FE6, 0x00A290E6009C90E6, 0x00A991E6009291E6, 0x00BE91E600B791E6, 0x009D92E6009A92E6, 0x00AF94E6008493E6, 
0x008F95E600B494E6, 0x00AC95E6009695E6, 0x008796E600B895E6, 0x009996E6009796E6, 0x00B096E600A496E6, 0x008597E600B996E6, 0x00A297E600A097E6, 0x00A597E600A397E6, 
0xE600BBB2E68E98E6, 0xE600A098E6009398, 0x99E6008C92E5AD98, 0x9AE600B499E60089, 0x9AE600919AE60088, 0x9BE600B49AE6009C, 0x9BE600B09BE60086, 0x9CE600B89BE600B4, 
0x9CE600889CE60080, 0x9CE600979CE60089, 0x9CE600A19CE6009B, 0x9DE6008E9DE600A8, 0x9DE600969DE60093, 0x9EE600BB9DE6009E, 0x9FE600979EE60085, 0xA0E600BA9FE600B3, 
0xA0E6009FA0E60097, 0x8FBCE5AAA0E600AA, 0xE600BEA4E79ABCE4, 0xE60081A2E60092A1, 0xE6008EA2E60085A2, 0xE60094A4E600A8A2, 0xE600A3A6E60082A5, 0xE60082A8E600AAA7, 
0xE600A8AAE60093A8, 0xE6009BABE60093AB, 0xE600A0ACE60084AC, 0xE60094ADE600A1AC, 0xE600A3ADE600A2AD, 0xE600B7ADE600B2AD, 0xE6009FAEE600B9AD, 0xE600B3AEE600AEAE, 
0xE600BBAEE600BAAE, 0xE6008DAFE6008BAF, 0xE6009BAFE60094AF, 0xE60094B0E6008FB0, 0xE6008EB1E600B4B0, 0xE60088B2E600A7B1, 0xE6008CB3E600BFB2, 0xE600A5B3E6008DB3, 
0xE60096B4E600A8B3, 0xE6009EB4E6009BB4, 0xE600BEB4E600B4B4, 0xE600A9B5E60081B5, 0xE600B7B5E600AAB5, 0xE60085B6E600B8B5, 0xE6009AB7E6008BB7, 0xE600B9B7E600AAB7, 
0xE600AFB8E6009AB8, 0xE60080BAE600AEB9, 0xE600BABAE6009CBA, 0xE6008BBBE60087BB, 0xE6009BBBE60091BB, 0xE60094BCE6008FBC, 0xE600A3BCE600A2BC, 0xE60086BFE600AEBD, 
0xE700BEBFE600ABBF, 0xE7009E80E7009B80, 0xE7008A81E700B980, 0xE700B081E700AB81, 0xE700BD81E700B781, 0xE700AD82E7009982, 0xE7009983E7008883, 0xE7008585E700A184, 
0xE700AE85E7008985, 0xE7008E87E7009C86, 0xE7009088E7009087, 0xE700A888E7009B88, 0xE700AB88E700AA88, 0xE700B688E700B588, 0xE700BF88E700BB88, 0xE7009089E7008789, 
0xE7009B89E7009989, 0xE700B989E700A289, 0xE700958AE700808A, 0xE700AF8AE700AC8A, 0xE700BC8BE700808B, 0xE700B58DE700AA8C, 0xE700848EE700BA8D, 0xE700898EE700878E, 
0xE700A58EE7008B8E, 0xE7009E8FE700B28E, 0xE7008990E7008690, 0xE7008791E700A290, 0xE700A991E7009C91, 0xE7008592E700B191, 0xE7009892E7008992, 0xE7009C93E7008A93, 
0xE7008694E700A693, 0xE7009F94E7009894, 0xE700A894E700A494, 0xE700B294E700B094, 0xE700B794E700B394, 0xE700BE94E700BB94, 0xE700A595E7009995, 0xE7008B96E700B095, 
0xE700A297E7009296, 0xE7009D98E7009098, 0xE7008299E7009F98, 0xE700B699E700A999, 0xE700AE9AE700BD99, 0xE7008A9BE700BF9A, 0xE700A39BE7009B9B, 0xE700AE9BE700A79B, 
0xE700819CE700B49B, 0xE7009F9CE7009E9C, 0xE7008A9DE700809D, 0xE700A79EE7008B9E, 0xE700A29FE7009B9F, 0xE7008EA1E700B39F, 0xE7008CA2E700ABA1, 0xE7008AA3E70091A2, 
0xE700BBA3E7008CA3, 0xE700BAA4E700AAA4, 0xE700BEA4E700BCA4, 0xE70089A5E70088A5, 0xE70096A5E70090A5, 0xE7009EA5E7009DA5, 0xE700BFA5E700A5A5, 0xE7008DA6E70081A6, 
0xE7008FA6E7008EA6, 0xE700B8A6E700AEA6, 0xE7008AA7E700BEA6, 0xE700ABA7E70098A7, 0xE70080A9E7009CA8, 0xE7008FA9E7008AA9, 0xE700BAA9E700B4A9, 0xE700B1AAE70081AA, 
0xE700AEABE7008BAB, 0xE700A0ACE700B9AB, 0xE70080AFE7008FAE, 0xE70089AFE70086AF, 0xE700A0B1E700BEB0, 0xE700BBB1E700B3B1, 0xE700BEB2E70092B2, 0xE70096B3E70092B3, 
0xE700A7B3E700A3B3, 0xE700B8B3E700A8B3, 0xE70090B4E70080B4, 0xE700AFB4E700A2B4, 0xE7009BB5E70082B5, 0xE700A0B6E700A3B5, 0xE70087B7E700BEB6, 0xE70082B8E700B4B7, 
0xE700B7B8E70089B8, 0xE70085B9E70081B9, 0xE700BEBCE700B6BC, 0xE700B2BDE70091BD, 0xE700BABDE700B9BD, 0xE7008ABEE70085BE, 0xE7009ABEE70095BE, 0xE800BABFE700BDBE, 
0xE8008580E8008180, 0xE8009280E8008C80, 0xE8008681E800B380, 0xE800AF81E800A081, 0xE800BE81E800B081, 0xE8008982E800BF81, 0xE800AD82E8008B82, 0xE8008384E800B282, 
0xE8009887E800BE84, 0xE800A887E800A387, 0xE800AD87E800AA87, 0xE800BC87E800B387, 0xE8008488E8008188, 0xE8009888E8008C88, 0xE8009F88E8009B88, 0xE800AF89E800AE89, 
0xE800B889E800B289, 0xE8008B8AE800B989, 0xE8009D8AE800918A, 0xE800B38AE800B18A, 0xE800A58BE800BD8A, 0xE8009D8CE800A68B, 0xE800B68CE800A38C, 0xE800938DE800928D, 
0xE800AD8EE800A38D, 0xE800898FE800BD8E, 0xE8008C8FE8008A8F, 0xE800A78FE8009C8F, 0xE800B18FE800AF8F, 0xE8008991E800BD90, 0xE800AE93E8009791, 0xE800B393E800B193, 
0xE8009694E800BC93, 0xE8008D97E800A495, 0xE8008698E800BA97, 0xE800AD98E8009298, 0xE8008D99E800BF98, 0xE8009C99E8009099, 0xE800A999E800A799, 0xE800889AE800AB99, 
0xE800A29BE800A99A, 0xE800A89CE8008E9C, 0xE800B99DE800AB9D, 0xE800BA9EE800869E, 0xE80081A0E800A19F, 0xE80080A1E8009FA0, 0xE800A0A1E8008CA1, 0xE80082A3E800A3A1, 
0xE80097A3E8008FA3, 0xE800A1A3E8009EA3, 0xE800BAA3E800B8A3, 0xE80081A5E80090A4, 0xE800BEA5E800A4A5, 0xE8008BA6E80086A6, 0xE80092A7E80096A6, 0xE80080A8E800A3A7, 
0xE800AAAAE800A0AA, 0xE8008BABE800BFAA, 0xE80096ABE80092AB, 0xE800B8ABE800ADAB, 0xE80081ACE800BEAB, 0xE80098ADE800B9AC, 0xE8008AAEE80080AE, 0xE80086B1E800B7B0, 
0xE80095B1E80088B1, 0xE8009DB2E800B8B1, 0xE800A9B2E800A1B2, 0xE80081B3E800ABB2, 0xE80087B3E80082B3, 0xE80093B3E80088B3, 0xE8009BB4E80088B4, 0xE800B0B5E800A4B5, 
0xE800B3B6E800B7B5, 0xE8008BB7E800BCB6, 0xE800B0B7E800AFB7, 0xE8008ABBE800ABBA, 0xE800A6BCE80094BB, 0xE800B8BCE800AABC, 0xE800A2BDE800BBBC, 0xE8009EBEE8009BBE, 
0xE800B5BEE800B0BE, 0xE900A380E900B6BE, 0xE9008A81E900B880, 0xE900B281E900A981, 0xE9008F82E900BC81, 0xE9009482E9009182, 0xE9009E83E9008E83, 0xE900BD83E900B183, 
0xE9009B84E9009184, 0xE900AA85E9008985, 0xE900B486E9009986, 0xE9008C87E9008687, 0xE9009187E9008F87, 0xE900B888E900B488, 0xE900BC89E900B689, 0xE900988BE900978B, 
0xE9008A8DE900848C, 0xE9009590E900B98F, 0xE9008096E900B795, 0xE900AD96E9008B96, 0xE9009C98E900B796, 0xE9008B99E900AE98, 0xE900B599E9008D99, 0xE900BC99E900B899, 
0xE900A39AE900869A, 0xE900B79AE900B69A, 0xE900B99AE900B89A, 0xE900A29BE900839B, 0xE900A89BE900A39B, 0xE900B79BE900B69B, 0xE900B29CE900A39C, 0xE900919DE900889D, 
0xE9009E9DE900969D, 0xE900A99DE900A29D, 0xE9009B9FE9008B9F, 0xE900AD9FE900A09F, 0xE900BF9FE900B39F, 0xE90085A0E90081A0, 0xE90098A0E9008BA0, 0xE900BBA0E900A9A0, 
0xE900A8A2E9009EA1, 0xE9009FA3E9009BA3, 0xE900AFA3E900A2A3, 0xE900A8A4E900BCA3, 0xE90096A6E900A9A4, 0xE900A7A6E90099A6, 0xE90082A7E900ACA6, 0xE900BEA7E900B1A7, 
0xE900A8AAE900AAA9, 0xE9009FABE90098AB, 0xE900A5ACE90092AC, 0xE900B2ACE900AFAC, 0xE9009AADE900BCAC, 0xE90080B1E900AFAD, 0xE900A5B3E90097B1, 0xE900A7B5E900BDB3, 
0xE900BAB7E900B4B6, 0xE900B5B9E9009EB8, 0xE90097BAE900BFB9, 0xE900A5BAE9009FBA, 0xE90083BBE900BBBA, 0xE9008EBBE9008DBB, 0xE900B9BBE90091BB, 0xE900BEBBE900BDBB, 
0xE9008EBCE90085BC, 0xE90093BCE9008FBC, 0xE900A0BCE90096BC, 0xE90083BDE900BBBC, 0xE90092BDE9008ABD, 0xE9008EBEE9008DBE, 0xE9009FBEE9009CBE, 0xEA00A79CEA00A0BE, 
0xEA00B7ACEA00AF9D, 0xEA0080B0EA0092AD, 0xEA0082B0EA0081B0, 0xEA0084B0EA0083B0, 0xEA0086B0EA0085B0, 0xEA0088B0EA0087B0, 0xEA008AB0EA0089B0, 0xEA008CB0EA008BB0, 
0xEA008EB0EA008DB0, 0xEA0090B0EA008FB0, 0xEA0092B0EA0091B0, 0xEA0094B0EA0093B0, 0xEA0096B0EA0095B0, 0xEA0098B0EA0097B0, 0xEA009AB0EA0099B0, 0xEA009CB0EA009BB0, 
0xEA009EB0EA009DB0, 0xEA00A0B0EA009FB0, 0xEA00A2B0EA00A1B0, 0xEA00A4B0EA00A3B0, 0xEA00A6B0EA00A5B0, 0xEA00A8B0EA00A7B0, 0xEA00AAB0EA00A9B0, 0xEA00ACB0EA00ABB0, 
0xEA00AEB0EA00ADB0, 0xEA00B0B0EA00AFB0, 0xEA00B2B0EA00B1B0, 0xEA00B4B0EA00B3B0, 0xEA00B6B0EA00B5B0, 0xEA00B8B0EA00B7B0, 0xEA00BAB0EA00B9B0, 0xEA00BCB0EA00BBB0, 
0xEA00BEB0EA00BDB0, 0xEA0080B1EA00BFB0, 0xEA0082B1EA0081B1, 0xEA0084B1EA0083B1, 0xEA0086B1EA0085B1, 0xEA0088B1EA0087B1, 0xEA008AB1EA0089B1, 0xEA008CB1EA008BB1, 
0xEA008EB1EA008DB1, 0xEA0090B1EA008FB1, 0xEA0092B1EA0091B1, 0xEA0094B1EA0093B1, 0xEA0096B1EA0095B1, 0xEA0098B1EA0097B1, 0xEA009AB1EA0099B1, 0xEA009CB1EA009BB1, 
0xEA009EB1EA009DB1, 0xEA00A0B1EA009FB1, 0xEA00A2B1EA00A1B1, 0xEA00A4B1EA00A3B1, 0xEA00A6B1EA00A5B1, 0xEA00A8B1EA00A7B1, 0xEA00AAB1EA00A9B1, 0xEA00ACB1EA00ABB1, 
0xEA00AEB1EA00ADB1, 0xEA00B0B1EA00AFB1, 0xEA00B2B1EA00B1B1, 0xEA00B4B1EA00B3B1, 0xEA00B6B1EA00B5B1, 0xEA00B8B1EA00B7B1, 0xEA00BAB1EA00B9B1, 0xEA00BCB1EA00BBB1, 
0xEA00BEB1EA00BDB1, 0xEA0080B2EA00BFB1, 0xEA0082B2EA0081B2, 0xEA0084B2EA0083B2, 0xEA0086B2EA0085B2, 0xEA0088B2EA0087B2, 0xEA008AB2EA0089B2, 0xEA008CB2EA008BB2, 
0xEA008EB2EA008DB2, 0xEA0090B2EA008FB2, 0xEA0092B2EA0091B2, 0xEA0094B2EA0093B2, 0xEA0096B2EA0095B2, 0xEA0098B2EA0097B2, 0xEA009AB2EA0099B2, 0xEA009CB2EA009BB2, 
0xEA009EB2EA009DB2, 0xEA00A0B2EA009FB2, 0xEA00A2B2EA00A1B2, 0xEA00A4B2EA00A3B2, 0xEA00A6B2EA00A5B2, 0xEA00A8B2EA00A7B2, 0xEA00AAB2EA00A9B2, 0xEA00ACB2EA00ABB2, 
0xEA00AEB2EA00ADB2, 0xEA00B0B2EA00AFB2, 0xEA00B2B2EA00B1B2, 0xEA00B4B2EA00B3B2, 0xEA00B6B2EA00B5B2, 0xEA00B8B2EA00B7B2, 0xEA00BAB2EA00B9B2, 0xEA00BCB2EA00BBB2, 
0xEA00BEB2EA00BDB2, 0xEA0080B3EA00BFB2, 0xEA0082B3EA0081B3, 0xEA0084B3EA0083B3, 0xEA0086B3EA0085B3, 0xEA0088B3EA0087B3, 0xEA008AB3EA0089B3, 0xEA008CB3EA008BB3, 
0xEA008EB3EA008DB3, 0xEA0090B3EA008FB3, 0xEA0092B3EA0091B3, 0xEA0094B3EA0093B3, 0xEA0096B3EA0095B3, 0xEA0098B3EA0097B3, 0xEA009AB3EA0099B3, 0xEA009CB3EA009BB3, 
0xEA009EB3EA009DB3, 0xEA00A0B3EA009FB3, 0xEA00A2B3EA00A1B3, 0xEA00A4B3EA00A3B3, 0xEA00A6B3EA00A5B3, 0xEA00A8B3EA00A7B3, 0xEA00AAB3EA00A9B3, 0xEA00ACB3EA00ABB3, 
0xEA00AEB3EA00ADB3, 0xEA00B0B3EA00AFB3, 0xEA00B2B3EA00B1B3, 0xEA00B4B3EA00B3B3, 0xEA00B6B3EA00B5B3, 0xEA00B8B3EA00B7B3, 0xEA00BAB3EA00B9B3, 0xEA00BCB3EA00BBB3, 
0xEA00BEB3EA00BDB3, 0xEA0080B4EA00BFB3, 0xEA0082B4EA0081B4, 0xEA0084B4EA0083B4, 0xEA0086B4EA0085B4, 0xEA0088B4EA0087B4, 0xEA008AB4EA0089B4, 0xEA008CB4EA008BB4, 
0xEA008EB4EA008DB4, 0xEA0090B4EA008FB4, 0xEA0092B4EA0091B4, 0xEA0094B4EA0093B4, 0xEA0096B4EA0095B4, 0xEA0098B4EA0097B4, 0xEA009AB4EA0099B4, 0xEA009CB4EA009BB4, 
0xEA009EB4EA009DB4, 0xEA00A0B4EA009FB4, 0xEA00A2B4EA00A1B4, 0xEA00A4B4EA00A3B4, 0xEA00A6B4EA00A5B4, 0xEA00A8B4EA00A7B4, 0xEA00AAB4EA00A9B4, 0xEA00ACB4EA00ABB4, 
0xEA00AEB4EA00ADB4, 0xEA00B0B4EA00AFB4, 0xEA00B2B4EA00B1B4, 0xEA00B4B4EA00B3B4, 0xEA00B6B4EA00B5B4, 0xEA00B8B4EA00B7B4, 0xEA00BAB4EA00B9B4, 0xEA00BCB4EA00BBB4, 
0xEA00BEB4EA00BDB4, 0xEA0080B5EA00BFB4, 0xEA0082B5EA0081B5, 0xEA0084B5EA0083B5, 0xEA0086B5EA0085B5, 0xEA0088B5EA0087B5, 0xEA008AB5EA0089B5, 0xEA008CB5EA008BB5, 
0xEA008EB5EA008DB5, 0xEA0090B5EA008FB5, 0xEA0092B5EA0091B5, 0xEA0094B5EA0093B5, 0xEA0096B5EA0095B5, 0xEA0098B5EA0097B5, 0xEA009AB5EA0099B5, 0xEA009CB5EA009BB5, 
0xEA009EB5EA009DB5, 0xEA00A0B5EA009FB5, 0xEA00A2B5EA00A1B5, 0xEA00A4B5EA00A3B5, 0xEA00A6B5EA00A5B5, 0xEA00A8B5EA00A7B5, 0xEA00AAB5EA00A9B5, 0xEA00ACB5EA00ABB5, 
0xEA00AEB5EA00ADB5, 0xEA00B0B5EA00AFB5, 0xEA00B2B5EA00B1B5, 0xEA00B4B5EA00B3B5, 0xEA00B6B5EA00B5B5, 0xEA00B8B5EA00B7B5, 0xEA00BAB5EA00B9B5, 0xEA00BCB5EA00BBB5, 
0xEA00BEB5EA00BDB5, 0xEA0080B6EA00BFB5, 0xEA0082B6EA0081B6, 0xEA0084B6EA0083B6, 0xEA0086B6EA0085B6, 0xEA0088B6EA0087B6, 0xEA008AB6EA0089B6, 0xEA008CB6EA008BB6, 
0xEA008EB6EA008DB6, 0xEA0090B6EA008FB6, 0xEA0092B6EA0091B6, 0xEA0094B6EA0093B6, 0xEA0096B6EA0095B6, 0xEA0098B6EA0097B6, 0xEA009AB6EA0099B6, 0xEA009CB6EA009BB6, 
0xEA009EB6EA009DB6, 0xEA00A0B6EA009FB6, 0xEA00A2B6EA00A1B6, 0xEA00A4B6EA00A3B6, 0xEA00A6B6EA00A5B6, 0xEA00A8B6EA00A7B6, 0xEA00AAB6EA00A9B6, 0xEA00ACB6EA00ABB6, 
0xEA00AEB6EA00ADB6, 0xEA00B0B6EA00AFB6, 0xEA00B2B6EA00B1B6, 0xEA00B4B6EA00B3B6, 0xEA00B6B6EA00B5B6, 0xEA00B8B6EA00B7B6, 0xEA00BAB6EA00B9B6, 0xEA00BCB6EA00BBB6, 
0xEA00BEB6EA00BDB6, 0xEA0080B7EA00BFB6, 0xEA0082B7EA0081B7, 0xEA0084B7EA0083B7, 0xEA0086B7EA0085B7, 0xEA0088B7EA0087B7, 0xEA008AB7EA0089B7, 0xEA008CB7EA008BB7, 
0xEA008EB7EA008DB7, 0xEA0090B7EA008FB7, 0xEA0092B7EA0091B7, 0xEA0094B7EA0093B7, 0xEA0096B7EA0095B7, 0xEA0098B7EA0097B7, 0xEA009AB7EA0099B7, 0xEA009CB7EA009BB7, 
0xEA009EB7EA009DB7, 0xEA00A0B7EA009FB7, 0xEA00A2B7EA00A1B7, 0xEA00A4B7EA00A3B7, 0xEA00A6B7EA00A5B7, 0xEA00A8B7EA00A7B7, 0xEA00AAB7EA00A9B7, 0xEA00ACB7EA00ABB7, 
0xEA00AEB7EA00ADB7, 0xEA00B0B7EA00AFB7, 0xEA00B2B7EA00B1B7, 0xEA00B4B7EA00B3B7, 0xEA00B6B7EA00B5B7, 0xEA00B8B7EA00B7B7, 0xEA00BAB7EA00B9B7, 0xEA00BCB7EA00BBB7, 
0xEA00BEB7EA00BDB7, 0xEA0080B8EA00BFB7, 0xEA0082B8EA0081B8, 0xEA0084B8EA0083B8, 0xEA0086B8EA0085B8, 0xEA0088B8EA0087B8, 0xEA008AB8EA0089B8, 0xEA008CB8EA008BB8, 
0xEA008EB8EA008DB8, 0xEA0090B8EA008FB8, 0xEA0092B8EA0091B8, 0xEA0094B8EA0093B8, 0xEA0096B8EA0095B8, 0xEA0098B8EA0097B8, 0xEA009AB8EA0099B8, 0xEA009CB8EA009BB8, 
0xEA009EB8EA009DB8, 0xEA00A0B8EA009FB8, 0xEA00A2B8EA00A1B8, 0xEA00A4B8EA00A3B8, 0xEA00A6B8EA00A5B8, 0xEA00A8B8EA00A7B8, 0xEA00AAB8EA00A9B8, 0xEA00ACB8EA00ABB8, 
0xEA00AEB8EA00ADB8, 0xEA00B0B8EA00AFB8, 0xEA00B2B8EA00B1B8, 0xEA00B4B8EA00B3B8, 0xEA00B6B8EA00B5B8, 0xEA00B8B8EA00B7B8, 0xEA00BAB8EA00B9B8, 0xEA00BCB8EA00BBB8, 
0xEA00BEB8EA00BDB8, 0xEA0080B9EA00BFB8, 0xEA0082B9EA0081B9, 0xEA0084B9EA0083B9, 0xEA0086B9EA0085B9, 0xEA0088B9EA0087B9, 0xEA008AB9EA0089B9, 0xEA008CB9EA008BB9, 
0xEA008EB9EA008DB9, 0xEA0090B9EA008FB9, 0xEA0092B9EA0091B9, 0xEA0094B9EA0093B9, 0xEA0096B9EA0095B9, 0xEA0098B9EA0097B9, 0xEA009AB9EA0099B9, 0xEA009CB9EA009BB9, 
0xEA009EB9EA009DB9, 0xEA00A0B9EA009FB9, 0xEA00A2B9EA00A1B9, 0xEA00A4B9EA00A3B9, 0xEA00A6B9EA00A5B9, 0xEA00A8B9EA00A7B9, 0xEA00AAB9EA00A9B9, 0xEA00ACB9EA00ABB9, 
0xEA00AEB9EA00ADB9, 0xEA00B0B9EA00AFB9, 0xEA00B2B9EA00B1B9, 0xEA00B4B9EA00B3B9, 0xEA00B6B9EA00B5B9, 0xEA00B8B9EA00B7B9, 0xEA00BAB9EA00B9B9, 0xEA00BCB9EA00BBB9, 
0xEA00BEB9EA00BDB9, 0xEA0080BAEA00BFB9, 0xEA0082BAEA0081BA, 0xEA0084BAEA0083BA, 0xEA0086BAEA0085BA, 0xEA0088BAEA0087BA, 0xEA008ABAEA0089BA, 0xEA008CBAEA008BBA, 
0xEA008EBAEA008DBA, 0xEA0090BAEA008FBA, 0xEA0092BAEA0091BA, 0xEA0094BAEA0093BA, 0xEA0096BAEA0095BA, 0xEA0098BAEA0097BA, 0xEA009ABAEA0099BA, 0xEA009CBAEA009BBA, 
0xEA009EBAEA009DBA, 0xEA00A0BAEA009FBA, 0xEA00A2BAEA00A1BA, 0xEA00A4BAEA00A3BA, 0xEA00A6BAEA00A5BA, 0xEA00A8BAEA00A7BA, 0xEA00AABAEA00A9BA, 0xEA00ACBAEA00ABBA, 
0xEA00AEBAEA00ADBA, 0xEA00B0BAEA00AFBA, 0xEA00B2BAEA00B1BA, 0xEA00B4BAEA00B3BA, 0xEA00B6BAEA00B5BA, 0xEA00B8BAEA00B7BA, 0xEA00BABAEA00B9BA, 0xEA00BCBAEA00BBBA, 
0xEA00BEBAEA00BDBA, 0xEA0080BBEA00BFBA, 0xEA0082BBEA0081BB, 0xEA0084BBEA0083BB, 0xEA0086BBEA0085BB, 0xEA0088BBEA0087BB, 0xEA008ABBEA0089BB, 0xEA008CBBEA008BBB, 
0xEA008EBBEA008DBB, 0xEA0090BBEA008FBB, 0xEA0092BBEA0091BB, 0xEA0094BBEA0093BB, 0xEA0096BBEA0095BB, 0xEA0098BBEA0097BB, 0xEA009ABBEA0099BB, 0xEA009CBBEA009BBB, 
0xEA009EBBEA009DBB, 0xEA00A0BBEA009FBB, 0xEA00A2BBEA00A1BB, 0xEA00A4BBEA00A3BB, 0xEA00A6BBEA00A5BB, 0xEA00A8BBEA00A7BB, 0xEA00AABBEA00A9BB, 0xEA00ACBBEA00ABBB, 
0xEA00AEBBEA00ADBB, 0xEA00B0BBEA00AFBB, 0xEA00B2BBEA00B1BB, 0xEA00B4BBEA00B3BB, 0xEA00B6BBEA00B5BB, 0xEA00B8BBEA00B7BB, 0xEA00BABBEA00B9BB, 0xEA00BCBBEA00BBBB, 
0xEA00BEBBEA00BDBB, 0xEA0080BCEA00BFBB, 0xEA0082BCEA0081BC, 0xEA0084BCEA0083BC, 0xEA0086BCEA0085BC, 0xEA0088BCEA0087BC, 0xEA008ABCEA0089BC, 0xEA008CBCEA008BBC, 
0xEA008EBCEA008DBC, 0xEA0090BCEA008FBC, 0xEA0092BCEA0091BC, 0xEA0094BCEA0093BC, 0xEA0096BCEA0095BC, 0xEA0098BCEA0097BC, 0xEA009ABCEA0099BC, 0xEA009CBCEA009BBC, 
0xEA009EBCEA009DBC, 0xEA00A0BCEA009FBC, 0xEA00A2BCEA00A1BC, 0xEA00A4BCEA00A3BC, 0xEA00A6BCEA00A5BC, 0xEA00A8BCEA00A7BC, 0xEA00AABCEA00A9BC, 0xEA00ACBCEA00ABBC, 
0xEA00AEBCEA00ADBC, 0xEA00B0BCEA00AFBC, 0xEA00B2BCEA00B1BC, 0xEA00B4BCEA00B3BC, 0xEA00B6BCEA00B5BC, 0xEA00B8BCEA00B7BC, 0xEA00BABCEA00B9BC, 0xEA00BCBCEA00BBBC, 
0xEA00BEBCEA00BDBC, 0xEA0080BDEA00BFBC, 0xEA0082BDEA0081BD, 0xEA0084BDEA0083BD, 0xEA0086BDEA0085BD, 0xEA0088BDEA0087BD, 0xEA008ABDEA0089BD, 0xEA008CBDEA008BBD, 
0xEA008EBDEA008DBD, 0xEA0090BDEA008FBD, 0xEA0092BDEA0091BD, 0xEA0094BDEA0093BD, 0xEA0096BDEA0095BD, 0xEA0098BDEA0097BD, 0xEA009ABDEA0099BD, 0xEA009CBDEA009BBD, 
0xEA009EBDEA009DBD, 0xEA00A0BDEA009FBD, 0xEA00A2BDEA00A1BD, 0xEA00A4BDEA00A3BD, 0xEA00A6BDEA00A5BD, 0xEA00A8BDEA00A7BD, 0xEA00AABDEA00A9BD, 0xEA00ACBDEA00ABBD, 
0xEA00AEBDEA00ADBD, 0xEA00B0BDEA00AFBD, 0xEA00B2BDEA00B1BD, 0xEA00B4BDEA00B3BD, 0xEA00B6BDEA00B5BD, 0xEA00B8BDEA00B7BD, 0xEA00BABDEA00B9BD, 0xEA00BCBDEA00BBBD, 
0xEA00BEBDEA00BDBD, 0xEA0080BEEA00BFBD, 0xEA0082BEEA0081BE, 0xEA0084BEEA0083BE, 0xEA0086BEEA0085BE, 0xEA0088BEEA0087BE, 0xEA008ABEEA0089BE, 0xEA008CBEEA008BBE, 
0xEA008EBEEA008DBE, 0xEA0090BEEA008FBE, 0xEA0092BEEA0091BE, 0xEA0094BEEA0093BE, 0xEA0096BEEA0095BE, 0xEA0098BEEA0097BE, 0xEA009ABEEA0099BE, 0xEA009CBEEA009BBE, 
0xEA009EBEEA009DBE, 0xEA00A0BEEA009FBE, 0xEA00A2BEEA00A1BE, 0xEA00A4BEEA00A3BE, 0xEA00A6BEEA00A5BE, 0xEA00A8BEEA00A7BE, 0xEA00AABEEA00A9BE, 0xEA00ACBEEA00ABBE, 
0xEA00AEBEEA00ADBE, 0xEA00B0BEEA00AFBE, 0xEA00B2BEEA00B1BE, 0xEA00B4BEEA00B3BE, 0xEA00B6BEEA00B5BE, 0xEA00B8BEEA00B7BE, 0xEA00BABEEA00B9BE, 0xEA00BCBEEA00BBBE, 
0xEA00BEBEEA00BDBE, 0xEA0080BFEA00BFBE, 0xEA0082BFEA0081BF, 0xEA0084BFEA0083BF, 0xEA0086BFEA0085BF, 0xEA0088BFEA0087BF, 0xEA008ABFEA0089BF, 0xEA008CBFEA008BBF, 
0xEA008EBFEA008DBF, 0xEA0090BFEA008FBF, 0xEA0092BFEA0091BF, 0xEA0094BFEA0093BF, 0xEA0096BFEA0095BF, 0xEA0098BFEA0097BF, 0xEA009ABFEA0099BF, 0xEA009CBFEA009BBF, 
0xEA009EBFEA009DBF, 0xEA00A0BFEA009FBF, 0xEA00A2BFEA00A1BF, 0xEA00A4BFEA00A3BF, 0xEA00A6BFEA00A5BF, 0xEA00A8BFEA00A7BF, 0xEA00AABFEA00A9BF, 0xEA00ACBFEA00ABBF, 
0xEA00AEBFEA00ADBF, 0xEA00B0BFEA00AFBF, 0xEA00B2BFEA00B1BF, 0xEA00B4BFEA00B3BF, 0xEA00B6BFEA00B5BF, 0xEA00B8BFEA00B7BF, 0xEA00BABFEA00B9BF, 0xEA00BCBFEA00BBBF, 
0xEA00BEBFEA00BDBF, 0xEB008080EB00BFBF, 0xEB008280EB008180, 0xEB008480EB008380, 0xEB008680EB008580, 0xEB008880EB008780, 0xEB008A80EB008980, 0xEB008C80EB008B80, 
0xEB008E80EB008D80, 0xEB009080EB008F80, 0xEB009280EB009180, 0xEB009480EB009380, 0xEB009680EB009580, 0xEB009880EB009780, 0xEB009A80EB009980, 0xEB009C80EB009B80, 
0xEB009E80EB009D80, 0xEB00A080EB009F80, 0xEB00A280EB00A180, 0xEB00A480EB00A380, 0xEB00A680EB00A580, 0xEB00A880EB00A780, 0xEB00AA80EB00A980, 0xEB00AC80EB00AB80, 
0xEB00AE80EB00AD80, 0xEB00B080EB00AF80, 0xEB00B280EB00B180, 0xEB00B480EB00B380, 0xEB00B680EB00B580, 0xEB00B880EB00B780, 0xEB00BA80EB00B980, 0xEB00BC80EB00BB80, 
0xEB00BE80EB00BD80, 0xEB008081EB00BF80, 0xEB008281EB008181, 0xEB008481EB008381, 0xEB008681EB008581, 0xEB008881EB008781, 0xEB008A81EB008981, 0xEB008C81EB008B81, 
0xEB008E81EB008D81, 0xEB009081EB008F81, 0xEB009281EB009181, 0xEB009481EB009381, 0xEB009681EB009581, 0xEB009881EB009781, 0xEB009A81EB009981, 0xEB009C81EB009B81, 
0xEB009E81EB009D81, 0xEB00A081EB009F81, 0xEB00A281EB00A181, 0xEB00A481EB00A381, 0xEB00A681EB00A581, 0xEB00A881EB00A781, 0xEB00AA81EB00A981, 0xEB00AC81EB00AB81, 
0xEB00AE81EB00AD81, 0xEB00B081EB00AF81, 0xEB00B281EB00B181, 0xEB00B481EB00B381, 0xEB00B681EB00B581, 0xEB00B881EB00B781, 0xEB00BA81EB00B981, 0xEB00BC81EB00BB81, 
0xEB00BE81EB00BD81, 0xEB008082EB00BF81, 0xEB008282EB008182, 0xEB008482EB008382, 0xEB008682EB008582, 0xEB008882EB008782, 0xEB008A82EB008982, 0xEB008C82EB008B82, 
0xEB008E82EB008D82, 0xEB009082EB008F82, 0xEB009282EB009182, 0xEB009482EB009382, 0xEB009682EB009582, 0xEB009882EB009782, 0xEB009A82EB009982, 0xEB009C82EB009B82, 
0xEB009E82EB009D82, 0xEB00A082EB009F82, 0xEB00A282EB00A182, 0xEB00A482EB00A382, 0xEB00A682EB00A582, 0xEB00A882EB00A782, 0xEB00AA82EB00A982, 0xEB00AC82EB00AB82, 
0xEB00AE82EB00AD82, 0xEB00B082EB00AF82, 0xEB00B282EB00B182, 0xEB00B482EB00B382, 0xEB00B682EB00B582, 0xEB00B882EB00B782, 0xEB00BA82EB00B982, 0xEB00BC82EB00BB82, 
0xEB00BE82EB00BD82, 0xEB008083EB00BF82, 0xEB008283EB008183, 0xEB008483EB008383, 0xEB008683EB008583, 0xEB008883EB008783, 0xEB008A83EB008983, 0xEB008C83EB008B83, 
0xEB008E83EB008D83, 0xEB009083EB008F83, 0xEB009283EB009183, 0xEB009483EB009383, 0xEB009683EB009583, 0xEB009883EB009783, 0xEB009A83EB009983, 0xEB009C83EB009B83, 
0xEB009E83EB009D83, 0xEB00A083EB009F83, 0xEB00A283EB00A183, 0xEB00A483EB00A383, 0xEB00A683EB00A583, 0xEB00A883EB00A783, 0xEB00AA83EB00A983, 0xEB00AC83EB00AB83, 
0xEB00AE83EB00AD83, 0xEB00B083EB00AF83, 0xEB00B283EB00B183, 0xEB00B483EB00B383, 0xEB00B683EB00B583, 0xEB00B883EB00B783, 0xEB00BA83EB00B983, 0xEB00BC83EB00BB83, 
0xEB00BE83EB00BD83, 0xEB008084EB00BF83, 0xEB008284EB008184, 0xEB008484EB008384, 0xEB008684EB008584, 0xEB008884EB008784, 0xEB008A84EB008984, 0xEB008C84EB008B84, 
0xEB008E84EB008D84, 0xEB009084EB008F84, 0xEB009284EB009184, 0xEB009484EB009384, 0xEB009684EB009584, 0xEB009884EB009784, 0xEB009A84EB009984, 0xEB009C84EB009B84, 
0xEB009E84EB009D84, 0xEB00A084EB009F84, 0xEB00A284EB00A184, 0xEB00A484EB00A384, 0xEB00A684EB00A584, 0xEB00A884EB00A784, 0xEB00AA84EB00A984, 0xEB00AC84EB00AB84, 
0xEB00AE84EB00AD84, 0xEB00B084EB00AF84, 0xEB00B284EB00B184, 0xEB00B484EB00B384, 0xEB00B684EB00B584, 0xEB00B884EB00B784, 0xEB00BA84EB00B984, 0xEB00BC84EB00BB84, 
0xEB00BE84EB00BD84, 0xEB008085EB00BF84, 0xEB008285EB008185, 0xEB008485EB008385, 0xEB008685EB008585, 0xEB008885EB008785, 0xEB008A85EB008985, 0xEB008C85EB008B85, 
0xEB008E85EB008D85, 0xEB009085EB008F85, 0xEB009285EB009185, 0xEB009485EB009385, 0xEB009685EB009585, 0xEB009885EB009785, 0xEB009A85EB009985, 0xEB009C85EB009B85, 
0xEB009E85EB009D85, 0xEB00A085EB009F85, 0xEB00A285EB00A185, 0xEB00A485EB00A385, 0xEB00A685EB00A585, 0xEB00A885EB00A785, 0xEB00AA85EB00A985, 0xEB00AC85EB00AB85, 
0xEB00AE85EB00AD85, 0xEB00B085EB00AF85, 0xEB00B285EB00B185, 0xEB00B485EB00B385, 0xEB00B685EB00B585, 0xEB00B885EB00B785, 0xEB00BA85EB00B985, 0xEB00BC85EB00BB85, 
0xEB00BE85EB00BD85, 0xEB008086EB00BF85, 0xEB008286EB008186, 0xEB008486EB008386, 0xEB008686EB008586, 0xEB008886EB008786, 0xEB008A86EB008986, 0xEB008C86EB008B86, 
0xEB008E86EB008D86, 0xEB009086EB008F86, 0xEB009286EB009186, 0xEB009486EB009386, 0xEB009686EB009586, 0xEB009886EB009786, 0xEB009A86EB009986, 0xEB009C86EB009B86, 
0xEB009E86EB009D86, 0xEB00A086EB009F86, 0xEB00A286EB00A186, 0xEB00A486EB00A386, 0xEB00A686EB00A586, 0xEB00A886EB00A786, 0xEB00AA86EB00A986, 0xEB00AC86EB00AB86, 
0xEB00AE86EB00AD86, 0xEB00B086EB00AF86, 0xEB00B286EB00B186, 0xEB00B486EB00B386, 0xEB00B686EB00B586, 0xEB00B886EB00B786, 0xEB00BA86EB00B986, 0xEB00BC86EB00BB86, 
0xEB00BE86EB00BD86, 0xEB008087EB00BF86, 0xEB008287EB008187, 0xEB008487EB008387, 0xEB008687EB008587, 0xEB008887EB008787, 0xEB008A87EB008987, 0xEB008C87EB008B87, 
0xEB008E87EB008D87, 0xEB009087EB008F87, 0xEB009287EB009187, 0xEB009487EB009387, 0xEB009687EB009587, 0xEB009887EB009787, 0xEB009A87EB009987, 0xEB009C87EB009B87, 
0xEB009E87EB009D87, 0xEB00A087EB009F87, 0xEB00A287EB00A187, 0xEB00A487EB00A387, 0xEB00A687EB00A587, 0xEB00A887EB00A787, 0xEB00AA87EB00A987, 0xEB00AC87EB00AB87, 
0xEB00AE87EB00AD87, 0xEB00B087EB00AF87, 0xEB00B287EB00B187, 0xEB00B487EB00B387, 0xEB00B687EB00B587, 0xEB00B887EB00B787, 0xEB00BA87EB00B987, 0xEB00BC87EB00BB87, 
0xEB00BE87EB00BD87, 0xEB008088EB00BF87, 0xEB008288EB008188, 0xEB008488EB008388, 0xEB008688EB008588, 0xEB008888EB008788, 0xEB008A88EB008988, 0xEB008C88EB008B88, 
0xEB008E88EB008D88, 0xEB009088EB008F88, 0xEB009288EB009188, 0xEB009488EB009388, 0xEB009688EB009588, 0xEB009888EB009788, 0xEB009A88EB009988, 0xEB009C88EB009B88, 
0xEB009E88EB009D88, 0xEB00A088EB009F88, 0xEB00A288EB00A188, 0xEB00A488EB00A388, 0xEB00A688EB00A588, 0xEB00A888EB00A788, 0xEB00AA88EB00A988, 0xEB00AC88EB00AB88, 
0xEB00AE88EB00AD88, 0xEB00B088EB00AF88, 0xEB00B288EB00B188, 0xEB00B488EB00B388, 0xEB00B688EB00B588, 0xEB00B888EB00B788, 0xEB00BA88EB00B988, 0xEB00BC88EB00BB88, 
0xEB00BE88EB00BD88, 0xEB008089EB00BF88, 0xEB008289EB008189, 0xEB008489EB008389, 0xEB008689EB008589, 0xEB008889EB008789, 0xEB008A89EB008989, 0xEB008C89EB008B89, 
0xEB008E89EB008D89, 0xEB009089EB008F89, 0xEB009289EB009189, 0xEB009489EB009389, 0xEB009689EB009589, 0xEB009889EB009789, 0xEB009A89EB009989, 0xEB009C89EB009B89, 
0xEB009E89EB009D89, 0xEB00A089EB009F89, 0xEB00A289EB00A189, 0xEB00A489EB00A389, 0xEB00A689EB00A589, 0xEB00A889EB00A789, 0xEB00AA89EB00A989, 0xEB00AC89EB00AB89, 
0xEB00AE89EB00AD89, 0xEB00B089EB00AF89, 0xEB00B289EB00B189, 0xEB00B489EB00B389, 0xEB00B689EB00B589, 0xEB00B889EB00B789, 0xEB00BA89EB00B989, 0xEB00BC89EB00BB89, 
0xEB00BE89EB00BD89, 0xEB00808AEB00BF89, 0xEB00828AEB00818A, 0xEB00848AEB00838A, 0xEB00868AEB00858A, 0xEB00888AEB00878A, 0xEB008A8AEB00898A, 0xEB008C8AEB008B8A, 
0xEB008E8AEB008D8A, 0xEB00908AEB008F8A, 0xEB00928AEB00918A, 0xEB00948AEB00938A, 0xEB00968AEB00958A, 0xEB00988AEB00978A, 0xEB009A8AEB00998A, 0xEB009C8AEB009B8A, 
0xEB009E8AEB009D8A, 0xEB00A08AEB009F8A, 0xEB00A28AEB00A18A, 0xEB00A48AEB00A38A, 0xEB00A68AEB00A58A, 0xEB00A88AEB00A78A, 0xEB00AA8AEB00A98A, 0xEB00AC8AEB00AB8A, 
0xEB00AE8AEB00AD8A, 0xEB00B08AEB00AF8A, 0xEB00B28AEB00B18A, 0xEB00B48AEB00B38A, 0xEB00B68AEB00B58A, 0xEB00B88AEB00B78A, 0xEB00BA8AEB00B98A, 0xEB00BC8AEB00BB8A, 
0xEB00BE8AEB00BD8A, 0xEB00808BEB00BF8A, 0xEB00828BEB00818B, 0xEB00848BEB00838B, 0xEB00868BEB00858B, 0xEB00888BEB00878B, 0xEB008A8BEB00898B, 0xEB008C8BEB008B8B, 
0xEB008E8BEB008D8B, 0xEB00908BEB008F8B, 0xEB00928BEB00918B, 0xEB00948BEB00938B, 0xEB00968BEB00958B, 0xEB00988BEB00978B, 0xEB009A8BEB00998B, 0xEB009C8BEB009B8B, 
0xEB009E8BEB009D8B, 0xEB00A08BEB009F8B, 0xEB00A28BEB00A18B, 0xEB00A48BEB00A38B, 0xEB00A68BEB00A58B, 0xEB00A88BEB00A78B, 0xEB00AA8BEB00A98B, 0xEB00AC8BEB00AB8B, 
0xEB00AE8BEB00AD8B, 0xEB00B08BEB00AF8B, 0xEB00B28BEB00B18B, 0xEB00B48BEB00B38B, 0xEB00B68BEB00B58B, 0xEB00B88BEB00B78B, 0xEB00BA8BEB00B98B, 0xEB00BC8BEB00BB8B, 
0xEB00BE8BEB00BD8B, 0xEB00808CEB00BF8B, 0xEB00828CEB00818C, 0xEB00848CEB00838C, 0xEB00868CEB00858C, 0xEB00888CEB00878C, 0xEB008A8CEB00898C, 0xEB008C8CEB008B8C, 
0xEB008E8CEB008D8C, 0xEB00908CEB008F8C, 0xEB00928CEB00918C, 0xEB00948CEB00938C, 0xEB00968CEB00958C, 0xEB00988CEB00978C, 0xEB009A8CEB00998C, 0xEB009C8CEB009B8C, 
0xEB009E8CEB009D8C, 0xEB00A08CEB009F8C, 0xEB00A28CEB00A18C, 0xEB00A48CEB00A38C, 0xEB00A68CEB00A58C, 0xEB00A88CEB00A78C, 0xEB00AA8CEB00A98C, 0xEB00AC8CEB00AB8C, 
0xEB00AE8CEB00AD8C, 0xEB00B08CEB00AF8C, 0xEB00B28CEB00B18C, 0xEB00B48CEB00B38C, 0xEB00B68CEB00B58C, 0xEB00B88CEB00B78C, 0xEB00BA8CEB00B98C, 0xEB00BC8CEB00BB8C, 
0xEB00BE8CEB00BD8C, 0xEB00808DEB00BF8C, 0xEB00828DEB00818D, 0xEB00848DEB00838D, 0xEB00868DEB00858D, 0xEB00888DEB00878D, 0xEB008A8DEB00898D, 0xEB008C8DEB008B8D, 
0xEB008E8DEB008D8D, 0xEB00908DEB008F8D, 0xEB00928DEB00918D, 0xEB00948DEB00938D, 0xEB00968DEB00958D, 0xEB00988DEB00978D, 0xEB009A8DEB00998D, 0xEB009C8DEB009B8D, 
0xEB009E8DEB009D8D, 0xEB00A08DEB009F8D, 0xEB00A28DEB00A18D, 0xEB00A48DEB00A38D, 0xEB00A68DEB00A58D, 0xEB00A88DEB00A78D, 0xEB00AA8DEB00A98D, 0xEB00AC8DEB00AB8D, 
0xEB00AE8DEB00AD8D, 0xEB00B08DEB00AF8D, 0xEB00B28DEB00B18D, 0xEB00B48DEB00B38D, 0xEB00B68DEB00B58D, 0xEB00B88DEB00B78D, 0xEB00BA8DEB00B98D, 0xEB00BC8DEB00BB8D, 
0xEB00BE8DEB00BD8D, 0xEB00808EEB00BF8D, 0xEB00828EEB00818E, 0xEB00848EEB00838E, 0xEB00868EEB00858E, 0xEB00888EEB00878E, 0xEB008A8EEB00898E, 0xEB008C8EEB008B8E, 
0xEB008E8EEB008D8E, 0xEB00908EEB008F8E, 0xEB00928EEB00918E, 0xEB00948EEB00938E, 0xEB00968EEB00958E, 0xEB00988EEB00978E, 0xEB009A8EEB00998E, 0xEB009C8EEB009B8E, 
0xEB009E8EEB009D8E, 0xEB00A08EEB009F8E, 0xEB00A28EEB00A18E, 0xEB00A48EEB00A38E, 0xEB00A68EEB00A58E, 0xEB00A88EEB00A78E, 0xEB00AA8EEB00A98E, 0xEB00AC8EEB00AB8E, 
0xEB00AE8EEB00AD8E, 0xEB00B08EEB00AF8E, 0xEB00B28EEB00B18E, 0xEB00B48EEB00B38E, 0xEB00B68EEB00B58E, 0xEB00B88EEB00B78E, 0xEB00BA8EEB00B98E, 0xEB00BC8EEB00BB8E, 
0xEB00BE8EEB00BD8E, 0xEB00808FEB00BF8E, 0xEB00828FEB00818F, 0xEB00848FEB00838F, 0xEB00868FEB00858F, 0xEB00888FEB00878F, 0xEB008A8FEB00898F, 0xEB008C8FEB008B8F, 
0xEB008E8FEB008D8F, 0xEB00908FEB008F8F, 0xEB00928FEB00918F, 0xEB00948FEB00938F, 0xEB00968FEB00958F, 0xEB00988FEB00978F, 0xEB009A8FEB00998F, 0xEB009C8FEB009B8F, 
0xEB009E8FEB009D8F, 0xEB00A08FEB009F8F, 0xEB00A28FEB00A18F, 0xEB00A48FEB00A38F, 0xEB00A68FEB00A58F, 0xEB00A88FEB00A78F, 0xEB00AA8FEB00A98F, 0xEB00AC8FEB00AB8F, 
0xEB00AE8FEB00AD8F, 0xEB00B08FEB00AF8F, 0xEB00B28FEB00B18F, 0xEB00B48FEB00B38F, 0xEB00B68FEB00B58F, 0xEB00B88FEB00B78F, 0xEB00BA8FEB00B98F, 0xEB00BC8FEB00BB8F, 
0xEB00BE8FEB00BD8F, 0xEB008090EB00BF8F, 0xEB008290EB008190, 0xEB008490EB008390, 0xEB008690EB008590, 0xEB008890EB008790, 0xEB008A90EB008990, 0xEB008C90EB008B90, 
0xEB008E90EB008D90, 0xEB009090EB008F90, 0xEB009290EB009190, 0xEB009490EB009390, 0xEB009690EB009590, 0xEB009890EB009790, 0xEB009A90EB009990, 0xEB009C90EB009B90, 
0xEB009E90EB009D90, 0xEB00A090EB009F90, 0xEB00A290EB00A190, 0xEB00A490EB00A390, 0xEB00A690EB00A590, 0xEB00A890EB00A790, 0xEB00AA90EB00A990, 0xEB00AC90EB00AB90, 
0xEB00AE90EB00AD90, 0xEB00B090EB00AF90, 0xEB00B290EB00B190, 0xEB00B490EB00B390, 0xEB00B690EB00B590, 0xEB00B890EB00B790, 0xEB00BA90EB00B990, 0xEB00BC90EB00BB90, 
0xEB00BE90EB00BD90, 0xEB008091EB00BF90, 0xEB008291EB008191, 0xEB008491EB008391, 0xEB008691EB008591, 0xEB008891EB008791, 0xEB008A91EB008991, 0xEB008C91EB008B91, 
0xEB008E91EB008D91, 0xEB009091EB008F91, 0xEB009291EB009191, 0xEB009491EB009391, 0xEB009691EB009591, 0xEB009891EB009791, 0xEB009A91EB009991, 0xEB009C91EB009B91, 
0xEB009E91EB009D91, 0xEB00A091EB009F91, 0xEB00A291EB00A191, 0xEB00A491EB00A391, 0xEB00A691EB00A591, 0xEB00A891EB00A791, 0xEB00AA91EB00A991, 0xEB00AC91EB00AB91, 
0xEB00AE91EB00AD91, 0xEB00B091EB00AF91, 0xEB00B291EB00B191, 0xEB00B491EB00B391, 0xEB00B691EB00B591, 0xEB00B891EB00B791, 0xEB00BA91EB00B991, 0xEB00BC91EB00BB91, 
0xEB00BE91EB00BD91, 0xEB008092EB00BF91, 0xEB008292EB008192, 0xEB008492EB008392, 0xEB008692EB008592, 0xEB008892EB008792, 0xEB008A92EB008992, 0xEB008C92EB008B92, 
0xEB008E92EB008D92, 0xEB009092EB008F92, 0xEB009292EB009192, 0xEB009492EB009392, 0xEB009692EB009592, 0xEB009892EB009792, 0xEB009A92EB009992, 0xEB009C92EB009B92, 
0xEB009E92EB009D92, 0xEB00A092EB009F92, 0xEB00A292EB00A192, 0xEB00A492EB00A392, 0xEB00A692EB00A592, 0xEB00A892EB00A792, 0xEB00AA92EB00A992, 0xEB00AC92EB00AB92, 
0xEB00AE92EB00AD92, 0xEB00B092EB00AF92, 0xEB00B292EB00B192, 0xEB00B492EB00B392, 0xEB00B692EB00B592, 0xEB00B892EB00B792, 0xEB00BA92EB00B992, 0xEB00BC92EB00BB92, 
0xEB00BE92EB00BD92, 0xEB008093EB00BF92, 0xEB008293EB008193, 0xEB008493EB008393, 0xEB008693EB008593, 0xEB008893EB008793, 0xEB008A93EB008993, 0xEB008C93EB008B93, 
0xEB008E93EB008D93, 0xEB009093EB008F93, 0xEB009293EB009193, 0xEB009493EB009393, 0xEB009693EB009593, 0xEB009893EB009793, 0xEB009A93EB009993, 0xEB009C93EB009B93, 
0xEB009E93EB009D93, 0xEB00A093EB009F93, 0xEB00A293EB00A193, 0xEB00A493EB00A393, 0xEB00A693EB00A593, 0xEB00A893EB00A793, 0xEB00AA93EB00A993, 0xEB00AC93EB00AB93, 
0xEB00AE93EB00AD93, 0xEB00B093EB00AF93, 0xEB00B293EB00B193, 0xEB00B493EB00B393, 0xEB00B693EB00B593, 0xEB00B893EB00B793, 0xEB00BA93EB00B993, 0xEB00BC93EB00BB93, 
0xEB00BE93EB00BD93, 0xEB008094EB00BF93, 0xEB008294EB008194, 0xEB008494EB008394, 0xEB008694EB008594, 0xEB008894EB008794, 0xEB008A94EB008994, 0xEB008C94EB008B94, 
0xEB008E94EB008D94, 0xEB009094EB008F94, 0xEB009294EB009194, 0xEB009494EB009394, 0xEB009694EB009594, 0xEB009894EB009794, 0xEB009A94EB009994, 0xEB009C94EB009B94, 
0xEB009E94EB009D94, 0xEB00A094EB009F94, 0xEB00A294EB00A194, 0xEB00A494EB00A394, 0xEB00A694EB00A594, 0xEB00A894EB00A794, 0xEB00AA94EB00A994, 0xEB00AC94EB00AB94, 
0xEB00AE94EB00AD94, 0xEB00B094EB00AF94, 0xEB00B294EB00B194, 0xEB00B494EB00B394, 0xEB00B694EB00B594, 0xEB00B894EB00B794, 0xEB00BA94EB00B994, 0xEB00BC94EB00BB94, 
0xEB00BE94EB00BD94, 0xEB008095EB00BF94, 0xEB008295EB008195, 0xEB008495EB008395, 0xEB008695EB008595, 0xEB008895EB008795, 0xEB008A95EB008995, 0xEB008C95EB008B95, 
0xEB008E95EB008D95, 0xEB009095EB008F95, 0xEB009295EB009195, 0xEB009495EB009395, 0xEB009695EB009595, 0xEB009895EB009795, 0xEB009A95EB009995, 0xEB009C95EB009B95, 
0xEB009E95EB009D95, 0xEB00A095EB009F95, 0xEB00A295EB00A195, 0xEB00A495EB00A395, 0xEB00A695EB00A595, 0xEB00A895EB00A795, 0xEB00AA95EB00A995, 0xEB00AC95EB00AB95, 
0xEB00AE95EB00AD95, 0xEB00B095EB00AF95, 0xEB00B295EB00B195, 0xEB00B495EB00B395, 0xEB00B695EB00B595, 0xEB00B895EB00B795, 0xEB00BA95EB00B995, 0xEB00BC95EB00BB95, 
0xEB00BE95EB00BD95, 0xEB008096EB00BF95, 0xEB008296EB008196, 0xEB008496EB008396, 0xEB008696EB008596, 0xEB008896EB008796, 0xEB008A96EB008996, 0xEB008C96EB008B96, 
0xEB008E96EB008D96, 0xEB009096EB008F96, 0xEB009296EB009196, 0xEB009496EB009396, 0xEB009696EB009596, 0xEB009896EB009796, 0xEB009A96EB009996, 0xEB009C96EB009B96, 
0xEB009E96EB009D96, 0xEB00A096EB009F96, 0xEB00A296EB00A196, 0xEB00A496EB00A396, 0xEB00A696EB00A596, 0xEB00A896EB00A796, 0xEB00AA96EB00A996, 0xEB00AC96EB00AB96, 
0xEB00AE96EB00AD96, 0xEB00B096EB00AF96, 0xEB00B296EB00B196, 0xEB00B496EB00B396, 0xEB00B696EB00B596, 0xEB00B896EB00B796, 0xEB00BA96EB00B996, 0xEB00BC96EB00BB96, 
0xEB00BE96EB00BD96, 0xEB008097EB00BF96, 0xEB008297EB008197, 0xEB008497EB008397, 0xEB008697EB008597, 0xEB008897EB008797, 0xEB008A97EB008997, 0xEB008C97EB008B97, 
0xEB008E97EB008D97, 0xEB009097EB008F97, 0xEB009297EB009197, 0xEB009497EB009397, 0xEB009697EB009597, 0xEB009897EB009797, 0xEB009A97EB009997, 0xEB009C97EB009B97, 
0xEB009E97EB009D97, 0xEB00A097EB009F97, 0xEB00A297EB00A197, 0xEB00A497EB00A397, 0xEB00A697EB00A597, 0xEB00A897EB00A797, 0xEB00AA97EB00A997, 0xEB00AC97EB00AB97, 
0xEB00AE97EB00AD97, 0xEB00B097EB00AF97, 0xEB00B297EB00B197, 0xEB00B497EB00B397, 0xEB00B697EB00B597, 0xEB00B897EB00B797, 0xEB00BA97EB00B997, 0xEB00BC97EB00BB97, 
0xEB00BE97EB00BD97, 0xEB008098EB00BF97, 0xEB008298EB008198, 0xEB008498EB008398, 0xEB008698EB008598, 0xEB008898EB008798, 0xEB008A98EB008998, 0xEB008C98EB008B98, 
0xEB008E98EB008D98, 0xEB009098EB008F98, 0xEB009298EB009198, 0xEB009498EB009398, 0xEB009698EB009598, 0xEB009898EB009798, 0xEB009A98EB009998, 0xEB009C98EB009B98, 
0xEB009E98EB009D98, 0xEB00A098EB009F98, 0xEB00A298EB00A198, 0xEB00A498EB00A398, 0xEB00A698EB00A598, 0xEB00A898EB00A798, 0xEB00AA98EB00A998, 0xEB00AC98EB00AB98, 
0xEB00AE98EB00AD98, 0xEB00B098EB00AF98, 0xEB00B298EB00B198, 0xEB00B498EB00B398, 0xEB00B698EB00B598, 0xEB00B898EB00B798, 0xEB00BA98EB00B998, 0xEB00BC98EB00BB98, 
0xEB00BE98EB00BD98, 0xEB008099EB00BF98, 0xEB008299EB008199, 0xEB008499EB008399, 0xEB008699EB008599, 0xEB008899EB008799, 0xEB008A99EB008999, 0xEB008C99EB008B99, 
0xEB008E99EB008D99, 0xEB009099EB008F99, 0xEB009299EB009199, 0xEB009499EB009399, 0xEB009699EB009599, 0xEB009899EB009799, 0xEB009A99EB009999, 0xEB009C99EB009B99, 
0xEB009E99EB009D99, 0xEB00A099EB009F99, 0xEB00A299EB00A199, 0xEB00A499EB00A399, 0xEB00A699EB00A599, 0xEB00A899EB00A799, 0xEB00AA99EB00A999, 0xEB00AC99EB00AB99, 
0xEB00AE99EB00AD99, 0xEB00B099EB00AF99, 0xEB00B299EB00B199, 0xEB00B499EB00B399, 0xEB00B699EB00B599, 0xEB00B899EB00B799, 0xEB00BA99EB00B999, 0xEB00BC99EB00BB99, 
0xEB00BE99EB00BD99, 0xEB00809AEB00BF99, 0xEB00829AEB00819A, 0xEB00849AEB00839A, 0xEB00869AEB00859A, 0xEB00889AEB00879A, 0xEB008A9AEB00899A, 0xEB008C9AEB008B9A, 
0xEB008E9AEB008D9A, 0xEB00909AEB008F9A, 0xEB00929AEB00919A, 0xEB00949AEB00939A, 0xEB00969AEB00959A, 0xEB00989AEB00979A, 0xEB009A9AEB00999A, 0xEB009C9AEB009B9A, 
0xEB009E9AEB009D9A, 0xEB00A09AEB009F9A, 0xEB00A29AEB00A19A, 0xEB00A49AEB00A39A, 0xEB00A69AEB00A59A, 0xEB00A89AEB00A79A, 0xEB00AA9AEB00A99A, 0xEB00AC9AEB00AB9A, 
0xEB00AE9AEB00AD9A, 0xEB00B09AEB00AF9A, 0xEB00B29AEB00B19A, 0xEB00B49AEB00B39A, 0xEB00B69AEB00B59A, 0xEB00B89AEB00B79A, 0xEB00BA9AEB00B99A, 0xEB00BC9AEB00BB9A, 
0xEB00BE9AEB00BD9A, 0xEB00809BEB00BF9A, 0xEB00829BEB00819B, 0xEB00849BEB00839B, 0xEB00869BEB00859B, 0xEB00889BEB00879B, 0xEB008A9BEB00899B, 0xEB008C9BEB008B9B, 
0xEB008E9BEB008D9B, 0xEB00909BEB008F9B, 0xEB00929BEB00919B, 0xEB00949BEB00939B, 0xEB00969BEB00959B, 0xEB00989BEB00979B, 0xEB009A9BEB00999B, 0xEB009C9BEB009B9B, 
0xEB009E9BEB009D9B, 0xEB00A09BEB009F9B, 0xEB00A29BEB00A19B, 0xEB00A49BEB00A39B, 0xEB00A69BEB00A59B, 0xEB00A89BEB00A79B, 0xEB00AA9BEB00A99B, 0xEB00AC9BEB00AB9B, 
0xEB00AE9BEB00AD9B, 0xEB00B09BEB00AF9B, 0xEB00B29BEB00B19B, 0xEB00B49BEB00B39B, 0xEB00B69BEB00B59B, 0xEB00B89BEB00B79B, 0xEB00BA9BEB00B99B, 0xEB00BC9BEB00BB9B, 
0xEB00BE9BEB00BD9B, 0xEB00809CEB00BF9B, 0xEB00829CEB00819C, 0xEB00849CEB00839C, 0xEB00869CEB00859C, 0xEB00889CEB00879C, 0xEB008A9CEB00899C, 0xEB008C9CEB008B9C, 
0xEB008E9CEB008D9C, 0xEB00909CEB008F9C, 0xEB00929CEB00919C, 0xEB00949CEB00939C, 0xEB00969CEB00959C, 0xEB00989CEB00979C, 0xEB009A9CEB00999C, 0xEB009C9CEB009B9C, 
0xEB009E9CEB009D9C, 0xEB00A09CEB009F9C, 0xEB00A29CEB00A19C, 0xEB00A49CEB00A39C, 0xEB00A69CEB00A59C, 0xEB00A89CEB00A79C, 0xEB00AA9CEB00A99C, 0xEB00AC9CEB00AB9C, 
0xEB00AE9CEB00AD9C, 0xEB00B09CEB00AF9C, 0xEB00B29CEB00B19C, 0xEB00B49CEB00B39C, 0xEB00B69CEB00B59C, 0xEB00B89CEB00B79C, 0xEB00BA9CEB00B99C, 0xEB00BC9CEB00BB9C, 
0xEB00BE9CEB00BD9C, 0xEB00809DEB00BF9C, 0xEB00829DEB00819D, 0xEB00849DEB00839D, 0xEB00869DEB00859D, 0xEB00889DEB00879D, 0xEB008A9DEB00899D, 0xEB008C9DEB008B9D, 
0xEB008E9DEB008D9D, 0xEB00909DEB008F9D, 0xEB00929DEB00919D, 0xEB00949DEB00939D, 0xEB00969DEB00959D, 0xEB00989DEB00979D, 0xEB009A9DEB00999D, 0xEB009C9DEB009B9D, 
0xEB009E9DEB009D9D, 0xEB00A09DEB009F9D, 0xEB00A29DEB00A19D, 0xEB00A49DEB00A39D, 0xEB00A69DEB00A59D, 0xEB00A89DEB00A79D, 0xEB00AA9DEB00A99D, 0xEB00AC9DEB00AB9D, 
0xEB00AE9DEB00AD9D, 0xEB00B09DEB00AF9D, 0xEB00B29DEB00B19D, 0xEB00B49DEB00B39D, 0xEB00B69DEB00B59D, 0xEB00B89DEB00B79D, 0xEB00BA9DEB00B99D, 0xEB00BC9DEB00BB9D, 
0xEB00BE9DEB00BD9D, 0xEB00809EEB00BF9D, 0xEB00829EEB00819E, 0xEB00849EEB00839E, 0xEB00869EEB00859E, 0xEB00889EEB00879E, 0xEB008A9EEB00899E, 0xEB008C9EEB008B9E, 
0xEB008E9EEB008D9E, 0xEB00909EEB008F9E, 0xEB00929EEB00919E, 0xEB00949EEB00939E, 0xEB00969EEB00959E, 0xEB00989EEB00979E, 0xEB009A9EEB00999E, 0xEB009C9EEB009B9E, 
0xEB009E9EEB009D9E, 0xEB00A09EEB009F9E, 0xEB00A29EEB00A19E, 0xEB00A49EEB00A39E, 0xEB00A69EEB00A59E, 0xEB00A89EEB00A79E, 0xEB00AA9EEB00A99E, 0xEB00AC9EEB00AB9E, 
0xEB00AE9EEB00AD9E, 0xEB00B09EEB00AF9E, 0xEB00B29EEB00B19E, 0xEB00B49EEB00B39E, 0xEB00B69EEB00B59E, 0xEB00B89EEB00B79E, 0xEB00BA9EEB00B99E, 0xEB00BC9EEB00BB9E, 
0xEB00BE9EEB00BD9E, 0xEB00809FEB00BF9E, 0xEB00829FEB00819F, 0xEB00849FEB00839F, 0xEB00869FEB00859F, 0xEB00889FEB00879F, 0xEB008A9FEB00899F, 0xEB008C9FEB008B9F, 
0xEB008E9FEB008D9F, 0xEB00909FEB008F9F, 0xEB00929FEB00919F, 0xEB00949FEB00939F, 0xEB00969FEB00959F, 0xEB00989FEB00979F, 0xEB009A9FEB00999F, 0xEB009C9FEB009B9F, 
0xEB009E9FEB009D9F, 0xEB00A09FEB009F9F, 0xEB00A29FEB00A19F, 0xEB00A49FEB00A39F, 0xEB00A69FEB00A59F, 0xEB00A89FEB00A79F, 0xEB00AA9FEB00A99F, 0xEB00AC9FEB00AB9F, 
0xEB00AE9FEB00AD9F, 0xEB00B09FEB00AF9F, 0xEB00B29FEB00B19F, 0xEB00B49FEB00B39F, 0xEB00B69FEB00B59F, 0xEB00B89FEB00B79F, 0xEB00BA9FEB00B99F, 0xEB00BC9FEB00BB9F, 
0xEB00BE9FEB00BD9F, 0xEB0080A0EB00BF9F, 0xEB0082A0EB0081A0, 0xEB0084A0EB0083A0, 0xEB0086A0EB0085A0, 0xEB0088A0EB0087A0, 0xEB008AA0EB0089A0, 0xEB008CA0EB008BA0, 
0xEB008EA0EB008DA0, 0xEB0090A0EB008FA0, 0xEB0092A0EB0091A0, 0xEB0094A0EB0093A0, 0xEB0096A0EB0095A0, 0xEB0098A0EB0097A0, 0xEB009AA0EB0099A0, 0xEB009CA0EB009BA0, 
0xEB009EA0EB009DA0, 0xEB00A0A0EB009FA0, 0xEB00A2A0EB00A1A0, 0xEB00A4A0EB00A3A0, 0xEB00A6A0EB00A5A0, 0xEB00A8A0EB00A7A0, 0xEB00AAA0EB00A9A0, 0xEB00ACA0EB00ABA0, 
0xEB00AEA0EB00ADA0, 0xEB00B0A0EB00AFA0, 0xEB00B2A0EB00B1A0, 0xEB00B4A0EB00B3A0, 0xEB00B6A0EB00B5A0, 0xEB00B8A0EB00B7A0, 0xEB00BAA0EB00B9A0, 0xEB00BCA0EB00BBA0, 
0xEB00BEA0EB00BDA0, 0xEB0080A1EB00BFA0, 0xEB0082A1EB0081A1, 0xEB0084A1EB0083A1, 0xEB0086A1EB0085A1, 0xEB0088A1EB0087A1, 0xEB008AA1EB0089A1, 0xEB008CA1EB008BA1, 
0xEB008EA1EB008DA1, 0xEB0090A1EB008FA1, 0xEB0092A1EB0091A1, 0xEB0094A1EB0093A1, 0xEB0096A1EB0095A1, 0xEB0098A1EB0097A1, 0xEB009AA1EB0099A1, 0xEB009CA1EB009BA1, 
0xEB009EA1EB009DA1, 0xEB00A0A1EB009FA1, 0xEB00A2A1EB00A1A1, 0xEB00A4A1EB00A3A1, 0xEB00A6A1EB00A5A1, 0xEB00A8A1EB00A7A1, 0xEB00AAA1EB00A9A1, 0xEB00ACA1EB00ABA1, 
0xEB00AEA1EB00ADA1, 0xEB00B0A1EB00AFA1, 0xEB00B2A1EB00B1A1, 0xEB00B4A1EB00B3A1, 0xEB00B6A1EB00B5A1, 0xEB00B8A1EB00B7A1, 0xEB00BAA1EB00B9A1, 0xEB00BCA1EB00BBA1, 
0xEB00BEA1EB00BDA1, 0xEB0080A2EB00BFA1, 0xEB0082A2EB0081A2, 0xEB0084A2EB0083A2, 0xEB0086A2EB0085A2, 0xEB0088A2EB0087A2, 0xEB008AA2EB0089A2, 0xEB008CA2EB008BA2, 
0xEB008EA2EB008DA2, 0xEB0090A2EB008FA2, 0xEB0092A2EB0091A2, 0xEB0094A2EB0093A2, 0xEB0096A2EB0095A2, 0xEB0098A2EB0097A2, 0xEB009AA2EB0099A2, 0xEB009CA2EB009BA2, 
0xEB009EA2EB009DA2, 0xEB00A0A2EB009FA2, 0xEB00A2A2EB00A1A2, 0xEB00A4A2EB00A3A2, 0xEB00A6A2EB00A5A2, 0xEB00A8A2EB00A7A2, 0xEB00AAA2EB00A9A2, 0xEB00ACA2EB00ABA2, 
0xEB00AEA2EB00ADA2, 0xEB00B0A2EB00AFA2, 0xEB00B2A2EB00B1A2, 0xEB00B4A2EB00B3A2, 0xEB00B6A2EB00B5A2, 0xEB00B8A2EB00B7A2, 0xEB00BAA2EB00B9A2, 0xEB00BCA2EB00BBA2, 
0xEB00BEA2EB00BDA2, 0xEB0080A3EB00BFA2, 0xEB0082A3EB0081A3, 0xEB0084A3EB0083A3, 0xEB0086A3EB0085A3, 0xEB0088A3EB0087A3, 0xEB008AA3EB0089A3, 0xEB008CA3EB008BA3, 
0xEB008EA3EB008DA3, 0xEB0090A3EB008FA3, 0xEB0092A3EB0091A3, 0xEB0094A3EB0093A3, 0xEB0096A3EB0095A3, 0xEB0098A3EB0097A3, 0xEB009AA3EB0099A3, 0xEB009CA3EB009BA3, 
0xEB009EA3EB009DA3, 0xEB00A0A3EB009FA3, 0xEB00A2A3EB00A1A3, 0xEB00A4A3EB00A3A3, 0xEB00A6A3EB00A5A3, 0xEB00A8A3EB00A7A3, 0xEB00AAA3EB00A9A3, 0xEB00ACA3EB00ABA3, 
0xEB00AEA3EB00ADA3, 0xEB00B0A3EB00AFA3, 0xEB00B2A3EB00B1A3, 0xEB00B4A3EB00B3A3, 0xEB00B6A3EB00B5A3, 0xEB00B8A3EB00B7A3, 0xEB00BAA3EB00B9A3, 0xEB00BCA3EB00BBA3, 
0xEB00BEA3EB00BDA3, 0xEB0080A4EB00BFA3, 0xEB0082A4EB0081A4, 0xEB0084A4EB0083A4, 0xEB0086A4EB0085A4, 0xEB0088A4EB0087A4, 0xEB008AA4EB0089A4, 0xEB008CA4EB008BA4, 
0xEB008EA4EB008DA4, 0xEB0090A4EB008FA4, 0xEB0092A4EB0091A4, 0xEB0094A4EB0093A4, 0xEB0096A4EB0095A4, 0xEB0098A4EB0097A4, 0xEB009AA4EB0099A4, 0xEB009CA4EB009BA4, 
0xEB009EA4EB009DA4, 0xEB00A0A4EB009FA4, 0xEB00A2A4EB00A1A4, 0xEB00A4A4EB00A3A4, 0xEB00A6A4EB00A5A4, 0xEB00A8A4EB00A7A4, 0xEB00AAA4EB00A9A4, 0xEB00ACA4EB00ABA4, 
0xEB00AEA4EB00ADA4, 0xEB00B0A4EB00AFA4, 0xEB00B2A4EB00B1A4, 0xEB00B4A4EB00B3A4, 0xEB00B6A4EB00B5A4, 0xEB00B8A4EB00B7A4, 0xEB00BAA4EB00B9A4, 0xEB00BCA4EB00BBA4, 
0xEB00BEA4EB00BDA4, 0xEB0080A5EB00BFA4, 0xEB0082A5EB0081A5, 0xEB0084A5EB0083A5, 0xEB0086A5EB0085A5, 0xEB0088A5EB0087A5, 0xEB008AA5EB0089A5, 0xEB008CA5EB008BA5, 
0xEB008EA5EB008DA5, 0xEB0090A5EB008FA5, 0xEB0092A5EB0091A5, 0xEB0094A5EB0093A5, 0xEB0096A5EB0095A5, 0xEB0098A5EB0097A5, 0xEB009AA5EB0099A5, 0xEB009CA5EB009BA5, 
0xEB009EA5EB009DA5, 0xEB00A0A5EB009FA5, 0xEB00A2A5EB00A1A5, 0xEB00A4A5EB00A3A5, 0xEB00A6A5EB00A5A5, 0xEB00A8A5EB00A7A5, 0xEB00AAA5EB00A9A5, 0xEB00ACA5EB00ABA5, 
0xEB00AEA5EB00ADA5, 0xEB00B0A5EB00AFA5, 0xEB00B2A5EB00B1A5, 0xEB00B4A5EB00B3A5, 0xEB00B6A5EB00B5A5, 0xEB00B8A5EB00B7A5, 0xEB00BAA5EB00B9A5, 0xEB00BCA5EB00BBA5, 
0xEB00BEA5EB00BDA5, 0xEB0080A6EB00BFA5, 0xEB0082A6EB0081A6, 0xEB0084A6EB0083A6, 0xEB0086A6EB0085A6, 0xEB0088A6EB0087A6, 0xEB008AA6EB0089A6, 0xEB008CA6EB008BA6, 
0xEB008EA6EB008DA6, 0xEB0090A6EB008FA6, 0xEB0092A6EB0091A6, 0xEB0094A6EB0093A6, 0xEB0096A6EB0095A6, 0xEB0098A6EB0097A6, 0xEB009AA6EB0099A6, 0xEB009CA6EB009BA6, 
0xEB009EA6EB009DA6, 0xEB00A0A6EB009FA6, 0xEB00A2A6EB00A1A6, 0xEB00A4A6EB00A3A6, 0xEB00A6A6EB00A5A6, 0xEB00A8A6EB00A7A6, 0xEB00AAA6EB00A9A6, 0xEB00ACA6EB00ABA6, 
0xEB00AEA6EB00ADA6, 0xEB00B0A6EB00AFA6, 0xEB00B2A6EB00B1A6, 0xEB00B4A6EB00B3A6, 0xEB00B6A6EB00B5A6, 0xEB00B8A6EB00B7A6, 0xEB00BAA6EB00B9A6, 0xEB00BCA6EB00BBA6, 
0xEB00BEA6EB00BDA6, 0xEB0080A7EB00BFA6, 0xEB0082A7EB0081A7, 0xEB0084A7EB0083A7, 0xEB0086A7EB0085A7, 0xEB0088A7EB0087A7, 0xEB008AA7EB0089A7, 0xEB008CA7EB008BA7, 
0xEB008EA7EB008DA7, 0xEB0090A7EB008FA7, 0xEB0092A7EB0091A7, 0xEB0094A7EB0093A7, 0xEB0096A7EB0095A7, 0xEB0098A7EB0097A7, 0xEB009AA7EB0099A7, 0xEB009CA7EB009BA7, 
0xEB009EA7EB009DA7, 0xEB00A0A7EB009FA7, 0xEB00A2A7EB00A1A7, 0xEB00A4A7EB00A3A7, 0xEB00A6A7EB00A5A7, 0xEB00A8A7EB00A7A7, 0xEB00AAA7EB00A9A7, 0xEB00ACA7EB00ABA7, 
0xEB00AEA7EB00ADA7, 0xEB00B0A7EB00AFA7, 0xEB00B2A7EB00B1A7, 0xEB00B4A7EB00B3A7, 0xEB00B6A7EB00B5A7, 0xEB00B8A7EB00B7A7, 0xEB00BAA7EB00B9A7, 0xEB00BCA7EB00BBA7, 
0xEB00BEA7EB00BDA7, 0xEB0080A8EB00BFA7, 0xEB0082A8EB0081A8, 0xEB0084A8EB0083A8, 0xEB0086A8EB0085A8, 0xEB0088A8EB0087A8, 0xEB008AA8EB0089A8, 0xEB008CA8EB008BA8, 
0xEB008EA8EB008DA8, 0xEB0090A8EB008FA8, 0xEB0092A8EB0091A8, 0xEB0094A8EB0093A8, 0xEB0096A8EB0095A8, 0xEB0098A8EB0097A8, 0xEB009AA8EB0099A8, 0xEB009CA8EB009BA8, 
0xEB009EA8EB009DA8, 0xEB00A0A8EB009FA8, 0xEB00A2A8EB00A1A8, 0xEB00A4A8EB00A3A8, 0xEB00A6A8EB00A5A8, 0xEB00A8A8EB00A7A8, 0xEB00AAA8EB00A9A8, 0xEB00ACA8EB00ABA8, 
0xEB00AEA8EB00ADA8, 0xEB00B0A8EB00AFA8, 0xEB00B2A8EB00B1A8, 0xEB00B4A8EB00B3A8, 0xEB00B6A8EB00B5A8, 0xEB00B8A8EB00B7A8, 0xEB00BAA8EB00B9A8, 0xEB00BCA8EB00BBA8, 
0xEB00BEA8EB00BDA8, 0xEB0080A9EB00BFA8, 0xEB0082A9EB0081A9, 0xEB0084A9EB0083A9, 0xEB0086A9EB0085A9, 0xEB0088A9EB0087A9, 0xEB008AA9EB0089A9, 0xEB008CA9EB008BA9, 
0xEB008EA9EB008DA9, 0xEB0090A9EB008FA9, 0xEB0092A9EB0091A9, 0xEB0094A9EB0093A9, 0xEB0096A9EB0095A9, 0xEB0098A9EB0097A9, 0xEB009AA9EB0099A9, 0xEB009CA9EB009BA9, 
0xEB009EA9EB009DA9, 0xEB00A0A9EB009FA9, 0xEB00A2A9EB00A1A9, 0xEB00A4A9EB00A3A9, 0xEB00A6A9EB00A5A9, 0xEB00A8A9EB00A7A9, 0xEB00AAA9EB00A9A9, 0xEB00ACA9EB00ABA9, 
0xEB00AEA9EB00ADA9, 0xEB00B0A9EB00AFA9, 0xEB00B2A9EB00B1A9, 0xEB00B4A9EB00B3A9, 0xEB00B6A9EB00B5A9, 0xEB00B8A9EB00B7A9, 0xEB00BAA9EB00B9A9, 0xEB00BCA9EB00BBA9, 
0xEB00BEA9EB00BDA9, 0xEB0080AAEB00BFA9, 0xEB0082AAEB0081AA, 0xEB0084AAEB0083AA, 0xEB0086AAEB0085AA, 0xEB0088AAEB0087AA, 0xEB008AAAEB0089AA, 0xEB008CAAEB008BAA, 
0xEB008EAAEB008DAA, 0xEB0090AAEB008FAA, 0xEB0092AAEB0091AA, 0xEB0094AAEB0093AA, 0xEB0096AAEB0095AA, 0xEB0098AAEB0097AA, 0xEB009AAAEB0099AA, 0xEB009CAAEB009BAA, 
0xEB009EAAEB009DAA, 0xEB00A0AAEB009FAA, 0xEB00A2AAEB00A1AA, 0xEB00A4AAEB00A3AA, 0xEB00A6AAEB00A5AA, 0xEB00A8AAEB00A7AA, 0xEB00AAAAEB00A9AA, 0xEB00ACAAEB00ABAA, 
0xEB00AEAAEB00ADAA, 0xEB00B0AAEB00AFAA, 0xEB00B2AAEB00B1AA, 0xEB00B4AAEB00B3AA, 0xEB00B6AAEB00B5AA, 0xEB00B8AAEB00B7AA, 0xEB00BAAAEB00B9AA, 0xEB00BCAAEB00BBAA, 
0xEB00BEAAEB00BDAA, 0xEB0080ABEB00BFAA, 0xEB0082ABEB0081AB, 0xEB0084ABEB0083AB, 0xEB0086ABEB0085AB, 0xEB0088ABEB0087AB, 0xEB008AABEB0089AB, 0xEB008CABEB008BAB, 
0xEB008EABEB008DAB, 0xEB0090ABEB008FAB, 0xEB0092ABEB0091AB, 0xEB0094ABEB0093AB, 0xEB0096ABEB0095AB, 0xEB0098ABEB0097AB, 0xEB009AABEB0099AB, 0xEB009CABEB009BAB, 
0xEB009EABEB009DAB, 0xEB00A0ABEB009FAB, 0xEB00A2ABEB00A1AB, 0xEB00A4ABEB00A3AB, 0xEB00A6ABEB00A5AB, 0xEB00A8ABEB00A7AB, 0xEB00AAABEB00A9AB, 0xEB00ACABEB00ABAB, 
0xEB00AEABEB00ADAB, 0xEB00B0ABEB00AFAB, 0xEB00B2ABEB00B1AB, 0xEB00B4ABEB00B3AB, 0xEB00B6ABEB00B5AB, 0xEB00B8ABEB00B7AB, 0xEB00BAABEB00B9AB, 0xEB00BCABEB00BBAB, 
0xEB00BEABEB00BDAB, 0xEB0080ACEB00BFAB, 0xEB0082ACEB0081AC, 0xEB0084ACEB0083AC, 0xEB0086ACEB0085AC, 0xEB0088ACEB0087AC, 0xEB008AACEB0089AC, 0xEB008CACEB008BAC, 
0xEB008EACEB008DAC, 0xEB0090ACEB008FAC, 0xEB0092ACEB0091AC, 0xEB0094ACEB0093AC, 0xEB0096ACEB0095AC, 0xEB0098ACEB0097AC, 0xEB009AACEB0099AC, 0xEB009CACEB009BAC, 
0xEB009EACEB009DAC, 0xEB00A0ACEB009FAC, 0xEB00A2ACEB00A1AC, 0xEB00A4ACEB00A3AC, 0xEB00A6ACEB00A5AC, 0xEB00A8ACEB00A7AC, 0xEB00AAACEB00A9AC, 0xEB00ACACEB00ABAC, 
0xEB00AEACEB00ADAC, 0xEB00B0ACEB00AFAC, 0xEB00B2ACEB00B1AC, 0xEB00B4ACEB00B3AC, 0xEB00B6ACEB00B5AC, 0xEB00B8ACEB00B7AC, 0xEB00BAACEB00B9AC, 0xEB00BCACEB00BBAC, 
0xEB00BEACEB00BDAC, 0xEB0080ADEB00BFAC, 0xEB0082ADEB0081AD, 0xEB0084ADEB0083AD, 0xEB0086ADEB0085AD, 0xEB0088ADEB0087AD, 0xEB008AADEB0089AD, 0xEB008CADEB008BAD, 
0xEB008EADEB008DAD, 0xEB0090ADEB008FAD, 0xEB0092ADEB0091AD, 0xEB0094ADEB0093AD, 0xEB0096ADEB0095AD, 0xEB0098ADEB0097AD, 0xEB009AADEB0099AD, 0xEB009CADEB009BAD, 
0xEB009EADEB009DAD, 0xEB00A0ADEB009FAD, 0xEB00A2ADEB00A1AD, 0xEB00A4ADEB00A3AD, 0xEB00A6ADEB00A5AD, 0xEB00A8ADEB00A7AD, 0xEB00AAADEB00A9AD, 0xEB00ACADEB00ABAD, 
0xEB00AEADEB00ADAD, 0xEB00B0ADEB00AFAD, 0xEB00B2ADEB00B1AD, 0xEB00B4ADEB00B3AD, 0xEB00B6ADEB00B5AD, 0xEB00B8ADEB00B7AD, 0xEB00BAADEB00B9AD, 0xEB00BCADEB00BBAD, 
0xEB00BEADEB00BDAD, 0xEB0080AEEB00BFAD, 0xEB0082AEEB0081AE, 0xEB0084AEEB0083AE, 0xEB0086AEEB0085AE, 0xEB0088AEEB0087AE, 0xEB008AAEEB0089AE, 0xEB008CAEEB008BAE, 
0xEB008EAEEB008DAE, 0xEB0090AEEB008FAE, 0xEB0092AEEB0091AE, 0xEB0094AEEB0093AE, 0xEB0096AEEB0095AE, 0xEB0098AEEB0097AE, 0xEB009AAEEB0099AE, 0xEB009CAEEB009BAE, 
0xEB009EAEEB009DAE, 0xEB00A0AEEB009FAE, 0xEB00A2AEEB00A1AE, 0xEB00A4AEEB00A3AE, 0xEB00A6AEEB00A5AE, 0xEB00A8AEEB00A7AE, 0xEB00AAAEEB00A9AE, 0xEB00ACAEEB00ABAE, 
0xEB00AEAEEB00ADAE, 0xEB00B0AEEB00AFAE, 0xEB00B2AEEB00B1AE, 0xEB00B4AEEB00B3AE, 0xEB00B6AEEB00B5AE, 0xEB00B8AEEB00B7AE, 0xEB00BAAEEB00B9AE, 0xEB00BCAEEB00BBAE, 
0xEB00BEAEEB00BDAE, 0xEB0080AFEB00BFAE, 0xEB0082AFEB0081AF, 0xEB0084AFEB0083AF, 0xEB0086AFEB0085AF, 0xEB0088AFEB0087AF, 0xEB008AAFEB0089AF, 0xEB008CAFEB008BAF, 
0xEB008EAFEB008DAF, 0xEB0090AFEB008FAF, 0xEB0092AFEB0091AF, 0xEB0094AFEB0093AF, 0xEB0096AFEB0095AF, 0xEB0098AFEB0097AF, 0xEB009AAFEB0099AF, 0xEB009CAFEB009BAF, 
0xEB009EAFEB009DAF, 0xEB00A0AFEB009FAF, 0xEB00A2AFEB00A1AF, 0xEB00A4AFEB00A3AF, 0xEB00A6AFEB00A5AF, 0xEB00A8AFEB00A7AF, 0xEB00AAAFEB00A9AF, 0xEB00ACAFEB00ABAF, 
0xEB00AEAFEB00ADAF, 0xEB00B0AFEB00AFAF, 0xEB00B2AFEB00B1AF, 0xEB00B4AFEB00B3AF, 0xEB00B6AFEB00B5AF, 0xEB00B8AFEB00B7AF, 0xEB00BAAFEB00B9AF, 0xEB00BCAFEB00BBAF, 
0xEB00BEAFEB00BDAF, 0xEB0080B0EB00BFAF, 0xEB0082B0EB0081B0, 0xEB0084B0EB0083B0, 0xEB0086B0EB0085B0, 0xEB0088B0EB0087B0, 0xEB008AB0EB0089B0, 0xEB008CB0EB008BB0, 
0xEB008EB0EB008DB0, 0xEB0090B0EB008FB0, 0xEB0092B0EB0091B0, 0xEB0094B0EB0093B0, 0xEB0096B0EB0095B0, 0xEB0098B0EB0097B0, 0xEB009AB0EB0099B0, 0xEB009CB0EB009BB0, 
0xEB009EB0EB009DB0, 0xEB00A0B0EB009FB0, 0xEB00A2B0EB00A1B0, 0xEB00A4B0EB00A3B0, 0xEB00A6B0EB00A5B0, 0xEB00A8B0EB00A7B0, 0xEB00AAB0EB00A9B0, 0xEB00ACB0EB00ABB0, 
0xEB00AEB0EB00ADB0, 0xEB00B0B0EB00AFB0, 0xEB00B2B0EB00B1B0, 0xEB00B4B0EB00B3B0, 0xEB00B6B0EB00B5B0, 0xEB00B8B0EB00B7B0, 0xEB00BAB0EB00B9B0, 0xEB00BCB0EB00BBB0, 
0xEB00BEB0EB00BDB0, 0xEB0080B1EB00BFB0, 0xEB0082B1EB0081B1, 0xEB0084B1EB0083B1, 0xEB0086B1EB0085B1, 0xEB0088B1EB0087B1, 0xEB008AB1EB0089B1, 0xEB008CB1EB008BB1, 
0xEB008EB1EB008DB1, 0xEB0090B1EB008FB1, 0xEB0092B1EB0091B1, 0xEB0094B1EB0093B1, 0xEB0096B1EB0095B1, 0xEB0098B1EB0097B1, 0xEB009AB1EB0099B1, 0xEB009CB1EB009BB1, 
0xEB009EB1EB009DB1, 0xEB00A0B1EB009FB1, 0xEB00A2B1EB00A1B1, 0xEB00A4B1EB00A3B1, 0xEB00A6B1EB00A5B1, 0xEB00A8B1EB00A7B1, 0xEB00AAB1EB00A9B1, 0xEB00ACB1EB00ABB1, 
0xEB00AEB1EB00ADB1, 0xEB00B0B1EB00AFB1, 0xEB00B2B1EB00B1B1, 0xEB00B4B1EB00B3B1, 0xEB00B6B1EB00B5B1, 0xEB00B8B1EB00B7B1, 0xEB00BAB1EB00B9B1, 0xEB00BCB1EB00BBB1, 
0xEB00BEB1EB00BDB1, 0xEB0080B2EB00BFB1, 0xEB0082B2EB0081B2, 0xEB0084B2EB0083B2, 0xEB0086B2EB0085B2, 0xEB0088B2EB0087B2, 0xEB008AB2EB0089B2, 0xEB008CB2EB008BB2, 
0xEB008EB2EB008DB2, 0xEB0090B2EB008FB2, 0xEB0092B2EB0091B2, 0xEB0094B2EB0093B2, 0xEB0096B2EB0095B2, 0xEB0098B2EB0097B2, 0xEB009AB2EB0099B2, 0xEB009CB2EB009BB2, 
0xEB009EB2EB009DB2, 0xEB00A0B2EB009FB2, 0xEB00A2B2EB00A1B2, 0xEB00A4B2EB00A3B2, 0xEB00A6B2EB00A5B2, 0xEB00A8B2EB00A7B2, 0xEB00AAB2EB00A9B2, 0xEB00ACB2EB00ABB2, 
0xEB00AEB2EB00ADB2, 0xEB00B0B2EB00AFB2, 0xEB00B2B2EB00B1B2, 0xEB00B4B2EB00B3B2, 0xEB00B6B2EB00B5B2, 0xEB00B8B2EB00B7B2, 0xEB00BAB2EB00B9B2, 0xEB00BCB2EB00BBB2, 
0xEB00BEB2EB00BDB2, 0xEB0080B3EB00BFB2, 0xEB0082B3EB0081B3, 0xEB0084B3EB0083B3, 0xEB0086B3EB0085B3, 0xEB0088B3EB0087B3, 0xEB008AB3EB0089B3, 0xEB008CB3EB008BB3, 
0xEB008EB3EB008DB3, 0xEB0090B3EB008FB3, 0xEB0092B3EB0091B3, 0xEB0094B3EB0093B3, 0xEB0096B3EB0095B3, 0xEB0098B3EB0097B3, 0xEB009AB3EB0099B3, 0xEB009CB3EB009BB3, 
0xEB009EB3EB009DB3, 0xEB00A0B3EB009FB3, 0xEB00A2B3EB00A1B3, 0xEB00A4B3EB00A3B3, 0xEB00A6B3EB00A5B3, 0xEB00A8B3EB00A7B3, 0xEB00AAB3EB00A9B3, 0xEB00ACB3EB00ABB3, 
0xEB00AEB3EB00ADB3, 0xEB00B0B3EB00AFB3, 0xEB00B2B3EB00B1B3, 0xEB00B4B3EB00B3B3, 0xEB00B6B3EB00B5B3, 0xEB00B8B3EB00B7B3, 0xEB00BAB3EB00B9B3, 0xEB00BCB3EB00BBB3, 
0xEB00BEB3EB00BDB3, 0xEB0080B4EB00BFB3, 0xEB0082B4EB0081B4, 0xEB0084B4EB0083B4, 0xEB0086B4EB0085B4, 0xEB0088B4EB0087B4, 0xEB008AB4EB0089B4, 0xEB008CB4EB008BB4, 
0xEB008EB4EB008DB4, 0xEB0090B4EB008FB4, 0xEB0092B4EB0091B4, 0xEB0094B4EB0093B4, 0xEB0096B4EB0095B4, 0xEB0098B4EB0097B4, 0xEB009AB4EB0099B4, 0xEB009CB4EB009BB4, 
0xEB009EB4EB009DB4, 0xEB00A0B4EB009FB4, 0xEB00A2B4EB00A1B4, 0xEB00A4B4EB00A3B4, 0xEB00A6B4EB00A5B4, 0xEB00A8B4EB00A7B4, 0xEB00AAB4EB00A9B4, 0xEB00ACB4EB00ABB4, 
0xEB00AEB4EB00ADB4, 0xEB00B0B4EB00AFB4, 0xEB00B2B4EB00B1B4, 0xEB00B4B4EB00B3B4, 0xEB00B6B4EB00B5B4, 0xEB00B8B4EB00B7B4, 0xEB00BAB4EB00B9B4, 0xEB00BCB4EB00BBB4, 
0xEB00BEB4EB00BDB4, 0xEB0080B5EB00BFB4, 0xEB0082B5EB0081B5, 0xEB0084B5EB0083B5, 0xEB0086B5EB0085B5, 0xEB0088B5EB0087B5, 0xEB008AB5EB0089B5, 0xEB008CB5EB008BB5, 
0xEB008EB5EB008DB5, 0xEB0090B5EB008FB5, 0xEB0092B5EB0091B5, 0xEB0094B5EB0093B5, 0xEB0096B5EB0095B5, 0xEB0098B5EB0097B5, 0xEB009AB5EB0099B5, 0xEB009CB5EB009BB5, 
0xEB009EB5EB009DB5, 0xEB00A0B5EB009FB5, 0xEB00A2B5EB00A1B5, 0xEB00A4B5EB00A3B5, 0xEB00A6B5EB00A5B5, 0xEB00A8B5EB00A7B5, 0xEB00AAB5EB00A9B5, 0xEB00ACB5EB00ABB5, 
0xEB00AEB5EB00ADB5, 0xEB00B0B5EB00AFB5, 0xEB00B2B5EB00B1B5, 0xEB00B4B5EB00B3B5, 0xEB00B6B5EB00B5B5, 0xEB00B8B5EB00B7B5, 0xEB00BAB5EB00B9B5, 0xEB00BCB5EB00BBB5, 
0xEB00BEB5EB00BDB5, 0xEB0080B6EB00BFB5, 0xEB0082B6EB0081B6, 0xEB0084B6EB0083B6, 0xEB0086B6EB0085B6, 0xEB0088B6EB0087B6, 0xEB008AB6EB0089B6, 0xEB008CB6EB008BB6, 
0xEB008EB6EB008DB6, 0xEB0090B6EB008FB6, 0xEB0092B6EB0091B6, 0xEB0094B6EB0093B6, 0xEB0096B6EB0095B6, 0xEB0098B6EB0097B6, 0xEB009AB6EB0099B6, 0xEB009CB6EB009BB6, 
0xEB009EB6EB009DB6, 0xEB00A0B6EB009FB6, 0xEB00A2B6EB00A1B6, 0xEB00A4B6EB00A3B6, 0xEB00A6B6EB00A5B6, 0xEB00A8B6EB00A7B6, 0xEB00AAB6EB00A9B6, 0xEB00ACB6EB00ABB6, 
0xEB00AEB6EB00ADB6, 0xEB00B0B6EB00AFB6, 0xEB00B2B6EB00B1B6, 0xEB00B4B6EB00B3B6, 0xEB00B6B6EB00B5B6, 0xEB00B8B6EB00B7B6, 0xEB00BAB6EB00B9B6, 0xEB00BCB6EB00BBB6, 
0xEB00BEB6EB00BDB6, 0xEB0080B7EB00BFB6, 0xEB0082B7EB0081B7, 0xEB0084B7EB0083B7, 0xEB0086B7EB0085B7, 0xEB0088B7EB0087B7, 0xEB008AB7EB0089B7, 0xEB008CB7EB008BB7, 
0xEB008EB7EB008DB7, 0xEB0090B7EB008FB7, 0xEB0092B7EB0091B7, 0xEB0094B7EB0093B7, 0xEB0096B7EB0095B7, 0xEB0098B7EB0097B7, 0xEB009AB7EB0099B7, 0xEB009CB7EB009BB7, 
0xEB009EB7EB009DB7, 0xEB00A0B7EB009FB7, 0xEB00A2B7EB00A1B7, 0xEB00A4B7EB00A3B7, 0xEB00A6B7EB00A5B7, 0xEB00A8B7EB00A7B7, 0xEB00AAB7EB00A9B7, 0xEB00ACB7EB00ABB7, 
0xEB00AEB7EB00ADB7, 0xEB00B0B7EB00AFB7, 0xEB00B2B7EB00B1B7, 0xEB00B4B7EB00B3B7, 0xEB00B6B7EB00B5B7, 0xEB00B8B7EB00B7B7, 0xEB00BAB7EB00B9B7, 0xEB00BCB7EB00BBB7, 
0xEB00BEB7EB00BDB7, 0xEB0080B8EB00BFB7, 0xEB0082B8EB0081B8, 0xEB0084B8EB0083B8, 0xEB0086B8EB0085B8, 0xEB0088B8EB0087B8, 0xEB008AB8EB0089B8, 0xEB008CB8EB008BB8, 
0xEB008EB8EB008DB8, 0xEB0090B8EB008FB8, 0xEB0092B8EB0091B8, 0xEB0094B8EB0093B8, 0xEB0096B8EB0095B8, 0xEB0098B8EB0097B8, 0xEB009AB8EB0099B8, 0xEB009CB8EB009BB8, 
0xEB009EB8EB009DB8, 0xEB00A0B8EB009FB8, 0xEB00A2B8EB00A1B8, 0xEB00A4B8EB00A3B8, 0xEB00A6B8EB00A5B8, 0xEB00A8B8EB00A7B8, 0xEB00AAB8EB00A9B8, 0xEB00ACB8EB00ABB8, 
0xEB00AEB8EB00ADB8, 0xEB00B0B8EB00AFB8, 0xEB00B2B8EB00B1B8, 0xEB00B4B8EB00B3B8, 0xEB00B6B8EB00B5B8, 0xEB00B8B8EB00B7B8, 0xEB00BAB8EB00B9B8, 0xEB00BCB8EB00BBB8, 
0xEB00BEB8EB00BDB8, 0xEB0080B9EB00BFB8, 0xEB0082B9EB0081B9, 0xEB0084B9EB0083B9, 0xEB0086B9EB0085B9, 0xEB0088B9EB0087B9, 0xEB008AB9EB0089B9, 0xEB008CB9EB008BB9, 
0xEB008EB9EB008DB9, 0xEB0090B9EB008FB9, 0xEB0092B9EB0091B9, 0xEB0094B9EB0093B9, 0xEB0096B9EB0095B9, 0xEB0098B9EB0097B9, 0xEB009AB9EB0099B9, 0xEB009CB9EB009BB9, 
0xEB009EB9EB009DB9, 0xEB00A0B9EB009FB9, 0xEB00A2B9EB00A1B9, 0xEB00A4B9EB00A3B9, 0xEB00A6B9EB00A5B9, 0xEB00A8B9EB00A7B9, 0xEB00AAB9EB00A9B9, 0xEB00ACB9EB00ABB9, 
0xEB00AEB9EB00ADB9, 0xEB00B0B9EB00AFB9, 0xEB00B2B9EB00B1B9, 0xEB00B4B9EB00B3B9, 0xEB00B6B9EB00B5B9, 0xEB00B8B9EB00B7B9, 0xEB00BAB9EB00B9B9, 0xEB00BCB9EB00BBB9, 
0xEB00BEB9EB00BDB9, 0xEB0080BAEB00BFB9, 0xEB0082BAEB0081BA, 0xEB0084BAEB0083BA, 0xEB0086BAEB0085BA, 0xEB0088BAEB0087BA, 0xEB008ABAEB0089BA, 0xEB008CBAEB008BBA, 
0xEB008EBAEB008DBA, 0xEB0090BAEB008FBA, 0xEB0092BAEB0091BA, 0xEB0094BAEB0093BA, 0xEB0096BAEB0095BA, 0xEB0098BAEB0097BA, 0xEB009ABAEB0099BA, 0xEB009CBAEB009BBA, 
0xEB009EBAEB009DBA, 0xEB00A0BAEB009FBA, 0xEB00A2BAEB00A1BA, 0xEB00A4BAEB00A3BA, 0xEB00A6BAEB00A5BA, 0xEB00A8BAEB00A7BA, 0xEB00AABAEB00A9BA, 0xEB00ACBAEB00ABBA, 
0xEB00AEBAEB00ADBA, 0xEB00B0BAEB00AFBA, 0xEB00B2BAEB00B1BA, 0xEB00B4BAEB00B3BA, 0xEB00B6BAEB00B5BA, 0xEB00B8BAEB00B7BA, 0xEB00BABAEB00B9BA, 0xEB00BCBAEB00BBBA, 
0xEB00BEBAEB00BDBA, 0xEB0080BBEB00BFBA, 0xEB0082BBEB0081BB, 0xEB0084BBEB0083BB, 0xEB0086BBEB0085BB, 0xEB0088BBEB0087BB, 0xEB008ABBEB0089BB, 0xEB008CBBEB008BBB, 
0xEB008EBBEB008DBB, 0xEB0090BBEB008FBB, 0xEB0092BBEB0091BB, 0xEB0094BBEB0093BB, 0xEB0096BBEB0095BB, 0xEB0098BBEB0097BB, 0xEB009ABBEB0099BB, 0xEB009CBBEB009BBB, 
0xEB009EBBEB009DBB, 0xEB00A0BBEB009FBB, 0xEB00A2BBEB00A1BB, 0xEB00A4BBEB00A3BB, 0xEB00A6BBEB00A5BB, 0xEB00A8BBEB00A7BB, 0xEB00AABBEB00A9BB, 0xEB00ACBBEB00ABBB, 
0xEB00AEBBEB00ADBB, 0xEB00B0BBEB00AFBB, 0xEB00B2BBEB00B1BB, 0xEB00B4BBEB00B3BB, 0xEB00B6BBEB00B5BB, 0xEB00B8BBEB00B7BB, 0xEB00BABBEB00B9BB, 0xEB00BCBBEB00BBBB, 
0xEB00BEBBEB00BDBB, 0xEB0080BCEB00BFBB, 0xEB0082BCEB0081BC, 0xEB0084BCEB0083BC, 0xEB0086BCEB0085BC, 0xEB0088BCEB0087BC, 0xEB008ABCEB0089BC, 0xEB008CBCEB008BBC, 
0xEB008EBCEB008DBC, 0xEB0090BCEB008FBC, 0xEB0092BCEB0091BC, 0xEB0094BCEB0093BC, 0xEB0096BCEB0095BC, 0xEB0098BCEB0097BC, 0xEB009ABCEB0099BC, 0xEB009CBCEB009BBC, 
0xEB009EBCEB009DBC, 0xEB00A0BCEB009FBC, 0xEB00A2BCEB00A1BC, 0xEB00A4BCEB00A3BC, 0xEB00A6BCEB00A5BC, 0xEB00A8BCEB00A7BC, 0xEB00AABCEB00A9BC, 0xEB00ACBCEB00ABBC, 
0xEB00AEBCEB00ADBC, 0xEB00B0BCEB00AFBC, 0xEB00B2BCEB00B1BC, 0xEB00B4BCEB00B3BC, 0xEB00B6BCEB00B5BC, 0xEB00B8BCEB00B7BC, 0xEB00BABCEB00B9BC, 0xEB00BCBCEB00BBBC, 
0xEB00BEBCEB00BDBC, 0xEB0080BDEB00BFBC, 0xEB0082BDEB0081BD, 0xEB0084BDEB0083BD, 0xEB0086BDEB0085BD, 0xEB0088BDEB0087BD, 0xEB008ABDEB0089BD, 0xEB008CBDEB008BBD, 
0xEB008EBDEB008DBD, 0xEB0090BDEB008FBD, 0xEB0092BDEB0091BD, 0xEB0094BDEB0093BD, 0xEB0096BDEB0095BD, 0xEB0098BDEB0097BD, 0xEB009ABDEB0099BD, 0xEB009CBDEB009BBD, 
0xEB009EBDEB009DBD, 0xEB00A0BDEB009FBD, 0xEB00A2BDEB00A1BD, 0xEB00A4BDEB00A3BD, 0xEB00A6BDEB00A5BD, 0xEB00A8BDEB00A7BD, 0xEB00AABDEB00A9BD, 0xEB00ACBDEB00ABBD, 
0xEB00AEBDEB00ADBD, 0xEB00B0BDEB00AFBD, 0xEB00B2BDEB00B1BD, 0xEB00B4BDEB00B3BD, 0xEB00B6BDEB00B5BD, 0xEB00B8BDEB00B7BD, 0xEB00BABDEB00B9BD, 0xEB00BCBDEB00BBBD, 
0xEB00BEBDEB00BDBD, 0xEB0080BEEB00BFBD, 0xEB0082BEEB0081BE, 0xEB0084BEEB0083BE, 0xEB0086BEEB0085BE, 0xEB0088BEEB0087BE, 0xEB008ABEEB0089BE, 0xEB008CBEEB008BBE, 
0xEB008EBEEB008DBE, 0xEB0090BEEB008FBE, 0xEB0092BEEB0091BE, 0xEB0094BEEB0093BE, 0xEB0096BEEB0095BE, 0xEB0098BEEB0097BE, 0xEB009ABEEB0099BE, 0xEB009CBEEB009BBE, 
0xEB009EBEEB009DBE, 0xEB00A0BEEB009FBE, 0xEB00A2BEEB00A1BE, 0xEB00A4BEEB00A3BE, 0xEB00A6BEEB00A5BE, 0xEB00A8BEEB00A7BE, 0xEB00AABEEB00A9BE, 0xEB00ACBEEB00ABBE, 
0xEB00AEBEEB00ADBE, 0xEB00B0BEEB00AFBE, 0xEB00B2BEEB00B1BE, 0xEB00B4BEEB00B3BE, 0xEB00B6BEEB00B5BE, 0xEB00B8BEEB00B7BE, 0xEB00BABEEB00B9BE, 0xEB00BCBEEB00BBBE, 
0xEB00BEBEEB00BDBE, 0xEB0080BFEB00BFBE, 0xEB0082BFEB0081BF, 0xEB0084BFEB0083BF, 0xEB0086BFEB0085BF, 0xEB0088BFEB0087BF, 0xEB008ABFEB0089BF, 0xEB008CBFEB008BBF, 
0xEB008EBFEB008DBF, 0xEB0090BFEB008FBF, 0xEB0092BFEB0091BF, 0xEB0094BFEB0093BF, 0xEB0096BFEB0095BF, 0xEB0098BFEB0097BF, 0xEB009ABFEB0099BF, 0xEB009CBFEB009BBF, 
0xEB009EBFEB009DBF, 0xEB00A0BFEB009FBF, 0xEB00A2BFEB00A1BF, 0xEB00A4BFEB00A3BF, 0xEB00A6BFEB00A5BF, 0xEB00A8BFEB00A7BF, 0xEB00AABFEB00A9BF, 0xEB00ACBFEB00ABBF, 
0xEB00AEBFEB00ADBF, 0xEB00B0BFEB00AFBF, 0xEB00B2BFEB00B1BF, 0xEB00B4BFEB00B3BF, 0xEB00B6BFEB00B5BF, 0xEB00B8BFEB00B7BF, 0xEB00BABFEB00B9BF, 0xEB00BCBFEB00BBBF, 
0xEB00BEBFEB00BDBF, 0xEC008080EC00BFBF, 0xEC008280EC008180, 0xEC008480EC008380, 0xEC008680EC008580, 0xEC008880EC008780, 0xEC008A80EC008980, 0xEC008C80EC008B80, 
0xEC008E80EC008D80, 0xEC009080EC008F80, 0xEC009280EC009180, 0xEC009480EC009380, 0xEC009680EC009580, 0xEC009880EC009780, 0xEC009A80EC009980, 0xEC009C80EC009B80, 
0xEC009E80EC009D80, 0xEC00A080EC009F80, 0xEC00A280EC00A180, 0xEC00A480EC00A380, 0xEC00A680EC00A580, 0xEC00A880EC00A780, 0xEC00AA80EC00A980, 0xEC00AC80EC00AB80, 
0xEC00AE80EC00AD80, 0xEC00B080EC00AF80, 0xEC00B280EC00B180, 0xEC00B480EC00B380, 0xEC00B680EC00B580, 0xEC00B880EC00B780, 0xEC00BA80EC00B980, 0xEC00BC80EC00BB80, 
0xEC00BE80EC00BD80, 0xEC008081EC00BF80, 0xEC008281EC008181, 0xEC008481EC008381, 0xEC008681EC008581, 0xEC008881EC008781, 0xEC008A81EC008981, 0xEC008C81EC008B81, 
0xEC008E81EC008D81, 0xEC009081EC008F81, 0xEC009281EC009181, 0xEC009481EC009381, 0xEC009681EC009581, 0xEC009881EC009781, 0xEC009A81EC009981, 0xEC009C81EC009B81, 
0xEC009E81EC009D81, 0xEC00A081EC009F81, 0xEC00A281EC00A181, 0xEC00A481EC00A381, 0xEC00A681EC00A581, 0xEC00A881EC00A781, 0xEC00AA81EC00A981, 0xEC00AC81EC00AB81, 
0xEC00AE81EC00AD81, 0xEC00B081EC00AF81, 0xEC00B281EC00B181, 0xEC00B481EC00B381, 0xEC00B681EC00B581, 0xEC00B881EC00B781, 0xEC00BA81EC00B981, 0xEC00BC81EC00BB81, 
0xEC00BE81EC00BD81, 0xEC008082EC00BF81, 0xEC008282EC008182, 0xEC008482EC008382, 0xEC008682EC008582, 0xEC008882EC008782, 0xEC008A82EC008982, 0xEC008C82EC008B82, 
0xEC008E82EC008D82, 0xEC009082EC008F82, 0xEC009282EC009182, 0xEC009482EC009382, 0xEC009682EC009582, 0xEC009882EC009782, 0xEC009A82EC009982, 0xEC009C82EC009B82, 
0xEC009E82EC009D82, 0xEC00A082EC009F82, 0xEC00A282EC00A182, 0xEC00A482EC00A382, 0xEC00A682EC00A582, 0xEC00A882EC00A782, 0xEC00AA82EC00A982, 0xEC00AC82EC00AB82, 
0xEC00AE82EC00AD82, 0xEC00B082EC00AF82, 0xEC00B282EC00B182, 0xEC00B482EC00B382, 0xEC00B682EC00B582, 0xEC00B882EC00B782, 0xEC00BA82EC00B982, 0xEC00BC82EC00BB82, 
0xEC00BE82EC00BD82, 0xEC008083EC00BF82, 0xEC008283EC008183, 0xEC008483EC008383, 0xEC008683EC008583, 0xEC008883EC008783, 0xEC008A83EC008983, 0xEC008C83EC008B83, 
0xEC008E83EC008D83, 0xEC009083EC008F83, 0xEC009283EC009183, 0xEC009483EC009383, 0xEC009683EC009583, 0xEC009883EC009783, 0xEC009A83EC009983, 0xEC009C83EC009B83, 
0xEC009E83EC009D83, 0xEC00A083EC009F83, 0xEC00A283EC00A183, 0xEC00A483EC00A383, 0xEC00A683EC00A583, 0xEC00A883EC00A783, 0xEC00AA83EC00A983, 0xEC00AC83EC00AB83, 
0xEC00AE83EC00AD83, 0xEC00B083EC00AF83, 0xEC00B283EC00B183, 0xEC00B483EC00B383, 0xEC00B683EC00B583, 0xEC00B883EC00B783, 0xEC00BA83EC00B983, 0xEC00BC83EC00BB83, 
0xEC00BE83EC00BD83, 0xEC008084EC00BF83, 0xEC008284EC008184, 0xEC008484EC008384, 0xEC008684EC008584, 0xEC008884EC008784, 0xEC008A84EC008984, 0xEC008C84EC008B84, 
0xEC008E84EC008D84, 0xEC009084EC008F84, 0xEC009284EC009184, 0xEC009484EC009384, 0xEC009684EC009584, 0xEC009884EC009784, 0xEC009A84EC009984, 0xEC009C84EC009B84, 
0xEC009E84EC009D84, 0xEC00A084EC009F84, 0xEC00A284EC00A184, 0xEC00A484EC00A384, 0xEC00A684EC00A584, 0xEC00A884EC00A784, 0xEC00AA84EC00A984, 0xEC00AC84EC00AB84, 
0xEC00AE84EC00AD84, 0xEC00B084EC00AF84, 0xEC00B284EC00B184, 0xEC00B484EC00B384, 0xEC00B684EC00B584, 0xEC00B884EC00B784, 0xEC00BA84EC00B984, 0xEC00BC84EC00BB84, 
0xEC00BE84EC00BD84, 0xEC008085EC00BF84, 0xEC008285EC008185, 0xEC008485EC008385, 0xEC008685EC008585, 0xEC008885EC008785, 0xEC008A85EC008985, 0xEC008C85EC008B85, 
0xEC008E85EC008D85, 0xEC009085EC008F85, 0xEC009285EC009185, 0xEC009485EC009385, 0xEC009685EC009585, 0xEC009885EC009785, 0xEC009A85EC009985, 0xEC009C85EC009B85, 
0xEC009E85EC009D85, 0xEC00A085EC009F85, 0xEC00A285EC00A185, 0xEC00A485EC00A385, 0xEC00A685EC00A585, 0xEC00A885EC00A785, 0xEC00AA85EC00A985, 0xEC00AC85EC00AB85, 
0xEC00AE85EC00AD85, 0xEC00B085EC00AF85, 0xEC00B285EC00B185, 0xEC00B485EC00B385, 0xEC00B685EC00B585, 0xEC00B885EC00B785, 0xEC00BA85EC00B985, 0xEC00BC85EC00BB85, 
0xEC00BE85EC00BD85, 0xEC008086EC00BF85, 0xEC008286EC008186, 0xEC008486EC008386, 0xEC008686EC008586, 0xEC008886EC008786, 0xEC008A86EC008986, 0xEC008C86EC008B86, 
0xEC008E86EC008D86, 0xEC009086EC008F86, 0xEC009286EC009186, 0xEC009486EC009386, 0xEC009686EC009586, 0xEC009886EC009786, 0xEC009A86EC009986, 0xEC009C86EC009B86, 
0xEC009E86EC009D86, 0xEC00A086EC009F86, 0xEC00A286EC00A186, 0xEC00A486EC00A386, 0xEC00A686EC00A586, 0xEC00A886EC00A786, 0xEC00AA86EC00A986, 0xEC00AC86EC00AB86, 
0xEC00AE86EC00AD86, 0xEC00B086EC00AF86, 0xEC00B286EC00B186, 0xEC00B486EC00B386, 0xEC00B686EC00B586, 0xEC00B886EC00B786, 0xEC00BA86EC00B986, 0xEC00BC86EC00BB86, 
0xEC00BE86EC00BD86, 0xEC008087EC00BF86, 0xEC008287EC008187, 0xEC008487EC008387, 0xEC008687EC008587, 0xEC008887EC008787, 0xEC008A87EC008987, 0xEC008C87EC008B87, 
0xEC008E87EC008D87, 0xEC009087EC008F87, 0xEC009287EC009187, 0xEC009487EC009387, 0xEC009687EC009587, 0xEC009887EC009787, 0xEC009A87EC009987, 0xEC009C87EC009B87, 
0xEC009E87EC009D87, 0xEC00A087EC009F87, 0xEC00A287EC00A187, 0xEC00A487EC00A387, 0xEC00A687EC00A587, 0xEC00A887EC00A787, 0xEC00AA87EC00A987, 0xEC00AC87EC00AB87, 
0xEC00AE87EC00AD87, 0xEC00B087EC00AF87, 0xEC00B287EC00B187, 0xEC00B487EC00B387, 0xEC00B687EC00B587, 0xEC00B887EC00B787, 0xEC00BA87EC00B987, 0xEC00BC87EC00BB87, 
0xEC00BE87EC00BD87, 0xEC008088EC00BF87, 0xEC008288EC008188, 0xEC008488EC008388, 0xEC008688EC008588, 0xEC008888EC008788, 0xEC008A88EC008988, 0xEC008C88EC008B88, 
0xEC008E88EC008D88, 0xEC009088EC008F88, 0xEC009288EC009188, 0xEC009488EC009388, 0xEC009688EC009588, 0xEC009888EC009788, 0xEC009A88EC009988, 0xEC009C88EC009B88, 
0xEC009E88EC009D88, 0xEC00A088EC009F88, 0xEC00A288EC00A188, 0xEC00A488EC00A388, 0xEC00A688EC00A588, 0xEC00A888EC00A788, 0xEC00AA88EC00A988, 0xEC00AC88EC00AB88, 
0xEC00AE88EC00AD88, 0xEC00B088EC00AF88, 0xEC00B288EC00B188, 0xEC00B488EC00B388, 0xEC00B688EC00B588, 0xEC00B888EC00B788, 0xEC00BA88EC00B988, 0xEC00BC88EC00BB88, 
0xEC00BE88EC00BD88, 0xEC008089EC00BF88, 0xEC008289EC008189, 0xEC008489EC008389, 0xEC008689EC008589, 0xEC008889EC008789, 0xEC008A89EC008989, 0xEC008C89EC008B89, 
0xEC008E89EC008D89, 0xEC009089EC008F89, 0xEC009289EC009189, 0xEC009489EC009389, 0xEC009689EC009589, 0xEC009889EC009789, 0xEC009A89EC009989, 0xEC009C89EC009B89, 
0xEC009E89EC009D89, 0xEC00A089EC009F89, 0xEC00A289EC00A189, 0xEC00A489EC00A389, 0xEC00A689EC00A589, 0xEC00A889EC00A789, 0xEC00AA89EC00A989, 0xEC00AC89EC00AB89, 
0xEC00AE89EC00AD89, 0xEC00B089EC00AF89, 0xEC00B289EC00B189, 0xEC00B489EC00B389, 0xEC00B689EC00B589, 0xEC00B889EC00B789, 0xEC00BA89EC00B989, 0xEC00BC89EC00BB89, 
0xEC00BE89EC00BD89, 0xEC00808AEC00BF89, 0xEC00828AEC00818A, 0xEC00848AEC00838A, 0xEC00868AEC00858A, 0xEC00888AEC00878A, 0xEC008A8AEC00898A, 0xEC008C8AEC008B8A, 
0xEC008E8AEC008D8A, 0xEC00908AEC008F8A, 0xEC00928AEC00918A, 0xEC00948AEC00938A, 0xEC00968AEC00958A, 0xEC00988AEC00978A, 0xEC009A8AEC00998A, 0xEC009C8AEC009B8A, 
0xEC009E8AEC009D8A, 0xEC00A08AEC009F8A, 0xEC00A28AEC00A18A, 0xEC00A48AEC00A38A, 0xEC00A68AEC00A58A, 0xEC00A88AEC00A78A, 0xEC00AA8AEC00A98A, 0xEC00AC8AEC00AB8A, 
0xEC00AE8AEC00AD8A, 0xEC00B08AEC00AF8A, 0xEC00B28AEC00B18A, 0xEC00B48AEC00B38A, 0xEC00B68AEC00B58A, 0xEC00B88AEC00B78A, 0xEC00BA8AEC00B98A, 0xEC00BC8AEC00BB8A, 
0xEC00BE8AEC00BD8A, 0xEC00808BEC00BF8A, 0xEC00828BEC00818B, 0xEC00848BEC00838B, 0xEC00868BEC00858B, 0xEC00888BEC00878B, 0xEC008A8BEC00898B, 0xEC008C8BEC008B8B, 
0xEC008E8BEC008D8B, 0xEC00908BEC008F8B, 0xEC00928BEC00918B, 0xEC00948BEC00938B, 0xEC00968BEC00958B, 0xEC00988BEC00978B, 0xEC009A8BEC00998B, 0xEC009C8BEC009B8B, 
0xEC009E8BEC009D8B, 0xEC00A08BEC009F8B, 0xEC00A28BEC00A18B, 0xEC00A48BEC00A38B, 0xEC00A68BEC00A58B, 0xEC00A88BEC00A78B, 0xEC00AA8BEC00A98B, 0xEC00AC8BEC00AB8B, 
0xEC00AE8BEC00AD8B, 0xEC00B08BEC00AF8B, 0xEC00B28BEC00B18B, 0xEC00B48BEC00B38B, 0xEC00B68BEC00B58B, 0xEC00B88BEC00B78B, 0xEC00BA8BEC00B98B, 0xEC00BC8BEC00BB8B, 
0xEC00BE8BEC00BD8B, 0xEC00808CEC00BF8B, 0xEC00828CEC00818C, 0xEC00848CEC00838C, 0xEC00868CEC00858C, 0xEC00888CEC00878C, 0xEC008A8CEC00898C, 0xEC008C8CEC008B8C, 
0xEC008E8CEC008D8C, 0xEC00908CEC008F8C, 0xEC00928CEC00918C, 0xEC00948CEC00938C, 0xEC00968CEC00958C, 0xEC00988CEC00978C, 0xEC009A8CEC00998C, 0xEC009C8CEC009B8C, 
0xEC009E8CEC009D8C, 0xEC00A08CEC009F8C, 0xEC00A28CEC00A18C, 0xEC00A48CEC00A38C, 0xEC00A68CEC00A58C, 0xEC00A88CEC00A78C, 0xEC00AA8CEC00A98C, 0xEC00AC8CEC00AB8C, 
0xEC00AE8CEC00AD8C, 0xEC00B08CEC00AF8C, 0xEC00B28CEC00B18C, 0xEC00B48CEC00B38C, 0xEC00B68CEC00B58C, 0xEC00B88CEC00B78C, 0xEC00BA8CEC00B98C, 0xEC00BC8CEC00BB8C, 
0xEC00BE8CEC00BD8C, 0xEC00808DEC00BF8C, 0xEC00828DEC00818D, 0xEC00848DEC00838D, 0xEC00868DEC00858D, 0xEC00888DEC00878D, 0xEC008A8DEC00898D, 0xEC008C8DEC008B8D, 
0xEC008E8DEC008D8D, 0xEC00908DEC008F8D, 0xEC00928DEC00918D, 0xEC00948DEC00938D, 0xEC00968DEC00958D, 0xEC00988DEC00978D, 0xEC009A8DEC00998D, 0xEC009C8DEC009B8D, 
0xEC009E8DEC009D8D, 0xEC00A08DEC009F8D, 0xEC00A28DEC00A18D, 0xEC00A48DEC00A38D, 0xEC00A68DEC00A58D, 0xEC00A88DEC00A78D, 0xEC00AA8DEC00A98D, 0xEC00AC8DEC00AB8D, 
0xEC00AE8DEC00AD8D, 0xEC00B08DEC00AF8D, 0xEC00B28DEC00B18D, 0xEC00B48DEC00B38D, 0xEC00B68DEC00B58D, 0xEC00B88DEC00B78D, 0xEC00BA8DEC00B98D, 0xEC00BC8DEC00BB8D, 
0xEC00BE8DEC00BD8D, 0xEC00808EEC00BF8D, 0xEC00828EEC00818E, 0xEC00848EEC00838E, 0xEC00868EEC00858E, 0xEC00888EEC00878E, 0xEC008A8EEC00898E, 0xEC008C8EEC008B8E, 
0xEC008E8EEC008D8E, 0xEC00908EEC008F8E, 0xEC00928EEC00918E, 0xEC00948EEC00938E, 0xEC00968EEC00958E, 0xEC00988EEC00978E, 0xEC009A8EEC00998E, 0xEC009C8EEC009B8E, 
0xEC009E8EEC009D8E, 0xEC00A08EEC009F8E, 0xEC00A28EEC00A18E, 0xEC00A48EEC00A38E, 0xEC00A68EEC00A58E, 0xEC00A88EEC00A78E, 0xEC00AA8EEC00A98E, 0xEC00AC8EEC00AB8E, 
0xEC00AE8EEC00AD8E, 0xEC00B08EEC00AF8E, 0xEC00B28EEC00B18E, 0xEC00B48EEC00B38E, 0xEC00B68EEC00B58E, 0xEC00B88EEC00B78E, 0xEC00BA8EEC00B98E, 0xEC00BC8EEC00BB8E, 
0xEC00BE8EEC00BD8E, 0xEC00808FEC00BF8E, 0xEC00828FEC00818F, 0xEC00848FEC00838F, 0xEC00868FEC00858F, 0xEC00888FEC00878F, 0xEC008A8FEC00898F, 0xEC008C8FEC008B8F, 
0xEC008E8FEC008D8F, 0xEC00908FEC008F8F, 0xEC00928FEC00918F, 0xEC00948FEC00938F, 0xEC00968FEC00958F, 0xEC00988FEC00978F, 0xEC009A8FEC00998F, 0xEC009C8FEC009B8F, 
0xEC009E8FEC009D8F, 0xEC00A08FEC009F8F, 0xEC00A28FEC00A18F, 0xEC00A48FEC00A38F, 0xEC00A68FEC00A58F, 0xEC00A88FEC00A78F, 0xEC00AA8FEC00A98F, 0xEC00AC8FEC00AB8F, 
0xEC00AE8FEC00AD8F, 0xEC00B08FEC00AF8F, 0xEC00B28FEC00B18F, 0xEC00B48FEC00B38F, 0xEC00B68FEC00B58F, 0xEC00B88FEC00B78F, 0xEC00BA8FEC00B98F, 0xEC00BC8FEC00BB8F, 
0xEC00BE8FEC00BD8F, 0xEC008090EC00BF8F, 0xEC008290EC008190, 0xEC008490EC008390, 0xEC008690EC008590, 0xEC008890EC008790, 0xEC008A90EC008990, 0xEC008C90EC008B90, 
0xEC008E90EC008D90, 0xEC009090EC008F90, 0xEC009290EC009190, 0xEC009490EC009390, 0xEC009690EC009590, 0xEC009890EC009790, 0xEC009A90EC009990, 0xEC009C90EC009B90, 
0xEC009E90EC009D90, 0xEC00A090EC009F90, 0xEC00A290EC00A190, 0xEC00A490EC00A390, 0xEC00A690EC00A590, 0xEC00A890EC00A790, 0xEC00AA90EC00A990, 0xEC00AC90EC00AB90, 
0xEC00AE90EC00AD90, 0xEC00B090EC00AF90, 0xEC00B290EC00B190, 0xEC00B490EC00B390, 0xEC00B690EC00B590, 0xEC00B890EC00B790, 0xEC00BA90EC00B990, 0xEC00BC90EC00BB90, 
0xEC00BE90EC00BD90, 0xEC008091EC00BF90, 0xEC008291EC008191, 0xEC008491EC008391, 0xEC008691EC008591, 0xEC008891EC008791, 0xEC008A91EC008991, 0xEC008C91EC008B91, 
0xEC008E91EC008D91, 0xEC009091EC008F91, 0xEC009291EC009191, 0xEC009491EC009391, 0xEC009691EC009591, 0xEC009891EC009791, 0xEC009A91EC009991, 0xEC009C91EC009B91, 
0xEC009E91EC009D91, 0xEC00A091EC009F91, 0xEC00A291EC00A191, 0xEC00A491EC00A391, 0xEC00A691EC00A591, 0xEC00A891EC00A791, 0xEC00AA91EC00A991, 0xEC00AC91EC00AB91, 
0xEC00AE91EC00AD91, 0xEC00B091EC00AF91, 0xEC00B291EC00B191, 0xEC00B491EC00B391, 0xEC00B691EC00B591, 0xEC00B891EC00B791, 0xEC00BA91EC00B991, 0xEC00BC91EC00BB91, 
0xEC00BE91EC00BD91, 0xEC008092EC00BF91, 0xEC008292EC008192, 0xEC008492EC008392, 0xEC008692EC008592, 0xEC008892EC008792, 0xEC008A92EC008992, 0xEC008C92EC008B92, 
0xEC008E92EC008D92, 0xEC009092EC008F92, 0xEC009292EC009192, 0xEC009492EC009392, 0xEC009692EC009592, 0xEC009892EC009792, 0xEC009A92EC009992, 0xEC009C92EC009B92, 
0xEC009E92EC009D92, 0xEC00A092EC009F92, 0xEC00A292EC00A192, 0xEC00A492EC00A392, 0xEC00A692EC00A592, 0xEC00A892EC00A792, 0xEC00AA92EC00A992, 0xEC00AC92EC00AB92, 
0xEC00AE92EC00AD92, 0xEC00B092EC00AF92, 0xEC00B292EC00B192, 0xEC00B492EC00B392, 0xEC00B692EC00B592, 0xEC00B892EC00B792, 0xEC00BA92EC00B992, 0xEC00BC92EC00BB92, 
0xEC00BE92EC00BD92, 0xEC008093EC00BF92, 0xEC008293EC008193, 0xEC008493EC008393, 0xEC008693EC008593, 0xEC008893EC008793, 0xEC008A93EC008993, 0xEC008C93EC008B93, 
0xEC008E93EC008D93, 0xEC009093EC008F93, 0xEC009293EC009193, 0xEC009493EC009393, 0xEC009693EC009593, 0xEC009893EC009793, 0xEC009A93EC009993, 0xEC009C93EC009B93, 
0xEC009E93EC009D93, 0xEC00A093EC009F93, 0xEC00A293EC00A193, 0xEC00A493EC00A393, 0xEC00A693EC00A593, 0xEC00A893EC00A793, 0xEC00AA93EC00A993, 0xEC00AC93EC00AB93, 
0xEC00AE93EC00AD93, 0xEC00B093EC00AF93, 0xEC00B293EC00B193, 0xEC00B493EC00B393, 0xEC00B693EC00B593, 0xEC00B893EC00B793, 0xEC00BA93EC00B993, 0xEC00BC93EC00BB93, 
0xEC00BE93EC00BD93, 0xEC008094EC00BF93, 0xEC008294EC008194, 0xEC008494EC008394, 0xEC008694EC008594, 0xEC008894EC008794, 0xEC008A94EC008994, 0xEC008C94EC008B94, 
0xEC008E94EC008D94, 0xEC009094EC008F94, 0xEC009294EC009194, 0xEC009494EC009394, 0xEC009694EC009594, 0xEC009894EC009794, 0xEC009A94EC009994, 0xEC009C94EC009B94, 
0xEC009E94EC009D94, 0xEC00A094EC009F94, 0xEC00A294EC00A194, 0xEC00A494EC00A394, 0xEC00A694EC00A594, 0xEC00A894EC00A794, 0xEC00AA94EC00A994, 0xEC00AC94EC00AB94, 
0xEC00AE94EC00AD94, 0xEC00B094EC00AF94, 0xEC00B294EC00B194, 0xEC00B494EC00B394, 0xEC00B694EC00B594, 0xEC00B894EC00B794, 0xEC00BA94EC00B994, 0xEC00BC94EC00BB94, 
0xEC00BE94EC00BD94, 0xEC008095EC00BF94, 0xEC008295EC008195, 0xEC008495EC008395, 0xEC008695EC008595, 0xEC008895EC008795, 0xEC008A95EC008995, 0xEC008C95EC008B95, 
0xEC008E95EC008D95, 0xEC009095EC008F95, 0xEC009295EC009195, 0xEC009495EC009395, 0xEC009695EC009595, 0xEC009895EC009795, 0xEC009A95EC009995, 0xEC009C95EC009B95, 
0xEC009E95EC009D95, 0xEC00A095EC009F95, 0xEC00A295EC00A195, 0xEC00A495EC00A395, 0xEC00A695EC00A595, 0xEC00A895EC00A795, 0xEC00AA95EC00A995, 0xEC00AC95EC00AB95, 
0xEC00AE95EC00AD95, 0xEC00B095EC00AF95, 0xEC00B295EC00B195, 0xEC00B495EC00B395, 0xEC00B695EC00B595, 0xEC00B895EC00B795, 0xEC00BA95EC00B995, 0xEC00BC95EC00BB95, 
0xEC00BE95EC00BD95, 0xEC008096EC00BF95, 0xEC008296EC008196, 0xEC008496EC008396, 0xEC008696EC008596, 0xEC008896EC008796, 0xEC008A96EC008996, 0xEC008C96EC008B96, 
0xEC008E96EC008D96, 0xEC009096EC008F96, 0xEC009296EC009196, 0xEC009496EC009396, 0xEC009696EC009596, 0xEC009896EC009796, 0xEC009A96EC009996, 0xEC009C96EC009B96, 
0xEC009E96EC009D96, 0xEC00A096EC009F96, 0xEC00A296EC00A196, 0xEC00A496EC00A396, 0xEC00A696EC00A596, 0xEC00A896EC00A796, 0xEC00AA96EC00A996, 0xEC00AC96EC00AB96, 
0xEC00AE96EC00AD96, 0xEC00B096EC00AF96, 0xEC00B296EC00B196, 0xEC00B496EC00B396, 0xEC00B696EC00B596, 0xEC00B896EC00B796, 0xEC00BA96EC00B996, 0xEC00BC96EC00BB96, 
0xEC00BE96EC00BD96, 0xEC008097EC00BF96, 0xEC008297EC008197, 0xEC008497EC008397, 0xEC008697EC008597, 0xEC008897EC008797, 0xEC008A97EC008997, 0xEC008C97EC008B97, 
0xEC008E97EC008D97, 0xEC009097EC008F97, 0xEC009297EC009197, 0xEC009497EC009397, 0xEC009697EC009597, 0xEC009897EC009797, 0xEC009A97EC009997, 0xEC009C97EC009B97, 
0xEC009E97EC009D97, 0xEC00A097EC009F97, 0xEC00A297EC00A197, 0xEC00A497EC00A397, 0xEC00A697EC00A597, 0xEC00A897EC00A797, 0xEC00AA97EC00A997, 0xEC00AC97EC00AB97, 
0xEC00AE97EC00AD97, 0xEC00B097EC00AF97, 0xEC00B297EC00B197, 0xEC00B497EC00B397, 0xEC00B697EC00B597, 0xEC00B897EC00B797, 0xEC00BA97EC00B997, 0xEC00BC97EC00BB97, 
0xEC00BE97EC00BD97, 0xEC008098EC00BF97, 0xEC008298EC008198, 0xEC008498EC008398, 0xEC008698EC008598, 0xEC008898EC008798, 0xEC008A98EC008998, 0xEC008C98EC008B98, 
0xEC008E98EC008D98, 0xEC009098EC008F98, 0xEC009298EC009198, 0xEC009498EC009398, 0xEC009698EC009598, 0xEC009898EC009798, 0xEC009A98EC009998, 0xEC009C98EC009B98, 
0xEC009E98EC009D98, 0xEC00A098EC009F98, 0xEC00A298EC00A198, 0xEC00A498EC00A398, 0xEC00A698EC00A598, 0xEC00A898EC00A798, 0xEC00AA98EC00A998, 0xEC00AC98EC00AB98, 
0xEC00AE98EC00AD98, 0xEC00B098EC00AF98, 0xEC00B298EC00B198, 0xEC00B498EC00B398, 0xEC00B698EC00B598, 0xEC00B898EC00B798, 0xEC00BA98EC00B998, 0xEC00BC98EC00BB98, 
0xEC00BE98EC00BD98, 0xEC008099EC00BF98, 0xEC008299EC008199, 0xEC008499EC008399, 0xEC008699EC008599, 0xEC008899EC008799, 0xEC008A99EC008999, 0xEC008C99EC008B99, 
0xEC008E99EC008D99, 0xEC009099EC008F99, 0xEC009299EC009199, 0xEC009499EC009399, 0xEC009699EC009599, 0xEC009899EC009799, 0xEC009A99EC009999, 0xEC009C99EC009B99, 
0xEC009E99EC009D99, 0xEC00A099EC009F99, 0xEC00A299EC00A199, 0xEC00A499EC00A399, 0xEC00A699EC00A599, 0xEC00A899EC00A799, 0xEC00AA99EC00A999, 0xEC00AC99EC00AB99, 
0xEC00AE99EC00AD99, 0xEC00B099EC00AF99, 0xEC00B299EC00B199, 0xEC00B499EC00B399, 0xEC00B699EC00B599, 0xEC00B899EC00B799, 0xEC00BA99EC00B999, 0xEC00BC99EC00BB99, 
0xEC00BE99EC00BD99, 0xEC00809AEC00BF99, 0xEC00829AEC00819A, 0xEC00849AEC00839A, 0xEC00869AEC00859A, 0xEC00889AEC00879A, 0xEC008A9AEC00899A, 0xEC008C9AEC008B9A, 
0xEC008E9AEC008D9A, 0xEC00909AEC008F9A, 0xEC00929AEC00919A, 0xEC00949AEC00939A, 0xEC00969AEC00959A, 0xEC00989AEC00979A, 0xEC009A9AEC00999A, 0xEC009C9AEC009B9A, 
0xEC009E9AEC009D9A, 0xEC00A09AEC009F9A, 0xEC00A29AEC00A19A, 0xEC00A49AEC00A39A, 0xEC00A69AEC00A59A, 0xEC00A89AEC00A79A, 0xEC00AA9AEC00A99A, 0xEC00AC9AEC00AB9A, 
0xEC00AE9AEC00AD9A, 0xEC00B09AEC00AF9A, 0xEC00B29AEC00B19A, 0xEC00B49AEC00B39A, 0xEC00B69AEC00B59A, 0xEC00B89AEC00B79A, 0xEC00BA9AEC00B99A, 0xEC00BC9AEC00BB9A, 
0xEC00BE9AEC00BD9A, 0xEC00809BEC00BF9A, 0xEC00829BEC00819B, 0xEC00849BEC00839B, 0xEC00869BEC00859B, 0xEC00889BEC00879B, 0xEC008A9BEC00899B, 0xEC008C9BEC008B9B, 
0xEC008E9BEC008D9B, 0xEC00909BEC008F9B, 0xEC00929BEC00919B, 0xEC00949BEC00939B, 0xEC00969BEC00959B, 0xEC00989BEC00979B, 0xEC009A9BEC00999B, 0xEC009C9BEC009B9B, 
0xEC009E9BEC009D9B, 0xEC00A09BEC009F9B, 0xEC00A29BEC00A19B, 0xEC00A49BEC00A39B, 0xEC00A69BEC00A59B, 0xEC00A89BEC00A79B, 0xEC00AA9BEC00A99B, 0xEC00AC9BEC00AB9B, 
0xEC00AE9BEC00AD9B, 0xEC00B09BEC00AF9B, 0xEC00B29BEC00B19B, 0xEC00B49BEC00B39B, 0xEC00B69BEC00B59B, 0xEC00B89BEC00B79B, 0xEC00BA9BEC00B99B, 0xEC00BC9BEC00BB9B, 
0xEC00BE9BEC00BD9B, 0xEC00809CEC00BF9B, 0xEC00829CEC00819C, 0xEC00849CEC00839C, 0xEC00869CEC00859C, 0xEC00889CEC00879C, 0xEC008A9CEC00899C, 0xEC008C9CEC008B9C, 
0xEC008E9CEC008D9C, 0xEC00909CEC008F9C, 0xEC00929CEC00919C, 0xEC00949CEC00939C, 0xEC00969CEC00959C, 0xEC00989CEC00979C, 0xEC009A9CEC00999C, 0xEC009C9CEC009B9C, 
0xEC009E9CEC009D9C, 0xEC00A09CEC009F9C, 0xEC00A29CEC00A19C, 0xEC00A49CEC00A39C, 0xEC00A69CEC00A59C, 0xEC00A89CEC00A79C, 0xEC00AA9CEC00A99C, 0xEC00AC9CEC00AB9C, 
0xEC00AE9CEC00AD9C, 0xEC00B09CEC00AF9C, 0xEC00B29CEC00B19C, 0xEC00B49CEC00B39C, 0xEC00B69CEC00B59C, 0xEC00B89CEC00B79C, 0xEC00BA9CEC00B99C, 0xEC00BC9CEC00BB9C, 
0xEC00BE9CEC00BD9C, 0xEC00809DEC00BF9C, 0xEC00829DEC00819D, 0xEC00849DEC00839D, 0xEC00869DEC00859D, 0xEC00889DEC00879D, 0xEC008A9DEC00899D, 0xEC008C9DEC008B9D, 
0xEC008E9DEC008D9D, 0xEC00909DEC008F9D, 0xEC00929DEC00919D, 0xEC00949DEC00939D, 0xEC00969DEC00959D, 0xEC00989DEC00979D, 0xEC009A9DEC00999D, 0xEC009C9DEC009B9D, 
0xEC009E9DEC009D9D, 0xEC00A09DEC009F9D, 0xEC00A29DEC00A19D, 0xEC00A49DEC00A39D, 0xEC00A69DEC00A59D, 0xEC00A89DEC00A79D, 0xEC00AA9DEC00A99D, 0xEC00AC9DEC00AB9D, 
0xEC00AE9DEC00AD9D, 0xEC00B09DEC00AF9D, 0xEC00B29DEC00B19D, 0xEC00B49DEC00B39D, 0xEC00B69DEC00B59D, 0xEC00B89DEC00B79D, 0xEC00BA9DEC00B99D, 0xEC00BC9DEC00BB9D, 
0xEC00BE9DEC00BD9D, 0xEC00809EEC00BF9D, 0xEC00829EEC00819E, 0xEC00849EEC00839E, 0xEC00869EEC00859E, 0xEC00889EEC00879E, 0xEC008A9EEC00899E, 0xEC008C9EEC008B9E, 
0xEC008E9EEC008D9E, 0xEC00909EEC008F9E, 0xEC00929EEC00919E, 0xEC00949EEC00939E, 0xEC00969EEC00959E, 0xEC00989EEC00979E, 0xEC009A9EEC00999E, 0xEC009C9EEC009B9E, 
0xEC009E9EEC009D9E, 0xEC00A09EEC009F9E, 0xEC00A29EEC00A19E, 0xEC00A49EEC00A39E, 0xEC00A69EEC00A59E, 0xEC00A89EEC00A79E, 0xEC00AA9EEC00A99E, 0xEC00AC9EEC00AB9E, 
0xEC00AE9EEC00AD9E, 0xEC00B09EEC00AF9E, 0xEC00B29EEC00B19E, 0xEC00B49EEC00B39E, 0xEC00B69EEC00B59E, 0xEC00B89EEC00B79E, 0xEC00BA9EEC00B99E, 0xEC00BC9EEC00BB9E, 
0xEC00BE9EEC00BD9E, 0xEC00809FEC00BF9E, 0xEC00829FEC00819F, 0xEC00849FEC00839F, 0xEC00869FEC00859F, 0xEC00889FEC00879F, 0xEC008A9FEC00899F, 0xEC008C9FEC008B9F, 
0xEC008E9FEC008D9F, 0xEC00909FEC008F9F, 0xEC00929FEC00919F, 0xEC00949FEC00939F, 0xEC00969FEC00959F, 0xEC00989FEC00979F, 0xEC009A9FEC00999F, 0xEC009C9FEC009B9F, 
0xEC009E9FEC009D9F, 0xEC00A09FEC009F9F, 0xEC00A29FEC00A19F, 0xEC00A49FEC00A39F, 0xEC00A69FEC00A59F, 0xEC00A89FEC00A79F, 0xEC00AA9FEC00A99F, 0xEC00AC9FEC00AB9F, 
0xEC00AE9FEC00AD9F, 0xEC00B09FEC00AF9F, 0xEC00B29FEC00B19F, 0xEC00B49FEC00B39F, 0xEC00B69FEC00B59F, 0xEC00B89FEC00B79F, 0xEC00BA9FEC00B99F, 0xEC00BC9FEC00BB9F, 
0xEC00BE9FEC00BD9F, 0xEC0080A0EC00BF9F, 0xEC0082A0EC0081A0, 0xEC0084A0EC0083A0, 0xEC0086A0EC0085A0, 0xEC0088A0EC0087A0, 0xEC008AA0EC0089A0, 0xEC008CA0EC008BA0, 
0xEC008EA0EC008DA0, 0xEC0090A0EC008FA0, 0xEC0092A0EC0091A0, 0xEC0094A0EC0093A0, 0xEC0096A0EC0095A0, 0xEC0098A0EC0097A0, 0xEC009AA0EC0099A0, 0xEC009CA0EC009BA0, 
0xEC009EA0EC009DA0, 0xEC00A0A0EC009FA0, 0xEC00A2A0EC00A1A0, 0xEC00A4A0EC00A3A0, 0xEC00A6A0EC00A5A0, 0xEC00A8A0EC00A7A0, 0xEC00AAA0EC00A9A0, 0xEC00ACA0EC00ABA0, 
0xEC00AEA0EC00ADA0, 0xEC00B0A0EC00AFA0, 0xEC00B2A0EC00B1A0, 0xEC00B4A0EC00B3A0, 0xEC00B6A0EC00B5A0, 0xEC00B8A0EC00B7A0, 0xEC00BAA0EC00B9A0, 0xEC00BCA0EC00BBA0, 
0xEC00BEA0EC00BDA0, 0xEC0080A1EC00BFA0, 0xEC0082A1EC0081A1, 0xEC0084A1EC0083A1, 0xEC0086A1EC0085A1, 0xEC0088A1EC0087A1, 0xEC008AA1EC0089A1, 0xEC008CA1EC008BA1, 
0xEC008EA1EC008DA1, 0xEC0090A1EC008FA1, 0xEC0092A1EC0091A1, 0xEC0094A1EC0093A1, 0xEC0096A1EC0095A1, 0xEC0098A1EC0097A1, 0xEC009AA1EC0099A1, 0xEC009CA1EC009BA1, 
0xEC009EA1EC009DA1, 0xEC00A0A1EC009FA1, 0xEC00A2A1EC00A1A1, 0xEC00A4A1EC00A3A1, 0xEC00A6A1EC00A5A1, 0xEC00A8A1EC00A7A1, 0xEC00AAA1EC00A9A1, 0xEC00ACA1EC00ABA1, 
0xEC00AEA1EC00ADA1, 0xEC00B0A1EC00AFA1, 0xEC00B2A1EC00B1A1, 0xEC00B4A1EC00B3A1, 0xEC00B6A1EC00B5A1, 0xEC00B8A1EC00B7A1, 0xEC00BAA1EC00B9A1, 0xEC00BCA1EC00BBA1, 
0xEC00BEA1EC00BDA1, 0xEC0080A2EC00BFA1, 0xEC0082A2EC0081A2, 0xEC0084A2EC0083A2, 0xEC0086A2EC0085A2, 0xEC0088A2EC0087A2, 0xEC008AA2EC0089A2, 0xEC008CA2EC008BA2, 
0xEC008EA2EC008DA2, 0xEC0090A2EC008FA2, 0xEC0092A2EC0091A2, 0xEC0094A2EC0093A2, 0xEC0096A2EC0095A2, 0xEC0098A2EC0097A2, 0xEC009AA2EC0099A2, 0xEC009CA2EC009BA2, 
0xEC009EA2EC009DA2, 0xEC00A0A2EC009FA2, 0xEC00A2A2EC00A1A2, 0xEC00A4A2EC00A3A2, 0xEC00A6A2EC00A5A2, 0xEC00A8A2EC00A7A2, 0xEC00AAA2EC00A9A2, 0xEC00ACA2EC00ABA2, 
0xEC00AEA2EC00ADA2, 0xEC00B0A2EC00AFA2, 0xEC00B2A2EC00B1A2, 0xEC00B4A2EC00B3A2, 0xEC00B6A2EC00B5A2, 0xEC00B8A2EC00B7A2, 0xEC00BAA2EC00B9A2, 0xEC00BCA2EC00BBA2, 
0xEC00BEA2EC00BDA2, 0xEC0080A3EC00BFA2, 0xEC0082A3EC0081A3, 0xEC0084A3EC0083A3, 0xEC0086A3EC0085A3, 0xEC0088A3EC0087A3, 0xEC008AA3EC0089A3, 0xEC008CA3EC008BA3, 
0xEC008EA3EC008DA3, 0xEC0090A3EC008FA3, 0xEC0092A3EC0091A3, 0xEC0094A3EC0093A3, 0xEC0096A3EC0095A3, 0xEC0098A3EC0097A3, 0xEC009AA3EC0099A3, 0xEC009CA3EC009BA3, 
0xEC009EA3EC009DA3, 0xEC00A0A3EC009FA3, 0xEC00A2A3EC00A1A3, 0xEC00A4A3EC00A3A3, 0xEC00A6A3EC00A5A3, 0xEC00A8A3EC00A7A3, 0xEC00AAA3EC00A9A3, 0xEC00ACA3EC00ABA3, 
0xEC00AEA3EC00ADA3, 0xEC00B0A3EC00AFA3, 0xEC00B2A3EC00B1A3, 0xEC00B4A3EC00B3A3, 0xEC00B6A3EC00B5A3, 0xEC00B8A3EC00B7A3, 0xEC00BAA3EC00B9A3, 0xEC00BCA3EC00BBA3, 
0xA3EC00989DECBCA3, 0xA3EC00BEA3EC00BD, 0xA4EC0080A4EC00BF, 0xA4EC0082A4EC0081, 0xA4EC0084A4EC0083, 0xA4EC0086A4EC0085, 0xA4EC0088A4EC0087, 0xA4EC008AA4EC0089, 
0xA4EC008CA4EC008B, 0xA4EC008EA4EC008D, 0xA4EC0090A4EC008F, 0xA4EC0092A4EC0091, 0xA4EC0094A4EC0093, 0xA4EC0096A4EC0095, 0xA4EC0098A4EC0097, 0xA4EC009AA4EC0099, 
0xA4EC009CA4EC009B, 0xA4EC009EA4EC009D, 0xA4EC00A0A4EC009F, 0xA4EC00A2A4EC00A1, 0xA4EC00A4A4EC00A3, 0xA4EC00A6A4EC00A5, 0xA4EC00A8A4EC00A7, 0xA4EC00AAA4EC00A9, 
0xA4EC00ACA4EC00AB, 0xA4EC00AEA4EC00AD, 0xA4EC00B0A4EC00AF, 0xA4EC00B2A4EC00B1, 0xA4EC00B4A4EC00B3, 0xA4EC00B6A4EC00B5, 0xA4EC00B8A4EC00B7, 0xA4EC00BAA4EC00B9, 
0xA4EC00BCA4EC00BB, 0xA4EC00BEA4EC00BD, 0xA5EC0080A5EC00BF, 0xA5EC0082A5EC0081, 0xA5EC0084A5EC0083, 0xA5EC0086A5EC0085, 0xA5EC0088A5EC0087, 0xA5EC008AA5EC0089, 
0xA5EC008CA5EC008B, 0xA5EC008EA5EC008D, 0xA5EC0090A5EC008F, 0xA5EC0092A5EC0091, 0xA5EC0094A5EC0093, 0xA5EC0096A5EC0095, 0xA5EC0098A5EC0097, 0xA5EC009AA5EC0099, 
0xA5EC009CA5EC009B, 0xA5EC009EA5EC009D, 0xA5EC00A0A5EC009F, 0xA5EC00A2A5EC00A1, 0xA5EC00A4A5EC00A3, 0xA5EC00A6A5EC00A5, 0xA5EC00A8A5EC00A7, 0xA5EC00AAA5EC00A9, 
0xA5EC00ACA5EC00AB, 0xA5EC00AEA5EC00AD, 0xA5EC00B0A5EC00AF, 0xA5EC00B2A5EC00B1, 0xA5EC00B4A5EC00B3, 0xA5EC00B6A5EC00B5, 0xA5EC00B8A5EC00B7, 0xA5EC00BAA5EC00B9, 
0xA5EC00BCA5EC00BB, 0xA5EC00BEA5EC00BD, 0xA6EC0080A6EC00BF, 0xA6EC0082A6EC0081, 0xA6EC0084A6EC0083, 0xA6EC0086A6EC0085, 0xA6EC0088A6EC0087, 0xA6EC008AA6EC0089, 
0xA6EC008CA6EC008B, 0xA6EC008EA6EC008D, 0xA6EC0090A6EC008F, 0xA6EC0092A6EC0091, 0xA6EC0094A6EC0093, 0xA6EC0096A6EC0095, 0xA6EC0098A6EC0097, 0xA6EC009AA6EC0099, 
0xA6EC009CA6EC009B, 0xA6EC009EA6EC009D, 0xA6EC00A0A6EC009F, 0xA6EC00A2A6EC00A1, 0xA6EC00A4A6EC00A3, 0xA6EC00A6A6EC00A5, 0xA6EC00A8A6EC00A7, 0xA6EC00AAA6EC00A9, 
0xA6EC00ACA6EC00AB, 0xA6EC00AEA6EC00AD, 0xA6EC00B0A6EC00AF, 0xA6EC00B2A6EC00B1, 0xA6EC00B4A6EC00B3, 0xA6EC00B6A6EC00B5, 0xA6EC00B8A6EC00B7, 0xA6EC00BAA6EC00B9, 
0xA6EC00BCA6EC00BB, 0xA6EC00BEA6EC00BD, 0xA7EC0080A7EC00BF, 0xA7EC0082A7EC0081, 0xA7EC0084A7EC0083, 0xA7EC0086A7EC0085, 0xA7EC0088A7EC0087, 0xA7EC008AA7EC0089, 
0xA7EC008CA7EC008B, 0xA7EC008EA7EC008D, 0xA7EC0090A7EC008F, 0xA7EC0092A7EC0091, 0xA7EC0094A7EC0093, 0xA7EC0096A7EC0095, 0xA7EC0098A7EC0097, 0xA7EC009AA7EC0099, 
0xA7EC009CA7EC009B, 0xA7EC009EA7EC009D, 0xA7EC00A0A7EC009F, 0xA7EC00A2A7EC00A1, 0xA7EC00A4A7EC00A3, 0xA7EC00A6A7EC00A5, 0xA7EC00A8A7EC00A7, 0xA7EC00AAA7EC00A9, 
0xA7EC00ACA7EC00AB, 0xA7EC00AEA7EC00AD, 0xA7EC00B0A7EC00AF, 0xA7EC00B2A7EC00B1, 0xA7EC00B4A7EC00B3, 0xA7EC00B6A7EC00B5, 0xA7EC00B8A7EC00B7, 0xA7EC00BAA7EC00B9, 
0xA7EC00BCA7EC00BB, 0xA7EC00BEA7EC00BD, 0xA8EC0080A8EC00BF, 0xA8EC0082A8EC0081, 0xA8EC0084A8EC0083, 0xA8EC0086A8EC0085, 0xA8EC0088A8EC0087, 0xA8EC008AA8EC0089, 
0xA8EC008CA8EC008B, 0xA8EC008EA8EC008D, 0xA8EC0090A8EC008F, 0xA8EC0092A8EC0091, 0xA8EC0094A8EC0093, 0xA8EC0096A8EC0095, 0xA8EC0098A8EC0097, 0xA8EC009AA8EC0099, 
0xA8EC009CA8EC009B, 0xA8EC009EA8EC009D, 0xA8EC00A0A8EC009F, 0xA8EC00A2A8EC00A1, 0xA8EC00A4A8EC00A3, 0xA8EC00A6A8EC00A5, 0xA8EC00A8A8EC00A7, 0xA8EC00AAA8EC00A9, 
0xA8EC00ACA8EC00AB, 0xA8EC00AEA8EC00AD, 0xA8EC00B0A8EC00AF, 0xA8EC00B2A8EC00B1, 0xA8EC00B4A8EC00B3, 0xA8EC00B6A8EC00B5, 0xA8EC00B8A8EC00B7, 0xA8EC00BAA8EC00B9, 
0xA8EC00BCA8EC00BB, 0xA8EC00BEA8EC00BD, 0xA9EC0080A9EC00BF, 0xA9EC0082A9EC0081, 0xA9EC0084A9EC0083, 0xA9EC0086A9EC0085, 0xA9EC0088A9EC0087, 0xA9EC008AA9EC0089, 
0xA9EC008CA9EC008B, 0xA9EC008EA9EC008D, 0xA9EC0090A9EC008F, 0xA9EC0092A9EC0091, 0xA9EC0094A9EC0093, 0xA9EC0096A9EC0095, 0xA9EC0098A9EC0097, 0xA9EC009AA9EC0099, 
0xA9EC009CA9EC009B, 0xA9EC009EA9EC009D, 0xA9EC00A0A9EC009F, 0xA9EC00A2A9EC00A1, 0xA9EC00A4A9EC00A3, 0xA9EC00A6A9EC00A5, 0xA9EC00A8A9EC00A7, 0xA9EC00AAA9EC00A9, 
0xA9EC00ACA9EC00AB, 0xA9EC00AEA9EC00AD, 0xA9EC00B0A9EC00AF, 0xA9EC00B2A9EC00B1, 0xA9EC00B4A9EC00B3, 0xA9EC00B6A9EC00B5, 0xA9EC00B8A9EC00B7, 0xA9EC00BAA9EC00B9, 
0xA9EC00BCA9EC00BB, 0xA9EC00BEA9EC00BD, 0xAAEC0080AAEC00BF, 0xAAEC0082AAEC0081, 0xAAEC0084AAEC0083, 0xAAEC0086AAEC0085, 0xAAEC0088AAEC0087, 0xAAEC008AAAEC0089, 
0xAAEC008CAAEC008B, 0xAAEC008EAAEC008D, 0xAAEC0090AAEC008F, 0xAAEC0092AAEC0091, 0xAAEC0094AAEC0093, 0xAAEC0096AAEC0095, 0xAAEC0098AAEC0097, 0xAAEC009AAAEC0099, 
0xAAEC009CAAEC009B, 0xAAEC009EAAEC009D, 0xAAEC00A0AAEC009F, 0xAAEC00A2AAEC00A1, 0xAAEC00A4AAEC00A3, 0xAAEC00A6AAEC00A5, 0xAAEC00A8AAEC00A7, 0xAAEC00AAAAEC00A9, 
0xAAEC00ACAAEC00AB, 0xAAEC00AEAAEC00AD, 0xAAEC00B0AAEC00AF, 0xAAEC00B2AAEC00B1, 0xAAEC00B4AAEC00B3, 0xAAEC00B6AAEC00B5, 0xAAEC00B8AAEC00B7, 0xAAEC00BAAAEC00B9, 
0xAAEC00BCAAEC00BB, 0xAAEC00BEAAEC00BD, 0xABEC0080ABEC00BF, 0xABEC0082ABEC0081, 0xABEC0084ABEC0083, 0xABEC0086ABEC0085, 0xABEC0088ABEC0087, 0xABEC008AABEC0089, 
0xABEC008CABEC008B, 0xABEC008EABEC008D, 0xABEC0090ABEC008F, 0xABEC0092ABEC0091, 0xABEC0094ABEC0093, 0xABEC0096ABEC0095, 0xABEC0098ABEC0097, 0xABEC009AABEC0099, 
0xABEC009CABEC009B, 0xABEC009EABEC009D, 0xABEC00A0ABEC009F, 0xABEC00A2ABEC00A1, 0xABEC00A4ABEC00A3, 0xABEC00A6ABEC00A5, 0xABEC00A8ABEC00A7, 0xABEC00AAABEC00A9, 
0xABEC00ACABEC00AB, 0xABEC00AEABEC00AD, 0xABEC00B0ABEC00AF, 0xABEC00B2ABEC00B1, 0xABEC00B4ABEC00B3, 0xABEC00B6ABEC00B5, 0xABEC00B8ABEC00B7, 0xABEC00BAABEC00B9, 
0xABEC00BCABEC00BB, 0xABEC00BEABEC00BD, 0xACEC0080ACEC00BF, 0xACEC0082ACEC0081, 0xACEC0084ACEC0083, 0xACEC0086ACEC0085, 0xACEC0088ACEC0087, 0xACEC008AACEC0089, 
0xACEC008CACEC008B, 0xACEC008EACEC008D, 0xACEC0090ACEC008F, 0xACEC0092ACEC0091, 0xACEC0094ACEC0093, 0xACEC0096ACEC0095, 0xACEC0098ACEC0097, 0xACEC009AACEC0099, 
0xACEC009CACEC009B, 0xACEC009EACEC009D, 0xACEC00A0ACEC009F, 0xACEC00A2ACEC00A1, 0xACEC00A4ACEC00A3, 0xACEC00A6ACEC00A5, 0xACEC00A8ACEC00A7, 0xACEC00AAACEC00A9, 
0xACEC00ACACEC00AB, 0xACEC00AEACEC00AD, 0xACEC00B0ACEC00AF, 0xACEC00B2ACEC00B1, 0xACEC00B4ACEC00B3, 0xACEC00B6ACEC00B5, 0xACEC00B8ACEC00B7, 0xACEC00BAACEC00B9, 
0xACEC00BCACEC00BB, 0xACEC00BEACEC00BD, 0xADEC0080ADEC00BF, 0xADEC0082ADEC0081, 0xADEC0084ADEC0083, 0xADEC0086ADEC0085, 0xADEC0088ADEC0087, 0xADEC008AADEC0089, 
0xADEC008CADEC008B, 0xADEC008EADEC008D, 0xADEC0090ADEC008F, 0xADEC0092ADEC0091, 0xADEC0094ADEC0093, 0xADEC0096ADEC0095, 0xADEC0098ADEC0097, 0xADEC009AADEC0099, 
0xADEC009CADEC009B, 0xADEC009EADEC009D, 0xADEC00A0ADEC009F, 0xADEC00A2ADEC00A1, 0xADEC00A4ADEC00A3, 0xADEC00A6ADEC00A5, 0xADEC00A8ADEC00A7, 0xADEC00AAADEC00A9, 
0xADEC00ACADEC00AB, 0xADEC00AEADEC00AD, 0xADEC00B0ADEC00AF, 0xADEC00B2ADEC00B1, 0xADEC00B4ADEC00B3, 0xADEC00B6ADEC00B5, 0xADEC00B8ADEC00B7, 0xADEC00BAADEC00B9, 
0xADEC00BCADEC00BB, 0xADEC00BEADEC00BD, 0xAEEC0080AEEC00BF, 0xAEEC0082AEEC0081, 0xAEEC0084AEEC0083, 0xAEEC0086AEEC0085, 0xAEEC0088AEEC0087, 0xAEEC008AAEEC0089, 
0xAEEC008CAEEC008B, 0xAEEC008EAEEC008D, 0xAEEC0090AEEC008F, 0xAEEC0092AEEC0091, 0xAEEC0094AEEC0093, 0xAEEC0096AEEC0095, 0xAEEC0098AEEC0097, 0xAEEC009AAEEC0099, 
0xAEEC009CAEEC009B, 0xAEEC009EAEEC009D, 0xAEEC00A0AEEC009F, 0xAEEC00A2AEEC00A1, 0xAEEC00A4AEEC00A3, 0xAEEC00A6AEEC00A5, 0xAEEC00A8AEEC00A7, 0xAEEC00AAAEEC00A9, 
0xAEEC00ACAEEC00AB, 0xAEEC00AEAEEC00AD, 0xAEEC00B0AEEC00AF, 0xAEEC00B2AEEC00B1, 0xAEEC00B4AEEC00B3, 0xAEEC00B6AEEC00B5, 0xAEEC00B8AEEC00B7, 0xAEEC00BAAEEC00B9, 
0xAEEC00BCAEEC00BB, 0xAEEC00BEAEEC00BD, 0xAFEC0080AFEC00BF, 0xAFEC0082AFEC0081, 0xAFEC0084AFEC0083, 0xAFEC0086AFEC0085, 0xAFEC0088AFEC0087, 0xAFEC008AAFEC0089, 
0xAFEC008CAFEC008B, 0xAFEC008EAFEC008D, 0xAFEC0090AFEC008F, 0xAFEC0092AFEC0091, 0xAFEC0094AFEC0093, 0xAFEC0096AFEC0095, 0xAFEC0098AFEC0097, 0xAFEC009AAFEC0099, 
0xAFEC009CAFEC009B, 0xAFEC009EAFEC009D, 0xAFEC00A0AFEC009F, 0xAFEC00A2AFEC00A1, 0xAFEC00A4AFEC00A3, 0xAFEC00A6AFEC00A5, 0xAFEC00A8AFEC00A7, 0xAFEC00AAAFEC00A9, 
0xAFEC00ACAFEC00AB, 0xAFEC00AEAFEC00AD, 0xAFEC00B0AFEC00AF, 0xAFEC00B2AFEC00B1, 0xAFEC00B4AFEC00B3, 0xAFEC00B6AFEC00B5, 0xAFEC00B8AFEC00B7, 0xAFEC00BAAFEC00B9, 
0xAFEC00BCAFEC00BB, 0xAFEC00BEAFEC00BD, 0xB0EC0080B0EC00BF, 0xB0EC0082B0EC0081, 0xB0EC0084B0EC0083, 0xB0EC0086B0EC0085, 0xB0EC0088B0EC0087, 0xB0EC008AB0EC0089, 
0xB0EC008CB0EC008B, 0xB0EC008EB0EC008D, 0xB0EC0090B0EC008F, 0xB0EC0092B0EC0091, 0xB0EC0094B0EC0093, 0xB0EC0096B0EC0095, 0xB0EC0098B0EC0097, 0xB0EC009AB0EC0099, 
0xB0EC009CB0EC009B, 0xB0EC009EB0EC009D, 0xB0EC00A0B0EC009F, 0xB0EC00A2B0EC00A1, 0xB0EC00A4B0EC00A3, 0xB0EC00A6B0EC00A5, 0xB0EC00A8B0EC00A7, 0xB0EC00AAB0EC00A9, 
0xB0EC00ACB0EC00AB, 0xB0EC00AEB0EC00AD, 0xB0EC00B0B0EC00AF, 0xB0EC00B2B0EC00B1, 0xB0EC00B4B0EC00B3, 0xB0EC00B6B0EC00B5, 0xB0EC00B8B0EC00B7, 0xB9B0EC00A0B3EAB8, 
0xBBB0EC00BAB0EC00, 0xBDB0EC00BCB0EC00, 0xBFB0EC00BEB0EC00, 0x81B1EC0080B1EC00, 0x83B1EC0082B1EC00, 0x85B1EC0084B1EC00, 0x87B1EC0086B1EC00, 0x89B1EC0088B1EC00, 
0x8BB1EC008AB1EC00, 0x8DB1EC008CB1EC00, 0x8FB1EC008EB1EC00, 0x91B1EC0090B1EC00, 0x93B1EC0092B1EC00, 0x95B1EC0094B1EC00, 0x97B1EC0096B1EC00, 0x99B1EC0098B1EC00, 
0x9BB1EC009AB1EC00, 0x9DB1EC009CB1EC00, 0x9FB1EC009EB1EC00, 0xA1B1EC00A0B1EC00, 0xA3B1EC00A2B1EC00, 0xA5B1EC00A4B1EC00, 0xA7B1EC00A6B1EC00, 0xA9B1EC00A8B1EC00, 
0xABB1EC00AAB1EC00, 0xADB1EC00ACB1EC00, 0xAFB1EC00AEB1EC00, 0xB1B1EC00B0B1EC00, 0xB3B1EC00B2B1EC00, 0xB5B1EC00B4B1EC00, 0xB7B1EC00B6B1EC00, 0xB9B1EC00B8B1EC00, 
0xBBB1EC00BAB1EC00, 0xBDB1EC00BCB1EC00, 0xBFB1EC00BEB1EC00, 0x81B2EC0080B2EC00, 0x83B2EC0082B2EC00, 0x85B2EC0084B2EC00, 0x87B2EC0086B2EC00, 0x89B2EC0088B2EC00, 
0x8BB2EC008AB2EC00, 0x8DB2EC008CB2EC00, 0x8FB2EC008EB2EC00, 0x91B2EC0090B2EC00, 0x93B2EC0092B2EC00, 0x95B2EC0094B2EC00, 0x97B2EC0096B2EC00, 0x99B2EC0098B2EC00, 
0x9BB2EC009AB2EC00, 0x9DB2EC009CB2EC00, 0x9FB2EC009EB2EC00, 0xA1B2EC00A0B2EC00, 0xA3B2EC00A2B2EC00, 0xA5B2EC00A4B2EC00, 0xA7B2EC00A6B2EC00, 0xA9B2EC00A8B2EC00, 
0xABB2EC00AAB2EC00, 0xADB2EC00ACB2EC00, 0xAFB2EC00AEB2EC00, 0xB1B2EC00B0B2EC00, 0xB3B2EC00B2B2EC00, 0xB5B2EC00B4B2EC00, 0xB7B2EC00B6B2EC00, 0xB9B2EC00B8B2EC00, 
0xBBB2EC00BAB2EC00, 0xBDB2EC00BCB2EC00, 0xBFB2EC00BEB2EC00, 0x81B3EC0080B3EC00, 0x83B3EC0082B3EC00, 0x85B3EC0084B3EC00, 0x87B3EC0086B3EC00, 0x89B3EC0088B3EC00, 
0x8BB3EC008AB3EC00, 0x8DB3EC008CB3EC00, 0x8FB3EC008EB3EC00, 0x91B3EC0090B3EC00, 0x93B3EC0092B3EC00, 0x95B3EC0094B3EC00, 0x97B3EC0096B3EC00, 0x99B3EC0098B3EC00, 
0x9BB3EC009AB3EC00, 0x9DB3EC009CB3EC00, 0x9FB3EC009EB3EC00, 0xA1B3EC00A0B3EC00, 0xA3B3EC00A2B3EC00, 0xA5B3EC00A4B3EC00, 0xA7B3EC00A6B3EC00, 0xA9B3EC00A8B3EC00, 
0xABB3EC00AAB3EC00, 0xADB3EC00ACB3EC00, 0xAFB3EC00AEB3EC00, 0xB1B3EC00B0B3EC00, 0xB3B3EC00B2B3EC00, 0xB5B3EC00B4B3EC00, 0xB7B3EC00B6B3EC00, 0xB9B3EC00B8B3EC00, 
0xBBB3EC00BAB3EC00, 0xBDB3EC00BCB3EC00, 0xBFB3EC00BEB3EC00, 0x81B4EC0080B4EC00, 0x83B4EC0082B4EC00, 0x85B4EC0084B4EC00, 0x87B4EC0086B4EC00, 0x89B4EC0088B4EC00, 
0x8BB4EC008AB4EC00, 0x8DB4EC008CB4EC00, 0x8FB4EC008EB4EC00, 0x91B4EC0090B4EC00, 0x93B4EC0092B4EC00, 0x95B4EC0094B4EC00, 0x97B4EC0096B4EC00, 0x99B4EC0098B4EC00, 
0x9BB4EC009AB4EC00, 0x9DB4EC009CB4EC00, 0x9FB4EC009EB4EC00, 0xA1B4EC00A0B4EC00, 0xA3B4EC00A2B4EC00, 0xA5B4EC00A4B4EC00, 0xA7B4EC00A6B4EC00, 0xA9B4EC00A8B4EC00, 
0xABB4EC00AAB4EC00, 0xADB4EC00ACB4EC00, 0xAFB4EC00AEB4EC00, 0xB1B4EC00B0B4EC00, 0xB3B4EC00B2B4EC00, 0xB5B4EC00B4B4EC00, 0xB7B4EC00B6B4EC00, 0xB9B4EC00B8B4EC00, 
0xBBB4EC00BAB4EC00, 0xBDB4EC00BCB4EC00, 0xBFB4EC00BEB4EC00, 0x81B5EC0080B5EC00, 0x83B5EC0082B5EC00, 0x85B5EC0084B5EC00, 0x87B5EC0086B5EC00, 0x89B5EC0088B5EC00, 
0x8BB5EC008AB5EC00, 0x8DB5EC008CB5EC00, 0x8FB5EC008EB5EC00, 0x91B5EC0090B5EC00, 0x93B5EC0092B5EC00, 0x95B5EC0094B5EC00, 0x97B5EC0096B5EC00, 0x99B5EC0098B5EC00, 
0x9BB5EC009AB5EC00, 0x9DB5EC009CB5EC00, 0x9FB5EC009EB5EC00, 0xA1B5EC00A0B5EC00, 0xA3B5EC00A2B5EC00, 0xA5B5EC00A4B5EC00, 0xA7B5EC00A6B5EC00, 0xA9B5EC00A8B5EC00, 
0xABB5EC00AAB5EC00, 0xADB5EC00ACB5EC00, 0xAFB5EC00AEB5EC00, 0xB1B5EC00B0B5EC00, 0xB3B5EC00B2B5EC00, 0xB5B5EC00B4B5EC00, 0xB7B5EC00B6B5EC00, 0xB9B5EC00B8B5EC00, 
0xBBB5EC00BAB5EC00, 0xBDB5EC00BCB5EC00, 0xBFB5EC00BEB5EC00, 0x81B6EC0080B6EC00, 0x83B6EC0082B6EC00, 0x85B6EC0084B6EC00, 0x87B6EC0086B6EC00, 0x89B6EC0088B6EC00, 
0x8BB6EC008AB6EC00, 0x8DB6EC008CB6EC00, 0x8FB6EC008EB6EC00, 0x91B6EC0090B6EC00, 0x93B6EC0092B6EC00, 0x95B6EC0094B6EC00, 0x97B6EC0096B6EC00, 0x99B6EC0098B6EC00, 
0x9BB6EC009AB6EC00, 0x9DB6EC009CB6EC00, 0x9FB6EC009EB6EC00, 0xA1B6EC00A0B6EC00, 0xA3B6EC00A2B6EC00, 0xA5B6EC00A4B6EC00, 0xA7B6EC00A6B6EC00, 0xA9B6EC00A8B6EC00, 
0xABB6EC00AAB6EC00, 0xADB6EC00ACB6EC00, 0xAFB6EC00AEB6EC00, 0xB1B6EC00B0B6EC00, 0xB3B6EC00B2B6EC00, 0xB5B6EC00B4B6EC00, 0xB7B6EC00B6B6EC00, 0xB9B6EC00B8B6EC00, 
0xBBB6EC00BAB6EC00, 0xBDB6EC00BCB6EC00, 0xBFB6EC00BEB6EC00, 0x81B7EC0080B7EC00, 0x83B7EC0082B7EC00, 0x85B7EC0084B7EC00, 0x87B7EC0086B7EC00, 0x89B7EC0088B7EC00, 
0x8BB7EC008AB7EC00, 0x8DB7EC008CB7EC00, 0x8FB7EC008EB7EC00, 0x91B7EC0090B7EC00, 0x93B7EC0092B7EC00, 0x95B7EC0094B7EC00, 0x97B7EC0096B7EC00, 0x99B7EC0098B7EC00, 
0x9BB7EC009AB7EC00, 0x9DB7EC009CB7EC00, 0x9FB7EC009EB7EC00, 0xA1B7EC00A0B7EC00, 0xA3B7EC00A2B7EC00, 0xA5B7EC00A4B7EC00, 0xA7B7EC00A6B7EC00, 0xA9B7EC00A8B7EC00, 
0xABB7EC00AAB7EC00, 0xADB7EC00ACB7EC00, 0xAFB7EC00AEB7EC00, 0xB1B7EC00B0B7EC00, 0xB3B7EC00B2B7EC00, 0xB5B7EC00B4B7EC00, 0xB7B7EC00B6B7EC00, 0xB9B7EC00B8B7EC00, 
0xBBB7EC00BAB7EC00, 0xBDB7EC00BCB7EC00, 0xBFB7EC00BEB7EC00, 0x81B8EC0080B8EC00, 0x83B8EC0082B8EC00, 0x85B8EC0084B8EC00, 0x87B8EC0086B8EC00, 0x89B8EC0088B8EC00, 
0x8BB8EC008AB8EC00, 0x8DB8EC008CB8EC00, 0x8FB8EC008EB8EC00, 0x91B8EC0090B8EC00, 0x93B8EC0092B8EC00, 0x95B8EC0094B8EC00, 0x97B8EC0096B8EC00, 0x99B8EC0098B8EC00, 
0x9BB8EC009AB8EC00, 0x9DB8EC009CB8EC00, 0x9FB8EC009EB8EC00, 0xA1B8EC00A0B8EC00, 0xA3B8EC00A2B8EC00, 0xA5B8EC00A4B8EC00, 0xA7B8EC00A6B8EC00, 0xA9B8EC00A8B8EC00, 
0xABB8EC00AAB8EC00, 0xADB8EC00ACB8EC00, 0xAFB8EC00AEB8EC00, 0xB1B8EC00B0B8EC00, 0xB3B8EC00B2B8EC00, 0xB5B8EC00B4B8EC00, 0xB7B8EC00B6B8EC00, 0xB9B8EC00B8B8EC00, 
0xBBB8EC00BAB8EC00, 0xBDB8EC00BCB8EC00, 0xBFB8EC00BEB8EC00, 0x81B9EC0080B9EC00, 0x83B9EC0082B9EC00, 0x85B9EC0084B9EC00, 0x87B9EC0086B9EC00, 0x89B9EC0088B9EC00, 
0x8BB9EC008AB9EC00, 0x8DB9EC008CB9EC00, 0x8FB9EC008EB9EC00, 0x91B9EC0090B9EC00, 0x93B9EC0092B9EC00, 0x95B9EC0094B9EC00, 0x97B9EC0096B9EC00, 0x99B9EC0098B9EC00, 
0x9BB9EC009AB9EC00, 0x9DB9EC009CB9EC00, 0x9FB9EC009EB9EC00, 0xA1B9EC00A0B9EC00, 0xA3B9EC00A2B9EC00, 0xA5B9EC00A4B9EC00, 0xA7B9EC00A6B9EC00, 0xA9B9EC00A8B9EC00, 
0xABB9EC00AAB9EC00, 0xADB9EC00ACB9EC00, 0xAFB9EC00AEB9EC00, 0xB1B9EC00B0B9EC00, 0xB3B9EC00B2B9EC00, 0xB5B9EC00B4B9EC00, 0xB7B9EC00B6B9EC00, 0xB9B9EC00B8B9EC00, 
0xBBB9EC00BAB9EC00, 0xBDB9EC00BCB9EC00, 0xBFB9EC00BEB9EC00, 0x81BAEC0080BAEC00, 0x83BAEC0082BAEC00, 0x85BAEC0084BAEC00, 0x87BAEC0086BAEC00, 0x89BAEC0088BAEC00, 
0x8BBAEC008ABAEC00, 0x8DBAEC008CBAEC00, 0x8FBAEC008EBAEC00, 0x91BAEC0090BAEC00, 0x93BAEC0092BAEC00, 0x95BAEC0094BAEC00, 0x97BAEC0096BAEC00, 0x99BAEC0098BAEC00, 
0x9BBAEC009ABAEC00, 0x9DBAEC009CBAEC00, 0x9FBAEC009EBAEC00, 0xA1BAEC00A0BAEC00, 0xA3BAEC00A2BAEC00, 0xA5BAEC00A4BAEC00, 0xA7BAEC00A6BAEC00, 0xA9BAEC00A8BAEC00, 
0xABBAEC00AABAEC00, 0xADBAEC00ACBAEC00, 0xAFBAEC00AEBAEC00, 0xB1BAEC00B0BAEC00, 0xB3BAEC00B2BAEC00, 0xB5BAEC00B4BAEC00, 0xB7BAEC00B6BAEC00, 0xB9BAEC00B8BAEC00, 
0xBBBAEC00BABAEC00, 0xBDBAEC00BCBAEC00, 0xBFBAEC00BEBAEC00, 0x81BBEC0080BBEC00, 0x83BBEC0082BBEC00, 0x85BBEC0084BBEC00, 0x87BBEC0086BBEC00, 0x89BBEC0088BBEC00, 
0x8BBBEC008ABBEC00, 0x8DBBEC008CBBEC00, 0x8FBBEC008EBBEC00, 0x91BBEC0090BBEC00, 0x93BBEC0092BBEC00, 0x95BBEC0094BBEC00, 0x97BBEC0096BBEC00, 0x99BBEC0098BBEC00, 
0x9BBBEC009ABBEC00, 0x9DBBEC009CBBEC00, 0x9FBBEC009EBBEC00, 0xA1BBEC00A0BBEC00, 0xA3BBEC00A2BBEC00, 0xA5BBEC00A4BBEC00, 0xA7BBEC00A6BBEC00, 0xA9BBEC00A8BBEC00, 
0xABBBEC00AABBEC00, 0xADBBEC00ACBBEC00, 0xAFBBEC00AEBBEC00, 0xB1BBEC00B0BBEC00, 0xB3BBEC00B2BBEC00, 0xB5BBEC00B4BBEC00, 0xB7BBEC00B6BBEC00, 0xB9BBEC00B8BBEC00, 
0xBBBBEC00BABBEC00, 0xBDBBEC00BCBBEC00, 0xBFBBEC00BEBBEC00, 0x81BCEC0080BCEC00, 0x83BCEC0082BCEC00, 0x85BCEC0084BCEC00, 0x87BCEC0086BCEC00, 0x89BCEC0088BCEC00, 
0x8BBCEC008ABCEC00, 0x8DBCEC008CBCEC00, 0x8FBCEC008EBCEC00, 0x91BCEC0090BCEC00, 0x93BCEC0092BCEC00, 0x95BCEC0094BCEC00, 0x97BCEC0096BCEC00, 0x99BCEC0098BCEC00, 
0x9BBCEC009ABCEC00, 0x9DBCEC009CBCEC00, 0x9FBCEC009EBCEC00, 0xA1BCEC00A0BCEC00, 0xA3BCEC00A2BCEC00, 0xA5BCEC00A4BCEC00, 0xA7BCEC00A6BCEC00, 0xA9BCEC00A8BCEC00, 
0xABBCEC00AABCEC00, 0xADBCEC00ACBCEC00, 0xAFBCEC00AEBCEC00, 0xB1BCEC00B0BCEC00, 0xB3BCEC00B2BCEC00, 0xB5BCEC00B4BCEC00, 0xB7BCEC00B6BCEC00, 0xB9BCEC00B8BCEC00, 
0xBBBCEC00BABCEC00, 0xBDBCEC00BCBCEC00, 0xBFBCEC00BEBCEC00, 0x81BDEC0080BDEC00, 0x83BDEC0082BDEC00, 0x85BDEC0084BDEC00, 0x87BDEC0086BDEC00, 0x89BDEC0088BDEC00, 
0x8BBDEC008ABDEC00, 0x8DBDEC008CBDEC00, 0x8FBDEC008EBDEC00, 0x91BDEC0090BDEC00, 0x93BDEC0092BDEC00, 0x95BDEC0094BDEC00, 0x97BDEC0096BDEC00, 0x99BDEC0098BDEC00, 
0x9BBDEC009ABDEC00, 0x9DBDEC009CBDEC00, 0x9FBDEC009EBDEC00, 0xA1BDEC00A0BDEC00, 0xA3BDEC00A2BDEC00, 0xA5BDEC00A4BDEC00, 0xA7BDEC00A6BDEC00, 0xA9BDEC00A8BDEC00, 
0xABBDEC00AABDEC00, 0xADBDEC00ACBDEC00, 0xAFBDEC00AEBDEC00, 0xB1BDEC00B0BDEC00, 0xB3BDEC00B2BDEC00, 0xB5BDEC00B4BDEC00, 0xB7BDEC00B6BDEC00, 0xB9BDEC00B8BDEC00, 
0xBBBDEC00BABDEC00, 0xBDBDEC00BCBDEC00, 0xBFBDEC00BEBDEC00, 0x81BEEC0080BEEC00, 0x83BEEC0082BEEC00, 0x85BEEC0084BEEC00, 0x87BEEC0086BEEC00, 0x89BEEC0088BEEC00, 
0x8BBEEC008ABEEC00, 0x8DBEEC008CBEEC00, 0x8FBEEC008EBEEC00, 0x91BEEC0090BEEC00, 0x93BEEC0092BEEC00, 0x95BEEC0094BEEC00, 0x97BEEC0096BEEC00, 0x99BEEC0098BEEC00, 
0x9BBEEC009ABEEC00, 0x9DBEEC009CBEEC00, 0x9FBEEC009EBEEC00, 0xA1BEEC00A0BEEC00, 0xA3BEEC00A2BEEC00, 0xA5BEEC00A4BEEC00, 0xA7BEEC00A6BEEC00, 0xA9BEEC00A8BEEC00, 
0xABBEEC00AABEEC00, 0xADBEEC00ACBEEC00, 0xAFBEEC00AEBEEC00, 0xB1BEEC00B0BEEC00, 0xB3BEEC00B2BEEC00, 0xB5BEEC00B4BEEC00, 0xB7BEEC00B6BEEC00, 0xB9BEEC00B8BEEC00, 
0xBBBEEC00BABEEC00, 0xBDBEEC00BCBEEC00, 0xBFBEEC00BEBEEC00, 0x81BFEC0080BFEC00, 0x83BFEC0082BFEC00, 0x85BFEC0084BFEC00, 0x87BFEC0086BFEC00, 0x89BFEC0088BFEC00, 
0x8BBFEC008ABFEC00, 0x8DBFEC008CBFEC00, 0x8FBFEC008EBFEC00, 0x91BFEC0090BFEC00, 0x93BFEC0092BFEC00, 0x95BFEC0094BFEC00, 0x97BFEC0096BFEC00, 0x99BFEC0098BFEC00, 
0x9BBFEC009ABFEC00, 0x9DBFEC009CBFEC00, 0x9FBFEC009EBFEC00, 0xA1BFEC00A0BFEC00, 0xA3BFEC00A2BFEC00, 0xA5BFEC00A4BFEC00, 0xA7BFEC00A6BFEC00, 0xA9BFEC00A8BFEC00, 
0xABBFEC00AABFEC00, 0xADBFEC00ACBFEC00, 0xAFBFEC00AEBFEC00, 0xB1BFEC00B0BFEC00, 0xB3BFEC00B2BFEC00, 0xB5BFEC00B4BFEC00, 0xB7BFEC00B6BFEC00, 0xB9BFEC00B8BFEC00, 
0xBBBFEC00BABFEC00, 0xBDBFEC00BCBFEC00, 0xBFBFEC00BEBFEC00, 0x8180ED008080ED00, 0x8380ED008280ED00, 0x8580ED008480ED00, 0x8780ED008680ED00, 0x8980ED008880ED00, 
0x8B80ED008A80ED00, 0x8D80ED008C80ED00, 0x8F80ED008E80ED00, 0x9180ED009080ED00, 0x9380ED009280ED00, 0x9580ED009480ED00, 0x9780ED009680ED00, 0x9980ED009880ED00, 
0x9B80ED009A80ED00, 0x9D80ED009C80ED00, 0x9F80ED009E80ED00, 0xA180ED00A080ED00, 0xA380ED00A280ED00, 0xA580ED00A480ED00, 0xA780ED00A680ED00, 0xA980ED00A880ED00, 
0xAB80ED00AA80ED00, 0xAD80ED00AC80ED00, 0xAF80ED00AE80ED00, 0xB180ED00B080ED00, 0xB380ED00B280ED00, 0xB580ED00B480ED00, 0xB780ED00B680ED00, 0xB980ED00B880ED00, 
0xBB80ED00BA80ED00, 0xBD80ED00BC80ED00, 0xBF80ED00BE80ED00, 0x8181ED008081ED00, 0x8381ED008281ED00, 0x8581ED008481ED00, 0x8781ED008681ED00, 0x8981ED008881ED00, 
0x8B81ED008A81ED00, 0x8D81ED008C81ED00, 0x8F81ED008E81ED00, 0x9181ED009081ED00, 0x9381ED009281ED00, 0x9581ED009481ED00, 0x9781ED009681ED00, 0x9981ED009881ED00, 
0x9B81ED009A81ED00, 0x9D81ED009C81ED00, 0x9F81ED009E81ED00, 0xA181ED00A081ED00, 0xA381ED00A281ED00, 0xA581ED00A481ED00, 0xA781ED00A681ED00, 0xA981ED00A881ED00, 
0xAB81ED00AA81ED00, 0xAD81ED00AC81ED00, 0xAF81ED00AE81ED00, 0xB181ED00B081ED00, 0xB381ED00B281ED00, 0xB581ED00B481ED00, 0xB781ED00B681ED00, 0xB981ED00B881ED00, 
0xBB81ED00BA81ED00, 0xBD81ED00BC81ED00, 0xBF81ED00BE81ED00, 0x8182ED008082ED00, 0x8382ED008282ED00, 0x8582ED008482ED00, 0x8782ED008682ED00, 0x8982ED008882ED00, 
0x8B82ED008A82ED00, 0x8D82ED008C82ED00, 0x8F82ED008E82ED00, 0x9182ED009082ED00, 0x9382ED009282ED00, 0x9582ED009482ED00, 0x9782ED009682ED00, 0x9982ED009882ED00, 
0x9B82ED009A82ED00, 0x9D82ED009C82ED00, 0x9F82ED009E82ED00, 0xA182ED00A082ED00, 0xA382ED00A282ED00, 0xA582ED00A482ED00, 0xA782ED00A682ED00, 0xA982ED00A882ED00, 
0xAB82ED00AA82ED00, 0xAD82ED00AC82ED00, 0xAF82ED00AE82ED00, 0xB182ED00B082ED00, 0xB382ED00B282ED00, 0xB582ED00B482ED00, 0xB782ED00B682ED00, 0xB982ED00B882ED00, 
0xBB82ED00BA82ED00, 0xBD82ED00BC82ED00, 0xBF82ED00BE82ED00, 0x8183ED008083ED00, 0x8383ED008283ED00, 0x8583ED008483ED00, 0x8783ED008683ED00, 0x8983ED008883ED00, 
0x8B83ED008A83ED00, 0x8D83ED008C83ED00, 0x8F83ED008E83ED00, 0x9183ED009083ED00, 0x9383ED009283ED00, 0x9583ED009483ED00, 0x9783ED009683ED00, 0x9983ED009883ED00, 
0x9B83ED009A83ED00, 0x9D83ED009C83ED00, 0x9F83ED009E83ED00, 0xA183ED00A083ED00, 0xA383ED00A283ED00, 0xA583ED00A483ED00, 0xA783ED00A683ED00, 0xA983ED00A883ED00, 
0xAB83ED00AA83ED00, 0xAD83ED00AC83ED00, 0xAF83ED00AE83ED00, 0xB183ED00B083ED00, 0xB383ED00B283ED00, 0xB583ED00B483ED00, 0xB783ED00B683ED00, 0xB983ED00B883ED00, 
0xBB83ED00BA83ED00, 0xBD83ED00BC83ED00, 0xBF83ED00BE83ED00, 0x8184ED008084ED00, 0x8384ED008284ED00, 0x8584ED008484ED00, 0x8784ED008684ED00, 0x8984ED008884ED00, 
0x8B84ED008A84ED00, 0x8D84ED008C84ED00, 0x8F84ED008E84ED00, 0x9184ED009084ED00, 0x9384ED009284ED00, 0x9584ED009484ED00, 0x9784ED009684ED00, 0x9984ED009884ED00, 
0x9B84ED009A84ED00, 0x9D84ED009C84ED00, 0x9F84ED009E84ED00, 0xA184ED00A084ED00, 0xA384ED00A284ED00, 0xA584ED00A484ED00, 0xA784ED00A684ED00, 0xA984ED00A884ED00, 
0xAB84ED00AA84ED00, 0xAD84ED00AC84ED00, 0xAF84ED00AE84ED00, 0xB184ED00B084ED00, 0xB384ED00B284ED00, 0xB584ED00B484ED00, 0xB784ED00B684ED00, 0xB984ED00B884ED00, 
0xBB84ED00BA84ED00, 0xBD84ED00BC84ED00, 0xBF84ED00BE84ED00, 0x8185ED008085ED00, 0x8385ED008285ED00, 0x8585ED008485ED00, 0x8785ED008685ED00, 0x8985ED008885ED00, 
0x8B85ED008A85ED00, 0x8D85ED008C85ED00, 0x8F85ED008E85ED00, 0x9185ED009085ED00, 0x9385ED009285ED00, 0x9585ED009485ED00, 0x9785ED009685ED00, 0x9985ED009885ED00, 
0x9B85ED009A85ED00, 0x9D85ED009C85ED00, 0x9F85ED009E85ED00, 0xA185ED00A085ED00, 0xA385ED00A285ED00, 0xA585ED00A485ED00, 0xA785ED00A685ED00, 0xA985ED00A885ED00, 
0xAB85ED00AA85ED00, 0xAD85ED00AC85ED00, 0xAF85ED00AE85ED00, 0xB185ED00B085ED00, 0xB385ED00B285ED00, 0xB585ED00B485ED00, 0xB785ED00B685ED00, 0xB985ED00B885ED00, 
0xBB85ED00BA85ED00, 0xBD85ED00BC85ED00, 0xBF85ED00BE85ED00, 0x8186ED008086ED00, 0x8386ED008286ED00, 0x8586ED008486ED00, 0x8786ED008686ED00, 0x8986ED008886ED00, 
0x8B86ED008A86ED00, 0x8D86ED008C86ED00, 0x8F86ED008E86ED00, 0x9186ED009086ED00, 0x9386ED009286ED00, 0x9586ED009486ED00, 0x9786ED009686ED00, 0x9986ED009886ED00, 
0x9B86ED009A86ED00, 0x9D86ED009C86ED00, 0x9F86ED009E86ED00, 0xA186ED00A086ED00, 0xA386ED00A286ED00, 0xA586ED00A486ED00, 0xA786ED00A686ED00, 0xA986ED00A886ED00, 
0xAB86ED00AA86ED00, 0xAD86ED00AC86ED00, 0xAF86ED00AE86ED00, 0xB186ED00B086ED00, 0xB386ED00B286ED00, 0xB586ED00B486ED00, 0xB786ED00B686ED00, 0xB986ED00B886ED00, 
0xBB86ED00BA86ED00, 0xBD86ED00BC86ED00, 0xBF86ED00BE86ED00, 0x8187ED008087ED00, 0x8387ED008287ED00, 0x8587ED008487ED00, 0x8787ED008687ED00, 0x8987ED008887ED00, 
0x8B87ED008A87ED00, 0x8D87ED008C87ED00, 0x8F87ED008E87ED00, 0x9187ED009087ED00, 0x9387ED009287ED00, 0x9587ED009487ED00, 0x9787ED009687ED00, 0x9987ED009887ED00, 
0x9B87ED009A87ED00, 0x9D87ED009C87ED00, 0x9F87ED009E87ED00, 0xA187ED00A087ED00, 0xA387ED00A287ED00, 0xA587ED00A487ED00, 0xA787ED00A687ED00, 0xA987ED00A887ED00, 
0xAB87ED00AA87ED00, 0xAD87ED00AC87ED00, 0xAF87ED00AE87ED00, 0xB187ED00B087ED00, 0xB387ED00B287ED00, 0xB587ED00B487ED00, 0xB787ED00B687ED00, 0xB987ED00B887ED00, 
0xBB87ED00BA87ED00, 0xBD87ED00BC87ED00, 0xBF87ED00BE87ED00, 0x8188ED008088ED00, 0x8388ED008288ED00, 0x8588ED008488ED00, 0x8788ED008688ED00, 0x8988ED008888ED00, 
0x8B88ED008A88ED00, 0x8D88ED008C88ED00, 0x8F88ED008E88ED00, 0x9188ED009088ED00, 0x9388ED009288ED00, 0x9588ED009488ED00, 0x9788ED009688ED00, 0x9988ED009888ED00, 
0x9B88ED009A88ED00, 0x9D88ED009C88ED00, 0x9F88ED009E88ED00, 0xA188ED00A088ED00, 0xA388ED00A288ED00, 0xA588ED00A488ED00, 0xA788ED00A688ED00, 0xA988ED00A888ED00, 
0xAB88ED00AA88ED00, 0xAD88ED00AC88ED00, 0xAF88ED00AE88ED00, 0xB188ED00B088ED00, 0xB388ED00B288ED00, 0xB588ED00B488ED00, 0xB788ED00B688ED00, 0xB988ED00B888ED00, 
0xBB88ED00BA88ED00, 0xBD88ED00BC88ED00, 0xBF88ED00BE88ED00, 0x8189ED008089ED00, 0x8389ED008289ED00, 0x8589ED008489ED00, 0x8789ED008689ED00, 0x8989ED008889ED00, 
0x8B89ED008A89ED00, 0x8D89ED008C89ED00, 0x8F89ED008E89ED00, 0x9189ED009089ED00, 0x9389ED009289ED00, 0x9589ED009489ED00, 0x9789ED009689ED00, 0x9989ED009889ED00, 
0x9B89ED009A89ED00, 0x9D89ED009C89ED00, 0x9F89ED009E89ED00, 0xA189ED00A089ED00, 0xA389ED00A289ED00, 0xA589ED00A489ED00, 0xA789ED00A689ED00, 0xA989ED00A889ED00, 
0xAB89ED00AA89ED00, 0xAD89ED00AC89ED00, 0xAF89ED00AE89ED00, 0xB189ED00B089ED00, 0xB389ED00B289ED00, 0xB589ED00B489ED00, 0xB789ED00B689ED00, 0xB989ED00B889ED00, 
0xBB89ED00BA89ED00, 0xBD89ED00BC89ED00, 0xBF89ED00BE89ED00, 0x818AED00808AED00, 0x838AED00828AED00, 0x858AED00848AED00, 0x878AED00868AED00, 0x898AED00888AED00, 
0x8B8AED008A8AED00, 0x8D8AED008C8AED00, 0x8F8AED008E8AED00, 0x918AED00908AED00, 0x938AED00928AED00, 0x958AED00948AED00, 0x978AED00968AED00, 0x998AED00988AED00, 
0x9B8AED009A8AED00, 0x9D8AED009C8AED00, 0x9F8AED009E8AED00, 0xA18AED00A08AED00, 0xA38AED00A28AED00, 0xA58AED00A48AED00, 0xA78AED00A68AED00, 0xA98AED00A88AED00, 
0xAB8AED00AA8AED00, 0xAD8AED00AC8AED00, 0xAF8AED00AE8AED00, 0xB18AED00B08AED00, 0xB38AED00B28AED00, 0xB58AED00B48AED00, 0xB78AED00B68AED00, 0xB98AED00B88AED00, 
0xBB8AED00BA8AED00, 0xBD8AED00BC8AED00, 0xBF8AED00BE8AED00, 0x818BED00808BED00, 0x838BED00828BED00, 0x858BED00848BED00, 0x878BED00868BED00, 0x898BED00888BED00, 
0x8B8BED008A8BED00, 0x8D8BED008C8BED00, 0x8F8BED008E8BED00, 0x918BED00908BED00, 0x938BED00928BED00, 0x958BED00948BED00, 0x978BED00968BED00, 0x998BED00988BED00, 
0x9B8BED009A8BED00, 0x9D8BED009C8BED00, 0x9F8BED009E8BED00, 0xA18BED00A08BED00, 0xA38BED00A28BED00, 0xA58BED00A48BED00, 0xA78BED00A68BED00, 0xA98BED00A88BED00, 
0xAB8BED00AA8BED00, 0xAD8BED00AC8BED00, 0xAF8BED00AE8BED00, 0xB18BED00B08BED00, 0xB38BED00B28BED00, 0xB58BED00B48BED00, 0xB78BED00B68BED00, 0xB98BED00B88BED00, 
0xBB8BED00BA8BED00, 0xBD8BED00BC8BED00, 0xBF8BED00BE8BED00, 0x818CED00808CED00, 0x838CED00828CED00, 0x858CED00848CED00, 0x878CED00868CED00, 0x898CED00888CED00, 
0x8B8CED008A8CED00, 0x8D8CED008C8CED00, 0x8F8CED008E8CED00, 0x918CED00908CED00, 0x938CED00928CED00, 0x958CED00948CED00, 0x978CED00968CED00, 0x998CED00988CED00, 
0x9B8CED009A8CED00, 0x9D8CED009C8CED00, 0x9F8CED009E8CED00, 0xA18CED00A08CED00, 0xA38CED00A28CED00, 0xA58CED00A48CED00, 0xA78CED00A68CED00, 0xA98CED00A88CED00, 
0xAB8CED00AA8CED00, 0xAD8CED00AC8CED00, 0xAF8CED00AE8CED00, 0xB18CED00B08CED00, 0xB38CED00B28CED00, 0xB58CED00B48CED00, 0xB78CED00B68CED00, 0xB98CED00B88CED00, 
0xBB8CED00BA8CED00, 0xBD8CED00BC8CED00, 0xBF8CED00BE8CED00, 0x818DED00808DED00, 0x838DED00828DED00, 0x858DED00848DED00, 0x878DED00868DED00, 0x898DED00888DED00, 
0x8B8DED008A8DED00, 0x8D8DED008C8DED00, 0x8F8DED008E8DED00, 0x918DED00908DED00, 0x938DED00928DED00, 0x958DED00948DED00, 0x978DED00968DED00, 0x998DED00988DED00, 
0x9B8DED009A8DED00, 0x9D8DED009C8DED00, 0x9F8DED009E8DED00, 0xA18DED00A08DED00, 0xA38DED00A28DED00, 0xA58DED00A48DED00, 0xA78DED00A68DED00, 0xA98DED00A88DED00, 
0xAB8DED00AA8DED00, 0xAD8DED00AC8DED00, 0xAF8DED00AE8DED00, 0xB18DED00B08DED00, 0xB38DED00B28DED00, 0xB58DED00B48DED00, 0xB78DED00B68DED00, 0xB98DED00B88DED00, 
0xBB8DED00BA8DED00, 0xBD8DED00BC8DED00, 0xBF8DED00BE8DED00, 0x818EED00808EED00, 0x838EED00828EED00, 0x858EED00848EED00, 0x878EED00868EED00, 0x898EED00888EED00, 
0x8B8EED008A8EED00, 0x8D8EED008C8EED00, 0x8F8EED008E8EED00, 0x918EED00908EED00, 0x938EED00928EED00, 0x958EED00948EED00, 0x978EED00968EED00, 0x998EED00988EED00, 
0x9B8EED009A8EED00, 0x9D8EED009C8EED00, 0x9F8EED009E8EED00, 0xA18EED00A08EED00, 0xA38EED00A28EED00, 0xA58EED00A48EED00, 0xA78EED00A68EED00, 0xA98EED00A88EED00, 
0xAB8EED00AA8EED00, 0xAD8EED00AC8EED00, 0xAF8EED00AE8EED00, 0xB18EED00B08EED00, 0xB38EED00B28EED00, 0xB58EED00B48EED00, 0xB78EED00B68EED00, 0xB98EED00B88EED00, 
0xBB8EED00BA8EED00, 0xBD8EED00BC8EED00, 0xBF8EED00BE8EED00, 0x818FED00808FED00, 0x838FED00828FED00, 0x858FED00848FED00, 0x878FED00868FED00, 0x898FED00888FED00, 
0x8B8FED008A8FED00, 0x8D8FED008C8FED00, 0x8F8FED008E8FED00, 0x918FED00908FED00, 0x938FED00928FED00, 0x958FED00948FED00, 0x978FED00968FED00, 0x998FED00988FED00, 
0x9B8FED009A8FED00, 0x9D8FED009C8FED00, 0x9F8FED009E8FED00, 0xA18FED00A08FED00, 0xA38FED00A28FED00, 0xA58FED00A48FED00, 0xA78FED00A68FED00, 0xA98FED00A88FED00, 
0xAB8FED00AA8FED00, 0xAD8FED00AC8FED00, 0xAF8FED00AE8FED00, 0xB18FED00B08FED00, 0xB38FED00B28FED00, 0xB58FED00B48FED00, 0xB78FED00B68FED00, 0xB98FED00B88FED00, 
0xBB8FED00BA8FED00, 0xBD8FED00BC8FED00, 0xBF8FED00BE8FED00, 0x8190ED008090ED00, 0x8390ED008290ED00, 0x8590ED008490ED00, 0x8790ED008690ED00, 0x8990ED008890ED00, 
0x8B90ED008A90ED00, 0x8D90ED008C90ED00, 0x8F90ED008E90ED00, 0x9190ED009090ED00, 0x9390ED009290ED00, 0x9590ED009490ED00, 0x9790ED009690ED00, 0x9990ED009890ED00, 
0x9B90ED009A90ED00, 0x9D90ED009C90ED00, 0x9F90ED009E90ED00, 0xA190ED00A090ED00, 0xA390ED00A290ED00, 0xA590ED00A490ED00, 0xA790ED00A690ED00, 0xA990ED00A890ED00, 
0xAB90ED00AA90ED00, 0xAD90ED00AC90ED00, 0xAF90ED00AE90ED00, 0xB190ED00B090ED00, 0xB390ED00B290ED00, 0xB590ED00B490ED00, 0xB790ED00B690ED00, 0xB990ED00B890ED00, 
0xBB90ED00BA90ED00, 0xBD90ED00BC90ED00, 0xBF90ED00BE90ED00, 0x8191ED008091ED00, 0x8391ED008291ED00, 0x8591ED008491ED00, 0x8791ED008691ED00, 0x8991ED008891ED00, 
0x8B91ED008A91ED00, 0x8D91ED008C91ED00, 0x8F91ED008E91ED00, 0x9191ED009091ED00, 0x9391ED009291ED00, 0x9591ED009491ED00, 0x9791ED009691ED00, 0x9991ED009891ED00, 
0x9B91ED009A91ED00, 0x9D91ED009C91ED00, 0x9F91ED009E91ED00, 0xA191ED00A091ED00, 0xA391ED00A291ED00, 0xA591ED00A491ED00, 0xA791ED00A691ED00, 0xA991ED00A891ED00, 
0xAB91ED00AA91ED00, 0xAD91ED00AC91ED00, 0xAF91ED00AE91ED00, 0xB191ED00B091ED00, 0xB391ED00B291ED00, 0xB591ED00B491ED00, 0xB791ED00B691ED00, 0xB991ED00B891ED00, 
0xBB91ED00BA91ED00, 0xBD91ED00BC91ED00, 0xBF91ED00BE91ED00, 0x8192ED008092ED00, 0x8392ED008292ED00, 0x8592ED008492ED00, 0x8792ED008692ED00, 0x8992ED008892ED00, 
0x8B92ED008A92ED00, 0x8D92ED008C92ED00, 0x8F92ED008E92ED00, 0x9192ED009092ED00, 0x9392ED009292ED00, 0x9592ED009492ED00, 0x9792ED009692ED00, 0x9992ED009892ED00, 
0x9B92ED009A92ED00, 0x9D92ED009C92ED00, 0x9F92ED009E92ED00, 0xA192ED00A092ED00, 0xA392ED00A292ED00, 0xA592ED00A492ED00, 0xA792ED00A692ED00, 0xA992ED00A892ED00, 
0xAB92ED00AA92ED00, 0xAD92ED00AC92ED00, 0xAF92ED00AE92ED00, 0xB192ED00B092ED00, 0xB392ED00B292ED00, 0xB592ED00B492ED00, 0xB792ED00B692ED00, 0xB992ED00B892ED00, 
0xBB92ED00BA92ED00, 0xBD92ED00BC92ED00, 0xBF92ED00BE92ED00, 0x8193ED008093ED00, 0x8393ED008293ED00, 0x8593ED008493ED00, 0x8793ED008693ED00, 0x8993ED008893ED00, 
0x8B93ED008A93ED00, 0x8D93ED008C93ED00, 0x8F93ED008E93ED00, 0x9193ED009093ED00, 0x9393ED009293ED00, 0x9593ED009493ED00, 0x9793ED009693ED00, 0x9993ED009893ED00, 
0x9B93ED009A93ED00, 0x9D93ED009C93ED00, 0x9F93ED009E93ED00, 0xA193ED00A093ED00, 0xA393ED00A293ED00, 0xA593ED00A493ED00, 0xA793ED00A693ED00, 0xA993ED00A893ED00, 
0xAB93ED00AA93ED00, 0xAD93ED00AC93ED00, 0xAF93ED00AE93ED00, 0xB193ED00B093ED00, 0xB393ED00B293ED00, 0xB593ED00B493ED00, 0xB793ED00B693ED00, 0xB993ED00B893ED00, 
0xBB93ED00BA93ED00, 0xBD93ED00BC93ED00, 0xBF93ED00BE93ED00, 0x8194ED008094ED00, 0x8394ED008294ED00, 0x8594ED008494ED00, 0x8794ED008694ED00, 0x8994ED008894ED00, 
0x8B94ED008A94ED00, 0x8D94ED008C94ED00, 0x8F94ED008E94ED00, 0x9194ED009094ED00, 0x9394ED009294ED00, 0x9594ED009494ED00, 0x9794ED009694ED00, 0x9994ED009894ED00, 
0x9B94ED009A94ED00, 0x9D94ED009C94ED00, 0x9F94ED009E94ED00, 0xA194ED00A094ED00, 0xA394ED00A294ED00, 0xA594ED00A494ED00, 0xA794ED00A694ED00, 0xA994ED00A894ED00, 
0xAB94ED00AA94ED00, 0xAD94ED00AC94ED00, 0xAF94ED00AE94ED00, 0xB194ED00B094ED00, 0xB394ED00B294ED00, 0xB594ED00B494ED00, 0xB794ED00B694ED00, 0xB994ED00B894ED00, 
0xBB94ED00BA94ED00, 0xBD94ED00BC94ED00, 0xBF94ED00BE94ED00, 0x8195ED008095ED00, 0x8395ED008295ED00, 0x8595ED008495ED00, 0x8795ED008695ED00, 0x8995ED008895ED00, 
0x8B95ED008A95ED00, 0x8D95ED008C95ED00, 0x8F95ED008E95ED00, 0x9195ED009095ED00, 0x9395ED009295ED00, 0x9595ED009495ED00, 0x9795ED009695ED00, 0x9995ED009895ED00, 
0x9B95ED009A95ED00, 0x9D95ED009C95ED00, 0x9F95ED009E95ED00, 0xA195ED00A095ED00, 0xA395ED00A295ED00, 0xA595ED00A495ED00, 0xA795ED00A695ED00, 0xA995ED00A895ED00, 
0xAB95ED00AA95ED00, 0xAD95ED00AC95ED00, 0xAF95ED00AE95ED00, 0xB195ED00B095ED00, 0xB395ED00B295ED00, 0xB595ED00B495ED00, 0xB795ED00B695ED00, 0xB995ED00B895ED00, 
0xBB95ED00BA95ED00, 0xBD95ED00BC95ED00, 0xBF95ED00BE95ED00, 0x8196ED008096ED00, 0x8396ED008296ED00, 0x8596ED008496ED00, 0x8796ED008696ED00, 0x8996ED008896ED00, 
0x8B96ED008A96ED00, 0x8D96ED008C96ED00, 0x8F96ED008E96ED00, 0x9196ED009096ED00, 0x9396ED009296ED00, 0x9596ED009496ED00, 0x9796ED009696ED00, 0x9996ED009896ED00, 
0x9B96ED009A96ED00, 0x9D96ED009C96ED00, 0x9F96ED009E96ED00, 0xA196ED00A096ED00, 0xA396ED00A296ED00, 0xA596ED00A496ED00, 0xA796ED00A696ED00, 0xA996ED00A896ED00, 
0xAB96ED00AA96ED00, 0xAD96ED00AC96ED00, 0xAF96ED00AE96ED00, 0xB196ED00B096ED00, 0xB396ED00B296ED00, 0xB596ED00B496ED00, 0xB796ED00B696ED00, 0xB996ED00B896ED00, 
0xBB96ED00BA96ED00, 0xBD96ED00BC96ED00, 0xBF96ED00BE96ED00, 0x8197ED008097ED00, 0x8397ED008297ED00, 0x8597ED008497ED00, 0x8797ED008697ED00, 0x8997ED008897ED00, 
0x8B97ED008A97ED00, 0x8D97ED008C97ED00, 0x8F97ED008E97ED00, 0x9197ED009097ED00, 0x9397ED009297ED00, 0x9597ED009497ED00, 0x9797ED009697ED00, 0x9997ED009897ED00, 
0x9B97ED009A97ED00, 0x9D97ED009C97ED00, 0x9F97ED009E97ED00, 0xA197ED00A097ED00, 0xA397ED00A297ED00, 0xA597ED00A497ED00, 0xA797ED00A697ED00, 0xA997ED00A897ED00, 
0xAB97ED00AA97ED00, 0xAD97ED00AC97ED00, 0xAF97ED00AE97ED00, 0xB197ED00B097ED00, 0xB397ED00B297ED00, 0xB597ED00B497ED00, 0xB797ED00B697ED00, 0xB997ED00B897ED00, 
0xBB97ED00BA97ED00, 0xBD97ED00BC97ED00, 0xBF97ED00BE97ED00, 0x8198ED008098ED00, 0x8398ED008298ED00, 0x8598ED008498ED00, 0x8798ED008698ED00, 0x8998ED008898ED00, 
0x8B98ED008A98ED00, 0x8D98ED008C98ED00, 0x8F98ED008E98ED00, 0x9198ED009098ED00, 0x9398ED009298ED00, 0x9598ED009498ED00, 0x9798ED009698ED00, 0x9998ED009898ED00, 
0x9B98ED009A98ED00, 0x9D98ED009C98ED00, 0x9F98ED009E98ED00, 0xA198ED00A098ED00, 0xA398ED00A298ED00, 0xA598ED00A498ED00, 0xA798ED00A698ED00, 0xA998ED00A898ED00, 
0xAB98ED00AA98ED00, 0xAD98ED00AC98ED00, 0xAF98ED00AE98ED00, 0xB198ED00B098ED00, 0xB398ED00B298ED00, 0xB598ED00B498ED00, 0xB798ED00B698ED00, 0xB998ED00B898ED00, 
0xBB98ED00BA98ED00, 0xBD98ED00BC98ED00, 0xBF98ED00BE98ED00, 0x8199ED008099ED00, 0x8399ED008299ED00, 0x8599ED008499ED00, 0x8799ED008699ED00, 0x8999ED008899ED00, 
0x8B99ED008A99ED00, 0x8D99ED008C99ED00, 0x8F99ED008E99ED00, 0x9199ED009099ED00, 0x9399ED009299ED00, 0x9599ED009499ED00, 0x9799ED009699ED00, 0x9999ED009899ED00, 
0x9B99ED009A99ED00, 0x9D99ED009C99ED00, 0x9F99ED009E99ED00, 0xA199ED00A099ED00, 0xA399ED00A299ED00, 0xA599ED00A499ED00, 0xA799ED00A699ED00, 0xA999ED00A899ED00, 
0xAB99ED00AA99ED00, 0xAD99ED00AC99ED00, 0xAF99ED00AE99ED00, 0xB199ED00B099ED00, 0xB399ED00B299ED00, 0xB599ED00B499ED00, 0xB799ED00B699ED00, 0xB999ED00B899ED00, 
0xBB99ED00BA99ED00, 0xBD99ED00BC99ED00, 0xBF99ED00BE99ED00, 0x819AED00809AED00, 0x839AED00829AED00, 0x859AED00849AED00, 0x879AED00869AED00, 0x899AED00889AED00, 
0x8B9AED008A9AED00, 0x8D9AED008C9AED00, 0x8F9AED008E9AED00, 0x919AED00909AED00, 0x939AED00929AED00, 0x959AED00949AED00, 0x979AED00969AED00, 0x999AED00989AED00, 
0x9B9AED009A9AED00, 0x9D9AED009C9AED00, 0x9F9AED009E9AED00, 0xA19AED00A09AED00, 0xA39AED00A29AED00, 0xA59AED00A49AED00, 0xA79AED00A69AED00, 0xA99AED00A89AED00, 
0xAB9AED00AA9AED00, 0xAD9AED00AC9AED00, 0xAF9AED00AE9AED00, 0xB19AED00B09AED00, 0xB39AED00B29AED00, 0xB59AED00B49AED00, 0xB79AED00B69AED00, 0xB99AED00B89AED00, 
0xBB9AED00BA9AED00, 0xBD9AED00BC9AED00, 0xBF9AED00BE9AED00, 0x819BED00809BED00, 0x839BED00829BED00, 0x859BED00849BED00, 0x879BED00869BED00, 0x899BED00889BED00, 
0x8B9BED008A9BED00, 0x8D9BED008C9BED00, 0x8F9BED008E9BED00, 0x919BED00909BED00, 0x939BED00929BED00, 0x959BED00949BED00, 0x979BED00969BED00, 0x999BED00989BED00, 
0x9B9BED009A9BED00, 0x9D9BED009C9BED00, 0x9F9BED009E9BED00, 0xA19BED00A09BED00, 0xA39BED00A29BED00, 0xA59BED00A49BED00, 0xA79BED00A69BED00, 0xA99BED00A89BED00, 
0xAB9BED00AA9BED00, 0xAD9BED00AC9BED00, 0xAF9BED00AE9BED00, 0xB19BED00B09BED00, 0xB39BED00B29BED00, 0xB59BED00B49BED00, 0xB79BED00B69BED00, 0xB99BED00B89BED00, 
0xBB9BED00BA9BED00, 0xBD9BED00BC9BED00, 0xBF9BED00BE9BED00, 0x819CED00809CED00, 0x839CED00829CED00, 0x859CED00849CED00, 0x879CED00869CED00, 0x899CED00889CED00, 
0x8B9CED008A9CED00, 0x8D9CED008C9CED00, 0x8F9CED008E9CED00, 0x919CED00909CED00, 0x939CED00929CED00, 0x959CED00949CED00, 0x979CED00969CED00, 0x999CED00989CED00, 
0x9B9CED009A9CED00, 0x9D9CED009C9CED00, 0x9F9CED009E9CED00, 0xA19CED00A09CED00, 0xA39CED00A29CED00, 0xA59CED00A49CED00, 0xA79CED00A69CED00, 0xA99CED00A89CED00, 
0xAB9CED00AA9CED00, 0xAD9CED00AC9CED00, 0xAF9CED00AE9CED00, 0xB19CED00B09CED00, 0xB39CED00B29CED00, 0xB59CED00B49CED00, 0xB79CED00B69CED00, 0xB99CED00B89CED00, 
0xBB9CED00BA9CED00, 0xBD9CED00BC9CED00, 0xBF9CED00BE9CED00, 0x819DED00809DED00, 0x839DED00829DED00, 0x859DED00849DED00, 0x879DED00869DED00, 0x899DED00889DED00, 
0x8B9DED008A9DED00, 0x8D9DED008C9DED00, 0x8F9DED008E9DED00, 0x919DED00909DED00, 0x939DED00929DED00, 0x959DED00949DED00, 0x979DED00969DED00, 0x999DED00989DED00, 
0x9B9DED009A9DED00, 0x9D9DED009C9DED00, 0x9F9DED009E9DED00, 0xA19DED00A09DED00, 0xA39DED00A29DED00, 0xA59DED00A49DED00, 0xA79DED00A69DED00, 0xA99DED00A89DED00, 
0xAB9DED00AA9DED00, 0xAD9DED00AC9DED00, 0xAF9DED00AE9DED00, 0xB19DED00B09DED00, 0xB39DED00B29DED00, 0xB59DED00B49DED00, 0xB79DED00B69DED00, 0xB99DED00B89DED00, 
0xBB9DED00BA9DED00, 0xBD9DED00BC9DED00, 0xBF9DED00BE9DED00, 0x819EED00809EED00, 0x839EED00829EED00, 0x859EED00849EED00, 0x879EED00869EED00, 0x899EED00889EED00, 
0x8B9EED008A9EED00, 0x8D9EED008C9EED00, 0x8F9EED008E9EED00, 0x919EED00909EED00, 0x939EED00929EED00, 0x959EED00949EED00, 0x979EED00969EED00, 0x999EED00989EED00, 
0x9B9EED009A9EED00, 0x9D9EED009C9EED00, 0x9F9EED009E9EED00, 0xA19EED00A09EED00, 0xA39EED00A29EED00, 0x91F0009A8291F000, 0x00AB8291F0009C82, 0x8491F000AE8491F0, 
0xF0008B8D91F000AF, 0xBB9291F0008C8D91, 0x91F000BC9291F000, 0x00BA9691F000BE92, 0x859DF000BB9691F0, 0x9DF000A5859DF097, 0xF000A5859DF09885, 0xF0A5859DF098859D, 
0x98859DF000AE859D, 0xAF859DF0A5859DF0, 0x859DF098859DF000, 0x9DF000B0859DF0A5, 0x9DF0A5859DF09885, 0xF098859DF000B185, 0x00B2859DF0A5859D, 0xA5859DF0B9869DF0, 
0x859DF0B9869DF000, 0x9DF000AE859DF0A5, 0x9DF0A5859DF0B986, 0xF0BA869DF000AF85, 0xBA869DF000A5859D, 0xAE859DF0A5859DF0, 0x859DF0BA869DF000, 0xA0F000AF859DF0A5, 
0x009C94A0F000A284, 0x95A0F000A594A0F0, 0xF000BA98A0F0008B, 0x9EA3A0F00084A0A0, 0xA0F000ACA8A0F000, 0x00A493A1F000A3AD, 0x9BA1F000A89AA1F0, 0xF00088A7A1F000AA, 
0x8BB4A1F00098ACA1, 0xA1F000A4B7A1F000, 0x008386A2F000A6B7, 0x8CA2F0009F86A2F0, 0xF000949BA2F000B1, 0x8AA1A2F00084A1A2, 0xA2F0008CACA2F000, 0x008A80A3F000B1AF, 
0x8DA3F000B88AA3F0, 0xF000938EA3F0009F, 0x838FA3F0009C8EA3, 0xA3F000958FA3F000, 0x00A39AA3F000AD91, 0xAAA3F000A7A2A3F0, 0xF000BAABA3F0008D, 0x9EB4A3F000BCB2A3, 
0xA3F00091BBA3F000, 0x008EBEA3F0009EBD, 0x8BA4F000A389A4F0, 0xF000AB8EA4F000AE, 0xB59CA4F0008898A4, 0xA4F00094A0A4F000, 0x0092B2A4F000B6B0, 0xBEA4F000A1BEA4F0, 
0xF0008481A5F000B8, 0xB383A5F000B283A5, 0xA5F0009984A5F000, 0x008989A5F000B384, 0x98A5F0009D90A5F0, 0xF0009A9AA5F000A6, 0xBCA5A5F000859BA5, 0xA5F000A7AAA5F000, 
0x0080B2A5F000ABAE, 0xBEA5F00090B3A5F0, 0xF0009A87A6F00086, 0x8789A6F000A888A6, 0xA6F000998BA6F000, 0x009A93A6F000BE8C, 0x96A6F000A394A6F0, 0xF000A79EA6F000A8, 
0xBCACA6F000B59EA6, 0xA6F000B6B0A6F000, 0x00ABB5A6F00095B3, 0xBEA6F000ACBCA6F0, 0xF0009283A7F000B1, 0xA799A7F0008A8FA7, 0xA7F000AEA2A7F000, 0x00A8B2A7F000A6A5, 
0xBCA7F00093BBA7F0, 0xF0009297A8F000AF, 0xAE9CA8F000AD97A8, 0xA8F000BAAFA8F000, 0x008585A9F000B7B5, 0x88A9F0009F87A9F0, 0xF0008A90A9F0009A, 0xB696A9F0009692A9, 
0xAAF000B0ACA9F000, 0x008584AAF0008E83, 0x8AAAF0008E88AAF0, 0xF000928EAAF00091, 0x00000000008098AA, 0x000084000002B400, 0x8000000180000000, 0x000005B80002FCCC, 
0x0002E4CC80002287, 0x8000227B00003DB8, 0x000005B80002ECCC, 0x00003CCC8000228B, 0x8000099B0000BCCD, 0x800009A18000099E, 0x0000198000001D83, 0x80001D3D00001981, 
0x80001D4D80001D35, 0x0000318080001D45, 0x800009A400003181, 0x0003583D00003189, 0x80000A400003483C, 0x000085010003683E, 0x00008D0300010184, 0x0000950500008902, 
0x00009D0700009104, 0x0000A90900009906, 0x0000AD0B0000A108, 0x0000B90D0000A50A, 0x0000BD0F0000BD0C, 0x0000C5110000B90E, 0x0000CD130000C110, 0x0000D5150000C912, 
0x0000DD170000D114, 0x0000E5190000D916, 0x0000ED1B0000E118, 0x0000F51D0000E91A, 0x0000FD1F0000F11C, 0x000938610000F91E, 0x000E406380001D65, 0x000F28650008F062, 
0x000FD867000E8064, 0x000C7069000FF066, 0x000CF06B000C3068, 0x000D486D000CD86A, 0x0012106F000D1C6C, 0x80000A46000D6C6E, 0x0013A87300130C70, 0x001028750013EC72, 
0x0011D07700104C74, 0x0016D07900101476, 0x80001D5D0010F478, 0x80001D750016F47A, 0x00017D7F80001D6D, 0x0002804180000C86, 0x0000184380000BDE, 0x000048450000C042, 
0x0006904700006044, 0x0006284900018446, 0x0007384B00016C48, 0x0007704D0007F04A, 0x0004F04F0007444C, 0x800009A70004CC4E, 0x000AA05300052C50, 0x000A005500051052, 
0x0008D057000A5054, 0x00084859000B1056, 0x000011840008B858, 0x0000F58000083C5A, 0x80000BD800009D81, 0x0002698380001D2D, 0x0002358100024582, 0x00036D8700023580, 
0x0000398100035586, 0x80000C1700026584, 0x0003D5890004018A, 0x0000098F0003ED88, 0x80000C2980000BA8, 0x80000C2F0000098C, 0x0000099100033189, 0x80001D550000D8CC, 
0x80001ABD80001D7D, 0x0003658080000A4C, 0x00003D8600030D81, 0x000210CC00031D83, 0x00002982000184CD, 0x000681A3000374CC, 0x0002B18080001AC5, 0x80001ACD0002B181, 
0x0000C1A500002981, 0x0003E8CC80001AD5, 0x80000A52000260CD, 0x80000A580000F1A8, 0x80000A6480000A5E, 0x0000698180001ADD, 0x000111820004DCCC, 0x80000A6A80001AE5, 
0x80001AFD80001AED, 0x80001AF580001B05, 0x0004A0CC800009B3, 0x000108CC0004DCCD, 0x80001DA5800009B6, 0x002B00E100011186, 0x024888E300277CE0, 0x80001D9D02380CE2, 
0x80001DB500019187, 0x0001D98080001DAD, 0x0002C4CC00003581, 0x80001D95026444EA, 0x026468EF80001B0D, 0x0001F18200071181, 0x00005589028BD0F0, 0x80001B150001E581, 
0x00006D800001E187, 0x0000798300000D81, 0x0000798180000A76, 0x000138CC00019580, 0x0001C18C000114CD, 0x800009BC80000A7C, 0x001794C3000115A3, 0x001784C500149CC2, 
0x0017ECC7001750C4, 0x80001D8D001280C6, 0x0016D0CB80000A88, 0x001614CD0016E0CA, 0x0020BCCF80000C35, 0x0024CCD100199CCE, 0x0024E8D30025D8D0, 0x80000C3B000151B1, 
0x80001DBD0007DDA7, 0x0027C8D90024BCD6, 0x0027F8DB0022D4D8, 0x0007ED8780001B2D, 0x0004F8CC80000A82, 0x80001D2580001B1D, 0x800009B00006C987, 0x800009B90007DD91, 
0x80000A7080001B25, 0x80001D8580001B35, 0x0006F98C80000C8C, 0x0006D58080000C0B, 0x0002C4CC0006C181, 0x00005182000504CD, 0x0006AD8000077583, 0x000735860006B981, 
0x0000418400072987, 0x0000EDA780000A8E, 0x0007E98880001B3D, 0x80000A940007CD89, 0x0007DD8C0007C18F, 0x80000BEA80000A9A, 0x00009DB000065DA7, 0x80000AA680000AA0, 
0x80001B45000641A3, 0x80000C7D80001B55, 0x80001B5D80001B4D, 0x80001B65000671AD, 0x0003F8CC800009BF, 0x800009C200032CCD, 0x800009C50000E5A3, 0x80000AB200004D8C, 
0x80000AB80000F1A7, 0x00009D8700063DB1, 0x00071DA800009586, 0x80000ABE00008984, 0x0000D5810000A982, 0x80000ACA000701AD, 0x0001998200003D91, 0x00050CCD800009C8, 
0x00003D81000508CC, 0x0001BD8800018587, 0x80001DC580001B75, 0x0001918C80000BAE, 0x80000C4780000C41, 0x0001F58080001DCD, 0x0001818200018581, 0x0001898400019D83, 
0x0001A98680000AC4, 0x00006D8800005D87, 0x80001B6D00004D89, 0x00005D8C000210CC, 0x80000AD000000D82, 0x0000E9B00000498F, 0x80000BF080001B7D, 0x00012580000129A3, 
0x80001B8500015581, 0x0001A4CC000135A7, 0x80000AD6000210CD, 0x0000358180001B8D, 0x000109AE80000ADC, 0x0001E8CC80000AE8, 0x80001B95000228CD, 0x000005840000F1A3, 
0x80000AE280001B9D, 0x0000B5A880001BAD, 0x00005D8180001BA5, 0x0001FCCC80001BB5, 0x80001BBD0001C0CD, 0x0003858180001BC5, 0x0003E58180000C11, 0x0003E98780000AEE, 
0x0003A58C800009CB, 0x80000AFA80001BCD, 0x80001BD5800009AA, 0x0003DD8100039981, 0x000124CD0003BD8C, 0x000210CC000120CC, 0x0000F981000230CD, 0x0000558000005187, 
0x80000AF400005981, 0x0000418C00004983, 0x80001BDD80001BE5, 0x00007D81800009CE, 0x000320CC00007180, 0x00037DA30003B0CD, 0x000311A3800009D1, 0x00012D8180001DED, 
0x000331A70000FDB1, 0x80001DE5000341AD, 0x80001DFD00036DA3, 0x80001BED80001DF5, 0x0000358000036DA7, 0x00036DB100001D81, 0x80000C9800002D88, 0x00007181000095A7, 
0x0000718300005980, 0x000051810000F5A3, 0x80001BF5000081AD, 0x00005D89000309B1, 0x000138CC00003D84, 0x0000198100019D84, 0x0000658400000980, 0x0007D0CC80001BFD, 
0x80001C050007F0CC, 0x00064CCC00008991, 0x000670CC000604CD, 0x000740CC000674CD, 0x0007A8CC000F2D9B, 0x00000D860007ACCD, 0x000F4184000F5587, 0x000C018280000B09, 
0x00013580000F5583, 0x80000CA40001D981, 0x0000ED8C0000E98F, 0x80001DDD80000C92, 0x000F6D880000F58B, 0x80000B0F00000D89, 0x0000258280000BB4, 0x0000418180000C4D, 
0x80001E1580000C53, 0x80001E2580001E0D, 0x80001E2D80001E1D, 0x0000298080001E05, 0x80000BFC00002981, 0x0000798480001C0D, 0x00014D8180001C15, 0x80000B180001A180, 
0x000238CC000FFDA3, 0x80001C1D000348CD, 0x00027CCD00005981, 0x80000B24000DA4CC, 0x000FC9A880000C59, 0x800009D700003987, 0x80000B03000FA189, 0x80000C9E00001191, 
0x80000B99800009DA, 0x000FB98080000C5F, 0x80001DD5000FB981, 0x80000BF6000F8D83, 0x0000058480001C25, 0x80000B1E80001C2D, 0x80000B2A80001C35, 0x00002187000F9D81, 
0x0002A8CC000FB587, 0x000CB4CC0002E8CD, 0x0000CDA6000CDCCD, 0x80001C4D0000C5A7, 0x000F898C000F818F, 0x80000B300000E5A3, 0x80000B3C80001C3D, 0x000005870000C9B1, 
0x80001C4580001C55, 0x80001C5D00003D87, 0x80000B3680000C71, 0x0000F981000F05A3, 0x80001C650003A8CC, 0x0000498C80000B48, 0x80001C6D0000F1A3, 0x80000B4280000C77, 
0x80001C7D000095A7, 0x0003ACCC80001C75, 0x800009DD0000C8CD, 0x800009E000006987, 0x000079820000BD81, 0x0001B987800009E3, 0x0000A59180000B4E, 0x80001C9D00001D81, 
0x0000058880000B54, 0x0000919B80001CA5, 0x800009E680000B5A, 0x80000BD20001918C, 0x80000BC080000BC6, 0x0000458380000BCC, 0x0001B9810001B982, 0x80001E3D0001A580, 
0x80000B6000007186, 0x0000158B00004984, 0x0000398900003D8A, 0x0000F98F00004588, 0x80000BBA80000B66, 0x000151A70000058C, 0x80000C65000149A6, 0x000159A3000079B0, 
0x0000A9800000A98C, 0x000095810000A981, 0x000171AD00009580, 0x80000BA280000C6B, 0x80001E4D00008D84, 0x000021A380001E45, 0x80001E5580001E5D, 0x00006D8180001E65, 
0x000105B100006D80, 0x80001E35000039A4, 0x80000B6C80001C85, 0x80001C95000005A8, 0x000009AD80001C8D, 0x0003BD810001B0CC, 0x0003CD830003BD80, 0x80001CB580001CAD, 
0x0001BCCC80001CBD, 0x0003E989000184CD, 0x0002D98100011CCC, 0x000138CD0002C580, 0x000268CC00013CCC, 0x00004D83000244CD, 0x0000D98780001CC5, 0x0000458000002D87, 
0x0000058200001181, 0x80001CD580000B72, 0x80001CDD80001CCD, 0x00001588000238CC, 0x00006D800000E188, 0x000284CC00003981, 0x000345A3000150CD, 0x80001CE500013984, 
0x0003DCCC80001CED, 0x80001E6D000248CD, 0x80000B78800009E9, 0x80000CAA80001E85, 0x80001CF500006D81, 0x0000D1A380000B7E, 0x80001E7580001E7D, 0x00007581000488CC, 
0x80000B8100007580, 0x000400CC0000B5A3, 0x80001CFD000254CD, 0x00014D8480000B87, 0x80001D0580000B8D, 0x000ED0CC80001D0D, 0x000500CC00012CCC, 0x800009EC00055CCD, 
0x000E98CC800009EF, 0x000FCCCC0000C181, 0x000108CC000E3CCC, 0x000FD4CC000E9CCD, 0x000E3CCC000F78CD, 0x0001E581000E38CD, 0x0001E5830001E580, 0x800009D40001E582, 
0x0001E1870001E584, 0x0001A58980001D41, 0x0007C9810001D988, 0x80001D5180001D39, 0x000134CC80001D49, 0x0000DD80800009F5, 0x80000A430000E981, 0x0000CD800000FD83, 
0x000711810000F981, 0x80001D6180001D69, 0x000128CC0000D189, 0x80001D7180001D79, 0x000134CC80000BE1, 0x00005D8080000BDB, 0x000101A300006581, 0x0000718100006183, 
0x80001D3100004980, 0x80000BAB80000C1A, 0x80000C2C00005589, 0x80001D5980000C32, 0x80001AC180001D81, 0x00001D8280000A4F, 0x0007198000077983, 0x0000218600071981, 
0x0007918400002987, 0x0000698A800009F2, 0x000069880006D9B1, 0x80000A490007F589, 0x0007D98C0007DD8F, 0x800009F880000C89, 0x800009FB80001D29, 0x000741800007A191, 
0x0000058700074181, 0x0007918280001AC9, 0x80001AD980001AD1, 0x00078586000695A3, 0x000290CC0000EDA7, 0x0000E9B10005E0CD, 0x80000A550000C1A3, 0x80000A6180000A5B, 
0x800009FE80000A67, 0x80001AE1000765A5, 0x000755A80003B8CC, 0x80000A6D80001AE9, 0x80001B0180001AF1, 0x80001AF980001B09, 0x0000ADA380000A01, 0x0006258C80000A04, 
0x00004D8C80000A07, 0x00006D8280001DA9, 0x0006018200063D81, 0x80001DA100006581, 0x80001DB900006587, 0x0001AD8700061187, 0x000250CC80001DB1, 0x0001E1810002C4CD, 
0x0001E1830001C980, 0x0001FD8000008991, 0x80001D990001D581, 0x0000358900019D8C, 0x0000758080000A73, 0x00002D8600005D81, 0x00007D8400003587, 0x0001858280001B11, 
0x00019D8000007D83, 0x80001B1900019181, 0x0000E18C0000E98F, 0x80000A7F80000A79, 0x00000D8880000A0A, 0x000139A70000F989, 0x80000A8B80001D91, 0x000125A380000C38, 
0x000059B080000C3E, 0x0000058280001D89, 0x000115AD80001DC1, 0x80001B3180000C8F, 0x80000A8500000586, 0x80001B2980001B21, 0x00010D80000069A7, 0x0000318700010181, 
0x000119B1000049A3, 0x80001B39000210CC, 0x80000A9180000C0E, 0x0001D4CC000051AD, 0x000041A80001F8CD, 0x000138CD80001B41, 0x0003ED8100013CCC, 0x80000A9D80000A97, 
0x80000BED00000D8C, 0x0003C58180000AA3, 0x80000AA9000268CC, 0x80001B490003C582, 0x000029870003C984, 0x80001B5900003186, 0x80000C8000006D82, 0x0000618780001B51, 
0x80001B6980001B61, 0x0003A8CC80001D15, 0x0000F9810002ACCD, 0x80000A0D00002D88, 0x80000A1380000A10, 0x80000AB50000358C, 0x0000D5B180000ABB, 0x80001B7980000AC1, 
0x80000BB180001DC9, 0x80000C44000130CC, 0x80001DD180000C4A, 0x80000AC7000104CC, 0x0000A5A780001B71, 0x00008DA380000AD3, 0x0000B980000214CC, 0x000085A70000B981, 
0x0000658280000C08, 0x0000358C80001B81, 0x001CECCC80000BF3, 0x80001B890003FCCD, 0x80000AD90000ADAE, 0x0006C0CC80001B91, 0x0001BDB00006D0CD, 0x80000ADF000790CC, 
0x001D18CC0001C981, 0x00001184000220CD, 0x0006B8CD80000AEB, 0x80001BA10006ACCC, 0x0000298180000AE5, 0x80001BA980001BB1, 0x001D40CC0001EDA3, 0x80001BB9000210CD, 
0x0000098180001BC1, 0x001D40CC80001BC9, 0x0001D9A80002D0CD, 0x000790CC80000C14, 0x000660CC00011CCC, 0x80000AF1000664CD, 0x80001BD180000A1C, 0x80000AFD00012991, 
0x80001BD9001FCD81, 0x80001BE980000AF7, 0x0006C4CC80001BE1, 0x000031810006C0CD, 0x80000A1F0000D980, 0x0001B98280000A22, 0x0001B98000014583, 0x00015D860001B981, 
0x00015D8480001DF1, 0x0000C0CD80001DE9, 0x001C01880000F0CC, 0x80001E0100017989, 0x0001618C0001558F, 0x001EDD8180001DF9, 0x80001B99001F1581, 0x001F818C001F5D81, 
0x000318CC001F4187, 0x001F4D80000368CD, 0x80000A25001FA581, 0x001F158C001FA983, 0x80000A28001ED18C, 0x001F9580001FB587, 0x00001181001F9981, 0x001F8580001FBD83, 
0x80001BF1001F8981, 0x80000C9B00003D84, 0x80001BF9001F9989, 0x80000B0600000588, 0x00000D8080001C01, 0x80001C090000FD81, 0x001E79A3001FD9A3, 0x80000B0C000085A3, 
0x001E61A7001F35AD, 0x80000CA1001FA9A7, 0x80000CA700000D84, 0x80000A2B001F35A3, 0x00007184001F89AD, 0x001E3DB1001F21A7, 0x80000C95001F85B1, 0x80000B1280001DE1, 
0x001CB4CC80000BB7, 0x80000C50001CB0CD, 0x80000C56001F41B1, 0x80001E1980000B9C, 0x80001E2980001E11, 0x001EB98080001E21, 0x00012182001EB981, 0x0001618400013583, 
0x0001898680001E31, 0x000191880001BD87, 0x80001DD90001E989, 0x0001E58C0001FD8B, 0x80001E0900000D82, 0x0001B9830001DD8F, 0x0001BD810001AD91, 0x0001A1800001BD80, 
0x80000BF90001A181, 0x00003D8480000BFF, 0x0001958980001C11, 0x001ECD810001819B, 0x0002FCCC001ECD80, 0x0000E5810002F0CD, 0x0000ED8180001C19, 0x000190CC0000A5A3, 
0x00001D8700025CCD, 0x0000F9A880000B1B, 0x80000B2780001C21, 0x80000C6280000C5C, 0x0000058480001C29, 0x0000D5A380001C31, 0x80001C3980000B21, 0x0001F4CC00005181, 
0x80000B2D0001D0CD, 0x80001C5100003D87, 0x80001C4180000B33, 0x0000058780000B3F, 0x80001C4980001C59, 0x0003D9810003F187, 0x0000918100039981, 0x80000C7480001C61, 
0x000124CC0003F98C, 0x0003F9810003B987, 0x000264CC80000B39, 0x0003998C0003C982, 0x0003D18780001C69, 0x0006DD810003918F, 0x000400CC0003F591, 0x000065870003ECCD, 
0x80000B4B80001D19, 0x80000C7A80001C71, 0x000118CC80000B45, 0x80001C8100003988, 0x00035CCC80001C79, 0x80000A2E0000258C, 0x0000FDB100012CCC, 0x80000A31000339A3, 
0x80001CA180000A34, 0x000374CC000359A7, 0x000351A300000988, 0x80000B5D80001CA9, 0x00009DA7000D6D83, 0x00009DA30000ADA6, 0x000128CC00030DB1, 0x0000B5A780000BD5, 
0x80000BC90000B5A6, 0x0007D581000130CC, 0x000128CC80000BC3, 0x80001E4180000BCF, 0x000089AD80000B63, 0x0001CD8080000B69, 0x000144CC0001DD81, 0x0001F584001E9CCD, 
0x000158CC80000BBD, 0x0001ED8000014CCD, 0x0000B5830001FD81, 0x0001DD8C80000C68, 0x001E08CC80000C6E, 0x000138CC0006F18C, 0x80001E5100013CCD, 0x0006058100001189, 
0x80001E6180001E49, 0x80001E6980001E59, 0x0000218000003D83, 0x0000398000003981, 0x80001E3900002181, 0x000128CC80001C89, 0x80000B6F0006D981, 0x000124CC0006FD81, 
0x80001C9180001C99, 0x0001218080001CB1, 0x000005A300013581, 0x80001CC180001CB9, 0x00058CCC80001CC9, 0x00031CB7000240CD, 0x0007CD8780000B75, 0x80001CD180001CD9, 
0x000088CD80001D1D, 0x0005DD8C000090CC, 0x80000A16000085A3, 0x80001CE10002E0CC, 0x00004D810007D588, 0x80000B5100004D80, 0x80000B5780001CE9, 0x80000A3700073991, 
0x80000BA50007C588, 0x80001CF10007C98A, 0x0007E58700003D9B, 0x0007858180001E71, 0x80000A3A00078580, 0x0006D5820007F982, 0x0006C98000004583, 0x0006E1860006DD81, 
0x0000518480000B7B, 0x0006958A80001E89, 0x000079880006998B, 0x80000CAD00069D89, 0x00076D8C0007598F, 0x000380CC80001CF9, 0x000711B0000224CD, 0x80001E8180000A3D, 
0x80001E7980001D21, 0x00008D8080000B84, 0x0003ECCC00009D81, 0x80001D010004E8CD, 0x000749A380000B8A, 0x80001D0980000B90, 0x80001D110007BDA3, 0x800007E78000001B, 
0x0007A5A48000000B, 0x8000058A800004EB, 0x000761A880000003, 0x8000006580000DD9, 0x8000091B800003C8, 0x00012D80000769AD, 0x00015D8200013D81, 0x0001618400015183, 
0x800004AC800004B8, 0x0001AD8800016187, 0x0001BD8A0001B589, 0x800005BC0015298F, 0x000278CC80000C1D, 0x0001DD810005D8CD, 0x80000BE400007181, 0x000019840001FD82, 
0x0001ED8780000C23, 0x000434CC80000C20, 0x80000BE7000430CD, 0x80000C260015699F, 0x0004F8CD0001C98C, 0x000149B10002F0CC, 0x0000D58180000721, 0x001599A0000115A3, 
0x8000074680000873, 0x000428CC0000F584, 0x800008C300042CCD, 0x00017DA8000179AF, 0x000169AA80000D31, 0x000125B480000952, 0x000109A3000129B5, 0x800006EA80000C02, 
0x000105B2800006EE, 0x0000F5BC00013DB3, 0x0000D9BE0000FDBD, 0x000101B880000838, 0x000101BA000101B9, 0x800007438000073C, 0x00039DB300000C86, 0x800008B3000389B2, 
0x800007690003BD80, 0x800009128000076C, 0x800006E7800006E4, 0x0003858980000835, 0x0003A1BF0007E4CC, 0x80000CD780000C05, 0x000CE4CD0000658C, 0x00004189000C24CC, 
0x0000458B00005588, 0x0003B5850000458A, 0x000395870003B584, 0x80000D0100038186, 0x80000D0780000D04, 0x8000001300002C98, 0x00068CCD0000C8A6, 0x000069850006A8CC, 
0x8000003180000017, 0x0003F0CC80000069, 0x8000003580000007, 0x000095B180000CD1, 0x000095B380000D25, 0x80000D35000095B2, 0x80000D4080000D38, 0x80000D2E80000D3B, 
0x800006A680000075, 0x8000099880000025, 0x000355BF8000211D, 0x8000211980000D43, 0x8000206180002115, 0x000D659400006CB8, 0x0001AD9C00020092, 0x0001899A0001A59D, 
0x000199980001899B, 0x000620CC00018999, 0x000640CC000604CD, 0x00073CCC00065CCD, 0x0007BCCC000738CD, 0x000F018000007585, 0x80002069000F0D81, 0x00000585000199BA, 
0x8000205980002071, 0x000F2981000185BE, 0x80002065000F2580, 0x00002985000F2182, 0x000011850001A5B4, 0x000F89B38000206D, 0x0001C9B1000F85B2, 0x000F81B7000C01B0, 
0x0001EDB50001EDB6, 0x000165810001EDB4, 0x0001618300016580, 0x000B3CCC000FB5B8, 0x000FE18000017984, 0x80002075000FDD81, 0x0004C8CC8000205D, 0x0000AD850004B8CD, 
0x8000212100001585, 0x0019E8CC80002139, 0x00015DA40019B4CD, 0x00024DA280000D46, 0x000155A0000FF1A3, 0x8000087F000FDDA1, 0x8000093B8000096E, 0x8000096C80001EED, 
0x8000097780001EF5, 0x800008B180001EF1, 0x80001EAD00000D93, 0x000CD58480001EF9, 0x00006994000EE985, 0x80001EB5000EDD87, 0x80001EBD0002B499, 0x80001EB180001EC5, 
0x80001EB98000213D, 0x80001EC10001749F, 0x000E8D80000D1891, 0x000E8586000E8181, 0x000E898400038C95, 0x0000118200024497, 0x0000D1800000B8A9, 0x80001EC90000ED81, 
0x80001EE580000D49, 0x00008983000F5985, 0x000E4581000D34A1, 0x80001EE9000E4980, 0x000F6185000134A5, 0x80001F1D0014F0CC, 0x0003C8CC0005C4B9, 0x0000DD800003DCCD, 
0x80001F250000C181, 0x00001185000590BF, 0x0000F5800007ECB1, 0x800020A10000C181, 0x80001F2D00068CB5, 0x000EDD80000640B7, 0x000228CC000EE981, 0x000ECD800002B4CD, 
0x00002985000EF981, 0x0001758000018583, 0x0001F1800001B181, 0x800020A90001D581, 0x0000058580001F35, 0x00019980800020B1, 0x00007D820001BD81, 0x0001E1940001D593, 
0x8000209900000D85, 0x0000098080001F21, 0x80001F2900001981, 0x00002D940001AD93, 0x00000D85800020A5, 0x0000058580001F31, 0x80001F39800020AD, 0x0000198200002985, 
0x0000F18000003585, 0x800020B50000E181, 0x800021418000209D, 0x8000216100000585, 0x0001ED8000017583, 0x0001F0CC00012981, 0x80000D4C0001B0CD, 0x800021598000215D, 
0x80001F5D80000DA3, 0x00003D8080001F65, 0x80001F6D00000D81, 0x00002D8080001F75, 0x0000158200001D81, 0x00012CCD80001F61, 0x80001F7180001F69, 0x0003C58880001F79, 
0x000290CC800021A5, 0x0003ED840002BCCD, 0x0003F98680000D4F, 0x0003818080001F9D, 0x00003D800003FD81, 0x0000498100003581, 0x0001DCCD00004180, 0x80001FA500004182, 
0x80001FA980001FA1, 0x00039D94000130CD, 0x0001F0CD8000218D, 0x0003B98100010CCC, 0x0003A1830003C580, 0x0000AD800003A593, 0x00009D800000D581, 0x800021890000A981, 
0x0000C18180000D52, 0x0000B5800000C980, 0x8000218500008181, 0x000370CC00046983, 0x800021810003B4CD, 0x80000DA600013CCD, 0x00028CCD00040193, 0x00000D800002F4CC, 
0x0006D99400003581, 0x80001FD580001FD1, 0x000108CC80001FD9, 0x0000118100011CCD, 0x800021A900002980, 0x0001918000001982, 0x000568CD00019181, 0x000910CC000294CC, 
0x000E58CC001628CD, 0x000D14CC000E78CD, 0x000C28CC000AD8CD, 0x0017E0CC000D8CCD, 0x000B38CC000AE0CC, 0x000011850008F4CD, 0x0007518080000D55, 0x800020E100075181, 
0x00000585000E90CD, 0x000ED8CC800020E9, 0x800020F10001ECCD, 0x00001985000E00CD, 0x000E3CCD000FF0CD, 0x000168CC000E54CD, 0x800020D900016CCD, 0x0007999480000861, 
0x00016180003BC0CC, 0x000029850000D981, 0x000178CC000E64CD, 0x0007AD8100017CCD, 0x000065850007AD80, 0x0001518000079D82, 0x0007E19400015181, 0x000179840000C0CD, 
0x000161860007C593, 0x00012188800020E5, 0x800020ED00000D85, 0x0000D8CC000118CD, 0x0007DD800000B4CD, 0x80001F990007CD81, 0x80001FCD00000985, 0x80001FFD800020F5, 
0x80002005800020DD, 0x800020158000200D, 0x8000200180002009, 0x80002011800021AD, 0x0002B8CC80002019, 0x0000658000031CCD, 0x00007D8200007581, 0x000009858000201D, 
0x8000210100004185, 0x0006998080000DA9, 0x0000198500072181, 0x8000210900007D83, 0x800020FD00005985, 0x0000CD80800020F9, 0x80001E8D0000D981, 0x0000E98400001185, 
0x0000E58680001E95, 0x0000358080002041, 0x80001E9D00000D81, 0x8000204900001D85, 0x0000058580001EA5, 0x0000558080002051, 0x00007D8200006D81, 0x00000D9400004593, 
0x8000203900000D85, 0x0000098080001E91, 0x80001E9900001181, 0x8000204500001D85, 0x0000058580001EA1, 0x0001E9808000204D, 0x000005820001F181, 0x0000098580001EA9, 
0x8000205500000985, 0x00016D808000203D, 0x0000198200017981, 0x8000210D0001A583, 0x0000058500007585, 0x8000210580002111, 0x0002C8CC80002021, 0x80000DAC0002DCCD, 
0x0000398080001ECD, 0x80001ED500003981, 0x80001ED180001EDD, 0x00001D8080001ED9, 0x80001EE100000D81, 0x0000C58080002025, 0x0000C0CD0000D581, 0x0000D580000224CC, 
0x000039850000C581, 0x800021250000C983, 0x0000D58080000DAF, 0x0000058500000981, 0x80001EFD8000212D, 0x0000098080002081, 0x80001F0500001181, 0x0000B99400009993, 
0x0000658580001F0D, 0x8000208900003D85, 0x80001F1500005D93, 0x000570CD00001185, 0x003C0194000574CC, 0x8000207980002091, 0x80002085000128CD, 0x000019858000208D, 
0x8000207D80002095, 0x8000212980002135, 0x0000258580002029, 0x0002F8CC00003985, 0x00013CCD0003C4CD, 0x0003958180000DB2, 0x0001C4CD00038D80, 0x000051850003A582, 
0x000128CC00004985, 0x000138CD00012CCD, 0x003E698000013CCC, 0x80002149003E6981, 0x003C38CD80002145, 0x003CD181003C54CC, 0x000148CC003E9D93, 0x000134CD0002C8CD, 
0x003EB9948000214D, 0x003EA18080000D58, 0x003EA182003EA181, 0x80002155003C8D88, 0x00002D800000AD85, 0x003FD58500002181, 0x0000ED8080001F95, 0x0000A5860000F181, 
0x0000A98480001F45, 0x000128CD000124CD, 0x003EF98880001F4D, 0x80001F55003FF185, 0x003FC58580001F49, 0x000110CD000130CD, 0x0001DD800006F4CD, 0x0006BCCD0001E981, 
0x0006E0CC000670CD, 0x000668CC00015CCD, 0x000664CD000690CD, 0x0007ACCC000678CD, 0x0007E8CC0007A8CD, 0x003F4D820007C8CD, 0x000235800002FD83, 0x80001F510002E981, 
0x003D058080001F59, 0x8000215100017D85, 0x000114CD8000202D, 0x0001ED8180000E29, 0x00013CCD0001E180, 0x00012CCD0001CD82, 0x00016D8100017582, 0x0001658000015980, 
0x80001F850000C581, 0x000138CD000124CD, 0x0000F9810000F182, 0x0000298000015980, 0x000118CC00007181, 0x00012CCD00017CCD, 0x00001D8180001F8D, 0x80001F8900001D80, 
0x8000217180001F91, 0x003DE4CC000124CD, 0x0000E8CD000F5CCD, 0x0001D58000010CCC, 0x000099820001C981, 0x80001F09003FE583, 0x80001F1980001F11, 0x80000E2380002131, 
0x80001F3D80002175, 0x80001F4180002031, 0x003F4D8080000E2C, 0x80001F7D003F4181, 0x80001F8180002169, 0x003F258080002165, 0x003F9193003F2981, 0x80000E2600007D83, 
0x0002D8CC00004194, 0x8000216D0002ACCD, 0x0000098000005593, 0x80000DB500001D81, 0x000041948000217D, 0x00009D8080001FAD, 0x00001D800000A181, 0x0000A58400001181, 
0x0000A58680001FB5, 0x0000F18880001FBD, 0x0000D9810000D182, 0x000025800000CD80, 0x0000058200002981, 0x80001FB180001FC5, 0x80001FC180001FB9, 0x000011940000B193, 
0x00001D8080001FC9, 0x0000258000001581, 0x00003D8200002D81, 0x0000ED8080002179, 0x000015820000D181, 0x003DD08100008183, 0x000220CC80002035, 0x000278850001DCCD, 
0x80000E2F80002191, 0x0003188980002199, 0x00002D8080001FDD, 0x0000098000003581, 0x80001FE500006D81, 0x0000B191800020C1, 0x003BDD930000A990, 0x0000A59500040192, 
0x80001FED003B9594, 0x000009850000A196, 0x800020C900004193, 0x0000058580001FF5, 0x0000F594800020D1, 0x0000B980800020B9, 0x0000E5820000DD81, 0x80001FE980001FE1, 
0x000009800000E985, 0x0000058500003581, 0x80001FF1800020C5, 0x800020CD00001D85, 0x0000058580001FF9, 0x0005C1B1800020D5, 0x800020BD0003C5B0, 0x0005D9B50003C5B2, 
0x8000219D0003CDB4, 0x0003FDB900003985, 0x80002195800021A1, 0x80000DCD80000DBB, 0x80001F0180000E17, 0x80000DD380000E05, 0x80000E0B000288CC, 0x000190CD003EE0CD, 
0x80000D70000124CC, 0x80000E4180000D8E, 0x0000B18080000E7D, 0x003EE4CD003ED4CD, 0x003EBCCC80000E83, 0x0003D180003EB8CD, 0x0003FD820003ED81, 0x80000E3E00006986, 
0x00013CCD00039D85, 0x0002E8CC80000E38, 0x0000E588003F3CCD, 0x80000E89000118CD, 0x80000E3B00004188, 0x00012CCD80000E77, 0x0000D58080000E95, 0x0000E18680000E9B, 
0x80000E470000E986, 0x80000EA1000124CD, 0x0000D188000110CD, 0x0002F8CC00002988, 0x0002F8CD80000E4D, 0x80000EA7000124CC, 0x003EA0CC00032D85, 0x0003D580003E6CCD, 
0x000301820003CD81, 0x000364CC0003F983, 0x80000E440002CCCD, 0x00020CCC000124CD, 0x00001181000208CD, 0x003EB0CC00039CCC, 0x003EC4CC003EB4CD, 0x003E80CC003EC0CD, 
0x80000EAD003EB8CD, 0x003F98CC000284CC, 0x003E20CC003E50CD, 0x003F0CCD003EA0CD, 0x003F78CD003F30CD, 0x00005988003F04CD, 0x0001F8CD80000EBF, 0x80000E4A0001C4CC, 
0x80000ECB80000EC5, 0x000108CC000214CC, 0x000005880001C8CD, 0x80000ED780000ED1, 0x80000EB9000228CC, 0x0000D18600000D88, 0x0000CD8400011D80, 0x00023CCC0000F588, 
0x000244CC00013584, 0x80000E8000012986, 0x80000E8600016588, 0x80000E62000544A7, 0x0000ED880000ED8B, 0x0000258800000D81, 0x000270CC00006586, 0x000230CC000274CD, 
0x80000E5C0005D8CD, 0x0000398080000E8C, 0x0005E0CC80000E5F, 0x000128CC80000E7A, 0x00002586000114CD, 0x80000E0800005588, 0x80000DC400308486, 0x0007FD860007D580, 
0x000224CC80000E98, 0x80000E9E00003D88, 0x00003D8880000E6B, 0x000248CC80000EA4, 0x80000E50000278CD, 0x0005C09780000EAA, 0x0005189500057096, 0x0005589300006980, 
0x0000658800003981, 0x00005986003CF890, 0x000045840005A89E, 0x0002D4CC80000E68, 0x00005D800005B49A, 0x0004ECA70005AC98, 0x0002D8CC00001188, 0x0004BCA30002DCCD, 
0x000260CC80000EB0, 0x80000E6E80000EC2, 0x000408AD80000EC8, 0x0004F4AB80000ECE, 0x0000058800022CCC, 0x0003E8B780000ED4, 0x000428B500041CB6, 0x000428B3000200CC, 
0x00007D880000798B, 0x00004186000474B0, 0x000075840003A4BE, 0x80000EDA00001D88, 0x0003DCCC00034CBA, 0x0002A8830003FCB8, 0x80000EBC00000D88, 0x0002948700001588, 
0x80000E65000238CC, 0x0002DC8B000204CC, 0x80000E7100000D8F, 0x000220CC0000198F, 0x0002F08D80000E74, 0x0003209800007588, 0x80000E8F00032C99, 0x00024CCC80000D94, 
0x000224CC00037096, 0x80000E9200003D88, 0x0000058800022CCC, 0x000224CC80000EB3, 0x80000EB600000D88, 0x0003D4A80000F587, 0x80000EDD0003C4A9, 0x80000FD2000260D9, 
0x80000FDB80000FD5, 0x0000319300003594, 0x80000FD8000268D9, 0x0000059400024CD9, 0x0000219580000FDE, 0x8000105000002994, 0x8000174380001674, 0x000260D9800016D2, 
0x0003D8B580001737, 0x000035940003F0B4, 0x8000175A000258D9, 0x000254D900000594, 0x8000173100000D94, 0x0000C88A000174E0, 0x0000C888000015BC, 0x80001787000280E0, 
0x0002ECA40000A081, 0x00005CA80002C8A4, 0x8000179900000DBC, 0x000005BC000284E0, 0x0002F8A48000179D, 0x0003CCB00002F4E0, 0x8000175D0000D095, 0x0002C8A60003E0B3, 
0x0000D892000260A7, 0x0000C1BE80001764, 0x0000C1978000176B, 0x8000177980001772, 0x003F78CD80001780, 0x000D80BE003FBCCC, 0x000C78BC8000178B, 0x000CF4BA000D80BD, 
0x000CF4B8000C54BB, 0x800017B680001792, 0x800017BA000CB8B7, 0x0003A0B2000C8CB5, 0x800017A1000CA0B3, 0x000270AE000340B1, 0x000305B8000364AF, 0x800017A8000348AD, 
0x000344A8800017AF, 0x800017DA0003D8A9, 0x000268A40003D8A7, 0x000335B6000388A5, 0x0002C89200033DB7, 0x00015D9900033DB5, 0x0001659B00014D98, 0x0001659D0001699A, 
0x0001859F0001659C, 0x00029C870001999E, 0x0000A5960000ADBE, 0x000534CC0000BD97, 0x0038B8CC00378CCD, 0x0001959F0038ACCD, 0x0001999D00001DB6, 0x0001B1B30001F59C, 
0x800017E1000278AE, 0x00003D99800017BE, 0x0000199B800017C5, 0x800017CC0000099A, 0x000248E0800017D3, 0x00025CAC0000099E, 0x800017FA0002F4AD, 0x800017FE800017F6, 
0x00036087800017E8, 0x000254AF800017EF, 0x00000597000011BE, 0x0002ACE080001802, 0x0003F88680001806, 0x0002B4E00003EC87, 0x000248AF8000180E, 0x00023CE0000290AE, 
0x8000180A00000DBE, 0x0002D8E000001997, 0x0000119600038486, 0x00006D9D000C00BF, 0x800018120000619C, 0x000250B300024CB1, 0x8000181600000D95, 0x0002C8E000039C86, 
0x00000582000204B3, 0x000250B380001822, 0x8000182600000D95, 0x8000181E8000181A, 0x00038C860002B4E0, 0x00000DBE0003DC87, 0x0000799600006995, 0x0002E8B48000182A, 
0x00000597000250B5, 0x0002D4E080001832, 0x000019BE0002F4B4, 0x8000182E0002A0E0, 0x00038C990002D4E0, 0x0000058A0002D4B7, 0x8000183A80001836, 0x000234B70000158A, 
0x8000183E00001D8F, 0x000005B380001842, 0x000005B380001846, 0x0000099C8000185B, 0x8000184D0000099D, 0x0000058C80001854, 0x8000186D80001862, 0x8000187B80001874, 
0x800018820000499F, 0x8000186680001889, 0x8000189780001890, 0x800018CF800018D9, 0x800018E0800018EA, 0x0001C9838000189E, 0x800018AC0001F981, 0x800018BA800018B3, 
0x800018C8800018C1, 0x0002B480800018A5, 0x000208E1000388A5, 0x800018F100001DAE, 0x0001F58D000009BC, 0x000200E1800018F5, 0x001094E300019592, 0x0001899700004593, 
0x0001788700001485, 0x80003A4600040086, 0x80003A4E80003A4A, 0x80003A5680003A52, 0x00688CEF0000799D, 0x80003A5A0001A19C, 0x000099A280003A5E, 0x80003A6680003A62, 
0x80003A6E80003A6A, 0x80003A72000089A7, 0x000149A980003A76, 0x0000A9AC80003A7A, 0x80003A8280003A7E, 0x000125B380003A86, 0x80003A8E80003A8A, 0x000121B780003A92, 
0x000131B5000139B6, 0x80003A9A80003A96, 0x000111B90000F9B9, 0x80003A9E000119B8, 0x80003AA680003AA2, 0x0001B08080003AAA, 0x80003AAE00028884, 0x000354840001C883, 
0x80003AB200045C84, 0x0003DD8000055C84, 0x0000318200002D81, 0x80003ABA00023CBE, 0x0003888780003ABE, 0x00032DB300049C86, 0x80003AC680003AC2, 0x00051CBE000400BE, 
0x0003D9B50003D1B6, 0x0003F9BB80003ACA, 0x01D3589A0003F1BA, 0x0003C5BF0007E084, 0x0003DDBD0003D9BE, 0x001800BE0003DDBC, 0x00030DA6000305A5, 0x00181C8480003ACE, 
0x80003AD680003AD2, 0x000301AC0003F1A3, 0x000305AE000301AD, 0x021BA4AC000319AF, 0x00032DAA021ADCAD, 0x00194CBE000325AB, 0x80003ADA001A48BE, 0x021AE0B4001B80BE, 
0x021E30B6021DD4B5, 0x80003ADE000208EF, 0x021A38BA0001A0E1, 0x000000BA0002F8E3, 0x021CF4BE021C64BD, 0x01D30491021000BF, 0x000144E001F6E490, 0x80003AE2023E0892, 
0x80003AEA80003AE6, 0x001CACBE80003AEE, 0x80003AF680003AF2, 0x80003AFE80003AFA, 0x80003B0680003B02, 0x006DB08180003B0A, 0x00521C8300018080, 0x009A20850077D882, 
0x00CF088700BE9084, 0x01376C8900E68C86, 0x017E188B012CE088, 0x01A5E08D0113D88A, 0x01EBFC8F015AF08C, 0x0017D5B0018F588E, 0x006B8DB2006801B1, 0x006B49B4006B9DB3, 
0x80003B0E006F95B5, 0x80003B12000170E0, 0x80003B1A80003B16, 0x0000198080003B1E, 0x0000058200001981, 0x80003B2A80003B22, 0x000749A20002A5A1, 0x000641A4000741A3, 
0x001BDDA6001BD5A5, 0x001C01A8001AC1A7, 0x001F49AA001FE1A9, 0x0013F5AC001001AB, 0x001401AE0013ADAD, 0x000631A80017F9AF, 0x00064DAA000631A9, 0x00064DAC000645AB, 
0x00068DAE000699AD, 0x00038086000685AF, 0x80003B2E00031887, 0x80003B3680003B32, 0x80003B3E80003B3A, 0x00076DB880003B42, 0x00077DBA000775B9, 0x00076DBC000775BB, 
0x0007F9BE0007CDBD, 0x0006A9B00007F9BF, 0x000779B2000685B1, 0x000769B4000779B3, 0x00075DB6000769B5, 0x80003AB6000755B7, 0x80003B460006C1B3, 0x00061DB680003B26, 
0x80003B4E80003B4A, 0x000669BA0006C1B5, 0x80003B52000645BB, 0x0007A9BE80003B56, 0x0007A9BC0007A9BF, 0x000685A30007A9BD, 0x80003B5E80003B5A, 0x80003B6680003B62, 
0x000685A5000659A6, 0x000601AB80003B6A, 0x80003B6E00062DAA, 0x0007EDAF80003B72, 0x0007EDAD0007EDAE, 0x0006C1A80007EDAC, 0x000125AA00012DA9, 0x000125AC00013DAB, 
0x000125AE00012DAD, 0x80003B76000195AF, 0x80003B7E80003B7A, 0x80003B8680003B82, 0x0000BD810000BD82, 0x00019DB80000BD80, 0x0001A5BA0001ADB9, 0x000075BC00006DBB, 
0x000075BE00007DBD, 0x0001F5B000006DBF, 0x0001C1B20001FDB1, 0x0001B5B40001C1B3, 0x0001B5B60001BDB5, 0x80003B8A0001ADB7, 0x80003B9280003B8E, 0x80003B960001A1B3, 
0x0001A1B60001A1B5, 0x0001808680003B9A, 0x00013DBA0001C487, 0x000119BC000135BB, 0x00017DBE000119BD, 0x0001EDA3000175BF, 0x80003BA280003B9E, 0x80003BAA80003BA6, 
0x0001EDA50001EDA6, 0x000179AB80003BAE, 0x80003BB2000171AA, 0x000139AF80003BB6, 0x000155AD000131AE, 0x80003BBA000155AC, 0x80003BC280003BBE, 0x80003BCA80003BC6, 
0x80003BCE0001ACE1, 0x80003BD2000660E3, 0x80003BDA80003BD6, 0x80003BDE000654EF, 0x001AB4BE80003BE2, 0x80003BEA80003BE6, 0x001C688680003BEE, 0x80003BF200038C87, 
0x80003BFA80003BF6, 0x0000398080003BFE, 0x0000058200003981, 0x80003C0A80003C02, 0x80003C1280003C0E, 0x00031DA880003C16, 0x000341AA000341A9, 0x000341AC000341AB, 
0x000371AE000349AD, 0x001D2084000371AF, 0x80003C1E80003C1A, 0x80003C2680003C22, 0x80003C2E80003C2A, 0x0000E9B880003C32, 0x0000FDBA0000F5B9, 0x000091BC0000F1BB, 
0x000089BE000091BD, 0x0000E1B0000089BF, 0x0000E1B20000E1B1, 0x0000E1B40000E1B3, 0x0000D9B60000EDB5, 0x00070CE30000D9B7, 0x000130E1000720E1, 0x80003C36000708E3, 
0x80003C3E80003C3A, 0x80003C4680003C42, 0x80003C4E80003C4A, 0x000798EF80003C52, 0x80003C5A80003C56, 0x000289B3000788EF, 0x80003C6280003C5E, 0x80003C66001A80BE, 
0x000289B5000289B6, 0x000165BB80003C6A, 0x80003C6E000165BA, 0x000169BF80003C72, 0x000175BD000165BE, 0x00063DB7000175BC, 0x00063DB500063DB6, 0x000635B3000621B4, 
0x000601B1000635B2, 0x000659BF000609B0, 0x000659BD000651BE, 0x00066DBB00064DBC, 0x000671B9000679BA, 0x00009D80000679B8, 0x0000A5820000AD81, 0x80003C7E80003C7A, 
0x80003C8680003C82, 0x000671AF80003C8A, 0x00066DAD000669AE, 0x000681AB00066DAC, 0x000691A9000699AA, 0x80003C06000699A8, 0x80003C8E80003C76, 0x80003C92001DC5A3, 
0x001DC5A6001DC5A5, 0x0003008680003C96, 0x001E29AA00036487, 0x001E39AC001E29AB, 0x001E29AE001E39AD, 0x001E39B3001E25AF, 0x80003C9E80003C9A, 0x80003CA680003CA2, 
0x001EFDB5001EFDB6, 0x001ED9BB80003CAA, 0x80003CAE001ED1BA, 0x001F69BF80003CB2, 0x001F69BD001F61BE, 0x001EF1A8001EC1BC, 0x001EF1AA001EF1A9, 0x001E35AC001EF1AB, 
0x001E35AE001E3DAD, 0x80003CB6001E2DAF, 0x80003CBE80003CBA, 0x80003CC680003CC2, 0x80003CCE80003CCA, 0x001FE5B880003CD2, 0x001FE5BA001FEDB9, 0x001FE9BC001FF9BB, 
0x001F91BE001F91BD, 0x001E55B0001F8DBF, 0x001E55B2001E5DB1, 0x001FE5B4001FFDB3, 0x001FE5B6001FEDB5, 0x001F79A3001FDDB7, 0x80003CDA80003CD6, 0x80003CE280003CDE, 
0x001FBDA5001FBDA6, 0x001F99AB80003CE6, 0x00008886001F91AA, 0x001E29AF00014C87, 0x001E29AD001E21AE, 0x00004980001F81AC, 0x0000598200004981, 0x80003CEA001E99B3, 
0x000151B6001E89B5, 0x80003CF280003CEE, 0x00012DBA80003CF6, 0x00013DBC000125BB, 0x000125BE000125BD, 0x001E4DA8000115BF, 0x001E5DAA001E55A9, 0x001E4DAC001E55AB, 
0x000189AE00019DAD, 0x0001AC84000181AF, 0x80003CFE80003CFA, 0x80003D0680003D02, 0x80003D0E80003D0A, 0x000165B880003D12, 0x000165BA00016DB9, 0x000165BC00017DBB, 
0x000165BE00016DBD, 0x0001A5B00000D9BF, 0x0001A5B20001ADB1, 0x0001ADB40001BDB3, 0x000195B600019DB5, 0x001DD5A300015DB7, 0x80003D1A80003D16, 0x80003D2280003D1E, 
0x001DC5A500021DA6, 0x000269AB80003D26, 0x80003D2A000261AA, 0x000259AF80003D2E, 0x000269AD000269AE, 0x80003D32000271AC, 0x80003D3A80003D36, 0x80003D4280003D3E, 
0x80003D4A80003D46, 0x0000398080003D4E, 0x0000058200003981, 0x80003D5A80003D52, 0x0003408780003D5E, 0x00044C8400045C86, 0x80003D6680003D62, 0x000120E300050484, 
0x0001A8E180003D6A, 0x001A94EF80003D6E, 0x80003D7680003D72, 0x80003D7E80003D7A, 0x80003D8680003D82, 0x0003A1B380003D8A, 0x80003D9280003D8E, 0x80003D9A80003D96, 
0x00037DB500037DB6, 0x000359BB80003D9E, 0x80003DA2000351BA, 0x0000FDBF80003DA6, 0x0000FDBD0000FDBE, 0x000251A8000341BC, 0x000269AA000259A9, 0x0002B5AC000269AB, 
0x0002B5AE0002BDAD, 0x0007A8840002ADAF, 0x80003DAE80003DAA, 0x0000A98280003DB2, 0x0000A98080003DB6, 0x000169B80000A981, 0x000109BA000169B9, 0x000119BC000109BB, 
0x000109BE000119BD, 0x0002D5B0000109BF, 0x0002D5B20002DDB1, 0x000179B4000169B3, 0x000169B6000179B5, 0x0001B8E1000161B7, 0x001F38E3001FD4E1, 0x80003DBA001B0CE3, 
0x80003DC280003DBE, 0x80003DCE80003DCA, 0x80003DD680003DD2, 0x00093CBE80003DDA, 0x001B84EF80003DDE, 0x0002A1A3001B84EF, 0x0004E88680003DE2, 0x80003DE60005BC87, 
0x00027DA500027DA6, 0x000259AB80003DEA, 0x80003DEE000251AA, 0x0001FDAF80003DF2, 0x0001FDAD0001FDAE, 0x000685B3000241AC, 0x80003DF680003DC6, 0x80003DFE80003DFA, 
0x00068DB5000689B6, 0x000691BB80003E02, 0x80003E06000689BA, 0x0006F5BF80003E0A, 0x000681BD000689BE, 0x80003E0E000689BC, 0x80003E1680003E12, 0x80003E1E80003E1A, 
0x80003E2680003E22, 0x80003E2A001D84EF, 0x80003E2E000400E1, 0x000011800004FCE3, 0x0000058200001D81, 0x0006F1A880003E32, 0x00060DAA0006F1A9, 0x000605AC000605AB, 
0x00063DAE000609AD, 0x80003E36000635AF, 0x0000888680003E3A, 0x80003E3E00031087, 0x80003E4680003E42, 0x000611B880003E4A, 0x000621BA000619B9, 0x0007F5BC000621BB, 
0x0007F5BE0007FDBD, 0x00064DB00007E9BF, 0x00065DB2000655B1, 0x00064DB4000655B3, 0x000631B6000631B5, 0x000785A3000631B7, 0x80003E5280003E4E, 0x80003E5A80003E56, 
0x00078DA5000789A6, 0x000791AB80003E5E, 0x80003E62000789AA, 0x0007F5AF80003E66, 0x000781AD000789AE, 0x80003E6A000789AC, 0x80003E6E0006E1B3, 0x0006E5B680003E72, 
0x80003E7A80003E76, 0x0006BDBA0006F1B5, 0x80003E7E00068DBB, 0x00017DBE80003E82, 0x000695BC000165BF, 0x00061DA8000175BD, 0x00062DAA000625A9, 0x00063DAC000625AB, 
0x00065DAE000621AD, 0x80003E8600064DAF, 0x80003E8E80003E8A, 0x80003E9680003E92, 0x0003B1810003B982, 0x0001EDB80003B980, 0x00018DBA000185B9, 0x00019DBC000185BB, 
0x00018DBE000185BD, 0x00063DB0000185BF, 0x000605B200060DB1, 0x0001FDB40001E5B3, 0x0001E5B60001E5B5, 0x0005A5A30001D5B7, 0x80003E9E80003E9A, 0x80003EAA80003EA2, 
0x0005B5A50005A1A6, 0x0005C9AB80003EAE, 0x000C08860005F9AA, 0x000221AF00031C87, 0x000231AD000239AE, 0x80003EB20005D1AC, 0x80003EB60002F1B3, 0x000355B680003EBA, 
0x80003EC280003EBE, 0x000371BA0002E1B5, 0x80003EC6000379BB, 0x000331BE80003ECA, 0x000351BC00033DBF, 0x000225A8000351BD, 0x00023DAA000235A9, 0x00022DAC000235AB, 
0x000391AE000391AD, 0x80003ECE000391AF, 0x80003ED680003ED2, 0x000000AC80003EDA, 0x80003EE280003EDE, 0x000399B880003EE6, 0x0003A5BA0003ADB9, 0x000375BC00036DBB, 
0x000375BE00037DBD, 0x0003F1B000036DBF, 0x0003C1B20003F9B1, 0x0003B1B40003C1B3, 0x0003B5B60003BDB5, 0x80003EEA0003A9B7, 0x80003EF280003EEE, 0x80003EFA80003EF6, 
0x80003F0280003EFE, 0x000C68BE001AA8EF, 0x80003F06000194E1, 0x00000D8000061CE3, 0x0000718200007181, 0x0003F5A380003F0A, 0x80003F1280003F0E, 0x80003F1A00024C84, 
0x0003E5A5000251A6, 0x00027DAB80003F1E, 0x000CC886000275AA, 0x000239AF000D2C87, 0x000255AD000235AE, 0x000650E1000255AC, 0x000714E380003F22, 0x80003F26000CC084, 
0x80003F2E80003F2A, 0x80003F3680003F32, 0x80003F3E80003F3A, 0x80003F4680003F42, 0x001B78EF80003F4A, 0x80003F4E000FF8BE, 0x80003F5680003F52, 0x80003F5A00018DB3, 
0x00018DB6000199B5, 0x80003D5680003F5E, 0x000185BA80003F62, 0x000155BC00014DBB, 0x000155BE00015DBD, 0x000E41A3000149BF, 0x80003F6680003F16, 0x80003F6E80003F6A, 
0x000E55A5000E41A6, 0x000E81AB80003F72, 0x80003F76000E49AA, 0x000E85AF80003F7A, 0x000E91AD000E99AE, 0x00006D80000E99AC, 0x00001D8200000981, 0x000918EF80003F7E, 
0x80003F8680003F82, 0x000D3CE380003F8A, 0x000C58E180003F8E, 0x0000D08680003F92, 0x80003F960003BC87, 0x000E91A880003F9A, 0x000EC9AA000E99A9, 0x000EDDAC000EC5AB, 
0x000EC1AE000EC1AD, 0x0000E884000EF5AF, 0x80003FA280003F9E, 0x80003FAA80003FA6, 0x80003FB280003FAE, 0x000FC1B880003FB6, 0x000FC1BA000FC1B9, 0x000FC1BC000FC1BB, 
0x000FC1BE000FC1BD, 0x000E8DB0000FF5BF, 0x000E4DB2000E45B1, 0x000E5DB4000E45B3, 0x000E41B6000E41B5, 0x000E51A8000E41B7, 0x000E8DAA000E59A9, 0x000E85AC000E9DAB, 
0x000E85AE000E8DAD, 0x80003FBA000EBDAF, 0x80003FC280003FBE, 0x80003FCA80003FC6, 0x80003FD280003FCE, 0x000E91B880003FD6, 0x000EADBA000E99B9, 0x00015DBC000145BB, 
0x000145BE000145BD, 0x000EC5B0000175BF, 0x000EC5B2000ECDB1, 0x000EC5B4000EDDB3, 0x000EBDB6000EB5B5, 0x000E05B3000EB5B7, 0x80003FDE80003FDA, 0x80003FE680003FE2, 
0x000E0DB5000E0DB6, 0x000E09BB80003FEA, 0x80003FEE000E01BA, 0x000E71BF80003FF2, 0x000E09BD000E01BE, 0x00006D82000E11BC, 0x00005580000E41A3, 0x000E49A600006581, 
0x80003FFE80003FFA, 0x000E45AA000E49A5, 0x00004886000E4DAB, 0x000E45AE00007887, 0x000E55AC000E35AF, 0x00025DA8000E4DAD, 0x000265AA000261A9, 0x00026DAC000275AB, 
0x0002B1AE0002B1AD, 0x0004EC840002B1AF, 0x8000400680004002, 0x8000400E8000400A, 0x8000401680004012, 0x000371B88000401A, 0x000371BA000371B9, 0x0003D5BC000371BB, 
0x0003D5BE0003DDBD, 0x0002D1B00003CDBF, 0x0002D1B20002D1B1, 0x000351B40002D1B3, 0x000351B6000351B5, 0x8000401E000351B7, 0x800040220002E9B3, 0x000235B6000480BE, 
0x8000402A80004026, 0x000211BA0002E1B5, 0x8000402E000211BB, 0x000391BE80004032, 0x000201BC000391BF, 0x80004036000201BD, 0x0002A5A38000403A, 0x0002ADA58000403E, 
0x8000404680004042, 0x8000404A000279A6, 0x00025DAB8000404E, 0x00024DAD00025DAA, 0x0003DDAF00024DAC, 0x0002D5A80003DDAE, 0x00012DAA0002DDA9, 0x00013DAC000125AB, 
0x00012DAE000125AD, 0x80004052000125AF, 0x8000405A80004056, 0x800040628000405E, 0x8000406E8000406A, 0x000185B880004072, 0x00019DBA000189B9, 0x0001B1BC000195BB, 
0x000079BE0001B1BD, 0x00015DB0000079BF, 0x0001E1B20001E5B1, 0x0001E9B40001F9B3, 0x0001D5B60001DDB5, 0x000EF0E10001BDB7, 0x000E14E380004076, 0x0000BD818000407A, 
0x8000407E0000BD80, 0x000400860000AD82, 0x800040820005EC87, 0x8000408A80004086, 0x000E60EF8000408E, 0x8000409680004092, 0x007D5C858000409A, 0x800040A28000409E, 
0x800040A6000164E3, 0x800040AA0001B4E1, 0x800040AE000EA0EF, 0x0005F88480003EA6, 0x800040B6800040B2, 0x000625B3800040BA, 0x800040BE80004066, 0x800040C6800040C2, 
0x000635B5000625B6, 0x0006A1BB800040CA, 0x800040CE000619BA, 0x000699BF800040D2, 0x0006ADBD0006ADBE, 0x00006D820006B5BC, 0x00005580000430EF, 0x00035CBE00006581, 
0x0000F886800040D6, 0x800040DA00036C87, 0x800040E2800040DE, 0x800040EA800040E6, 0x800040EE000444E3, 0x0006A5A300078CE1, 0x800040F6800040F2, 0x800040FE800040FA, 
0x0006B5A50006A5A6, 0x000621AB80004102, 0x80004106000699AA, 0x000619AF8000410A, 0x00062DAD00062DAE, 0x8000410E000635AC, 0x800041120007F9B3, 0x000749B680004116, 
0x8000411E8000411A, 0x000751BA000751B5, 0x80004122000751BB, 0x000735BE80004126, 0x000745BC000739BF, 0x000635A800073DBD, 0x000635AA00063DA9, 0x00069DAC000689AB, 
0x0006B1AE00068DAD, 0x8000412A0006B1AF, 0x800041328000412E, 0x00000D8080004136, 0x0000B1820000B181, 0x0006A1B88000413A, 0x0006BDBA0006ADB9, 0x0006ADBC0006B5BB, 
0x000155BE00015DBD, 0x0006D1B000014DBF, 0x0006D5B20006D1B1, 0x0006B5B40006ADB3, 0x0006A9B60006B9B5, 0x0006BDA30006A5B7, 0x800041428000413E, 0x000190BE00028484, 
0x000615A500060DA6, 0x000615AB8000414A, 0x00000886000615AA, 0x00067DAF00017C87, 0x000679AD000671AE, 0x8000414E000601AC, 0x800041520001ADB3, 0x0001A9B680004156, 
0x8000415E8000415A, 0x00016DBA0001ADB5, 0x80004162000175BB, 0x00015DBE80004166, 0x000165BC000135BF, 0x000261A8000155BD, 0x000261AA000261A9, 0x000261AC000261AB, 
0x00029DAE00026DAD, 0x8000416A000295AF, 0x800041728000416E, 0x8000417A80004176, 0x800041828000417E, 0x000295B880004186, 0x0002A1BA00029DB9, 0x000371BC0002A1BB, 
0x000371BE000371BD, 0x0002EDB0000371BF, 0x0002F5B20002F5B1, 0x0002DDB40002C5B3, 0x0002B1B60002B5B5, 0x8000418A0002B1B7, 0x800041928000418E, 0x800041960002E5A3, 
0x0002E1A60002E5A5, 0x8000419E8000419A, 0x000225AA800041A2, 0x00022DAC00023DAB, 0x000215AE00021DAD, 0x800041A600027DAF, 0x800041AE800041AA, 0x00001580007C4084, 
0x0000058200001D81, 0x007CECBE800041B2, 0x007D4886800041BA, 0x800041BE00030887, 0x800041C6800041C2, 0x00029DA8800041CA, 0x0002C1AA0002C5A9, 0x0002C5AC0002C1AB, 
0x0002F1AE0002CDAD, 0x800041CE0002F1AF, 0x800041D6800041D2, 0x000000C9800041DA, 0x800041E2800041DE, 0x0001C1B8800041E6, 0x0001C1BA0001C1B9, 0x0001CDBC0001DDBB, 
0x0001FDBE0001F5BD, 0x000141B000019DBF, 0x000141B2000141B1, 0x000141B4000141B3, 0x000141B6000141B5, 0x000638E1000141B7, 0x000668E3800041EA, 0x800041F2800041EE, 
0x800041FA800041F6, 0x007CACBE007D9484, 0x80004202800041FE, 0x007FB8BE80004206, 0x000110EF8000420A, 0x800042128000420E, 0x8000421A80004216, 0x000190E18000421E, 
0x000044E380004222, 0x00002D818000422A, 0x000080EF00002D80, 0x8000422E00003982, 0x80003FF680004232, 0x007FB0E180004236, 0x007CD4E3800041B6, 0x800042268000423A, 
0x0000B8868000423E, 0x800042420002D487, 0x8000424A80004246, 0x800042528000424E, 0x007C20EF80004256, 0x007D89B38000425A, 0x800042628000425E, 0x8000426A80004266, 
0x007D8DB5007D8DB6, 0x007E45BB8000426E, 0x80004272007E45BA, 0x007E45BF80004276, 0x007E55BD007E45BE, 0x007D49A3007E55BC, 0x8000427E8000427A, 0x8000428680004282, 
0x007D4DA5007D4DA6, 0x007E85AB8000428A, 0x8000428E007E85AA, 0x007E85AF80004292, 0x007E95AD007E85AE, 0x00006D82007E95AC, 0x00005580007E31B3, 0x007FF1B600006581, 
0x800042960003DC84, 0x007FCDBA007E21B5, 0x00040086007FD1BB, 0x007F75BE0000D487, 0x007FC1BC007F79BF, 0x007FE5A8007FC1BD, 0x007FFDAA007FF5A9, 0x007FEDAC007FF5AB, 
0x007E3DAE007E35AD, 0x8000429A007E35AF, 0x800042A28000429E, 0x800042AA800042A6, 0x800042B2800042AE, 0x007ED9B8800042B6, 0x007EE1BA007EE1B9, 0x007EE5BC007EE1BB, 
0x007E99BE007EE9BD, 0x007E4DB0007E99BF, 0x007E51B2007E51B1, 0x007EF5B4007E51B3, 0x007EE9B6007EF9B5, 0x007F75A3007EE9B7, 0x800042BE800042BA, 0x800042C6800042C2, 
0x007F65A5007EB5A6, 0x007E95AB800042CA, 0x800042CE007E89AA, 0x007E3DAF800042D2, 0x007E85AD007E31AE, 0x800042D6007E85AC, 0x800042DA007E31B3, 0x0001C5B6800042DE, 
0x800042E6800042E2, 0x0001C9BA0001D1B5, 0x800042EA0001C9BB, 0x0001CDBE800042EE, 0x0001C9BC0001B1BF, 0x007DDDA80001C9BD, 0x007DFDAA007DF5A9, 0x00021DAC007DF1AB, 
0x000239AE000201AD, 0x800042F2000239AF, 0x800042FA800042F6, 0x00000582800042FE, 0x0000118080004302, 0x000211B800001181, 0x000221BA000219B9, 0x0002D5BC000221BB, 
0x0002D5BE0002DDBD, 0x000249B00002CDBF, 0x000259B2000249B1, 0x00024DB4000259B3, 0x000231B6000231B5, 0x000300BE000231B7, 0x00028884007D71A3, 0x000285A6000480BE, 
0x8000430E8000430A, 0x000289AA000291A5, 0x00042886000289AB, 0x00028DAE00030C87, 0x000289AC0002F1AF, 0x80004312000289AD, 0x0005CC850003C884, 0x800043160003E5B3, 
0x0003EDB60003E5B5, 0x8000431E8000431A, 0x00036DBA80004322, 0x00037DBC000365BB, 0x000365BE000365BD, 0x80004326000355BF, 0x000400BF8000432A, 0x8000432E000225A3, 
0x00022DA6000225A5, 0x8000433680004332, 0x0002ADAA8000433A, 0x0002BDAC0002A5AB, 0x0002A5AE0002A5AD, 0x8000433E000295AF, 0x8000434680004342, 0x8000434E8000434A, 
0x800043520003CCE3, 0x800043560001ACE1, 0x8000435A00031CEF, 0x800043628000435E, 0x8000436A80004366, 0x007F70E18000436E, 0x007E04E380004146, 0x8000437A80004372, 
0x8000437E000194E1, 0x0000D980000158E3, 0x000025820000D981, 0x80004382007EE4EF, 0x007EE0EF80004386, 0x000101B38000438A, 0x0007E8868000438E, 0x8000439200042C87, 
0x000105B5000135B6, 0x0000F1BB80004396, 0x8000439A0000E1BA, 0x0000B1BF8000439E, 0x0000D9BD0000D1BE, 0x800043060000E1BC, 0x800043A280004376, 0x000401A1800043A6, 
0x000019A3000411A0, 0x0006B5A80004C5A2, 0x0006E9AA0006BDA9, 0x0006EDAC0006FDAB, 0x0006DDAE0006D5AD, 0x000745B000073DAF, 0x000755B2000755B1, 0x000775B400076DB3, 
0x00071DB6000715B5, 0x00072DB8000715B7, 0x000731BA000735B9, 0x000719BC00070DBB, 0x000709BE000719BD, 0x000641A3000709BF, 0x800043AE800043AA, 0x800043B6800043B2, 
0x000645A5000675A6, 0x0007B1AB800043BA, 0x006DC98F0007A1AA, 0x0007F1AF800043BE, 0x000799AD000791AE, 0x0075DD950007A1AC, 0x0070CD970074C194, 0x00685D9100732D96, 
0x0074D99300685590, 0x0078E59D00694D92, 0x00076D9F007B1D9C, 0x007F1D990078B99E, 0x007CA19B00705598, 0x006C6182007CF99A, 0x800043C200698583, 0x00751186800043C6, 
0x0069958400751187, 0x00743D8A00688D85, 0x800043CA0072C58B, 0x007EDD8E800043CE, 0x00713D8C007D318F, 0x007D199200719D8D, 0x800043D2007ABD93, 0x0006D596000990EF, 
0x00795D9400055197, 0x0005719A00790995, 0x800043D60005BD9B, 0x800043DE800043DA, 0x0001799C0005A8E1, 0x000185A10008B8E3, 0x000DA9A3800043E2, 0x000801A5000C01A2, 
0x0009A9A7000D39A4, 0x0015A5A90009BDA6, 0x001401AB001401A8, 0x0011B9AD0015FDAA, 0x001C01AF0011B1AC, 0x001CFDB10010A1AE, 0x0019E9B3001DE5B0, 0x002401B5001801B2, 
0x0000148400197DB4, 0x00008D80000014BE, 0x00006D8200009581, 0x000F5086800043EA, 0x800043EE00006487, 0x0007D5BA800043F2, 0x0007C1B80007DDBB, 0x000431BE0007C1B9, 
0x0007F1BC000431BF, 0x0007ADB20007F1BD, 0x0007ADB00007B5B3, 0x00079DB60007A5B1, 0x0007A5B40007F5B7, 0x000769AA000795B5, 0x000769A8000769AB, 0x000769AE000769A9, 
0x000769AC000769AF, 0x800043F6000769AD, 0x800043FE800043FA, 0x8000440680004402, 0x8000440E8000440A, 0x000511A880004412, 0x000539AA00051DA9, 0x00052DAC000539AB, 
0x000549AE000551AD, 0x80004416000541AF, 0x8000441E8000441A, 0x8000442680004422, 0x8000442E8000442A, 0x00025DB880004432, 0x0003C1BA000269B9, 0x0003F9BC0003C1BB, 
0x000391BE0003F9BD, 0x000509B00003B5BF, 0x0002E1B2000509B1, 0x000275B40002E1B3, 0x000275B600027DB5, 0x0004B1B300026DB7, 0x000D04BE00020084, 0x8000443A80004436, 
0x0004A5B50004D1B6, 0x0004CDBB8000443E, 0x800044420004CDBA, 0x0003B9BF80004446, 0x000335BD0003B1BE, 0x8000444A000335BC, 0x8000444E0004F5A3, 0x000495A680004452, 
0x8000445E8000445A, 0x000489AA0004E1A5, 0x000DA887000489AB, 0x0003F5AE000CCC86, 0x000371AC0003FDAF, 0x000650E1000371AD, 0x000040E3000734E1, 0x0000D180000758E3, 
0x0000D5820000DD81, 0x8000446680004462, 0x8000446E8000446A, 0x8000447680004472, 0x00009CEF8000447A, 0x8000447E0007C8EF, 0x000235B380004482, 0x0001B5B580004486, 
0x8000448E8000448A, 0x000CECBE0001B5B6, 0x000191BB80004492, 0x000151BD000199BA, 0x000151BF000189BC, 0x000DEDA8000159BE, 0x000DF5AA000DFDA9, 0x000E75AC000E6DAB, 
0x000E75AE000E7DAD, 0x80004456000E6DAF, 0x8000449A80004496, 0x800044A28000449E, 0x800044AA800044A6, 0x000EF5B8800044AE, 0x000EF5BA000EFDB9, 0x000F41BC000F41BB, 
0x000F71BE000F49BD, 0x000E15B0000F71BF, 0x000E15B2000E1DB1, 0x000ED5B4000ECDB3, 0x000ED5B6000EDDB5, 0x000D7DA3000ECDB7, 0x800044B6800044B2, 0x800044BE800044BA, 
0x000EFDA5000EFDA6, 0x000ED9AB800044C2, 0x0002A884000ED1AA, 0x000E19AF800044C6, 0x000E19AD000E11AE, 0x00004D80000EC1AC, 0x0000558200005581, 0x800044CA000F51B3, 
0x000F71B6000F71B5, 0x0000E086800044CE, 0x000F5DBA00030487, 0x000F35BC000F2DBB, 0x000F2DBE000F39BD, 0x000E55A8000F25BF, 0x000E95AA000E5DA9, 0x000EB5AC000EADAB, 
0x000EB5AE000EBDAD, 0x800044D2000EADAF, 0x800044DA800044D6, 0x800044E2800044DE, 0x800044EA800044E6, 0x000169B8800044EE, 0x000179BA000169B9, 0x000169BC000179BB, 
0x0001DDBE000169BD, 0x000ED5B00001D5BF, 0x000EADB2000EA5B1, 0x000EA5B4000EA1B3, 0x000E9DB6000EADB5, 0x000E1DA3000159B7, 0x800044F6800044F2, 0x800044FA800043E6, 
0x000E3DA5000E3DA6, 0x000E61AB800044FE, 0x80004502000E11AA, 0x000E69AF80004506, 0x000E75AD000E61AE, 0x8000450A000E79AC, 0x800045128000450E, 0x8000451A80004516, 
0x800045228000451E, 0x00000D8080004526, 0x00001D8200001581, 0x8000452E8000452A, 0x0001788480004532, 0x000F14E3000014BE, 0x000DE0E18000453A, 0x0004B08600030084, 
0x8000453E00031487, 0x8000454680004542, 0x8000454E8000454A, 0x000FC0EF80004552, 0x8000455A80004556, 0x800045628000455E, 0x8000456A80004566, 0x8000456E00036DB3, 
0x000375B600037DB5, 0x8000457680004572, 0x000351BA8000457A, 0x0003F5BC000351BB, 0x0003E9BE0003FDBD, 0x8000457E0003E1BF, 0x8000458680004582, 0x8000458E8000458A, 
0x8000459680004592, 0x000271A88000459A, 0x000389AA000279A9, 0x000399AC000389AB, 0x000389AE000399AD, 0x0003F9B0000389AF, 0x00034DB20003F9B1, 0x000341B4000345B3, 
0x000371B6000349B5, 0x000321B8000371B7, 0x000321BA000321B9, 0x000321BC000321BB, 0x000321BE000321BD, 0x00019D80000321BF, 0x0000118200001181, 0x000014EF00050484, 
0x800045A28000459E, 0x0000C8E3000510BE, 0x0001D0E1800045AA, 0x800045B2800045AE, 0x800045BA800045B6, 0x000279AA800045BE, 0x0004E886000279AB, 0x0002C1AE00056087, 
0x0002DDAC0002C9AF, 0x800045C20002D5AD, 0x800045C6000245A3, 0x00025DA6800045CA, 0x800045D2800045CE, 0x800045D6000255A5, 0x800045DE800045DA, 0x800045E6800045E2, 
0x800045EE800045EA, 0x0004ACBE000E84EF, 0x800045F2000ED0E1, 0x800045F6000114E3, 0x800045FE800045FA, 0x0001DDB380004602, 0x8000460A80004606, 0x800046128000460E, 
0x0001FDB50001FDB6, 0x0001DDBB8000461A, 0x0004E0840001DDBA, 0x0001A1BF8000461E, 0x0001BDBD0001BDBE, 0x000605A80001BDBC, 0x000615AA00061DA9, 0x000635AC00062DAB, 
0x000635AE00063DAD, 0x800045A6000629AF, 0x0007E5810007F582, 0x800046160007E580, 0x00001C8680004622, 0x000625B80003B087, 0x0006CDBA0006C5B9, 0x0006DDBC0006C5BB, 
0x0006CDBE0006C5BD, 0x000659B00006C5BF, 0x000629B2000659B1, 0x000639B4000629B3, 0x000625B6000625B5, 0x00069DA300061DB7, 0x8000462A80004626, 0x800046328000462E, 
0x0006BDA50006BDA6, 0x00069DAB80004636, 0x8000463A00069DAA, 0x0006E1AF8000463E, 0x0006FDAD0006FDAE, 0x800046420006FDAC, 0x800046460007F5B3, 0x0007EDB68000464A, 
0x800046528000464E, 0x00078DBA0007E5B5, 0x80004656000791BB, 0x000775BE8000465A, 0x000781BC00077DBF, 0x000625A800077DBD, 0x000639AA000629A9, 0x000629AC000639AB, 
0x000679AE000629AD, 0x8000465E000675AF, 0x8000466680004662, 0x8000466E8000466A, 0x8000467680004672, 0x0006D5B88000467A, 0x0006E1BA0006DDB9, 0x0006E5BC0006FDBB, 
0x0006E5BE0006EDBD, 0x00060DB0000699BF, 0x000611B2000611B1, 0x0006F5B40006EDB3, 0x0006F5B60006FDB5, 0x0006B1A30006EDB7, 0x0000158100002D82, 0x800045360000B180, 
0x0006A1A50006A9A6, 0x0006D5AB8000467E, 0x800046820006C9AA, 0x000639AF000168BE, 0x000639AD000631AE, 0x8000468A0006C5AC, 0x000068860001F1B3, 0x00015DB600017C87, 
0x800046928000468E, 0x000149BA000155B5, 0x80004696000149BB, 0x00013DBE8000469A, 0x000139BC000121BF, 0x8000469E000135BD, 0x00030484800046A2, 0x800046A6001C80BE, 
0x800046AA00061CE1, 0x002E08BF000600E3, 0x800046B2800046AE, 0x800046B60007C8EF, 0x800046BE800046BA, 0x800046C6800046C2, 0x00027DA3800046CA, 0x0002D9A5800046CE, 
0x800046D6800046D2, 0x800046DA0002D1A6, 0x0002C5AB800046DE, 0x0002B9AD0002C5AA, 0x0002ADAF0002B5AC, 0x00056DA90002B1AE, 0x00020DAB000559A8, 0x00021DAD0002B9AA, 
0x000205AF00021DAC, 0x001D68BE00020DAE, 0x800046E6800046E2, 0x00001D80800046EA, 0x0001998200000981, 0x0003E1B9800046EE, 0x0003E1BB000229B8, 0x0003E1BD0003E9BA, 
0x0003E1BF0003F9BC, 0x00024DB10003E9BE, 0x000221B300024DB0, 0x000225B500022DB2, 0x000211B7000239B4, 0x0002C1A8000225B6, 0x0002D1AA0002D1A9, 0x0002FDAC0002E5AB, 
0x00011DAE000115AD, 0x800046F200010DAF, 0x800046FE800046FA, 0x8000470680004702, 0x8000470E8000470A, 0x000105B880004712, 0x00011DBA000109B9, 0x000131BC000115BB, 
0x0001FDBE000131BD, 0x000179B00001F5BF, 0x000141B2000141B1, 0x000145B400015DB3, 0x000145B600014DB5, 0x001DA08600013DB7, 0x80004716001DC487, 0x8000471A0000D8EF, 
0x800047228000471E, 0x001C6C840006C4EF, 0x800047260006F4E1, 0x8000472A0006B0E3, 0x8000472E000194E1, 0x000219B3000644E3, 0x8000473680004732, 0x002CEC858000473A, 
0x000235B50001D5B6, 0x0001C5BB8000473E, 0x800047420001FDBA, 0x0001C9BF80004746, 0x0001C9BD0001C1BE, 0x001DD9A30001D5BC, 0x8000474A800046F6, 0x800047528000474E, 
0x001DF5A5001E15A6, 0x001E05AB80004756, 0x8000475A001E3DAA, 0x001E09AF8000475E, 0x001E09AD001E01AE, 0x00006980001E15AC, 0x0000058200006981, 0x8000476680004762, 
0x000310878000476A, 0x8000476E00037C86, 0x8000477680004772, 0x8000477E8000477A, 0x8000478680004782, 0x001FA5A88000478A, 0x001FA5AA001FADA9, 0x001FA5AC001FBDAB, 
0x001FA5AE001FADAD, 0x8000478E001F15AF, 0x8000479680004792, 0x8000479E8000479A, 0x800047A6800047A2, 0x001F0DB8800047AA, 0x001F21BA001F19B9, 0x0000D9BC001F21BB, 
0x0000C9BE0000D9BD, 0x001F71B00000C1BF, 0x001F71B2001F71B1, 0x001F41B4001F45B3, 0x001F3DB6001F4DB5, 0x001E2DB3001F35B7, 0x800047B2800047AE, 0x800047BA800047B6, 
0x001E2DB5001E2DB6, 0x001EB5BB800047BE, 0x800047C2001EB5BA, 0x001E89BF800047C6, 0x001E91BD001E85BE, 0x00002982001EA5BC, 0x00001D80001E69A3, 0x001E69A600001581, 
0x800047CE800047CA, 0x001EF1AA001E69A5, 0x800047D2001EF1AB, 0x001EC1AE0001E084, 0x001EE1AC001ECDAF, 0x0001D5A8001ED5AD, 0x0001EDAA0001E5A9, 0x0001FDAC0001E5AB, 
0x0001EDAE0001E5AD, 0x0001A0BE0001E5AF, 0x800047D680004686, 0x00001086800047DA, 0x800047DE00017487, 0x00017DB8800047E2, 0x0000C1BA0000C1B9, 0x0000C1BC0000C1BB, 
0x0000F1BE0000C9BD, 0x00019DB00000F1BF, 0x00014DB2000145B1, 0x00015DB4000145B3, 0x00014DB6000145B5, 0x800047E6000145B7, 0x800047EE800047EA, 0x800047F6800047F2, 
0x001EECEF000234EF, 0x001DF0E1800047FA, 0x001E30E30002E0E3, 0x800047FE000184E1, 0x8000480680004802, 0x000225B38000480A, 0x8000480E00000094, 0x8000481680004812, 
0x000235B5000225B6, 0x0002C1BB8000481A, 0x8000481E000219BA, 0x0002C1BF80004822, 0x0002D1BD0002D9BE, 0x800048260002D9BC, 0x8000482E8000482A, 0x800048320002E9A3, 
0x0002E9A60002F9A5, 0x8000483A80004836, 0x0002D5AA8000483E, 0x000215AC00020DAB, 0x000215AE00021DAD, 0x0000618000020DAF, 0x0000058200006181, 0x8000484A80004842, 
0x000414BE00040084, 0x0004C0868000484E, 0x8000485200035087, 0x8000485A80004856, 0x800048628000485E, 0x0002ADA880004866, 0x0002B5AA0002BDA9, 0x000115AC00010DAB, 
0x000115AE00011DAD, 0x0004EC8400010DAF, 0x8000486E8000486A, 0x8000487680004872, 0x8000487E8000487A, 0x00011DB880004882, 0x000125BA00012DB9, 0x0001D5BC0001CDBB, 
0x0001C9BE0001DDBD, 0x00017DB00001C1BF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x000135B600013DB5, 0x001E18E100012DB7, 0x001E38E380004886, 0x8000488E8000488A, 
0x8000489680004892, 0x8000489E8000489A, 0x000460BE800048A2, 0x00007581800048A6, 0x001FE0EF00007580, 0x800048AA00006D82, 0x0004E886800048AE, 0x800048B200057C87, 
0x800048BA000190E1, 0x800048BE0000A0E3, 0x800048C6800048C2, 0x800048CA0000B4EF, 0x800048D2800048CE, 0x000605B5800048D6, 0x800048B680004846, 0x800048DA000605B6, 
0x0005A5B3800048DE, 0x000619BD800048E2, 0x000661BF000611BC, 0x800048E6000611BE, 0x000609BB800048EA, 0x0005FDA3000621BA, 0x800048F2800048EE, 0x800048FA800048F6, 
0x00065DA500065DA6, 0x000651AB800048FE, 0x80004902000679AA, 0x000639AF80004906, 0x000641AD000649AE, 0x000651A8000649AC, 0x000661AA000659A9, 0x000661AC000661AB, 
0x000661AE000661AD, 0x8000490A000661AF, 0x800049128000490E, 0x00000D8080004916, 0x0001B1820001B181, 0x00074DB88000491A, 0x00075DBA000755B9, 0x00074DBC000755BB, 
0x00077DBE000775BD, 0x0007C5B0000771BF, 0x0007C5B20007CDB1, 0x0007C5B40007DDB3, 0x0007C5B60007CDB5, 0x0007E9B3000779B7, 0x800049228000491E, 0x0001D8BE0001C084, 
0x0007E9B50007E1B6, 0x000609BB80004926, 0x00008886000601BA, 0x000609BF0001AC87, 0x000609BD000601BE, 0x8000492A000611BC, 0x8000492E0007ADA3, 0x0007A5A680004932, 
0x8000493A80004936, 0x000645AA0007ADA5, 0x8000493E00064DAB, 0x000645AE80004942, 0x000655AC00064DAF, 0x000659A800064DAD, 0x00066DAA000665A9, 0x000661AC000665AB, 
0x000661AE000661AD, 0x0001AC84000661AF, 0x8000494A80004946, 0x800049528000494E, 0x8000495A80004956, 0x000191B88000495E, 0x0001A1BA000199B9, 0x000171BC0001A1BB, 
0x000171BE000171BD, 0x0001F1B0000171BF, 0x0001F5B20001F1B1, 0x0001C5B40001DDB3, 0x0001B1B60001B1B5, 0x0005E5B30001B1B7, 0x8000496680004962, 0x8000496E8000496A, 
0x0005E9B50005E1B6, 0x000235BB80004972, 0x80004976000235BA, 0x000275BF8000497A, 0x000209BD000201BE, 0x8000497E000221BC, 0x800049820005A1A3, 0x0005A5A680004986, 
0x8000498E8000498A, 0x000271AA0005ADA5, 0x80004992000271AB, 0x000245AE000328BE, 0x000265AC000231AF, 0x0000D58000024DAD, 0x0000E1820000DD81, 0x000120E38000499A, 
0x0001A8E18000499E, 0x000234EF800049A2, 0x000C0886800049A6, 0x000000AC00036887, 0x800049AE800049AA, 0x00038DB3800049B2, 0x800049BA800049B6, 0x800049BE000C8084, 
0x000381B50003BDB6, 0x00034DBB800049C2, 0x800049C600034DBA, 0x00034DBF800049CA, 0x00034DBD00034DBE, 0x000241A800034DBC, 0x000245AA00024DA9, 0x000249AC000259AB, 
0x000275AE00027DAD, 0x000D68BE0002B9AF, 0x800049D2800049CE, 0x000C6C84800049D6, 0x800049DE800049DA, 0x00014DB8800049E2, 0x000155BA000155B9, 0x00017DBC000165BB, 
0x000111BE000115BD, 0x0002C9B0000111BF, 0x0002D9B20002C9B1, 0x0002C9B40002D9B3, 0x00017DB60002C9B5, 0x000778E1000175B7, 0x0006B8E3000098E3, 0x800049E600065CE1, 
0x800049EE800049EA, 0x800049F6800049F2, 0x800049FE800049FA, 0x000000EC80004A02, 0x0006E8EF00005CEF, 0x0000698180004A0A, 0x000285A300006180, 0x000289A500006182, 
0x80004A1280004A0E, 0x000C40860002B5A6, 0x000245AB000CC487, 0x000245AD000245AA, 0x000245AF000245AC, 0x000E8DA8000245AE, 0x000E95AA000E91A9, 0x000EA5AC000EA9AB, 
0x000EA5AE000EADAD, 0x80004A06000ED9AF, 0x80004A1A80004A16, 0x80004A2280004A1E, 0x80004A2A80004A26, 0x000F75B880004A2E, 0x000F75BA000F7DB9, 0x000FC5BC000FDDBB, 
0x000FC5BE000FCDBD, 0x000EA9B0000FFDBF, 0x000EB5B2000EB5B1, 0x000E9DB4000E85B3, 0x000F51B6000F51B5, 0x000E1DB3000F51B7, 0x80004A3680004A32, 0x80004A3E80004A3A, 
0x000E2DB5000E2DB6, 0x000E71BB80004A42, 0x80004A46000E6DBA, 0x000F95BF80004A4A, 0x000E51BD000E59BE, 0x80004A4E000E61BC, 0x80004A52000E59A3, 0x000E69A680004A56, 
0x80004A5E80004A5A, 0x000E29AA000E69A5, 0x80004A62000E35AB, 0x000E1DAE80004A66, 0x000E25AC000FD1AF, 0x000EBDA8000E15AD, 0x000ED1AA000ED1A9, 0x000139AC000129AB, 
0x000129AE000139AD, 0x00000D80000129AF, 0x00001D8200001581, 0x80004A6E80004A6A, 0x000274BE80004A72, 0x0001EDB880004A76, 0x000181BA000185B9, 0x000185BC000181BB, 
0x0001B1BE00018DBD, 0x000159B00001B1BF, 0x0001EDB2000159B1, 0x0001FDB40001E5B3, 0x0001E5B60001E5B5, 0x80004A7A0001D5B7, 0x0001A1B50001A9B6, 0x000E49B380004A7E, 
0x0000388680004A82, 0x000131BF0001DC87, 0x000121BD000129BE, 0x00018DBB000129BC, 0x8000499600018DBA, 0x000E19A380004A86, 0x80004A8E80004A8A, 0x80004A9680004A92, 
0x0001F1A50001F9A6, 0x0001DDAB80004A9A, 0x80004A9E0001DDAA, 0x000161AF80004AA2, 0x000171AD000179AE, 0x80004AA6000179AC, 0x80004AAA000FDCEF, 0x80004AB280004AAE, 
0x80004ABA80004AB6, 0x80004AC280004ABE, 0x80004ACA80004AC6, 0x80004AD280004ACE, 0x80004AD6000EE8E3, 0x00001180000E8CE1, 0x0000118200001181, 0x80004ADA00024084, 
0x80004AE280004ADE, 0x0004C086000310BE, 0x80004AEA00034487, 0x80004AF280004AEE, 0x80004AFA80004AF6, 0x000224EF80004AFE, 0x80004B0680004B02, 0x80004B0E80004B0A, 
0x80004B1680004B12, 0x0004EC8480004B1A, 0x80004B2280004B1E, 0x0002ECE380004B26, 0x000138E180004B2A, 0x000355B380004B2E, 0x80004B3680004B32, 0x80004B3E80004B3A, 
0x00031DB500031DB6, 0x000309BB80004B42, 0x80004B46000339BA, 0x0000FDBF80004B4A, 0x0000F9BD0000FDBE, 0x000281A8000311BC, 0x00029DAA000289A9, 0x0002D5AC0002B1AB, 
0x0002D5AE0002DDAD, 0x0001CD800002CDAF, 0x0000198200000981, 0x80004B5280004B4E, 0x000570BE80004B5A, 0x000159B880004B5E, 0x000169BA000159B9, 0x000179BC000169BB, 
0x000169BE000179BD, 0x0002BDB0000165BF, 0x000285B200028DB1, 0x000179B400016DB3, 0x000169B6000179B5, 0x00042086000169B7, 0x80004B6200050887, 0x80004B6A80004B66, 
0x80004B7280004B6E, 0x0004EC8400005CEF, 0x80004B76000E5CE1, 0x80004B7A000E8CE3, 0x80004B8280004B7E, 0x000255A380004B86, 0x80004B8E80004B8A, 0x80004B9680004B92, 
0x00021DA500021DA6, 0x000209AB80004B9A, 0x80004B9E000239AA, 0x0001FDAF80004BA2, 0x0001F9AD0001FDAE, 0x000669A8000211AC, 0x000679AA000669A9, 0x000669AC000679AB, 
0x00069DAE000669AD, 0x80004B56000695AF, 0x80004BAA80004BA6, 0x80004BB280004BAE, 0x80004BBA80004BB6, 0x0006F5B880004BBE, 0x00068DBA0006F9B9, 0x00069DBC000685BB, 
0x000685BE000685BD, 0x0006EDB00006B5BF, 0x0006FDB20006F5B1, 0x0006EDB40006F5B3, 0x0006D1B60006D1B5, 0x0006F1B30006D1B7, 0x0000B58100001582, 0x80004BC20000B580, 
0x0006E1B50006E9B6, 0x000631BB0003D4BE, 0x80004BC6000629BA, 0x000615BF80004BCA, 0x000621BD000629BE, 0x80004BCE000629BC, 0x0000C8860006B5A3, 0x0006ADA60000C887, 
0x80004BD680004BD2, 0x00066DAA0006A5A5, 0x80004BDA000675AB, 0x00066DAE80004BDE, 0x00066DAC000651AF, 0x000635A8000665AD, 0x000681AA000639A9, 0x000681AC000681AB, 
0x000681AE000681AD, 0x80004BE20006B5AF, 0x80004BEA80004BE6, 0x80004BF280004BEE, 0x80004BFA80004BF6, 0x00069DB880004BFE, 0x0006A5BA0006ADB9, 0x000179BC000169BB, 
0x000169BE000179BD, 0x0006D1B0000169BF, 0x0006D1B20006D1B1, 0x0006B5B40006D1B3, 0x0006B5B60006BDB5, 0x000609B30006ADB7, 0x80004C0680004C02, 0x80004C0E80004C0A, 
0x000609B5000601B6, 0x000615BB80004C12, 0x80004C16000615BA, 0x000679BF80004C1A, 0x000605BD000671BE, 0x80004C1E000605BC, 0x80004C2200064DA3, 0x000645A680004AE6, 
0x80004C2A80004C26, 0x000651AA00064DA5, 0x80004C2E000651AB, 0x000635AE80004C32, 0x000641AC00063DAF, 0x0003E981000641AD, 0x000388840003DD80, 0x003CB0860003E182, 
0x000354BE00028887, 0x80004C3E80004C3A, 0x80004C4680004C42, 0x80004C4E80004C4A, 0x80004C5680004C52, 0x0006F0E380004C5A, 0x000630E180004C5E, 0x80004C62003C0084, 
0x80004C6A80004C66, 0x80004C7280004C6E, 0x80004C76003D3485, 0x0007B0EF80004C7A, 0x80004C8280004C7E, 0x80004C8A80004C86, 0x80004C9280004C8E, 0x80004C96003CC4BE, 
0x00019D8100019D82, 0x00020DA800019D80, 0x00027DAA000265A9, 0x000259AC000275AB, 0x000399AE000259AD, 0x0003E9B0000399AF, 0x0003F9B20003E9B1, 0x0003E9B40003F9B3, 
0x00035DB60003E9B5, 0x00036DB8000355B7, 0x000375BA000375B9, 0x00035DBC000345BB, 0x000331BE000335BD, 0x80004C9A000329BF, 0x80004CA280004C9E, 0x000360E180004CAA, 
0x000244E30003F4EF, 0x80004CB280004CAE, 0x0037F4EF00033CE3, 0x80004CB60001FCE1, 0x80004CBE80004CBA, 0x003F648680004CC2, 0x00213485003D6887, 0x80004CC6000399B3, 
0x0003B5B60003BDB5, 0x80004CCE80004CCA, 0x000241BA80004CD2, 0x000241BC000241BB, 0x000241BE000241BD, 0x80004CD6000241BF, 0x80004CDE80004CDA, 0x80004CE680004CE2, 
0x80004CEE80004CEA, 0x003C68840001F8EF, 0x80004CF200063CE1, 0x80004CF600061CE3, 0x80004CFE80004CFA, 0x000315A380004D02, 0x80004D0A80004D06, 0x80004D1280004D0E, 
0x000331A5000339A6, 0x0002CDAB80004D1A, 0x003E64BE0002CDAA, 0x0002CDAF80004D1E, 0x0002CDAD0002CDAE, 0x003E1DA80002CDAC, 0x003E2DAA003E25A9, 0x003E3DAC003E25AB, 
0x003E2DAE003E25AD, 0x80004CA6003E25AF, 0x003FE581003FF582, 0x80004D16003FE580, 0x0004008680004D22, 0x003E2DB800039C87, 0x003E31BA003E31B9, 0x003ED1BC003E31BB, 
0x003ED1BE003ED1BD, 0x003E5DB0003ECDBF, 0x003E39B2003E21B1, 0x003E29B4003E39B3, 0x003E19B6003E29B5, 0x003EA5B3003E15B7, 0x80004D2A80004D26, 0x80004D3280004D2E, 
0x003EB5B5003EA5B6, 0x003EE5BB80004D36, 0x80004D3A003E99BA, 0x003EEDBF80004D3E, 0x003EEDBD003EEDBE, 0x80004D42003EEDBC, 0x80004D46003EE1A3, 0x003EE1A680004D4A, 
0x80004D5280004D4E, 0x003EDDAA003EF1A5, 0x80004D56003EA1AB, 0x003EA9AE80004D5A, 0x003EA9AC003EA9AF, 0x0025058F003EA9AD, 0x80004D5E003E25B3, 0x003E29B680004D62, 
0x80004D6A80004D66, 0x003E7DBA003E29B5, 0x80004D6E003E45BB, 0x003EB5BE80004D72, 0x003E5DBC003EBDBF, 0x00387D9F003EBDBD, 0x0038F19D0039659E, 0x0035599B0034519C, 
0x0030F1990035519A, 0x0031659700310D98, 0x002D59950030C196, 0x002CE193002D4D94, 0x002959910029D992, 0x0019A5B40028F190, 0x80004D760018DDB5, 0x001591B000000884, 
0x001801B2001501B1, 0x00000D800019BDB3, 0x0003A5820003AD81, 0x000061A380004D7A, 0x003D99A1003D1DA2, 0x0005C5A4003C71A0, 0x000801A6000441A5, 0x80004C360009E1A7, 
0x0001E9A20001F5A1, 0x001001AC0005DDA3, 0x0011D9AE0011C5AD, 0x000865A8001039AF, 0x000DD9AA000C01A9, 0x002E318A000D09AB, 0x80004D7E0033A18B, 0x0033B98E80004D82, 
0x00321D8C0036118F, 0x0026258200324D8D, 0x000364BE002BA983, 0x002FA18600046084, 0x002A1984002E1587, 0x003E619A002A9185, 0x0004C886003EED9B, 0x80004D8A0003DC87, 
0x0003899C003E5CE1, 0x00366992003E00E3, 0x80004D8E00377993, 0x003B4D96003E18EF, 0x003BC194003FB997, 0x003D9DA9003A5D95, 0x003DB9AB003D89A8, 0x003DA9AD003DADAA, 
0x003DC9AF003DA1AC, 0x0004E8BE003DA1AE, 0x80004D9680004D92, 0x80004D9E80004D9A, 0x80004DA680004DA2, 0x003D59B980004DAA, 0x003D79BB003D51B8, 0x003D69BD003D65BA, 
0x003D1DBF003D61BC, 0x003D81B1003D61BE, 0x003D69B3003DB9B0, 0x003D79B5003D89B2, 0x003D69B7003D71B4, 0x003C21A3003D71B6, 0x80004DB280004DAE, 0x80004DBA80004DB6, 
0x003C2DA5003C2DA6, 0x003C41AB80004DBE, 0x80004DC2003C79AA, 0x003CB9AF80004DC6, 0x003CB9AD003CB1AE, 0x80004DCA003C59AC, 0x00037DB380004DCE, 0x0003D9B580004DD2, 
0x80004DDA80004DD6, 0x80004DDE0003D1B6, 0x0003C5BB80004DE2, 0x0003B9BD0003C5BA, 0x0003ADBF0003B5BC, 0x80004DE60003B1BE, 0x80004DEE80004DEA, 0x0000158000035CEF, 
0x0000318200001D81, 0x0004EC84003E8CEF, 0x80004DF2003EFCE1, 0x80004DFA003E1CE3, 0x80004DFE000194E1, 0x0003F5A3000020E3, 0x0004E88780004E02, 0x80004E0600046C86, 
0x000351A5000359A6, 0x00034DAB80004E0A, 0x80004E0E00034DAA, 0x000325AF80004E12, 0x000331AD000339AE, 0x80004D8600033DAC, 0x80004E1680004DF6, 0x80004E1E80004E1A, 
0x80004E2680004E22, 0x000671A880004E2A, 0x00068DAA00064DA9, 0x00069DAC000685AB, 0x00068DAE000685AD, 0x0006FDB0000685AF, 0x000741B2000741B1, 0x000741B4000741B3, 
0x000771B6000749B5, 0x000721B8000771B7, 0x000725BA000721B9, 0x000729BC000739BB, 0x00071DBE000715BD, 0x000625B30007FDBF, 0x80004E3280004E2E, 0x80004E3A80004E36, 
0x000635B5000625B6, 0x0007A5BB80004E3E, 0x80004E42000619BA, 0x0007ADBF80004E46, 0x0007B5BD0007A5BE, 0x80004E4A0007B5BC, 0x80004E4E000661A3, 0x000661A680004E52, 
0x80004E5A80004E56, 0x00065DAA000671A5, 0x80004E5E0007E1AB, 0x0007E1AE80004E62, 0x0007F1AC0007E9AF, 0x0006B1A80007F1AD, 0x0006CDAA0006BDA9, 0x0006CDAC0006DDAB, 
0x0006F5AE0006FDAD, 0x0001F980000115AF, 0x0001C5820001CD81, 0x00009086000264BE, 0x80004E6A00010087, 0x0001D1B880004E6E, 0x0001E1BA0001D9B9, 0x000191BC0001E1BB, 
0x000195BE00019DBD, 0x00016DB0000189BF, 0x00017DB2000175B1, 0x00016DB4000175B3, 0x0001F1B60001F1B5, 0x000645B30001F1B7, 0x80004E7280004E66, 0x80004E7A80004E76, 
0x000645B500067DB6, 0x0001B1BB80004E7E, 0x80004E820001A9BA, 0x000135BF80004E86, 0x0001A1BD0001A9BE, 0x80004E8A0001A9BC, 0x80004E8E000601A3, 0x000639A680004E92, 
0x80004E9A80004E96, 0x0001EDAA000601A5, 0x80004E9E0001F5AB, 0x0001EDAE80004EA2, 0x0001EDAC000171AF, 0x000128E10001E5AD, 0x000250E380004EA6, 0x80004EAE80004EAA, 
0x80004EB680004EB2, 0x80004EBE80004EBA, 0x80004EC680004EC2, 0x0000718180004ECA, 0x00029CEF00001980, 0x80004ECE00007982, 0x0002C88480004ED2, 0x80004EDA0003C5B3, 
0x0003C5B60003C5B5, 0x000CC086000310BE, 0x0003A9BA000C4487, 0x0003BDBC0003A5BB, 0x0003A1BE0003A1BD, 0x000611AE000395BF, 0x000601AC000619AF, 0x0006A5AA000601AD, 
0x003945A8000611AB, 0x80004EDE003971A9, 0x80004EE680004EE2, 0x80004EEE80004EEA, 0x80004EF680004EF2, 0x0007EDBE80004EFA, 0x0007D1BC00074DBF, 0x0007DDBA0007E5BD, 
0x000635B80007C1BB, 0x000639B60007D5B9, 0x000625B400060DB7, 0x000631B2000639B5, 0x000651B000063DB3, 0x000239A8000651B1, 0x000281AA000239A9, 0x000281AC000281AB, 
0x0002B1AE000289AD, 0x000D6C840002B1AF, 0x000D60BE80004EFE, 0x80004F0680004F02, 0x80004F0E80004F0A, 0x00014DB880004F12, 0x00015DBA000155B9, 0x00014DBC000155BB, 
0x00017DBE000175BD, 0x0002A1B0000175BF, 0x0002A5B20002ADB1, 0x0002A9B40002B9B3, 0x000295B600029DB5, 0x000654E1000179B7, 0x000638E30007D4E1, 0x80004F160007B0E3, 
0x80004F1E80004F1A, 0x000CE48480004F22, 0x80004F2A80004F26, 0x80004F3280004F2E, 0x00006CEF80004F36, 0x000249A30007E4EF, 0x80004F3E80004F3A, 0x80004F4A80004F42, 
0x000249A5000249A6, 0x000229AB80004F4E, 0x000C4886000225AA, 0x000219AF000CDC87, 0x00022DAD00022DAE, 0x000E51A8000231AC, 0x000EADAA000EA5A9, 0x000EBDAC000EA5AB, 
0x000EADAE000EA5AD, 0x000FE580000EA5AF, 0x000FE582000FED81, 0x80004F5280004F46, 0x80004F5A80004F56, 0x000FD5B880004F5E, 0x000FD5BA000FDDB9, 0x000FF9BC000FE9BB, 
0x000FE9BE000FF9BD, 0x000EDDB0000FE9BF, 0x000F45B2000F41B1, 0x000F45B4000F5DB3, 0x000F45B6000F4DB5, 0x000E25B3000FEDB7, 0x80004F6680004F62, 0x80004F6E80004F6A, 
0x000E35B5000E25B6, 0x000F85BB80004F72, 0x80004F76000E19BA, 0x000F89BF80004F7A, 0x000F89BD000F81BE, 0x80004F7E000F91BC, 0x80004F82000E61A3, 0x000E61A680004F86, 
0x80004F8E80004F8A, 0x000E5DAA000E71A5, 0x80004F92000FC1AB, 0x000FC5AE80004F96, 0x000FD5AC000FCDAF, 0x000ED1A8000FCDAD, 0x000139AA000ED9A9, 0x000129AC000139AB, 
0x00019DAE000129AD, 0x80004F9A000195AF, 0x80004FA280004F9E, 0x00000D8080004FA6, 0x0000BD820000B581, 0x000195B880004FAA, 0x0001A1BA00019DB9, 0x000071BC0001A1BB, 
0x000071BE000071BD, 0x0001EDB0000071BF, 0x0001F5B20001F5B1, 0x0001DDB40001C5B3, 0x0001B1B60001B5B5, 0x80004FAE0001B1B7, 0x0001B9B380004FB2, 0x0001A9B50002C0BE, 
0x80004FBA80004FB6, 0x000180860001A1B6, 0x000139BB0001C487, 0x000119BD000121BA, 0x000179BF000129BC, 0x0001F1A3000111BE, 0x80004ED680004FBE, 0x80004FC680004FC2, 
0x0001E1A50001E9A6, 0x000171AB80004FCA, 0x80004FCE000169AA, 0x000131AF80004FD2, 0x000151AD000159AE, 0x80004FD6000161AC, 0x80004FDE80004FDA, 0x0001A8E180004FE2, 
0x000240E380004FE6, 0x001528BF80004FEA, 0x000274EF80004FEE, 0x80004FF680004FF2, 0x80004FFE80004FFA, 0x8000500680005002, 0x00038884000F74E3, 0x8000500A000E34E1, 
0x800050128000500E, 0x00000D8080005016, 0x0000118200001581, 0x8000501E8000501A, 0x80005022000FA4EF, 0x000319A88000502A, 0x000345AA000341A9, 0x00034DAC00035DAB, 
0x000375AE00037DAD, 0x0015A48500009DAF, 0x0004088600037CBE, 0x8000502E00031C87, 0x8000503680005032, 0x0000F5B88000503A, 0x0000F5BA0000FDB9, 0x000081BC00008DBB, 
0x000081BE000081BD, 0x0000E5B0000081BF, 0x0000E5B20000EDB1, 0x0000EDB40000F9B3, 0x0000D5B60000D1B5, 0x8000503E0000CDB7, 0x8000504680005042, 0x8000504A0002C1B3, 
0x0002F1B60002C9B5, 0x800050528000504E, 0x00012DBA80005056, 0x00013DBC000125BB, 0x000125BE000121BD, 0x0002A9A6000119BF, 0x8000505A00024884, 0x8000505E000291A5, 
0x80005062000299A3, 0x00017DAE80005066, 0x000165AC000141AF, 0x000175AA000179AD, 0x8000506A00017DAB, 0x800050728000506E, 0x8000507A80005076, 0x0000E4EF8000507E, 
0x8000508680005082, 0x000E10E38000508A, 0x000E58E18000508E, 0x00002D8080005092, 0x0000158200001181, 0x000175B30005B0BE, 0x000514878000509A, 0x8000509E00046C86, 
0x000165B50000D5B6, 0x0000FDBB800050A2, 0x800050A60000F5BA, 0x0000A1BF800050AA, 0x0000DDBD0000BDBE, 0x00067DA80000DDBC, 0x0006BDAA0006B5A9, 0x0006ADAC0006B5AB, 
0x00071DAE000715AD, 0x80005096000715AF, 0x800050B2800050AE, 0x800050BA800050B6, 0x800050C2800050BE, 0x000739B8800050C6, 0x0007C9BA000739B9, 0x0007D9BC0007C9BB, 
0x0007CDBE0007D9BD, 0x000771B00007C5BF, 0x000749B2000779B1, 0x000739B4000749B3, 0x000721B6000725B5, 0x000635A3000721B7, 0x800050CE800050CA, 0x800050D6800050D2, 
0x000625A5000795A6, 0x0007BDAB800050DA, 0x800050DE0007B5AA, 0x0007E1AF800050E2, 0x00079DAD0007FDAE, 0x800050E600079DAC, 0x800050EE800050EA, 0x800050F6800050F2, 
0x00003D8100003D82, 0x800050FA00003D80, 0x80005102800050FE, 0x0003A4BE0003A084, 0x0000F88680005106, 0x0006C5A80000E087, 0x0006D5AA0006D5A9, 0x0006FDAC0006E5AB, 
0x000131AE000131AD, 0x8000510A000131AF, 0x800051128000510E, 0x8000511A80005116, 0x800051228000511E, 0x0001DDB880005126, 0x0001E5BA0001EDB9, 0x000195BC00018DBB, 
0x000195BE00019DBD, 0x000151B000018DBF, 0x000151B2000151B1, 0x0001F5B4000151B3, 0x0001F5B60001FDB5, 0x00065DB30001EDB7, 0x8000512E8000512A, 0x8000513680005132, 
0x000675B50001B1B6, 0x000195BB8000513A, 0x8000513E000195BA, 0x000139BF80005142, 0x000185BD000131BE, 0x00062DA5000185BC, 0x8000514A80005146, 0x8000514E0001E9A6, 
0x000605A380005152, 0x0001DDAD80005156, 0x000161AF0001DDAC, 0x8000515A000169AE, 0x0001CDAB80005026, 0x8000515E0001CDAA, 0x0003C48480005162, 0x8000516600F400BF, 
0x00003D8100003D82, 0x8000516A00003D80, 0x800051728000516E, 0x8000517A000360BE, 0x800051828000517E, 0x001CE08680005186, 0x00070CEF00030087, 0x8000518E8000518A, 
0x8000519680005192, 0x8000519E8000519A, 0x800051A6800051A2, 0x0006C0E1800051AA, 0x00072CE3800051AE, 0x800051B6800051B2, 0x800051BE800051BA, 0x800051C6800051C2, 
0x800051CE800051CA, 0x000381A8800051D2, 0x000381AA000381A9, 0x000381AC000381AB, 0x000381AE000381AD, 0x000345B0000381AF, 0x000345B200034DB1, 0x00034DB400035DB3, 
0x000375B600037DB5, 0x000329B8000319B7, 0x00033DBA000335B9, 0x000301BC000331BB, 0x0000FDBE0000F5BD, 0x000229B30000EDBF, 0x800051DA800051D6, 0x800051E2800051DE, 
0x000229B5000221B6, 0x0002A9BB001D5084, 0x800051EA0002A1BA, 0x000299BF800051EE, 0x0002A9BD0002A9BE, 0x00004D810002B1BC, 0x00039CEF00004D80, 0x001CF08600005D82, 
0x001D10BE001D7887, 0x800051F6800051F2, 0x800051FE800051FA, 0x000190E180005202, 0x000360E380005206, 0x8000520E8000520A, 0x8000521680005212, 0x8000521E8000521A, 
0x8000522680005222, 0x001CEC84000194EF, 0x8000522A000670E1, 0x8000522E000150E3, 0x8000523680005232, 0x0002E9A38000523A, 0x800052428000523E, 0x8000524A80005246, 
0x0002E9A50002E1A6, 0x000269AB8000524E, 0x80005252000261AA, 0x000259AF001CA8BE, 0x000269AD000269AE, 0x001E31A8000271AC, 0x001E31AA001E31A9, 0x001E5DAC001E31AB, 
0x001E4DAE001E45AD, 0x800051E6001E45AF, 0x001FF581001FCD82, 0x80005256001FFD80, 0x00001C868000525A, 0x001EC5B80003F887, 0x001EC5BA001ECDB9, 0x001EC5BC001EDDBB, 
0x001EC5BE001ECDBD, 0x001E3DB0001F59BF, 0x001E0DB2001E05B1, 0x001E1DB4001E05B3, 0x001E05B6001E01B5, 0x001EB9B3001EFDB7, 0x800052628000525E, 0x8000526A80005266, 
0x001ED5B5001EC5B6, 0x001EC1BB8000526E, 0x80005272001EF9BA, 0x001EC5BF80005276, 0x001ED1BD001ED9BE, 0x8000527A001ED9BC, 0x8000527E001EFDA3, 0x001E81A680005282, 
0x8000528A80005286, 0x001EBDAA001E91A5, 0x8000528E001E85AB, 0x001E9DAE80005292, 0x001E9DAC001E81AF, 0x001E29A8001E95AD, 0x001E55AA001E29A9, 0x001E75AC001E6DAB, 
0x001E75AE001E7DAD, 0x80005296001E69AF, 0x8000529E8000529A, 0x800052A6800052A2, 0x800052AE800052AA, 0x001EE9B8800052B2, 0x001EFDBA001EF5B9, 0x001EEDBC001EF5BB, 
0x001E91BE001E91BD, 0x001E1DB0001E91BF, 0x001EEDB2001EE5B1, 0x001EFDB4001EE5B3, 0x001EEDB6001EE5B5, 0x001EDDB3001EE5B7, 0x800052BA800052B6, 0x800052C2800052BE, 
0x001EFDB5001EFDB6, 0x001E21BB00015884, 0x000028BE001ED9BA, 0x001E21BF800052CA, 0x001E31BD001E39BE, 0x00004D81001E39BC, 0x001E95A300004D80, 0x001EB5A500005D82, 
0x800052CE800052C6, 0x80005176001EB5A6, 0x001E69AB800052D2, 0x001E79AD001E91AA, 0x001E69AF001E71AC, 0x00040086001E71AE, 0x000281B300034487, 0x000281B5800052D6, 
0x800052DE800052DA, 0x00000088000281B6, 0x0002E1BB800052E2, 0x0002E5BD0002EDBA, 0x0002D1BF0002F9BC, 0x800052E60002E5BE, 0x00034484800052EA, 0x000248E100038CBE, 
0x000200E3800052EE, 0x800052F2001FFCEF, 0x0002DCEF001E3CE1, 0x800052F6001F60E3, 0x800052FE800052FA, 0x000205A980005302, 0x000205AB0002B1A8, 0x00020DAD000205AA, 
0x000235AF000205AC, 0x00056C84000235AE, 0x8000530A80005306, 0x800053128000530E, 0x8000531A80005316, 0x0003E9B98000531E, 0x0003F9BB0003E1B8, 0x0003E9BD0003E1BA, 
0x00035DBF0003E1BC, 0x000229B10003E1BE, 0x00023DB3000225B0, 0x000219B5000221B2, 0x0003D9B700022DB4, 0x80005322000211B6, 0x8000532A80005326, 0x8000532E000385A3, 
0x000385A6000385A5, 0x8000533A80005332, 0x0003E9AA8000533E, 0x0003FDAC0003E5AB, 0x0003E1AE0003E1AD, 0x000049800003D5AF, 0x0000558200005581, 0x000498BE0002A9A3, 
0x000141A6000141A5, 0x0005E08680005342, 0x00012DAA0005E087, 0x000111AC000139AB, 0x00010DAE000105AD, 0x80005346000105AF, 0x8000534E8000534A, 0x800053520000DCEF, 
0x8000535A80005356, 0x00072C84001E88EF, 0x8000535E001EECE1, 0x80005362001E1CE3, 0x80005366000194E1, 0x000225B3000030E3, 0x8000536A00E66085, 0x800053728000536E, 
0x0001CDB50001CDB6, 0x0001B5BB80005376, 0x8000537A0001A1BA, 0x000189BF8000537E, 0x000189BD000181BE, 0x8000533600019DBC, 0x8000538680005382, 0x8000538E8000538A, 
0x8000539680005392, 0x000701A88000539A, 0x000775AA000701A9, 0x0007B5AC0007ADAB, 0x0007A9AE0007BDAD, 0x0007D9B00007A9AF, 0x0007F9B20007EDB1, 0x000799B40007F5B3, 
0x000789B6000799B5, 0x000789B8000781B7, 0x00006DBA000789B9, 0x00007DBC000065BB, 0x00006DBE000065BD, 0x00000981000065BF, 0x8000539E00009980, 0x800053A200001D82, 
0x800053AA800053A6, 0x00050DA8800053AE, 0x00054DAA00057DA9, 0x0006A5AC0006A1AB, 0x00069DAE0006ADAD, 0x000685B00006FDAF, 0x0006A9B2000691B1, 0x0006A5B40006BDB3, 
0x0006A5B60006ADB5, 0x000649B8000679B7, 0x000659BA000649B9, 0x000649BC000659BB, 0x0007F9BE000649BD, 0x00065DB30007F9BF, 0x00022886800053B2, 0x800053B600012C87, 
0x00069DB500069DB6, 0x000689BB800053BA, 0x800053BE0006BDBA, 0x0006FDBF800053C2, 0x000681BD0006FDBE, 0x800053C600068DBC, 0x800053CA000619A3, 0x0006D9A6800053CE, 
0x800053D6800053D2, 0x0006F9AA0006D9A5, 0x800053DA0006CDAB, 0x0006B9AE800053DE, 0x0006C9AC0006B9AF, 0x000119A80006C5AD, 0x00008DAA000119A9, 0x00008DAC00009DAB, 
0x0000B5AE0000BDAD, 0x800053E20000DDAF, 0x800053EA800053E6, 0x800053F2800053EE, 0x800053FA800053F6, 0x000069B8800053FE, 0x000079BA000069B9, 0x000069BC000079BB, 
0x0003DDBE000069BD, 0x0000A9B00003D5BF, 0x0000BDB20000A9B1, 0x000099B40000B5B3, 0x000059B6000099B5, 0x00022CBE000059B7, 0x8000540680005402, 0x8000540E8000540A, 
0x8000541A80005412, 0x00002D808000541E, 0x00003D8200003581, 0x000C908680005422, 0x800054260002E887, 0x000345B38000542A, 0x800054328000542E, 0x8000543A80005436, 
0x000345B500037DB6, 0x00032DBB8000543E, 0x8000544200032DBA, 0x00031DBF80005446, 0x000321BD00031DBE, 0x0003CDAB000329BC, 0x8000544A0003CDAA, 0x0003FDAF8000544E, 
0x0003C1AD0003FDAE, 0x0003A5A30003C9AC, 0x8000545680005452, 0x8000545E8000545A, 0x0003A5A500039DA6, 0x8000546680005462, 0x8000546E8000546A, 0x8000547680005472, 
0x00003D8100003D82, 0x8000547A00003D80, 0x800054828000547E, 0x000CD08600036084, 0x8000548A00033087, 0x000244BE8000548E, 0x8000549680005492, 0x000000E18000549A, 
0x0006A8E38000549E, 0x000CEC84800054A2, 0x0003D0EF800054A6, 0x800054AE800054AA, 0x800054B6800054B2, 0x00016DB3800054BA, 0x800054C2800054BE, 0x800054CA800054C6, 
0x000165B5000111B6, 0x00013DBB800054CE, 0x800054D2000135BA, 0x0001FDBF800054D6, 0x000115BD0001FDBE, 0x800054DA000115BC, 0x800054DE0006FCE1, 0x800054E200073CE3, 
0x800054EA800054E6, 0x800054F2800054EE, 0x800054FA000C6CBE, 0x80005502800054FE, 0x8000550A80005506, 0x00005D81000614EF, 0x0001E5A300005D80, 0x0001EDA500006D82, 
0x800055128000550E, 0x000CA887000199A6, 0x0001B5AB000CE486, 0x00019DAD0001BDAA, 0x000175AF00019DAC, 0x000E19A8000175AE, 0x000E25AA000E19A9, 0x000E2DAC000E35AB, 
0x000E51AE000E51AD, 0x80005486000E51AF, 0x80005516800054F6, 0x8000551E8000551A, 0x8000552680005522, 0x000EEDB88000552A, 0x000EF5BA000EF5B9, 0x000E95BC000E8DBB, 
0x000E95BE000E9DBD, 0x000E31B0000E8DBF, 0x000E01B2000E39B1, 0x000EF9B4000E01B3, 0x000EDDB6000EF9B5, 0x000E79A8000ED5B7, 0x000F8DAA000E79A9, 0x000F9DAC000F85AB, 
0x000F85AE000F81AD, 0x8000552E000FB9AF, 0x8000553680005532, 0x8000553E8000553A, 0x8000554680005542, 0x000F91B88000554A, 0x000FA1BA000F99B9, 0x000F51BC000FA1BB, 
0x000F49BE000F5DBD, 0x000FCDB0000F49BF, 0x000FDDB2000FD5B1, 0x000FCDB4000FD5B3, 0x000FB1B6000FB1B5, 0x000E05B3000FB1B7, 0x800055528000554E, 0x8000555A80005556, 
0x000E15B5000E01B6, 0x000E11BB8000555E, 0x80005562000E09BA, 0x000E75BF0001A084, 0x000E01BD000E09BE, 0x00006982000E09BC, 0x00005980000E41A3, 0x000E45A600005181, 
0x80005566000158BE, 0x000E4DAA000E51A5, 0x0000C886000E55AB, 0x000E4DAE0001AC87, 0x000E4DAC000E31AF, 0x8000556A000E45AD, 0x800055728000556E, 0x8000557A80005576, 
0x800054168000557E, 0x000E09A880005582, 0x000E19AA000E09A9, 0x000E09AC000E19AB, 0x000E61AE000E61AD, 0x0001EDB0000195AF, 0x0001FDB20001F5B1, 0x0001EDB40001F5B3, 
0x00017DB6000175B5, 0x00014DB8000175B7, 0x00015DBA000155B9, 0x00014DBC000155BB, 0x0000F1BE0000F1BD, 0x800055860000F1BF, 0x8000558E8000558A, 0x8000559680005592, 
0x8000559A000EE8E3, 0x000400BE000E34E1, 0x8000559E000FDCEF, 0x800055A6800055A2, 0x800055AE800055AA, 0x000DF1B3800055B2, 0x800055BA800055B6, 0x800055C2800055BE, 
0x000DE1B5000D81B6, 0x000251BB800055C6, 0x800055CA000249BA, 0x0002D1BF800055CE, 0x000241BD000249BE, 0x000D31A3000249BC, 0x00038884800055D2, 0x800055DE800055DA, 
0x000D21A5000D41A6, 0x000291AB800055E2, 0x800055E6000289AA, 0x000211AF800055EA, 0x000281AD000289AE, 0x0000A980000289AC, 0x00004D820000A981, 0x001264E1800055EE, 
0x000B08E300024CE3, 0x800055F20001ACE1, 0x001618EF00023CEF, 0x00065086800055F6, 0x800055FA00034887, 0x000281A8800055FE, 0x000281AA000281A9, 0x000281AC000281AB, 
0x000285AE000281AD, 0x8000560200011DAF, 0x8000560A80005606, 0x800056128000560E, 0x8000561A80005616, 0x000175B80005B884, 0x000175BA00017DB9, 0x000119BC000109BB, 
0x000109BE000119BD, 0x000165B0000101BF, 0x000165B200016DB1, 0x000169B400017DB3, 0x000155B600015DB5, 0x8000561E00014DB7, 0x8000562680005622, 0x8000562E8000562A, 
0x000034EF80005632, 0x000E5CE1000EC0EF, 0x000094E3000F4CE1, 0x80005636000E9CE3, 0x00007D8100006582, 0x8000563A00007D80, 0x0007C4BE8000563E, 0x80005642000245B3, 
0x00024DB6000245B5, 0x000640868000564A, 0x0001EDBA00049087, 0x0001FDBC0001E5BB, 0x0001E1BE0001E5BD, 0x0008959F0001D5BF, 0x000DDD9D0008059E, 0x000C319B000C3D9C, 
0x0010ED99000DF59A, 0x0011D59700103D98, 0x001405950015B196, 0x0019B5930015E594, 0x0018399100183192, 0x001C618F001C0D90, 0x0006D5B3800055D6, 0x0006FDB58000564E, 
0x8000565280005646, 0x80005656000691B6, 0x000695BB8000565A, 0x000755BD000695BA, 0x000755BF000755BC, 0x8000565E000755BE, 0x00068DAA80005662, 0x00069DAC000685AB, 
0x000681AE000685AD, 0x0000A8840006B5AF, 0x8000566A80005666, 0x8000566E000525A3, 0x00052DA6000525A5, 0x8000567680005672, 0x8000567E8000567A, 0x8000568680005682, 
0x8000568E8000568A, 0x8000569680005692, 0x8000569E8000569A, 0x0005A9A3800056A2, 0x0004D9A10004D1A2, 0x001D2182000565A0, 0x800056A6001D3583, 0x00189586800056AA, 
0x001919840014DD87, 0x00150D8A00191985, 0x800056AE0014B18B, 0x0011C58E800056B2, 0x0010CD8C000CD58F, 0x000D619200111D8D, 0x00004CBE000D7593, 0x0009C596800056BA, 
0x000C8D940004CD97, 0x0005419A00095D95, 0x00FFC8860005419B, 0x0000598100004C87, 0x0004219C00007980, 0x0001C5A100005182, 0x00FC01A3800056BE, 0x00FD15A50001D9A2, 
0x00F9B9A700FDB5A4, 0x00F809A900F801A6, 0x00F505AB00F995A8, 0x00F1B1AD00F5ADAA, 0x00F01DAF00F001AC, 0x00EDE1B100F1ADAE, 0x00E801B300EC01B0, 0x00E95DB500ECFDB2, 
0x800056C200E9F5B4, 0x800056CA800056C6, 0x800056D2800056CE, 0x800056DA800056D6, 0x800056E2800056DE, 0x00048DA8800056E6, 0x000495AA000495A9, 0x0004BDAC0004A5AB, 
0x0004F9AE0004D9AD, 0x00FC6C840004F1AF, 0x800056EE800056EA, 0x800056F6800056F2, 0x800056FE800056FA, 0x000579B880005702, 0x0005CDBA0005C5B9, 0x0005DDBC0005C5BB, 
0x0005CDBE0005C5BD, 0x000499B00005EDBF, 0x000549B2000499B1, 0x000559B4000549B3, 0x000549B6000559B5, 0x00041DA3000549B7, 0x8000570600FCCCBE, 0x8000570E8000570A, 
0x000435A5000459A6, 0x00045DAB80005712, 0x8000571600045DAA, 0x00059DAF8000571A, 0x00059DAD00059DAE, 0x8000571E00059DAC, 0x8000572200029DB3, 0x000251B68000572A, 
0x800057328000572E, 0x000249BA0002B9B5, 0x00FD4886000255BB, 0x000235BE00FCC087, 0x000245BC00023DBF, 0x0004DDA800023DBD, 0x000351AA000349A9, 0x000375AC00036DAB, 
0x00039DAE000395AD, 0x00018D800003B9AF, 0x0001E1820001E581, 0x8000573A80005736, 0x800057428000573E, 0x000395B880005746, 0x000395BA00039DB9, 0x0003B5BC0003ADBB, 
0x0003B5BE0003BDBD, 0x0003C9B0000255BF, 0x0003D5B20003D5B1, 0x0003B5B40003ADB3, 0x0003B5B60003BDB5, 0x8000574A0003ADB7, 0x0003D1A38000574E, 0x0003F5A580005752, 
0x8000575A80005756, 0x8000575E00031DA6, 0x000319AB80005762, 0x000371AD000305AA, 0x000371AF000309AC, 0x000728E1000379AE, 0x0006E4E380005766, 0x000628E18000576A, 
0x000168E38000576E, 0x8000577680005772, 0x000058EF8000577A, 0x800057828000577E, 0x0006C8EF80005786, 0x00FD4DA88000578A, 0x00FDD1AA00FD81A9, 0x00FDF1AC00FDD1AB, 
0x00FDF1AE00FDF1AD, 0x8000572600FDF1AF, 0x0000198100001182, 0x8000578E00FFD180, 0x0003748480005792, 0x00FE75B8000374BE, 0x00FE75BA00FE7DB9, 0x00FEDDBC00FEC5BB, 
0x00FEC5BE00FEC5BD, 0x00FD91B000FEF5BF, 0x00FD91B200FD91B1, 0x00FE55B400FD91B3, 0x00FE55B600FE5DB5, 0x00FD59B300FE4DB7, 0x0000AC8680005796, 0x8000579A00034487, 
0x00FD79B500FD71B6, 0x00FD55BB8000579E, 0x800057A200FD55BA, 0x00FE99BF800057A6, 0x00FD45BD00FE91BE, 0x800057AA00FD45BC, 0x800057AE00FD1DA3, 0x00FD35A6800057B2, 
0x800057BA800057B6, 0x00FD11AA00FD3DA5, 0x800057BE00FD11AB, 0x00FED5AE800057C2, 0x00FD01AC00FEDDAF, 0x00FFCDA800FD01AD, 0x00FFD1AA00FFD1A9, 0x00FE21AC00FE21AB, 
0x00FE21AE00FE21AD, 0x800057C600FE21AF, 0x800057CE800057CA, 0x800057D6800057D2, 0x800057DE800057DA, 0x00FE8DB8800057E2, 0x00FE95BA00FE91B9, 0x00FEB5BC00FEADBB, 
0x00FEA9BE00FEB9BD, 0x00FEE1B000FEA9BF, 0x00FEE5B200FEE1B1, 0x00FEE9B400FEF9B3, 0x00FEDDB600FED5B5, 0x00FF59B300FEB9B7, 0x800056B6800057E6, 0x800057EE800057EA, 
0x00FEA9B500FEA1B6, 0x00FE25BB800057F2, 0x800057F600FE25BA, 0x00FE11BF800057FA, 0x00FE2DBD00FE2DBE, 0x0000198200FE31BC, 0x0000658000FF1DA3, 0x00FEE5A600001981, 
0x80005802800057FE, 0x00FE61AA00FEEDA5, 0x0001648400FE61AB, 0x00FE69AE000020BE, 0x00FE75AC00FE55AF, 0x8000580A00FE69AD, 0x8000580E00FE34E3, 0x0004B08600FD7CE1, 
0x8000581200030887, 0x8000581A80005816, 0x000324848000581E, 0x8000582200042484, 0x8000582600FE48EF, 0x0002E9B38000582A, 0x000444BE8000582E, 0x80005832000540BE, 
0x000299B500029DB6, 0x000289BB80005836, 0x8000583A0002BDBA, 0x000359BF8000583E, 0x000359BD000351BE, 0x00021DA9000291BC, 0x000225AB000215A8, 0x000259AD000225AA, 
0x00024DAF000255AC, 0x000664BE000251AE, 0x8000584680005842, 0x8000584E8000584A, 0x8000585680005852, 0x0003F9B98000585A, 0x00034DBB0003F1B8, 0x000341BD0003F1BA, 
0x000371BF000359BC, 0x000209B1000341BE, 0x0003C9B300023DB0, 0x0003D9B5000201B2, 0x0003C9B70003D1B4, 0x000190E10003D1B6, 0x0000F0E38000585E, 0x8000586680005862, 
0x00003D8100003D82, 0x8000586A00003D80, 0x800058728000586E, 0x8000587E8000587A, 0x00002CEF80005882, 0x0003E9A380005886, 0x0004E8868000588A, 0x8000588E00056087, 
0x000399A500039DA6, 0x000389AB80005892, 0x800058960003BDAA, 0x000259AF8000589A, 0x000259AD000251AE, 0x8000589E000391AC, 0x800058A6800058A2, 0x800058AE800058AA, 
0x800058B6800058B2, 0x0004A084000158EF, 0x800058BA00FF54E1, 0x800058BE000184E3, 0x800058C6800058C2, 0x0001D9B3800058CA, 0x0019CC85800058CE, 0x800058D6800058D2, 
0x0001F9B50001F1B6, 0x0001A5BB800058DA, 0x800058DE0001D9BA, 0x00019DBF800058E2, 0x0001A5BD00019DBE, 0x000601A80001ADBC, 0x000611AA00060DA9, 0x000631AC000611AB, 
0x000629AE000631AD, 0x80005876000625AF, 0x0007C1810007C982, 0x800058E60007F180, 0x00001C86800058EA, 0x0006EDB80003FC87, 0x0006FDBA0006F5B9, 0x0006EDBC0006F5BB, 
0x000755BE000751BD, 0x00065DB000074DBF, 0x000639B2000621B1, 0x000619B4000631B3, 0x0006DDB6000619B5, 0x000699A30006D5B7, 0x800058F2800058EE, 0x800058FA800058F6, 
0x0006B9A50006B1A6, 0x0006E5AB800058FE, 0x80005902000699AA, 0x0006DDAF80005906, 0x0006E5AD0006DDAE, 0x8000590A0006EDAC, 0x8000590E0007F1B3, 0x000781B680005912, 
0x8000591A80005916, 0x00078DBA000799B5, 0x8000591E000765BB, 0x00077DBE80005922, 0x00077DBC000765BF, 0x00062DA8000775BD, 0x00063DAA000635A9, 0x000655AC000631AB, 
0x000645AE000645AD, 0x80005926000675AF, 0x8000592E8000592A, 0x8000593680005932, 0x8000593E8000593A, 0x0006E9B880005942, 0x0006FDBA0006F5B9, 0x0006EDBC0006F5BB, 
0x000695BE000691BD, 0x00060DB000068DBF, 0x0006EDB20006E5B1, 0x0006FDB40006E5B3, 0x0006EDB60006E5B5, 0x0006B5A30006E5B7, 0x8000594A80005946, 0x800059528000594E, 
0x0006DDA50006C5A6, 0x000621AB80005806, 0x800059560006C9AA, 0x000621AF8000595A, 0x000631AD000639AE, 0x00004980000639AC, 0x0000598200004981, 0x8000595E000145B3, 
0x000145B6000145B5, 0x0000408680005962, 0x000129BA00006487, 0x00013DBC000125BB, 0x000121BE000121BD, 0x80005966000115BF, 0x000304848000596A, 0x000628E3000C00BE, 
0x000610E10002E0EF, 0x000690EF8000596E, 0x8000597200023CE3, 0x800059760001D4E1, 0x8000597E8000597A, 0x8000598680005982, 0x0002C1A38000598A, 0x0002C1A58000598E, 
0x8000599680005992, 0x8000599A0002C1A6, 0x0002A1AB8000599E, 0x0002A5AD0002ADAA, 0x000291AF0002B9AC, 0x000205A90002A5AE, 0x000205AB0002B1A8, 0x00020DAD000205AA, 
0x000235AF000205AC, 0x000CA884000235AE, 0x800059A6800059A2, 0x800059AE800059AA, 0x800059B6800059B2, 0x0003E9B9800059BA, 0x0003F9BB0003E1B8, 0x0003E9BD0003E1BA, 
0x00035DBF0003E1BC, 0x000229B10003E1BE, 0x00023DB3000225B0, 0x000219B5000221B2, 0x0003D9B700022DB4, 0x0002ADA8000211B6, 0x0002D5AA0002D5A9, 0x000115AC00010DAB, 
0x000131AE000109AD, 0x800059BE00012DAF, 0x800059CA800059C2, 0x800059D2800059CE, 0x800059DA800059D6, 0x000121B8800059DE, 0x0001EDBA000121B9, 0x0001FDBC0001E5BB, 
0x0001EDBE0001E5BD, 0x000155B00001E5BF, 0x000155B200015DB1, 0x000135B400012DB3, 0x00012DB6000139B5, 0x00013D80000125B7, 0x0000AD820000A581, 0x800059E20007D4EF, 
0x800059EA800059E6, 0x000C2CBE000728EF, 0x800059EE0006F4E1, 0x800059F2000790E3, 0x800059F6000194E1, 0x00021DB300060CE3, 0x000D4487800059FA, 0x800059FE000D4C86, 
0x0001DDB50001C9B6, 0x0001D9BB80005A02, 0x80005A060001D1BA, 0x0001BDBF80005A0A, 0x0001B9BD0001B1BE, 0x800059C60001C1BC, 0x80005A1280005A0E, 0x80005A1A80005A16, 
0x80005A2280005A1E, 0x000F09A880005A26, 0x000F19AA000F09A9, 0x000F09AC000F19AB, 0x000FA9AE000F09AD, 0x000FD9B0000FA9AF, 0x000FF9B2000FEDB1, 0x000F95B4000FF5B3, 
0x000F85B6000F85B5, 0x000F8DB8000FB5B7, 0x000061BA000061B9, 0x000061BC000061BB, 0x000061BE000061BD, 0x000D5DA3000061BF, 0x0000158100002D82, 0x80005A2A00001D80, 
0x000E9DA5000E89A6, 0x000E99AB80005A2E, 0x80005A32000E91AA, 0x000EFDAF80005A36, 0x000EF9AD000EF1AE, 0x80005A3A000E81AC, 0x0003E886000FF5B3, 0x000FEDB60003BC87, 
0x80005A4280005A3E, 0x000F79BA000FE5B5, 0x80005A46000F4DBB, 0x000F35BE80005A4A, 0x000F49BC000F25BF, 0x000E31A3000F45BD, 0x80005A5280005A4E, 0x80005A5A80005A56, 
0x000E21A5000E29A6, 0x000E89AB80005A5E, 0x80005A62000EBDAA, 0x000EE1AF80005A66, 0x000E81AD000EF1AE, 0x80005A6A000E8DAC, 0x80005A7280005A6E, 0x80005A7A80005A76, 
0x80005A8280005A7E, 0x80005A8A80005A86, 0x80005A9280005A8E, 0x00000D8080005A96, 0x0000DD820000D581, 0x000141A880005A9A, 0x000151AA000151A9, 0x00017DAC000165AB, 
0x000091AE000091AD, 0x80005A9E000091AF, 0x0001648480005AA2, 0x00019086000164BE, 0x80005AAA00008487, 0x000091B880005AAE, 0x000091BA000091B9, 0x0000B1BC000091BB, 
0x0000B1BE0000B1BD, 0x0000F1B00000B1BF, 0x0000C1B20000F9B1, 0x0000B1B40000C1B3, 0x0000B1B60000B1B5, 0x0002D9B30000B1B7, 0x000370BE80005AB2, 0x80005AB6000444BE, 
0x0002F5B5000311B6, 0x00033DBB80005ABA, 0x80005ABE000335BA, 0x000375BF80005AC2, 0x000315BD000375BE, 0x80005AC6000315BC, 0x80005ACA00029DA3, 0x000355A680005ACE, 
0x80005AD680005AD2, 0x000371AA0002B1A5, 0x80005ADA000379AB, 0x000331AE80005ADE, 0x000351AC000331AF, 0x000339A8000351AD, 0x00008DAA000339A9, 0x00008DAC00009DAB, 
0x0000B5AE0000BDAD, 0x80005AE20000DDAF, 0x80005AEA80005AE6, 0x80005AF280005AEE, 0x80005AFA80005AF6, 0x000069B880005AFE, 0x000079BA000069B9, 0x000069BC000079BB, 
0x0001D9BE000069BD, 0x0000A9B00001D9BF, 0x0000BDB20000A9B1, 0x000099B40000B5B3, 0x000059B6000099B5, 0x80005B02000059B7, 0x80005B0A80005B06, 0x000044EF80005B0E, 
0x0005988680005B12, 0x000098E30002E487, 0x0001F8E10002A884, 0x0000398080005B1A, 0x00002D8200003981, 0x000145B380005B1E, 0x80005B2680005B22, 0x80005B2E80005B2A, 
0x000145B500017DB6, 0x00012DBB80005B32, 0x80005B3600012DBA, 0x00011DBF80005B3A, 0x000121BD00011DBE, 0x80005B3E000129BC, 0x80005B42000E50E1, 0x80005B46000F3CE3, 
0x80005B4E80005B4A, 0x80005B5680005B52, 0x000000E380005B5A, 0x80005B6280005B5E, 0x0005F48480005B66, 0x0001A9AE000EE4EF, 0x00019DAC0001A9AF, 0x000199AA000195AD, 
0x80005B6A000199AB, 0x0001C9A680005B6E, 0x80005B7680005B72, 0x0007FD820001F1A5, 0x0007FD800001F1A3, 0x80005B160007F581, 0x80005B7E80005B7A, 0x80005B8680005B82, 
0x0003B88680005B8A, 0x00070DA800039087, 0x00076DAA000719A9, 0x00077DAC000765AB, 0x000765AE000765AD, 0x00072DB0000755AF, 0x0007C1B20007C5B1, 0x0007C5B40007DDB3, 
0x0007C5B60007CDB5, 0x0007C5B80007FDB7, 0x0007D9BA0007C9B9, 0x0007A9BC0007D9BB, 0x00079DBE0007A9BD, 0x0007C5B3000795BF, 0x80005B9280005B8E, 0x80005B9A80005B96, 
0x0007D5B50007C5B6, 0x000721BB80005B9E, 0x80005BA20007C9BA, 0x000729BF80005BA6, 0x000729BD000721BE, 0x80005BAA000735BC, 0x80005BAE000781A3, 0x000781A680005BB2, 
0x80005BBA80005BB6, 0x00078DAA000791A5, 0x80005BBE000765AB, 0x000765AE80005BC2, 0x000771AC00076DAF, 0x000115A800076DAD, 0x000181AA000181A9, 0x000181AC000181AB, 
0x0001B1AE000189AD, 0x80005BC60001B1AF, 0x80005BCE80005BCA, 0x80005BD680005BD2, 0x80005BDE80005BDA, 0x000065B880005BE2, 0x000065BA00006DB9, 0x000065BC00007DBB, 
0x000065BE00006DBD, 0x0001A1B00000DDBF, 0x0001A5B20001ADB1, 0x0001A9B40001B9B3, 0x000195B600019DB5, 0x80005BE600005DB7, 0x00001D8100001D82, 0x80005BEA00001D80, 
0x80005BF280005BEE, 0x0002AC84000158BE, 0x0001088780005BF6, 0x80005BFA00018C86, 0x80005BFE80005AA6, 0x000149B380005C02, 0x80005C0A80005C06, 0x80005C1280005C0E, 
0x000149B5000149B6, 0x000129BB80005C16, 0x80005C1A000125BA, 0x000119BF80005C1E, 0x00012DBD00012DBE, 0x0003D8BE000131BC, 0x0006F8EF80005C22, 0x80005C2A80005C26, 
0x0002E0EF80005C2E, 0x000194E180005C32, 0x000274E380005C36, 0x000598E180005C3A, 0x00070CE380005C3E, 0x80005C4680005C42, 0x0002C1A380005C4A, 0x0002C1A500038C84, 
0x80005C5280005C4E, 0x80005C560002C1A6, 0x0002A1AB80005C5A, 0x0002A5AD0002ADAA, 0x000291AF0002B9AC, 0x000331A80002A5AE, 0x000335AA00033DA9, 0x000359AC000349AB, 
0x000349AE000359AD, 0x0000C580000341AF, 0x0000198200000981, 0x80005C6280005C5E, 0x00036C8780005C6A, 0x0000EDB8001C1C86, 0x0000F5BA0000F1B9, 0x000095BC00008DBB, 
0x000081BE000081BD, 0x000309B00000BDBF, 0x0000EDB2000309B1, 0x0000E1B40000E1B3, 0x0000E5B60000E1B5, 0x80005C6E0000D9B7, 0x80005C7680005C72, 0x80005C7A0002B1B3, 
0x0002D5B60002DDB5, 0x80005C8280005C7E, 0x0002C1BA80005C86, 0x000135BC0002C1BB, 0x000129BE000139BD, 0x00028DA6000129BF, 0x80005C8E80005C8A, 0x80005C92000285A5, 
0x80005C960002E9A3, 0x000171AE80005C9A, 0x00016DAC000171AF, 0x000299AA000161AD, 0x80005C9E000299AB, 0x80005CA680005CA2, 0x80005CAA000684E1, 0x80005CAE000624E3, 
0x80005CB2000194E1, 0x001DE8BE00002CE3, 0x80005CBA80005CB6, 0x001DFC840000C8EF, 0x80005CBE001CF0BE, 0x80005CC2000748EF, 0x80005CCA80005CC6, 0x00001D8180005CCE, 
0x80005CD200001D80, 0x001C408600000582, 0x80005CDA001CC487, 0x80005CE280005CDE, 0x80005CEA80005CE6, 0x001EB5A880005CEE, 0x001F0DAA001F05A9, 0x001F01AC001F05AB, 
0x001F39AE001F09AD, 0x80005CD6001F39AF, 0x80005CF680005CF2, 0x80005CFE80005CFA, 0x80005D0680005D02, 0x001FC9B880005D0A, 0x001FD1BA001FD5B9, 0x001FF9BC001FE9BB, 
0x001F99BE001FEDBD, 0x001F25B0001F99BF, 0x001F39B2001F2DB1, 0x001F2DB4001F35B3, 0x001F05B6001F0DB5, 0x001F85B3001FFDB7, 0x80005D1280005D0E, 0x80005D1A80005D16, 
0x001F89B5001F89B6, 0x001FE9BB80005D1E, 0x80005D22001FE1BA, 0x001FC9BF80005D26, 0x001FE1BD001FE9BE, 0x80005D2A001FEDBC, 0x80005D2E001FC1A3, 0x001FCDA680005D32, 
0x80005D3A80005D36, 0x001FA5AA001FCDA5, 0x80005D3E001FADAB, 0x001FADAE80005D42, 0x001FA9AC001F8DAF, 0x001EE9A8001FA5AD, 0x001EF9AA001EE9A9, 0x001EE9AC001EF9AB, 
0x00013DAE001EE9AD, 0x0001F980000135AF, 0x0001C5820001CD81, 0x80005D4600026084, 0x0001688780005D4A, 0x0001D1B800009C86, 0x0001E1BA0001D9B9, 0x000191BC0001E1BB, 
0x000195BE00019DBD, 0x00014DB0000189BF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x0001F1B60001F1B5, 0x001E71B30001F1B7, 0x80005D5280005D4E, 0x80005D5A80005D56, 
0x001E61B5001E69B6, 0x000191BB80005D5E, 0x80005D62000189BA, 0x000135BF80005D66, 0x000181BD000189BE, 0x80005D6A000189BC, 0x001E39A380005C66, 0x001E29A580005D6E, 
0x80005D7680005D72, 0x80005D7A001E21A6, 0x0001D9AB80005D7E, 0x0001C9AD0001C1AA, 0x00017DAF0001C1AC, 0x80005D820001C1AE, 0x80005D8A80005D86, 0x80005D9280005D8E, 
0x80005D9A80005D96, 0x80005DA280005D9E, 0x80005DAA80005DA6, 0x80005DB280005DAE, 0x80005DBE80005DBA, 0x001EE4E1000370BE, 0x001FE8E300024884, 0x0000798000040084, 
0x0000698200007981, 0x0004C08680005DC2, 0x80005DC600034487, 0x80005DCE80005DCA, 0x001F20EF80005DD2, 0x80005DDA80005DD6, 0x80005DE280005DDE, 0x80005DE6000248EF, 
0x80005DEE80005DEA, 0x0004E8BE80005DF2, 0x80005DFA80005DF6, 0x80005E0280005DFE, 0x80005E06000190E1, 0x000349B30002E8E3, 0x80005E0E80005E0A, 0x80005E1680005E12, 
0x000349B5000349B6, 0x00032DBB80005E1A, 0x80005E1E000325BA, 0x000315BF80005E22, 0x000321BD000315BE, 0x000235A8000329BC, 0x000281AA000281A9, 0x000281AC000281AB, 
0x0002B1AE000289AD, 0x0001FD800002B1AF, 0x0001C5820001CD81, 0x0004908680005E2A, 0x80005E2E00050487, 0x000149B800047084, 0x000159BA000149B9, 0x000149BC000159BB, 
0x000179BE000149BD, 0x0002A1B0000179BF, 0x0002BDB20002A9B1, 0x000291B40002B5B3, 0x000179B6000291B5, 0x80005E32000179B7, 0x80005E3A80005E36, 0x80005E4280005E3E, 
0x80005E4A80005E46, 0x0004E8BE001ED0EF, 0x80005E4E001E5CE1, 0x80005E52000090E3, 0x80005E5A80005E56, 0x000249A380005E5E, 0x80005E6680005E62, 0x80005E6E80005E6A, 
0x000249A5000249A6, 0x00022DAB80005E72, 0x80005E76000225AA, 0x000215AF80005E7A, 0x000221AD000215AE, 0x000635A8000229AC, 0x000655AA00063DA9, 0x00067DAC000665AB, 
0x00066DAE000665AD, 0x80005E26000661AF, 0x80005E8280005E7E, 0x00000D8080005E86, 0x0000B1820000B181, 0x0006E9B880005E8A, 0x0006F9BA0006E9B9, 0x000695BC0006F5BB, 
0x000695BE00069DBD, 0x0006E1B000068DBF, 0x0006E1B20006E1B1, 0x0006E5B40006FDB3, 0x0006E5B60006EDB5, 0x0006DDB30006D9B7, 0x80005E9280005E8E, 0x80005E9A80005E96, 
0x0006F5B50006E5B6, 0x000625BB80005E9E, 0x00009886000625BA, 0x000629BF0000AC87, 0x000629BD000621BE, 0x80005EA2000635BC, 0x80005EA6000699A3, 0x0006A1A680005EAA, 
0x80005EB280005EAE, 0x000661AA0006B1A5, 0x80005EB6000661AB, 0x000665AE80005EBA, 0x000671AC00066DAF, 0x00062DA800066DAD, 0x000689AA00063DA9, 0x000699AC000689AB, 
0x000689AE000699AD, 0x80005EBE000689AF, 0x80005EC680005EC2, 0x80005ECE80005ECA, 0x80005ED680005ED2, 0x00068DB880005EDA, 0x000695BA000695B9, 0x0006BDBC0006A5BB, 
0x000171BE000171BD, 0x0006F9B0000171BF, 0x0006D9B20006CDB1, 0x0006C9B40006D9B3, 0x0006BDB60006C9B5, 0x000601B30006B5B7, 0x80005EE280005EDE, 0x80005EEA80005EE6, 
0x000611B5000619B6, 0x000609BB80005EEE, 0x80005EF200063DBA, 0x00060DBF80005EF6, 0x00060DBD00060DBE, 0x80005EFA00060DBC, 0x80005DB6000645A3, 0x00065DA680005EFE, 
0x0000588480005F02, 0x000679AA000655A5, 0x000168BE00064DAB, 0x000649AE80005F06, 0x000649AC000649AF, 0x0003C180000649AD, 0x0003DD820003C981, 0x80005F0A0002CDA3, 
0x0002CDA60002D9A5, 0x000D808680005F0E, 0x0002C5AA00039487, 0x000315AC00030DAB, 0x000315AE00031DAD, 0x00179CE100030DAF, 0x000314E3000618E3, 0x000218EF000634E1, 
0x80005F1680005F12, 0x0002D0E380005F1A, 0x000250E180005F1E, 0x80005F2680005F22, 0x0025E4EF00062CEF, 0x00024DAC80005F2A, 0x000251AE000251AD, 0x000201A8000265AF, 
0x000259AA000209A9, 0x000DEC84000255AB, 0x80005F3280005F2E, 0x000DF8BE80005F36, 0x80005F3E80005F3A, 0x000351BC80005F42, 0x000361BE000359BD, 0x0003EDB8000361BF, 
0x000351BA000351B9, 0x0003CDB4000351BB, 0x0003DDB60003D5B5, 0x00021DB00003D5B7, 0x0003DDB20003D5B1, 0x0000C8E30003D5B3, 0x0001B8E180005F46, 0x000F548480005F4A, 
0x80005F5280005F4E, 0x0002E9A180005F56, 0x0003A5A3000615A0, 0x000020EF00030DA2, 0x80005F5E80005F5A, 0x80005F6680005F62, 0x0026348580005F6A, 0x80005F6E00038DB3, 
0x00038DB6000399B5, 0x000FC08680005F72, 0x000385BA000D9487, 0x000255BC00024DBB, 0x000255BE00025DBD, 0x80005F7A00024DBF, 0x80005F8280005F7E, 0x80005F8A80005F86, 
0x00EBDD8F80005F8E, 0x000FE0BE0006C4EF, 0x80005F9200068CE1, 0x0000F580000680E3, 0x0000E5820000E581, 0x001F6D9980005F96, 0x001BC99B001FC598, 0x001A759D001A799A, 
0x0007F99F001BC59C, 0x001669910006199E, 0x00176D9300EBB190, 0x0013D1950017CD92, 0x0012519700126994, 0x00E455830013CD96, 0x80005F7600E44182, 0x001D8D8780005F9A, 
0x0018398500189186, 0x001C118B00199584, 0x80005F9E001C058A, 0x0015858F80005FA2, 0x0010398D0010998E, 0x00145193001D958C, 0x80005FA600144592, 0x0009619780005FAA, 
0x00099D9500087596, 0x000C419B0015F994, 0x80005FAE000DAD9A, 0x80005FB680005FB2, 0x80005FBE80005FBA, 0x000D6DA1000CF19C, 0x000401A380005FC2, 0x000499A5000085A2, 
0x003819A7000491A4, 0x003809A90005C5A6, 0x003C89AB003829A8, 0x003001AD003C01AA, 0x003029AF003C1DAC, 0x0034E1B100309DAE, 0x002801B3003401B0, 0x0028D9B50034FDB2, 
0x80005FC60028D1B4, 0x80005FCE80005FCA, 0x80005FD680005FD2, 0x00001D8080005FDA, 0x0001D98200000981, 0x000F11A880005FDE, 0x000F5DAA000F19A9, 0x000F4DAC000F55AB, 
0x000F75AE000F71AD, 0x80005FE2000F6DAF, 0x0000888680005FEA, 0x80005FEE00011087, 0x80005FF680005FF2, 0x000E4DB880005FFA, 0x000E51BA000E51B9, 0x000E65BC000E51BB, 
0x000E65BE000E6DBD, 0x000F1DB0000E1DBF, 0x000FC1B2000FC1B1, 0x000FC5B4000FC1B3, 0x000FC5B6000FCDB5, 0x000FD5B3000E79B7, 0x8000600280005FFE, 0x8000600A80006006, 
0x000FC5B5000FF1B6, 0x000F05BB8000600E, 0x80006012000FD9BA, 0x000F09BF80006016, 0x000F15BD000F01BE, 0x8000601A000F15BC, 0x8000601E000F91A3, 0x000FB5A680006022, 
0x8000602A80006026, 0x000F9DAA000F81A5, 0x8000602E000F41AB, 0x000F45AE80006032, 0x000F51AC000F4DAF, 0x000D81A8000F51AD, 0x000D81AA000D81A9, 0x000D81AC000D81AB, 
0x000DB1AE000D81AD, 0x80006036000DA1AF, 0x8000603E8000603A, 0x8000604680006042, 0x0000BD810000B982, 0x000235B80000BD80, 0x0002CDBA00023DB9, 0x00028DBC000295BB, 
0x0002BDBE0002B5BD, 0x00026DB00002B5BF, 0x000245B200024DB1, 0x00023DB4000225B3, 0x000215B600021DB5, 0x8000604A00020DB7, 0x000D01B38000604E, 0x000D01B580006052, 
0x000394848000605A, 0x00042CBE000D09B6, 0x000281BB8000605E, 0x0002F9BD0002A1BA, 0x0002D1BF000299BC, 0x800060620002F1BE, 0x8000606A80006066, 0x8000606E000D45A3, 
0x000D4DA6000D45A5, 0x0004E08680006072, 0x0002E5AA0004A487, 0x0002DDAC0002C5AB, 0x0002B5AE0002BDAD, 0x000225A8000295AF, 0x00023DAA000235A9, 0x00022DAC000235AB, 
0x000291AE000291AD, 0x80006076000291AF, 0x8000607E8000607A, 0x000000CC80006082, 0x8000608A80006086, 0x000299B88000608E, 0x0002A5BA0002ADB9, 0x000175BC00016DBB, 
0x000175BE00017DBD, 0x0002F1B000016DBF, 0x0002C1B20002F9B1, 0x0002B1B40002C1B3, 0x0002B5B60002BDB5, 0x800060920002A9B7, 0x80006096000E84E3, 0x8000609A000EF4E1, 
0x800060A28000609E, 0x00052084800060A6, 0x800060AE800060AA, 0x800060B6800060B2, 0x800060BA000EECEF, 0x0002F5B3800060BE, 0x0004E886800060C2, 0x00045CBE00048C87, 
0x0002E5B5000251B6, 0x00027DBB800060CA, 0x800060CE000275BA, 0x000239BF800060D2, 0x000255BD000235BE, 0x000535A3000255BC, 0x800060C680006056, 0x800060DA800060D6, 
0x000525A5000591A6, 0x0005BDAB800060DE, 0x800060E20005B5AA, 0x0005F9AF800060E6, 0x000595AD0005F5AE, 0x0007F980000595AC, 0x00078D820007F981, 0x800060EA00068DB3, 
0x000689B600069DB5, 0x800060F2800060EE, 0x00074DBA800060F6, 0x00075DBC000745BB, 0x000741BE000741BD, 0x800060FA000741BF, 0x80005FE6800060FE, 0x8000610680006102, 
0x8000610E8000610A, 0x000635A880006112, 0x000669AA000601A9, 0x000679AC000669AB, 0x000665AE000665AD, 0x0007E5B000079DAF, 0x0007E5B20007EDB1, 0x0007E9B40007F9B3, 
0x000759B60007E9B5, 0x000771B8000755B7, 0x000771BA000771B9, 0x000755BC000771BB, 0x000755BE00075DBD, 0x0007C1A300074DBF, 0x8000611A80006116, 0x800061228000611E, 
0x0007D1A50007C5A6, 0x000609AB80006126, 0x8000612A000601AA, 0x00060DAF8000612E, 0x00060DAD00060DAE, 0x00006980000611AC, 0x0000058200006981, 0x000198BE80006132, 
0x8000613600019884, 0x003C00868000613A, 0x8000613E0001C487, 0x8000614680006142, 0x8000614E8000614A, 0x00065DA880006152, 0x000665AA00066DA9, 0x000181AC000181AB, 
0x0001B1AE000189AD, 0x800061560001B1AF, 0x8000615E8000615A, 0x8000616680006162, 0x8000616E8000616A, 0x000155B880006172, 0x000155BA00015DB9, 0x0000D9BC0000C9BB, 
0x0000C9BE0000D9BD, 0x0001B1B00000C1BF, 0x000189B20001B9B1, 0x000171B4000189B3, 0x000175B6000171B5, 0x0005EDB300016DB7, 0x8000617A80006176, 0x800061828000617E, 
0x000209B5000209B6, 0x00027DBB80006186, 0x8000618A000275BA, 0x0002B5BF8000618E, 0x00025DBD0002B5BE, 0x000260BE00025DBC, 0x800061920005A9A3, 0x00024DA680006196, 
0x8000619E8000619A, 0x000231AA00024DA5, 0x800061A2000239AB, 0x0002F1AE0003E084, 0x000219AC0002F1AF, 0x003C88BE000219AD, 0x00032DAA800061AA, 0x00033DAC000325AB, 
0x00032DAE000325AD, 0x0000F580000325AF, 0x0000C1820000FD81, 0x800061AE0003C1A3, 0x0003C1A60003C1A5, 0x003C6086800061B2, 0x800061B600035487, 0x800061BE800061BA, 
0x800061C20002A8E3, 0x800061C60001A4E1, 0x800061CA00025CEF, 0x800061D2800061CE, 0x800061DA800061D6, 0x800061E2800061DE, 0x800061E600078CE3, 0x800061EA00043CE1, 
0x800061F2800061EE, 0x00022084800061F6, 0x800061FE800061FA, 0x8000620680006202, 0x8000620A00076CEF, 0x00022DB38000620E, 0x80006212003D4484, 0x8000621E8000621A, 
0x00022DB500022DB6, 0x0002C9BB80006222, 0x800062260002C1BA, 0x0002C9BF8000622A, 0x0002C9BD0002C1BE, 0x000778E10002D1BC, 0x000638E30000C0E3, 0x0000A98000065CE1, 
0x0000D1820000A981, 0x800062328000622E, 0x003CA4BE80006236, 0x8000623E8000623A, 0x000690EF00001CEF, 0x003C608680006242, 0x80006246003D0487, 0x8000624A000171B3, 
0x000109B6000119B5, 0x800062528000624E, 0x000101BA80006256, 0x000101BC000101BB, 0x000101BE000101BD, 0x003E85A8000101BF, 0x003EB5AA003EB5A9, 0x003EDDAC003EC5AB, 
0x003EC1AE003EC5AD, 0x8000625A003EFDAF, 0x800062628000625E, 0x8000626A80006266, 0x800062728000626E, 0x003F51B880006276, 0x003F51BA003F51B9, 0x003F75BC003F51BB, 
0x003F75BE003F7DBD, 0x003E89B0003F6DBF, 0x003E99B2003E89B1, 0x003E89B4003E99B3, 0x003F79B6003E89B5, 0x800061A6003F75B7, 0x8000627A003E39A3, 0x003E41A680006216, 
0x800062828000627E, 0x003E49AA003E51A5, 0x80006286003E49AB, 0x003E49AE8000628A, 0x003E49AC003E49AF, 0x00004980003E49AD, 0x0000518200005181, 0x8000628E003F91B3, 
0x003F45B6003FB9B5, 0x0000408680006292, 0x003F45BA00030487, 0x003F4DBC003F5DBB, 0x003F29BE003F3DBD, 0x003E4DA8003F21BF, 0x003E55AA003E55A9, 0x003E7DAC003E65AB, 
0x003EB9AE003E89AD, 0x80006296003EB9AF, 0x8000629E8000629A, 0x800062A6800062A2, 0x800062AE800062AA, 0x000161B8800062B2, 0x000161BA000161B9, 0x000161BC000161BB, 
0x000161BE000161BD, 0x003ECDB0000161BF, 0x003ED5B2003ED5B1, 0x003EA1B4003EA5B3, 0x003E99B6003EA9B5, 0x003EDDA3003E99B7, 0x800062BA800062B6, 0x800062C2800062BE, 
0x003EF5A5003E09A6, 0x003E11AB800062C6, 0x800062CA003E09AA, 0x003E6DAF800062CE, 0x003E71AD003E65AE, 0x800062D2003E01AC, 0x800062DA800062D6, 0x800062E2800062DE, 
0x800062EA800062E6, 0x00003980800062EE, 0x0000058200003981, 0x0001B8BE800062F2, 0x800062FA0001B884, 0x0002ADA8800062FE, 0x0002D5AA0002D5A9, 0x000335AC00032DAB, 
0x000335AE00033DAD, 0x8000630200032DAF, 0x8000630A80006306, 0x800063128000630E, 0x8000631A80006316, 0x0003E9B88000631E, 0x000389BA0003E9B9, 0x000399BC000389BB, 
0x000389BE000399BD, 0x000355B0000389BF, 0x000355B200035DB1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 0x00025DB30003E1B7, 0x0004288680006322, 0x800063260003CC87, 
0x0003BDB50003BDB6, 0x000399BB8000632A, 0x8000632E000391BA, 0x00033DBF80006332, 0x00033DBD00033DBE, 0x00140085000381BC, 0x80006336000219A3, 0x0003F9A68000633A, 
0x800063428000633E, 0x0003D5AA0003F9A5, 0x800063460003DDAB, 0x000379AE8000634A, 0x0003C5AC000379AF, 0x003E54E3000379AD, 0x003ED0E1003FDCE1, 0x8000634E003E3CE3, 
0x8000635200001CEF, 0x8000635A80006356, 0x8000635E0000C0E3, 0x003E60EF0001D4E1, 0x8000636A80006362, 0x00006180003F44EF, 0x00007D8200006D81, 0x0004F08600050084, 
0x000510BE00059C87, 0x800063728000636E, 0x8000637A80006376, 0x800063828000637E, 0x8000638A80006386, 0x003D89B88000638E, 0x003D99BA003D89B9, 0x003DB9BC003D91BB, 
0x003DD1BE003DB9BD, 0x003E05B0003DD1BF, 0x003E05B2003E0DB1, 0x003E05B4003E1DB3, 0x003E05B6003E0DB5, 0x003E9DA8003DB9B7, 0x003EA5AA003EADA9, 0x003EA5AC003EBDAB, 
0x003EA5AE003EADAD, 0x0004AC84003E7DAF, 0x800063920004ACBE, 0x8000639A80006396, 0x800063A28000639E, 0x0005F9A8800063A6, 0x000629AA0005F9A9, 0x000639AC000629AB, 
0x000629AE000639AD, 0x80006366000629AF, 0x800063AE800063AA, 0x800063B6800063B2, 0x800063BE800063BA, 0x00068DB8800063C2, 0x000691BA000691B9, 0x0006BDBC0006A5BB, 
0x000741BE000745BD, 0x000659B0000741BF, 0x0006EDB2000659B1, 0x0006EDB40006FDB3, 0x0006D5B60006DDB5, 0x0006A1B30006B5B7, 0x800063CA800063C6, 0x800063D2800063CE, 
0x0006B1B50006B9B6, 0x00069DBB800063DA, 0x800063D600069DBA, 0x000619BF800062F6, 0x000629BD000629BE, 0x00005182000639BC, 0x000041800006E5A3, 0x0006FDA600004181, 
0x800063E2800063DE, 0x0006D9AA0006F5A5, 0x000048860006D9AB, 0x00066DAE00006C87, 0x00067DAC00065DAF, 0x000639A800066DAD, 0x000669AA000659A9, 0x000679AC000669AB, 
0x000669AE000679AD, 0x800063E6000669AF, 0x800063EE800063EA, 0x800063F6800063F2, 0x800063FE800063FA, 0x000165B880006402, 0x000165BA00016DB9, 0x000165BC00017DBB, 
0x000165BE00016DBD, 0x000619B00001D9BF, 0x000681B2000619B1, 0x000681B4000681B3, 0x000681B6000681B5, 0x0006E1B3000681B7, 0x8000640A80006406, 0x800064128000640E, 
0x0006F1B50006F9B6, 0x0006DDBB80006416, 0x8000641A0006DDBA, 0x000645BF8000641E, 0x000655BD000645BE, 0x80006422000655BC, 0x800064260006A5A3, 0x0006BDA68000642A, 
0x800064328000642E, 0x000699AA0006B5A5, 0x80006436000699AB, 0x000601AE8000643A, 0x000611AC000601AF, 0x00029DA8000611AD, 0x0002D1AA0002D1A9, 0x000335AC00032DAB, 
0x000335AE00033DAD, 0x8000643E00032DAF, 0x000264BE80006442, 0x8000644E8000644A, 0x8000645680006452, 0x0003E9B88000645A, 0x000389BA0003E9B9, 0x00039DBC000385BB, 
0x000381BE000381BD, 0x000355B00003B5BF, 0x000355B200035DB1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 0x00036D800003E1B7, 0x0000AD820000A581, 0x8000645E000255B3, 
0x0003B1B60003B1B5, 0x0002E08480006462, 0x00039DBA80006466, 0x00038DBC000395BB, 0x000331BE000331BD, 0x000219A3000331BF, 0x006970858000646A, 0x800064728000646E, 
0x0003FDA50003FDA6, 0x0003D9AB80006476, 0x000C48860003D1AA, 0x00037DAF0003BC87, 0x00037DAD00037DAE, 0x8000647A0003C1AC, 0x800064828000647E, 0x0006B0EF80006486, 
0x8000648A0003C4EF, 0x00067CE38000648E, 0x0007B8E1000394E3, 0x800064920001DCE1, 0x8000649A80006496, 0x800064A28000649E, 0x00024484800064A6, 0x00000D80000D58BE, 
0x00003D8200003581, 0x800064AE800064AA, 0x000CC886800064B2, 0x800064BA000D5C87, 0x800064C2800064BE, 0x800064CA800064C6, 0x800064D2800064CE, 0x800064DA800064D6, 
0x800064E2800064DE, 0x000DAC84000680EF, 0x800064E60006ECE1, 0x800064EA00065CE3, 0x800064F2800064EE, 0x0001F5B3800064F6, 0x800064FE800064FA, 0x8000650680006502, 
0x0001E5B5000145B6, 0x00012DBB8000650A, 0x8000650E000121BA, 0x0000F5BF80006512, 0x000125BD0000F5BE, 0x000E2DA800012DBC, 0x000E3DAA000E35A9, 0x000E2DAC000E35AB, 
0x000E85AE000E85AD, 0x800064B6000EB9AF, 0x8000651A80006516, 0x000019808000651E, 0x0000058200001981, 0x000F59B880006522, 0x000F79BA000F59B9, 0x000F69BC000F79BB, 
0x000F19BE000F69BD, 0x000EA5B0000F19BF, 0x000EB9B2000EA9B1, 0x000F71B4000EB1B3, 0x000F71B6000F71B5, 0x000EBDA5000F71B7, 0x8000652A000388BE, 0x80006526000E1DA6, 
0x000EADA38000652E, 0x000E7DAD80006532, 0x000FADAF000E75AC, 0x80006446000FADAE, 0x000E75AB80006536, 0x000FB9B3000E79AA, 0x000068868000653A, 0x8000653E00030C87, 
0x000F59B5000F51B6, 0x000F75BB80006542, 0x80006546000F75BA, 0x000F45BF8000654A, 0x000F51BD000F45BE, 0x000E71A8000F65BC, 0x000E71AA000E71A9, 0x000E91AC000E71AB, 
0x000E91AE000E91AD, 0x8000654E000E91AF, 0x8000655680006552, 0x8000655E8000655A, 0x8000656680006562, 0x000E85B88000656A, 0x000E85BA000E8DB9, 0x000E8DBC000E9DBB, 
0x000EB5BE000EBDBD, 0x000EF1B0000179BF, 0x000EF1B2000EF1B1, 0x000EC1B4000EC5B3, 0x000EC1B6000EC1B5, 0x000EF9A3000EC1B7, 0x800065728000656E, 0x8000657A80006576, 
0x000E19A5000E11A6, 0x000E35AB8000657E, 0x80006582000E35AA, 0x000E05AF80006586, 0x000E11AD000E05AE, 0x00000D80000E25AC, 0x00001D8200001581, 0x8000658E8000658A, 
0x0001948480006592, 0x00074086000194BE, 0x8000659A0000E487, 0x800065A28000659E, 0x800065AA800065A6, 0x000289A8800065AE, 0x000295AA000291A9, 0x0002D5AC0002B9AB, 
0x0002C5AE0002C5AD, 0x800065B20002F5AF, 0x800065BA800065B6, 0x00037CBE800065BE, 0x800065C6800065C2, 0x00037DB8800065CA, 0x0003C1BA0003C1B9, 0x0003C1BC0003C1BB, 
0x0003F1BE0003C9BD, 0x00028DB00003F1BF, 0x00034DB2000345B1, 0x00035DB4000345B3, 0x00034DB6000345B5, 0x00021DB3000345B7, 0x800065D2800065CE, 0x800065DA800065D6, 
0x00025DB5000245B6, 0x000381BB800065DE, 0x800065E2000249BA, 0x000381BF800065E6, 0x000391BD000399BE, 0x800065EA000399BC, 0x800065EE000259A3, 0x000201A6800065F2, 
0x800065FA800065F6, 0x00020DAA000219A5, 0x800065FE0003C5AB, 0x0003DDAE80006602, 0x0003DDAC0003C5AF, 0x0001D9800003D5AD, 0x0001E5820001ED81, 0x8000660A000EB8EF, 
0x000298840001C4E1, 0x8000660E0000D4E3, 0x800066120004ECBE, 0x80006616000008EF, 0x8000661A000FC4E1, 0x00050086000E64E3, 0x8000661E00056887, 0x800066220002BDB3, 
0x0002A5B60002ADB5, 0x8000662A80006626, 0x000141BA8000662E, 0x000145BC000141BB, 0x000145BE00014DBD, 0x800066320001F9BF, 0x8000663A80006636, 0x800066428000663E, 
0x8000664A80006646, 0x00046C840001E0EF, 0x8000664E000ED4E1, 0x80006652000E1CE3, 0x8000665A80006656, 0x000231A38000665E, 0x0007248480006662, 0x8000666A80006666, 
0x000221A5000229A6, 0x0001CDAB8000666E, 0x800066720001CDAA, 0x000175AF8000667A, 0x0001C1AD0001C9AE, 0x0005E9A80001C9AC, 0x0005F9AA0005E9A9, 0x0005E9AC0005F9AB, 
0x000639AE0005E9AD, 0x80006606000639AF, 0x0007F5810007CD82, 0x800066760007FD80, 0x000318868000667E, 0x0006D1B800039087, 0x0006E1BA0006D9B9, 0x000691BC0006E1BB, 
0x000695BE00069DBD, 0x000649B0000689BF, 0x00065DB2000649B1, 0x00064DB4000655B3, 0x0006F1B60006F1B5, 0x0007E1B00006F1B7, 0x000709B20007E1B1, 0x000719B4000709B3, 
0x000709B6000719B5, 0x000739B8000709B7, 0x000719BA00070DB9, 0x000709BC000719BB, 0x00077DBE000709BD, 0x80006682000771BF, 0x8000668680006596, 0x8000668E8000668A, 
0x8000669680006692, 0x0007F1A88000669A, 0x0007C1AA0007C5A9, 0x0007C9AC0007DDAB, 0x0007A9AE0007BDAD, 0x000629B30007A1AF, 0x800066A28000669E, 0x800066AA800066A6, 
0x000621B500065DB6, 0x000645BB800066AE, 0x800066B2000645BA, 0x0006BDBF800066B6, 0x0006BDBD0006BDBE, 0x800066BA0006BDBC, 0x800066BE00066DA3, 0x000619A6800066C2, 
0x800066CA800066C6, 0x000601AA000665A5, 0x800066CE000601AB, 0x0006F9AE800066D2, 0x0006F9AC0006F9AF, 0x00066DA80006F9AD, 0x000149AA0001B1A9, 0x00015DAC000145AB, 
0x00014DAE000145AD, 0x800066D6000145AF, 0x00001D8100001D82, 0x800066DA00001D80, 0x800066E2800066DE, 0x000081B8000154BE, 0x000085BA00008DB9, 0x000089BC000099BB, 
0x0000B5BE0000BDBD, 0x00013DB000007DBF, 0x0000E1B20000E1B1, 0x0000E1B40000E1B3, 0x0000D1B60000E9B5, 0x000305BB0000D1B7, 0x00022C860002D9BA, 0x00030DBF00032C87, 
0x000315BD000305BE, 0x0002E1B3000315BC, 0x800066EE800066EA, 0x800066F200032C84, 0x0002F5B50002E5B6, 0x00029DAA800066F6, 0x800066FA000341AB, 0x000341AE800066FE, 
0x000351AC000349AF, 0x80006702000351AD, 0x800067060002A5A3, 0x0002A1A68000670A, 0x800067128000670E, 0x0000A9A90002B1A5, 0x0000B5AB0000A1A8, 0x0000DDAD0000BDAA, 
0x0000F1AF0000DDAC, 0x001C2CBE0000FDAE, 0x8000671A80006716, 0x800067228000671E, 0x8000672A80006726, 0x00007DB98000672E, 0x0001CDBB00007DB8, 0x0001DDBD0001CDBA, 
0x0001CDBF0001DDBC, 0x000095B10001CDBE, 0x00004DB3000089B0, 0x00005DB5000095B2, 0x00004DB700005DB4, 0x8000673200004DB6, 0x8000673A80006736, 0x800067428000673E, 
0x8000674A80006746, 0x000039808000674E, 0x0000058200003981, 0x8000675A80006752, 0x0002F8878000675E, 0x0004B8E1001D7C86, 0x000640E3001CC8BE, 0x8000676680006762, 
0x8000676E8000676A, 0x8000677680006772, 0x8000677E8000677A, 0x8000678680006782, 0x0007B0EF8000678A, 0x800067928000678E, 0x8000679A80006796, 0x8000679E0000C8EF, 
0x800067A6800067A2, 0x800067AA000640EF, 0x800067AE0006FCE1, 0x800067B200061CE3, 0x800067B6000194E1, 0x00001180000664E3, 0x0000298200001981, 0x800067BA0001FDB3, 
0x000195B600019DB5, 0x800067C2800067BE, 0x000185BA001D6C84, 0x000189BC000199BB, 0x000151BE000151BD, 0x001E31A3000151BF, 0x800067C680006756, 0x800067CE800067CA, 
0x001E51A5001E59A6, 0x001E55AB800067D2, 0x00030886001E49AA, 0x001E9DAF00036C87, 0x001E9DAD001E9DAE, 0x800067D6001E45AC, 0x800067DA001F09B3, 0x001F09B6800067DE, 
0x800067E6800067E2, 0x001F05BA001F09B5, 0x800067EA001F0DBB, 0x001F05BE800067EE, 0x001F15BC001F09BF, 0x001FE5B0001F0DBD, 0x001FE5B2001FEDB1, 0x001FE5B4001FFDB3, 
0x001F19B6001FE9B5, 0x001F29B8001F19B7, 0x001F3DBA001F35B9, 0x001F11BC001F35BB, 0x001F09BE001F1DBD, 0x800067F2001F05BF, 0x800066E6800067F6, 0x800067FE800067FA, 
0x8000680680006802, 0x001FD1A88000680A, 0x001FA5AA001FD1A9, 0x001FA5AC001FBDAB, 0x001FA5AE001FADAD, 0x001E4DA3001F9DAF, 0x800068128000680E, 0x8000681A80006816, 
0x001E4DA5001E4DA6, 0x001E49AB8000681E, 0x80006822001E41AA, 0x001E4DAF80006826, 0x001E49AD001E41AE, 0x00000D80001E51AC, 0x00001D8200001581, 0x8000682E8000682A, 
0x0001B48480006832, 0x0001E8BF0001B4BE, 0x000748868000683A, 0x0006BC8400003487, 0x800068428000683E, 0x00018DA80006B4BE, 0x000195AA000195A9, 0x0001D9AC0001CDAB, 
0x0001CDAE0001D9AD, 0x800068460001C5AF, 0x8000684E8000684A, 0x8000685680006852, 0x8000685E8000685A, 0x00011DB880006862, 0x0000C1BA0000C1B9, 0x0000C1BC0000C1BB, 
0x0000F1BE0000C9BD, 0x000189B00000F1BF, 0x000129B2000189B1, 0x00013DB4000129B3, 0x00012DB6000125B5, 0x00026DBB000125B7, 0x8000686600026DBA, 0x0002C1BF8000686A, 
0x0002DDBD0002D9BE, 0x00023DB30002DDBC, 0x800068728000686E, 0x0006FC8480006876, 0x000271B5000279B6, 0x000229AA8000687A, 0x8000687E000229AB, 0x00029DAE80006882, 
0x000299AC000285AF, 0x80006886000299AD, 0x8000688A000279A3, 0x00023DA68000688E, 0x8000689680006892, 0x00276D82000235A5, 0x0005A886002A8D83, 0x002E998600036C87, 
0x002E1184002FCD87, 0x0012218A002E9985, 0x8000689A0012298B, 0x0016918E8000689E, 0x0012118C00161D8F, 0x001A71920016118D, 0x800068A2001AE593, 0x001EF196007694EF, 
0x001A4994001EE597, 0x0002299A001E1995, 0x800068AA0002E19B, 0x800068B2800068AE, 0x0002F19C001220E1, 0x001F219F001620E3, 0x001B999D001FC19E, 0x001BA19B001B2D9C, 
0x001739990017BD9A, 0x001389970017B198, 0x0013A9950013A996, 0x002F3993002E7594, 0x002FB191002F3192, 0x0026AD8F002B3590, 0x000000D2001F78E3, 0x00019982001F5CE1, 
0x0001F180800068B6, 0x0007A8BE0001F181, 0x800068BE800068BA, 0x0006BC84800068C2, 0x800068C6001F2CEF, 0x001EA4E1800068CA, 0x001E7CE30000CCE3, 0x800068CE0001BCE1, 
0x800068D6800068D2, 0x800068DA00069C84, 0x800068DE00066CBE, 0x800068E6800068E2, 0x001E04EF000010EF, 0x800068EE800068EA, 0x800068F6800068F2, 0x800068FE800068FA, 
0x8000690680006902, 0x00003D808000690A, 0x0007C98200000981, 0x0003F9A38000690E, 0x000331A10003F1A2, 0x007149B0001FCDA0, 0x007C09B2007C01B1, 0x007801B4007D21B3, 
0x80006836007815B5, 0x80006912800068A6, 0x00000C86000E28BE, 0x8000691600038C87, 0x8000691E8000691A, 0x8000692680006922, 0x000055A200005DA1, 0x000C01A400007DA3, 
0x000CF5A6000C15A5, 0x000821A8000801A7, 0x007401AA0008C5A9, 0x007401AC007409AB, 0x007079AE00751DAD, 0x0005E5A8007079AF, 0x0005F1AA0005F1A9, 0x000535AC00052DAB, 
0x000535AE00053DAD, 0x8000692A00052DAF, 0x800069328000692E, 0x8000693A80006936, 0x800069428000693E, 0x0006FDB880006946, 0x000685BA00068DB9, 0x0006B9BC0006ADBB, 
0x0006ADBE0006B9BD, 0x000555B00006A5BF, 0x000555B200055DB1, 0x0006FDB40006E5B3, 0x0006D1B60006D1B5, 0x000479B30006D1B7, 0x8000694E8000694A, 0x8000695680006952, 
0x0004BDB50004BDB6, 0x000499BB8000695A, 0x8000695E000491BA, 0x000715BF80006962, 0x000731BD000739BE, 0x80006966000481BC, 0x8000696A00043DA3, 0x0004F9A68000696E, 
0x8000697680006972, 0x0004D5AA0004F9A5, 0x8000697A0004DDAB, 0x00077DAE8000697E, 0x0004C5AC000751AF, 0x000769A8000775AD, 0x000779AA000769A9, 0x0006F5AC0006D9AB, 
0x0006F5AE0006FDAD, 0x0000C9800006E5AF, 0x000005820000C981, 0x000F708680006982, 0x8000698A00003487, 0x00067DB88000698E, 0x00060DBA000605B9, 0x00061DBC000605BB, 
0x00060DBE000605BD, 0x00069DB0000605BF, 0x00067DB2000675B1, 0x000651B4000675B3, 0x000655B600065DB5, 0x0004F1B300064DB7, 0x8000699680006992, 0x8000699E8000699A, 
0x00057DB500057DB6, 0x0005B1BB800069A2, 0x800069A6000559BA, 0x000599BF800069AA, 0x0005A1BD000595BE, 0x800069AE0005A9BC, 0x800069B20004B5A3, 0x000539A6800069B6, 
0x800069BE800069BA, 0x00051DAA000539A5, 0x800069C20005F5AB, 0x0005D1AE800069C6, 0x0005EDAC0005DDAF, 0x0002B9A90005E5AD, 0x0002C9AB0002B1A8, 0x000235AD0002B1AA, 
0x000235AF000235AC, 0x800069CA000235AE, 0x800069D2800069CE, 0x800069DA800069D6, 0x800069E2800069DE, 0x0003E9B9800069E6, 0x000389BB0003D9B8, 0x00039DBD0003E1BA, 
0x000381BF00039DBC, 0x000255B1000389BE, 0x000255B3000255B0, 0x0003F9B5000255B2, 0x0003E9B70003F1B4, 0x00033DB30003F1B6, 0x800069EE800069EA, 0x800069FA800069F2, 
0x0003B9B50003B1B6, 0x000395BB800069FE, 0x000C8886000395BA, 0x000239BF000DA087, 0x000385BD000231BE, 0x80006A02000385BC, 0x80006A06000379A3, 0x0003F5A680006A0A, 
0x80006A1280006A0E, 0x0003D1AA0003FDA5, 0x80006A160003D1AB, 0x000275AE80006A1A, 0x0003C1AC00027DAF, 0x000085800003C1AD, 0x0000858200008D81, 0x0007B0E30006D0EF, 
0x000708E10004F4E3, 0x000638EF0004ECE1, 0x000CA4BE000420EF, 0x80006A2280006A1E, 0x80006A26000184E1, 0x80006A2A0006DCE3, 0x000DC08480006A2E, 0x80006A320001C9B3, 
0x0001C9B60001D9B5, 0x80006A3A80006A36, 0x0001C5BA80006A3E, 0x0001B9BC0001ADBB, 0x0001ADBE0001B9BD, 0x000E2DB00001A5BF, 0x000E41B2000E45B1, 0x000E45B4000E41B3, 
0x000E71B6000E4DB5, 0x000E81B8000E71B7, 0x000E81BA000E81B9, 0x000E81BC000E81BB, 0x000E81BE000E81BD, 0x800069F6000E81BF, 0x80006A4680006A42, 0x8000698680006A4A, 
0x80006A5280006A4E, 0x000DD9A880006A56, 0x000E6DAA000DD9A9, 0x000E7DAC000E65AB, 0x000E65AE000E65AD, 0x000E85A3000E55AF, 0x0000158100002D82, 0x80006A5A00001D80, 
0x000E95A5000E85A6, 0x000EE1AB80006A5E, 0x80006A62000E89AA, 0x000EE9AF80006A66, 0x000EF5AD000EE1AE, 0x80006A6A000EF5AC, 0x00006886000F85B3, 0x000F85B600031C87, 
0x80006A7280006A6E, 0x000F8DBA000F91B5, 0x80006A76000F49BB, 0x000F31BE80006A7A, 0x000F49BC000F31BF, 0x000E11A8000F45BD, 0x000E49AA000E19A9, 0x000E5DAC000E45AB, 
0x000E41AE000E41AD, 0x80006A7E000E75AF, 0x80006A8680006A82, 0x80006A8E80006A8A, 0x80006A9680006A92, 0x000EA1B880006A9A, 0x00010DBA000EA1B9, 0x00011DBC000105BB, 
0x000101BE000101BD, 0x000E0DB0000101BF, 0x000ED9B2000EC9B1, 0x000EB1B4000ED5B3, 0x000EA9B6000EB1B5, 0x000EC1A3000EA1B7, 0x80006AA280006A9E, 0x80006AAA80006AA6, 
0x000ED5A5000EC1A6, 0x000E0DAB80006AAE, 0x80006AB2000EC9AA, 0x000E75AF80006AB6, 0x000E01AD000E75AE, 0x80006ABA000E0DAC, 0x80006AC280006ABE, 0x00000D8080006AC6, 
0x00003D8200003581, 0x80006ACE80006ACA, 0x0001848480006AD2, 0x00073086000184BE, 0x80006ADA0000F887, 0x0002C1A880006ADE, 0x0002D1AA0002D1A9, 0x0002FDAC0002E5AB, 
0x00033DAE000335AD, 0x80006AE2000335AF, 0x80006AEA80006AE6, 0x80006AF280006AEE, 0x80006AFA80006AF6, 0x0003D1B880006AFE, 0x0003E1BA0003D9B9, 0x000391BC0003E1BB, 
0x000391BE000391BD, 0x00034DB0000391BF, 0x00035DB2000355B1, 0x00034DB4000355B3, 0x0003F1B60003F1B5, 0x0003B1BB0003F1B7, 0x80006B020003A9BA, 0x000315BF000384BE, 
0x0003A1BD0003A9BE, 0x000279B30003A9BC, 0x80006B0A80006B06, 0x80006B1280006B0E, 0x000255B5000395B6, 0x0003EDAA80006B16, 0x80006B1A0003F5AB, 0x0003EDAE80006B1E, 
0x0003EDAC000351AF, 0x80006B220003E5AD, 0x80006B2600023DA3, 0x0003D1A680006B2A, 0x80006B3280006B2E, 0x80006B36000211A5, 0x0000158100002182, 0x000004EF00001580, 
0x80006B3A00029484, 0x0000D8E380006B3E, 0x0001F8E180006B42, 0x80006B4E80006B4A, 0x80006B5680006B52, 0x0005608680006B5A, 0x80006B5E00050887, 0x80006B6200016DB3, 
0x000175B600017DB5, 0x80006B6A80006B66, 0x000151BA80006B6E, 0x0001F9BC000151BB, 0x0001D1BE0001D1BD, 0x80006B720001D1BF, 0x80006B760001A5A3, 0x0001BDA680006B7A, 
0x80006B8280006B7E, 0x000199AA0001B5A5, 0x80006B86000199AB, 0x000119AE80006B8A, 0x000131AC000119AF, 0x80006B8E000119AD, 0x80006B92000EF4E1, 0x000000F4000E14E3, 
0x80006B96000C7CE1, 0x80006B9A000A50E3, 0x000420BE80006B9E, 0x80006BA2000D30EF, 0x0004348480006BA6, 0x000639B0000EACEF, 0x000681B2000639B1, 0x0006B9B40006A9B3, 
0x0006A9B60006B9B5, 0x0006E9B80006A1B7, 0x0006C9BA0006E9B9, 0x0006DDBC0006C5BB, 0x0006C1BE0006C1BD, 0x80006B4600073DBF, 0x00001D8100001D82, 0x80006BAA00001D80, 
0x80006BB280006BAE, 0x000599A880006AD6, 0x000649AA000599A9, 0x000659AC000649AB, 0x000649AE000659AD, 0x0007ADA8000649AF, 0x0007BDAA0007B5A9, 0x0007ADAC0007B5AB, 
0x0007C9AE0007DDAD, 0x80006BB60007C1AF, 0x0003888680006BBA, 0x80006BBE00031087, 0x80006BC680006BC2, 0x00076DB880006BCA, 0x000701BA000705B9, 0x000731BC000715BB, 
0x000729BE000731BD, 0x000781B0000729BF, 0x000769B2000781B1, 0x00077DB4000765B3, 0x000761B6000761B5, 0x000635B3000755B7, 0x80006BD280006BCE, 0x80006BDA80006BD6, 
0x000625B500065DB6, 0x000645BB80006BDE, 0x80006BE2000645BA, 0x0006A5BF80006BE6, 0x0006B1BD0006B9BE, 0x80006BEA0006BDBC, 0x80006BEE000671A3, 0x000619A680006BF2, 
0x80006BFA80006BF6, 0x000601AA000661A5, 0x80006BFE000601AB, 0x0006FDAE80006C02, 0x0006F9AC0006E1AF, 0x000125A80006F5AD, 0x00013DAA000135A9, 0x00012DAC000135AB, 
0x000091AE000091AD, 0x80006C06000091AF, 0x80006C0E80006C0A, 0x80006C1680006C12, 0x0003BD810003BD82, 0x000099B80003BD80, 0x0000A5BA0000ADB9, 0x000075BC00006DBB, 
0x000075BE00007DBD, 0x0000F1B000006DBF, 0x0000C1B20000F9B1, 0x0000B1B40000C1B3, 0x0000B5B60000BDB5, 0x80006C1A0000A9B7, 0x80006C2280006C1E, 0x00021CBE00028084, 
0x007CF88680006C2A, 0x0003AC840002CC87, 0x80006C3280006C2E, 0x80006C3A80006C36, 0x80006C4280006C3E, 0x0002F5B380006C46, 0x80006C4E80006C4A, 0x80006C5200000092, 
0x0002E5B5000351B6, 0x00037DBB80006C56, 0x80006C5A000375BA, 0x000339BF80006C5E, 0x000355BD000335BE, 0x000235A3000355BC, 0x80006C6680006C62, 0x80006C6E80006C6A, 
0x000225A5000391A6, 0x0003BDAB80006C72, 0x80006C760003B5AA, 0x0003F9AF80006C7A, 0x000395AD0003F5AE, 0x0003C0BE000395AC, 0x80006C8280006C7E, 0x00000D8080006C86, 
0x00003D8200003581, 0x80006C8E80006C8A, 0x007CC88680006C92, 0x80006C9A00030087, 0x80006CA280006C9E, 0x80006CAA80006CA6, 0x80006CB280006CAE, 0x80006CBA80006CB6, 
0x80006CC280006CBE, 0x007CEC840003F4EF, 0x80006CC6000194E1, 0x80006CCA000330E3, 0x80006CD280006CCE, 0x000169B380006CD6, 0x80006CDE80006CDA, 0x80006CE680006CE2, 
0x000169B5000161B6, 0x000129BB80006CEA, 0x80006CEE000121BA, 0x00011DBF80006CF2, 0x000125BD00011DBE, 0x80006CF600012DBC, 0x80006CFE80006CFA, 0x80006D020001A5A3, 
0x0001ADA60001A5A5, 0x007C8086007C54BE, 0x0001EDAA007CEC87, 0x0001E1AC0001E5AB, 0x0001D1AE0001E9AD, 0x80006D0A0001D1AF, 0x007F048400069CE1, 0x0006D4E3000624E3, 
0x000430E180006D0E, 0x000794EF80006D12, 0x0000618100007582, 0x80006D1600006980, 0x80006D1E80006D1A, 0x007E8DB80006ECEF, 0x007E95BA007E95B9, 0x007EBDBC007EA5BB, 
0x007ED1BE007ED1BD, 0x007E65B0007ED1BF, 0x007E79B2007E6DB1, 0x007E59B4007E71B3, 0x007EBDB6007E59B5, 0x007E55A8007EB5B7, 0x007E61AA007E61A9, 0x007E61AC007E61AB, 
0x007E61AE007E61AD, 0x80006D22007E61AF, 0x80006C2680006C96, 0x80006D0680006D26, 0x80006D2E80006D2A, 0x007E71A880006D32, 0x007E71AA007E71A9, 0x007F91AC007E71AB, 
0x007F91AE007F91AD, 0x80006D36007F91AF, 0x80006D3E80006D3A, 0x80006D4680006D42, 0x80006D4E80006D4A, 0x007F85B880006D52, 0x007F85BA007F8DB9, 0x007F8DBC007F9DBB, 
0x007FB5BE007FBDBD, 0x007FF1B0007F5DBF, 0x007FF1B2007FF1B1, 0x007FC1B4007FC5B3, 0x007FC1B6007FC1B5, 0x007FF9B3007FC1B7, 0x80006D5A80006D56, 0x80006D6280006D5E, 
0x007E19B5007E11B6, 0x007E35BB80006D66, 0x80006D6A007E35BA, 0x007E05BF80006D6E, 0x007E11BD007E05BE, 0x00001582007E25BC, 0x00006180007FBDA3, 0x007E55A600006181, 
0x000190BE80006D72, 0x007E71AA007E5DA5, 0x80006D76007E71AB, 0x007E41AE80006D7A, 0x007E61AC007E41AF, 0x007E41A8007E55AD, 0x007E55AA007E51A9, 0x007E65AC007E7DAB, 
0x0001F9AE007E6DAD, 0x000000860001F1AF, 0x80006D7E00013487, 0x80006D8680006D82, 0x80006D8E80006D8A, 0x000175B880006D92, 0x000175BA00017DB9, 0x0000D9BC0000C9BB, 
0x0000C9BE0000D9BD, 0x000195B00000C1BF, 0x000195B200019DB1, 0x000155B400014DB3, 0x000155B600015DB5, 0x007DDDB300014DB7, 0x80006D9A80006D96, 0x80006DA280006D9E, 
0x007DEDB5007DEDB6, 0x000259BB80006DA6, 0x80006DAA000251BA, 0x000299BF80006DAE, 0x000299BD000291BE, 0x80006DB2000241BC, 0x80006DB6007D99A3, 0x007DA9A680006DBA, 
0x80006DC280006DBE, 0x000215AA007DA9A5, 0x80006DC600021DAB, 0x0002D5AE80006DCA, 0x000205AC0002DDAF, 0x80006DCE0002DDAD, 0x80006DD680006DD2, 0x00001D8080006DDA, 
0x0000398200000981, 0x80006DE280006DDE, 0x80006DEA000400BE, 0x80006DF280006DEE, 0x80006DFA80006DF6, 0x00038C8480006DFE, 0x0003088780006E02, 0x80006E060004EC86, 
0x80006E0A000288EF, 0x00046C8480006E0E, 0x80006E12000234E3, 0x80006E16000154E1, 0x80006E1E80006E1A, 0x00026DA880006E22, 0x0002A5AA0002ADA9, 0x0002A5AC0002BDAB, 
0x0002A5AE0002ADAD, 0x0004ACBE000119AF, 0x80006E2A80006E26, 0x80006E3280006E2E, 0x80006E3A80006E36, 0x00010DB880006E3E, 0x000111BA000111B9, 0x00013DBC000125BB, 
0x0001DDBE0001D5BD, 0x000169B00001D5BF, 0x000179B2000169B1, 0x000159B4000171B3, 0x000139B6000159B5, 0x00022DB3000135B7, 0x80006E4680006E42, 0x80006E4E80006E4A, 
0x00022DB500022DB6, 0x0001ADBB80006E52, 0x80006E5A0001ADBA, 0x00019DBF80006E5E, 0x0001A5BD00019DBE, 0x00004D800001ADBC, 0x0000558200005581, 0x80006E6200006CEF, 
0x007EBCEF007FECEF, 0x007F10E180006E66, 0x007ED8E3007FD4E3, 0x80006E6A007FECE1, 0x80006E6E007E4CE1, 0x80006DE6007E24E3, 0x000605AB80006E56, 0x00060DAD000605AA, 
0x000635AF000605AC, 0x00030086000635AE, 0x000585A300032887, 0x000585A580006E72, 0x80006E7A80006E76, 0x0006F1B3000585A6, 0x80006E8280006E7E, 0x80006E8A80006E86, 
0x0006E1B50006E9B6, 0x0006BDBB80006E8E, 0x80006E920006BDBA, 0x000689BF80006E96, 0x000689BD000681BE, 0x000629A8000695BC, 0x000639AA000629A9, 0x000629AC000639AB, 
0x00065DAE000629AD, 0x80006E9A00064DAF, 0x80006EA280006E9E, 0x80006EAA80006EA6, 0x80006EB280006EAE, 0x0007E9B880006EB6, 0x0007F9BA0007E9B9, 0x0007E9BC0007F9BB, 
0x00075DBE0007E9BD, 0x000639B0000755BF, 0x000601B2000639B1, 0x000605B400061DB3, 0x000605B600060DB5, 0x0007B1A30007D9B7, 0x0000158100002D82, 0x80006EBA00001D80, 
0x0007A1A50007A9A6, 0x0007FDAB80006EBE, 0x80006EC20007FDAA, 0x0007C9AF0002A484, 0x0007C9AD0007C1AE, 0x0001CCBE0007D5AC, 0x80006EC6000695B3, 0x0006A9B680006ECA, 
0x80006ED280006ECE, 0x000159BA0006ADB5, 0x0000C886000121BB, 0x000121BE00010C87, 0x000131BC000129BF, 0x000629A8000131BD, 0x000659AA000629A9, 0x000661AC000651AB, 
0x0001B5AE00066DAD, 0x0001E0840001A9AF, 0x80006EDA80006ED6, 0x80006EE280006EDE, 0x80006EEA80006EE6, 0x000161B880006EEE, 0x000161BA000161B9, 0x000161BC000161BB, 
0x000161BE000161BD, 0x0001D9B0000161BF, 0x0001A1B20001A1B1, 0x0001A1B40001A1B3, 0x000191B60001A9B5, 0x0005D1A3000191B7, 0x80006EF680006EF2, 0x80006EFE80006EFA, 
0x0005E9A50005EDA6, 0x000265AB80006F02, 0x80006F0600021DAA, 0x00026DAF80006F0A, 0x000275AD000265AE, 0x80006F0E000275AC, 0x80006F1680006F12, 0x80006F1E80006F1A, 
0x80006F2680006F22, 0x00003D8080006F2A, 0x0000198200000981, 0x80006F3280006F2E, 0x00033CBE80006F3A, 0x000C008680006F3E, 0x80006F4200031487, 0x80006F460003D5B3, 
0x000335B600033DB5, 0x80006F4E80006F4A, 0x000311BA000A8CBF, 0x0000B5BC000311BB, 0x0000B5BE0000BDBD, 0x80006F520000ADBF, 0x80006F56000174E3, 0x80006F5A0001BCE1, 
0x80006F6280006F5E, 0x80006F6A80006F66, 0x80006F7280006F6E, 0x80006F7A80006F76, 0x80006F7E000274EF, 0x00024DA880006F82, 0x000251AA000251A9, 0x0002B9AC0002A9AB, 
0x0002A9AE0002B9AD, 0x000D6C840002A9AF, 0x80006F8A80006F86, 0x80006F9280006F8E, 0x80006F9A80006F96, 0x00016DB8000D74BE, 0x00010DBA000105B9, 0x00011DBC000105BB, 
0x00010DBE000105BD, 0x0002D9B0000105BF, 0x00016DB20002D9B1, 0x00017DB4000165B3, 0x000165B6000165B5, 0x0001B8E1000155B7, 0x0000B4E3000750E1, 0x0000A98000077CE3, 
0x0000398200000981, 0x80006FA280006F9E, 0x80006FAE80006FAA, 0x000000EE80006FB2, 0x000000EF80006FB6, 0x000C6086000664EF, 0x000291A3000CE487, 0x000279A580006FBA, 
0x80006FC280006FBE, 0x80006FC6000271A6, 0x000255AB80006FCA, 0x0001F9AD000255AA, 0x0001E9AF0001F1AC, 0x80006FA60001F1AE, 0x80006FCE80006F36, 0x80006FD680006FD2, 
0x80006FDE80006FDA, 0x000E55A880006FE2, 0x000EA1AA000E59A9, 0x000EADAC000EBDAB, 0x000EF9AE000E95AD, 0x000E91B0000EF5AF, 0x000E91B2000E91B1, 0x000EB1B4000E91B3, 
0x000EB1B6000EB1B5, 0x000E91B8000EB1B7, 0x000E95BA000E9DB9, 0x000F59BC000F49BB, 0x000F49BE000F59BD, 0x000E09B3000F49BF, 0x80006FEA80006FE6, 0x80006FF280006FEE, 
0x000E05B5000E35B6, 0x000E75BB80006FF6, 0x80006FFA000E75BA, 0x000E55BF80006FFE, 0x000E65BD000E55BE, 0x80007002000E65BC, 0x80007006000E4DA3, 0x000E71A68000700A, 
0x800070128000700E, 0x000E31AA000E41A5, 0x0003A484000E31AB, 0x000E11AE0003A4BE, 0x000E21AC000E11AF, 0x000EA5A8000E21AD, 0x000EA5AA000EADA9, 0x000EDDAC000EB9AB, 
0x000EC1AE000EC1AD, 0x0001ED80000EFDAF, 0x0001F1820001F181, 0x0001908680007016, 0x8000701A0001B487, 0x0001C9B88000701E, 0x0001D9BA0001C9B9, 0x0001F9BC0001D1BB, 
0x000199BE0001F9BD, 0x000E85B0000195BF, 0x000165B200016DB1, 0x000165B400017DB3, 0x000165B600016DB5, 0x000E2DB30001F9B7, 0x8000702680007022, 0x8000702E8000702A, 
0x000E55B5000E41B6, 0x0001A9BB80007032, 0x80007036000E41BA, 0x0001A9BF8000703A, 0x0001A9BD0001A1BE, 0x8000703E0001B1BC, 0x80007042000E69A3, 0x000E05A680007046, 
0x8000704E8000704A, 0x000E05AA000E11A5, 0x800070520001EDAB, 0x0001E5AE80007056, 0x0001F5AC0001EDAF, 0x000339A80001EDAD, 0x00038DAA000339A9, 0x00039DAC000385AB, 
0x000385AE000385AD, 0x8000705A0003B5AF, 0x800070628000705E, 0x8000706A80007066, 0x800070728000706E, 0x000061B880007076, 0x000061BA000061B9, 0x000061BC000061BB, 
0x000061BE000061BD, 0x0003CDB0000061BF, 0x0003A1B20003A5B1, 0x0003A5B40003A1B3, 0x000391B60003ADB5, 0x00000D80000391B7, 0x0000118200001181, 0x0002F4EF8000707A, 
0x800070828000707E, 0x000214E300031CBE, 0x000180E100028884, 0x8000708E8000708A, 0x0003C88780007092, 0x000301BB00043C86, 0x80007096000369BA, 0x000309BF8000709A, 
0x000315BD000301BE, 0x000365B3000315BC, 0x800070A28000709E, 0x800070AA800070A6, 0x000375B5000365B6, 0x800070B2800070AE, 0x800070BA800070B6, 0x800070BE000289A3, 
0x000289A6000299A5, 0x00022C84800070C2, 0x000285AA800070C6, 0x0002F9AC0002EDAB, 0x0002EDAE0002F9AD, 0x800070CA0002E5AF, 0x000544BE800070CE, 0x800070D200054C84, 
0x800070DA800070D6, 0x800070E2800070DE, 0x800070EA800070E6, 0x00001980800070EE, 0x0000058200001981, 0x000F18E1800070F2, 0x000EB8E3000E5CE1, 0x800070FA000174E3, 
0x80007102800070FE, 0x0004008680007106, 0x8000710A00056487, 0x800071128000710E, 0x000E7CEF80007116, 0x000175B30001A8EF, 0x8000711E8000711A, 0x8000712680007122, 
0x000115B5000131B6, 0x00011DBB8000712A, 0x8000712E000115BA, 0x0000E1BF80007132, 0x0000FDBD0000FDBE, 0x800070F60000FDBC, 0x8000713A80007136, 0x800070868000713E, 
0x8000714680007142, 0x00068DA88000714A, 0x00069DAA000695A9, 0x0006FDAC0006E5AB, 0x0006D1AE0006D1AD, 0x0006B1B00006D1AF, 0x000749B20006B9B1, 0x000759B4000749B3, 
0x000745B6000745B5, 0x000721B8000779B7, 0x000739BA000721B9, 0x000729BC000739BB, 0x000719BE000729BD, 0x000635A3000719BF, 0x800071528000714E, 0x8000715A80007156, 
0x000655A5000671A6, 0x00065DAB8000715E, 0x80007162000655AA, 0x0007A1AF0003A0BE, 0x0007BDAD0007BDAE, 0x000051800007BDAC, 0x0000618200005981, 0x0000F485000755B3, 
0x000775B600077DB5, 0x001C008680007166, 0x00072DBA0001E487, 0x00073DBC000725BB, 0x000725BE000725BD, 0x000691A8000715BF, 0x000691AA000691A9, 0x0006B9AC000691AB, 
0x0006A9AE0006B9AD, 0x8000716A0006A9AF, 0x800071728000716E, 0x000121A280007176, 0x000539A0000135A3, 0x000149B8000411A1, 0x00015DBA000149B9, 0x00014DBC000155BB, 
0x0001D1BE0001D1BD, 0x0006A5B00001D1BF, 0x0006A5B20006ADB1, 0x0006ADB40006BDB3, 0x000695B600069DB5, 0x000619A3000179B7, 0x8000717A00799D8F, 0x800071828000717E, 
0x000631A5000639A6, 0x000669AB80007186, 0x8000718A000661AA, 0x000659AF8000718E, 0x000669AD000669AE, 0x0008899E000671AC, 0x0009C99C0005C19F, 0x000DA19A0009C99D, 
0x000DB198000CBD9B, 0x0071A196000DB999, 0x0075459400714597, 0x0075A1920071B195, 0x0079E5900075B593, 0x00725D8A0079CD91, 0x800071920072458B, 0x000E758E001C80BE, 
0x0072B98C000E658F, 0x007A3982000E758D, 0x80007196007A3983, 0x007671868000719A, 0x007A098400769987, 0x00076D9A00766D85, 0x8000719E0002559B, 0x800071A6800071A2, 
0x0002599C000090E1, 0x000F0992001A08E3, 0x800071AA000A6593, 0x00067596001638EF, 0x000A7D9400067597, 0x00168DA9000B3595, 0x001001AB001685A8, 0x001271AD001631AA, 
0x002EB9AF0012B5AC, 0x00027DA1002C01AE, 0x001EA1A3800071AE, 0x001AB1A5001EA9A2, 0x001BE5A7001FF5A4, 0x0003CC84001AB1A6, 0x800071B2001C4C84, 0x800071BA800071B6, 
0x800071C2800071BE, 0x002801B1800071C6, 0x002A8DB3002ED9B0, 0x0026F5B5002AE9B2, 0x001D7084002401B4, 0x0001FD80800071CA, 0x00001D8200001581, 0x800071CE001C80BE, 
0x0002B887800071D2, 0x800071DA001D3C86, 0x800071E2800071DE, 0x800071EA800071E6, 0x800071F2800071EE, 0x800071FA800071F6, 0x80007202800071FE, 0x000380E380007206, 
0x0001A0E18000720A, 0x000394EF8000720E, 0x8000721680007212, 0x8000721E8000721A, 0x8000722680007222, 0x8000722E8000722A, 0x8000723200063CE1, 0x800072360006D0E3, 
0x8000723A000730E1, 0x000039800006ACE3, 0x00001D8200001581, 0x8000723E00061CEF, 0x001FB8BE80007242, 0x0002E9B30001E8EF, 0x001CC4878000724A, 0x8000724E001CEC86, 
0x000251B5000259B6, 0x00024DBB80007252, 0x8000725600024DBA, 0x0001B9BF8000725A, 0x0001D1BD0001D9BE, 0x001D29A30001F5BC, 0x80007246800071D6, 0x800072628000725E, 
0x001D91A5001D99A6, 0x001D8DAB80007266, 0x8000726A001D8DAA, 0x001E79AF8000726E, 0x001E11AD001E19AE, 0x80007272001E35AC, 0x80007276001F6DB3, 0x001F65B68000727A, 
0x800072828000727E, 0x001F21BA001F6DB5, 0x80007286001F21BB, 0x001F25BE8000728A, 0x001F31BC001F29BF, 0x001FA1A8001F31BD, 0x001FA1AA001FA1A9, 0x001FA1AC001FA1AB, 
0x001FA1AE001FA1AD, 0x8000728E001FA1AF, 0x8000729680007292, 0x8000729E8000729A, 0x800072A6800072A2, 0x001FADB8800072AA, 0x001FBDBA001FB5B9, 0x001FADBC001FB5BB, 
0x001F51BE001F55BD, 0x001FA1B0001F4DBF, 0x001FA1B2001FA1B1, 0x001FA5B4001FA1B3, 0x001F9DB6001FA9B5, 0x001E29A3001F95B7, 0x0000198100001982, 0x800072AE0001B180, 
0x001E29A5001E21A6, 0x001E65AB800072B2, 0x00008886001E65AA, 0x001E6DAF0001FC87, 0x001E75AD001E61AE, 0x800072B6001E75AC, 0x800072BA001E99B3, 0x00015DB6800072BE, 
0x800072C6800072C2, 0x000149BA001EB1B5, 0x800072CA000149BB, 0x00013DBE800072CE, 0x000139BC000121BF, 0x001E45A8000135BD, 0x001E55AA001E55A9, 0x001E7DAC001E65AB, 
0x000189AE000199AD, 0x0000AC84000181AF, 0x800072D6800072D2, 0x800072DE800072DA, 0x800072E6800072E2, 0x0001ADB8800072EA, 0x00016DBA000165B9, 0x00017DBC000165BB, 
0x00016DBE000165BD, 0x0001C9B0000165BF, 0x0001A9B20001C9B1, 0x0001BDB40001A5B3, 0x0001A1B60001A1B5, 0x001C69B8000195B7, 0x001CC1BA001CA1B9, 0x001CC1BC001CC1BB, 
0x001CC1BE001CC1BD, 0x001F89B0001CC1BF, 0x001C21B2001F89B1, 0x001C1DB4001C05B3, 0x001C75B6001C7DB5, 0x001F61A8001C6DB7, 0x001F61AA001F61A9, 0x001FD9AC001F61AB, 
0x001FC9AE001FD9AD, 0x800072EE001FC1AF, 0x800072F6800072F2, 0x800072FE800072FA, 0x8000730680007302, 0x8000730E8000730A, 0x000400BE80007312, 0x80007316001D51A3, 
0x000295A6001D79A5, 0x8000731E8000731A, 0x000281AA80007322, 0x0002F1AC000281AB, 0x0002F5AE0002FDAD, 0x8000732A0002E9AF, 0x8000732E0001F4E1, 0x00004D8000017CE3, 
0x00007D8200007581, 0x0004C08680007332, 0x800073360004A487, 0x8000733E8000733A, 0x8000734680007342, 0x000249A800028CEF, 0x00025DAA000249A9, 0x000279AC000255AB, 
0x0002BDAE000279AD, 0x0005A0840002B5AF, 0x8000734E8000734A, 0x0004BCBE80007352, 0x8000735A80007356, 0x00012DB88000735E, 0x00013DBA000135B9, 0x00012DBC000135BB, 
0x0001DDBE0001D5BD, 0x0002CDB00001CDBF, 0x0002DDB20002D5B1, 0x0002CDB40002D5B3, 0x00011DB6000115B5, 0x001E84E1000115B7, 0x001F5CE3001F6CE3, 0x80007362001E58E1, 
0x8000736A80007366, 0x800073728000736E, 0x8000737A80007376, 0x000000E98000737E, 0x001E4CEF001EF4EF, 0x000295B380007382, 0x8000738A80007386, 0x800073928000738E, 
0x0002B1B50002B9B6, 0x000251BB8000739A, 0x0004C886000249BA, 0x000191BF0004AC87, 0x000241BD000249BE, 0x80007326000249BC, 0x8000739E000551A3, 0x00057DA680007396, 
0x800073A6800073A2, 0x00058DAA000575A5, 0x800073AA000595AB, 0x00058DAE800073AE, 0x00058DAC000655AF, 0x00078980000585AD, 0x0007998200078981, 0x800073B2000691B3, 
0x0006A9B60006B9B5, 0x800073BA800073B6, 0x00074DBA800073BE, 0x00075DBC000745BB, 0x000741BE000741BD, 0x000641A8000741BF, 0x000655AA00064DA9, 0x00067DAC000665AB, 
0x00066DAE000665AD, 0x800073C2000665AF, 0x800073CA800073C6, 0x800073D2800073CE, 0x800073DA800073D6, 0x000759B8800073DE, 0x000769BA000759B9, 0x000779BC000769BB, 
0x000765BE000779BD, 0x0007C5B0000719BF, 0x0007C5B20007CDB1, 0x0007C9B40007D9B3, 0x000769B60007C9B5, 0x0007DDA3000769B7, 0x800073E6800073E2, 0x800073EE800073EA, 
0x0007F5A50007E5A6, 0x000609AB800073F2, 0x800073F6000601AA, 0x00060DAF800073FA, 0x00060DAD00060DAE, 0x00006D80000611AC, 0x0000198200000981, 0x80007402800073FE, 
0x000190BE00019884, 0x0000C08680007406, 0x8000740A0001E487, 0x800074128000740E, 0x8000741A80007416, 0x00065DA88000741E, 0x00019DAA00018DA9, 0x0001B9AC000195AB, 
0x0001C9AE0001B9AD, 0x0000A0840001C1AF, 0x8000742680007422, 0x8000742E8000742A, 0x8000743680007432, 0x000179B88000743A, 0x0000CDBA000179B9, 0x0000DDBC0000C5BB, 
0x0000C5BE0000C5BD, 0x000181B00000F5BF, 0x000149B2000181B1, 0x000159B4000149B3, 0x000149B6000159B5, 0x000215B3000149B7, 0x800074428000743E, 0x8000744A80007446, 
0x000231B5000239B6, 0x000245BB8000744E, 0x80007452000245BA, 0x00029DBF80007456, 0x00029DBD00029DBE, 0x003E7C8500029DBC, 0x8000745A000251A3, 0x00027DA68000745E, 
0x8000746680007462, 0x000201AA000275A5, 0x8000746A000201AB, 0x0002D9AE8000746E, 0x0002D9AC0002D9AF, 0x0000E9800002D9AD, 0x000005820000E981, 0x000C00BE80007472, 
0x0003A8878000747A, 0x8000747E000CBC86, 0x8000748680007482, 0x8000748E8000748A, 0x8000749680007492, 0x8000749E8000749A, 0x800074A6800074A2, 0x000160E3800074AA, 
0x0001A0E1800074AE, 0x000288EF800074B2, 0x800074BA800074B6, 0x800074C2800074BE, 0x800074CA800074C6, 0x000269A8800074CE, 0x000279AA000269A9, 0x000269AC000279AB, 
0x0002BDAE000269AD, 0x000CACBE0002B5AF, 0x800074D6800074D2, 0x00001D80800074DA, 0x0000A98200000981, 0x000151B8800074DE, 0x000161BA000159B9, 0x000119BC000161BB, 
0x00010DBE000119BD, 0x0002CDB0000105BF, 0x0002DDB20002D5B1, 0x0002CDB40002D5B3, 0x000171B6000171B5, 0x0000C4E3000171B7, 0x000678E100077CE1, 0x800074E20006BCE3, 
0x000CB886000D1884, 0x000F2CBE000D3C87, 0x800074EE800074EA, 0x000010EF800074F2, 0x800074FA800074F6, 0x800074FE000674EF, 0x8000750680007502, 0x8000750A0002BDB3, 
0x0002A5B60002ADB5, 0x800075128000750E, 0x000245BA80007516, 0x000245BC00025DBB, 0x000245BE00024DBD, 0x800074760001F9BF, 0x000D75A6000D7DA5, 0x8000751A800074E6, 
0x800075228000751E, 0x000D95AC000D6DA3, 0x000D95AE000D9DAD, 0x80007526000E29AF, 0x000D95AA8000752A, 0x000EE5B3000D8DAB, 0x800075328000752E, 0x8000753A80007536, 
0x000EF5B5000EE5B6, 0x000EA1BB8000753E, 0x80007542000ED9BA, 0x000EA5BF80007546, 0x000EB1BD000EB9BE, 0x000E15A8000EB9BC, 0x000E2DAA000E25A9, 0x000E3DAC000E25AB, 
0x000E2DAE000E25AD, 0x00000D80000E25AF, 0x00001D8200001581, 0x8000754E8000754A, 0x0003308480007552, 0x000E29B880007556, 0x000E39BA000E29B9, 0x000E29BC000E39BB, 
0x000FFDBE000E29BD, 0x000E5DB0000FF5BF, 0x000E2DB2000E25B1, 0x000E3DB4000E25B3, 0x000E25B6000E21B5, 0x000FA5A3000E19B7, 0x000128868000755A, 0x8000755E00014C87, 
0x000FB5A5000FA5A6, 0x000FE1AB80007562, 0x80007566000F99AA, 0x000FE5AF8000756A, 0x000FF1AD000FF9AE, 0x8000756E000FF9AC, 0x80007572000EE9B3, 0x000E91B680007576, 
0x8000757E8000757A, 0x000EB1BA000EE5B5, 0x80007582000EB9BB, 0x000161BE80007586, 0x000E99BC000161BF, 0x000E25A8000E99BD, 0x000E25AA000E2DA9, 0x000E29AC000E39AB, 
0x000E5DAE000E55AD, 0x8000758A000E55AF, 0x800075928000758E, 0x8000759A80007596, 0x800075A28000759E, 0x0001F5B8800075A6, 0x000181BA000181B9, 0x000181BC000181BB, 
0x0001B1BE000189BD, 0x000E31B00001B1BF, 0x000E09B2000E39B1, 0x0001E1B4000E09B3, 0x0001E1B60001E1B5, 0x000DADA30001CDB7, 0x800075AE800075AA, 0x800075B6800075B2, 
0x000DA1A5000DD5A6, 0x000DFDAB800075BA, 0x800075BE000DF5AA, 0x000225AF800075C2, 0x000DDDAD000225AE, 0x00005D80000DDDAC, 0x0000658200006D81, 0x00039CBE000351B3, 
0x000319B6000379B5, 0x0002E084800075CA, 0x00033DBA800075CE, 0x000319BC000335BB, 0x0003D9BE000319BD, 0x000385A80003D9BF, 0x000395AA000395A9, 0x0003BDAC0003A5AB, 
0x0003D1AE0003D5AD, 0x000400860003D1AF, 0x0033A0BF00033487, 0x800075D6800075D2, 0x800075DE800075DA, 0x000371B8800075E2, 0x000371BA000371B9, 0x0000D5BC000371BB, 
0x0000D5BE0000DDBD, 0x0003B5B00000CDBF, 0x000381B20003BDB1, 0x000351B4000381B3, 0x000351B6000351B5, 0x0003A8EF000351B7, 0x800075EA800075E6, 0x00021C84800075EE, 
0x800075F6800075F2, 0x00052CBE800075FA, 0x80007602800075FE, 0x000340E380007606, 0x000028E18000760A, 0x00025DA38000760E, 0x8000761680007612, 0x8000761E8000761A, 
0x000275A5000215A6, 0x000239AB80007622, 0x80007626000231AA, 0x0002D5AF8000762A, 0x000215AD0002D5AE, 0x000128E3000215AC, 0x000E08E1000F00E1, 0x0000FD80000E08E3, 
0x0000398200000981, 0x800076328000762E, 0x8000763E8000763A, 0x000EE8EF80007642, 0x8000764A80007646, 0x00016DB3000E64EF, 0x0004E8868000764E, 0x8000765200050C87, 
0x00016DB500016DB6, 0x0000EDBB80007656, 0x8000765A0000EDBA, 0x0000D5BF8000765E, 0x0000E1BD0000E9BE, 0x00065DA80000E9BC, 0x0006A5AA000661A9, 0x0006A5AC0006BDAB, 
0x0006A5AE0006ADAD, 0x80007636000719AF, 0x8000766680007662, 0x8000766E8000766A, 0x8000767680007672, 0x000775B88000767A, 0x00070DBA000779B9, 0x00071DBC000705BB, 
0x000705BE000705BD, 0x000769B0000735BF, 0x00077DB2000769B1, 0x00076DB4000775B3, 0x000751B6000751B5, 0x00062DA3000751B7, 0x800076828000767E, 0x8000768A80007686, 
0x00062DA500062DA6, 0x0007ADAB8000768E, 0x800076920007ADAA, 0x000795AF80007696, 0x0007A1AD0007A9AE, 0x00000D800007A9AC, 0x00001D8200001581, 0x8000769E8000769A, 
0x00035484800076A2, 0x800076A600005CBE, 0x0000E886800076AA, 0x800076AE00034C87, 0x800076B6800076B2, 0x800076BE800076BA, 0x800076C2000404E3, 0x800076C60005B4E1, 
0x800076CE800076CA, 0x800076D6800076D2, 0x800076DE800076DA, 0x800076E6800076E2, 0x800076EA0004ECEF, 0x0006EDB3800076EE, 0x800076F6800076F2, 0x800076FE800076FA, 
0x0006E1B5000691B6, 0x00068DBB80007702, 0x8000770600068DBA, 0x000141BF8000770A, 0x000151BD000159BE, 0x000625A8000159BC, 0x000625AA00062DA9, 0x000629AC000639AB, 
0x000649AE000651AD, 0x0000CD80000641AF, 0x0000198200000981, 0x800077128000770E, 0x000034BE00012C84, 0x0001FDB88000771A, 0x000141BA000141B9, 0x000141BC000141BB, 
0x000171BE000149BD, 0x000609B0000171BF, 0x0001CDB2000609B1, 0x0001DDB40001C5B3, 0x0001CDB60001C5B5, 0x003CA0860001C5B7, 0x8000771E00034487, 0x800077220005A1A3, 
0x0005DDA60005ADA5, 0x8000772A80007726, 0x0005C1AA003C28BE, 0x000215AC0005C1AB, 0x000215AE00021DAD, 0x000341B600020DAF, 0x800077328000772E, 0x800077360002B1B5, 
0x8000773A0002A1B3, 0x000345BE8000773E, 0x000375BC00034DBF, 0x000365BA00034DBD, 0x8000774200036DBB, 0x8000774A80007746, 0x800075C68000774E, 0x8000775680007752, 
0x8000775E8000775A, 0x000245A880007762, 0x00025DAA000255A9, 0x00024DAC000255AB, 0x0003B1AE0003B5AD, 0x0003D5B00003ADAF, 0x0003D5B20003DDB1, 0x0003F5B40003EDB3, 
0x0003F5B60003FDB5, 0x0003D9B80003EDB7, 0x0003ADBA0003D9B9, 0x0003BDBC0003A5BB, 0x0003A5BE0003A5BD, 0x0003F5A3000395BF, 0x8000776A80007766, 0x800077728000776E, 
0x0003E5A5000215A6, 0x000239AB80007776, 0x8000777A000231AA, 0x000219AF8000777E, 0x000219AD000211AE, 0x00006980000221AC, 0x0000058200006981, 0x8000778A80007782, 
0x800077928000778E, 0x00026C8400001CEF, 0x80007796000194E1, 0x8000779A0000C8E3, 0x003C58868000779E, 0x800077A2003D5087, 0x800077AA800077A6, 0x800077AE003D8484, 
0x800077B6800077B2, 0x003C6CBE0001B8EF, 0x800077BA000674E1, 0x800077BE000164E3, 0x800077C6800077C2, 0x0001D1B3800077CA, 0x800077D2800077CE, 0x800077DA800077D6, 
0x0001F9B5000191B6, 0x0001BDBB800077DE, 0x800077E20001BDBA, 0x000175BF800077E6, 0x000185BD000175BE, 0x003DBDA8000185BC, 0x003E19AA003E0DA9, 0x003E31AC003E11AB, 
0x003E51AE003E51AD, 0x80007786003E4DAF, 0x00001D8100001D82, 0x800077EA00001D80, 0x800077F2800077EE, 0x003ED5B8800077F6, 0x003ED5BA003EDDB9, 0x003F59BC003F49BB, 
0x003F49BE003F59BD, 0x003E39B0003F41BF, 0x003E11B2003E39B1, 0x003EF1B4003E11B3, 0x003EF5B6003EF1B5, 0x003E91A3003EEDB7, 0x00002886800077FA, 0x800077FE0003C087, 
0x003EB9A5003ED1A6, 0x003EFDAB80007802, 0x80007806003EFDAA, 0x003E35AF8000780A, 0x003EC5AD003E35AE, 0x8000780E003EC5AC, 0x80007812003F9DB3, 0x003FA5B680007816, 
0x8000781E8000781A, 0x003F69BA003FADB5, 0x80007822003F75BB, 0x003F59BE80007826, 0x003F6DBC003F45BF, 0x8000782A003F65BD, 0x800078328000782E, 0x003C60E380007836, 
0x003D00E18000783A, 0x003DFCEF8000783E, 0x8000784680007842, 0x8000784E8000784A, 0x8000785680007852, 0x003E19A38000785A, 0x0000198100001982, 0x8000785E00007180, 
0x003E29A5003E21A6, 0x003EF1AB80007862, 0x00012484003EEDAA, 0x003EC1AF000124BE, 0x003EE1AD003EDDAE, 0x003ED1A8003EE9AC, 0x003ED1AA003ED1A9, 0x003EE1AC003EE5AB, 
0x003E19AE003EE1AD, 0x00000086003E19AF, 0x8000786A00008487, 0x800078728000786E, 0x8000787A80007876, 0x003E7DB88000787E, 0x003E01BA003E01B9, 0x003E01BC003E01BB, 
0x003E31BE003E09BD, 0x003E69B0003E31BF, 0x003E7DB2003E75B1, 0x003E59B4003E75B3, 0x003E4DB6003E45B5, 0x000285A8003E45B7, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x800078820002D1AF, 0x8000788A80007886, 0x8000788E01E624BF, 0x8000789680007892, 0x000355B88000789A, 0x00036DBA000359B9, 0x00037DBC000365BB, 
0x00036DBE000365BD, 0x0002B5B0000365BF, 0x000281B20002BDB1, 0x000371B4000281B3, 0x000371B6000371B5, 0x00021DB3000371B7, 0x800078A28000789E, 0x00038884800078A6, 
0x000235B5000255B6, 0x000279BB80007716, 0x800078AA000271BA, 0x0003B5BF800078AE, 0x000255BD0003B5BE, 0x800078B2000255BC, 0x800078B6000259A3, 0x000211A6800078BA, 
0x800078C2800078BE, 0x000235AA000271A5, 0x800078C600023DAB, 0x0003F1AE800078CA, 0x000211AC0003F1AF, 0x0002A9A8000211AD, 0x0002B9AA0002A9A9, 0x0002A9AC0002B9AB, 
0x000139AE0002A9AD, 0x0001CD80000139AF, 0x0000198200000981, 0x800078D2800078CE, 0x800078DA0005B8BE, 0x0001E9B8800078DE, 0x000189BA0001E9B9, 0x00019DBC000185BB, 
0x000181BE000181BD, 0x000149B00001B5BF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x0001F1B60001F1B5, 0x000014EF0001F1B7, 0x0005A886800078E2, 0x800078E60005DC87, 
0x800078EA00045884, 0x800078EE003EC4EF, 0x800078F2003EC4E1, 0x0000C8E3003E30E3, 0x000128E1800078F6, 0x00027DB6800078FA, 0x80007902800078FE, 0x80007906000275B5, 
0x8000790A000265B3, 0x0001DDBE8000790E, 0x0001DDBC000161BF, 0x0001D9BA0001D5BD, 0x800079120001C5BB, 0x0005B1A380007916, 0x8000791A800078D6, 0x800079228000791E, 
0x0005A1A50005A9A6, 0x000611AB80007926, 0x8000792A00060DAA, 0x0006B5AF8000792E, 0x000601AD000609AE, 0x80007932000609AC, 0x8000793A80007936, 0x000019808000793E, 
0x0000058200001981, 0x00036CBE80007942, 0x0000C88680007946, 0x8000794A00031C87, 0x800079528000794E, 0x0007B9A880007956, 0x00070DAA0007B9A9, 0x000709AC00071DAB, 
0x000731AE000735AD, 0x0003A884000729AF, 0x8000795E8000795A, 0x8000796680007962, 0x8000796E8000796A, 0x0000C9B880007972, 0x0000D9BA0000C9B9, 0x0000F9BC0000D1BB, 
0x000099BE0000F9BD, 0x00075DB0000099BF, 0x000721B2000721B1, 0x000729B400073DB3, 0x000701B6000729B5, 0x000685B3000701B7, 0x8000797A80007976, 0x800079828000797E, 
0x000681B50006B5B6, 0x0006E5BB80007986, 0x8000798A000699BA, 0x0006EDBF8000798E, 0x0006E9BD0006EDBE, 0x800079920006F5BC, 0x8000799A80007996, 0x800079A28000799E, 
0x800079AA800079A6, 0x800079AE000490EF, 0x800079B20006DCE1, 0x000029800005ECE3, 0x0000118200001581, 0x000605A300017CBE, 0x00002886800079BA, 0x800079BE00014C87, 
0x000601A5000635A6, 0x000665AB800079C2, 0x800079C6000619AA, 0x00066DAF800079CA, 0x000669AD00066DAE, 0x800079CE000675AC, 0x800079D20001BDB3, 0x000179B6800079D6, 
0x800079DE800079DA, 0x000155BA000179B5, 0x800079E200015DBB, 0x0000F9BE800079E6, 0x000145BC0000F9BF, 0x000271A80000F9BD, 0x000271AA000271A9, 0x0002B5AC000271AB, 
0x0002B5AE0002BDAD, 0x000CEC840002ADAF, 0x800079EE800079EA, 0x800079F6800079F2, 0x800079FE800079FA, 0x000369B880007A02, 0x000309BA000369B9, 0x000319BC000309BB, 
0x000309BE000319BD, 0x0002D5B0000309BF, 0x0002D5B20002DDB1, 0x000379B4000369B3, 0x000369B6000379B5, 0x80007A06000361B7, 0x80007A0E80007A0A, 0x80007A120002F5A3, 
0x000231A6000231A5, 0x80007A1A80007A16, 0x00021DAA80007A1E, 0x00020DAC000215AB, 0x0003B1AE0003B1AD, 0x000061800003B1AF, 0x0000058200006181, 0x000CF08680007A22, 
0x000C10BE00036087, 0x8000786680007A2A, 0x80007A3280007A2E, 0x80007A3A80007A36, 0x80007A4280007A3E, 0x000285A880007A46, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x80007A4A0002D1AF, 0x80007A5280007A4E, 0x80007A5A80007A56, 0x80007A6280007A5E, 0x000175B880007A66, 0x000175BA00017DB9, 0x0001D5BC0001CDBB, 
0x0001C9BE0001DDBD, 0x0002B5B00001C1BF, 0x000281B20002BDB1, 0x000155B4000281B3, 0x000155B600015DB5, 0x000610E100014DB7, 0x00060CE3000C4884, 0x000C988480007A6A, 
0x80007A7280007A6E, 0x80007A7A80007A76, 0x80007A8280007A7E, 0x0000758180007A86, 0x000120EF00007580, 0x80007A8A00007582, 0x80007A9280007A8E, 0x000EB485000CC0BE, 
0x00005CEF000210E1, 0x000190E1001600E3, 0x000158E380007A9A, 0x80007A9E00073CEF, 0x0008008680007AA2, 0x000D9DB3000CB887, 0x80007AA680007A26, 0x80007AAE80007AAA, 
0x000DB5B5000DD5B6, 0x000DF9BB80007AB2, 0x80007AB6000DF1BA, 0x000E19BF80007ABA, 0x000DD5BD000E11BE, 0x80007ABE000DD5BC, 0x80007AC2000DD9A3, 0x000D91A680007AC6, 
0x80007ACE80007ACA, 0x000DB5AA000DF1A5, 0x80007AD2000DBDAB, 0x000E55AE80007AD6, 0x000D91AC000E5DAF, 0x000E5DA8000D91AD, 0x000E61AA000E61A9, 0x000E61AC000E61AB, 
0x000E61AE000E61AD, 0x80007ADA000E61AF, 0x80007AE280007ADE, 0x80007AEA80007AE6, 0x80007AF280007AEE, 0x000F4DB880007AF6, 0x000F51BA000F51B9, 0x000F71BC000F51BB, 
0x000F71BE000F71BD, 0x000FC1B0000F71BF, 0x000FC1B2000FC1B1, 0x000FC1B4000FC1B3, 0x000FC1B6000FC1B5, 0x000FE9B3000FC1B7, 0x000180BE80007AFA, 0x80007A9680007AFE, 
0x000FE9B5000FE1B6, 0x000E05BB80007B02, 0x80007B0A000E05BA, 0x000E05BF80007B06, 0x000E15BD000E05BE, 0x00004D81000E15BC, 0x000D68EF00004180, 0x0007F08600005182, 
0x80007B0E0001D487, 0x80007B1680007B12, 0x80007B1A00017084, 0x000EE0E180007B1E, 0x000D48E380007B22, 0x000F69A380007B26, 0x80007B2E80007B2A, 0x80007B3680007B32, 
0x000F69A5000F61A6, 0x000E85AB80007B3A, 0x80007B3E000E85AA, 0x000E85AF80007B42, 0x000E95AD000E85AE, 0x80007B46000E95AC, 0x80007B4A000E31B3, 0x0001C1B680007B4E, 
0x80007B5680007B52, 0x0001CDBA0001D1B5, 0x80007B5A0001A5BB, 0x0001A5BE80007B5E, 0x0001B1BC0001ADBF, 0x0026DD8F0001B1BD, 0x80007B62000DF1A3, 0x000201A680007B66, 
0x80007B6E80007B6A, 0x00020DAA000211A5, 0x80007B72000265AB, 0x000265AE000420BE, 0x000271AC00026DAF, 0x000CA19F000271AD, 0x000A699D000A799E, 0x0036B19B0008D19C, 
0x0034D1990036759A, 0x00326D970032E198, 0x003F359500326596, 0x003E7193003E6194, 0x003A7191003B3592, 0x00009580003A7990, 0x0000A18200009D81, 0x000244EF80007B7A, 
0x80007B7E000F74E1, 0x0001D4E3000F1CE3, 0x0001E0E180007B82, 0x0002B5A300015CEF, 0x000EDDA1000041A2, 0x0003A9B5000EB9A0, 0x0004C08480007B86, 0x0005F0860003A1B6, 
0x000385B30004E487, 0x000371BD80007B8A, 0x000341BF000369BC, 0x80007B8E000371BE, 0x000371BB800079B6, 0x0027DD82000379BA, 0x000784BE003B0183, 0x003F11860006C0BE, 
0x003B1184003F1987, 0x003E7D8A003A5D85, 0x80007B920033258B, 0x0035B98E80007B96, 0x0033358C0037158F, 0x0037A1920033818D, 0x0019C4BE0009D993, 0x000DB19680007B9A, 
0x000B7994000F5197, 0x000F059A000B6195, 0x80007B9E0001919B, 0x80007BA680007BA2, 0x00037D9C000000DD, 0x000F48E180007BAA, 0x000E1CE380007BAE, 0x80007BB680007BB2, 
0x80007BBE80007BBA, 0x001741B180007BC2, 0x01EBA9B30017A1B0, 0x01EC01B501E801B2, 0x000E8CEF01EB11B4, 0x001FC5A980007BC6, 0x001001AB001C01A8, 0x0013D9AD001F91AA, 
0x0017D9AF0013D1AC, 0x0002F1A1001305AE, 0x0007C9A380007BCA, 0x001801A50002C1A2, 0x001BA1A7000765A4, 0x000529A8001BF9A6, 0x000555AA00055DA9, 0x000579AC00056DAB, 
0x00056DAE000579AD, 0x80007B76000561AF, 0x80007BD280007BCE, 0x00000D8080007BD6, 0x0000B1820000B181, 0x000589B880007BDA, 0x00059DBA000589B9, 0x0005B9BC000595BB, 
0x000651BE0005B9BD, 0x0005E5B0000651BF, 0x0005E5B20005EDB1, 0x0005EDB40005FDB3, 0x0005D5B60005DDB5, 0x0005DDA30005BDB7, 0x80007BE280007BDE, 0x80007BE600000C84, 
0x0005F1A50005F9A6, 0x000529AB80007BEA, 0x00009886000521AA, 0x000519AF0000A087, 0x000529AD000529AE, 0x80007BEE000531AC, 0x80007BF2000661B3, 0x000621B680007BF6, 
0x80007BFE80007BFA, 0x0007ADBA000601B5, 0x80007C0200078DBB, 0x00078DBE80007C06, 0x000795BC000771BF, 0x0005B9BE00078DBD, 0x0005B9BC0005B9BF, 0x0005B9BA0005B9BD, 
0x0005B9B80005B9BB, 0x000549B60005B9B9, 0x00057DB4000549B7, 0x000579B2000575B5, 0x000515B0000579B3, 0x00055DAE00057DB1, 0x000545AC00056DAF, 0x000AA5AA00055DAD, 
0x000ABDA800055DAB, 0x80007C0A000AADA9, 0x80007C1280007C0E, 0x80007C1A80007C16, 0x80007C2280007C1E, 0x00070DA880007C26, 0x00072DAA00071DA9, 0x00074DAC000749AB, 
0x0006B1AE000765AD, 0x80007C2A0006B1AF, 0x80007C3280007C2E, 0x80007C3A80007C36, 0x80007C4280007C3E, 0x000655B880007C46, 0x000655BA00065DB9, 0x000635BC000671BB, 
0x0001F1BE0001F1BD, 0x0006ADB00001F1BF, 0x000685B200068DB1, 0x00068DB400069DB3, 0x000675B6000671B5, 0x0004A5A300066DB7, 0x0000158100002D82, 0x80007C4A00001D80, 
0x0004C5A50004E5A6, 0x000549AB80007C4E, 0x80007C52000569AA, 0x0005B5AF80007C5A, 0x000549AD000549AE, 0x001C6086000551AC, 0x80007C5E00030887, 0x80007C62000285B3, 
0x000281B6000281B5, 0x80007C6A80007C66, 0x000309BA80007C6E, 0x000319BC000309BB, 0x000309BE000319BD, 0x000255AC000309BF, 0x000261AE00025DAD, 0x00020DA8000261AF, 
0x000251AA000255A9, 0x0003AC84000251AB, 0x80007C7680007C72, 0x001DFC8480007C7A, 0x80007C8280007C7E, 0x000371BC80007C86, 0x000371BE000371BD, 0x000371B8000371BF, 
0x000371BA000371B9, 0x000391B4000371BB, 0x000391B6000391B5, 0x000391B0000391B7, 0x000391B2000391B1, 0x80007C8A000391B3, 0x80007C9280007C8E, 0x80007C9A80007C96, 
0x80007C9E0001A4E1, 0x001C68BE000180E3, 0x80007CA680007CA2, 0x80007CAA0006D8EF, 0x80007CB280007CAE, 0x000389A380007CB6, 0x0000158100002D82, 0x80007CBA00001D80, 
0x00038DA500038DA6, 0x000205AB80007CBE, 0x80007CC2000205AA, 0x000205AF80007CCA, 0x000215AD000205AE, 0x001C2086000215AC, 0x80007CCE001DC487, 0x80007CD680007CD2, 
0x80007CDE80007CDA, 0x80007CE200066CEF, 0x80007CE600076CE1, 0x80007CEA000774E3, 0x80007CF280007CEE, 0x000191B380007CF6, 0x80007CFE80007CFA, 0x80007D0680007D02, 
0x0001B9B50001B1B6, 0x000155BB80007D0A, 0x80007D0E000149BA, 0x0000F5BF80007D12, 0x000145BD0000F5BE, 0x001E51A3000145BC, 0x80007D1680007CC6, 0x80007D1E80007D1A, 
0x001E79A5001E71A6, 0x001E95AB80007D22, 0x80007D26001E89AA, 0x001F35AF80007D2A, 0x001E85AD001F35AE, 0x00006D80001E85AC, 0x00001D8200001581, 0x80007D2E0019FCEF, 
0x80007D3680007D32, 0x0000C08680007D3A, 0x80007D3E0003AC87, 0x80007D4680007D42, 0x80007D4A001C2CE1, 0x001EADA8001CCCE3, 0x001ED9AA001ECDA9, 0x001EF1AC001ED1AB, 
0x001E3DAE001EF1AD, 0x0000EC84001E35AF, 0x80007D5280007D4E, 0x80007D5A80007D56, 0x80007D6280007D5E, 0x001FD1B880007D66, 0x001FEDBA001FDDB9, 0x001FE1BC001FE5BB, 
0x001FE1BE001FE1BD, 0x001E4DB0001FE1BF, 0x001E51B2001E51B1, 0x001FF1B4001E51B3, 0x001FF1B6001FF1B5, 0x001E6DA8001FF1B7, 0x001E85AA001E8DA9, 0x001E85AC001E9DAB, 
0x001EB9AE001E8DAD, 0x80007D6A001EB5AF, 0x80007D7280007D6E, 0x80007D7A80007D76, 0x80007D8280007D7E, 0x001E9DB880007D86, 0x001EA5BA001EADB9, 0x00015DBC000145BB, 
0x000145BE000145BD, 0x001ED1B0000175BF, 0x001ED1B2001ED1B1, 0x001EB5B4001ED1B3, 0x001EB5B6001EBDB5, 0x001E0DB3001EADB7, 0x80007D8E80007D8A, 0x80007D9680007D92, 
0x001E0DB5001E0DB6, 0x001E15BB80007D9A, 0x80007D9E001E15BA, 0x001E79BF80007DA2, 0x001E05BD001E71BE, 0x00006D82001E05BC, 0x00005580001E49A3, 0x001E49A600006581, 
0x80007DAA00019CBE, 0x001E51AA001E49A5, 0x00007C87001E51AB, 0x001E35AE00004C86, 0x001E41AC001E3DAF, 0x00025DA8001E41AD, 0x000265AA00026DA9, 0x000269AC00027DAB, 
0x0002B1AE0002B1AD, 0x0004EC840002B1AF, 0x80007DB280007DAE, 0x80007DBA80007DB6, 0x80007DC280007DBE, 0x000371B880007DC6, 0x000371BA000371B9, 0x0003D5BC000371BB, 
0x0003D5BE0003DDBD, 0x0002D1B00003CDBF, 0x0002D1B20002D1B1, 0x000351B40002D1B3, 0x000351B6000351B5, 0x0002EDB3000351B7, 0x80007DCE80007DCA, 0x80007DD2000480BE, 
0x0002E1B5000231B6, 0x000215BB80007DD6, 0x80007DDA000215BA, 0x000395BF80007DDE, 0x000205BD000395BE, 0x80007DE2000205BC, 0x80007DE60002A9A3, 0x000275A680007DEA, 
0x80007DF280007DEE, 0x000251AA0002A5A5, 0x80007DF6000251AB, 0x0003D1AE80007DFA, 0x000241AC0003D1AF, 0x0002D9A8000241AD, 0x000121AA000121A9, 0x000121AC000121AB, 
0x000121AE000121AD, 0x80007DFE000121AF, 0x80007E0680007E02, 0x80007E0A000420BE, 0x80007E1280007E0E, 0x00018DB880007E1A, 0x000191BA000191B9, 0x0001BDBC0001A5BB, 
0x00007DBE000075BD, 0x0001E5B0000075BF, 0x0001F9B20001EDB1, 0x0001D9B40001F1B3, 0x0001B9B60001D9B5, 0x001E18E10001B5B7, 0x001F28E380007E1E, 0x0000A58180007E22, 
0x80007E260000A580, 0x000400860000A582, 0x80007E2A0005F487, 0x80007E3280007E2E, 0x001E60EF80007E36, 0x80007E3E80007E3A, 0x01F4F08580007E42, 0x80007E4A80007E46, 
0x80007E4E000164E3, 0x80007E520001A4E1, 0x80007E560000C8EF, 0x80007C5680007E5A, 0x80007E5E0005FC84, 0x000629B380007E62, 0x80007E6680007E16, 0x80007E6E80007E6A, 
0x000629B5000621B6, 0x0006A9BB80007E72, 0x80007E760006A1BA, 0x00069DBF80007E7A, 0x0006A5BD00069DBE, 0x0007B4E10006ADBC, 0x000478E380007E7E, 0x00007D8080007E82, 
0x0000158200001181, 0x0000C08680007E86, 0x80007E8A00035887, 0x80007E9280007E8E, 0x00040CEF80007E96, 0x0006A9A380007E9A, 0x80007EA280007E9E, 0x80007EAA80007EA6, 
0x0006A9A50006A1A6, 0x000629AB80007EAE, 0x80007EB2000621AA, 0x00061DAF80007EB6, 0x000625AD00061DAE, 0x80007EBA00062DAC, 0x80007EBE000749B3, 0x00077DB680007EC2, 
0x80007ECA80007EC6, 0x00075DBA000775B5, 0x80007ECE000725BB, 0x000721BE80007ED2, 0x00073DBC00072DBF, 0x00063DA8000731BD, 0x000685AA000681A9, 0x0006B9AC000695AB, 
0x0006A9AE0006B9AD, 0x80007ED60006A9AF, 0x80007EDE80007EDA, 0x80007EE680007EE2, 0x0000B1810000B982, 0x0006ADB80000B980, 0x0006B5BA0006BDB9, 0x00015DBC000145BB, 
0x000145BE000145BD, 0x0006DDB0000175BF, 0x0006ADB20006A5B1, 0x0006A1B40006A1B3, 0x000699B60006ADB5, 0x00060DA3000695B7, 0x80007EEE80007EEA, 0x0002988480007EF2, 
0x000631A5000639A6, 0x000661AB00019CBE, 0x00000886000619AA, 0x000669AF00017C87, 0x000675AD000665AE, 0x80007EFA000679AC, 0x80007EFE0001B5B3, 0x000155B680007F02, 
0x80007F0A80007F06, 0x000171BA0001A1B5, 0x80007F0E000179BB, 0x000131BE80007F12, 0x000151BC00013DBF, 0x000269A8000151BD, 0x000279AA000269A9, 0x00026DAC000279AB, 
0x000291AE000291AD, 0x80007F16000291AF, 0x80007F1E80007F1A, 0x80007F2680007F22, 0x80007F2E80007F2A, 0x000299B880007F32, 0x0002A5BA0002ADB9, 0x000375BC00036DBB, 
0x000375BE00037DBD, 0x0002F1B000036DBF, 0x0002C1B20002F9B1, 0x0002B1B40002C1B3, 0x0002B5B60002BDB5, 0x80007F360002A9B7, 0x80007F3E80007F3A, 0x80007F420002FDA3, 
0x00021DA60002E9A5, 0x80007F4A80007F46, 0x000239AA80007F4E, 0x000219AC000231AB, 0x000279AE000219AD, 0x80007F52000275AF, 0x80007F5A80007F56, 0x00001980000C0084, 
0x0000398200000981, 0x80007F6280007F5E, 0x80007F6E80007F6A, 0x80007F72000CE0BE, 0x000D588680007F76, 0x0002C1A800030C87, 0x0002C5AA0002CDA9, 0x0002C9AC0002D9AB, 
0x0002F5AE0002FDAD, 0x80007F7A00013DAF, 0x80007F8280007F7E, 0x80007F8A80007F86, 0x80007F9280007F8E, 0x0001C5B8000C30BE, 0x0001D9BA0001CDB9, 0x0001F1BC0001D1BB, 
0x000199BE0001F1BD, 0x000145B0000199BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 0x000638E10001FDB7, 0x00066CE380007F96, 0x80007F9E80007F9A, 
0x80007FA680007FA2, 0x000DA88480007FAA, 0x80007FB280007FAE, 0x000FB0BE80007FB6, 0x00066CEF80007FBA, 0x80007FC280007FBE, 0x80007FC680007DA6, 0x000050E380007FCA, 
0x0001A0E180007FCE, 0x000084EF80007FD2, 0x000D208780007FDA, 0x00003D80000F4C86, 0x0000258200002181, 0x000DCDB380007FDE, 0x80007FD680007F66, 0x80007FE680007FE2, 
0x000DC1B5000DFDB6, 0x000E09BB80007FEA, 0x80007FEE000E01BA, 0x000E09BF80007FF2, 0x000E09BD000E01BE, 0x80007FF6000E11BC, 0x80007FFA000C98E3, 0x80007FFE000FFCE1, 
0x8000800680008002, 0x8000800E8000800A, 0x8000801680008012, 0x8000801E8000801A, 0x80008022000C60EF, 0x000D4DA380008026, 0x8000802E8000802A, 0x8000803680008032, 
0x000D41A5000D7DA6, 0x000E89AB8000803A, 0x8000803E000E81AA, 0x000E89AF80008042, 0x000E89AD000E81AE, 0x00006D82000E91AC, 0x00005580000E35B3, 0x000FF5B600006581, 
0x800080460003DC84, 0x000FD1BA000FFDB5, 0x00040086000FD1BB, 0x000F7DBE0000DC87, 0x000FC1BC000F65BF, 0x000FE5A8000F79BD, 0x000FF9AA000FEDA9, 0x000E31AC000FF9AB, 
0x000E31AE000E31AD, 0x8000804A000E31AF, 0x800080528000804E, 0x8000805A80008056, 0x800080628000805E, 0x000EDDB880008066, 0x000EE1BA000EE1B9, 0x000EE5BC000EE1BB, 
0x000E99BE000EE9BD, 0x000E51B0000E95BF, 0x000E51B2000E51B1, 0x000EFDB4000EE9B3, 0x000EEDB6000EE5B5, 0x000F71A3000EE5B7, 0x8000806E8000806A, 0x8000807680008072, 
0x000EB9A5000EB1A6, 0x000E95AB8000807A, 0x8000807E000E95AA, 0x000E21AF80008082, 0x000E3DAD000E39AE, 0x80008086000E85AC, 0x8000808A0001C9B3, 0x0001F9B68000808E, 
0x8000809680008092, 0x0001A9BA0001C1B5, 0x8000809A0001B5BB, 0x0001ADBE8000809E, 0x0001ADBC000195BF, 0x000DE5A80001A5BD, 0x000205AA000DF9A9, 0x00020DAC00021DAB, 
0x000235AE00023DAD, 0x800080A200025DAF, 0x800080AA800080A6, 0x00001980800080AE, 0x0000058200001981, 0x00022DB8800080B2, 0x000231BA000235B9, 0x0002D5BC000231BB, 
0x0002D5BE0002DDBD, 0x000229B00002CDBF, 0x00023DB2000235B1, 0x00022DB4000235B3, 0x00021DB6000215B5, 0x800080BA000215B7, 0x800080BE00029C84, 0x800080C2000281A3, 
0x0002B1A6000289A5, 0x00042086800080C6, 0x0002E1AA0003D487, 0x0002E5AC0002FDAB, 0x0002E5AE0002EDAD, 0x0003F5B60002DDAF, 0x01FD8C85000344BE, 0x800080CA0003FDB5, 
0x800080CE0003FDB3, 0x00037DBE800080D2, 0x000365BC00034DBF, 0x000375BA00037DBD, 0x800080D600037DBB, 0x800080DE800080DA, 0x00020484800080E2, 0x800080E6000225A3, 
0x00022DA6000225A5, 0x800080EE800080EA, 0x0002ADAA800080F2, 0x0002BDAC0002A5AB, 0x0002A5AE0002A5AD, 0x800080F6000295AF, 0x800080FE800080FA, 0x8000810680008102, 
0x8000810A0003C0E3, 0x8000810E0001ACE1, 0x80008112000358EF, 0x00000D8080008116, 0x0000ED820000E581, 0x000F60E18000811A, 0x000E38E3000140E3, 0x8000811E000E78E1, 
0x000594BE80008122, 0x000400868000812A, 0x8000812E00056487, 0x8000813680008132, 0x000E7CEF000EFCEF, 0x000151B38000813A, 0x80007EF68000813E, 0x8000814680008142, 
0x000109B500010DB6, 0x0000E1BB8000814A, 0x8000814E000119BA, 0x0000D1BF80008152, 0x0000E9BD0000E9BE, 0x800080B60000F9BC, 0x8000815680008126, 0x8000815E8000815A, 
0x8000816680008162, 0x0006A1A88000816A, 0x0006B9AA0006ADA9, 0x0006E1AC0006B1AB, 0x0006E5AE0006EDAD, 0x0006BDB00006C5AF, 0x00074DB2000745B1, 0x00074DB400075DB3, 
0x00077DB6000775B5, 0x000725B800071DB7, 0x000725BA00072DB9, 0x000729BC00073DBB, 0x000711BE000715BD, 0x000611A3000711BF, 0x800081728000816E, 0x8000817A80008176, 
0x000649A500064DA6, 0x0007A1AB8000817E, 0x80008182000659AA, 0x000791AF80008186, 0x0007A9AD0007A9AE, 0x00000D800007B9AC, 0x00001D8200001581, 0x8000818E8000818A, 
0x0003948480008192, 0x80008196000394BE, 0x0000C8868000819A, 0x8000819E00008C87, 0x800081A6800081A2, 0x00069DA8800081AA, 0x0006A5AA0006ADA9, 0x0006ADAC0006BDAB, 
0x0006D5AE0006D1AD, 0x800081AE0006CDAF, 0x800081B6800081B2, 0x800081BE800081BA, 0x800081C6800081C2, 0x00015DB8800081CA, 0x0001C1BA0001C1B9, 0x0001C1BC0001C1BB, 
0x0001F1BE0001C9BD, 0x0006BDB00001F1BF, 0x000685B200068DB1, 0x00017DB4000165B3, 0x00016DB6000165B5, 0x00062DB3000165B7, 0x800081D2800081CE, 0x800081DA800081D6, 
0x000625B5000651B6, 0x000649BB800081DE, 0x800081E2000679BA, 0x0001A1BF800081E6, 0x0001B1BD0001B9BE, 0x800081EA000651BC, 0x800081EE000669A3, 0x000615A6800081F2, 
0x800081FA800081F6, 0x00063DAA000661A5, 0x800081FE00060DAB, 0x0001FDAE80008202, 0x000615AC0001E5AF, 0x0007D5BA0001F5AD, 0x0007C1B80007DDBB, 0x000431BE0007C1B9, 
0x0007F1BC000431BF, 0x0007ADB20007F1BD, 0x0007ADB00007B5B3, 0x00079DB60007A5B1, 0x0007A5B40007F5B7, 0x000769AA000795B5, 0x000769A8000769AB, 0x000769AE000769A9, 
0x000769AC000769AF, 0x0003B980000769AD, 0x0003858200038D81, 0x01FC50860003A884, 0x000334BE00030887, 0x000265A88000820A, 0x00027DAA000275A9, 0x00026DAC000275AB, 
0x0003BDAE0003B5AD, 0x8000820E0003B5AF, 0x8000821680008212, 0x8000821E8000821A, 0x8000822680008222, 0x000351B88000822A, 0x000361BA000359B9, 0x000311BC000361BB, 
0x000315BE00031DBD, 0x0003CDB0000309BF, 0x0003DDB20003D5B1, 0x0003CDB40003D5B3, 0x000371B6000371B5, 0x8000822E000371B7, 0x0003FDB380008232, 0x0003EDB580008236, 
0x8000823E8000823A, 0x8000824200023DB6, 0x000219BB80008246, 0x000209BD000201BA, 0x0002BDBF000201BC, 0x8000824A000201BE, 0x01FDC4848000824E, 0x8000825201FCC0BE, 
0x8000825A80008256, 0x8000825E0003DCEF, 0x80008262000194E1, 0x80008266000310E3, 0x0000ED810000ED82, 0x000638E10000ED80, 0x000140E300073CE1, 0x8000826A000694E3, 
0x800082728000826E, 0x01FC80868000827A, 0x8000827E01FDE887, 0x8000828680008282, 0x00019CEF8000828A, 0x000335A30006DCEF, 0x800082928000828E, 0x8000829A80008296, 
0x000325A50002F5A6, 0x0002D1AB8000829E, 0x800082A20002C9AA, 0x000275AF800082A6, 0x0002C1AD0002C9AE, 0x800082760002C9AC, 0x800082AE800082AA, 0x01FDA4EF800082B2, 
0x800082BA800082B6, 0x01FD78E3800082BE, 0x01FC40E1800082C2, 0x800082CA800082C6, 0x800082D2800082CE, 0x01FEE5B3800082D6, 0x0000158100002D82, 0x800082DA00001D80, 
0x01FEF5B501FEE5B6, 0x01FF61BB800082DE, 0x800082E201FED9BA, 0x01FF69BF0003E484, 0x01FF75BD01FF61BE, 0x01FEFDA801FF79BC, 0x01FE2DAA01FE25A9, 0x01FE3DAC01FE25AB, 
0x01FE2DAE01FE25AD, 0x00002CBE01FE25AF, 0x00008886800082E6, 0x800082EA0000EC87, 0x800082F2800082EE, 0x01FF81B8800082F6, 0x01FF99BA01FF81B9, 0x01FF89BC01FF99BB, 
0x01FFB1BE01FFB5BD, 0x01FE5DB001FFADBF, 0x01FFEDB201FFE5B1, 0x01FFE5B401FFE1B3, 0x01FFD9B601FFEDB5, 0x01FFA5A301FFD9B7, 0x800082FE800082FA, 0x8000830680008302, 
0x01FFB5A501FFA5A6, 0x01FE21AB8000830A, 0x8000830E01FF99AA, 0x01FE29AF80008312, 0x01FE35AD01FE21AE, 0x8000831601FE39AC, 0x8000831A01FEE9B3, 0x01FE95B68000831E, 
0x8000832680008322, 0x01FEB1BA01FEE9B5, 0x8000832A01FEB9BB, 0x000175BE8000832E, 0x01FE91BC00017DBF, 0x01FE1DA801FE91BD, 0x01FE25AA01FE2DA9, 0x01FE25AC01FE3DAB, 
0x01FE51AE01FE51AD, 0x8000833201FE51AF, 0x8000833A80008336, 0x800083428000833E, 0x8000834A80008346, 0x0001D9B88000834E, 0x0001EDBA0001D9B9, 0x0001E1BC0001E1BB, 
0x0001E1BE0001E1BD, 0x01FE31B00001E1BF, 0x01FE01B201FE39B1, 0x0001F5B401FE01B3, 0x0001F5B60001FDB5, 0x01FDADA30001E9B7, 0x00034CBE80008352, 0x8000835E8000835A, 
0x01FDADA501FDD1A6, 0x01FDFDAB80008362, 0x8000836601FDF5AA, 0x000239AF8000836A, 0x01FDD5AD000231AE, 0x0003F98001FDD5AC, 0x00004D820003F981, 0x8000836E00207485, 
0x0004D4840003D884, 0x0004408680008372, 0x8000837600035487, 0x8000837E8000837A, 0x8000838680008382, 0x000231A80005F0BE, 0x000231AA000231A9, 0x000395AC000231AB, 
0x000395AE00039DAD, 0x8000838A00038DAF, 0x800083928000838E, 0x00077C8480008396, 0x8000839E8000839A, 0x0003A9B8800083A2, 0x000369BA0003A9B9, 0x000379BC000369BB, 
0x000369BE000379BD, 0x0003FDB0000369BF, 0x0003C5B20003CDB1, 0x0003B9B40003ADB3, 0x0003ADB60003B9B5, 0x800083A60003A5B7, 0x800083AE800083AA, 0x800083B6800083B2, 
0x0003E8EF800083BA, 0x000190E1800083BE, 0x00036CE3800083C2, 0x00002580800083CA, 0x00001D8200002981, 0x0003F9B3800083CE, 0x00076886800083D2, 0x800083D600055C87, 
0x00025DB500025DB6, 0x000249BB800083DA, 0x800083DE000279BA, 0x00023DBF800083E2, 0x000239BD00023DBE, 0x800083E6000251BC, 0x000640BE01FE3CE1, 0x800083EA0001F0E3, 
0x800083F2800083EE, 0x800083FA800083F6, 0x80008402800083FE, 0x8000840680008206, 0x8000840E8000840A, 0x800084120001E4EF, 0x000371A380008416, 0x0002D5A58000841A, 
0x800084228000841E, 0x800084260002D5A6, 0x0002C1AB8000842A, 0x0002B1AD0002F1AA, 0x0002B5AF0002D9AC, 0x01FCDCE10002B5AE, 0x000450E3800083C6, 0x0007F580000488EF, 
0x00003D8200000981, 0x000124848000842E, 0x8000843680008432, 0x8000843E8000843A, 0x001CE4EF00044CE1, 0x00065DB3000474E3, 0x000C008680008442, 0x800084460003E087, 
0x000675B5000605B6, 0x000611BB8000844A, 0x8000844E000609BA, 0x0006D5BF80008452, 0x000601BD0006D5BE, 0x00068DA8000609BC, 0x000695AA000695A9, 0x0006BDAC0006A5AB, 
0x0006C5AE0006C5AD, 0x800084560006F5AF, 0x8000845E8000845A, 0x8000846680008462, 0x8000846E8000846A, 0x000675B880008472, 0x000675BA00067DB9, 0x0007D5BC0007CDBB, 
0x0007D5BE0007DDBD, 0x00068DB00007CDBF, 0x00069DB2000695B1, 0x000651B4000695B3, 0x000651B6000651B5, 0x00071DA3000651B7, 0x8000847601EC158F, 0x8000847E8000847A, 
0x000735A5000745A6, 0x000751AB80008482, 0x80008486000749AA, 0x000795AF8000848A, 0x000741AD000795AE, 0x01F9459E000749AC, 0x01FD919C01F9A59F, 0x01FD559A01F94D9D, 
0x01F1059801FD5D9B, 0x01F2A59601FE9599, 0x01F56D9401F16197, 0x01E9E19201F53595, 0x01EC559001F68593, 0x001DB1B101E95D91, 0x001989B3001DA5B0, 0x002401B5001C41B2, 
0x8000848E0019F5B4, 0x8000849680008492, 0x0003A1810003A982, 0x000515A200006980, 0x000615A0000205A3, 0x0001C5A10005BDA1, 0x000DCDA38000849A, 0x000801A50001E5A2, 
0x0009D1A7000DDDA4, 0x001401A90009D9A6, 0x0014C5AB0008A5A8, 0x0011D1AD0015CDAA, 0x001C01AF001001AC, 0x01EF1182001175AE, 0x8000849E01EF2983, 0x01F5E186800084A2, 
0x01EA398401F61187, 0x01F6798A01EA8D85, 0x000CA4BE01F1E18B, 0x01FDF98E800084AA, 0x01F23D8C01FE318F, 0x01FE499201F2618D, 0x000C088701FE9D93, 0x01FAB196000C6C86, 
0x01FA59940005F997, 0x0006619A01FA5995, 0x800084AE0006C19B, 0x800084B6800084B2, 0x0001C99C800084BA, 0x0005ADA8800084BE, 0x0005CDAA0005B9A9, 0x0005CDAC0005DDAB, 
0x0005F5AE0005FDAD, 0x800084C200051DAF, 0x800084CA800084C6, 0x800084D2800084CE, 0x800084DA800084D6, 0x000575B8800084DE, 0x000509BA00057DB9, 0x00051DBC000509BB, 
0x000501BE000501BD, 0x000571B000053DBF, 0x000571B2000571B1, 0x000551B4000571B3, 0x000551B6000551B5, 0x000445B300054DB7, 0x800084E6800084E2, 0x800084EE800084EA, 
0x000445B500047DB6, 0x0004B5BB800084F2, 0x800084F60004B5BA, 0x000495BF800084FA, 0x0004A5BD000495BE, 0x800084FE0004A5BC, 0x80008502000401A3, 0x000439A680008506, 
0x8000850E8000850A, 0x0004F1AA000401A5, 0x800085120004F1AB, 0x0004D1AE000DEC84, 0x0004E1AC0004D1AF, 0x0006D0E10004E1AD, 0x000728E3000C0C84, 0x8000851A000C00BE, 
0x000CB886000344EF, 0x8000851E000D2C87, 0x80008522000194E3, 0x800083560001FCE1, 0x0006C8EF80008526, 0x8000852E8000852A, 0x00038DB380008532, 0x00038DB580008536, 
0x8000853E8000853A, 0x800085420003B5B6, 0x000341BB80008546, 0x000341BD000349BA, 0x000341BF000359BC, 0x000C45A3000349BE, 0x80008516800084A6, 0x8000854E8000854A, 
0x000C45A5000C7DA6, 0x000C89AB80008552, 0x80008556000C81AA, 0x000C89AF8000855A, 0x000C89AD000C81AE, 0x000F1580000C91AC, 0x000F2182000F1D81, 0x8000855E000E21B3, 
0x000E25B6000E21B5, 0x8000856680008562, 0x000EC1BA8000856A, 0x000EC1BC000EC1BB, 0x000EC1BE000EC1BD, 0x000EADA8000EC1BF, 0x000EE5AA000EEDA9, 0x000EE5AC000EFDAB, 
0x000E39AE000EE9AD, 0x8000856E000E39AF, 0x8000857680008572, 0x00001D808000857A, 0x0001BD8200000981, 0x000FCDB88000857E, 0x000FD5BA000FD5B9, 0x000FFDBC000FE5BB, 
0x000F91BE000F95BD, 0x000E49B0000F91BF, 0x000E59B2000E49B1, 0x000E49B4000E59B3, 0x000FFDB6000E49B5, 0x000F6DA3000FF5B7, 0x000184BE80008582, 0x8000858E8000858A, 
0x000F6DA5000F69A6, 0x000F8DAB80008592, 0x00008886000F8DAA, 0x000F8DAF00016C87, 0x000F8DAD000F8DAE, 0x80008596000F8DAC, 0x8000859A000EEDB3, 0x000E91B68000859E, 
0x800085A6800085A2, 0x000EB5BA000EE1B5, 0x800085AA000EBDBB, 0x00017DBE800085AE, 0x000E99BC000165BF, 0x000E11A8000E99BD, 0x000E21AA000E25A9, 0x000E2DAC000E39AB, 
0x000E5DAE000E55AD, 0x0000A884000E51AF, 0x800085B6800085B2, 0x800085BE800085BA, 0x800085C6800085C2, 0x0001EDB8800085CA, 0x000195BA000195B9, 0x0001B5BC0001ADBB, 
0x00017DBE000175BD, 0x000E35B0000175BF, 0x000E09B2000E3DB1, 0x0001FDB4000E09B3, 0x0001E5B60001E5B5, 0x000DA9A30001D5B7, 0x800085D2800085CE, 0x800085DA800085D6, 
0x000DA5A5000DD5A6, 0x000DF9AB800085DE, 0x800085E2000DF1AA, 0x000221AF800085E6, 0x000DDDAD000239AE, 0x00000D80000DDDAC, 0x00001D8200001581, 0x800085EE800085EA, 
0x00039087800085F2, 0x0004ECBE00047C86, 0x800085FE800085FA, 0x8000860680008602, 0x8000860E8000860A, 0x000E2DB280008612, 0x000E2DB0000E35B3, 0x000E2DB6000E25B1, 
0x000E2DB4000F9DB7, 0x000FBDBA000E25B5, 0x000FA5B8000F8DBB, 0x000F2DBE000FBDB9, 0x000F95BC000F15BF, 0x80008616000F25BD, 0x8000861E8000861A, 0x8000862680008622, 
0x8000862E8000862A, 0x000EA5AA80008632, 0x000EC5A8000EB5AB, 0x000E9DAE000EDDA9, 0x000EA5AC000E55AF, 0x00020DA8000E95AD, 0x000215AA000215A9, 0x000259AC00024DAB, 
0x00024DAE000259AD, 0x0005A884000245AF, 0x8000863A80008636, 0x0004B8848000863E, 0x8000864680008642, 0x0002FDB88000864A, 0x000141BA000141B9, 0x000141BC000141BB, 
0x000171BE000149BD, 0x000209B0000171BF, 0x0002CDB2000209B1, 0x0002DDB40002C5B3, 0x0002CDB60002C5B5, 0x000FD4E10002C5B7, 0x000EF4E3000E10E3, 0x8000864E000E0CE1, 
0x8000865680008652, 0x8000865E8000865A, 0x000424BE80008662, 0x000000EC8000866A, 0x000ECCEF000044EF, 0x000065828000866E, 0x000055800002D9B3, 0x00029DB600006D81, 
0x8000867680008672, 0x000289BA000295B5, 0x0004A886000289BB, 0x00025DBE0004E087, 0x00025DBC000245BF, 0x00051DA3000255BD, 0x80008666800085F6, 0x8000867E8000867A, 
0x000551A5000559A6, 0x00054DAB80008682, 0x8000868600054DAA, 0x000581AF8000868A, 0x000591AD000599AE, 0x8000868E000599AC, 0x80008692000629B3, 0x000629B680008696, 
0x8000869E8000869A, 0x0006A5BA000629B5, 0x800086A20006ADBB, 0x0006A5BE800086A6, 0x0006B5BC0006ADBF, 0x0006E5A80006ADBD, 0x0006E5AA0006EDA9, 0x0006E5AC0006FDAB, 
0x0006E5AE0006EDAD, 0x800086AA00065DAF, 0x800086B2800086AE, 0x800086BA800086B6, 0x800086C2800086BE, 0x0007E9B8800086C6, 0x0007FDBA0007E9B9, 0x0007EDBC0007F5BB, 
0x00074DBE000745BD, 0x000625B0000745BF, 0x000625B200062DB1, 0x000625B400063DB3, 0x000625B600062DB5, 0x00076DA30007D9B7, 0x0000158100002D82, 0x800086CA00001D80, 
0x00076DA500076DA6, 0x0007E9AB800086CE, 0x800086D20007E1AA, 0x0007E9AF0001A0BE, 0x0007E9AD0007E1AE, 0x800086D60007F1AC, 0x0000E886000691B3, 0x000141B600012C87, 
0x800086DE800086DA, 0x00014DBA000151B5, 0x800086E2000125BB, 0x000125BE800086E6, 0x000131BC00012DBF, 0x0001ADB0000131BD, 0x0001C1B20001C5B1, 0x0001C5B40001C1B3, 
0x0001F1B60001CDB5, 0x000101B80001F1B7, 0x000101BA000101B9, 0x000101BC000101BB, 0x000101BE000101BD, 0x800086EA000101BF, 0x800086F2800086EE, 0x80008586800086F6, 
0x800086FE800086FA, 0x00064DA880008702, 0x00063DAA000659A9, 0x0001FDAC000635AB, 0x0001E5AE0001E5AD, 0x0005D5A30001D5AF, 0x8000870A80008706, 0x800087128000870E, 
0x000215A5000205A6, 0x000261AB80008716, 0x8000871A000209AA, 0x000269AF8000871E, 0x000275AD000261AE, 0x80008722000275AC, 0x8000872A80008726, 0x800087328000872E, 
0x80008736000564E1, 0x000011800005ECE3, 0x0000118200001181, 0x8000873A0006F4EF, 0x800087428000873E, 0x0002C484000330BE, 0x0003E1B38000874A, 0x000351B5001CC084, 
0x800087528000874E, 0x80008756000359B6, 0x000371BB8000875A, 0x0000B5BD000379BA, 0x0000B5BF000369BC, 0x8000875E0000B5BE, 0x80008762000194E1, 0x001C708600025CE3, 
0x8000876600034487, 0x8000876E8000876A, 0x8000877680008772, 0x8000877E8000877A, 0x8000878680008782, 0x000255A8000278EF, 0x000261AA00025DA9, 0x0002D1AC000261AB, 
0x0002D1AE0002D1AD, 0x8000878A0002D1AF, 0x800087928000878E, 0x8000879A80008796, 0x800087A28000879E, 0x000169B8800087A6, 0x000109BA000169B9, 0x000119BC000109BB, 
0x000109BE000119BD, 0x0002B5B0000105BF, 0x0002B5B20002BDB1, 0x000179B4000169B3, 0x000169B6000179B5, 0x0007C4E1000161B7, 0x0006B8E30006A4E3, 0x00000D8000067CE1, 
0x00003D8200003581, 0x800087AE800087AA, 0x001DE0BE800087B2, 0x800087BE800087BA, 0x0006E8EF000060EF, 0x0002A9A3800087C2, 0x800087CA800087C6, 0x800087D2800087CE, 
0x000219A5000211A6, 0x000239AB800087D6, 0x001C4886000231AA, 0x0001FDAF001CCC87, 0x0001FDAD0001FDAE, 0x001E85A8000221AC, 0x001E91AA001E91A9, 0x001EB5AC001EADAB, 
0x001ED1AE001ED5AD, 0x800087B6001EC5AF, 0x800087DE800087DA, 0x800087E6800087E2, 0x800087EE800087EA, 0x001F61B8800087F2, 0x001F61BA001F61B9, 0x001F61BC001F61BB, 
0x001F61BE001F61BD, 0x001EBDB0001F61BF, 0x001E8DB2001E85B1, 0x001E9DB4001E85B3, 0x001E8DB6001E85B5, 0x001E19B3001E85B7, 0x800087FA800087F6, 0x80008802800087FE, 
0x001E3DB5001E55B6, 0x001E41BB80008806, 0x8000880A001E79BA, 0x001E41BF8000880E, 0x001E51BD001E59BE, 0x80008812001E59BC, 0x80008816001E5DA3, 0x001E11A68000881A, 
0x800088228000881E, 0x001E3DAA001E79A5, 0x0003A484001E05AB, 0x001E1DAE0003A8BE, 0x001E1DAC001E05AF, 0x001EADA8001E15AD, 0x001EB5AA001EB5A9, 0x001ED9AC001EC9AB, 
0x001EC9AE001ED9AD, 0x0001ED80001EC1AF, 0x0001F1820001F181, 0x0000908680008826, 0x8000882A00017487, 0x0001C9B88000882E, 0x0001D9BA0001C9B9, 0x0001F9BC0001D1BB, 
0x000199BE0001F9BD, 0x000145B0000195BF, 0x000145B200014DB1, 0x000145B400015DB3, 0x000145B600014DB5, 0x001E3DB30001F9B7, 0x8000883680008832, 0x8000883E8000883A, 
0x001E51B5001E59B6, 0x000189BB80008842, 0x80008846000181BA, 0x000189BF8000884A, 0x000189BD000181BE, 0x8000884E000191BC, 0x001E75A380008852, 0x001E19A580008856, 
0x8000885E8000885A, 0x80008746001E11A6, 0x0001C1AB80008862, 0x0001C1AD0001C9AA, 0x0001C1AF0001D9AC, 0x800088660001C9AE, 0x8000886E8000886A, 0x8000887680008872, 
0x8000887A00021884, 0x800088828000887E, 0x8000888A80008886, 0x800088928000888E, 0x8000889E8000889A, 0x00006980000370BE, 0x0000798200006981, 0x0004F08600040084, 
0x800088A200037487, 0x800088A6001F0CEF, 0x800088AA001EACE1, 0x800088AE001EF0E3, 0x800088B6800088B2, 0x800088BE800088BA, 0x800088C6800088C2, 0x000254EF800088CA, 
0x800088D2800088CE, 0x0002A4E3800088D6, 0x000180E1800088DA, 0x800088E2800088DE, 0x800088EA800088E6, 0x000345B3800088EE, 0x800088F6800088F2, 0x800088FE800088FA, 
0x000355B5000345B6, 0x000321BB80008902, 0x0004A0BE000349BA, 0x000329BF8000890A, 0x000335BD000321BE, 0x000239A8000339BC, 0x00028DAA000239A9, 0x00029DAC000285AB, 
0x000285AE000285AD, 0x0001ED800002B5AF, 0x0001F5820001F581, 0x000490868000890E, 0x8000891200050487, 0x000145B880008916, 0x000145BA00014DB9, 0x000149BC00015DBB, 
0x000179BE000149BD, 0x0002CDB0000179BF, 0x0002ADB20002A5B1, 0x0002A5B40002A1B3, 0x00029DB60002ADB5, 0x8000891A00017DB7, 0x800089228000891E, 0x8000892A80008926, 
0x800089328000892E, 0x0004EC84000188EF, 0x80008936001E54E1, 0x8000893A000154E3, 0x800089428000893E, 0x000245A380008946, 0x8000894E8000894A, 0x8000895680008952, 
0x000255A5000245A6, 0x000221AB8000895A, 0x8000895E000249AA, 0x000229AF80008962, 0x000235AD000221AE, 0x000635A8000239AC, 0x000651AA00063DA9, 0x000679AC00066DAB, 
0x00066DAE000665AD, 0x80008906000665AF, 0x8000896A80008966, 0x000019808000896E, 0x0000058200001981, 0x0006E5B880008972, 0x0006F9BA0006E9B9, 0x0006E9BC0006F9BB, 
0x00069DBE0006E9BD, 0x00061DB0000695BF, 0x0006EDB20006E5B1, 0x0006FDB40006E5B3, 0x0006E1B60006E1B5, 0x0006D9B30006E1B7, 0x800089760003D0BE, 0x8000897E8000897A, 
0x0006F1B50006E5B6, 0x000621BB80008982, 0x000098860006D9BA, 0x000625BF00037887, 0x000631BD000639BE, 0x80008986000639BC, 0x8000898A00069DA3, 0x0006A1A68000898E, 
0x8000899680008992, 0x00069DAA0006B5A5, 0x8000899A000665AB, 0x00067DAE8000899E, 0x00067DAC000661AF, 0x0007EDA8000675AD, 0x000631AA000629A9, 0x000691AC000631AB, 
0x000691AE000691AD, 0x800089A2000691AF, 0x800089AA800089A6, 0x800089B2800089AE, 0x800089BA800089B6, 0x000685B8800089BE, 0x000685BA00068DB9, 0x00068DBC00069DBB, 
0x0006B5BE0006BDBD, 0x0006F1B0000179BF, 0x0006F1B20006F1B1, 0x0006C1B40006C5B3, 0x0006C1B60006C1B5, 0x0006B9B30006C1B7, 0x800089C6800089C2, 0x800089CE800089CA, 
0x000619B5000611B6, 0x000635BB800089D2, 0x800089D6000635BA, 0x000605BF800089DA, 0x000611BD000605BE, 0x000641A5000625BC, 0x800089E2800089DE, 0x00001581000649A6, 
0x0006E1A300007980, 0x000649AD00001582, 0x00065DAF00067DAC, 0x0001348400065DAE, 0x00066DAB80008896, 0x0003CCBE00066DAA, 0x000295B3800089EA, 0x0002D9B5800089EE, 
0x800089F6800089F2, 0x000C80860002D1B6, 0x0002C5BB00033887, 0x000315BD0002C5BA, 0x000315BF000315BC, 0x800089FA000315BE, 0x000658EF800089FE, 0x80008A0200034084, 
0x80008A0A80008A06, 0x80008A1280008A0E, 0x80008A1A80008A16, 0x000638E180008A1E, 0x000624E380008A22, 0x000249AC000C70BE, 0x00025DAE000249AD, 0x00021DA8000255AF, 
0x000205AA000205A9, 0x000CA88400025DAB, 0x80008A2A80008A26, 0x000DBCBE80008A2E, 0x80008A3680008A32, 0x00034DBC80008A3A, 0x000355BE000355BD, 0x0003E9B8000365BF, 
0x00035DBA0003E9B9, 0x0003C9B4000355BB, 0x0003D9B60003C9B5, 0x000219B00003D9B7, 0x0003D9B2000219B1, 0x80008A3E0003D9B3, 0x80008A420000E4E3, 0x80008A460001BCE1, 
0x00003D8100003D82, 0x80008A4A00003D80, 0x80008A5280008A4E, 0x80008A5E80008A5A, 0x80008A620003CCEF, 0x0003DDA380008A66, 0x000CE88680008A6A, 0x80008A6E000D6087, 
0x000391A5000399A6, 0x00038DAB80008A72, 0x80008A7600038DAA, 0x00025DAF80008A7A, 0x00025DAD00025DAE, 0x80008A7E00025DAC, 0x80008A8680008A82, 0x80008A8E80008A8A, 
0x80008A9680008A92, 0x000CBC840001E0EF, 0x80008A9A00068CE1, 0x80008A9E00061CE3, 0x80008AA680008AA2, 0x0001D5B380008AAA, 0x80008AB280008AAE, 0x80008ABA80008AB6, 
0x000199B5000191B6, 0x0001BDBB80008ABE, 0x80008AC20001BDBA, 0x00019DBF80008ACA, 0x00019DBD00019DBE, 0x000E05A800019DBC, 0x000E1DAA000E09A9, 0x000E51AC000E15AB, 
0x000E49AE000E51AD, 0x80008A56000E49AF, 0x000FF581000FCD82, 0x80008AC6000FFD80, 0x00001C8680008ACE, 0x000EE9B80003B087, 0x000EFDBA000EE9B9, 0x000EEDBC000EF5BB, 
0x000F51BE000F55BD, 0x000E39B0000F4DBF, 0x000E09B2000E39B1, 0x000E19B4000E09B3, 0x000E0DB6000E19B5, 0x000E95A3000ED9B7, 0x80008AD680008AD2, 0x80008ADE80008ADA, 
0x000ED9A5000ED1A6, 0x000EFDAB80008AE2, 0x80008AE6000EFDAA, 0x000EDDAF80008AEA, 0x000EDDAD000EDDAE, 0x80008AEE000EDDAC, 0x80008AF2000FFDB3, 0x000F81B680008AF6, 
0x80008AFE80008AFA, 0x000F8DBA000F99B5, 0x80008B02000F65BB, 0x000F7DBE80008B06, 0x000F7DBC000F65BF, 0x000E2DA8000F75BD, 0x000E31AA000E35A9, 0x000E55AC000E31AB, 
0x000E45AE000E45AD, 0x80008B0A000E75AF, 0x80008B1280008B0E, 0x80008B1A80008B16, 0x80008B2280008B1E, 0x000EE9B880008B26, 0x000EFDBA000EF5B9, 0x000EEDBC000EF5BB, 
0x000E91BE000E91BD, 0x000E0DB0000E91BF, 0x000EEDB2000EE5B1, 0x000EFDB4000EE5B3, 0x000EEDB6000EE5B5, 0x000EB9A3000EE5B7, 0x0000158100002D82, 0x80008B2A00001D80, 
0x000EDDA5000EC5A6, 0x000E21AB80008B2E, 0x80008B32000EC9AA, 0x000E21AF00012CBE, 0x000E31AD000E39AE, 0x80008B3A000E39AC, 0x000145B5000155B6, 0x000155B380008B36, 
0x0000788680008B3E, 0x000139BF00005C87, 0x000125BD000131BE, 0x000131BB000125BC, 0x800089E6000159BA, 0x80008B4680008B42, 0x0003048480008B4A, 0x80008B4E000289A3, 
0x000289A6000299A5, 0x003928BF80008B52, 0x000285AA80008B56, 0x0002F9AC0002EDAB, 0x0002EDAE0002F9AD, 0x000258E30002E5AF, 0x000188E1000EC0EF, 0x80008B5E80008B5A, 
0x80008B6680008B62, 0x80008B6E80008B6A, 0x80008B7680008B72, 0x000228EF80008B7A, 0x80008B7E000E28E3, 0x0002B5A9000E44E1, 0x000201AB000D69A8, 0x000201AD000209AA, 
0x000231AF000219AC, 0x000400BE000201AE, 0x80008B8680008B82, 0x80008B8E80008B8A, 0x80008B9680008B92, 0x0003E5B980008B9A, 0x0003E5BB0003E5B8, 0x0003E5BD0003E5BA, 
0x0003E5BF0003E5BC, 0x000221B10003E5BE, 0x000225B3000249B0, 0x000229B5000225B2, 0x000215B7000221B4, 0x0002C1A8000215B6, 0x0002F5AA0002D1A9, 0x000115AC00010DAB, 
0x000105AE000105AD, 0x80008B9E000139AF, 0x80008BAA80008BA2, 0x80008BB280008BAE, 0x80008BBA80008BB6, 0x00012DB880008BBE, 0x0001EDBA00013DB9, 0x0001FDBC0001E5BB, 
0x0001EDBE0001E5BD, 0x00012DB00001E5BF, 0x00013DB2000135B1, 0x00012DB4000135B3, 0x00011DB6000115B5, 0x00013D80000115B7, 0x0000AD820000A581, 0x0005B0860000D8EF, 
0x80008BC20005D887, 0x00046C84000FD4EF, 0x80008BC6000EF4E1, 0x80008BCA000F1CE3, 0x80008BCE000194E1, 0x00023DB3000E0CE3, 0x80008BD680008BD2, 0x80008BDE80008BDA, 
0x0001DDB50001C5B6, 0x0001B1BB80008BE2, 0x80008BE60001A9BA, 0x000191BF80008BEA, 0x0001A1BD0001A9BE, 0x80008BA60001A9BC, 0x000645AA80008BEE, 0x000645AC00065DAB, 
0x000645AE00064DAD, 0x80008BF200067DAF, 0x80008BFA80008BF6, 0x80008BFE0005D1A3, 0x000629A6000631A5, 0x80008C0680008C02, 0x00001D8100001D82, 0x80008C0A00001D80, 
0x80008C1280008C0E, 0x80008C16000394BE, 0x0003488680008C1A, 0x80008C1E0003CC87, 0x80008C2680008C22, 0x0007A9A880008C2A, 0x0007B9AA0007A9A9, 0x0007A9AC0007B9AB, 
0x000701AE0007A9AD, 0x80008C2E000735AF, 0x80008C3680008C32, 0x80008C3E80008C3A, 0x80008C4680008C42, 0x00072DB880008C4A, 0x0000E9BA0000C1B9, 0x0000F9BC0000E9BB, 
0x0000E5BE0000E5BD, 0x000751B000009DBF, 0x00072DB200075DB1, 0x00073DB4000725B3, 0x000725B6000725B5, 0x000631B3000715B7, 0x80008C5280008C4E, 0x80008C5A80008C56, 
0x000621B5000629B6, 0x000699BB80008C5E, 0x80008C62000695BA, 0x0006E1BF80008C66, 0x0006F1BD0006F9BE, 0x80008C6A0006F9BC, 0x80008C6E000675A3, 0x00066DA680008C72, 
0x80008C7A80008C76, 0x0006D1AA000665A5, 0x80008C7E0006DDAB, 0x0006BDAE80008C82, 0x0006BDAC0006A5AF, 0x0001E5A80006B5AD, 0x0001FDAA0001F5A9, 0x0001EDAC0001F5AB, 
0x00013DAE000135AD, 0x0000F980000135AF, 0x0000C5820000CD81, 0x000178BE00016084, 0x0000AC8780008C8A, 0x0000D1B800019086, 0x0000E1BA0000D9B9, 0x000091BC0000E1BB, 
0x000095BE00009DBD, 0x00014DB0000089BF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x0000F1B60000F1B5, 0x000275B30000F1B7, 0x80008C9280008C8E, 0x80008C9A80008C96, 
0x000265B50002B5B6, 0x000291BB80008C9E, 0x80008CA2000289BA, 0x000335BF80008CA6, 0x000281BD000289BE, 0x80008CAA000289BC, 0x80008CAE000231A3, 0x0002F1A60003C084, 
0x80008CB680008CB2, 0x0002CDAA000221A5, 0x80008CBA0002D5AB, 0x0002CDAE80008CBE, 0x0002CDAC000371AF, 0x00008DAB0002C5AD, 0x00008DA900008DAA, 0x0000BDAF000339A8, 
0x000085AD0000BDAE, 0x000000AA00008DAC, 0x80008CC2000000AB, 0x80008CCA80008CC6, 0x80008CD280008CCE, 0x00007DBB80008CD6, 0x00007DB900007DBA, 0x0001DDBF00007DB8, 
0x0001DDBD0001DDBE, 0x0000B9B30001DDBC, 0x0000A1B10000B1B2, 0x00005DB70000ADB0, 0x000095B500005DB6, 0x80008CDA000095B4, 0x80008CE280008CDE, 0x0000358180008CE6, 
0x80008CEA00000D80, 0x003DACBE00003582, 0x80008CF280008CEE, 0x80008CFA003D6885, 0x003C388680008CFE, 0x000149B30002C087, 0x000000D080008D02, 0x80008D0A80008D06, 
0x000149B5000149B6, 0x000129BB80008D0E, 0x80008D12000125BA, 0x00011DBF80008D16, 0x000121BD00011DBE, 0x003634E3000129BC, 0x0002B0E100060CE1, 0x80008D1A00063CE3, 
0x80008D2280008D1E, 0x003F2C8480008D26, 0x80008D2A003FA0BE, 0x00377CEF80008D2E, 0x80008D3680008D32, 0x80008D3A000118EF, 0x003E688680008D3E, 0x80008D42003FCC87, 
0x80008D4A80008D46, 0x80008D4E000094EF, 0x80008D52000194E1, 0x80008D56000050E3, 0x003FE981003FE982, 0x003E09A3003FF180, 0x80008CF60024018F, 0x80008D5E80008D5A, 
0x003E09A5003E09A6, 0x003E69AB80008D62, 0x80008D66003E65AA, 0x003E5DAF80008D6A, 0x003E61AD003E5DAE, 0x0038619E003E69AC, 0x0034C19C0038759F, 0x0035A59A0039B59D, 
0x003079980034759B, 0x002D219600317199, 0x002C6D9400318597, 0x00287992002C6595, 0x00245190002DA593, 0x00140DB100287991, 0x001801B3001405B0, 0x001879B5001455B2, 
0x80008D6E0018B5B4, 0x80008D7680008D72, 0x80008D7E80008D7A, 0x003CD1A280008D82, 0x003975A0000125A3, 0x0000C9A1003CBDA1, 0x000401A380008D86, 0x00041DA50000E5A2, 
0x0008F9A70004F5A4, 0x000C01A9000801A6, 0x000CCDAB00086DA8, 0x0010D1AD000CCDAA, 0x0011D5AF001001AC, 0x002505820010D9AE, 0x80008D8A00252D83, 0x002CC18680008D8E, 
0x00291D84002D1187, 0x002D298A00291585, 0x80008D92002C658B, 0x00301D8E80008D96, 0x0030D98C0034C18F, 0x0035619200311D8D, 0x80008D9A0035CD93, 0x0039619680008D9E, 
0x0038A19400389997, 0x003D619A00397D95, 0x80008DA2003D059B, 0x80008DAA80008DA6, 0x0000E99C80008DAE, 0x80008DB680008DB2, 0x80008DBE80008DBA, 0x80008C8680008DC2, 
0x80008DCA80008DC6, 0x003E91A880008DCE, 0x003EEDAA003E91A9, 0x003EE1AC003EE1AB, 0x003ED1AE003EE9AD, 0x003E51B0003ED1AF, 0x003E51B2003E51B1, 0x003E79B4003E51B3, 
0x003E6DB6003E79B5, 0x003E21B8003E65B7, 0x003E39BA003E21B9, 0x003E29BC003E39BB, 0x003E11BE003E15BD, 0x00039980003E0DBF, 0x0000058200039981, 0x000354BE80008DD2, 
0x80008DDA003DB0E1, 0x00023884003E40E3, 0x80008DE280008DDE, 0x80008DE6003FF4EF, 0x0004988680008DEA, 0x003D05B300031C87, 0x80008DEE00040884, 0x80008DF680008DF2, 
0x003D09B5003D09B6, 0x003DF5BB80008DFA, 0x80008DFE003DF5BA, 0x003DDDBF80008E02, 0x003DE5BD003DDDBE, 0x80008E06003DE5BC, 0x003DCDA380008E0A, 0x003DC1A50004C4BE, 
0x80008E1280008E0E, 0x80008E16003DC1A6, 0x003D3DAB80008E1A, 0x003D2DAD003D3DAA, 0x003D15AF003D2DAC, 0x000269B6003D15AE, 0x80008E2280008E1E, 0x80008E26000269B5, 
0x80008E2A000249B3, 0x0003A9BE80008E2E, 0x0003C1BC0003A9BF, 0x0003F9BA0003C1BD, 0x80008E320003F9BB, 0x00032DA880008E36, 0x000395AA00039DA9, 0x0003B5AC0003ADAB, 
0x0003B5AE0003BDAD, 0x00000D800003D9AF, 0x00001D8200001581, 0x80008E3E80008E3A, 0x0005B48780008E42, 0x000231B800049C86, 0x000235BA000231B9, 0x0002D5BC0002CDBB, 
0x0002D5BE0002DDBD, 0x000269B00002C9BF, 0x000241B2000269B1, 0x000239B4000241B3, 0x000211B6000239B5, 0x80008E4A000211B7, 0x80008E4E003E34E3, 0x80008E52003EACE1, 
0x80008E5600037CEF, 0x80008E5E80008E5A, 0x80008E62000394E3, 0x80008E66003E7CE1, 0x80008E6A003EE8EF, 0x80008E7280008E6E, 0x000355A380008E76, 0x000375A580008E7A, 
0x80008E8280008E7E, 0x80008E86000375A6, 0x0002E5AB80008E8A, 0x0002DDAD0002E5AA, 0x0002B5AF0002DDAC, 0x000619A80002B5AE, 0x000621AA000621A9, 0x000625AC00063DAB, 
0x000655AE00065DAD, 0x80008E4600064DAF, 0x80008E9280008E8E, 0x80008E9A80008E96, 0x80008EA280008E9E, 0x0006E5B880008EA6, 0x000681BA000681B9, 0x000689BC00069DBB, 
0x0006A1BE000689BD, 0x00063DB00006A1BF, 0x000605B200060DB1, 0x0006F5B40006EDB3, 0x0006E1B60006E1B5, 0x0006A9B30006DDB7, 0x0000158100002D82, 0x80008EAA00001D80, 
0x0006ADB50006DDB6, 0x0006C9BB80008EAE, 0x80008EB20006F9BA, 0x000625BF0003E084, 0x000639BD000631BE, 0x000388BE0006D1BC, 0x80008DD60006EDA3, 0x000699A680008EB6, 
0x80008EBE80008EBA, 0x0006BDAA0006E9A5, 0x0000488600068DAB, 0x000675AE00006C87, 0x000695AC000661AF, 0x000681A800067DAD, 0x000699AA00068DA9, 0x00068DAC000695AB, 
0x0006B1AE0006B5AD, 0x80008EC20006ADAF, 0x80008ECA80008EC6, 0x80008ED280008ECE, 0x80008EDA80008ED6, 0x0006A5B880008EDE, 0x000161BA000161B9, 0x000161BC000161BB, 
0x000161BE000161BD, 0x0006D9B0000161BF, 0x0006A9B20006D9B1, 0x0006BDB40006A9B3, 0x0006A1B60006A1B5, 0x000611B300069DB7, 0x80008EE680008EE2, 0x80008EEE80008EEA, 
0x000605B5000635B6, 0x00061DBB80008EF2, 0x80008EF600061DBA, 0x000665BF80008EFA, 0x00067DBD000679BE, 0x80008EFE00067DBC, 0x80008F02000655A3, 0x000671A680008F06, 
0x80008F0E80008F0A, 0x000659AA000641A5, 0x80008F12000659AB, 0x00063DAE80008F16, 0x000639AC000621AF, 0x0002D5A8000639AD, 0x000329AA0002DDA9, 0x000339AC000329AB, 
0x000329AE000339AD, 0x80008F1A000329AF, 0x80008F2280008F1E, 0x80008F2E80008F2A, 0x0003B8BE80008F32, 0x0003EDB880008F36, 0x000381BA000385B9, 0x000385BC000381BB, 
0x0003B1BE00038DBD, 0x000359B00003B1BF, 0x0003EDB2000359B1, 0x0003FDB40003E5B3, 0x0003E5B60003E5B5, 0x0000A1800003D5B7, 0x0000A1820000A181, 0x80008F3A000C80BE, 
0x80008F3E00029884, 0x000C008680008F42, 0x80008F460003F487, 0x80008F4E80008F4A, 0x80008F5680008F52, 0x0003E1B30003B084, 0x80008F5E80008F5A, 0x80008F6680008F62, 
0x0003F1B50003F9B6, 0x0003DDBB80008F6A, 0x80008F6E0003DDBA, 0x000361BF80008F72, 0x000371BD000379BE, 0x80008F76000379BC, 0x80008F7E80008F7A, 0x80008F8200022DA3, 
0x000235A600023DA5, 0x80008F8A80008F86, 0x000211AA80008F8E, 0x0002B5AC000211AB, 0x0002B5AE0002BDAD, 0x0003C4E30002ADAF, 0x0001B8E1000710E3, 0x0000718000076CE1, 
0x0000058200007181, 0x000CC08680008F92, 0x80008F9A000D5487, 0x0003B0EF80008F9E, 0x80008FA2000700EF, 0x80008FAA80008FA6, 0x80008FB280008FAE, 0x80008FBA80008FB6, 
0x80008FC280008FBE, 0x000DA0840001A4EF, 0x80008FC6000680E1, 0x80008FCA000110E3, 0x80008FD280008FCE, 0x0001F5B380008FD6, 0x80008FDE80008FDA, 0x80008FE680008FE2, 
0x000149B500014DB6, 0x000151BB80008FEA, 0x80008FEE000149BA, 0x000139BF80008FF2, 0x000141BD000131BE, 0x000E2DA8000149BC, 0x000E3DAA000E35A9, 0x000E81AC000E31AB, 
0x000E85AE000E8DAD, 0x80008F96000EB5AF, 0x80008FFA80008FF6, 0x0000198080008FFE, 0x0000058200001981, 0x000E9DB880009002, 0x000EA5BA000EADB9, 0x000F55BC000F4DBB, 
0x000F49BE000F5DBD, 0x000ECDB0000F41BF, 0x000EDDB2000ED5B1, 0x000EB5B4000ED5B3, 0x000EB5B6000EBDB5, 0x000EB5A3000EADB7, 0x80009006000388BE, 0x8000900E8000900A, 
0x000E09A5000E0DA6, 0x000E11AB80009012, 0x00000886000E09AA, 0x000E79AF00036C87, 0x000E01AD000E71AE, 0x80009016000E09AC, 0x8000901E8000901A, 0x80009022000FB5B3, 
0x000F5DB6000F55B5, 0x8000902680008F26, 0x000F79BA8000902A, 0x000F69BC000F79BB, 0x000F49BE000F5DBD, 0x000E69A8000F49BF, 0x000E71AA000E69A9, 0x000E91AC000E71AB, 
0x000E91AE000E91AD, 0x8000902E000E91AF, 0x8000903680009032, 0x8000903E8000903A, 0x8000904680009042, 0x000E85B88000904A, 0x000E85BA000E8DB9, 0x000E8DBC000E9DBB, 
0x000EB5BE000EBDBD, 0x000EF1B0000179BF, 0x000EF1B2000EF1B1, 0x000EC1B4000EC5B3, 0x000EC1B6000EC1B5, 0x000EF9A3000EC1B7, 0x800090528000904E, 0x8000905A80009056, 
0x000E19A5000E11A6, 0x000E35AB8000905E, 0x80009062000E35AA, 0x000E05AF80009066, 0x000E11AD000E05AE, 0x00000D80000E25AC, 0x00001D8200001581, 0x8000906E8000906A, 
0x0001948480009072, 0x00074086000194BE, 0x8000907A0000F487, 0x800090828000907E, 0x8000908A80009086, 0x00028DA88000908E, 0x000295AA000295A9, 0x0002D5AC0002CDAB, 
0x0002C9AE0002DDAD, 0x800090920002FDAF, 0x8000909A80009096, 0x001400BF8000909E, 0x800090A6800090A2, 0x00037DB8800090AA, 0x0003C1BA0003C1B9, 0x0003C1BC0003C1BB, 
0x0003F1BE0003C9BD, 0x000285B00003F1BF, 0x00034DB2000345B1, 0x00035DB4000345B3, 0x00034DB6000345B5, 0x00021DB3000345B7, 0x800090B2800090AE, 0x800090BA800090B6, 
0x00025DB500025DB6, 0x000381BB800090BE, 0x800090C2000241BA, 0x000381BF800090C6, 0x000391BD000399BE, 0x800090CA000399BC, 0x800090CE000259A3, 0x000219A6800090D2, 
0x800090DA800090D6, 0x000205AA000219A5, 0x800090DE0003C5AB, 0x0003DDAE800090E2, 0x0003DDAC0003C5AF, 0x800090EA0003D5AD, 0x000204840000CCE3, 0x0001C9800001BCE1, 
0x0001F5820001FD81, 0x800090EE000510BE, 0x800090F2000428BE, 0x800090FA800090F6, 0x800090FE000010EF, 0x0004E08680009102, 0x800091060002F487, 0x000FFCE38000910A, 
0x000FE0E18000910E, 0x000F14EF80009112, 0x8000911A80009116, 0x800091228000911E, 0x8000912A80009126, 0x800091328000912E, 0x8000913A80009136, 0x800091428000913E, 
0x8000914A80009146, 0x001204850001E0EF, 0x8000914E000EDCE1, 0x00002980000E1CE3, 0x0000058200001D81, 0x000231B380009152, 0x0005CC848000915A, 0x800091628000915E, 
0x000221B5000229B6, 0x0001CDBB80009166, 0x8000916A0001CDBA, 0x000175BF8000916E, 0x0001C1BD0001C9BE, 0x0005E9A80001C9BC, 0x0005F9AA0005E9A9, 0x0005E9AC0005F9AB, 
0x000639AE0005E9AD, 0x800090E6000639AF, 0x0000888680009156, 0x8000917200030087, 0x8000917A80009176, 0x0006D1B88000917E, 0x0006E1BA0006D9B9, 0x000691BC0006E1BB, 
0x000695BE00069DBD, 0x000649B0000689BF, 0x00065DB2000649B1, 0x00064DB4000655B3, 0x0006F1B60006F1B5, 0x000571A30006F1B7, 0x8000918680009182, 0x8000918E8000918A, 
0x000561A5000569A6, 0x00068DAB80009192, 0x8000919600068DAA, 0x000635AF8000919A, 0x000681AD000689AE, 0x8000919E000689AC, 0x0007E1B3800091A2, 0x0007E1B5800091A6, 
0x800091AE800091AA, 0x800090760007E5B6, 0x0007BDBB800091B2, 0x000795BD0007A1BA, 0x000795BF0007A9BC, 0x000601A8000795BE, 0x000621AA000625A9, 0x000621AC000621AB, 
0x000625AE00062DAD, 0x800091B6000655AF, 0x00001D8100001D82, 0x800091BA00001D80, 0x800091C2800091BE, 0x000639B8000130BE, 0x0006C9BA000639B9, 0x0006D9BC0006C9BB, 
0x0006C9BE0006D9BD, 0x00062DB00006C9BF, 0x000635B2000631B1, 0x000619B4000609B3, 0x000609B6000619B5, 0x0006A9A3000609B7, 0x001F288600028C84, 0x800091CA00014487, 
0x0006A9A50006ADA6, 0x0006F5AB800091CE, 0x800091D20006E9AA, 0x0006DDAF800091D6, 0x0006DDAD0006DDAE, 0x800091DA0006E1AC, 0x800091DE000615B3, 0x00063DB6800091E2, 
0x800091EA800091E6, 0x0001D9BA000635B5, 0x800091EE0001D9BB, 0x00017DBE800091F2, 0x00017DBC000165BF, 0x0005C5A8000175BD, 0x0005D9AA0005C9A9, 0x0005F9AC0005D1AB, 
0x000229AE0005F9AD, 0x800091F6000229AF, 0x800091FE800091FA, 0x0000008C80009202, 0x8000920A80009206, 0x0002EDB88000920E, 0x00028DBA000285B9, 0x000285BC000281BB, 
0x0002BDBE00028DBD, 0x000259B000037DBF, 0x0002EDB2000259B1, 0x0002FDB40002E5B3, 0x0002E5B60002E5B5, 0x000551A30002D5B7, 0x8000921680009212, 0x8000921E8000921A, 
0x000571A5000579A6, 0x00029DAB80009222, 0x8000922600029DAA, 0x000221AF8000922A, 0x000231AD000239AE, 0x00001182000239AC, 0x000065808000922E, 0x8000923200000981, 
0x8000923A000398BE, 0x000324848000923E, 0x0003688780009242, 0x80009246001C8C86, 0x8000924E8000924A, 0x8000925680009252, 0x0002A1B38000925A, 0x0002D1B5001CC084, 
0x800092628000925E, 0x800092660002D5B6, 0x0002C1BB8000926A, 0x000111BD0002F5BA, 0x000111BF0002D9BC, 0x8000926E000119BE, 0x8000927680009272, 0x8000927E8000927A, 
0x8000928680009282, 0x8000928A0006B8EF, 0x8000928E00049CE1, 0x80009292000674E3, 0x8000929A80009296, 0x0000F9808000929E, 0x000005820000F981, 0x001C58BE800092A2, 
0x00005CEF001F5884, 0x000190E1000640EF, 0x00003CE30006FCE1, 0x800092AA000674E3, 0x001C9886800092AE, 0x000269A3001CF487, 0x800092B2001F0CBE, 0x800092BA800092B6, 
0x000219A500021DA6, 0x000209AB800092BE, 0x800092C200023DAA, 0x0001D9AF800092C6, 0x0001D9AD0001D1AE, 0x001D91A8000211AC, 0x001DA1AA001D99A9, 0x001DD1AC001DA1AB, 
0x001DD5AE001DDDAD, 0x80009236001DC9AF, 0x800092CA800092A6, 0x800092D2800092CE, 0x800092DA800092D6, 0x001E79B8800092DE, 0x001ECDBA001E79B9, 0x001EDDBC001EC5BB, 
0x001EC5BE001EC5BD, 0x001DB9B0001EF5BF, 0x001D85B2001D8DB1, 0x001E55B4001E4DB3, 0x001E55B6001E5DB5, 0x001FCDB8001E49B7, 0x001FDDBA001FD5B9, 0x001FF1BC001FD5BB, 
0x001FE9BE001FFDBD, 0x001FA5B0001FE9BF, 0x001FB1B2001FB1B1, 0x001F95B4001F8DB3, 0x001FFDB6001FF5B5, 0x001E19A8001FF5B7, 0x001E2DAA001E19A9, 0x001E25AC001E3DAB, 
0x001E25AE001E2DAD, 0x800092E2001FDDAF, 0x800092EA800092E6, 0x800092F2800092EE, 0x800092F6800091C6, 0x001FE5B3800092FA, 0x80009302800092FE, 0x8000930A80009306, 
0x001FEDB5001FEDB6, 0x001E35BB8000930E, 0x80009312001E21BA, 0x001E71BF80009316, 0x001E19BD001E11BE, 0x00006982001E25BC, 0x00005980001FA1A3, 0x001FA9A600005181, 
0x8000931E8000931A, 0x001E65AA001FA9A5, 0x00040086001E71AB, 0x001E55AE0001EC87, 0x001E61AC001E35AF, 0x001E31A8001E5DAD, 0x001E41AA001E31A9, 0x001E41AC001E41AB, 
0x001E71AE001E49AD, 0x80009322001E71AF, 0x8000932A80009326, 0x800093328000932E, 0x8000933A80009336, 0x000129B88000933E, 0x000139BA000129B9, 0x00012DBC000135BB, 
0x0000D1BE0000D1BD, 0x0001C9B00000D1BF, 0x0001D9B20001C9B1, 0x0001C9B40001D9B3, 0x000119B60001C9B5, 0x001DC9B3000119B7, 0x8000934680009342, 0x8000934E8000934A, 
0x001DC9B5001DC9B6, 0x00020DBB80009352, 0x8000935600020DBA, 0x00020DBF8000935A, 0x00020DBD00020DBE, 0x8000935E00020DBC, 0x80009362001D8DA3, 0x001D8DA680009366, 
0x8000936E8000936A, 0x000249AA001D8DA5, 0x80009372000249AB, 0x000249AE80009376, 0x000249AC000249AF, 0x00000D80000249AD, 0x0000118200001181, 0x0002CCEF8000937A, 
0x800093828000937E, 0x00022CE300029084, 0x0001D8E1000328BE, 0x000410868000938A, 0x8000938E0003D487, 0x000361B380009392, 0x8000939A80009396, 0x800093A28000939E, 
0x000371B5000379B6, 0x00035DBB800093A6, 0x800093AA00035DBA, 0x0000E1BF800093AE, 0x0000F1BD0000F9BE, 0x0002A1A30000F9BC, 0x800093B6800093B2, 0x800093BE800093BA, 
0x0002B1A50002B9A6, 0x00029DAB800093C2, 0x800093C600029DAA, 0x000121AF800093CA, 0x000131AD000139AE, 0x800093CE000139AC, 0x001F64EF800093D2, 0x800093DA800093D6, 
0x800093E2800093DE, 0x00000D80800093E6, 0x0000158200001181, 0x001CE0E1800093EA, 0x001F88E3800093EE, 0x00028084800093F2, 0x0005488700058CBE, 0x800093FA00042C86, 
0x001EA4EF800093FE, 0x001E00E1001EF4EF, 0x001E2CE3001F50E1, 0x80009402001EB0E3, 0x8000940A80009406, 0x800094128000940E, 0x0004848480009416, 0x8000941A000171B3, 
0x000115B600011DB5, 0x800094228000941E, 0x000101BA80009426, 0x0000F5BC000101BB, 0x0000F5BE0000FDBD, 0x0006ADA80000EDBF, 0x0006B5AA0006BDA9, 0x0006D9AC0006C9AB, 
0x0006C9AE0006D9AD, 0x8000942A0006C1AF, 0x800094328000942E, 0x8000943A80009436, 0x800094428000943E, 0x00076DB880009446, 0x00070DBA000705B9, 0x000701BC000701BB, 
0x000701BE000701BD, 0x000689B0000701BF, 0x00076DB2000689B1, 0x00077DB4000765B3, 0x000765B6000765B5, 0x80009386000755B7, 0x8000944A000639A3, 0x00065DA6800093F6, 
0x800094528000944E, 0x000649AA000655A5, 0x80009456000649AB, 0x0007BDAE8000945A, 0x0007BDAC0007A5AF, 0x00006D800007B5AD, 0x0000198200000981, 0x800094628000945E, 
0x8000946600039CBE, 0x000040868000946A, 0x8000946E00006087, 0x8000947680009472, 0x8000947E8000947A, 0x000691A880009482, 0x0006B9AA000691A9, 0x0006A9AC0006B9AB, 
0x0006D9AE0006A9AD, 0x800094860006D9AF, 0x8000948E8000948A, 0x8000949680009492, 0x8000949E8000949A, 0x000171B8800094A2, 0x000171BA000171B9, 0x0001D9BC000171BB, 
0x0001C1BE0001C1BD, 0x0006B1B00001F5BF, 0x000689B20006B9B1, 0x000151B4000689B3, 0x000151B6000151B5, 0x000631B3000151B7, 0x800094AA800094A6, 0x800094B2800094AE, 
0x000621B5000629B6, 0x00067DBB800094B6, 0x800094BA000675BA, 0x000195BF800094BE, 0x00065DBD000195BE, 0x800094C200065DBC, 0x800094C6000675A3, 0x00066DA6800094CA, 
0x800094D2800094CE, 0x000631AA000665A5, 0x0001AC84000639AB, 0x0001D1AE0001A0BE, 0x000619AC0001D1AF, 0x0002DDA8000619AD, 0x0002E5AA0002EDA9, 0x0002E5AC0002FDAB, 
0x0002E5AE0002EDAD, 0x800094DA00033DAF, 0x800094E2800094DE, 0x800094E6000C64BE, 0x800094EE800094EA, 0x0003C9B8800094F2, 0x0003D9BA0003C9B9, 0x0003F9BC0003D1BB, 
0x000399BE0003F9BD, 0x000345B0000395BF, 0x000345B200034DB1, 0x000345B400035DB3, 0x000345B600034DB5, 0x000355810003F9B7, 0x000265B300034980, 0x000265B500035582, 
0x800094FA800094F6, 0x000C0086000265B6, 0x000381BB0003E487, 0x000381BD000389BA, 0x000381BF000399BC, 0x00022DA3000389BE, 0x80009502800094FE, 0x8000950A80009506, 
0x00022DA500022DA6, 0x0003C9AB8000950E, 0x800095120003C1AA, 0x0003C9AF80009516, 0x0003C9AD0003C1AE, 0x0006D8E30003D1AC, 0x00069CE10007ACE1, 0x8000951A00069CE3, 
0x8000951E000D5884, 0x8000952680009522, 0x8000952E8000952A, 0x00011CEF80009532, 0x8000953A80009536, 0x00007980000640EF, 0x0000118200001581, 0x8000953E000C0084, 
0x800095420000ACE3, 0x8000954A0001A4E1, 0x000CC886000070EF, 0x8000954E000DA487, 0x8000955680009552, 0x0005C9BA8000955A, 0x0005A5B80005C9BB, 0x0005F9BE0005CDB9, 
0x0005CDBC0005F9BF, 0x0005A5B20005C5BD, 0x000611B00005ADB3, 0x0005ADB6000611B1, 0x0005B5B400059DB7, 0x000661AA0005ADB5, 0x00069DA8000661AB, 0x000661AE000695A9, 
0x000671AC000661AF, 0x8000955E000671AD, 0x8000956680009562, 0x8000956E8000956A, 0x000CB0BE80009572, 0x000E21A880009576, 0x000E21AA000E21A9, 0x000E25AC000E3DAB, 
0x000E25AE000E2DAD, 0x80009546000E89AF, 0x8000957E8000957A, 0x8000958680009582, 0x8000958E8000958A, 0x000F51B880009592, 0x000F55BA000F5DB9, 0x000F75BC000F6DBB, 
0x000F75BE000F7DBD, 0x000EF9B0000F69BF, 0x000EA1B2000EA1B1, 0x000EA1B4000EA1B3, 0x000E91B6000EA9B5, 0x000EA9B3000E91B7, 0x800094D680009596, 0x8000959E8000959A, 
0x000EADB5000EADB6, 0x000E65BB800095A2, 0x800095A6000E3DBA, 0x000E6DBF800095AA, 0x000E75BD000E65BE, 0x00001982000E75BC, 0x00006580000EEDA3, 0x000EE9A600001981, 
0x800095B2800095AE, 0x000E79AA000EE9A5, 0x800095B6000E21AB, 0x000E21AE800095BA, 0x000E31AC000E29AF, 0x000E61A8000E31AD, 0x000E7DAA000E75A9, 0x000E6DAC000E75AB, 
0x000EFDAE000EF5AD, 0x00018086000EF5AF, 0x800095BE0001A487, 0x800095C6800095C2, 0x800095CE800095CA, 0x000175B8800095D2, 0x000175BA00017DB9, 0x0001DDBC0001C9BB, 
0x0001C5BE0001C5BD, 0x000E8DB00001F5BF, 0x000E9DB2000E95B1, 0x000155B4000E91B3, 0x000155B600015DB5, 0x000EF5B300014DB7, 0x800095DA800095D6, 0x800095E2800095DE, 
0x000EE5B5000E75B6, 0x000E51BB800095E6, 0x800095EA000E49BA, 0x000199BF800095EE, 0x000E45BD000191BE, 0x800095F2000E49BC, 0x800095F6000EB1A3, 0x000E31A6800095FA, 
0x80009602800095FE, 0x000E0DAA000EA1A5, 0x80009606000E15AB, 0x0001D5AE8000960A, 0x000E0DAC0001DDAF, 0x0002EDA8000E01AD, 0x000325AA00032DA9, 0x000325AC00033DAB, 
0x000325AE00032DAD, 0x8000960E000399AF, 0x8000961680009612, 0x8000961E8000961A, 0x000274BE80009622, 0x00038DB88000962A, 0x000391BA000391B9, 0x0003BDBC0003A5BB, 
0x00007DBE000075BD, 0x0003E9B0000075BF, 0x0003F9B20003E9B1, 0x0003D9B40003F1B3, 0x0003B9B60003D9B5, 0x0000AD800003B5B7, 0x0000BD820000B581, 0x8000962E0003A1B3, 
0x0003A1B60003A1B5, 0x0002E08480009632, 0x000321BA80009636, 0x000321BC000321BB, 0x000311BE000329BD, 0x0003EDA3000311BF, 0x006FB4850004C085, 0x8000963E8000963A, 
0x0003EDA50003EDA6, 0x00036DAB80009642, 0x0005488600036DAA, 0x00035DAF00036C87, 0x000365AD00035DAE, 0x8000964600036DAC, 0x006C58EF000E00E3, 0x8000964A000FB4E1, 
0x800096528000964E, 0x0003A9A180009656, 0x0003C1A3000FFDA0, 0x0003E0E100030DA2, 0x0003E4E3000FE0EF, 0x8000965E8000965A, 0x0004048480009662, 0x80009666000404BE, 
0x8000966A000394EF, 0x800096728000966E, 0x800096760003D4E3, 0x8000967A000054E1, 0x800096828000967E, 0x00000D8080009686, 0x00001D8200001581, 0x8000968E8000968A, 
0x001B918F80009692, 0x0007E084000E9CEF, 0x8000969A000ED4E1, 0x8000969E000EF0E3, 0x00071886800096A2, 0x0017E59900049087, 0x000BE99B0017E598, 0x000AFD9D000B399A, 
0x000F559F000BF19C, 0x001F2991000F5D9E, 0x001F2593001BCD90, 0x0013D195001FCD92, 0x0017199700132994, 0x0010E18C00137596, 0x00102D8E0010258D, 0x80009626000CF98F, 
0x0014398A80009696, 0x0018E9840014958B, 0x0018E58600180585, 0x800096A60014F187, 0x001C3182800096AA, 0x0004A99C001C1583, 0x800096B2800096AE, 0x800096BA800096B6, 
0x0004D19A800096BE, 0x000D4D9400047D9B, 0x0008E5960008E595, 0x800096C20008B597, 0x000C5992800096C6, 0x000091A1000C5993, 0x007C01A3800096CA, 0x007CB9A5000099A2, 
0x007899A7007C91A4, 0x007981A9007DE1A6, 0x007489AB0078A1A8, 0x007001AD007401AA, 0x007085AF007459AC, 0x006CE1B100709DAE, 0x006801B3006C01B0, 0x0068F5B5006C1DB2, 
0x800096CE0068F5B4, 0x800096D6800096D2, 0x800096DE800096DA, 0x800096E6800096E2, 0x800096EE800096EA, 0x00073DA8800096F2, 0x000795AA000795A9, 0x0007DDAC0007A9AB, 
0x0007C5AE0007C5AD, 0x800096F600061DAF, 0x00001D8100001D82, 0x800096FA00001D80, 0x80009702800096FE, 0x000619B8000160BE, 0x000629BA000619B9, 0x000621BC000625BB, 
0x000621BE000621BD, 0x000671B0000621BF, 0x000671B2000671B1, 0x00064DB4000671B3, 0x00063DB6000635B5, 0x00071DB300062DB7, 0x000028868000970A, 0x8000970E0000A887, 
0x000755B5000745B6, 0x0006B5BB80009712, 0x800097160006B5BA, 0x0006F1BF8000971A, 0x0006A5BD000689BE, 0x8000971E0006A5BC, 0x80009722000759A3, 0x000701A680009726, 
0x8000972E8000972A, 0x0006F1AA000711A5, 0x800097320006F1AB, 0x0006CDAE80009736, 0x0006E1AC0006B5AF, 0x0005A9A80006E1AD, 0x0005BDAA0005B5A9, 0x000225AC00023DAB, 
0x000251AE000251AD, 0x8000973A000251AF, 0x800097428000973E, 0x00033C8480009746, 0x8000974E8000974A, 0x0002A5B880009752, 0x0002A5BA0002ADB9, 0x0002A5BC0002BDBB, 
0x0002A5BE0002ADBD, 0x000231B000037DBF, 0x000219B2000231B1, 0x0002F5B4000219B3, 0x0002A5B60002ADB5, 0x8000975600029DB7, 0x8000975E8000975A, 0x80009762000539B3, 
0x0002DDB60002A1B5, 0x8000976A80009766, 0x0002F9BA8000976E, 0x0002C1BC0002F9BB, 0x00023DBE0002C1BD, 0x80009772000265BF, 0x0002FDA5000281A6, 0x000565A38000977A, 
0x007CD886007C58BE, 0x000239AF007C9C87, 0x00029DAD000261AE, 0x0002A5AB00029DAC, 0x8000977E0002A5AA, 0x000285A880009782, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x000185810002D1AF, 0x8000978600018580, 0x8000978A0001ED82, 0x800097928000978E, 0x000175B880009796, 0x000175BA00017DB9, 0x0001D5BC0001CDBB, 
0x0001C9BE0001DDBD, 0x0002B5B00001C1BF, 0x000281B20002BDB1, 0x000151B4000281B3, 0x000151B6000151B5, 0x8000979A000151B7, 0x800097A28000979E, 0x000630E1800097A6, 
0x000628E3000764E1, 0x007D20840006C4E3, 0x00006CEF800097AA, 0x800097AE000618EF, 0x800097B6800097B2, 0x00025DB3800097BA, 0x800097BE007C48BE, 0x800097C6800097C2, 
0x000275B5000215B6, 0x000239BB800097CA, 0x800097CE000231BA, 0x0001D5BF800097D2, 0x000215BD0001D5BE, 0x007D9DA3000215BC, 0x800097D680009776, 0x800097DE800097DA, 
0x007DB5A5007DD5A6, 0x007DF9AB800097E2, 0x800097E6007DF1AA, 0x007E15AF800097EA, 0x007DD5AD007E15AE, 0x00004D80007DD5AC, 0x0000558200005581, 0x800097EE007EB1B3, 
0x007F6DB6007F65B5, 0x00034086800097F2, 0x007FE9BA00030487, 0x007FF9BC007FE9BB, 0x007FDDBE007FF9BD, 0x800097F6007FCDBF, 0x80009706800097FA, 0x80009802800097FE, 
0x8000980A80009806, 0x007E6DA88000980E, 0x007E55AA007E5DA9, 0x007F81AC007F85AB, 0x007F81AE007F81AD, 0x007F41B0007F81AF, 0x007F41B2007F41B1, 0x007F75B4007F41B3, 
0x007F6DB6007F65B5, 0x007F5DB8007F65B7, 0x007F25BA007F2DB9, 0x007F2DBC007F3DBB, 0x007F15BE007F1DBD, 0x007FFDA30000F5BF, 0x8000981680009812, 0x8000981E8000981A, 
0x007E29A5007E21A6, 0x007EA5AB80009822, 0x80009826007EA5AA, 0x007E81AF8000982A, 0x007EB5AD007E91AE, 0x8000982E007EB5AC, 0x8000983680009832, 0x8000983E8000983A, 
0x8000984680009842, 0x00003D808000984A, 0x0000198200000981, 0x800098528000984E, 0x0001B0BE0001B884, 0x0001ADA880009856, 0x0001D5AA0001D5A9, 0x000115AC00010DAB, 
0x000109AE000119AD, 0x00040086000109AF, 0x8000985A00010487, 0x800098628000985E, 0x8000986A80009866, 0x0000EDB88000986E, 0x00008DBA000085B9, 0x00009DBC000085BB, 
0x00008DBE000085BD, 0x000179B0000085BF, 0x0000EDB2000179B1, 0x0000FDB40000E5B3, 0x0000E5B60000E5B5, 0x00025DB30000D5B7, 0x8000987680009872, 0x8000987E8000987A, 
0x00029DB5000299B6, 0x0002BDBB80009882, 0x800098860002BDBA, 0x000321BF8000988A, 0x000331BD000339BE, 0x000328BE000339BC, 0x8000988E000219A3, 0x0002DDA680009892, 
0x8000989A80009896, 0x0002F9AA0002D9A5, 0x8000989E0002F9AB, 0x00037DAE800098A2, 0x00037DAC000365AF, 0x0004C8BE000375AD, 0x800098AA800098A6, 0x800098AE0005C4BE, 
0x800098B6800098B2, 0x00003D80800098BA, 0x0000198200000981, 0x800098C2800098BE, 0x800098CA00033884, 0x000278EF800098CE, 0x00044886800098D2, 0x800098D600035487, 
0x800098DE800098DA, 0x800098E6800098E2, 0x800098EE800098EA, 0x000254E3800098F2, 0x000140E1800098F6, 0x800098FE800098FA, 0x80009902007F24E3, 0x80009906007C9CE1, 
0x8000990E8000990A, 0x00056C8480009912, 0x8000991A80009916, 0x800099228000991E, 0x80009926007F18EF, 0x0002F1B38000992A, 0x800099328000992E, 0x8000993E8000993A, 
0x0002E1B50002E9B6, 0x000171BB80009942, 0x0005A087000169BA, 0x000139BF0004CC86, 0x000151BD000159BE, 0x007F40E1000161BC, 0x007E38E380009946, 0x0000D9820004C084, 
0x0000A580000014EF, 0x8000994A0000D981, 0x8000994E0000C0E3, 0x800099520001D4E1, 0x007E84EF80009956, 0x0001CDAA8000995A, 0x8000995E0001D5AB, 0x0001FDAE80009962, 
0x0001C5AC00019DAF, 0x800099660001F5AD, 0x8000996A000255A3, 0x00024DA68000996E, 0x8000997680009972, 0x800098C6000245A5, 0x8000997A80009936, 0x800099828000997E, 
0x8000998A80009986, 0x000699A88000998E, 0x0006EDAA000699A9, 0x0006E5AC0006FDAB, 0x0006E5AE0006EDAD, 0x0006A5B00006DDAF, 0x0006A5B20006ADB1, 0x0006ADB40006B9B3, 
0x000751B6000755B5, 0x000775B800074DB7, 0x000775BA00077DB9, 0x000759BC000749BB, 0x000749BE000759BD, 0x000645B3000745BF, 0x8000999680009992, 0x8000999E8000999A, 
0x00064DB500064DB6, 0x000649BB800099A2, 0x00000886000641BA, 0x0007B1BF00008C87, 0x00064DBD000649BE, 0x00005D82000651BC, 0x00004580000601A3, 0x000609A600005D81, 
0x800099AE800099AA, 0x000605AA000609A5, 0x800099B200060DAB, 0x00060DAE800099B6, 0x000615AC0007F5AF, 0x00064DA8000609AD, 0x000655AA000655A9, 0x0006B1AC000689AB, 
0x0006A9AE0006BDAD, 0x800099A60006A9AF, 0x800099BE800099BA, 0x800099C6800099C2, 0x800099CE800099CA, 0x000149B8800099D2, 0x000159BA000149B9, 0x000149BC000159BB, 
0x0001DDBE000149BD, 0x0006DDB00001D5BF, 0x0006A5B20006ADB1, 0x000699B400068DB3, 0x00068DB6000699B5, 0x0006DDB3000685B7, 0x800099DA800099D6, 0x800099E2800099DE, 
0x000639B500063DB6, 0x000669BB800099E6, 0x800099EA000619BA, 0x00065DBF800099EE, 0x000659BD00065DBE, 0x800099F2000671BC, 0x800099F6000699A3, 0x000679A6800099FA, 
0x80009A02800099FE, 0x00065DAA00067DA5, 0x80009A0600062DAB, 0x000619AE80009A0A, 0x000635AC000619AF, 0x0002D5A800061DAD, 0x0002E1AA0002DDA9, 0x000335AC0002E1AB, 
0x000335AE00033DAD, 0x0003CD8000032DAF, 0x0000198200000981, 0x80009A1280009A0E, 0x000374BE00021884, 0x0003E9B880009A1A, 0x000389BA0003E9B9, 0x00039DBC000385BB, 
0x000381BE000381BD, 0x000355B00003B5BF, 0x000355B200035DB1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 0x000C20860003E1B7, 0x80009A1E00031087, 0x80009A2680009A22, 
0x80009A2E80009A2A, 0x80009A3200025CEF, 0x80009A36000014E1, 0x000CF8BE000288E3, 0x80009A3E80009A3A, 0x0003F9BB80009A42, 0x000D80BE0003F1BA, 0x00035DBF80009A46, 
0x00035DBD00035DBE, 0x000209B30003E1BC, 0x80009A4E80009A4A, 0x80009A5680009A52, 0x0003DDB50003DDB6, 0x0006A9A880009A5A, 0x0006B9AA0006A9A9, 0x0006A9AC0006B9AB, 
0x00051DAE0006A9AD, 0x80009A5E000515AF, 0x80009A6680009A62, 0x80009A6E80009A6A, 0x80009A7680009A72, 0x000519B880009A7A, 0x000525BA00052DB9, 0x0005D9BC0005C9BB, 
0x0005CDBE0005C5BD, 0x00056DB00005C5BF, 0x000575B2000575B1, 0x00055DB4000545B3, 0x000535B600053DB5, 0x0006F4E1000529B7, 0x000614E3000754E1, 0x000009810006BCE3, 
0x80009A7E0000A980, 0x000DEC8400003982, 0x000C888780009A82, 0x80009A8A000C0C86, 0x0007CCEF80009A8E, 0x000329A30007C4EF, 0x80009A9680009A92, 0x80009A9E80009A9A, 
0x0002FDA50002FDA6, 0x0002D9AB80009AA2, 0x80009AA60002D1AA, 0x00027DAF80009AAA, 0x00027DAD00027DAE, 0x000E3DA80002C1AC, 0x000E85AA000E8DA9, 0x000E85AC000E9DAB, 
0x000EB9AE000E8DAD, 0x80009A86000EB5AF, 0x80009AB280009AAE, 0x80009ABA80009AB6, 0x80009AC280009ABE, 0x000EBDB880009AC6, 0x000F6DBA000F65B9, 0x000F7DBC000F65BB, 
0x000F6DBE000F65BD, 0x000ED5B0000F65BF, 0x000ED5B2000EDDB1, 0x000E95B4000EA1B3, 0x000E95B6000E9DB5, 0x000E0DB3000E8DB7, 0x80009ACE80009ACA, 0x80009AD680009AD2, 
0x000E0DB5000E0DB6, 0x000E19BB80009ADA, 0x80009ADE000E11BA, 0x000E59BF80009A16, 0x000E75BD000E51BE, 0x80009AE2000E01BC, 0x80009AE6000E49A3, 0x000E49A680009AEA, 
0x80009AF280009AEE, 0x000E55AA000E49A5, 0x0003A484000E5DAB, 0x000E15AE80009AF6, 0x000E45AC000E1DAF, 0x000EB1A8000E31AD, 0x000ECDAA000EB1A9, 0x000EDDAC000EC5AB, 
0x000EC5AE000EC5AD, 0x0001ED80000EF5AF, 0x0001F1820001F181, 0x0001908680009AFA, 0x80009AFE0001B487, 0x0001C5B880009B02, 0x0001C5BA0001CDB9, 0x0001CDBC0001DDBB, 
0x000199BE0001FDBD, 0x000E8DB0000195BF, 0x000141B2000141B1, 0x000141B4000141B3, 0x000141B6000141B5, 0x000E45B3000141B7, 0x80009B0A80009B06, 0x80009B1280009B0E, 
0x000E55B5000E45B6, 0x000185BB80009B16, 0x80009B1A000E49BA, 0x000185BF80009B1E, 0x000195BD000185BE, 0x80009B22000195BC, 0x80009B26000E01A3, 0x000E01A680009B2A, 
0x80009B3280009B2E, 0x000E0DAA000E11A5, 0x80009B360001C1AB, 0x0001C1AE80009B3A, 0x0001D1AC0001C1AF, 0x00032DA80001D1AD, 0x000335AA00033DA9, 0x000399AC000389AB, 
0x000389AE000399AD, 0x80009B3E000381AF, 0x80009B4680009B42, 0x80009B4E80009B4A, 0x80009B5680009B52, 0x0003ADB880009B5A, 0x00006DBA000065B9, 0x00007DBC000065BB, 
0x00006DBE000065BD, 0x0003C9B0000065BF, 0x0003A9B20003C9B1, 0x0003BDB40003A5B3, 0x0003A1B60003A1B5, 0x0000BD80000395B7, 0x0000198200000981, 0x80009B6280009B5E, 
0x80009B6A0003D8BE, 0x0002AC8480009B6E, 0x0003E88780009B72, 0x80009B7600040C86, 0x80009B7E80009B7A, 0x0003FDB380009B82, 0x80009B8A80009B86, 0x80009B9280009B8E, 
0x000351B5000359B6, 0x00034DBB80009B96, 0x80009B9A00034DBA, 0x000325BF80009B9E, 0x000331BD000339BE, 0x80009BA200033DBC, 0x80009BAA80009BA6, 0x000F58EF80009BAE, 
0x80009BB680009BB2, 0x000E90E380009BBA, 0x000FB0E180009BBE, 0x80009BC680009BC2, 0x80009BCE80009BCA, 0x0000758080009BD2, 0x0000758200007D81, 0x00033CEF00051884, 
0x000514BE80009BDA, 0x0003D0E380009BDE, 0x000040E180009BE2, 0x0004D08680009BE6, 0x80009BEA00055887, 0x80009BF280009BEE, 0x80009BFA80009BF6, 0x80009C0280009BFE, 
0x80009C0A80009C06, 0x0004EC84000FACEF, 0x80009C0E000E10E1, 0x80009C12000154E3, 0x80009C1A80009C16, 0x0002FDA380009C1E, 0x80009C2680009C22, 0x80009C2E80009C2A, 
0x000251A5000259A6, 0x00024DAB80009C32, 0x80009C3600024DAA, 0x000225AF80009C3A, 0x000231AD000239AE, 0x000699A800023DAC, 0x0006ADAA000699A9, 0x0006A5AC0006BDAB, 
0x0006A5AE0006ADAD, 0x80009BD60006D9AF, 0x0000198100001182, 0x80009C3E0007C180, 0x000370BE80009C42, 0x000749B880009C46, 0x00075DBA000749B9, 0x00074DBC000755BB, 
0x000775BE000771BD, 0x0006A9B000076DBF, 0x0006B9B20006A9B1, 0x000699B40006B1B3, 0x000779B6000699B5, 0x000635B5000779B7, 0x80009C4E80009C4A, 0x00003086000635B6, 
0x00063DB300035C87, 0x00067DBD80009C52, 0x000645BF000675BC, 0x80009B66000645BE, 0x000675BB80009C56, 0x000665A3000675BA, 0x80009C5E80009C5A, 0x80009C6680009C62, 
0x00066DA500066DA6, 0x00062DAB80009C6A, 0x80009C6E00062DAA, 0x00061DAF80009C72, 0x000625AD00061DAE, 0x000655A800062DAC, 0x00066DAA000659A9, 0x000669AC000661AB, 
0x000699AE000669AD, 0x80009C76000699AF, 0x80009C7E80009C7A, 0x80009C8680009C82, 0x80009C8E80009C8A, 0x0006F9B880009C92, 0x00068DBA0006F9B9, 0x00069DBC000685BB, 
0x000685BE000685BD, 0x0006E9B00006B5BF, 0x0006F9B20006E9B1, 0x0006E9B40006F9B3, 0x0006C9B60006DDB5, 0x0006E5B30006C9B7, 0x80009C9A80009C96, 0x80009CA280009C9E, 
0x0006E1B50006E9B6, 0x00062DBB80009CA6, 0x80009CAA00062DBA, 0x000619BF80009CAE, 0x00062DBD00062DBE, 0x0000158200062DBC, 0x000061800006A1A3, 0x0006ADA600006181, 
0x000190BE80009CB2, 0x000669AA0006A5A5, 0x0001A484000669AB, 0x000669AE80009CBA, 0x000669AC00065DAF, 0x000285A8000669AD, 0x000295AA00028DA9, 0x0002D5AC0002B9AB, 
0x0002D5AE0002DDAD, 0x001C80860002CDAF, 0x80009CBE00036487, 0x80009CC2000360BE, 0x80009CCA80009CC6, 0x000375B880009CCE, 0x000375BA00037DB9, 0x0003D9BC0003C9BB, 
0x0003C9BE0003D9BD, 0x0002BDB00003C1BF, 0x000285B200028DB1, 0x000355B400034DB3, 0x000355B600035DB5, 0x00021DB300034DB7, 0x0003088480009CD2, 0x80009CDA80009CD6, 
0x00025DB500025DB6, 0x000249BB80009CDE, 0x80009CE2000279BA, 0x000399BF80009CE6, 0x000399BD000391BE, 0x000000B0000251BC, 0x80009CEA000259A3, 0x000219A680009CEE, 
0x80009CF680009CF2, 0x00023DAA000219A5, 0x80009CFA00020DAB, 0x0003D5AE80009CFE, 0x000215AC0003DDAF, 0x80009D020003DDAD, 0x80009D0A80009D06, 0x80009D0E0006ACEF, 
0x80009D1680009D12, 0x001CE8BE80009D1A, 0x80009D2280009D1E, 0x80009D2E80009D2A, 0x80009D32000780E1, 0x00005D80000660E3, 0x0000618200006181, 0x80009D3600017DB3, 
0x000165B600016DB5, 0x001D208680009D3A, 0x0001F9BA001D5887, 0x0001D9BC0001F1BB, 0x0001B1BE0001D9BD, 0x0000A0EF0001B1BF, 0x80009D4280009D3E, 0x80009D4A80009D46, 
0x80009D5280009D4E, 0x001C6C8400015CEF, 0x80009D560006CCE1, 0x000048E300061CE3, 0x000130E180009D5A, 0x0001F1A380009D5E, 0x0014008580009D62, 0x80009D6A80009D66, 
0x0001E1A50001E9A6, 0x00017DAB80009D6E, 0x80009D72000175AA, 0x00013DAF80009D76, 0x000155AD00013DAE, 0x001DEDA8000155AC, 0x001E39AA001E2DA9, 0x001E29AC001E39AB, 
0x001E9DAE001E29AD, 0x80009D26001E91AF, 0x80009D7E80009D7A, 0x80009D8680009D82, 0x0000F1810000F982, 0x001EA9B80000FD80, 0x001F49BA001EA9B9, 0x001F59BC001F49BB, 
0x001F4DBE001F45BD, 0x001EF1B0001F45BF, 0x001EC1B2001EF9B1, 0x001EB9B4001EC1B3, 0x001EADB6001EB9B5, 0x001F11B0001EA5B7, 0x001F11B2001F11B1, 0x001F25B4001F25B3, 
0x001F5DB6001F29B5, 0x001F71B8001F51B7, 0x001F41BA001F79B9, 0x000095BC001F41BB, 0x000095BE00009DBD, 0x80009D8A00008DBF, 0x80009D8E80009CB6, 0x80009D9680009D92, 
0x0003F88680009D9A, 0x001FCDA80000D087, 0x001FD1AA001FD5A9, 0x001FADAC001FBDAB, 0x001F71AE001F71AD, 0x001E39B3001F71AF, 0x80009DA280009D9E, 0x80009DAA80009DA6, 
0x001E45B5001E91B6, 0x001EB5BB80009DAE, 0x80009DB2001EB5BA, 0x001E8DBF80009DB6, 0x001E91BD001E81BE, 0x80009DBA001EA5BC, 0x80009DBE001E7DA3, 0x001ED5A680009DC2, 
0x80009DCA80009DC6, 0x001EF1AA001E01A5, 0x80009DCE001EF1AB, 0x001EC5AE80009DD2, 0x001EE1AC001EC9AF, 0x000155A8001ED5AD, 0x000081AA000081A9, 0x000081AC000081AB, 
0x0000B1AE000089AD, 0x80009DD60000B1AF, 0x80009DDE80009DDA, 0x80009DE680009DE2, 0x80009DEE80009DEA, 0x000065B880009DF2, 0x000065BA00006DB9, 0x000065BC00007DBB, 
0x000065BE00006DBD, 0x0000A1B00003DDBF, 0x0000A5B20000ADB1, 0x0000A9B40000B9B3, 0x000095B600009DB5, 0x80009DF600005DB7, 0x00001D8100001D82, 0x80009DFA00001D80, 
0x80009E0280009DFE, 0x80009E0A000214BE, 0x80009E0E0002A884, 0x80009E1680009E12, 0x80009E1E80009E1A, 0x000349B30000008F, 0x0004E88680009E22, 0x80009E260002AC87, 
0x000349B5000349B6, 0x000329BB80009E2A, 0x80009E2E000325BA, 0x000319BF80009E32, 0x00032DBD00032DBE, 0x80009E36000331BC, 0x80009E3A00038DA3, 0x00038DA680009E3E, 
0x80009E4680009E42, 0x0003E1AA00038DA5, 0x80009E4A0003EDAB, 0x0003E9AE80009E4E, 0x0003F5AC0003DDAF, 0x000384BE0003E9AD, 0x80009E5680009E52, 0x80009E5E80009E5A, 
0x80009E6680009E62, 0x00003D8080009E6A, 0x0000198200000981, 0x80009E7280009E6E, 0x0003348480009E7A, 0x00012DB380009E7E, 0x0002CC8780009E82, 0x80009E8600054C86, 
0x00012DB500012DB6, 0x000149BB80009E8A, 0x80009E8E000179BA, 0x0001BDBF80009E92, 0x0001B9BD0001BDBE, 0x001F78E1000151BC, 0x001FD0E380009E96, 0x80009E9E80009E9A, 
0x80009EA2000194E1, 0x80009EA6000368E3, 0x80009EAE80009EAA, 0x80009EB2000388EF, 0x001FACEF80009EB6, 0x80009EBE80009EBA, 0x80009EC680009EC2, 0x80009ECE80009ECA, 
0x80009ED680009ED2, 0x80009EDA001E44EF, 0x80009EDE001EDCE1, 0x80009EE2001E1CE3, 0x80009EEE80009EEA, 0x0000698180009EF2, 0x0001E5A300006580, 0x0001E5A500007D82, 
0x0004148480009EF6, 0x000428BE0001E5A6, 0x000181AB80009EFA, 0x000171AD0001B1AA, 0x000175AF000199AC, 0x000621A8000175AE, 0x000625AA00062DA9, 0x000625AC00063DAB, 
0x00065DAE00062DAD, 0x80009E7600064DAF, 0x0003088680009EE6, 0x80009EFE00038C87, 0x80009F0680009F02, 0x0006E9B880009F0A, 0x00068DBA0006E9B9, 0x00069DBC000685BB, 
0x00068DBE000685BD, 0x00063DB0000685BF, 0x000605B200060DB1, 0x0006F9B40006EDB3, 0x0006EDB60006F9B5, 0x0007CDB00006E5B7, 0x0007D1B20007D5B1, 0x0007F5B40007EDB3, 
0x0007E9B60007FDB5, 0x0007DDB80007E9B7, 0x00072DBA000725B9, 0x00073DBC000725BB, 0x00072DBE000725BD, 0x80009F0E000725BF, 0x80009E0680009F12, 0x80009F1A80009F16, 
0x80009F2280009F1E, 0x000615A880009F26, 0x0007EDAA000619A9, 0x0007EDAC0007FDAB, 0x0007D5AE0007DDAD, 0x000605B30007B9AF, 0x80009F2E80009F2A, 0x80009F3680009F32, 
0x000605B500063DB6, 0x000671BB80009F3A, 0x80009F3E000669BA, 0x000659BF80009F42, 0x000659BD000651BE, 0x80009F46000665BC, 0x80009F4A000641A3, 0x000679A680009F4E, 
0x0001B48480009F52, 0x00062DAA000641A5, 0x000180BE000635AB, 0x000615AE80009F5A, 0x000621AC00061DAF, 0x000635A800061DAD, 0x000635AA00063DA9, 0x000675AC000659AB, 
0x0001ADAE0001A5AD, 0x0000E9800001A5AF, 0x0000FD820000E981, 0x000F3086000124BF, 0x80009F5E0000E487, 0x0000C5B880009F62, 0x0000C5BA0000CDB9, 0x0000CDBC0000DDBB, 
0x0000F5BE0000FDBD, 0x0001DDB000009DBF, 0x00012DB2000125B1, 0x000121B4000121B3, 0x000121B6000121B5, 0x0002C1BB000121B7, 0x80009F66000239BA, 0x0002C5BF80009F6A, 
0x0002D5BD0002C5BE, 0x00059DB30002D9BC, 0x80009F7280009F6E, 0x0000008C80009F76, 0x0005DDB5000205B6, 0x00027DAA80009F7A, 0x80009F7E000285AB, 0x000281AE80009F82, 
0x00029DAC000281AF, 0x80009F86000291AD, 0x80009F8A0005D9A3, 0x000241A680009F8E, 0x80009F9680009F92, 0x006A9182000599A5, 0x80009F9A006A9183, 0x0016B98680009F9E, 
0x001611840017E987, 0x0012A18A00169985, 0x80009FA20012A18B, 0x001E918E80009FA6, 0x0013998C001E598F, 0x001A7192001E118D, 0x80009FAA001AE593, 0x0006F1960024E8EF, 
0x001AE59400060597, 0x0002299A00061995, 0x80009FAE0002C59B, 0x80009FB680009FB2, 0x0002DD9C001B28E1, 0x0007219F000F20E3, 0x001B359D0007C19E, 0x001BA19B001B2D9C, 
0x001F3999001FF99A, 0x00120197001FB198, 0x0013299500132196, 0x0017199300165194, 0x0017B19100173192, 0x006B518F006B2990, 0x000D04840007ACE3, 0x00000D8000071CE1, 
0x00003D8200003581, 0x80009FBE80009FBA, 0x000D20BE80009FC2, 0x80009FCE80009FCA, 0x000C588600074CEF, 0x80009FD2000D6087, 0x80009FDA80009FD6, 0x000F5C8480009FDE, 
0x000008EF80009FE2, 0x000190E1000684EF, 0x0000E0E30006B0E1, 0x80009FE6000664E3, 0x80009FEE80009FEA, 0x80009FF680009FF2, 0x000F00BE80009FFA, 0x80009FFE000E4084, 
0x8000A0068000A002, 0x8000A00E8000A00A, 0x8000A0168000A012, 0x0003D5A38000A01A, 0x000331A10003D5A2, 0x80009F5600072DA0, 0x8000A01E80009FC6, 0x8000A0268000A022, 
0x0000918100009982, 0x000D4DA800009980, 0x000D95AA000D9DA9, 0x000E3DAC000E25AB, 0x000E11AE000E11AD, 0x000E7DB0000E11AF, 0x000E05B2000E0DB1, 0x000E39B4000E2DB3, 
0x000E2DB6000E39B5, 0x000EE9B8000E25B7, 0x000EC1BA000EE9B9, 0x000EB9BC000EC1BB, 0x000E95BE000E9DBD, 0x000D3DB3000E8DBF, 0x8000A02E8000A02A, 0x8000A0368000A032, 
0x000E95B5000EB1B6, 0x000EE9BB8000A03A, 0x00008886000E99BA, 0x000EDDBF0000E487, 0x000ED9BD000EDDBE, 0x8000A03E000EF1BC, 0x000184BE000D79A3, 0x000EF5A600068084, 
0x8000A0468000A042, 0x000EDDAA000ED1A5, 0x8000A04A000EADAB, 0x000E99AE8000A04E, 0x000EB5AC000E99AF, 0x003505B2000E9DAD, 0x00306DB0003419B3, 0x8000A05200350DB1, 
0x002801B48000A056, 0x8000A05A00293DB5, 0x8000A0628000A05E, 0x8000A06A8000A066, 0x8000A0728000A06E, 0x000145A28000A076, 0x8000A07A0001D5A3, 0x0005CDA600014DA1, 
0x000401A4003801A7, 0x003C01AA00057DA5, 0x003949A8003D45AB, 0x003175AE0039E5A9, 0x003D5DAC00317DAF, 0x000EEDA8003001AD, 0x000E09AA000EF5A9, 0x000E19AC000E09AB, 
0x000E0DAE000E19AD, 0x8000A07E000E2DAF, 0x8000A0868000A082, 0x8000A08E8000A08A, 0x8000A0968000A092, 0x000E1DB88000A09A, 0x000E2DBA000E25B9, 0x000E3DBC000E25BB, 
0x0001D5BE0001DDBD, 0x000E55B00001CDBF, 0x000E55B2000E5DB1, 0x000E35B4000E2DB3, 0x000E2DB6000E25B5, 0x000D81B3000E25B7, 0x8000A0A28000A09E, 0x8000A0AE8000A0AA, 
0x000D91B5000D99B6, 0x000D99BB000454BE, 0x00048886000D91BA, 0x000DE1BF0003BC87, 0x000DF9BD000DF1BE, 0x00004982000D81BC, 0x0003F580000DC5A3, 0x000DDDA600004981, 
0x8000A0B68000A0B2, 0x000DD5AA000DD5A5, 0x8000A0BA000DDDAB, 0x000DB5AE8000A0BE, 0x000DC5AC000DA5AF, 0x00021DA8000DBDAD, 0x00025DAA000245A9, 0x000279AC000255AB, 
0x000389AE000279AD, 0x8000A0C2000389AF, 0x8000A0CA8000A0C6, 0x0005FC848000A0CE, 0x8000A0D68000A0D2, 0x000389B88000A0DA, 0x00036DBA000365B9, 0x00037DBC000365BB, 
0x00036DBE000365BD, 0x0003C1B0000365BF, 0x0003C1B20003C1B1, 0x0003C1B40003C1B3, 0x0003C1B60003C1B5, 0x8000A0DE0003C1B7, 0x8000A0E68000A0E2, 0x8000A0EE8000A0EA, 
0x8000A0F20001A4E1, 0x000468BE000EC0E3, 0x8000A0FA8000A0F6, 0x8000A0FE00011CEF, 0x8000A1068000A102, 0x000395B38000A10A, 0x8000A1128000A10E, 0x8000A11E8000A11A, 
0x0003B1B50003B9B6, 0x000245BB8000A122, 0x0004A886000245BA, 0x000245BF0005A487, 0x000255BD000245BE, 0x000EE0E1000255BC, 0x000E08E3000C2CE1, 0x0000AD80000ED4E3, 
0x0000D1820000D181, 0x8000A12A8000A126, 0x8000A1328000A12E, 0x8000A13A8000A136, 0x000E88EF8000A13E, 0x000315A3000E2CEF, 0x002BC4858000A142, 0x8000A14A8000A146, 
0x000331A5000339A6, 0x0002C5AB8000A14E, 0x8000A1520002C5AA, 0x0002C5AF8000A156, 0x0002D5AD0002C5AE, 0x00060DA80002D5AC, 0x00065DAA000615A9, 0x000679AC000655AB, 
0x0006B9AE000679AD, 0x8000A1160006B9AF, 0x8000A15E8000A15A, 0x8000A1668000A162, 0x8000A16E8000A16A, 0x00074DB88000A172, 0x000751BA000755B9, 0x000779BC000769BB, 
0x00076DBE000765BD, 0x0006C9B0000765BF, 0x0006DDB20006C9B1, 0x0006CDB40006D5B3, 0x00077DB6000775B5, 0x0006D5B3000775B7, 0x8000A17A8000A176, 0x8000A1828000A17E, 
0x0006F1B50006F9B6, 0x00060DBB8000A186, 0x0000088600060DBA, 0x0007B1BF00002C87, 0x000601BD000609BE, 0x00005182000609BC, 0x00004180000691A3, 0x0006BDA600004181, 
0x8000A18E8000A18A, 0x000649AA0006B5A5, 0x8000A192000649AB, 0x00064DAE8000A196, 0x00064DAC0007F5AF, 0x0006B1B0000645AD, 0x0006CDB20006B1B1, 0x0006C1B40006C1B3, 
0x0006F1B60006C9B5, 0x000105B80006F1B7, 0x000105BA00010DB9, 0x000105BC00011DBB, 0x000105BE00010DBD, 0x8000A19A0001B9BF, 0x8000A1A28000A19E, 0x8000A1AA8000A1A6, 
0x8000A0A68000A1AE, 0x00062DA88000A1B2, 0x000635AA000635A9, 0x0006D1AC0006F1AB, 0x0006D1AE0006D1AD, 0x0006DDB30006D1AF, 0x8000A1BA8000A1B6, 0x8000A1C28000A1BE, 
0x000639B5000631B6, 0x000615BB8000A1C6, 0x8000A1CA000615BA, 0x00066DBF8000A1CE, 0x000675BD000665BE, 0x8000A1D2000679BC, 0x8000A1D6000699A3, 0x000675A68000A1DA, 
0x8000A1E28000A1DE, 0x000651AA00067DA5, 0x8000A1E6000651AB, 0x000621AE8000A1EA, 0x00063DAC000629AF, 0x0002D5A8000631AD, 0x0002E1AA0002DDA9, 0x000351AC0002E1AB, 
0x000351AE000351AD, 0x8000A1EE000351AF, 0x0003ECBE8000A1F2, 0x8000A1FE8000A1FA, 0x8000A2068000A202, 0x0003E9B88000A20A, 0x000389BA0003E9B9, 0x00039DBC000385BB, 
0x000381BE000381BD, 0x000331B00003B5BF, 0x000335B2000331B1, 0x0003F9B40003E9B3, 0x0003E9B60003F9B5, 0x00036D800003E1B7, 0x0000AD820000A581, 0x8000A20E000265B3, 
0x0003DDB60003D5B5, 0x0002E0848000A212, 0x0003F9BA8000A216, 0x0003EDBC0003F9BB, 0x000331BE000331BD, 0x0003EC87000331BF, 0x000000B2003C6486, 0x8000A21E8000A21A, 
0x8000A222000408E3, 0x8000A2260006ECE1, 0x8000A22A000600EF, 0x8000A2328000A22E, 0x8000A23A8000A236, 0x8000A2428000A23E, 0x8000A24A8000A246, 0x0003A0E38000A24E, 
0x0001A8E18000A252, 0x0003F0EF8000A256, 0x00001D8100001D82, 0x8000A25A00001D80, 0x8000A2628000A25E, 0x003D4CBE8000A26A, 0x0003A1A38000A26E, 0x000211A5003C40BE, 
0x8000A2768000A272, 0x00026C84000219A6, 0x00023DAB8000A27A, 0x0002F5AD00023DAA, 0x0002F5AF000229AC, 0x003C40860002F5AE, 0x8000A27E003DB487, 0x8000A2868000A282, 
0x8000A28E8000A28A, 0x8000A292000644EF, 0x8000A2960006D4E1, 0x8000A29A00070CE3, 0x8000A2A28000A29E, 0x0001F5B38000A2A6, 0x8000A2AE8000A2AA, 0x8000A2B68000A2B2, 
0x0001E5B5000145B6, 0x000131BB8000A2BA, 0x8000A2BE000129BA, 0x00011DBF8000A2C2, 0x000119BD00011DBE, 0x003E2DA8000125BC, 0x003E3DAA003E35A9, 0x003E2DAC003E35AB, 
0x003E85AE003E85AD, 0x8000A266003EB9AF, 0x8000A2CA8000A2C6, 0x000019808000A2CE, 0x0000058200001981, 0x003EB9B88000A2D2, 0x003F49BA003EB9B9, 0x003F59BC003F49BB, 
0x003F4DBE003F59BD, 0x003EADB0003F41BF, 0x003EB1B2003EB5B1, 0x003E99B4003E8DB3, 0x003E89B6003E99B5, 0x003EB5A3003E89B7, 0x8000A2D600028C84, 0x8000A2DE8000A2DA, 
0x003EA5A5003E05A6, 0x003E71AB8000A2E2, 0x00000886003E69AA, 0x003E5DAF00036887, 0x003E59AD003E5DAE, 0x8000A2E6003E65AC, 0x8000A2EA003F91B3, 0x003F59B68000A2EE, 
0x8000A2F68000A2F2, 0x003F75BA003FB9B5, 0x8000A2FA003F7DBB, 0x003F41BE8000A2FE, 0x003F59BC003F41BF, 0x003E95B0003F55BD, 0x003EA9B2003E9DB1, 0x003EA1B4003EA5B3, 
0x003EA1B6003EA1B5, 0x003EE5B8003EA1B7, 0x003EE5BA003EEDB9, 0x003EEDBC003EFDBB, 0x003ED5BE003EDDBD, 0x8000A302000119BF, 0x8000A30A8000A306, 0x8000A3128000A30E, 
0x8000A3168000A1F6, 0x003E5DA88000A31A, 0x003E3DAA003E21A9, 0x003E15AC003E35AB, 0x003EF5AE003EFDAD, 0x003ED5A3003EEDAF, 0x8000A3228000A31E, 0x8000A32A8000A326, 
0x003EFDA5003E1DA6, 0x003E39AB8000A32E, 0x8000A332003E31AA, 0x003E05AF8000A336, 0x003E11AD003E05AE, 0x00001181003E1DAC, 0x8000A33A00000D80, 0x8000A33E00001982, 
0x000194848000A342, 0x00074086000010BE, 0x8000A34A00010087, 0x8000A3528000A34E, 0x8000A35A8000A356, 0x00028DA88000A35E, 0x000295AA000295A9, 0x0002D9AC0002CDAB, 
0x0002CDAE0002D9AD, 0x8000A3620002C5AF, 0x8000A36A8000A366, 0x0000008C8000A36E, 0x8000A3768000A372, 0x00031DB88000A37A, 0x0003C1BA0003C1B9, 0x0003C1BC0003C1BB, 
0x0003F1BE0003C9BD, 0x000289B00003F1BF, 0x000329B2000289B1, 0x000339B4000329B3, 0x000329B6000339B5, 0x00021DB3000325B7, 0x8000A3828000A37E, 0x8000A38A8000A386, 
0x000251B5000259B6, 0x00024DBB8000A38E, 0x8000A39200024DBA, 0x0003FDBF8000A396, 0x0003FDBD0003FDBE, 0x8000A39A0003FDBC, 0x8000A3A28000A39E, 0x003E0CE18000A3A6, 
0x003FA8E38000A3AA, 0x00003D818000A3AE, 0x003F50EF00003180, 0x8000A3B200001D82, 0x000518860004F8BE, 0x00020C8400034C87, 0x8000A3BA0000CCE3, 0x8000A3BE0001BCE1, 
0x8000A3C68000A3C2, 0x8000A3CE8000A3CA, 0x8000A3D200052C84, 0x8000A3DA8000A3D6, 0x8000A3DE000010EF, 0x0003DDA38000A3E2, 0x8000A3EA8000A3E6, 0x8000A3F28000A3EE, 
0x000391A5000399A6, 0x00038DAB8000A3F6, 0x8000A3FA00038DAA, 0x00023DAF8000A3FE, 0x00023DAD00023DAE, 0x8000A40200023DAC, 0x8000A40A8000A406, 0x8000A4128000A40E, 
0x8000A41A8000A416, 0x8000A41E003E28EF, 0x8000A422003E3CE1, 0x00002980000138E3, 0x0000118200001581, 0x000231B38000A42A, 0x0004C0840004C8BE, 0x8000A4328000A42E, 
0x000221B5000229B6, 0x0001CDBB8000A436, 0x8000A43A0001CDBA, 0x000175BF8000A43E, 0x0001C1BD0001C9BE, 0x0005E9A80001C9BC, 0x0005F9AA0005E9A9, 0x0005E9AC0005F9AB, 
0x000639AE0005E9AD, 0x8000A3B6000639AF, 0x000088868000A426, 0x8000A44200034087, 0x8000A44A8000A446, 0x0006D1B88000A44E, 0x0006E1BA0006D9B9, 0x000691BC0006E1BB, 
0x000691BE000691BD, 0x000649B0000691BF, 0x00065DB2000649B1, 0x00064DB4000655B3, 0x0006F1B60006F1B5, 0x000571A30006F1B7, 0x8000A4568000A452, 0x8000A45E8000A45A, 
0x000561A5000569A6, 0x00068DAB8000A462, 0x8000A46600068DAA, 0x000635AF8000A46A, 0x000681AD000689AE, 0x8000A46E000689AC, 0x8000A4720007D1B3, 0x0007F1B68000A476, 
0x8000A47E8000A47A, 0x0007D1BA0007C1B5, 0x8000A4820007DDBB, 0x0007B9BE8000A486, 0x0007C5BC0007B9BF, 0x000669B80007B9BD, 0x000689BA000669B9, 0x000699BC000689BB, 
0x000689BE000699BD, 0x000611B0000689BF, 0x000615B200061DB1, 0x000679B4000669B3, 0x000669B6000679B5, 0x000649A8000661B7, 0x00065DAA000655A9, 0x00064DAC000655AB, 
0x000671AE000675AD, 0x8000A346000671AF, 0x00001D8100001D82, 0x8000A48A00001D80, 0x8000A4928000A48E, 0x000695A3000170BE, 0x000028868000A49A, 0x8000A49E00014887, 
0x000685A50006B5A6, 0x000699AB8000A4A2, 0x8000A4A6000695AA, 0x0006FDAF8000A4AA, 0x0006FDAD0006FDAE, 0x8000A4AE000681AC, 0x8000A4B2000615B3, 0x00063DB68000A4B6, 
0x8000A4BE8000A4BA, 0x0001D9BA000635B5, 0x8000A4C20001D9BB, 0x00017DBE8000A4C6, 0x00017DBC000165BF, 0x0005BDA8000175BD, 0x0005D9AA0005C9A9, 0x0005F9AC0005D1AB, 
0x000229AE0005F9AD, 0x8000A4CA000229AF, 0x8000A4D28000A4CE, 0x0000008C8000A4D6, 0x8000A4DE8000A4DA, 0x0002EDB88000A4E2, 0x000281BA000285B9, 0x000285BC000281BB, 
0x0002B1BE00028DBD, 0x000259B00002B1BF, 0x0002EDB2000259B1, 0x0002FDB40002E5B3, 0x0002E5B60002E5B5, 0x000551A30002D5B7, 0x8000A4EA8000A4E6, 0x8000A4F28000A4EE, 
0x000571A5000579A6, 0x00029DAB8000A4F6, 0x8000A4FA00029DAA, 0x000221AF8000A4FE, 0x000231AD000239AE, 0x00006D81000239AC, 0x8000A50200006D80, 0x000C5CBE00000582, 
0x8000A50E8000A50A, 0x0003EC840006D0EF, 0x8000A51200051CE1, 0x8000A5160007FCE3, 0x000CD8868000A51A, 0x000285A8000CBC87, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x8000A51E0002D1AF, 0x8000A5268000A522, 0x8000A52E8000A52A, 0x8000A5368000A532, 0x000175B88000A53A, 0x000175BA00017DB9, 0x0001D9BC0001C9BB, 
0x0001C9BE0001D9BD, 0x0002B5B00001C1BF, 0x000281B20002BDB1, 0x000151B4000281B3, 0x000151B6000151B5, 0x8000A53E000151B7, 0x8000A542000D0484, 0x000C1CBE8000A546, 
0x00001CEF8000A54A, 0x000190E10006A0EF, 0x000670E3000744E1, 0x8000A54E000698E3, 0x8000A5568000A552, 0x00025DB38000A55A, 0x8000A5628000A55E, 0x8000A56A8000A566, 
0x000275B5000215B6, 0x000239BB8000A56E, 0x8000A572000231BA, 0x0001D5BF8000A57A, 0x000215BD0001D5BE, 0x000D9DA3000215BC, 0x8000A5768000A506, 0x8000A5828000A57E, 
0x000DB5A5000DD5A6, 0x000DF9AB8000A586, 0x00030886000DF1AA, 0x000E15AF00036087, 0x000DD5AD000E15AE, 0x000F9180000DD5AC, 0x000FA182000F9981, 0x8000A58A000EA5B3, 
0x000F79B6000EA1B5, 0x8000A5928000A58E, 0x000F45BA8000A596, 0x000F45BC000F5DBB, 0x000F45BE000F4DBD, 0x000E55A8000FFDBF, 0x000E61AA000E5DA9, 0x000E65AC000E7DAB, 
0x000FBDAE000FB5AD, 0x8000A59A000FB5AF, 0x8000A5A28000A59E, 0x8000A5AA8000A5A6, 0x8000A5B28000A5AE, 0x000F55B88000A5B6, 0x000F7DBA000F75B9, 0x000F6DBC000F75BB, 
0x000F11BE000F11BD, 0x000FCDB0000F11BF, 0x000FDDB2000FD5B1, 0x000FCDB4000FD5B3, 0x000F71B6000F75B5, 0x000FE9A3000F71B7, 0x8000A5BE8000A5BA, 0x8000A5C68000A5C2, 
0x000FEDA5000E35A6, 0x000E11AB8000A5CA, 0x8000A5CE000E09AA, 0x000EB1AF8000A5D2, 0x000E01AD000E09AE, 0x8000A5D6000E09AC, 0x00001D8100001D82, 0x8000A5DA00001D80, 
0x8000A5E28000A5DE, 0x0001AC84000194BE, 0x0001E0878000A5E6, 0x8000A5EA0000CC86, 0x8000A5F28000A5EE, 0x000E6DA88000A496, 0x000199AA000189A9, 0x0001C1AC000191AB, 
0x0001F9AE0001C9AD, 0x0000A0840001F9AF, 0x8000A5FA8000A5F6, 0x8000A6028000A5FE, 0x8000A60A8000A606, 0x0000C5B88000A60E, 0x0000C5BA0000CDB9, 0x0000CDBC0000DDBB, 
0x0000F5BE0000FDBD, 0x000141B000009DBF, 0x000141B2000141B1, 0x000141B4000141B3, 0x000141B6000141B5, 0x000211B3000141B7, 0x8000A6168000A612, 0x8000A61E8000A61A, 
0x000249B5000249B6, 0x000285BB8000A622, 0x8000A626000285BA, 0x000285BF8000A62A, 0x000295BD000285BE, 0x001A3C85000295BC, 0x8000A62E000255A3, 0x00020DA68000A632, 
0x8000A63A8000A636, 0x0002C1AA00020DA5, 0x8000A63E0002C1AB, 0x0002C1AE8000A642, 0x0002D1AC0002C1AF, 0x000019820002D1AD, 0x000019808000A646, 0x8000A64A00001981, 
0x8000A6528000A64E, 0x000400BE8000A65A, 0x8000A6628000A65E, 0x8000A66A8000A666, 0x8000A6728000A66E, 0x000EE8EF8000A676, 0x0004E8868000A67A, 0x8000A67E00035087, 
0x000280EF8000A682, 0x000194E18000A686, 0x000158E38000A68A, 0x000E00E38000A68E, 0x000D68E18000A692, 0x000271A88000A696, 0x000271AA000271A9, 0x0002B9AC0002A9AB, 
0x0002A9AE0002B9AD, 0x0005AC840002A9AF, 0x8000A69E8000A69A, 0x8000A6A68000A6A2, 0x8000A6AE8000A6AA, 0x00016DB88000A6B2, 0x000105BA00010DB9, 0x000109BC000119BB, 
0x000135BE00013DBD, 0x0002D9B00001D9BF, 0x00016DB20002D9B1, 0x00017DB4000165B3, 0x000165B6000165B5, 0x000F60E1000155B7, 0x000E1CE30000F4E3, 0x8000A6B60001BCE1, 
0x0000318100003982, 0x8000A6BA00003D80, 0x8000A6BE000428BE, 0x00073CBE8000A6C2, 0x000ED0EF000010EF, 0x0004E0868000A6CA, 0x8000A6CE0004C887, 0x8000A6D20002B5B3, 
0x000275B600027DB5, 0x8000A6DA8000A6D6, 0x000251BA8000A6DE, 0x0001F5BC000251BB, 0x0001F5BE0001FDBD, 0x8000A6560001EDBF, 0x0005B1AA8000A6C6, 0x000615AC0005B1AB, 
0x000615AE00061DAD, 0x8000A6E200060DAF, 0x8000A6EA8000A6E6, 0x8000A6EE000555A3, 0x000595A600059DA5, 0x0006E9B38000A6F2, 0x8000A6FA8000A6F6, 0x8000A7028000A6FE, 
0x0006E9B50006E1B6, 0x0006B1BB8000A706, 0x8000A70A0006A1BA, 0x00069DBF8000A70E, 0x0006A5BD000691BE, 0x00061DA80006A9BC, 0x000621AA000621A9, 0x000621AC000621AB, 
0x000621AE000621AD, 0x8000A712000621AF, 0x8000A71A8000A716, 0x8000A7228000A71E, 0x8000A72A8000A726, 0x0007E5B88000A72E, 0x0007E5BA0007EDB9, 0x0007E5BC0007FDBB, 
0x0007E5BE0007EDBD, 0x000625B000074DBF, 0x00063DB2000635B1, 0x000615B4000631B3, 0x00060DB6000619B5, 0x0007A9A3000601B7, 0x0001B58100001582, 0x8000A7320001B580, 
0x0007A9A50007A1A6, 0x0007F1AB8000A736, 0x0002A0840007E1AA, 0x0007DDAF8000A73A, 0x0007E5AD0007D1AE, 0x8000A73E0007E9AC, 0x0000E886000695B3, 0x0006B5B600011887, 
0x8000A7468000A742, 0x000149BA0006BDB5, 0x8000A74A000155BB, 0x000139BE8000A74E, 0x000145BC000139BF, 0x00063DA8000139BD, 0x000659AA00064DA9, 0x000671AC000651AB, 
0x0001B9AE000671AD, 0x0001AC840001B9AF, 0x8000A7568000A752, 0x8000A75E8000A75A, 0x8000A7668000A762, 0x0001A9B88000A76A, 0x000169BA0001A9B9, 0x000179BC000169BB, 
0x000169BE000179BD, 0x0001C9B0000169BF, 0x0001D5B20001D5B1, 0x0001B9B40001A9B3, 0x0001A9B60001B9B5, 0x0005D1A30001A1B7, 0x8000A7728000A76E, 0x8000A77A8000A776, 
0x0005F9A50005F1A6, 0x000211AB8000A77E, 0x8000A78200020DAA, 0x00027DAF8000A786, 0x00027DAD00027DAE, 0x8000A78A000201AC, 0x8000A7928000A78E, 0x000031818000A796, 
0x8000A79A00000D80, 0x8000A79E00003982, 0x000324BE8000A7A2, 0x8000A7AE8000A7AA, 0x001CD8868000A7B2, 0x8000A7B600034C87, 0x8000A7BE8000A7BA, 0x000120E3001CC084, 
0x0001C8E18000A7C2, 0x000230EF8000A7C6, 0x8000A7CE8000A7CA, 0x8000A7D68000A7D2, 0x8000A7DE8000A7DA, 0x000395B38000A7E2, 0x8000A7EA8000A7E6, 0x8000A7F28000A7EE, 
0x0003B1B50003B9B6, 0x000351BB8000A7F6, 0x8000A7FA000349BA, 0x0000F5BF8000A7FE, 0x000341BD000349BE, 0x00022DA8000349BC, 0x00025DAA000245A9, 0x000279AC000255AB, 
0x0002BDAE000279AD, 0x001D68BE0002B5AF, 0x8000A8068000A802, 0x00001D808000A80A, 0x0000A98200000981, 0x000151B88000A80E, 0x000161BA000159B9, 0x000111BC000161BB, 
0x000111BE000111BD, 0x0002CDB0000111BF, 0x0002DDB20002D5B1, 0x0002CDB40002D5B3, 0x000171B6000171B5, 0x000658E1000171B7, 0x0000B0E3000754E1, 0x8000A8120006BCE3, 
0x001C18868000A81A, 0x8000A81E001D5487, 0x8000A8268000A822, 0x001CF8BE8000A82A, 0x0006F0EF8000A82E, 0x000295A30006E0EF, 0x8000A8368000A832, 0x8000A83E8000A83A, 
0x0002B1A50002B9A6, 0x000251AB8000A842, 0x8000A846000249AA, 0x0001F5AF8000A84A, 0x000241AD000249AE, 0x001E6DA8000249AC, 0x001E7DAA001E75A9, 0x001E95AC001E8DAB, 
0x001E8DAE001E9DAD, 0x8000A816001E81AF, 0x8000A8528000A84E, 0x8000A85A8000A856, 0x8000A8628000A85E, 0x001E89B88000A866, 0x001E99BA001E89B9, 0x001EB9BC001E91BB, 
0x001F7DBE001EB9BD, 0x001EC5B0001F75BF, 0x001EC5B2001ECDB1, 0x001EC5B4001EDDB3, 0x001EC5B6001ECDB5, 0x001EF5B3001EB9B7, 0x8000A86E8000A86A, 0x8000A8768000A872, 
0x001E1DB5001E1DB6, 0x001E09BB8000A87A, 0x8000A87E001E01BA, 0x001E09BF8000A882, 0x001E09BD001E01BE, 0x00006D82001E11BC, 0x00005580001EB1A3, 0x001E59A600006581, 
0x0001D0BF00039884, 0x001E45AA001E59A5, 0x00040086001E4DAB, 0x001E45AE00019887, 0x001E55AC001E4DAF, 0x8000A88A001E4DAD, 0x000024848000A88E, 0x8000A8968000A892, 
0x8000A7A68000A89A, 0x001EB5A88000A886, 0x001E8DAA001E85A9, 0x001E9DAC001E85AB, 0x001EFDAE001E81AD, 0x001E8DB0001EF5AF, 0x001E95B2001E95B1, 0x001EBDB4001EA5B3, 
0x000171B6000171B5, 0x000151B8000171B7, 0x000151BA000151B9, 0x0001F5BC000151BB, 0x0001F5BE0001FDBD, 0x001E25B30001EDBF, 0x8000A89E000708BE, 0x8000A8A68000A8A2, 
0x001E35B5001E21B6, 0x001E71BB8000A8AA, 0x8000A8AE001E69BA, 0x000195BF8000A8B2, 0x001E51BD001E59BE, 0x8000A8B6001E61BC, 0x8000A8BA001E61A3, 0x001E65A68000A8BE, 
0x8000A8C68000A8C2, 0x001E2DAA001E71A5, 0x8000A8CA001E35AB, 0x001E1DAE8000A8CE, 0x001E25AC0001D1AF, 0x001A54E1001E15AD, 0x000A5CE38000A8D2, 0x8000A8DA8000A8D6, 
0x8000A8E28000A8DE, 0x8000A8EA8000A8E6, 0x8000A8EE0005A8BE, 0x002A318F8000A8F2, 0x00FBC4EF8000A8FA, 0x002E61938000A8FE, 0x002AD991002F1D92, 0x0012D997002A4990, 
0x00130D9500127596, 0x001B1D9B002EC194, 0x001649990016419A, 0x001E719F00170D98, 0x001A719D001B119E, 0x0002A1A3001A799C, 0x001F95A100039DA2, 0x000188E3001E89A0, 
0x000068E1001E08E3, 0x0001DCEF001EFCE1, 0x00FE89B5001F7CEF, 0x00FA01B300FC01B4, 0x00F801B100FA95B2, 0x00F6E1AF00F611B0, 0x00F225AD00F401AE, 0x00F001AB00F2EDAC, 
0x000ED5A9000FE9AA, 0x000C01A7000EDDA8, 0x000AEDA5000AC9A6, 0x0006E1A3000801A4, 0x0003E5A10006F1A2, 0x002B01828000A902, 0x8000A906002B0183, 0x002F31868000A90A, 
0x002B8984002F8987, 0x0012758A002E4585, 0x000508860013058B, 0x0017118E00056C87, 0x0013B18C0017118F, 0x001A3D9200165D8D, 0x0005C884001B4193, 0x001F519600070084, 
0x001B5194001F5197, 0x001E7D9A001A3995, 0x8000A90E00027D9B, 0x000159818000A912, 0x0003599C00015580, 0x0007C8BE00015182, 0x8000A91A8000A916, 0x8000A9228000A91E, 
0x8000A92A8000A926, 0x8000A92E001ED4EF, 0x8000A932001E24E1, 0x8000A936000168E3, 0x8000A93E8000A93A, 0x000269BB8000A942, 0x8000A946000259BA, 0x00021DBF8000A94A, 
0x000219BD00021DBE, 0x0002EDB3000271BC, 0x8000A9528000A94E, 0x8000A95A8000A956, 0x0002EDB500027DB6, 0x00050DA38000A95E, 0x8000A9628000A8F6, 0x8000A9668000A96A, 
0x00050DA500059DA6, 0x000589AB8000A96E, 0x000308860005B9AA, 0x0005FDAF00037C87, 0x0005F9AD0005FDAE, 0x0007B180000591AC, 0x000041820007B981, 0x8000A9720006B1B3, 
0x000731B6000759B5, 0x8000A97A8000A976, 0x0007E1BA8000A97E, 0x0007E1BC0007E1BB, 0x0007E1BE0007E1BD, 0x0006B5A80007DDBF, 0x000675AA0006B9A9, 0x00079DAC000785AB, 
0x0007F5AE0007FDAD, 0x8000A982000719AF, 0x8000A98A8000A986, 0x8000A9928000A98E, 0x8000A99A8000A996, 0x000775B88000A99E, 0x000775BA00077DB9, 0x00071DBC000705BB, 
0x000731BE000731BD, 0x000769B0000731BF, 0x000779B2000769B1, 0x000769B4000779B3, 0x000751B6000755B5, 0x0007FDA300074DB7, 0x8000A9A68000A9A2, 0x8000A9AE8000A9AA, 
0x000615A500067DA6, 0x0006ADAB8000A9B2, 0x8000A9B60006ADAA, 0x000691AF8000A9BA, 0x0006ADAD0006ADAE, 0x8000A9BE0006ADAC, 0x8000A9C68000A9C2, 0x00001D808000A9CA, 
0x0000398200000981, 0x8000A9D28000A9CE, 0x0000C8868000A9DA, 0x8000A9DE0001A487, 0x8000A9E68000A9E2, 0x00018DA88000A9EA, 0x0001D9AA000199A9, 0x0001F1AC0001D1AB, 
0x000139AE0001F1AD, 0x0000A084000139AF, 0x8000A9F28000A9EE, 0x8000A9FA8000A9F6, 0x8000AA028000A9FE, 0x0000CDB88000AA06, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 
0x00009DBE000095BD, 0x000149B0000095BF, 0x000159B2000149B1, 0x000149B4000159B3, 0x0000FDB6000149B5, 0x000405BA0000F5B7, 0x0007E1B8000409BB, 0x000409BE0007E1B9, 
0x000409BC000409BF, 0x00078DB2000409BD, 0x0007B5B00007E5B3, 0x0007E5B6000785B1, 0x0007F1B40007EDB7, 0x00074DAA0007F1B5, 0x000749A8000755AB, 0x0007DDAE000749A9, 
0x00074DAC0007C5AF, 0x8000AA0A0007D5AD, 0x8000AA128000AA0E, 0x8000AA1A8000AA16, 0x8000AA228000AA1E, 0x0002D1B38000AA26, 0x8000AA2E8000AA2A, 0x8000AA32000C00BE, 
0x0002F9B50002F1B6, 0x00020DBB8000AA36, 0x8000AA3A00020DBA, 0x00020DBF8000AA3E, 0x00020DBD00020DBE, 0x0000158200020DBC, 0x00006180000295A3, 0x0002B5A600006181, 
0x8000AA4A8000AA42, 0x000249AA0002BDA5, 0x000CC886000249AB, 0x000249AE000CAC87, 0x000249AC000249AF, 0x000265A8000249AD, 0x00027DAA000275A9, 0x00026DAC000275AB, 
0x0002B1AE0002B1AD, 0x000DA0840002B1AF, 0x8000AA528000AA4E, 0x8000AA5A8000AA56, 0x8000AA628000AA5E, 0x000131B88000AA66, 0x000131BA000131B9, 0x0001D5BC000131BB, 
0x0001C9BE0001DDBD, 0x0002D1B00001C1BF, 0x0002D1B20002D1B1, 0x000111B40002D1B3, 0x000111B6000111B5, 0x0006B0E1000111B7, 0x0006D0E38000AA6A, 0x8000AA6E000F4084, 
0x8000AA720001A4E1, 0x8000AA760006C0E3, 0x8000AA7E8000AA7A, 0x000000EC0006D4EF, 0x000764EF8000AA82, 0x8000AA8A8000AA86, 0x8000AA928000AA8E, 0x8000AA960002B9B3, 
0x00027DB60002A9B5, 0x8000AA9E8000AA9A, 0x000259BA8000AAA2, 0x000249BC000259BB, 0x000199BE000249BD, 0x000D75A3000199BF, 0x8000AAA68000AA46, 0x8000AAAE8000AAAA, 
0x000D65A5000DB1A6, 0x000D95AB8000AAB2, 0x0003A4BE000D95AA, 0x000E55AF8000AAB6, 0x000D85AD000E55AE, 0x00004D80000D85AC, 0x0000558200005581, 0x8000AABA000F65B3, 
0x000F6DB6000F65B5, 0x000340868000AABE, 0x000FEDBA00031487, 0x000FE9BC000FFDBB, 0x000FDDBE000FD5BD, 0x000E59A8000FD5BF, 0x000FA1AA000FA1A9, 0x000FA1AC000FA1AB, 
0x000FA1AE000FA1AD, 0x8000AAC2000FA1AF, 0x8000AACA8000AAC6, 0x8000AAD28000AACE, 0x8000AADA8000AAD6, 0x000F01B88000AADE, 0x000F01BA000F01B9, 0x000F0DBC000F1DBB, 
0x000F3DBE000F35BD, 0x000F65B00000D5BF, 0x000F71B2000F75B1, 0x000F55B4000F4DB3, 0x000F4DB6000F5DB5, 0x000E29A3000F41B7, 0x8000AAE68000AAE2, 0x8000AAEE8000AAEA, 
0x000E29A5000E21A6, 0x000EB1AB8000AAF2, 0x8000AAF6000EA1AA, 0x000E99AF8000AAFA, 0x000E99AD000E91AE, 0x8000AAFE000EA5AC, 0x8000AB068000AB02, 0x000D24EF8000AB0A, 
0x8000AB128000AB0E, 0x000ED0E38000AB16, 0x000E18E18000AB1A, 0x000015808000AB1E, 0x0000058200001981, 0x0001D1A88000AB22, 0x000129AA0001D9A9, 0x000139AC000129AB, 
0x000129AE000139AD, 0x000168BE000129AF, 0x0001C8868000AB2A, 0x8000AB2E0000AC87, 0x8000AB368000AB32, 0x0000EDB88000AB3A, 0x00008DBA000085B9, 0x00009DBC000085BB, 
0x000081BE000081BD, 0x000159B0000081BF, 0x0000EDB2000159B1, 0x0000FDB40000E5B3, 0x0000E5B60000E5B5, 0x0002A1B30000D5B7, 0x8000AB428000AB3E, 0x8000AB4A8000AB46, 
0x0002B1B50002B9B6, 0x00029DBB8000AB4E, 0x8000AB5200029DBA, 0x000321BF8000AB56, 0x000331BD000339BE, 0x00F5F885000339BC, 0x8000AB5A0002E5A3, 0x0002FDA68000AB5E, 
0x8000AB668000AB62, 0x0002D9AA0002F5A5, 0x8000AB6A0002D9AB, 0x00037DAE8000AB6E, 0x00037DAC000365AF, 0x0000E9B8000375AD, 0x000069BA0000E9B9, 0x000079BC000069BB, 
0x00006DBE000065BD, 0x0000B1B0000065BF, 0x000081B20000B9B1, 0x0000F9B4000081B3, 0x0000EDB60000F9B5, 0x000365A80000E5B7, 0x00037DAA000375A9, 0x00036DAC000375AB, 
0x0000D1AE0000D1AD, 0x8000AB720000D1AF, 0x8000AB7A8000AB76, 0x8000AB7E8000A9D6, 0x8000AB868000AB82, 0x0001FD808000AB8A, 0x0000198200000981, 0x8000AB928000AB8E, 
0x8000AB9A000244BE, 0x0002AC848000AB9E, 0x0002F8878000ABA2, 0x8000ABA60005AC86, 0x8000ABAE8000ABAA, 0x0002F5B38000ABB2, 0x8000ABBA8000ABB6, 0x8000ABC28000ABBE, 
0x0002E5B5000151B6, 0x00017DBB8000ABC6, 0x8000ABCA000175BA, 0x00013DBF8000ABCE, 0x000155BD00013DBE, 0x000F70E1000155BC, 0x000EB8E38000ABD2, 0x0000C8EF0005C084, 
0x8000ABDA8000ABD6, 0x000E3CE38000ABDE, 0x0001D0E18000ABE2, 0x000774848000ABE6, 0x000168EF8000ABEA, 0x8000ABF28000ABEE, 0x0001CDA6000279A5, 0x000021808000ABF6, 
0x0007DD8200002181, 0x0001C9AC000269A3, 0x0001A1AE0001C9AD, 0x8000ABFA0001A1AF, 0x0001E9AA8000ABFE, 0x8000AB960001E1AB, 0x000240BE8000AC02, 0x000330868000AC06, 
0x8000AC0A00033087, 0x000739A88000AC0E, 0x00070DAA000739A9, 0x000705AC00071DAB, 0x000705AE00070DAD, 0x000709B0000779AF, 0x000719B2000709B1, 0x000739B4000711B3, 
0x0007DDB6000739B5, 0x0007F9B80007C9B7, 0x0007CDBA0007F9B9, 0x0007C5BC0007C1BB, 0x0007B9BE0007C9BD, 0x0007A5B30007B1BF, 0x8000AC168000AC12, 0x8000AC1E8000AC1A, 
0x0007ADB50007ADB6, 0x0007EDBB8000AC22, 0x8000AC260007EDBA, 0x0007DDBF8000AC2A, 0x0007E5BD0007DDBE, 0x8000AC2E0007EDBC, 0x8000AC320007E1A3, 0x0007E9A68000AC36, 
0x8000AC3E8000AC3A, 0x0007A9AA0007E9A5, 0x8000AC420007A9AB, 0x000799AE8000AC46, 0x0007A9AC000799AF, 0x8000AC4A0007A1AD, 0x8000AC528000AC4E, 0x8000AC5A8000AC56, 
0x8000AC628000AC5E, 0x000011818000AC66, 0x8000AC6A00000D80, 0x8000AC6E00001982, 0x0001E4BE8000AC72, 0x0000E0868000AC76, 0x8000AC7A00011887, 0x8000AC828000AC7E, 
0x8000AC8A8000AC86, 0x8000AC8E0004B0EF, 0x8000AC920006D4E1, 0x8000AC9600045CE3, 0x8000AC9E8000AC9A, 0x000199A88000ACA2, 0x00010DAA000199A9, 0x00011DAC000105AB, 
0x000105AE000105AD, 0x00018884000135AF, 0x8000ACAA8000ACA6, 0x8000ACB28000ACAE, 0x8000ACBA8000ACB6, 0x0000C1B88000ACBE, 0x0000C1BA0000C1B9, 0x0000C1BC0000C1BB, 
0x0000C1BE0000C1BD, 0x00014DB00000C1BF, 0x000121B2000125B1, 0x000125B4000121B3, 0x000111B600012DB5, 0x8000ACC2000111B7, 0x00028DB38000ACC6, 0x00029DB58000ACCA, 
0x8000ACD28000ACCE, 0x8000ACD600028DB6, 0x0002E9BB8000ACDA, 0x0002FDBD000281BA, 0x0002E1BF0002FDBC, 0x8000ACDE0002E9BE, 0x0002C5A50002D5A6, 0x0002D5A3000308BE, 
0x0000198100002D82, 0x0002B9AF00007980, 0x0002A5AD0002B1AE, 0x0002B1AB0002A5AC, 0x8000ACE20002D9AA, 0x000234EF8000ACEA, 0x000318878000ACEE, 0x8000ACF200FC2C86, 
0x8000ACFA8000ACF6, 0x8000AD028000ACFE, 0x8000AD0A8000AD06, 0x000100E38000AD0E, 0x0001E0E18000AD12, 0x0003B5BA8000AD16, 0x8000AD1A0003BDBB, 0x000379BE8000AD1E, 
0x0003A5BC000379BF, 0x8000AB26000379BD, 0x8000AD220003B5B3, 0x000391B68000AD26, 0x8000AD2E8000AD2A, 0x000249A80003A5B5, 0x000259AA000249A9, 0x000249AC000259AB, 
0x000271AE000275AD, 0x00FD68BE00026DAF, 0x8000AD3200FFA4BE, 0x8000AD3A8000AD36, 0x8000AD428000AD3E, 0x0002F9B88000AD46, 0x000149BA0002F9B9, 0x00015DBC000149BB, 
0x000141BE000141BD, 0x000215B000017DBF, 0x000215B200021DB1, 0x0002D9B40002C9B3, 0x0002C9B60002D9B5, 0x000620E30002C9B7, 0x000180E10006B0E1, 0x00000D80000610E3, 
0x00003D8200003581, 0x8000AD4E8000AD4A, 0x8000AD5A8000AD52, 0x000070EF8000AD5E, 0x8000AD668000AD62, 0x00FD8C8400014CEF, 0x000299A38000AD6A, 0x000289A58000AD6E, 
0x8000AD768000AD72, 0x00FCC0860002BDA6, 0x000291AB00FCE487, 0x000255AD000299AA, 0x000255AF000289AC, 0x00FE7DA8000255AE, 0x00FE99AA00FE81A9, 0x00FE89AC00FE99AB, 
0x00FEB9AE00FE89AD, 0x8000AD5600FEB9AF, 0x8000AD7E8000AD7A, 0x8000AD868000AD82, 0x8000AD8E8000AD8A, 0x00FEB5B88000AD92, 0x00FF61BA00FEBDB9, 0x00FF61BC00FF61BB, 
0x00FF61BE00FF61BD, 0x00FEC9B000FF61BF, 0x00FEDDB200FEC9B1, 0x00FEB9B400FED1B3, 0x00FE91B600FEB9B5, 0x00FE11B300FE91B7, 0x8000AD9A8000AD96, 0x8000ADA28000AD9E, 
0x00FE01B500FE09B6, 0x00FE0DBB8000ADA6, 0x8000ADAA00FE0DBA, 0x00FE7DBF8000ADAE, 0x00FE05BD00FE7DBE, 0x8000ADB200FE09BC, 0x8000ADB600FE55A3, 0x00FE4DA68000ADBA, 
0x8000ADC28000ADBE, 0x00FE49AA00FE45A5, 0x0003288400FE49AB, 0x00FE39AE8000ADC6, 0x00FE4DAC00FE39AF, 0x0001CD8000FE41AD, 0x0001D1820001D181, 0x8000ADCA00FEB9B3, 
0x00FED5B600FED1B5, 0x000160868000ADCE, 0x00010DBA00016087, 0x00011DBC000105BB, 0x00010DBE000105BD, 0x8000ADD2000105BF, 0x8000ADDA8000ADD6, 0x8000ADE28000ADDE, 
0x8000ADE600FDC0E1, 0x8000ADEA00FC8CE3, 0x8000ADF28000ADEE, 0x8000ADF600FCB4EF, 0x8000ADFE8000ADFA, 0x00FE29A88000AE02, 0x00FE3DAA00FE29A9, 0x00FE55AC00FE35AB, 
0x00FE4DAE00FE59AD, 0x8000AE0600FE45AF, 0x8000AE0E8000AE0A, 0x8000AE168000AE12, 0x8000AE1E8000AE1A, 0x000149B88000AE22, 0x000159BA000149B9, 0x000179BC000151BB, 
0x000119BE000179BD, 0x0001C5B0000115BF, 0x0001C5B20001CDB1, 0x0001C5B40001DDB3, 0x0001C5B60001CDB5, 0x8000AE26000179B7, 0x8000AE2E8000AE2A, 0x8000AE3200FDB9A3, 
0x00FDD5A600FDD1A5, 0x8000AE410003D084, 0x00020DAA0002E0BE, 0x00021DAC000205AB, 0x00020DAE000205AD, 0x00004981000205AF, 0x000309A300004180, 0x000319A500005D82, 
0x8000AE498000AE45, 0x0004C086000311A6, 0x00030DAB0003E487, 0x000301AD00030DAA, 0x000301AF00031DAC, 0x0003E1B0000309AE, 0x0003E1B20003E1B1, 0x0003E5B40003FDB3, 
0x0003E5B60003EDB5, 0x000305B800033DB7, 0x000305BA00030DB9, 0x000305BC00031DBB, 0x000305BE00030DBD, 0x8000AE4D0000BDBF, 0x8000AE558000AE51, 0x8000ACE68000AE59, 
0x8000AE618000AE5D, 0x0003F1A88000AE65, 0x0003A9AA0003F9A9, 0x0003B9AC0003A9AB, 0x0003A9AE0003B9AD, 0x000241B30003A5AF, 0x8000AE6D8000AE69, 0x8000AE758000AE71, 
0x000251B5000259B6, 0x000245BB8000AE79, 0x8000AE7D000245BA, 0x000249BF8000AE81, 0x000249BD000241BE, 0x8000AE85000255BC, 0x8000AE8D8000AE89, 0x00038CEF8000AE91, 
0x8000AE998000AE95, 0x00036CE38000AE9D, 0x000050E18000AEA1, 0x8000AEA98000AEA5, 0x8000AEB1000578BE, 0x0000E58000027084, 0x0000F9820000E981, 0x0004B0868000AEB5, 
0x8000AEB900055487, 0x8000AEBD00FE40EF, 0x8000AEC100FE5CE1, 0x8000AEC5000154E3, 0x8000AECD8000AEC9, 0x000199B38000AED1, 0x8000AED98000AED5, 0x8000AEE18000AEDD, 
0x00011DB500011DB6, 0x00013DBB8000AEE5, 0x8000AEE900013DBA, 0x0000E1BF8000AEED, 0x0000F1BD0000F9BE, 0x000621A80000F9BC, 0x000651AA000651A9, 0x0006D5AC0006CDAB, 
0x0006D5AE0006DDAD, 0x8000AEAD0006C9AF, 0x8000AEF58000AEF1, 0x8000AEFD8000AEF9, 0x8000AF058000AF01, 0x00076DB88000AF09, 0x00070DBA000705B9, 0x00071DBC000705BB, 
0x000701BE000701BD, 0x0006B9B0000701BF, 0x00076DB20006B9B1, 0x00077DB4000765B3, 0x000765B6000765B5, 0x0006D9A3000755B7, 0x8000AF118000AF0D, 0x8000AF198000AF15, 
0x00065DA500065DA6, 0x00067DAB00029C84, 0x000324BE00067DAA, 0x0007A1AF8000AF1D, 0x0007B1AD0007B9AE, 0x000049800007B9AC, 0x0000598200004981, 0x8000AF21000755B3, 
0x000769B600077DB5, 0x000040868000AF25, 0x000755BA00035487, 0x000739BC000729BB, 0x000729BE000739BD, 0x000699A3000721BF, 0x8000AF2D8000AF29, 0x8000AF358000AF31, 
0x0006B1A50006A5A6, 0x0006E5AB8000AF39, 0x8000AF3D000699AA, 0x0006EDAF8000AF41, 0x0006F5AD0006E5AE, 0x000538E10006F5AC, 0x000424E38000AF45, 0x8000AF4D8000AF49, 
0x8000AF558000AF51, 0x8000AF5D8000AF59, 0x8000AF658000AF61, 0x8000AF6D8000AF69, 0x0004F4EF8000AF71, 0x0006F9A88000AF75, 0x000611AA000609A9, 0x000639AC00062DAB, 
0x00062DAE000625AD, 0x8000AF79000625AF, 0x8000AF818000AF7D, 0x000019808000AF85, 0x0000058200001981, 0x0001E5B88000AF89, 0x0001E5BA0001EDB9, 0x0001E5BC0001FDBB, 
0x0001E5BE0001EDBD, 0x00065DB0000159BF, 0x000621B2000621B1, 0x000621B4000621B3, 0x000611B6000629B5, 0x0002D1A8000611B7, 0x00030DAA0002D9A9, 0x00031DAC000305AB, 
0x000305AE000305AD, 0x000264BE000335AF, 0x8000AF958000AF91, 0x8000AF9D8000AF99, 0x8000AFA58000AFA1, 0x000325B88000AFA9, 0x000325BA00032DB9, 0x000325BC00033DBB, 
0x0003F9BE000329BD, 0x00034DB00003F9BF, 0x000325B2000321B1, 0x000325B400033DB3, 0x000325B600032DB5, 0x000385B300031DB7, 0x8000AFAD0002C884, 0x8000AFB100030884, 
0x000395B5000385B6, 0x0003E5BB8000AFB5, 0x000C0886000389BA, 0x0003E9BF00039C87, 0x0003E9BD0003E1BE, 0x000AEC850003F1BC, 0x0003CDA38000AE36, 0x0003DDA58000AFB9, 
0x8000AFC18000AFBD, 0x8000AFC50003CDA6, 0x0003ADAB8000AFC9, 0x0003A1AD0003C1AA, 0x0003A1AF0003B9AC, 0x8000AFCD0003A9AE, 0x8000AFD58000AFD1, 0x0003C8EF8000AFD9, 
0x8000AFE18000AFDD, 0x0003B4E38000AFE5, 0x0001D0E18000AFE9, 0x00000D808000AFED, 0x00007D8200007581, 0x8000AFF58000AFF1, 0x000165B38000AFF9, 0x000165B5000204BE, 
0x8000B0058000B001, 0x000D4086000165B6, 0x0001F5BB000D5887, 0x0001A5BD0001FDBA, 0x000199BF0001B9BC, 0x8000B0090001A5BE, 0x8000B0118000B00D, 0x8000B015000C0084, 
0x8000B01D8000B019, 0x8000B0210001CCEF, 0x8000B02500062CE1, 0x000000EC000120E3, 0x8000B02D8000B029, 0x8000B0358000B031, 0x8000B0390001E9A3, 0x0001E9A68000B03D, 
0x8000B0458000B041, 0x000171AA0001E9A5, 0x8000B049000179AB, 0x000129AE8000B04D, 0x000135AC000115AF, 0x000E25A8000129AD, 0x000E25AA000E2DA9, 0x000E25AC000E3DAB, 
0x000E25AE000E2DAD, 0x8000AFFD000E95AF, 0x8000B0558000B051, 0x8000B05D8000B059, 0x00009D8100009D82, 0x000F45B800009D80, 0x000F45BA000F4DB9, 0x000F49BC000F59BB, 
0x000F7DBE000F49BD, 0x000EF1B0000F71BF, 0x000EA5B2000EF9B1, 0x000EA9B4000EB9B3, 0x000E9DB6000E95B5, 0x000FD5A8000F7DB7, 0x000F09AA000FDDA9, 0x000F19AC000F09AB, 
0x000F0DAE000F05AD, 0x8000B061000F05AF, 0x8000B0698000B065, 0x8000B06D0003A0BE, 0x000378878000B071, 0x000F15B800001086, 0x000F21BA000F1DB9, 0x0000F5BC000F21BB, 
0x0000F5BE0000FDBD, 0x000F41B00000EDBF, 0x000F5DB2000F4DB1, 0x000F4DB4000F55B3, 0x000F31B6000F35B5, 0x8000B075000F31B7, 0x8000B079000CB0EF, 0x8000B0818000B07D, 
0x8000B0898000B085, 0x8000B0918000B08D, 0x8000B0998000B095, 0x8000B0A18000B09D, 0x8000B0A5000DA8E3, 0x000EC1B3000D8CE1, 0x8000B0AD8000B0A9, 0x8000B0B58000B0B1, 
0x000ED1B5000EC5B6, 0x000EC9BB8000B0B9, 0x8000B0BD000EC5BA, 0x000EB1BF8000B0C1, 0x000EC1BD000EC9BE, 0x000E01A3000EC9BC, 0x8000B0C98000B0C5, 0x8000B0D18000B0CD, 
0x000E11A5000E05A6, 0x000E09AB8000B0D5, 0x8000B0D9000E05AA, 0x000E71AF0002AC84, 0x000E01AD000E09AE, 0x00005180000E09AC, 0x0000618200005981, 0x0001CCBE0000C5B3, 
0x0000CDB60000C5B5, 0x000740868000B0E1, 0x0000C9BA00011487, 0x0000D9BC0000C9BB, 0x0000C9BE0000D9BD, 0x00030DAB0000C5BF, 0x000309A900030DAA, 0x00030DAF0002B9A8, 
0x00030DAD00030DAE, 0x000360BE00030DAC, 0x8000B0E98000B0E5, 0x8000B0F18000B0ED, 0x8000B0F98000B0F5, 0x000329BB000530BE, 0x000319B9000319BA, 0x0003DDBF000301B8, 
0x0003DDBD0003DDBE, 0x00034DB3000331BC, 0x00034DB100034DB2, 0x000339B700034DB0, 0x000341B5000331B6, 0x8000B0FD00034DB4, 0x000399A5000391A6, 0x000399A38000B101, 
0x8000B1098000B105, 0x000399AF8000B10D, 0x000385AD000395AE, 0x000395AB000385AC, 0x8000AF8D000395AA, 0x8000B1158000B111, 0x8000B11D8000B119, 0x8000B1258000B121, 
0x8000B12D8000B129, 0x8000B1358000B131, 0x8000B13D8000B139, 0x00001D808000B141, 0x0001FD8200000981, 0x000708BF8000B145, 0x8000B1518000B149, 0x8000B155000024EF, 
0x8000B15900029484, 0x0002E0878000B15D, 0x001800BE00050486, 0x8000B1658000B161, 0x8000B169000190E1, 0x8000B16D000080E3, 0x8000B1758000B171, 0x8000B179000165B3, 
0x00016DB6000165B5, 0x8000B1818000B17D, 0x0001E5BA8000B185, 0x0001E9BC0001F9BB, 0x0001C5BE0001E9BD, 0x8000B1890001BDBF, 0x8000B1918000B18D, 0x8000B1950019C4BE, 
0x8000B19D8000B199, 0x8000B1A10001C8EF, 0x8000B1A5000EDCE1, 0x8000B1A9000E30E3, 0x8000B1B18000B1AD, 0x0000798000043084, 0x0000158200001581, 0x8000B1B50001E5A3, 
0x0001EDA60001E5A5, 0x000640868000B1B9, 0x000165AA00079087, 0x000169AC000179AB, 0x000145AE000169AD, 0x0005DDA800013DAF, 0x000621AA000621A9, 0x000621AC000621AB, 
0x000621AE000621AD, 0x8000B14D00069DAF, 0x8000B1C18000B1BD, 0x8000B1C500013084, 0x8000B1CD8000B1C9, 0x00068DB88000B1D1, 0x00069DBA000695B9, 0x00068DBC000695BB, 
0x0006BDBE0006B5BD, 0x0006EDB00006B5BF, 0x0006F1B20006F1B1, 0x0006CDB40006F1B3, 0x0006BDB60006B5B5, 0x000789A80006B5B7, 0x000791AA000795A9, 0x0007BDAC000791AB, 
0x0007A1AE0007A5AD, 0x8000B1D50007DDAF, 0x8000B1DD8000B1D9, 0x8000B1E58000B1E1, 0x8000B1ED8000B1E9, 0x000749B88000B1F1, 0x00075DBA000755B9, 0x000771BC000755BB, 
0x000769BE00077DBD, 0x0007A5B0000769BF, 0x0007B9B20007ADB1, 0x000791B40007B1B3, 0x000779B6000791B5, 0x8000B1F5000779B7, 0x8000B1FD8000B1F9, 0x0005C8EF8000B201, 
0x8000B2050009C0E1, 0x000424E30019C0E3, 0x0006D0E18000B209, 0x00039DA20028DCEF, 0x000519A0000115A3, 0x000659B300058DA1, 0x8000B2118000B20D, 0x8000B2198000B215, 
0x000675B5000665B6, 0x000629BB8000B21D, 0x8000B221000621BA, 0x000615BF8000B225, 0x000625BD000615BE, 0x000699A300062DBC, 0x8000B22900FC998F, 0x8000B2358000B231, 
0x0006B5A50006A5A6, 0x0006E9AB8000B239, 0x001F28860006E1AA, 0x0006D5AF00009C87, 0x0006E5AD0006D5AE, 0x00096D9E0006EDAC, 0x000B0D9C00077D9F, 0x000DF19A0009ED9D, 
0x00F0E598000D399B, 0x00F1E196000F0D99, 0x00F5C59400F1E997, 0x00F71D9200F30D95, 0x00F9FD9000F5F193, 0x00FF1D8200F9ED91, 0x8000B23D00FA0183, 0x00F615868000B241, 
0x00FA098400F63987, 0x00F0C18A00F4F185, 0x8000B24500F2258B, 0x000CE18E8000B249, 0x00F2358C000E158F, 0x000EAD9200F3018D, 0x8000B24D00088193, 0x0004E9968000B251, 
0x000A799400067597, 0x0006D19A000AF195, 0x8000B2550000C99B, 0x00031D818000B259, 0x0002599C00031D80, 0x001001AB0003F582, 0x00168DA9001695AA, 0x002E95AF00168DA8, 
0x0012FDAD002C01AE, 0x001EA5A3001299AC, 0x00028DA1001EA5A2, 0x001A19A78000B0DD, 0x001801A5001A95A6, 0x8000B25D001F9DA4, 0x8000B2658000B261, 0x8000B26D8000B269, 
0x8000B2758000B271, 0x002AE5B38000B279, 0x002FADB1002AE5B2, 0x8000B27D002EE5B0, 0x002401B58000B281, 0x000329A8002A11B4, 0x00033DAA000335A9, 0x00032DAC000335AB, 
0x0003BDAE0003B5AD, 0x8000B2850003B5AF, 0x8000B28D8000B289, 0x00001D808000B291, 0x0000B98200000981, 0x00024DB88000B295, 0x00026DBA00025DB9, 0x000219BC000209BB, 
0x000209BE000219BD, 0x0003CDB0000201BF, 0x0003DDB20003D5B1, 0x0003CDB40003D5B3, 0x00027DB6000275B5, 0x8000B299000275B7, 0x8000B2A1001DC884, 0x8000B2A5001F0CBE, 
0x000648EF8000B2A9, 0x000658E1000758EF, 0x000194E3000698E1, 0x001C1086000600E3, 0x001EF4BE001D7C87, 0x8000B2B18000B2AD, 0x0003F5B5000365B6, 0x0003E5B38000B2B5, 
0x8000B2BD8000B2B9, 0x0002E1BF8000B2C1, 0x000351BD000359BE, 0x000341BB000359BC, 0x8000B2C5000359BA, 0x8000B22D8000B2C9, 0x8000B2CD8000B29D, 0x8000B2D58000B2D1, 
0x8000B2DD8000B2D9, 0x001DADA88000B2E1, 0x001DB5AA001DB5A9, 0x001E3DAC001E25AB, 0x001E15AE001E1DAD, 0x001E0DB0001E75AF, 0x001E25B2001E2DB1, 0x001E95B4001E8DB3, 
0x001E95B6001E9DB5, 0x001EB5B8001E8DB7, 0x001EB5BA001EBDB9, 0x001E85BC001E9DBB, 0x001F5DBE001F55BD, 0x001D1DB3001F55BF, 0x8000B2E98000B2E5, 0x8000B2F18000B2ED, 
0x001E95B5001EBDB6, 0x001EC9BB8000B2F5, 0x8000B2F9001EE9BA, 0x001E79BF8000B2FD, 0x001E79BD001E71BE, 0x00002982001ED1BC, 0x00001D80001D59A3, 0x001EF9A600001581, 
0x8000B3058000B301, 0x001EADAA001ED1A5, 0x8000B309001E8DAB, 0x001E35AE0003E084, 0x001E95AC001E3DAF, 0x001E89A8001E3DAD, 0x001E9DAA001E95A9, 0x001ED1AC001EB1AB, 
0x001ECDAE001ED9AD, 0x8000B30D001EC5AF, 0x000088868000B311, 0x8000B31500016C87, 0x8000B31D8000B319, 0x00015DB88000B321, 0x0001C1BA0001C1B9, 0x0001C1BC0001C1BB, 
0x0001F1BE0001C9BD, 0x001EBDB00001F1BF, 0x001E95B2001E9DB1, 0x00017DB4000165B3, 0x00016DB6000165B5, 0x001D2DAA000165B7, 0x8000B325001D35AB, 0x001D2DAE8000B329, 
0x001D2DAC001C95AF, 0x00018C84001D25AD, 0x8000B32D001D91A3, 0x001D11A68000B331, 0x8000B3398000B335, 0x001E55B3001D81A5, 0x8000B3418000B33D, 0x8000B3498000B345, 
0x001E19B5001E19B6, 0x001E19BB8000B34D, 0x8000B351001E39BA, 0x0001E1BF8000B355, 0x0001F1BD0001F9BE, 0x8000B359001E01BC, 0x8000B3618000B35D, 0x8000B365001D99A3, 
0x001DD5A6001DD5A5, 0x8000B36D8000B369, 0x001DF5AA8000B371, 0x001DCDAC001DD5AB, 0x000235AE00023DAD, 0x0000658000022DAF, 0x00001D8200001581, 0x8000B37500040084, 
0x000370878000B379, 0x8000B3810004FC86, 0x8000B3898000B385, 0x8000B3918000B38D, 0x8000B3998000B395, 0x0004C8BE8000B39D, 0x8000B3A58000B3A1, 0x8000B3AD8000B3A9, 
0x8000B3B58000B3B1, 0x8000B3B9001FDCEF, 0x8000B3BD000194E1, 0x8000B3C100011CE3, 0x8000B3C98000B3C5, 0x000375BB8000B3CD, 0x000648BE000369BA, 0x00031DBF8000B3D1, 
0x00031DBD00031DBE, 0x0003D5B3000365BC, 0x8000B3D98000B3D5, 0x8000B3E18000B3DD, 0x0003C5B500037DB6, 0x000225A800057084, 0x00023DAA000235A9, 0x00022DAC000235AB, 
0x000295AE00029DAD, 0x000015820002B5AF, 0x0001D9808000B3E5, 0x000000C400000981, 0x8000B3F18000B3E9, 0x0002A9B88000B3F5, 0x000149BA0002A9B9, 0x000159BC000149BB, 
0x000145BE000145BD, 0x0002CDB000017DBF, 0x0002D1B20002D1B1, 0x0002B9B40002A9B3, 0x0002A9B60002B9B5, 0x001E28E10002A1B7, 0x000174E3001C34E1, 0x8000B3F9001E18E3, 
0x0004B8868000B3FD, 0x0007388400055487, 0x8000B4058000B401, 0x0007ACBE8000B409, 0x001ECCEF8000B40D, 0x0002F5A3001AC8EF, 0x8000B4158000B411, 0x8000B41D8000B419, 
0x0002E5A500025DA6, 0x000255AB8000B421, 0x8000B425000249AA, 0x00023DAF8000B429, 0x00023DAD00023DAE, 0x000661A8000245AC, 0x000661AA000661A9, 0x000661AC000661AB, 
0x000661AE000661AD, 0x8000B3ED000661AF, 0x8000B4318000B42D, 0x8000B4398000B435, 0x8000B4418000B43D, 0x0006F1B88000B445, 0x0006F1BA0006F1B9, 0x00069DBC0006F1BB, 
0x0006B1BE0006B1BD, 0x0006E5B00006B1BF, 0x0006E5B20006EDB1, 0x0006E5B40006FDB3, 0x0006D9B60006EDB5, 0x0006E9B30006D5B7, 0x8000B44D8000B449, 0x8000B4558000B451, 
0x0006E9B50006E1B6, 0x000629BB8000B459, 0x8000B45D000621BA, 0x000629BF8000B461, 0x000629BD000621BE, 0x00005D82000631BC, 0x000045800006ADA3, 0x0006A5A600005D81, 
0x8000B4698000B465, 0x000665AA0006ADA5, 0x000C008600066DAB, 0x000665AE00034087, 0x000675AC00066DAF, 0x8000B46D00066DAD, 0x8000B47100057CEF, 0x8000B4798000B475, 
0x8000B4818000B47D, 0x8000B4898000B485, 0x8000B4918000B48D, 0x8000B4998000B495, 0x8000B49D000568E3, 0x0006D1B3000578E1, 0x8000B4A58000B4A1, 0x8000B4AD8000B4A9, 
0x0006FDB50006FDB6, 0x0006A9BB8000B4B1, 0x8000B4B50006A1BA, 0x000699BF8000B4B9, 0x0006A9BD0006A9BE, 0x0006B9A80006B1BC, 0x000619AA0006B9A9, 0x000635AC000619AB, 
0x000635AE00063DAD, 0x8000B4BD000629AF, 0x00001D8100001D82, 0x8000B4C100001D80, 0x8000B4C98000B4C5, 0x0001E9B88000B4D1, 0x0001F9BA0001E9B9, 0x0001E9BC0001F9BB, 
0x00015DBE0001E9BD, 0x000625B0000155BF, 0x000625B200062DB1, 0x00062DB400063DB3, 0x000615B600061DB5, 0x000C80860001D9B7, 0x8000B4D50002E487, 0x8000B4D900059DA3, 
0x0005B1A60005B1A5, 0x8000B4E18000B4DD, 0x0005EDAA8000B4E5, 0x0005FDAC0005E5AB, 0x0005E5AE0005E5AD, 0x00034DB60005D5AF, 0x0003C4848000B4E9, 0x8000B4ED000345B5, 
0x8000B4F100028DB3, 0x000349BE8000B4F5, 0x000349BC000349BF, 0x000369BA000349BD, 0x8000B4F9000369BB, 0x8000B5018000B4FD, 0x000381A5000389A6, 0x000249A38000B505, 
0x8000B50D8000B509, 0x00038DAF8000B511, 0x00038DAD00038DAE, 0x0003ADAB00038DAC, 0x8000B37D0003ADAA, 0x8000B5198000B515, 0x003DB4858000B51D, 0x8000B5258000B521, 
0x8000B52D8000B529, 0x00003D808000B531, 0x00001D8200000981, 0x0003B0BE8000B535, 0x000338878000B539, 0x8000B541000CDC86, 0x8000B5498000B545, 0x8000B5518000B54D, 
0x8000B55500065CEF, 0x000CE8BE8000B559, 0x8000B55D000694E3, 0x8000B5610001DCE1, 0x8000B5698000B565, 0x000151B38000B56D, 0x8000B5758000B571, 0x8000B57D8000B579, 
0x000179B5000171B6, 0x00013DBB8000B581, 0x8000B58500013DBA, 0x0001FDBF8000B589, 0x000105BD0001F5BE, 0x8000B58D000105BC, 0x8000B5958000B591, 0x8000B599000C4084, 
0x8000B5A18000B59D, 0x8000B5A50007ACEF, 0x8000B5A9000624E1, 0x000C9086000740E3, 0x8000B5B1000CFC87, 0x000059808000B5B5, 0x0000618200006581, 0x8000B5B90001DDA3, 
0x0001FDA60001F5A5, 0x8000B5C18000B5BD, 0x0001B1AA8000B5C5, 0x000189AC0001B1AB, 0x000179AE000189AD, 0x8000B4CD000171AF, 0x8000B5C98000B53D, 0x8000B5AD8000B5CD, 
0x8000B5D58000B5D1, 0x000D9DA88000B5D9, 0x000E39AA000E2DA9, 0x000E11AC000E31AB, 0x000E7DAE000E11AD, 0x000E19B0000E6DAF, 0x000E31B2000E19B1, 0x000ED1B4000E31B3, 
0x000ECDB6000ED9B5, 0x000EFDB8000EC5B7, 0x000EA9BA000ED9B9, 0x000EBDBC000EA9BB, 0x000EADBE000EA5BD, 0x000F81A8000EA5BF, 0x000F81AA000F81A9, 0x000F81AC000F81AB, 
0x000F85AE000F8DAD, 0x8000B5DD000FB5AF, 0x8000B5E58000B5E1, 0x8000B5ED8000B5E9, 0x8000B5F58000B5F1, 0x000F9DB88000B5F9, 0x000FA5BA000FADB9, 0x000F55BC000F4DBB, 
0x000F49BE000F5DBD, 0x000FD1B0000F49BF, 0x000FD1B2000FD1B1, 0x000FB5B4000FD1B3, 0x000FB5B6000FBDB5, 0x000E09B3000FADB7, 0x8000B6018000B5FD, 0x8000B6098000B605, 
0x000E09B5000E0DB6, 0x000E15BB8000B60D, 0x8000B611000E15BA, 0x000E79BF8000B615, 0x000E05BD000E71BE, 0x00001582000E05BC, 0x00006180000E4DA3, 0x000E49A600006181, 
0x000110BE8000B619, 0x000E51AA000E4DA5, 0x00012484000E51AB, 0x000E35AE8000B621, 0x000E41AC000E3DAF, 0x000E39A8000E41AD, 0x000E59AA000E39A9, 0x000E71AC000E51AB, 
0x000191AE000E71AD, 0x00000086000191AF, 0x8000B62500008487, 0x8000B62D8000B629, 0x8000B6358000B631, 0x000175B88000B639, 0x000175BA00017DB9, 0x0000D9BC0000C9BB, 
0x0000C9BE0000D9BD, 0x0001F5B00000C1BF, 0x0001F5B20001FDB1, 0x000155B400014DB3, 0x000155B600015DB5, 0x000F4DBA00014DB7, 0x000F4DB8000F55BB, 0x000F7DBE000F45B9, 
0x000F45BC000FB5BF, 0x000F01B2000F75BD, 0x000F31B0000F01B3, 0x000F01B6000F31B1, 0x000F11B4000F0DB7, 0x000E99AA000F11B5, 0x000EE5A8000F45AB, 0x000F41AE000E99A9, 
0x000F51AC000F41AF, 0x8000B63D000F51AD, 0x8000B6458000B641, 0x8000B64D8000B649, 0x8000B6558000B651, 0x000D51B38000B659, 0x8000B6618000B65D, 0x8000B6698000B665, 
0x000D79B5000D71B6, 0x0002B9BB8000B66D, 0x8000B6710002B1BA, 0x000219BF8000B675, 0x000219BD000211BE, 0x8000B6790002A1BC, 0x8000B67D000D15A3, 0x000D35A68000B681, 
0x8000B6898000B685, 0x0002F5AA000D3DA5, 0x0003E8840002FDAB, 0x000255AE8000B691, 0x0002E5AC00025DAF, 0x00026DA800025DAD, 0x0002A5AA0002ADA9, 0x0002A5AC0002BDAB, 
0x0002A5AE0002ADAD, 0x0001ED8000017DAF, 0x0001F1820001F181, 0x8000B6950005A0BE, 0x000568878000B699, 0x0001C9B800051C86, 0x0001D9BA0001C9B9, 0x0001F9BC0001D1BB, 
0x000199BE0001F9BD, 0x000105B0000195BF, 0x000105B200010DB1, 0x000105B400011DB3, 0x000105B600010DB5, 0x000F64E10001F9B7, 0x000E14E3000F9CE1, 0x8000B69D000FD4E3, 
0x8000B6A1000E3CE1, 0x0004ACBE0000E4E3, 0x8000B6A98000B6A5, 0x8000B6AD00000CEF, 0x000E60EF8000B6B1, 0x8000B6B5000FB4EF, 0x000444848000B6B9, 0x8000B6BD000261B3, 
0x000261B6000261B5, 0x8000B6C58000B6C1, 0x00018DBA8000B6C9, 0x00019DBC000185BB, 0x00018DBE000185BD, 0x0005ADA3000185BF, 0x8000B6CD8000B68D, 0x8000B6D58000B6D1, 
0x0005ADA50005ADA6, 0x000649AB8000B6D9, 0x8000B6DD000641AA, 0x000649AF8000B6E1, 0x000649AD000641AE, 0x8000B6E5000651AC, 0x8000B6ED8000B6E9, 0x00001D808000B6F1, 
0x0000398200000981, 0x8000B6F98000B6F5, 0x0000C8868000B6FD, 0x8000B70100032087, 0x8000B7098000B705, 0x00066DA88000B70D, 0x0007BDAA0007B5A9, 0x000709AC00071DAB, 
0x000731AE000731AD, 0x0003A88400072DAF, 0x8000B7158000B711, 0x8000B71D8000B719, 0x8000B7258000B721, 0x0000CDB88000B729, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 
0x00009DBE000095BD, 0x000755B0000095BF, 0x00072DB2000725B1, 0x00072DB400073DB3, 0x00071DB6000715B5, 0x8000B72D0000F5B7, 0x8000B7310006BCE1, 0x8000B7350005F4E3, 
0x8000B73D8000B739, 0x8000B7458000B741, 0x8000B74D8000B749, 0x8000B7558000B751, 0x8000B75D8000B759, 0x000675B30004E8EF, 0x0000158100002D82, 0x8000B76100001D80, 
0x0006C1B50006F1B6, 0x0006A1BB8000B765, 0x8000B7690006D1BA, 0x000691BF00016CBE, 0x0006A9BD0006A9BE, 0x0006B5A30006B9BC, 0x000028868000B771, 0x8000B77500014C87, 
0x000601A5000631A6, 0x000661AB8000B779, 0x8000B77D000611AA, 0x000651AF8000B781, 0x000669AD000669AE, 0x8000B785000679AC, 0x8000B7890001BDB3, 0x000179B68000B78D, 
0x8000B7958000B791, 0x000155BA000179B5, 0x8000B79900015DBB, 0x0000F9BE8000B79D, 0x000145BC0000E5BF, 0x000271A80000FDBD, 0x000271AA000271A9, 0x0002B5AC000271AB, 
0x0002B5AE0002BDAD, 0x003CEC840002ADAF, 0x8000B7A58000B7A1, 0x8000B7AD8000B7A9, 0x8000B7B58000B7B1, 0x00035DB88000B7B9, 0x00036DBA000365B9, 0x00037DBC000365BB, 
0x00036DBE000365BD, 0x0002D5B0000365BF, 0x0002D5B20002DDB1, 0x000379B400036DB3, 0x00036DB6000365B5, 0x8000B61D000365B7, 0x8000B7C18000B7BD, 0x8000B7C50002F5A3, 
0x000231A6000231A5, 0x8000B7CD8000B7C9, 0x00021DAA8000B7D1, 0x00020DAC000215AB, 0x0003B1AE0003B5AD, 0x000065800003ADAF, 0x0000198200000981, 0x8000B7D98000B7D5, 
0x003C10BE8000B7E1, 0x003CC0868000B7E5, 0x8000B7E900032087, 0x8000B7F18000B7ED, 0x8000B7F98000B7F5, 0x000285A88000B7FD, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x8000B8010002D1AF, 0x8000B8098000B805, 0x8000B8118000B80D, 0x8000B8198000B815, 0x000175B88000B81D, 0x000175BA00017DB9, 0x0001D9BC0001C9BB, 
0x0001C5BE0001C5BD, 0x0002B5B00001FDBF, 0x000281B20002BDB1, 0x000155B4000281B3, 0x000155B600015DB5, 0x0006A4E100014DB7, 0x000650E38000B821, 0x003C1C84003C80BE, 
0x8000B825003F80BE, 0x8000B82D8000B829, 0x8000B8358000B831, 0x8000B83D8000B839, 0x0006E0EF8000B841, 0x00007D818000B845, 0x8000B84900007180, 0x8000B85100000582, 
0x00004CEF8000B855, 0x000190E18000B859, 0x000158E38000B85D, 0x8000B8658000B861, 0x003F58868000B869, 0x003D9DB3003CFC87, 0x8000B84D8000B7DD, 0x8000B8718000B86D, 
0x003DB5B5003DD5B6, 0x003DF9BB8000B875, 0x8000B879003DF1BA, 0x003E19BF8000B87D, 0x003DD5BD003E11BE, 0x8000B881003DD5BC, 0x8000B885003DD9A3, 0x003D91A68000B889, 
0x8000B8918000B88D, 0x003DB5AA003DF1A5, 0x8000B895003DBDAB, 0x003E55AE8000B899, 0x003D91AC003E5DAF, 0x003E55A8003D91AD, 0x003E61AA003E59A9, 0x003E61AC003E61AB, 
0x003E61AE003E61AD, 0x0003A884003E61AF, 0x8000B8A18000B89D, 0x8000B8A98000B8A5, 0x8000B8B18000B8AD, 0x003F45B88000B8B5, 0x003F55BA003F5DB9, 0x003F75BC003F6DBB, 
0x003F75BE003F7DBD, 0x003FC1B0003F6DBF, 0x003FC1B2003FC1B1, 0x003FC1B4003FC1B3, 0x003FC1B6003FC1B5, 0x0001B980003FC1B7, 0x000005820001B981, 0x003E80E18000B8B9, 
0x003D28E38000B8C1, 0x000080868000B8C5, 0x003D08EF00010487, 0x8000B8CD8000B8C9, 0x8000B8D58000B8D1, 0x003FA9B38000B8D9, 0x8000B8DD8000B8BD, 0x8000B8E58000B8E1, 
0x003FA9B5003FA1B6, 0x003E45BB8000B8E9, 0x8000B8ED003E45BA, 0x003E45BF8000B8F1, 0x003E55BD003E45BE, 0x003F69A3003E55BC, 0x8000B8F98000B8F5, 0x8000B9018000B8FD, 
0x003F69A5003F61A6, 0x003E85AB8000B905, 0x8000B909003E85AA, 0x003E85AF8000B90D, 0x003E95AD003E85AE, 0x8000B911003E95AC, 0x8000B915003E19B3, 0x003E21B68000B919, 
0x8000B9218000B91D, 0x0001F1BA003E31B5, 0x8000B9250001F9BB, 0x0001B1BE8000B929, 0x0001D1BC0001BDBF, 0x003DD1A80001D1BD, 0x003DD5AA003DD1A9, 0x003DFDAC003DE9AB, 
0x003DEDAE003DE5AD, 0x0003F980000211AF, 0x0003C5820003CD81, 0x000400BE00032484, 0x0003AC878000B931, 0x000219B80004BC86, 0x000225BA00022DB9, 0x0002F9BC0002E9BB, 
0x0002E9BE0002F9BD, 0x000271B00002E9BF, 0x000241B2000279B1, 0x000231B4000241B3, 0x000235B600023DB5, 0x003D6DA5000229B7, 0x8000B9398000B935, 0x8000B93D003D7DA6, 
0x003D45A38000B76D, 0x00028DAD8000B941, 0x0002E1AF00028DAC, 0x000000AC0002EDAE, 0x0002A5AB8000B945, 0x0001F8E10002ADAA, 0x0002F4E38000B949, 0x8000B94D0004C084, 
0x8000B9558000B951, 0x8000B95D8000B959, 0x8000B9658000B961, 0x8000B96D8000B969, 0x000230EF8000B971, 0x000215A88000B975, 0x000225AA000219A9, 0x000225AC00023DAB, 
0x000225AE00022DAD, 0x8000B979000255AF, 0x8000B9818000B97D, 0x8000B9898000B985, 0x0004B0848000B98D, 0x0002D1B88000B991, 0x0002E1BA0002D9B9, 0x000291BC0002E1BB, 
0x000295BE00029DBD, 0x00022DB0000289BF, 0x000235B2000235B1, 0x00021DB4000205B3, 0x0002F1B60002F1B5, 0x003F78E10002F1B7, 0x003E08E3000134E3, 0x00000981003E6CE1, 
0x8000B9950000A980, 0x8000B99900003D82, 0x8000B9A58000B9A1, 0x8000B9A9000420BE, 0x003ECCEF003ED8EF, 0x8000B9B18000B9AD, 0x0004E8860002E9B3, 0x0002E9B60004C087, 
0x8000B9B98000B9B5, 0x0002ADBA0002E9B5, 0x8000B9BD0002B5BB, 0x00029DBE8000B9C1, 0x0002A5BC000271BF, 0x8000B92D000295BD, 0x8000B9C58000B99D, 0x8000B9CD8000B9C9, 
0x8000B9D58000B9D1, 0x000615A88000B9D9, 0x0006A1AA0006A1A9, 0x0006ADAC0006BDAB, 0x0006FDAE000681AD, 0x000695B00006EDAF, 0x000695B200069DB1, 0x0006B5B40006ADB3, 
0x0006B5B60006BDB5, 0x000695B80006ADB7, 0x000749BA000699B9, 0x000759BC000749BB, 0x000749BE000759BD, 0x0005DDAC000749BF, 0x0005E5AE0005EDAD, 0x8000B9DD000509AF, 
0x0005D5AA8000B9E1, 0x8000B9E50005CDAB, 0x000591A6000591A5, 0x8000B9ED8000B9E9, 0x8000B9F58000B9F1, 0x000649B3000591A3, 0x8000B9FD8000B9F9, 0x8000BA058000BA01, 
0x000645B5000661B6, 0x000639BB8000BA09, 0x000064BE000631BA, 0x000619BF8000BA0D, 0x000619BD000611BE, 0x000789A3000621BC, 0x0001D9810001D982, 0x8000BA110001C180, 
0x000785A50007A1A6, 0x0007F9AB8000BA15, 0x000108860007F1AA, 0x0007D9AF00017C87, 0x0007D9AD0007D1AE, 0x8000BA190007E1AC, 0x8000BA1D0006F5B3, 0x000685B68000BA21, 
0x8000BA298000BA25, 0x00068DBA00069DB5, 0x8000BA2D00016DBB, 0x000165BE8000BA31, 0x000175BC00016DBF, 0x000625A800016DBD, 0x000639AA00062DA9, 0x000651AC000631AB, 
0x000641AE000641AD, 0x8000BA35000675AF, 0x8000BA3D8000BA39, 0x8000BA458000BA41, 0x8000BA4D8000BA49, 0x000155B88000BA51, 0x000165BA000165B9, 0x000165BC00017DBB, 
0x00011DBE00016DBD, 0x00060DB0000115BF, 0x0001E5B20001EDB1, 0x0001E5B40001FDB3, 0x0001E5B60001EDB5, 0x0005B1A300016DB7, 0x8000BA598000BA55, 0x000C58BE000348BE, 
0x0005D9A50005C1A6, 0x000229AB8000BA5D, 0x8000BA610005C9AA, 0x000229AF8000BA65, 0x000229AD000221AE, 0x8000BA69000231AC, 0x8000BA718000BA6D, 0x000019808000BA75, 
0x0000058200001981, 0x0003AC848000BA79, 0x000318878000BA81, 0x8000BA85000CCC86, 0x8000BA8D8000BA89, 0x000391A88000BA91, 0x0003C9AA000399A9, 0x0003DDAC0003C5AB, 
0x0003C1AE0003C1AD, 0x8000BA950003F5AF, 0x8000BA9D8000BA99, 0x8000BAA58000BAA1, 0x8000BAAD8000BAA9, 0x00037DB88000BAB1, 0x0000C1BA0000C1B9, 0x0000F9BC0000D1BB, 
0x000099BE0000F9BD, 0x00038DB0000099BF, 0x00034DB2000345B1, 0x00035DB4000345B3, 0x00034DB6000345B5, 0x000241B3000345B7, 0x8000BAB98000BAB5, 0x8000BABD000F04BF, 
0x000255B5000241B6, 0x000281BB8000BAC1, 0x8000BAC5000249BA, 0x000281BF8000BAC9, 0x000291BD000299BE, 0x8000BACD000299BC, 0x8000BAD58000BAD1, 0x0003A4EF8000BAD9, 
0x8000BAE18000BADD, 0x000310E38000BAE5, 0x000058E18000BAE9, 0x00002980000D2084, 0x00001D8200002981, 0x000650E18000BAF1, 0x0006A0E30007A0E1, 0x000C9485000750E3, 
0x001B48EF8000BAF5, 0x000224E18000BAF9, 0x001A70E38000BAFD, 0x8000BB058000BB01, 0x0001A8EF8000BB09, 0x000FA0860006E8EF, 0x000289A3000D0C87, 0x00029DA58000BB0D, 
0x8000BB158000BB11, 0x8000BB19000289A6, 0x000249AB8000BB1D, 0x000259AD000281AA, 0x000249AF000251AC, 0x000E65A8000251AE, 0x000E7DAA000E75A9, 0x000E6DAC000E75AB, 
0x000EBDAE000EB5AD, 0x8000BAED000EB5AF, 0x8000BB258000BB21, 0x8000BB2D8000BB29, 0x8000BB3C8000BB38, 0x000F5DB88000BB40, 0x000F65BA000F6DB9, 0x000F15BC000F0DBB, 
0x000F15BE000F1DBD, 0x000ECDB0000F09BF, 0x000EDDB2000ED5B1, 0x000ECDB4000ED5B3, 0x000F71B6000F71B5, 0x000EF5B3000F6DB7, 0x8000BB488000BB44, 0x8000BB508000BB4C, 
0x000EE5B5000E35B6, 0x000E11BB8000BB54, 0x8000BB58000E09BA, 0x000FB5BF8000BB5C, 0x000E01BD000E09BE, 0x00001582000E09BC, 0x00006180000EB1A3, 0x000E71A600006181, 
0x000110BE8000BB60, 0x000E4DAA000EA1A5, 0x8000BB68000E55AB, 0x000E4DAE00012084, 0x000E4DAC000FF1AF, 0x0008459F000E45AD, 0x00090D9D00090D9E, 0x0035759B000B999C, 
0x003799990035119A, 0x0031259700310D98, 0x003D819500312596, 0x003F8993003D0D94, 0x00393D9100381592, 0x0025658F00393D90, 0x00040086000DACEF, 0x8000BB6C0001A087, 
0x8000BB748000BB70, 0x8000BB780001E8EF, 0x8000BB7C000234E1, 0x8000BB80000134E3, 0x8000BB84000C08E3, 0x0001A1A1000D08E1, 0x000509A38000BB88, 0x0004CDA500036DA2, 
0x00191DA7000511A4, 0x001DA1A900191DA6, 0x001CE9AB001939A8, 0x001191AD001DA9AA, 0x001401AF001001AC, 0x0015F9B1001151AE, 0x0069E9B30015E5B0, 0x006C01B5006801B2, 
0x8000BB8C006979B4, 0x8000BB948000BB90, 0x8000BB9C8000BB98, 0x000309A38000BBA0, 0x000DFDA1000D19A2, 0x00262582000DFDA0, 0x8000BBA4003A0583, 0x003CA9868000BBA8, 
0x003A1D84003E3587, 0x003E898A003B3D85, 0x8000BBAC0032258B, 0x0034B18E8000BBB0, 0x00323D8C0036318F, 0x0036259200322D8D, 0x000344840008D193, 0x000B15960004C0BE, 
0x000A5D94000E5597, 0x000E659A000A5595, 0x8000BBB4000E899B, 0x8000BBBC8000BBB8, 0x0000819C8000BBC0, 0x0002B5B88000BBC4, 0x0002B5BA0002BDB9, 0x000219BC000209BB, 
0x000209BE000219BD, 0x000D75B0000201BF, 0x000D49B2000D7DB1, 0x000295B4000D49B3, 0x000295B600029DB5, 0x000DBDA800028DB7, 0x000D55AA000D51A9, 0x000D7DAC000D69AB, 
0x000D6DAE000D65AD, 0x8000BB64000D11AF, 0x00001D810001ED82, 0x8000BBC800001D80, 0x8000BA7D8000BBCC, 0x000C9DB3000570BE, 0x8000BBD000058C84, 0x8000BBDC8000BBD8, 
0x000CB5B5000CA5B6, 0x000CF9BB8000BBE0, 0x00052886000CF1BA, 0x000319BF00052087, 0x000CDDBD000311BE, 0x8000BBE4000CDDBC, 0x8000BBE8000CD9A3, 0x000CE1A68000BBEC, 
0x8000BBF48000BBF0, 0x000CB5AA000CF1A5, 0x8000BBF8000CBDAB, 0x000355AE8000BBFC, 0x000C99AC00035DAF, 0x8000BC00000C99AD, 0x8000BC088000BC04, 0x8000BC108000BC0C, 
0x8000BC188000BC14, 0x8000BC1C0001BCEF, 0x8000BC20000E7CE1, 0x8000BC24000150E3, 0x8000BC2C8000BC28, 0x000295B38000BC30, 0x8000BC388000BC34, 0x8000BC408000BC3C, 
0x0002B9B50002BDB6, 0x000239BB8000BC48, 0x0004C886000261BA, 0x000219BF0004AC87, 0x000219BD000211BE, 0x000555A3000221BC, 0x0007C5810007D582, 0x8000BC4C0007C580, 
0x000579A500057DA6, 0x0005F9AB8000BC50, 0x8000BC540005A1AA, 0x0005D9AF8000BC58, 0x0005D9AD0005D1AE, 0x8000BC5C0005E1AC, 0x8000BC60000759B3, 0x00071DB68000BC64, 
0x8000BC6C8000BC68, 0x000709BA000715B5, 0x8000BC70000709BB, 0x0007F9BE8000BC74, 0x0007F9BC0007F9BF, 0x8000BBD40007F9BD, 0x8000BC788000BC44, 0x8000BC808000BC7C, 
0x8000BC888000BC84, 0x0007ADA88000BC8C, 0x0007B5AA0007B5A9, 0x0007F9AC0007EDAB, 0x0007EDAE0007F9AD, 0x0007A9B00007E5AF, 0x000749B20007A9B1, 0x000759B4000749B3, 
0x000749B6000759B5, 0x000779B8000749B7, 0x000741BA000745B9, 0x000745BC00075DBB, 0x000745BE00074DBD, 0x00061DA3000739BF, 0x8000BC948000BC90, 0x8000BC9C8000BC98, 
0x000651A5000659A6, 0x00064DAB8000BCA0, 0x8000BCA400064DAA, 0x0006BDAF8000BCA8, 0x0006BDAD0006BDAE, 0x00006D800006BDAC, 0x0000198200000981, 0x8000BCB08000BCAC, 
0x000190BE00019884, 0x001C00868000BCB4, 0x8000BCB80001C487, 0x8000BCC08000BCBC, 0x8000BCC88000BCC4, 0x00065DA88000BCCC, 0x000195AA000195A9, 0x0001BDAC0001A5AB, 
0x0001D1AE0001D5AD, 0x8000BCD00001D1AF, 0x8000BCD88000BCD4, 0x8000BCE08000BCDC, 0x8000BCE88000BCE4, 0x000159B88000BCEC, 0x0000CDBA000159B9, 0x0000DDBC0000C5BB, 
0x0000C5BE0000C5BD, 0x0001B5B00000F5BF, 0x000181B20001BDB1, 0x000179B4000181B3, 0x000169B6000179B5, 0x00021DB3000169B7, 0x8000BCF48000BCF0, 0x8000BCF8001C80BE, 
0x000235B5000255B6, 0x000279BB8000BCFC, 0x8000BD00000271BA, 0x0002BDBF8000BD04, 0x000255BD0002BDBE, 0x8000BD08000255BC, 0x8000BD0C000259A3, 0x000211A68000BD10, 
0x8000BD188000BD14, 0x000235AA000271A5, 0x8000BD1C00023DAB, 0x0002F9AE8000BD20, 0x000211AC0002F9AF, 0x8000BD28000211AD, 0x001D04BE8000BD2C, 0x8000BD30001E00BE, 
0x8000BD388000BD34, 0x0000F9808000BD3C, 0x0000C5820000CD81, 0x001CB08600032084, 0x8000BD4000039487, 0x8000BD488000BD44, 0x8000BD508000BD4C, 0x00026CE38000BD54, 
0x0001A0E18000BD58, 0x000214EF8000BD5C, 0x8000BD648000BD60, 0x8000BD6C8000BD68, 0x8000BD748000BD70, 0x0006F0E18000BD78, 0x00004CE3000634E1, 0x8000BD7C000618E3, 
0x8000BD848000BD80, 0x00003D808000BD88, 0x0000198200000981, 0x8000BD908000BD8C, 0x000098EF001DBC84, 0x000231B3000738EF, 0x001DD887000000D1, 0x8000BD98001C6C86, 
0x000221B5000229B6, 0x0002CDBB8000BD9C, 0x8000BDA00002CDBA, 0x0002CDBF8000BDA4, 0x0002CDBD0002CDBE, 0x00065DB20002CDBC, 0x00060DB0000665B3, 0x00067DB6000655B1, 
0x00067DB400059DB7, 0x00058DBA000675B5, 0x0005A5B80005CDBB, 0x0005C5BE000585B9, 0x0005D5BC0005C9BF, 0x8000BDA80005CDBD, 0x8000BDB08000BDAC, 0x8000BDB88000BDB4, 
0x8000BDC08000BDBC, 0x0006B5AA8000BDC4, 0x000701A80006BDAB, 0x000681AE0006BDA9, 0x000699AC00068DAF, 0x001D71A3000695AD, 0x8000BDCC8000BDC8, 0x8000BDD48000BDD0, 
0x001D61A5001D69A6, 0x001D8DAB8000BDD8, 0x8000BDDC001D8DAA, 0x001D8DAF8000BDE0, 0x001D8DAD001D8DAE, 0x8000BDE4001D8DAC, 0x8000BDE8001ED5B3, 0x001ECDB68000BDEC, 
0x8000BDF48000BDF0, 0x001EA1BA001EC5B5, 0x8000BDF8001EA1BB, 0x001EA5BE8000BDFC, 0x001EB1BC001EA9BF, 0x8000BD24001EB1BD, 0x8000BE008000BD94, 0x0000F98000030484, 
0x000011820000F981, 0x001E21A88000BE04, 0x001E39AA001E21A9, 0x001E29AC001E39AB, 0x001E01AE001E29AD, 0x001E01B0001E01AF, 0x001E01B2001E01B1, 0x001E05B4001E01B3, 
0x001E3DB6001E09B5, 0x001E0DB8001E35B7, 0x001E1DBA001E15B9, 0x001E0DBC001E15BB, 0x001FEDBE001FE5BD, 0x001F91A3001FE5BF, 0x000128868000BE08, 0x8000BE0C00014887, 
0x001F81A5001F89A6, 0x001FE5AB8000BE10, 0x8000BE14001FE5AA, 0x001FEDAF8000BE18, 0x001FF5AD001FE1AE, 0x8000BE1C001FF5AC, 0x8000BE20001E2DB3, 0x001E95B68000BE24, 
0x8000BE2C8000BE28, 0x001EB1BA001E9DB5, 0x8000BE30001EB1BB, 0x000175BE8000BE34, 0x001EA1BC00017DBF, 0x001ED1A8001EA1BD, 0x001EE1AA001ED9A9, 0x001E51AC001EE1AB, 
0x001E51AE001E51AD, 0x8000BE38001E51AF, 0x8000BE408000BE3C, 0x8000BE488000BE44, 0x8000BE508000BE4C, 0x0001DDB88000BE54, 0x0001E5BA0001EDB9, 0x000199BC00018DBB, 
0x00018DBE000199BD, 0x001E31B0000185BF, 0x001E31B2001E31B1, 0x0001F5B4001E31B3, 0x0001F5B60001FDB5, 0x001D69A30001EDB7, 0x8000BE5C8000BE58, 0x8000BE648000BE60, 
0x001DD9A5001DD1A6, 0x001DF5AB8000BE68, 0x8000BE6C001DF5AA, 0x000239AF8000BE70, 0x001DE5AD000231AE, 0x00006981001DE5AC, 0x000400BE00005980, 0x8000BE7800006182, 
0x8000BE808000BE7C, 0x0003EC848000BE84, 0x000388878000BE88, 0x8000BE8C0004EC86, 0x8000BE948000BE90, 0x000385A88000BE98, 0x000395AA000395A9, 0x0003BDAC0003A5AB, 
0x0003D1AE0003D5AD, 0x8000BE9C0003D1AF, 0x8000BEA48000BEA0, 0x8000BEAC8000BEA8, 0x8000BEB48000BEB0, 0x000371B88000BEB8, 0x000371BA000371B9, 0x0000D5BC000371BB, 
0x0000D5BE0000DDBD, 0x0003B5B00000CDBF, 0x000381B20003BDB1, 0x000351B4000381B3, 0x000351B6000351B5, 0x001E54E1000351B7, 0x000194E3001FACE1, 0x000360E3001E28E3, 
0x000008E18000BEBC, 0x000390EF8000BEC0, 0x8000BEC88000BEC4, 0x8000BED08000BECC, 0x001F4CEF8000BED4, 0x00025DB3001F4CEF, 0x8000BEDC8000BED8, 0x8000BEE88000BEE0, 
0x000275B5000215B6, 0x000239BB8000BEEC, 0x00052484000231BA, 0x0002D5BF0004E0BE, 0x000215BD0002D5BE, 0x001D91B8000215BC, 0x001DA1BA001D99B9, 0x001DD1BC001DA1BB, 
0x001DD5BE001DDDBD, 0x001E09B0001DC9BF, 0x001E19B2001E09B1, 0x001E09B4001E19B3, 0x001DBDB6001E09B5, 0x001EA9A8001DB5B7, 0x001EB9AA001EA9A9, 0x001EA9AC001EB9AB, 
0x001E79AE001EA9AD, 0x0000A580001E79AF, 0x0000A5820000AD81, 0x0004D0868000BEF0, 0x8000BEF40004F887, 0x8000BE748000BEF8, 0x8000BEFC8000BEE4, 0x8000BF048000BF00, 
0x8000BF0C8000BF08, 0x000671A88000BF10, 0x000671AA000671A9, 0x000655AC000671AB, 0x00064DAE000645AD, 0x00063DB0000645AF, 0x0006EDB20006E5B1, 0x0006FDB40006E5B3, 
0x0006EDB60006E5B5, 0x0006DDB80006E5B7, 0x000775BA000771B9, 0x000759BC000749BB, 0x000749BE000759BD, 0x0006D9B3000749BF, 0x8000BF188000BF14, 0x8000BF208000BF1C, 
0x0006FDB50006E5B6, 0x000601BB8000BF24, 0x8000BF280006D9BA, 0x000601BF8000BF2C, 0x000611BD000619BE, 0x8000BF30000619BC, 0x8000BF340005D9A3, 0x000591A68000BF38, 
0x8000BF408000BF3C, 0x0005B5AA0005F1A5, 0x8000BF440005BDAB, 0x000551AE8000BF48, 0x000591AC000551AF, 0x000759A3000591AD, 0x0000198100001982, 0x8000BF4C0001E180, 
0x00077DA5000765A6, 0x000781AB8000BF50, 0x0002A084000759AA, 0x000781AF0001ACBE, 0x000791AD000799AE, 0x8000BF54000799AC, 0x0000E8860006A9B3, 0x000159B600012C87, 
0x8000BF5C8000BF58, 0x000175BA0006A1B5, 0x8000BF6000017DBB, 0x0001F9BE8000BF64, 0x000165BC0001F9BF, 0x0006D1A80001F9BD, 0x000665AA0006D9A9, 0x00066DAC000675AB, 
0x000195AE00019DAD, 0x0001EC8400018DAF, 0x8000BF6C8000BF68, 0x8000BF748000BF70, 0x8000BF7C8000BF78, 0x000169B88000BF80, 0x000109BA000169B9, 0x00011DBC000105BB, 
0x000101BE000101BD, 0x0001F5B0000135BF, 0x0001F5B20001FDB1, 0x000179B4000169B3, 0x000169B6000179B5, 0x8000BF84000161B7, 0x8000BF8C8000BF88, 0x8000BF900005E1A3, 
0x000211A60005E9A5, 0x8000BF988000BF94, 0x00023DAA8000BF9C, 0x00022DAC000235AB, 0x0002B1AE0002B1AD, 0x8000BFA00002B1AF, 0x000304BE8000BFA4, 0x8000BFA8000C0084, 
0x8000BFB08000BFAC, 0x00000D808000BFB4, 0x00001D8200001581, 0x8000BFBC8000BFB8, 0x000344878000BFC0, 0x0003E9B3000CDC86, 0x8000BFCC8000BFC8, 0x8000BFD48000BFD0, 
0x00033DB500033DB6, 0x000319BB8000BFD8, 0x8000BFDC000311BA, 0x0000B9BF8000BFE0, 0x0000B9BD0000B1BE, 0x8000BFE4000301BC, 0x8000BFE8000194E1, 0x8000BFEC00017CE3, 
0x8000BFF48000BFF0, 0x8000BFFC8000BFF8, 0x8000C0048000C000, 0x8000C00C8000C008, 0x8000C0148000C010, 0x000255A800024CEF, 0x000261AA00025DA9, 0x0002B5AC000261AB, 
0x0002B5AE0002BDAD, 0x000D68BE0002ADAF, 0x8000C01C8000C018, 0x8000C0248000C020, 0x0000AD810000AD82, 0x000161B80000AD80, 0x000109BA000161B9, 0x000101BC000109BB, 
0x000101BE000101BD, 0x0002D5B0000101BF, 0x0002D5B20002DDB1, 0x000175B400016DB3, 0x000169B600017DB5, 0x000668E1000161B7, 0x0000B0E30007F0E1, 0x8000C0280006F4E3, 
0x8000C0308000C02C, 0x8000C03C8000C038, 0x8000C0448000C040, 0x000CFCBE8000C048, 0x00006CEF8000C04C, 0x0002A9A3000628EF, 0x000C68868000C050, 0x8000C054000D0487, 
0x00027DA500027DA6, 0x000259AB8000C058, 0x8000C05C000251AA, 0x0001F9AF8000C060, 0x0001F9AD0001F1AE, 0x000E85A8000241AC, 0x000E85AA000E8DA9, 0x000E8DAC000E9DAB, 
0x000EB5AE000EBDAD, 0x8000C034000EDDAF, 0x8000C0688000C064, 0x8000C0708000C06C, 0x8000C0788000C074, 0x000EADB88000C07C, 0x000EBDBA000EB5B9, 0x000F75BC000EB5BB, 
0x000F75BE000F7DBD, 0x000EA9B0000F6DBF, 0x000EBDB2000EB5B1, 0x000EADB4000EB5B3, 0x000E9DB6000E95B5, 0x000E0DB3000E95B7, 0x8000C0848000C080, 0x8000C08C8000C088, 
0x000E05B5000E3DB6, 0x000E71BB8000C090, 0x8000C094000E6DBA, 0x000E51BF8000C098, 0x000E61BD000E69BE, 0x00001982000E69BC, 0x00006580000E49A3, 0x000E79A600001981, 
0x8000C0A08000C09C, 0x000E29AA000E41A5, 0x0003BC84000E35AB, 0x000E2DAE8000C0A4, 0x000E2DAC000E15AF, 0x000E9DA8000E25AD, 0x000EADAA000EA5A9, 0x000EBDAC000EA5AB, 
0x000EDDAE000EA1AD, 0x00012086000ECDAF, 0x8000C0A800016487, 0x8000C0B08000C0AC, 0x8000C0B88000C0B4, 0x000179B88000C0BC, 0x0001CDBA000179B9, 0x0001DDBC0001C5BB, 
0x0001C5BE0001C5BD, 0x000EBDB00001F5BF, 0x000E85B2000E8DB1, 0x000159B4000149B3, 0x000149B6000159B5, 0x000E2DB5000149B7, 0x8000C0C48000C0C0, 0x8000C0C8000E39B6, 
0x000E3DB38000C0CC, 0x000185BD8000C0D0, 0x000185BF000E49BC, 0x8000C0D4000185BE, 0x000E51BB8000BFC4, 0x000E65A3000E61BA, 0x8000C0DC8000C0D8, 0x8000C0E48000C0E0, 
0x000E75A5000E61A6, 0x000E09AB8000C0E8, 0x8000C0EC000E39AA, 0x0001DDAF8000C0F0, 0x0001DDAD0001DDAE, 0x8000C0F4000E11AC, 0x000FD0EF8000C0F8, 0x8000C1008000C0FC, 
0x8000C1088000C104, 0x8000C1108000C10C, 0x8000C118000368BE, 0x000E54E18000C11C, 0x000E64E38000C120, 0x000059808000C124, 0x0000698200005981, 0x0004F08600038C84, 
0x8000C12800031487, 0x8000C1308000C12C, 0x8000C1388000C134, 0x8000C1408000C13C, 0x8000C1488000C144, 0x8000C1508000C14C, 0x8000C1588000C154, 0x8000C1608000C15C, 
0x8000C1688000C164, 0x000389A88000C16C, 0x000399AA000389A9, 0x000389AC000399AB, 0x00033DAE000389AD, 0x000351B0000335AF, 0x000355B2000351B1, 0x000315B400037DB3, 
0x000315B600031DB5, 0x00033DB800030DB7, 0x000305BA00030DB9, 0x0000F5BC0000EDBB, 0x0000E9BE0000F9BD, 0x8000C1700000E9BF, 0x8000C1788000C174, 0x8000C17C00023DB3, 
0x000225B600022DB5, 0x000568BE8000C180, 0x0002B9BA8000C188, 0x0002ADBC0002B9BB, 0x0002FDBE000285BD, 0x000049800002F5BF, 0x0000558200005581, 0x00038CEF00050084, 
0x00057487000418BE, 0x00033CE30004FC86, 0x000050E18000C18C, 0x8000C1948000C190, 0x8000C19C8000C198, 0x8000C1A48000C1A0, 0x8000C1AC8000C1A8, 0x8000C1B48000C1B0, 
0x8000C1BC8000C1B8, 0x000628BE000ED4EF, 0x8000C1C0000E74E1, 0x8000C1C4000154E3, 0x8000C1CC8000C1C8, 0x0002F1A38000C1D0, 0x8000C1D88000C1D4, 0x8000C1E08000C1DC, 
0x0002E1A50002E9A6, 0x000275AB8000C1E4, 0x8000C1E8000275AA, 0x000239AF8000C1EC, 0x000249AD000231AE, 0x000629A8000261AC, 0x00063DAA000629A9, 0x000649AC000631AB, 
0x000679AE000649AD, 0x8000C184000679AF, 0x0007C58100001582, 0x8000C1F00007C580, 0x8000C1F400036884, 0x0006C9B88000C1F8, 0x0006D9BA0006C9B9, 0x0006C9BC0006D9BB, 
0x000759BE0006C9BD, 0x000609B0000759BF, 0x000619B2000609B1, 0x000609B4000619B3, 0x0006F9B6000609B5, 0x0006B5B30006F9B7, 0x0000AC868000C1FC, 0x8000C20000034087, 
0x0006C1B50006C9B6, 0x0006CDBB8000C204, 0x8000C2080006CDBA, 0x0006CDBF8000C20C, 0x0006CDBD0006CDBE, 0x8000C2100006CDBC, 0x8000C2140006F1A3, 0x00068DA68000C218, 
0x8000C2208000C21C, 0x000689AA000685A5, 0x8000C224000689AB, 0x000689AE8000C228, 0x000689AC000689AF, 0x000625A8000689AD, 0x000665AA000661A9, 0x000665AC00067DAB, 
0x000665AE00066DAD, 0x8000C22C00069DAF, 0x8000C2348000C230, 0x8000C23C8000C238, 0x8000C2448000C240, 0x0006F5B88000C248, 0x0006F5BA0006FDB9, 0x000699BC000689BB, 
0x000689BE000699BD, 0x0006E5B0000681BF, 0x0006E5B20006EDB1, 0x0006E5B40006FDB3, 0x0006D1B60006EDB5, 0x8000C24C0006CDB7, 0x0006FDB50006FDB6, 0x0006FDB38000C250, 
0x8000C2588000C254, 0x000639BF8000C25C, 0x000639BD000631BE, 0x000639BB000621BC, 0x8000C114000631BA, 0x0006ADA38000C260, 0x0000558100007982, 0x00015C8400005580, 
0x0006ADA50006ADA6, 0x000669AB8000C268, 0x007F4886000661AA, 0x000669AF0000E487, 0x000669AD000661AE, 0x8000C26C000671AC, 0x8000C2700007DCEF, 0x8000C2788000C274, 
0x8000C2808000C27C, 0x8000C2888000C284, 0x8000C28C0003A084, 0x8000C290007924BF, 0x8000C294000768E3, 0x0002D1B3000674E1, 0x000304BE8000C298, 0x8000C29C007D8084, 
0x0002F1B50002F9B6, 0x0002B5BB8000C2A0, 0x8000C2A40002A9BA, 0x000351BF8000C2A8, 0x000291BD000299BE, 0x000205A90002A5BC, 0x000215AB0002B9A8, 0x00023DAD00021DAA, 
0x000251AF00023DAC, 0x007D68BE00025DAE, 0x8000C2B08000C2AC, 0x8000C2B88000C2B4, 0x8000C2C08000C2BC, 0x0003F1B98000C2C4, 0x0003F1BB0003E9B8, 0x000351BD0003F9BA, 
0x00034DBF0003E9BC, 0x000235B1000351BE, 0x000201B3000229B0, 0x0003D1B5000235B2, 0x0003D1B7000219B4, 0x000029820003D9B6, 0x00001D80000395A3, 0x0003BDA600001581, 
0x8000C2CC8000C2C8, 0x0003EDAA0003B5A5, 0x8000C2D00003F1AB, 0x0003DDAE8000C2D8, 0x0003E1AC000215AF, 0x007D60860003D5AD, 0x000141B3007D7887, 0x000141B5007F0084, 
0x8000C2E08000C2DC, 0x8000C2E4000149B6, 0x000141BB8000C2E8, 0x000149BD00014DBA, 0x000129BF000145BC, 0x8000C2EC000139BE, 0x8000C2F00006DCEF, 0x8000C2F88000C2F4, 
0x8000C3008000C2FC, 0x007E2C84000630EF, 0x8000C3040006E0E1, 0x8000C308000188E3, 0x8000C30C000074E3, 0x0001C9A300012CE1, 0x8000C3148000C310, 0x8000C31800797085, 
0x0001C9A50001C1A6, 0x0001C9AB8000C31C, 0x8000C3200001C5AA, 0x0001A1AF8000C324, 0x0001C1AD0001B1AE, 0x007DDDA80001CDAC, 0x007E01AA007E05A9, 0x007E01AC007E01AB, 
0x007E01AE007E01AD, 0x8000C2D4007E01AF, 0x8000C32C8000C328, 0x8000C3348000C330, 0x00009D8100009D82, 0x007E2DB800009D80, 0x007EE1BA007EE1B9, 0x007EE1BC007EE1BB, 
0x007EE1BE007EE1BD, 0x007E41B0007EE1BF, 0x007E59B2007E4DB1, 0x007E35B4007E55B3, 0x007E25B6007E25B5, 0x007FADA8007E15B7, 0x007FD1AA007FD1A9, 0x007FF5AC007FEDAB, 
0x007F11AE007F15AD, 0x8000C338007F11AF, 0x8000C3408000C33C, 0x0003F0868000C344, 0x8000C3480000B887, 0x007F11B88000C34C, 0x007F21BA007F19B9, 0x0000F5BC007F21BB, 
0x0000F5BE0000FDBD, 0x007F71B00000EDBF, 0x007F71B2007F71B1, 0x007F41B4007F45B3, 0x007F3DB6007F4DB5, 0x007E59B3007F35B7, 0x8000C3548000C350, 0x8000C35C8000C358, 
0x007E7DB5007E95B6, 0x007EB5BB8000C360, 0x8000C364007EB5BA, 0x007E89BF8000C368, 0x007E91BD007E85BE, 0x8000C36C007EA5BC, 0x8000C370007E1DA3, 0x007ED1A68000C374, 
0x8000C37C8000C378, 0x007EF1AA007E39A5, 0x8000C380007EF1AB, 0x007EC1AE8000C384, 0x007EE1AC007ECDAF, 0x0000ADB0007ED5AD, 0x0000C1B20000C5B1, 0x0000C5B40000C1B3, 
0x0000F1B60000CDB5, 0x000061B80000F1B7, 0x000061BA000061B9, 0x000065BC00007DBB, 0x000065BE00006DBD, 0x8000C3880003BDBF, 0x8000C3908000C38C, 0x8000C3948000C264, 
0x8000C39C8000C398, 0x000159A88000C3A0, 0x0000EDAA000159A9, 0x0000FDAC0000E5AB, 0x0000E5AE0000E5AD, 0x8000C3A40000D5AF, 0x00001D8100001D82, 0x8000C3A800001D80, 
0x8000C3B08000C3AC, 0x00048086000254BE, 0x8000C3B80002EC87, 0x8000C3C08000C3BC, 0x8000C3C88000C3C4, 0x007E74E3000378BE, 0x007DB8E18000C3CC, 0x8000C3D48000C3D0, 
0x8000C3DC8000C3D8, 0x8000C3E48000C3E0, 0x8000C3EC8000C3E8, 0x007EC0EF8000C3F0, 0x8000C3F88000C3F4, 0x000385B38000C3FC, 0x8000C4048000C400, 0x8000C40C8000C408, 
0x000395B5000385B6, 0x0003E1BB8000C410, 0x000624BE000389BA, 0x0003E9BF8000C414, 0x0003F5BD0003E1BE, 0x000029820003F5BC, 0x00001D800003C1A3, 0x0003C1A600001581, 
0x8000C41C8000C418, 0x0003CDAA0003D1A5, 0x8000C4200003A5AB, 0x0003A5AE0005E085, 0x0003B1AC0003ADAF, 0x0003F8E10003B1AD, 0x001F5CE38000C428, 0x0003F4EF8000C42C, 
0x00073C868000C430, 0x007E7CE30002AC87, 0x000180E18000C434, 0x8000C43C8000C438, 0x0013E4EF8000C440, 0x000171B38000C444, 0x8000C44C8000C448, 0x8000C4548000C450, 
0x000161B5000111B6, 0x000139BB8000C458, 0x8000C45C000131BA, 0x000119BF8000C460, 0x000119BD000111BE, 0x8000C464000121BC, 0x8000C46C8000C468, 0x8000C4748000C470, 
0x8000C47C8000C478, 0x8000C480007FC4EF, 0x8000C484007EFCE1, 0x00000D80007FF0E3, 0x00007D8200007581, 0x8000C48C8000C488, 0x0001F9A38000C490, 0x0001E9A5000800BE, 
0x8000C49C8000C498, 0x0005A884000199A6, 0x0001B1AB8000C4A0, 0x000191AD0001B9AA, 0x000191AF0001A9AC, 0x000629A8000199AE, 0x000639AA000629A9, 0x000629AC000639AB, 
0x000655AE000651AD, 0x8000C42400064DAF, 0x8000C4A400012084, 0x0001E1A38000C494, 0x000419A1000499A2, 0x000639B80005F1A0, 0x0006CDBA000639B9, 0x0006DDBC0006C5BB, 
0x0006C5BE0006C5BD, 0x000635B00006F1BF, 0x000635B200063DB1, 0x000615B400060DB3, 0x000615B600061DB5, 0x006CA18F000609B7, 0x00012886000791B3, 0x0007A1B600037C87, 
0x8000C4AC8000C4A8, 0x0007E5BA0007B1B5, 0x8000C4B00007EDBB, 0x0007EDBE8000C4B4, 0x0007F5BC0007DDBF, 0x0078F99F0007EDBD, 0x0079719D0078E59E, 0x007CF19B007C219C, 
0x00719999007D619A, 0x0070E1970070D998, 0x00746D9500747996, 0x0069AD9300746D94, 0x0068799100687192, 0x006D2182006E1D90, 0x8000C4B8006FE583, 0x00684D868000C4BC, 
0x0069998400759587, 0x0075A58A00699985, 0x8000C4C00075B98B, 0x0070718E8000C4C4, 0x0071398C007C818F, 0x007D61920071398D, 0x8000C4C8007DA993, 0x007969968000C4CC, 
0x0078E19400049997, 0x0005419A00797D95, 0x8000C4D00005C99B, 0x8000C4D88000C4D4, 0x0000A99C8000C4DC, 0x000D81A38000C4E0, 0x0001A9A10001A9A2, 0x0009B1A78000C4E4, 
0x000D4DA5000801A6, 0x001591AB000D99A4, 0x001401A9001585AA, 0x00101DAF000971A8, 0x0011BDAD0011E9AE, 0x001801B3001001AC, 0x001DC1B1001CF1B2, 0x8000C3B4001DC9B0, 
0x0018E1B58000C4E8, 0x8000C4EC0019FDB4, 0x8000C4F48000C4F0, 0x00001D808000C4F8, 0x0003FD8200000981, 0x000515A38000C4FC, 0x000C88868000C500, 0x8000C50800033C87, 
0x000535A5000525A6, 0x000569AB8000C50C, 0x8000C510000561AA, 0x000559AF8000C514, 0x000569AD000569AE, 0x8000C518000571AC, 0x000C04848000C51C, 0x8000C5248000C520, 
0x8000C52800066CE1, 0x8000C52C007BECE3, 0x8000C5348000C530, 0x8000C5380006A8EF, 0x8000C5408000C53C, 0x00058DA98000C544, 0x0005ADAB000581A8, 0x0005A1AD000599AA, 
0x0005A5AF0005B9AC, 0x000D68840005A9AE, 0x8000C54C8000C548, 0x8000C5548000C550, 0x8000C55C8000C558, 0x000549B9000CF4BE, 0x000559BB000541B8, 0x000549BD000541BA, 
0x000571BF000541BC, 0x0005A9B100057DBE, 0x0005B9B30005A1B0, 0x000599B50005A1B2, 0x000579B70005A9B4, 0x0004D5A8000591B6, 0x0004EDAA0004DDA9, 0x000385AC000325AB, 
0x0003B1AE00038DAD, 0x8000C5600003B1AF, 0x8000C5688000C564, 0x000019808000C56C, 0x0000058200001981, 0x000231B88000C570, 0x000235BA000231B9, 0x000285BC0002C1BB, 
0x0002BDBE0002B5BD, 0x000269B00002B5BF, 0x000241B2000269B1, 0x000239B4000241B3, 0x000211B6000239B5, 0x000CA086000211B7, 0x8000C578000D4C87, 0x0006A4EF8000C57C, 
0x8000C5848000C580, 0x000194E30007CCEF, 0x000138E10006A4E1, 0x8000C58800065CE3, 0x8000C5908000C58C, 0x8000C5988000C594, 0x00042DB38000C59C, 0x000345B58000C5A0, 
0x8000C5A88000C5A4, 0x8000C5AC000345B6, 0x0002E5BB8000C5B0, 0x0002DDBD0002E5BA, 0x0002B5BF0002DDBC, 0x8000C5040002B5BE, 0x8000C5B48000C574, 0x8000C5BC8000C5B8, 
0x8000C5C48000C5C0, 0x000E31A88000C5C8, 0x000E01AA000E39A9, 0x000E71AC000E01AB, 0x000E75AE000E71AD, 0x000E19B0000E6DAF, 0x000E2DB2000E25B1, 0x000E21B4000E25B3, 
0x000E21B6000E21B5, 0x000EC5B8000E21B7, 0x000EC5BA000ECDB9, 0x000EC5BC000EDDBB, 0x000F59BE000ECDBD, 0x000EA9B3000F59BF, 0x8000C5D08000C5CC, 0x8000C5D88000C5D4, 
0x000ED9B5000ED1B6, 0x000EC1BB8000C5DC, 0x8000C5E0000EFDBA, 0x000EC5BF00002CBE, 0x000ED1BD000EC5BE, 0x00006982000ED9BC, 0x00005980000EEDA3, 0x000E95A600005181, 
0x8000C5E88000C5E4, 0x000EB9AA000E9DA5, 0x0000C886000E85AB, 0x000E81AE0000AC87, 0x000E9DAC000E81AF, 0x8000C5EC000E95AD, 0x8000C5F0000E91B3, 0x000EA5B68000C5F4, 
0x8000C5FC8000C5F8, 0x000EE1BA000EADB5, 0x8000C600000EE1BB, 0x000EE9BE8000C604, 0x000EF5BC000ED5BF, 0x000AA5A3000EE9BD, 0x8000C60C8000C608, 0x8000C6148000C610, 
0x000DCDA5000DCDA6, 0x000C6DAB8000C618, 0x8000C61C000C6DAA, 0x000C3DAF8000C620, 0x000C55AD000C3DAE, 0x000E09A8000C55AC, 0x000E1DAA000E09A9, 0x000E21AC000E15AB, 
0x000E21AE000E21AD, 0x8000C624000E21AF, 0x8000C62C8000C628, 0x8000C6348000C630, 0x8000C63C8000C638, 0x0001CDB88000C640, 0x0001DDBA0001D5B9, 0x0001CDBC0001D5BB, 
0x000151BE000151BD, 0x000E21B0000151BF, 0x000E25B2000E21B1, 0x000E29B4000E39B3, 0x000E1DB6000E15B5, 0x8000C6440001F5B7, 0x8000C64C8000C648, 0x8000C650000D99A3, 
0x000DADA6000DA5A5, 0x0003EC840002DCBE, 0x000DE9AA8000C658, 0x000DFDAC000DE9AB, 0x000DE1AE000DE1AD, 0x00004580000DDDAF, 0x0000598200004D81, 0x8000C65C000345A3, 
0x000341A6000341A5, 0x0004C0868000C660, 0x00032DAA00030087, 0x00033DAC000325AB, 0x000325AE000325AD, 0x000259A8000315AF, 0x000381AA000385A9, 0x000385AC000381AB, 
0x0003B1AE00038DAD, 0x8000C6640003B1AF, 0x8000C66C8000C668, 0x8000C6748000C670, 0x8000C67C8000C678, 0x000365B88000C680, 0x000365BA00036DB9, 0x000365BC00037DBB, 
0x000365BE00036DBD, 0x0003A5B00000DDBF, 0x0003A5B20003ADB1, 0x0003ADB40003BDB3, 0x000395B600039DB5, 0x000209B300035DB7, 0x8000C6888000C684, 0x8000C6908000C68C, 
0x00020DB500020DB6, 0x000269BB8000C694, 0x8000C698000261BA, 0x000259BF8000C69C, 0x000269BD000269BE, 0x8000C6A0000271BC, 0x8000C6A88000C6A4, 0x0001A0E18000C6AC, 
0x000368E38000C6B0, 0x000015818000C6B4, 0x00038CEF00001580, 0x8000C6B800001582, 0x8000C6C08000C6BC, 0x000E18E1000570BE, 0x000F38E3000F94E1, 0x00029484000FD4E3, 
0x8000C6CC8000C6C8, 0x8000C6D48000C6D0, 0x8000C6DC8000C6D8, 0x8000C6E48000C6E0, 0x0001ECEF8000C6E8, 0x00046086000FF8EF, 0x000195B300050487, 0x000175B50005CC84, 
0x8000C6F08000C6EC, 0x8000C6F4000175B6, 0x000151BB8000C6F8, 0x0000F5BD000159BA, 0x0000F5BF000149BC, 0x000625A80000F5BE, 0x000655AA000655A9, 0x0006B5AC0006ADAB, 
0x0006B5AE0006BDAD, 0x8000C6C40006ADAF, 0x8000C7008000C6FC, 0x8000C7088000C704, 0x8000C7108000C70C, 0x000769B88000C714, 0x000709BA000769B9, 0x000719BC000709BB, 
0x00070DBE000719BD, 0x0006D5B0000701BF, 0x0006D5B20006DDB1, 0x000779B4000769B3, 0x000769B6000779B5, 0x0006DDA3000761B7, 0x8000C71C8000C718, 0x8000C7248000C720, 
0x00063DA500063DA6, 0x000619AB8000C728, 0x8000C72C000611AA, 0x0007BDAF8000C730, 0x0007BDAD0007BDAE, 0x00005D80000601AC, 0x0000658200006D81, 0x0003D8BE000751B3, 
0x000771B6000771B5, 0x0000E0868000C734, 0x00075DBA00031487, 0x000729BC000739BB, 0x00071DBE000715BD, 0x000695A80000D9BF, 0x000695AA00069DA9, 0x0006B5AC0006ADAB, 
0x0006B5AE0006BDAD, 0x8000C7380006ADAF, 0x8000C7408000C73C, 0x8000C7488000C744, 0x8000C7508000C74C, 0x000171B88000C754, 0x000171BA000171B9, 0x0001D5BC000171BB, 
0x0001D5BE0001DDBD, 0x0006D5B00001CDBF, 0x0006B1B20006B1B1, 0x000695B400068DB3, 0x000151B6000151B5, 0x8000C758000151B7, 0x8000C75C000619A3, 0x000639A68000C760, 
0x8000C7648000C654, 0x000615AA000639A5, 0x8000C768000671AB, 0x000655AE8000C76C, 0x000661AC000191AF, 0x8000C77000065DAD, 0x8000C7788000C774, 0x8000C7808000C77C, 
0x8000C7888000C784, 0x8000C7908000C78C, 0x8000C7988000C794, 0x000019808000C79C, 0x0000058200001981, 0x000280848000C7A0, 0x00030C87000380BE, 0x000668E1001CAC86, 
0x000798E38000C7A8, 0x8000C7B08000C7AC, 0x0007ACEF8000C7B4, 0x8000C7BC8000C7B8, 0x8000C7C48000C7C0, 0x8000C7CC8000C7C8, 0x8000C7D48000C7D0, 0x8000C7D8000365B3, 
0x00036DB6000365B5, 0x8000C7E08000C7DC, 0x0003E9BA8000C7E4, 0x0003FDBC0003E5BB, 0x0003D1BE0003EDBD, 0x8000C7E80003D1BF, 0x8000C7F08000C7EC, 0x8000C7F88000C7F4, 
0x8000C8008000C7FC, 0x000381A88000C804, 0x000381AA000381A9, 0x000381AC000381AB, 0x000381AE000381AD, 0x000341B0000381AF, 0x000345B200034DB1, 0x000379B4000355B3, 
0x000319B6000379B5, 0x000329B8000319B7, 0x000339BA000329B9, 0x000329BC000339BB, 0x000319BE000329BD, 0x00001981000319BF, 0x000221A300001180, 0x000221A500002D82, 
0x8000C80C8000C808, 0x8000C810000229A6, 0x0002A1AB8000C818, 0x0002A9AD0002ADAA, 0x000295AF0002B9AC, 0x00024C84000295AE, 0x001D6487001D48BE, 0x000340E3001CEC86, 
0x0001A0E18000C81C, 0x00039CEF8000C820, 0x8000C8288000C824, 0x8000C8308000C82C, 0x8000C8388000C834, 0x8000C8408000C83C, 0x8000C8488000C844, 0x8000C8508000C84C, 
0x8000C8588000C854, 0x001DA8840001B4EF, 0x8000C85C00067CE1, 0x8000C860000670E3, 0x8000C8688000C864, 0x0001E1B38000C86C, 0x8000C8748000C870, 0x8000C87C8000C878, 
0x0001F5B50001E5B6, 0x0001A1BB8000C880, 0x001CE4BE0001D9BA, 0x0001ADBF8000C888, 0x0001B1BD0001A5BE, 0x001E15A80001B9BC, 0x001E29AA001E19A9, 0x001E3DAC001E29AB, 
0x001E2DAE001E25AD, 0x8000C814001E25AF, 0x001FF981001FF982, 0x8000C884001FE180, 0x00001C868000C88C, 0x001EC1B80003B087, 0x001EC1BA001EC1B9, 0x001EC1BC001EC1BB, 
0x001EC1BE001EC1BD, 0x001E5DB0001EC1BF, 0x001E2DB2001E25B1, 0x001E21B4001E25B3, 0x001E19B6001E29B5, 0x001EA1A3001E19B7, 0x8000C8948000C890, 0x8000C89C8000C898, 
0x001EB5A5001EA5A6, 0x001EE1AB8000C8A0, 0x8000C8A4001E99AA, 0x001EEDAF8000C8A8, 0x001EF1AD001EE5AE, 0x8000C8AC001EF9AC, 0x8000C8B0001F99B3, 0x001FBDB68000C8B4, 
0x8000C8BC8000C8B8, 0x001F99BA001FB5B5, 0x8000C8C0001F99BB, 0x001F79BE8000C8C4, 0x001F79BC001F79BF, 0x001E25A8001F79BD, 0x001E55AA001E51A9, 0x001E79AC001E69AB, 
0x001E69AE001E79AD, 0x8000C8C8001E69AF, 0x8000C8D08000C8CC, 0x8000C8D88000C8D4, 0x8000C8E08000C8DC, 0x001ED9B88000C8E4, 0x001EF9BA001EEDB9, 0x001EE9BC001EF9BB, 
0x001E9DBE001EE9BD, 0x001E19B0001E95BF, 0x001EE9B2001E19B1, 0x001EF9B4001EE9B3, 0x001EE9B6001EF9B5, 0x001EDDA3001EE9B7, 0x0000158100002982, 0x8000C8E800001D80, 
0x001EF1A5001EF9A6, 0x001EDDAB8000C8EC, 0x8000C7A4001EDDAA, 0x001E3DAF8000C8F0, 0x001E3DAD001E3DAE, 0x0002C884001E3DAC, 0x00010CBE000141B3, 0x000141B68000C8F8, 
0x8000C9008000C8FC, 0x00014DBA000151B5, 0x00004886000125BB, 0x000125BE00015087, 0x000131BC00012DBF, 0x8000C904000131BD, 0x000304848000C908, 0x8000C90C000480BE, 
0x8000C910001FA8EF, 0x003128BF8000C914, 0x8000C918001F74E3, 0x8000C91C001E38E1, 0x8000C9248000C920, 0x8000C92C8000C928, 0x0002CDA38000C930, 0x0002DDA58000C934, 
0x8000C93C8000C938, 0x8000C9400002CDA6, 0x0002A9AB8000C944, 0x0002BDAD0002C1AA, 0x0002A1AF0002BDAC, 0x0002B5A90002A9AE, 0x000201AB001D69A8, 0x000201AD000209AA, 
0x000231AF000219AC, 0x00056C84000201AE, 0x8000C94C8000C948, 0x8000C9548000C950, 0x00019D8100019D82, 0x0003E5B900019D80, 0x0003E5BB0003E5B8, 0x0003E5BD0003E5BA, 
0x0003E5BF0003E5BC, 0x000221B10003E5BE, 0x000225B3000249B0, 0x000229B5000225B2, 0x000215B7000221B4, 0x0002CDA8000215B6, 0x0002D1AA0002D1A9, 0x000115AC00010DAB, 
0x000101AE000105AD, 0x8000C958000101AF, 0x8000C9608000C95C, 0x0004F8BE8000C968, 0x8000C9708000C96C, 0x000115B88000C974, 0x000129BA00011DB9, 0x0001F5BC000129BB, 
0x0001F5BE0001FDBD, 0x000149B00001EDBF, 0x00015DB2000155B1, 0x00014DB4000155B3, 0x00013DB6000135B5, 0x0005A086000131B7, 0x8000C9780005C887, 0x8000C97C0000BCEF, 
0x8000C9848000C980, 0x00072C84001E8CEF, 0x8000C988001EF0E1, 0x8000C98C001E1CE3, 0x8000C990000194E1, 0x000219B300006CE3, 0x8000C9988000C994, 0x000800848000C99C, 
0x0001DDB50001C5B6, 0x0001D1BB8000C9A0, 0x8000C9A40001CDBA, 0x0001B1BF8000C9A8, 0x0001C1BD0001C9BE, 0x0005D9A30001C9BC, 0x8000C9AC8000C964, 0x8000C9B48000C9B0, 
0x00061DA5000605A6, 0x000611AB8000C9B8, 0x8000C9BC00060DAA, 0x000671AF8000C9C0, 0x000601AD000609AE, 0x8000C9C4000609AC, 0x00001D8100001D82, 0x8000C9C800001D80, 
0x8000C9D08000C9CC, 0x000340868000C9D4, 0x8000C9D80003C487, 0x8000C9E08000C9DC, 0x8000C9E88000C9E4, 0x0007ADA88000C9EC, 0x0007B1AA0007B1A9, 0x000719AC0007B1AB, 
0x00070DAE000705AD, 0x8000C9F0000705AF, 0x8000C9F88000C9F4, 0x8000CA008000C9FC, 0x8000CA088000CA04, 0x00072DB88000CA0C, 0x0000C5BA0000CDB9, 0x0000CDBC0000DDBB, 
0x0000F5BE0000FDBD, 0x000749B000009DBF, 0x000751B2000755B1, 0x000739B4000729B3, 0x000725B6000739B5, 0x000639B3000715B7, 0x8000CA148000CA10, 0x8000CA1C8000CA18, 
0x000691B5000685B6, 0x000691BB8000CA20, 0x8000CA2400068DBA, 0x0006FDBF8000CA28, 0x0006FDBD0006FDBE, 0x8000CA2C000685BC, 0x8000CA3000067DA3, 0x0006C1A68000CA34, 
0x8000CA3C8000CA38, 0x0006C9AA0006D5A5, 0x8000CA400006D5AB, 0x0006B9AE00016CBE, 0x0006C1AC0006B9AF, 0x0001E9A80006B9AD, 0x0001F9AA0001E9A9, 0x0001E9AC0001F9AB, 
0x000139AE0001E9AD, 0x0000F580000139AF, 0x0000C1820000FD81, 0x000010868000CA44, 0x8000CA4800017487, 0x0000CDB88000C8F4, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 
0x000091BE000095BD, 0x000149B0000091BF, 0x000159B2000149B1, 0x000149B4000159B3, 0x0000FDB6000149B5, 0x0006F4EF0000F5B7, 0x8000CA508000CA4C, 0x000230EF8000CA54, 
0x8000CA5C8000CA58, 0x0007E0E38000CA60, 0x000180E18000CA64, 0x000628E38000CA68, 0x0005C8E18000CA6C, 0x000231B38000CA70, 0x8000CA788000CA74, 0x8000CA7C00000096, 
0x000221B5000229B6, 0x0002CDBB8000CA80, 0x8000CA840002CDBA, 0x0002CDBF8000CA88, 0x0002CDBD0002CDBE, 0x8000CA8C0002CDBC, 0x8000CA948000CA90, 0x8000CA980002FDA3, 
0x0002E5A60002EDA5, 0x8000CAA08000CA9C, 0x000201AA8000CAA4, 0x000201AC000201AB, 0x000201AE000201AD, 0x00000D80000201AF, 0x00001D8200001581, 0x8000CAAC8000CAA8, 
0x000C54BE8000CAB0, 0x000CC0868000CAB8, 0x8000CABC00032487, 0x8000CAC48000CAC0, 0x8000CACC8000CAC8, 0x0002B9A88000CAD0, 0x000101AA000101A9, 0x000105AC000101AB, 
0x000105AE00010DAD, 0x000DA884000139AF, 0x8000CAD88000CAD4, 0x8000CAE08000CADC, 0x8000CAE88000CAE4, 0x00012DB88000CAEC, 0x0001CDBA0001C5B9, 0x0001C1BC0001C5BB, 
0x0001F9BE0001C9BD, 0x00014DB00001F9BF, 0x000155B2000151B1, 0x000139B4000129B3, 0x000125B6000125B5, 0x000618E1000115B7, 0x000738E38000CAF0, 0x8000CAF88000CAF4, 
0x8000CAFC000C58BE, 0x000F6C848000CB00, 0x000F60BE8000CB04, 0x8000CB0C8000CB08, 0x000670EF8000CB10, 0x000015808000CB14, 0x00002D8200001981, 0x000660E3000FCC84, 
0x0001A0E18000CB18, 0x000074EF8000CB1C, 0x000CC8868000CB20, 0x8000CB28000CFC87, 0x8000CB308000CB2C, 0x000E09A38000CB34, 0x8000CB248000CAB4, 0x8000CB3C8000CB38, 
0x000E0DA5000E0DA6, 0x000E15AB8000CB40, 0x8000CB44000E09AA, 0x000E61AF8000CB48, 0x000E7DAD000E7DAE, 0x8000CB4C000E01AC, 0x8000CB50000EA9B3, 0x000EA9B68000CB54, 
0x8000CB5C8000CB58, 0x000F49BA000EA9B5, 0x8000CB60000F49BB, 0x000F49BE8000CB64, 0x000F49BC000F49BF, 0x000E5DA8000F49BD, 0x000E65AA000E6DA9, 0x000E65AC000E7DAB, 
0x000E65AE000E6DAD, 0x8000CB68000FB9AF, 0x8000CB708000CB6C, 0x8000CB788000CB74, 0x8000CB808000CB7C, 0x000F51B88000CB84, 0x000F55BA000F5DB9, 0x000F7DBC000F69BB, 
0x000F6DBE000F65BD, 0x000FC9B0000F61BF, 0x000FD9B2000FC9B1, 0x000FC9B4000FD9B3, 0x000F7DB6000FC9B5, 0x8000CB88000F71B7, 0x000F11B6000F11B5, 0x000011808000CB8C, 
0x0000298200001981, 0x000F1DBC000F15B3, 0x000F61BE000F61BD, 0x8000CB90000F7DBF, 0x000F15BA8000CB94, 0x000FADA3000F09BB, 0x0000E8868000CB98, 0x8000CB9C0001C887, 
0x000FADA5000FADA6, 0x000E4DAB8000CBA0, 0x8000CBA4000E4DAA, 0x000E4DAF8000CBA8, 0x000E4DAD000E4DAE, 0x000E71A8000E4DAC, 0x000E71AA000E71A9, 0x00019DAC000E71AB, 
0x000185AE000185AD, 0x0000ECBE0001B5AF, 0x8000CBB08000CBAC, 0x8000CBB88000CBB4, 0x8000CBC08000CBBC, 0x000161B88000CBC4, 0x000161BA000161B9, 0x000161BC000161BB, 
0x000161BE000161BD, 0x0001CDB0000161BF, 0x0001A1B20001A5B1, 0x0001A5B40001A1B3, 0x000191B60001ADB5, 0x000DF9B3000191B7, 0x8000CBCC8000CBC8, 0x8000CBD48000CBD0, 
0x000215B5000205B6, 0x000261BB8000CBD8, 0x8000CBDC000209BA, 0x000269BF8000CBE0, 0x000275BD000261BE, 0x8000CBE4000275BC, 0x8000CBE8000DBDA3, 0x000241A68000CBEC, 
0x8000CBF48000CBF0, 0x00024DAA000251A5, 0x8000CBF8000225AB, 0x000225AE8000CBFC, 0x000231AC00022DAF, 0x0000ED81000231AD, 0x0001D0EF0000ED80, 0x8000CC0000001D82, 
0x000438868000CC08, 0x8000CC0C00035087, 0x8000CC148000CC10, 0x0001E0E18000CC18, 0x000F64E38000CC1C, 0x8000CC248000CC20, 0x8000CC2C8000CC28, 0x8000CC30000391B3, 
0x00037DB60003B9B5, 0x8000CC388000CC34, 0x000359BA8000CC3C, 0x000349BC000359BB, 0x0000FDBE000349BD, 0x000245A80000F5BF, 0x000255AA000255A9, 0x00027DAC000265AB, 
0x0002B1AE0002B1AD, 0x000568BE0002B1AF, 0x8000CC448000CC40, 0x8000CC4C8000CC48, 0x8000CC548000CC50, 0x00015DB88000CC58, 0x000165BA00016DB9, 0x000119BC00010DBB, 
0x00010DBE000119BD, 0x0002D1B0000105BF, 0x0002D1B20002D1B1, 0x000175B40002D1B3, 0x000175B600017DB5, 0x000F78E100016DB7, 0x000EB8E3000E34E3, 0x8000CC5C000E7CE1, 
0x8000CC648000CC60, 0x8000CC6C8000CC68, 0x8000CC788000CC70, 0x8000CC808000CC7C, 0x000ED4EF000EE4EF, 0x00029DA38000CC84, 0x0000698100006182, 0x00059C8400005180, 
0x0002B5A5000271A6, 0x000255AB8000CC88, 0x00044886000255AA, 0x0001F9AF0004CC87, 0x000245AD0001F1AE, 0x000695A8000245AC, 0x0006ADAA0006A5A9, 0x0006BDAC0006A5AB, 
0x0006A5AE0006A1AD, 0x8000CC740006DDAF, 0x8000CC908000CC8C, 0x8000CC988000CC94, 0x8000CCA08000CC9C, 0x00076DB88000CCA4, 0x00077DBA000775B9, 0x00076DBC000775BB, 
0x0007CDBE0007C5BD, 0x0006A5B00007C5BF, 0x0006B9B20006ADB1, 0x000691B40006B1B3, 0x00075DB6000691B5, 0x000625B3000755B7, 0x8000CCAC8000CCA8, 0x8000CCB48000CCB0, 
0x000635B5000621B6, 0x000669BB8000CCB8, 0x8000CCBC000661BA, 0x000655BF8000CCC0, 0x000665BD000655BE, 0x8000CCC400066DBC, 0x8000CCC8000661A3, 0x000665A68000CCCC, 
0x8000CCD48000CCD0, 0x000625AA000671A5, 0x8000CCD800062DAB, 0x000611AE8000CCDC, 0x000629AC000611AF, 0x0006A9A8000621AD, 0x0006B9AA0006A9A9, 0x0006CDAC0006B1AB, 
0x000131AE000131AD, 0x0001C980000131AF, 0x000005820001C981, 0x000278BE8000CCE0, 0x8000CCE400027884, 0x0001DDB88000CCE8, 0x0001E5BA0001EDB9, 0x000199BC00018DBB, 
0x00018DBE000199BD, 0x000151B0000185BF, 0x000151B2000151B1, 0x0001F5B4000151B3, 0x0001F5B60001FDB5, 0x000631B30001EDB7, 0x000028868000CCEC, 0x8000CCF00001DC87, 
0x000645B50001B1B6, 0x000195BB8000CCF4, 0x8000CCF8000195BA, 0x000139BF8000CCFC, 0x000185BD000131BE, 0x8000CC04000185BC, 0x8000CD00000675A3, 0x0001F5A68000CD04, 
0x8000CD0C8000CD08, 0x0001D1AA000601A5, 0x8000CD100001D1AB, 0x000175AE8000CD14, 0x0001C1AC00017DAF, 0x8000CD180001C1AD, 0x8000CD208000CD1C, 0x8000CD288000CD24, 
0x8000CD308000CD2C, 0x8000CD388000CD34, 0x8000CD408000CD3C, 0x8000CD488000CD44, 0x8000CD508000CD4C, 0x003C0085000370BE, 0x000244840006C4E1, 0x0000618000078CE3, 
0x0000618200006181, 0x003C4485000368EF, 0x8000CD58000210E1, 0x003D5086002BD8E3, 0x8000CD5C0003F487, 0x8000CD600007A4EF, 0x8000CD64000240EF, 0x8000CD6C8000CD68, 
0x8000CD748000CD70, 0x003C3C848000CD78, 0x8000CD808000CD7C, 0x8000CD888000CD84, 0x8000CD8C0002ECE3, 0x000351B300012CE1, 0x8000CD948000CD90, 0x8000CD9C8000CD98, 
0x000371B5000379B6, 0x000339BB8000CDA0, 0x8000CDA4000331BA, 0x0000F5BF8000CDA8, 0x000315BD0000F5BE, 0x00023DA8000315BC, 0x000299AA000281A9, 0x0002B9AC000291AB, 
0x0002D1AE0002B9AD, 0x003FA8840002D1AF, 0x8000CDAC003FA8BE, 0x8000CDB48000CDB0, 0x8000CDBC8000CDB8, 0x000151B88000CDC0, 0x000151BA000151B9, 0x000171BC000151BB, 
0x000171BE000171BD, 0x0002B5B0000171BF, 0x000281B20002BDB1, 0x000171B4000281B3, 0x000171B6000171B5, 0x0000B580000171B7, 0x0000B5820000BD81, 0x003FB0868000CDC8, 
0x8000CDCC003CE087, 0x003E2CBE000054EF, 0x8000CDD0000654E1, 0x8000CDD4000088E3, 0x8000CDDC8000CDD8, 0x000251A38000CDE0, 0x0026D8BF8000CDE4, 0x8000CDEC8000CDE8, 
0x000271A5000279A6, 0x000239AB8000CDF0, 0x8000CDF4000231AA, 0x0001F5AF8000CDF8, 0x000215AD0001F5AE, 0x00242D90000215AC, 0x00280D9200280591, 0x002D85940028D993, 
0x002CC596002C3595, 0x003001980031B597, 0x0035959A00301599, 0x00346D9C0034299B, 0x00383D9E0035999D, 0x8000CD540038359F, 0x003EC5B5003ED5B6, 0x003ED1B38000CDC4, 
0x8000CE008000CDFC, 0x003ED9BF8000CE04, 0x003EC5BD003ED5BE, 0x003ED5BB003EC5BC, 0x8000CE08003EE9BA, 0x0009E5A900245D8F, 0x000C05AB000815A8, 0x001001AD000C0DAA, 
0x001041AF000C01AC, 0x0000E1A10010BDAE, 0x000401A38000CE0C, 0x00049DA50000E1A2, 0x0008B9A7000495A4, 0x0039F5A0000801A6, 0x003CE9A2003D05A1, 0x8000CE10003DF5A3, 
0x8000CE188000CE14, 0x0014C1B18000CE1C, 0x001801B3001401B0, 0x0018D5B500147DB2, 0x8000CE200018D5B4, 0x002521828000CE24, 0x8000CE2800252983, 0x0029C5868000CE2C, 
0x00291984002C8187, 0x002D018A00291985, 0x8000CE30002DF98B, 0x0031018E8000CE38, 0x0030918C0034898F, 0x0035459200311D8D, 0x0007E88600351993, 0x003959960001EC87, 
0x0034F59400386197, 0x003CA19A00395995, 0x8000CE3C003D459B, 0x00007D818000CE40, 0x003C419C00007D80, 0x003FE9A800005582, 0x003F09AA003FFDA9, 0x003F1DAC003F05AB, 
0x003F0DAE003F05AD, 0x8000CE44003F05AF, 0x8000CE4C8000CE48, 0x8000CE548000CE50, 0x8000CE5C8000CE58, 0x003F0DB88000CE60, 0x003F15BA003F15B9, 0x003F3DBC003F25BB, 
0x003EF5BE003EFDBD, 0x003F7DB0003EEDBF, 0x003F41B2003F41B1, 0x003F41B4003F41B3, 0x003F3DB6003F4DB5, 0x003C81A3003F35B7, 0x8000CE688000CE64, 0x8000CE708000CE6C, 
0x003C95A5003C85A6, 0x003C85AB8000CE74, 0x8000CE78003CB9AA, 0x003C89AF8000CE7C, 0x003C95AD003C85AE, 0x0003C884003C95AC, 0x8000CE80003DEDB3, 0x003DE9B68000CE84, 
0x8000CE8C8000CE88, 0x003DADBA003DE9B5, 0x8000CE90003DB5BB, 0x003D9DBE8000CE94, 0x003DA5BC000221BF, 0x003D0DA8003D95BD, 0x003D21AA003D1DA9, 0x003D25AC003D3DAB, 
0x003D25AE003D2DAD, 0x00000D80003D59AF, 0x00001D8200001581, 0x8000CE9C8000CE98, 0x8000CEA88000CEA0, 0x0002B9B80003B8BE, 0x000219BA000261B9, 0x000209BC000219BB, 
0x000221BE000209BD, 0x003D2DB0000221BF, 0x003D35B2003D35B1, 0x003D1DB4003D05B3, 0x0002A1B60002A1B5, 0x003CA9A30002A1B7, 0x000528868000CEAC, 0x8000CEB00002EC87, 
0x003CADA5003CADA6, 0x003CF1AB8000CEB4, 0x8000CEB8003CE9AA, 0x000365AF8000CEBC, 0x003CD1AD003CD9AE, 0x8000CEC0003CE1AC, 0x8000CEC4000229B3, 0x0002F9B68000CEC8, 
0x8000CED08000CECC, 0x0002D5BA0002F9B5, 0x8000CED40002DDBB, 0x000179BE8000CED8, 0x0002C5BC000179BF, 0x8000CEDC000179BD, 0x0002E5A38000CEE0, 0x000235A58000CEE4, 
0x8000CEEC8000CEE8, 0x8000CEF0000235A6, 0x000211AB8000CEF4, 0x0001B5AD000219AA, 0x0001B5AF000209AC, 0x003EF0E30001B5AE, 0x003E40E1003FACE1, 0x8000CEF8003F7CE3, 
0x8000CF008000CEFC, 0x00000D808000CF04, 0x0000118200001181, 0x003EA8EF8000CF08, 0x8000CF108000CF0C, 0x00052DA8003E20EF, 0x000565AA00056DA9, 0x0005B5AC0005ADAB, 
0x0005B5AE0005BDAD, 0x8000CEA40005ADAF, 0x0003E0BE0003E884, 0x000310868000CF14, 0x8000CF1800039887, 0x000669B88000CF1C, 0x000601BA000669B9, 0x000605BC000601BB, 
0x000631BE00060DBD, 0x0005D5B0000631BF, 0x0005D5B20005DDB1, 0x000679B4000669B3, 0x000669B6000679B5, 0x000639A8000661B7, 0x000799AA000781A9, 0x0007B9AC000791AB, 
0x0007D9AE0007B9AD, 0x8000CF200007D5AF, 0x8000CE348000CF24, 0x8000CF2C8000CF28, 0x8000CF348000CF30, 0x000755B88000CF38, 0x000769BA00075DB9, 0x000701BC000769BB, 
0x000701BE000701BD, 0x0007ADB0000701BF, 0x0007B1B20007B1B1, 0x00079DB4000785B3, 0x00077DB6000775B5, 0x000611B3000771B7, 0x8000CF408000CF3C, 0x8000CF488000CF44, 
0x000631B5000639B6, 0x000675BB8000CF4C, 0x8000CF50000669BA, 0x0006B1BF8000CF54, 0x000651BD000659BE, 0x8000CF58000665BC, 0x8000CF5C000655A3, 0x00067DA68000CF60, 
0x8000CF688000CF64, 0x00062DAA000675A5, 0x8000CF6C000631AB, 0x00061DAE8000CF70, 0x000621AC0006F5AF, 0x0001B9A8000615AD, 0x000129AA0001B9A9, 0x00013DAC000129AB, 
0x00012DAE000125AD, 0x8000CF74000125AF, 0x00001D8100001D82, 0x8000CF7800001D80, 0x8000CF808000CF7C, 0x000081B8000170BE, 0x000085BA00008DB9, 0x000089BC000099BB, 
0x0000B5BE0000BDBD, 0x00015DB000007DBF, 0x0000E1B20000E1B1, 0x0000E1B40000E1B3, 0x0000D1B60000E9B5, 0x0002C8840000D1B7, 0x000338870002A5B3, 0x0002A1B600022886, 
0x8000CF8C8000CF88, 0x00029DBA0002B1B5, 0x00036CBE000321BB, 0x000321BE8000CF90, 0x000331BC000329BF, 0x0002E1A3000331BD, 0x8000CF988000CF94, 0x8000CFA08000CF9C, 
0x0002F5A50002E5A6, 0x000365AB8000CFA4, 0x8000CFA80002D9AA, 0x00036DAF8000CFAC, 0x000375AD000365AE, 0x000099A9000375AC, 0x0000CDAB000091A8, 0x0000DDAD0000A1AA, 
0x0000C5AF0000DDAC, 0x000D2CBE0000CDAE, 0x8000CFB48000CFB0, 0x8000CFBC8000CFB8, 0x8000CFC48000CFC0, 0x0001C1B98000CFC8, 0x0001C1BB000079B8, 0x0001C1BD0001C9BA, 
0x0001C5BF0001D9BC, 0x00008DB10001C5BE, 0x000041B300008DB0, 0x000041B5000049B2, 0x000041B7000059B4, 0x8000CFCC000049B6, 0x8000CFD48000CFD0, 0x8000CFDC8000CFD8, 
0x8000CFE0000750EF, 0x000FF8BE8000CFE4, 0x8000CFE8000774E3, 0x0000198000047CE1, 0x0000798200000981, 0x8000CFF08000CFEC, 0x8000CFF8000169B3, 0x00011DB60002C484, 
0x8000D0008000CFFC, 0x000109BA000115B5, 0x000DE886000109BB, 0x0001DDBE000DE887, 0x0001DDBC0001C5BF, 0x8000D0040001D5BD, 0x8000D00C8000D008, 0x0000D4EF8000D010, 
0x8000D0188000D014, 0x0003B0E300014CEF, 0x000180E10006B4E1, 0x8000D01C000198E3, 0x8000D0248000D020, 0x8000D02C8000D028, 0x0001E5A38000D030, 0x000199A5000DC084, 
0x8000D0388000D034, 0x8000D03C000191A6, 0x000185AB8000D040, 0x000159AD000185AA, 0x000149AF000151AC, 0x8000CFF4000151AE, 0x8000D0488000D044, 0x8000D0508000D04C, 
0x8000D0588000D054, 0x000F69A88000D05C, 0x000F71AA000F71A9, 0x000FB5AC000FADAB, 0x000FB5AE000FBDAD, 0x000FD9B0000FA9AF, 0x000FFDB2000FF5B1, 0x000FEDB4000FF5B3, 
0x000F9DB6000F95B5, 0x000FB9B8000F89B7, 0x000F8DBA000F85B9, 0x000079BC000069BB, 0x000069BE000079BD, 0x00009D81000069BF, 0x8000D06000009D80, 0x8000D06400000582, 
0x8000D06C8000D068, 0x000380868000D070, 0x8000D0740003F487, 0x8000D07C8000D078, 0x8000D0848000D080, 0x000F99B38000CF84, 0x8000D08C8000D088, 0x8000D0948000D090, 
0x000F5DB5000F5DB6, 0x000F51BB8000D098, 0x8000D09C000F7DBA, 0x000F31BF8000D0A0, 0x000F41BD000F49BE, 0x000E59A3000F49BC, 0x8000D0A88000D0A4, 0x8000D0B08000D0AC, 
0x000E9DA5000E9DA6, 0x000E91AB8000D0B4, 0x8000D0B8000EBDAA, 0x000EF1AF8000D0BC, 0x000E81AD000E89AE, 0x8000D0C0000E89AC, 0x8000D0C88000D0C4, 0x000019808000D0CC, 
0x0000058200001981, 0x0001A0848000D0D0, 0x0001E8878000D0D4, 0x8000D0D800040086, 0x8000D0E08000D0DC, 0x000115A88000D0E4, 0x000115AA00011DA9, 0x00013DAC000125AB, 
0x00012DAE000125AD, 0x8000D0E8000125AF, 0x8000D0F08000D0EC, 0x8000D0F88000D0F4, 0x8000D1008000D0FC, 0x0000C9B88000D104, 0x0000D9BA0000C9B9, 0x0000F9BC0000D1BB, 
0x000099BE0000F9BD, 0x000125B0000099BF, 0x000125B200012DB1, 0x00012DB400013DB3, 0x000115B600011DB5, 0x8000D1080000F9B7, 0x8000D1108000D10C, 0x8000D114000291B3, 
0x0002A9B60002B9B5, 0x8000D11C8000D118, 0x0002EDBA8000D120, 0x0002FDBC0002E5BB, 0x0002E5BE0002E5BD, 0x0002F1A60002D5BF, 0x8000D1288000D124, 0x8000D12C0002E1A5, 
0x8000D1300002C9A3, 0x0002BDAE8000D134, 0x0002A5AC00028DAF, 0x0002B5AA0002BDAD, 0x8000D1380002BDAB, 0x0000F9808000D13C, 0x000005820000F981, 0x0003C8BE8000D140, 
0x8000D14800031884, 0x8000D1508000D14C, 0x8000D1588000D154, 0x8000D1608000D15C, 0x000418868000D164, 0x8000D16800039C87, 0x8000D1708000D16C, 0x8000D1788000D174, 
0x0002B0EF8000D17C, 0x000194E18000D180, 0x00026CE38000D184, 0x8000D18C8000D188, 0x8000D1948000D190, 0x000FD0EF8000D198, 0x8000D1A08000D19C, 0x8000D1A88000D1A4, 
0x8000D1AC0001ACE1, 0x0000318000006CE3, 0x00001D8200003D81, 0x000E6CE3000EF4EF, 0x000F2CE18000D1B0, 0x000239B3000570BE, 0x0004E88600050C84, 0x000000DC00056087, 
0x0002F9B50002F1B6, 0x0002D5BB8000D1B8, 0x8000D1BC0002D5BA, 0x000175BF8000D1C0, 0x0002C5BD000175BE, 0x8000D1C40002C5BC, 0x8000D1C8000EF4E1, 0x8000D1CC000E50E3, 
0x8000D1D48000D1D0, 0x8000D1DC8000D1D8, 0x8000D1E48000D1E0, 0x8000D1EC8000D1E8, 0x8000D1F48000D1F0, 0x000265A6000FE4EF, 0x8000D1FC8000D1F8, 0x8000D20000026DA5, 
0x8000D2040002ADA3, 0x0001E1AE8000D208, 0x000251AC0001E1AF, 0x000241AA000251AD, 0x8000D20C000241AB, 0x000699A88000D210, 0x0006A9AA000699A9, 0x0006B9AC0006A9AB, 
0x0006A9AE0006B9AD, 0x8000D2140006A9AF, 0x00001D8100001D82, 0x8000D21800001D80, 0x8000D2208000D21C, 0x0006ADB8000374BE, 0x0006BDBA0006B5B9, 0x0006ADBC0006B5BB, 
0x000751BE000751BD, 0x0006A1B0000751BF, 0x0006A1B20006A1B1, 0x0006A1B40006A1B3, 0x0006A5B60006A1B5, 0x8000D144000699B7, 0x0003C484000625B3, 0x00063DB68000D1B4, 
0x8000D2288000D224, 0x000661BA000635B5, 0x00000886000661BB, 0x000661BE00008887, 0x000671BC000661BF, 0x000661A3000671BD, 0x8000D2308000D22C, 0x8000D2388000D234, 
0x000671A5000679A6, 0x000625AB8000D23C, 0x8000D240000625AA, 0x000625AF8000D244, 0x000635AD000625AE, 0x00065DA8000635AC, 0x000665AA00066DA9, 0x000699AC00068DAB, 
0x00068DAE000685AD, 0x8000D248000685AF, 0x8000D2508000D24C, 0x8000D2588000D254, 0x8000D2608000D25C, 0x000685B88000D264, 0x000699BA00068DB9, 0x00068DBC000695BB, 
0x0006A5BE0006ADBD, 0x0006FDB000017DBF, 0x0006CDB20006C5B1, 0x0006DDB40006C5B3, 0x0006CDB60006C5B5, 0x0006EDB30006C5B7, 0x8000D26C8000D268, 0x8000D2748000D270, 
0x000611B5000605B6, 0x000601BB8000D278, 0x8000D27C000639BA, 0x000601BF8000D280, 0x000611BD000619BE, 0x8000D284000619BC, 0x8000D2880006A9A3, 0x000641A68000D28C, 
0x000194848000D290, 0x00067DAA000655A5, 0x0001A0BE000645AB, 0x00065DAE8000D298, 0x00065DAC000645AF, 0x000299A8000655AD, 0x0002C1AA0002C1A9, 0x0002C1AC0002C1AB, 
0x0002F1AE0002C9AD, 0x0003ED810002F1AF, 0x8000D29C0003ED80, 0x001C90860003F982, 0x8000D2A000037487, 0x0003C5B88000D2A4, 0x0003C5BA0003CDB9, 0x0003CDBC0003DDBB, 
0x0003F5BE0003FDBD, 0x000341B000039DBF, 0x000341B2000341B1, 0x000341B4000341B3, 0x000341B6000341B5, 0x000249B3000341B7, 0x8000D2AC8000D2A8, 0x8000D2B48000D2B0, 
0x000249B5000249B6, 0x000385BB8000D2B8, 0x8000D2BC000385BA, 0x000385BF8000D2C0, 0x000395BD000385BE, 0x8000D2C4000395BC, 0x8000D2C800020DA3, 0x00020DA68000D2CC, 
0x8000D2D48000D2D0, 0x0003C1AA00020DA5, 0x8000D2D80003C1AB, 0x0003C1AE8000D2DC, 0x0003D1AC0003C1AF, 0x000198E30003D1AD, 0x000658E10007A4E1, 0x0001A0E1000658E3, 
0x0000D0E38000D2E0, 0x8000D2E88000D2E4, 0x000038EF8000D2EC, 0x0001F4EF8000D2F0, 0x8000D2F88000D2F4, 0x000079800006F8EF, 0x00001D8200001581, 0x8000D2FC001D0084, 
0x001D10BE8000D300, 0x001CC0868000D308, 0x8000D30C001DAC87, 0x8000D3148000D310, 0x8000D31C8000D318, 0x0005C5BB8000D320, 0x0005A9B90005A1BA, 0x0005CDBF000591B8, 
0x0005C9BD0005CDBE, 0x00061DB30005D5BC, 0x00061DB100061DB2, 0x0005A1B700061DB0, 0x0005BDB50005BDB6, 0x0006BDAB0005BDB4, 0x0006BDA90006BDAA, 0x00067DAF0006BDA8, 
0x00067DAD00067DAE, 0x8000D32400067DAC, 0x8000D32C8000D328, 0x8000D3348000D330, 0x8000D33C8000D338, 0x001DEDA88000D340, 0x001E31AA001E2DA9, 0x001E95AC001E31AB, 
0x001E95AE001E9DAD, 0x8000D304001E8DAF, 0x8000D3488000D344, 0x8000D3508000D34C, 0x8000D3588000D354, 0x001EA9B88000D35C, 0x001F5DBA001EA9B9, 0x001F71BC001F51BB, 
0x001F75BE001F71BD, 0x001EFDB0001F69BF, 0x001EC5B2001ECDB1, 0x001EB9B4001EADB3, 0x001EADB6001EB9B5, 0x001EB9B3001EA5B7, 0x8000D3648000D360, 0x8000D2948000D368, 
0x001E1DB5001E1DB6, 0x001E09BB8000D36C, 0x8000D370001E39BA, 0x001E7DBF0003E084, 0x001E79BD001E7DBE, 0x00006982001E11BC, 0x00004580001EFDA3, 0x001E59A600005181, 
0x8000D37400039CBE, 0x001E7DAA001E59A5, 0x00004886001E4DAB, 0x001E39AE00006C87, 0x001E55AC001E39AF, 0x001E5DA8001E3DAD, 0x001E65AA001E6DA9, 0x001E65AC001E7DAB, 
0x001E65AE001E6DAD, 0x8000D378001EFDAF, 0x8000D3808000D37C, 0x8000D3888000D384, 0x8000D3908000D38C, 0x000169B88000D394, 0x000179BA000169B9, 0x000169BC000179BB, 
0x0001DDBE000169BD, 0x001E85B00001D5BF, 0x001E85B2001E8DB1, 0x001E85B4001E9DB3, 0x001E85B6001E8DB5, 0x001EEDB3000159B7, 0x8000D39C8000D398, 0x8000D3A48000D3A0, 
0x001EEDB5001EEDB6, 0x001E49BB8000D3A8, 0x8000D3AC001E41BA, 0x001E49BF8000D3B0, 0x001E49BD001E41BE, 0x8000D3B4001E51BC, 0x8000D3B8001EA9A3, 0x001EA9A68000D3BC, 
0x8000D3C48000D3C0, 0x001E05AA001EA9A5, 0x8000D3C8001E0DAB, 0x001E05AE8000D3CC, 0x001E15AC001E0DAF, 0x000321A8001E0DAD, 0x000321AA000321A9, 0x000321AC000321AB, 
0x000321AE000321AD, 0x8000D3D0000321AF, 0x8000D3D88000D3D4, 0x8000D3DC000260BE, 0x8000D3E88000D3E0, 0x000389B88000D3EC, 0x00039DBA000389B9, 0x0003B9BC000395BB, 
0x000079BE0003B9BD, 0x0003E5B0000079BF, 0x0003E5B20003EDB1, 0x0003EDB40003FDB3, 0x0003D5B60003DDB5, 0x0000A9800003BDB7, 0x0000BD820000B581, 0x8000D3F00003A5B3, 
0x0003ADB60003A5B5, 0x0002E0848000D3F4, 0x00032DBA8000D3F8, 0x00033DBC000325BB, 0x000325BE000325BD, 0x0003E9A3000315BF, 0x000468868000D3FC, 0x8000D40000038087, 
0x0003E9A50003E1A6, 0x000369AB8000D404, 0x8000D408000361AA, 0x000359AF8000D40C, 0x000369AD000369AE, 0x8000D410000371AC, 0x8000D4188000D414, 0x8000D4208000D41C, 
0x8000D424001F3CE1, 0x8000D428001E40E3, 0x8000D4308000D42C, 0x8000D434001E8CEF, 0x8000D43C8000D438, 0x8000D4448000D440, 0x0000118100002582, 0x8000D44800001D80, 
0x8000D44C0003E4E3, 0x8000D4500001ACE1, 0x000264840003B0EF, 0x0004D086000560BE, 0x8000D45800054487, 0x8000D4608000D45C, 0x8000D4688000D464, 0x8000D4708000D46C, 
0x8000D4788000D474, 0x0005A4840001B0EF, 0x8000D47C001EDCE1, 0x8000D480000110E3, 0x8000D4888000D484, 0x000151B38000D48C, 0x8000D4948000D490, 0x8000D49C8000D498, 
0x00017DB5000111B6, 0x00010DBB8000D4A0, 0x8000D4A400010DBA, 0x0000FDBF8000D4A8, 0x0000FDBD0000FDBE, 0x000639A80000FDBC, 0x000699AA000639A9, 0x0006B5AC000691AB, 
0x0006C9AE0006D1AD, 0x8000D4540006C1AF, 0x8000D4B08000D4AC, 0x00000D808000D4B4, 0x0000B1820000B181, 0x000761B88000D4B8, 0x000761BA000761B9, 0x000765BC00077DBB, 
0x000765BE00076DBD, 0x000689B000071DBF, 0x000769B2000689B1, 0x000779B4000769B3, 0x000769B6000779B5, 0x000611A3000765B7, 0x8000D4C08000D4BC, 0x8000D4C4000380BE, 
0x00063DA5000651A6, 0x00064DAB8000D4C8, 0x0000088600064DAA, 0x0007BDAF00037C87, 0x0007BDAD0007BDAE, 0x8000D4CC0007BDAC, 0x000749B38000D4D0, 0x000759B58000D4D4, 
0x8000D4DC8000D4D8, 0x8000D4E0000751B6, 0x000741BB8000D3E4, 0x000745BD000775BA, 0x000745BF000745BC, 0x000679A8000745BE, 0x000689AA000679A9, 0x000699AC000689AB, 
0x000689AE000699AD, 0x8000D4E4000689AF, 0x8000D4EC8000D4E8, 0x8000D4F48000D4F0, 0x8000D4FC8000D4F8, 0x00068DB88000D500, 0x000695BA000695B9, 0x0006BDBC0006A5BB, 
0x000171BE000171BD, 0x0006F9B0000171BF, 0x0006D9B20006CDB1, 0x0006C9B40006D9B3, 0x0006BDB60006C9B5, 0x000601A30006B5B7, 0x8000D5088000D504, 0x8000D5108000D50C, 
0x000611A5000619A6, 0x000609AB8000D514, 0x8000D51800063DAA, 0x00060DAF8000D51C, 0x00060DAD00060DAE, 0x8000D52000060DAC, 0x8000D5288000D524, 0x000019808000D52C, 
0x0000058200001981, 0x0001AC848000D530, 0x0000E8870001ACBE, 0x8000D538000F4C86, 0x8000D5408000D53C, 0x00029DA88000D544, 0x0002CDAA0002C5A9, 0x0002C5AC0002C1AB, 
0x0002F9AE0002CDAD, 0x8000D54800033DAF, 0x8000D5508000D54C, 0x000C3CBE8000D554, 0x8000D55C8000D558, 0x0003C9B88000D560, 0x0003D9BA0003C9B9, 0x0003F9BC0003D1BB, 
0x000399BE0003F9BD, 0x000345B0000399BF, 0x000345B200034DB1, 0x000345B400035DB3, 0x000345B600034DB5, 0x000245B30003F9B7, 0x8000D5688000D564, 0x8000D5708000D56C, 
0x00024DB500024DB6, 0x000389BB8000D574, 0x8000D578000381BA, 0x000389BF8000D57C, 0x000389BD000381BE, 0x8000D580000391BC, 0x8000D584000201A3, 0x000209A68000D588, 
0x8000D5908000D58C, 0x0003C5AA000209A5, 0x8000D5940003CDAB, 0x0003C5AE8000D598, 0x0003D5AC0003CDAF, 0x0001ED800003CDAD, 0x0000118200001581, 0x8000D59C00020084, 
0x8000D5A00001A4E1, 0x8000D5A80000ECE3, 0x8000D5B08000D5AC, 0x8000D5B4000030EF, 0x8000D5BC8000D5B8, 0x000CE0868000D5C0, 0x8000D5C40002F487, 0x8000D5CC8000D5C8, 
0x0006CCEF8000D5D0, 0x0007B0E18000D5D4, 0x000610E38000D5D8, 0x8000D5E08000D5DC, 0x8000D5E88000D5E4, 0x8000D5F08000D5EC, 0x8000D5F88000D5F4, 0x8000D6008000D5FC, 
0x8000D6088000D604, 0x000F18850001E8EF, 0x8000D60C0006CCE1, 0x0000298000061CE3, 0x0000058200001D81, 0x000239B38000D610, 0x000F6886000DCC84, 0x03D2D0E1000CFC87, 
0x0001F9B50001F1B6, 0x0001D9BB8000D618, 0x000CE4BE0001D1BA, 0x00017DBF8000D61C, 0x00017DBD00017DBE, 0x000DF1A80001C1BC, 0x000DF1AA000DF1A9, 0x000E31AC000DF1AB, 
0x000E31AE000E31AD, 0x8000D5A4000E31AF, 0x8000D6208000D614, 0x8000D6288000D624, 0x8000D6308000D62C, 0x000EE9B88000D634, 0x000E89BA000EE9B9, 0x000E9DBC000E85BB, 
0x000E81BE000E81BD, 0x000E55B0000EB5BF, 0x000E55B2000E5DB1, 0x000EF9B4000EE9B3, 0x000EE9B6000EF9B5, 0x000D79A3000EE1B7, 0x8000D63C8000D638, 0x8000D6448000D640, 
0x000EB9A5000EB1A6, 0x000E99AB8000D648, 0x8000D64C000E91AA, 0x000E3DAF8000D650, 0x000E3DAD000E3DAE, 0x8000D654000E81AC, 0x8000D658000FEDB3, 0x000FE9B68000D65C, 
0x8000D6648000D660, 0x000FADBA000FE9B5, 0x8000D534000FB5BB, 0x000F95BE8000D668, 0x000FADBC000F99BF, 0x000E21A8000FA1BD, 0x000E21AA000E21A9, 0x000E25AC000E3DAB, 
0x000E25AE000E2DAD, 0x8000D66C000E55AF, 0x8000D6748000D670, 0x00001D808000D678, 0x0000BD8200000981, 0x000E39B88000D67C, 0x000EC9BA000E39B9, 0x000ED9BC000EC9BB, 
0x000EC9BE000ED9BD, 0x000E2DB0000EC9BF, 0x000E3DB2000E35B1, 0x000E15B4000E31B3, 0x000E09B6000E19B5, 0x000EA9A3000E09B7, 0x000280848000D680, 0x00040085000180BE, 
0x000EADA5000EADA6, 0x000EF1AB8000D688, 0x00072886000EE9AA, 0x000EDDAF00001887, 0x000EE5AD000ED1AE, 0x8000D68C000EE9AC, 0x8000D6900001EDB3, 0x0001E5B68000D694, 
0x8000D69C8000D698, 0x000165BA0001EDB5, 0x8000D6A000016DBB, 0x00016DBE8000D6A4, 0x000175BC00015DBF, 0x000DDDA800016DBD, 0x000221AA000DE9A9, 0x000221AC000221AB, 
0x000221AE000221AD, 0x8000D6A8000221AF, 0x8000D6B08000D6AC, 0x000211A28000D6B4, 0x000EA9A0000211A3, 0x000289B80002D5A1, 0x00029DBA000289B9, 0x0002BDBC000295BB, 
0x00037DBE000375BD, 0x0002E5B0000375BF, 0x0002E5B20002EDB1, 0x0002EDB40002FDB3, 0x0002D5B60002DDB5, 0x0002A9A30002BDB7, 0x8000D6B8001AC58F, 0x8000D6C08000D6BC, 
0x0002A9A50002A1A6, 0x000229AB8000D6C4, 0x8000D6C8000221AA, 0x000219AF8000D6CC, 0x000229AD000229AE, 0x000E259E000231AC, 0x000AE99C000EE59F, 0x0016459A000A159D, 
0x00165998000A459B, 0x0012719600165199, 0x0012559400138197, 0x001ED1920012ED95, 0x001AB590001ED993, 0x001FA984001E5591, 0x001F2586001F2585, 0x8000D6D00013B187, 
0x001B59828000D6D4, 0x0012458C001B5183, 0x0017A58E0017A58D, 0x01FB39800017B98F, 0x0013398A8000D6D8, 0x000B99940013AD8B, 0x000F6996000FA195, 0x8000D6DC000FDD97, 
0x000BC992000F9CEF, 0x0003459C000B7D93, 0x8000D6E0000E78E3, 0x8000D6E4000C98E1, 0x0003919A00027884, 0x000004E100035D9B, 0x03EADCE3000588BE, 0x8000D6EC8000D6E8, 
0x0000ECEF8000D6F0, 0x000E70E1000E8CEF, 0x000030E3000EFCE1, 0x00002181000E78E3, 0x03EDB4EF00003980, 0x000209B300002982, 0x000468868000D6F8, 0x8000D6FC00052C87, 
0x00020DB500020DB6, 0x0001C5BB8000D700, 0x8000D7040001C5BA, 0x00017DBF8000D708, 0x0001D5BD00017DBE, 0x8000D6840001D5BC, 0x8000D70C8000D6F4, 0x8000D7148000D710, 
0x8000D71C8000D718, 0x0005BDA88000D720, 0x0005E1AA0005E5A9, 0x0005E5AC0005E1AB, 0x0005D1AE0005EDAD, 0x000661B00005D1AF, 0x000661B2000661B1, 0x0006D9B4000661B3, 
0x0006C9B60006D9B5, 0x0006C9B80006C1B7, 0x000779BA0006C9B9, 0x000745BC000779BB, 0x000711BE000725BD, 0x000549A300070DBF, 0x8000D7288000D724, 0x8000D7308000D72C, 
0x00054DA500054DA6, 0x000685AB8000D734, 0x8000D738000685AA, 0x00063DAF8000D73C, 0x000695AD00063DAE, 0x8000D740000695AC, 0x8000D7488000D744, 0x8000D7508000D74C, 
0x8000D7588000D754, 0x000039808000D75C, 0x0000058200003981, 0x0003B8BE8000D760, 0x8000D7680003B884, 0x0006C5A88000D76C, 0x0006D5AA0006D5A9, 0x0006FDAC0006E5AB, 
0x000115AE00011DAD, 0x8000D76400010DAF, 0x000188868000D770, 0x8000D77400011C87, 0x8000D77C8000D778, 0x0001E9B88000D780, 0x000189BA0001E9B9, 0x000199BC000189BB, 
0x000189BE000199BD, 0x000175B0000189BF, 0x000175B200017DB1, 0x0001F9B40001E9B3, 0x0001E9B60001F9B5, 0x00065DB30001E1B7, 0x8000D7888000D784, 0x0001BC848000D78C, 
0x000675B500019DB6, 0x0001B9BB8000D790, 0x8000D7940001B1BA, 0x00013DBF8000D798, 0x00013DBD00013DBE, 0x8000D79C0001A1BC, 0x8000D7A0000619A3, 0x0001D9A68000D7A4, 
0x8000D7AC8000D7A8, 0x0001F5AA000631A5, 0x8000D7B00001FDAB, 0x000179AE8000D7B4, 0x0001E5AC000179AF, 0x0002F9A8000179AD, 0x00032DAA0002F9A9, 0x000325AC00033DAB, 
0x000325AE00032DAD, 0x8000D7B8000399AF, 0x8000D7C08000D7BC, 0x00000D808000D7C4, 0x0000B1820000B181, 0x000395B88000D7C8, 0x0003A1BA00039DB9, 0x000071BC0003A1BB, 
0x000071BE000071BD, 0x0003E9B0000071BF, 0x0003F5B20003E9B1, 0x0003DDB40003C5B3, 0x0003B1B60003B5B5, 0x0003CCBE0003B1B7, 0x8000D7D08000D7CC, 0x8000D7DC8000D7D8, 
0x8000D7E48000D7E0, 0x8000D7E80002E4EF, 0x8000D7EC000194E1, 0x8000D7F000012CE3, 0x000318878000D7F4, 0x00034DBB03FC1C86, 0x8000D7F800034DBA, 0x000311BF8000D7FC, 
0x000371BD000379BE, 0x0003C5B3000341BC, 0x8000D80003FCE884, 0x8000D8088000D804, 0x0003CDB50003CDB6, 0x03FC01A48000D80C, 0x03FFD9A603FF25A5, 0x8000D81003F801A7, 
0x00031DA2000315A1, 0x03F711AC00023DA3, 0x03F32DAE03F001AD, 0x03FB11A803F301AF, 0x03F401AA03FB99A9, 0x03E801B403F71DAB, 0x03FCC4BE03EB65B5, 0x03EC01B003FCC484, 
0x03EF4DB203EF55B1, 0x8000D81403EE71B3, 0x8000D81C8000D818, 0x8000D8248000D820, 0x8000D82C8000D828, 0x000650E18000D830, 0x00016CE3000434E1, 0x8000D8340006E8E3, 
0x8000D83C8000D838, 0x000035808000D840, 0x0000358200003D81, 0x8000D84C8000D848, 0x0001B0EF8000D850, 0x0002E5A30006C0EF, 0x03FCE8868000D854, 0x8000D85803FD7C87, 
0x0002EDA50002EDA6, 0x00026DAB8000D85C, 0x8000D86000026DAA, 0x000231AF8000D864, 0x000251AD000259AE, 0x03FE8DA8000261AC, 0x03FE9DAA03FE95A9, 0x03FEB1AC03FE95AB, 
0x03FEA9AE03FEBDAD, 0x8000D84403FEA9AF, 0x8000D86C8000D868, 0x8000D8748000D870, 0x8000D87C8000D878, 0x03FF25B88000D880, 0x03FF25BA03FF2DB9, 0x03FF25BC03FF3DBB, 
0x03FF25BE03FF2DBD, 0x03FEA9B003FFCDBF, 0x03FE81B203FEA9B1, 0x03FE81B403FE81B3, 0x03FF69B603FE89B5, 0x8000D88403FF1DB7, 0x8000D88803FC20E1, 0x8000D88C03FC78E3, 
0x8000D8948000D890, 0x8000D89C8000D898, 0x8000D8A48000D8A0, 0x00001D808000D8A8, 0x0000718200007181, 0x03FE55B303FD0CEF, 0x8000D8B08000D8AC, 0x8000D8B4000040BE, 
0x03FE79B503FE7DB6, 0x03FE2DBB8000D8B8, 0x0000E88603FE2DBA, 0x03FE0DBF0000AC87, 0x03FE15BD03FE05BE, 0x03FF95A303FE15BC, 0x8000D8C08000D8BC, 0x8000D8C88000D8C4, 
0x03FFB9A503FFBDA6, 0x03FFEDAB8000D8CC, 0x8000D8D003FFEDAA, 0x03FFCDAF8000D8D4, 0x03FFD5AD03FFC5AE, 0x8000D8D803FFD5AC, 0x8000D8DC03FEF1B3, 0x03FE8DB68000D8E0, 
0x8000D8E88000D8E4, 0x000145BA03FE8DB5, 0x8000D8EC00014DBB, 0x000145BE8000D8F0, 0x000155BC00014DBF, 0x03FE2DA800014DBD, 0x03FE3DAA03FE35A9, 0x03FE41AC03FE49AB, 
0x03FE71AE03FE49AD, 0x8000D8F403FE71AF, 0x8000D8FC8000D8F8, 0x8000D9048000D900, 0x8000D90C8000D908, 0x000149B88000D910, 0x00015DBA000155B9, 0x00014DBC000155BB, 
0x00017DBE000175BD, 0x0001C5B0000175BF, 0x0001C5B20001CDB1, 0x0001C5B40001DDB3, 0x0001C5B60001CDB5, 0x03FDB5A300017DB7, 0x8000D9188000D914, 0x8000D91C0003C484, 
0x03FDC9A503FDC9A6, 0x000209AB8000D920, 0x8000D928000201AA, 0x000209AF0002ECBE, 0x000209AD000201AE, 0x00004980000211AC, 0x0000558200005581, 0x8000D92C000345A3, 
0x000345A6000345A5, 0x0004C0868000D930, 0x000329AA00031487, 0x00033DAC000325AB, 0x000321AE000321AD, 0x8000D934000315AF, 0x8000D93C8000D938, 0x8000D9448000D940, 
0x8000D94C8000D948, 0x00027DA88000D950, 0x0003A1AA0003A1A9, 0x0003A1AC0003A1AB, 0x000391AE0003A9AD, 0x000381B0000391AF, 0x000385B200038DB1, 0x000389B4000399B3, 
0x0003B5B60003BDB5, 0x000345B800037DB7, 0x000345BA00034DB9, 0x000345BC00035DBB, 0x000345BE00034DBD, 0x8000D7D40000F9BF, 0x8000D95400020DB3, 0x00020DB68000D958, 
0x8000D9608000D95C, 0x000261BA00020DB5, 0x8000D96400026DBB, 0x000269BE8000D968, 0x000275BC00025DBF, 0x8000D96C000269BD, 0x8000D9748000D970, 0x8000D97C8000D978, 
0x8000D9800001A4E1, 0x8000D984000340E3, 0x8000D98C8000D988, 0x000015800003B8EF, 0x0000058200001D81, 0x000280848000D990, 0x000518870005C8BE, 0x8000D99800042C86, 
0x8000D9A08000D99C, 0x8000D9A40001A8EF, 0x8000D9A803FE74E1, 0x8000D9AC03FEF0E3, 0x8000D9B48000D9B0, 0x8000D9BC8000D9B8, 0x8000D9C48000D9C0, 0x8000D9C8000191B3, 
0x000151B6000151B5, 0x8000D9D08000D9CC, 0x00017DBA8000D9D4, 0x00016DBC000175BB, 0x0000F5BE0000FDBD, 0x000629A80000E9BF, 0x000655AA000655A9, 0x000695AC00068DAB, 
0x000695AE00069DAD, 0x8000D99400068DAF, 0x8000D9DC8000D9D8, 0x8000D9E48000D9E0, 0x8000D9EC8000D9E8, 0x00076DB88000D9F0, 0x00070DBA000705B9, 0x00071DBC000705BB, 
0x000701BE000705BD, 0x0006F5B000073DBF, 0x0006F5B20006FDB1, 0x00077DB4000765B3, 0x000761B6000761B5, 0x000510E3000755B7, 0x0004F0E18000D9F4, 0x00001D808000D9F8, 
0x0000398200000981, 0x8000DA008000D9FC, 0x0003E0BE0003E884, 0x0005CCEF8000DA04, 0x000038878000DA08, 0x00069DA300001886, 0x8000DA108000DA0C, 0x8000DA188000DA14, 
0x00065DA500065DA6, 0x000679AB8000DA1C, 0x8000DA20000671AA, 0x0007E5AF8000DA24, 0x0007F1AD0007F9AE, 0x000691A8000661AC, 0x000691AA000691A9, 0x0006B9AC0006ADAB, 
0x0006ADAE0006A5AD, 0x8000DA280006A5AF, 0x8000DA308000DA2C, 0x8000DA388000DA34, 0x8000DA408000DA3C, 0x000165B88000DA44, 0x000165BA00016DB9, 0x000165BC00017DBB, 
0x000165BE00016DBD, 0x0006DDB00001D9BF, 0x0006ADB20006A5B1, 0x0006A1B40006A5B3, 0x000699B60006A9B5, 0x000619B3000699B7, 0x8000DA4C8000DA48, 0x8000DA548000DA50, 
0x000631B5000625B6, 0x000661BB8000DA58, 0x8000DA5C000619BA, 0x00066DBF8000DA60, 0x000671BD000665BE, 0x8000DA64000679BC, 0x8000DA6800065DA3, 0x000661A68000DA6C, 
0x000198848000DA70, 0x00065DAA000675A5, 0x0001A4BE000625AB, 0x000621AE8000DA78, 0x00063DAC000629AF, 0x0002C5A9000635AD, 0x0002C5AB0002B1A8, 0x0002CDAD0002C5AA, 
0x0002F5AF0002C5AC, 0x8000DA7C0002F5AE, 0x8000DA848000DA80, 0x8000DA8C8000DA88, 0x8000DA948000DA90, 0x0003C9B98000DA98, 0x0003D9BB0003C1B8, 0x0003F9BD0003C1BA, 
0x000399BF0003C9BC, 0x000345B10003F1BE, 0x000345B3000345B0, 0x000345B5000345B2, 0x000345B7000345B4, 0x00034980000345B6, 0x00035D8200034981, 0x000CDCBE000245B3, 
0x000245B6000245B5, 0x000C00868000DA9C, 0x000389BA0003E487, 0x000399BC000389BB, 0x000389BE000399BD, 0x000209A3000389BF, 0x8000DAA48000DAA0, 0x8000DAAC8000DAA8, 
0x000209A5000209A6, 0x0003C5AB8000DAB0, 0x8000DAB40003C5AA, 0x0003C5AF8000DAB8, 0x0003D5AD0003C5AE, 0x8000DABC0003D5AC, 0x8000DAC48000DAC0, 0x000000EF8000D924, 
0x8000DACC8000DAC8, 0x0000E8E38000DAD0, 0x00018CE18000DAD4, 0x8000DADC8000DAD8, 0x8000DAE88000DAE0, 0x00006D808000DAEC, 0x00007D8200007581, 0x000CF08600024084, 
0x8000DAF0000D7887, 0x8000DAF88000DAF4, 0x8000DB008000DAFC, 0x8000DB088000DB04, 0x8000DB108000DB0C, 0x8000DB188000DB14, 0x8000DB208000DB1C, 0x8000DB288000DB24, 
0x8000DB308000DB2C, 0x000CEC840001CCEF, 0x8000DB34000630E1, 0x8000DB38000118E3, 0x8000DB408000DB3C, 0x0001E5B38000DB44, 0x000F84848000DB48, 0x8000DB508000DB4C, 
0x0001F5B50001E5B6, 0x00017DBB8000DB58, 0x000CA0BE0001D9BA, 0x000121BF8000DB5C, 0x000131BD000139BE, 0x000DEDA8000139BC, 0x000E2DAA000E25A9, 0x000E3DAC000E25AB, 
0x000E2DAE000E25AD, 0x8000DAE4000E25AF, 0x000FE581000FF582, 0x8000DB54000FE980, 0x000098868000DB60, 0x000EADB800030C87, 0x000F4DBA000F45B9, 0x000F45BC000F45BB, 
0x000F45BE000F4DBD, 0x000E5DB0000F79BF, 0x000EADB2000EF9B1, 0x000EBDB4000EA5B3, 0x000EA5B6000EA5B5, 0x8000DB64000E95B7, 0x8000DB68000CECEF, 0x8000DB708000DB6C, 
0x8000DB788000DB74, 0x0000E8BE8000DB7C, 0x8000DB848000DB80, 0x8000DB8C8000DB88, 0x8000DB90000DE8E3, 0x000EE5A3000C04E1, 0x8000DB988000DB94, 0x8000DBA08000DB9C, 
0x000EF5A5000EE5A6, 0x000E7DAB8000DBA4, 0x8000DBA8000ED9AA, 0x000E21AF8000DBAC, 0x000E31AD000E39AE, 0x000E39A8000E39AC, 0x000E51AA000E39A9, 0x000E71AC000E51AB, 
0x000E71AE000E71AD, 0x8000DBB0000E71AF, 0x8000DBB88000DBB4, 0x000019808000DBBC, 0x0000058200001981, 0x000ED1B88000DBC0, 0x000ED1BA000ED1B9, 0x000EE1BC000EE5BB, 
0x000EE1BE000EE1BD, 0x000E11B0000EE1BF, 0x000E11B2000E11B1, 0x000EF1B4000E11B3, 0x000EF1B6000EF1B5, 0x000ED9B3000EF1B7, 0x000028868000DBC8, 0x8000DBCC0000B887, 
0x000EF9B5000EF1B6, 0x000ED5BB8000DBD0, 0x8000DBD4000ED5BA, 0x000E35BF8000DBD8, 0x000EC5BD000E35BE, 0x8000DBDC000EC5BC, 0x8000DBE0000E9DA3, 0x000EB5A68000DBE4, 
0x8000DBEC8000DBE8, 0x000E91AA000EBDA5, 0x8000DBF0000E91AB, 0x000E71AE8000DBF4, 0x000E81AC000E71AF, 0x000DDDA8000E81AD, 0x00023DAA000DE9A9, 0x000299AC00028DAB, 
0x000289AE000299AD, 0x0004ACBE000289AF, 0x8000DBFC8000DBF8, 0x8000DC0000032084, 0x8000DC088000DC04, 0x000289B88000DC0C, 0x000299BA000289B9, 0x0002B9BC000291BB, 
0x000379BE0002B9BD, 0x0002F9B0000379BF, 0x0002CDB20002F9B1, 0x0002DDB40002C5B3, 0x0002C1B60002C5B5, 0x0002B5B30002B9B7, 0x8000DC148000DC10, 0x8000DC1C8000DC18, 
0x000211B5000219B6, 0x00023DBB8000DC20, 0x8000DC2400023DBA, 0x000201BF8000DC28, 0x000211BD000219BE, 0x8000DC2C000219BC, 0x8000DC300002F1A3, 0x00025DA68000DC38, 
0x8000DC408000DC3C, 0x000279AA000255A5, 0x00054886000279AB, 0x00025DAE0004AC87, 0x00025DAC000245AF, 0x000285A8000255AD, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x8000DC440002D1AF, 0x8000DC4C8000DC48, 0x0001F1818000DC50, 0x8000DA7400019980, 0x000179B80001F582, 0x0001CDBA000179B9, 0x0001DDBC0001C5BB, 
0x0001C5BE0001C5BD, 0x0002B5B00001F5BF, 0x000281B20002BDB1, 0x000155B4000281B3, 0x000149B600015DB5, 0x8000DC54000149B7, 0x8000DC5C8000DC58, 0x000510840001D4EF, 
0x8000DC648000DC60, 0x0005ECBE000E8CEF, 0x8000DC68000EECE1, 0x8000DC6C000E1CE3, 0x8000DC70000194E1, 0x00025DB3000E64E3, 0x8000DC788000DC74, 0x8000DC808000DC7C, 
0x000275B5000215B6, 0x000239BB8000DC84, 0x8000DC88000231BA, 0x0001D9BF8000DC8C, 0x000215BD0001D1BE, 0x00059DA3000215BC, 0x8000DC908000DC34, 0x8000DC988000DC94, 
0x0005B5A50005D5A6, 0x0005F9AB8000DC9C, 0x8000DCA00005F1AA, 0x000619AF8000DCA4, 0x0005D5AD000611AE, 0x000051800005D5AC, 0x0000618200005981, 0x8000DCA8000695B3, 
0x000771B6000771B5, 0x000340868000DCAC, 0x0007EDBA00035487, 0x0007E5BC0007E5BB, 0x0007D1BE0007EDBD, 0x8000DCB00007CDBF, 0x8000DCB88000DCB4, 0x8000DCC08000DCBC, 
0x000440EF8000DCC4, 0x000730E18000DCC8, 0x000494E38000DCCC, 0x8000DCD48000DCD0, 0x8000DCDC8000DCD8, 0x000619A38000DCE0, 0x8000DCE88000DCE4, 0x8000DCF08000DCEC, 
0x0007FDA50007FDA6, 0x000769AB8000DCF4, 0x8000DCF8000761AA, 0x000741AF8000DCFC, 0x000761AD00075DAE, 0x0007CDA8000769AC, 0x0007D1AA0007D1A9, 0x000635AC00062DAB, 
0x000635AE00063DAD, 0x8000DD0000069DAF, 0x8000DD088000DD04, 0x000019808000DD0C, 0x0000058200001981, 0x000689B88000DD10, 0x000699BA000689B9, 0x0006B9BC000691BB, 
0x000151BE0006B9BD, 0x0006E5B0000151BF, 0x0006FDB20006EDB1, 0x0006D9B40006F5B3, 0x0006C1B60006C5B5, 0x0001D1A80006B9B7, 0x000109AA0001D9A9, 0x000119AC000109AB, 
0x000109AE000119AD, 0x00016084000109AF, 0x0000A88700017CBE, 0x8000DD1800018C86, 0x8000DD208000DD1C, 0x000109B88000DD24, 0x000119BA000109B9, 0x000139BC000111BB, 
0x0000F9BE000139BD, 0x00017DB00000F9BF, 0x000145B2000141B1, 0x000145B400015DB3, 0x000145B600014DB5, 0x8000DD28000139B7, 0x8000DD308000DD2C, 0x8000DD3400028DB3, 
0x000295B600029DB5, 0x8000DD3C8000DD38, 0x0002B5BA8000DD40, 0x00029DBC000289BB, 0x00028DBE000285BD, 0x0002CDA6000285BF, 0x8000DD488000DD44, 0x8000DD4C0002C5A5, 
0x8000DD500002D5A3, 0x0002D5AE8000DD54, 0x0002C5AC0002DDAF, 0x0002EDAA0002DDAD, 0x0003F4840002D1AB, 0x000331A88000DD58, 0x000331AA000331A9, 0x000091AC000331AB, 
0x000091AE000091AD, 0x8000DD5C00008DAF, 0x8000DD648000DD60, 0x8000DD6C8000DD68, 0x8000DD748000DD70, 0x0000BDB88000DD78, 0x00006DBA000065B9, 0x00007DBC000065BB, 
0x00006DBE000065BD, 0x0000FDB0000065BF, 0x0000CDB20000C5B1, 0x0000B9B40000A9B3, 0x0000A1B60000A5B5, 0x0001BD800000A1B7, 0x0000198200000981, 0x8000DD808000DD7C, 
0x001D1487000258BE, 0x001D6C84001D9C86, 0x8000DD888000DBC4, 0x001CBCBE8000DD8C, 0x8000DD948000DD90, 0x0002F9B38000DD98, 0x8000DDA08000DD9C, 0x8000DDA88000DDA4, 
0x000159B5000151B6, 0x000141BB001FDCBE, 0x8000DDAC000179BA, 0x000121BF8000DDB0, 0x00013DBD00013DBE, 0x000770E1000159BC, 0x000608E38000DDB4, 0x0000CCEF8000DDB8, 
0x8000DDC08000DDBC, 0x000010E38000DDC4, 0x0001D0E18000DDC8, 0x001C90868000DDCC, 0x0006E0EF001CF487, 0x000279A38000DDD0, 0x8000DDD88000DDD4, 0x8000DDE08000DDDC, 
0x0001D9A50001D1A6, 0x0001C1AB8000DDE4, 0x8000DDE80001F9AA, 0x0001A1AF8000DDEC, 0x0001BDAD0001BDAE, 0x8000DD840001D9AC, 0x001FE58100001582, 0x8000DDF0001FE580, 
0x8000DDF88000DDF4, 0x001F09A88000DDFC, 0x001F1DAA001F09A9, 0x001F0DAC001F15AB, 0x001F71AE001F71AD, 0x001F11B0001F71AF, 0x001F25B2001F2DB1, 0x001FDDB4001FC9B3, 
0x001FC1B6001FC1B5, 0x001FC5B8001FC1B7, 0x001FD5BA001FC9B9, 0x001FB9BC001FA9BB, 0x001FA9BE001FB9BD, 0x001FB5B3001FA1BF, 0x8000DE048000DE00, 0x8000DE0C8000DE08, 
0x001FA5B5001FD1B6, 0x001FC9BB8000DE10, 0x8000DE14001FF5BA, 0x001F25BF8000DE18, 0x001F3DBD001F39BE, 0x8000DE1C001FD1BC, 0x8000DE248000DE20, 0x8000DE2C8000DE28, 
0x8000DE30001F60E1, 0x8000DE34001CB4E3, 0x8000DE3C8000DE38, 0x8000DE40001D00EF, 0x8000DE488000DE44, 0x001E35A38000DE4C, 0x8000DE548000DE50, 0x8000DE5C8000DE58, 
0x001E25A5001E51A6, 0x001E49AB8000DE60, 0x0002A884001E75AA, 0x001EA5AF8000DE64, 0x001EBDAD001EB9AE, 0x00004D80001E51AC, 0x0000558200005581, 0x8000DE680001C9B3, 
0x0001C9B60001D9B5, 0x0000A0868000DE6C, 0x0001C5BA00010487, 0x0001B5BC0001ADBB, 0x0001B5BE0001BDBD, 0x000199A80001ADBF, 0x00010DAA000199A9, 0x00011DAC000105AB, 
0x000105AE000105AD, 0x8000DE70000135AF, 0x8000DE788000DE74, 0x8000DE808000DE7C, 0x8000DE888000DE84, 0x000125B88000DE8C, 0x000139BA00012DB9, 0x000129BC000139BB, 
0x0000DDBE000129BD, 0x00014DB00000D5BF, 0x00012DB2000125B1, 0x00013DB4000125B3, 0x000121B6000125B5, 0x8000DE9000011DB7, 0x8000DE988000DE94, 0x8000DE9C000289A3, 
0x000289A6000299A5, 0x8000DEA48000DEA0, 0x000285AA8000DEA8, 0x0002F5AC0002EDAB, 0x0002F5AE0002FDAD, 0x8000DEAC0002EDAF, 0x8000DEB48000DEB0, 0x8000DEB800024084, 
0x8000DEC08000DEBC, 0x00000D808000DEC4, 0x00001D8200001581, 0x8000DECC8000DEC8, 0x0003B4878000DED0, 0x0003CCBE0004DC86, 0x8000DEDC8000DED8, 0x0002E8EF8000DEE0, 
0x8000DEE88000DEE4, 0x0002FCE38000DEEC, 0x0001D0E18000DEF0, 0x8000DEF88000DEF4, 0x8000DF008000DEFC, 0x000361B38000DF04, 0x8000DF0C8000DF08, 0x8000DF148000DF10, 
0x000371B5000379B6, 0x00035DBB8000DF18, 0x8000DF1C00035DBA, 0x0000E1BF8000DF20, 0x0000FDBD0000FDBE, 0x0002B9B00000FDBC, 0x000109B20002B9B1, 0x000119B4000109B3, 
0x000105B6000105B5, 0x000105B800013DB7, 0x00016DBA000165B9, 0x000161BC000165BB, 0x000161BE000161BD, 0x00075C85000161BF, 0x8000DF288000DF24, 0x8000DD148000DF2C, 
0x8000DF348000DF30, 0x000231A88000DF38, 0x0002C9AA000239A9, 0x0002D9AC0002C9AB, 0x0002C9AE0002D9AD, 0x0005CC840002C9AF, 0x8000DF3C001E80E1, 0x001E38E1001EBCE3, 
0x0000A0E38000DF40, 0x8000DF48000410BE, 0x001E0CEF8000DF4C, 0x8000DF548000DF50, 0x8000DF5C8000DF58, 0x000261A3001E74EF, 0x0000418100005182, 0x8000DF6000009180, 
0x000271A5000279A6, 0x00025DAB8000DF64, 0x0004C88600025DAA, 0x0001E1AF00053C87, 0x0001FDAD0001FDAE, 0x000685A80001FDAC, 0x000685AA00068DA9, 0x000689AC000699AB, 
0x0006BDAE000689AD, 0x8000DF440006B1AF, 0x8000DF6C8000DF68, 0x8000DF748000DF70, 0x8000DF7C8000DF78, 0x00069DB88000DF80, 0x0006A5BA0006ADB9, 0x000719BC000709BB, 
0x00070DBE000719BD, 0x0006D1B0000705BF, 0x0006D1B20006D1B1, 0x0006B5B40006D1B3, 0x0006B5B60006BDB5, 0x00060DB30006ADB7, 0x8000DF888000DF84, 0x8000DF908000DF8C, 
0x000601B5000609B6, 0x000615BB8000DF94, 0x8000DF98000615BA, 0x000679BF8000DF9C, 0x000605BD000671BE, 0x8000DFA0000605BC, 0x8000DFA40004A0E1, 0x00000D8000055CE3, 
0x00003D8200003581, 0x8000DFAC8000DFA8, 0x000360848000DFB0, 0x0001F0BF00006CBE, 0x8000DFB400009085, 0x00078DA3000598EF, 0x000C008600000884, 0x8000DFB800008C87, 
0x000781A5000789A6, 0x000795AB8000DFBC, 0x8000DFC0000795AA, 0x0007F9AF8000DFC4, 0x000785AD0007F1AE, 0x8000DFC8000785AC, 0x8000DFCC0006E9B3, 0x0006E9B68000DFD0, 
0x8000DFD88000DFD4, 0x000145BA0006E9B5, 0x8000DFDC00014DBB, 0x000145BE8000DFE0, 0x000155BC00014DBF, 0x000621A800014DBD, 0x000625AA000621A9, 0x000625AC00063DAB, 
0x000649AE00062DAD, 0x8000DFE4000641AF, 0x8000DFEC8000DFE8, 0x8000DFF48000DFF0, 0x8000DFFC8000DFF8, 0x000149B88000E000, 0x000159BA000149B9, 0x000179BC000151BB, 
0x000119BE000179BD, 0x0001C5B0000115BF, 0x0001C5B20001CDB1, 0x0001C5B40001DDB3, 0x0001C5B60001CDB5, 0x8000E004000179B7, 0x8000E00C8000E008, 0x8000E0100005A1A3, 
0x0005A1A60005A1A5, 0x03EA218F8000E014, 0x00020DAA8000E018, 0x00021DAC000205AB, 0x00020DAE000205AD, 0x0012ED97000205AF, 0x0011459500126596, 0x0016719300169D94, 
0x03EB799100155592, 0x0006619F03EA5990, 0x001A459D0005359E, 0x0019559B001A699C, 0x001E5999001E459A, 0x000060E1001D4598, 0x003E4CE38000E01C, 0x0002B1A38000E020, 
0x0007B5A10001D5A2, 0x003801B1000689A0, 0x003A95B3003E09B0, 0x0026B5B5003A8DB2, 0x003A68EF002401B4, 0x0036C9A9000C30BE, 0x003001AB0036C1A8, 0x0033CDAD0037E1AA, 
0x003EF9AF0032F5AC, 0x000219A1003C01AE, 0x000E6DA38000E028, 0x000AF5A5000E6DA2, 0x000B85A7000801A4, 0x000D0086000A99A6, 0x03EB0982000D4487, 0x03EA318403EB0983, 
0x0017398600141585, 0x000DA0840017CD87, 0x0010258A8000E02C, 0x00139D8C00130D8B, 0x001F198E001C0D8D, 0x8000DED4001F0D8F, 0x00186D92000300EF, 0x001B7D94001B4993, 
0x0007599600040595, 0x8000E03000074997, 0x0006459A8000E034, 0x0003519C00002D9B, 0x8000E038000060E3, 0x0001A58000006CE1, 0x0001058200010181, 0x8000E03C000C00BE, 
0x8000E0448000E040, 0x8000E048000188EF, 0x8000E04C000654E1, 0x8000E050000154E3, 0x8000E0588000E054, 0x0002E9B38000E05C, 0x8000E0648000E060, 0x8000E06C8000E068, 
0x000299B500029DB6, 0x000289BB8000E070, 0x8000E0740002BDBA, 0x000259BF8000E078, 0x000259BD000251BE, 0x000D29A3000291BC, 0x8000E0808000E07C, 0x8000E0888000E084, 
0x000D59A5000D5DA6, 0x000D49AB8000E08C, 0x8000E090000D7DAA, 0x000D99AF8000E098, 0x000D99AD000D91AE, 0x00005180000D51AC, 0x0000618200005981, 0x8000E09C000F2DB3, 
0x000FC9B6000F2DB5, 0x000340868000E0A0, 0x000FC9BA00030887, 0x000FC1BC000FC5BB, 0x000FC1BE000FC1BD, 0x8000E024000FC1BF, 0x8000E0A48000E094, 0x8000E0AC8000E0A8, 
0x8000E0B48000E0B0, 0x000E45A88000E0B8, 0x000FC9AA000F81A9, 0x000FC9AC000FC9AB, 0x000F2DAE000F25AD, 0x000F61B0000F25AF, 0x000F79B2000F6DB1, 0x000F69B4000F79B3, 
0x000F1DB6000F69B5, 0x000F2DB8000F15B7, 0x000F35BA000F35B9, 0x000F1DBC000F05BB, 0x0000F1BE0000F1BD, 0x000E61A30000F1BF, 0x0001C4848000E0BC, 0x8000E0C48000E0C0, 
0x000E61A5000E85A6, 0x000E89AB8000E0C8, 0x8000E0CC000E85AA, 0x000E8DAF8000E0D0, 0x000E8DAD000E8DAE, 0x8000E0D4000E8DAC, 0x8000E0DC8000E0D8, 0x8000E0E48000E0E0, 
0x8000E0EC8000E0E8, 0x8000E0F48000E0F0, 0x00001D8100001D82, 0x8000E0F800001D80, 0x8000E1008000E0FC, 0x0001ADA80001B4BE, 0x0001D5AA0001D5A9, 0x00011DAC000105AB, 
0x00010DAE000105AD, 0x00018086000105AF, 0x8000E10800011887, 0x8000E1108000E10C, 0x8000E1188000E114, 0x000085B88000E11C, 0x000085BA00008DB9, 0x000085BC00009DBB, 
0x000085BE00008DBD, 0x00017DB00000BDBF, 0x0000E5B20000E1B1, 0x0000EDB40000FDB3, 0x0000D5B60000DDB5, 0x00025DB30000BDB7, 0x8000E1248000E120, 0x8000E12C8000E128, 
0x000295B5000285B6, 0x000325BB8000E130, 0x8000E1340002B9BA, 0x000319BF8000E138, 0x000329BD000329BE, 0x0004CCBE000331BC, 0x8000E13C000219A3, 0x0002C1A68000E140, 
0x8000E1488000E144, 0x0002FDAA0002D1A5, 0x8000E14C000361AB, 0x00036DAE8000E150, 0x000375AC00035DAF, 0x000329A800036DAD, 0x000339AA000329A9, 0x000329AC000339AB, 
0x00009DAE000329AD, 0x8000E154000095AF, 0x8000E15C8000E158, 0x8000E1648000E160, 0x0001AD810001A982, 0x000099B80001AD80, 0x0000A5BA0000ADB9, 0x000075BC00006DBB, 
0x000075BE00007DBD, 0x0000EDB000006DBF, 0x0000F5B20000F5B1, 0x0000DDB40000C5B3, 0x0000B5B60000BDB5, 0x000178E10000A9B7, 0x000010E3000E1CE1, 0x8000E168000E3CE3, 
0x000414BE8000E16C, 0x0002AC848000E170, 0x000578878000E178, 0x8000E17C00050C86, 0x0000BCEF8000E180, 0x0002F1B3000E48EF, 0x8000E1888000E184, 0x8000E1908000E18C, 
0x0002E1B50002E9B6, 0x000171BB8000E194, 0x8000E198000169BA, 0x000139BF0004A084, 0x000151BD000159BE, 0x8000E19C000161BC, 0x8000E1A000048C84, 0x8000E1A400380084, 
0x8000E1AC8000E1A8, 0x000E89AA8000E1B0, 0x000EB9A8000E89AB, 0x000EFDAE000EB1A9, 0x000EF9AC000EE1AF, 0x000EADB2000EF5AD, 0x000E91B0000E65B3, 0x000E7DB6000EA5B1, 
0x000E7DB4000E65B7, 0x000E5DBA000E75B5, 0x000E5DB8000DE5BB, 0x000DE1BE000E55B9, 0x000DFDBC000DE9BF, 0x0005B1A3000DF5BD, 0x8000E1B48000E174, 0x8000E1BC8000E1B8, 
0x0005A1A50005A9A6, 0x000631AB8000E1C0, 0x8000E1C4000629AA, 0x000679AF8000E1C8, 0x000611AD000619AE, 0x8000E1CC000621AC, 0x8000E1D48000E1D0, 0x00001D808000E1D8, 
0x0000398200000981, 0x8000E1E08000E1DC, 0x0000C8868000E1E4, 0x8000E1E800030C87, 0x8000E1F08000E1EC, 0x0007A5A88000E1F4, 0x0007BDAA0007B5A9, 0x0007D9AC0007C9AB, 
0x0007C9AE0007D9AD, 0x0000A0BE0007C1AF, 0x8000E1FC8000E1F8, 0x8000E2048000E200, 0x8000E20C8000E208, 0x0000CDB88000E210, 0x0000D5BA0000D5B9, 0x0000FDBC0000E5BB, 
0x00009DBE000095BD, 0x000789B0000095BF, 0x000761B2000765B1, 0x000765B400077DB3, 0x000765B600076DB5, 0x000635B30000F5B7, 0x8000E2188000E214, 0x8000E2208000E21C, 
0x000651B5000659B6, 0x0006A1BB8000E224, 0x8000E22800064DBA, 0x0006A9BF8000E22C, 0x0006A9BD0006A1BE, 0x8000E2300006B5BC, 0x0005F0EF8000E234, 0x8000E23C8000E238, 
0x8000E2448000E240, 0x00003D808000E248, 0x00001D8200000981, 0x0006C8E18000E24C, 0x000448E38000E250, 0x0006B5A38000E254, 0x000028868000E258, 0x8000E25C00014087, 
0x0006D1A50006D9A6, 0x000621AB8000E260, 0x8000E2640006CDAA, 0x000629AF8000E268, 0x000629AD000621AE, 0x8000E26C000635AC, 0x8000E2700001BDB3, 0x000179B68000E274, 
0x8000E27C8000E278, 0x000155BA000179B5, 0x8000E28000015DBB, 0x0000F9BE8000E284, 0x000145BC0000F9BF, 0x000271A80000F9BD, 0x000271AA000271A9, 0x0002B5AC000271AB, 
0x0002B5AE0002BDAD, 0x003CACBE0002ADAF, 0x8000E28C8000E288, 0x8000E2948000E290, 0x8000E29C8000E298, 0x000369B88000E2A0, 0x000309BA000369B9, 0x00031DBC000309BB, 
0x00030DBE000305BD, 0x0002D5B0000305BF, 0x0002D5B20002DDB1, 0x000379B4000369B3, 0x000369B6000379B5, 0x8000E2A4000361B7, 0x8000E2AC8000E2A8, 0x8000E2B00002F5A3, 
0x000231A6000231A5, 0x8000E2B88000E2B4, 0x00021DAA8000E2BC, 0x00020DAC000215AB, 0x0003B1AE0003B1AD, 0x000218EF0003B1AF, 0x00006D8100001582, 0x8000E2C000006D80, 
0x003CF8868000E2C8, 0x8000E2CC00031887, 0x8000E2D48000E2D0, 0x00076CE38000E2D8, 0x000168E18000E104, 0x000285A88000E2DC, 0x000295AA000295A9, 0x0002BDAC0002A5AB, 
0x0002D1AE0002D5AD, 0x8000E2E00002D1AF, 0x8000E2E88000E2E4, 0x8000E2F08000E2EC, 0x8000E2F88000E2F4, 0x000175B88000E2FC, 0x000175BA00017DB9, 0x0001D5BC0001CDBB, 
0x0001C9BE0001DDBD, 0x0002B5B00001C1BF, 0x000281B20002BDB1, 0x000155B4000281B3, 0x000155B600015DB5, 0x0006B4E100014DB7, 0x0006F4E38000E300, 0x003D18848000E304, 
0x8000E30C8000E308, 0x8000E3148000E310, 0x8000E31C8000E318, 0x8000E3248000E320, 0x000658EF8000E328, 0x00007D818000E32C, 0x8000E33000007180, 0x8000E33800000582, 
0x000180EF8000E33C, 0x000190E1003C54BE, 0x00067CE38000E340, 0x8000E3488000E344, 0x003CD8868000E34C, 0x003D9DA3003CF487, 0x8000E3348000E2C4, 0x8000E3548000E350, 
0x003DB5A5003DD5A6, 0x003DF9AB8000E358, 0x8000E35C003DF1AA, 0x003E19AF8000E360, 0x003DD5AD003E11AE, 0x8000E364003DD5AC, 0x8000E368003EA1B3, 0x003EADB68000E36C, 
0x8000E3748000E370, 0x003F49BA003EB1B5, 0x8000E378003F49BB, 0x003F49BE8000E37C, 0x003F49BC003F49BF, 0x003E55A8003F49BD, 0x003E6DAA003E65A9, 0x003E7DAC003E65AB, 
0x003FB9AE003E69AD, 0x8000E380003FB9AF, 0x8000E3888000E384, 0x8000E3908000E38C, 0x8000E3988000E394, 0x003F55B88000E39C, 0x003F55BA003F5DB9, 0x003F75BC003F6DBB, 
0x003F75BE003F7DBD, 0x003FC9B0003F6DBF, 0x003FD9B2003FC9B1, 0x003FC9B4003FD9B3, 0x003F7DB6003FC9B5, 0x00001582003F71B7, 0x0001B180003FE1A3, 0x003FEDA60001B181, 
0x0001D0BE8000E3A0, 0x003E09AA003FF1A5, 0x0001E484003E09AB, 0x003E09AE8000E3A4, 0x003E09AC003E09AF, 0x003CDDB3003E09AD, 0x0000E8868000E3A8, 0x8000E3AC0001CC87, 
0x003CF5B5003C95B6, 0x003CB9BB8000E3B0, 0x8000E3B4003CB1BA, 0x003F59BF8000E3B8, 0x003C95BD003F51BE, 0x003E51A8003C95BC, 0x003E6DAA003E51A9, 0x003E61AC003E61AB, 
0x000195AE003E61AD, 0x0001A08400018DAF, 0x8000E3C08000E3BC, 0x8000E3C88000E3C4, 0x8000E3D08000E3CC, 0x0001A9B88000E3D4, 0x000169BA0001A9B9, 0x000179BC000169BB, 
0x000169BE000179BD, 0x0001FDB0000169BF, 0x0001C5B20001CDB1, 0x0001B9B40001ADB3, 0x0001ADB60001B9B5, 0x003DE5B30001A5B7, 0x8000E3DC8000E3D8, 0x8000E3E48000E3E0, 
0x003DE9B5003DE1B6, 0x000209BB8000E3E8, 0x8000E3EC000239BA, 0x00027DBF8000E3F0, 0x000279BD00027DBE, 0x8000E3F4000211BC, 0x8000E3F8003DA1A3, 0x003DA5A68000E3FC, 
0x8000E4048000E400, 0x00027DAA003DADA5, 0x8000E40800024DAB, 0x000239AE8000E40C, 0x000255AC000239AF, 0x0000E98000023DAD, 0x00001D820000E981, 0x0002E4EF0003C0BE, 
0x000354878000E410, 0x000110E300043C86, 0x0001F8E18000E418, 0x8000E4208000E41C, 0x8000E4288000E424, 0x8000E4308000E42C, 0x8000E4388000E434, 0x8000E43C000391B3, 
0x00037DB60003B9B5, 0x8000E4448000E440, 0x000359BA8000E448, 0x000349BC000359BB, 0x0000FDBE000349BD, 0x000245A80000F5BF, 0x000255AA000255A9, 0x00027DAC000265AB, 
0x0002B1AE0002B1AD, 0x00056C840002B1AF, 0x8000E4508000E44C, 0x8000E4588000E454, 0x000570BE8000E45C, 0x00015DB88000E460, 0x000165BA00016DB9, 0x000119BC00010DBB, 
0x00010DBE000119BD, 0x0002D1B0000105BF, 0x0002D1B20002D1B1, 0x000175B40002D1B3, 0x000175B600017DB5, 0x003F40E100016DB7, 0x003E08E30000BCE3, 0x8000E464003E6CE1, 
0x8000E46C8000E468, 0x8000E4748000E470, 0x8000E47C8000E478, 0x00076CBE8000E480, 0x003E9CEF000054EF, 0x00029DA38000E488, 0x0000618100006982, 0x8000E48C00006980, 
0x0002B5A5000271A6, 0x000255AB8000E490, 0x0004C886000255AA, 0x0001F9AF0004EC87, 0x000245AD0001F1AE, 0x0006A5A8000245AC, 0x0006B9AA0006A9A9, 0x0006A9AC0006B9AB, 
0x0006D9AE0006A9AD, 0x8000E4840006D9AF, 0x8000E4988000E494, 0x8000E4A08000E49C, 0x8000E4A88000E4A4, 0x000771B88000E4AC, 0x000775BA000771B9, 0x0007C5BC0007DDBB, 
0x0007C5BE0007CDBD, 0x0006A9B00007FDBF, 0x0006B5B20006B5B1, 0x000695B400068DB3, 0x000751B6000751B5, 0x000631B3000751B7, 0x8000E4B48000E4B0, 0x8000E4BC8000E4B8, 
0x000621B5000629B6, 0x000671BB8000E4C0, 0x8000E4C400066DBA, 0x000795BF8000E4C8, 0x000659BD000651BE, 0x8000E4CC000661BC, 0x8000E4D0000675A3, 0x00066DA68000E4D4, 
0x8000E4DC8000E4D8, 0x000629AA000665A5, 0x8000E4E0000635AB, 0x000615AE8000E4E4, 0x000625AC0007D1AF, 0x00000D8000061DAD, 0x00001D8200001581, 0x8000E4EC8000E4E8, 
0x0001DC848000E4F0, 0x000080868000E4F4, 0x8000E4F800012087, 0x8000E5008000E4FC, 0x8000E5088000E504, 0x8000E5108000E50C, 0x8000E514000474E3, 0x8000E5180005C8E1, 
0x8000E5208000E51C, 0x8000E5288000E524, 0x8000E5308000E52C, 0x8000E5388000E534, 0x8000E53C0004B4EF, 0x00063DA88000E540, 0x000655AA000655A9, 0x0001B9AC0001A9AB, 
0x0001A9AE0001B9AD, 0x0001AC840001A9AF, 0x8000E5488000E544, 0x8000E5508000E54C, 0x8000E5588000E554, 0x00016DB88000E55C, 0x000101BA000105B9, 0x000105BC000101BB, 
0x000131BE00010DBD, 0x0001D9B0000131BF, 0x00016DB20001D9B1, 0x00017DB4000165B3, 0x000165B6000165B5, 0x0003BD81000155B7, 0x0005D5B30003BD80, 0x000239B500001982, 
0x000354BE8000E560, 0x8000E568000231B6, 0x000215BB8000E56C, 0x0002B9BD000215BA, 0x0002A9BF0002B1BC, 0x8000E5700002B1BE, 0x000261A5000269A6, 0x00058DA3000C0084, 
0x000CF8868000E574, 0x0002F1AF00037C87, 0x0002E1AD0002E9AE, 0x00024DAB0002E9AC, 0x8000E57800024DAA, 0x8000E5808000E57C, 0x8000E5888000E584, 0x000120E38000E58C, 
0x0001A0E18000E590, 0x000240EF8000E594, 0x8000E59C8000E598, 0x8000E5A48000E5A0, 0x8000E5AC8000E5A8, 0x0003F1B38000E5B0, 0x8000E4148000E5B4, 0x8000E5BC8000E5B8, 
0x0003E1B50003E9B6, 0x0003B5BB8000E5C0, 0x8000E5C40003B5BA, 0x000395BF8000E5C8, 0x0003A5BD000395BE, 0x000229A80003A5BC, 0x000239AA000229A9, 0x000229AC000239AB, 
0x000259AE000229AD, 0x0001CD80000255AF, 0x0000198200000981, 0x8000E5D08000E5CC, 0x000DB487000D7CBE, 0x000231B8000C1C86, 0x000235BA00023DB9, 0x0002F9BC0002E9BB, 
0x0002E9BE0002F9BD, 0x000231B00002E9BF, 0x000231B2000231B1, 0x000211B4000231B3, 0x000211B6000211B5, 0x8000E5D8000211B7, 0x8000E5E08000E5DC, 0x8000E5E88000E5E4, 
0x8000E5F08000E5EC, 0x8000E5F40006D4EF, 0x8000E5F8000654E1, 0x00150CAC0000A4E3, 0x8000E6008000E5FC, 0x0002F1A38000E604, 0x8000E60C8000E608, 0x8000E6148000E610, 
0x0002E1A50002E9A6, 0x0002B5AB8000E618, 0x8000E61C0002B5AA, 0x000295AF8000E620, 0x0002A5AD000295AE, 0x000E21A80002A5AC, 0x000E49AA000E21A9, 0x000E69AC000E59AB, 
0x000E99AE000E69AD, 0x8000E5D4000E99AF, 0x8000E6288000E624, 0x8000E6308000E62C, 0x8000E6388000E634, 0x000EF5B88000E63C, 0x000EF5BA000EFDB9, 0x000E9DBC000E89BB, 
0x000E85BE000E85BD, 0x000EE9B0000EB5BF, 0x000EFDB2000EE9B1, 0x000ED5B4000EF1B3, 0x000ED5B6000EDDB5, 0x000EC1B3000ECDB7, 0x0000B58100001582, 0x8000E6400000B580, 
0x000EE1B5000EE9B6, 0x000E2DBB000010BE, 0x00036484000E2DBA, 0x000E19BF8000E644, 0x000E25BD000E11BE, 0x8000E648000E29BC, 0x00008886000E85A3, 0x000EADA600036C87, 
0x8000E6508000E64C, 0x000E69AA000EA5A5, 0x8000E654000E69AB, 0x000E55AE8000E658, 0x000E6DAC000E5DAF, 0x000E89B3000E61AD, 0x8000E6608000E65C, 0x8000E6688000E664, 
0x000E89B5000E81B6, 0x000E95BB8000E66C, 0x8000E670000E8DBA, 0x000EF9BF8000E674, 0x000E85BD000EF1BE, 0x8000E678000E85BC, 0x8000E6808000E67C, 0x000D0CE38000E684, 
0x000D18E18000E688, 0x000CACEF8000E68C, 0x8000E6948000E690, 0x8000E69C8000E698, 0x8000E6A48000E6A0, 0x000E01A88000E6A8, 0x000E01AA000E01A9, 0x000E01AC000E01AB, 
0x000E01AE000E01AD, 0x0000DD80000E3DAF, 0x0000198200000981, 0x8000E6B08000E6AC, 0x000074BE00013C84, 0x000E1DB88000E6B8, 0x000E25BA000E2DB9, 0x0001F9BC0001E9BB, 
0x0001E9BE0001F9BD, 0x000E49B00001E9BF, 0x000E51B2000E51B1, 0x000E35B4000E51B3, 0x000E35B6000E3DB5, 0x000D89A3000E2DB7, 0x0004AC868000E6BC, 0x8000E6C000033C87, 
0x000D89A5000D81A6, 0x000D95AB8000E6C4, 0x8000E6C8000D8DAA, 0x000DF9AF8000E6CC, 0x000D85AD000DF1AE, 0x8000E6D0000D85AC, 0x0003488400029DB3, 0x000355B6000440BE, 
0x8000E6D88000E6D4, 0x000371BA0002B1B5, 0x8000E6DC000379BB, 0x000331BE8000E6E0, 0x000351BC000331BF, 0x000391B0000351BD, 0x0003A1B2000399B1, 0x0003D1B40003A1B3, 
0x0003D1B60003D1B5, 0x0003F5B80003D1B7, 0x0003CDBA0003F9B9, 0x0003DDBC0003C5BB, 0x0003CDBE0003C5BD, 0x8000E6E40003C5BF, 0x8000E6EC8000E6E8, 0x00197C858000E6F0, 
0x8000E6F88000E6F4, 0x000221A88000E564, 0x000231AA000231A9, 0x00021DAC000205AB, 0x0003F1AE0003F1AD, 0x8000E6FC0003F1AF, 0x8000E7048000E700, 0x000050EF8000E708, 
0x8000E7108000E70C, 0x000084E38000E714, 0x0001F8E18000E718, 0x000015808000E71C, 0x0000058200001981, 0x000399A38000E720, 0x000468868000E728, 0x8000E72C00056087, 
0x0003B5A5000251A6, 0x00027DAB8000E730, 0x8000E734000275AA, 0x000235AF8000E738, 0x000255AD000235AE, 0x8000E73C000255AC, 0x8000E7448000E740, 0x8000E74C8000E748, 
0x8000E7548000E750, 0x00046CBE0001F8EF, 0x8000E758000E80E1, 0x8000E75C000114E3, 0x8000E7648000E760, 0x8000E76C8000E768, 0x8000E7748000E770, 0x8000E7780001DDB3, 
0x0001F5B60001FDB5, 0x8000E7808000E77C, 0x0001B1BA8000E784, 0x00019DBC000185BB, 0x00013DBE000135BD, 0x000605A9000135BF, 0x000615AB0005B9A8, 0x00063DAD00061DAA, 
0x00064DAF00063DAC, 0x8000E72400065DAE, 0x00001D8100001D82, 0x8000E78800001D80, 0x8000E7908000E78C, 0x000741B98000E794, 0x000741BB00069DB8, 0x000745BD000749BA, 
0x000745BF000759BC, 0x000609B1000745BE, 0x0006A9B300063DB0, 0x0006B9B5000601B2, 0x0006ADB70006B1B4, 0x000691A30006B1B6, 0x0000288600028C84, 0x8000E7980003C087, 
0x0006B1A50006B9A6, 0x0006C9AB8000E79C, 0x8000E7A00006FDAA, 0x000679AF8000E7A4, 0x000679AD000671AE, 0x8000E7A80006D1AC, 0x8000E7AC000799B3, 0x000751B68000E7B0, 
0x8000E7B88000E7B4, 0x00076DBA0007B1B5, 0x8000E7BC000775BB, 0x000759BE8000E7C0, 0x00076DBC000745BF, 0x8000E7C4000765BD, 0x8000E7CC8000E7C8, 0x8000E7D48000E7D0, 
0x8000E7DC8000E7D8, 0x8000E7E00005A8EF, 0x8000E7E4000534E1, 0x8000E7E8000574E3, 0x8000E7F08000E7EC, 0x00061DA38000E7F4, 0x0000158100002D82, 0x8000E7F800001D80, 
0x000635A50006D5A6, 0x0006F1AB8000E7FC, 0x8000E8000006E9AA, 0x0006C1AF00012884, 0x0006E1AD0006DDAE, 0x0006C5A80006E9AC, 0x0006D5AA0006D5A9, 0x0006FDAC0006E5AB, 
0x00061DAE000615AD, 0x0001ECBE000615AF, 0x000008868000E808, 0x8000E80C00002087, 0x8000E8148000E810, 0x00067DB88000E818, 0x00060DBA000605B9, 0x000601BC000605BB, 
0x000639BE000609BD, 0x00066DB0000639BF, 0x00067DB2000675B1, 0x000659B4000675B3, 0x00064DB6000645B5, 0x000291A8000645B7, 0x0002A1AA000299A9, 0x0002D1AC0002A1AB, 
0x0002D5AE0002DDAD, 0x8000E81C0002C9AF, 0x8000E8248000E820, 0x8000E828001E2CBF, 0x8000E8308000E82C, 0x000355B88000E834, 0x000369BA00035DB9, 0x000361BC000365BB, 
0x000361BE000361BD, 0x0002B9B0000361BF, 0x000285B200028DB1, 0x000375B400036DB3, 0x000375B600037DB5, 0x8000E83800036DB7, 0x000221B38000E83C, 0x000251B58000E840, 
0x8000E84400038884, 0x8000E6B4000255B6, 0x000241BB001C28BE, 0x0003B1BD000275BA, 0x0003B1BF000259BC, 0x000269A30003B9BE, 0x8000E84C8000E848, 0x8000E8548000E850, 
0x000219A500021DA6, 0x000209AB8000E858, 0x8000E85C00023DAA, 0x0003F9AF8000E860, 0x0003F9AD0003F1AE, 0x0002A5A8000211AC, 0x0002BDAA0002B5A9, 0x0002ADAC0002B5AB, 
0x00013DAE000135AD, 0x001C2CBE000135AF, 0x8000E8688000E864, 0x8000E8708000E86C, 0x001D68878000E878, 0x000185B8001D1C86, 0x000185BA00018DB9, 0x00018DBC00019DBB, 
0x0001B5BE0001BDBD, 0x000151B0000079BF, 0x000151B2000151B1, 0x0001F1B4000151B3, 0x0001F5B60001F1B5, 0x0000D8EF0001E5B7, 0x0000A5810000B582, 0x8000E87C0000A580, 
0x8000E8848000E880, 0x8000E8880006C4EF, 0x8000E88C0006F4E1, 0x0000CCE3000138E3, 0x000128E18000E890, 0x8000E8988000E894, 0x000275B50001E5B6, 0x000265B3001C4084, 
0x8000E8A08000E89C, 0x000165BF8000E8A4, 0x0001D5BD000165BE, 0x0001C5BB0001D5BC, 0x8000E8A80001C5BA, 0x001DB5A38000E8AC, 0x8000E8B08000E874, 0x8000E8B88000E8B4, 
0x001DA5A5001E35A6, 0x001E15AB8000E8BC, 0x8000E8C0001E15AA, 0x001EB5AF8000E8C4, 0x001E05AD001EB5AE, 0x8000E8C8001E05AC, 0x8000E8D08000E8CC, 0x00000D808000E8D4, 
0x00003D8200003581, 0x8000E8DC8000E8D8, 0x000005B58000E8E0, 0x0002B4E180001A71, 0x000005B50002D8AC, 0x001FB5A880001A75, 0x001F1DAA001F15A9, 0x001F31AC001F15AB, 
0x001F2DAE001F3DAD, 0x0002B4E1001F21AF, 0x000005B50002D8AC, 0x0002B4E180001A79, 0x000005B50002D8AC, 0x0000D1B880001A7D, 0x0000E1BA0000D9B9, 0x000091BC0000E1BB, 
0x000091BE000091BD, 0x001F21B0000091BF, 0x001F31B2001F31B1, 0x001F09B4001F31B3, 0x0000F1B6001F09B5, 0x0002B4E10000F1B7, 0x001D54EF0002DCAC, 0x80001A8100001DB5, 
0x0002D0AC0002BCE1, 0x000125A3000029B5, 0x001D15A1000391A2, 0x001E80E1001D0DA0, 0x001DBCE380001A85, 0x001ED5B30002C4E1, 0x0002D8AC000009B5, 0x0002BCE180001A89, 
0x001EF9B5001EFDB6, 0x001EB5BB0002E0AC, 0x000005B5001EA5BA, 0x001E8DBF80001A8D, 0x001EA5BD001E8DBE, 0x001E15A3001EA5BC, 0x0002D0AC0002BCE1, 0x0025698F000011B5, 
0x001E39A5001E3DA6, 0x001E75AB80001A91, 0x0002B4E1001E65AA, 0x001E4DAF000178AC, 0x001E65AD001E4DAE, 0x0014DD9B001E65AC, 0x001701990015E59A, 0x001F719F0010E198, 
0x0019F99D0019799E, 0x002DE593001B019C, 0x00296D91002F1192, 0x0011F99700296D90, 0x002C85950011F196, 0x000025B5002D9994, 0x0026F182000294E1, 0x002A9584002A8D83, 
0x002E1D86002CE185, 0x0002B4AC002E7987, 0x002F558A80001A95, 0x0012398C0012298B, 0x0014F18E0013198D, 0x000005B500161D8F, 0x0017559280001A99, 0x001A719400189193, 
0x001CF996001AF995, 0x0003E082001E7D97, 0x001E559A80000B93, 0x0002759C0000D99B, 0x80000CB380000C83, 0x000401AC000A89B8, 0x000681AE000685AD, 0x00037CCC000210CC, 
0x80001A9D80000CB6, 0x80000CC580000CC2, 0x80000B0080000CC8, 0x80000CBC0232A581, 0x0006959A8000E804, 0x000691BC0223559B, 0x000691BE0000B1BD, 0x0006E9B80006ADBF, 
0x000691BA000695B9, 0x0006C1B480001AA1, 0x0006CDB60006CDB5, 0x0006FDB00006DDB7, 0x00009DB20006E5B1, 0x03C754850006E5B3, 0x0000FC8780001AA5, 0x80001AAD000A01B8, 
0x80001AB180000CE9, 0x0001A48D0073918C, 0x80000DBE0002F0CC, 0x0000148980000DC1, 0x00000C8B000A19B8, 0x80000E5380000E1A, 0x80000CBF80000CB9, 0x0001C09180000A19, 
0x000A6DB880000CCB, 0x80000CD480000CCE, 0x80000CDD80000CDA, 0x80001AB580000CE0, 0x80000CE680000D28, 0x001EA4E180001AB9, 0x001E54E380000D2B, 0x000228CC007321AF, 
0x80000CEC80000CEF, 0x80000CF580000CF2, 0x000280CC80000CF8, 0x80000CFB0003B894, 0x001E60EF00021492, 0x80000CFE00020090, 0x000AF1B880000D0A, 0x80000B9F80000D0D, 
0x000B298980000D10, 0x80001AA980000D13, 0x0001C4BF000130BC, 0x80000D160001ECBE, 0x000AC5B80002ECCC, 0x800009AD000144BA, 0x800006CA80000D19, 0x800006F2800006DF, 
0x800006FA80000D1C, 0x8000070A80000D1F, 0x800007188000072D, 0x8000072F800007F6, 0x8000073A80000DA9, 0x8000074A80000DAF, 0x80000767000079B5, 0x80000772022A71B7, 
0x80000774000061B1, 0x8000078D02290DB3, 0x800007A00000E9BD, 0x800007AD800007FA, 0x800007C3022B19B9, 0x8000081F021459BB, 0x8000083C8000095A, 0x8000085B80000E2F, 
0x8000088180000039, 0x800008C780000071, 0x800009208000002B, 0x8000095C8000003D, 0x8000095E80000043, 0x8000086A80000845, 0x8000080080000049, 0x8000097980000053, 
0x80000D2280000059, 0x02220DBB8000005F, 0x023614CC80000DD0, 0x000065BF8000001F, 0x00006DBD000011BE, 0x00016980800007E5, 0x0001718200017581, 0x000769840221DD83, 
0x0007818600078185, 0x0001A18800017187, 0x0007B58A0001AD89, 0x0007958C00078D8B, 0x8000004F0001A58D, 0x0001E1900001A58F, 0x0221B1920007ED91, 0x00078D940007FD93, 
0x0001F19600065195, 0x0001D1980001D997, 0x00067D9A00067599, 0x0006699C0001D59B, 0x0006519E0214999D, 0x021475A00006519F, 0x000149A20006B9A1, 0x000121A4022D85A3, 
0x021475A600012DA5, 0x0211A1A80006B5A7, 0x000695AA021451A9, 0x0235BCCC800021B1, 0x8000006D02353CCD, 0x800003AC800003AA, 0x800021BD800003AF, 0x800021DB800021C4, 
0x800000C9800021E2, 0x0006A1B88000000F, 0x800006B7800006BA, 0x800021CE800000CC, 0x800005DD800003B5, 0x000205BA80000618, 0x0005E9B80002D5BB, 0x0002C9BE0005FDB9, 
0x00020DBC0217E5BF, 0x0005E1B2000201BD, 0x00058DB00005E1B3, 0x0005E5B600059DB1, 0x0005F5B40005E9B7, 0x00053DAA0005EDB5, 0x00053DA80005C1AB, 0x0005CDAE000535A9, 
0x0005CDAC0005F5AF, 0x00053DA20005C5AD, 0x0002D5A0000505A3, 0x00051DA6000539A1, 0x00051DA4000505A7, 0x800006BF000515A5, 0x8000063E0005C19B, 0x0005DD9E80000655, 
0x0002519C0004319F, 0x800006720005D59D, 0x800003A480000689, 0x800000DB80002230, 0x8000078F800003A0, 0x800007F2800007EE, 0x8000080280000990, 0x80000B9680000806, 
0x80000AAF80000994, 0x8000078B8000076F, 0x800007A280000797, 0x800009AA800007AA, 0x80000F1280000EFB, 0x023304CC80000F1F, 0x023320CC0230B0CD, 0x023010CC0230E0CD, 
0x023058CC023068CC, 0x023168CC02308CCD, 0x0231D4CC023114CD, 0x022070CC023614CD, 0x023630CC0227D0CD, 0x023C0CCC023124CC, 0x023F18CC023F68CD, 0x023D18CC023F34CD, 
0x023C44CC0232C0CD, 0x023238CC023918CC, 0x023288CC0232A8CD, 0x02337CCC0233F8CD, 0x023328CC023340CD, 0x0221C8CC023308CD, 0x0226ACCC022624CD, 0x022598CC023840CC, 
0x02241CCC023AC8CD, 0x023B84CC022410CD, 0x0225ACCC023BA8CD, 0x0238ACCC023ABCCD, 0x0238E0CC0227F8CC, 0x80000F27023874CD, 0x80000D61800006F6, 0x022A20CD80000D88, 
0x800006AA022B1CCC, 0x0220A4CC8000222C, 0x022638CC0227A0CD, 0x023A38CC800004CA, 0x023910CC023B3CCD, 0x0003A0CC023E60CD, 0x022CEDBD000D3DBE, 0x022355BB800004D6, 
0x02223DB980000904, 0x800007D9800006CF, 0x80000DA0800004A5, 0x8000056F800004B2, 0x800004BE800006F4, 0x000CBDAF80000575, 0x000CA5AD022E99AE, 0x0222C5AB800005C2, 
0x800004C480000603, 0x800004D080000623, 0x80000629800005C8, 0x021801A38000065D, 0x8000071A800004A0, 0x000C5D9F8000071D, 0x000C459D000C519E, 0x0221599B80000727, 
0x800007B1800007AF, 0x800007B8800007B4, 0x800007CE8000072A, 0x02262D93800007D0, 0x8000086C800007D3, 0x000C058F8000086F, 0x000C658D000C718E, 0x0220458B80000879, 
0x022F358980000960, 0x8000096780000963, 0x800009708000087C, 0x800003BD80000973, 0x000C5D8180002200, 0x00010080000C6180, 0x0004008200001881, 0x0007108480002204, 
0x0008E48600061485, 0x00052C8800023C87, 0x0078008A0005A489, 0x0000248C80002208, 0x800022148000220C, 0x000011B880002210, 0x007A4892007BC491, 0x8000221C00794C93, 
0x0009F0960002E8CC, 0x0009C090000039B8, 0x0009F09280002224, 0x0009B4940002F8CC, 0x8000222800000DB8, 0x000005B800021CCC, 0x0002E4CC80002234, 0x8000223800001DB8, 
0x800022438000223C, 0x00088CA88000225A, 0x80002261007BE4A9, 0x0002E4CC0006D4AB, 0x8000226B00000DB8, 0x8000226F000294CC, 0x000009B8007B80B1, 0x0002FCCC000015B8, 
0x800022730008E4B5, 0x800022770002D8CC, 0x00059CBA000005B8, 0x007C00BC00055CBB, 0x007DF8BE007FF4BD, 0x023A09800072FCBF, 0x023A0182023A0D81, 0x023A1984023A0583, 
0x023A1186023A1D85, 0x023A2988023A1587, 0x023A218A023A2D89, 0x023A398C023A258B, 0x023A318E023A3D8D, 0x0002F0CC023A358F, 0x80002283000FE991, 0x000019B80002CCCC, 
0x0002DCCC8000227F, 0x000035B8000FE597, 0x8000228F00000DB8, 0x000005B80002FCCC, 0x000230CC80002293, 0x0002D0CC80002297, 0x8000229F8000229B, 0x000F2DA4000288CC, 
0x000F5DA6000F55A5, 0x023AA9A8000294CC, 0x0000D5B8023AADA9, 0x000035B8800022A3, 0x000350CC800022A7, 0x00032CCC023AB5AF, 0x000318CC800022AB, 0x000F1DB4000F05B3, 
0x000F09B6800022CF, 0x007D68BE000F09B7, 0x000045B800006DB8, 0x000F29BC000338CC, 0x000F25BE800022D3, 0x000EE587000358CC, 0x0001BDB8023AE8CC, 0x0235F0CC0001C9B8, 
0x022280CC0233A4CD, 0x023694CD02257CCD, 0x023BECCD022904CC, 0x0001E5B8023A64CC, 0x000ED5890001C1B8, 0x000EB197000ED588, 0x800022AF00000DB8, 0x800022B7800022B3, 
0x800022BB000019B8, 0x023B699F800022D7, 0x800022BF800022DB, 0x0002C4CC00003DB8, 0x800022C30002F8CC, 0x0000D9B8800022C7, 0x800022DF800022CB, 0x800022E30000D1B8, 
0x0233CCCC0000F1B8, 0x0000C9B8800022E7, 0x800022EB0233E8CC, 0x000065A90000D5B8, 0x0002D8CC0000C9B8, 0x000D4DB70006B9AA, 0x000E35B5000D4DB6, 0x000055B8000E35B4, 
0x000F19B180002315, 0x0003F5BF000E29B0, 0x000D59BD000D51BE, 0x000D5DBB000C35BC, 0x000D5DB9000D5DBA, 0x000ABD80000D5DB8, 0x00041582000AC581, 0x00057CCC000AC983, 
0x000AD586000ADD85, 0x000554CC000ACD87, 0x0008B98A000AF189, 0x0008118C00080D8B, 0x0227B58E0008158D, 0x00086990000AE58F, 0x0008719200086D91, 0x000510CC02246D93, 
0x000A859600081D95, 0x000534CC000510CC, 0x000A899A00083D99, 0x0008119C00080D9B, 0x000548CC0008159D, 0x000A65A0000210CC, 0x000A65A2000A6DA1, 0x0004B1A4000705B8, 
0x0004B1A60002E8CC, 0x000481A800070DB8, 0x000899AA0002FCCC, 0x0008B9AC000A5DAB, 0x000725B80004A9AD, 0x0008D1B0000835AF, 0x0002C0CC0004F1B1, 0x022829B400088DB3, 
0x000A21B6000A21B5, 0x000B21B8000A21B7, 0x000741B8000825B9, 0x021D0DBC000B29BB, 0x000B31BE000FDDBD, 0x000ADD80000B31BF, 0x007DA19C80002319, 0x800003E9800003D0, 
0x0009998600091985, 0x0009E18800099587, 0x8000040202252589, 0x8000042E8000041B, 0x8000045480000441, 0x000AAD9080000467, 0x00056D9200054991, 0x0005619400056193, 
0x0005659600056D95, 0x0005359800051197, 0x0005359A00053D99, 0x0005159C00050D9B, 0x0005159E00051D9D, 0x0009A9A00005099F, 0x0005F5A20005FDA1, 0x000505A4000501A3, 
0x000505A600050DA5, 0x000505A800053DA7, 0x000505AA00050DA9, 0x000989AC000519AB, 0x0009B5AE0005A9AD, 0x000901B00009FDAF, 0x000575B200057DB1, 0x000969B4000501B3, 
0x000505B6000501B5, 0x000505B800053DB7, 0x000501BA0225E1B9, 0x0225D1BC000501BB, 0x000979BE00093DBD, 0x0005308300095DBF, 0x007EB19F000778A1, 0x000778A48000047A, 
0x8000048D000748A5, 0x00047C8B800004F3, 0x80000113800000DD, 0x8000011C00044888, 0x8000012480000120, 0x8000012C80000128, 0x000700B280000130, 0x800001340007FCB3, 
0x0007E4B6800000E1, 0x800000E60007F0B7, 0x0007E0BA800000EB, 0x000788BC00079CBB, 0x800000F00007A8BD, 0x0004CCA3007EC1B3, 0x800000FA800000F5, 0x800000FF00040083, 
0x000420A500047485, 0x00044C8880000104, 0x8000010E80000109, 0x00072DAF80000117, 0x000721AD0007C48D, 0x800003CD000729AC, 0x8000058F800004F0, 0x800005E2000765B0, 
0x800006438000061D, 0x800006778000065A, 0x800003D38000068E, 0x80000405800003EC, 0x800004318000041E, 0x022BDD8200047CBC, 0x000AFD80022BE583, 0x00099986022BF981, 
0x000AE18400099987, 0x0009898A000AE185, 0x000989880009898B, 0x0009858E00098989, 0x0008E18C80000444, 0x022BB99200098D8D, 0x022B999002274193, 0x000BC996000BC591, 
0x000DC59402277597, 0x000BC99A0224D195, 0x000BC998022AD99B, 0x8000045700077999, 0x000BFD9C8000046A, 0x800004908000047D, 0x800001A0800004F6, 0x800001A8800001A4, 
0x800001AC000264E3, 0x800001B4800001B0, 0x000911A80007BCEF, 0x800001BC800001B8, 0x800001C4800001C0, 0x800001CC800001C8, 0x800001D4800001D0, 0x800001DC800001D8, 
0x800001E4800001E0, 0x800001EC800001E8, 0x800001F4800001F0, 0x800001FC800001F8, 0x007E9C8280000200, 0x0254F5A080000204, 0x0254E9A20254D9A1, 0x0075EDA40075F5A3, 
0x007695A600769DA5, 0x007685A80076BDA7, 0x007D39AA007D29A9, 0x007D1DAC007D05AB, 0x007D0DAE007D05AD, 0x007D7DB0007D05AF, 0x007E51B2007E49B1, 0x007E75B4007E51B3, 
0x007E69B6007E7DB5, 0x007E59B8007E69B7, 0x007E29BA007E59B9, 0x007E21BC007E29BB, 0x007E19BE007E21BD, 0x80000792007E19BF, 0x800007D780000939, 0x00000DB48000224D, 
0x00003DB6000035B5, 0x800006AC800006A2, 0x80002303800006AF, 0x007825BD80002309, 0x800031C60258B5BC, 0x80002A9980003A2E, 0x80002AC980002ABD, 0x80002AE180002AD9, 
0x80002AF580002AED, 0x80002B0980002AFD, 0x80002B7580002B5D, 0x80002B9580002B85, 0x80002BB580002BA5, 0x007F798080002BD5, 0x007F8182007F8181, 0x007F8D84007F9D83, 
0x007FB186007FB185, 0x007FE188007FB187, 0x007FE18A007FE189, 0x007FE58C007FFD8B, 0x007FE58E007FED8D, 0x007FA590007FDD8F, 0x007FA592007FAD91, 0x007FA594007FBD93, 
0x007E6D96007FAD95, 0x007E1598007E2D97, 0x007EE99A007E1999, 0x007EF99C007EE99B, 0x007EE99E007EF99D, 0x007E1DA0007EE59F, 0x007E25A2007E25A1, 0x007E25A4007E3DA3, 
0x007E25A6007E2DA5, 0x007E65A8007E5DA7, 0x007E65AA007E6DA9, 0x007E65AC007E7DAB, 0x007E65AE007E6DAD, 0x007E25B0007E5DAF, 0x007E25B2007E2DB1, 0x007E25B4007E3DB3, 
0x007759B6007E29B5, 0x0079FDB80075D5B7, 0x0075F9BA0075E9B9, 0x0075E9BC0079D9BB, 0x0075D1BE0075D5BD, 0x007631800075D9BF, 0x0076498200763D81, 0x0076418400764583, 
0x0074F98600764D85, 0x0002A18800767D87, 0x0076598A00764D89, 0x0076498C007AB98B, 0x0002B18E007A9D8D, 0x02569190007A1D8F, 0x0076819200762991, 0x0076D9940076CD93, 
0x0076C9960076E995, 0x0076A1980259D197, 0x0076F19A025A6599, 0x0076D19C025A4D9B, 0x0256819E007A619D, 0x000205A00076D59F, 0x025735A2025A8DA1, 0x007621A4007609A3, 
0x025A89A600762DA5, 0x025AB9A8025A99A7, 0x00775DAA007675A9, 0x80002BDD80002BD9, 0x80002C3980002C11, 0x80002C5180002C49, 0x80002C6180002C55, 0x80002C8180002C7D, 
0x80002C9D80002C99, 0x80002CB580002CA5, 0x80002D6580002D51, 0x80002DB980002DA5, 0x80002DC580002DC1, 0x000A759980002DD5, 0x80002E2480002DF8, 0x80002E5080002E30, 
0x80002E6080002E5C, 0x007AEC8280002E64, 0x80002E7C007B6483, 0x007B748680002E80, 0x80002EAC007BBC87, 0x80002EC080002EB8, 0x80002ED880002EC8, 0x80002EEF80002EE7, 
0x80002F1F80002F1B, 0x007C709280002F27, 0x80002F3380002F2B, 0x80002F3B007C4C91, 0x80002F6780002F4B, 0x80002FF380002FDF, 0x007CE4A8007CCCAB, 0x80002FF7007CDCA9, 
0x8000307B80003077, 0x007CC0A28000308F, 0x8000309B80003093, 0x024940CC800030A3, 0x024AFCCC024900CD, 0x800030AB024B68CD, 0x800030ED800030B7, 0x80003111800030FD, 
0x8000319A8000318E, 0x007CACB2800031AA, 0x800031B6007C40B3, 0x800031CA800031C2, 0x007C6CB4800031CE, 0x00079580007C04B5, 0x0007958200079D81, 0x0007B9840007A983, 
0x0007D9860007B985, 0x0007E9880007D987, 0x0007F98A0007E989, 0x0007E98C0007F98B, 0x0007D18E0007E98D, 0x0007B1900007D18F, 0x000149920007B191, 0x0001599400014993, 
0x0001499600015995, 0x0001799800014997, 0x0001499A00017999, 0x0001599C0001499B, 0x0001499E0001599D, 0x0001B9A00001499F, 0x0001C9A20001B9A1, 0x0001D9A40001C9A3, 
0x0001C9A60001D9A5, 0x0001F9A80001C9A7, 0x0001C9AA0001F9A9, 0x0001D9AC0001C9AB, 0x0001C9AE0001D9AD, 0x0001B9B00001C9AF, 0x000149B20001B9B1, 0x000159B4000149B3, 
0x000149B6000159B5, 0x000179B8000149B7, 0x000149BA000179B9, 0x000159BC000149BB, 0x000149BE000159BD, 0x800031D2000149BF, 0x800031DA800031D6, 0x800032DA80003292, 
0x800032EA800032E6, 0x800032F2800032EE, 0x800032FE800032FA, 0x8000332E80003312, 0x8000337680003336, 0x800033828000337A, 0x8000338E80003386, 0x800033B680003392, 
0x800033D6800033BA, 0x800033DE800033DA, 0x800033F6800033E2, 0x8000341E8000341A, 0x8000344680003422, 0x8000348A80003486, 0x800034BA800034AA, 0x800034E2800034C2, 
0x8000354A80003506, 0x8000356680003552, 0x8000357A80003572, 0x8000358680003582, 0x800035A28000358A, 0x800035C2800035A6, 0x800035D2800035CA, 0x800035E2800035D6, 
0x800035EE800035EA, 0x800035FA800035F2, 0x8000369E800035FE, 0x000C859E800036B2, 0x800036EA800036E6, 0x0003B980800036F2, 0x0003C9820003B981, 0x0003D9840003C983, 
0x0003C9860003D985, 0x0003F9880003C987, 0x0003C98A0003F989, 0x0003D98C0003C98B, 0x0003CD8E0003D98D, 0x0003BD900003C58F, 0x000E4992000C0191, 0x000E5994000E4993, 
0x000E4996000E5995, 0x000E7998000E4997, 0x000E499A000E7999, 0x000E599C000E499B, 0x000E499E000E599D, 0x000EB9A0000E499F, 0x000EC9A2000EB9A1, 0x000ED9A4000EC9A3, 
0x000EC9A6000ED9A5, 0x000EF9A8000EC9A7, 0x000EC9AA000EF9A9, 0x000ED9AC000EC9AB, 0x000EC9AE000ED9AD, 0x000EB9B0000EC9AF, 0x000E49B2000EB9B1, 0x000E59B4000E49B3, 
0x000E49B6000E59B5, 0x000E79B8000E49B7, 0x000E49BA000E79B9, 0x000E59BC000E49BB, 0x000E49BE000E59BD, 0x000479BC000E49BF, 0x000489BE000479BD, 0x000475B800049DBF, 
0x000469BA00047DB9, 0x000471B4000469BB, 0x000471B6000471B5, 0x000471B0000471B7, 0x000471B2000471B1, 0x000469AC000471B3, 0x000471AE000469AD, 0x000441A8000471AF, 
0x000441AA000441A9, 0x00059DA4000441AB, 0x000461A6000461A5, 0x00059DA0000461A7, 0x00058DA2000585A1, 0x00055D9C000585A3, 0x00056D9E0005659D, 0x00055D980005659F, 
0x00054D9A00054599, 0x00051D940005459B, 0x00056D9600056595, 0x00051D9000056597, 0x00050D9200050591, 0x0007318C00050593, 0x0007318E0007318D, 0x000731880007318F, 
0x0007318A00073189, 0x000731840007318B, 0x0007318600073185, 0x0007318000073187, 0x0007318200073181, 0x8000372600073183, 0x800037368000372E, 0x8000377680003772, 
0x800037828000377E, 0x800037B280003786, 0x800037BE800037B6, 0x800037D6800037D2, 0x800037FA800037F2, 0x80003822800037FE, 0x8000385280003842, 0x8000385E80003856, 
0x8000388E8000388A, 0x800038C28000389E, 0x800038DE800038CE, 0x800038FE800038F6, 0x8000390680003902, 0x800039168000390A, 0x800039228000391A, 0x800039428000393E, 
0x8000395E80003946, 0x8000396A80003962, 0x800039828000397E, 0x8000398E80003986, 0x8000399680003992, 0x8000399E8000399A, 0x800039C6800039AE, 0x800039D6800039CA, 
0x800039DE800039DA, 0x800039EA800039E2, 0x800039F2800039EE, 0x80003A06800039FE, 0x80003A1280003A0E, 0x0001B98080003A1A, 0x0001C9820001B981, 0x0001D9840001C983, 
0x0001C9860001D985, 0x0001F9880001C987, 0x0001C98A0001F989, 0x0001D98C0001C98B, 0x0001C98E0001D98D, 0x0001B9900001C98F, 0x000011920001B991, 0x0000319400001193, 
0x80003A1E00003195, 0x80003A2A80003A22, 0x8000233D80003A32, 0x80002C6980002C65, 0x0002608280002425, 0x000080800000E199, 0x0006E48200009881, 0x001BD48400048883, 
0x001F1886001A9485, 0x001EC488800023B3, 0x0013A88A00100089, 0x0028008C0011AC8B, 0x002AB88E002BB48D, 0x0002B0E30029BC8F, 0x0000559E000274BE, 0x00026C82000214E3, 
0x00000D99800023B7, 0x0000359E000244BE, 0x0000059900026882, 0x0002CCEF800023BB, 0x000084820000A0BE, 0x0001ECE30002D8EF, 0x800023BF0001F4E3, 0x800023C3000308E3, 
0x800023C7000338E3, 0x800023CB000388E3, 0x800023CF0003E0EF, 0x00013CEF000388EF, 0x800023D30003C4EF, 0x0003ECE30003D4EF, 0x800023D78000371E, 0x0003ECE30003ECE3, 
0x800023DB0003E4E3, 0x00035CEF0003B8E3, 0x800023DF00034CEF, 0x0003F4EF000348EF, 0x800023E7800023E3, 0x00037CE3000334EF, 0x800023EB000494E3, 0x800023F3800023EF, 
0x800023F70004B4E3, 0x800023FF800023FB, 0x8000240300046CEF, 0x000458EF80002407, 0x8000240B000450EF, 0x8000241A80002416, 0x0004F8E3800000BD, 0x80002431800000C2, 
0x8000296D8000241E, 0x8000250800049CE3, 0x800025AE8000256B, 0x800025DA000450EF, 0x00043CEF80002604, 0x024B098080002629, 0x000244BE00771C86, 0x000250BE00027482, 
0x000111998000263E, 0x0002AC8F00010D99, 0x0001688D00020482, 0x00017C8B0002C19E, 0x0001299E00013D9E, 0x0002D097000208BE, 0x0002D09500015D99, 0x0002D0930001559E, 
0x0002D09100017599, 0x0002B89F000248BE, 0x0002B49D80002646, 0x0002B09B00014D9E, 0x0002B49900015D99, 0x0001A99E000284BE, 0x8000266200028CA6, 0x0001A999000280A4, 
0x000248A18000266A, 0x0002E4AF0002AC82, 0x00025C820002B482, 0x000208BE0001E599, 0x0004008200027C82, 0x0001F99E0002A4A8, 0x00041CB5000270BE, 0x0005A8BE0001859E, 
0x0002B1B6000284B2, 0x000929B80005ACBE, 0x000299BA000289B9, 0x0004E8BB00058C82, 0x8000267200059C82, 0x0006599E0004F0B8, 0x0006619E00066D99, 0x00027CBE00067999, 
0x00025C820006619E, 0x00065999000240BE, 0x0002608200065D9E, 0x00027CBE0006A599, 0x00021C820006BD9E, 0x0006CD99000214BE, 0x00024C8200024CBE, 0x0006DD9E0006DD9A, 
0x00020CE30006C59F, 0x0006F9990002BC82, 0x0002F4EF000264BE, 0x0006E99E0006F19A, 0x0006D99E0006E99F, 0x000204E30006D59F, 0x0006219A00062599, 0x00063D9900027882, 
0x00024482000204E3, 0x000270BE0006259A, 0x0006059E00029CEF, 0x0002E8EF0006159F, 0x000605990006759A, 0x000270BE00020482, 0x0006759E000270E3, 0x0006019E00060D9F, 
0x000234E300027CBE, 0x000260BE00060D99, 0x0002F0EF00026C82, 0x0003908200063599, 0x0006219E0002D8EF, 0x0007C59B80002684, 0x00027CBE0007E599, 0x0007C59F0007ED9E, 
0x0002509D0003ECE3, 0x00026C820007D19C, 0x0007CD990002D4EF, 0x000270BE00027C82, 0x0007DD9E0007DD99, 0x000268E3000200BE, 0x0007B9990007AD9E, 0x00027C82000268E3, 
0x000248BE00020CE3, 0x000258820007A999, 0x0007999E0002C4EF, 0x0002B8EF00026CBE, 0x00078D9E00029482, 0x000000BB0002B8EF, 0x00000CB900077999, 0x000000BF0007719E, 
0x000004BD00025482, 0x0003D4B3000268BE, 0x000370B10006B199, 0x000038B700020482, 0x000034B50006A19E, 0x000358AB000270BE, 0x00025CEF0006A19E, 0x000310AF0006A999, 
0x000314AD00025082, 0x0006699900078599, 0x0006619E000258BE, 0x0002688200027CBE, 0x000290E30002A0A6, 0x00017CE300066999, 0x0001ACE3000198E3, 0x0001E8E30001D0E3, 
0x00058D9E000274BE, 0x0002CCEF000230E3, 0x0005D19900026882, 0x000154EF000294EF, 0x000124EF000170EF, 0x00027CBE000128EF, 0x00020CE30005BD9E, 0x0002AD9900027882, 
0x0002A59E000274BE, 0x00026082000234E3, 0x000260BE00001999, 0x00000D9E0002FCEF, 0x0002D4EF00029482, 0x0002FCE380002690, 0x000260BE00000999, 0x00001D9E80002698, 
0x002A25B0000200E3, 0x00000D9900025882, 0x000264BE0002F4EF, 0x0002C0EF800026AE, 0x000218820000199E, 0x000270E300023882, 0x0000359A00001199, 0x000274BE00012999, 
0x0000259F800026EC, 0x0001E9990000099E, 0x0003E0BE0003B4BE, 0x0002D8EF0001CD9A, 0x0003D8820001119E, 0x0002C481800026FD, 0x8000271F0003B0E3, 0x0002FCBE0003FCE3, 
0x000228820002C484, 0x8000272A00021086, 0x0000219E00023C88, 0x8000277A00000D9F, 0x0002748F000328EF, 0x0002888200032CEF, 0x0000159A00007599, 0x0003D0950003C492, 
0x0000D19A00002D99, 0x0002C8BE8000278E, 0x00037C9B00036898, 0x0000419E0003C482, 0x800027B00000299F, 0x000290E300028482, 0x800027BE000308BE, 0x0000199F80002806, 
0x0002D0E30000ED9E, 0x0000159A00007199, 0x000230EF000214BE, 0x000258EF00002199, 0x0003ECAF80002814, 0x001C4CB100020482, 0x0000259E001C00B0, 0x00005D9E001C4CB2, 
0x0002BCE30000619F, 0x000000F900002199, 0x000294EF80002971, 0x001C3CBD80002975, 0x001FC1BF001D8082, 0x001DB4E380002979, 0x001FF59E000274BE, 0x00000599001DF0E3, 
0x00027CBE8000297D, 0x000260820000099E, 0x8000298900000D99, 0x0002CCEF000260BE, 0x800025E900001D9E, 0x000268E30002DCEF, 0x001D3CE3800018F9, 0x800018FD80001A21, 
0x80001A2580001901, 0x80001A2D80001A29, 0x80001A3580001A31, 0x0002A4EF80001A39, 0x001D24EF80001A3D, 0x0000C5B180001A41, 0x0000C5B380001905, 0x0000C9B50000DDB2, 
0x00001DB70000C1B4, 0x000065B90000C1B6, 0x0000CDBB000065B8, 0x0000DDBD0000CDBA, 0x0000C5BF0000DDBC, 0x800019090000C9BE, 0x8000194D8000190D, 0x8000191180001961, 
0x037814EF80001915, 0x034DD8E1034800EF, 0x03795CE302A838E1, 0x800019AD0350B4E3, 0x800019B5800019B1, 0x0001C980800019B9, 0x0001DD820001D581, 0x0001DD8400026D83, 
0x0004018600027185, 0x0005258800051D87, 0x00053D8A00053589, 0x0005758C00056D8B, 0x00056D8E0005658D, 0x0001B5900001CD8F, 0x0001B5920001BD91, 0x0003559400034D93, 
0x0003559600035D95, 0x0003759800034D97, 0x0003759A00037D99, 0x0003559C00034D9B, 0x0003499E0003599D, 0x0003B9A00003499F, 0x0003C1A20003B9A1, 0x0003C5A40003DDA3, 
0x0003C5A60003CDA5, 0x0003C9A80003FDA7, 0x0003D1AA0003C9A9, 0x000331AC0003D1AB, 0x000331AE000331AD, 0x000351B0000331AF, 0x000351B2000351B1, 0x000371B4000351B3, 
0x000371B6000371B5, 0x000351B8000371B7, 0x000351BA000351B9, 0x000331BC000351BB, 0x000331BE000331BD, 0x800019BD000331BF, 0x800019C5800019C1, 0x800019CD800019C9, 
0x800019D5800019D1, 0x800019DD800019D9, 0x000220F0800019E1, 0x800019E9800019E5, 0x800019F1800019ED, 0x0036F59C800019F5, 0x800019F90036FD9D, 0x800019FD00029091, 
0x80001945800019A9, 0x80001A4580001949, 0x80001A4900D869BA, 0x0036B1B880001A4D, 0x80001A510036B1B9, 0x80001A5980001A55, 0x8000195180001A5D, 0x80001A6580001A61, 
0x8000195980001955, 0x800019658000195D, 0x8000196D80001969, 0x8000197580001971, 0x8000197D80001979, 0x8000198580001981, 0x8000198D80001989, 0x8000199580001991, 
0x8000199900025882, 0x000258F080001A69, 0x8000199D80001A6D, 0x800019A5800019A1, 0x80001A0580001A01, 0x023BB4E100037491, 0x0222D8E380001A09, 0x80001A1180001A0D, 
0x80001A1980001A15, 0x80002AA580001A1D, 0x80002AA980002D55, 0x80002AAD80002AC1, 0x023FC8EF80003396, 0x02F394E180002AB5, 0x02F794E302D298E1, 0x02B694E102C610E3, 
0x02A284E3029D90E1, 0x80001919028708E3, 0x02B3B8EF8000191D, 0x80002A9D028B38EF, 0x029720EF80002DE0, 0x0002E48202E0E0EF, 0x8000020880002D69, 0x8000020E00D9C5BA, 
0x8000021A80000214, 0x8000022680000220, 0x800002328000022C, 0x8000023E80000238, 0x8000024A80000244, 0x027880E180000250, 0x026A14E30006E4F0, 0x020FA0E100088082, 
0x020E84E3021308E1, 0x80000256021E18E3, 0x023B34EF80000334, 0x8000033A021F30EF, 0x02120CEF80000340, 0x8000192580000346, 0x8000034C80001929, 0x8000192D80000352, 
0x8000035880001931, 0x800003768000035E, 0x8000038880000382, 0x800003948000038E, 0x8000037C8000039A, 0x8000193580000364, 0x8000036D80001939, 0x8000193D8000025C, 
0x8000027480001941, 0x800002BC80000268, 0x800002988000027A, 0x8000029280000262, 0x800002A48000026E, 0x00065180800002D4, 0x0006558200065D81, 0x0006798400066983, 
0x0006698600067985, 0x0006598800066987, 0x0007A58A0007A189, 0x0007A58C0007BD8B, 0x0007A58E0007AD8D, 0x800002EC800002F2, 0x00140992800002E0, 0x0007F19400141593, 
0x0007F1960007F195, 0x0007D1980007F197, 0x0014399A0007D199, 0x0007819C0007D19B, 0x00077D9E0007819D, 0x00012D9900141D9F, 0x00013D9B00012D98, 0x00012D9D00013D9A, 
0x8000192100012D9C, 0x0006DD910001559E, 0x000125930006D190, 0x00012D9500012592, 0x00011D9700012D94, 0x0006F18900011D96, 0x0006F18B0006E988, 0x0006B18D0006F98A, 
0x0006A98F0006E98C, 0x0006F1810006B98E, 0x0006F1830006ED80, 0x0006D1850006F982, 0x0006D1870006E984, 0x0003ADB90006D986, 0x0003BDBB0003ADB8, 0x0003ADBD0003BDBA, 
0x0003DDBF0003ADBC, 0x0003ADB10003DDBE, 0x0003BDB30003ADB0, 0x0003ADB50003BDB2, 0x00039DB70003ADB4, 0x0001B9A900039DB6, 0x000175AB0001B1A8, 0x000115AD0001B1AA, 
0x0003DDAF000115AC, 0x0001B9A10003DDAE, 0x000189A30001A9A0, 0x000199A50001B1A2, 0x000189A7000191A4, 0x8000032E000191A6, 0x800002CE800002C2, 0x800002DA800002E6, 
0x800002B080000304, 0x80000322800002F8, 0x8000029E8000030A, 0x800002B680000280, 0x800002FE800002C8, 0x8000032880000286, 0x80000310800002AA, 0x800003168000028C, 
0x80002D098000031C, 0x800034CA80002EEB, 0x8000050680000784, 0x8000052480000515, 0x8000054280000533, 0x00382CF08000054B, 0x8000055D80000554, 0x8000059280000566, 
0x8000059B036E48E3, 0x800005A4036E4CE1, 0x800005A70301F4EF, 0x800005AD800005AA, 0x80004CA680003A46, 0x80006836800055D6, 0x80007A9680007166, 0x80009F5680008CF6, 
0x8000BAED8000A886, 0x8000CD548000C424, 0x8000DFB48000D684, 0x8000AE3A8000BB31, 0x80002AF98000A506, 0x80002AA180002B89, 0x8000314180002AE5, 0x8000344E80003101, 
0x8000330680002CD5, 0x800034628000378A, 0x8000349280002C1D, 0x800038128000339E, 0x80002C8580002B59, 0x80003926800031FA, 0x80002BAD80002B1D, 0x80002EBC8000319E, 
0x80002C5980002CC9, 0x80002E2C80002E38, 0x800033EE0006A091, 0x8000379E80002B19, 0x80002DCD80002C75, 0x033FD4E1800005B0, 0x032FDCE3031A58E1, 0x03F214E1030E50E3, 
0x03EA40E303D340E1, 0x800005B303C340E3, 0x03EB78EF800005B6, 0x800005B903F25CEF, 0x03DE44EF800005E5, 0x038BB4E1032598EF, 0x03A27CE303973CE1, 0x004130E1038B98E3, 
0x007F1CE303AC50E1, 0x800005E8004688E3, 0x007B38EF800005EB, 0x800005EE0041E0EF, 0x038ACCEF800005F1, 0x0018C180038720EF, 0x000B29820018DD81, 0x000EE984000B2983, 
0x000F1986000EE985, 0x000F25880018F187, 0x001BE58A001AED89, 0x001D398C001D218B, 0x0010698E001BE58D, 0x001B8590001AD58F, 0x000F4592000F4D91, 0x000F4594000F5D93, 
0x000F4596000F4D95, 0x000F4598000F7D97, 0x000F459A000F4D99, 0x000F419C001B699B, 0x000F419E000F419D, 0x000FC1A0000F419F, 0x000FC1A2000FC1A1, 0x000BB9A4000FC1A3, 
0x000BA9A6000BB9A5, 0x000FF5A8000FCDA7, 0x000FF5AA000FFDA9, 0x000FD9AC000FCDAB, 0x000FC9AE000FD9AD, 0x000FB9B0000FC9AF, 0x000F69B2000FB9B1, 0x000F61B4000F69B3, 
0x000F39B6000F61B5, 0x000F11B8000F39B7, 0x0001E9BA000F11B9, 0x0001F9BC0001E9BB, 0x0001E9BE0001F9BD, 0x800005F40001E9BF, 0x800005FA800005F7, 0x80000600800005FD, 
0x800004E180000620, 0x800005D380000580, 0x800006348000060E, 0x800006688000064B, 0x800006968000067F, 0x800003F6800003DD, 0x800007128000040F, 0x8000083E80000841, 
0x800024398000073F, 0x800024A380002472, 0x800026B9800024C8, 0x800026C8800026C4, 0x800026D0800026CC, 0x8000286E8000282F, 0x8000289A80002896, 0x800028C7800028BF, 
0x800028F5800028E3, 0x800028FD800028F9, 0x8000291500D3E9BA, 0x8000294B80002930, 0x8000244A8000243D, 0x8000246480002457, 0x8000248380002476, 0x800024A780002495, 
0x800024CC800024B7, 0x800024E4800024D6, 0x800024FB800024EE, 0x800025168000250C, 0x800025768000256F, 0x0003198080002524, 0x0003298200031981, 0x0003398400032983, 
0x0003298600033985, 0x0003198800032987, 0x0003698A00031989, 0x0003798C0003698B, 0x0003698E0003798D, 0x000319900003698F, 0x0004019200031991, 0x0003359400032D93, 
0x00065D9600065595, 0x00066D9800065597, 0x00067D9A00067599, 0x00066D9C0006759B, 0x00063D9E0006359D, 0x0006CDA00006359F, 0x0006DDA20006D5A1, 0x0003F9A40006D5A3, 
0x0003E9A60003F9A5, 0x0003D9A80003E9A7, 0x000629AA0006F9A9, 0x000639AC000629AB, 0x0003C5AE000639AD, 0x000345B000033DAF, 0x000345B200034DB1, 0x000345B400035DB3, 
0x000345B600034DB5, 0x000349B800037DB7, 0x000359BA000349B9, 0x000665BC00067DBB, 0x000665BE00066DBD, 0x000F15A980002580, 0x000F4DAB000F01A8, 0x000F45AD000F4DAA, 
0x000DA1AF000F45AC, 0x000B75A1000DA9AE, 0x000BEDA3000B61A0, 0x000BE5A5000BA9A2, 0x000F39A7000BE5A4, 0x000DA1B9000859A6, 0x000DA1BB000D99B8, 0x000DA1BD000DA9BA, 
0x80002531000DB9BC, 0x000DA1B1000DA9BE, 0x000DA1B3000DD9B0, 0x000DA1B5000DA9B2, 0x000DA1B7000DB9B4, 0x80002538000DA9B6, 0x8000255B80002548, 0x800025BC800025B2, 
0x800025A180002591, 0x000DED81800025D0, 0x000DFD83000DED80, 0x000DED85000DFD82, 0x000DD987000DED84, 0x000D4D9900182186, 0x000D519B000D4D98, 0x000D799D000D5D9A, 
0x000D699F000D759C, 0x000D8991000D719E, 0x000D9993000D8190, 0x000D8995000D8192, 0x000D7D97000D8194, 0x800024E0000D8196, 0x8000258D80002520, 0x800025DE800025CC, 
0x8000262D80002608, 0x800025F080002642, 0x8000260C800025FA, 0x8000263180002619, 0x800026588000264E, 0x8000264A80002676, 0x8000266E80002666, 0x8000268C80002680, 
0x800026A380002694, 0x8000269C800026DE, 0x800026A7800026B2, 0x800026D4800026BD, 0x80002701800026E2, 0x8000271B80002711, 0x800027928000274F, 0x8000294F800027E7, 
0x800029618000295D, 0x800026F080002965, 0x8000273E8000272E, 0x8000272380002748, 0x8000276380002753, 0x800027708000277E, 0x800027C280002796, 0x800027A6800027C9, 
0x800027DD800027D3, 0x80002818800027B4, 0x800027EB8000280A, 0x800027F280002825, 0x80002833800027FC, 0x8000284A80002840, 0x8000285E80002854, 0x8000287F80002872, 
0x8000289E80002886, 0x800028B2800028A5, 0x800028D5800028CB, 0x80002901800028E7, 0x800029198000290E, 0x8000293480002923, 0x800029538000293B, 0x800004E6800003C3, 
0x800005D880000585, 0x8000063980000613, 0x8000066D80000650, 0x8000069B80000684, 0x800003FC800003E3, 0x8000042880000415, 0x8000044E8000043B, 0x8000047480000461, 
0x8000049A80000487, 0x8000050F80000500, 0x8000052D8000051E, 0x800008638000053C, 0x800006C180000824, 0x8000091D800007FC, 0x80000933001328E3, 0x8000082D8000082A, 
0x8000072480000831, 0x800030CA80002EDC, 0x800030BB80002DD9, 0x8000092780003145, 0x800009060013ECEF, 0x800008CF80000DDC, 0x8000073180000883, 0x800006FC8000074C, 
0x800008948000080A, 0x800009098000092A, 0x80000DEC80000DE0, 0x80000899800008DB, 0x8000088680000715, 0x800006FF80000755, 0x80002491800007A6, 0x800008E280000DF0, 
0x8000089C80000827, 0x8000091580000858, 0x800008E580000DF4, 0x8000089F80000814, 0x80000817800008E8, 0x800008A2800008C9, 0x8000081B800008EC, 0x800008A6800008CC, 
0x800008FD800008F7, 0x8000088A80000788, 0x8000070380000759, 0x800009418000093D, 0x8000093680000949, 0x80000DF880000918, 0x8000092D800008F4, 0x80000DE48000090C, 
0x8000088E800008D2, 0x800009308000075D, 0x80000DE88000090F, 0x80000891800008D5, 0x800008AD80000760, 0x001248E380000763, 0x0013F8E3001214E3, 0x0012ECE30013B8E3, 
0x00126CE30012A0E3, 0x000DC0EF001278E3, 0x001274EF000DD8EF, 0x0012A8EF001250EF, 0x001328EF0012DCEF, 0x800007E9001320EF, 0x8000080E800006CC, 0x800006D880000811, 
0x80000821800006D4, 0x8000086780000707, 0x800008768000070C, 0x8000073780000734, 0x800008B6800008AA, 0x0010D8E3800008B9, 0x0010A0E30010A0E3, 0x001034E3001174E3, 
0x0010E4E3001008E3, 0x0010BCEF0010F4E3, 0x0010CCEF0010E0EF, 0x001010EF001038EF, 0x001070EF001070EF, 0x001384E300104CEF, 0x001030E30013E8E3, 0x001360E3001010E3, 
0x0013A4E3001340E3, 0x0013C8EF0013B4E3, 0x001398EF0013B4EF, 0x00135CEF00137CEF, 0x001314EF00134CEF, 0x003CED800010E8EF, 0x003CFD82003CF581, 0x003CED84003CF583, 
0x003D1D86003D1585, 0x003D2D88003D1587, 0x003D3D8A003D3589, 0x003D2D8C003D358B, 0x003D1D8E003D158D, 0x003D6D90003D158F, 0x003D7D92003D7591, 0x003D6D94003D7593, 
0x003D1D96003D1595, 0x003D2D98003D1597, 0x003D3D9A003D3599, 0x003D2D9C003D359B, 0x003D1D9E003D159D, 0x003DEDA0003D159F, 0x003DFDA2003DF5A1, 0x003DEDA4003DF5A3, 
0x003D1DA6003D15A5, 0x003D2DA8003D15A7, 0x003D3DAA003D35A9, 0x003D2DAC003D35AB, 0x003D1DAE003D15AD, 0x003D6DB0003D15AF, 0x003D7DB2003D75B1, 0x003D6DB4003D75B3, 
0x003D11B6003D15B5, 0x003D31B8003D11B7, 0x003D31BA003D31B9, 0x003D11BC003D31BB, 0x003D11BE003D11BD, 0x003CF180003D11BF, 0x003CF582003CFD81, 0x003F1584003F0D83, 
0x003F1586003F1D85, 0x003F3588003F0D87, 0x003F358A003F3D89, 0x003F158C003F0D8B, 0x003F158E003F1D8D, 0x003F7590003F0D8F, 0x003F7592003F7D91, 0x003F1594003F0D93, 
0x003F0996003F1995, 0x003F3998003F0997, 0x003F099A003F3999, 0x003F199C003F099B, 0x003F099E003F199D, 0x003FF9A0003F099F, 0x003F09A2003FF9A1, 0x003F19A4003F09A3, 
0x003F09A6003F19A5, 0x003F39A8003F09A7, 0x003F09AA003F39A9, 0x003F19AC003F09AB, 0x003F09AE003F19AD, 0x003F79B0003F09AF, 0x003F09B2003F79B1, 0x003F19B4003F09B3, 
0x003F09B6003F19B5, 0x003F39B8003F09B7, 0x003F09BA003F39B9, 0x003F19BC003F09BB, 0x003F09BE003F19BD, 0x003CF980003F09BF, 0x003D4982003CF981, 0x003D5984003D4983, 
0x003D4986003D5985, 0x003D7988003D4987, 0x003D498A003D7989, 0x003D598C003D498B, 0x003D498E003D598D, 0x003D3990003D498F, 0x00040192003D3991, 0x0006559400064D93, 
0x0006559600065D95, 0x0006759800064D97, 0x0006759A00067D99, 0x0006559C00064D9B, 0x0006559E00065D9D, 0x0006B5A000064D9F, 0x0006B5A20006BDA1, 0x0006D5A40006CDA3, 
0x0006D5A60006DDA5, 0x0006F5A80006CDA7, 0x0006F5AA0006FDA9, 0x0006D5AC0006CDAB, 0x0006D5AE0006DDAD, 0x0006B5B00006CDAF, 0x0006B5B20006BDB1, 0x000655B400064DB3, 
0x000655B600065DB5, 0x000675B800064DB7, 0x000675BA00067DB9, 0x000655BC00064DBB, 0x000655BE00065DBD, 0x003F7DAC00064DBF, 0x003FADAE003FA5AD, 0x003F7DA8003FA5AF, 
0x003F6DAA003F65A9, 0x003F1DA4003F65AB, 0x003F4DA6003F45A5, 0x003F1DA0003F45A7, 0x003F0DA2003F05A1, 0x003F9DBC003F05A3, 0x003FADBE003FA5BD, 0x003F9DB8003FA5BF, 
0x003F8DBA003F85B9, 0x003FDDB4003F85BB, 0x003FADB6003FA5B5, 0x003FDDB0003FA5B7, 0x003FCDB2003FC5B1, 0x003A658C003FC5B3, 0x003A658E003A6D8D, 0x003A4588003A7D8F, 
0x003A458A003A4D89, 0x003A6584003A7D8B, 0x003A6586003A6D85, 0x003A0580003A7D87, 0x003A0582003A0D81, 0x00385D9C003A7D83, 0x003FED9E003FE59D, 0x00385D98003FE59F, 
0x00384D9A00384599, 0x0038B9940038459B, 0x00386D9600386595, 0x003A059000386597, 0x003A0592003A0D91, 0x800008C000390193, 0x800008DE800008D8, 0x80000776800008F0, 
0x8000077980000922, 0x8000095480000781, 0x800007CB8000079D, 0x800006C4800007BD, 0x8000057B800004DC, 0x80000609800005CE, 0x800006468000062F, 0x8000067A80000663, 
0x800003D780000691, 0x80000409800003F0, 0x8000043580000422, 0x8000045B80000448, 0x800004818000046E, 0x800004FA80000494, 0x8000051880000509, 0x8000053680000527, 
0x8000054E80000545, 0x8000056080000557, 0x8000059580000569, 0x8000085D8000059E, 0x80000E5980000E56, 0x80000AAC80003A3A, 0x80003A3680000B15, 0x0000199C80003A3E, 
0x0000399E0000199D, 0x80000CE30000399F, 0x8000377A80003A42, 0x800037A2800030F1, 0x80002AC58000325A, 0x0035309A80002CB9, 0x80002D1D80002DEC, 0x80002FD780002DE8, 
0x800033D20035849F, 0x800035620029449D, 0x800036D68000369A, 0x8000381E8000370A, 0x8000320280003176, 0x80003346800032AE, 0x8000384680003662, 0x80002AE980003972, 
0x8000318A80002C8D, 0x80003696800032D2, 0x80002E94800039C2, 0x800036868000327A, 0x8000300B8000371A, 0x001A80B4800035BE, 0x00E688B6001984B5, 0x001C00B000E48CB7, 
0x001800B2001E94B1, 0x00EC00BC001B9CB3, 0x00EEA8BE00EFA4BD, 0x00E000B800EDA4BF, 0x00E2B8BA00E3B4B9, 0x0000C0A400E1BCBB, 0x000EC8A6000C00A5, 0x800036E2000800A7, 
0x8000310580002F07, 0x001000AC00037CAD, 0x0012E8AE0013E4AD, 0x000AF0A8001160AF, 0x0016F8AA00091CA9, 0x8000321A0014FCAB, 0x8000382A8000331E, 0x80002BC180002B29, 
0x8000307380002C2D, 0x800032CE80003182, 0x8000368E800033F2, 0x800037CA800036A6, 0x800039A2800038EE, 0x8000342E800039BE, 0x800008BC8000346E, 0x8000364680003526, 
0x8000374E8000387A, 0x80002F2380002DA1, 0x8000359E800034DE, 0x8000343680003302, 0x800038E68000379A, 0x80002E7080002D9D, 0x8000322E8000317A, 0x8000351680003262, 
0x800038A68000353E, 0x0000009C80002C29, 0x80002BCD800035AA, 0x8000349A80002BC9, 0x8000365E8000352A, 0x8000376A800038AE, 0x8000375A8000300F, 0x80002E4480002AD1, 
0x8000333280002F7B, 0x80002C4D800033B2, 0x80002B398000343E, 0x80002AB180002F5F, 0x8000308B800031EE, 0x0003E98080003512, 0x002F39820003E981, 0x0003E5840003FD83, 
0x0003E5860003ED85, 0x002E4188002E7D87, 0x002F798A00022189, 0x00023D8C0002258B, 0x0002218E0002258D, 0x0002659000021D8F, 0x0002659200026D91, 0x0002659400027D93, 
0x0002659600026D95, 0x0002259800021D97, 0x0002259A00022D99, 0x0002259C00023D9B, 0x0002259E00022D9D, 0x0002E5A000021D9F, 0x0002E5A20002EDA1, 0x0002E5A40002FDA3, 
0x0002E5A60002EDA5, 0x000275A800024DA7, 0x0001A9AA00027DA9, 0x0001B9AC0001A9AB, 0x0001A9AE0001B9AD, 0x0001D9B00001A9AF, 0x0001E9B20001D9B1, 0x002279B40001E9B3, 
0x0001F5B60001FDB5, 0x0001D5B80001EDB7, 0x0001D5BA0001DDB9, 0x0001B5BC0001ADBB, 0x0001A9BE0001B9BD, 0x80002CA10001A9BF, 0x800033FE80002D8D, 0x8000373E80003666, 
0x800031E6800031BA, 0x8000361E8000301F, 0x800033AE8000303F, 0x80002B8180002B05, 0x8000315680002BC5, 0x800035F6800034FE, 0x8000385A8000374A, 0x80002CE980002C35, 
0x800030A780002F17, 0x800034428000327E, 0x8000397A80003896, 0x800039E6800039CE, 0x800031A6800030E9, 0x80002EE3800037EE, 0x80002FDB80002FBF, 0x8000326E8000306B, 
0x8000336A800032BA, 0x800035328000348E, 0x800037DE80003596, 0x800038068000366E, 0x80002BE98000387E, 0x80002CFD80002C15, 0x800036F6800032AA, 0x80002F7380002F03, 
0x800031B280003037, 0x80003326800034DA, 0x80002D5980002B15, 0x80002F7F80002EA8, 0x8000335E80003342, 0x000151808000356E, 0x00015D82002A0181, 0x00014D8400015583, 
0x00017D8600017585, 0x00014D8800017587, 0x002B9D8A00015589, 0x0001498C0001598B, 0x0001B98E0001498D, 0x0001C9900001B98F, 0x0001D9920001C991, 0x0001C9940001D993, 
0x0001F9960001C995, 0x0001C9980001F997, 0x0001D99A0001C999, 0x0001C99C0001D99B, 0x0001B99E0001C99D, 0x000149A00001B99F, 0x000145A2000195A1, 0x000145A400015DA3, 
0x000145A600014DA5, 0x000145A800017DA7, 0x000F79AA00014DA9, 0x000141AC000141AB, 0x000141AE000141AD, 0x0003C1B0000141AF, 0x0003C1B20003C1B1, 0x0003C1B40003C1B3, 
0x0003C1B60003C1B5, 0x0003C1B80003C1B7, 0x0003C1BA0003C1B9, 0x0003C1BC0003C1BB, 0x0003C1BE0003C1BD, 0x8000358E000CC9BF, 0x800038E280003862, 0x8000392E800038F2, 
0x8000348280002B2D, 0x800038CA8000384E, 0x80002AF180002F97, 0x80002E4880002B51, 0x8000309780002E68, 0x800033CE800032C6, 0x8000381A8000367A, 0x800038A2800030D9, 
0x8000312580002C0D, 0x8000321280003131, 0x8000334E8000324A, 0x8000342A800033AA, 0x8000393A8000350E, 0x800038B280002FEB, 0x80002E8C80002B41, 0x800037E280003232, 
0x80002F9F80002F4F, 0x800038BA80003139, 0x80002CD980002BF1, 0x800030C280002E78, 0x8000316280003115, 0x8000334A800031F6, 0x8000355A800033BE, 0x80003706800036FA, 
0x80002C5D800038D6, 0x80002CDD8000324E, 0x8000336E800032CA, 0x800038BE8000368A, 0x800039D2800039AA, 0x002339B18000312D, 0x000315B3000311B0, 0x000335B5000315B2, 
0x000335B7000335B4, 0x000315B9000335B6, 0x000315BB000315B8, 0x000375BD000315BA, 0x000375BF000375BC, 0x000D99A1000375BE, 0x000DA9A3000D91A0, 0x000DB9A5000D91A2, 
0x000DA9A7000DB1A4, 0x000D99A9000DB1A6, 0x000369AB000D91A8, 0x000379AD000D91AA, 0x000369AF000371AC, 0x000D1991000371AE, 0x000D2D93000D1190, 0x000D3D95000D1192, 
0x000D2D97000D3D94, 0x000D1D99000D2D96, 0x000D6D9B000D1D98, 0x000D799D000D6D9A, 0x000D699F000E819C, 0x000D9981000D719E, 0x000DA98300230980, 0x000DB985000D9182, 
0x000DA987000DB184, 0x000D9989000DB186, 0x000D698B000D9188, 0x000D798D000D918A, 0x000D698F000D718C, 0x8000322A000D718E, 0x800034C6800035C6, 0x8000331A800034EA, 
0x80003766800032A2, 0x8000362E80002B0D, 0x80002BE580002BF5, 0x8000301380002EF3, 0x80002E34800034F6, 0x800030E580003206, 0x800038AA800037EA, 0x80002B6180002F0F, 
0x80002D8980002D35, 0x80002BD1800030D5, 0x800033E680003322, 0x800034668000344A, 0x8000347E8000346A, 0x800034EE800038FA, 0x8000375680003692, 0x800038368000380A, 
0x800039528000394E, 0x800039BA80003956, 0x800038C68000382E, 0x80002B5580002B31, 0x80002C2580002B69, 0x80002C7180002C31, 0x80002D4180002D25, 0x80002D8580002D49, 
0x80002E7480002D91, 0x80002FB380002F8B, 0x0010F89180002FBB, 0x8000307F80002FD3, 0x800030DD800030AF, 0x000129808000315A, 0x0001398200012981, 0x0001298400013983, 
0x0001598600012985, 0x0028D98800015987, 0x0025298A00016D89, 0x0001618C0001618B, 0x8000321E0001618D, 0x000119908000323A, 0x000115928000326A, 0x800032DE800032BE, 
0x00013D9600013595, 0x00010D9800013597, 0x00011D9A00011599, 0x00010D9C0001159B, 0x0028DD9E0001F59D, 0x000105A080003352, 0x000101A280003432, 0x8000345280003456, 
0x000109A6000119A5, 0x8000345E8000345A, 0x00013DAA80003476, 0x00012DAC000135AB, 0x00011DAE000115AD, 0x00016DB0000115AF, 0x00017DB2000175B1, 0x00016DB4000175B3, 
0x00011DB6000115B5, 0x00012DB8000115B7, 0x00013DBA000135B9, 0x002ED9BC000135BB, 0x000119BE000129BD, 0x001E79BA000119BF, 0x0002CDB8001E79BB, 0x001E95BE001E79B9, 
0x000241BC001E9DBF, 0x001E7DB2001E9DBD, 0x001E7DB0001E45B3, 0x001E5DB6001E75B1, 0x001E5DB4001E45B7, 0x001E05AA001E55B5, 0x001E75A8001E0DAB, 0x8000347A001E0DA9, 
0x001E15AC8000349E, 0x001E49A2001E0DAD, 0x001E49A0001E49A3, 0x001E49A6001E49A1, 0x001E49A40002F9A7, 0x001E8D9A001E49A5, 0x001E8D98001E959B, 0x001E899E001E8599, 
0x001E8D9C001E899F, 0x00030592001E859D, 0x000309900000F593, 0x001EB19600398D91, 0x0000ED9400061597, 0x0003BD8A001C0195, 0x000385880003418B, 0x0003418E00039D89, 
0x0039C98C0003498F, 0x000215820003518D, 0x0002058000021D83, 0x0003CD8600021D81, 0x000205840003B187, 0x0005F9B30003C585, 0x0005F9B10005F1B2, 0x002A99B70005E1B0, 
0x000319B5000311B6, 0x000335BB0005E1B4, 0x000325B9000335BA, 0x000315BF000325B8, 0x000325BD000315BE, 0x0005FDA3000325BC, 0x0005FDA10005FDA2, 0x00059DA70005FDA0, 
0x00059DA500059DA6, 0x0005B9AB00059DA4, 0x002725A90005B1AA, 0x000599AF0005BDA8, 0x000599AD000591AE, 0x000501930005A1AC, 0x003975910005F992, 0x000501970005F590, 
0x0005119500051996, 0x0009799B00051994, 0x000531990005399A, 0x00051D9F00053998, 0x00051D9D00051D9E, 0x0005898300051D9C, 0x0005898100058182, 0x000585870005F180, 
0x0005958500058586, 0x0005858B00268184, 0x0005B5890005858A, 0x0005858F0005B588, 0x0005958D0005858E, 0x800034CE0005958C, 0x800035428000353A, 0x8000357E80003556, 
0x80003602800035CE, 0x800037128000366A, 0x8000375E8000372A, 0x800037A680003762, 0x80003802800037AA, 0x8000391E800038DA, 0x80002F8380003936, 0x800035E68000EA90, 
0x80002BBD80002AB9, 0x80002B2580002B7D, 0x8