// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008 - INRIA - Serge Steer
// Copyright (C) 2010 - DIGITEO - Michael Baudin
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- CLI SHELL MODE -->

// Maple code used to create reference
// Digits := 40: 
// writeto("acosd.ref"): interface(prettyprint = 0):
// for i from -1 by 1/200 to 1 do print(i, evalf[30](arccos(i)*180/Pi, 30)) end do; 
// writeto(terminal):

ieee(2)
pi=%pi;eps=%eps;Inf=%inf;NaN=%nan; //used to make following code runnable under Matlab

ref=[-1, 180.
-199/200, 174.268032034802276025812349240
-99/100, 171.890385544005821304179816712
-197/200, 170.063632927859279626539910716
-49/50, 168.521659045466427374970182192
-39/40, 167.161431859015947964508026889
-97/100, 165.930132252427874336131938947
-193/200, 164.796395906706995631725241030
-24/25, 163.739795291688042593711225119
-191/200, 162.746146882642724461983650429
-19/20, 161.805127661233223475817833285
-189/200, 160.908947487139639834394379338
-47/50, 160.051556411197304428468900657
-187/200, 159.228144954671740571345783884
-93/100, 158.434814984757324037281529582
-37/40, 157.668354990778489454815507268
-23/25, 156.926081934369024619725256979
-183/200, 156.205727049463362426368627490
-91/100, 155.505351528580319859934797238
-181/200, 154.823283059390274021817685934
-9/10, 154.158067236832871264830460741
-179/200, 153.508429799643927439863292545
-89/100, 152.873246882726032304097026012
-177/200, 152.251521299346598104744798445
-22/25, 151.642363423672021236763751322
-7/8, 151.044975628140152242457930402
-87/100, 150.458639499857209858967812767
-173/200, 149.882705252677940000910824492
-43/50, 149.316582891024180144592826653
-171/200, 148.759734783818330270786999618
-17/20, 148.211669382948380165928340392
-169/200, 147.671935877837735817718749727
-21/25, 147.140119621110891263411957432
-167/200, 146.615838193651724709827331481
-83/100, 146.098738003133731386832168487
-33/40, 145.588491330230552333234292299
-41/50, 145.084793752555815419507908415
-163/200, 144.587361888940431790906349399
-81/100, 144.095931416682828774137441326
-161/200, 143.610255322466446951635666570
-4/5, 143.130102354155978703144387441
-159/200, 142.655255645985221369540043812
-79/100, 142.185511493985853881761584531
-157/200, 141.720678262072262284603259670
-39/50, 141.260575402144345711961325393
-31/40, 140.805032574017056767472817570
-77/100, 140.353888853026281860017435502
-153/200, 139.906992014870231353990521905
-19/25, 139.464197888683440051608565736
-151/200, 139.025369770554673066486836681
-3/4, 138.590377890729140661519497813
-149/200, 138.159098928610784755706482823
-37/50, 137.731415570427532415064480212
-147/200, 137.307216105062196114720575535
-73/100, 136.886394054101287366638006220
-29/40, 136.468847832627544131166680843
-18/25, 136.054480437691163850285968392
-143/200, 135.643199161749314155294029418
-71/100, 135.234915328671577440848667783
-141/200, 134.829544050177364149307975259
-7/10, 134.427004000805703726744612246
-139/200, 134.027217209722993146477100981
-69/100, 133.630108867854306728089116110
-137/200, 133.235607148982184318299691098
-17/25, 132.843643043596337791955001160
-27/40, 132.454150204400936240997147204
-67/100, 132.067064802495173606928305930
-133/200, 131.682325393339509328026004142
-33/50, 131.299872791705865911261895378
-131/200, 130.919649954886512560527113007
-13/20, 130.541601873504521758912533281
-129/200, 130.165675469329559601387725001
-16/25, 129.791819499557230382922930854
-127/200, 129.419984467058996707327008748
-63/100, 129.050122536153495413812608213
-5/8, 128.682187453489439990938748375
-31/50, 128.316134473665742529660921481
-123/200, 127.951920289246440902988066211
-61/100, 127.589502964856864059624963870
-121/200, 127.228841875073547701465016787
-3/5, 126.869897645844021296855612559
-119/200, 126.512632099193987281373013890
-59/100, 126.157008200998835686585239415
-117/200, 125.802990011614086854062000960
-29/50, 125.450542639175412517595956611
-23/40, 125.099632195393512106919476449
-57/100, 124.750225753682459451466558246
-113/200, 124.402291309472312211568864036
-14/25, 124.055797742567905559481970100
-111/200, 123.710714781425933898865116621
-11/20, 123.367012969231750012250966511
-109/200, 123.024663631665860716391947716
-27/50, 122.683638846257944226073158175
-107/200, 122.343911413233421863430840894
-53/100, 122.005454827764243771934589805
-21/40, 121.668243253541647293932281470
-13/25, 121.332251497594264810397959990
-103/200, 120.997454986280137624952833626
-51/100, 120.663829742385972249679940501
-101/200, 120.331352363271389855083128698
-1/2, 120.
-99/200, 119.669750337402904408274357706
-49/100, 119.340581575023731194338291947
-97/200, 119.012472408897537857818823579
-12/25, 118.685402014118923720668713822
-19/40, 118.359350028157478492692327049
-47/100, 118.034296534881280809626198306
-93/200, 117.710222049251564814173799493
-23/50, 117.387107502653908655033451399
-91/200, 117.064934228833379397875735446
-9/20, 116.743683950403006359313493055
-89/200, 116.423338765896760331856680783
-11/25, 116.103881137339899662583422795
-87/200, 115.785293878311114923291098816
-43/100, 115.467560142472370431662156824
-17/40, 115.150663412543710913246410051
-21/50, 114.834587489701582254140895581
-83/200, 114.519316483380413122899750969
-41/100, 114.204834801458325245837993803
-81/200, 113.891127140808889827684769372
-2/5, 113.578178478201831104022499420
-79/200, 113.265974061536499975498066979
-39/100, 112.954499401392805421488788243
-77/200, 112.643740262885102902093287328
-19/50, 112.333682657805300904224895932
-3/8, 112.024312837042162561296775203
-37/100, 111.715617283264452010024916946
-73/200, 111.407582703856207739629333674
-9/25, 111.100196024093020318942040347
-71/200, 110.793444380548752037500177267
-7/20, 110.487315114722663466756581659
-69/200, 110.181795766877408868233152581
-17/50, 109.876874070078830723385803774
-67/200, 109.572537944428925269485720076
-33/100, 109.268775491483767500236787281
-13/40, 108.965574988848577211627391053
-8/25, 108.662924884942478813717261122
-63/200, 108.360813793925858155912060395
-31/100, 108.059230490783550800036833839
-61/200, 107.758163906557409207684457641
-3/10, 107.457603123722092290246045793
-59/200, 107.157537371698200731017463399
-29/100, 106.857956022497146388619025778
-57/200, 106.558848586492394825098087469
-7/25, 106.260204708311957406288774882
-11/40, 105.962014162847234276747341722
-27/100, 105.664266851373522546012025055
-53/200, 105.366952797777705918556696254
-13/50, 105.070062144888833393869909131
-51/200, 104.773585150907476151722087359
-1/4, 104.477512185929923878771034799
-49/200, 104.181833728563445108511673745
-6/25, 103.886540362628991126397190852
-47/200, 103.591622773947870094102430356
-23/100, 103.297071747209057700985746843
-9/40, 103.002878162913943259659917380
-11/50, 102.709032994395436104042067599
-43/200, 102.415527304908476776828927780
-21/100, 102.122352244789111141769993220
-41/200, 101.829499048679393536772814002
-1/5, 101.536959032815487690137371511
-39/200, 101.244723592376431629657710124
-19/100, 100.952784198891125481880645473
-37/200, 100.661132397701189129820989460
-9/50, 100.369759805477420400648764235
-7/40, 100.078658107787664005351140501
-17/100, 99.7878190567139770523622950848
-33/200, 99.4972344685170487968380756418
-4/25, 99.2068962213459005455128918997
-31/200, 98.9167962529909564821749334384
-3/20, 98.6269265586786377690081747854
-29/200, 98.3372791889056907632577556596
-7/50, 98.0478462473115157069191758434
-27/200, 97.7586198885868149311423640048
-13/100, 97.4695923164169295906389871936
-1/8, 97.1807557814582813230389956264
-3/25, 96.8921025793463801233218519558
-23/200, 96.6036250487339022370041329598
-11/100, 96.3153155693573821043055502610
-21/200, 96.0271665601311004217336858743
-1/10, 95.7391704772667863125149089039
-19/200, 95.4513198124177854928324286237
-9/100, 95.1636070908463782616447892117
-17/200, 94.8760248696129611978867456195
-2/25, 94.5885657357858346854735540496
-3/40, 94.3012223046703648647652886442
-7/100, 94.0139872180563133858770516834
-13/200, 93.7268531424821514673567044878
-3/50, 93.4398127675151962924129215448
-11/200, 93.1528588040464277495451695634
-1/20, 92.8659839825988619870938253798
-9/200, 92.5791810516483752405240422596
-1/25, 92.2924427759558869425744149447
-7/200, 92.0057619349098252720072878099
-3/100, 91.7191313208778110658315401402
-1/40, 91.4325437375665074388349037506
-1/50, 91.1459919983885925465107755084
-3/200, 90.8594689248358217136610964462
-1/100, 90.5729673448571526490501273824
-1/200, 90.2864800912409136917576079772
0, 90.
1/200, 89.7135199087590863082423920228
1/100, 89.4270326551428473509498726176
3/200, 89.1405310751641782863389035538
1/50, 88.8540080016114074534892244916
1/40, 88.5674562624334925611650962494
3/100, 88.2808686791221889341684598598
7/200, 87.9942380650901747279927121901
1/25, 87.7075572240441130574255850553
9/200, 87.4208189483516247594759577404
1/20, 87.1340160174011380129061746202
11/200, 86.8471411959535722504548304366
3/50, 86.5601872324848037075870784552
13/200, 86.2731468575178485326432955122
7/100, 85.9860127819436866141229483166
3/40, 85.6987776953296351352347113558
2/25, 85.4114342642141653145264459504
17/200, 85.1239751303870388021132543805
9/100, 84.8363929091536217383552107883
19/200, 84.5486801875822145071675713763
1/10, 84.2608295227332136874850910961
21/200, 83.9728334398688995782663141257
11/100, 83.6846844306426178956944497390
23/200, 83.3963749512660977629958670402
3/25, 83.1078974206536198766781480442
1/8, 82.8192442185417186769610043736
13/100, 82.5304076835830704093610128064
27/200, 82.2413801114131850688576359950
7/50, 81.9521537526884842930808241566
29/200, 81.6627208110943092367422443404
3/20, 81.3730734413213622309918252146
31/200, 81.0832037470090435178250665616
4/25, 80.7931037786540994544871081003
33/200, 80.5027655314829512031619243582
17/100, 80.2121809432860229476377049152
7/40, 79.9213418922123359946488594990
9/50, 79.6302401945225795993512357654
37/200, 79.3388676022988108701790105404
19/100, 79.0472158011088745181193545266
39/200, 78.7552764076235683703422898755
1/5, 78.4630409671845123098626284894
41/200, 78.1705009513206064632271859984
21/100, 77.8776477552108888582300067798
43/200, 77.5844726950915232231710722200
11/50, 77.2909670056045638959579324011
9/40, 76.9971218370860567403400826201
23/100, 76.7029282527909422990142531571
47/200, 76.4083772260521299058975696436
6/25, 76.1134596373710088736028091477
49/200, 75.8181662714365548914883262552
1/4, 75.5224878140700761212289652011
51/200, 75.2264148490925238482779126409
13/50, 74.9299378551111666061300908688
53/200, 74.6330472022222940814433037462
27/100, 74.3357331486264774539879749454
11/40, 74.0379858371527657232526582778
7/25, 73.7397952916880425937112251178
57/200, 73.4411514135076051749019125307
29/100, 73.1420439775028536113809742218
59/200, 72.8424626283017992689825366011
3/10, 72.5423968762779077097539542074
61/200, 72.2418360934425907923155423588
31/100, 71.9407695092164491999631661615
63/200, 71.6391862060741418440879396045
8/25, 71.3370751150575211862827388776
13/40, 71.0344250111514227883726089470
33/100, 70.7312245085162324997632127189
67/200, 70.4274620555710747305142799240
17/50, 70.1231259299211692766141962258
69/200, 69.8182042331225911317668474189
7/20, 69.5126848852773365332434183407
71/200, 69.2065556194512479624998227329
9/25, 68.8998039759069796810579596527
73/200, 68.5924172961437922603706663259
37/100, 68.2843827167355479899750830536
3/8, 67.9756871629578374387032247971
19/50, 67.6663173421946990957751040683
77/200, 67.3562597371148970979067126718
39/100, 67.0455005986071945785112117574
79/200, 66.7340259384635000245019330210
2/5, 66.4218215217981688959775005800
81/200, 66.1088728591911101723152306282
41/100, 65.7951651985416747541620061968
83/200, 65.4806835166195868771002490307
21/50, 65.1654125102984177458591044188
17/40, 64.8493365874562890867535899491
43/100, 64.5324398575276295683378431756
87/200, 64.2147061216888850767089011842
11/25, 63.8961188626601003374165772053
89/200, 63.5766612341032396681433192167
9/20, 63.2563160495969936406865069454
91/200, 62.9350657711666206021242645542
23/50, 62.6128924973460913449665486008
93/200, 62.2897779507484351858262005073
47/100, 61.9657034651187191903738016938
19/40, 61.6406499718425215073076729505
12/25, 61.3145979858810762793312861784
97/200, 60.9875275911024621421811764213
49/100, 60.6594184249762688056617080534
99/200, 60.3302496625970955917256422939
1/2, 60.
101/200, 59.6686476367286101449168713023
51/100, 59.3361702576140277503200594986
103/200, 59.0025450137198623750471663735
13/25, 58.6677485024057351896020400102
21/40, 58.3317567464583527060677185303
53/100, 57.9945451722357562280654101954
107/200, 57.6560885867665781365691591058
27/50, 57.3163611537420557739268418254
109/200, 56.9753363683341392836080522843
11/20, 56.6329870307682499877490334894
111/200, 56.2892852185740661011348833791
14/25, 55.9442022574320944405180298994
113/200, 55.5977086905276877884311359634
57/100, 55.2497742463175405485334417536
23/40, 54.9003678046064878930805235510
29/50, 54.5494573608245874824040433892
117/200, 54.1970099883859131459379990402
59/100, 53.8429917990011643134147605851
119/200, 53.4873679008060127186269861097
3/5, 53.1301023541559787031443874408
121/200, 52.7711581249264522985349832132
61/100, 52.4104970351431359403750361305
123/200, 52.0480797107535590970119337887
31/50, 51.6838655263342574703390785190
5/8, 51.3178125465105600090612516256
63/100, 50.9498774638465045861873917869
127/200, 50.5800155329410032926729912521
16/25, 50.2081805004427696170770691462
129/200, 49.8343245306704403986122749994
13/20, 49.4583981264954782410874667192
131/200, 49.0803500451134874394728869926
33/50, 48.7001272082941340887381046222
133/200, 48.3176746066604906719739958577
67/100, 47.9329351975048263930716940706
27/40, 47.5458497955990637590028527958
17/25, 47.1563569564036622080449988397
137/200, 46.7643928510178156817003089021
69/100, 46.3698911321456932719108838903
139/200, 45.9727827902770068535228990189
7/10, 45.5729959991942962732553877542
141/200, 45.1704559498226358506920247411
71/100, 44.7650846713284225591513322170
143/200, 44.3568008382506858447059705812
18/25, 43.9455195623088361497140316081
29/40, 43.5311521673724558688333191570
73/100, 43.1136059458987126333619937805
147/200, 42.6927838949378038852794244647
37/50, 42.2685844295724675849355197874
149/200, 41.8409010713892152442935171770
3/4, 41.4096221092708593384805021869
151/200, 40.9746302294453269335131633188
19/25, 40.5358021113165599483914342639
153/200, 40.0930079851297686460094780947
77/100, 39.6461111469737181399825644984
31/40, 39.1949674259829432325271824300
39/50, 38.7394245978556542880386746068
157/200, 38.2793217379277377153967403296
79/100, 37.8144885060141461182384154690
159/200, 37.3447443540147786304599561880
4/5, 36.8698976458440212968556125590
161/200, 36.3897446775335530483643334297
81/100, 35.9040685833171712258625586735
163/200, 35.4126381110595682090936506011
41/50, 34.9152062474441845804920915848
33/40, 34.4115086697694476667657077014
83/100, 33.9012619968662686131678315130
167/200, 33.3841618063482752901726685183
21/25, 32.8598803788891087365880425680
169/200, 32.3280641221622641822812502725
17/20, 31.7883306170516198340716596084
171/200, 31.2402652161816697292130003819
43/50, 30.6834171089758198554071733473
173/200, 30.1172947473220599990891755077
87/100, 29.5413605001427901410321872331
7/8, 28.9550243718598477575420695983
22/25, 28.3576365763279787632362486784
177/200, 27.7484787006534018952552015546
89/100, 27.1267531172739676959029739875
179/200, 26.4915702003560725601367074552
9/10, 25.8419327631671287351695392595
181/200, 25.1767169406097259781823140658
91/100, 24.4946484714196801400652027616
183/200, 23.7942729505366375736313725101
23/25, 23.0739180656309753802747430210
37/40, 22.3316450092215105451844927317
93/100, 21.5651850152426759627184704171
187/200, 20.7718550453282594286542161162
47/50, 19.9484435888026955715310993431
189/200, 19.0910525128603601656056206621
19/20, 18.1948723387667765241821667149
191/200, 17.2538531173572755380163495707
24/25, 16.2602047083119574062887748818
193/200, 15.2036040932930043682747589700
97/100, 14.0698677475721256638680610535
39/40, 12.8385681409840520354919731110
49/50, 11.4783409545335726250298178078
197/200, 9.93636707214072037346008928431
99/100, 8.10961445599417869582018328724
199/200, 5.73196796519772397418765075974
1, 0.];


x=ref(1:$-1,1);
expected = ref(1:$-1,2);
computed = acosd(x);
e=max(abs((expected-computed)./expected));
if e>10*eps then pause,end
if acosd(1)<>0 then pause,end
if acosd(-1)<>180 then pause,end
if acosd(0)<>90 then pause,end

if acosd([])<>[] then pause,end

