/* rygel-tracker-selection-query.c generated by valac 0.36.6, the Vala compiler
 * generated from rygel-tracker-selection-query.vala, do not modify */

/*
 * Copyright (C) 2010-2012 Nokia Corporation.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <rygel-core.h>


#define RYGEL_TRACKER_TYPE_QUERY (rygel_tracker_query_get_type ())
#define RYGEL_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery))
#define RYGEL_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))
#define RYGEL_TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY))
#define RYGEL_TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQueryClass))

typedef struct _RygelTrackerQuery RygelTrackerQuery;
typedef struct _RygelTrackerQueryClass RygelTrackerQueryClass;
typedef struct _RygelTrackerQueryPrivate RygelTrackerQueryPrivate;

#define RYGEL_TRACKER_TYPE_QUERY_TRIPLETS (rygel_tracker_query_triplets_get_type ())
#define RYGEL_TRACKER_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTriplets))
#define RYGEL_TRACKER_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_IS_QUERY_TRIPLETS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS))
#define RYGEL_TRACKER_QUERY_TRIPLETS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_QUERY_TRIPLETS, RygelTrackerQueryTripletsClass))

typedef struct _RygelTrackerQueryTriplets RygelTrackerQueryTriplets;
typedef struct _RygelTrackerQueryTripletsClass RygelTrackerQueryTripletsClass;

#define RYGEL_TRACKER_TYPE_SELECTION_QUERY (rygel_tracker_selection_query_get_type ())
#define RYGEL_TRACKER_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery))
#define RYGEL_TRACKER_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))
#define RYGEL_TRACKER_IS_SELECTION_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_IS_SELECTION_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SELECTION_QUERY))
#define RYGEL_TRACKER_SELECTION_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryClass))

typedef struct _RygelTrackerSelectionQuery RygelTrackerSelectionQuery;
typedef struct _RygelTrackerSelectionQueryClass RygelTrackerSelectionQueryClass;
typedef struct _RygelTrackerSelectionQueryPrivate RygelTrackerSelectionQueryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _rygel_tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (rygel_tracker_query_unref (var), NULL)))
typedef struct _RygelTrackerSelectionQueryExecuteData RygelTrackerSelectionQueryExecuteData;

struct _RygelTrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerQueryPrivate * priv;
	RygelTrackerQueryTriplets* triplets;
};

struct _RygelTrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerQuery *self);
	void (*execute) (RygelTrackerQuery* self, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*execute_finish) (RygelTrackerQuery* self, GAsyncResult* _res_, GError** error);
	gchar* (*to_string) (RygelTrackerQuery* self);
};

struct _RygelTrackerSelectionQuery {
	RygelTrackerQuery parent_instance;
	RygelTrackerSelectionQueryPrivate * priv;
	GeeArrayList* variables;
	GeeArrayList* filters;
	gchar* order_by;
	gint offset;
	gint max_count;
	TrackerSparqlCursor* result;
};

struct _RygelTrackerSelectionQueryClass {
	RygelTrackerQueryClass parent_class;
};

struct _RygelTrackerSelectionQueryPrivate {
	gchar* uri_filter;
};

struct _RygelTrackerSelectionQueryExecuteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelTrackerSelectionQuery* self;
	TrackerSparqlConnection* resources;
	gchar* str;
	gchar* _tmp0_;
	TrackerSparqlCursor* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	GError * _inner_error_;
};


static gpointer rygel_tracker_selection_query_parent_class = NULL;

gpointer rygel_tracker_query_ref (gpointer instance);
void rygel_tracker_query_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_query (GValue* value, gpointer v_object);
void rygel_tracker_value_take_query (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_query (const GValue* value);
GType rygel_tracker_query_get_type (void) G_GNUC_CONST;
GType rygel_tracker_query_triplets_get_type (void) G_GNUC_CONST;
GType rygel_tracker_selection_query_get_type (void) G_GNUC_CONST;
#define RYGEL_TRACKER_SELECTION_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQueryPrivate))
enum  {
	RYGEL_TRACKER_SELECTION_QUERY_DUMMY_PROPERTY
};
#define RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE "?item"
#define RYGEL_TRACKER_SELECTION_QUERY_SHARED_FILTER "(!BOUND(nmm:uPnPShared(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")) ||" " nmm:uPnPShared(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") = true) && " "(BOUND(nie:url(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")))"
#define RYGEL_TRACKER_SELECTION_QUERY_STRICT_SHARED_FILTER "(BOUND(nmm:dlnaProfile(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ")))"
#define RYGEL_TRACKER_SELECTION_QUERY_AVAILABLE_FILTER "(tracker:available(" RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE ") = true)"
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count);
RygelTrackerQuery* rygel_tracker_query_construct (GType object_type, RygelTrackerQueryTriplets* triplets);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query);
RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query);
static GeeArrayList* rygel_tracker_selection_query_copy_str_list (GeeList* str_list);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_new_clone (RygelTrackerQueryTriplets* triplets);
RygelTrackerQueryTriplets* rygel_tracker_query_triplets_construct_clone (GType object_type, RygelTrackerQueryTriplets* triplets);
static void rygel_tracker_selection_query_real_execute_data_free (gpointer _data);
static void rygel_tracker_selection_query_real_execute_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void rygel_tracker_selection_query_real_execute (RygelTrackerQuery* base, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_tracker_selection_query_real_execute_co (RygelTrackerSelectionQueryExecuteData* _data_);
gchar* rygel_tracker_query_to_string (RygelTrackerQuery* self);
static void rygel_tracker_selection_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* rygel_tracker_selection_query_real_to_string (RygelTrackerQuery* base);
static void rygel_tracker_selection_query_finalize (RygelTrackerQuery * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_;
		gint _tmp33_;
		gint _tmp34_;
		gsize _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		const gchar* res = NULL;
		gsize _tmp40_;
		void* _tmp41_;
		void* ptr = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gint _tmp43__length1;
		const gchar* _tmp44_;
		void* _tmp45_;
		const gchar* _tmp62_;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gint _tmp21_ = 0;
				gchar** _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				const gchar* _tmp24_;
				gsize _tmp30_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						gint _tmp19_;
						const gchar* _tmp20_;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_;
				gchar** _tmp49_;
				gint _tmp49__length1;
				void* _tmp50_;
				const gchar* _tmp51_;
				void* _tmp52_;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_;
				gint _tmp54__length1;
				gint _tmp55_;
				const gchar* _tmp56_;
				void* _tmp60_;
				void* _tmp61_;
				if (!_tmp46_) {
					gint _tmp47_;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_;
					gint _tmp57__length1;
					gint _tmp58_;
					const gchar* _tmp59_;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct (GType object_type, GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count) {
	RygelTrackerSelectionQuery* self = NULL;
	RygelTrackerQueryTriplets* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GeeArrayList* uris = NULL;
	gchar** uri_filters = NULL;
	gchar** _tmp11_;
	gint uri_filters_length1;
	gint _uri_filters_size_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp12_;
	GFile* home_dir = NULL;
	const gchar* _tmp18_;
	GFile* _tmp19_;
	const gchar* pictures_dir = NULL;
	const gchar* _tmp20_;
	const gchar* videos_dir = NULL;
	const gchar* _tmp21_;
	const gchar* music_dir = NULL;
	const gchar* _tmp22_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (variables != NULL, NULL);
	g_return_val_if_fail (triplets != NULL, NULL);
	_tmp0_ = triplets;
	self = (RygelTrackerSelectionQuery*) rygel_tracker_query_construct (object_type, _tmp0_);
	_tmp1_ = filters;
	if (_tmp1_ != NULL) {
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		_tmp2_ = filters;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->filters);
		self->filters = _tmp3_;
	} else {
		GeeArrayList* _tmp4_;
		_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->filters);
		self->filters = _tmp4_;
	}
	_tmp5_ = variables;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->variables);
	self->variables = _tmp6_;
	_tmp7_ = order_by;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->order_by);
	self->order_by = _tmp8_;
	_tmp9_ = offset;
	self->offset = _tmp9_;
	_tmp10_ = max_count;
	self->max_count = _tmp10_;
	_tmp11_ = g_new0 (gchar*, 0 + 1);
	uri_filters = _tmp11_;
	uri_filters_length1 = 0;
	_uri_filters_size_ = uri_filters_length1;
	_tmp12_ = rygel_meta_config_get_default ();
	config = _tmp12_;
	{
		GeeArrayList* _tmp13_ = NULL;
		RygelMetaConfig* _tmp14_;
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		_tmp14_ = config;
		_tmp15_ = rygel_configuration_get_string_list ((RygelConfiguration*) _tmp14_, "Tracker", "only-export-from", &_inner_error_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_tmp16_ = _tmp13_;
		_tmp13_ = NULL;
		_g_object_unref0 (uris);
		uris = _tmp16_;
		_g_object_unref0 (_tmp13_);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		GeeArrayList* _tmp17_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		_g_object_unref0 (uris);
		uris = _tmp17_;
		_g_error_free0 (_error_);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (config);
		uri_filters = (_vala_array_free (uri_filters, uri_filters_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp18_ = g_get_home_dir ();
	_tmp19_ = g_file_new_for_path (_tmp18_);
	home_dir = _tmp19_;
	_tmp20_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	pictures_dir = _tmp20_;
	_tmp21_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	videos_dir = _tmp21_;
	_tmp22_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	music_dir = _tmp22_;
	{
		GeeArrayList* _uri_list = NULL;
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		gint _uri_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _uri_index = 0;
		_tmp23_ = uris;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_uri_list = _tmp24_;
		_tmp25_ = _uri_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_uri_size = _tmp27_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gchar* uri = NULL;
			GeeArrayList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			GFile* file = NULL;
			const gchar* _tmp34_;
			GFile* _tmp35_;
			GFile* _tmp36_;
			GFile* _tmp37_;
			gboolean _tmp38_;
			_tmp28_ = _uri_index;
			_uri_index = _tmp28_ + 1;
			_tmp29_ = _uri_index;
			_tmp30_ = _uri_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _uri_list;
			_tmp32_ = _uri_index;
			_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
			uri = (gchar*) _tmp33_;
			_tmp34_ = uri;
			_tmp35_ = g_file_new_for_commandline_arg (_tmp34_);
			file = _tmp35_;
			_tmp36_ = file;
			_tmp37_ = home_dir;
			_tmp38_ = g_file_equal (_tmp36_, _tmp37_);
			if (!_tmp38_) {
				gchar* actual_uri = NULL;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp45_;
				const gchar* _tmp49_;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				const gchar* _tmp55_;
				gboolean _tmp56_;
				const gchar* _tmp61_;
				GFile* _tmp62_;
				GFile* _tmp63_;
				GFile* _tmp64_;
				gboolean _tmp65_;
				gchar** _tmp66_;
				gint _tmp66__length1;
				GFile* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				_tmp39_ = uri;
				_tmp40_ = g_strdup (_tmp39_);
				actual_uri = _tmp40_;
				_tmp41_ = pictures_dir;
				if (_tmp41_ != NULL) {
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					gchar* _tmp44_;
					_tmp42_ = actual_uri;
					_tmp43_ = pictures_dir;
					_tmp44_ = string_replace (_tmp42_, "@PICTURES@", _tmp43_);
					_g_free0 (actual_uri);
					actual_uri = _tmp44_;
				}
				_tmp45_ = videos_dir;
				if (_tmp45_ != NULL) {
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					_tmp46_ = actual_uri;
					_tmp47_ = videos_dir;
					_tmp48_ = string_replace (_tmp46_, "@VIDEOS@", _tmp47_);
					_g_free0 (actual_uri);
					actual_uri = _tmp48_;
				}
				_tmp49_ = music_dir;
				if (_tmp49_ != NULL) {
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					_tmp50_ = actual_uri;
					_tmp51_ = music_dir;
					_tmp52_ = string_replace (_tmp50_, "@MUSIC@", _tmp51_);
					_g_free0 (actual_uri);
					actual_uri = _tmp52_;
				}
				_tmp55_ = actual_uri;
				_tmp56_ = string_contains (_tmp55_, "@PICTURES@");
				if (_tmp56_) {
					_tmp54_ = TRUE;
				} else {
					const gchar* _tmp57_;
					gboolean _tmp58_;
					_tmp57_ = actual_uri;
					_tmp58_ = string_contains (_tmp57_, "@VIDEOS@");
					_tmp54_ = _tmp58_;
				}
				if (_tmp54_) {
					_tmp53_ = TRUE;
				} else {
					const gchar* _tmp59_;
					gboolean _tmp60_;
					_tmp59_ = actual_uri;
					_tmp60_ = string_contains (_tmp59_, "@MUSIC@");
					_tmp53_ = _tmp60_;
				}
				if (_tmp53_) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_tmp61_ = actual_uri;
				_tmp62_ = g_file_new_for_commandline_arg (_tmp61_);
				_g_object_unref0 (file);
				file = _tmp62_;
				_tmp63_ = file;
				_tmp64_ = home_dir;
				_tmp65_ = g_file_equal (_tmp63_, _tmp64_);
				if (_tmp65_) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_tmp66_ = uri_filters;
				_tmp66__length1 = uri_filters_length1;
				_tmp67_ = file;
				_tmp68_ = g_file_get_uri (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = g_strdup_printf ("tracker:uri-is-descendant(\"%s\", nie:url(%s))", _tmp69_, RYGEL_TRACKER_SELECTION_QUERY_ITEM_VARIABLE);
				_vala_array_add1 (&uri_filters, &uri_filters_length1, &_uri_filters_size_, _tmp70_);
				_g_free0 (_tmp69_);
				_g_free0 (actual_uri);
			}
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	_tmp71_ = uri_filters;
	_tmp71__length1 = uri_filters_length1;
	if (_tmp71__length1 != 0) {
		gchar** _tmp72_;
		gint _tmp72__length1;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp72_ = uri_filters;
		_tmp72__length1 = uri_filters_length1;
		_tmp73_ = _vala_g_strjoinv ("||", _tmp72_, _tmp72__length1);
		_tmp74_ = _tmp73_;
		_tmp75_ = g_strdup_printf ("(%s)", _tmp74_);
		_g_free0 (self->priv->uri_filter);
		self->priv->uri_filter = _tmp75_;
		_g_free0 (_tmp74_);
	} else {
		_g_free0 (self->priv->uri_filter);
		self->priv->uri_filter = NULL;
	}
	_g_object_unref0 (home_dir);
	_g_object_unref0 (config);
	uri_filters = (_vala_array_free (uri_filters, uri_filters_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (uris);
	return self;
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_new (GeeArrayList* variables, RygelTrackerQueryTriplets* triplets, GeeArrayList* filters, const gchar* order_by, gint offset, gint max_count) {
	return rygel_tracker_selection_query_construct (RYGEL_TRACKER_TYPE_SELECTION_QUERY, variables, triplets, filters, order_by, offset, max_count);
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_construct_clone (GType object_type, RygelTrackerSelectionQuery* query) {
	RygelTrackerSelectionQuery* self = NULL;
	RygelTrackerSelectionQuery* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelTrackerSelectionQuery* _tmp4_;
	RygelTrackerQueryTriplets* _tmp5_;
	RygelTrackerQueryTriplets* _tmp6_;
	RygelTrackerQueryTriplets* _tmp7_;
	RygelTrackerSelectionQuery* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	RygelTrackerSelectionQuery* _tmp12_;
	const gchar* _tmp13_;
	RygelTrackerSelectionQuery* _tmp14_;
	gint _tmp15_;
	RygelTrackerSelectionQuery* _tmp16_;
	gint _tmp17_;
	g_return_val_if_fail (query != NULL, NULL);
	_tmp0_ = query;
	_tmp1_ = _tmp0_->variables;
	_tmp2_ = rygel_tracker_selection_query_copy_str_list ((GeeList*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = query;
	_tmp5_ = ((RygelTrackerQuery*) _tmp4_)->triplets;
	_tmp6_ = rygel_tracker_query_triplets_new_clone (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = query;
	_tmp9_ = _tmp8_->filters;
	_tmp10_ = rygel_tracker_selection_query_copy_str_list ((GeeList*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = query;
	_tmp13_ = _tmp12_->order_by;
	_tmp14_ = query;
	_tmp15_ = _tmp14_->offset;
	_tmp16_ = query;
	_tmp17_ = _tmp16_->max_count;
	self = (RygelTrackerSelectionQuery*) rygel_tracker_selection_query_construct (object_type, _tmp3_, _tmp7_, _tmp11_, _tmp13_, _tmp15_, _tmp17_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp3_);
	return self;
}


RygelTrackerSelectionQuery* rygel_tracker_selection_query_new_clone (RygelTrackerSelectionQuery* query) {
	return rygel_tracker_selection_query_construct_clone (RYGEL_TRACKER_TYPE_SELECTION_QUERY, query);
}


static void rygel_tracker_selection_query_real_execute_data_free (gpointer _data) {
	RygelTrackerSelectionQueryExecuteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->resources);
	_rygel_tracker_query_unref0 (_data_->self);
	g_slice_free (RygelTrackerSelectionQueryExecuteData, _data_);
}


static void rygel_tracker_selection_query_real_execute_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	RygelTrackerSelectionQueryExecuteData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _rygel_tracker_query_ref0 (gpointer self) {
	return self ? rygel_tracker_query_ref (self) : NULL;
}


static void rygel_tracker_selection_query_real_execute (RygelTrackerQuery* base, TrackerSparqlConnection* resources, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelTrackerSelectionQuery * self;
	RygelTrackerSelectionQueryExecuteData* _data_;
	RygelTrackerSelectionQuery* _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	TrackerSparqlConnection* _tmp2_;
	self = (RygelTrackerSelectionQuery*) base;
	_data_ = g_slice_new0 (RygelTrackerSelectionQueryExecuteData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (NULL, NULL, rygel_tracker_selection_query_real_execute_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_tracker_selection_query_real_execute_data_free);
	_tmp0_ = _rygel_tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = resources;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->resources);
	_data_->resources = _tmp2_;
	rygel_tracker_selection_query_real_execute_co (_data_);
}


static void rygel_tracker_selection_query_real_execute_finish (RygelTrackerQuery* base, GAsyncResult* _res_, GError** error) {
	RygelTrackerSelectionQueryExecuteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void rygel_tracker_selection_query_execute_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelTrackerSelectionQueryExecuteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_tracker_selection_query_real_execute_co (_data_);
}


static gboolean rygel_tracker_selection_query_real_execute_co (RygelTrackerSelectionQueryExecuteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = rygel_tracker_query_to_string ((RygelTrackerQuery*) _data_->self);
	_data_->str = _data_->_tmp0_;
	g_debug ("rygel-tracker-selection-query.vala:148: Executing SPARQL query: %s", _data_->str);
	_data_->_tmp2_ = _data_->resources;
	_data_->_state_ = 1;
	tracker_sparql_connection_query_async (_data_->_tmp2_, _data_->str, NULL, rygel_tracker_selection_query_execute_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = tracker_sparql_connection_query_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		_g_free0 (_data_->str);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->result);
	_data_->self->result = _data_->_tmp4_;
	_g_object_unref0 (_data_->_tmp1_);
	_g_free0 (_data_->str);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* rygel_tracker_selection_query_real_to_string (RygelTrackerQuery* base) {
	RygelTrackerSelectionQuery * self;
	gchar* result = NULL;
	gchar* query = NULL;
	gchar* _tmp0_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GeeArrayList* filters = NULL;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	const gchar* _tmp28_;
	gint _tmp30_;
	gint _tmp31_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	gint _tmp59_;
	gint _tmp67_;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerSelectionQuery*) base;
	_tmp0_ = g_strdup ("SELECT ");
	query = _tmp0_;
	{
		GeeArrayList* _variable_list = NULL;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _variable_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _variable_index = 0;
		_tmp1_ = self->variables;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_variable_list = _tmp2_;
		_tmp3_ = _variable_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_variable_size = _tmp5_;
		_variable_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gchar* variable = NULL;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp6_ = _variable_index;
			_variable_index = _tmp6_ + 1;
			_tmp7_ = _variable_index;
			_tmp8_ = _variable_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _variable_list;
			_tmp10_ = _variable_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			variable = (gchar*) _tmp11_;
			_tmp12_ = query;
			_tmp13_ = variable;
			_tmp14_ = g_strconcat (" ", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
			_g_free0 (query);
			query = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (variable);
		}
		_g_object_unref0 (_variable_list);
	}
	_tmp17_ = query;
	_tmp18_ = RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_selection_query_parent_class)->to_string (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TRACKER_TYPE_QUERY, RygelTrackerQuery));
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (" WHERE { ", _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp17_, _tmp21_, NULL);
	_g_free0 (query);
	query = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_tmp23_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	filters = _tmp23_;
	_tmp24_ = self->filters;
	gee_array_list_add_all (filters, (GeeCollection*) _tmp24_);
	gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_SHARED_FILTER);
	gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_AVAILABLE_FILTER);
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_;
		_tmp25_ = rygel_meta_config_get_default ();
		config = _tmp25_;
		_tmp27_ = rygel_configuration_get_bool ((RygelConfiguration*) config, "Tracker", "strict-sharing", &_inner_error_);
		_tmp26_ = _tmp27_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch11_g_error;
		}
		if (_tmp26_) {
			gee_abstract_collection_add ((GeeAbstractCollection*) filters, RYGEL_TRACKER_SELECTION_QUERY_STRICT_SHARED_FILTER);
		}
		_g_object_unref0 (config);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (filters);
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp28_ = self->priv->uri_filter;
	if (_tmp28_ != NULL) {
		const gchar* _tmp29_;
		_tmp29_ = self->priv->uri_filter;
		gee_abstract_collection_add ((GeeAbstractCollection*) filters, _tmp29_);
	}
	_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
	_tmp31_ = _tmp30_;
	if (_tmp31_ > 0) {
		const gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		_tmp32_ = query;
		_tmp33_ = g_strconcat (_tmp32_, " FILTER (", NULL);
		_g_free0 (query);
		query = _tmp33_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp34_ = FALSE;
				_tmp34_ = TRUE;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					const gchar* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gint _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					if (!_tmp34_) {
						gint _tmp35_;
						_tmp35_ = i;
						i = _tmp35_ + 1;
					}
					_tmp34_ = FALSE;
					_tmp36_ = i;
					_tmp37_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
					_tmp38_ = _tmp37_;
					if (!(_tmp36_ < _tmp38_)) {
						break;
					}
					_tmp39_ = query;
					_tmp40_ = i;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) filters, _tmp40_);
					_tmp42_ = (gchar*) _tmp41_;
					_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
					_g_free0 (query);
					query = _tmp43_;
					_g_free0 (_tmp42_);
					_tmp44_ = i;
					_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) filters);
					_tmp46_ = _tmp45_;
					if (_tmp44_ < (_tmp46_ - 1)) {
						const gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp47_ = query;
						_tmp48_ = g_strconcat (_tmp47_, " && ", NULL);
						_g_free0 (query);
						query = _tmp48_;
					}
				}
			}
		}
		_tmp49_ = query;
		_tmp50_ = g_strconcat (_tmp49_, ")", NULL);
		_g_free0 (query);
		query = _tmp50_;
	}
	_tmp51_ = query;
	_tmp52_ = g_strconcat (_tmp51_, " }", NULL);
	_g_free0 (query);
	query = _tmp52_;
	_tmp53_ = self->order_by;
	if (_tmp53_ != NULL) {
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp54_ = query;
		_tmp55_ = self->order_by;
		_tmp56_ = g_strconcat (" ORDER BY ", _tmp55_, NULL);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp54_, _tmp57_, NULL);
		_g_free0 (query);
		query = _tmp58_;
		_g_free0 (_tmp57_);
	}
	_tmp59_ = self->offset;
	if (_tmp59_ > 0) {
		const gchar* _tmp60_;
		gint _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp60_ = query;
		_tmp61_ = self->offset;
		_tmp62_ = g_strdup_printf ("%i", _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_strconcat (" OFFSET ", _tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strconcat (_tmp60_, _tmp65_, NULL);
		_g_free0 (query);
		query = _tmp66_;
		_g_free0 (_tmp65_);
		_g_free0 (_tmp63_);
	}
	_tmp67_ = self->max_count;
	if (_tmp67_ > 0) {
		const gchar* _tmp68_;
		gint _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp68_ = query;
		_tmp69_ = self->max_count;
		_tmp70_ = g_strdup_printf ("%i", _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strconcat (" LIMIT ", _tmp71_, NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strconcat (_tmp68_, _tmp73_, NULL);
		_g_free0 (query);
		query = _tmp74_;
		_g_free0 (_tmp73_);
		_g_free0 (_tmp71_);
	}
	result = query;
	_g_object_unref0 (filters);
	return result;
}


static GeeArrayList* rygel_tracker_selection_query_copy_str_list (GeeList* str_list) {
	GeeArrayList* result = NULL;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (str_list != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	copy = _tmp0_;
	_tmp1_ = str_list;
	gee_array_list_add_all (copy, (GeeCollection*) _tmp1_);
	result = copy;
	return result;
}


static void rygel_tracker_selection_query_class_init (RygelTrackerSelectionQueryClass * klass) {
	rygel_tracker_selection_query_parent_class = g_type_class_peek_parent (klass);
	((RygelTrackerQueryClass *) klass)->finalize = rygel_tracker_selection_query_finalize;
	g_type_class_add_private (klass, sizeof (RygelTrackerSelectionQueryPrivate));
	((RygelTrackerQueryClass *) klass)->execute = (void (*) (RygelTrackerQuery *, TrackerSparqlConnection*, GAsyncReadyCallback, gpointer)) rygel_tracker_selection_query_real_execute;
	((RygelTrackerQueryClass *) klass)->execute_finish = (void (*) (RygelTrackerQuery *, GAsyncResult*, GError**)) rygel_tracker_selection_query_real_execute_finish;
	((RygelTrackerQueryClass *) klass)->to_string = (gchar* (*) (RygelTrackerQuery *)) rygel_tracker_selection_query_real_to_string;
}


static void rygel_tracker_selection_query_instance_init (RygelTrackerSelectionQuery * self) {
	self->priv = RYGEL_TRACKER_SELECTION_QUERY_GET_PRIVATE (self);
}


static void rygel_tracker_selection_query_finalize (RygelTrackerQuery * obj) {
	RygelTrackerSelectionQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TRACKER_TYPE_SELECTION_QUERY, RygelTrackerSelectionQuery);
	_g_free0 (self->priv->uri_filter);
	_g_object_unref0 (self->variables);
	_g_object_unref0 (self->filters);
	_g_free0 (self->order_by);
	_g_object_unref0 (self->result);
	RYGEL_TRACKER_QUERY_CLASS (rygel_tracker_selection_query_parent_class)->finalize (obj);
}


/**
 * Represents Tracker SPARQL Selection query
 */
GType rygel_tracker_selection_query_get_type (void) {
	static volatile gsize rygel_tracker_selection_query_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_selection_query_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerSelectionQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_selection_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerSelectionQuery), 0, (GInstanceInitFunc) rygel_tracker_selection_query_instance_init, NULL };
		GType rygel_tracker_selection_query_type_id;
		rygel_tracker_selection_query_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_QUERY, "RygelTrackerSelectionQuery", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_selection_query_type_id__volatile, rygel_tracker_selection_query_type_id);
	}
	return rygel_tracker_selection_query_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



