/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Area : Administrative area
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Area {
    /// Name of the area
    #[serde(rename = "name")]
    pub name: String,
    /// [OpenStreetMap `admin_level`](https://wiki.openstreetmap.org/wiki/Key:admin_level) of the area 
    #[serde(rename = "adminLevel")]
    pub admin_level: f64,
    /// Whether this area was matched by the input text
    #[serde(rename = "matched")]
    pub matched: bool,
    /// Whether this area should be displayed as default area (area with admin level closest 7)
    #[serde(rename = "default", skip_serializing_if = "Option::is_none")]
    pub default: Option<bool>,
}

impl Area {
    /// Administrative area
    pub fn new(name: String, admin_level: f64, matched: bool) -> Area {
        Area {
            name,
            admin_level,
            matched,
            default: None,
        }
    }
}

