/* automatically generated by rust-bindgen 0.59.2 */

pub type va_list = __builtin_va_list;
pub type __int8_t = libc::c_schar;
pub type __uint8_t = libc::c_uchar;
pub type __int16_t = libc::c_short;
pub type __uint16_t = libc::c_ushort;
pub type __int32_t = libc::c_int;
pub type __uint32_t = libc::c_uint;
pub type __int64_t = libc::c_long;
pub type __uint64_t = libc::c_ulong;
pub type csh = usize;
#[repr(u32)]
#[doc = " Architecture type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cs_arch {
    #[doc = "< ARM architecture (including Thumb, Thumb-2)"]
    CS_ARCH_ARM = 0,
    #[doc = "< ARM-64, also called AArch64"]
    CS_ARCH_ARM64 = 1,
    #[doc = "< Mips architecture"]
    CS_ARCH_MIPS = 2,
    #[doc = "< X86 architecture (including x86 & x86-64)"]
    CS_ARCH_X86 = 3,
    #[doc = "< PowerPC architecture"]
    CS_ARCH_PPC = 4,
    #[doc = "< Sparc architecture"]
    CS_ARCH_SPARC = 5,
    #[doc = "< SystemZ architecture"]
    CS_ARCH_SYSZ = 6,
    #[doc = "< XCore architecture"]
    CS_ARCH_XCORE = 7,
    #[doc = "< 68K architecture"]
    CS_ARCH_M68K = 8,
    #[doc = "< TMS320C64x architecture"]
    CS_ARCH_TMS320C64X = 9,
    #[doc = "< 680X architecture"]
    CS_ARCH_M680X = 10,
    #[doc = "< Ethereum architecture"]
    CS_ARCH_EVM = 11,
    #[doc = "< MOS65XX architecture (including MOS6502)"]
    CS_ARCH_MOS65XX = 12,
    #[doc = "< WebAssembly architecture"]
    CS_ARCH_WASM = 13,
    #[doc = "< Berkeley Packet Filter architecture (including eBPF)"]
    CS_ARCH_BPF = 14,
    #[doc = "< RISCV architecture"]
    CS_ARCH_RISCV = 15,
    CS_ARCH_MAX = 16,
    CS_ARCH_ALL = 65535,
}
#[doc = "< little-endian mode (default mode)"]
pub const CS_MODE_LITTLE_ENDIAN: cs_mode = cs_mode(0);
#[doc = "< 32-bit ARM"]
pub const CS_MODE_ARM: cs_mode = cs_mode(0);
#[doc = "< 16-bit mode (X86)"]
pub const CS_MODE_16: cs_mode = cs_mode(2);
#[doc = "< 32-bit mode (X86)"]
pub const CS_MODE_32: cs_mode = cs_mode(4);
#[doc = "< 64-bit mode (X86, PPC)"]
pub const CS_MODE_64: cs_mode = cs_mode(8);
#[doc = "< ARM's Thumb mode, including Thumb-2"]
pub const CS_MODE_THUMB: cs_mode = cs_mode(16);
#[doc = "< ARM's Cortex-M series"]
pub const CS_MODE_MCLASS: cs_mode = cs_mode(32);
#[doc = "< ARMv8 A32 encodings for ARM"]
pub const CS_MODE_V8: cs_mode = cs_mode(64);
#[doc = "< MicroMips mode (MIPS)"]
pub const CS_MODE_MICRO: cs_mode = cs_mode(16);
#[doc = "< Mips III ISA"]
pub const CS_MODE_MIPS3: cs_mode = cs_mode(32);
#[doc = "< Mips32r6 ISA"]
pub const CS_MODE_MIPS32R6: cs_mode = cs_mode(64);
#[doc = "< Mips II ISA"]
pub const CS_MODE_MIPS2: cs_mode = cs_mode(128);
#[doc = "< SparcV9 mode (Sparc)"]
pub const CS_MODE_V9: cs_mode = cs_mode(16);
#[doc = "< Quad Processing eXtensions mode (PPC)"]
pub const CS_MODE_QPX: cs_mode = cs_mode(16);
#[doc = "< Signal Processing Engine mode (PPC)"]
pub const CS_MODE_SPE: cs_mode = cs_mode(32);
#[doc = "< Book-E mode (PPC)"]
pub const CS_MODE_BOOKE: cs_mode = cs_mode(64);
#[doc = "< M68K 68000 mode"]
pub const CS_MODE_M68K_000: cs_mode = cs_mode(2);
#[doc = "< M68K 68010 mode"]
pub const CS_MODE_M68K_010: cs_mode = cs_mode(4);
#[doc = "< M68K 68020 mode"]
pub const CS_MODE_M68K_020: cs_mode = cs_mode(8);
#[doc = "< M68K 68030 mode"]
pub const CS_MODE_M68K_030: cs_mode = cs_mode(16);
#[doc = "< M68K 68040 mode"]
pub const CS_MODE_M68K_040: cs_mode = cs_mode(32);
#[doc = "< M68K 68060 mode"]
pub const CS_MODE_M68K_060: cs_mode = cs_mode(64);
#[doc = "< big-endian mode"]
pub const CS_MODE_BIG_ENDIAN: cs_mode = cs_mode(2147483648);
#[doc = "< Mips32 ISA (Mips)"]
pub const CS_MODE_MIPS32: cs_mode = cs_mode(4);
#[doc = "< Mips64 ISA (Mips)"]
pub const CS_MODE_MIPS64: cs_mode = cs_mode(8);
#[doc = "< M680X Hitachi 6301,6303 mode"]
pub const CS_MODE_M680X_6301: cs_mode = cs_mode(2);
#[doc = "< M680X Hitachi 6309 mode"]
pub const CS_MODE_M680X_6309: cs_mode = cs_mode(4);
#[doc = "< M680X Motorola 6800,6802 mode"]
pub const CS_MODE_M680X_6800: cs_mode = cs_mode(8);
#[doc = "< M680X Motorola 6801,6803 mode"]
pub const CS_MODE_M680X_6801: cs_mode = cs_mode(16);
#[doc = "< M680X Motorola/Freescale 6805 mode"]
pub const CS_MODE_M680X_6805: cs_mode = cs_mode(32);
#[doc = "< M680X Motorola/Freescale/NXP 68HC08 mode"]
pub const CS_MODE_M680X_6808: cs_mode = cs_mode(64);
#[doc = "< M680X Motorola 6809 mode"]
pub const CS_MODE_M680X_6809: cs_mode = cs_mode(128);
#[doc = "< M680X Motorola/Freescale/NXP 68HC11 mode"]
pub const CS_MODE_M680X_6811: cs_mode = cs_mode(256);
#[doc = "< M680X Motorola/Freescale/NXP CPU12"]
#[doc = "< used on M68HC12/HCS12"]
pub const CS_MODE_M680X_CPU12: cs_mode = cs_mode(512);
#[doc = "< M680X Freescale/NXP HCS08 mode"]
pub const CS_MODE_M680X_HCS08: cs_mode = cs_mode(1024);
#[doc = "< Classic BPF mode (default)"]
pub const CS_MODE_BPF_CLASSIC: cs_mode = cs_mode(0);
#[doc = "< Extended BPF mode"]
pub const CS_MODE_BPF_EXTENDED: cs_mode = cs_mode(1);
#[doc = "< RISCV RV32G"]
pub const CS_MODE_RISCV32: cs_mode = cs_mode(1);
#[doc = "< RISCV RV64G"]
pub const CS_MODE_RISCV64: cs_mode = cs_mode(2);
#[doc = "< RISCV compressed instructure mode"]
pub const CS_MODE_RISCVC: cs_mode = cs_mode(4);
#[doc = "< MOS65XXX MOS 6502"]
pub const CS_MODE_MOS65XX_6502: cs_mode = cs_mode(2);
#[doc = "< MOS65XXX WDC 65c02"]
pub const CS_MODE_MOS65XX_65C02: cs_mode = cs_mode(4);
#[doc = "< MOS65XXX WDC W65c02"]
pub const CS_MODE_MOS65XX_W65C02: cs_mode = cs_mode(8);
#[doc = "< MOS65XXX WDC 65816, 8-bit m/x"]
pub const CS_MODE_MOS65XX_65816: cs_mode = cs_mode(16);
#[doc = "< MOS65XXX WDC 65816, 16-bit m, 8-bit x"]
pub const CS_MODE_MOS65XX_65816_LONG_M: cs_mode = cs_mode(32);
#[doc = "< MOS65XXX WDC 65816, 8-bit m, 16-bit x"]
pub const CS_MODE_MOS65XX_65816_LONG_X: cs_mode = cs_mode(64);
pub const CS_MODE_MOS65XX_65816_LONG_MX: cs_mode = cs_mode(96);
impl ::core::ops::BitOr<cs_mode> for cs_mode {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        cs_mode(self.0 | other.0)
    }
}
impl ::core::ops::BitOrAssign for cs_mode {
    #[inline]
    fn bitor_assign(&mut self, rhs: cs_mode) {
        self.0 |= rhs.0;
    }
}
impl ::core::ops::BitAnd<cs_mode> for cs_mode {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        cs_mode(self.0 & other.0)
    }
}
impl ::core::ops::BitAndAssign for cs_mode {
    #[inline]
    fn bitand_assign(&mut self, rhs: cs_mode) {
        self.0 &= rhs.0;
    }
}
#[repr(C)]
#[doc = " Mode type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct cs_mode(pub libc::c_uint);
pub type cs_malloc_t =
    ::core::option::Option<unsafe extern "C" fn(size: usize) -> *mut libc::c_void>;
pub type cs_calloc_t =
    ::core::option::Option<unsafe extern "C" fn(nmemb: usize, size: usize) -> *mut libc::c_void>;
pub type cs_realloc_t = ::core::option::Option<
    unsafe extern "C" fn(ptr: *mut libc::c_void, size: usize) -> *mut libc::c_void,
>;
pub type cs_free_t = ::core::option::Option<unsafe extern "C" fn(ptr: *mut libc::c_void)>;
pub type cs_vsnprintf_t = ::core::option::Option<
    unsafe extern "C" fn(
        str_: *mut libc::c_char,
        size: usize,
        format: *const libc::c_char,
        ap: *mut __va_list_tag,
    ) -> libc::c_int,
>;
#[doc = " User-defined dynamic memory related functions: malloc/calloc/realloc/free/vsnprintf()"]
#[doc = " By default, Capstone uses system's malloc(), calloc(), realloc(), free() & vsnprintf()."]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_opt_mem {
    pub malloc: cs_malloc_t,
    pub calloc: cs_calloc_t,
    pub realloc: cs_realloc_t,
    pub free: cs_free_t,
    pub vsnprintf: cs_vsnprintf_t,
}
impl Clone for cs_opt_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Customize mnemonic for instructions with alternative name."]
#[doc = " To reset existing customized instruction to its default mnemonic,"]
#[doc = " call cs_option(CS_OPT_MNEMONIC) again with the same @id and NULL value"]
#[doc = " for @mnemonic."]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_opt_mnem {
    #[doc = " ID of instruction to be customized."]
    pub id: libc::c_uint,
    #[doc = " Customized instruction mnemonic."]
    pub mnemonic: *const libc::c_char,
}
impl Clone for cs_opt_mnem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " Runtime option for the disassembled engine"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cs_opt_type {
    #[doc = "< No option specified"]
    CS_OPT_INVALID = 0,
    #[doc = "< Assembly output syntax"]
    CS_OPT_SYNTAX = 1,
    #[doc = "< Break down instruction structure into details"]
    CS_OPT_DETAIL = 2,
    #[doc = "< Change engine's mode at run-time"]
    CS_OPT_MODE = 3,
    #[doc = "< User-defined dynamic memory related functions"]
    CS_OPT_MEM = 4,
    #[doc = "< Skip data when disassembling. Then engine is in SKIPDATA mode."]
    CS_OPT_SKIPDATA = 5,
    #[doc = "< Setup user-defined function for SKIPDATA option"]
    CS_OPT_SKIPDATA_SETUP = 6,
    #[doc = "< Customize instruction mnemonic"]
    CS_OPT_MNEMONIC = 7,
    #[doc = "< print immediate operands in unsigned form"]
    CS_OPT_UNSIGNED = 8,
}
pub mod cs_opt_value {
    #[doc = " Runtime option value (associated with option type above)"]
    pub type Type = libc::c_uint;
    #[doc = "< Turn OFF an option - default for CS_OPT_DETAIL, CS_OPT_SKIPDATA, CS_OPT_UNSIGNED."]
    pub const CS_OPT_OFF: Type = 0;
    #[doc = "< Turn ON an option (CS_OPT_DETAIL, CS_OPT_SKIPDATA)."]
    pub const CS_OPT_ON: Type = 3;
    #[doc = "< Default asm syntax (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_DEFAULT: Type = 0;
    #[doc = "< X86 Intel asm syntax - default on X86 (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_INTEL: Type = 1;
    #[doc = "< X86 ATT asm syntax (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_ATT: Type = 2;
    #[doc = "< Prints register name with only number (CS_OPT_SYNTAX)"]
    pub const CS_OPT_SYNTAX_NOREGNAME: Type = 3;
    #[doc = "< X86 Intel Masm syntax (CS_OPT_SYNTAX)."]
    pub const CS_OPT_SYNTAX_MASM: Type = 4;
    #[doc = "< MOS65XX use $ as hex prefix"]
    pub const CS_OPT_SYNTAX_MOTOROLA: Type = 5;
}
#[repr(u32)]
#[doc = " Common instruction operand types - to be consistent across all architectures."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum cs_op_type {
    #[doc = "< uninitialized/invalid operand."]
    CS_OP_INVALID = 0,
    #[doc = "< Register operand."]
    CS_OP_REG = 1,
    #[doc = "< Immediate operand."]
    CS_OP_IMM = 2,
    #[doc = "< Memory operand."]
    CS_OP_MEM = 3,
    #[doc = "< Floating-Point operand."]
    CS_OP_FP = 4,
}
#[doc = "< Uninitialized/invalid access type."]
pub const CS_AC_INVALID: cs_ac_type = cs_ac_type(0);
#[doc = "< Operand read from memory or register."]
pub const CS_AC_READ: cs_ac_type = cs_ac_type(1);
#[doc = "< Operand write to memory or register."]
pub const CS_AC_WRITE: cs_ac_type = cs_ac_type(2);
impl ::core::ops::BitOr<cs_ac_type> for cs_ac_type {
    type Output = Self;
    #[inline]
    fn bitor(self, other: Self) -> Self {
        cs_ac_type(self.0 | other.0)
    }
}
impl ::core::ops::BitOrAssign for cs_ac_type {
    #[inline]
    fn bitor_assign(&mut self, rhs: cs_ac_type) {
        self.0 |= rhs.0;
    }
}
impl ::core::ops::BitAnd<cs_ac_type> for cs_ac_type {
    type Output = Self;
    #[inline]
    fn bitand(self, other: Self) -> Self {
        cs_ac_type(self.0 & other.0)
    }
}
impl ::core::ops::BitAndAssign for cs_ac_type {
    #[inline]
    fn bitand_assign(&mut self, rhs: cs_ac_type) {
        self.0 &= rhs.0;
    }
}
#[repr(C)]
#[doc = " Common instruction operand access types - to be consistent across all architectures."]
#[doc = " It is possible to combine access types, for example: CS_AC_READ | CS_AC_WRITE"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub struct cs_ac_type(pub libc::c_uint);
pub mod cs_group_type {
    #[doc = " Common instruction groups - to be consistent across all architectures."]
    pub type Type = libc::c_uint;
    #[doc = "< uninitialized/invalid group."]
    pub const CS_GRP_INVALID: Type = 0;
    #[doc = "< all jump instructions (conditional+direct+indirect jumps)"]
    pub const CS_GRP_JUMP: Type = 1;
    #[doc = "< all call instructions"]
    pub const CS_GRP_CALL: Type = 2;
    #[doc = "< all return instructions"]
    pub const CS_GRP_RET: Type = 3;
    #[doc = "< all interrupt instructions (int+syscall)"]
    pub const CS_GRP_INT: Type = 4;
    #[doc = "< all interrupt return instructions"]
    pub const CS_GRP_IRET: Type = 5;
    #[doc = "< all privileged instructions"]
    pub const CS_GRP_PRIVILEGE: Type = 6;
    #[doc = "< all relative branching instructions"]
    pub const CS_GRP_BRANCH_RELATIVE: Type = 7;
}
#[doc = "User-defined callback function for SKIPDATA option."]
#[doc = "See tests/test_skipdata.c for sample code demonstrating this API."]
#[doc = ""]
#[doc = "@code: the input buffer containing code to be disassembled."]
#[doc = "This is the same buffer passed to cs_disasm()."]
#[doc = "@code_size: size (in bytes) of the above @code buffer."]
#[doc = "@offset: the position of the currently-examining byte in the input"]
#[doc = "buffer @code mentioned above."]
#[doc = "@user_data: user-data passed to cs_option() via @user_data field in"]
#[doc = "cs_opt_skipdata struct below."]
#[doc = ""]
#[doc = "@return: return number of bytes to skip, or 0 to immediately stop disassembling."]
pub type cs_skipdata_cb_t = ::core::option::Option<
    unsafe extern "C" fn(
        code: *const u8,
        code_size: usize,
        offset: usize,
        user_data: *mut libc::c_void,
    ) -> usize,
>;
#[doc = " User-customized setup for SKIPDATA option"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_opt_skipdata {
    #[doc = " Capstone considers data to skip as special \"instructions\"."]
    #[doc = " User can specify the string for this instruction's \"mnemonic\" here."]
    #[doc = " By default (if @mnemonic is NULL), Capstone use \".byte\"."]
    pub mnemonic: *const libc::c_char,
    #[doc = " User-defined callback function to be called when Capstone hits data."]
    #[doc = " If the returned value from this callback is positive (>0), Capstone"]
    #[doc = " will skip exactly that number of bytes & continue. Otherwise, if"]
    #[doc = " the callback returns 0, Capstone stops disassembling and returns"]
    #[doc = " immediately from cs_disasm()"]
    #[doc = " NOTE: if this callback pointer is NULL, Capstone would skip a number"]
    #[doc = " of bytes depending on architectures, as following:"]
    #[doc = " Arm:     2 bytes (Thumb mode) or 4 bytes."]
    #[doc = " Arm64:   4 bytes."]
    #[doc = " Mips:    4 bytes."]
    #[doc = " M680x:   1 byte."]
    #[doc = " PowerPC: 4 bytes."]
    #[doc = " Sparc:   4 bytes."]
    #[doc = " SystemZ: 2 bytes."]
    #[doc = " X86:     1 bytes."]
    #[doc = " XCore:   2 bytes."]
    #[doc = " EVM:     1 bytes."]
    #[doc = " RISCV:   4 bytes."]
    #[doc = " WASM:    1 bytes."]
    #[doc = " MOS65XX: 1 bytes."]
    #[doc = " BPF:     8 bytes."]
    pub callback: cs_skipdata_cb_t,
    #[doc = " User-defined data to be passed to @callback function pointer."]
    pub user_data: *mut libc::c_void,
}
impl Clone for cs_opt_skipdata {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " ARM shift type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_shifter {
    ARM_SFT_INVALID = 0,
    #[doc = "< shift with immediate const"]
    ARM_SFT_ASR = 1,
    #[doc = "< shift with immediate const"]
    ARM_SFT_LSL = 2,
    #[doc = "< shift with immediate const"]
    ARM_SFT_LSR = 3,
    #[doc = "< shift with immediate const"]
    ARM_SFT_ROR = 4,
    #[doc = "< shift with immediate const"]
    ARM_SFT_RRX = 5,
    #[doc = "< shift with register"]
    ARM_SFT_ASR_REG = 6,
    #[doc = "< shift with register"]
    ARM_SFT_LSL_REG = 7,
    #[doc = "< shift with register"]
    ARM_SFT_LSR_REG = 8,
    #[doc = "< shift with register"]
    ARM_SFT_ROR_REG = 9,
    #[doc = "< shift with register"]
    ARM_SFT_RRX_REG = 10,
}
#[repr(u32)]
#[doc = " ARM condition code"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_cc {
    ARM_CC_INVALID = 0,
    #[doc = "< Equal                      Equal"]
    ARM_CC_EQ = 1,
    #[doc = "< Not equal                  Not equal, or unordered"]
    ARM_CC_NE = 2,
    #[doc = "< Carry set                  >, ==, or unordered"]
    ARM_CC_HS = 3,
    #[doc = "< Carry clear                Less than"]
    ARM_CC_LO = 4,
    #[doc = "< Minus, negative            Less than"]
    ARM_CC_MI = 5,
    #[doc = "< Plus, positive or zero     >, ==, or unordered"]
    ARM_CC_PL = 6,
    #[doc = "< Overflow                   Unordered"]
    ARM_CC_VS = 7,
    #[doc = "< No overflow                Not unordered"]
    ARM_CC_VC = 8,
    #[doc = "< Unsigned higher            Greater than, or unordered"]
    ARM_CC_HI = 9,
    #[doc = "< Unsigned lower or same     Less than or equal"]
    ARM_CC_LS = 10,
    #[doc = "< Greater than or equal      Greater than or equal"]
    ARM_CC_GE = 11,
    #[doc = "< Less than                  Less than, or unordered"]
    ARM_CC_LT = 12,
    #[doc = "< Greater than               Greater than"]
    ARM_CC_GT = 13,
    #[doc = "< Less than or equal         <, ==, or unordered"]
    ARM_CC_LE = 14,
    #[doc = "< Always (unconditional)     Always (unconditional)"]
    ARM_CC_AL = 15,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_sysreg {
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_INVALID = 0,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_C = 1,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_X = 2,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_S = 4,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_F = 8,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_C = 16,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_X = 32,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_S = 64,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CPSR_F = 128,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR = 256,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR_G = 257,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR_NZCVQ = 258,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_APSR_NZCVQG = 259,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR = 260,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR_G = 261,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR_NZCVQG = 262,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IAPSR_NZCVQ = 263,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR = 264,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR_G = 265,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR_NZCVQG = 266,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EAPSR_NZCVQ = 267,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR = 268,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR_G = 269,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR_NZCVQG = 270,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_XPSR_NZCVQ = 271,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IPSR = 272,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_EPSR = 273,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_IEPSR = 274,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_MSP = 275,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PSP = 276,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PRIMASK = 277,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_BASEPRI = 278,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_BASEPRI_MAX = 279,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_FAULTMASK = 280,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CONTROL = 281,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_MSPLIM = 282,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PSPLIM = 283,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_MSP_NS = 284,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PSP_NS = 285,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_MSPLIM_NS = 286,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PSPLIM_NS = 287,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_PRIMASK_NS = 288,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_BASEPRI_NS = 289,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_FAULTMASK_NS = 290,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_CONTROL_NS = 291,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_NS = 292,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R8_USR = 293,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R9_USR = 294,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R10_USR = 295,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R11_USR = 296,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R12_USR = 297,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_USR = 298,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_USR = 299,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R8_FIQ = 300,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R9_FIQ = 301,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R10_FIQ = 302,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R11_FIQ = 303,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_R12_FIQ = 304,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_FIQ = 305,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_FIQ = 306,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_IRQ = 307,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_IRQ = 308,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_SVC = 309,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_SVC = 310,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_ABT = 311,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_ABT = 312,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_UND = 313,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_UND = 314,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_LR_MON = 315,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_MON = 316,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_ELR_HYP = 317,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SP_HYP = 318,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_FIQ = 319,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_IRQ = 320,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_SVC = 321,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_ABT = 322,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_UND = 323,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_MON = 324,
    #[doc = " Special registers for MSR"]
    ARM_SYSREG_SPSR_HYP = 325,
}
#[repr(u32)]
#[doc = " The memory barrier constants map directly to the 4-bit encoding of"]
#[doc = " the option field for Memory Barrier operations."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_mem_barrier {
    ARM_MB_INVALID = 0,
    ARM_MB_RESERVED_0 = 1,
    ARM_MB_OSHLD = 2,
    ARM_MB_OSHST = 3,
    ARM_MB_OSH = 4,
    ARM_MB_RESERVED_4 = 5,
    ARM_MB_NSHLD = 6,
    ARM_MB_NSHST = 7,
    ARM_MB_NSH = 8,
    ARM_MB_RESERVED_8 = 9,
    ARM_MB_ISHLD = 10,
    ARM_MB_ISHST = 11,
    ARM_MB_ISH = 12,
    ARM_MB_RESERVED_12 = 13,
    ARM_MB_LD = 14,
    ARM_MB_ST = 15,
    ARM_MB_SY = 16,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    ARM_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    ARM_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    ARM_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    ARM_OP_MEM = 3,
    #[doc = "< = CS_OP_FP (Floating-Point operand)."]
    ARM_OP_FP = 4,
    #[doc = "< C-Immediate (coprocessor registers)"]
    ARM_OP_CIMM = 64,
    #[doc = "< P-Immediate (coprocessor registers)"]
    ARM_OP_PIMM = 65,
    #[doc = "< operand for SETEND instruction"]
    ARM_OP_SETEND = 66,
    #[doc = "< MSR/MRS special register operand"]
    ARM_OP_SYSREG = 67,
}
#[repr(u32)]
#[doc = " Operand type for SETEND instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_setend_type {
    #[doc = "< Uninitialized."]
    ARM_SETEND_INVALID = 0,
    #[doc = "< BE operand."]
    ARM_SETEND_BE = 1,
    #[doc = "< LE operand"]
    ARM_SETEND_LE = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_cpsmode_type {
    ARM_CPSMODE_INVALID = 0,
    ARM_CPSMODE_IE = 2,
    ARM_CPSMODE_ID = 3,
}
#[repr(u32)]
#[doc = " Operand type for SETEND instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_cpsflag_type {
    ARM_CPSFLAG_INVALID = 0,
    ARM_CPSFLAG_F = 1,
    ARM_CPSFLAG_I = 2,
    ARM_CPSFLAG_A = 4,
    #[doc = "< no flag"]
    ARM_CPSFLAG_NONE = 16,
}
#[repr(u32)]
#[doc = " Data type for elements of vector instructions."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_vectordata_type {
    ARM_VECTORDATA_INVALID = 0,
    ARM_VECTORDATA_I8 = 1,
    ARM_VECTORDATA_I16 = 2,
    ARM_VECTORDATA_I32 = 3,
    ARM_VECTORDATA_I64 = 4,
    ARM_VECTORDATA_S8 = 5,
    ARM_VECTORDATA_S16 = 6,
    ARM_VECTORDATA_S32 = 7,
    ARM_VECTORDATA_S64 = 8,
    ARM_VECTORDATA_U8 = 9,
    ARM_VECTORDATA_U16 = 10,
    ARM_VECTORDATA_U32 = 11,
    ARM_VECTORDATA_U64 = 12,
    ARM_VECTORDATA_P8 = 13,
    ARM_VECTORDATA_F16 = 14,
    ARM_VECTORDATA_F32 = 15,
    ARM_VECTORDATA_F64 = 16,
    ARM_VECTORDATA_F16F64 = 17,
    ARM_VECTORDATA_F64F16 = 18,
    ARM_VECTORDATA_F32F16 = 19,
    ARM_VECTORDATA_F16F32 = 20,
    ARM_VECTORDATA_F64F32 = 21,
    ARM_VECTORDATA_F32F64 = 22,
    ARM_VECTORDATA_S32F32 = 23,
    ARM_VECTORDATA_U32F32 = 24,
    ARM_VECTORDATA_F32S32 = 25,
    ARM_VECTORDATA_F32U32 = 26,
    ARM_VECTORDATA_F64S16 = 27,
    ARM_VECTORDATA_F32S16 = 28,
    ARM_VECTORDATA_F64S32 = 29,
    ARM_VECTORDATA_S16F64 = 30,
    ARM_VECTORDATA_S16F32 = 31,
    ARM_VECTORDATA_S32F64 = 32,
    ARM_VECTORDATA_U16F64 = 33,
    ARM_VECTORDATA_U16F32 = 34,
    ARM_VECTORDATA_U32F64 = 35,
    ARM_VECTORDATA_F64U16 = 36,
    ARM_VECTORDATA_F32U16 = 37,
    ARM_VECTORDATA_F64U32 = 38,
    ARM_VECTORDATA_F16U16 = 39,
    ARM_VECTORDATA_U16F16 = 40,
    ARM_VECTORDATA_F16U32 = 41,
    ARM_VECTORDATA_U32F16 = 42,
}
pub mod arm_reg {
    #[doc = " ARM registers"]
    pub type Type = libc::c_uint;
    pub const ARM_REG_INVALID: Type = 0;
    pub const ARM_REG_APSR: Type = 1;
    pub const ARM_REG_APSR_NZCV: Type = 2;
    pub const ARM_REG_CPSR: Type = 3;
    pub const ARM_REG_FPEXC: Type = 4;
    pub const ARM_REG_FPINST: Type = 5;
    pub const ARM_REG_FPSCR: Type = 6;
    pub const ARM_REG_FPSCR_NZCV: Type = 7;
    pub const ARM_REG_FPSID: Type = 8;
    pub const ARM_REG_ITSTATE: Type = 9;
    pub const ARM_REG_LR: Type = 10;
    pub const ARM_REG_PC: Type = 11;
    pub const ARM_REG_SP: Type = 12;
    pub const ARM_REG_SPSR: Type = 13;
    pub const ARM_REG_D0: Type = 14;
    pub const ARM_REG_D1: Type = 15;
    pub const ARM_REG_D2: Type = 16;
    pub const ARM_REG_D3: Type = 17;
    pub const ARM_REG_D4: Type = 18;
    pub const ARM_REG_D5: Type = 19;
    pub const ARM_REG_D6: Type = 20;
    pub const ARM_REG_D7: Type = 21;
    pub const ARM_REG_D8: Type = 22;
    pub const ARM_REG_D9: Type = 23;
    pub const ARM_REG_D10: Type = 24;
    pub const ARM_REG_D11: Type = 25;
    pub const ARM_REG_D12: Type = 26;
    pub const ARM_REG_D13: Type = 27;
    pub const ARM_REG_D14: Type = 28;
    pub const ARM_REG_D15: Type = 29;
    pub const ARM_REG_D16: Type = 30;
    pub const ARM_REG_D17: Type = 31;
    pub const ARM_REG_D18: Type = 32;
    pub const ARM_REG_D19: Type = 33;
    pub const ARM_REG_D20: Type = 34;
    pub const ARM_REG_D21: Type = 35;
    pub const ARM_REG_D22: Type = 36;
    pub const ARM_REG_D23: Type = 37;
    pub const ARM_REG_D24: Type = 38;
    pub const ARM_REG_D25: Type = 39;
    pub const ARM_REG_D26: Type = 40;
    pub const ARM_REG_D27: Type = 41;
    pub const ARM_REG_D28: Type = 42;
    pub const ARM_REG_D29: Type = 43;
    pub const ARM_REG_D30: Type = 44;
    pub const ARM_REG_D31: Type = 45;
    pub const ARM_REG_FPINST2: Type = 46;
    pub const ARM_REG_MVFR0: Type = 47;
    pub const ARM_REG_MVFR1: Type = 48;
    pub const ARM_REG_MVFR2: Type = 49;
    pub const ARM_REG_Q0: Type = 50;
    pub const ARM_REG_Q1: Type = 51;
    pub const ARM_REG_Q2: Type = 52;
    pub const ARM_REG_Q3: Type = 53;
    pub const ARM_REG_Q4: Type = 54;
    pub const ARM_REG_Q5: Type = 55;
    pub const ARM_REG_Q6: Type = 56;
    pub const ARM_REG_Q7: Type = 57;
    pub const ARM_REG_Q8: Type = 58;
    pub const ARM_REG_Q9: Type = 59;
    pub const ARM_REG_Q10: Type = 60;
    pub const ARM_REG_Q11: Type = 61;
    pub const ARM_REG_Q12: Type = 62;
    pub const ARM_REG_Q13: Type = 63;
    pub const ARM_REG_Q14: Type = 64;
    pub const ARM_REG_Q15: Type = 65;
    pub const ARM_REG_R0: Type = 66;
    pub const ARM_REG_R1: Type = 67;
    pub const ARM_REG_R2: Type = 68;
    pub const ARM_REG_R3: Type = 69;
    pub const ARM_REG_R4: Type = 70;
    pub const ARM_REG_R5: Type = 71;
    pub const ARM_REG_R6: Type = 72;
    pub const ARM_REG_R7: Type = 73;
    pub const ARM_REG_R8: Type = 74;
    pub const ARM_REG_R9: Type = 75;
    pub const ARM_REG_R10: Type = 76;
    pub const ARM_REG_R11: Type = 77;
    pub const ARM_REG_R12: Type = 78;
    pub const ARM_REG_S0: Type = 79;
    pub const ARM_REG_S1: Type = 80;
    pub const ARM_REG_S2: Type = 81;
    pub const ARM_REG_S3: Type = 82;
    pub const ARM_REG_S4: Type = 83;
    pub const ARM_REG_S5: Type = 84;
    pub const ARM_REG_S6: Type = 85;
    pub const ARM_REG_S7: Type = 86;
    pub const ARM_REG_S8: Type = 87;
    pub const ARM_REG_S9: Type = 88;
    pub const ARM_REG_S10: Type = 89;
    pub const ARM_REG_S11: Type = 90;
    pub const ARM_REG_S12: Type = 91;
    pub const ARM_REG_S13: Type = 92;
    pub const ARM_REG_S14: Type = 93;
    pub const ARM_REG_S15: Type = 94;
    pub const ARM_REG_S16: Type = 95;
    pub const ARM_REG_S17: Type = 96;
    pub const ARM_REG_S18: Type = 97;
    pub const ARM_REG_S19: Type = 98;
    pub const ARM_REG_S20: Type = 99;
    pub const ARM_REG_S21: Type = 100;
    pub const ARM_REG_S22: Type = 101;
    pub const ARM_REG_S23: Type = 102;
    pub const ARM_REG_S24: Type = 103;
    pub const ARM_REG_S25: Type = 104;
    pub const ARM_REG_S26: Type = 105;
    pub const ARM_REG_S27: Type = 106;
    pub const ARM_REG_S28: Type = 107;
    pub const ARM_REG_S29: Type = 108;
    pub const ARM_REG_S30: Type = 109;
    pub const ARM_REG_S31: Type = 110;
    pub const ARM_REG_ENDING: Type = 111;
    pub const ARM_REG_R13: Type = 12;
    pub const ARM_REG_R14: Type = 10;
    pub const ARM_REG_R15: Type = 11;
    pub const ARM_REG_SB: Type = 75;
    pub const ARM_REG_SL: Type = 76;
    pub const ARM_REG_FP: Type = 77;
    pub const ARM_REG_IP: Type = 78;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with ARM_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct arm_op_mem {
    #[doc = "< base register"]
    pub base: arm_reg::Type,
    #[doc = "< index register"]
    pub index: arm_reg::Type,
    #[doc = "< scale for index register (can be 1, or -1)"]
    pub scale: libc::c_int,
    #[doc = "< displacement/offset value"]
    pub disp: libc::c_int,
    #[doc = " left-shift on index register, or 0 if irrelevant"]
    #[doc = " NOTE: this value can also be fetched via operand.shift.value"]
    pub lshift: libc::c_int,
}
impl Clone for arm_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm_op {
    #[doc = "< Vector Index for some vector operands (or -1 if irrelevant)"]
    pub vector_index: libc::c_int,
    pub shift: cs_arm_op__bindgen_ty_1,
    #[doc = "< operand type"]
    pub type_: arm_op_type,
    pub __bindgen_anon_1: cs_arm_op__bindgen_ty_2,
    #[doc = " in some instructions, an operand can be subtracted or added to"]
    #[doc = " the base register,"]
    #[doc = " if TRUE, this operand is subtracted. otherwise, it is added."]
    pub subtracted: bool,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
    #[doc = " Neon lane index for NEON instructions (or -1 if irrelevant)"]
    pub neon_lane: i8,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_arm_op__bindgen_ty_1 {
    pub type_: arm_shifter,
    pub value: libc::c_uint,
}
impl Clone for cs_arm_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub union cs_arm_op__bindgen_ty_2 {
    #[doc = "< register value for REG/SYSREG operand"]
    pub reg: libc::c_int,
    #[doc = "< immediate value for C-IMM, P-IMM or IMM operand"]
    pub imm: i32,
    #[doc = "< floating point value for FP operand"]
    pub fp: f64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: arm_op_mem,
    #[doc = "< SETEND instruction's operand type"]
    pub setend: arm_setend_type,
}
impl Clone for cs_arm_op__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm_op__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_arm_op__bindgen_ty_2 {{ union }}")
    }
}
impl Clone for cs_arm_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_arm_op {{ vector_index: {:?}, shift: {:?}, type: {:?}, __bindgen_anon_1: {:?}, subtracted: {:?}, access: {:?}, neon_lane: {:?} }}" , self . vector_index , self . shift , self . type_ , self . __bindgen_anon_1 , self . subtracted , self . access , self . neon_lane)
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm {
    #[doc = "< User-mode registers to be loaded (for LDM/STM instructions)"]
    pub usermode: bool,
    #[doc = "< Scalar size for vector instructions"]
    pub vector_size: libc::c_int,
    #[doc = "< Data type for elements of vector instructions"]
    pub vector_data: arm_vectordata_type,
    #[doc = "< CPS mode for CPS instruction"]
    pub cps_mode: arm_cpsmode_type,
    #[doc = "< CPS mode for CPS instruction"]
    pub cps_flag: arm_cpsflag_type,
    #[doc = "< conditional code for this insn"]
    pub cc: arm_cc,
    #[doc = "< does this insn update flags?"]
    pub update_flags: bool,
    #[doc = "< does this insn write-back?"]
    pub writeback: bool,
    #[doc = "< Option for some memory barrier instructions"]
    pub mem_barrier: arm_mem_barrier,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_arm_op; 36usize],
}
impl Clone for cs_arm {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_arm {{ usermode: {:?}, vector_size: {:?}, vector_data: {:?}, cps_mode: {:?}, cps_flag: {:?}, cc: {:?}, update_flags: {:?}, writeback: {:?}, mem_barrier: {:?}, op_count: {:?}, operands: [...] }}" , self . usermode , self . vector_size , self . vector_data , self . cps_mode , self . cps_flag , self . cc , self . update_flags , self . writeback , self . mem_barrier , self . op_count)
    }
}
#[repr(u32)]
#[doc = " ARM instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm_insn {
    ARM_INS_INVALID = 0,
    ARM_INS_ADC = 1,
    ARM_INS_ADD = 2,
    ARM_INS_ADDW = 3,
    ARM_INS_ADR = 4,
    ARM_INS_AESD = 5,
    ARM_INS_AESE = 6,
    ARM_INS_AESIMC = 7,
    ARM_INS_AESMC = 8,
    ARM_INS_AND = 9,
    ARM_INS_ASR = 10,
    ARM_INS_B = 11,
    ARM_INS_BFC = 12,
    ARM_INS_BFI = 13,
    ARM_INS_BIC = 14,
    ARM_INS_BKPT = 15,
    ARM_INS_BL = 16,
    ARM_INS_BLX = 17,
    ARM_INS_BLXNS = 18,
    ARM_INS_BX = 19,
    ARM_INS_BXJ = 20,
    ARM_INS_BXNS = 21,
    ARM_INS_CBNZ = 22,
    ARM_INS_CBZ = 23,
    ARM_INS_CDP = 24,
    ARM_INS_CDP2 = 25,
    ARM_INS_CLREX = 26,
    ARM_INS_CLZ = 27,
    ARM_INS_CMN = 28,
    ARM_INS_CMP = 29,
    ARM_INS_CPS = 30,
    ARM_INS_CRC32B = 31,
    ARM_INS_CRC32CB = 32,
    ARM_INS_CRC32CH = 33,
    ARM_INS_CRC32CW = 34,
    ARM_INS_CRC32H = 35,
    ARM_INS_CRC32W = 36,
    ARM_INS_CSDB = 37,
    ARM_INS_DBG = 38,
    ARM_INS_DCPS1 = 39,
    ARM_INS_DCPS2 = 40,
    ARM_INS_DCPS3 = 41,
    ARM_INS_DFB = 42,
    ARM_INS_DMB = 43,
    ARM_INS_DSB = 44,
    ARM_INS_EOR = 45,
    ARM_INS_ERET = 46,
    ARM_INS_ESB = 47,
    ARM_INS_FADDD = 48,
    ARM_INS_FADDS = 49,
    ARM_INS_FCMPZD = 50,
    ARM_INS_FCMPZS = 51,
    ARM_INS_FCONSTD = 52,
    ARM_INS_FCONSTS = 53,
    ARM_INS_FLDMDBX = 54,
    ARM_INS_FLDMIAX = 55,
    ARM_INS_FMDHR = 56,
    ARM_INS_FMDLR = 57,
    ARM_INS_FMSTAT = 58,
    ARM_INS_FSTMDBX = 59,
    ARM_INS_FSTMIAX = 60,
    ARM_INS_FSUBD = 61,
    ARM_INS_FSUBS = 62,
    ARM_INS_HINT = 63,
    ARM_INS_HLT = 64,
    ARM_INS_HVC = 65,
    ARM_INS_ISB = 66,
    ARM_INS_IT = 67,
    ARM_INS_LDA = 68,
    ARM_INS_LDAB = 69,
    ARM_INS_LDAEX = 70,
    ARM_INS_LDAEXB = 71,
    ARM_INS_LDAEXD = 72,
    ARM_INS_LDAEXH = 73,
    ARM_INS_LDAH = 74,
    ARM_INS_LDC = 75,
    ARM_INS_LDC2 = 76,
    ARM_INS_LDC2L = 77,
    ARM_INS_LDCL = 78,
    ARM_INS_LDM = 79,
    ARM_INS_LDMDA = 80,
    ARM_INS_LDMDB = 81,
    ARM_INS_LDMIB = 82,
    ARM_INS_LDR = 83,
    ARM_INS_LDRB = 84,
    ARM_INS_LDRBT = 85,
    ARM_INS_LDRD = 86,
    ARM_INS_LDREX = 87,
    ARM_INS_LDREXB = 88,
    ARM_INS_LDREXD = 89,
    ARM_INS_LDREXH = 90,
    ARM_INS_LDRH = 91,
    ARM_INS_LDRHT = 92,
    ARM_INS_LDRSB = 93,
    ARM_INS_LDRSBT = 94,
    ARM_INS_LDRSH = 95,
    ARM_INS_LDRSHT = 96,
    ARM_INS_LDRT = 97,
    ARM_INS_LSL = 98,
    ARM_INS_LSR = 99,
    ARM_INS_MCR = 100,
    ARM_INS_MCR2 = 101,
    ARM_INS_MCRR = 102,
    ARM_INS_MCRR2 = 103,
    ARM_INS_MLA = 104,
    ARM_INS_MLS = 105,
    ARM_INS_MOV = 106,
    ARM_INS_MOVS = 107,
    ARM_INS_MOVT = 108,
    ARM_INS_MOVW = 109,
    ARM_INS_MRC = 110,
    ARM_INS_MRC2 = 111,
    ARM_INS_MRRC = 112,
    ARM_INS_MRRC2 = 113,
    ARM_INS_MRS = 114,
    ARM_INS_MSR = 115,
    ARM_INS_MUL = 116,
    ARM_INS_MVN = 117,
    ARM_INS_NEG = 118,
    ARM_INS_NOP = 119,
    ARM_INS_ORN = 120,
    ARM_INS_ORR = 121,
    ARM_INS_PKHBT = 122,
    ARM_INS_PKHTB = 123,
    ARM_INS_PLD = 124,
    ARM_INS_PLDW = 125,
    ARM_INS_PLI = 126,
    ARM_INS_POP = 127,
    ARM_INS_PUSH = 128,
    ARM_INS_QADD = 129,
    ARM_INS_QADD16 = 130,
    ARM_INS_QADD8 = 131,
    ARM_INS_QASX = 132,
    ARM_INS_QDADD = 133,
    ARM_INS_QDSUB = 134,
    ARM_INS_QSAX = 135,
    ARM_INS_QSUB = 136,
    ARM_INS_QSUB16 = 137,
    ARM_INS_QSUB8 = 138,
    ARM_INS_RBIT = 139,
    ARM_INS_REV = 140,
    ARM_INS_REV16 = 141,
    ARM_INS_REVSH = 142,
    ARM_INS_RFEDA = 143,
    ARM_INS_RFEDB = 144,
    ARM_INS_RFEIA = 145,
    ARM_INS_RFEIB = 146,
    ARM_INS_ROR = 147,
    ARM_INS_RRX = 148,
    ARM_INS_RSB = 149,
    ARM_INS_RSC = 150,
    ARM_INS_SADD16 = 151,
    ARM_INS_SADD8 = 152,
    ARM_INS_SASX = 153,
    ARM_INS_SBC = 154,
    ARM_INS_SBFX = 155,
    ARM_INS_SDIV = 156,
    ARM_INS_SEL = 157,
    ARM_INS_SETEND = 158,
    ARM_INS_SETPAN = 159,
    ARM_INS_SEV = 160,
    ARM_INS_SEVL = 161,
    ARM_INS_SG = 162,
    ARM_INS_SHA1C = 163,
    ARM_INS_SHA1H = 164,
    ARM_INS_SHA1M = 165,
    ARM_INS_SHA1P = 166,
    ARM_INS_SHA1SU0 = 167,
    ARM_INS_SHA1SU1 = 168,
    ARM_INS_SHA256H = 169,
    ARM_INS_SHA256H2 = 170,
    ARM_INS_SHA256SU0 = 171,
    ARM_INS_SHA256SU1 = 172,
    ARM_INS_SHADD16 = 173,
    ARM_INS_SHADD8 = 174,
    ARM_INS_SHASX = 175,
    ARM_INS_SHSAX = 176,
    ARM_INS_SHSUB16 = 177,
    ARM_INS_SHSUB8 = 178,
    ARM_INS_SMC = 179,
    ARM_INS_SMLABB = 180,
    ARM_INS_SMLABT = 181,
    ARM_INS_SMLAD = 182,
    ARM_INS_SMLADX = 183,
    ARM_INS_SMLAL = 184,
    ARM_INS_SMLALBB = 185,
    ARM_INS_SMLALBT = 186,
    ARM_INS_SMLALD = 187,
    ARM_INS_SMLALDX = 188,
    ARM_INS_SMLALTB = 189,
    ARM_INS_SMLALTT = 190,
    ARM_INS_SMLATB = 191,
    ARM_INS_SMLATT = 192,
    ARM_INS_SMLAWB = 193,
    ARM_INS_SMLAWT = 194,
    ARM_INS_SMLSD = 195,
    ARM_INS_SMLSDX = 196,
    ARM_INS_SMLSLD = 197,
    ARM_INS_SMLSLDX = 198,
    ARM_INS_SMMLA = 199,
    ARM_INS_SMMLAR = 200,
    ARM_INS_SMMLS = 201,
    ARM_INS_SMMLSR = 202,
    ARM_INS_SMMUL = 203,
    ARM_INS_SMMULR = 204,
    ARM_INS_SMUAD = 205,
    ARM_INS_SMUADX = 206,
    ARM_INS_SMULBB = 207,
    ARM_INS_SMULBT = 208,
    ARM_INS_SMULL = 209,
    ARM_INS_SMULTB = 210,
    ARM_INS_SMULTT = 211,
    ARM_INS_SMULWB = 212,
    ARM_INS_SMULWT = 213,
    ARM_INS_SMUSD = 214,
    ARM_INS_SMUSDX = 215,
    ARM_INS_SRSDA = 216,
    ARM_INS_SRSDB = 217,
    ARM_INS_SRSIA = 218,
    ARM_INS_SRSIB = 219,
    ARM_INS_SSAT = 220,
    ARM_INS_SSAT16 = 221,
    ARM_INS_SSAX = 222,
    ARM_INS_SSUB16 = 223,
    ARM_INS_SSUB8 = 224,
    ARM_INS_STC = 225,
    ARM_INS_STC2 = 226,
    ARM_INS_STC2L = 227,
    ARM_INS_STCL = 228,
    ARM_INS_STL = 229,
    ARM_INS_STLB = 230,
    ARM_INS_STLEX = 231,
    ARM_INS_STLEXB = 232,
    ARM_INS_STLEXD = 233,
    ARM_INS_STLEXH = 234,
    ARM_INS_STLH = 235,
    ARM_INS_STM = 236,
    ARM_INS_STMDA = 237,
    ARM_INS_STMDB = 238,
    ARM_INS_STMIB = 239,
    ARM_INS_STR = 240,
    ARM_INS_STRB = 241,
    ARM_INS_STRBT = 242,
    ARM_INS_STRD = 243,
    ARM_INS_STREX = 244,
    ARM_INS_STREXB = 245,
    ARM_INS_STREXD = 246,
    ARM_INS_STREXH = 247,
    ARM_INS_STRH = 248,
    ARM_INS_STRHT = 249,
    ARM_INS_STRT = 250,
    ARM_INS_SUB = 251,
    ARM_INS_SUBS = 252,
    ARM_INS_SUBW = 253,
    ARM_INS_SVC = 254,
    ARM_INS_SWP = 255,
    ARM_INS_SWPB = 256,
    ARM_INS_SXTAB = 257,
    ARM_INS_SXTAB16 = 258,
    ARM_INS_SXTAH = 259,
    ARM_INS_SXTB = 260,
    ARM_INS_SXTB16 = 261,
    ARM_INS_SXTH = 262,
    ARM_INS_TBB = 263,
    ARM_INS_TBH = 264,
    ARM_INS_TEQ = 265,
    ARM_INS_TRAP = 266,
    ARM_INS_TSB = 267,
    ARM_INS_TST = 268,
    ARM_INS_TT = 269,
    ARM_INS_TTA = 270,
    ARM_INS_TTAT = 271,
    ARM_INS_TTT = 272,
    ARM_INS_UADD16 = 273,
    ARM_INS_UADD8 = 274,
    ARM_INS_UASX = 275,
    ARM_INS_UBFX = 276,
    ARM_INS_UDF = 277,
    ARM_INS_UDIV = 278,
    ARM_INS_UHADD16 = 279,
    ARM_INS_UHADD8 = 280,
    ARM_INS_UHASX = 281,
    ARM_INS_UHSAX = 282,
    ARM_INS_UHSUB16 = 283,
    ARM_INS_UHSUB8 = 284,
    ARM_INS_UMAAL = 285,
    ARM_INS_UMLAL = 286,
    ARM_INS_UMULL = 287,
    ARM_INS_UQADD16 = 288,
    ARM_INS_UQADD8 = 289,
    ARM_INS_UQASX = 290,
    ARM_INS_UQSAX = 291,
    ARM_INS_UQSUB16 = 292,
    ARM_INS_UQSUB8 = 293,
    ARM_INS_USAD8 = 294,
    ARM_INS_USADA8 = 295,
    ARM_INS_USAT = 296,
    ARM_INS_USAT16 = 297,
    ARM_INS_USAX = 298,
    ARM_INS_USUB16 = 299,
    ARM_INS_USUB8 = 300,
    ARM_INS_UXTAB = 301,
    ARM_INS_UXTAB16 = 302,
    ARM_INS_UXTAH = 303,
    ARM_INS_UXTB = 304,
    ARM_INS_UXTB16 = 305,
    ARM_INS_UXTH = 306,
    ARM_INS_VABA = 307,
    ARM_INS_VABAL = 308,
    ARM_INS_VABD = 309,
    ARM_INS_VABDL = 310,
    ARM_INS_VABS = 311,
    ARM_INS_VACGE = 312,
    ARM_INS_VACGT = 313,
    ARM_INS_VACLE = 314,
    ARM_INS_VACLT = 315,
    ARM_INS_VADD = 316,
    ARM_INS_VADDHN = 317,
    ARM_INS_VADDL = 318,
    ARM_INS_VADDW = 319,
    ARM_INS_VAND = 320,
    ARM_INS_VBIC = 321,
    ARM_INS_VBIF = 322,
    ARM_INS_VBIT = 323,
    ARM_INS_VBSL = 324,
    ARM_INS_VCADD = 325,
    ARM_INS_VCEQ = 326,
    ARM_INS_VCGE = 327,
    ARM_INS_VCGT = 328,
    ARM_INS_VCLE = 329,
    ARM_INS_VCLS = 330,
    ARM_INS_VCLT = 331,
    ARM_INS_VCLZ = 332,
    ARM_INS_VCMLA = 333,
    ARM_INS_VCMP = 334,
    ARM_INS_VCMPE = 335,
    ARM_INS_VCNT = 336,
    ARM_INS_VCVT = 337,
    ARM_INS_VCVTA = 338,
    ARM_INS_VCVTB = 339,
    ARM_INS_VCVTM = 340,
    ARM_INS_VCVTN = 341,
    ARM_INS_VCVTP = 342,
    ARM_INS_VCVTR = 343,
    ARM_INS_VCVTT = 344,
    ARM_INS_VDIV = 345,
    ARM_INS_VDUP = 346,
    ARM_INS_VEOR = 347,
    ARM_INS_VEXT = 348,
    ARM_INS_VFMA = 349,
    ARM_INS_VFMS = 350,
    ARM_INS_VFNMA = 351,
    ARM_INS_VFNMS = 352,
    ARM_INS_VHADD = 353,
    ARM_INS_VHSUB = 354,
    ARM_INS_VINS = 355,
    ARM_INS_VJCVT = 356,
    ARM_INS_VLD1 = 357,
    ARM_INS_VLD2 = 358,
    ARM_INS_VLD3 = 359,
    ARM_INS_VLD4 = 360,
    ARM_INS_VLDMDB = 361,
    ARM_INS_VLDMIA = 362,
    ARM_INS_VLDR = 363,
    ARM_INS_VLLDM = 364,
    ARM_INS_VLSTM = 365,
    ARM_INS_VMAX = 366,
    ARM_INS_VMAXNM = 367,
    ARM_INS_VMIN = 368,
    ARM_INS_VMINNM = 369,
    ARM_INS_VMLA = 370,
    ARM_INS_VMLAL = 371,
    ARM_INS_VMLS = 372,
    ARM_INS_VMLSL = 373,
    ARM_INS_VMOV = 374,
    ARM_INS_VMOVL = 375,
    ARM_INS_VMOVN = 376,
    ARM_INS_VMOVX = 377,
    ARM_INS_VMRS = 378,
    ARM_INS_VMSR = 379,
    ARM_INS_VMUL = 380,
    ARM_INS_VMULL = 381,
    ARM_INS_VMVN = 382,
    ARM_INS_VNEG = 383,
    ARM_INS_VNMLA = 384,
    ARM_INS_VNMLS = 385,
    ARM_INS_VNMUL = 386,
    ARM_INS_VORN = 387,
    ARM_INS_VORR = 388,
    ARM_INS_VPADAL = 389,
    ARM_INS_VPADD = 390,
    ARM_INS_VPADDL = 391,
    ARM_INS_VPMAX = 392,
    ARM_INS_VPMIN = 393,
    ARM_INS_VPOP = 394,
    ARM_INS_VPUSH = 395,
    ARM_INS_VQABS = 396,
    ARM_INS_VQADD = 397,
    ARM_INS_VQDMLAL = 398,
    ARM_INS_VQDMLSL = 399,
    ARM_INS_VQDMULH = 400,
    ARM_INS_VQDMULL = 401,
    ARM_INS_VQMOVN = 402,
    ARM_INS_VQMOVUN = 403,
    ARM_INS_VQNEG = 404,
    ARM_INS_VQRDMLAH = 405,
    ARM_INS_VQRDMLSH = 406,
    ARM_INS_VQRDMULH = 407,
    ARM_INS_VQRSHL = 408,
    ARM_INS_VQRSHRN = 409,
    ARM_INS_VQRSHRUN = 410,
    ARM_INS_VQSHL = 411,
    ARM_INS_VQSHLU = 412,
    ARM_INS_VQSHRN = 413,
    ARM_INS_VQSHRUN = 414,
    ARM_INS_VQSUB = 415,
    ARM_INS_VRADDHN = 416,
    ARM_INS_VRECPE = 417,
    ARM_INS_VRECPS = 418,
    ARM_INS_VREV16 = 419,
    ARM_INS_VREV32 = 420,
    ARM_INS_VREV64 = 421,
    ARM_INS_VRHADD = 422,
    ARM_INS_VRINTA = 423,
    ARM_INS_VRINTM = 424,
    ARM_INS_VRINTN = 425,
    ARM_INS_VRINTP = 426,
    ARM_INS_VRINTR = 427,
    ARM_INS_VRINTX = 428,
    ARM_INS_VRINTZ = 429,
    ARM_INS_VRSHL = 430,
    ARM_INS_VRSHR = 431,
    ARM_INS_VRSHRN = 432,
    ARM_INS_VRSQRTE = 433,
    ARM_INS_VRSQRTS = 434,
    ARM_INS_VRSRA = 435,
    ARM_INS_VRSUBHN = 436,
    ARM_INS_VSDOT = 437,
    ARM_INS_VSELEQ = 438,
    ARM_INS_VSELGE = 439,
    ARM_INS_VSELGT = 440,
    ARM_INS_VSELVS = 441,
    ARM_INS_VSHL = 442,
    ARM_INS_VSHLL = 443,
    ARM_INS_VSHR = 444,
    ARM_INS_VSHRN = 445,
    ARM_INS_VSLI = 446,
    ARM_INS_VSQRT = 447,
    ARM_INS_VSRA = 448,
    ARM_INS_VSRI = 449,
    ARM_INS_VST1 = 450,
    ARM_INS_VST2 = 451,
    ARM_INS_VST3 = 452,
    ARM_INS_VST4 = 453,
    ARM_INS_VSTMDB = 454,
    ARM_INS_VSTMIA = 455,
    ARM_INS_VSTR = 456,
    ARM_INS_VSUB = 457,
    ARM_INS_VSUBHN = 458,
    ARM_INS_VSUBL = 459,
    ARM_INS_VSUBW = 460,
    ARM_INS_VSWP = 461,
    ARM_INS_VTBL = 462,
    ARM_INS_VTBX = 463,
    ARM_INS_VTRN = 464,
    ARM_INS_VTST = 465,
    ARM_INS_VUDOT = 466,
    ARM_INS_VUZP = 467,
    ARM_INS_VZIP = 468,
    ARM_INS_WFE = 469,
    ARM_INS_WFI = 470,
    ARM_INS_YIELD = 471,
    ARM_INS_ENDING = 472,
}
pub mod arm_insn_group {
    #[doc = " Group of ARM instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const ARM_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const ARM_GRP_JUMP: Type = 1;
    #[doc = "< = CS_GRP_CALL"]
    pub const ARM_GRP_CALL: Type = 2;
    #[doc = "< = CS_GRP_INT"]
    pub const ARM_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const ARM_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const ARM_GRP_BRANCH_RELATIVE: Type = 7;
    pub const ARM_GRP_CRYPTO: Type = 128;
    pub const ARM_GRP_DATABARRIER: Type = 129;
    pub const ARM_GRP_DIVIDE: Type = 130;
    pub const ARM_GRP_FPARMV8: Type = 131;
    pub const ARM_GRP_MULTPRO: Type = 132;
    pub const ARM_GRP_NEON: Type = 133;
    pub const ARM_GRP_T2EXTRACTPACK: Type = 134;
    pub const ARM_GRP_THUMB2DSP: Type = 135;
    pub const ARM_GRP_TRUSTZONE: Type = 136;
    pub const ARM_GRP_V4T: Type = 137;
    pub const ARM_GRP_V5T: Type = 138;
    pub const ARM_GRP_V5TE: Type = 139;
    pub const ARM_GRP_V6: Type = 140;
    pub const ARM_GRP_V6T2: Type = 141;
    pub const ARM_GRP_V7: Type = 142;
    pub const ARM_GRP_V8: Type = 143;
    pub const ARM_GRP_VFP2: Type = 144;
    pub const ARM_GRP_VFP3: Type = 145;
    pub const ARM_GRP_VFP4: Type = 146;
    pub const ARM_GRP_ARM: Type = 147;
    pub const ARM_GRP_MCLASS: Type = 148;
    pub const ARM_GRP_NOTMCLASS: Type = 149;
    pub const ARM_GRP_THUMB: Type = 150;
    pub const ARM_GRP_THUMB1ONLY: Type = 151;
    pub const ARM_GRP_THUMB2: Type = 152;
    pub const ARM_GRP_PREV8: Type = 153;
    pub const ARM_GRP_FPVMLX: Type = 154;
    pub const ARM_GRP_MULOPS: Type = 155;
    pub const ARM_GRP_CRC: Type = 156;
    pub const ARM_GRP_DPVFP: Type = 157;
    pub const ARM_GRP_V6M: Type = 158;
    pub const ARM_GRP_VIRTUALIZATION: Type = 159;
    pub const ARM_GRP_ENDING: Type = 160;
}
#[repr(u32)]
#[doc = " ARM64 shift type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_shifter {
    ARM64_SFT_INVALID = 0,
    ARM64_SFT_LSL = 1,
    ARM64_SFT_MSL = 2,
    ARM64_SFT_LSR = 3,
    ARM64_SFT_ASR = 4,
    ARM64_SFT_ROR = 5,
}
#[repr(u32)]
#[doc = " ARM64 extender type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_extender {
    ARM64_EXT_INVALID = 0,
    ARM64_EXT_UXTB = 1,
    ARM64_EXT_UXTH = 2,
    ARM64_EXT_UXTW = 3,
    ARM64_EXT_UXTX = 4,
    ARM64_EXT_SXTB = 5,
    ARM64_EXT_SXTH = 6,
    ARM64_EXT_SXTW = 7,
    ARM64_EXT_SXTX = 8,
}
#[repr(u32)]
#[doc = " ARM64 condition code"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_cc {
    ARM64_CC_INVALID = 0,
    #[doc = "< Equal"]
    ARM64_CC_EQ = 1,
    #[doc = "< Not equal:                 Not equal, or unordered"]
    ARM64_CC_NE = 2,
    #[doc = "< Unsigned higher or same:   >, ==, or unordered"]
    ARM64_CC_HS = 3,
    #[doc = "< Unsigned lower or same:    Less than"]
    ARM64_CC_LO = 4,
    #[doc = "< Minus, negative:           Less than"]
    ARM64_CC_MI = 5,
    #[doc = "< Plus, positive or zero:    >, ==, or unordered"]
    ARM64_CC_PL = 6,
    #[doc = "< Overflow:                  Unordered"]
    ARM64_CC_VS = 7,
    #[doc = "< No overflow:               Ordered"]
    ARM64_CC_VC = 8,
    #[doc = "< Unsigned higher:           Greater than, or unordered"]
    ARM64_CC_HI = 9,
    #[doc = "< Unsigned lower or same:    Less than or equal"]
    ARM64_CC_LS = 10,
    #[doc = "< Greater than or equal:     Greater than or equal"]
    ARM64_CC_GE = 11,
    #[doc = "< Less than:                 Less than, or unordered"]
    ARM64_CC_LT = 12,
    #[doc = "< Signed greater than:       Greater than"]
    ARM64_CC_GT = 13,
    #[doc = "< Signed less than or equal: <, ==, or unordered"]
    ARM64_CC_LE = 14,
    #[doc = "< Always (unconditional):    Always (unconditional)"]
    ARM64_CC_AL = 15,
    #[doc = "< Always (unconditional):   Always (unconditional)"]
    ARM64_CC_NV = 16,
}
pub const ARM64_SYSREG_DBGDTRTX_EL0: arm64_sysreg = arm64_sysreg::ARM64_SYSREG_DBGDTRRX_EL0;
#[repr(u32)]
#[doc = " System registers"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_sysreg {
    ARM64_SYSREG_INVALID = 0,
    ARM64_SYSREG_MDCCSR_EL0 = 38920,
    ARM64_SYSREG_DBGDTRRX_EL0 = 38952,
    ARM64_SYSREG_MDRAR_EL1 = 32896,
    ARM64_SYSREG_OSLSR_EL1 = 32908,
    ARM64_SYSREG_DBGAUTHSTATUS_EL1 = 33782,
    ARM64_SYSREG_PMCEID0_EL0 = 56550,
    ARM64_SYSREG_PMCEID1_EL0 = 56551,
    ARM64_SYSREG_MIDR_EL1 = 49152,
    ARM64_SYSREG_CCSIDR_EL1 = 51200,
    ARM64_SYSREG_CCSIDR2_EL1 = 51202,
    ARM64_SYSREG_CLIDR_EL1 = 51201,
    ARM64_SYSREG_CTR_EL0 = 55297,
    ARM64_SYSREG_MPIDR_EL1 = 49157,
    ARM64_SYSREG_REVIDR_EL1 = 49158,
    ARM64_SYSREG_AIDR_EL1 = 51207,
    ARM64_SYSREG_DCZID_EL0 = 55303,
    ARM64_SYSREG_ID_PFR0_EL1 = 49160,
    ARM64_SYSREG_ID_PFR1_EL1 = 49161,
    ARM64_SYSREG_ID_DFR0_EL1 = 49162,
    ARM64_SYSREG_ID_AFR0_EL1 = 49163,
    ARM64_SYSREG_ID_MMFR0_EL1 = 49164,
    ARM64_SYSREG_ID_MMFR1_EL1 = 49165,
    ARM64_SYSREG_ID_MMFR2_EL1 = 49166,
    ARM64_SYSREG_ID_MMFR3_EL1 = 49167,
    ARM64_SYSREG_ID_ISAR0_EL1 = 49168,
    ARM64_SYSREG_ID_ISAR1_EL1 = 49169,
    ARM64_SYSREG_ID_ISAR2_EL1 = 49170,
    ARM64_SYSREG_ID_ISAR3_EL1 = 49171,
    ARM64_SYSREG_ID_ISAR4_EL1 = 49172,
    ARM64_SYSREG_ID_ISAR5_EL1 = 49173,
    ARM64_SYSREG_ID_ISAR6_EL1 = 49175,
    ARM64_SYSREG_ID_AA64PFR0_EL1 = 49184,
    ARM64_SYSREG_ID_AA64PFR1_EL1 = 49185,
    ARM64_SYSREG_ID_AA64DFR0_EL1 = 49192,
    ARM64_SYSREG_ID_AA64DFR1_EL1 = 49193,
    ARM64_SYSREG_ID_AA64AFR0_EL1 = 49196,
    ARM64_SYSREG_ID_AA64AFR1_EL1 = 49197,
    ARM64_SYSREG_ID_AA64ISAR0_EL1 = 49200,
    ARM64_SYSREG_ID_AA64ISAR1_EL1 = 49201,
    ARM64_SYSREG_ID_AA64MMFR0_EL1 = 49208,
    ARM64_SYSREG_ID_AA64MMFR1_EL1 = 49209,
    ARM64_SYSREG_ID_AA64MMFR2_EL1 = 49210,
    ARM64_SYSREG_MVFR0_EL1 = 49176,
    ARM64_SYSREG_MVFR1_EL1 = 49177,
    ARM64_SYSREG_MVFR2_EL1 = 49178,
    ARM64_SYSREG_RVBAR_EL1 = 50689,
    ARM64_SYSREG_RVBAR_EL2 = 58881,
    ARM64_SYSREG_RVBAR_EL3 = 62977,
    ARM64_SYSREG_ISR_EL1 = 50696,
    ARM64_SYSREG_CNTPCT_EL0 = 57089,
    ARM64_SYSREG_CNTVCT_EL0 = 57090,
    ARM64_SYSREG_ID_MMFR4_EL1 = 49174,
    ARM64_SYSREG_TRCSTATR = 34840,
    ARM64_SYSREG_TRCIDR8 = 34822,
    ARM64_SYSREG_TRCIDR9 = 34830,
    ARM64_SYSREG_TRCIDR10 = 34838,
    ARM64_SYSREG_TRCIDR11 = 34846,
    ARM64_SYSREG_TRCIDR12 = 34854,
    ARM64_SYSREG_TRCIDR13 = 34862,
    ARM64_SYSREG_TRCIDR0 = 34887,
    ARM64_SYSREG_TRCIDR1 = 34895,
    ARM64_SYSREG_TRCIDR2 = 34903,
    ARM64_SYSREG_TRCIDR3 = 34911,
    ARM64_SYSREG_TRCIDR4 = 34919,
    ARM64_SYSREG_TRCIDR5 = 34927,
    ARM64_SYSREG_TRCIDR6 = 34935,
    ARM64_SYSREG_TRCIDR7 = 34943,
    ARM64_SYSREG_TRCOSLSR = 34956,
    ARM64_SYSREG_TRCPDSR = 34988,
    ARM64_SYSREG_TRCDEVAFF0 = 35798,
    ARM64_SYSREG_TRCDEVAFF1 = 35806,
    ARM64_SYSREG_TRCLSR = 35822,
    ARM64_SYSREG_TRCAUTHSTATUS = 35830,
    ARM64_SYSREG_TRCDEVARCH = 35838,
    ARM64_SYSREG_TRCDEVID = 35735,
    ARM64_SYSREG_TRCDEVTYPE = 35743,
    ARM64_SYSREG_TRCPIDR4 = 35751,
    ARM64_SYSREG_TRCPIDR5 = 35759,
    ARM64_SYSREG_TRCPIDR6 = 35767,
    ARM64_SYSREG_TRCPIDR7 = 35775,
    ARM64_SYSREG_TRCPIDR0 = 35783,
    ARM64_SYSREG_TRCPIDR1 = 35791,
    ARM64_SYSREG_TRCPIDR2 = 35799,
    ARM64_SYSREG_TRCPIDR3 = 35807,
    ARM64_SYSREG_TRCCIDR0 = 35815,
    ARM64_SYSREG_TRCCIDR1 = 35823,
    ARM64_SYSREG_TRCCIDR2 = 35831,
    ARM64_SYSREG_TRCCIDR3 = 35839,
    ARM64_SYSREG_ICC_IAR1_EL1 = 50784,
    ARM64_SYSREG_ICC_IAR0_EL1 = 50752,
    ARM64_SYSREG_ICC_HPPIR1_EL1 = 50786,
    ARM64_SYSREG_ICC_HPPIR0_EL1 = 50754,
    ARM64_SYSREG_ICC_RPR_EL1 = 50779,
    ARM64_SYSREG_ICH_VTR_EL2 = 58969,
    ARM64_SYSREG_ICH_EISR_EL2 = 58971,
    ARM64_SYSREG_ICH_ELRSR_EL2 = 58973,
    ARM64_SYSREG_ID_AA64ZFR0_EL1 = 49188,
    ARM64_SYSREG_LORID_EL1 = 50471,
    ARM64_SYSREG_ERRIDR_EL1 = 49816,
    ARM64_SYSREG_ERXFR_EL1 = 49824,
    ARM64_SYSREG_OSLAR_EL1 = 32900,
    ARM64_SYSREG_PMSWINC_EL0 = 56548,
    ARM64_SYSREG_TRCOSLAR = 34948,
    ARM64_SYSREG_TRCLAR = 35814,
    ARM64_SYSREG_ICC_EOIR1_EL1 = 50785,
    ARM64_SYSREG_ICC_EOIR0_EL1 = 50753,
    ARM64_SYSREG_ICC_DIR_EL1 = 50777,
    ARM64_SYSREG_ICC_SGI1R_EL1 = 50781,
    ARM64_SYSREG_ICC_ASGI1R_EL1 = 50782,
    ARM64_SYSREG_ICC_SGI0R_EL1 = 50783,
    ARM64_SYSREG_OSDTRRX_EL1 = 32770,
    ARM64_SYSREG_OSDTRTX_EL1 = 32794,
    ARM64_SYSREG_TEECR32_EL1 = 36864,
    ARM64_SYSREG_MDCCINT_EL1 = 32784,
    ARM64_SYSREG_MDSCR_EL1 = 32786,
    ARM64_SYSREG_DBGDTR_EL0 = 38944,
    ARM64_SYSREG_OSECCR_EL1 = 32818,
    ARM64_SYSREG_DBGVCR32_EL2 = 41016,
    ARM64_SYSREG_DBGBVR0_EL1 = 32772,
    ARM64_SYSREG_DBGBVR1_EL1 = 32780,
    ARM64_SYSREG_DBGBVR2_EL1 = 32788,
    ARM64_SYSREG_DBGBVR3_EL1 = 32796,
    ARM64_SYSREG_DBGBVR4_EL1 = 32804,
    ARM64_SYSREG_DBGBVR5_EL1 = 32812,
    ARM64_SYSREG_DBGBVR6_EL1 = 32820,
    ARM64_SYSREG_DBGBVR7_EL1 = 32828,
    ARM64_SYSREG_DBGBVR8_EL1 = 32836,
    ARM64_SYSREG_DBGBVR9_EL1 = 32844,
    ARM64_SYSREG_DBGBVR10_EL1 = 32852,
    ARM64_SYSREG_DBGBVR11_EL1 = 32860,
    ARM64_SYSREG_DBGBVR12_EL1 = 32868,
    ARM64_SYSREG_DBGBVR13_EL1 = 32876,
    ARM64_SYSREG_DBGBVR14_EL1 = 32884,
    ARM64_SYSREG_DBGBVR15_EL1 = 32892,
    ARM64_SYSREG_DBGBCR0_EL1 = 32773,
    ARM64_SYSREG_DBGBCR1_EL1 = 32781,
    ARM64_SYSREG_DBGBCR2_EL1 = 32789,
    ARM64_SYSREG_DBGBCR3_EL1 = 32797,
    ARM64_SYSREG_DBGBCR4_EL1 = 32805,
    ARM64_SYSREG_DBGBCR5_EL1 = 32813,
    ARM64_SYSREG_DBGBCR6_EL1 = 32821,
    ARM64_SYSREG_DBGBCR7_EL1 = 32829,
    ARM64_SYSREG_DBGBCR8_EL1 = 32837,
    ARM64_SYSREG_DBGBCR9_EL1 = 32845,
    ARM64_SYSREG_DBGBCR10_EL1 = 32853,
    ARM64_SYSREG_DBGBCR11_EL1 = 32861,
    ARM64_SYSREG_DBGBCR12_EL1 = 32869,
    ARM64_SYSREG_DBGBCR13_EL1 = 32877,
    ARM64_SYSREG_DBGBCR14_EL1 = 32885,
    ARM64_SYSREG_DBGBCR15_EL1 = 32893,
    ARM64_SYSREG_DBGWVR0_EL1 = 32774,
    ARM64_SYSREG_DBGWVR1_EL1 = 32782,
    ARM64_SYSREG_DBGWVR2_EL1 = 32790,
    ARM64_SYSREG_DBGWVR3_EL1 = 32798,
    ARM64_SYSREG_DBGWVR4_EL1 = 32806,
    ARM64_SYSREG_DBGWVR5_EL1 = 32814,
    ARM64_SYSREG_DBGWVR6_EL1 = 32822,
    ARM64_SYSREG_DBGWVR7_EL1 = 32830,
    ARM64_SYSREG_DBGWVR8_EL1 = 32838,
    ARM64_SYSREG_DBGWVR9_EL1 = 32846,
    ARM64_SYSREG_DBGWVR10_EL1 = 32854,
    ARM64_SYSREG_DBGWVR11_EL1 = 32862,
    ARM64_SYSREG_DBGWVR12_EL1 = 32870,
    ARM64_SYSREG_DBGWVR13_EL1 = 32878,
    ARM64_SYSREG_DBGWVR14_EL1 = 32886,
    ARM64_SYSREG_DBGWVR15_EL1 = 32894,
    ARM64_SYSREG_DBGWCR0_EL1 = 32775,
    ARM64_SYSREG_DBGWCR1_EL1 = 32783,
    ARM64_SYSREG_DBGWCR2_EL1 = 32791,
    ARM64_SYSREG_DBGWCR3_EL1 = 32799,
    ARM64_SYSREG_DBGWCR4_EL1 = 32807,
    ARM64_SYSREG_DBGWCR5_EL1 = 32815,
    ARM64_SYSREG_DBGWCR6_EL1 = 32823,
    ARM64_SYSREG_DBGWCR7_EL1 = 32831,
    ARM64_SYSREG_DBGWCR8_EL1 = 32839,
    ARM64_SYSREG_DBGWCR9_EL1 = 32847,
    ARM64_SYSREG_DBGWCR10_EL1 = 32855,
    ARM64_SYSREG_DBGWCR11_EL1 = 32863,
    ARM64_SYSREG_DBGWCR12_EL1 = 32871,
    ARM64_SYSREG_DBGWCR13_EL1 = 32879,
    ARM64_SYSREG_DBGWCR14_EL1 = 32887,
    ARM64_SYSREG_DBGWCR15_EL1 = 32895,
    ARM64_SYSREG_TEEHBR32_EL1 = 36992,
    ARM64_SYSREG_OSDLR_EL1 = 32924,
    ARM64_SYSREG_DBGPRCR_EL1 = 32932,
    ARM64_SYSREG_DBGCLAIMSET_EL1 = 33734,
    ARM64_SYSREG_DBGCLAIMCLR_EL1 = 33742,
    ARM64_SYSREG_CSSELR_EL1 = 53248,
    ARM64_SYSREG_VPIDR_EL2 = 57344,
    ARM64_SYSREG_VMPIDR_EL2 = 57349,
    ARM64_SYSREG_CPACR_EL1 = 49282,
    ARM64_SYSREG_SCTLR_EL1 = 49280,
    ARM64_SYSREG_SCTLR_EL2 = 57472,
    ARM64_SYSREG_SCTLR_EL3 = 61568,
    ARM64_SYSREG_ACTLR_EL1 = 49281,
    ARM64_SYSREG_ACTLR_EL2 = 57473,
    ARM64_SYSREG_ACTLR_EL3 = 61569,
    ARM64_SYSREG_HCR_EL2 = 57480,
    ARM64_SYSREG_SCR_EL3 = 61576,
    ARM64_SYSREG_MDCR_EL2 = 57481,
    ARM64_SYSREG_SDER32_EL3 = 61577,
    ARM64_SYSREG_CPTR_EL2 = 57482,
    ARM64_SYSREG_CPTR_EL3 = 61578,
    ARM64_SYSREG_HSTR_EL2 = 57483,
    ARM64_SYSREG_HACR_EL2 = 57487,
    ARM64_SYSREG_MDCR_EL3 = 61593,
    ARM64_SYSREG_TTBR0_EL1 = 49408,
    ARM64_SYSREG_TTBR0_EL2 = 57600,
    ARM64_SYSREG_TTBR0_EL3 = 61696,
    ARM64_SYSREG_TTBR1_EL1 = 49409,
    ARM64_SYSREG_TCR_EL1 = 49410,
    ARM64_SYSREG_TCR_EL2 = 57602,
    ARM64_SYSREG_TCR_EL3 = 61698,
    ARM64_SYSREG_VTTBR_EL2 = 57608,
    ARM64_SYSREG_VTCR_EL2 = 57610,
    ARM64_SYSREG_DACR32_EL2 = 57728,
    ARM64_SYSREG_SPSR_EL1 = 49664,
    ARM64_SYSREG_SPSR_EL2 = 57856,
    ARM64_SYSREG_SPSR_EL3 = 61952,
    ARM64_SYSREG_ELR_EL1 = 49665,
    ARM64_SYSREG_ELR_EL2 = 57857,
    ARM64_SYSREG_ELR_EL3 = 61953,
    ARM64_SYSREG_SP_EL0 = 49672,
    ARM64_SYSREG_SP_EL1 = 57864,
    ARM64_SYSREG_SP_EL2 = 61960,
    ARM64_SYSREG_SPSEL = 49680,
    ARM64_SYSREG_NZCV = 55824,
    ARM64_SYSREG_DAIF = 55825,
    ARM64_SYSREG_CURRENTEL = 49682,
    ARM64_SYSREG_SPSR_IRQ = 57880,
    ARM64_SYSREG_SPSR_ABT = 57881,
    ARM64_SYSREG_SPSR_UND = 57882,
    ARM64_SYSREG_SPSR_FIQ = 57883,
    ARM64_SYSREG_FPCR = 55840,
    ARM64_SYSREG_FPSR = 55841,
    ARM64_SYSREG_DSPSR_EL0 = 55848,
    ARM64_SYSREG_DLR_EL0 = 55849,
    ARM64_SYSREG_IFSR32_EL2 = 57985,
    ARM64_SYSREG_AFSR0_EL1 = 49800,
    ARM64_SYSREG_AFSR0_EL2 = 57992,
    ARM64_SYSREG_AFSR0_EL3 = 62088,
    ARM64_SYSREG_AFSR1_EL1 = 49801,
    ARM64_SYSREG_AFSR1_EL2 = 57993,
    ARM64_SYSREG_AFSR1_EL3 = 62089,
    ARM64_SYSREG_ESR_EL1 = 49808,
    ARM64_SYSREG_ESR_EL2 = 58000,
    ARM64_SYSREG_ESR_EL3 = 62096,
    ARM64_SYSREG_FPEXC32_EL2 = 58008,
    ARM64_SYSREG_FAR_EL1 = 49920,
    ARM64_SYSREG_FAR_EL2 = 58112,
    ARM64_SYSREG_FAR_EL3 = 62208,
    ARM64_SYSREG_HPFAR_EL2 = 58116,
    ARM64_SYSREG_PAR_EL1 = 50080,
    ARM64_SYSREG_PMCR_EL0 = 56544,
    ARM64_SYSREG_PMCNTENSET_EL0 = 56545,
    ARM64_SYSREG_PMCNTENCLR_EL0 = 56546,
    ARM64_SYSREG_PMOVSCLR_EL0 = 56547,
    ARM64_SYSREG_PMSELR_EL0 = 56549,
    ARM64_SYSREG_PMCCNTR_EL0 = 56552,
    ARM64_SYSREG_PMXEVTYPER_EL0 = 56553,
    ARM64_SYSREG_PMXEVCNTR_EL0 = 56554,
    ARM64_SYSREG_PMUSERENR_EL0 = 56560,
    ARM64_SYSREG_PMINTENSET_EL1 = 50417,
    ARM64_SYSREG_PMINTENCLR_EL1 = 50418,
    ARM64_SYSREG_PMOVSSET_EL0 = 56563,
    ARM64_SYSREG_MAIR_EL1 = 50448,
    ARM64_SYSREG_MAIR_EL2 = 58640,
    ARM64_SYSREG_MAIR_EL3 = 62736,
    ARM64_SYSREG_AMAIR_EL1 = 50456,
    ARM64_SYSREG_AMAIR_EL2 = 58648,
    ARM64_SYSREG_AMAIR_EL3 = 62744,
    ARM64_SYSREG_VBAR_EL1 = 50688,
    ARM64_SYSREG_VBAR_EL2 = 58880,
    ARM64_SYSREG_VBAR_EL3 = 62976,
    ARM64_SYSREG_RMR_EL1 = 50690,
    ARM64_SYSREG_RMR_EL2 = 58882,
    ARM64_SYSREG_RMR_EL3 = 62978,
    ARM64_SYSREG_CONTEXTIDR_EL1 = 50817,
    ARM64_SYSREG_TPIDR_EL0 = 56962,
    ARM64_SYSREG_TPIDR_EL2 = 59010,
    ARM64_SYSREG_TPIDR_EL3 = 63106,
    ARM64_SYSREG_TPIDRRO_EL0 = 56963,
    ARM64_SYSREG_TPIDR_EL1 = 50820,
    ARM64_SYSREG_CNTFRQ_EL0 = 57088,
    ARM64_SYSREG_CNTVOFF_EL2 = 59139,
    ARM64_SYSREG_CNTKCTL_EL1 = 50952,
    ARM64_SYSREG_CNTHCTL_EL2 = 59144,
    ARM64_SYSREG_CNTP_TVAL_EL0 = 57104,
    ARM64_SYSREG_CNTHP_TVAL_EL2 = 59152,
    ARM64_SYSREG_CNTPS_TVAL_EL1 = 65296,
    ARM64_SYSREG_CNTP_CTL_EL0 = 57105,
    ARM64_SYSREG_CNTHP_CTL_EL2 = 59153,
    ARM64_SYSREG_CNTPS_CTL_EL1 = 65297,
    ARM64_SYSREG_CNTP_CVAL_EL0 = 57106,
    ARM64_SYSREG_CNTHP_CVAL_EL2 = 59154,
    ARM64_SYSREG_CNTPS_CVAL_EL1 = 65298,
    ARM64_SYSREG_CNTV_TVAL_EL0 = 57112,
    ARM64_SYSREG_CNTV_CTL_EL0 = 57113,
    ARM64_SYSREG_CNTV_CVAL_EL0 = 57114,
    ARM64_SYSREG_PMEVCNTR0_EL0 = 57152,
    ARM64_SYSREG_PMEVCNTR1_EL0 = 57153,
    ARM64_SYSREG_PMEVCNTR2_EL0 = 57154,
    ARM64_SYSREG_PMEVCNTR3_EL0 = 57155,
    ARM64_SYSREG_PMEVCNTR4_EL0 = 57156,
    ARM64_SYSREG_PMEVCNTR5_EL0 = 57157,
    ARM64_SYSREG_PMEVCNTR6_EL0 = 57158,
    ARM64_SYSREG_PMEVCNTR7_EL0 = 57159,
    ARM64_SYSREG_PMEVCNTR8_EL0 = 57160,
    ARM64_SYSREG_PMEVCNTR9_EL0 = 57161,
    ARM64_SYSREG_PMEVCNTR10_EL0 = 57162,
    ARM64_SYSREG_PMEVCNTR11_EL0 = 57163,
    ARM64_SYSREG_PMEVCNTR12_EL0 = 57164,
    ARM64_SYSREG_PMEVCNTR13_EL0 = 57165,
    ARM64_SYSREG_PMEVCNTR14_EL0 = 57166,
    ARM64_SYSREG_PMEVCNTR15_EL0 = 57167,
    ARM64_SYSREG_PMEVCNTR16_EL0 = 57168,
    ARM64_SYSREG_PMEVCNTR17_EL0 = 57169,
    ARM64_SYSREG_PMEVCNTR18_EL0 = 57170,
    ARM64_SYSREG_PMEVCNTR19_EL0 = 57171,
    ARM64_SYSREG_PMEVCNTR20_EL0 = 57172,
    ARM64_SYSREG_PMEVCNTR21_EL0 = 57173,
    ARM64_SYSREG_PMEVCNTR22_EL0 = 57174,
    ARM64_SYSREG_PMEVCNTR23_EL0 = 57175,
    ARM64_SYSREG_PMEVCNTR24_EL0 = 57176,
    ARM64_SYSREG_PMEVCNTR25_EL0 = 57177,
    ARM64_SYSREG_PMEVCNTR26_EL0 = 57178,
    ARM64_SYSREG_PMEVCNTR27_EL0 = 57179,
    ARM64_SYSREG_PMEVCNTR28_EL0 = 57180,
    ARM64_SYSREG_PMEVCNTR29_EL0 = 57181,
    ARM64_SYSREG_PMEVCNTR30_EL0 = 57182,
    ARM64_SYSREG_PMCCFILTR_EL0 = 57215,
    ARM64_SYSREG_PMEVTYPER0_EL0 = 57184,
    ARM64_SYSREG_PMEVTYPER1_EL0 = 57185,
    ARM64_SYSREG_PMEVTYPER2_EL0 = 57186,
    ARM64_SYSREG_PMEVTYPER3_EL0 = 57187,
    ARM64_SYSREG_PMEVTYPER4_EL0 = 57188,
    ARM64_SYSREG_PMEVTYPER5_EL0 = 57189,
    ARM64_SYSREG_PMEVTYPER6_EL0 = 57190,
    ARM64_SYSREG_PMEVTYPER7_EL0 = 57191,
    ARM64_SYSREG_PMEVTYPER8_EL0 = 57192,
    ARM64_SYSREG_PMEVTYPER9_EL0 = 57193,
    ARM64_SYSREG_PMEVTYPER10_EL0 = 57194,
    ARM64_SYSREG_PMEVTYPER11_EL0 = 57195,
    ARM64_SYSREG_PMEVTYPER12_EL0 = 57196,
    ARM64_SYSREG_PMEVTYPER13_EL0 = 57197,
    ARM64_SYSREG_PMEVTYPER14_EL0 = 57198,
    ARM64_SYSREG_PMEVTYPER15_EL0 = 57199,
    ARM64_SYSREG_PMEVTYPER16_EL0 = 57200,
    ARM64_SYSREG_PMEVTYPER17_EL0 = 57201,
    ARM64_SYSREG_PMEVTYPER18_EL0 = 57202,
    ARM64_SYSREG_PMEVTYPER19_EL0 = 57203,
    ARM64_SYSREG_PMEVTYPER20_EL0 = 57204,
    ARM64_SYSREG_PMEVTYPER21_EL0 = 57205,
    ARM64_SYSREG_PMEVTYPER22_EL0 = 57206,
    ARM64_SYSREG_PMEVTYPER23_EL0 = 57207,
    ARM64_SYSREG_PMEVTYPER24_EL0 = 57208,
    ARM64_SYSREG_PMEVTYPER25_EL0 = 57209,
    ARM64_SYSREG_PMEVTYPER26_EL0 = 57210,
    ARM64_SYSREG_PMEVTYPER27_EL0 = 57211,
    ARM64_SYSREG_PMEVTYPER28_EL0 = 57212,
    ARM64_SYSREG_PMEVTYPER29_EL0 = 57213,
    ARM64_SYSREG_PMEVTYPER30_EL0 = 57214,
    ARM64_SYSREG_TRCPRGCTLR = 34824,
    ARM64_SYSREG_TRCPROCSELR = 34832,
    ARM64_SYSREG_TRCCONFIGR = 34848,
    ARM64_SYSREG_TRCAUXCTLR = 34864,
    ARM64_SYSREG_TRCEVENTCTL0R = 34880,
    ARM64_SYSREG_TRCEVENTCTL1R = 34888,
    ARM64_SYSREG_TRCSTALLCTLR = 34904,
    ARM64_SYSREG_TRCTSCTLR = 34912,
    ARM64_SYSREG_TRCSYNCPR = 34920,
    ARM64_SYSREG_TRCCCCTLR = 34928,
    ARM64_SYSREG_TRCBBCTLR = 34936,
    ARM64_SYSREG_TRCTRACEIDR = 34817,
    ARM64_SYSREG_TRCQCTLR = 34825,
    ARM64_SYSREG_TRCVICTLR = 34818,
    ARM64_SYSREG_TRCVIIECTLR = 34826,
    ARM64_SYSREG_TRCVISSCTLR = 34834,
    ARM64_SYSREG_TRCVIPCSSCTLR = 34842,
    ARM64_SYSREG_TRCVDCTLR = 34882,
    ARM64_SYSREG_TRCVDSACCTLR = 34890,
    ARM64_SYSREG_TRCVDARCCTLR = 34898,
    ARM64_SYSREG_TRCSEQEVR0 = 34820,
    ARM64_SYSREG_TRCSEQEVR1 = 34828,
    ARM64_SYSREG_TRCSEQEVR2 = 34836,
    ARM64_SYSREG_TRCSEQRSTEVR = 34868,
    ARM64_SYSREG_TRCSEQSTR = 34876,
    ARM64_SYSREG_TRCEXTINSELR = 34884,
    ARM64_SYSREG_TRCCNTRLDVR0 = 34821,
    ARM64_SYSREG_TRCCNTRLDVR1 = 34829,
    ARM64_SYSREG_TRCCNTRLDVR2 = 34837,
    ARM64_SYSREG_TRCCNTRLDVR3 = 34845,
    ARM64_SYSREG_TRCCNTCTLR0 = 34853,
    ARM64_SYSREG_TRCCNTCTLR1 = 34861,
    ARM64_SYSREG_TRCCNTCTLR2 = 34869,
    ARM64_SYSREG_TRCCNTCTLR3 = 34877,
    ARM64_SYSREG_TRCCNTVR0 = 34885,
    ARM64_SYSREG_TRCCNTVR1 = 34893,
    ARM64_SYSREG_TRCCNTVR2 = 34901,
    ARM64_SYSREG_TRCCNTVR3 = 34909,
    ARM64_SYSREG_TRCIMSPEC0 = 34823,
    ARM64_SYSREG_TRCIMSPEC1 = 34831,
    ARM64_SYSREG_TRCIMSPEC2 = 34839,
    ARM64_SYSREG_TRCIMSPEC3 = 34847,
    ARM64_SYSREG_TRCIMSPEC4 = 34855,
    ARM64_SYSREG_TRCIMSPEC5 = 34863,
    ARM64_SYSREG_TRCIMSPEC6 = 34871,
    ARM64_SYSREG_TRCIMSPEC7 = 34879,
    ARM64_SYSREG_TRCRSCTLR2 = 34960,
    ARM64_SYSREG_TRCRSCTLR3 = 34968,
    ARM64_SYSREG_TRCRSCTLR4 = 34976,
    ARM64_SYSREG_TRCRSCTLR5 = 34984,
    ARM64_SYSREG_TRCRSCTLR6 = 34992,
    ARM64_SYSREG_TRCRSCTLR7 = 35000,
    ARM64_SYSREG_TRCRSCTLR8 = 35008,
    ARM64_SYSREG_TRCRSCTLR9 = 35016,
    ARM64_SYSREG_TRCRSCTLR10 = 35024,
    ARM64_SYSREG_TRCRSCTLR11 = 35032,
    ARM64_SYSREG_TRCRSCTLR12 = 35040,
    ARM64_SYSREG_TRCRSCTLR13 = 35048,
    ARM64_SYSREG_TRCRSCTLR14 = 35056,
    ARM64_SYSREG_TRCRSCTLR15 = 35064,
    ARM64_SYSREG_TRCRSCTLR16 = 34945,
    ARM64_SYSREG_TRCRSCTLR17 = 34953,
    ARM64_SYSREG_TRCRSCTLR18 = 34961,
    ARM64_SYSREG_TRCRSCTLR19 = 34969,
    ARM64_SYSREG_TRCRSCTLR20 = 34977,
    ARM64_SYSREG_TRCRSCTLR21 = 34985,
    ARM64_SYSREG_TRCRSCTLR22 = 34993,
    ARM64_SYSREG_TRCRSCTLR23 = 35001,
    ARM64_SYSREG_TRCRSCTLR24 = 35009,
    ARM64_SYSREG_TRCRSCTLR25 = 35017,
    ARM64_SYSREG_TRCRSCTLR26 = 35025,
    ARM64_SYSREG_TRCRSCTLR27 = 35033,
    ARM64_SYSREG_TRCRSCTLR28 = 35041,
    ARM64_SYSREG_TRCRSCTLR29 = 35049,
    ARM64_SYSREG_TRCRSCTLR30 = 35057,
    ARM64_SYSREG_TRCRSCTLR31 = 35065,
    ARM64_SYSREG_TRCSSCCR0 = 34946,
    ARM64_SYSREG_TRCSSCCR1 = 34954,
    ARM64_SYSREG_TRCSSCCR2 = 34962,
    ARM64_SYSREG_TRCSSCCR3 = 34970,
    ARM64_SYSREG_TRCSSCCR4 = 34978,
    ARM64_SYSREG_TRCSSCCR5 = 34986,
    ARM64_SYSREG_TRCSSCCR6 = 34994,
    ARM64_SYSREG_TRCSSCCR7 = 35002,
    ARM64_SYSREG_TRCSSCSR0 = 35010,
    ARM64_SYSREG_TRCSSCSR1 = 35018,
    ARM64_SYSREG_TRCSSCSR2 = 35026,
    ARM64_SYSREG_TRCSSCSR3 = 35034,
    ARM64_SYSREG_TRCSSCSR4 = 35042,
    ARM64_SYSREG_TRCSSCSR5 = 35050,
    ARM64_SYSREG_TRCSSCSR6 = 35058,
    ARM64_SYSREG_TRCSSCSR7 = 35066,
    ARM64_SYSREG_TRCSSPCICR0 = 34947,
    ARM64_SYSREG_TRCSSPCICR1 = 34955,
    ARM64_SYSREG_TRCSSPCICR2 = 34963,
    ARM64_SYSREG_TRCSSPCICR3 = 34971,
    ARM64_SYSREG_TRCSSPCICR4 = 34979,
    ARM64_SYSREG_TRCSSPCICR5 = 34987,
    ARM64_SYSREG_TRCSSPCICR6 = 34995,
    ARM64_SYSREG_TRCSSPCICR7 = 35003,
    ARM64_SYSREG_TRCPDCR = 34980,
    ARM64_SYSREG_TRCACVR0 = 35072,
    ARM64_SYSREG_TRCACVR1 = 35088,
    ARM64_SYSREG_TRCACVR2 = 35104,
    ARM64_SYSREG_TRCACVR3 = 35120,
    ARM64_SYSREG_TRCACVR4 = 35136,
    ARM64_SYSREG_TRCACVR5 = 35152,
    ARM64_SYSREG_TRCACVR6 = 35168,
    ARM64_SYSREG_TRCACVR7 = 35184,
    ARM64_SYSREG_TRCACVR8 = 35073,
    ARM64_SYSREG_TRCACVR9 = 35089,
    ARM64_SYSREG_TRCACVR10 = 35105,
    ARM64_SYSREG_TRCACVR11 = 35121,
    ARM64_SYSREG_TRCACVR12 = 35137,
    ARM64_SYSREG_TRCACVR13 = 35153,
    ARM64_SYSREG_TRCACVR14 = 35169,
    ARM64_SYSREG_TRCACVR15 = 35185,
    ARM64_SYSREG_TRCACATR0 = 35074,
    ARM64_SYSREG_TRCACATR1 = 35090,
    ARM64_SYSREG_TRCACATR2 = 35106,
    ARM64_SYSREG_TRCACATR3 = 35122,
    ARM64_SYSREG_TRCACATR4 = 35138,
    ARM64_SYSREG_TRCACATR5 = 35154,
    ARM64_SYSREG_TRCACATR6 = 35170,
    ARM64_SYSREG_TRCACATR7 = 35186,
    ARM64_SYSREG_TRCACATR8 = 35075,
    ARM64_SYSREG_TRCACATR9 = 35091,
    ARM64_SYSREG_TRCACATR10 = 35107,
    ARM64_SYSREG_TRCACATR11 = 35123,
    ARM64_SYSREG_TRCACATR12 = 35139,
    ARM64_SYSREG_TRCACATR13 = 35155,
    ARM64_SYSREG_TRCACATR14 = 35171,
    ARM64_SYSREG_TRCACATR15 = 35187,
    ARM64_SYSREG_TRCDVCVR0 = 35076,
    ARM64_SYSREG_TRCDVCVR1 = 35108,
    ARM64_SYSREG_TRCDVCVR2 = 35140,
    ARM64_SYSREG_TRCDVCVR3 = 35172,
    ARM64_SYSREG_TRCDVCVR4 = 35077,
    ARM64_SYSREG_TRCDVCVR5 = 35109,
    ARM64_SYSREG_TRCDVCVR6 = 35141,
    ARM64_SYSREG_TRCDVCVR7 = 35173,
    ARM64_SYSREG_TRCDVCMR0 = 35078,
    ARM64_SYSREG_TRCDVCMR1 = 35110,
    ARM64_SYSREG_TRCDVCMR2 = 35142,
    ARM64_SYSREG_TRCDVCMR3 = 35174,
    ARM64_SYSREG_TRCDVCMR4 = 35079,
    ARM64_SYSREG_TRCDVCMR5 = 35111,
    ARM64_SYSREG_TRCDVCMR6 = 35143,
    ARM64_SYSREG_TRCDVCMR7 = 35175,
    ARM64_SYSREG_TRCCIDCVR0 = 35200,
    ARM64_SYSREG_TRCCIDCVR1 = 35216,
    ARM64_SYSREG_TRCCIDCVR2 = 35232,
    ARM64_SYSREG_TRCCIDCVR3 = 35248,
    ARM64_SYSREG_TRCCIDCVR4 = 35264,
    ARM64_SYSREG_TRCCIDCVR5 = 35280,
    ARM64_SYSREG_TRCCIDCVR6 = 35296,
    ARM64_SYSREG_TRCCIDCVR7 = 35312,
    ARM64_SYSREG_TRCVMIDCVR0 = 35201,
    ARM64_SYSREG_TRCVMIDCVR1 = 35217,
    ARM64_SYSREG_TRCVMIDCVR2 = 35233,
    ARM64_SYSREG_TRCVMIDCVR3 = 35249,
    ARM64_SYSREG_TRCVMIDCVR4 = 35265,
    ARM64_SYSREG_TRCVMIDCVR5 = 35281,
    ARM64_SYSREG_TRCVMIDCVR6 = 35297,
    ARM64_SYSREG_TRCVMIDCVR7 = 35313,
    ARM64_SYSREG_TRCCIDCCTLR0 = 35202,
    ARM64_SYSREG_TRCCIDCCTLR1 = 35210,
    ARM64_SYSREG_TRCVMIDCCTLR0 = 35218,
    ARM64_SYSREG_TRCVMIDCCTLR1 = 35226,
    ARM64_SYSREG_TRCITCTRL = 35716,
    ARM64_SYSREG_TRCCLAIMSET = 35782,
    ARM64_SYSREG_TRCCLAIMCLR = 35790,
    ARM64_SYSREG_ICC_BPR1_EL1 = 50787,
    ARM64_SYSREG_ICC_BPR0_EL1 = 50755,
    ARM64_SYSREG_ICC_PMR_EL1 = 49712,
    ARM64_SYSREG_ICC_CTLR_EL1 = 50788,
    ARM64_SYSREG_ICC_CTLR_EL3 = 63076,
    ARM64_SYSREG_ICC_SRE_EL1 = 50789,
    ARM64_SYSREG_ICC_SRE_EL2 = 58957,
    ARM64_SYSREG_ICC_SRE_EL3 = 63077,
    ARM64_SYSREG_ICC_IGRPEN0_EL1 = 50790,
    ARM64_SYSREG_ICC_IGRPEN1_EL1 = 50791,
    ARM64_SYSREG_ICC_IGRPEN1_EL3 = 63079,
    ARM64_SYSREG_ICC_SEIEN_EL1 = 50792,
    ARM64_SYSREG_ICC_AP0R0_EL1 = 50756,
    ARM64_SYSREG_ICC_AP0R1_EL1 = 50757,
    ARM64_SYSREG_ICC_AP0R2_EL1 = 50758,
    ARM64_SYSREG_ICC_AP0R3_EL1 = 50759,
    ARM64_SYSREG_ICC_AP1R0_EL1 = 50760,
    ARM64_SYSREG_ICC_AP1R1_EL1 = 50761,
    ARM64_SYSREG_ICC_AP1R2_EL1 = 50762,
    ARM64_SYSREG_ICC_AP1R3_EL1 = 50763,
    ARM64_SYSREG_ICH_AP0R0_EL2 = 58944,
    ARM64_SYSREG_ICH_AP0R1_EL2 = 58945,
    ARM64_SYSREG_ICH_AP0R2_EL2 = 58946,
    ARM64_SYSREG_ICH_AP0R3_EL2 = 58947,
    ARM64_SYSREG_ICH_AP1R0_EL2 = 58952,
    ARM64_SYSREG_ICH_AP1R1_EL2 = 58953,
    ARM64_SYSREG_ICH_AP1R2_EL2 = 58954,
    ARM64_SYSREG_ICH_AP1R3_EL2 = 58955,
    ARM64_SYSREG_ICH_HCR_EL2 = 58968,
    ARM64_SYSREG_ICH_MISR_EL2 = 58970,
    ARM64_SYSREG_ICH_VMCR_EL2 = 58975,
    ARM64_SYSREG_ICH_VSEIR_EL2 = 58956,
    ARM64_SYSREG_ICH_LR0_EL2 = 58976,
    ARM64_SYSREG_ICH_LR1_EL2 = 58977,
    ARM64_SYSREG_ICH_LR2_EL2 = 58978,
    ARM64_SYSREG_ICH_LR3_EL2 = 58979,
    ARM64_SYSREG_ICH_LR4_EL2 = 58980,
    ARM64_SYSREG_ICH_LR5_EL2 = 58981,
    ARM64_SYSREG_ICH_LR6_EL2 = 58982,
    ARM64_SYSREG_ICH_LR7_EL2 = 58983,
    ARM64_SYSREG_ICH_LR8_EL2 = 58984,
    ARM64_SYSREG_ICH_LR9_EL2 = 58985,
    ARM64_SYSREG_ICH_LR10_EL2 = 58986,
    ARM64_SYSREG_ICH_LR11_EL2 = 58987,
    ARM64_SYSREG_ICH_LR12_EL2 = 58988,
    ARM64_SYSREG_ICH_LR13_EL2 = 58989,
    ARM64_SYSREG_ICH_LR14_EL2 = 58990,
    ARM64_SYSREG_ICH_LR15_EL2 = 58991,
    ARM64_SYSREG_PAN = 49683,
    ARM64_SYSREG_LORSA_EL1 = 50464,
    ARM64_SYSREG_LOREA_EL1 = 50465,
    ARM64_SYSREG_LORN_EL1 = 50466,
    ARM64_SYSREG_LORC_EL1 = 50467,
    ARM64_SYSREG_TTBR1_EL2 = 57601,
    ARM64_SYSREG_CONTEXTIDR_EL2 = 59009,
    ARM64_SYSREG_CNTHV_TVAL_EL2 = 59160,
    ARM64_SYSREG_CNTHV_CVAL_EL2 = 59162,
    ARM64_SYSREG_CNTHV_CTL_EL2 = 59161,
    ARM64_SYSREG_SCTLR_EL12 = 59520,
    ARM64_SYSREG_CPACR_EL12 = 59522,
    ARM64_SYSREG_TTBR0_EL12 = 59648,
    ARM64_SYSREG_TTBR1_EL12 = 59649,
    ARM64_SYSREG_TCR_EL12 = 59650,
    ARM64_SYSREG_AFSR0_EL12 = 60040,
    ARM64_SYSREG_AFSR1_EL12 = 60041,
    ARM64_SYSREG_ESR_EL12 = 60048,
    ARM64_SYSREG_FAR_EL12 = 60160,
    ARM64_SYSREG_MAIR_EL12 = 60688,
    ARM64_SYSREG_AMAIR_EL12 = 60696,
    ARM64_SYSREG_VBAR_EL12 = 60928,
    ARM64_SYSREG_CONTEXTIDR_EL12 = 61057,
    ARM64_SYSREG_CNTKCTL_EL12 = 61192,
    ARM64_SYSREG_CNTP_TVAL_EL02 = 61200,
    ARM64_SYSREG_CNTP_CTL_EL02 = 61201,
    ARM64_SYSREG_CNTP_CVAL_EL02 = 61202,
    ARM64_SYSREG_CNTV_TVAL_EL02 = 61208,
    ARM64_SYSREG_CNTV_CTL_EL02 = 61209,
    ARM64_SYSREG_CNTV_CVAL_EL02 = 61210,
    ARM64_SYSREG_SPSR_EL12 = 59904,
    ARM64_SYSREG_ELR_EL12 = 59905,
    ARM64_SYSREG_UAO = 49684,
    ARM64_SYSREG_PMBLIMITR_EL1 = 50384,
    ARM64_SYSREG_PMBPTR_EL1 = 50385,
    ARM64_SYSREG_PMBSR_EL1 = 50387,
    ARM64_SYSREG_PMBIDR_EL1 = 50391,
    ARM64_SYSREG_PMSCR_EL2 = 58568,
    ARM64_SYSREG_PMSCR_EL12 = 60616,
    ARM64_SYSREG_PMSCR_EL1 = 50376,
    ARM64_SYSREG_PMSICR_EL1 = 50378,
    ARM64_SYSREG_PMSIRR_EL1 = 50379,
    ARM64_SYSREG_PMSFCR_EL1 = 50380,
    ARM64_SYSREG_PMSEVFR_EL1 = 50381,
    ARM64_SYSREG_PMSLATFR_EL1 = 50382,
    ARM64_SYSREG_PMSIDR_EL1 = 50383,
    ARM64_SYSREG_ERRSELR_EL1 = 49817,
    ARM64_SYSREG_ERXCTLR_EL1 = 49825,
    ARM64_SYSREG_ERXSTATUS_EL1 = 49826,
    ARM64_SYSREG_ERXADDR_EL1 = 49827,
    ARM64_SYSREG_ERXMISC0_EL1 = 49832,
    ARM64_SYSREG_ERXMISC1_EL1 = 49833,
    ARM64_SYSREG_DISR_EL1 = 50697,
    ARM64_SYSREG_VDISR_EL2 = 58889,
    ARM64_SYSREG_VSESR_EL2 = 58003,
    ARM64_SYSREG_APIAKEYLO_EL1 = 49416,
    ARM64_SYSREG_APIAKEYHI_EL1 = 49417,
    ARM64_SYSREG_APIBKEYLO_EL1 = 49418,
    ARM64_SYSREG_APIBKEYHI_EL1 = 49419,
    ARM64_SYSREG_APDAKEYLO_EL1 = 49424,
    ARM64_SYSREG_APDAKEYHI_EL1 = 49425,
    ARM64_SYSREG_APDBKEYLO_EL1 = 49426,
    ARM64_SYSREG_APDBKEYHI_EL1 = 49427,
    ARM64_SYSREG_APGAKEYLO_EL1 = 49432,
    ARM64_SYSREG_APGAKEYHI_EL1 = 49433,
    ARM64_SYSREG_VSTCR_EL2 = 57650,
    ARM64_SYSREG_VSTTBR_EL2 = 57648,
    ARM64_SYSREG_CNTHVS_TVAL_EL2 = 59168,
    ARM64_SYSREG_CNTHVS_CVAL_EL2 = 59170,
    ARM64_SYSREG_CNTHVS_CTL_EL2 = 59169,
    ARM64_SYSREG_CNTHPS_TVAL_EL2 = 59176,
    ARM64_SYSREG_CNTHPS_CVAL_EL2 = 59178,
    ARM64_SYSREG_CNTHPS_CTL_EL2 = 59177,
    ARM64_SYSREG_SDER32_EL2 = 57497,
    ARM64_SYSREG_ERXPFGCTL_EL1 = 49829,
    ARM64_SYSREG_ERXPFGCDN_EL1 = 49830,
    ARM64_SYSREG_ERXTS_EL1 = 49839,
    ARM64_SYSREG_ERXMISC2_EL1 = 49834,
    ARM64_SYSREG_ERXMISC3_EL1 = 49835,
    ARM64_SYSREG_ERXPFGF_EL1 = 49828,
    ARM64_SYSREG_MPAM0_EL1 = 50473,
    ARM64_SYSREG_MPAM1_EL1 = 50472,
    ARM64_SYSREG_MPAM2_EL2 = 58664,
    ARM64_SYSREG_MPAM3_EL3 = 62760,
    ARM64_SYSREG_MPAM1_EL12 = 60712,
    ARM64_SYSREG_MPAMHCR_EL2 = 58656,
    ARM64_SYSREG_MPAMVPMV_EL2 = 58657,
    ARM64_SYSREG_MPAMVPM0_EL2 = 58672,
    ARM64_SYSREG_MPAMVPM1_EL2 = 58673,
    ARM64_SYSREG_MPAMVPM2_EL2 = 58674,
    ARM64_SYSREG_MPAMVPM3_EL2 = 58675,
    ARM64_SYSREG_MPAMVPM4_EL2 = 58676,
    ARM64_SYSREG_MPAMVPM5_EL2 = 58677,
    ARM64_SYSREG_MPAMVPM6_EL2 = 58678,
    ARM64_SYSREG_MPAMVPM7_EL2 = 58679,
    ARM64_SYSREG_MPAMIDR_EL1 = 50468,
    ARM64_SYSREG_AMCR_EL0 = 56976,
    ARM64_SYSREG_AMCFGR_EL0 = 56977,
    ARM64_SYSREG_AMCGCR_EL0 = 56978,
    ARM64_SYSREG_AMUSERENR_EL0 = 56979,
    ARM64_SYSREG_AMCNTENCLR0_EL0 = 56980,
    ARM64_SYSREG_AMCNTENSET0_EL0 = 56981,
    ARM64_SYSREG_AMEVCNTR00_EL0 = 56992,
    ARM64_SYSREG_AMEVCNTR01_EL0 = 56993,
    ARM64_SYSREG_AMEVCNTR02_EL0 = 56994,
    ARM64_SYSREG_AMEVCNTR03_EL0 = 56995,
    ARM64_SYSREG_AMEVTYPER00_EL0 = 57008,
    ARM64_SYSREG_AMEVTYPER01_EL0 = 57009,
    ARM64_SYSREG_AMEVTYPER02_EL0 = 57010,
    ARM64_SYSREG_AMEVTYPER03_EL0 = 57011,
    ARM64_SYSREG_AMCNTENCLR1_EL0 = 56984,
    ARM64_SYSREG_AMCNTENSET1_EL0 = 56985,
    ARM64_SYSREG_AMEVCNTR10_EL0 = 57056,
    ARM64_SYSREG_AMEVCNTR11_EL0 = 57057,
    ARM64_SYSREG_AMEVCNTR12_EL0 = 57058,
    ARM64_SYSREG_AMEVCNTR13_EL0 = 57059,
    ARM64_SYSREG_AMEVCNTR14_EL0 = 57060,
    ARM64_SYSREG_AMEVCNTR15_EL0 = 57061,
    ARM64_SYSREG_AMEVCNTR16_EL0 = 57062,
    ARM64_SYSREG_AMEVCNTR17_EL0 = 57063,
    ARM64_SYSREG_AMEVCNTR18_EL0 = 57064,
    ARM64_SYSREG_AMEVCNTR19_EL0 = 57065,
    ARM64_SYSREG_AMEVCNTR110_EL0 = 57066,
    ARM64_SYSREG_AMEVCNTR111_EL0 = 57067,
    ARM64_SYSREG_AMEVCNTR112_EL0 = 57068,
    ARM64_SYSREG_AMEVCNTR113_EL0 = 57069,
    ARM64_SYSREG_AMEVCNTR114_EL0 = 57070,
    ARM64_SYSREG_AMEVCNTR115_EL0 = 57071,
    ARM64_SYSREG_AMEVTYPER10_EL0 = 57072,
    ARM64_SYSREG_AMEVTYPER11_EL0 = 57073,
    ARM64_SYSREG_AMEVTYPER12_EL0 = 57074,
    ARM64_SYSREG_AMEVTYPER13_EL0 = 57075,
    ARM64_SYSREG_AMEVTYPER14_EL0 = 57076,
    ARM64_SYSREG_AMEVTYPER15_EL0 = 57077,
    ARM64_SYSREG_AMEVTYPER16_EL0 = 57078,
    ARM64_SYSREG_AMEVTYPER17_EL0 = 57079,
    ARM64_SYSREG_AMEVTYPER18_EL0 = 57080,
    ARM64_SYSREG_AMEVTYPER19_EL0 = 57081,
    ARM64_SYSREG_AMEVTYPER110_EL0 = 57082,
    ARM64_SYSREG_AMEVTYPER111_EL0 = 57083,
    ARM64_SYSREG_AMEVTYPER112_EL0 = 57084,
    ARM64_SYSREG_AMEVTYPER113_EL0 = 57085,
    ARM64_SYSREG_AMEVTYPER114_EL0 = 57086,
    ARM64_SYSREG_AMEVTYPER115_EL0 = 57087,
    ARM64_SYSREG_TRFCR_EL1 = 49297,
    ARM64_SYSREG_TRFCR_EL2 = 57489,
    ARM64_SYSREG_TRFCR_EL12 = 59537,
    ARM64_SYSREG_DIT = 55829,
    ARM64_SYSREG_VNCR_EL2 = 57616,
    ARM64_SYSREG_ZCR_EL1 = 49296,
    ARM64_SYSREG_ZCR_EL2 = 57488,
    ARM64_SYSREG_ZCR_EL3 = 61584,
    ARM64_SYSREG_ZCR_EL12 = 59536,
    ARM64_SYSREG_CPM_IOACC_CTL_EL3 = 65424,
}
#[repr(u32)]
#[doc = " System PState Field (MSR instruction)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_pstate {
    ARM64_PSTATE_INVALID = 0,
    ARM64_PSTATE_SPSEL = 5,
    ARM64_PSTATE_DAIFSET = 30,
    ARM64_PSTATE_DAIFCLR = 31,
    ARM64_PSTATE_PAN = 4,
    ARM64_PSTATE_UAO = 3,
    ARM64_PSTATE_DIT = 26,
}
#[repr(u32)]
#[doc = " Vector arrangement specifier (for FloatingPoint/Advanced SIMD insn)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_vas {
    ARM64_VAS_INVALID = 0,
    ARM64_VAS_16B = 1,
    ARM64_VAS_8B = 2,
    ARM64_VAS_4B = 3,
    ARM64_VAS_1B = 4,
    ARM64_VAS_8H = 5,
    ARM64_VAS_4H = 6,
    ARM64_VAS_2H = 7,
    ARM64_VAS_1H = 8,
    ARM64_VAS_4S = 9,
    ARM64_VAS_2S = 10,
    ARM64_VAS_1S = 11,
    ARM64_VAS_2D = 12,
    ARM64_VAS_1D = 13,
    ARM64_VAS_1Q = 14,
}
#[repr(u32)]
#[doc = " Memory barrier operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_barrier_op {
    ARM64_BARRIER_INVALID = 0,
    ARM64_BARRIER_OSHLD = 1,
    ARM64_BARRIER_OSHST = 2,
    ARM64_BARRIER_OSH = 3,
    ARM64_BARRIER_NSHLD = 5,
    ARM64_BARRIER_NSHST = 6,
    ARM64_BARRIER_NSH = 7,
    ARM64_BARRIER_ISHLD = 9,
    ARM64_BARRIER_ISHST = 10,
    ARM64_BARRIER_ISH = 11,
    ARM64_BARRIER_LD = 13,
    ARM64_BARRIER_ST = 14,
    ARM64_BARRIER_SY = 15,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    ARM64_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    ARM64_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    ARM64_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    ARM64_OP_MEM = 3,
    #[doc = "< = CS_OP_FP (Floating-Point operand)."]
    ARM64_OP_FP = 4,
    #[doc = "< C-Immediate"]
    ARM64_OP_CIMM = 64,
    #[doc = "< MRS register operand."]
    ARM64_OP_REG_MRS = 65,
    #[doc = "< MSR register operand."]
    ARM64_OP_REG_MSR = 66,
    #[doc = "< PState operand."]
    ARM64_OP_PSTATE = 67,
    #[doc = "< SYS operand for IC/DC/AT/TLBI instructions."]
    ARM64_OP_SYS = 68,
    #[doc = "< Prefetch operand (PRFM)."]
    ARM64_OP_PREFETCH = 69,
    #[doc = "< Memory barrier operand (ISB/DMB/DSB instructions)."]
    ARM64_OP_BARRIER = 70,
}
#[repr(u32)]
#[doc = " TLBI operations"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_tlbi_op {
    ARM64_TLBI_INVALID = 0,
    ARM64_TLBI_IPAS2E1IS = 1,
    ARM64_TLBI_IPAS2LE1IS = 2,
    ARM64_TLBI_VMALLE1IS = 3,
    ARM64_TLBI_ALLE2IS = 4,
    ARM64_TLBI_ALLE3IS = 5,
    ARM64_TLBI_VAE1IS = 6,
    ARM64_TLBI_VAE2IS = 7,
    ARM64_TLBI_VAE3IS = 8,
    ARM64_TLBI_ASIDE1IS = 9,
    ARM64_TLBI_VAAE1IS = 10,
    ARM64_TLBI_ALLE1IS = 11,
    ARM64_TLBI_VALE1IS = 12,
    ARM64_TLBI_VALE2IS = 13,
    ARM64_TLBI_VALE3IS = 14,
    ARM64_TLBI_VMALLS12E1IS = 15,
    ARM64_TLBI_VAALE1IS = 16,
    ARM64_TLBI_IPAS2E1 = 17,
    ARM64_TLBI_IPAS2LE1 = 18,
    ARM64_TLBI_VMALLE1 = 19,
    ARM64_TLBI_ALLE2 = 20,
    ARM64_TLBI_ALLE3 = 21,
    ARM64_TLBI_VAE1 = 22,
    ARM64_TLBI_VAE2 = 23,
    ARM64_TLBI_VAE3 = 24,
    ARM64_TLBI_ASIDE1 = 25,
    ARM64_TLBI_VAAE1 = 26,
    ARM64_TLBI_ALLE1 = 27,
    ARM64_TLBI_VALE1 = 28,
    ARM64_TLBI_VALE2 = 29,
    ARM64_TLBI_VALE3 = 30,
    ARM64_TLBI_VMALLS12E1 = 31,
    ARM64_TLBI_VAALE1 = 32,
    ARM64_TLBI_VMALLE1OS = 33,
    ARM64_TLBI_VAE1OS = 34,
    ARM64_TLBI_ASIDE1OS = 35,
    ARM64_TLBI_VAAE1OS = 36,
    ARM64_TLBI_VALE1OS = 37,
    ARM64_TLBI_VAALE1OS = 38,
    ARM64_TLBI_IPAS2E1OS = 39,
    ARM64_TLBI_IPAS2LE1OS = 40,
    ARM64_TLBI_VAE2OS = 41,
    ARM64_TLBI_VALE2OS = 42,
    ARM64_TLBI_VMALLS12E1OS = 43,
    ARM64_TLBI_VAE3OS = 44,
    ARM64_TLBI_VALE3OS = 45,
    ARM64_TLBI_ALLE2OS = 46,
    ARM64_TLBI_ALLE1OS = 47,
    ARM64_TLBI_ALLE3OS = 48,
    ARM64_TLBI_RVAE1 = 49,
    ARM64_TLBI_RVAAE1 = 50,
    ARM64_TLBI_RVALE1 = 51,
    ARM64_TLBI_RVAALE1 = 52,
    ARM64_TLBI_RVAE1IS = 53,
    ARM64_TLBI_RVAAE1IS = 54,
    ARM64_TLBI_RVALE1IS = 55,
    ARM64_TLBI_RVAALE1IS = 56,
    ARM64_TLBI_RVAE1OS = 57,
    ARM64_TLBI_RVAAE1OS = 58,
    ARM64_TLBI_RVALE1OS = 59,
    ARM64_TLBI_RVAALE1OS = 60,
    ARM64_TLBI_RIPAS2E1IS = 61,
    ARM64_TLBI_RIPAS2LE1IS = 62,
    ARM64_TLBI_RIPAS2E1 = 63,
    ARM64_TLBI_RIPAS2LE1 = 64,
    ARM64_TLBI_RIPAS2E1OS = 65,
    ARM64_TLBI_RIPAS2LE1OS = 66,
    ARM64_TLBI_RVAE2 = 67,
    ARM64_TLBI_RVALE2 = 68,
    ARM64_TLBI_RVAE2IS = 69,
    ARM64_TLBI_RVALE2IS = 70,
    ARM64_TLBI_RVAE2OS = 71,
    ARM64_TLBI_RVALE2OS = 72,
    ARM64_TLBI_RVAE3 = 73,
    ARM64_TLBI_RVALE3 = 74,
    ARM64_TLBI_RVAE3IS = 75,
    ARM64_TLBI_RVALE3IS = 76,
    ARM64_TLBI_RVAE3OS = 77,
    ARM64_TLBI_RVALE3OS = 78,
}
#[repr(u32)]
#[doc = " AT operations"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_at_op {
    ARM64_AT_S1E1R = 0,
    ARM64_AT_S1E2R = 1,
    ARM64_AT_S1E3R = 2,
    ARM64_AT_S1E1W = 3,
    ARM64_AT_S1E2W = 4,
    ARM64_AT_S1E3W = 5,
    ARM64_AT_S1E0R = 6,
    ARM64_AT_S1E0W = 7,
    ARM64_AT_S12E1R = 8,
    ARM64_AT_S12E1W = 9,
    ARM64_AT_S12E0R = 10,
    ARM64_AT_S12E0W = 11,
    ARM64_AT_S1E1RP = 12,
    ARM64_AT_S1E1WP = 13,
}
#[repr(u32)]
#[doc = " DC operations"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_dc_op {
    ARM64_DC_INVALID = 0,
    ARM64_DC_ZVA = 1,
    ARM64_DC_IVAC = 2,
    ARM64_DC_ISW = 3,
    ARM64_DC_CVAC = 4,
    ARM64_DC_CSW = 5,
    ARM64_DC_CVAU = 6,
    ARM64_DC_CIVAC = 7,
    ARM64_DC_CISW = 8,
    ARM64_DC_CVAP = 9,
}
#[repr(u32)]
#[doc = " IC operations"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_ic_op {
    ARM64_IC_INVALID = 0,
    ARM64_IC_IALLUIS = 1,
    ARM64_IC_IALLU = 2,
    ARM64_IC_IVAU = 3,
}
#[repr(u32)]
#[doc = " Prefetch operations (PRFM)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_prefetch_op {
    ARM64_PRFM_INVALID = 0,
    ARM64_PRFM_PLDL1KEEP = 1,
    ARM64_PRFM_PLDL1STRM = 2,
    ARM64_PRFM_PLDL2KEEP = 3,
    ARM64_PRFM_PLDL2STRM = 4,
    ARM64_PRFM_PLDL3KEEP = 5,
    ARM64_PRFM_PLDL3STRM = 6,
    ARM64_PRFM_PLIL1KEEP = 9,
    ARM64_PRFM_PLIL1STRM = 10,
    ARM64_PRFM_PLIL2KEEP = 11,
    ARM64_PRFM_PLIL2STRM = 12,
    ARM64_PRFM_PLIL3KEEP = 13,
    ARM64_PRFM_PLIL3STRM = 14,
    ARM64_PRFM_PSTL1KEEP = 17,
    ARM64_PRFM_PSTL1STRM = 18,
    ARM64_PRFM_PSTL2KEEP = 19,
    ARM64_PRFM_PSTL2STRM = 20,
    ARM64_PRFM_PSTL3KEEP = 21,
    ARM64_PRFM_PSTL3STRM = 22,
}
pub mod arm64_reg {
    #[doc = " ARM64 registers"]
    pub type Type = libc::c_uint;
    pub const ARM64_REG_INVALID: Type = 0;
    pub const ARM64_REG_FFR: Type = 1;
    pub const ARM64_REG_FP: Type = 2;
    pub const ARM64_REG_LR: Type = 3;
    pub const ARM64_REG_NZCV: Type = 4;
    pub const ARM64_REG_SP: Type = 5;
    pub const ARM64_REG_WSP: Type = 6;
    pub const ARM64_REG_WZR: Type = 7;
    pub const ARM64_REG_XZR: Type = 8;
    pub const ARM64_REG_B0: Type = 9;
    pub const ARM64_REG_B1: Type = 10;
    pub const ARM64_REG_B2: Type = 11;
    pub const ARM64_REG_B3: Type = 12;
    pub const ARM64_REG_B4: Type = 13;
    pub const ARM64_REG_B5: Type = 14;
    pub const ARM64_REG_B6: Type = 15;
    pub const ARM64_REG_B7: Type = 16;
    pub const ARM64_REG_B8: Type = 17;
    pub const ARM64_REG_B9: Type = 18;
    pub const ARM64_REG_B10: Type = 19;
    pub const ARM64_REG_B11: Type = 20;
    pub const ARM64_REG_B12: Type = 21;
    pub const ARM64_REG_B13: Type = 22;
    pub const ARM64_REG_B14: Type = 23;
    pub const ARM64_REG_B15: Type = 24;
    pub const ARM64_REG_B16: Type = 25;
    pub const ARM64_REG_B17: Type = 26;
    pub const ARM64_REG_B18: Type = 27;
    pub const ARM64_REG_B19: Type = 28;
    pub const ARM64_REG_B20: Type = 29;
    pub const ARM64_REG_B21: Type = 30;
    pub const ARM64_REG_B22: Type = 31;
    pub const ARM64_REG_B23: Type = 32;
    pub const ARM64_REG_B24: Type = 33;
    pub const ARM64_REG_B25: Type = 34;
    pub const ARM64_REG_B26: Type = 35;
    pub const ARM64_REG_B27: Type = 36;
    pub const ARM64_REG_B28: Type = 37;
    pub const ARM64_REG_B29: Type = 38;
    pub const ARM64_REG_B30: Type = 39;
    pub const ARM64_REG_B31: Type = 40;
    pub const ARM64_REG_D0: Type = 41;
    pub const ARM64_REG_D1: Type = 42;
    pub const ARM64_REG_D2: Type = 43;
    pub const ARM64_REG_D3: Type = 44;
    pub const ARM64_REG_D4: Type = 45;
    pub const ARM64_REG_D5: Type = 46;
    pub const ARM64_REG_D6: Type = 47;
    pub const ARM64_REG_D7: Type = 48;
    pub const ARM64_REG_D8: Type = 49;
    pub const ARM64_REG_D9: Type = 50;
    pub const ARM64_REG_D10: Type = 51;
    pub const ARM64_REG_D11: Type = 52;
    pub const ARM64_REG_D12: Type = 53;
    pub const ARM64_REG_D13: Type = 54;
    pub const ARM64_REG_D14: Type = 55;
    pub const ARM64_REG_D15: Type = 56;
    pub const ARM64_REG_D16: Type = 57;
    pub const ARM64_REG_D17: Type = 58;
    pub const ARM64_REG_D18: Type = 59;
    pub const ARM64_REG_D19: Type = 60;
    pub const ARM64_REG_D20: Type = 61;
    pub const ARM64_REG_D21: Type = 62;
    pub const ARM64_REG_D22: Type = 63;
    pub const ARM64_REG_D23: Type = 64;
    pub const ARM64_REG_D24: Type = 65;
    pub const ARM64_REG_D25: Type = 66;
    pub const ARM64_REG_D26: Type = 67;
    pub const ARM64_REG_D27: Type = 68;
    pub const ARM64_REG_D28: Type = 69;
    pub const ARM64_REG_D29: Type = 70;
    pub const ARM64_REG_D30: Type = 71;
    pub const ARM64_REG_D31: Type = 72;
    pub const ARM64_REG_H0: Type = 73;
    pub const ARM64_REG_H1: Type = 74;
    pub const ARM64_REG_H2: Type = 75;
    pub const ARM64_REG_H3: Type = 76;
    pub const ARM64_REG_H4: Type = 77;
    pub const ARM64_REG_H5: Type = 78;
    pub const ARM64_REG_H6: Type = 79;
    pub const ARM64_REG_H7: Type = 80;
    pub const ARM64_REG_H8: Type = 81;
    pub const ARM64_REG_H9: Type = 82;
    pub const ARM64_REG_H10: Type = 83;
    pub const ARM64_REG_H11: Type = 84;
    pub const ARM64_REG_H12: Type = 85;
    pub const ARM64_REG_H13: Type = 86;
    pub const ARM64_REG_H14: Type = 87;
    pub const ARM64_REG_H15: Type = 88;
    pub const ARM64_REG_H16: Type = 89;
    pub const ARM64_REG_H17: Type = 90;
    pub const ARM64_REG_H18: Type = 91;
    pub const ARM64_REG_H19: Type = 92;
    pub const ARM64_REG_H20: Type = 93;
    pub const ARM64_REG_H21: Type = 94;
    pub const ARM64_REG_H22: Type = 95;
    pub const ARM64_REG_H23: Type = 96;
    pub const ARM64_REG_H24: Type = 97;
    pub const ARM64_REG_H25: Type = 98;
    pub const ARM64_REG_H26: Type = 99;
    pub const ARM64_REG_H27: Type = 100;
    pub const ARM64_REG_H28: Type = 101;
    pub const ARM64_REG_H29: Type = 102;
    pub const ARM64_REG_H30: Type = 103;
    pub const ARM64_REG_H31: Type = 104;
    pub const ARM64_REG_P0: Type = 105;
    pub const ARM64_REG_P1: Type = 106;
    pub const ARM64_REG_P2: Type = 107;
    pub const ARM64_REG_P3: Type = 108;
    pub const ARM64_REG_P4: Type = 109;
    pub const ARM64_REG_P5: Type = 110;
    pub const ARM64_REG_P6: Type = 111;
    pub const ARM64_REG_P7: Type = 112;
    pub const ARM64_REG_P8: Type = 113;
    pub const ARM64_REG_P9: Type = 114;
    pub const ARM64_REG_P10: Type = 115;
    pub const ARM64_REG_P11: Type = 116;
    pub const ARM64_REG_P12: Type = 117;
    pub const ARM64_REG_P13: Type = 118;
    pub const ARM64_REG_P14: Type = 119;
    pub const ARM64_REG_P15: Type = 120;
    pub const ARM64_REG_Q0: Type = 121;
    pub const ARM64_REG_Q1: Type = 122;
    pub const ARM64_REG_Q2: Type = 123;
    pub const ARM64_REG_Q3: Type = 124;
    pub const ARM64_REG_Q4: Type = 125;
    pub const ARM64_REG_Q5: Type = 126;
    pub const ARM64_REG_Q6: Type = 127;
    pub const ARM64_REG_Q7: Type = 128;
    pub const ARM64_REG_Q8: Type = 129;
    pub const ARM64_REG_Q9: Type = 130;
    pub const ARM64_REG_Q10: Type = 131;
    pub const ARM64_REG_Q11: Type = 132;
    pub const ARM64_REG_Q12: Type = 133;
    pub const ARM64_REG_Q13: Type = 134;
    pub const ARM64_REG_Q14: Type = 135;
    pub const ARM64_REG_Q15: Type = 136;
    pub const ARM64_REG_Q16: Type = 137;
    pub const ARM64_REG_Q17: Type = 138;
    pub const ARM64_REG_Q18: Type = 139;
    pub const ARM64_REG_Q19: Type = 140;
    pub const ARM64_REG_Q20: Type = 141;
    pub const ARM64_REG_Q21: Type = 142;
    pub const ARM64_REG_Q22: Type = 143;
    pub const ARM64_REG_Q23: Type = 144;
    pub const ARM64_REG_Q24: Type = 145;
    pub const ARM64_REG_Q25: Type = 146;
    pub const ARM64_REG_Q26: Type = 147;
    pub const ARM64_REG_Q27: Type = 148;
    pub const ARM64_REG_Q28: Type = 149;
    pub const ARM64_REG_Q29: Type = 150;
    pub const ARM64_REG_Q30: Type = 151;
    pub const ARM64_REG_Q31: Type = 152;
    pub const ARM64_REG_S0: Type = 153;
    pub const ARM64_REG_S1: Type = 154;
    pub const ARM64_REG_S2: Type = 155;
    pub const ARM64_REG_S3: Type = 156;
    pub const ARM64_REG_S4: Type = 157;
    pub const ARM64_REG_S5: Type = 158;
    pub const ARM64_REG_S6: Type = 159;
    pub const ARM64_REG_S7: Type = 160;
    pub const ARM64_REG_S8: Type = 161;
    pub const ARM64_REG_S9: Type = 162;
    pub const ARM64_REG_S10: Type = 163;
    pub const ARM64_REG_S11: Type = 164;
    pub const ARM64_REG_S12: Type = 165;
    pub const ARM64_REG_S13: Type = 166;
    pub const ARM64_REG_S14: Type = 167;
    pub const ARM64_REG_S15: Type = 168;
    pub const ARM64_REG_S16: Type = 169;
    pub const ARM64_REG_S17: Type = 170;
    pub const ARM64_REG_S18: Type = 171;
    pub const ARM64_REG_S19: Type = 172;
    pub const ARM64_REG_S20: Type = 173;
    pub const ARM64_REG_S21: Type = 174;
    pub const ARM64_REG_S22: Type = 175;
    pub const ARM64_REG_S23: Type = 176;
    pub const ARM64_REG_S24: Type = 177;
    pub const ARM64_REG_S25: Type = 178;
    pub const ARM64_REG_S26: Type = 179;
    pub const ARM64_REG_S27: Type = 180;
    pub const ARM64_REG_S28: Type = 181;
    pub const ARM64_REG_S29: Type = 182;
    pub const ARM64_REG_S30: Type = 183;
    pub const ARM64_REG_S31: Type = 184;
    pub const ARM64_REG_W0: Type = 185;
    pub const ARM64_REG_W1: Type = 186;
    pub const ARM64_REG_W2: Type = 187;
    pub const ARM64_REG_W3: Type = 188;
    pub const ARM64_REG_W4: Type = 189;
    pub const ARM64_REG_W5: Type = 190;
    pub const ARM64_REG_W6: Type = 191;
    pub const ARM64_REG_W7: Type = 192;
    pub const ARM64_REG_W8: Type = 193;
    pub const ARM64_REG_W9: Type = 194;
    pub const ARM64_REG_W10: Type = 195;
    pub const ARM64_REG_W11: Type = 196;
    pub const ARM64_REG_W12: Type = 197;
    pub const ARM64_REG_W13: Type = 198;
    pub const ARM64_REG_W14: Type = 199;
    pub const ARM64_REG_W15: Type = 200;
    pub const ARM64_REG_W16: Type = 201;
    pub const ARM64_REG_W17: Type = 202;
    pub const ARM64_REG_W18: Type = 203;
    pub const ARM64_REG_W19: Type = 204;
    pub const ARM64_REG_W20: Type = 205;
    pub const ARM64_REG_W21: Type = 206;
    pub const ARM64_REG_W22: Type = 207;
    pub const ARM64_REG_W23: Type = 208;
    pub const ARM64_REG_W24: Type = 209;
    pub const ARM64_REG_W25: Type = 210;
    pub const ARM64_REG_W26: Type = 211;
    pub const ARM64_REG_W27: Type = 212;
    pub const ARM64_REG_W28: Type = 213;
    pub const ARM64_REG_W29: Type = 214;
    pub const ARM64_REG_W30: Type = 215;
    pub const ARM64_REG_X0: Type = 216;
    pub const ARM64_REG_X1: Type = 217;
    pub const ARM64_REG_X2: Type = 218;
    pub const ARM64_REG_X3: Type = 219;
    pub const ARM64_REG_X4: Type = 220;
    pub const ARM64_REG_X5: Type = 221;
    pub const ARM64_REG_X6: Type = 222;
    pub const ARM64_REG_X7: Type = 223;
    pub const ARM64_REG_X8: Type = 224;
    pub const ARM64_REG_X9: Type = 225;
    pub const ARM64_REG_X10: Type = 226;
    pub const ARM64_REG_X11: Type = 227;
    pub const ARM64_REG_X12: Type = 228;
    pub const ARM64_REG_X13: Type = 229;
    pub const ARM64_REG_X14: Type = 230;
    pub const ARM64_REG_X15: Type = 231;
    pub const ARM64_REG_X16: Type = 232;
    pub const ARM64_REG_X17: Type = 233;
    pub const ARM64_REG_X18: Type = 234;
    pub const ARM64_REG_X19: Type = 235;
    pub const ARM64_REG_X20: Type = 236;
    pub const ARM64_REG_X21: Type = 237;
    pub const ARM64_REG_X22: Type = 238;
    pub const ARM64_REG_X23: Type = 239;
    pub const ARM64_REG_X24: Type = 240;
    pub const ARM64_REG_X25: Type = 241;
    pub const ARM64_REG_X26: Type = 242;
    pub const ARM64_REG_X27: Type = 243;
    pub const ARM64_REG_X28: Type = 244;
    pub const ARM64_REG_Z0: Type = 245;
    pub const ARM64_REG_Z1: Type = 246;
    pub const ARM64_REG_Z2: Type = 247;
    pub const ARM64_REG_Z3: Type = 248;
    pub const ARM64_REG_Z4: Type = 249;
    pub const ARM64_REG_Z5: Type = 250;
    pub const ARM64_REG_Z6: Type = 251;
    pub const ARM64_REG_Z7: Type = 252;
    pub const ARM64_REG_Z8: Type = 253;
    pub const ARM64_REG_Z9: Type = 254;
    pub const ARM64_REG_Z10: Type = 255;
    pub const ARM64_REG_Z11: Type = 256;
    pub const ARM64_REG_Z12: Type = 257;
    pub const ARM64_REG_Z13: Type = 258;
    pub const ARM64_REG_Z14: Type = 259;
    pub const ARM64_REG_Z15: Type = 260;
    pub const ARM64_REG_Z16: Type = 261;
    pub const ARM64_REG_Z17: Type = 262;
    pub const ARM64_REG_Z18: Type = 263;
    pub const ARM64_REG_Z19: Type = 264;
    pub const ARM64_REG_Z20: Type = 265;
    pub const ARM64_REG_Z21: Type = 266;
    pub const ARM64_REG_Z22: Type = 267;
    pub const ARM64_REG_Z23: Type = 268;
    pub const ARM64_REG_Z24: Type = 269;
    pub const ARM64_REG_Z25: Type = 270;
    pub const ARM64_REG_Z26: Type = 271;
    pub const ARM64_REG_Z27: Type = 272;
    pub const ARM64_REG_Z28: Type = 273;
    pub const ARM64_REG_Z29: Type = 274;
    pub const ARM64_REG_Z30: Type = 275;
    pub const ARM64_REG_Z31: Type = 276;
    pub const ARM64_REG_V0: Type = 277;
    pub const ARM64_REG_V1: Type = 278;
    pub const ARM64_REG_V2: Type = 279;
    pub const ARM64_REG_V3: Type = 280;
    pub const ARM64_REG_V4: Type = 281;
    pub const ARM64_REG_V5: Type = 282;
    pub const ARM64_REG_V6: Type = 283;
    pub const ARM64_REG_V7: Type = 284;
    pub const ARM64_REG_V8: Type = 285;
    pub const ARM64_REG_V9: Type = 286;
    pub const ARM64_REG_V10: Type = 287;
    pub const ARM64_REG_V11: Type = 288;
    pub const ARM64_REG_V12: Type = 289;
    pub const ARM64_REG_V13: Type = 290;
    pub const ARM64_REG_V14: Type = 291;
    pub const ARM64_REG_V15: Type = 292;
    pub const ARM64_REG_V16: Type = 293;
    pub const ARM64_REG_V17: Type = 294;
    pub const ARM64_REG_V18: Type = 295;
    pub const ARM64_REG_V19: Type = 296;
    pub const ARM64_REG_V20: Type = 297;
    pub const ARM64_REG_V21: Type = 298;
    pub const ARM64_REG_V22: Type = 299;
    pub const ARM64_REG_V23: Type = 300;
    pub const ARM64_REG_V24: Type = 301;
    pub const ARM64_REG_V25: Type = 302;
    pub const ARM64_REG_V26: Type = 303;
    pub const ARM64_REG_V27: Type = 304;
    pub const ARM64_REG_V28: Type = 305;
    pub const ARM64_REG_V29: Type = 306;
    pub const ARM64_REG_V30: Type = 307;
    pub const ARM64_REG_V31: Type = 308;
    pub const ARM64_REG_ENDING: Type = 309;
    pub const ARM64_REG_IP0: Type = 232;
    pub const ARM64_REG_IP1: Type = 233;
    pub const ARM64_REG_X29: Type = 2;
    pub const ARM64_REG_X30: Type = 3;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with ARM64_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct arm64_op_mem {
    #[doc = "< base register"]
    pub base: arm64_reg::Type,
    #[doc = "< index register"]
    pub index: arm64_reg::Type,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
}
impl Clone for arm64_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm64_op {
    #[doc = "< Vector Index for some vector operands (or -1 if irrelevant)"]
    pub vector_index: libc::c_int,
    #[doc = "< Vector Arrangement Specifier"]
    pub vas: arm64_vas,
    pub shift: cs_arm64_op__bindgen_ty_1,
    #[doc = "< extender type of this operand"]
    pub ext: arm64_extender,
    #[doc = "< operand type"]
    pub type_: arm64_op_type,
    pub __bindgen_anon_1: cs_arm64_op__bindgen_ty_2,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_arm64_op__bindgen_ty_1 {
    #[doc = "< shifter type of this operand"]
    pub type_: arm64_shifter,
    #[doc = "< shifter value of this operand"]
    pub value: libc::c_uint,
}
impl Clone for cs_arm64_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub union cs_arm64_op__bindgen_ty_2 {
    #[doc = "< register value for REG operand"]
    pub reg: arm64_reg::Type,
    #[doc = "< immediate value, or index for C-IMM or IMM operand"]
    pub imm: i64,
    #[doc = "< floating point value for FP operand"]
    pub fp: f64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: arm64_op_mem,
    #[doc = "< PState field of MSR instruction."]
    pub pstate: arm64_pstate,
    #[doc = "< IC/DC/AT/TLBI operation (see arm64_ic_op, arm64_dc_op, arm64_at_op, arm64_tlbi_op)"]
    pub sys: libc::c_uint,
    #[doc = "< PRFM operation."]
    pub prefetch: arm64_prefetch_op,
    #[doc = "< Memory barrier operation (ISB/DMB/DSB instructions)."]
    pub barrier: arm64_barrier_op,
}
impl Clone for cs_arm64_op__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm64_op__bindgen_ty_2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_arm64_op__bindgen_ty_2 {{ union }}")
    }
}
impl Clone for cs_arm64_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm64_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_arm64_op {{ vector_index: {:?}, vas: {:?}, shift: {:?}, ext: {:?}, type: {:?}, __bindgen_anon_1: {:?}, access: {:?} }}" , self . vector_index , self . vas , self . shift , self . ext , self . type_ , self . __bindgen_anon_1 , self . access)
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_arm64 {
    #[doc = "< conditional code for this insn"]
    pub cc: arm64_cc,
    #[doc = "< does this insn update flags?"]
    pub update_flags: bool,
    #[doc = "< does this insn request writeback? 'True' means 'yes'"]
    pub writeback: bool,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_arm64_op; 8usize],
}
impl Clone for cs_arm64 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_arm64 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_arm64 {{ cc: {:?}, update_flags: {:?}, writeback: {:?}, op_count: {:?}, operands: {:?} }}" , self . cc , self . update_flags , self . writeback , self . op_count , self . operands)
    }
}
#[repr(u32)]
#[doc = " ARM64 instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum arm64_insn {
    ARM64_INS_INVALID = 0,
    ARM64_INS_ABS = 1,
    ARM64_INS_ADC = 2,
    ARM64_INS_ADCS = 3,
    ARM64_INS_ADD = 4,
    ARM64_INS_ADDHN = 5,
    ARM64_INS_ADDHN2 = 6,
    ARM64_INS_ADDP = 7,
    ARM64_INS_ADDPL = 8,
    ARM64_INS_ADDS = 9,
    ARM64_INS_ADDV = 10,
    ARM64_INS_ADDVL = 11,
    ARM64_INS_ADR = 12,
    ARM64_INS_ADRP = 13,
    ARM64_INS_AESD = 14,
    ARM64_INS_AESE = 15,
    ARM64_INS_AESIMC = 16,
    ARM64_INS_AESMC = 17,
    ARM64_INS_AND = 18,
    ARM64_INS_ANDS = 19,
    ARM64_INS_ANDV = 20,
    ARM64_INS_ASR = 21,
    ARM64_INS_ASRD = 22,
    ARM64_INS_ASRR = 23,
    ARM64_INS_ASRV = 24,
    ARM64_INS_AUTDA = 25,
    ARM64_INS_AUTDB = 26,
    ARM64_INS_AUTDZA = 27,
    ARM64_INS_AUTDZB = 28,
    ARM64_INS_AUTIA = 29,
    ARM64_INS_AUTIA1716 = 30,
    ARM64_INS_AUTIASP = 31,
    ARM64_INS_AUTIAZ = 32,
    ARM64_INS_AUTIB = 33,
    ARM64_INS_AUTIB1716 = 34,
    ARM64_INS_AUTIBSP = 35,
    ARM64_INS_AUTIBZ = 36,
    ARM64_INS_AUTIZA = 37,
    ARM64_INS_AUTIZB = 38,
    ARM64_INS_B = 39,
    ARM64_INS_BCAX = 40,
    ARM64_INS_BFM = 41,
    ARM64_INS_BIC = 42,
    ARM64_INS_BICS = 43,
    ARM64_INS_BIF = 44,
    ARM64_INS_BIT = 45,
    ARM64_INS_BL = 46,
    ARM64_INS_BLR = 47,
    ARM64_INS_BLRAA = 48,
    ARM64_INS_BLRAAZ = 49,
    ARM64_INS_BLRAB = 50,
    ARM64_INS_BLRABZ = 51,
    ARM64_INS_BR = 52,
    ARM64_INS_BRAA = 53,
    ARM64_INS_BRAAZ = 54,
    ARM64_INS_BRAB = 55,
    ARM64_INS_BRABZ = 56,
    ARM64_INS_BRK = 57,
    ARM64_INS_BRKA = 58,
    ARM64_INS_BRKAS = 59,
    ARM64_INS_BRKB = 60,
    ARM64_INS_BRKBS = 61,
    ARM64_INS_BRKN = 62,
    ARM64_INS_BRKNS = 63,
    ARM64_INS_BRKPA = 64,
    ARM64_INS_BRKPAS = 65,
    ARM64_INS_BRKPB = 66,
    ARM64_INS_BRKPBS = 67,
    ARM64_INS_BSL = 68,
    ARM64_INS_CAS = 69,
    ARM64_INS_CASA = 70,
    ARM64_INS_CASAB = 71,
    ARM64_INS_CASAH = 72,
    ARM64_INS_CASAL = 73,
    ARM64_INS_CASALB = 74,
    ARM64_INS_CASALH = 75,
    ARM64_INS_CASB = 76,
    ARM64_INS_CASH = 77,
    ARM64_INS_CASL = 78,
    ARM64_INS_CASLB = 79,
    ARM64_INS_CASLH = 80,
    ARM64_INS_CASP = 81,
    ARM64_INS_CASPA = 82,
    ARM64_INS_CASPAL = 83,
    ARM64_INS_CASPL = 84,
    ARM64_INS_CBNZ = 85,
    ARM64_INS_CBZ = 86,
    ARM64_INS_CCMN = 87,
    ARM64_INS_CCMP = 88,
    ARM64_INS_CFINV = 89,
    ARM64_INS_CINC = 90,
    ARM64_INS_CINV = 91,
    ARM64_INS_CLASTA = 92,
    ARM64_INS_CLASTB = 93,
    ARM64_INS_CLREX = 94,
    ARM64_INS_CLS = 95,
    ARM64_INS_CLZ = 96,
    ARM64_INS_CMEQ = 97,
    ARM64_INS_CMGE = 98,
    ARM64_INS_CMGT = 99,
    ARM64_INS_CMHI = 100,
    ARM64_INS_CMHS = 101,
    ARM64_INS_CMLE = 102,
    ARM64_INS_CMLO = 103,
    ARM64_INS_CMLS = 104,
    ARM64_INS_CMLT = 105,
    ARM64_INS_CMN = 106,
    ARM64_INS_CMP = 107,
    ARM64_INS_CMPEQ = 108,
    ARM64_INS_CMPGE = 109,
    ARM64_INS_CMPGT = 110,
    ARM64_INS_CMPHI = 111,
    ARM64_INS_CMPHS = 112,
    ARM64_INS_CMPLE = 113,
    ARM64_INS_CMPLO = 114,
    ARM64_INS_CMPLS = 115,
    ARM64_INS_CMPLT = 116,
    ARM64_INS_CMPNE = 117,
    ARM64_INS_CMTST = 118,
    ARM64_INS_CNEG = 119,
    ARM64_INS_CNOT = 120,
    ARM64_INS_CNT = 121,
    ARM64_INS_CNTB = 122,
    ARM64_INS_CNTD = 123,
    ARM64_INS_CNTH = 124,
    ARM64_INS_CNTP = 125,
    ARM64_INS_CNTW = 126,
    ARM64_INS_COMPACT = 127,
    ARM64_INS_CPY = 128,
    ARM64_INS_CRC32B = 129,
    ARM64_INS_CRC32CB = 130,
    ARM64_INS_CRC32CH = 131,
    ARM64_INS_CRC32CW = 132,
    ARM64_INS_CRC32CX = 133,
    ARM64_INS_CRC32H = 134,
    ARM64_INS_CRC32W = 135,
    ARM64_INS_CRC32X = 136,
    ARM64_INS_CSDB = 137,
    ARM64_INS_CSEL = 138,
    ARM64_INS_CSET = 139,
    ARM64_INS_CSETM = 140,
    ARM64_INS_CSINC = 141,
    ARM64_INS_CSINV = 142,
    ARM64_INS_CSNEG = 143,
    ARM64_INS_CTERMEQ = 144,
    ARM64_INS_CTERMNE = 145,
    ARM64_INS_DCPS1 = 146,
    ARM64_INS_DCPS2 = 147,
    ARM64_INS_DCPS3 = 148,
    ARM64_INS_DECB = 149,
    ARM64_INS_DECD = 150,
    ARM64_INS_DECH = 151,
    ARM64_INS_DECP = 152,
    ARM64_INS_DECW = 153,
    ARM64_INS_DMB = 154,
    ARM64_INS_DRPS = 155,
    ARM64_INS_DSB = 156,
    ARM64_INS_DUP = 157,
    ARM64_INS_DUPM = 158,
    ARM64_INS_EON = 159,
    ARM64_INS_EOR = 160,
    ARM64_INS_EOR3 = 161,
    ARM64_INS_EORS = 162,
    ARM64_INS_EORV = 163,
    ARM64_INS_ERET = 164,
    ARM64_INS_ERETAA = 165,
    ARM64_INS_ERETAB = 166,
    ARM64_INS_ESB = 167,
    ARM64_INS_EXT = 168,
    ARM64_INS_EXTR = 169,
    ARM64_INS_FABD = 170,
    ARM64_INS_FABS = 171,
    ARM64_INS_FACGE = 172,
    ARM64_INS_FACGT = 173,
    ARM64_INS_FACLE = 174,
    ARM64_INS_FACLT = 175,
    ARM64_INS_FADD = 176,
    ARM64_INS_FADDA = 177,
    ARM64_INS_FADDP = 178,
    ARM64_INS_FADDV = 179,
    ARM64_INS_FCADD = 180,
    ARM64_INS_FCCMP = 181,
    ARM64_INS_FCCMPE = 182,
    ARM64_INS_FCMEQ = 183,
    ARM64_INS_FCMGE = 184,
    ARM64_INS_FCMGT = 185,
    ARM64_INS_FCMLA = 186,
    ARM64_INS_FCMLE = 187,
    ARM64_INS_FCMLT = 188,
    ARM64_INS_FCMNE = 189,
    ARM64_INS_FCMP = 190,
    ARM64_INS_FCMPE = 191,
    ARM64_INS_FCMUO = 192,
    ARM64_INS_FCPY = 193,
    ARM64_INS_FCSEL = 194,
    ARM64_INS_FCVT = 195,
    ARM64_INS_FCVTAS = 196,
    ARM64_INS_FCVTAU = 197,
    ARM64_INS_FCVTL = 198,
    ARM64_INS_FCVTL2 = 199,
    ARM64_INS_FCVTMS = 200,
    ARM64_INS_FCVTMU = 201,
    ARM64_INS_FCVTN = 202,
    ARM64_INS_FCVTN2 = 203,
    ARM64_INS_FCVTNS = 204,
    ARM64_INS_FCVTNU = 205,
    ARM64_INS_FCVTPS = 206,
    ARM64_INS_FCVTPU = 207,
    ARM64_INS_FCVTXN = 208,
    ARM64_INS_FCVTXN2 = 209,
    ARM64_INS_FCVTZS = 210,
    ARM64_INS_FCVTZU = 211,
    ARM64_INS_FDIV = 212,
    ARM64_INS_FDIVR = 213,
    ARM64_INS_FDUP = 214,
    ARM64_INS_FEXPA = 215,
    ARM64_INS_FJCVTZS = 216,
    ARM64_INS_FMAD = 217,
    ARM64_INS_FMADD = 218,
    ARM64_INS_FMAX = 219,
    ARM64_INS_FMAXNM = 220,
    ARM64_INS_FMAXNMP = 221,
    ARM64_INS_FMAXNMV = 222,
    ARM64_INS_FMAXP = 223,
    ARM64_INS_FMAXV = 224,
    ARM64_INS_FMIN = 225,
    ARM64_INS_FMINNM = 226,
    ARM64_INS_FMINNMP = 227,
    ARM64_INS_FMINNMV = 228,
    ARM64_INS_FMINP = 229,
    ARM64_INS_FMINV = 230,
    ARM64_INS_FMLA = 231,
    ARM64_INS_FMLS = 232,
    ARM64_INS_FMOV = 233,
    ARM64_INS_FMSB = 234,
    ARM64_INS_FMSUB = 235,
    ARM64_INS_FMUL = 236,
    ARM64_INS_FMULX = 237,
    ARM64_INS_FNEG = 238,
    ARM64_INS_FNMAD = 239,
    ARM64_INS_FNMADD = 240,
    ARM64_INS_FNMLA = 241,
    ARM64_INS_FNMLS = 242,
    ARM64_INS_FNMSB = 243,
    ARM64_INS_FNMSUB = 244,
    ARM64_INS_FNMUL = 245,
    ARM64_INS_FRECPE = 246,
    ARM64_INS_FRECPS = 247,
    ARM64_INS_FRECPX = 248,
    ARM64_INS_FRINTA = 249,
    ARM64_INS_FRINTI = 250,
    ARM64_INS_FRINTM = 251,
    ARM64_INS_FRINTN = 252,
    ARM64_INS_FRINTP = 253,
    ARM64_INS_FRINTX = 254,
    ARM64_INS_FRINTZ = 255,
    ARM64_INS_FRSQRTE = 256,
    ARM64_INS_FRSQRTS = 257,
    ARM64_INS_FSCALE = 258,
    ARM64_INS_FSQRT = 259,
    ARM64_INS_FSUB = 260,
    ARM64_INS_FSUBR = 261,
    ARM64_INS_FTMAD = 262,
    ARM64_INS_FTSMUL = 263,
    ARM64_INS_FTSSEL = 264,
    ARM64_INS_HINT = 265,
    ARM64_INS_HLT = 266,
    ARM64_INS_HVC = 267,
    ARM64_INS_INCB = 268,
    ARM64_INS_INCD = 269,
    ARM64_INS_INCH = 270,
    ARM64_INS_INCP = 271,
    ARM64_INS_INCW = 272,
    ARM64_INS_INDEX = 273,
    ARM64_INS_INS = 274,
    ARM64_INS_INSR = 275,
    ARM64_INS_ISB = 276,
    ARM64_INS_LASTA = 277,
    ARM64_INS_LASTB = 278,
    ARM64_INS_LD1 = 279,
    ARM64_INS_LD1B = 280,
    ARM64_INS_LD1D = 281,
    ARM64_INS_LD1H = 282,
    ARM64_INS_LD1R = 283,
    ARM64_INS_LD1RB = 284,
    ARM64_INS_LD1RD = 285,
    ARM64_INS_LD1RH = 286,
    ARM64_INS_LD1RQB = 287,
    ARM64_INS_LD1RQD = 288,
    ARM64_INS_LD1RQH = 289,
    ARM64_INS_LD1RQW = 290,
    ARM64_INS_LD1RSB = 291,
    ARM64_INS_LD1RSH = 292,
    ARM64_INS_LD1RSW = 293,
    ARM64_INS_LD1RW = 294,
    ARM64_INS_LD1SB = 295,
    ARM64_INS_LD1SH = 296,
    ARM64_INS_LD1SW = 297,
    ARM64_INS_LD1W = 298,
    ARM64_INS_LD2 = 299,
    ARM64_INS_LD2B = 300,
    ARM64_INS_LD2D = 301,
    ARM64_INS_LD2H = 302,
    ARM64_INS_LD2R = 303,
    ARM64_INS_LD2W = 304,
    ARM64_INS_LD3 = 305,
    ARM64_INS_LD3B = 306,
    ARM64_INS_LD3D = 307,
    ARM64_INS_LD3H = 308,
    ARM64_INS_LD3R = 309,
    ARM64_INS_LD3W = 310,
    ARM64_INS_LD4 = 311,
    ARM64_INS_LD4B = 312,
    ARM64_INS_LD4D = 313,
    ARM64_INS_LD4H = 314,
    ARM64_INS_LD4R = 315,
    ARM64_INS_LD4W = 316,
    ARM64_INS_LDADD = 317,
    ARM64_INS_LDADDA = 318,
    ARM64_INS_LDADDAB = 319,
    ARM64_INS_LDADDAH = 320,
    ARM64_INS_LDADDAL = 321,
    ARM64_INS_LDADDALB = 322,
    ARM64_INS_LDADDALH = 323,
    ARM64_INS_LDADDB = 324,
    ARM64_INS_LDADDH = 325,
    ARM64_INS_LDADDL = 326,
    ARM64_INS_LDADDLB = 327,
    ARM64_INS_LDADDLH = 328,
    ARM64_INS_LDAPR = 329,
    ARM64_INS_LDAPRB = 330,
    ARM64_INS_LDAPRH = 331,
    ARM64_INS_LDAPUR = 332,
    ARM64_INS_LDAPURB = 333,
    ARM64_INS_LDAPURH = 334,
    ARM64_INS_LDAPURSB = 335,
    ARM64_INS_LDAPURSH = 336,
    ARM64_INS_LDAPURSW = 337,
    ARM64_INS_LDAR = 338,
    ARM64_INS_LDARB = 339,
    ARM64_INS_LDARH = 340,
    ARM64_INS_LDAXP = 341,
    ARM64_INS_LDAXR = 342,
    ARM64_INS_LDAXRB = 343,
    ARM64_INS_LDAXRH = 344,
    ARM64_INS_LDCLR = 345,
    ARM64_INS_LDCLRA = 346,
    ARM64_INS_LDCLRAB = 347,
    ARM64_INS_LDCLRAH = 348,
    ARM64_INS_LDCLRAL = 349,
    ARM64_INS_LDCLRALB = 350,
    ARM64_INS_LDCLRALH = 351,
    ARM64_INS_LDCLRB = 352,
    ARM64_INS_LDCLRH = 353,
    ARM64_INS_LDCLRL = 354,
    ARM64_INS_LDCLRLB = 355,
    ARM64_INS_LDCLRLH = 356,
    ARM64_INS_LDEOR = 357,
    ARM64_INS_LDEORA = 358,
    ARM64_INS_LDEORAB = 359,
    ARM64_INS_LDEORAH = 360,
    ARM64_INS_LDEORAL = 361,
    ARM64_INS_LDEORALB = 362,
    ARM64_INS_LDEORALH = 363,
    ARM64_INS_LDEORB = 364,
    ARM64_INS_LDEORH = 365,
    ARM64_INS_LDEORL = 366,
    ARM64_INS_LDEORLB = 367,
    ARM64_INS_LDEORLH = 368,
    ARM64_INS_LDFF1B = 369,
    ARM64_INS_LDFF1D = 370,
    ARM64_INS_LDFF1H = 371,
    ARM64_INS_LDFF1SB = 372,
    ARM64_INS_LDFF1SH = 373,
    ARM64_INS_LDFF1SW = 374,
    ARM64_INS_LDFF1W = 375,
    ARM64_INS_LDLAR = 376,
    ARM64_INS_LDLARB = 377,
    ARM64_INS_LDLARH = 378,
    ARM64_INS_LDNF1B = 379,
    ARM64_INS_LDNF1D = 380,
    ARM64_INS_LDNF1H = 381,
    ARM64_INS_LDNF1SB = 382,
    ARM64_INS_LDNF1SH = 383,
    ARM64_INS_LDNF1SW = 384,
    ARM64_INS_LDNF1W = 385,
    ARM64_INS_LDNP = 386,
    ARM64_INS_LDNT1B = 387,
    ARM64_INS_LDNT1D = 388,
    ARM64_INS_LDNT1H = 389,
    ARM64_INS_LDNT1W = 390,
    ARM64_INS_LDP = 391,
    ARM64_INS_LDPSW = 392,
    ARM64_INS_LDR = 393,
    ARM64_INS_LDRAA = 394,
    ARM64_INS_LDRAB = 395,
    ARM64_INS_LDRB = 396,
    ARM64_INS_LDRH = 397,
    ARM64_INS_LDRSB = 398,
    ARM64_INS_LDRSH = 399,
    ARM64_INS_LDRSW = 400,
    ARM64_INS_LDSET = 401,
    ARM64_INS_LDSETA = 402,
    ARM64_INS_LDSETAB = 403,
    ARM64_INS_LDSETAH = 404,
    ARM64_INS_LDSETAL = 405,
    ARM64_INS_LDSETALB = 406,
    ARM64_INS_LDSETALH = 407,
    ARM64_INS_LDSETB = 408,
    ARM64_INS_LDSETH = 409,
    ARM64_INS_LDSETL = 410,
    ARM64_INS_LDSETLB = 411,
    ARM64_INS_LDSETLH = 412,
    ARM64_INS_LDSMAX = 413,
    ARM64_INS_LDSMAXA = 414,
    ARM64_INS_LDSMAXAB = 415,
    ARM64_INS_LDSMAXAH = 416,
    ARM64_INS_LDSMAXAL = 417,
    ARM64_INS_LDSMAXALB = 418,
    ARM64_INS_LDSMAXALH = 419,
    ARM64_INS_LDSMAXB = 420,
    ARM64_INS_LDSMAXH = 421,
    ARM64_INS_LDSMAXL = 422,
    ARM64_INS_LDSMAXLB = 423,
    ARM64_INS_LDSMAXLH = 424,
    ARM64_INS_LDSMIN = 425,
    ARM64_INS_LDSMINA = 426,
    ARM64_INS_LDSMINAB = 427,
    ARM64_INS_LDSMINAH = 428,
    ARM64_INS_LDSMINAL = 429,
    ARM64_INS_LDSMINALB = 430,
    ARM64_INS_LDSMINALH = 431,
    ARM64_INS_LDSMINB = 432,
    ARM64_INS_LDSMINH = 433,
    ARM64_INS_LDSMINL = 434,
    ARM64_INS_LDSMINLB = 435,
    ARM64_INS_LDSMINLH = 436,
    ARM64_INS_LDTR = 437,
    ARM64_INS_LDTRB = 438,
    ARM64_INS_LDTRH = 439,
    ARM64_INS_LDTRSB = 440,
    ARM64_INS_LDTRSH = 441,
    ARM64_INS_LDTRSW = 442,
    ARM64_INS_LDUMAX = 443,
    ARM64_INS_LDUMAXA = 444,
    ARM64_INS_LDUMAXAB = 445,
    ARM64_INS_LDUMAXAH = 446,
    ARM64_INS_LDUMAXAL = 447,
    ARM64_INS_LDUMAXALB = 448,
    ARM64_INS_LDUMAXALH = 449,
    ARM64_INS_LDUMAXB = 450,
    ARM64_INS_LDUMAXH = 451,
    ARM64_INS_LDUMAXL = 452,
    ARM64_INS_LDUMAXLB = 453,
    ARM64_INS_LDUMAXLH = 454,
    ARM64_INS_LDUMIN = 455,
    ARM64_INS_LDUMINA = 456,
    ARM64_INS_LDUMINAB = 457,
    ARM64_INS_LDUMINAH = 458,
    ARM64_INS_LDUMINAL = 459,
    ARM64_INS_LDUMINALB = 460,
    ARM64_INS_LDUMINALH = 461,
    ARM64_INS_LDUMINB = 462,
    ARM64_INS_LDUMINH = 463,
    ARM64_INS_LDUMINL = 464,
    ARM64_INS_LDUMINLB = 465,
    ARM64_INS_LDUMINLH = 466,
    ARM64_INS_LDUR = 467,
    ARM64_INS_LDURB = 468,
    ARM64_INS_LDURH = 469,
    ARM64_INS_LDURSB = 470,
    ARM64_INS_LDURSH = 471,
    ARM64_INS_LDURSW = 472,
    ARM64_INS_LDXP = 473,
    ARM64_INS_LDXR = 474,
    ARM64_INS_LDXRB = 475,
    ARM64_INS_LDXRH = 476,
    ARM64_INS_LSL = 477,
    ARM64_INS_LSLR = 478,
    ARM64_INS_LSLV = 479,
    ARM64_INS_LSR = 480,
    ARM64_INS_LSRR = 481,
    ARM64_INS_LSRV = 482,
    ARM64_INS_MAD = 483,
    ARM64_INS_MADD = 484,
    ARM64_INS_MLA = 485,
    ARM64_INS_MLS = 486,
    ARM64_INS_MNEG = 487,
    ARM64_INS_MOV = 488,
    ARM64_INS_MOVI = 489,
    ARM64_INS_MOVK = 490,
    ARM64_INS_MOVN = 491,
    ARM64_INS_MOVPRFX = 492,
    ARM64_INS_MOVS = 493,
    ARM64_INS_MOVZ = 494,
    ARM64_INS_MRS = 495,
    ARM64_INS_MSB = 496,
    ARM64_INS_MSR = 497,
    ARM64_INS_MSUB = 498,
    ARM64_INS_MUL = 499,
    ARM64_INS_MVN = 500,
    ARM64_INS_MVNI = 501,
    ARM64_INS_NAND = 502,
    ARM64_INS_NANDS = 503,
    ARM64_INS_NEG = 504,
    ARM64_INS_NEGS = 505,
    ARM64_INS_NGC = 506,
    ARM64_INS_NGCS = 507,
    ARM64_INS_NOP = 508,
    ARM64_INS_NOR = 509,
    ARM64_INS_NORS = 510,
    ARM64_INS_NOT = 511,
    ARM64_INS_NOTS = 512,
    ARM64_INS_ORN = 513,
    ARM64_INS_ORNS = 514,
    ARM64_INS_ORR = 515,
    ARM64_INS_ORRS = 516,
    ARM64_INS_ORV = 517,
    ARM64_INS_PACDA = 518,
    ARM64_INS_PACDB = 519,
    ARM64_INS_PACDZA = 520,
    ARM64_INS_PACDZB = 521,
    ARM64_INS_PACGA = 522,
    ARM64_INS_PACIA = 523,
    ARM64_INS_PACIA1716 = 524,
    ARM64_INS_PACIASP = 525,
    ARM64_INS_PACIAZ = 526,
    ARM64_INS_PACIB = 527,
    ARM64_INS_PACIB1716 = 528,
    ARM64_INS_PACIBSP = 529,
    ARM64_INS_PACIBZ = 530,
    ARM64_INS_PACIZA = 531,
    ARM64_INS_PACIZB = 532,
    ARM64_INS_PFALSE = 533,
    ARM64_INS_PFIRST = 534,
    ARM64_INS_PMUL = 535,
    ARM64_INS_PMULL = 536,
    ARM64_INS_PMULL2 = 537,
    ARM64_INS_PNEXT = 538,
    ARM64_INS_PRFB = 539,
    ARM64_INS_PRFD = 540,
    ARM64_INS_PRFH = 541,
    ARM64_INS_PRFM = 542,
    ARM64_INS_PRFUM = 543,
    ARM64_INS_PRFW = 544,
    ARM64_INS_PSB = 545,
    ARM64_INS_PTEST = 546,
    ARM64_INS_PTRUE = 547,
    ARM64_INS_PTRUES = 548,
    ARM64_INS_PUNPKHI = 549,
    ARM64_INS_PUNPKLO = 550,
    ARM64_INS_RADDHN = 551,
    ARM64_INS_RADDHN2 = 552,
    ARM64_INS_RAX1 = 553,
    ARM64_INS_RBIT = 554,
    ARM64_INS_RDFFR = 555,
    ARM64_INS_RDFFRS = 556,
    ARM64_INS_RDVL = 557,
    ARM64_INS_RET = 558,
    ARM64_INS_RETAA = 559,
    ARM64_INS_RETAB = 560,
    ARM64_INS_REV = 561,
    ARM64_INS_REV16 = 562,
    ARM64_INS_REV32 = 563,
    ARM64_INS_REV64 = 564,
    ARM64_INS_REVB = 565,
    ARM64_INS_REVH = 566,
    ARM64_INS_REVW = 567,
    ARM64_INS_RMIF = 568,
    ARM64_INS_ROR = 569,
    ARM64_INS_RORV = 570,
    ARM64_INS_RSHRN = 571,
    ARM64_INS_RSHRN2 = 572,
    ARM64_INS_RSUBHN = 573,
    ARM64_INS_RSUBHN2 = 574,
    ARM64_INS_SABA = 575,
    ARM64_INS_SABAL = 576,
    ARM64_INS_SABAL2 = 577,
    ARM64_INS_SABD = 578,
    ARM64_INS_SABDL = 579,
    ARM64_INS_SABDL2 = 580,
    ARM64_INS_SADALP = 581,
    ARM64_INS_SADDL = 582,
    ARM64_INS_SADDL2 = 583,
    ARM64_INS_SADDLP = 584,
    ARM64_INS_SADDLV = 585,
    ARM64_INS_SADDV = 586,
    ARM64_INS_SADDW = 587,
    ARM64_INS_SADDW2 = 588,
    ARM64_INS_SBC = 589,
    ARM64_INS_SBCS = 590,
    ARM64_INS_SBFM = 591,
    ARM64_INS_SCVTF = 592,
    ARM64_INS_SDIV = 593,
    ARM64_INS_SDIVR = 594,
    ARM64_INS_SDOT = 595,
    ARM64_INS_SEL = 596,
    ARM64_INS_SETF16 = 597,
    ARM64_INS_SETF8 = 598,
    ARM64_INS_SETFFR = 599,
    ARM64_INS_SEV = 600,
    ARM64_INS_SEVL = 601,
    ARM64_INS_SHA1C = 602,
    ARM64_INS_SHA1H = 603,
    ARM64_INS_SHA1M = 604,
    ARM64_INS_SHA1P = 605,
    ARM64_INS_SHA1SU0 = 606,
    ARM64_INS_SHA1SU1 = 607,
    ARM64_INS_SHA256H = 608,
    ARM64_INS_SHA256H2 = 609,
    ARM64_INS_SHA256SU0 = 610,
    ARM64_INS_SHA256SU1 = 611,
    ARM64_INS_SHA512H = 612,
    ARM64_INS_SHA512H2 = 613,
    ARM64_INS_SHA512SU0 = 614,
    ARM64_INS_SHA512SU1 = 615,
    ARM64_INS_SHADD = 616,
    ARM64_INS_SHL = 617,
    ARM64_INS_SHLL = 618,
    ARM64_INS_SHLL2 = 619,
    ARM64_INS_SHRN = 620,
    ARM64_INS_SHRN2 = 621,
    ARM64_INS_SHSUB = 622,
    ARM64_INS_SLI = 623,
    ARM64_INS_SM3PARTW1 = 624,
    ARM64_INS_SM3PARTW2 = 625,
    ARM64_INS_SM3SS1 = 626,
    ARM64_INS_SM3TT1A = 627,
    ARM64_INS_SM3TT1B = 628,
    ARM64_INS_SM3TT2A = 629,
    ARM64_INS_SM3TT2B = 630,
    ARM64_INS_SM4E = 631,
    ARM64_INS_SM4EKEY = 632,
    ARM64_INS_SMADDL = 633,
    ARM64_INS_SMAX = 634,
    ARM64_INS_SMAXP = 635,
    ARM64_INS_SMAXV = 636,
    ARM64_INS_SMC = 637,
    ARM64_INS_SMIN = 638,
    ARM64_INS_SMINP = 639,
    ARM64_INS_SMINV = 640,
    ARM64_INS_SMLAL = 641,
    ARM64_INS_SMLAL2 = 642,
    ARM64_INS_SMLSL = 643,
    ARM64_INS_SMLSL2 = 644,
    ARM64_INS_SMNEGL = 645,
    ARM64_INS_SMOV = 646,
    ARM64_INS_SMSUBL = 647,
    ARM64_INS_SMULH = 648,
    ARM64_INS_SMULL = 649,
    ARM64_INS_SMULL2 = 650,
    ARM64_INS_SPLICE = 651,
    ARM64_INS_SQABS = 652,
    ARM64_INS_SQADD = 653,
    ARM64_INS_SQDECB = 654,
    ARM64_INS_SQDECD = 655,
    ARM64_INS_SQDECH = 656,
    ARM64_INS_SQDECP = 657,
    ARM64_INS_SQDECW = 658,
    ARM64_INS_SQDMLAL = 659,
    ARM64_INS_SQDMLAL2 = 660,
    ARM64_INS_SQDMLSL = 661,
    ARM64_INS_SQDMLSL2 = 662,
    ARM64_INS_SQDMULH = 663,
    ARM64_INS_SQDMULL = 664,
    ARM64_INS_SQDMULL2 = 665,
    ARM64_INS_SQINCB = 666,
    ARM64_INS_SQINCD = 667,
    ARM64_INS_SQINCH = 668,
    ARM64_INS_SQINCP = 669,
    ARM64_INS_SQINCW = 670,
    ARM64_INS_SQNEG = 671,
    ARM64_INS_SQRDMLAH = 672,
    ARM64_INS_SQRDMLSH = 673,
    ARM64_INS_SQRDMULH = 674,
    ARM64_INS_SQRSHL = 675,
    ARM64_INS_SQRSHRN = 676,
    ARM64_INS_SQRSHRN2 = 677,
    ARM64_INS_SQRSHRUN = 678,
    ARM64_INS_SQRSHRUN2 = 679,
    ARM64_INS_SQSHL = 680,
    ARM64_INS_SQSHLU = 681,
    ARM64_INS_SQSHRN = 682,
    ARM64_INS_SQSHRN2 = 683,
    ARM64_INS_SQSHRUN = 684,
    ARM64_INS_SQSHRUN2 = 685,
    ARM64_INS_SQSUB = 686,
    ARM64_INS_SQXTN = 687,
    ARM64_INS_SQXTN2 = 688,
    ARM64_INS_SQXTUN = 689,
    ARM64_INS_SQXTUN2 = 690,
    ARM64_INS_SRHADD = 691,
    ARM64_INS_SRI = 692,
    ARM64_INS_SRSHL = 693,
    ARM64_INS_SRSHR = 694,
    ARM64_INS_SRSRA = 695,
    ARM64_INS_SSHL = 696,
    ARM64_INS_SSHLL = 697,
    ARM64_INS_SSHLL2 = 698,
    ARM64_INS_SSHR = 699,
    ARM64_INS_SSRA = 700,
    ARM64_INS_SSUBL = 701,
    ARM64_INS_SSUBL2 = 702,
    ARM64_INS_SSUBW = 703,
    ARM64_INS_SSUBW2 = 704,
    ARM64_INS_ST1 = 705,
    ARM64_INS_ST1B = 706,
    ARM64_INS_ST1D = 707,
    ARM64_INS_ST1H = 708,
    ARM64_INS_ST1W = 709,
    ARM64_INS_ST2 = 710,
    ARM64_INS_ST2B = 711,
    ARM64_INS_ST2D = 712,
    ARM64_INS_ST2H = 713,
    ARM64_INS_ST2W = 714,
    ARM64_INS_ST3 = 715,
    ARM64_INS_ST3B = 716,
    ARM64_INS_ST3D = 717,
    ARM64_INS_ST3H = 718,
    ARM64_INS_ST3W = 719,
    ARM64_INS_ST4 = 720,
    ARM64_INS_ST4B = 721,
    ARM64_INS_ST4D = 722,
    ARM64_INS_ST4H = 723,
    ARM64_INS_ST4W = 724,
    ARM64_INS_STADD = 725,
    ARM64_INS_STADDB = 726,
    ARM64_INS_STADDH = 727,
    ARM64_INS_STADDL = 728,
    ARM64_INS_STADDLB = 729,
    ARM64_INS_STADDLH = 730,
    ARM64_INS_STCLR = 731,
    ARM64_INS_STCLRB = 732,
    ARM64_INS_STCLRH = 733,
    ARM64_INS_STCLRL = 734,
    ARM64_INS_STCLRLB = 735,
    ARM64_INS_STCLRLH = 736,
    ARM64_INS_STEOR = 737,
    ARM64_INS_STEORB = 738,
    ARM64_INS_STEORH = 739,
    ARM64_INS_STEORL = 740,
    ARM64_INS_STEORLB = 741,
    ARM64_INS_STEORLH = 742,
    ARM64_INS_STLLR = 743,
    ARM64_INS_STLLRB = 744,
    ARM64_INS_STLLRH = 745,
    ARM64_INS_STLR = 746,
    ARM64_INS_STLRB = 747,
    ARM64_INS_STLRH = 748,
    ARM64_INS_STLUR = 749,
    ARM64_INS_STLURB = 750,
    ARM64_INS_STLURH = 751,
    ARM64_INS_STLXP = 752,
    ARM64_INS_STLXR = 753,
    ARM64_INS_STLXRB = 754,
    ARM64_INS_STLXRH = 755,
    ARM64_INS_STNP = 756,
    ARM64_INS_STNT1B = 757,
    ARM64_INS_STNT1D = 758,
    ARM64_INS_STNT1H = 759,
    ARM64_INS_STNT1W = 760,
    ARM64_INS_STP = 761,
    ARM64_INS_STR = 762,
    ARM64_INS_STRB = 763,
    ARM64_INS_STRH = 764,
    ARM64_INS_STSET = 765,
    ARM64_INS_STSETB = 766,
    ARM64_INS_STSETH = 767,
    ARM64_INS_STSETL = 768,
    ARM64_INS_STSETLB = 769,
    ARM64_INS_STSETLH = 770,
    ARM64_INS_STSMAX = 771,
    ARM64_INS_STSMAXB = 772,
    ARM64_INS_STSMAXH = 773,
    ARM64_INS_STSMAXL = 774,
    ARM64_INS_STSMAXLB = 775,
    ARM64_INS_STSMAXLH = 776,
    ARM64_INS_STSMIN = 777,
    ARM64_INS_STSMINB = 778,
    ARM64_INS_STSMINH = 779,
    ARM64_INS_STSMINL = 780,
    ARM64_INS_STSMINLB = 781,
    ARM64_INS_STSMINLH = 782,
    ARM64_INS_STTR = 783,
    ARM64_INS_STTRB = 784,
    ARM64_INS_STTRH = 785,
    ARM64_INS_STUMAX = 786,
    ARM64_INS_STUMAXB = 787,
    ARM64_INS_STUMAXH = 788,
    ARM64_INS_STUMAXL = 789,
    ARM64_INS_STUMAXLB = 790,
    ARM64_INS_STUMAXLH = 791,
    ARM64_INS_STUMIN = 792,
    ARM64_INS_STUMINB = 793,
    ARM64_INS_STUMINH = 794,
    ARM64_INS_STUMINL = 795,
    ARM64_INS_STUMINLB = 796,
    ARM64_INS_STUMINLH = 797,
    ARM64_INS_STUR = 798,
    ARM64_INS_STURB = 799,
    ARM64_INS_STURH = 800,
    ARM64_INS_STXP = 801,
    ARM64_INS_STXR = 802,
    ARM64_INS_STXRB = 803,
    ARM64_INS_STXRH = 804,
    ARM64_INS_SUB = 805,
    ARM64_INS_SUBHN = 806,
    ARM64_INS_SUBHN2 = 807,
    ARM64_INS_SUBR = 808,
    ARM64_INS_SUBS = 809,
    ARM64_INS_SUNPKHI = 810,
    ARM64_INS_SUNPKLO = 811,
    ARM64_INS_SUQADD = 812,
    ARM64_INS_SVC = 813,
    ARM64_INS_SWP = 814,
    ARM64_INS_SWPA = 815,
    ARM64_INS_SWPAB = 816,
    ARM64_INS_SWPAH = 817,
    ARM64_INS_SWPAL = 818,
    ARM64_INS_SWPALB = 819,
    ARM64_INS_SWPALH = 820,
    ARM64_INS_SWPB = 821,
    ARM64_INS_SWPH = 822,
    ARM64_INS_SWPL = 823,
    ARM64_INS_SWPLB = 824,
    ARM64_INS_SWPLH = 825,
    ARM64_INS_SXTB = 826,
    ARM64_INS_SXTH = 827,
    ARM64_INS_SXTL = 828,
    ARM64_INS_SXTL2 = 829,
    ARM64_INS_SXTW = 830,
    ARM64_INS_SYS = 831,
    ARM64_INS_SYSL = 832,
    ARM64_INS_TBL = 833,
    ARM64_INS_TBNZ = 834,
    ARM64_INS_TBX = 835,
    ARM64_INS_TBZ = 836,
    ARM64_INS_TRN1 = 837,
    ARM64_INS_TRN2 = 838,
    ARM64_INS_TSB = 839,
    ARM64_INS_TST = 840,
    ARM64_INS_UABA = 841,
    ARM64_INS_UABAL = 842,
    ARM64_INS_UABAL2 = 843,
    ARM64_INS_UABD = 844,
    ARM64_INS_UABDL = 845,
    ARM64_INS_UABDL2 = 846,
    ARM64_INS_UADALP = 847,
    ARM64_INS_UADDL = 848,
    ARM64_INS_UADDL2 = 849,
    ARM64_INS_UADDLP = 850,
    ARM64_INS_UADDLV = 851,
    ARM64_INS_UADDV = 852,
    ARM64_INS_UADDW = 853,
    ARM64_INS_UADDW2 = 854,
    ARM64_INS_UBFM = 855,
    ARM64_INS_UCVTF = 856,
    ARM64_INS_UDIV = 857,
    ARM64_INS_UDIVR = 858,
    ARM64_INS_UDOT = 859,
    ARM64_INS_UHADD = 860,
    ARM64_INS_UHSUB = 861,
    ARM64_INS_UMADDL = 862,
    ARM64_INS_UMAX = 863,
    ARM64_INS_UMAXP = 864,
    ARM64_INS_UMAXV = 865,
    ARM64_INS_UMIN = 866,
    ARM64_INS_UMINP = 867,
    ARM64_INS_UMINV = 868,
    ARM64_INS_UMLAL = 869,
    ARM64_INS_UMLAL2 = 870,
    ARM64_INS_UMLSL = 871,
    ARM64_INS_UMLSL2 = 872,
    ARM64_INS_UMNEGL = 873,
    ARM64_INS_UMOV = 874,
    ARM64_INS_UMSUBL = 875,
    ARM64_INS_UMULH = 876,
    ARM64_INS_UMULL = 877,
    ARM64_INS_UMULL2 = 878,
    ARM64_INS_UQADD = 879,
    ARM64_INS_UQDECB = 880,
    ARM64_INS_UQDECD = 881,
    ARM64_INS_UQDECH = 882,
    ARM64_INS_UQDECP = 883,
    ARM64_INS_UQDECW = 884,
    ARM64_INS_UQINCB = 885,
    ARM64_INS_UQINCD = 886,
    ARM64_INS_UQINCH = 887,
    ARM64_INS_UQINCP = 888,
    ARM64_INS_UQINCW = 889,
    ARM64_INS_UQRSHL = 890,
    ARM64_INS_UQRSHRN = 891,
    ARM64_INS_UQRSHRN2 = 892,
    ARM64_INS_UQSHL = 893,
    ARM64_INS_UQSHRN = 894,
    ARM64_INS_UQSHRN2 = 895,
    ARM64_INS_UQSUB = 896,
    ARM64_INS_UQXTN = 897,
    ARM64_INS_UQXTN2 = 898,
    ARM64_INS_URECPE = 899,
    ARM64_INS_URHADD = 900,
    ARM64_INS_URSHL = 901,
    ARM64_INS_URSHR = 902,
    ARM64_INS_URSQRTE = 903,
    ARM64_INS_URSRA = 904,
    ARM64_INS_USHL = 905,
    ARM64_INS_USHLL = 906,
    ARM64_INS_USHLL2 = 907,
    ARM64_INS_USHR = 908,
    ARM64_INS_USQADD = 909,
    ARM64_INS_USRA = 910,
    ARM64_INS_USUBL = 911,
    ARM64_INS_USUBL2 = 912,
    ARM64_INS_USUBW = 913,
    ARM64_INS_USUBW2 = 914,
    ARM64_INS_UUNPKHI = 915,
    ARM64_INS_UUNPKLO = 916,
    ARM64_INS_UXTB = 917,
    ARM64_INS_UXTH = 918,
    ARM64_INS_UXTL = 919,
    ARM64_INS_UXTL2 = 920,
    ARM64_INS_UXTW = 921,
    ARM64_INS_UZP1 = 922,
    ARM64_INS_UZP2 = 923,
    ARM64_INS_WFE = 924,
    ARM64_INS_WFI = 925,
    ARM64_INS_WHILELE = 926,
    ARM64_INS_WHILELO = 927,
    ARM64_INS_WHILELS = 928,
    ARM64_INS_WHILELT = 929,
    ARM64_INS_WRFFR = 930,
    ARM64_INS_XAR = 931,
    ARM64_INS_XPACD = 932,
    ARM64_INS_XPACI = 933,
    ARM64_INS_XPACLRI = 934,
    ARM64_INS_XTN = 935,
    ARM64_INS_XTN2 = 936,
    ARM64_INS_YIELD = 937,
    ARM64_INS_ZIP1 = 938,
    ARM64_INS_ZIP2 = 939,
    ARM64_INS_SBFIZ = 940,
    ARM64_INS_UBFIZ = 941,
    ARM64_INS_SBFX = 942,
    ARM64_INS_UBFX = 943,
    ARM64_INS_BFI = 944,
    ARM64_INS_BFXIL = 945,
    ARM64_INS_IC = 946,
    ARM64_INS_DC = 947,
    ARM64_INS_AT = 948,
    ARM64_INS_TLBI = 949,
    ARM64_INS_ENDING = 950,
}
pub mod arm64_insn_group {
    #[doc = " Group of ARM64 instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const ARM64_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const ARM64_GRP_JUMP: Type = 1;
    pub const ARM64_GRP_CALL: Type = 2;
    pub const ARM64_GRP_RET: Type = 3;
    pub const ARM64_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const ARM64_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const ARM64_GRP_BRANCH_RELATIVE: Type = 7;
    pub const ARM64_GRP_PAC: Type = 8;
    pub const ARM64_GRP_CRYPTO: Type = 128;
    pub const ARM64_GRP_FPARMV8: Type = 129;
    pub const ARM64_GRP_NEON: Type = 130;
    pub const ARM64_GRP_CRC: Type = 131;
    pub const ARM64_GRP_AES: Type = 132;
    pub const ARM64_GRP_DOTPROD: Type = 133;
    pub const ARM64_GRP_FULLFP16: Type = 134;
    pub const ARM64_GRP_LSE: Type = 135;
    pub const ARM64_GRP_RCPC: Type = 136;
    pub const ARM64_GRP_RDM: Type = 137;
    pub const ARM64_GRP_SHA2: Type = 138;
    pub const ARM64_GRP_SHA3: Type = 139;
    pub const ARM64_GRP_SM4: Type = 140;
    pub const ARM64_GRP_SVE: Type = 141;
    pub const ARM64_GRP_V8_1A: Type = 142;
    pub const ARM64_GRP_V8_3A: Type = 143;
    pub const ARM64_GRP_V8_4A: Type = 144;
    pub const ARM64_GRP_ENDING: Type = 145;
}
pub mod m68k_reg {
    #[doc = " M68K registers and special registers"]
    pub type Type = libc::c_uint;
    pub const M68K_REG_INVALID: Type = 0;
    pub const M68K_REG_D0: Type = 1;
    pub const M68K_REG_D1: Type = 2;
    pub const M68K_REG_D2: Type = 3;
    pub const M68K_REG_D3: Type = 4;
    pub const M68K_REG_D4: Type = 5;
    pub const M68K_REG_D5: Type = 6;
    pub const M68K_REG_D6: Type = 7;
    pub const M68K_REG_D7: Type = 8;
    pub const M68K_REG_A0: Type = 9;
    pub const M68K_REG_A1: Type = 10;
    pub const M68K_REG_A2: Type = 11;
    pub const M68K_REG_A3: Type = 12;
    pub const M68K_REG_A4: Type = 13;
    pub const M68K_REG_A5: Type = 14;
    pub const M68K_REG_A6: Type = 15;
    pub const M68K_REG_A7: Type = 16;
    pub const M68K_REG_FP0: Type = 17;
    pub const M68K_REG_FP1: Type = 18;
    pub const M68K_REG_FP2: Type = 19;
    pub const M68K_REG_FP3: Type = 20;
    pub const M68K_REG_FP4: Type = 21;
    pub const M68K_REG_FP5: Type = 22;
    pub const M68K_REG_FP6: Type = 23;
    pub const M68K_REG_FP7: Type = 24;
    pub const M68K_REG_PC: Type = 25;
    pub const M68K_REG_SR: Type = 26;
    pub const M68K_REG_CCR: Type = 27;
    pub const M68K_REG_SFC: Type = 28;
    pub const M68K_REG_DFC: Type = 29;
    pub const M68K_REG_USP: Type = 30;
    pub const M68K_REG_VBR: Type = 31;
    pub const M68K_REG_CACR: Type = 32;
    pub const M68K_REG_CAAR: Type = 33;
    pub const M68K_REG_MSP: Type = 34;
    pub const M68K_REG_ISP: Type = 35;
    pub const M68K_REG_TC: Type = 36;
    pub const M68K_REG_ITT0: Type = 37;
    pub const M68K_REG_ITT1: Type = 38;
    pub const M68K_REG_DTT0: Type = 39;
    pub const M68K_REG_DTT1: Type = 40;
    pub const M68K_REG_MMUSR: Type = 41;
    pub const M68K_REG_URP: Type = 42;
    pub const M68K_REG_SRP: Type = 43;
    pub const M68K_REG_FPCR: Type = 44;
    pub const M68K_REG_FPSR: Type = 45;
    pub const M68K_REG_FPIAR: Type = 46;
    pub const M68K_REG_ENDING: Type = 47;
}
#[repr(u32)]
#[doc = " M68K Addressing Modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_address_mode {
    #[doc = "< No address mode."]
    M68K_AM_NONE = 0,
    #[doc = "< Register Direct - Data"]
    M68K_AM_REG_DIRECT_DATA = 1,
    #[doc = "< Register Direct - Address"]
    M68K_AM_REG_DIRECT_ADDR = 2,
    #[doc = "< Register Indirect - Address"]
    M68K_AM_REGI_ADDR = 3,
    #[doc = "< Register Indirect - Address with Postincrement"]
    M68K_AM_REGI_ADDR_POST_INC = 4,
    #[doc = "< Register Indirect - Address with Predecrement"]
    M68K_AM_REGI_ADDR_PRE_DEC = 5,
    #[doc = "< Register Indirect - Address with Displacement"]
    M68K_AM_REGI_ADDR_DISP = 6,
    #[doc = "< Address Register Indirect With Index- 8-bit displacement"]
    M68K_AM_AREGI_INDEX_8_BIT_DISP = 7,
    #[doc = "< Address Register Indirect With Index- Base displacement"]
    M68K_AM_AREGI_INDEX_BASE_DISP = 8,
    #[doc = "< Memory indirect - Postindex"]
    M68K_AM_MEMI_POST_INDEX = 9,
    #[doc = "< Memory indirect - Preindex"]
    M68K_AM_MEMI_PRE_INDEX = 10,
    #[doc = "< Program Counter Indirect - with Displacement"]
    M68K_AM_PCI_DISP = 11,
    #[doc = "< Program Counter Indirect with Index - with 8-Bit Displacement"]
    M68K_AM_PCI_INDEX_8_BIT_DISP = 12,
    #[doc = "< Program Counter Indirect with Index - with Base Displacement"]
    M68K_AM_PCI_INDEX_BASE_DISP = 13,
    #[doc = "< Program Counter Memory Indirect - Postindexed"]
    M68K_AM_PC_MEMI_POST_INDEX = 14,
    #[doc = "< Program Counter Memory Indirect - Preindexed"]
    M68K_AM_PC_MEMI_PRE_INDEX = 15,
    #[doc = "< Absolute Data Addressing  - Short"]
    M68K_AM_ABSOLUTE_DATA_SHORT = 16,
    #[doc = "< Absolute Data Addressing  - Long"]
    M68K_AM_ABSOLUTE_DATA_LONG = 17,
    #[doc = "< Immediate value"]
    M68K_AM_IMMEDIATE = 18,
    #[doc = "< Address as displacement from (PC+2) used by branches"]
    M68K_AM_BRANCH_DISPLACEMENT = 19,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    M68K_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    M68K_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    M68K_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    M68K_OP_MEM = 3,
    #[doc = "< single precision Floating-Point operand"]
    M68K_OP_FP_SINGLE = 4,
    #[doc = "< double precision Floating-Point operand"]
    M68K_OP_FP_DOUBLE = 5,
    #[doc = "< Register bits move"]
    M68K_OP_REG_BITS = 6,
    #[doc = "< Register pair in the same op (upper 4 bits for first reg, lower for second)"]
    M68K_OP_REG_PAIR = 7,
    #[doc = "< Branch displacement"]
    M68K_OP_BR_DISP = 8,
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with M68K_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m68k_op_mem {
    #[doc = "< base register (or M68K_REG_INVALID if irrelevant)"]
    pub base_reg: m68k_reg::Type,
    #[doc = "< index register (or M68K_REG_INVALID if irrelevant)"]
    pub index_reg: m68k_reg::Type,
    #[doc = "< indirect base register (or M68K_REG_INVALID if irrelevant)"]
    pub in_base_reg: m68k_reg::Type,
    #[doc = "< indirect displacement"]
    pub in_disp: u32,
    #[doc = "< other displacement"]
    pub out_disp: u32,
    #[doc = "< displacement value"]
    pub disp: i16,
    #[doc = "< scale for index register"]
    pub scale: u8,
    #[doc = "< set to true if the two values below should be used"]
    pub bitfield: u8,
    #[doc = "< used for bf* instructions"]
    pub width: u8,
    #[doc = "< used for bf* instructions"]
    pub offset: u8,
    #[doc = "< 0 = w, 1 = l"]
    pub index_size: u8,
}
impl Clone for m68k_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_op_br_disp_size {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    M68K_OP_BR_DISP_SIZE_INVALID = 0,
    #[doc = "< signed 8-bit displacement"]
    M68K_OP_BR_DISP_SIZE_BYTE = 1,
    #[doc = "< signed 16-bit displacement"]
    M68K_OP_BR_DISP_SIZE_WORD = 2,
    #[doc = "< signed 32-bit displacement"]
    M68K_OP_BR_DISP_SIZE_LONG = 4,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m68k_op_br_disp {
    #[doc = "< displacement value"]
    pub disp: i32,
    #[doc = "< Size from m68k_op_br_disp_size type above"]
    pub disp_size: u8,
}
impl Clone for m68k_op_br_disp {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Register pair in one operand."]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_m68k_op_reg_pair {
    pub reg_0: m68k_reg::Type,
    pub reg_1: m68k_reg::Type,
}
impl Clone for cs_m68k_op_reg_pair {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m68k_op {
    pub __bindgen_anon_1: cs_m68k_op__bindgen_ty_1,
    #[doc = "< data when operand is targeting memory"]
    pub mem: m68k_op_mem,
    #[doc = "< data when operand is a branch displacement"]
    pub br_disp: m68k_op_br_disp,
    #[doc = "< register bits for movem etc. (always in d0-d7, a0-a7, fp0 - fp7 order)"]
    pub register_bits: u32,
    pub type_: m68k_op_type,
    #[doc = "< M68K addressing mode for this op"]
    pub address_mode: m68k_address_mode,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_m68k_op__bindgen_ty_1 {
    #[doc = "< immediate value for IMM operand"]
    pub imm: u64,
    #[doc = "< double imm"]
    pub dimm: f64,
    #[doc = "< float imm"]
    pub simm: f32,
    #[doc = "< register value for REG operand"]
    pub reg: m68k_reg::Type,
    #[doc = "< register pair in one operand"]
    pub reg_pair: cs_m68k_op_reg_pair,
}
impl Clone for cs_m68k_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m68k_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_m68k_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_m68k_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m68k_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_m68k_op {{ __bindgen_anon_1: {:?}, mem: {:?}, br_disp: {:?}, register_bits: {:?}, type: {:?}, address_mode: {:?} }}" , self . __bindgen_anon_1 , self . mem , self . br_disp , self . register_bits , self . type_ , self . address_mode)
    }
}
#[repr(u32)]
#[doc = " Operation size of the CPU instructions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_cpu_size {
    #[doc = "< unsized or unspecified"]
    M68K_CPU_SIZE_NONE = 0,
    #[doc = "< 1 byte in size"]
    M68K_CPU_SIZE_BYTE = 1,
    #[doc = "< 2 bytes in size"]
    M68K_CPU_SIZE_WORD = 2,
    #[doc = "< 4 bytes in size"]
    M68K_CPU_SIZE_LONG = 4,
}
#[repr(u32)]
#[doc = " Operation size of the FPU instructions (Notice that FPU instruction can also use CPU sizes if needed)"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_fpu_size {
    #[doc = "< unsized like fsave/frestore"]
    M68K_FPU_SIZE_NONE = 0,
    #[doc = "< 4 byte in size (single float)"]
    M68K_FPU_SIZE_SINGLE = 4,
    #[doc = "< 8 byte in size (double)"]
    M68K_FPU_SIZE_DOUBLE = 8,
    #[doc = "< 12 byte in size (extended real format)"]
    M68K_FPU_SIZE_EXTENDED = 12,
}
#[repr(u32)]
#[doc = " Type of size that is being used for the current instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_size_type {
    M68K_SIZE_TYPE_INVALID = 0,
    M68K_SIZE_TYPE_CPU = 1,
    M68K_SIZE_TYPE_FPU = 2,
}
#[doc = " Operation size of the current instruction (NOT the actually size of instruction)"]
#[repr(C)]
#[derive(Copy)]
pub struct m68k_op_size {
    pub type_: m68k_size_type,
    pub __bindgen_anon_1: m68k_op_size__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union m68k_op_size__bindgen_ty_1 {
    pub cpu_size: m68k_cpu_size,
    pub fpu_size: m68k_fpu_size,
}
impl Clone for m68k_op_size__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for m68k_op_size__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "m68k_op_size__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for m68k_op_size {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for m68k_op_size {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "m68k_op_size {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " The M68K instruction and it's operands"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m68k {
    #[doc = "< operands for this instruction."]
    pub operands: [cs_m68k_op; 4usize],
    #[doc = "< size of data operand works on in bytes (.b, .w, .l, etc)"]
    pub op_size: m68k_op_size,
    #[doc = "< number of operands for the instruction"]
    pub op_count: u8,
}
impl Clone for cs_m68k {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m68k {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_m68k {{ operands: {:?}, op_size: {:?}, op_count: {:?} }}",
            self.operands, self.op_size, self.op_count
        )
    }
}
#[repr(u32)]
#[doc = " M68K instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_insn {
    M68K_INS_INVALID = 0,
    M68K_INS_ABCD = 1,
    M68K_INS_ADD = 2,
    M68K_INS_ADDA = 3,
    M68K_INS_ADDI = 4,
    M68K_INS_ADDQ = 5,
    M68K_INS_ADDX = 6,
    M68K_INS_AND = 7,
    M68K_INS_ANDI = 8,
    M68K_INS_ASL = 9,
    M68K_INS_ASR = 10,
    M68K_INS_BHS = 11,
    M68K_INS_BLO = 12,
    M68K_INS_BHI = 13,
    M68K_INS_BLS = 14,
    M68K_INS_BCC = 15,
    M68K_INS_BCS = 16,
    M68K_INS_BNE = 17,
    M68K_INS_BEQ = 18,
    M68K_INS_BVC = 19,
    M68K_INS_BVS = 20,
    M68K_INS_BPL = 21,
    M68K_INS_BMI = 22,
    M68K_INS_BGE = 23,
    M68K_INS_BLT = 24,
    M68K_INS_BGT = 25,
    M68K_INS_BLE = 26,
    M68K_INS_BRA = 27,
    M68K_INS_BSR = 28,
    M68K_INS_BCHG = 29,
    M68K_INS_BCLR = 30,
    M68K_INS_BSET = 31,
    M68K_INS_BTST = 32,
    M68K_INS_BFCHG = 33,
    M68K_INS_BFCLR = 34,
    M68K_INS_BFEXTS = 35,
    M68K_INS_BFEXTU = 36,
    M68K_INS_BFFFO = 37,
    M68K_INS_BFINS = 38,
    M68K_INS_BFSET = 39,
    M68K_INS_BFTST = 40,
    M68K_INS_BKPT = 41,
    M68K_INS_CALLM = 42,
    M68K_INS_CAS = 43,
    M68K_INS_CAS2 = 44,
    M68K_INS_CHK = 45,
    M68K_INS_CHK2 = 46,
    M68K_INS_CLR = 47,
    M68K_INS_CMP = 48,
    M68K_INS_CMPA = 49,
    M68K_INS_CMPI = 50,
    M68K_INS_CMPM = 51,
    M68K_INS_CMP2 = 52,
    M68K_INS_CINVL = 53,
    M68K_INS_CINVP = 54,
    M68K_INS_CINVA = 55,
    M68K_INS_CPUSHL = 56,
    M68K_INS_CPUSHP = 57,
    M68K_INS_CPUSHA = 58,
    M68K_INS_DBT = 59,
    M68K_INS_DBF = 60,
    M68K_INS_DBHI = 61,
    M68K_INS_DBLS = 62,
    M68K_INS_DBCC = 63,
    M68K_INS_DBCS = 64,
    M68K_INS_DBNE = 65,
    M68K_INS_DBEQ = 66,
    M68K_INS_DBVC = 67,
    M68K_INS_DBVS = 68,
    M68K_INS_DBPL = 69,
    M68K_INS_DBMI = 70,
    M68K_INS_DBGE = 71,
    M68K_INS_DBLT = 72,
    M68K_INS_DBGT = 73,
    M68K_INS_DBLE = 74,
    M68K_INS_DBRA = 75,
    M68K_INS_DIVS = 76,
    M68K_INS_DIVSL = 77,
    M68K_INS_DIVU = 78,
    M68K_INS_DIVUL = 79,
    M68K_INS_EOR = 80,
    M68K_INS_EORI = 81,
    M68K_INS_EXG = 82,
    M68K_INS_EXT = 83,
    M68K_INS_EXTB = 84,
    M68K_INS_FABS = 85,
    M68K_INS_FSABS = 86,
    M68K_INS_FDABS = 87,
    M68K_INS_FACOS = 88,
    M68K_INS_FADD = 89,
    M68K_INS_FSADD = 90,
    M68K_INS_FDADD = 91,
    M68K_INS_FASIN = 92,
    M68K_INS_FATAN = 93,
    M68K_INS_FATANH = 94,
    M68K_INS_FBF = 95,
    M68K_INS_FBEQ = 96,
    M68K_INS_FBOGT = 97,
    M68K_INS_FBOGE = 98,
    M68K_INS_FBOLT = 99,
    M68K_INS_FBOLE = 100,
    M68K_INS_FBOGL = 101,
    M68K_INS_FBOR = 102,
    M68K_INS_FBUN = 103,
    M68K_INS_FBUEQ = 104,
    M68K_INS_FBUGT = 105,
    M68K_INS_FBUGE = 106,
    M68K_INS_FBULT = 107,
    M68K_INS_FBULE = 108,
    M68K_INS_FBNE = 109,
    M68K_INS_FBT = 110,
    M68K_INS_FBSF = 111,
    M68K_INS_FBSEQ = 112,
    M68K_INS_FBGT = 113,
    M68K_INS_FBGE = 114,
    M68K_INS_FBLT = 115,
    M68K_INS_FBLE = 116,
    M68K_INS_FBGL = 117,
    M68K_INS_FBGLE = 118,
    M68K_INS_FBNGLE = 119,
    M68K_INS_FBNGL = 120,
    M68K_INS_FBNLE = 121,
    M68K_INS_FBNLT = 122,
    M68K_INS_FBNGE = 123,
    M68K_INS_FBNGT = 124,
    M68K_INS_FBSNE = 125,
    M68K_INS_FBST = 126,
    M68K_INS_FCMP = 127,
    M68K_INS_FCOS = 128,
    M68K_INS_FCOSH = 129,
    M68K_INS_FDBF = 130,
    M68K_INS_FDBEQ = 131,
    M68K_INS_FDBOGT = 132,
    M68K_INS_FDBOGE = 133,
    M68K_INS_FDBOLT = 134,
    M68K_INS_FDBOLE = 135,
    M68K_INS_FDBOGL = 136,
    M68K_INS_FDBOR = 137,
    M68K_INS_FDBUN = 138,
    M68K_INS_FDBUEQ = 139,
    M68K_INS_FDBUGT = 140,
    M68K_INS_FDBUGE = 141,
    M68K_INS_FDBULT = 142,
    M68K_INS_FDBULE = 143,
    M68K_INS_FDBNE = 144,
    M68K_INS_FDBT = 145,
    M68K_INS_FDBSF = 146,
    M68K_INS_FDBSEQ = 147,
    M68K_INS_FDBGT = 148,
    M68K_INS_FDBGE = 149,
    M68K_INS_FDBLT = 150,
    M68K_INS_FDBLE = 151,
    M68K_INS_FDBGL = 152,
    M68K_INS_FDBGLE = 153,
    M68K_INS_FDBNGLE = 154,
    M68K_INS_FDBNGL = 155,
    M68K_INS_FDBNLE = 156,
    M68K_INS_FDBNLT = 157,
    M68K_INS_FDBNGE = 158,
    M68K_INS_FDBNGT = 159,
    M68K_INS_FDBSNE = 160,
    M68K_INS_FDBST = 161,
    M68K_INS_FDIV = 162,
    M68K_INS_FSDIV = 163,
    M68K_INS_FDDIV = 164,
    M68K_INS_FETOX = 165,
    M68K_INS_FETOXM1 = 166,
    M68K_INS_FGETEXP = 167,
    M68K_INS_FGETMAN = 168,
    M68K_INS_FINT = 169,
    M68K_INS_FINTRZ = 170,
    M68K_INS_FLOG10 = 171,
    M68K_INS_FLOG2 = 172,
    M68K_INS_FLOGN = 173,
    M68K_INS_FLOGNP1 = 174,
    M68K_INS_FMOD = 175,
    M68K_INS_FMOVE = 176,
    M68K_INS_FSMOVE = 177,
    M68K_INS_FDMOVE = 178,
    M68K_INS_FMOVECR = 179,
    M68K_INS_FMOVEM = 180,
    M68K_INS_FMUL = 181,
    M68K_INS_FSMUL = 182,
    M68K_INS_FDMUL = 183,
    M68K_INS_FNEG = 184,
    M68K_INS_FSNEG = 185,
    M68K_INS_FDNEG = 186,
    M68K_INS_FNOP = 187,
    M68K_INS_FREM = 188,
    M68K_INS_FRESTORE = 189,
    M68K_INS_FSAVE = 190,
    M68K_INS_FSCALE = 191,
    M68K_INS_FSGLDIV = 192,
    M68K_INS_FSGLMUL = 193,
    M68K_INS_FSIN = 194,
    M68K_INS_FSINCOS = 195,
    M68K_INS_FSINH = 196,
    M68K_INS_FSQRT = 197,
    M68K_INS_FSSQRT = 198,
    M68K_INS_FDSQRT = 199,
    M68K_INS_FSF = 200,
    M68K_INS_FSBEQ = 201,
    M68K_INS_FSOGT = 202,
    M68K_INS_FSOGE = 203,
    M68K_INS_FSOLT = 204,
    M68K_INS_FSOLE = 205,
    M68K_INS_FSOGL = 206,
    M68K_INS_FSOR = 207,
    M68K_INS_FSUN = 208,
    M68K_INS_FSUEQ = 209,
    M68K_INS_FSUGT = 210,
    M68K_INS_FSUGE = 211,
    M68K_INS_FSULT = 212,
    M68K_INS_FSULE = 213,
    M68K_INS_FSNE = 214,
    M68K_INS_FST = 215,
    M68K_INS_FSSF = 216,
    M68K_INS_FSSEQ = 217,
    M68K_INS_FSGT = 218,
    M68K_INS_FSGE = 219,
    M68K_INS_FSLT = 220,
    M68K_INS_FSLE = 221,
    M68K_INS_FSGL = 222,
    M68K_INS_FSGLE = 223,
    M68K_INS_FSNGLE = 224,
    M68K_INS_FSNGL = 225,
    M68K_INS_FSNLE = 226,
    M68K_INS_FSNLT = 227,
    M68K_INS_FSNGE = 228,
    M68K_INS_FSNGT = 229,
    M68K_INS_FSSNE = 230,
    M68K_INS_FSST = 231,
    M68K_INS_FSUB = 232,
    M68K_INS_FSSUB = 233,
    M68K_INS_FDSUB = 234,
    M68K_INS_FTAN = 235,
    M68K_INS_FTANH = 236,
    M68K_INS_FTENTOX = 237,
    M68K_INS_FTRAPF = 238,
    M68K_INS_FTRAPEQ = 239,
    M68K_INS_FTRAPOGT = 240,
    M68K_INS_FTRAPOGE = 241,
    M68K_INS_FTRAPOLT = 242,
    M68K_INS_FTRAPOLE = 243,
    M68K_INS_FTRAPOGL = 244,
    M68K_INS_FTRAPOR = 245,
    M68K_INS_FTRAPUN = 246,
    M68K_INS_FTRAPUEQ = 247,
    M68K_INS_FTRAPUGT = 248,
    M68K_INS_FTRAPUGE = 249,
    M68K_INS_FTRAPULT = 250,
    M68K_INS_FTRAPULE = 251,
    M68K_INS_FTRAPNE = 252,
    M68K_INS_FTRAPT = 253,
    M68K_INS_FTRAPSF = 254,
    M68K_INS_FTRAPSEQ = 255,
    M68K_INS_FTRAPGT = 256,
    M68K_INS_FTRAPGE = 257,
    M68K_INS_FTRAPLT = 258,
    M68K_INS_FTRAPLE = 259,
    M68K_INS_FTRAPGL = 260,
    M68K_INS_FTRAPGLE = 261,
    M68K_INS_FTRAPNGLE = 262,
    M68K_INS_FTRAPNGL = 263,
    M68K_INS_FTRAPNLE = 264,
    M68K_INS_FTRAPNLT = 265,
    M68K_INS_FTRAPNGE = 266,
    M68K_INS_FTRAPNGT = 267,
    M68K_INS_FTRAPSNE = 268,
    M68K_INS_FTRAPST = 269,
    M68K_INS_FTST = 270,
    M68K_INS_FTWOTOX = 271,
    M68K_INS_HALT = 272,
    M68K_INS_ILLEGAL = 273,
    M68K_INS_JMP = 274,
    M68K_INS_JSR = 275,
    M68K_INS_LEA = 276,
    M68K_INS_LINK = 277,
    M68K_INS_LPSTOP = 278,
    M68K_INS_LSL = 279,
    M68K_INS_LSR = 280,
    M68K_INS_MOVE = 281,
    M68K_INS_MOVEA = 282,
    M68K_INS_MOVEC = 283,
    M68K_INS_MOVEM = 284,
    M68K_INS_MOVEP = 285,
    M68K_INS_MOVEQ = 286,
    M68K_INS_MOVES = 287,
    M68K_INS_MOVE16 = 288,
    M68K_INS_MULS = 289,
    M68K_INS_MULU = 290,
    M68K_INS_NBCD = 291,
    M68K_INS_NEG = 292,
    M68K_INS_NEGX = 293,
    M68K_INS_NOP = 294,
    M68K_INS_NOT = 295,
    M68K_INS_OR = 296,
    M68K_INS_ORI = 297,
    M68K_INS_PACK = 298,
    M68K_INS_PEA = 299,
    M68K_INS_PFLUSH = 300,
    M68K_INS_PFLUSHA = 301,
    M68K_INS_PFLUSHAN = 302,
    M68K_INS_PFLUSHN = 303,
    M68K_INS_PLOADR = 304,
    M68K_INS_PLOADW = 305,
    M68K_INS_PLPAR = 306,
    M68K_INS_PLPAW = 307,
    M68K_INS_PMOVE = 308,
    M68K_INS_PMOVEFD = 309,
    M68K_INS_PTESTR = 310,
    M68K_INS_PTESTW = 311,
    M68K_INS_PULSE = 312,
    M68K_INS_REMS = 313,
    M68K_INS_REMU = 314,
    M68K_INS_RESET = 315,
    M68K_INS_ROL = 316,
    M68K_INS_ROR = 317,
    M68K_INS_ROXL = 318,
    M68K_INS_ROXR = 319,
    M68K_INS_RTD = 320,
    M68K_INS_RTE = 321,
    M68K_INS_RTM = 322,
    M68K_INS_RTR = 323,
    M68K_INS_RTS = 324,
    M68K_INS_SBCD = 325,
    M68K_INS_ST = 326,
    M68K_INS_SF = 327,
    M68K_INS_SHI = 328,
    M68K_INS_SLS = 329,
    M68K_INS_SCC = 330,
    M68K_INS_SHS = 331,
    M68K_INS_SCS = 332,
    M68K_INS_SLO = 333,
    M68K_INS_SNE = 334,
    M68K_INS_SEQ = 335,
    M68K_INS_SVC = 336,
    M68K_INS_SVS = 337,
    M68K_INS_SPL = 338,
    M68K_INS_SMI = 339,
    M68K_INS_SGE = 340,
    M68K_INS_SLT = 341,
    M68K_INS_SGT = 342,
    M68K_INS_SLE = 343,
    M68K_INS_STOP = 344,
    M68K_INS_SUB = 345,
    M68K_INS_SUBA = 346,
    M68K_INS_SUBI = 347,
    M68K_INS_SUBQ = 348,
    M68K_INS_SUBX = 349,
    M68K_INS_SWAP = 350,
    M68K_INS_TAS = 351,
    M68K_INS_TRAP = 352,
    M68K_INS_TRAPV = 353,
    M68K_INS_TRAPT = 354,
    M68K_INS_TRAPF = 355,
    M68K_INS_TRAPHI = 356,
    M68K_INS_TRAPLS = 357,
    M68K_INS_TRAPCC = 358,
    M68K_INS_TRAPHS = 359,
    M68K_INS_TRAPCS = 360,
    M68K_INS_TRAPLO = 361,
    M68K_INS_TRAPNE = 362,
    M68K_INS_TRAPEQ = 363,
    M68K_INS_TRAPVC = 364,
    M68K_INS_TRAPVS = 365,
    M68K_INS_TRAPPL = 366,
    M68K_INS_TRAPMI = 367,
    M68K_INS_TRAPGE = 368,
    M68K_INS_TRAPLT = 369,
    M68K_INS_TRAPGT = 370,
    M68K_INS_TRAPLE = 371,
    M68K_INS_TST = 372,
    M68K_INS_UNLK = 373,
    M68K_INS_UNPK = 374,
    M68K_INS_ENDING = 375,
}
#[repr(u32)]
#[doc = " Group of M68K instructions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m68k_group_type {
    #[doc = "< CS_GRUP_INVALID"]
    M68K_GRP_INVALID = 0,
    #[doc = "< = CS_GRP_JUMP"]
    M68K_GRP_JUMP = 1,
    #[doc = "< = CS_GRP_RET"]
    M68K_GRP_RET = 3,
    #[doc = "< = CS_GRP_IRET"]
    M68K_GRP_IRET = 5,
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    M68K_GRP_BRANCH_RELATIVE = 7,
    M68K_GRP_ENDING = 8,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mips_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    MIPS_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    MIPS_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    MIPS_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    MIPS_OP_MEM = 3,
}
pub mod mips_reg {
    #[doc = " MIPS registers"]
    pub type Type = libc::c_uint;
    pub const MIPS_REG_INVALID: Type = 0;
    pub const MIPS_REG_PC: Type = 1;
    pub const MIPS_REG_0: Type = 2;
    pub const MIPS_REG_1: Type = 3;
    pub const MIPS_REG_2: Type = 4;
    pub const MIPS_REG_3: Type = 5;
    pub const MIPS_REG_4: Type = 6;
    pub const MIPS_REG_5: Type = 7;
    pub const MIPS_REG_6: Type = 8;
    pub const MIPS_REG_7: Type = 9;
    pub const MIPS_REG_8: Type = 10;
    pub const MIPS_REG_9: Type = 11;
    pub const MIPS_REG_10: Type = 12;
    pub const MIPS_REG_11: Type = 13;
    pub const MIPS_REG_12: Type = 14;
    pub const MIPS_REG_13: Type = 15;
    pub const MIPS_REG_14: Type = 16;
    pub const MIPS_REG_15: Type = 17;
    pub const MIPS_REG_16: Type = 18;
    pub const MIPS_REG_17: Type = 19;
    pub const MIPS_REG_18: Type = 20;
    pub const MIPS_REG_19: Type = 21;
    pub const MIPS_REG_20: Type = 22;
    pub const MIPS_REG_21: Type = 23;
    pub const MIPS_REG_22: Type = 24;
    pub const MIPS_REG_23: Type = 25;
    pub const MIPS_REG_24: Type = 26;
    pub const MIPS_REG_25: Type = 27;
    pub const MIPS_REG_26: Type = 28;
    pub const MIPS_REG_27: Type = 29;
    pub const MIPS_REG_28: Type = 30;
    pub const MIPS_REG_29: Type = 31;
    pub const MIPS_REG_30: Type = 32;
    pub const MIPS_REG_31: Type = 33;
    pub const MIPS_REG_DSPCCOND: Type = 34;
    pub const MIPS_REG_DSPCARRY: Type = 35;
    pub const MIPS_REG_DSPEFI: Type = 36;
    pub const MIPS_REG_DSPOUTFLAG: Type = 37;
    pub const MIPS_REG_DSPOUTFLAG16_19: Type = 38;
    pub const MIPS_REG_DSPOUTFLAG20: Type = 39;
    pub const MIPS_REG_DSPOUTFLAG21: Type = 40;
    pub const MIPS_REG_DSPOUTFLAG22: Type = 41;
    pub const MIPS_REG_DSPOUTFLAG23: Type = 42;
    pub const MIPS_REG_DSPPOS: Type = 43;
    pub const MIPS_REG_DSPSCOUNT: Type = 44;
    pub const MIPS_REG_AC0: Type = 45;
    pub const MIPS_REG_AC1: Type = 46;
    pub const MIPS_REG_AC2: Type = 47;
    pub const MIPS_REG_AC3: Type = 48;
    pub const MIPS_REG_CC0: Type = 49;
    pub const MIPS_REG_CC1: Type = 50;
    pub const MIPS_REG_CC2: Type = 51;
    pub const MIPS_REG_CC3: Type = 52;
    pub const MIPS_REG_CC4: Type = 53;
    pub const MIPS_REG_CC5: Type = 54;
    pub const MIPS_REG_CC6: Type = 55;
    pub const MIPS_REG_CC7: Type = 56;
    pub const MIPS_REG_F0: Type = 57;
    pub const MIPS_REG_F1: Type = 58;
    pub const MIPS_REG_F2: Type = 59;
    pub const MIPS_REG_F3: Type = 60;
    pub const MIPS_REG_F4: Type = 61;
    pub const MIPS_REG_F5: Type = 62;
    pub const MIPS_REG_F6: Type = 63;
    pub const MIPS_REG_F7: Type = 64;
    pub const MIPS_REG_F8: Type = 65;
    pub const MIPS_REG_F9: Type = 66;
    pub const MIPS_REG_F10: Type = 67;
    pub const MIPS_REG_F11: Type = 68;
    pub const MIPS_REG_F12: Type = 69;
    pub const MIPS_REG_F13: Type = 70;
    pub const MIPS_REG_F14: Type = 71;
    pub const MIPS_REG_F15: Type = 72;
    pub const MIPS_REG_F16: Type = 73;
    pub const MIPS_REG_F17: Type = 74;
    pub const MIPS_REG_F18: Type = 75;
    pub const MIPS_REG_F19: Type = 76;
    pub const MIPS_REG_F20: Type = 77;
    pub const MIPS_REG_F21: Type = 78;
    pub const MIPS_REG_F22: Type = 79;
    pub const MIPS_REG_F23: Type = 80;
    pub const MIPS_REG_F24: Type = 81;
    pub const MIPS_REG_F25: Type = 82;
    pub const MIPS_REG_F26: Type = 83;
    pub const MIPS_REG_F27: Type = 84;
    pub const MIPS_REG_F28: Type = 85;
    pub const MIPS_REG_F29: Type = 86;
    pub const MIPS_REG_F30: Type = 87;
    pub const MIPS_REG_F31: Type = 88;
    pub const MIPS_REG_FCC0: Type = 89;
    pub const MIPS_REG_FCC1: Type = 90;
    pub const MIPS_REG_FCC2: Type = 91;
    pub const MIPS_REG_FCC3: Type = 92;
    pub const MIPS_REG_FCC4: Type = 93;
    pub const MIPS_REG_FCC5: Type = 94;
    pub const MIPS_REG_FCC6: Type = 95;
    pub const MIPS_REG_FCC7: Type = 96;
    pub const MIPS_REG_W0: Type = 97;
    pub const MIPS_REG_W1: Type = 98;
    pub const MIPS_REG_W2: Type = 99;
    pub const MIPS_REG_W3: Type = 100;
    pub const MIPS_REG_W4: Type = 101;
    pub const MIPS_REG_W5: Type = 102;
    pub const MIPS_REG_W6: Type = 103;
    pub const MIPS_REG_W7: Type = 104;
    pub const MIPS_REG_W8: Type = 105;
    pub const MIPS_REG_W9: Type = 106;
    pub const MIPS_REG_W10: Type = 107;
    pub const MIPS_REG_W11: Type = 108;
    pub const MIPS_REG_W12: Type = 109;
    pub const MIPS_REG_W13: Type = 110;
    pub const MIPS_REG_W14: Type = 111;
    pub const MIPS_REG_W15: Type = 112;
    pub const MIPS_REG_W16: Type = 113;
    pub const MIPS_REG_W17: Type = 114;
    pub const MIPS_REG_W18: Type = 115;
    pub const MIPS_REG_W19: Type = 116;
    pub const MIPS_REG_W20: Type = 117;
    pub const MIPS_REG_W21: Type = 118;
    pub const MIPS_REG_W22: Type = 119;
    pub const MIPS_REG_W23: Type = 120;
    pub const MIPS_REG_W24: Type = 121;
    pub const MIPS_REG_W25: Type = 122;
    pub const MIPS_REG_W26: Type = 123;
    pub const MIPS_REG_W27: Type = 124;
    pub const MIPS_REG_W28: Type = 125;
    pub const MIPS_REG_W29: Type = 126;
    pub const MIPS_REG_W30: Type = 127;
    pub const MIPS_REG_W31: Type = 128;
    pub const MIPS_REG_HI: Type = 129;
    pub const MIPS_REG_LO: Type = 130;
    pub const MIPS_REG_P0: Type = 131;
    pub const MIPS_REG_P1: Type = 132;
    pub const MIPS_REG_P2: Type = 133;
    pub const MIPS_REG_MPL0: Type = 134;
    pub const MIPS_REG_MPL1: Type = 135;
    pub const MIPS_REG_MPL2: Type = 136;
    pub const MIPS_REG_ENDING: Type = 137;
    pub const MIPS_REG_ZERO: Type = 2;
    pub const MIPS_REG_AT: Type = 3;
    pub const MIPS_REG_V0: Type = 4;
    pub const MIPS_REG_V1: Type = 5;
    pub const MIPS_REG_A0: Type = 6;
    pub const MIPS_REG_A1: Type = 7;
    pub const MIPS_REG_A2: Type = 8;
    pub const MIPS_REG_A3: Type = 9;
    pub const MIPS_REG_T0: Type = 10;
    pub const MIPS_REG_T1: Type = 11;
    pub const MIPS_REG_T2: Type = 12;
    pub const MIPS_REG_T3: Type = 13;
    pub const MIPS_REG_T4: Type = 14;
    pub const MIPS_REG_T5: Type = 15;
    pub const MIPS_REG_T6: Type = 16;
    pub const MIPS_REG_T7: Type = 17;
    pub const MIPS_REG_S0: Type = 18;
    pub const MIPS_REG_S1: Type = 19;
    pub const MIPS_REG_S2: Type = 20;
    pub const MIPS_REG_S3: Type = 21;
    pub const MIPS_REG_S4: Type = 22;
    pub const MIPS_REG_S5: Type = 23;
    pub const MIPS_REG_S6: Type = 24;
    pub const MIPS_REG_S7: Type = 25;
    pub const MIPS_REG_T8: Type = 26;
    pub const MIPS_REG_T9: Type = 27;
    pub const MIPS_REG_K0: Type = 28;
    pub const MIPS_REG_K1: Type = 29;
    pub const MIPS_REG_GP: Type = 30;
    pub const MIPS_REG_SP: Type = 31;
    pub const MIPS_REG_FP: Type = 32;
    pub const MIPS_REG_S8: Type = 32;
    pub const MIPS_REG_RA: Type = 33;
    pub const MIPS_REG_HI0: Type = 45;
    pub const MIPS_REG_HI1: Type = 46;
    pub const MIPS_REG_HI2: Type = 47;
    pub const MIPS_REG_HI3: Type = 48;
    pub const MIPS_REG_LO0: Type = 45;
    pub const MIPS_REG_LO1: Type = 46;
    pub const MIPS_REG_LO2: Type = 47;
    pub const MIPS_REG_LO3: Type = 48;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with MIPS_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct mips_op_mem {
    #[doc = "< base register"]
    pub base: mips_reg::Type,
    #[doc = "< displacement/offset value"]
    pub disp: i64,
}
impl Clone for mips_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_mips_op {
    #[doc = "< operand type"]
    pub type_: mips_op_type,
    pub __bindgen_anon_1: cs_mips_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_mips_op__bindgen_ty_1 {
    #[doc = "< register id for REG operand"]
    pub reg: mips_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: mips_op_mem,
}
impl Clone for cs_mips_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mips_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_mips_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_mips_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mips_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_mips_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_mips {
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_mips_op; 10usize],
}
impl Clone for cs_mips {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mips {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_mips {{ op_count: {:?}, operands: {:?} }}",
            self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " MIPS instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mips_insn {
    MIPS_INS_INVALID = 0,
    MIPS_INS_ABSQ_S = 1,
    MIPS_INS_ADD = 2,
    MIPS_INS_ADDIUPC = 3,
    MIPS_INS_ADDIUR1SP = 4,
    MIPS_INS_ADDIUR2 = 5,
    MIPS_INS_ADDIUS5 = 6,
    MIPS_INS_ADDIUSP = 7,
    MIPS_INS_ADDQH = 8,
    MIPS_INS_ADDQH_R = 9,
    MIPS_INS_ADDQ = 10,
    MIPS_INS_ADDQ_S = 11,
    MIPS_INS_ADDSC = 12,
    MIPS_INS_ADDS_A = 13,
    MIPS_INS_ADDS_S = 14,
    MIPS_INS_ADDS_U = 15,
    MIPS_INS_ADDU16 = 16,
    MIPS_INS_ADDUH = 17,
    MIPS_INS_ADDUH_R = 18,
    MIPS_INS_ADDU = 19,
    MIPS_INS_ADDU_S = 20,
    MIPS_INS_ADDVI = 21,
    MIPS_INS_ADDV = 22,
    MIPS_INS_ADDWC = 23,
    MIPS_INS_ADD_A = 24,
    MIPS_INS_ADDI = 25,
    MIPS_INS_ADDIU = 26,
    MIPS_INS_ALIGN = 27,
    MIPS_INS_ALUIPC = 28,
    MIPS_INS_AND = 29,
    MIPS_INS_AND16 = 30,
    MIPS_INS_ANDI16 = 31,
    MIPS_INS_ANDI = 32,
    MIPS_INS_APPEND = 33,
    MIPS_INS_ASUB_S = 34,
    MIPS_INS_ASUB_U = 35,
    MIPS_INS_AUI = 36,
    MIPS_INS_AUIPC = 37,
    MIPS_INS_AVER_S = 38,
    MIPS_INS_AVER_U = 39,
    MIPS_INS_AVE_S = 40,
    MIPS_INS_AVE_U = 41,
    MIPS_INS_B16 = 42,
    MIPS_INS_BADDU = 43,
    MIPS_INS_BAL = 44,
    MIPS_INS_BALC = 45,
    MIPS_INS_BALIGN = 46,
    MIPS_INS_BBIT0 = 47,
    MIPS_INS_BBIT032 = 48,
    MIPS_INS_BBIT1 = 49,
    MIPS_INS_BBIT132 = 50,
    MIPS_INS_BC = 51,
    MIPS_INS_BC0F = 52,
    MIPS_INS_BC0FL = 53,
    MIPS_INS_BC0T = 54,
    MIPS_INS_BC0TL = 55,
    MIPS_INS_BC1EQZ = 56,
    MIPS_INS_BC1F = 57,
    MIPS_INS_BC1FL = 58,
    MIPS_INS_BC1NEZ = 59,
    MIPS_INS_BC1T = 60,
    MIPS_INS_BC1TL = 61,
    MIPS_INS_BC2EQZ = 62,
    MIPS_INS_BC2F = 63,
    MIPS_INS_BC2FL = 64,
    MIPS_INS_BC2NEZ = 65,
    MIPS_INS_BC2T = 66,
    MIPS_INS_BC2TL = 67,
    MIPS_INS_BC3F = 68,
    MIPS_INS_BC3FL = 69,
    MIPS_INS_BC3T = 70,
    MIPS_INS_BC3TL = 71,
    MIPS_INS_BCLRI = 72,
    MIPS_INS_BCLR = 73,
    MIPS_INS_BEQ = 74,
    MIPS_INS_BEQC = 75,
    MIPS_INS_BEQL = 76,
    MIPS_INS_BEQZ16 = 77,
    MIPS_INS_BEQZALC = 78,
    MIPS_INS_BEQZC = 79,
    MIPS_INS_BGEC = 80,
    MIPS_INS_BGEUC = 81,
    MIPS_INS_BGEZ = 82,
    MIPS_INS_BGEZAL = 83,
    MIPS_INS_BGEZALC = 84,
    MIPS_INS_BGEZALL = 85,
    MIPS_INS_BGEZALS = 86,
    MIPS_INS_BGEZC = 87,
    MIPS_INS_BGEZL = 88,
    MIPS_INS_BGTZ = 89,
    MIPS_INS_BGTZALC = 90,
    MIPS_INS_BGTZC = 91,
    MIPS_INS_BGTZL = 92,
    MIPS_INS_BINSLI = 93,
    MIPS_INS_BINSL = 94,
    MIPS_INS_BINSRI = 95,
    MIPS_INS_BINSR = 96,
    MIPS_INS_BITREV = 97,
    MIPS_INS_BITSWAP = 98,
    MIPS_INS_BLEZ = 99,
    MIPS_INS_BLEZALC = 100,
    MIPS_INS_BLEZC = 101,
    MIPS_INS_BLEZL = 102,
    MIPS_INS_BLTC = 103,
    MIPS_INS_BLTUC = 104,
    MIPS_INS_BLTZ = 105,
    MIPS_INS_BLTZAL = 106,
    MIPS_INS_BLTZALC = 107,
    MIPS_INS_BLTZALL = 108,
    MIPS_INS_BLTZALS = 109,
    MIPS_INS_BLTZC = 110,
    MIPS_INS_BLTZL = 111,
    MIPS_INS_BMNZI = 112,
    MIPS_INS_BMNZ = 113,
    MIPS_INS_BMZI = 114,
    MIPS_INS_BMZ = 115,
    MIPS_INS_BNE = 116,
    MIPS_INS_BNEC = 117,
    MIPS_INS_BNEGI = 118,
    MIPS_INS_BNEG = 119,
    MIPS_INS_BNEL = 120,
    MIPS_INS_BNEZ16 = 121,
    MIPS_INS_BNEZALC = 122,
    MIPS_INS_BNEZC = 123,
    MIPS_INS_BNVC = 124,
    MIPS_INS_BNZ = 125,
    MIPS_INS_BOVC = 126,
    MIPS_INS_BPOSGE32 = 127,
    MIPS_INS_BREAK = 128,
    MIPS_INS_BREAK16 = 129,
    MIPS_INS_BSELI = 130,
    MIPS_INS_BSEL = 131,
    MIPS_INS_BSETI = 132,
    MIPS_INS_BSET = 133,
    MIPS_INS_BZ = 134,
    MIPS_INS_BEQZ = 135,
    MIPS_INS_B = 136,
    MIPS_INS_BNEZ = 137,
    MIPS_INS_BTEQZ = 138,
    MIPS_INS_BTNEZ = 139,
    MIPS_INS_CACHE = 140,
    MIPS_INS_CEIL = 141,
    MIPS_INS_CEQI = 142,
    MIPS_INS_CEQ = 143,
    MIPS_INS_CFC1 = 144,
    MIPS_INS_CFCMSA = 145,
    MIPS_INS_CINS = 146,
    MIPS_INS_CINS32 = 147,
    MIPS_INS_CLASS = 148,
    MIPS_INS_CLEI_S = 149,
    MIPS_INS_CLEI_U = 150,
    MIPS_INS_CLE_S = 151,
    MIPS_INS_CLE_U = 152,
    MIPS_INS_CLO = 153,
    MIPS_INS_CLTI_S = 154,
    MIPS_INS_CLTI_U = 155,
    MIPS_INS_CLT_S = 156,
    MIPS_INS_CLT_U = 157,
    MIPS_INS_CLZ = 158,
    MIPS_INS_CMPGDU = 159,
    MIPS_INS_CMPGU = 160,
    MIPS_INS_CMPU = 161,
    MIPS_INS_CMP = 162,
    MIPS_INS_COPY_S = 163,
    MIPS_INS_COPY_U = 164,
    MIPS_INS_CTC1 = 165,
    MIPS_INS_CTCMSA = 166,
    MIPS_INS_CVT = 167,
    MIPS_INS_C = 168,
    MIPS_INS_CMPI = 169,
    MIPS_INS_DADD = 170,
    MIPS_INS_DADDI = 171,
    MIPS_INS_DADDIU = 172,
    MIPS_INS_DADDU = 173,
    MIPS_INS_DAHI = 174,
    MIPS_INS_DALIGN = 175,
    MIPS_INS_DATI = 176,
    MIPS_INS_DAUI = 177,
    MIPS_INS_DBITSWAP = 178,
    MIPS_INS_DCLO = 179,
    MIPS_INS_DCLZ = 180,
    MIPS_INS_DDIV = 181,
    MIPS_INS_DDIVU = 182,
    MIPS_INS_DERET = 183,
    MIPS_INS_DEXT = 184,
    MIPS_INS_DEXTM = 185,
    MIPS_INS_DEXTU = 186,
    MIPS_INS_DI = 187,
    MIPS_INS_DINS = 188,
    MIPS_INS_DINSM = 189,
    MIPS_INS_DINSU = 190,
    MIPS_INS_DIV = 191,
    MIPS_INS_DIVU = 192,
    MIPS_INS_DIV_S = 193,
    MIPS_INS_DIV_U = 194,
    MIPS_INS_DLSA = 195,
    MIPS_INS_DMFC0 = 196,
    MIPS_INS_DMFC1 = 197,
    MIPS_INS_DMFC2 = 198,
    MIPS_INS_DMOD = 199,
    MIPS_INS_DMODU = 200,
    MIPS_INS_DMTC0 = 201,
    MIPS_INS_DMTC1 = 202,
    MIPS_INS_DMTC2 = 203,
    MIPS_INS_DMUH = 204,
    MIPS_INS_DMUHU = 205,
    MIPS_INS_DMUL = 206,
    MIPS_INS_DMULT = 207,
    MIPS_INS_DMULTU = 208,
    MIPS_INS_DMULU = 209,
    MIPS_INS_DOTP_S = 210,
    MIPS_INS_DOTP_U = 211,
    MIPS_INS_DPADD_S = 212,
    MIPS_INS_DPADD_U = 213,
    MIPS_INS_DPAQX_SA = 214,
    MIPS_INS_DPAQX_S = 215,
    MIPS_INS_DPAQ_SA = 216,
    MIPS_INS_DPAQ_S = 217,
    MIPS_INS_DPAU = 218,
    MIPS_INS_DPAX = 219,
    MIPS_INS_DPA = 220,
    MIPS_INS_DPOP = 221,
    MIPS_INS_DPSQX_SA = 222,
    MIPS_INS_DPSQX_S = 223,
    MIPS_INS_DPSQ_SA = 224,
    MIPS_INS_DPSQ_S = 225,
    MIPS_INS_DPSUB_S = 226,
    MIPS_INS_DPSUB_U = 227,
    MIPS_INS_DPSU = 228,
    MIPS_INS_DPSX = 229,
    MIPS_INS_DPS = 230,
    MIPS_INS_DROTR = 231,
    MIPS_INS_DROTR32 = 232,
    MIPS_INS_DROTRV = 233,
    MIPS_INS_DSBH = 234,
    MIPS_INS_DSHD = 235,
    MIPS_INS_DSLL = 236,
    MIPS_INS_DSLL32 = 237,
    MIPS_INS_DSLLV = 238,
    MIPS_INS_DSRA = 239,
    MIPS_INS_DSRA32 = 240,
    MIPS_INS_DSRAV = 241,
    MIPS_INS_DSRL = 242,
    MIPS_INS_DSRL32 = 243,
    MIPS_INS_DSRLV = 244,
    MIPS_INS_DSUB = 245,
    MIPS_INS_DSUBU = 246,
    MIPS_INS_EHB = 247,
    MIPS_INS_EI = 248,
    MIPS_INS_ERET = 249,
    MIPS_INS_EXT = 250,
    MIPS_INS_EXTP = 251,
    MIPS_INS_EXTPDP = 252,
    MIPS_INS_EXTPDPV = 253,
    MIPS_INS_EXTPV = 254,
    MIPS_INS_EXTRV_RS = 255,
    MIPS_INS_EXTRV_R = 256,
    MIPS_INS_EXTRV_S = 257,
    MIPS_INS_EXTRV = 258,
    MIPS_INS_EXTR_RS = 259,
    MIPS_INS_EXTR_R = 260,
    MIPS_INS_EXTR_S = 261,
    MIPS_INS_EXTR = 262,
    MIPS_INS_EXTS = 263,
    MIPS_INS_EXTS32 = 264,
    MIPS_INS_ABS = 265,
    MIPS_INS_FADD = 266,
    MIPS_INS_FCAF = 267,
    MIPS_INS_FCEQ = 268,
    MIPS_INS_FCLASS = 269,
    MIPS_INS_FCLE = 270,
    MIPS_INS_FCLT = 271,
    MIPS_INS_FCNE = 272,
    MIPS_INS_FCOR = 273,
    MIPS_INS_FCUEQ = 274,
    MIPS_INS_FCULE = 275,
    MIPS_INS_FCULT = 276,
    MIPS_INS_FCUNE = 277,
    MIPS_INS_FCUN = 278,
    MIPS_INS_FDIV = 279,
    MIPS_INS_FEXDO = 280,
    MIPS_INS_FEXP2 = 281,
    MIPS_INS_FEXUPL = 282,
    MIPS_INS_FEXUPR = 283,
    MIPS_INS_FFINT_S = 284,
    MIPS_INS_FFINT_U = 285,
    MIPS_INS_FFQL = 286,
    MIPS_INS_FFQR = 287,
    MIPS_INS_FILL = 288,
    MIPS_INS_FLOG2 = 289,
    MIPS_INS_FLOOR = 290,
    MIPS_INS_FMADD = 291,
    MIPS_INS_FMAX_A = 292,
    MIPS_INS_FMAX = 293,
    MIPS_INS_FMIN_A = 294,
    MIPS_INS_FMIN = 295,
    MIPS_INS_MOV = 296,
    MIPS_INS_FMSUB = 297,
    MIPS_INS_FMUL = 298,
    MIPS_INS_MUL = 299,
    MIPS_INS_NEG = 300,
    MIPS_INS_FRCP = 301,
    MIPS_INS_FRINT = 302,
    MIPS_INS_FRSQRT = 303,
    MIPS_INS_FSAF = 304,
    MIPS_INS_FSEQ = 305,
    MIPS_INS_FSLE = 306,
    MIPS_INS_FSLT = 307,
    MIPS_INS_FSNE = 308,
    MIPS_INS_FSOR = 309,
    MIPS_INS_FSQRT = 310,
    MIPS_INS_SQRT = 311,
    MIPS_INS_FSUB = 312,
    MIPS_INS_SUB = 313,
    MIPS_INS_FSUEQ = 314,
    MIPS_INS_FSULE = 315,
    MIPS_INS_FSULT = 316,
    MIPS_INS_FSUNE = 317,
    MIPS_INS_FSUN = 318,
    MIPS_INS_FTINT_S = 319,
    MIPS_INS_FTINT_U = 320,
    MIPS_INS_FTQ = 321,
    MIPS_INS_FTRUNC_S = 322,
    MIPS_INS_FTRUNC_U = 323,
    MIPS_INS_HADD_S = 324,
    MIPS_INS_HADD_U = 325,
    MIPS_INS_HSUB_S = 326,
    MIPS_INS_HSUB_U = 327,
    MIPS_INS_ILVEV = 328,
    MIPS_INS_ILVL = 329,
    MIPS_INS_ILVOD = 330,
    MIPS_INS_ILVR = 331,
    MIPS_INS_INS = 332,
    MIPS_INS_INSERT = 333,
    MIPS_INS_INSV = 334,
    MIPS_INS_INSVE = 335,
    MIPS_INS_J = 336,
    MIPS_INS_JAL = 337,
    MIPS_INS_JALR = 338,
    MIPS_INS_JALRS16 = 339,
    MIPS_INS_JALRS = 340,
    MIPS_INS_JALS = 341,
    MIPS_INS_JALX = 342,
    MIPS_INS_JIALC = 343,
    MIPS_INS_JIC = 344,
    MIPS_INS_JR = 345,
    MIPS_INS_JR16 = 346,
    MIPS_INS_JRADDIUSP = 347,
    MIPS_INS_JRC = 348,
    MIPS_INS_JALRC = 349,
    MIPS_INS_LB = 350,
    MIPS_INS_LBU16 = 351,
    MIPS_INS_LBUX = 352,
    MIPS_INS_LBU = 353,
    MIPS_INS_LD = 354,
    MIPS_INS_LDC1 = 355,
    MIPS_INS_LDC2 = 356,
    MIPS_INS_LDC3 = 357,
    MIPS_INS_LDI = 358,
    MIPS_INS_LDL = 359,
    MIPS_INS_LDPC = 360,
    MIPS_INS_LDR = 361,
    MIPS_INS_LDXC1 = 362,
    MIPS_INS_LH = 363,
    MIPS_INS_LHU16 = 364,
    MIPS_INS_LHX = 365,
    MIPS_INS_LHU = 366,
    MIPS_INS_LI16 = 367,
    MIPS_INS_LL = 368,
    MIPS_INS_LLD = 369,
    MIPS_INS_LSA = 370,
    MIPS_INS_LUXC1 = 371,
    MIPS_INS_LUI = 372,
    MIPS_INS_LW = 373,
    MIPS_INS_LW16 = 374,
    MIPS_INS_LWC1 = 375,
    MIPS_INS_LWC2 = 376,
    MIPS_INS_LWC3 = 377,
    MIPS_INS_LWL = 378,
    MIPS_INS_LWM16 = 379,
    MIPS_INS_LWM32 = 380,
    MIPS_INS_LWPC = 381,
    MIPS_INS_LWP = 382,
    MIPS_INS_LWR = 383,
    MIPS_INS_LWUPC = 384,
    MIPS_INS_LWU = 385,
    MIPS_INS_LWX = 386,
    MIPS_INS_LWXC1 = 387,
    MIPS_INS_LWXS = 388,
    MIPS_INS_LI = 389,
    MIPS_INS_MADD = 390,
    MIPS_INS_MADDF = 391,
    MIPS_INS_MADDR_Q = 392,
    MIPS_INS_MADDU = 393,
    MIPS_INS_MADDV = 394,
    MIPS_INS_MADD_Q = 395,
    MIPS_INS_MAQ_SA = 396,
    MIPS_INS_MAQ_S = 397,
    MIPS_INS_MAXA = 398,
    MIPS_INS_MAXI_S = 399,
    MIPS_INS_MAXI_U = 400,
    MIPS_INS_MAX_A = 401,
    MIPS_INS_MAX = 402,
    MIPS_INS_MAX_S = 403,
    MIPS_INS_MAX_U = 404,
    MIPS_INS_MFC0 = 405,
    MIPS_INS_MFC1 = 406,
    MIPS_INS_MFC2 = 407,
    MIPS_INS_MFHC1 = 408,
    MIPS_INS_MFHI = 409,
    MIPS_INS_MFLO = 410,
    MIPS_INS_MINA = 411,
    MIPS_INS_MINI_S = 412,
    MIPS_INS_MINI_U = 413,
    MIPS_INS_MIN_A = 414,
    MIPS_INS_MIN = 415,
    MIPS_INS_MIN_S = 416,
    MIPS_INS_MIN_U = 417,
    MIPS_INS_MOD = 418,
    MIPS_INS_MODSUB = 419,
    MIPS_INS_MODU = 420,
    MIPS_INS_MOD_S = 421,
    MIPS_INS_MOD_U = 422,
    MIPS_INS_MOVE = 423,
    MIPS_INS_MOVEP = 424,
    MIPS_INS_MOVF = 425,
    MIPS_INS_MOVN = 426,
    MIPS_INS_MOVT = 427,
    MIPS_INS_MOVZ = 428,
    MIPS_INS_MSUB = 429,
    MIPS_INS_MSUBF = 430,
    MIPS_INS_MSUBR_Q = 431,
    MIPS_INS_MSUBU = 432,
    MIPS_INS_MSUBV = 433,
    MIPS_INS_MSUB_Q = 434,
    MIPS_INS_MTC0 = 435,
    MIPS_INS_MTC1 = 436,
    MIPS_INS_MTC2 = 437,
    MIPS_INS_MTHC1 = 438,
    MIPS_INS_MTHI = 439,
    MIPS_INS_MTHLIP = 440,
    MIPS_INS_MTLO = 441,
    MIPS_INS_MTM0 = 442,
    MIPS_INS_MTM1 = 443,
    MIPS_INS_MTM2 = 444,
    MIPS_INS_MTP0 = 445,
    MIPS_INS_MTP1 = 446,
    MIPS_INS_MTP2 = 447,
    MIPS_INS_MUH = 448,
    MIPS_INS_MUHU = 449,
    MIPS_INS_MULEQ_S = 450,
    MIPS_INS_MULEU_S = 451,
    MIPS_INS_MULQ_RS = 452,
    MIPS_INS_MULQ_S = 453,
    MIPS_INS_MULR_Q = 454,
    MIPS_INS_MULSAQ_S = 455,
    MIPS_INS_MULSA = 456,
    MIPS_INS_MULT = 457,
    MIPS_INS_MULTU = 458,
    MIPS_INS_MULU = 459,
    MIPS_INS_MULV = 460,
    MIPS_INS_MUL_Q = 461,
    MIPS_INS_MUL_S = 462,
    MIPS_INS_NLOC = 463,
    MIPS_INS_NLZC = 464,
    MIPS_INS_NMADD = 465,
    MIPS_INS_NMSUB = 466,
    MIPS_INS_NOR = 467,
    MIPS_INS_NORI = 468,
    MIPS_INS_NOT16 = 469,
    MIPS_INS_NOT = 470,
    MIPS_INS_OR = 471,
    MIPS_INS_OR16 = 472,
    MIPS_INS_ORI = 473,
    MIPS_INS_PACKRL = 474,
    MIPS_INS_PAUSE = 475,
    MIPS_INS_PCKEV = 476,
    MIPS_INS_PCKOD = 477,
    MIPS_INS_PCNT = 478,
    MIPS_INS_PICK = 479,
    MIPS_INS_POP = 480,
    MIPS_INS_PRECEQU = 481,
    MIPS_INS_PRECEQ = 482,
    MIPS_INS_PRECEU = 483,
    MIPS_INS_PRECRQU_S = 484,
    MIPS_INS_PRECRQ = 485,
    MIPS_INS_PRECRQ_RS = 486,
    MIPS_INS_PRECR = 487,
    MIPS_INS_PRECR_SRA = 488,
    MIPS_INS_PRECR_SRA_R = 489,
    MIPS_INS_PREF = 490,
    MIPS_INS_PREPEND = 491,
    MIPS_INS_RADDU = 492,
    MIPS_INS_RDDSP = 493,
    MIPS_INS_RDHWR = 494,
    MIPS_INS_REPLV = 495,
    MIPS_INS_REPL = 496,
    MIPS_INS_RINT = 497,
    MIPS_INS_ROTR = 498,
    MIPS_INS_ROTRV = 499,
    MIPS_INS_ROUND = 500,
    MIPS_INS_SAT_S = 501,
    MIPS_INS_SAT_U = 502,
    MIPS_INS_SB = 503,
    MIPS_INS_SB16 = 504,
    MIPS_INS_SC = 505,
    MIPS_INS_SCD = 506,
    MIPS_INS_SD = 507,
    MIPS_INS_SDBBP = 508,
    MIPS_INS_SDBBP16 = 509,
    MIPS_INS_SDC1 = 510,
    MIPS_INS_SDC2 = 511,
    MIPS_INS_SDC3 = 512,
    MIPS_INS_SDL = 513,
    MIPS_INS_SDR = 514,
    MIPS_INS_SDXC1 = 515,
    MIPS_INS_SEB = 516,
    MIPS_INS_SEH = 517,
    MIPS_INS_SELEQZ = 518,
    MIPS_INS_SELNEZ = 519,
    MIPS_INS_SEL = 520,
    MIPS_INS_SEQ = 521,
    MIPS_INS_SEQI = 522,
    MIPS_INS_SH = 523,
    MIPS_INS_SH16 = 524,
    MIPS_INS_SHF = 525,
    MIPS_INS_SHILO = 526,
    MIPS_INS_SHILOV = 527,
    MIPS_INS_SHLLV = 528,
    MIPS_INS_SHLLV_S = 529,
    MIPS_INS_SHLL = 530,
    MIPS_INS_SHLL_S = 531,
    MIPS_INS_SHRAV = 532,
    MIPS_INS_SHRAV_R = 533,
    MIPS_INS_SHRA = 534,
    MIPS_INS_SHRA_R = 535,
    MIPS_INS_SHRLV = 536,
    MIPS_INS_SHRL = 537,
    MIPS_INS_SLDI = 538,
    MIPS_INS_SLD = 539,
    MIPS_INS_SLL = 540,
    MIPS_INS_SLL16 = 541,
    MIPS_INS_SLLI = 542,
    MIPS_INS_SLLV = 543,
    MIPS_INS_SLT = 544,
    MIPS_INS_SLTI = 545,
    MIPS_INS_SLTIU = 546,
    MIPS_INS_SLTU = 547,
    MIPS_INS_SNE = 548,
    MIPS_INS_SNEI = 549,
    MIPS_INS_SPLATI = 550,
    MIPS_INS_SPLAT = 551,
    MIPS_INS_SRA = 552,
    MIPS_INS_SRAI = 553,
    MIPS_INS_SRARI = 554,
    MIPS_INS_SRAR = 555,
    MIPS_INS_SRAV = 556,
    MIPS_INS_SRL = 557,
    MIPS_INS_SRL16 = 558,
    MIPS_INS_SRLI = 559,
    MIPS_INS_SRLRI = 560,
    MIPS_INS_SRLR = 561,
    MIPS_INS_SRLV = 562,
    MIPS_INS_SSNOP = 563,
    MIPS_INS_ST = 564,
    MIPS_INS_SUBQH = 565,
    MIPS_INS_SUBQH_R = 566,
    MIPS_INS_SUBQ = 567,
    MIPS_INS_SUBQ_S = 568,
    MIPS_INS_SUBSUS_U = 569,
    MIPS_INS_SUBSUU_S = 570,
    MIPS_INS_SUBS_S = 571,
    MIPS_INS_SUBS_U = 572,
    MIPS_INS_SUBU16 = 573,
    MIPS_INS_SUBUH = 574,
    MIPS_INS_SUBUH_R = 575,
    MIPS_INS_SUBU = 576,
    MIPS_INS_SUBU_S = 577,
    MIPS_INS_SUBVI = 578,
    MIPS_INS_SUBV = 579,
    MIPS_INS_SUXC1 = 580,
    MIPS_INS_SW = 581,
    MIPS_INS_SW16 = 582,
    MIPS_INS_SWC1 = 583,
    MIPS_INS_SWC2 = 584,
    MIPS_INS_SWC3 = 585,
    MIPS_INS_SWL = 586,
    MIPS_INS_SWM16 = 587,
    MIPS_INS_SWM32 = 588,
    MIPS_INS_SWP = 589,
    MIPS_INS_SWR = 590,
    MIPS_INS_SWXC1 = 591,
    MIPS_INS_SYNC = 592,
    MIPS_INS_SYNCI = 593,
    MIPS_INS_SYSCALL = 594,
    MIPS_INS_TEQ = 595,
    MIPS_INS_TEQI = 596,
    MIPS_INS_TGE = 597,
    MIPS_INS_TGEI = 598,
    MIPS_INS_TGEIU = 599,
    MIPS_INS_TGEU = 600,
    MIPS_INS_TLBP = 601,
    MIPS_INS_TLBR = 602,
    MIPS_INS_TLBWI = 603,
    MIPS_INS_TLBWR = 604,
    MIPS_INS_TLT = 605,
    MIPS_INS_TLTI = 606,
    MIPS_INS_TLTIU = 607,
    MIPS_INS_TLTU = 608,
    MIPS_INS_TNE = 609,
    MIPS_INS_TNEI = 610,
    MIPS_INS_TRUNC = 611,
    MIPS_INS_V3MULU = 612,
    MIPS_INS_VMM0 = 613,
    MIPS_INS_VMULU = 614,
    MIPS_INS_VSHF = 615,
    MIPS_INS_WAIT = 616,
    MIPS_INS_WRDSP = 617,
    MIPS_INS_WSBH = 618,
    MIPS_INS_XOR = 619,
    MIPS_INS_XOR16 = 620,
    MIPS_INS_XORI = 621,
    MIPS_INS_NOP = 622,
    MIPS_INS_NEGU = 623,
    MIPS_INS_JALR_HB = 624,
    MIPS_INS_JR_HB = 625,
    MIPS_INS_ENDING = 626,
}
pub mod mips_insn_group {
    #[doc = " Group of MIPS instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const MIPS_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const MIPS_GRP_JUMP: Type = 1;
    #[doc = "< = CS_GRP_CALL"]
    pub const MIPS_GRP_CALL: Type = 2;
    #[doc = "< = CS_GRP_RET"]
    pub const MIPS_GRP_RET: Type = 3;
    #[doc = "< = CS_GRP_INT"]
    pub const MIPS_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_IRET"]
    pub const MIPS_GRP_IRET: Type = 5;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const MIPS_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const MIPS_GRP_BRANCH_RELATIVE: Type = 7;
    pub const MIPS_GRP_BITCOUNT: Type = 128;
    pub const MIPS_GRP_DSP: Type = 129;
    pub const MIPS_GRP_DSPR2: Type = 130;
    pub const MIPS_GRP_FPIDX: Type = 131;
    pub const MIPS_GRP_MSA: Type = 132;
    pub const MIPS_GRP_MIPS32R2: Type = 133;
    pub const MIPS_GRP_MIPS64: Type = 134;
    pub const MIPS_GRP_MIPS64R2: Type = 135;
    pub const MIPS_GRP_SEINREG: Type = 136;
    pub const MIPS_GRP_STDENC: Type = 137;
    pub const MIPS_GRP_SWAP: Type = 138;
    pub const MIPS_GRP_MICROMIPS: Type = 139;
    pub const MIPS_GRP_MIPS16MODE: Type = 140;
    pub const MIPS_GRP_FP64BIT: Type = 141;
    pub const MIPS_GRP_NONANSFPMATH: Type = 142;
    pub const MIPS_GRP_NOTFP64BIT: Type = 143;
    pub const MIPS_GRP_NOTINMICROMIPS: Type = 144;
    pub const MIPS_GRP_NOTNACL: Type = 145;
    pub const MIPS_GRP_NOTMIPS32R6: Type = 146;
    pub const MIPS_GRP_NOTMIPS64R6: Type = 147;
    pub const MIPS_GRP_CNMIPS: Type = 148;
    pub const MIPS_GRP_MIPS32: Type = 149;
    pub const MIPS_GRP_MIPS32R6: Type = 150;
    pub const MIPS_GRP_MIPS64R6: Type = 151;
    pub const MIPS_GRP_MIPS2: Type = 152;
    pub const MIPS_GRP_MIPS3: Type = 153;
    pub const MIPS_GRP_MIPS3_32: Type = 154;
    pub const MIPS_GRP_MIPS3_32R2: Type = 155;
    pub const MIPS_GRP_MIPS4_32: Type = 156;
    pub const MIPS_GRP_MIPS4_32R2: Type = 157;
    pub const MIPS_GRP_MIPS5_32R2: Type = 158;
    pub const MIPS_GRP_GP32BIT: Type = 159;
    pub const MIPS_GRP_GP64BIT: Type = 160;
    pub const MIPS_GRP_ENDING: Type = 161;
}
#[repr(u32)]
#[doc = " PPC branch codes for some branch instructions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ppc_bc {
    PPC_BC_INVALID = 0,
    PPC_BC_LT = 12,
    PPC_BC_LE = 36,
    PPC_BC_EQ = 76,
    PPC_BC_GE = 4,
    PPC_BC_GT = 44,
    PPC_BC_NE = 68,
    PPC_BC_UN = 108,
    PPC_BC_NU = 100,
    #[doc = "< summary overflow"]
    PPC_BC_SO = 140,
    #[doc = "< not summary overflow"]
    PPC_BC_NS = 132,
}
#[repr(u32)]
#[doc = " PPC branch hint for some branch instructions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ppc_bh {
    #[doc = "< no hint"]
    PPC_BH_INVALID = 0,
    #[doc = "< PLUS hint"]
    PPC_BH_PLUS = 1,
    #[doc = "< MINUS hint"]
    PPC_BH_MINUS = 2,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ppc_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    PPC_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    PPC_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    PPC_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    PPC_OP_MEM = 3,
    #[doc = "< Condition Register field"]
    PPC_OP_CRX = 64,
}
pub mod ppc_reg {
    #[doc = " PPC registers"]
    pub type Type = libc::c_uint;
    pub const PPC_REG_INVALID: Type = 0;
    pub const PPC_REG_CARRY: Type = 2;
    pub const PPC_REG_CTR: Type = 3;
    pub const PPC_REG_LR: Type = 5;
    pub const PPC_REG_RM: Type = 6;
    pub const PPC_REG_VRSAVE: Type = 8;
    pub const PPC_REG_XER: Type = 9;
    pub const PPC_REG_ZERO: Type = 10;
    pub const PPC_REG_CR0: Type = 12;
    pub const PPC_REG_CR1: Type = 13;
    pub const PPC_REG_CR2: Type = 14;
    pub const PPC_REG_CR3: Type = 15;
    pub const PPC_REG_CR4: Type = 16;
    pub const PPC_REG_CR5: Type = 17;
    pub const PPC_REG_CR6: Type = 18;
    pub const PPC_REG_CR7: Type = 19;
    pub const PPC_REG_CTR8: Type = 20;
    pub const PPC_REG_F0: Type = 21;
    pub const PPC_REG_F1: Type = 22;
    pub const PPC_REG_F2: Type = 23;
    pub const PPC_REG_F3: Type = 24;
    pub const PPC_REG_F4: Type = 25;
    pub const PPC_REG_F5: Type = 26;
    pub const PPC_REG_F6: Type = 27;
    pub const PPC_REG_F7: Type = 28;
    pub const PPC_REG_F8: Type = 29;
    pub const PPC_REG_F9: Type = 30;
    pub const PPC_REG_F10: Type = 31;
    pub const PPC_REG_F11: Type = 32;
    pub const PPC_REG_F12: Type = 33;
    pub const PPC_REG_F13: Type = 34;
    pub const PPC_REG_F14: Type = 35;
    pub const PPC_REG_F15: Type = 36;
    pub const PPC_REG_F16: Type = 37;
    pub const PPC_REG_F17: Type = 38;
    pub const PPC_REG_F18: Type = 39;
    pub const PPC_REG_F19: Type = 40;
    pub const PPC_REG_F20: Type = 41;
    pub const PPC_REG_F21: Type = 42;
    pub const PPC_REG_F22: Type = 43;
    pub const PPC_REG_F23: Type = 44;
    pub const PPC_REG_F24: Type = 45;
    pub const PPC_REG_F25: Type = 46;
    pub const PPC_REG_F26: Type = 47;
    pub const PPC_REG_F27: Type = 48;
    pub const PPC_REG_F28: Type = 49;
    pub const PPC_REG_F29: Type = 50;
    pub const PPC_REG_F30: Type = 51;
    pub const PPC_REG_F31: Type = 52;
    pub const PPC_REG_LR8: Type = 54;
    pub const PPC_REG_Q0: Type = 55;
    pub const PPC_REG_Q1: Type = 56;
    pub const PPC_REG_Q2: Type = 57;
    pub const PPC_REG_Q3: Type = 58;
    pub const PPC_REG_Q4: Type = 59;
    pub const PPC_REG_Q5: Type = 60;
    pub const PPC_REG_Q6: Type = 61;
    pub const PPC_REG_Q7: Type = 62;
    pub const PPC_REG_Q8: Type = 63;
    pub const PPC_REG_Q9: Type = 64;
    pub const PPC_REG_Q10: Type = 65;
    pub const PPC_REG_Q11: Type = 66;
    pub const PPC_REG_Q12: Type = 67;
    pub const PPC_REG_Q13: Type = 68;
    pub const PPC_REG_Q14: Type = 69;
    pub const PPC_REG_Q15: Type = 70;
    pub const PPC_REG_Q16: Type = 71;
    pub const PPC_REG_Q17: Type = 72;
    pub const PPC_REG_Q18: Type = 73;
    pub const PPC_REG_Q19: Type = 74;
    pub const PPC_REG_Q20: Type = 75;
    pub const PPC_REG_Q21: Type = 76;
    pub const PPC_REG_Q22: Type = 77;
    pub const PPC_REG_Q23: Type = 78;
    pub const PPC_REG_Q24: Type = 79;
    pub const PPC_REG_Q25: Type = 80;
    pub const PPC_REG_Q26: Type = 81;
    pub const PPC_REG_Q27: Type = 82;
    pub const PPC_REG_Q28: Type = 83;
    pub const PPC_REG_Q29: Type = 84;
    pub const PPC_REG_Q30: Type = 85;
    pub const PPC_REG_Q31: Type = 86;
    pub const PPC_REG_R0: Type = 87;
    pub const PPC_REG_R1: Type = 88;
    pub const PPC_REG_R2: Type = 89;
    pub const PPC_REG_R3: Type = 90;
    pub const PPC_REG_R4: Type = 91;
    pub const PPC_REG_R5: Type = 92;
    pub const PPC_REG_R6: Type = 93;
    pub const PPC_REG_R7: Type = 94;
    pub const PPC_REG_R8: Type = 95;
    pub const PPC_REG_R9: Type = 96;
    pub const PPC_REG_R10: Type = 97;
    pub const PPC_REG_R11: Type = 98;
    pub const PPC_REG_R12: Type = 99;
    pub const PPC_REG_R13: Type = 100;
    pub const PPC_REG_R14: Type = 101;
    pub const PPC_REG_R15: Type = 102;
    pub const PPC_REG_R16: Type = 103;
    pub const PPC_REG_R17: Type = 104;
    pub const PPC_REG_R18: Type = 105;
    pub const PPC_REG_R19: Type = 106;
    pub const PPC_REG_R20: Type = 107;
    pub const PPC_REG_R21: Type = 108;
    pub const PPC_REG_R22: Type = 109;
    pub const PPC_REG_R23: Type = 110;
    pub const PPC_REG_R24: Type = 111;
    pub const PPC_REG_R25: Type = 112;
    pub const PPC_REG_R26: Type = 113;
    pub const PPC_REG_R27: Type = 114;
    pub const PPC_REG_R28: Type = 115;
    pub const PPC_REG_R29: Type = 116;
    pub const PPC_REG_R30: Type = 117;
    pub const PPC_REG_R31: Type = 118;
    pub const PPC_REG_V0: Type = 151;
    pub const PPC_REG_V1: Type = 152;
    pub const PPC_REG_V2: Type = 153;
    pub const PPC_REG_V3: Type = 154;
    pub const PPC_REG_V4: Type = 155;
    pub const PPC_REG_V5: Type = 156;
    pub const PPC_REG_V6: Type = 157;
    pub const PPC_REG_V7: Type = 158;
    pub const PPC_REG_V8: Type = 159;
    pub const PPC_REG_V9: Type = 160;
    pub const PPC_REG_V10: Type = 161;
    pub const PPC_REG_V11: Type = 162;
    pub const PPC_REG_V12: Type = 163;
    pub const PPC_REG_V13: Type = 164;
    pub const PPC_REG_V14: Type = 165;
    pub const PPC_REG_V15: Type = 166;
    pub const PPC_REG_V16: Type = 167;
    pub const PPC_REG_V17: Type = 168;
    pub const PPC_REG_V18: Type = 169;
    pub const PPC_REG_V19: Type = 170;
    pub const PPC_REG_V20: Type = 171;
    pub const PPC_REG_V21: Type = 172;
    pub const PPC_REG_V22: Type = 173;
    pub const PPC_REG_V23: Type = 174;
    pub const PPC_REG_V24: Type = 175;
    pub const PPC_REG_V25: Type = 176;
    pub const PPC_REG_V26: Type = 177;
    pub const PPC_REG_V27: Type = 178;
    pub const PPC_REG_V28: Type = 179;
    pub const PPC_REG_V29: Type = 180;
    pub const PPC_REG_V30: Type = 181;
    pub const PPC_REG_V31: Type = 182;
    pub const PPC_REG_VS0: Type = 215;
    pub const PPC_REG_VS1: Type = 216;
    pub const PPC_REG_VS2: Type = 217;
    pub const PPC_REG_VS3: Type = 218;
    pub const PPC_REG_VS4: Type = 219;
    pub const PPC_REG_VS5: Type = 220;
    pub const PPC_REG_VS6: Type = 221;
    pub const PPC_REG_VS7: Type = 222;
    pub const PPC_REG_VS8: Type = 223;
    pub const PPC_REG_VS9: Type = 224;
    pub const PPC_REG_VS10: Type = 225;
    pub const PPC_REG_VS11: Type = 226;
    pub const PPC_REG_VS12: Type = 227;
    pub const PPC_REG_VS13: Type = 228;
    pub const PPC_REG_VS14: Type = 229;
    pub const PPC_REG_VS15: Type = 230;
    pub const PPC_REG_VS16: Type = 231;
    pub const PPC_REG_VS17: Type = 232;
    pub const PPC_REG_VS18: Type = 233;
    pub const PPC_REG_VS19: Type = 234;
    pub const PPC_REG_VS20: Type = 235;
    pub const PPC_REG_VS21: Type = 236;
    pub const PPC_REG_VS22: Type = 237;
    pub const PPC_REG_VS23: Type = 238;
    pub const PPC_REG_VS24: Type = 239;
    pub const PPC_REG_VS25: Type = 240;
    pub const PPC_REG_VS26: Type = 241;
    pub const PPC_REG_VS27: Type = 242;
    pub const PPC_REG_VS28: Type = 243;
    pub const PPC_REG_VS29: Type = 244;
    pub const PPC_REG_VS30: Type = 245;
    pub const PPC_REG_VS31: Type = 246;
    pub const PPC_REG_VS32: Type = 247;
    pub const PPC_REG_VS33: Type = 248;
    pub const PPC_REG_VS34: Type = 249;
    pub const PPC_REG_VS35: Type = 250;
    pub const PPC_REG_VS36: Type = 251;
    pub const PPC_REG_VS37: Type = 252;
    pub const PPC_REG_VS38: Type = 253;
    pub const PPC_REG_VS39: Type = 254;
    pub const PPC_REG_VS40: Type = 255;
    pub const PPC_REG_VS41: Type = 256;
    pub const PPC_REG_VS42: Type = 257;
    pub const PPC_REG_VS43: Type = 258;
    pub const PPC_REG_VS44: Type = 259;
    pub const PPC_REG_VS45: Type = 260;
    pub const PPC_REG_VS46: Type = 261;
    pub const PPC_REG_VS47: Type = 262;
    pub const PPC_REG_VS48: Type = 263;
    pub const PPC_REG_VS49: Type = 264;
    pub const PPC_REG_VS50: Type = 265;
    pub const PPC_REG_VS51: Type = 266;
    pub const PPC_REG_VS52: Type = 267;
    pub const PPC_REG_VS53: Type = 268;
    pub const PPC_REG_VS54: Type = 269;
    pub const PPC_REG_VS55: Type = 270;
    pub const PPC_REG_VS56: Type = 271;
    pub const PPC_REG_VS57: Type = 272;
    pub const PPC_REG_VS58: Type = 273;
    pub const PPC_REG_VS59: Type = 274;
    pub const PPC_REG_VS60: Type = 275;
    pub const PPC_REG_VS61: Type = 276;
    pub const PPC_REG_VS62: Type = 277;
    pub const PPC_REG_VS63: Type = 278;
    pub const PPC_REG_CR0EQ: Type = 312;
    pub const PPC_REG_CR1EQ: Type = 313;
    pub const PPC_REG_CR2EQ: Type = 314;
    pub const PPC_REG_CR3EQ: Type = 315;
    pub const PPC_REG_CR4EQ: Type = 316;
    pub const PPC_REG_CR5EQ: Type = 317;
    pub const PPC_REG_CR6EQ: Type = 318;
    pub const PPC_REG_CR7EQ: Type = 319;
    pub const PPC_REG_CR0GT: Type = 320;
    pub const PPC_REG_CR1GT: Type = 321;
    pub const PPC_REG_CR2GT: Type = 322;
    pub const PPC_REG_CR3GT: Type = 323;
    pub const PPC_REG_CR4GT: Type = 324;
    pub const PPC_REG_CR5GT: Type = 325;
    pub const PPC_REG_CR6GT: Type = 326;
    pub const PPC_REG_CR7GT: Type = 327;
    pub const PPC_REG_CR0LT: Type = 328;
    pub const PPC_REG_CR1LT: Type = 329;
    pub const PPC_REG_CR2LT: Type = 330;
    pub const PPC_REG_CR3LT: Type = 331;
    pub const PPC_REG_CR4LT: Type = 332;
    pub const PPC_REG_CR5LT: Type = 333;
    pub const PPC_REG_CR6LT: Type = 334;
    pub const PPC_REG_CR7LT: Type = 335;
    pub const PPC_REG_CR0UN: Type = 336;
    pub const PPC_REG_CR1UN: Type = 337;
    pub const PPC_REG_CR2UN: Type = 338;
    pub const PPC_REG_CR3UN: Type = 339;
    pub const PPC_REG_CR4UN: Type = 340;
    pub const PPC_REG_CR5UN: Type = 341;
    pub const PPC_REG_CR6UN: Type = 342;
    pub const PPC_REG_CR7UN: Type = 343;
    pub const PPC_REG_ENDING: Type = 344;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with PPC_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct ppc_op_mem {
    #[doc = "< base register"]
    pub base: ppc_reg::Type,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
}
impl Clone for ppc_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct ppc_op_crx {
    pub scale: libc::c_uint,
    pub reg: ppc_reg::Type,
    pub cond: ppc_bc,
}
impl Clone for ppc_op_crx {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_ppc_op {
    #[doc = "< operand type"]
    pub type_: ppc_op_type,
    pub __bindgen_anon_1: cs_ppc_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_ppc_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: ppc_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: ppc_op_mem,
    #[doc = "< operand with condition register"]
    pub crx: ppc_op_crx,
}
impl Clone for cs_ppc_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_ppc_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_ppc_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_ppc_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_ppc_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_ppc_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_ppc {
    #[doc = " branch code for branch instructions"]
    pub bc: ppc_bc,
    #[doc = " branch hint for branch instructions"]
    pub bh: ppc_bh,
    #[doc = " if update_cr0 = True, then this 'dot' insn updates CR0"]
    pub update_cr0: bool,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_ppc_op; 8usize],
}
impl Clone for cs_ppc {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_ppc {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_ppc {{ bc: {:?}, bh: {:?}, update_cr0: {:?}, op_count: {:?}, operands: {:?} }}",
            self.bc, self.bh, self.update_cr0, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " PPC instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ppc_insn {
    PPC_INS_INVALID = 0,
    PPC_INS_ADD = 1,
    PPC_INS_ADDC = 2,
    PPC_INS_ADDE = 3,
    PPC_INS_ADDI = 4,
    PPC_INS_ADDIC = 5,
    PPC_INS_ADDIS = 6,
    PPC_INS_ADDME = 7,
    PPC_INS_ADDPCIS = 8,
    PPC_INS_ADDZE = 9,
    PPC_INS_AND = 10,
    PPC_INS_ANDC = 11,
    PPC_INS_ANDI = 12,
    PPC_INS_ANDIS = 13,
    PPC_INS_ATTN = 14,
    PPC_INS_B = 15,
    PPC_INS_BA = 16,
    PPC_INS_BC = 17,
    PPC_INS_BCA = 18,
    PPC_INS_BCCTR = 19,
    PPC_INS_BCCTRL = 20,
    PPC_INS_BCDCFN = 21,
    PPC_INS_BCDCFSQ = 22,
    PPC_INS_BCDCFZ = 23,
    PPC_INS_BCDCPSGN = 24,
    PPC_INS_BCDCTN = 25,
    PPC_INS_BCDCTSQ = 26,
    PPC_INS_BCDCTZ = 27,
    PPC_INS_BCDS = 28,
    PPC_INS_BCDSETSGN = 29,
    PPC_INS_BCDSR = 30,
    PPC_INS_BCDTRUNC = 31,
    PPC_INS_BCDUS = 32,
    PPC_INS_BCDUTRUNC = 33,
    PPC_INS_BCL = 34,
    PPC_INS_BCLA = 35,
    PPC_INS_BCLR = 36,
    PPC_INS_BCLRL = 37,
    PPC_INS_BCTR = 38,
    PPC_INS_BCTRL = 39,
    PPC_INS_BDNZ = 40,
    PPC_INS_BDNZA = 41,
    PPC_INS_BDNZF = 42,
    PPC_INS_BDNZFA = 43,
    PPC_INS_BDNZFL = 44,
    PPC_INS_BDNZFLA = 45,
    PPC_INS_BDNZFLR = 46,
    PPC_INS_BDNZFLRL = 47,
    PPC_INS_BDNZL = 48,
    PPC_INS_BDNZLA = 49,
    PPC_INS_BDNZLR = 50,
    PPC_INS_BDNZLRL = 51,
    PPC_INS_BDNZT = 52,
    PPC_INS_BDNZTA = 53,
    PPC_INS_BDNZTL = 54,
    PPC_INS_BDNZTLA = 55,
    PPC_INS_BDNZTLR = 56,
    PPC_INS_BDNZTLRL = 57,
    PPC_INS_BDZ = 58,
    PPC_INS_BDZA = 59,
    PPC_INS_BDZF = 60,
    PPC_INS_BDZFA = 61,
    PPC_INS_BDZFL = 62,
    PPC_INS_BDZFLA = 63,
    PPC_INS_BDZFLR = 64,
    PPC_INS_BDZFLRL = 65,
    PPC_INS_BDZL = 66,
    PPC_INS_BDZLA = 67,
    PPC_INS_BDZLR = 68,
    PPC_INS_BDZLRL = 69,
    PPC_INS_BDZT = 70,
    PPC_INS_BDZTA = 71,
    PPC_INS_BDZTL = 72,
    PPC_INS_BDZTLA = 73,
    PPC_INS_BDZTLR = 74,
    PPC_INS_BDZTLRL = 75,
    PPC_INS_BEQ = 76,
    PPC_INS_BEQA = 77,
    PPC_INS_BEQCTR = 78,
    PPC_INS_BEQCTRL = 79,
    PPC_INS_BEQL = 80,
    PPC_INS_BEQLA = 81,
    PPC_INS_BEQLR = 82,
    PPC_INS_BEQLRL = 83,
    PPC_INS_BF = 84,
    PPC_INS_BFA = 85,
    PPC_INS_BFCTR = 86,
    PPC_INS_BFCTRL = 87,
    PPC_INS_BFL = 88,
    PPC_INS_BFLA = 89,
    PPC_INS_BFLR = 90,
    PPC_INS_BFLRL = 91,
    PPC_INS_BGE = 92,
    PPC_INS_BGEA = 93,
    PPC_INS_BGECTR = 94,
    PPC_INS_BGECTRL = 95,
    PPC_INS_BGEL = 96,
    PPC_INS_BGELA = 97,
    PPC_INS_BGELR = 98,
    PPC_INS_BGELRL = 99,
    PPC_INS_BGT = 100,
    PPC_INS_BGTA = 101,
    PPC_INS_BGTCTR = 102,
    PPC_INS_BGTCTRL = 103,
    PPC_INS_BGTL = 104,
    PPC_INS_BGTLA = 105,
    PPC_INS_BGTLR = 106,
    PPC_INS_BGTLRL = 107,
    PPC_INS_BL = 108,
    PPC_INS_BLA = 109,
    PPC_INS_BLE = 110,
    PPC_INS_BLEA = 111,
    PPC_INS_BLECTR = 112,
    PPC_INS_BLECTRL = 113,
    PPC_INS_BLEL = 114,
    PPC_INS_BLELA = 115,
    PPC_INS_BLELR = 116,
    PPC_INS_BLELRL = 117,
    PPC_INS_BLR = 118,
    PPC_INS_BLRL = 119,
    PPC_INS_BLT = 120,
    PPC_INS_BLTA = 121,
    PPC_INS_BLTCTR = 122,
    PPC_INS_BLTCTRL = 123,
    PPC_INS_BLTL = 124,
    PPC_INS_BLTLA = 125,
    PPC_INS_BLTLR = 126,
    PPC_INS_BLTLRL = 127,
    PPC_INS_BNE = 128,
    PPC_INS_BNEA = 129,
    PPC_INS_BNECTR = 130,
    PPC_INS_BNECTRL = 131,
    PPC_INS_BNEL = 132,
    PPC_INS_BNELA = 133,
    PPC_INS_BNELR = 134,
    PPC_INS_BNELRL = 135,
    PPC_INS_BNG = 136,
    PPC_INS_BNGA = 137,
    PPC_INS_BNGCTR = 138,
    PPC_INS_BNGCTRL = 139,
    PPC_INS_BNGL = 140,
    PPC_INS_BNGLA = 141,
    PPC_INS_BNGLR = 142,
    PPC_INS_BNGLRL = 143,
    PPC_INS_BNL = 144,
    PPC_INS_BNLA = 145,
    PPC_INS_BNLCTR = 146,
    PPC_INS_BNLCTRL = 147,
    PPC_INS_BNLL = 148,
    PPC_INS_BNLLA = 149,
    PPC_INS_BNLLR = 150,
    PPC_INS_BNLLRL = 151,
    PPC_INS_BNS = 152,
    PPC_INS_BNSA = 153,
    PPC_INS_BNSCTR = 154,
    PPC_INS_BNSCTRL = 155,
    PPC_INS_BNSL = 156,
    PPC_INS_BNSLA = 157,
    PPC_INS_BNSLR = 158,
    PPC_INS_BNSLRL = 159,
    PPC_INS_BNU = 160,
    PPC_INS_BNUA = 161,
    PPC_INS_BNUCTR = 162,
    PPC_INS_BNUCTRL = 163,
    PPC_INS_BNUL = 164,
    PPC_INS_BNULA = 165,
    PPC_INS_BNULR = 166,
    PPC_INS_BNULRL = 167,
    PPC_INS_BPERMD = 168,
    PPC_INS_BRINC = 169,
    PPC_INS_BSO = 170,
    PPC_INS_BSOA = 171,
    PPC_INS_BSOCTR = 172,
    PPC_INS_BSOCTRL = 173,
    PPC_INS_BSOL = 174,
    PPC_INS_BSOLA = 175,
    PPC_INS_BSOLR = 176,
    PPC_INS_BSOLRL = 177,
    PPC_INS_BT = 178,
    PPC_INS_BTA = 179,
    PPC_INS_BTCTR = 180,
    PPC_INS_BTCTRL = 181,
    PPC_INS_BTL = 182,
    PPC_INS_BTLA = 183,
    PPC_INS_BTLR = 184,
    PPC_INS_BTLRL = 185,
    PPC_INS_BUN = 186,
    PPC_INS_BUNA = 187,
    PPC_INS_BUNCTR = 188,
    PPC_INS_BUNCTRL = 189,
    PPC_INS_BUNL = 190,
    PPC_INS_BUNLA = 191,
    PPC_INS_BUNLR = 192,
    PPC_INS_BUNLRL = 193,
    PPC_INS_CLRBHRB = 194,
    PPC_INS_CLRLDI = 195,
    PPC_INS_CLRLSLDI = 196,
    PPC_INS_CLRLSLWI = 197,
    PPC_INS_CLRLWI = 198,
    PPC_INS_CLRRDI = 199,
    PPC_INS_CLRRWI = 200,
    PPC_INS_CMP = 201,
    PPC_INS_CMPB = 202,
    PPC_INS_CMPD = 203,
    PPC_INS_CMPDI = 204,
    PPC_INS_CMPEQB = 205,
    PPC_INS_CMPI = 206,
    PPC_INS_CMPL = 207,
    PPC_INS_CMPLD = 208,
    PPC_INS_CMPLDI = 209,
    PPC_INS_CMPLI = 210,
    PPC_INS_CMPLW = 211,
    PPC_INS_CMPLWI = 212,
    PPC_INS_CMPRB = 213,
    PPC_INS_CMPW = 214,
    PPC_INS_CMPWI = 215,
    PPC_INS_CNTLZD = 216,
    PPC_INS_CNTLZW = 217,
    PPC_INS_CNTTZD = 218,
    PPC_INS_CNTTZW = 219,
    PPC_INS_COPY = 220,
    PPC_INS_COPY_FIRST = 221,
    PPC_INS_CP_ABORT = 222,
    PPC_INS_CRAND = 223,
    PPC_INS_CRANDC = 224,
    PPC_INS_CRCLR = 225,
    PPC_INS_CREQV = 226,
    PPC_INS_CRMOVE = 227,
    PPC_INS_CRNAND = 228,
    PPC_INS_CRNOR = 229,
    PPC_INS_CRNOT = 230,
    PPC_INS_CROR = 231,
    PPC_INS_CRORC = 232,
    PPC_INS_CRSET = 233,
    PPC_INS_CRXOR = 234,
    PPC_INS_DARN = 235,
    PPC_INS_DCBA = 236,
    PPC_INS_DCBF = 237,
    PPC_INS_DCBFEP = 238,
    PPC_INS_DCBFL = 239,
    PPC_INS_DCBFLP = 240,
    PPC_INS_DCBI = 241,
    PPC_INS_DCBST = 242,
    PPC_INS_DCBSTEP = 243,
    PPC_INS_DCBT = 244,
    PPC_INS_DCBTCT = 245,
    PPC_INS_DCBTDS = 246,
    PPC_INS_DCBTEP = 247,
    PPC_INS_DCBTST = 248,
    PPC_INS_DCBTSTCT = 249,
    PPC_INS_DCBTSTDS = 250,
    PPC_INS_DCBTSTEP = 251,
    PPC_INS_DCBTSTT = 252,
    PPC_INS_DCBTT = 253,
    PPC_INS_DCBZ = 254,
    PPC_INS_DCBZEP = 255,
    PPC_INS_DCBZL = 256,
    PPC_INS_DCBZLEP = 257,
    PPC_INS_DCCCI = 258,
    PPC_INS_DCI = 259,
    PPC_INS_DIVD = 260,
    PPC_INS_DIVDE = 261,
    PPC_INS_DIVDEU = 262,
    PPC_INS_DIVDU = 263,
    PPC_INS_DIVW = 264,
    PPC_INS_DIVWE = 265,
    PPC_INS_DIVWEU = 266,
    PPC_INS_DIVWU = 267,
    PPC_INS_DSS = 268,
    PPC_INS_DSSALL = 269,
    PPC_INS_DST = 270,
    PPC_INS_DSTST = 271,
    PPC_INS_DSTSTT = 272,
    PPC_INS_DSTT = 273,
    PPC_INS_EFDABS = 274,
    PPC_INS_EFDADD = 275,
    PPC_INS_EFDCFS = 276,
    PPC_INS_EFDCFSF = 277,
    PPC_INS_EFDCFSI = 278,
    PPC_INS_EFDCFSID = 279,
    PPC_INS_EFDCFUF = 280,
    PPC_INS_EFDCFUI = 281,
    PPC_INS_EFDCFUID = 282,
    PPC_INS_EFDCMPEQ = 283,
    PPC_INS_EFDCMPGT = 284,
    PPC_INS_EFDCMPLT = 285,
    PPC_INS_EFDCTSF = 286,
    PPC_INS_EFDCTSI = 287,
    PPC_INS_EFDCTSIDZ = 288,
    PPC_INS_EFDCTSIZ = 289,
    PPC_INS_EFDCTUF = 290,
    PPC_INS_EFDCTUI = 291,
    PPC_INS_EFDCTUIDZ = 292,
    PPC_INS_EFDCTUIZ = 293,
    PPC_INS_EFDDIV = 294,
    PPC_INS_EFDMUL = 295,
    PPC_INS_EFDNABS = 296,
    PPC_INS_EFDNEG = 297,
    PPC_INS_EFDSUB = 298,
    PPC_INS_EFDTSTEQ = 299,
    PPC_INS_EFDTSTGT = 300,
    PPC_INS_EFDTSTLT = 301,
    PPC_INS_EFSABS = 302,
    PPC_INS_EFSADD = 303,
    PPC_INS_EFSCFD = 304,
    PPC_INS_EFSCFSF = 305,
    PPC_INS_EFSCFSI = 306,
    PPC_INS_EFSCFUF = 307,
    PPC_INS_EFSCFUI = 308,
    PPC_INS_EFSCMPEQ = 309,
    PPC_INS_EFSCMPGT = 310,
    PPC_INS_EFSCMPLT = 311,
    PPC_INS_EFSCTSF = 312,
    PPC_INS_EFSCTSI = 313,
    PPC_INS_EFSCTSIZ = 314,
    PPC_INS_EFSCTUF = 315,
    PPC_INS_EFSCTUI = 316,
    PPC_INS_EFSCTUIZ = 317,
    PPC_INS_EFSDIV = 318,
    PPC_INS_EFSMUL = 319,
    PPC_INS_EFSNABS = 320,
    PPC_INS_EFSNEG = 321,
    PPC_INS_EFSSUB = 322,
    PPC_INS_EFSTSTEQ = 323,
    PPC_INS_EFSTSTGT = 324,
    PPC_INS_EFSTSTLT = 325,
    PPC_INS_EIEIO = 326,
    PPC_INS_EQV = 327,
    PPC_INS_EVABS = 328,
    PPC_INS_EVADDIW = 329,
    PPC_INS_EVADDSMIAAW = 330,
    PPC_INS_EVADDSSIAAW = 331,
    PPC_INS_EVADDUMIAAW = 332,
    PPC_INS_EVADDUSIAAW = 333,
    PPC_INS_EVADDW = 334,
    PPC_INS_EVAND = 335,
    PPC_INS_EVANDC = 336,
    PPC_INS_EVCMPEQ = 337,
    PPC_INS_EVCMPGTS = 338,
    PPC_INS_EVCMPGTU = 339,
    PPC_INS_EVCMPLTS = 340,
    PPC_INS_EVCMPLTU = 341,
    PPC_INS_EVCNTLSW = 342,
    PPC_INS_EVCNTLZW = 343,
    PPC_INS_EVDIVWS = 344,
    PPC_INS_EVDIVWU = 345,
    PPC_INS_EVEQV = 346,
    PPC_INS_EVEXTSB = 347,
    PPC_INS_EVEXTSH = 348,
    PPC_INS_EVFSABS = 349,
    PPC_INS_EVFSADD = 350,
    PPC_INS_EVFSCFSF = 351,
    PPC_INS_EVFSCFSI = 352,
    PPC_INS_EVFSCFUF = 353,
    PPC_INS_EVFSCFUI = 354,
    PPC_INS_EVFSCMPEQ = 355,
    PPC_INS_EVFSCMPGT = 356,
    PPC_INS_EVFSCMPLT = 357,
    PPC_INS_EVFSCTSF = 358,
    PPC_INS_EVFSCTSI = 359,
    PPC_INS_EVFSCTSIZ = 360,
    PPC_INS_EVFSCTUI = 361,
    PPC_INS_EVFSDIV = 362,
    PPC_INS_EVFSMUL = 363,
    PPC_INS_EVFSNABS = 364,
    PPC_INS_EVFSNEG = 365,
    PPC_INS_EVFSSUB = 366,
    PPC_INS_EVFSTSTEQ = 367,
    PPC_INS_EVFSTSTGT = 368,
    PPC_INS_EVFSTSTLT = 369,
    PPC_INS_EVLDD = 370,
    PPC_INS_EVLDDX = 371,
    PPC_INS_EVLDH = 372,
    PPC_INS_EVLDHX = 373,
    PPC_INS_EVLDW = 374,
    PPC_INS_EVLDWX = 375,
    PPC_INS_EVLHHESPLAT = 376,
    PPC_INS_EVLHHESPLATX = 377,
    PPC_INS_EVLHHOSSPLAT = 378,
    PPC_INS_EVLHHOSSPLATX = 379,
    PPC_INS_EVLHHOUSPLAT = 380,
    PPC_INS_EVLHHOUSPLATX = 381,
    PPC_INS_EVLWHE = 382,
    PPC_INS_EVLWHEX = 383,
    PPC_INS_EVLWHOS = 384,
    PPC_INS_EVLWHOSX = 385,
    PPC_INS_EVLWHOU = 386,
    PPC_INS_EVLWHOUX = 387,
    PPC_INS_EVLWHSPLAT = 388,
    PPC_INS_EVLWHSPLATX = 389,
    PPC_INS_EVLWWSPLAT = 390,
    PPC_INS_EVLWWSPLATX = 391,
    PPC_INS_EVMERGEHI = 392,
    PPC_INS_EVMERGEHILO = 393,
    PPC_INS_EVMERGELO = 394,
    PPC_INS_EVMERGELOHI = 395,
    PPC_INS_EVMHEGSMFAA = 396,
    PPC_INS_EVMHEGSMFAN = 397,
    PPC_INS_EVMHEGSMIAA = 398,
    PPC_INS_EVMHEGSMIAN = 399,
    PPC_INS_EVMHEGUMIAA = 400,
    PPC_INS_EVMHEGUMIAN = 401,
    PPC_INS_EVMHESMF = 402,
    PPC_INS_EVMHESMFA = 403,
    PPC_INS_EVMHESMFAAW = 404,
    PPC_INS_EVMHESMFANW = 405,
    PPC_INS_EVMHESMI = 406,
    PPC_INS_EVMHESMIA = 407,
    PPC_INS_EVMHESMIAAW = 408,
    PPC_INS_EVMHESMIANW = 409,
    PPC_INS_EVMHESSF = 410,
    PPC_INS_EVMHESSFA = 411,
    PPC_INS_EVMHESSFAAW = 412,
    PPC_INS_EVMHESSFANW = 413,
    PPC_INS_EVMHESSIAAW = 414,
    PPC_INS_EVMHESSIANW = 415,
    PPC_INS_EVMHEUMI = 416,
    PPC_INS_EVMHEUMIA = 417,
    PPC_INS_EVMHEUMIAAW = 418,
    PPC_INS_EVMHEUMIANW = 419,
    PPC_INS_EVMHEUSIAAW = 420,
    PPC_INS_EVMHEUSIANW = 421,
    PPC_INS_EVMHOGSMFAA = 422,
    PPC_INS_EVMHOGSMFAN = 423,
    PPC_INS_EVMHOGSMIAA = 424,
    PPC_INS_EVMHOGSMIAN = 425,
    PPC_INS_EVMHOGUMIAA = 426,
    PPC_INS_EVMHOGUMIAN = 427,
    PPC_INS_EVMHOSMF = 428,
    PPC_INS_EVMHOSMFA = 429,
    PPC_INS_EVMHOSMFAAW = 430,
    PPC_INS_EVMHOSMFANW = 431,
    PPC_INS_EVMHOSMI = 432,
    PPC_INS_EVMHOSMIA = 433,
    PPC_INS_EVMHOSMIAAW = 434,
    PPC_INS_EVMHOSMIANW = 435,
    PPC_INS_EVMHOSSF = 436,
    PPC_INS_EVMHOSSFA = 437,
    PPC_INS_EVMHOSSFAAW = 438,
    PPC_INS_EVMHOSSFANW = 439,
    PPC_INS_EVMHOSSIAAW = 440,
    PPC_INS_EVMHOSSIANW = 441,
    PPC_INS_EVMHOUMI = 442,
    PPC_INS_EVMHOUMIA = 443,
    PPC_INS_EVMHOUMIAAW = 444,
    PPC_INS_EVMHOUMIANW = 445,
    PPC_INS_EVMHOUSIAAW = 446,
    PPC_INS_EVMHOUSIANW = 447,
    PPC_INS_EVMRA = 448,
    PPC_INS_EVMWHSMF = 449,
    PPC_INS_EVMWHSMFA = 450,
    PPC_INS_EVMWHSMI = 451,
    PPC_INS_EVMWHSMIA = 452,
    PPC_INS_EVMWHSSF = 453,
    PPC_INS_EVMWHSSFA = 454,
    PPC_INS_EVMWHUMI = 455,
    PPC_INS_EVMWHUMIA = 456,
    PPC_INS_EVMWLSMIAAW = 457,
    PPC_INS_EVMWLSMIANW = 458,
    PPC_INS_EVMWLSSIAAW = 459,
    PPC_INS_EVMWLSSIANW = 460,
    PPC_INS_EVMWLUMI = 461,
    PPC_INS_EVMWLUMIA = 462,
    PPC_INS_EVMWLUMIAAW = 463,
    PPC_INS_EVMWLUMIANW = 464,
    PPC_INS_EVMWLUSIAAW = 465,
    PPC_INS_EVMWLUSIANW = 466,
    PPC_INS_EVMWSMF = 467,
    PPC_INS_EVMWSMFA = 468,
    PPC_INS_EVMWSMFAA = 469,
    PPC_INS_EVMWSMFAN = 470,
    PPC_INS_EVMWSMI = 471,
    PPC_INS_EVMWSMIA = 472,
    PPC_INS_EVMWSMIAA = 473,
    PPC_INS_EVMWSMIAN = 474,
    PPC_INS_EVMWSSF = 475,
    PPC_INS_EVMWSSFA = 476,
    PPC_INS_EVMWSSFAA = 477,
    PPC_INS_EVMWSSFAN = 478,
    PPC_INS_EVMWUMI = 479,
    PPC_INS_EVMWUMIA = 480,
    PPC_INS_EVMWUMIAA = 481,
    PPC_INS_EVMWUMIAN = 482,
    PPC_INS_EVNAND = 483,
    PPC_INS_EVNEG = 484,
    PPC_INS_EVNOR = 485,
    PPC_INS_EVOR = 486,
    PPC_INS_EVORC = 487,
    PPC_INS_EVRLW = 488,
    PPC_INS_EVRLWI = 489,
    PPC_INS_EVRNDW = 490,
    PPC_INS_EVSEL = 491,
    PPC_INS_EVSLW = 492,
    PPC_INS_EVSLWI = 493,
    PPC_INS_EVSPLATFI = 494,
    PPC_INS_EVSPLATI = 495,
    PPC_INS_EVSRWIS = 496,
    PPC_INS_EVSRWIU = 497,
    PPC_INS_EVSRWS = 498,
    PPC_INS_EVSRWU = 499,
    PPC_INS_EVSTDD = 500,
    PPC_INS_EVSTDDX = 501,
    PPC_INS_EVSTDH = 502,
    PPC_INS_EVSTDHX = 503,
    PPC_INS_EVSTDW = 504,
    PPC_INS_EVSTDWX = 505,
    PPC_INS_EVSTWHE = 506,
    PPC_INS_EVSTWHEX = 507,
    PPC_INS_EVSTWHO = 508,
    PPC_INS_EVSTWHOX = 509,
    PPC_INS_EVSTWWE = 510,
    PPC_INS_EVSTWWEX = 511,
    PPC_INS_EVSTWWO = 512,
    PPC_INS_EVSTWWOX = 513,
    PPC_INS_EVSUBFSMIAAW = 514,
    PPC_INS_EVSUBFSSIAAW = 515,
    PPC_INS_EVSUBFUMIAAW = 516,
    PPC_INS_EVSUBFUSIAAW = 517,
    PPC_INS_EVSUBFW = 518,
    PPC_INS_EVSUBIFW = 519,
    PPC_INS_EVXOR = 520,
    PPC_INS_EXTLDI = 521,
    PPC_INS_EXTLWI = 522,
    PPC_INS_EXTRDI = 523,
    PPC_INS_EXTRWI = 524,
    PPC_INS_EXTSB = 525,
    PPC_INS_EXTSH = 526,
    PPC_INS_EXTSW = 527,
    PPC_INS_EXTSWSLI = 528,
    PPC_INS_FABS = 529,
    PPC_INS_FADD = 530,
    PPC_INS_FADDS = 531,
    PPC_INS_FCFID = 532,
    PPC_INS_FCFIDS = 533,
    PPC_INS_FCFIDU = 534,
    PPC_INS_FCFIDUS = 535,
    PPC_INS_FCMPU = 536,
    PPC_INS_FCPSGN = 537,
    PPC_INS_FCTID = 538,
    PPC_INS_FCTIDU = 539,
    PPC_INS_FCTIDUZ = 540,
    PPC_INS_FCTIDZ = 541,
    PPC_INS_FCTIW = 542,
    PPC_INS_FCTIWU = 543,
    PPC_INS_FCTIWUZ = 544,
    PPC_INS_FCTIWZ = 545,
    PPC_INS_FDIV = 546,
    PPC_INS_FDIVS = 547,
    PPC_INS_FMADD = 548,
    PPC_INS_FMADDS = 549,
    PPC_INS_FMR = 550,
    PPC_INS_FMSUB = 551,
    PPC_INS_FMSUBS = 552,
    PPC_INS_FMUL = 553,
    PPC_INS_FMULS = 554,
    PPC_INS_FNABS = 555,
    PPC_INS_FNEG = 556,
    PPC_INS_FNMADD = 557,
    PPC_INS_FNMADDS = 558,
    PPC_INS_FNMSUB = 559,
    PPC_INS_FNMSUBS = 560,
    PPC_INS_FRE = 561,
    PPC_INS_FRES = 562,
    PPC_INS_FRIM = 563,
    PPC_INS_FRIN = 564,
    PPC_INS_FRIP = 565,
    PPC_INS_FRIZ = 566,
    PPC_INS_FRSP = 567,
    PPC_INS_FRSQRTE = 568,
    PPC_INS_FRSQRTES = 569,
    PPC_INS_FSEL = 570,
    PPC_INS_FSQRT = 571,
    PPC_INS_FSQRTS = 572,
    PPC_INS_FSUB = 573,
    PPC_INS_FSUBS = 574,
    PPC_INS_FTDIV = 575,
    PPC_INS_FTSQRT = 576,
    PPC_INS_HRFID = 577,
    PPC_INS_ICBI = 578,
    PPC_INS_ICBIEP = 579,
    PPC_INS_ICBLC = 580,
    PPC_INS_ICBLQ = 581,
    PPC_INS_ICBT = 582,
    PPC_INS_ICBTLS = 583,
    PPC_INS_ICCCI = 584,
    PPC_INS_ICI = 585,
    PPC_INS_INSLWI = 586,
    PPC_INS_INSRDI = 587,
    PPC_INS_INSRWI = 588,
    PPC_INS_ISEL = 589,
    PPC_INS_ISYNC = 590,
    PPC_INS_LA = 591,
    PPC_INS_LBARX = 592,
    PPC_INS_LBEPX = 593,
    PPC_INS_LBZ = 594,
    PPC_INS_LBZCIX = 595,
    PPC_INS_LBZU = 596,
    PPC_INS_LBZUX = 597,
    PPC_INS_LBZX = 598,
    PPC_INS_LD = 599,
    PPC_INS_LDARX = 600,
    PPC_INS_LDAT = 601,
    PPC_INS_LDBRX = 602,
    PPC_INS_LDCIX = 603,
    PPC_INS_LDMX = 604,
    PPC_INS_LDU = 605,
    PPC_INS_LDUX = 606,
    PPC_INS_LDX = 607,
    PPC_INS_LFD = 608,
    PPC_INS_LFDEPX = 609,
    PPC_INS_LFDU = 610,
    PPC_INS_LFDUX = 611,
    PPC_INS_LFDX = 612,
    PPC_INS_LFIWAX = 613,
    PPC_INS_LFIWZX = 614,
    PPC_INS_LFS = 615,
    PPC_INS_LFSU = 616,
    PPC_INS_LFSUX = 617,
    PPC_INS_LFSX = 618,
    PPC_INS_LHA = 619,
    PPC_INS_LHARX = 620,
    PPC_INS_LHAU = 621,
    PPC_INS_LHAUX = 622,
    PPC_INS_LHAX = 623,
    PPC_INS_LHBRX = 624,
    PPC_INS_LHEPX = 625,
    PPC_INS_LHZ = 626,
    PPC_INS_LHZCIX = 627,
    PPC_INS_LHZU = 628,
    PPC_INS_LHZUX = 629,
    PPC_INS_LHZX = 630,
    PPC_INS_LI = 631,
    PPC_INS_LIS = 632,
    PPC_INS_LMW = 633,
    PPC_INS_LNIA = 634,
    PPC_INS_LSWI = 635,
    PPC_INS_LVEBX = 636,
    PPC_INS_LVEHX = 637,
    PPC_INS_LVEWX = 638,
    PPC_INS_LVSL = 639,
    PPC_INS_LVSR = 640,
    PPC_INS_LVX = 641,
    PPC_INS_LVXL = 642,
    PPC_INS_LWA = 643,
    PPC_INS_LWARX = 644,
    PPC_INS_LWAT = 645,
    PPC_INS_LWAUX = 646,
    PPC_INS_LWAX = 647,
    PPC_INS_LWBRX = 648,
    PPC_INS_LWEPX = 649,
    PPC_INS_LWSYNC = 650,
    PPC_INS_LWZ = 651,
    PPC_INS_LWZCIX = 652,
    PPC_INS_LWZU = 653,
    PPC_INS_LWZUX = 654,
    PPC_INS_LWZX = 655,
    PPC_INS_LXSD = 656,
    PPC_INS_LXSDX = 657,
    PPC_INS_LXSIBZX = 658,
    PPC_INS_LXSIHZX = 659,
    PPC_INS_LXSIWAX = 660,
    PPC_INS_LXSIWZX = 661,
    PPC_INS_LXSSP = 662,
    PPC_INS_LXSSPX = 663,
    PPC_INS_LXV = 664,
    PPC_INS_LXVB16X = 665,
    PPC_INS_LXVD2X = 666,
    PPC_INS_LXVDSX = 667,
    PPC_INS_LXVH8X = 668,
    PPC_INS_LXVL = 669,
    PPC_INS_LXVLL = 670,
    PPC_INS_LXVW4X = 671,
    PPC_INS_LXVWSX = 672,
    PPC_INS_LXVX = 673,
    PPC_INS_MADDHD = 674,
    PPC_INS_MADDHDU = 675,
    PPC_INS_MADDLD = 676,
    PPC_INS_MBAR = 677,
    PPC_INS_MCRF = 678,
    PPC_INS_MCRFS = 679,
    PPC_INS_MCRXRX = 680,
    PPC_INS_MFAMR = 681,
    PPC_INS_MFASR = 682,
    PPC_INS_MFBHRBE = 683,
    PPC_INS_MFBR0 = 684,
    PPC_INS_MFBR1 = 685,
    PPC_INS_MFBR2 = 686,
    PPC_INS_MFBR3 = 687,
    PPC_INS_MFBR4 = 688,
    PPC_INS_MFBR5 = 689,
    PPC_INS_MFBR6 = 690,
    PPC_INS_MFBR7 = 691,
    PPC_INS_MFCFAR = 692,
    PPC_INS_MFCR = 693,
    PPC_INS_MFCTR = 694,
    PPC_INS_MFDAR = 695,
    PPC_INS_MFDBATL = 696,
    PPC_INS_MFDBATU = 697,
    PPC_INS_MFDCCR = 698,
    PPC_INS_MFDCR = 699,
    PPC_INS_MFDEAR = 700,
    PPC_INS_MFDEC = 701,
    PPC_INS_MFDSCR = 702,
    PPC_INS_MFDSISR = 703,
    PPC_INS_MFESR = 704,
    PPC_INS_MFFPRD = 705,
    PPC_INS_MFFS = 706,
    PPC_INS_MFFSCDRN = 707,
    PPC_INS_MFFSCDRNI = 708,
    PPC_INS_MFFSCE = 709,
    PPC_INS_MFFSCRN = 710,
    PPC_INS_MFFSCRNI = 711,
    PPC_INS_MFFSL = 712,
    PPC_INS_MFIBATL = 713,
    PPC_INS_MFIBATU = 714,
    PPC_INS_MFICCR = 715,
    PPC_INS_MFLR = 716,
    PPC_INS_MFMSR = 717,
    PPC_INS_MFOCRF = 718,
    PPC_INS_MFPID = 719,
    PPC_INS_MFPMR = 720,
    PPC_INS_MFPVR = 721,
    PPC_INS_MFRTCL = 722,
    PPC_INS_MFRTCU = 723,
    PPC_INS_MFSDR1 = 724,
    PPC_INS_MFSPEFSCR = 725,
    PPC_INS_MFSPR = 726,
    PPC_INS_MFSPRG = 727,
    PPC_INS_MFSPRG0 = 728,
    PPC_INS_MFSPRG1 = 729,
    PPC_INS_MFSPRG2 = 730,
    PPC_INS_MFSPRG3 = 731,
    PPC_INS_MFSPRG4 = 732,
    PPC_INS_MFSPRG5 = 733,
    PPC_INS_MFSPRG6 = 734,
    PPC_INS_MFSPRG7 = 735,
    PPC_INS_MFSR = 736,
    PPC_INS_MFSRIN = 737,
    PPC_INS_MFSRR0 = 738,
    PPC_INS_MFSRR1 = 739,
    PPC_INS_MFSRR2 = 740,
    PPC_INS_MFSRR3 = 741,
    PPC_INS_MFTB = 742,
    PPC_INS_MFTBHI = 743,
    PPC_INS_MFTBL = 744,
    PPC_INS_MFTBLO = 745,
    PPC_INS_MFTBU = 746,
    PPC_INS_MFTCR = 747,
    PPC_INS_MFVRD = 748,
    PPC_INS_MFVRSAVE = 749,
    PPC_INS_MFVSCR = 750,
    PPC_INS_MFVSRD = 751,
    PPC_INS_MFVSRLD = 752,
    PPC_INS_MFVSRWZ = 753,
    PPC_INS_MFXER = 754,
    PPC_INS_MODSD = 755,
    PPC_INS_MODSW = 756,
    PPC_INS_MODUD = 757,
    PPC_INS_MODUW = 758,
    PPC_INS_MR = 759,
    PPC_INS_MSGSYNC = 760,
    PPC_INS_MSYNC = 761,
    PPC_INS_MTAMR = 762,
    PPC_INS_MTASR = 763,
    PPC_INS_MTBR0 = 764,
    PPC_INS_MTBR1 = 765,
    PPC_INS_MTBR2 = 766,
    PPC_INS_MTBR3 = 767,
    PPC_INS_MTBR4 = 768,
    PPC_INS_MTBR5 = 769,
    PPC_INS_MTBR6 = 770,
    PPC_INS_MTBR7 = 771,
    PPC_INS_MTCFAR = 772,
    PPC_INS_MTCR = 773,
    PPC_INS_MTCRF = 774,
    PPC_INS_MTCTR = 775,
    PPC_INS_MTDAR = 776,
    PPC_INS_MTDBATL = 777,
    PPC_INS_MTDBATU = 778,
    PPC_INS_MTDCCR = 779,
    PPC_INS_MTDCR = 780,
    PPC_INS_MTDEAR = 781,
    PPC_INS_MTDEC = 782,
    PPC_INS_MTDSCR = 783,
    PPC_INS_MTDSISR = 784,
    PPC_INS_MTESR = 785,
    PPC_INS_MTFSB0 = 786,
    PPC_INS_MTFSB1 = 787,
    PPC_INS_MTFSF = 788,
    PPC_INS_MTFSFI = 789,
    PPC_INS_MTIBATL = 790,
    PPC_INS_MTIBATU = 791,
    PPC_INS_MTICCR = 792,
    PPC_INS_MTLR = 793,
    PPC_INS_MTMSR = 794,
    PPC_INS_MTMSRD = 795,
    PPC_INS_MTOCRF = 796,
    PPC_INS_MTPID = 797,
    PPC_INS_MTPMR = 798,
    PPC_INS_MTSDR1 = 799,
    PPC_INS_MTSPEFSCR = 800,
    PPC_INS_MTSPR = 801,
    PPC_INS_MTSPRG = 802,
    PPC_INS_MTSPRG0 = 803,
    PPC_INS_MTSPRG1 = 804,
    PPC_INS_MTSPRG2 = 805,
    PPC_INS_MTSPRG3 = 806,
    PPC_INS_MTSPRG4 = 807,
    PPC_INS_MTSPRG5 = 808,
    PPC_INS_MTSPRG6 = 809,
    PPC_INS_MTSPRG7 = 810,
    PPC_INS_MTSR = 811,
    PPC_INS_MTSRIN = 812,
    PPC_INS_MTSRR0 = 813,
    PPC_INS_MTSRR1 = 814,
    PPC_INS_MTSRR2 = 815,
    PPC_INS_MTSRR3 = 816,
    PPC_INS_MTTBHI = 817,
    PPC_INS_MTTBL = 818,
    PPC_INS_MTTBLO = 819,
    PPC_INS_MTTBU = 820,
    PPC_INS_MTTCR = 821,
    PPC_INS_MTVRSAVE = 822,
    PPC_INS_MTVSCR = 823,
    PPC_INS_MTVSRD = 824,
    PPC_INS_MTVSRDD = 825,
    PPC_INS_MTVSRWA = 826,
    PPC_INS_MTVSRWS = 827,
    PPC_INS_MTVSRWZ = 828,
    PPC_INS_MTXER = 829,
    PPC_INS_MULHD = 830,
    PPC_INS_MULHDU = 831,
    PPC_INS_MULHW = 832,
    PPC_INS_MULHWU = 833,
    PPC_INS_MULLD = 834,
    PPC_INS_MULLI = 835,
    PPC_INS_MULLW = 836,
    PPC_INS_NAND = 837,
    PPC_INS_NAP = 838,
    PPC_INS_NEG = 839,
    PPC_INS_NOP = 840,
    PPC_INS_NOR = 841,
    PPC_INS_NOT = 842,
    PPC_INS_OR = 843,
    PPC_INS_ORC = 844,
    PPC_INS_ORI = 845,
    PPC_INS_ORIS = 846,
    PPC_INS_PASTE = 847,
    PPC_INS_PASTE_LAST = 848,
    PPC_INS_POPCNTB = 849,
    PPC_INS_POPCNTD = 850,
    PPC_INS_POPCNTW = 851,
    PPC_INS_PTESYNC = 852,
    PPC_INS_QVALIGNI = 853,
    PPC_INS_QVESPLATI = 854,
    PPC_INS_QVFABS = 855,
    PPC_INS_QVFADD = 856,
    PPC_INS_QVFADDS = 857,
    PPC_INS_QVFAND = 858,
    PPC_INS_QVFANDC = 859,
    PPC_INS_QVFCFID = 860,
    PPC_INS_QVFCFIDS = 861,
    PPC_INS_QVFCFIDU = 862,
    PPC_INS_QVFCFIDUS = 863,
    PPC_INS_QVFCLR = 864,
    PPC_INS_QVFCMPEQ = 865,
    PPC_INS_QVFCMPGT = 866,
    PPC_INS_QVFCMPLT = 867,
    PPC_INS_QVFCPSGN = 868,
    PPC_INS_QVFCTFB = 869,
    PPC_INS_QVFCTID = 870,
    PPC_INS_QVFCTIDU = 871,
    PPC_INS_QVFCTIDUZ = 872,
    PPC_INS_QVFCTIDZ = 873,
    PPC_INS_QVFCTIW = 874,
    PPC_INS_QVFCTIWU = 875,
    PPC_INS_QVFCTIWUZ = 876,
    PPC_INS_QVFCTIWZ = 877,
    PPC_INS_QVFEQU = 878,
    PPC_INS_QVFLOGICAL = 879,
    PPC_INS_QVFMADD = 880,
    PPC_INS_QVFMADDS = 881,
    PPC_INS_QVFMR = 882,
    PPC_INS_QVFMSUB = 883,
    PPC_INS_QVFMSUBS = 884,
    PPC_INS_QVFMUL = 885,
    PPC_INS_QVFMULS = 886,
    PPC_INS_QVFNABS = 887,
    PPC_INS_QVFNAND = 888,
    PPC_INS_QVFNEG = 889,
    PPC_INS_QVFNMADD = 890,
    PPC_INS_QVFNMADDS = 891,
    PPC_INS_QVFNMSUB = 892,
    PPC_INS_QVFNMSUBS = 893,
    PPC_INS_QVFNOR = 894,
    PPC_INS_QVFNOT = 895,
    PPC_INS_QVFOR = 896,
    PPC_INS_QVFORC = 897,
    PPC_INS_QVFPERM = 898,
    PPC_INS_QVFRE = 899,
    PPC_INS_QVFRES = 900,
    PPC_INS_QVFRIM = 901,
    PPC_INS_QVFRIN = 902,
    PPC_INS_QVFRIP = 903,
    PPC_INS_QVFRIZ = 904,
    PPC_INS_QVFRSP = 905,
    PPC_INS_QVFRSQRTE = 906,
    PPC_INS_QVFRSQRTES = 907,
    PPC_INS_QVFSEL = 908,
    PPC_INS_QVFSET = 909,
    PPC_INS_QVFSUB = 910,
    PPC_INS_QVFSUBS = 911,
    PPC_INS_QVFTSTNAN = 912,
    PPC_INS_QVFXMADD = 913,
    PPC_INS_QVFXMADDS = 914,
    PPC_INS_QVFXMUL = 915,
    PPC_INS_QVFXMULS = 916,
    PPC_INS_QVFXOR = 917,
    PPC_INS_QVFXXCPNMADD = 918,
    PPC_INS_QVFXXCPNMADDS = 919,
    PPC_INS_QVFXXMADD = 920,
    PPC_INS_QVFXXMADDS = 921,
    PPC_INS_QVFXXNPMADD = 922,
    PPC_INS_QVFXXNPMADDS = 923,
    PPC_INS_QVGPCI = 924,
    PPC_INS_QVLFCDUX = 925,
    PPC_INS_QVLFCDUXA = 926,
    PPC_INS_QVLFCDX = 927,
    PPC_INS_QVLFCDXA = 928,
    PPC_INS_QVLFCSUX = 929,
    PPC_INS_QVLFCSUXA = 930,
    PPC_INS_QVLFCSX = 931,
    PPC_INS_QVLFCSXA = 932,
    PPC_INS_QVLFDUX = 933,
    PPC_INS_QVLFDUXA = 934,
    PPC_INS_QVLFDX = 935,
    PPC_INS_QVLFDXA = 936,
    PPC_INS_QVLFIWAX = 937,
    PPC_INS_QVLFIWAXA = 938,
    PPC_INS_QVLFIWZX = 939,
    PPC_INS_QVLFIWZXA = 940,
    PPC_INS_QVLFSUX = 941,
    PPC_INS_QVLFSUXA = 942,
    PPC_INS_QVLFSX = 943,
    PPC_INS_QVLFSXA = 944,
    PPC_INS_QVLPCLDX = 945,
    PPC_INS_QVLPCLSX = 946,
    PPC_INS_QVLPCRDX = 947,
    PPC_INS_QVLPCRSX = 948,
    PPC_INS_QVSTFCDUX = 949,
    PPC_INS_QVSTFCDUXA = 950,
    PPC_INS_QVSTFCDUXI = 951,
    PPC_INS_QVSTFCDUXIA = 952,
    PPC_INS_QVSTFCDX = 953,
    PPC_INS_QVSTFCDXA = 954,
    PPC_INS_QVSTFCDXI = 955,
    PPC_INS_QVSTFCDXIA = 956,
    PPC_INS_QVSTFCSUX = 957,
    PPC_INS_QVSTFCSUXA = 958,
    PPC_INS_QVSTFCSUXI = 959,
    PPC_INS_QVSTFCSUXIA = 960,
    PPC_INS_QVSTFCSX = 961,
    PPC_INS_QVSTFCSXA = 962,
    PPC_INS_QVSTFCSXI = 963,
    PPC_INS_QVSTFCSXIA = 964,
    PPC_INS_QVSTFDUX = 965,
    PPC_INS_QVSTFDUXA = 966,
    PPC_INS_QVSTFDUXI = 967,
    PPC_INS_QVSTFDUXIA = 968,
    PPC_INS_QVSTFDX = 969,
    PPC_INS_QVSTFDXA = 970,
    PPC_INS_QVSTFDXI = 971,
    PPC_INS_QVSTFDXIA = 972,
    PPC_INS_QVSTFIWX = 973,
    PPC_INS_QVSTFIWXA = 974,
    PPC_INS_QVSTFSUX = 975,
    PPC_INS_QVSTFSUXA = 976,
    PPC_INS_QVSTFSUXI = 977,
    PPC_INS_QVSTFSUXIA = 978,
    PPC_INS_QVSTFSX = 979,
    PPC_INS_QVSTFSXA = 980,
    PPC_INS_QVSTFSXI = 981,
    PPC_INS_QVSTFSXIA = 982,
    PPC_INS_RFCI = 983,
    PPC_INS_RFDI = 984,
    PPC_INS_RFEBB = 985,
    PPC_INS_RFI = 986,
    PPC_INS_RFID = 987,
    PPC_INS_RFMCI = 988,
    PPC_INS_RLDCL = 989,
    PPC_INS_RLDCR = 990,
    PPC_INS_RLDIC = 991,
    PPC_INS_RLDICL = 992,
    PPC_INS_RLDICR = 993,
    PPC_INS_RLDIMI = 994,
    PPC_INS_RLWIMI = 995,
    PPC_INS_RLWINM = 996,
    PPC_INS_RLWNM = 997,
    PPC_INS_ROTLD = 998,
    PPC_INS_ROTLDI = 999,
    PPC_INS_ROTLW = 1000,
    PPC_INS_ROTLWI = 1001,
    PPC_INS_ROTRDI = 1002,
    PPC_INS_ROTRWI = 1003,
    PPC_INS_SC = 1004,
    PPC_INS_SETB = 1005,
    PPC_INS_SLBIA = 1006,
    PPC_INS_SLBIE = 1007,
    PPC_INS_SLBIEG = 1008,
    PPC_INS_SLBMFEE = 1009,
    PPC_INS_SLBMFEV = 1010,
    PPC_INS_SLBMTE = 1011,
    PPC_INS_SLBSYNC = 1012,
    PPC_INS_SLD = 1013,
    PPC_INS_SLDI = 1014,
    PPC_INS_SLW = 1015,
    PPC_INS_SLWI = 1016,
    PPC_INS_SRAD = 1017,
    PPC_INS_SRADI = 1018,
    PPC_INS_SRAW = 1019,
    PPC_INS_SRAWI = 1020,
    PPC_INS_SRD = 1021,
    PPC_INS_SRDI = 1022,
    PPC_INS_SRW = 1023,
    PPC_INS_SRWI = 1024,
    PPC_INS_STB = 1025,
    PPC_INS_STBCIX = 1026,
    PPC_INS_STBCX = 1027,
    PPC_INS_STBEPX = 1028,
    PPC_INS_STBU = 1029,
    PPC_INS_STBUX = 1030,
    PPC_INS_STBX = 1031,
    PPC_INS_STD = 1032,
    PPC_INS_STDAT = 1033,
    PPC_INS_STDBRX = 1034,
    PPC_INS_STDCIX = 1035,
    PPC_INS_STDCX = 1036,
    PPC_INS_STDU = 1037,
    PPC_INS_STDUX = 1038,
    PPC_INS_STDX = 1039,
    PPC_INS_STFD = 1040,
    PPC_INS_STFDEPX = 1041,
    PPC_INS_STFDU = 1042,
    PPC_INS_STFDUX = 1043,
    PPC_INS_STFDX = 1044,
    PPC_INS_STFIWX = 1045,
    PPC_INS_STFS = 1046,
    PPC_INS_STFSU = 1047,
    PPC_INS_STFSUX = 1048,
    PPC_INS_STFSX = 1049,
    PPC_INS_STH = 1050,
    PPC_INS_STHBRX = 1051,
    PPC_INS_STHCIX = 1052,
    PPC_INS_STHCX = 1053,
    PPC_INS_STHEPX = 1054,
    PPC_INS_STHU = 1055,
    PPC_INS_STHUX = 1056,
    PPC_INS_STHX = 1057,
    PPC_INS_STMW = 1058,
    PPC_INS_STOP = 1059,
    PPC_INS_STSWI = 1060,
    PPC_INS_STVEBX = 1061,
    PPC_INS_STVEHX = 1062,
    PPC_INS_STVEWX = 1063,
    PPC_INS_STVX = 1064,
    PPC_INS_STVXL = 1065,
    PPC_INS_STW = 1066,
    PPC_INS_STWAT = 1067,
    PPC_INS_STWBRX = 1068,
    PPC_INS_STWCIX = 1069,
    PPC_INS_STWCX = 1070,
    PPC_INS_STWEPX = 1071,
    PPC_INS_STWU = 1072,
    PPC_INS_STWUX = 1073,
    PPC_INS_STWX = 1074,
    PPC_INS_STXSD = 1075,
    PPC_INS_STXSDX = 1076,
    PPC_INS_STXSIBX = 1077,
    PPC_INS_STXSIHX = 1078,
    PPC_INS_STXSIWX = 1079,
    PPC_INS_STXSSP = 1080,
    PPC_INS_STXSSPX = 1081,
    PPC_INS_STXV = 1082,
    PPC_INS_STXVB16X = 1083,
    PPC_INS_STXVD2X = 1084,
    PPC_INS_STXVH8X = 1085,
    PPC_INS_STXVL = 1086,
    PPC_INS_STXVLL = 1087,
    PPC_INS_STXVW4X = 1088,
    PPC_INS_STXVX = 1089,
    PPC_INS_SUB = 1090,
    PPC_INS_SUBC = 1091,
    PPC_INS_SUBF = 1092,
    PPC_INS_SUBFC = 1093,
    PPC_INS_SUBFE = 1094,
    PPC_INS_SUBFIC = 1095,
    PPC_INS_SUBFME = 1096,
    PPC_INS_SUBFZE = 1097,
    PPC_INS_SUBI = 1098,
    PPC_INS_SUBIC = 1099,
    PPC_INS_SUBIS = 1100,
    PPC_INS_SUBPCIS = 1101,
    PPC_INS_SYNC = 1102,
    PPC_INS_TABORT = 1103,
    PPC_INS_TABORTDC = 1104,
    PPC_INS_TABORTDCI = 1105,
    PPC_INS_TABORTWC = 1106,
    PPC_INS_TABORTWCI = 1107,
    PPC_INS_TBEGIN = 1108,
    PPC_INS_TCHECK = 1109,
    PPC_INS_TD = 1110,
    PPC_INS_TDEQ = 1111,
    PPC_INS_TDEQI = 1112,
    PPC_INS_TDGE = 1113,
    PPC_INS_TDGEI = 1114,
    PPC_INS_TDGT = 1115,
    PPC_INS_TDGTI = 1116,
    PPC_INS_TDI = 1117,
    PPC_INS_TDLE = 1118,
    PPC_INS_TDLEI = 1119,
    PPC_INS_TDLGE = 1120,
    PPC_INS_TDLGEI = 1121,
    PPC_INS_TDLGT = 1122,
    PPC_INS_TDLGTI = 1123,
    PPC_INS_TDLLE = 1124,
    PPC_INS_TDLLEI = 1125,
    PPC_INS_TDLLT = 1126,
    PPC_INS_TDLLTI = 1127,
    PPC_INS_TDLNG = 1128,
    PPC_INS_TDLNGI = 1129,
    PPC_INS_TDLNL = 1130,
    PPC_INS_TDLNLI = 1131,
    PPC_INS_TDLT = 1132,
    PPC_INS_TDLTI = 1133,
    PPC_INS_TDNE = 1134,
    PPC_INS_TDNEI = 1135,
    PPC_INS_TDNG = 1136,
    PPC_INS_TDNGI = 1137,
    PPC_INS_TDNL = 1138,
    PPC_INS_TDNLI = 1139,
    PPC_INS_TDU = 1140,
    PPC_INS_TDUI = 1141,
    PPC_INS_TEND = 1142,
    PPC_INS_TLBIA = 1143,
    PPC_INS_TLBIE = 1144,
    PPC_INS_TLBIEL = 1145,
    PPC_INS_TLBIVAX = 1146,
    PPC_INS_TLBLD = 1147,
    PPC_INS_TLBLI = 1148,
    PPC_INS_TLBRE = 1149,
    PPC_INS_TLBREHI = 1150,
    PPC_INS_TLBRELO = 1151,
    PPC_INS_TLBSX = 1152,
    PPC_INS_TLBSYNC = 1153,
    PPC_INS_TLBWE = 1154,
    PPC_INS_TLBWEHI = 1155,
    PPC_INS_TLBWELO = 1156,
    PPC_INS_TRAP = 1157,
    PPC_INS_TRECHKPT = 1158,
    PPC_INS_TRECLAIM = 1159,
    PPC_INS_TSR = 1160,
    PPC_INS_TW = 1161,
    PPC_INS_TWEQ = 1162,
    PPC_INS_TWEQI = 1163,
    PPC_INS_TWGE = 1164,
    PPC_INS_TWGEI = 1165,
    PPC_INS_TWGT = 1166,
    PPC_INS_TWGTI = 1167,
    PPC_INS_TWI = 1168,
    PPC_INS_TWLE = 1169,
    PPC_INS_TWLEI = 1170,
    PPC_INS_TWLGE = 1171,
    PPC_INS_TWLGEI = 1172,
    PPC_INS_TWLGT = 1173,
    PPC_INS_TWLGTI = 1174,
    PPC_INS_TWLLE = 1175,
    PPC_INS_TWLLEI = 1176,
    PPC_INS_TWLLT = 1177,
    PPC_INS_TWLLTI = 1178,
    PPC_INS_TWLNG = 1179,
    PPC_INS_TWLNGI = 1180,
    PPC_INS_TWLNL = 1181,
    PPC_INS_TWLNLI = 1182,
    PPC_INS_TWLT = 1183,
    PPC_INS_TWLTI = 1184,
    PPC_INS_TWNE = 1185,
    PPC_INS_TWNEI = 1186,
    PPC_INS_TWNG = 1187,
    PPC_INS_TWNGI = 1188,
    PPC_INS_TWNL = 1189,
    PPC_INS_TWNLI = 1190,
    PPC_INS_TWU = 1191,
    PPC_INS_TWUI = 1192,
    PPC_INS_VABSDUB = 1193,
    PPC_INS_VABSDUH = 1194,
    PPC_INS_VABSDUW = 1195,
    PPC_INS_VADDCUQ = 1196,
    PPC_INS_VADDCUW = 1197,
    PPC_INS_VADDECUQ = 1198,
    PPC_INS_VADDEUQM = 1199,
    PPC_INS_VADDFP = 1200,
    PPC_INS_VADDSBS = 1201,
    PPC_INS_VADDSHS = 1202,
    PPC_INS_VADDSWS = 1203,
    PPC_INS_VADDUBM = 1204,
    PPC_INS_VADDUBS = 1205,
    PPC_INS_VADDUDM = 1206,
    PPC_INS_VADDUHM = 1207,
    PPC_INS_VADDUHS = 1208,
    PPC_INS_VADDUQM = 1209,
    PPC_INS_VADDUWM = 1210,
    PPC_INS_VADDUWS = 1211,
    PPC_INS_VAND = 1212,
    PPC_INS_VANDC = 1213,
    PPC_INS_VAVGSB = 1214,
    PPC_INS_VAVGSH = 1215,
    PPC_INS_VAVGSW = 1216,
    PPC_INS_VAVGUB = 1217,
    PPC_INS_VAVGUH = 1218,
    PPC_INS_VAVGUW = 1219,
    PPC_INS_VBPERMD = 1220,
    PPC_INS_VBPERMQ = 1221,
    PPC_INS_VCFSX = 1222,
    PPC_INS_VCFUX = 1223,
    PPC_INS_VCIPHER = 1224,
    PPC_INS_VCIPHERLAST = 1225,
    PPC_INS_VCLZB = 1226,
    PPC_INS_VCLZD = 1227,
    PPC_INS_VCLZH = 1228,
    PPC_INS_VCLZLSBB = 1229,
    PPC_INS_VCLZW = 1230,
    PPC_INS_VCMPBFP = 1231,
    PPC_INS_VCMPEQFP = 1232,
    PPC_INS_VCMPEQUB = 1233,
    PPC_INS_VCMPEQUD = 1234,
    PPC_INS_VCMPEQUH = 1235,
    PPC_INS_VCMPEQUW = 1236,
    PPC_INS_VCMPGEFP = 1237,
    PPC_INS_VCMPGTFP = 1238,
    PPC_INS_VCMPGTSB = 1239,
    PPC_INS_VCMPGTSD = 1240,
    PPC_INS_VCMPGTSH = 1241,
    PPC_INS_VCMPGTSW = 1242,
    PPC_INS_VCMPGTUB = 1243,
    PPC_INS_VCMPGTUD = 1244,
    PPC_INS_VCMPGTUH = 1245,
    PPC_INS_VCMPGTUW = 1246,
    PPC_INS_VCMPNEB = 1247,
    PPC_INS_VCMPNEH = 1248,
    PPC_INS_VCMPNEW = 1249,
    PPC_INS_VCMPNEZB = 1250,
    PPC_INS_VCMPNEZH = 1251,
    PPC_INS_VCMPNEZW = 1252,
    PPC_INS_VCTSXS = 1253,
    PPC_INS_VCTUXS = 1254,
    PPC_INS_VCTZB = 1255,
    PPC_INS_VCTZD = 1256,
    PPC_INS_VCTZH = 1257,
    PPC_INS_VCTZLSBB = 1258,
    PPC_INS_VCTZW = 1259,
    PPC_INS_VEQV = 1260,
    PPC_INS_VEXPTEFP = 1261,
    PPC_INS_VEXTRACTD = 1262,
    PPC_INS_VEXTRACTUB = 1263,
    PPC_INS_VEXTRACTUH = 1264,
    PPC_INS_VEXTRACTUW = 1265,
    PPC_INS_VEXTSB2D = 1266,
    PPC_INS_VEXTSB2W = 1267,
    PPC_INS_VEXTSH2D = 1268,
    PPC_INS_VEXTSH2W = 1269,
    PPC_INS_VEXTSW2D = 1270,
    PPC_INS_VEXTUBLX = 1271,
    PPC_INS_VEXTUBRX = 1272,
    PPC_INS_VEXTUHLX = 1273,
    PPC_INS_VEXTUHRX = 1274,
    PPC_INS_VEXTUWLX = 1275,
    PPC_INS_VEXTUWRX = 1276,
    PPC_INS_VGBBD = 1277,
    PPC_INS_VINSERTB = 1278,
    PPC_INS_VINSERTD = 1279,
    PPC_INS_VINSERTH = 1280,
    PPC_INS_VINSERTW = 1281,
    PPC_INS_VLOGEFP = 1282,
    PPC_INS_VMADDFP = 1283,
    PPC_INS_VMAXFP = 1284,
    PPC_INS_VMAXSB = 1285,
    PPC_INS_VMAXSD = 1286,
    PPC_INS_VMAXSH = 1287,
    PPC_INS_VMAXSW = 1288,
    PPC_INS_VMAXUB = 1289,
    PPC_INS_VMAXUD = 1290,
    PPC_INS_VMAXUH = 1291,
    PPC_INS_VMAXUW = 1292,
    PPC_INS_VMHADDSHS = 1293,
    PPC_INS_VMHRADDSHS = 1294,
    PPC_INS_VMINFP = 1295,
    PPC_INS_VMINSB = 1296,
    PPC_INS_VMINSD = 1297,
    PPC_INS_VMINSH = 1298,
    PPC_INS_VMINSW = 1299,
    PPC_INS_VMINUB = 1300,
    PPC_INS_VMINUD = 1301,
    PPC_INS_VMINUH = 1302,
    PPC_INS_VMINUW = 1303,
    PPC_INS_VMLADDUHM = 1304,
    PPC_INS_VMR = 1305,
    PPC_INS_VMRGEW = 1306,
    PPC_INS_VMRGHB = 1307,
    PPC_INS_VMRGHH = 1308,
    PPC_INS_VMRGHW = 1309,
    PPC_INS_VMRGLB = 1310,
    PPC_INS_VMRGLH = 1311,
    PPC_INS_VMRGLW = 1312,
    PPC_INS_VMRGOW = 1313,
    PPC_INS_VMSUMMBM = 1314,
    PPC_INS_VMSUMSHM = 1315,
    PPC_INS_VMSUMSHS = 1316,
    PPC_INS_VMSUMUBM = 1317,
    PPC_INS_VMSUMUHM = 1318,
    PPC_INS_VMSUMUHS = 1319,
    PPC_INS_VMUL10CUQ = 1320,
    PPC_INS_VMUL10ECUQ = 1321,
    PPC_INS_VMUL10EUQ = 1322,
    PPC_INS_VMUL10UQ = 1323,
    PPC_INS_VMULESB = 1324,
    PPC_INS_VMULESH = 1325,
    PPC_INS_VMULESW = 1326,
    PPC_INS_VMULEUB = 1327,
    PPC_INS_VMULEUH = 1328,
    PPC_INS_VMULEUW = 1329,
    PPC_INS_VMULOSB = 1330,
    PPC_INS_VMULOSH = 1331,
    PPC_INS_VMULOSW = 1332,
    PPC_INS_VMULOUB = 1333,
    PPC_INS_VMULOUH = 1334,
    PPC_INS_VMULOUW = 1335,
    PPC_INS_VMULUWM = 1336,
    PPC_INS_VNAND = 1337,
    PPC_INS_VNCIPHER = 1338,
    PPC_INS_VNCIPHERLAST = 1339,
    PPC_INS_VNEGD = 1340,
    PPC_INS_VNEGW = 1341,
    PPC_INS_VNMSUBFP = 1342,
    PPC_INS_VNOR = 1343,
    PPC_INS_VNOT = 1344,
    PPC_INS_VOR = 1345,
    PPC_INS_VORC = 1346,
    PPC_INS_VPERM = 1347,
    PPC_INS_VPERMR = 1348,
    PPC_INS_VPERMXOR = 1349,
    PPC_INS_VPKPX = 1350,
    PPC_INS_VPKSDSS = 1351,
    PPC_INS_VPKSDUS = 1352,
    PPC_INS_VPKSHSS = 1353,
    PPC_INS_VPKSHUS = 1354,
    PPC_INS_VPKSWSS = 1355,
    PPC_INS_VPKSWUS = 1356,
    PPC_INS_VPKUDUM = 1357,
    PPC_INS_VPKUDUS = 1358,
    PPC_INS_VPKUHUM = 1359,
    PPC_INS_VPKUHUS = 1360,
    PPC_INS_VPKUWUM = 1361,
    PPC_INS_VPKUWUS = 1362,
    PPC_INS_VPMSUMB = 1363,
    PPC_INS_VPMSUMD = 1364,
    PPC_INS_VPMSUMH = 1365,
    PPC_INS_VPMSUMW = 1366,
    PPC_INS_VPOPCNTB = 1367,
    PPC_INS_VPOPCNTD = 1368,
    PPC_INS_VPOPCNTH = 1369,
    PPC_INS_VPOPCNTW = 1370,
    PPC_INS_VPRTYBD = 1371,
    PPC_INS_VPRTYBQ = 1372,
    PPC_INS_VPRTYBW = 1373,
    PPC_INS_VREFP = 1374,
    PPC_INS_VRFIM = 1375,
    PPC_INS_VRFIN = 1376,
    PPC_INS_VRFIP = 1377,
    PPC_INS_VRFIZ = 1378,
    PPC_INS_VRLB = 1379,
    PPC_INS_VRLD = 1380,
    PPC_INS_VRLDMI = 1381,
    PPC_INS_VRLDNM = 1382,
    PPC_INS_VRLH = 1383,
    PPC_INS_VRLW = 1384,
    PPC_INS_VRLWMI = 1385,
    PPC_INS_VRLWNM = 1386,
    PPC_INS_VRSQRTEFP = 1387,
    PPC_INS_VSBOX = 1388,
    PPC_INS_VSEL = 1389,
    PPC_INS_VSHASIGMAD = 1390,
    PPC_INS_VSHASIGMAW = 1391,
    PPC_INS_VSL = 1392,
    PPC_INS_VSLB = 1393,
    PPC_INS_VSLD = 1394,
    PPC_INS_VSLDOI = 1395,
    PPC_INS_VSLH = 1396,
    PPC_INS_VSLO = 1397,
    PPC_INS_VSLV = 1398,
    PPC_INS_VSLW = 1399,
    PPC_INS_VSPLTB = 1400,
    PPC_INS_VSPLTH = 1401,
    PPC_INS_VSPLTISB = 1402,
    PPC_INS_VSPLTISH = 1403,
    PPC_INS_VSPLTISW = 1404,
    PPC_INS_VSPLTW = 1405,
    PPC_INS_VSR = 1406,
    PPC_INS_VSRAB = 1407,
    PPC_INS_VSRAD = 1408,
    PPC_INS_VSRAH = 1409,
    PPC_INS_VSRAW = 1410,
    PPC_INS_VSRB = 1411,
    PPC_INS_VSRD = 1412,
    PPC_INS_VSRH = 1413,
    PPC_INS_VSRO = 1414,
    PPC_INS_VSRV = 1415,
    PPC_INS_VSRW = 1416,
    PPC_INS_VSUBCUQ = 1417,
    PPC_INS_VSUBCUW = 1418,
    PPC_INS_VSUBECUQ = 1419,
    PPC_INS_VSUBEUQM = 1420,
    PPC_INS_VSUBFP = 1421,
    PPC_INS_VSUBSBS = 1422,
    PPC_INS_VSUBSHS = 1423,
    PPC_INS_VSUBSWS = 1424,
    PPC_INS_VSUBUBM = 1425,
    PPC_INS_VSUBUBS = 1426,
    PPC_INS_VSUBUDM = 1427,
    PPC_INS_VSUBUHM = 1428,
    PPC_INS_VSUBUHS = 1429,
    PPC_INS_VSUBUQM = 1430,
    PPC_INS_VSUBUWM = 1431,
    PPC_INS_VSUBUWS = 1432,
    PPC_INS_VSUM2SWS = 1433,
    PPC_INS_VSUM4SBS = 1434,
    PPC_INS_VSUM4SHS = 1435,
    PPC_INS_VSUM4UBS = 1436,
    PPC_INS_VSUMSWS = 1437,
    PPC_INS_VUPKHPX = 1438,
    PPC_INS_VUPKHSB = 1439,
    PPC_INS_VUPKHSH = 1440,
    PPC_INS_VUPKHSW = 1441,
    PPC_INS_VUPKLPX = 1442,
    PPC_INS_VUPKLSB = 1443,
    PPC_INS_VUPKLSH = 1444,
    PPC_INS_VUPKLSW = 1445,
    PPC_INS_VXOR = 1446,
    PPC_INS_WAIT = 1447,
    PPC_INS_WAITIMPL = 1448,
    PPC_INS_WAITRSV = 1449,
    PPC_INS_WRTEE = 1450,
    PPC_INS_WRTEEI = 1451,
    PPC_INS_XNOP = 1452,
    PPC_INS_XOR = 1453,
    PPC_INS_XORI = 1454,
    PPC_INS_XORIS = 1455,
    PPC_INS_XSABSDP = 1456,
    PPC_INS_XSABSQP = 1457,
    PPC_INS_XSADDDP = 1458,
    PPC_INS_XSADDQP = 1459,
    PPC_INS_XSADDQPO = 1460,
    PPC_INS_XSADDSP = 1461,
    PPC_INS_XSCMPEQDP = 1462,
    PPC_INS_XSCMPEXPDP = 1463,
    PPC_INS_XSCMPEXPQP = 1464,
    PPC_INS_XSCMPGEDP = 1465,
    PPC_INS_XSCMPGTDP = 1466,
    PPC_INS_XSCMPODP = 1467,
    PPC_INS_XSCMPOQP = 1468,
    PPC_INS_XSCMPUDP = 1469,
    PPC_INS_XSCMPUQP = 1470,
    PPC_INS_XSCPSGNDP = 1471,
    PPC_INS_XSCPSGNQP = 1472,
    PPC_INS_XSCVDPHP = 1473,
    PPC_INS_XSCVDPQP = 1474,
    PPC_INS_XSCVDPSP = 1475,
    PPC_INS_XSCVDPSPN = 1476,
    PPC_INS_XSCVDPSXDS = 1477,
    PPC_INS_XSCVDPSXWS = 1478,
    PPC_INS_XSCVDPUXDS = 1479,
    PPC_INS_XSCVDPUXWS = 1480,
    PPC_INS_XSCVHPDP = 1481,
    PPC_INS_XSCVQPDP = 1482,
    PPC_INS_XSCVQPDPO = 1483,
    PPC_INS_XSCVQPSDZ = 1484,
    PPC_INS_XSCVQPSWZ = 1485,
    PPC_INS_XSCVQPUDZ = 1486,
    PPC_INS_XSCVQPUWZ = 1487,
    PPC_INS_XSCVSDQP = 1488,
    PPC_INS_XSCVSPDP = 1489,
    PPC_INS_XSCVSPDPN = 1490,
    PPC_INS_XSCVSXDDP = 1491,
    PPC_INS_XSCVSXDSP = 1492,
    PPC_INS_XSCVUDQP = 1493,
    PPC_INS_XSCVUXDDP = 1494,
    PPC_INS_XSCVUXDSP = 1495,
    PPC_INS_XSDIVDP = 1496,
    PPC_INS_XSDIVQP = 1497,
    PPC_INS_XSDIVQPO = 1498,
    PPC_INS_XSDIVSP = 1499,
    PPC_INS_XSIEXPDP = 1500,
    PPC_INS_XSIEXPQP = 1501,
    PPC_INS_XSMADDADP = 1502,
    PPC_INS_XSMADDASP = 1503,
    PPC_INS_XSMADDMDP = 1504,
    PPC_INS_XSMADDMSP = 1505,
    PPC_INS_XSMADDQP = 1506,
    PPC_INS_XSMADDQPO = 1507,
    PPC_INS_XSMAXCDP = 1508,
    PPC_INS_XSMAXDP = 1509,
    PPC_INS_XSMAXJDP = 1510,
    PPC_INS_XSMINCDP = 1511,
    PPC_INS_XSMINDP = 1512,
    PPC_INS_XSMINJDP = 1513,
    PPC_INS_XSMSUBADP = 1514,
    PPC_INS_XSMSUBASP = 1515,
    PPC_INS_XSMSUBMDP = 1516,
    PPC_INS_XSMSUBMSP = 1517,
    PPC_INS_XSMSUBQP = 1518,
    PPC_INS_XSMSUBQPO = 1519,
    PPC_INS_XSMULDP = 1520,
    PPC_INS_XSMULQP = 1521,
    PPC_INS_XSMULQPO = 1522,
    PPC_INS_XSMULSP = 1523,
    PPC_INS_XSNABSDP = 1524,
    PPC_INS_XSNABSQP = 1525,
    PPC_INS_XSNEGDP = 1526,
    PPC_INS_XSNEGQP = 1527,
    PPC_INS_XSNMADDADP = 1528,
    PPC_INS_XSNMADDASP = 1529,
    PPC_INS_XSNMADDMDP = 1530,
    PPC_INS_XSNMADDMSP = 1531,
    PPC_INS_XSNMADDQP = 1532,
    PPC_INS_XSNMADDQPO = 1533,
    PPC_INS_XSNMSUBADP = 1534,
    PPC_INS_XSNMSUBASP = 1535,
    PPC_INS_XSNMSUBMDP = 1536,
    PPC_INS_XSNMSUBMSP = 1537,
    PPC_INS_XSNMSUBQP = 1538,
    PPC_INS_XSNMSUBQPO = 1539,
    PPC_INS_XSRDPI = 1540,
    PPC_INS_XSRDPIC = 1541,
    PPC_INS_XSRDPIM = 1542,
    PPC_INS_XSRDPIP = 1543,
    PPC_INS_XSRDPIZ = 1544,
    PPC_INS_XSREDP = 1545,
    PPC_INS_XSRESP = 1546,
    PPC_INS_XSRQPI = 1547,
    PPC_INS_XSRQPIX = 1548,
    PPC_INS_XSRQPXP = 1549,
    PPC_INS_XSRSP = 1550,
    PPC_INS_XSRSQRTEDP = 1551,
    PPC_INS_XSRSQRTESP = 1552,
    PPC_INS_XSSQRTDP = 1553,
    PPC_INS_XSSQRTQP = 1554,
    PPC_INS_XSSQRTQPO = 1555,
    PPC_INS_XSSQRTSP = 1556,
    PPC_INS_XSSUBDP = 1557,
    PPC_INS_XSSUBQP = 1558,
    PPC_INS_XSSUBQPO = 1559,
    PPC_INS_XSSUBSP = 1560,
    PPC_INS_XSTDIVDP = 1561,
    PPC_INS_XSTSQRTDP = 1562,
    PPC_INS_XSTSTDCDP = 1563,
    PPC_INS_XSTSTDCQP = 1564,
    PPC_INS_XSTSTDCSP = 1565,
    PPC_INS_XSXEXPDP = 1566,
    PPC_INS_XSXEXPQP = 1567,
    PPC_INS_XSXSIGDP = 1568,
    PPC_INS_XSXSIGQP = 1569,
    PPC_INS_XVABSDP = 1570,
    PPC_INS_XVABSSP = 1571,
    PPC_INS_XVADDDP = 1572,
    PPC_INS_XVADDSP = 1573,
    PPC_INS_XVCMPEQDP = 1574,
    PPC_INS_XVCMPEQSP = 1575,
    PPC_INS_XVCMPGEDP = 1576,
    PPC_INS_XVCMPGESP = 1577,
    PPC_INS_XVCMPGTDP = 1578,
    PPC_INS_XVCMPGTSP = 1579,
    PPC_INS_XVCPSGNDP = 1580,
    PPC_INS_XVCPSGNSP = 1581,
    PPC_INS_XVCVDPSP = 1582,
    PPC_INS_XVCVDPSXDS = 1583,
    PPC_INS_XVCVDPSXWS = 1584,
    PPC_INS_XVCVDPUXDS = 1585,
    PPC_INS_XVCVDPUXWS = 1586,
    PPC_INS_XVCVHPSP = 1587,
    PPC_INS_XVCVSPDP = 1588,
    PPC_INS_XVCVSPHP = 1589,
    PPC_INS_XVCVSPSXDS = 1590,
    PPC_INS_XVCVSPSXWS = 1591,
    PPC_INS_XVCVSPUXDS = 1592,
    PPC_INS_XVCVSPUXWS = 1593,
    PPC_INS_XVCVSXDDP = 1594,
    PPC_INS_XVCVSXDSP = 1595,
    PPC_INS_XVCVSXWDP = 1596,
    PPC_INS_XVCVSXWSP = 1597,
    PPC_INS_XVCVUXDDP = 1598,
    PPC_INS_XVCVUXDSP = 1599,
    PPC_INS_XVCVUXWDP = 1600,
    PPC_INS_XVCVUXWSP = 1601,
    PPC_INS_XVDIVDP = 1602,
    PPC_INS_XVDIVSP = 1603,
    PPC_INS_XVIEXPDP = 1604,
    PPC_INS_XVIEXPSP = 1605,
    PPC_INS_XVMADDADP = 1606,
    PPC_INS_XVMADDASP = 1607,
    PPC_INS_XVMADDMDP = 1608,
    PPC_INS_XVMADDMSP = 1609,
    PPC_INS_XVMAXDP = 1610,
    PPC_INS_XVMAXSP = 1611,
    PPC_INS_XVMINDP = 1612,
    PPC_INS_XVMINSP = 1613,
    PPC_INS_XVMOVDP = 1614,
    PPC_INS_XVMOVSP = 1615,
    PPC_INS_XVMSUBADP = 1616,
    PPC_INS_XVMSUBASP = 1617,
    PPC_INS_XVMSUBMDP = 1618,
    PPC_INS_XVMSUBMSP = 1619,
    PPC_INS_XVMULDP = 1620,
    PPC_INS_XVMULSP = 1621,
    PPC_INS_XVNABSDP = 1622,
    PPC_INS_XVNABSSP = 1623,
    PPC_INS_XVNEGDP = 1624,
    PPC_INS_XVNEGSP = 1625,
    PPC_INS_XVNMADDADP = 1626,
    PPC_INS_XVNMADDASP = 1627,
    PPC_INS_XVNMADDMDP = 1628,
    PPC_INS_XVNMADDMSP = 1629,
    PPC_INS_XVNMSUBADP = 1630,
    PPC_INS_XVNMSUBASP = 1631,
    PPC_INS_XVNMSUBMDP = 1632,
    PPC_INS_XVNMSUBMSP = 1633,
    PPC_INS_XVRDPI = 1634,
    PPC_INS_XVRDPIC = 1635,
    PPC_INS_XVRDPIM = 1636,
    PPC_INS_XVRDPIP = 1637,
    PPC_INS_XVRDPIZ = 1638,
    PPC_INS_XVREDP = 1639,
    PPC_INS_XVRESP = 1640,
    PPC_INS_XVRSPI = 1641,
    PPC_INS_XVRSPIC = 1642,
    PPC_INS_XVRSPIM = 1643,
    PPC_INS_XVRSPIP = 1644,
    PPC_INS_XVRSPIZ = 1645,
    PPC_INS_XVRSQRTEDP = 1646,
    PPC_INS_XVRSQRTESP = 1647,
    PPC_INS_XVSQRTDP = 1648,
    PPC_INS_XVSQRTSP = 1649,
    PPC_INS_XVSUBDP = 1650,
    PPC_INS_XVSUBSP = 1651,
    PPC_INS_XVTDIVDP = 1652,
    PPC_INS_XVTDIVSP = 1653,
    PPC_INS_XVTSQRTDP = 1654,
    PPC_INS_XVTSQRTSP = 1655,
    PPC_INS_XVTSTDCDP = 1656,
    PPC_INS_XVTSTDCSP = 1657,
    PPC_INS_XVXEXPDP = 1658,
    PPC_INS_XVXEXPSP = 1659,
    PPC_INS_XVXSIGDP = 1660,
    PPC_INS_XVXSIGSP = 1661,
    PPC_INS_XXBRD = 1662,
    PPC_INS_XXBRH = 1663,
    PPC_INS_XXBRQ = 1664,
    PPC_INS_XXBRW = 1665,
    PPC_INS_XXEXTRACTUW = 1666,
    PPC_INS_XXINSERTW = 1667,
    PPC_INS_XXLAND = 1668,
    PPC_INS_XXLANDC = 1669,
    PPC_INS_XXLEQV = 1670,
    PPC_INS_XXLNAND = 1671,
    PPC_INS_XXLNOR = 1672,
    PPC_INS_XXLOR = 1673,
    PPC_INS_XXLORC = 1674,
    PPC_INS_XXLXOR = 1675,
    PPC_INS_XXMRGHD = 1676,
    PPC_INS_XXMRGHW = 1677,
    PPC_INS_XXMRGLD = 1678,
    PPC_INS_XXMRGLW = 1679,
    PPC_INS_XXPERM = 1680,
    PPC_INS_XXPERMDI = 1681,
    PPC_INS_XXPERMR = 1682,
    PPC_INS_XXSEL = 1683,
    PPC_INS_XXSLDWI = 1684,
    PPC_INS_XXSPLTD = 1685,
    PPC_INS_XXSPLTIB = 1686,
    PPC_INS_XXSPLTW = 1687,
    PPC_INS_XXSWAPD = 1688,
    PPC_INS_ENDING = 1689,
}
pub mod ppc_insn_group {
    #[doc = " Group of PPC instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const PPC_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const PPC_GRP_JUMP: Type = 1;
    pub const PPC_GRP_ALTIVEC: Type = 128;
    pub const PPC_GRP_MODE32: Type = 129;
    pub const PPC_GRP_MODE64: Type = 130;
    pub const PPC_GRP_BOOKE: Type = 131;
    pub const PPC_GRP_NOTBOOKE: Type = 132;
    pub const PPC_GRP_SPE: Type = 133;
    pub const PPC_GRP_VSX: Type = 134;
    pub const PPC_GRP_E500: Type = 135;
    pub const PPC_GRP_PPC4XX: Type = 136;
    pub const PPC_GRP_PPC6XX: Type = 137;
    pub const PPC_GRP_ICBT: Type = 138;
    pub const PPC_GRP_P8ALTIVEC: Type = 139;
    pub const PPC_GRP_P8VECTOR: Type = 140;
    pub const PPC_GRP_QPX: Type = 141;
    pub const PPC_GRP_ENDING: Type = 142;
}
#[repr(u32)]
#[doc = " Enums corresponding to Sparc condition codes, both icc's and fcc's."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sparc_cc {
    #[doc = "< invalid CC (default)"]
    SPARC_CC_INVALID = 0,
    #[doc = "< Always"]
    SPARC_CC_ICC_A = 264,
    #[doc = "< Never"]
    SPARC_CC_ICC_N = 256,
    #[doc = "< Not Equal"]
    SPARC_CC_ICC_NE = 265,
    #[doc = "< Equal"]
    SPARC_CC_ICC_E = 257,
    #[doc = "< Greater"]
    SPARC_CC_ICC_G = 266,
    #[doc = "< Less or Equal"]
    SPARC_CC_ICC_LE = 258,
    #[doc = "< Greater or Equal"]
    SPARC_CC_ICC_GE = 267,
    #[doc = "< Less"]
    SPARC_CC_ICC_L = 259,
    #[doc = "< Greater Unsigned"]
    SPARC_CC_ICC_GU = 268,
    #[doc = "< Less or Equal Unsigned"]
    SPARC_CC_ICC_LEU = 260,
    #[doc = "< Carry Clear/Great or Equal Unsigned"]
    SPARC_CC_ICC_CC = 269,
    #[doc = "< Carry Set/Less Unsigned"]
    SPARC_CC_ICC_CS = 261,
    #[doc = "< Positive"]
    SPARC_CC_ICC_POS = 270,
    #[doc = "< Negative"]
    SPARC_CC_ICC_NEG = 262,
    #[doc = "< Overflow Clear"]
    SPARC_CC_ICC_VC = 271,
    #[doc = "< Overflow Set"]
    SPARC_CC_ICC_VS = 263,
    #[doc = "< Always"]
    SPARC_CC_FCC_A = 280,
    #[doc = "< Never"]
    SPARC_CC_FCC_N = 272,
    #[doc = "< Unordered"]
    SPARC_CC_FCC_U = 279,
    #[doc = "< Greater"]
    SPARC_CC_FCC_G = 278,
    #[doc = "< Unordered or Greater"]
    SPARC_CC_FCC_UG = 277,
    #[doc = "< Less"]
    SPARC_CC_FCC_L = 276,
    #[doc = "< Unordered or Less"]
    SPARC_CC_FCC_UL = 275,
    #[doc = "< Less or Greater"]
    SPARC_CC_FCC_LG = 274,
    #[doc = "< Not Equal"]
    SPARC_CC_FCC_NE = 273,
    #[doc = "< Equal"]
    SPARC_CC_FCC_E = 281,
    #[doc = "< Unordered or Equal"]
    SPARC_CC_FCC_UE = 282,
    #[doc = "< Greater or Equal"]
    SPARC_CC_FCC_GE = 283,
    #[doc = "< Unordered or Greater or Equal"]
    SPARC_CC_FCC_UGE = 284,
    #[doc = "< Less or Equal"]
    SPARC_CC_FCC_LE = 285,
    #[doc = "< Unordered or Less or Equal"]
    SPARC_CC_FCC_ULE = 286,
    #[doc = "< Ordered"]
    SPARC_CC_FCC_O = 287,
}
#[repr(u32)]
#[doc = " Branch hint"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sparc_hint {
    #[doc = "< no hint"]
    SPARC_HINT_INVALID = 0,
    #[doc = "< annul delay slot instruction"]
    SPARC_HINT_A = 1,
    #[doc = "< branch taken"]
    SPARC_HINT_PT = 2,
    #[doc = "< branch NOT taken"]
    SPARC_HINT_PN = 4,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sparc_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    SPARC_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    SPARC_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    SPARC_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    SPARC_OP_MEM = 3,
}
pub mod sparc_reg {
    #[doc = " SPARC registers"]
    pub type Type = libc::c_uint;
    pub const SPARC_REG_INVALID: Type = 0;
    pub const SPARC_REG_F0: Type = 1;
    pub const SPARC_REG_F1: Type = 2;
    pub const SPARC_REG_F2: Type = 3;
    pub const SPARC_REG_F3: Type = 4;
    pub const SPARC_REG_F4: Type = 5;
    pub const SPARC_REG_F5: Type = 6;
    pub const SPARC_REG_F6: Type = 7;
    pub const SPARC_REG_F7: Type = 8;
    pub const SPARC_REG_F8: Type = 9;
    pub const SPARC_REG_F9: Type = 10;
    pub const SPARC_REG_F10: Type = 11;
    pub const SPARC_REG_F11: Type = 12;
    pub const SPARC_REG_F12: Type = 13;
    pub const SPARC_REG_F13: Type = 14;
    pub const SPARC_REG_F14: Type = 15;
    pub const SPARC_REG_F15: Type = 16;
    pub const SPARC_REG_F16: Type = 17;
    pub const SPARC_REG_F17: Type = 18;
    pub const SPARC_REG_F18: Type = 19;
    pub const SPARC_REG_F19: Type = 20;
    pub const SPARC_REG_F20: Type = 21;
    pub const SPARC_REG_F21: Type = 22;
    pub const SPARC_REG_F22: Type = 23;
    pub const SPARC_REG_F23: Type = 24;
    pub const SPARC_REG_F24: Type = 25;
    pub const SPARC_REG_F25: Type = 26;
    pub const SPARC_REG_F26: Type = 27;
    pub const SPARC_REG_F27: Type = 28;
    pub const SPARC_REG_F28: Type = 29;
    pub const SPARC_REG_F29: Type = 30;
    pub const SPARC_REG_F30: Type = 31;
    pub const SPARC_REG_F31: Type = 32;
    pub const SPARC_REG_F32: Type = 33;
    pub const SPARC_REG_F34: Type = 34;
    pub const SPARC_REG_F36: Type = 35;
    pub const SPARC_REG_F38: Type = 36;
    pub const SPARC_REG_F40: Type = 37;
    pub const SPARC_REG_F42: Type = 38;
    pub const SPARC_REG_F44: Type = 39;
    pub const SPARC_REG_F46: Type = 40;
    pub const SPARC_REG_F48: Type = 41;
    pub const SPARC_REG_F50: Type = 42;
    pub const SPARC_REG_F52: Type = 43;
    pub const SPARC_REG_F54: Type = 44;
    pub const SPARC_REG_F56: Type = 45;
    pub const SPARC_REG_F58: Type = 46;
    pub const SPARC_REG_F60: Type = 47;
    pub const SPARC_REG_F62: Type = 48;
    pub const SPARC_REG_FCC0: Type = 49;
    pub const SPARC_REG_FCC1: Type = 50;
    pub const SPARC_REG_FCC2: Type = 51;
    pub const SPARC_REG_FCC3: Type = 52;
    pub const SPARC_REG_FP: Type = 53;
    pub const SPARC_REG_G0: Type = 54;
    pub const SPARC_REG_G1: Type = 55;
    pub const SPARC_REG_G2: Type = 56;
    pub const SPARC_REG_G3: Type = 57;
    pub const SPARC_REG_G4: Type = 58;
    pub const SPARC_REG_G5: Type = 59;
    pub const SPARC_REG_G6: Type = 60;
    pub const SPARC_REG_G7: Type = 61;
    pub const SPARC_REG_I0: Type = 62;
    pub const SPARC_REG_I1: Type = 63;
    pub const SPARC_REG_I2: Type = 64;
    pub const SPARC_REG_I3: Type = 65;
    pub const SPARC_REG_I4: Type = 66;
    pub const SPARC_REG_I5: Type = 67;
    pub const SPARC_REG_I7: Type = 68;
    pub const SPARC_REG_ICC: Type = 69;
    pub const SPARC_REG_L0: Type = 70;
    pub const SPARC_REG_L1: Type = 71;
    pub const SPARC_REG_L2: Type = 72;
    pub const SPARC_REG_L3: Type = 73;
    pub const SPARC_REG_L4: Type = 74;
    pub const SPARC_REG_L5: Type = 75;
    pub const SPARC_REG_L6: Type = 76;
    pub const SPARC_REG_L7: Type = 77;
    pub const SPARC_REG_O0: Type = 78;
    pub const SPARC_REG_O1: Type = 79;
    pub const SPARC_REG_O2: Type = 80;
    pub const SPARC_REG_O3: Type = 81;
    pub const SPARC_REG_O4: Type = 82;
    pub const SPARC_REG_O5: Type = 83;
    pub const SPARC_REG_O7: Type = 84;
    pub const SPARC_REG_SP: Type = 85;
    pub const SPARC_REG_Y: Type = 86;
    pub const SPARC_REG_XCC: Type = 87;
    pub const SPARC_REG_ENDING: Type = 88;
    pub const SPARC_REG_O6: Type = 85;
    pub const SPARC_REG_I6: Type = 53;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with SPARC_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct sparc_op_mem {
    #[doc = "< base register, can be safely interpreted as"]
    #[doc = "< a value of type `sparc_reg`, but it is only"]
    #[doc = "< one byte wide"]
    pub base: u8,
    #[doc = "< index register, same conditions apply here"]
    pub index: u8,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
}
impl Clone for sparc_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_sparc_op {
    #[doc = "< operand type"]
    pub type_: sparc_op_type,
    pub __bindgen_anon_1: cs_sparc_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_sparc_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: sparc_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: sparc_op_mem,
}
impl Clone for cs_sparc_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sparc_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_sparc_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_sparc_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sparc_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sparc_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_sparc {
    #[doc = "< code condition for this insn"]
    pub cc: sparc_cc,
    #[doc = "< branch hint: encoding as bitwise OR of sparc_hint."]
    pub hint: sparc_hint,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_sparc_op; 4usize],
}
impl Clone for cs_sparc {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sparc {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sparc {{ cc: {:?}, hint: {:?}, op_count: {:?}, operands: {:?} }}",
            self.cc, self.hint, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " SPARC instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sparc_insn {
    SPARC_INS_INVALID = 0,
    SPARC_INS_ADDCC = 1,
    SPARC_INS_ADDX = 2,
    SPARC_INS_ADDXCC = 3,
    SPARC_INS_ADDXC = 4,
    SPARC_INS_ADDXCCC = 5,
    SPARC_INS_ADD = 6,
    SPARC_INS_ALIGNADDR = 7,
    SPARC_INS_ALIGNADDRL = 8,
    SPARC_INS_ANDCC = 9,
    SPARC_INS_ANDNCC = 10,
    SPARC_INS_ANDN = 11,
    SPARC_INS_AND = 12,
    SPARC_INS_ARRAY16 = 13,
    SPARC_INS_ARRAY32 = 14,
    SPARC_INS_ARRAY8 = 15,
    SPARC_INS_B = 16,
    SPARC_INS_JMP = 17,
    SPARC_INS_BMASK = 18,
    SPARC_INS_FB = 19,
    SPARC_INS_BRGEZ = 20,
    SPARC_INS_BRGZ = 21,
    SPARC_INS_BRLEZ = 22,
    SPARC_INS_BRLZ = 23,
    SPARC_INS_BRNZ = 24,
    SPARC_INS_BRZ = 25,
    SPARC_INS_BSHUFFLE = 26,
    SPARC_INS_CALL = 27,
    SPARC_INS_CASX = 28,
    SPARC_INS_CAS = 29,
    SPARC_INS_CMASK16 = 30,
    SPARC_INS_CMASK32 = 31,
    SPARC_INS_CMASK8 = 32,
    SPARC_INS_CMP = 33,
    SPARC_INS_EDGE16 = 34,
    SPARC_INS_EDGE16L = 35,
    SPARC_INS_EDGE16LN = 36,
    SPARC_INS_EDGE16N = 37,
    SPARC_INS_EDGE32 = 38,
    SPARC_INS_EDGE32L = 39,
    SPARC_INS_EDGE32LN = 40,
    SPARC_INS_EDGE32N = 41,
    SPARC_INS_EDGE8 = 42,
    SPARC_INS_EDGE8L = 43,
    SPARC_INS_EDGE8LN = 44,
    SPARC_INS_EDGE8N = 45,
    SPARC_INS_FABSD = 46,
    SPARC_INS_FABSQ = 47,
    SPARC_INS_FABSS = 48,
    SPARC_INS_FADDD = 49,
    SPARC_INS_FADDQ = 50,
    SPARC_INS_FADDS = 51,
    SPARC_INS_FALIGNDATA = 52,
    SPARC_INS_FAND = 53,
    SPARC_INS_FANDNOT1 = 54,
    SPARC_INS_FANDNOT1S = 55,
    SPARC_INS_FANDNOT2 = 56,
    SPARC_INS_FANDNOT2S = 57,
    SPARC_INS_FANDS = 58,
    SPARC_INS_FCHKSM16 = 59,
    SPARC_INS_FCMPD = 60,
    SPARC_INS_FCMPEQ16 = 61,
    SPARC_INS_FCMPEQ32 = 62,
    SPARC_INS_FCMPGT16 = 63,
    SPARC_INS_FCMPGT32 = 64,
    SPARC_INS_FCMPLE16 = 65,
    SPARC_INS_FCMPLE32 = 66,
    SPARC_INS_FCMPNE16 = 67,
    SPARC_INS_FCMPNE32 = 68,
    SPARC_INS_FCMPQ = 69,
    SPARC_INS_FCMPS = 70,
    SPARC_INS_FDIVD = 71,
    SPARC_INS_FDIVQ = 72,
    SPARC_INS_FDIVS = 73,
    SPARC_INS_FDMULQ = 74,
    SPARC_INS_FDTOI = 75,
    SPARC_INS_FDTOQ = 76,
    SPARC_INS_FDTOS = 77,
    SPARC_INS_FDTOX = 78,
    SPARC_INS_FEXPAND = 79,
    SPARC_INS_FHADDD = 80,
    SPARC_INS_FHADDS = 81,
    SPARC_INS_FHSUBD = 82,
    SPARC_INS_FHSUBS = 83,
    SPARC_INS_FITOD = 84,
    SPARC_INS_FITOQ = 85,
    SPARC_INS_FITOS = 86,
    SPARC_INS_FLCMPD = 87,
    SPARC_INS_FLCMPS = 88,
    SPARC_INS_FLUSHW = 89,
    SPARC_INS_FMEAN16 = 90,
    SPARC_INS_FMOVD = 91,
    SPARC_INS_FMOVQ = 92,
    SPARC_INS_FMOVRDGEZ = 93,
    SPARC_INS_FMOVRQGEZ = 94,
    SPARC_INS_FMOVRSGEZ = 95,
    SPARC_INS_FMOVRDGZ = 96,
    SPARC_INS_FMOVRQGZ = 97,
    SPARC_INS_FMOVRSGZ = 98,
    SPARC_INS_FMOVRDLEZ = 99,
    SPARC_INS_FMOVRQLEZ = 100,
    SPARC_INS_FMOVRSLEZ = 101,
    SPARC_INS_FMOVRDLZ = 102,
    SPARC_INS_FMOVRQLZ = 103,
    SPARC_INS_FMOVRSLZ = 104,
    SPARC_INS_FMOVRDNZ = 105,
    SPARC_INS_FMOVRQNZ = 106,
    SPARC_INS_FMOVRSNZ = 107,
    SPARC_INS_FMOVRDZ = 108,
    SPARC_INS_FMOVRQZ = 109,
    SPARC_INS_FMOVRSZ = 110,
    SPARC_INS_FMOVS = 111,
    SPARC_INS_FMUL8SUX16 = 112,
    SPARC_INS_FMUL8ULX16 = 113,
    SPARC_INS_FMUL8X16 = 114,
    SPARC_INS_FMUL8X16AL = 115,
    SPARC_INS_FMUL8X16AU = 116,
    SPARC_INS_FMULD = 117,
    SPARC_INS_FMULD8SUX16 = 118,
    SPARC_INS_FMULD8ULX16 = 119,
    SPARC_INS_FMULQ = 120,
    SPARC_INS_FMULS = 121,
    SPARC_INS_FNADDD = 122,
    SPARC_INS_FNADDS = 123,
    SPARC_INS_FNAND = 124,
    SPARC_INS_FNANDS = 125,
    SPARC_INS_FNEGD = 126,
    SPARC_INS_FNEGQ = 127,
    SPARC_INS_FNEGS = 128,
    SPARC_INS_FNHADDD = 129,
    SPARC_INS_FNHADDS = 130,
    SPARC_INS_FNOR = 131,
    SPARC_INS_FNORS = 132,
    SPARC_INS_FNOT1 = 133,
    SPARC_INS_FNOT1S = 134,
    SPARC_INS_FNOT2 = 135,
    SPARC_INS_FNOT2S = 136,
    SPARC_INS_FONE = 137,
    SPARC_INS_FONES = 138,
    SPARC_INS_FOR = 139,
    SPARC_INS_FORNOT1 = 140,
    SPARC_INS_FORNOT1S = 141,
    SPARC_INS_FORNOT2 = 142,
    SPARC_INS_FORNOT2S = 143,
    SPARC_INS_FORS = 144,
    SPARC_INS_FPACK16 = 145,
    SPARC_INS_FPACK32 = 146,
    SPARC_INS_FPACKFIX = 147,
    SPARC_INS_FPADD16 = 148,
    SPARC_INS_FPADD16S = 149,
    SPARC_INS_FPADD32 = 150,
    SPARC_INS_FPADD32S = 151,
    SPARC_INS_FPADD64 = 152,
    SPARC_INS_FPMERGE = 153,
    SPARC_INS_FPSUB16 = 154,
    SPARC_INS_FPSUB16S = 155,
    SPARC_INS_FPSUB32 = 156,
    SPARC_INS_FPSUB32S = 157,
    SPARC_INS_FQTOD = 158,
    SPARC_INS_FQTOI = 159,
    SPARC_INS_FQTOS = 160,
    SPARC_INS_FQTOX = 161,
    SPARC_INS_FSLAS16 = 162,
    SPARC_INS_FSLAS32 = 163,
    SPARC_INS_FSLL16 = 164,
    SPARC_INS_FSLL32 = 165,
    SPARC_INS_FSMULD = 166,
    SPARC_INS_FSQRTD = 167,
    SPARC_INS_FSQRTQ = 168,
    SPARC_INS_FSQRTS = 169,
    SPARC_INS_FSRA16 = 170,
    SPARC_INS_FSRA32 = 171,
    SPARC_INS_FSRC1 = 172,
    SPARC_INS_FSRC1S = 173,
    SPARC_INS_FSRC2 = 174,
    SPARC_INS_FSRC2S = 175,
    SPARC_INS_FSRL16 = 176,
    SPARC_INS_FSRL32 = 177,
    SPARC_INS_FSTOD = 178,
    SPARC_INS_FSTOI = 179,
    SPARC_INS_FSTOQ = 180,
    SPARC_INS_FSTOX = 181,
    SPARC_INS_FSUBD = 182,
    SPARC_INS_FSUBQ = 183,
    SPARC_INS_FSUBS = 184,
    SPARC_INS_FXNOR = 185,
    SPARC_INS_FXNORS = 186,
    SPARC_INS_FXOR = 187,
    SPARC_INS_FXORS = 188,
    SPARC_INS_FXTOD = 189,
    SPARC_INS_FXTOQ = 190,
    SPARC_INS_FXTOS = 191,
    SPARC_INS_FZERO = 192,
    SPARC_INS_FZEROS = 193,
    SPARC_INS_JMPL = 194,
    SPARC_INS_LDD = 195,
    SPARC_INS_LD = 196,
    SPARC_INS_LDQ = 197,
    SPARC_INS_LDSB = 198,
    SPARC_INS_LDSH = 199,
    SPARC_INS_LDSW = 200,
    SPARC_INS_LDUB = 201,
    SPARC_INS_LDUH = 202,
    SPARC_INS_LDX = 203,
    SPARC_INS_LZCNT = 204,
    SPARC_INS_MEMBAR = 205,
    SPARC_INS_MOVDTOX = 206,
    SPARC_INS_MOV = 207,
    SPARC_INS_MOVRGEZ = 208,
    SPARC_INS_MOVRGZ = 209,
    SPARC_INS_MOVRLEZ = 210,
    SPARC_INS_MOVRLZ = 211,
    SPARC_INS_MOVRNZ = 212,
    SPARC_INS_MOVRZ = 213,
    SPARC_INS_MOVSTOSW = 214,
    SPARC_INS_MOVSTOUW = 215,
    SPARC_INS_MULX = 216,
    SPARC_INS_NOP = 217,
    SPARC_INS_ORCC = 218,
    SPARC_INS_ORNCC = 219,
    SPARC_INS_ORN = 220,
    SPARC_INS_OR = 221,
    SPARC_INS_PDIST = 222,
    SPARC_INS_PDISTN = 223,
    SPARC_INS_POPC = 224,
    SPARC_INS_RD = 225,
    SPARC_INS_RESTORE = 226,
    SPARC_INS_RETT = 227,
    SPARC_INS_SAVE = 228,
    SPARC_INS_SDIVCC = 229,
    SPARC_INS_SDIVX = 230,
    SPARC_INS_SDIV = 231,
    SPARC_INS_SETHI = 232,
    SPARC_INS_SHUTDOWN = 233,
    SPARC_INS_SIAM = 234,
    SPARC_INS_SLLX = 235,
    SPARC_INS_SLL = 236,
    SPARC_INS_SMULCC = 237,
    SPARC_INS_SMUL = 238,
    SPARC_INS_SRAX = 239,
    SPARC_INS_SRA = 240,
    SPARC_INS_SRLX = 241,
    SPARC_INS_SRL = 242,
    SPARC_INS_STBAR = 243,
    SPARC_INS_STB = 244,
    SPARC_INS_STD = 245,
    SPARC_INS_ST = 246,
    SPARC_INS_STH = 247,
    SPARC_INS_STQ = 248,
    SPARC_INS_STX = 249,
    SPARC_INS_SUBCC = 250,
    SPARC_INS_SUBX = 251,
    SPARC_INS_SUBXCC = 252,
    SPARC_INS_SUB = 253,
    SPARC_INS_SWAP = 254,
    SPARC_INS_TADDCCTV = 255,
    SPARC_INS_TADDCC = 256,
    SPARC_INS_T = 257,
    SPARC_INS_TSUBCCTV = 258,
    SPARC_INS_TSUBCC = 259,
    SPARC_INS_UDIVCC = 260,
    SPARC_INS_UDIVX = 261,
    SPARC_INS_UDIV = 262,
    SPARC_INS_UMULCC = 263,
    SPARC_INS_UMULXHI = 264,
    SPARC_INS_UMUL = 265,
    SPARC_INS_UNIMP = 266,
    SPARC_INS_FCMPED = 267,
    SPARC_INS_FCMPEQ = 268,
    SPARC_INS_FCMPES = 269,
    SPARC_INS_WR = 270,
    SPARC_INS_XMULX = 271,
    SPARC_INS_XMULXHI = 272,
    SPARC_INS_XNORCC = 273,
    SPARC_INS_XNOR = 274,
    SPARC_INS_XORCC = 275,
    SPARC_INS_XOR = 276,
    SPARC_INS_RET = 277,
    SPARC_INS_RETL = 278,
    SPARC_INS_ENDING = 279,
}
pub mod sparc_insn_group {
    #[doc = " Group of SPARC instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const SPARC_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const SPARC_GRP_JUMP: Type = 1;
    pub const SPARC_GRP_HARDQUAD: Type = 128;
    pub const SPARC_GRP_V9: Type = 129;
    pub const SPARC_GRP_VIS: Type = 130;
    pub const SPARC_GRP_VIS2: Type = 131;
    pub const SPARC_GRP_VIS3: Type = 132;
    pub const SPARC_GRP_32BIT: Type = 133;
    pub const SPARC_GRP_64BIT: Type = 134;
    pub const SPARC_GRP_ENDING: Type = 135;
}
#[repr(u32)]
#[doc = " Enums corresponding to SystemZ condition codes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sysz_cc {
    #[doc = "< invalid CC (default)"]
    SYSZ_CC_INVALID = 0,
    SYSZ_CC_O = 1,
    SYSZ_CC_H = 2,
    SYSZ_CC_NLE = 3,
    SYSZ_CC_L = 4,
    SYSZ_CC_NHE = 5,
    SYSZ_CC_LH = 6,
    SYSZ_CC_NE = 7,
    SYSZ_CC_E = 8,
    SYSZ_CC_NLH = 9,
    SYSZ_CC_HE = 10,
    SYSZ_CC_NL = 11,
    SYSZ_CC_LE = 12,
    SYSZ_CC_NH = 13,
    SYSZ_CC_NO = 14,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sysz_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    SYSZ_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    SYSZ_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    SYSZ_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    SYSZ_OP_MEM = 3,
    #[doc = "< Access register operand."]
    SYSZ_OP_ACREG = 64,
}
pub mod sysz_reg {
    #[doc = " SystemZ registers"]
    pub type Type = libc::c_uint;
    pub const SYSZ_REG_INVALID: Type = 0;
    pub const SYSZ_REG_0: Type = 1;
    pub const SYSZ_REG_1: Type = 2;
    pub const SYSZ_REG_2: Type = 3;
    pub const SYSZ_REG_3: Type = 4;
    pub const SYSZ_REG_4: Type = 5;
    pub const SYSZ_REG_5: Type = 6;
    pub const SYSZ_REG_6: Type = 7;
    pub const SYSZ_REG_7: Type = 8;
    pub const SYSZ_REG_8: Type = 9;
    pub const SYSZ_REG_9: Type = 10;
    pub const SYSZ_REG_10: Type = 11;
    pub const SYSZ_REG_11: Type = 12;
    pub const SYSZ_REG_12: Type = 13;
    pub const SYSZ_REG_13: Type = 14;
    pub const SYSZ_REG_14: Type = 15;
    pub const SYSZ_REG_15: Type = 16;
    pub const SYSZ_REG_CC: Type = 17;
    pub const SYSZ_REG_F0: Type = 18;
    pub const SYSZ_REG_F1: Type = 19;
    pub const SYSZ_REG_F2: Type = 20;
    pub const SYSZ_REG_F3: Type = 21;
    pub const SYSZ_REG_F4: Type = 22;
    pub const SYSZ_REG_F5: Type = 23;
    pub const SYSZ_REG_F6: Type = 24;
    pub const SYSZ_REG_F7: Type = 25;
    pub const SYSZ_REG_F8: Type = 26;
    pub const SYSZ_REG_F9: Type = 27;
    pub const SYSZ_REG_F10: Type = 28;
    pub const SYSZ_REG_F11: Type = 29;
    pub const SYSZ_REG_F12: Type = 30;
    pub const SYSZ_REG_F13: Type = 31;
    pub const SYSZ_REG_F14: Type = 32;
    pub const SYSZ_REG_F15: Type = 33;
    pub const SYSZ_REG_R0L: Type = 34;
    pub const SYSZ_REG_A0: Type = 35;
    pub const SYSZ_REG_A1: Type = 36;
    pub const SYSZ_REG_A2: Type = 37;
    pub const SYSZ_REG_A3: Type = 38;
    pub const SYSZ_REG_A4: Type = 39;
    pub const SYSZ_REG_A5: Type = 40;
    pub const SYSZ_REG_A6: Type = 41;
    pub const SYSZ_REG_A7: Type = 42;
    pub const SYSZ_REG_A8: Type = 43;
    pub const SYSZ_REG_A9: Type = 44;
    pub const SYSZ_REG_A10: Type = 45;
    pub const SYSZ_REG_A11: Type = 46;
    pub const SYSZ_REG_A12: Type = 47;
    pub const SYSZ_REG_A13: Type = 48;
    pub const SYSZ_REG_A14: Type = 49;
    pub const SYSZ_REG_A15: Type = 50;
    pub const SYSZ_REG_C0: Type = 51;
    pub const SYSZ_REG_C1: Type = 52;
    pub const SYSZ_REG_C2: Type = 53;
    pub const SYSZ_REG_C3: Type = 54;
    pub const SYSZ_REG_C4: Type = 55;
    pub const SYSZ_REG_C5: Type = 56;
    pub const SYSZ_REG_C6: Type = 57;
    pub const SYSZ_REG_C7: Type = 58;
    pub const SYSZ_REG_C8: Type = 59;
    pub const SYSZ_REG_C9: Type = 60;
    pub const SYSZ_REG_C10: Type = 61;
    pub const SYSZ_REG_C11: Type = 62;
    pub const SYSZ_REG_C12: Type = 63;
    pub const SYSZ_REG_C13: Type = 64;
    pub const SYSZ_REG_C14: Type = 65;
    pub const SYSZ_REG_C15: Type = 66;
    pub const SYSZ_REG_V0: Type = 67;
    pub const SYSZ_REG_V1: Type = 68;
    pub const SYSZ_REG_V2: Type = 69;
    pub const SYSZ_REG_V3: Type = 70;
    pub const SYSZ_REG_V4: Type = 71;
    pub const SYSZ_REG_V5: Type = 72;
    pub const SYSZ_REG_V6: Type = 73;
    pub const SYSZ_REG_V7: Type = 74;
    pub const SYSZ_REG_V8: Type = 75;
    pub const SYSZ_REG_V9: Type = 76;
    pub const SYSZ_REG_V10: Type = 77;
    pub const SYSZ_REG_V11: Type = 78;
    pub const SYSZ_REG_V12: Type = 79;
    pub const SYSZ_REG_V13: Type = 80;
    pub const SYSZ_REG_V14: Type = 81;
    pub const SYSZ_REG_V15: Type = 82;
    pub const SYSZ_REG_V16: Type = 83;
    pub const SYSZ_REG_V17: Type = 84;
    pub const SYSZ_REG_V18: Type = 85;
    pub const SYSZ_REG_V19: Type = 86;
    pub const SYSZ_REG_V20: Type = 87;
    pub const SYSZ_REG_V21: Type = 88;
    pub const SYSZ_REG_V22: Type = 89;
    pub const SYSZ_REG_V23: Type = 90;
    pub const SYSZ_REG_V24: Type = 91;
    pub const SYSZ_REG_V25: Type = 92;
    pub const SYSZ_REG_V26: Type = 93;
    pub const SYSZ_REG_V27: Type = 94;
    pub const SYSZ_REG_V28: Type = 95;
    pub const SYSZ_REG_V29: Type = 96;
    pub const SYSZ_REG_V30: Type = 97;
    pub const SYSZ_REG_V31: Type = 98;
    pub const SYSZ_REG_F16: Type = 99;
    pub const SYSZ_REG_F17: Type = 100;
    pub const SYSZ_REG_F18: Type = 101;
    pub const SYSZ_REG_F19: Type = 102;
    pub const SYSZ_REG_F20: Type = 103;
    pub const SYSZ_REG_F21: Type = 104;
    pub const SYSZ_REG_F22: Type = 105;
    pub const SYSZ_REG_F23: Type = 106;
    pub const SYSZ_REG_F24: Type = 107;
    pub const SYSZ_REG_F25: Type = 108;
    pub const SYSZ_REG_F26: Type = 109;
    pub const SYSZ_REG_F27: Type = 110;
    pub const SYSZ_REG_F28: Type = 111;
    pub const SYSZ_REG_F29: Type = 112;
    pub const SYSZ_REG_F30: Type = 113;
    pub const SYSZ_REG_F31: Type = 114;
    pub const SYSZ_REG_F0Q: Type = 115;
    pub const SYSZ_REG_F4Q: Type = 116;
    pub const SYSZ_REG_ENDING: Type = 117;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with SYSZ_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct sysz_op_mem {
    #[doc = "< base register, can be safely interpreted as"]
    #[doc = "< a value of type `sysz_reg`, but it is only"]
    #[doc = "< one byte wide"]
    pub base: u8,
    #[doc = "< index register, same conditions apply here"]
    pub index: u8,
    #[doc = "< BDLAddr operand"]
    pub length: u64,
    #[doc = "< displacement/offset value"]
    pub disp: i64,
}
impl Clone for sysz_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_sysz_op {
    #[doc = "< operand type"]
    pub type_: sysz_op_type,
    pub __bindgen_anon_1: cs_sysz_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_sysz_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: sysz_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: sysz_op_mem,
}
impl Clone for cs_sysz_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sysz_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_sysz_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_sysz_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sysz_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sysz_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_sysz {
    #[doc = "< Code condition"]
    pub cc: sysz_cc,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_sysz_op; 6usize],
}
impl Clone for cs_sysz {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_sysz {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_sysz {{ cc: {:?}, op_count: {:?}, operands: {:?} }}",
            self.cc, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " SystemZ instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum sysz_insn {
    SYSZ_INS_INVALID = 0,
    SYSZ_INS_A = 1,
    SYSZ_INS_ADB = 2,
    SYSZ_INS_ADBR = 3,
    SYSZ_INS_AEB = 4,
    SYSZ_INS_AEBR = 5,
    SYSZ_INS_AFI = 6,
    SYSZ_INS_AG = 7,
    SYSZ_INS_AGF = 8,
    SYSZ_INS_AGFI = 9,
    SYSZ_INS_AGFR = 10,
    SYSZ_INS_AGHI = 11,
    SYSZ_INS_AGHIK = 12,
    SYSZ_INS_AGR = 13,
    SYSZ_INS_AGRK = 14,
    SYSZ_INS_AGSI = 15,
    SYSZ_INS_AH = 16,
    SYSZ_INS_AHI = 17,
    SYSZ_INS_AHIK = 18,
    SYSZ_INS_AHY = 19,
    SYSZ_INS_AIH = 20,
    SYSZ_INS_AL = 21,
    SYSZ_INS_ALC = 22,
    SYSZ_INS_ALCG = 23,
    SYSZ_INS_ALCGR = 24,
    SYSZ_INS_ALCR = 25,
    SYSZ_INS_ALFI = 26,
    SYSZ_INS_ALG = 27,
    SYSZ_INS_ALGF = 28,
    SYSZ_INS_ALGFI = 29,
    SYSZ_INS_ALGFR = 30,
    SYSZ_INS_ALGHSIK = 31,
    SYSZ_INS_ALGR = 32,
    SYSZ_INS_ALGRK = 33,
    SYSZ_INS_ALHSIK = 34,
    SYSZ_INS_ALR = 35,
    SYSZ_INS_ALRK = 36,
    SYSZ_INS_ALY = 37,
    SYSZ_INS_AR = 38,
    SYSZ_INS_ARK = 39,
    SYSZ_INS_ASI = 40,
    SYSZ_INS_AXBR = 41,
    SYSZ_INS_AY = 42,
    SYSZ_INS_BCR = 43,
    SYSZ_INS_BRC = 44,
    SYSZ_INS_BRCL = 45,
    SYSZ_INS_CGIJ = 46,
    SYSZ_INS_CGRJ = 47,
    SYSZ_INS_CIJ = 48,
    SYSZ_INS_CLGIJ = 49,
    SYSZ_INS_CLGRJ = 50,
    SYSZ_INS_CLIJ = 51,
    SYSZ_INS_CLRJ = 52,
    SYSZ_INS_CRJ = 53,
    SYSZ_INS_BER = 54,
    SYSZ_INS_JE = 55,
    SYSZ_INS_JGE = 56,
    SYSZ_INS_LOCE = 57,
    SYSZ_INS_LOCGE = 58,
    SYSZ_INS_LOCGRE = 59,
    SYSZ_INS_LOCRE = 60,
    SYSZ_INS_STOCE = 61,
    SYSZ_INS_STOCGE = 62,
    SYSZ_INS_BHR = 63,
    SYSZ_INS_BHER = 64,
    SYSZ_INS_JHE = 65,
    SYSZ_INS_JGHE = 66,
    SYSZ_INS_LOCHE = 67,
    SYSZ_INS_LOCGHE = 68,
    SYSZ_INS_LOCGRHE = 69,
    SYSZ_INS_LOCRHE = 70,
    SYSZ_INS_STOCHE = 71,
    SYSZ_INS_STOCGHE = 72,
    SYSZ_INS_JH = 73,
    SYSZ_INS_JGH = 74,
    SYSZ_INS_LOCH = 75,
    SYSZ_INS_LOCGH = 76,
    SYSZ_INS_LOCGRH = 77,
    SYSZ_INS_LOCRH = 78,
    SYSZ_INS_STOCH = 79,
    SYSZ_INS_STOCGH = 80,
    SYSZ_INS_CGIJNLH = 81,
    SYSZ_INS_CGRJNLH = 82,
    SYSZ_INS_CIJNLH = 83,
    SYSZ_INS_CLGIJNLH = 84,
    SYSZ_INS_CLGRJNLH = 85,
    SYSZ_INS_CLIJNLH = 86,
    SYSZ_INS_CLRJNLH = 87,
    SYSZ_INS_CRJNLH = 88,
    SYSZ_INS_CGIJE = 89,
    SYSZ_INS_CGRJE = 90,
    SYSZ_INS_CIJE = 91,
    SYSZ_INS_CLGIJE = 92,
    SYSZ_INS_CLGRJE = 93,
    SYSZ_INS_CLIJE = 94,
    SYSZ_INS_CLRJE = 95,
    SYSZ_INS_CRJE = 96,
    SYSZ_INS_CGIJNLE = 97,
    SYSZ_INS_CGRJNLE = 98,
    SYSZ_INS_CIJNLE = 99,
    SYSZ_INS_CLGIJNLE = 100,
    SYSZ_INS_CLGRJNLE = 101,
    SYSZ_INS_CLIJNLE = 102,
    SYSZ_INS_CLRJNLE = 103,
    SYSZ_INS_CRJNLE = 104,
    SYSZ_INS_CGIJH = 105,
    SYSZ_INS_CGRJH = 106,
    SYSZ_INS_CIJH = 107,
    SYSZ_INS_CLGIJH = 108,
    SYSZ_INS_CLGRJH = 109,
    SYSZ_INS_CLIJH = 110,
    SYSZ_INS_CLRJH = 111,
    SYSZ_INS_CRJH = 112,
    SYSZ_INS_CGIJNL = 113,
    SYSZ_INS_CGRJNL = 114,
    SYSZ_INS_CIJNL = 115,
    SYSZ_INS_CLGIJNL = 116,
    SYSZ_INS_CLGRJNL = 117,
    SYSZ_INS_CLIJNL = 118,
    SYSZ_INS_CLRJNL = 119,
    SYSZ_INS_CRJNL = 120,
    SYSZ_INS_CGIJHE = 121,
    SYSZ_INS_CGRJHE = 122,
    SYSZ_INS_CIJHE = 123,
    SYSZ_INS_CLGIJHE = 124,
    SYSZ_INS_CLGRJHE = 125,
    SYSZ_INS_CLIJHE = 126,
    SYSZ_INS_CLRJHE = 127,
    SYSZ_INS_CRJHE = 128,
    SYSZ_INS_CGIJNHE = 129,
    SYSZ_INS_CGRJNHE = 130,
    SYSZ_INS_CIJNHE = 131,
    SYSZ_INS_CLGIJNHE = 132,
    SYSZ_INS_CLGRJNHE = 133,
    SYSZ_INS_CLIJNHE = 134,
    SYSZ_INS_CLRJNHE = 135,
    SYSZ_INS_CRJNHE = 136,
    SYSZ_INS_CGIJL = 137,
    SYSZ_INS_CGRJL = 138,
    SYSZ_INS_CIJL = 139,
    SYSZ_INS_CLGIJL = 140,
    SYSZ_INS_CLGRJL = 141,
    SYSZ_INS_CLIJL = 142,
    SYSZ_INS_CLRJL = 143,
    SYSZ_INS_CRJL = 144,
    SYSZ_INS_CGIJNH = 145,
    SYSZ_INS_CGRJNH = 146,
    SYSZ_INS_CIJNH = 147,
    SYSZ_INS_CLGIJNH = 148,
    SYSZ_INS_CLGRJNH = 149,
    SYSZ_INS_CLIJNH = 150,
    SYSZ_INS_CLRJNH = 151,
    SYSZ_INS_CRJNH = 152,
    SYSZ_INS_CGIJLE = 153,
    SYSZ_INS_CGRJLE = 154,
    SYSZ_INS_CIJLE = 155,
    SYSZ_INS_CLGIJLE = 156,
    SYSZ_INS_CLGRJLE = 157,
    SYSZ_INS_CLIJLE = 158,
    SYSZ_INS_CLRJLE = 159,
    SYSZ_INS_CRJLE = 160,
    SYSZ_INS_CGIJNE = 161,
    SYSZ_INS_CGRJNE = 162,
    SYSZ_INS_CIJNE = 163,
    SYSZ_INS_CLGIJNE = 164,
    SYSZ_INS_CLGRJNE = 165,
    SYSZ_INS_CLIJNE = 166,
    SYSZ_INS_CLRJNE = 167,
    SYSZ_INS_CRJNE = 168,
    SYSZ_INS_CGIJLH = 169,
    SYSZ_INS_CGRJLH = 170,
    SYSZ_INS_CIJLH = 171,
    SYSZ_INS_CLGIJLH = 172,
    SYSZ_INS_CLGRJLH = 173,
    SYSZ_INS_CLIJLH = 174,
    SYSZ_INS_CLRJLH = 175,
    SYSZ_INS_CRJLH = 176,
    SYSZ_INS_BLR = 177,
    SYSZ_INS_BLER = 178,
    SYSZ_INS_JLE = 179,
    SYSZ_INS_JGLE = 180,
    SYSZ_INS_LOCLE = 181,
    SYSZ_INS_LOCGLE = 182,
    SYSZ_INS_LOCGRLE = 183,
    SYSZ_INS_LOCRLE = 184,
    SYSZ_INS_STOCLE = 185,
    SYSZ_INS_STOCGLE = 186,
    SYSZ_INS_BLHR = 187,
    SYSZ_INS_JLH = 188,
    SYSZ_INS_JGLH = 189,
    SYSZ_INS_LOCLH = 190,
    SYSZ_INS_LOCGLH = 191,
    SYSZ_INS_LOCGRLH = 192,
    SYSZ_INS_LOCRLH = 193,
    SYSZ_INS_STOCLH = 194,
    SYSZ_INS_STOCGLH = 195,
    SYSZ_INS_JL = 196,
    SYSZ_INS_JGL = 197,
    SYSZ_INS_LOCL = 198,
    SYSZ_INS_LOCGL = 199,
    SYSZ_INS_LOCGRL = 200,
    SYSZ_INS_LOCRL = 201,
    SYSZ_INS_LOC = 202,
    SYSZ_INS_LOCG = 203,
    SYSZ_INS_LOCGR = 204,
    SYSZ_INS_LOCR = 205,
    SYSZ_INS_STOCL = 206,
    SYSZ_INS_STOCGL = 207,
    SYSZ_INS_BNER = 208,
    SYSZ_INS_JNE = 209,
    SYSZ_INS_JGNE = 210,
    SYSZ_INS_LOCNE = 211,
    SYSZ_INS_LOCGNE = 212,
    SYSZ_INS_LOCGRNE = 213,
    SYSZ_INS_LOCRNE = 214,
    SYSZ_INS_STOCNE = 215,
    SYSZ_INS_STOCGNE = 216,
    SYSZ_INS_BNHR = 217,
    SYSZ_INS_BNHER = 218,
    SYSZ_INS_JNHE = 219,
    SYSZ_INS_JGNHE = 220,
    SYSZ_INS_LOCNHE = 221,
    SYSZ_INS_LOCGNHE = 222,
    SYSZ_INS_LOCGRNHE = 223,
    SYSZ_INS_LOCRNHE = 224,
    SYSZ_INS_STOCNHE = 225,
    SYSZ_INS_STOCGNHE = 226,
    SYSZ_INS_JNH = 227,
    SYSZ_INS_JGNH = 228,
    SYSZ_INS_LOCNH = 229,
    SYSZ_INS_LOCGNH = 230,
    SYSZ_INS_LOCGRNH = 231,
    SYSZ_INS_LOCRNH = 232,
    SYSZ_INS_STOCNH = 233,
    SYSZ_INS_STOCGNH = 234,
    SYSZ_INS_BNLR = 235,
    SYSZ_INS_BNLER = 236,
    SYSZ_INS_JNLE = 237,
    SYSZ_INS_JGNLE = 238,
    SYSZ_INS_LOCNLE = 239,
    SYSZ_INS_LOCGNLE = 240,
    SYSZ_INS_LOCGRNLE = 241,
    SYSZ_INS_LOCRNLE = 242,
    SYSZ_INS_STOCNLE = 243,
    SYSZ_INS_STOCGNLE = 244,
    SYSZ_INS_BNLHR = 245,
    SYSZ_INS_JNLH = 246,
    SYSZ_INS_JGNLH = 247,
    SYSZ_INS_LOCNLH = 248,
    SYSZ_INS_LOCGNLH = 249,
    SYSZ_INS_LOCGRNLH = 250,
    SYSZ_INS_LOCRNLH = 251,
    SYSZ_INS_STOCNLH = 252,
    SYSZ_INS_STOCGNLH = 253,
    SYSZ_INS_JNL = 254,
    SYSZ_INS_JGNL = 255,
    SYSZ_INS_LOCNL = 256,
    SYSZ_INS_LOCGNL = 257,
    SYSZ_INS_LOCGRNL = 258,
    SYSZ_INS_LOCRNL = 259,
    SYSZ_INS_STOCNL = 260,
    SYSZ_INS_STOCGNL = 261,
    SYSZ_INS_BNOR = 262,
    SYSZ_INS_JNO = 263,
    SYSZ_INS_JGNO = 264,
    SYSZ_INS_LOCNO = 265,
    SYSZ_INS_LOCGNO = 266,
    SYSZ_INS_LOCGRNO = 267,
    SYSZ_INS_LOCRNO = 268,
    SYSZ_INS_STOCNO = 269,
    SYSZ_INS_STOCGNO = 270,
    SYSZ_INS_BOR = 271,
    SYSZ_INS_JO = 272,
    SYSZ_INS_JGO = 273,
    SYSZ_INS_LOCO = 274,
    SYSZ_INS_LOCGO = 275,
    SYSZ_INS_LOCGRO = 276,
    SYSZ_INS_LOCRO = 277,
    SYSZ_INS_STOCO = 278,
    SYSZ_INS_STOCGO = 279,
    SYSZ_INS_STOC = 280,
    SYSZ_INS_STOCG = 281,
    SYSZ_INS_BASR = 282,
    SYSZ_INS_BR = 283,
    SYSZ_INS_BRAS = 284,
    SYSZ_INS_BRASL = 285,
    SYSZ_INS_J = 286,
    SYSZ_INS_JG = 287,
    SYSZ_INS_BRCT = 288,
    SYSZ_INS_BRCTG = 289,
    SYSZ_INS_C = 290,
    SYSZ_INS_CDB = 291,
    SYSZ_INS_CDBR = 292,
    SYSZ_INS_CDFBR = 293,
    SYSZ_INS_CDGBR = 294,
    SYSZ_INS_CDLFBR = 295,
    SYSZ_INS_CDLGBR = 296,
    SYSZ_INS_CEB = 297,
    SYSZ_INS_CEBR = 298,
    SYSZ_INS_CEFBR = 299,
    SYSZ_INS_CEGBR = 300,
    SYSZ_INS_CELFBR = 301,
    SYSZ_INS_CELGBR = 302,
    SYSZ_INS_CFDBR = 303,
    SYSZ_INS_CFEBR = 304,
    SYSZ_INS_CFI = 305,
    SYSZ_INS_CFXBR = 306,
    SYSZ_INS_CG = 307,
    SYSZ_INS_CGDBR = 308,
    SYSZ_INS_CGEBR = 309,
    SYSZ_INS_CGF = 310,
    SYSZ_INS_CGFI = 311,
    SYSZ_INS_CGFR = 312,
    SYSZ_INS_CGFRL = 313,
    SYSZ_INS_CGH = 314,
    SYSZ_INS_CGHI = 315,
    SYSZ_INS_CGHRL = 316,
    SYSZ_INS_CGHSI = 317,
    SYSZ_INS_CGR = 318,
    SYSZ_INS_CGRL = 319,
    SYSZ_INS_CGXBR = 320,
    SYSZ_INS_CH = 321,
    SYSZ_INS_CHF = 322,
    SYSZ_INS_CHHSI = 323,
    SYSZ_INS_CHI = 324,
    SYSZ_INS_CHRL = 325,
    SYSZ_INS_CHSI = 326,
    SYSZ_INS_CHY = 327,
    SYSZ_INS_CIH = 328,
    SYSZ_INS_CL = 329,
    SYSZ_INS_CLC = 330,
    SYSZ_INS_CLFDBR = 331,
    SYSZ_INS_CLFEBR = 332,
    SYSZ_INS_CLFHSI = 333,
    SYSZ_INS_CLFI = 334,
    SYSZ_INS_CLFXBR = 335,
    SYSZ_INS_CLG = 336,
    SYSZ_INS_CLGDBR = 337,
    SYSZ_INS_CLGEBR = 338,
    SYSZ_INS_CLGF = 339,
    SYSZ_INS_CLGFI = 340,
    SYSZ_INS_CLGFR = 341,
    SYSZ_INS_CLGFRL = 342,
    SYSZ_INS_CLGHRL = 343,
    SYSZ_INS_CLGHSI = 344,
    SYSZ_INS_CLGR = 345,
    SYSZ_INS_CLGRL = 346,
    SYSZ_INS_CLGXBR = 347,
    SYSZ_INS_CLHF = 348,
    SYSZ_INS_CLHHSI = 349,
    SYSZ_INS_CLHRL = 350,
    SYSZ_INS_CLI = 351,
    SYSZ_INS_CLIH = 352,
    SYSZ_INS_CLIY = 353,
    SYSZ_INS_CLR = 354,
    SYSZ_INS_CLRL = 355,
    SYSZ_INS_CLST = 356,
    SYSZ_INS_CLY = 357,
    SYSZ_INS_CPSDR = 358,
    SYSZ_INS_CR = 359,
    SYSZ_INS_CRL = 360,
    SYSZ_INS_CS = 361,
    SYSZ_INS_CSG = 362,
    SYSZ_INS_CSY = 363,
    SYSZ_INS_CXBR = 364,
    SYSZ_INS_CXFBR = 365,
    SYSZ_INS_CXGBR = 366,
    SYSZ_INS_CXLFBR = 367,
    SYSZ_INS_CXLGBR = 368,
    SYSZ_INS_CY = 369,
    SYSZ_INS_DDB = 370,
    SYSZ_INS_DDBR = 371,
    SYSZ_INS_DEB = 372,
    SYSZ_INS_DEBR = 373,
    SYSZ_INS_DL = 374,
    SYSZ_INS_DLG = 375,
    SYSZ_INS_DLGR = 376,
    SYSZ_INS_DLR = 377,
    SYSZ_INS_DSG = 378,
    SYSZ_INS_DSGF = 379,
    SYSZ_INS_DSGFR = 380,
    SYSZ_INS_DSGR = 381,
    SYSZ_INS_DXBR = 382,
    SYSZ_INS_EAR = 383,
    SYSZ_INS_FIDBR = 384,
    SYSZ_INS_FIDBRA = 385,
    SYSZ_INS_FIEBR = 386,
    SYSZ_INS_FIEBRA = 387,
    SYSZ_INS_FIXBR = 388,
    SYSZ_INS_FIXBRA = 389,
    SYSZ_INS_FLOGR = 390,
    SYSZ_INS_IC = 391,
    SYSZ_INS_ICY = 392,
    SYSZ_INS_IIHF = 393,
    SYSZ_INS_IIHH = 394,
    SYSZ_INS_IIHL = 395,
    SYSZ_INS_IILF = 396,
    SYSZ_INS_IILH = 397,
    SYSZ_INS_IILL = 398,
    SYSZ_INS_IPM = 399,
    SYSZ_INS_L = 400,
    SYSZ_INS_LA = 401,
    SYSZ_INS_LAA = 402,
    SYSZ_INS_LAAG = 403,
    SYSZ_INS_LAAL = 404,
    SYSZ_INS_LAALG = 405,
    SYSZ_INS_LAN = 406,
    SYSZ_INS_LANG = 407,
    SYSZ_INS_LAO = 408,
    SYSZ_INS_LAOG = 409,
    SYSZ_INS_LARL = 410,
    SYSZ_INS_LAX = 411,
    SYSZ_INS_LAXG = 412,
    SYSZ_INS_LAY = 413,
    SYSZ_INS_LB = 414,
    SYSZ_INS_LBH = 415,
    SYSZ_INS_LBR = 416,
    SYSZ_INS_LCDBR = 417,
    SYSZ_INS_LCEBR = 418,
    SYSZ_INS_LCGFR = 419,
    SYSZ_INS_LCGR = 420,
    SYSZ_INS_LCR = 421,
    SYSZ_INS_LCXBR = 422,
    SYSZ_INS_LD = 423,
    SYSZ_INS_LDEB = 424,
    SYSZ_INS_LDEBR = 425,
    SYSZ_INS_LDGR = 426,
    SYSZ_INS_LDR = 427,
    SYSZ_INS_LDXBR = 428,
    SYSZ_INS_LDXBRA = 429,
    SYSZ_INS_LDY = 430,
    SYSZ_INS_LE = 431,
    SYSZ_INS_LEDBR = 432,
    SYSZ_INS_LEDBRA = 433,
    SYSZ_INS_LER = 434,
    SYSZ_INS_LEXBR = 435,
    SYSZ_INS_LEXBRA = 436,
    SYSZ_INS_LEY = 437,
    SYSZ_INS_LFH = 438,
    SYSZ_INS_LG = 439,
    SYSZ_INS_LGB = 440,
    SYSZ_INS_LGBR = 441,
    SYSZ_INS_LGDR = 442,
    SYSZ_INS_LGF = 443,
    SYSZ_INS_LGFI = 444,
    SYSZ_INS_LGFR = 445,
    SYSZ_INS_LGFRL = 446,
    SYSZ_INS_LGH = 447,
    SYSZ_INS_LGHI = 448,
    SYSZ_INS_LGHR = 449,
    SYSZ_INS_LGHRL = 450,
    SYSZ_INS_LGR = 451,
    SYSZ_INS_LGRL = 452,
    SYSZ_INS_LH = 453,
    SYSZ_INS_LHH = 454,
    SYSZ_INS_LHI = 455,
    SYSZ_INS_LHR = 456,
    SYSZ_INS_LHRL = 457,
    SYSZ_INS_LHY = 458,
    SYSZ_INS_LLC = 459,
    SYSZ_INS_LLCH = 460,
    SYSZ_INS_LLCR = 461,
    SYSZ_INS_LLGC = 462,
    SYSZ_INS_LLGCR = 463,
    SYSZ_INS_LLGF = 464,
    SYSZ_INS_LLGFR = 465,
    SYSZ_INS_LLGFRL = 466,
    SYSZ_INS_LLGH = 467,
    SYSZ_INS_LLGHR = 468,
    SYSZ_INS_LLGHRL = 469,
    SYSZ_INS_LLH = 470,
    SYSZ_INS_LLHH = 471,
    SYSZ_INS_LLHR = 472,
    SYSZ_INS_LLHRL = 473,
    SYSZ_INS_LLIHF = 474,
    SYSZ_INS_LLIHH = 475,
    SYSZ_INS_LLIHL = 476,
    SYSZ_INS_LLILF = 477,
    SYSZ_INS_LLILH = 478,
    SYSZ_INS_LLILL = 479,
    SYSZ_INS_LMG = 480,
    SYSZ_INS_LNDBR = 481,
    SYSZ_INS_LNEBR = 482,
    SYSZ_INS_LNGFR = 483,
    SYSZ_INS_LNGR = 484,
    SYSZ_INS_LNR = 485,
    SYSZ_INS_LNXBR = 486,
    SYSZ_INS_LPDBR = 487,
    SYSZ_INS_LPEBR = 488,
    SYSZ_INS_LPGFR = 489,
    SYSZ_INS_LPGR = 490,
    SYSZ_INS_LPR = 491,
    SYSZ_INS_LPXBR = 492,
    SYSZ_INS_LR = 493,
    SYSZ_INS_LRL = 494,
    SYSZ_INS_LRV = 495,
    SYSZ_INS_LRVG = 496,
    SYSZ_INS_LRVGR = 497,
    SYSZ_INS_LRVR = 498,
    SYSZ_INS_LT = 499,
    SYSZ_INS_LTDBR = 500,
    SYSZ_INS_LTEBR = 501,
    SYSZ_INS_LTG = 502,
    SYSZ_INS_LTGF = 503,
    SYSZ_INS_LTGFR = 504,
    SYSZ_INS_LTGR = 505,
    SYSZ_INS_LTR = 506,
    SYSZ_INS_LTXBR = 507,
    SYSZ_INS_LXDB = 508,
    SYSZ_INS_LXDBR = 509,
    SYSZ_INS_LXEB = 510,
    SYSZ_INS_LXEBR = 511,
    SYSZ_INS_LXR = 512,
    SYSZ_INS_LY = 513,
    SYSZ_INS_LZDR = 514,
    SYSZ_INS_LZER = 515,
    SYSZ_INS_LZXR = 516,
    SYSZ_INS_MADB = 517,
    SYSZ_INS_MADBR = 518,
    SYSZ_INS_MAEB = 519,
    SYSZ_INS_MAEBR = 520,
    SYSZ_INS_MDB = 521,
    SYSZ_INS_MDBR = 522,
    SYSZ_INS_MDEB = 523,
    SYSZ_INS_MDEBR = 524,
    SYSZ_INS_MEEB = 525,
    SYSZ_INS_MEEBR = 526,
    SYSZ_INS_MGHI = 527,
    SYSZ_INS_MH = 528,
    SYSZ_INS_MHI = 529,
    SYSZ_INS_MHY = 530,
    SYSZ_INS_MLG = 531,
    SYSZ_INS_MLGR = 532,
    SYSZ_INS_MS = 533,
    SYSZ_INS_MSDB = 534,
    SYSZ_INS_MSDBR = 535,
    SYSZ_INS_MSEB = 536,
    SYSZ_INS_MSEBR = 537,
    SYSZ_INS_MSFI = 538,
    SYSZ_INS_MSG = 539,
    SYSZ_INS_MSGF = 540,
    SYSZ_INS_MSGFI = 541,
    SYSZ_INS_MSGFR = 542,
    SYSZ_INS_MSGR = 543,
    SYSZ_INS_MSR = 544,
    SYSZ_INS_MSY = 545,
    SYSZ_INS_MVC = 546,
    SYSZ_INS_MVGHI = 547,
    SYSZ_INS_MVHHI = 548,
    SYSZ_INS_MVHI = 549,
    SYSZ_INS_MVI = 550,
    SYSZ_INS_MVIY = 551,
    SYSZ_INS_MVST = 552,
    SYSZ_INS_MXBR = 553,
    SYSZ_INS_MXDB = 554,
    SYSZ_INS_MXDBR = 555,
    SYSZ_INS_N = 556,
    SYSZ_INS_NC = 557,
    SYSZ_INS_NG = 558,
    SYSZ_INS_NGR = 559,
    SYSZ_INS_NGRK = 560,
    SYSZ_INS_NI = 561,
    SYSZ_INS_NIHF = 562,
    SYSZ_INS_NIHH = 563,
    SYSZ_INS_NIHL = 564,
    SYSZ_INS_NILF = 565,
    SYSZ_INS_NILH = 566,
    SYSZ_INS_NILL = 567,
    SYSZ_INS_NIY = 568,
    SYSZ_INS_NR = 569,
    SYSZ_INS_NRK = 570,
    SYSZ_INS_NY = 571,
    SYSZ_INS_O = 572,
    SYSZ_INS_OC = 573,
    SYSZ_INS_OG = 574,
    SYSZ_INS_OGR = 575,
    SYSZ_INS_OGRK = 576,
    SYSZ_INS_OI = 577,
    SYSZ_INS_OIHF = 578,
    SYSZ_INS_OIHH = 579,
    SYSZ_INS_OIHL = 580,
    SYSZ_INS_OILF = 581,
    SYSZ_INS_OILH = 582,
    SYSZ_INS_OILL = 583,
    SYSZ_INS_OIY = 584,
    SYSZ_INS_OR = 585,
    SYSZ_INS_ORK = 586,
    SYSZ_INS_OY = 587,
    SYSZ_INS_PFD = 588,
    SYSZ_INS_PFDRL = 589,
    SYSZ_INS_RISBG = 590,
    SYSZ_INS_RISBHG = 591,
    SYSZ_INS_RISBLG = 592,
    SYSZ_INS_RLL = 593,
    SYSZ_INS_RLLG = 594,
    SYSZ_INS_RNSBG = 595,
    SYSZ_INS_ROSBG = 596,
    SYSZ_INS_RXSBG = 597,
    SYSZ_INS_S = 598,
    SYSZ_INS_SDB = 599,
    SYSZ_INS_SDBR = 600,
    SYSZ_INS_SEB = 601,
    SYSZ_INS_SEBR = 602,
    SYSZ_INS_SG = 603,
    SYSZ_INS_SGF = 604,
    SYSZ_INS_SGFR = 605,
    SYSZ_INS_SGR = 606,
    SYSZ_INS_SGRK = 607,
    SYSZ_INS_SH = 608,
    SYSZ_INS_SHY = 609,
    SYSZ_INS_SL = 610,
    SYSZ_INS_SLB = 611,
    SYSZ_INS_SLBG = 612,
    SYSZ_INS_SLBR = 613,
    SYSZ_INS_SLFI = 614,
    SYSZ_INS_SLG = 615,
    SYSZ_INS_SLBGR = 616,
    SYSZ_INS_SLGF = 617,
    SYSZ_INS_SLGFI = 618,
    SYSZ_INS_SLGFR = 619,
    SYSZ_INS_SLGR = 620,
    SYSZ_INS_SLGRK = 621,
    SYSZ_INS_SLL = 622,
    SYSZ_INS_SLLG = 623,
    SYSZ_INS_SLLK = 624,
    SYSZ_INS_SLR = 625,
    SYSZ_INS_SLRK = 626,
    SYSZ_INS_SLY = 627,
    SYSZ_INS_SQDB = 628,
    SYSZ_INS_SQDBR = 629,
    SYSZ_INS_SQEB = 630,
    SYSZ_INS_SQEBR = 631,
    SYSZ_INS_SQXBR = 632,
    SYSZ_INS_SR = 633,
    SYSZ_INS_SRA = 634,
    SYSZ_INS_SRAG = 635,
    SYSZ_INS_SRAK = 636,
    SYSZ_INS_SRK = 637,
    SYSZ_INS_SRL = 638,
    SYSZ_INS_SRLG = 639,
    SYSZ_INS_SRLK = 640,
    SYSZ_INS_SRST = 641,
    SYSZ_INS_ST = 642,
    SYSZ_INS_STC = 643,
    SYSZ_INS_STCH = 644,
    SYSZ_INS_STCY = 645,
    SYSZ_INS_STD = 646,
    SYSZ_INS_STDY = 647,
    SYSZ_INS_STE = 648,
    SYSZ_INS_STEY = 649,
    SYSZ_INS_STFH = 650,
    SYSZ_INS_STG = 651,
    SYSZ_INS_STGRL = 652,
    SYSZ_INS_STH = 653,
    SYSZ_INS_STHH = 654,
    SYSZ_INS_STHRL = 655,
    SYSZ_INS_STHY = 656,
    SYSZ_INS_STMG = 657,
    SYSZ_INS_STRL = 658,
    SYSZ_INS_STRV = 659,
    SYSZ_INS_STRVG = 660,
    SYSZ_INS_STY = 661,
    SYSZ_INS_SXBR = 662,
    SYSZ_INS_SY = 663,
    SYSZ_INS_TM = 664,
    SYSZ_INS_TMHH = 665,
    SYSZ_INS_TMHL = 666,
    SYSZ_INS_TMLH = 667,
    SYSZ_INS_TMLL = 668,
    SYSZ_INS_TMY = 669,
    SYSZ_INS_X = 670,
    SYSZ_INS_XC = 671,
    SYSZ_INS_XG = 672,
    SYSZ_INS_XGR = 673,
    SYSZ_INS_XGRK = 674,
    SYSZ_INS_XI = 675,
    SYSZ_INS_XIHF = 676,
    SYSZ_INS_XILF = 677,
    SYSZ_INS_XIY = 678,
    SYSZ_INS_XR = 679,
    SYSZ_INS_XRK = 680,
    SYSZ_INS_XY = 681,
    SYSZ_INS_AD = 682,
    SYSZ_INS_ADR = 683,
    SYSZ_INS_ADTR = 684,
    SYSZ_INS_ADTRA = 685,
    SYSZ_INS_AE = 686,
    SYSZ_INS_AER = 687,
    SYSZ_INS_AGH = 688,
    SYSZ_INS_AHHHR = 689,
    SYSZ_INS_AHHLR = 690,
    SYSZ_INS_ALGSI = 691,
    SYSZ_INS_ALHHHR = 692,
    SYSZ_INS_ALHHLR = 693,
    SYSZ_INS_ALSI = 694,
    SYSZ_INS_ALSIH = 695,
    SYSZ_INS_ALSIHN = 696,
    SYSZ_INS_AP = 697,
    SYSZ_INS_AU = 698,
    SYSZ_INS_AUR = 699,
    SYSZ_INS_AW = 700,
    SYSZ_INS_AWR = 701,
    SYSZ_INS_AXR = 702,
    SYSZ_INS_AXTR = 703,
    SYSZ_INS_AXTRA = 704,
    SYSZ_INS_B = 705,
    SYSZ_INS_BAKR = 706,
    SYSZ_INS_BAL = 707,
    SYSZ_INS_BALR = 708,
    SYSZ_INS_BAS = 709,
    SYSZ_INS_BASSM = 710,
    SYSZ_INS_BC = 711,
    SYSZ_INS_BCT = 712,
    SYSZ_INS_BCTG = 713,
    SYSZ_INS_BCTGR = 714,
    SYSZ_INS_BCTR = 715,
    SYSZ_INS_BE = 716,
    SYSZ_INS_BH = 717,
    SYSZ_INS_BHE = 718,
    SYSZ_INS_BI = 719,
    SYSZ_INS_BIC = 720,
    SYSZ_INS_BIE = 721,
    SYSZ_INS_BIH = 722,
    SYSZ_INS_BIHE = 723,
    SYSZ_INS_BIL = 724,
    SYSZ_INS_BILE = 725,
    SYSZ_INS_BILH = 726,
    SYSZ_INS_BIM = 727,
    SYSZ_INS_BINE = 728,
    SYSZ_INS_BINH = 729,
    SYSZ_INS_BINHE = 730,
    SYSZ_INS_BINL = 731,
    SYSZ_INS_BINLE = 732,
    SYSZ_INS_BINLH = 733,
    SYSZ_INS_BINM = 734,
    SYSZ_INS_BINO = 735,
    SYSZ_INS_BINP = 736,
    SYSZ_INS_BINZ = 737,
    SYSZ_INS_BIO = 738,
    SYSZ_INS_BIP = 739,
    SYSZ_INS_BIZ = 740,
    SYSZ_INS_BL = 741,
    SYSZ_INS_BLE = 742,
    SYSZ_INS_BLH = 743,
    SYSZ_INS_BM = 744,
    SYSZ_INS_BMR = 745,
    SYSZ_INS_BNE = 746,
    SYSZ_INS_BNH = 747,
    SYSZ_INS_BNHE = 748,
    SYSZ_INS_BNL = 749,
    SYSZ_INS_BNLE = 750,
    SYSZ_INS_BNLH = 751,
    SYSZ_INS_BNM = 752,
    SYSZ_INS_BNMR = 753,
    SYSZ_INS_BNO = 754,
    SYSZ_INS_BNP = 755,
    SYSZ_INS_BNPR = 756,
    SYSZ_INS_BNZ = 757,
    SYSZ_INS_BNZR = 758,
    SYSZ_INS_BO = 759,
    SYSZ_INS_BP = 760,
    SYSZ_INS_BPP = 761,
    SYSZ_INS_BPR = 762,
    SYSZ_INS_BPRP = 763,
    SYSZ_INS_BRCTH = 764,
    SYSZ_INS_BRXH = 765,
    SYSZ_INS_BRXHG = 766,
    SYSZ_INS_BRXLE = 767,
    SYSZ_INS_BRXLG = 768,
    SYSZ_INS_BSA = 769,
    SYSZ_INS_BSG = 770,
    SYSZ_INS_BSM = 771,
    SYSZ_INS_BXH = 772,
    SYSZ_INS_BXHG = 773,
    SYSZ_INS_BXLE = 774,
    SYSZ_INS_BXLEG = 775,
    SYSZ_INS_BZ = 776,
    SYSZ_INS_BZR = 777,
    SYSZ_INS_CD = 778,
    SYSZ_INS_CDFBRA = 779,
    SYSZ_INS_CDFR = 780,
    SYSZ_INS_CDFTR = 781,
    SYSZ_INS_CDGBRA = 782,
    SYSZ_INS_CDGR = 783,
    SYSZ_INS_CDGTR = 784,
    SYSZ_INS_CDGTRA = 785,
    SYSZ_INS_CDLFTR = 786,
    SYSZ_INS_CDLGTR = 787,
    SYSZ_INS_CDPT = 788,
    SYSZ_INS_CDR = 789,
    SYSZ_INS_CDS = 790,
    SYSZ_INS_CDSG = 791,
    SYSZ_INS_CDSTR = 792,
    SYSZ_INS_CDSY = 793,
    SYSZ_INS_CDTR = 794,
    SYSZ_INS_CDUTR = 795,
    SYSZ_INS_CDZT = 796,
    SYSZ_INS_CE = 797,
    SYSZ_INS_CEDTR = 798,
    SYSZ_INS_CEFBRA = 799,
    SYSZ_INS_CEFR = 800,
    SYSZ_INS_CEGBRA = 801,
    SYSZ_INS_CEGR = 802,
    SYSZ_INS_CER = 803,
    SYSZ_INS_CEXTR = 804,
    SYSZ_INS_CFC = 805,
    SYSZ_INS_CFDBRA = 806,
    SYSZ_INS_CFDR = 807,
    SYSZ_INS_CFDTR = 808,
    SYSZ_INS_CFEBRA = 809,
    SYSZ_INS_CFER = 810,
    SYSZ_INS_CFXBRA = 811,
    SYSZ_INS_CFXR = 812,
    SYSZ_INS_CFXTR = 813,
    SYSZ_INS_CGDBRA = 814,
    SYSZ_INS_CGDR = 815,
    SYSZ_INS_CGDTR = 816,
    SYSZ_INS_CGDTRA = 817,
    SYSZ_INS_CGEBRA = 818,
    SYSZ_INS_CGER = 819,
    SYSZ_INS_CGIB = 820,
    SYSZ_INS_CGIBE = 821,
    SYSZ_INS_CGIBH = 822,
    SYSZ_INS_CGIBHE = 823,
    SYSZ_INS_CGIBL = 824,
    SYSZ_INS_CGIBLE = 825,
    SYSZ_INS_CGIBLH = 826,
    SYSZ_INS_CGIBNE = 827,
    SYSZ_INS_CGIBNH = 828,
    SYSZ_INS_CGIBNHE = 829,
    SYSZ_INS_CGIBNL = 830,
    SYSZ_INS_CGIBNLE = 831,
    SYSZ_INS_CGIBNLH = 832,
    SYSZ_INS_CGIT = 833,
    SYSZ_INS_CGITE = 834,
    SYSZ_INS_CGITH = 835,
    SYSZ_INS_CGITHE = 836,
    SYSZ_INS_CGITL = 837,
    SYSZ_INS_CGITLE = 838,
    SYSZ_INS_CGITLH = 839,
    SYSZ_INS_CGITNE = 840,
    SYSZ_INS_CGITNH = 841,
    SYSZ_INS_CGITNHE = 842,
    SYSZ_INS_CGITNL = 843,
    SYSZ_INS_CGITNLE = 844,
    SYSZ_INS_CGITNLH = 845,
    SYSZ_INS_CGRB = 846,
    SYSZ_INS_CGRBE = 847,
    SYSZ_INS_CGRBH = 848,
    SYSZ_INS_CGRBHE = 849,
    SYSZ_INS_CGRBL = 850,
    SYSZ_INS_CGRBLE = 851,
    SYSZ_INS_CGRBLH = 852,
    SYSZ_INS_CGRBNE = 853,
    SYSZ_INS_CGRBNH = 854,
    SYSZ_INS_CGRBNHE = 855,
    SYSZ_INS_CGRBNL = 856,
    SYSZ_INS_CGRBNLE = 857,
    SYSZ_INS_CGRBNLH = 858,
    SYSZ_INS_CGRT = 859,
    SYSZ_INS_CGRTE = 860,
    SYSZ_INS_CGRTH = 861,
    SYSZ_INS_CGRTHE = 862,
    SYSZ_INS_CGRTL = 863,
    SYSZ_INS_CGRTLE = 864,
    SYSZ_INS_CGRTLH = 865,
    SYSZ_INS_CGRTNE = 866,
    SYSZ_INS_CGRTNH = 867,
    SYSZ_INS_CGRTNHE = 868,
    SYSZ_INS_CGRTNL = 869,
    SYSZ_INS_CGRTNLE = 870,
    SYSZ_INS_CGRTNLH = 871,
    SYSZ_INS_CGXBRA = 872,
    SYSZ_INS_CGXR = 873,
    SYSZ_INS_CGXTR = 874,
    SYSZ_INS_CGXTRA = 875,
    SYSZ_INS_CHHR = 876,
    SYSZ_INS_CHLR = 877,
    SYSZ_INS_CIB = 878,
    SYSZ_INS_CIBE = 879,
    SYSZ_INS_CIBH = 880,
    SYSZ_INS_CIBHE = 881,
    SYSZ_INS_CIBL = 882,
    SYSZ_INS_CIBLE = 883,
    SYSZ_INS_CIBLH = 884,
    SYSZ_INS_CIBNE = 885,
    SYSZ_INS_CIBNH = 886,
    SYSZ_INS_CIBNHE = 887,
    SYSZ_INS_CIBNL = 888,
    SYSZ_INS_CIBNLE = 889,
    SYSZ_INS_CIBNLH = 890,
    SYSZ_INS_CIT = 891,
    SYSZ_INS_CITE = 892,
    SYSZ_INS_CITH = 893,
    SYSZ_INS_CITHE = 894,
    SYSZ_INS_CITL = 895,
    SYSZ_INS_CITLE = 896,
    SYSZ_INS_CITLH = 897,
    SYSZ_INS_CITNE = 898,
    SYSZ_INS_CITNH = 899,
    SYSZ_INS_CITNHE = 900,
    SYSZ_INS_CITNL = 901,
    SYSZ_INS_CITNLE = 902,
    SYSZ_INS_CITNLH = 903,
    SYSZ_INS_CKSM = 904,
    SYSZ_INS_CLCL = 905,
    SYSZ_INS_CLCLE = 906,
    SYSZ_INS_CLCLU = 907,
    SYSZ_INS_CLFDTR = 908,
    SYSZ_INS_CLFIT = 909,
    SYSZ_INS_CLFITE = 910,
    SYSZ_INS_CLFITH = 911,
    SYSZ_INS_CLFITHE = 912,
    SYSZ_INS_CLFITL = 913,
    SYSZ_INS_CLFITLE = 914,
    SYSZ_INS_CLFITLH = 915,
    SYSZ_INS_CLFITNE = 916,
    SYSZ_INS_CLFITNH = 917,
    SYSZ_INS_CLFITNHE = 918,
    SYSZ_INS_CLFITNL = 919,
    SYSZ_INS_CLFITNLE = 920,
    SYSZ_INS_CLFITNLH = 921,
    SYSZ_INS_CLFXTR = 922,
    SYSZ_INS_CLGDTR = 923,
    SYSZ_INS_CLGIB = 924,
    SYSZ_INS_CLGIBE = 925,
    SYSZ_INS_CLGIBH = 926,
    SYSZ_INS_CLGIBHE = 927,
    SYSZ_INS_CLGIBL = 928,
    SYSZ_INS_CLGIBLE = 929,
    SYSZ_INS_CLGIBLH = 930,
    SYSZ_INS_CLGIBNE = 931,
    SYSZ_INS_CLGIBNH = 932,
    SYSZ_INS_CLGIBNHE = 933,
    SYSZ_INS_CLGIBNL = 934,
    SYSZ_INS_CLGIBNLE = 935,
    SYSZ_INS_CLGIBNLH = 936,
    SYSZ_INS_CLGIT = 937,
    SYSZ_INS_CLGITE = 938,
    SYSZ_INS_CLGITH = 939,
    SYSZ_INS_CLGITHE = 940,
    SYSZ_INS_CLGITL = 941,
    SYSZ_INS_CLGITLE = 942,
    SYSZ_INS_CLGITLH = 943,
    SYSZ_INS_CLGITNE = 944,
    SYSZ_INS_CLGITNH = 945,
    SYSZ_INS_CLGITNHE = 946,
    SYSZ_INS_CLGITNL = 947,
    SYSZ_INS_CLGITNLE = 948,
    SYSZ_INS_CLGITNLH = 949,
    SYSZ_INS_CLGRB = 950,
    SYSZ_INS_CLGRBE = 951,
    SYSZ_INS_CLGRBH = 952,
    SYSZ_INS_CLGRBHE = 953,
    SYSZ_INS_CLGRBL = 954,
    SYSZ_INS_CLGRBLE = 955,
    SYSZ_INS_CLGRBLH = 956,
    SYSZ_INS_CLGRBNE = 957,
    SYSZ_INS_CLGRBNH = 958,
    SYSZ_INS_CLGRBNHE = 959,
    SYSZ_INS_CLGRBNL = 960,
    SYSZ_INS_CLGRBNLE = 961,
    SYSZ_INS_CLGRBNLH = 962,
    SYSZ_INS_CLGRT = 963,
    SYSZ_INS_CLGRTE = 964,
    SYSZ_INS_CLGRTH = 965,
    SYSZ_INS_CLGRTHE = 966,
    SYSZ_INS_CLGRTL = 967,
    SYSZ_INS_CLGRTLE = 968,
    SYSZ_INS_CLGRTLH = 969,
    SYSZ_INS_CLGRTNE = 970,
    SYSZ_INS_CLGRTNH = 971,
    SYSZ_INS_CLGRTNHE = 972,
    SYSZ_INS_CLGRTNL = 973,
    SYSZ_INS_CLGRTNLE = 974,
    SYSZ_INS_CLGRTNLH = 975,
    SYSZ_INS_CLGT = 976,
    SYSZ_INS_CLGTE = 977,
    SYSZ_INS_CLGTH = 978,
    SYSZ_INS_CLGTHE = 979,
    SYSZ_INS_CLGTL = 980,
    SYSZ_INS_CLGTLE = 981,
    SYSZ_INS_CLGTLH = 982,
    SYSZ_INS_CLGTNE = 983,
    SYSZ_INS_CLGTNH = 984,
    SYSZ_INS_CLGTNHE = 985,
    SYSZ_INS_CLGTNL = 986,
    SYSZ_INS_CLGTNLE = 987,
    SYSZ_INS_CLGTNLH = 988,
    SYSZ_INS_CLGXTR = 989,
    SYSZ_INS_CLHHR = 990,
    SYSZ_INS_CLHLR = 991,
    SYSZ_INS_CLIB = 992,
    SYSZ_INS_CLIBE = 993,
    SYSZ_INS_CLIBH = 994,
    SYSZ_INS_CLIBHE = 995,
    SYSZ_INS_CLIBL = 996,
    SYSZ_INS_CLIBLE = 997,
    SYSZ_INS_CLIBLH = 998,
    SYSZ_INS_CLIBNE = 999,
    SYSZ_INS_CLIBNH = 1000,
    SYSZ_INS_CLIBNHE = 1001,
    SYSZ_INS_CLIBNL = 1002,
    SYSZ_INS_CLIBNLE = 1003,
    SYSZ_INS_CLIBNLH = 1004,
    SYSZ_INS_CLM = 1005,
    SYSZ_INS_CLMH = 1006,
    SYSZ_INS_CLMY = 1007,
    SYSZ_INS_CLRB = 1008,
    SYSZ_INS_CLRBE = 1009,
    SYSZ_INS_CLRBH = 1010,
    SYSZ_INS_CLRBHE = 1011,
    SYSZ_INS_CLRBL = 1012,
    SYSZ_INS_CLRBLE = 1013,
    SYSZ_INS_CLRBLH = 1014,
    SYSZ_INS_CLRBNE = 1015,
    SYSZ_INS_CLRBNH = 1016,
    SYSZ_INS_CLRBNHE = 1017,
    SYSZ_INS_CLRBNL = 1018,
    SYSZ_INS_CLRBNLE = 1019,
    SYSZ_INS_CLRBNLH = 1020,
    SYSZ_INS_CLRT = 1021,
    SYSZ_INS_CLRTE = 1022,
    SYSZ_INS_CLRTH = 1023,
    SYSZ_INS_CLRTHE = 1024,
    SYSZ_INS_CLRTL = 1025,
    SYSZ_INS_CLRTLE = 1026,
    SYSZ_INS_CLRTLH = 1027,
    SYSZ_INS_CLRTNE = 1028,
    SYSZ_INS_CLRTNH = 1029,
    SYSZ_INS_CLRTNHE = 1030,
    SYSZ_INS_CLRTNL = 1031,
    SYSZ_INS_CLRTNLE = 1032,
    SYSZ_INS_CLRTNLH = 1033,
    SYSZ_INS_CLT = 1034,
    SYSZ_INS_CLTE = 1035,
    SYSZ_INS_CLTH = 1036,
    SYSZ_INS_CLTHE = 1037,
    SYSZ_INS_CLTL = 1038,
    SYSZ_INS_CLTLE = 1039,
    SYSZ_INS_CLTLH = 1040,
    SYSZ_INS_CLTNE = 1041,
    SYSZ_INS_CLTNH = 1042,
    SYSZ_INS_CLTNHE = 1043,
    SYSZ_INS_CLTNL = 1044,
    SYSZ_INS_CLTNLE = 1045,
    SYSZ_INS_CLTNLH = 1046,
    SYSZ_INS_CMPSC = 1047,
    SYSZ_INS_CP = 1048,
    SYSZ_INS_CPDT = 1049,
    SYSZ_INS_CPXT = 1050,
    SYSZ_INS_CPYA = 1051,
    SYSZ_INS_CRB = 1052,
    SYSZ_INS_CRBE = 1053,
    SYSZ_INS_CRBH = 1054,
    SYSZ_INS_CRBHE = 1055,
    SYSZ_INS_CRBL = 1056,
    SYSZ_INS_CRBLE = 1057,
    SYSZ_INS_CRBLH = 1058,
    SYSZ_INS_CRBNE = 1059,
    SYSZ_INS_CRBNH = 1060,
    SYSZ_INS_CRBNHE = 1061,
    SYSZ_INS_CRBNL = 1062,
    SYSZ_INS_CRBNLE = 1063,
    SYSZ_INS_CRBNLH = 1064,
    SYSZ_INS_CRDTE = 1065,
    SYSZ_INS_CRT = 1066,
    SYSZ_INS_CRTE = 1067,
    SYSZ_INS_CRTH = 1068,
    SYSZ_INS_CRTHE = 1069,
    SYSZ_INS_CRTL = 1070,
    SYSZ_INS_CRTLE = 1071,
    SYSZ_INS_CRTLH = 1072,
    SYSZ_INS_CRTNE = 1073,
    SYSZ_INS_CRTNH = 1074,
    SYSZ_INS_CRTNHE = 1075,
    SYSZ_INS_CRTNL = 1076,
    SYSZ_INS_CRTNLE = 1077,
    SYSZ_INS_CRTNLH = 1078,
    SYSZ_INS_CSCH = 1079,
    SYSZ_INS_CSDTR = 1080,
    SYSZ_INS_CSP = 1081,
    SYSZ_INS_CSPG = 1082,
    SYSZ_INS_CSST = 1083,
    SYSZ_INS_CSXTR = 1084,
    SYSZ_INS_CU12 = 1085,
    SYSZ_INS_CU14 = 1086,
    SYSZ_INS_CU21 = 1087,
    SYSZ_INS_CU24 = 1088,
    SYSZ_INS_CU41 = 1089,
    SYSZ_INS_CU42 = 1090,
    SYSZ_INS_CUDTR = 1091,
    SYSZ_INS_CUSE = 1092,
    SYSZ_INS_CUTFU = 1093,
    SYSZ_INS_CUUTF = 1094,
    SYSZ_INS_CUXTR = 1095,
    SYSZ_INS_CVB = 1096,
    SYSZ_INS_CVBG = 1097,
    SYSZ_INS_CVBY = 1098,
    SYSZ_INS_CVD = 1099,
    SYSZ_INS_CVDG = 1100,
    SYSZ_INS_CVDY = 1101,
    SYSZ_INS_CXFBRA = 1102,
    SYSZ_INS_CXFR = 1103,
    SYSZ_INS_CXFTR = 1104,
    SYSZ_INS_CXGBRA = 1105,
    SYSZ_INS_CXGR = 1106,
    SYSZ_INS_CXGTR = 1107,
    SYSZ_INS_CXGTRA = 1108,
    SYSZ_INS_CXLFTR = 1109,
    SYSZ_INS_CXLGTR = 1110,
    SYSZ_INS_CXPT = 1111,
    SYSZ_INS_CXR = 1112,
    SYSZ_INS_CXSTR = 1113,
    SYSZ_INS_CXTR = 1114,
    SYSZ_INS_CXUTR = 1115,
    SYSZ_INS_CXZT = 1116,
    SYSZ_INS_CZDT = 1117,
    SYSZ_INS_CZXT = 1118,
    SYSZ_INS_D = 1119,
    SYSZ_INS_DD = 1120,
    SYSZ_INS_DDR = 1121,
    SYSZ_INS_DDTR = 1122,
    SYSZ_INS_DDTRA = 1123,
    SYSZ_INS_DE = 1124,
    SYSZ_INS_DER = 1125,
    SYSZ_INS_DIAG = 1126,
    SYSZ_INS_DIDBR = 1127,
    SYSZ_INS_DIEBR = 1128,
    SYSZ_INS_DP = 1129,
    SYSZ_INS_DR = 1130,
    SYSZ_INS_DXR = 1131,
    SYSZ_INS_DXTR = 1132,
    SYSZ_INS_DXTRA = 1133,
    SYSZ_INS_ECAG = 1134,
    SYSZ_INS_ECCTR = 1135,
    SYSZ_INS_ECPGA = 1136,
    SYSZ_INS_ECTG = 1137,
    SYSZ_INS_ED = 1138,
    SYSZ_INS_EDMK = 1139,
    SYSZ_INS_EEDTR = 1140,
    SYSZ_INS_EEXTR = 1141,
    SYSZ_INS_EFPC = 1142,
    SYSZ_INS_EPAIR = 1143,
    SYSZ_INS_EPAR = 1144,
    SYSZ_INS_EPCTR = 1145,
    SYSZ_INS_EPSW = 1146,
    SYSZ_INS_EREG = 1147,
    SYSZ_INS_EREGG = 1148,
    SYSZ_INS_ESAIR = 1149,
    SYSZ_INS_ESAR = 1150,
    SYSZ_INS_ESDTR = 1151,
    SYSZ_INS_ESEA = 1152,
    SYSZ_INS_ESTA = 1153,
    SYSZ_INS_ESXTR = 1154,
    SYSZ_INS_ETND = 1155,
    SYSZ_INS_EX = 1156,
    SYSZ_INS_EXRL = 1157,
    SYSZ_INS_FIDR = 1158,
    SYSZ_INS_FIDTR = 1159,
    SYSZ_INS_FIER = 1160,
    SYSZ_INS_FIXR = 1161,
    SYSZ_INS_FIXTR = 1162,
    SYSZ_INS_HDR = 1163,
    SYSZ_INS_HER = 1164,
    SYSZ_INS_HSCH = 1165,
    SYSZ_INS_IAC = 1166,
    SYSZ_INS_ICM = 1167,
    SYSZ_INS_ICMH = 1168,
    SYSZ_INS_ICMY = 1169,
    SYSZ_INS_IDTE = 1170,
    SYSZ_INS_IEDTR = 1171,
    SYSZ_INS_IEXTR = 1172,
    SYSZ_INS_IPK = 1173,
    SYSZ_INS_IPTE = 1174,
    SYSZ_INS_IRBM = 1175,
    SYSZ_INS_ISKE = 1176,
    SYSZ_INS_IVSK = 1177,
    SYSZ_INS_JGM = 1178,
    SYSZ_INS_JGNM = 1179,
    SYSZ_INS_JGNP = 1180,
    SYSZ_INS_JGNZ = 1181,
    SYSZ_INS_JGP = 1182,
    SYSZ_INS_JGZ = 1183,
    SYSZ_INS_JM = 1184,
    SYSZ_INS_JNM = 1185,
    SYSZ_INS_JNP = 1186,
    SYSZ_INS_JNZ = 1187,
    SYSZ_INS_JP = 1188,
    SYSZ_INS_JZ = 1189,
    SYSZ_INS_KDB = 1190,
    SYSZ_INS_KDBR = 1191,
    SYSZ_INS_KDTR = 1192,
    SYSZ_INS_KEB = 1193,
    SYSZ_INS_KEBR = 1194,
    SYSZ_INS_KIMD = 1195,
    SYSZ_INS_KLMD = 1196,
    SYSZ_INS_KM = 1197,
    SYSZ_INS_KMA = 1198,
    SYSZ_INS_KMAC = 1199,
    SYSZ_INS_KMC = 1200,
    SYSZ_INS_KMCTR = 1201,
    SYSZ_INS_KMF = 1202,
    SYSZ_INS_KMO = 1203,
    SYSZ_INS_KXBR = 1204,
    SYSZ_INS_KXTR = 1205,
    SYSZ_INS_LAE = 1206,
    SYSZ_INS_LAEY = 1207,
    SYSZ_INS_LAM = 1208,
    SYSZ_INS_LAMY = 1209,
    SYSZ_INS_LASP = 1210,
    SYSZ_INS_LAT = 1211,
    SYSZ_INS_LCBB = 1212,
    SYSZ_INS_LCCTL = 1213,
    SYSZ_INS_LCDFR = 1214,
    SYSZ_INS_LCDR = 1215,
    SYSZ_INS_LCER = 1216,
    SYSZ_INS_LCTL = 1217,
    SYSZ_INS_LCTLG = 1218,
    SYSZ_INS_LCXR = 1219,
    SYSZ_INS_LDE = 1220,
    SYSZ_INS_LDER = 1221,
    SYSZ_INS_LDETR = 1222,
    SYSZ_INS_LDXR = 1223,
    SYSZ_INS_LDXTR = 1224,
    SYSZ_INS_LEDR = 1225,
    SYSZ_INS_LEDTR = 1226,
    SYSZ_INS_LEXR = 1227,
    SYSZ_INS_LFAS = 1228,
    SYSZ_INS_LFHAT = 1229,
    SYSZ_INS_LFPC = 1230,
    SYSZ_INS_LGAT = 1231,
    SYSZ_INS_LGG = 1232,
    SYSZ_INS_LGSC = 1233,
    SYSZ_INS_LLGFAT = 1234,
    SYSZ_INS_LLGFSG = 1235,
    SYSZ_INS_LLGT = 1236,
    SYSZ_INS_LLGTAT = 1237,
    SYSZ_INS_LLGTR = 1238,
    SYSZ_INS_LLZRGF = 1239,
    SYSZ_INS_LM = 1240,
    SYSZ_INS_LMD = 1241,
    SYSZ_INS_LMH = 1242,
    SYSZ_INS_LMY = 1243,
    SYSZ_INS_LNDFR = 1244,
    SYSZ_INS_LNDR = 1245,
    SYSZ_INS_LNER = 1246,
    SYSZ_INS_LNXR = 1247,
    SYSZ_INS_LOCFH = 1248,
    SYSZ_INS_LOCFHE = 1249,
    SYSZ_INS_LOCFHH = 1250,
    SYSZ_INS_LOCFHHE = 1251,
    SYSZ_INS_LOCFHL = 1252,
    SYSZ_INS_LOCFHLE = 1253,
    SYSZ_INS_LOCFHLH = 1254,
    SYSZ_INS_LOCFHM = 1255,
    SYSZ_INS_LOCFHNE = 1256,
    SYSZ_INS_LOCFHNH = 1257,
    SYSZ_INS_LOCFHNHE = 1258,
    SYSZ_INS_LOCFHNL = 1259,
    SYSZ_INS_LOCFHNLE = 1260,
    SYSZ_INS_LOCFHNLH = 1261,
    SYSZ_INS_LOCFHNM = 1262,
    SYSZ_INS_LOCFHNO = 1263,
    SYSZ_INS_LOCFHNP = 1264,
    SYSZ_INS_LOCFHNZ = 1265,
    SYSZ_INS_LOCFHO = 1266,
    SYSZ_INS_LOCFHP = 1267,
    SYSZ_INS_LOCFHR = 1268,
    SYSZ_INS_LOCFHRE = 1269,
    SYSZ_INS_LOCFHRH = 1270,
    SYSZ_INS_LOCFHRHE = 1271,
    SYSZ_INS_LOCFHRL = 1272,
    SYSZ_INS_LOCFHRLE = 1273,
    SYSZ_INS_LOCFHRLH = 1274,
    SYSZ_INS_LOCFHRM = 1275,
    SYSZ_INS_LOCFHRNE = 1276,
    SYSZ_INS_LOCFHRNH = 1277,
    SYSZ_INS_LOCFHRNHE = 1278,
    SYSZ_INS_LOCFHRNL = 1279,
    SYSZ_INS_LOCFHRNLE = 1280,
    SYSZ_INS_LOCFHRNLH = 1281,
    SYSZ_INS_LOCFHRNM = 1282,
    SYSZ_INS_LOCFHRNO = 1283,
    SYSZ_INS_LOCFHRNP = 1284,
    SYSZ_INS_LOCFHRNZ = 1285,
    SYSZ_INS_LOCFHRO = 1286,
    SYSZ_INS_LOCFHRP = 1287,
    SYSZ_INS_LOCFHRZ = 1288,
    SYSZ_INS_LOCFHZ = 1289,
    SYSZ_INS_LOCGHI = 1290,
    SYSZ_INS_LOCGHIE = 1291,
    SYSZ_INS_LOCGHIH = 1292,
    SYSZ_INS_LOCGHIHE = 1293,
    SYSZ_INS_LOCGHIL = 1294,
    SYSZ_INS_LOCGHILE = 1295,
    SYSZ_INS_LOCGHILH = 1296,
    SYSZ_INS_LOCGHIM = 1297,
    SYSZ_INS_LOCGHINE = 1298,
    SYSZ_INS_LOCGHINH = 1299,
    SYSZ_INS_LOCGHINHE = 1300,
    SYSZ_INS_LOCGHINL = 1301,
    SYSZ_INS_LOCGHINLE = 1302,
    SYSZ_INS_LOCGHINLH = 1303,
    SYSZ_INS_LOCGHINM = 1304,
    SYSZ_INS_LOCGHINO = 1305,
    SYSZ_INS_LOCGHINP = 1306,
    SYSZ_INS_LOCGHINZ = 1307,
    SYSZ_INS_LOCGHIO = 1308,
    SYSZ_INS_LOCGHIP = 1309,
    SYSZ_INS_LOCGHIZ = 1310,
    SYSZ_INS_LOCGM = 1311,
    SYSZ_INS_LOCGNM = 1312,
    SYSZ_INS_LOCGNP = 1313,
    SYSZ_INS_LOCGNZ = 1314,
    SYSZ_INS_LOCGP = 1315,
    SYSZ_INS_LOCGRM = 1316,
    SYSZ_INS_LOCGRNM = 1317,
    SYSZ_INS_LOCGRNP = 1318,
    SYSZ_INS_LOCGRNZ = 1319,
    SYSZ_INS_LOCGRP = 1320,
    SYSZ_INS_LOCGRZ = 1321,
    SYSZ_INS_LOCGZ = 1322,
    SYSZ_INS_LOCHHI = 1323,
    SYSZ_INS_LOCHHIE = 1324,
    SYSZ_INS_LOCHHIH = 1325,
    SYSZ_INS_LOCHHIHE = 1326,
    SYSZ_INS_LOCHHIL = 1327,
    SYSZ_INS_LOCHHILE = 1328,
    SYSZ_INS_LOCHHILH = 1329,
    SYSZ_INS_LOCHHIM = 1330,
    SYSZ_INS_LOCHHINE = 1331,
    SYSZ_INS_LOCHHINH = 1332,
    SYSZ_INS_LOCHHINHE = 1333,
    SYSZ_INS_LOCHHINL = 1334,
    SYSZ_INS_LOCHHINLE = 1335,
    SYSZ_INS_LOCHHINLH = 1336,
    SYSZ_INS_LOCHHINM = 1337,
    SYSZ_INS_LOCHHINO = 1338,
    SYSZ_INS_LOCHHINP = 1339,
    SYSZ_INS_LOCHHINZ = 1340,
    SYSZ_INS_LOCHHIO = 1341,
    SYSZ_INS_LOCHHIP = 1342,
    SYSZ_INS_LOCHHIZ = 1343,
    SYSZ_INS_LOCHI = 1344,
    SYSZ_INS_LOCHIE = 1345,
    SYSZ_INS_LOCHIH = 1346,
    SYSZ_INS_LOCHIHE = 1347,
    SYSZ_INS_LOCHIL = 1348,
    SYSZ_INS_LOCHILE = 1349,
    SYSZ_INS_LOCHILH = 1350,
    SYSZ_INS_LOCHIM = 1351,
    SYSZ_INS_LOCHINE = 1352,
    SYSZ_INS_LOCHINH = 1353,
    SYSZ_INS_LOCHINHE = 1354,
    SYSZ_INS_LOCHINL = 1355,
    SYSZ_INS_LOCHINLE = 1356,
    SYSZ_INS_LOCHINLH = 1357,
    SYSZ_INS_LOCHINM = 1358,
    SYSZ_INS_LOCHINO = 1359,
    SYSZ_INS_LOCHINP = 1360,
    SYSZ_INS_LOCHINZ = 1361,
    SYSZ_INS_LOCHIO = 1362,
    SYSZ_INS_LOCHIP = 1363,
    SYSZ_INS_LOCHIZ = 1364,
    SYSZ_INS_LOCM = 1365,
    SYSZ_INS_LOCNM = 1366,
    SYSZ_INS_LOCNP = 1367,
    SYSZ_INS_LOCNZ = 1368,
    SYSZ_INS_LOCP = 1369,
    SYSZ_INS_LOCRM = 1370,
    SYSZ_INS_LOCRNM = 1371,
    SYSZ_INS_LOCRNP = 1372,
    SYSZ_INS_LOCRNZ = 1373,
    SYSZ_INS_LOCRP = 1374,
    SYSZ_INS_LOCRZ = 1375,
    SYSZ_INS_LOCZ = 1376,
    SYSZ_INS_LPCTL = 1377,
    SYSZ_INS_LPD = 1378,
    SYSZ_INS_LPDFR = 1379,
    SYSZ_INS_LPDG = 1380,
    SYSZ_INS_LPDR = 1381,
    SYSZ_INS_LPER = 1382,
    SYSZ_INS_LPP = 1383,
    SYSZ_INS_LPQ = 1384,
    SYSZ_INS_LPSW = 1385,
    SYSZ_INS_LPSWE = 1386,
    SYSZ_INS_LPTEA = 1387,
    SYSZ_INS_LPXR = 1388,
    SYSZ_INS_LRA = 1389,
    SYSZ_INS_LRAG = 1390,
    SYSZ_INS_LRAY = 1391,
    SYSZ_INS_LRDR = 1392,
    SYSZ_INS_LRER = 1393,
    SYSZ_INS_LRVH = 1394,
    SYSZ_INS_LSCTL = 1395,
    SYSZ_INS_LTDR = 1396,
    SYSZ_INS_LTDTR = 1397,
    SYSZ_INS_LTER = 1398,
    SYSZ_INS_LTXR = 1399,
    SYSZ_INS_LTXTR = 1400,
    SYSZ_INS_LURA = 1401,
    SYSZ_INS_LURAG = 1402,
    SYSZ_INS_LXD = 1403,
    SYSZ_INS_LXDR = 1404,
    SYSZ_INS_LXDTR = 1405,
    SYSZ_INS_LXE = 1406,
    SYSZ_INS_LXER = 1407,
    SYSZ_INS_LZRF = 1408,
    SYSZ_INS_LZRG = 1409,
    SYSZ_INS_M = 1410,
    SYSZ_INS_MAD = 1411,
    SYSZ_INS_MADR = 1412,
    SYSZ_INS_MAE = 1413,
    SYSZ_INS_MAER = 1414,
    SYSZ_INS_MAY = 1415,
    SYSZ_INS_MAYH = 1416,
    SYSZ_INS_MAYHR = 1417,
    SYSZ_INS_MAYL = 1418,
    SYSZ_INS_MAYLR = 1419,
    SYSZ_INS_MAYR = 1420,
    SYSZ_INS_MC = 1421,
    SYSZ_INS_MD = 1422,
    SYSZ_INS_MDE = 1423,
    SYSZ_INS_MDER = 1424,
    SYSZ_INS_MDR = 1425,
    SYSZ_INS_MDTR = 1426,
    SYSZ_INS_MDTRA = 1427,
    SYSZ_INS_ME = 1428,
    SYSZ_INS_MEE = 1429,
    SYSZ_INS_MEER = 1430,
    SYSZ_INS_MER = 1431,
    SYSZ_INS_MFY = 1432,
    SYSZ_INS_MG = 1433,
    SYSZ_INS_MGH = 1434,
    SYSZ_INS_MGRK = 1435,
    SYSZ_INS_ML = 1436,
    SYSZ_INS_MLR = 1437,
    SYSZ_INS_MP = 1438,
    SYSZ_INS_MR = 1439,
    SYSZ_INS_MSC = 1440,
    SYSZ_INS_MSCH = 1441,
    SYSZ_INS_MSD = 1442,
    SYSZ_INS_MSDR = 1443,
    SYSZ_INS_MSE = 1444,
    SYSZ_INS_MSER = 1445,
    SYSZ_INS_MSGC = 1446,
    SYSZ_INS_MSGRKC = 1447,
    SYSZ_INS_MSRKC = 1448,
    SYSZ_INS_MSTA = 1449,
    SYSZ_INS_MVCDK = 1450,
    SYSZ_INS_MVCIN = 1451,
    SYSZ_INS_MVCK = 1452,
    SYSZ_INS_MVCL = 1453,
    SYSZ_INS_MVCLE = 1454,
    SYSZ_INS_MVCLU = 1455,
    SYSZ_INS_MVCOS = 1456,
    SYSZ_INS_MVCP = 1457,
    SYSZ_INS_MVCS = 1458,
    SYSZ_INS_MVCSK = 1459,
    SYSZ_INS_MVN = 1460,
    SYSZ_INS_MVO = 1461,
    SYSZ_INS_MVPG = 1462,
    SYSZ_INS_MVZ = 1463,
    SYSZ_INS_MXD = 1464,
    SYSZ_INS_MXDR = 1465,
    SYSZ_INS_MXR = 1466,
    SYSZ_INS_MXTR = 1467,
    SYSZ_INS_MXTRA = 1468,
    SYSZ_INS_MY = 1469,
    SYSZ_INS_MYH = 1470,
    SYSZ_INS_MYHR = 1471,
    SYSZ_INS_MYL = 1472,
    SYSZ_INS_MYLR = 1473,
    SYSZ_INS_MYR = 1474,
    SYSZ_INS_NIAI = 1475,
    SYSZ_INS_NTSTG = 1476,
    SYSZ_INS_PACK = 1477,
    SYSZ_INS_PALB = 1478,
    SYSZ_INS_PC = 1479,
    SYSZ_INS_PCC = 1480,
    SYSZ_INS_PCKMO = 1481,
    SYSZ_INS_PFMF = 1482,
    SYSZ_INS_PFPO = 1483,
    SYSZ_INS_PGIN = 1484,
    SYSZ_INS_PGOUT = 1485,
    SYSZ_INS_PKA = 1486,
    SYSZ_INS_PKU = 1487,
    SYSZ_INS_PLO = 1488,
    SYSZ_INS_POPCNT = 1489,
    SYSZ_INS_PPA = 1490,
    SYSZ_INS_PPNO = 1491,
    SYSZ_INS_PR = 1492,
    SYSZ_INS_PRNO = 1493,
    SYSZ_INS_PT = 1494,
    SYSZ_INS_PTF = 1495,
    SYSZ_INS_PTFF = 1496,
    SYSZ_INS_PTI = 1497,
    SYSZ_INS_PTLB = 1498,
    SYSZ_INS_QADTR = 1499,
    SYSZ_INS_QAXTR = 1500,
    SYSZ_INS_QCTRI = 1501,
    SYSZ_INS_QSI = 1502,
    SYSZ_INS_RCHP = 1503,
    SYSZ_INS_RISBGN = 1504,
    SYSZ_INS_RP = 1505,
    SYSZ_INS_RRBE = 1506,
    SYSZ_INS_RRBM = 1507,
    SYSZ_INS_RRDTR = 1508,
    SYSZ_INS_RRXTR = 1509,
    SYSZ_INS_RSCH = 1510,
    SYSZ_INS_SAC = 1511,
    SYSZ_INS_SACF = 1512,
    SYSZ_INS_SAL = 1513,
    SYSZ_INS_SAM24 = 1514,
    SYSZ_INS_SAM31 = 1515,
    SYSZ_INS_SAM64 = 1516,
    SYSZ_INS_SAR = 1517,
    SYSZ_INS_SCCTR = 1518,
    SYSZ_INS_SCHM = 1519,
    SYSZ_INS_SCK = 1520,
    SYSZ_INS_SCKC = 1521,
    SYSZ_INS_SCKPF = 1522,
    SYSZ_INS_SD = 1523,
    SYSZ_INS_SDR = 1524,
    SYSZ_INS_SDTR = 1525,
    SYSZ_INS_SDTRA = 1526,
    SYSZ_INS_SE = 1527,
    SYSZ_INS_SER = 1528,
    SYSZ_INS_SFASR = 1529,
    SYSZ_INS_SFPC = 1530,
    SYSZ_INS_SGH = 1531,
    SYSZ_INS_SHHHR = 1532,
    SYSZ_INS_SHHLR = 1533,
    SYSZ_INS_SIE = 1534,
    SYSZ_INS_SIGA = 1535,
    SYSZ_INS_SIGP = 1536,
    SYSZ_INS_SLA = 1537,
    SYSZ_INS_SLAG = 1538,
    SYSZ_INS_SLAK = 1539,
    SYSZ_INS_SLDA = 1540,
    SYSZ_INS_SLDL = 1541,
    SYSZ_INS_SLDT = 1542,
    SYSZ_INS_SLHHHR = 1543,
    SYSZ_INS_SLHHLR = 1544,
    SYSZ_INS_SLXT = 1545,
    SYSZ_INS_SP = 1546,
    SYSZ_INS_SPCTR = 1547,
    SYSZ_INS_SPKA = 1548,
    SYSZ_INS_SPM = 1549,
    SYSZ_INS_SPT = 1550,
    SYSZ_INS_SPX = 1551,
    SYSZ_INS_SQD = 1552,
    SYSZ_INS_SQDR = 1553,
    SYSZ_INS_SQE = 1554,
    SYSZ_INS_SQER = 1555,
    SYSZ_INS_SQXR = 1556,
    SYSZ_INS_SRDA = 1557,
    SYSZ_INS_SRDL = 1558,
    SYSZ_INS_SRDT = 1559,
    SYSZ_INS_SRNM = 1560,
    SYSZ_INS_SRNMB = 1561,
    SYSZ_INS_SRNMT = 1562,
    SYSZ_INS_SRP = 1563,
    SYSZ_INS_SRSTU = 1564,
    SYSZ_INS_SRXT = 1565,
    SYSZ_INS_SSAIR = 1566,
    SYSZ_INS_SSAR = 1567,
    SYSZ_INS_SSCH = 1568,
    SYSZ_INS_SSKE = 1569,
    SYSZ_INS_SSM = 1570,
    SYSZ_INS_STAM = 1571,
    SYSZ_INS_STAMY = 1572,
    SYSZ_INS_STAP = 1573,
    SYSZ_INS_STCK = 1574,
    SYSZ_INS_STCKC = 1575,
    SYSZ_INS_STCKE = 1576,
    SYSZ_INS_STCKF = 1577,
    SYSZ_INS_STCM = 1578,
    SYSZ_INS_STCMH = 1579,
    SYSZ_INS_STCMY = 1580,
    SYSZ_INS_STCPS = 1581,
    SYSZ_INS_STCRW = 1582,
    SYSZ_INS_STCTG = 1583,
    SYSZ_INS_STCTL = 1584,
    SYSZ_INS_STFL = 1585,
    SYSZ_INS_STFLE = 1586,
    SYSZ_INS_STFPC = 1587,
    SYSZ_INS_STGSC = 1588,
    SYSZ_INS_STIDP = 1589,
    SYSZ_INS_STM = 1590,
    SYSZ_INS_STMH = 1591,
    SYSZ_INS_STMY = 1592,
    SYSZ_INS_STNSM = 1593,
    SYSZ_INS_STOCFH = 1594,
    SYSZ_INS_STOCFHE = 1595,
    SYSZ_INS_STOCFHH = 1596,
    SYSZ_INS_STOCFHHE = 1597,
    SYSZ_INS_STOCFHL = 1598,
    SYSZ_INS_STOCFHLE = 1599,
    SYSZ_INS_STOCFHLH = 1600,
    SYSZ_INS_STOCFHM = 1601,
    SYSZ_INS_STOCFHNE = 1602,
    SYSZ_INS_STOCFHNH = 1603,
    SYSZ_INS_STOCFHNHE = 1604,
    SYSZ_INS_STOCFHNL = 1605,
    SYSZ_INS_STOCFHNLE = 1606,
    SYSZ_INS_STOCFHNLH = 1607,
    SYSZ_INS_STOCFHNM = 1608,
    SYSZ_INS_STOCFHNO = 1609,
    SYSZ_INS_STOCFHNP = 1610,
    SYSZ_INS_STOCFHNZ = 1611,
    SYSZ_INS_STOCFHO = 1612,
    SYSZ_INS_STOCFHP = 1613,
    SYSZ_INS_STOCFHZ = 1614,
    SYSZ_INS_STOCGM = 1615,
    SYSZ_INS_STOCGNM = 1616,
    SYSZ_INS_STOCGNP = 1617,
    SYSZ_INS_STOCGNZ = 1618,
    SYSZ_INS_STOCGP = 1619,
    SYSZ_INS_STOCGZ = 1620,
    SYSZ_INS_STOCM = 1621,
    SYSZ_INS_STOCNM = 1622,
    SYSZ_INS_STOCNP = 1623,
    SYSZ_INS_STOCNZ = 1624,
    SYSZ_INS_STOCP = 1625,
    SYSZ_INS_STOCZ = 1626,
    SYSZ_INS_STOSM = 1627,
    SYSZ_INS_STPQ = 1628,
    SYSZ_INS_STPT = 1629,
    SYSZ_INS_STPX = 1630,
    SYSZ_INS_STRAG = 1631,
    SYSZ_INS_STRVH = 1632,
    SYSZ_INS_STSCH = 1633,
    SYSZ_INS_STSI = 1634,
    SYSZ_INS_STURA = 1635,
    SYSZ_INS_STURG = 1636,
    SYSZ_INS_SU = 1637,
    SYSZ_INS_SUR = 1638,
    SYSZ_INS_SVC = 1639,
    SYSZ_INS_SW = 1640,
    SYSZ_INS_SWR = 1641,
    SYSZ_INS_SXR = 1642,
    SYSZ_INS_SXTR = 1643,
    SYSZ_INS_SXTRA = 1644,
    SYSZ_INS_TABORT = 1645,
    SYSZ_INS_TAM = 1646,
    SYSZ_INS_TAR = 1647,
    SYSZ_INS_TB = 1648,
    SYSZ_INS_TBDR = 1649,
    SYSZ_INS_TBEDR = 1650,
    SYSZ_INS_TBEGIN = 1651,
    SYSZ_INS_TBEGINC = 1652,
    SYSZ_INS_TCDB = 1653,
    SYSZ_INS_TCEB = 1654,
    SYSZ_INS_TCXB = 1655,
    SYSZ_INS_TDCDT = 1656,
    SYSZ_INS_TDCET = 1657,
    SYSZ_INS_TDCXT = 1658,
    SYSZ_INS_TDGDT = 1659,
    SYSZ_INS_TDGET = 1660,
    SYSZ_INS_TDGXT = 1661,
    SYSZ_INS_TEND = 1662,
    SYSZ_INS_THDER = 1663,
    SYSZ_INS_THDR = 1664,
    SYSZ_INS_TP = 1665,
    SYSZ_INS_TPI = 1666,
    SYSZ_INS_TPROT = 1667,
    SYSZ_INS_TR = 1668,
    SYSZ_INS_TRACE = 1669,
    SYSZ_INS_TRACG = 1670,
    SYSZ_INS_TRAP2 = 1671,
    SYSZ_INS_TRAP4 = 1672,
    SYSZ_INS_TRE = 1673,
    SYSZ_INS_TROO = 1674,
    SYSZ_INS_TROT = 1675,
    SYSZ_INS_TRT = 1676,
    SYSZ_INS_TRTE = 1677,
    SYSZ_INS_TRTO = 1678,
    SYSZ_INS_TRTR = 1679,
    SYSZ_INS_TRTRE = 1680,
    SYSZ_INS_TRTT = 1681,
    SYSZ_INS_TS = 1682,
    SYSZ_INS_TSCH = 1683,
    SYSZ_INS_UNPK = 1684,
    SYSZ_INS_UNPKA = 1685,
    SYSZ_INS_UNPKU = 1686,
    SYSZ_INS_UPT = 1687,
    SYSZ_INS_VA = 1688,
    SYSZ_INS_VAB = 1689,
    SYSZ_INS_VAC = 1690,
    SYSZ_INS_VACC = 1691,
    SYSZ_INS_VACCB = 1692,
    SYSZ_INS_VACCC = 1693,
    SYSZ_INS_VACCCQ = 1694,
    SYSZ_INS_VACCF = 1695,
    SYSZ_INS_VACCG = 1696,
    SYSZ_INS_VACCH = 1697,
    SYSZ_INS_VACCQ = 1698,
    SYSZ_INS_VACQ = 1699,
    SYSZ_INS_VAF = 1700,
    SYSZ_INS_VAG = 1701,
    SYSZ_INS_VAH = 1702,
    SYSZ_INS_VAP = 1703,
    SYSZ_INS_VAQ = 1704,
    SYSZ_INS_VAVG = 1705,
    SYSZ_INS_VAVGB = 1706,
    SYSZ_INS_VAVGF = 1707,
    SYSZ_INS_VAVGG = 1708,
    SYSZ_INS_VAVGH = 1709,
    SYSZ_INS_VAVGL = 1710,
    SYSZ_INS_VAVGLB = 1711,
    SYSZ_INS_VAVGLF = 1712,
    SYSZ_INS_VAVGLG = 1713,
    SYSZ_INS_VAVGLH = 1714,
    SYSZ_INS_VBPERM = 1715,
    SYSZ_INS_VCDG = 1716,
    SYSZ_INS_VCDGB = 1717,
    SYSZ_INS_VCDLG = 1718,
    SYSZ_INS_VCDLGB = 1719,
    SYSZ_INS_VCEQ = 1720,
    SYSZ_INS_VCEQB = 1721,
    SYSZ_INS_VCEQBS = 1722,
    SYSZ_INS_VCEQF = 1723,
    SYSZ_INS_VCEQFS = 1724,
    SYSZ_INS_VCEQG = 1725,
    SYSZ_INS_VCEQGS = 1726,
    SYSZ_INS_VCEQH = 1727,
    SYSZ_INS_VCEQHS = 1728,
    SYSZ_INS_VCGD = 1729,
    SYSZ_INS_VCGDB = 1730,
    SYSZ_INS_VCH = 1731,
    SYSZ_INS_VCHB = 1732,
    SYSZ_INS_VCHBS = 1733,
    SYSZ_INS_VCHF = 1734,
    SYSZ_INS_VCHFS = 1735,
    SYSZ_INS_VCHG = 1736,
    SYSZ_INS_VCHGS = 1737,
    SYSZ_INS_VCHH = 1738,
    SYSZ_INS_VCHHS = 1739,
    SYSZ_INS_VCHL = 1740,
    SYSZ_INS_VCHLB = 1741,
    SYSZ_INS_VCHLBS = 1742,
    SYSZ_INS_VCHLF = 1743,
    SYSZ_INS_VCHLFS = 1744,
    SYSZ_INS_VCHLG = 1745,
    SYSZ_INS_VCHLGS = 1746,
    SYSZ_INS_VCHLH = 1747,
    SYSZ_INS_VCHLHS = 1748,
    SYSZ_INS_VCKSM = 1749,
    SYSZ_INS_VCLGD = 1750,
    SYSZ_INS_VCLGDB = 1751,
    SYSZ_INS_VCLZ = 1752,
    SYSZ_INS_VCLZB = 1753,
    SYSZ_INS_VCLZF = 1754,
    SYSZ_INS_VCLZG = 1755,
    SYSZ_INS_VCLZH = 1756,
    SYSZ_INS_VCP = 1757,
    SYSZ_INS_VCTZ = 1758,
    SYSZ_INS_VCTZB = 1759,
    SYSZ_INS_VCTZF = 1760,
    SYSZ_INS_VCTZG = 1761,
    SYSZ_INS_VCTZH = 1762,
    SYSZ_INS_VCVB = 1763,
    SYSZ_INS_VCVBG = 1764,
    SYSZ_INS_VCVD = 1765,
    SYSZ_INS_VCVDG = 1766,
    SYSZ_INS_VDP = 1767,
    SYSZ_INS_VEC = 1768,
    SYSZ_INS_VECB = 1769,
    SYSZ_INS_VECF = 1770,
    SYSZ_INS_VECG = 1771,
    SYSZ_INS_VECH = 1772,
    SYSZ_INS_VECL = 1773,
    SYSZ_INS_VECLB = 1774,
    SYSZ_INS_VECLF = 1775,
    SYSZ_INS_VECLG = 1776,
    SYSZ_INS_VECLH = 1777,
    SYSZ_INS_VERIM = 1778,
    SYSZ_INS_VERIMB = 1779,
    SYSZ_INS_VERIMF = 1780,
    SYSZ_INS_VERIMG = 1781,
    SYSZ_INS_VERIMH = 1782,
    SYSZ_INS_VERLL = 1783,
    SYSZ_INS_VERLLB = 1784,
    SYSZ_INS_VERLLF = 1785,
    SYSZ_INS_VERLLG = 1786,
    SYSZ_INS_VERLLH = 1787,
    SYSZ_INS_VERLLV = 1788,
    SYSZ_INS_VERLLVB = 1789,
    SYSZ_INS_VERLLVF = 1790,
    SYSZ_INS_VERLLVG = 1791,
    SYSZ_INS_VERLLVH = 1792,
    SYSZ_INS_VESL = 1793,
    SYSZ_INS_VESLB = 1794,
    SYSZ_INS_VESLF = 1795,
    SYSZ_INS_VESLG = 1796,
    SYSZ_INS_VESLH = 1797,
    SYSZ_INS_VESLV = 1798,
    SYSZ_INS_VESLVB = 1799,
    SYSZ_INS_VESLVF = 1800,
    SYSZ_INS_VESLVG = 1801,
    SYSZ_INS_VESLVH = 1802,
    SYSZ_INS_VESRA = 1803,
    SYSZ_INS_VESRAB = 1804,
    SYSZ_INS_VESRAF = 1805,
    SYSZ_INS_VESRAG = 1806,
    SYSZ_INS_VESRAH = 1807,
    SYSZ_INS_VESRAV = 1808,
    SYSZ_INS_VESRAVB = 1809,
    SYSZ_INS_VESRAVF = 1810,
    SYSZ_INS_VESRAVG = 1811,
    SYSZ_INS_VESRAVH = 1812,
    SYSZ_INS_VESRL = 1813,
    SYSZ_INS_VESRLB = 1814,
    SYSZ_INS_VESRLF = 1815,
    SYSZ_INS_VESRLG = 1816,
    SYSZ_INS_VESRLH = 1817,
    SYSZ_INS_VESRLV = 1818,
    SYSZ_INS_VESRLVB = 1819,
    SYSZ_INS_VESRLVF = 1820,
    SYSZ_INS_VESRLVG = 1821,
    SYSZ_INS_VESRLVH = 1822,
    SYSZ_INS_VFA = 1823,
    SYSZ_INS_VFADB = 1824,
    SYSZ_INS_VFAE = 1825,
    SYSZ_INS_VFAEB = 1826,
    SYSZ_INS_VFAEBS = 1827,
    SYSZ_INS_VFAEF = 1828,
    SYSZ_INS_VFAEFS = 1829,
    SYSZ_INS_VFAEH = 1830,
    SYSZ_INS_VFAEHS = 1831,
    SYSZ_INS_VFAEZB = 1832,
    SYSZ_INS_VFAEZBS = 1833,
    SYSZ_INS_VFAEZF = 1834,
    SYSZ_INS_VFAEZFS = 1835,
    SYSZ_INS_VFAEZH = 1836,
    SYSZ_INS_VFAEZHS = 1837,
    SYSZ_INS_VFASB = 1838,
    SYSZ_INS_VFCE = 1839,
    SYSZ_INS_VFCEDB = 1840,
    SYSZ_INS_VFCEDBS = 1841,
    SYSZ_INS_VFCESB = 1842,
    SYSZ_INS_VFCESBS = 1843,
    SYSZ_INS_VFCH = 1844,
    SYSZ_INS_VFCHDB = 1845,
    SYSZ_INS_VFCHDBS = 1846,
    SYSZ_INS_VFCHE = 1847,
    SYSZ_INS_VFCHEDB = 1848,
    SYSZ_INS_VFCHEDBS = 1849,
    SYSZ_INS_VFCHESB = 1850,
    SYSZ_INS_VFCHESBS = 1851,
    SYSZ_INS_VFCHSB = 1852,
    SYSZ_INS_VFCHSBS = 1853,
    SYSZ_INS_VFD = 1854,
    SYSZ_INS_VFDDB = 1855,
    SYSZ_INS_VFDSB = 1856,
    SYSZ_INS_VFEE = 1857,
    SYSZ_INS_VFEEB = 1858,
    SYSZ_INS_VFEEBS = 1859,
    SYSZ_INS_VFEEF = 1860,
    SYSZ_INS_VFEEFS = 1861,
    SYSZ_INS_VFEEH = 1862,
    SYSZ_INS_VFEEHS = 1863,
    SYSZ_INS_VFEEZB = 1864,
    SYSZ_INS_VFEEZBS = 1865,
    SYSZ_INS_VFEEZF = 1866,
    SYSZ_INS_VFEEZFS = 1867,
    SYSZ_INS_VFEEZH = 1868,
    SYSZ_INS_VFEEZHS = 1869,
    SYSZ_INS_VFENE = 1870,
    SYSZ_INS_VFENEB = 1871,
    SYSZ_INS_VFENEBS = 1872,
    SYSZ_INS_VFENEF = 1873,
    SYSZ_INS_VFENEFS = 1874,
    SYSZ_INS_VFENEH = 1875,
    SYSZ_INS_VFENEHS = 1876,
    SYSZ_INS_VFENEZB = 1877,
    SYSZ_INS_VFENEZBS = 1878,
    SYSZ_INS_VFENEZF = 1879,
    SYSZ_INS_VFENEZFS = 1880,
    SYSZ_INS_VFENEZH = 1881,
    SYSZ_INS_VFENEZHS = 1882,
    SYSZ_INS_VFI = 1883,
    SYSZ_INS_VFIDB = 1884,
    SYSZ_INS_VFISB = 1885,
    SYSZ_INS_VFKEDB = 1886,
    SYSZ_INS_VFKEDBS = 1887,
    SYSZ_INS_VFKESB = 1888,
    SYSZ_INS_VFKESBS = 1889,
    SYSZ_INS_VFKHDB = 1890,
    SYSZ_INS_VFKHDBS = 1891,
    SYSZ_INS_VFKHEDB = 1892,
    SYSZ_INS_VFKHEDBS = 1893,
    SYSZ_INS_VFKHESB = 1894,
    SYSZ_INS_VFKHESBS = 1895,
    SYSZ_INS_VFKHSB = 1896,
    SYSZ_INS_VFKHSBS = 1897,
    SYSZ_INS_VFLCDB = 1898,
    SYSZ_INS_VFLCSB = 1899,
    SYSZ_INS_VFLL = 1900,
    SYSZ_INS_VFLLS = 1901,
    SYSZ_INS_VFLNDB = 1902,
    SYSZ_INS_VFLNSB = 1903,
    SYSZ_INS_VFLPDB = 1904,
    SYSZ_INS_VFLPSB = 1905,
    SYSZ_INS_VFLR = 1906,
    SYSZ_INS_VFLRD = 1907,
    SYSZ_INS_VFM = 1908,
    SYSZ_INS_VFMA = 1909,
    SYSZ_INS_VFMADB = 1910,
    SYSZ_INS_VFMASB = 1911,
    SYSZ_INS_VFMAX = 1912,
    SYSZ_INS_VFMAXDB = 1913,
    SYSZ_INS_VFMAXSB = 1914,
    SYSZ_INS_VFMDB = 1915,
    SYSZ_INS_VFMIN = 1916,
    SYSZ_INS_VFMINDB = 1917,
    SYSZ_INS_VFMINSB = 1918,
    SYSZ_INS_VFMS = 1919,
    SYSZ_INS_VFMSB = 1920,
    SYSZ_INS_VFMSDB = 1921,
    SYSZ_INS_VFMSSB = 1922,
    SYSZ_INS_VFNMA = 1923,
    SYSZ_INS_VFNMADB = 1924,
    SYSZ_INS_VFNMASB = 1925,
    SYSZ_INS_VFNMS = 1926,
    SYSZ_INS_VFNMSDB = 1927,
    SYSZ_INS_VFNMSSB = 1928,
    SYSZ_INS_VFPSO = 1929,
    SYSZ_INS_VFPSODB = 1930,
    SYSZ_INS_VFPSOSB = 1931,
    SYSZ_INS_VFS = 1932,
    SYSZ_INS_VFSDB = 1933,
    SYSZ_INS_VFSQ = 1934,
    SYSZ_INS_VFSQDB = 1935,
    SYSZ_INS_VFSQSB = 1936,
    SYSZ_INS_VFSSB = 1937,
    SYSZ_INS_VFTCI = 1938,
    SYSZ_INS_VFTCIDB = 1939,
    SYSZ_INS_VFTCISB = 1940,
    SYSZ_INS_VGBM = 1941,
    SYSZ_INS_VGEF = 1942,
    SYSZ_INS_VGEG = 1943,
    SYSZ_INS_VGFM = 1944,
    SYSZ_INS_VGFMA = 1945,
    SYSZ_INS_VGFMAB = 1946,
    SYSZ_INS_VGFMAF = 1947,
    SYSZ_INS_VGFMAG = 1948,
    SYSZ_INS_VGFMAH = 1949,
    SYSZ_INS_VGFMB = 1950,
    SYSZ_INS_VGFMF = 1951,
    SYSZ_INS_VGFMG = 1952,
    SYSZ_INS_VGFMH = 1953,
    SYSZ_INS_VGM = 1954,
    SYSZ_INS_VGMB = 1955,
    SYSZ_INS_VGMF = 1956,
    SYSZ_INS_VGMG = 1957,
    SYSZ_INS_VGMH = 1958,
    SYSZ_INS_VISTR = 1959,
    SYSZ_INS_VISTRB = 1960,
    SYSZ_INS_VISTRBS = 1961,
    SYSZ_INS_VISTRF = 1962,
    SYSZ_INS_VISTRFS = 1963,
    SYSZ_INS_VISTRH = 1964,
    SYSZ_INS_VISTRHS = 1965,
    SYSZ_INS_VL = 1966,
    SYSZ_INS_VLBB = 1967,
    SYSZ_INS_VLC = 1968,
    SYSZ_INS_VLCB = 1969,
    SYSZ_INS_VLCF = 1970,
    SYSZ_INS_VLCG = 1971,
    SYSZ_INS_VLCH = 1972,
    SYSZ_INS_VLDE = 1973,
    SYSZ_INS_VLDEB = 1974,
    SYSZ_INS_VLEB = 1975,
    SYSZ_INS_VLED = 1976,
    SYSZ_INS_VLEDB = 1977,
    SYSZ_INS_VLEF = 1978,
    SYSZ_INS_VLEG = 1979,
    SYSZ_INS_VLEH = 1980,
    SYSZ_INS_VLEIB = 1981,
    SYSZ_INS_VLEIF = 1982,
    SYSZ_INS_VLEIG = 1983,
    SYSZ_INS_VLEIH = 1984,
    SYSZ_INS_VLGV = 1985,
    SYSZ_INS_VLGVB = 1986,
    SYSZ_INS_VLGVF = 1987,
    SYSZ_INS_VLGVG = 1988,
    SYSZ_INS_VLGVH = 1989,
    SYSZ_INS_VLIP = 1990,
    SYSZ_INS_VLL = 1991,
    SYSZ_INS_VLLEZ = 1992,
    SYSZ_INS_VLLEZB = 1993,
    SYSZ_INS_VLLEZF = 1994,
    SYSZ_INS_VLLEZG = 1995,
    SYSZ_INS_VLLEZH = 1996,
    SYSZ_INS_VLLEZLF = 1997,
    SYSZ_INS_VLM = 1998,
    SYSZ_INS_VLP = 1999,
    SYSZ_INS_VLPB = 2000,
    SYSZ_INS_VLPF = 2001,
    SYSZ_INS_VLPG = 2002,
    SYSZ_INS_VLPH = 2003,
    SYSZ_INS_VLR = 2004,
    SYSZ_INS_VLREP = 2005,
    SYSZ_INS_VLREPB = 2006,
    SYSZ_INS_VLREPF = 2007,
    SYSZ_INS_VLREPG = 2008,
    SYSZ_INS_VLREPH = 2009,
    SYSZ_INS_VLRL = 2010,
    SYSZ_INS_VLRLR = 2011,
    SYSZ_INS_VLVG = 2012,
    SYSZ_INS_VLVGB = 2013,
    SYSZ_INS_VLVGF = 2014,
    SYSZ_INS_VLVGG = 2015,
    SYSZ_INS_VLVGH = 2016,
    SYSZ_INS_VLVGP = 2017,
    SYSZ_INS_VMAE = 2018,
    SYSZ_INS_VMAEB = 2019,
    SYSZ_INS_VMAEF = 2020,
    SYSZ_INS_VMAEH = 2021,
    SYSZ_INS_VMAH = 2022,
    SYSZ_INS_VMAHB = 2023,
    SYSZ_INS_VMAHF = 2024,
    SYSZ_INS_VMAHH = 2025,
    SYSZ_INS_VMAL = 2026,
    SYSZ_INS_VMALB = 2027,
    SYSZ_INS_VMALE = 2028,
    SYSZ_INS_VMALEB = 2029,
    SYSZ_INS_VMALEF = 2030,
    SYSZ_INS_VMALEH = 2031,
    SYSZ_INS_VMALF = 2032,
    SYSZ_INS_VMALH = 2033,
    SYSZ_INS_VMALHB = 2034,
    SYSZ_INS_VMALHF = 2035,
    SYSZ_INS_VMALHH = 2036,
    SYSZ_INS_VMALHW = 2037,
    SYSZ_INS_VMALO = 2038,
    SYSZ_INS_VMALOB = 2039,
    SYSZ_INS_VMALOF = 2040,
    SYSZ_INS_VMALOH = 2041,
    SYSZ_INS_VMAO = 2042,
    SYSZ_INS_VMAOB = 2043,
    SYSZ_INS_VMAOF = 2044,
    SYSZ_INS_VMAOH = 2045,
    SYSZ_INS_VME = 2046,
    SYSZ_INS_VMEB = 2047,
    SYSZ_INS_VMEF = 2048,
    SYSZ_INS_VMEH = 2049,
    SYSZ_INS_VMH = 2050,
    SYSZ_INS_VMHB = 2051,
    SYSZ_INS_VMHF = 2052,
    SYSZ_INS_VMHH = 2053,
    SYSZ_INS_VML = 2054,
    SYSZ_INS_VMLB = 2055,
    SYSZ_INS_VMLE = 2056,
    SYSZ_INS_VMLEB = 2057,
    SYSZ_INS_VMLEF = 2058,
    SYSZ_INS_VMLEH = 2059,
    SYSZ_INS_VMLF = 2060,
    SYSZ_INS_VMLH = 2061,
    SYSZ_INS_VMLHB = 2062,
    SYSZ_INS_VMLHF = 2063,
    SYSZ_INS_VMLHH = 2064,
    SYSZ_INS_VMLHW = 2065,
    SYSZ_INS_VMLO = 2066,
    SYSZ_INS_VMLOB = 2067,
    SYSZ_INS_VMLOF = 2068,
    SYSZ_INS_VMLOH = 2069,
    SYSZ_INS_VMN = 2070,
    SYSZ_INS_VMNB = 2071,
    SYSZ_INS_VMNF = 2072,
    SYSZ_INS_VMNG = 2073,
    SYSZ_INS_VMNH = 2074,
    SYSZ_INS_VMNL = 2075,
    SYSZ_INS_VMNLB = 2076,
    SYSZ_INS_VMNLF = 2077,
    SYSZ_INS_VMNLG = 2078,
    SYSZ_INS_VMNLH = 2079,
    SYSZ_INS_VMO = 2080,
    SYSZ_INS_VMOB = 2081,
    SYSZ_INS_VMOF = 2082,
    SYSZ_INS_VMOH = 2083,
    SYSZ_INS_VMP = 2084,
    SYSZ_INS_VMRH = 2085,
    SYSZ_INS_VMRHB = 2086,
    SYSZ_INS_VMRHF = 2087,
    SYSZ_INS_VMRHG = 2088,
    SYSZ_INS_VMRHH = 2089,
    SYSZ_INS_VMRL = 2090,
    SYSZ_INS_VMRLB = 2091,
    SYSZ_INS_VMRLF = 2092,
    SYSZ_INS_VMRLG = 2093,
    SYSZ_INS_VMRLH = 2094,
    SYSZ_INS_VMSL = 2095,
    SYSZ_INS_VMSLG = 2096,
    SYSZ_INS_VMSP = 2097,
    SYSZ_INS_VMX = 2098,
    SYSZ_INS_VMXB = 2099,
    SYSZ_INS_VMXF = 2100,
    SYSZ_INS_VMXG = 2101,
    SYSZ_INS_VMXH = 2102,
    SYSZ_INS_VMXL = 2103,
    SYSZ_INS_VMXLB = 2104,
    SYSZ_INS_VMXLF = 2105,
    SYSZ_INS_VMXLG = 2106,
    SYSZ_INS_VMXLH = 2107,
    SYSZ_INS_VN = 2108,
    SYSZ_INS_VNC = 2109,
    SYSZ_INS_VNN = 2110,
    SYSZ_INS_VNO = 2111,
    SYSZ_INS_VNX = 2112,
    SYSZ_INS_VO = 2113,
    SYSZ_INS_VOC = 2114,
    SYSZ_INS_VONE = 2115,
    SYSZ_INS_VPDI = 2116,
    SYSZ_INS_VPERM = 2117,
    SYSZ_INS_VPK = 2118,
    SYSZ_INS_VPKF = 2119,
    SYSZ_INS_VPKG = 2120,
    SYSZ_INS_VPKH = 2121,
    SYSZ_INS_VPKLS = 2122,
    SYSZ_INS_VPKLSF = 2123,
    SYSZ_INS_VPKLSFS = 2124,
    SYSZ_INS_VPKLSG = 2125,
    SYSZ_INS_VPKLSGS = 2126,
    SYSZ_INS_VPKLSH = 2127,
    SYSZ_INS_VPKLSHS = 2128,
    SYSZ_INS_VPKS = 2129,
    SYSZ_INS_VPKSF = 2130,
    SYSZ_INS_VPKSFS = 2131,
    SYSZ_INS_VPKSG = 2132,
    SYSZ_INS_VPKSGS = 2133,
    SYSZ_INS_VPKSH = 2134,
    SYSZ_INS_VPKSHS = 2135,
    SYSZ_INS_VPKZ = 2136,
    SYSZ_INS_VPOPCT = 2137,
    SYSZ_INS_VPOPCTB = 2138,
    SYSZ_INS_VPOPCTF = 2139,
    SYSZ_INS_VPOPCTG = 2140,
    SYSZ_INS_VPOPCTH = 2141,
    SYSZ_INS_VPSOP = 2142,
    SYSZ_INS_VREP = 2143,
    SYSZ_INS_VREPB = 2144,
    SYSZ_INS_VREPF = 2145,
    SYSZ_INS_VREPG = 2146,
    SYSZ_INS_VREPH = 2147,
    SYSZ_INS_VREPI = 2148,
    SYSZ_INS_VREPIB = 2149,
    SYSZ_INS_VREPIF = 2150,
    SYSZ_INS_VREPIG = 2151,
    SYSZ_INS_VREPIH = 2152,
    SYSZ_INS_VRP = 2153,
    SYSZ_INS_VS = 2154,
    SYSZ_INS_VSB = 2155,
    SYSZ_INS_VSBCBI = 2156,
    SYSZ_INS_VSBCBIQ = 2157,
    SYSZ_INS_VSBI = 2158,
    SYSZ_INS_VSBIQ = 2159,
    SYSZ_INS_VSCBI = 2160,
    SYSZ_INS_VSCBIB = 2161,
    SYSZ_INS_VSCBIF = 2162,
    SYSZ_INS_VSCBIG = 2163,
    SYSZ_INS_VSCBIH = 2164,
    SYSZ_INS_VSCBIQ = 2165,
    SYSZ_INS_VSCEF = 2166,
    SYSZ_INS_VSCEG = 2167,
    SYSZ_INS_VSDP = 2168,
    SYSZ_INS_VSEG = 2169,
    SYSZ_INS_VSEGB = 2170,
    SYSZ_INS_VSEGF = 2171,
    SYSZ_INS_VSEGH = 2172,
    SYSZ_INS_VSEL = 2173,
    SYSZ_INS_VSF = 2174,
    SYSZ_INS_VSG = 2175,
    SYSZ_INS_VSH = 2176,
    SYSZ_INS_VSL = 2177,
    SYSZ_INS_VSLB = 2178,
    SYSZ_INS_VSLDB = 2179,
    SYSZ_INS_VSP = 2180,
    SYSZ_INS_VSQ = 2181,
    SYSZ_INS_VSRA = 2182,
    SYSZ_INS_VSRAB = 2183,
    SYSZ_INS_VSRL = 2184,
    SYSZ_INS_VSRLB = 2185,
    SYSZ_INS_VSRP = 2186,
    SYSZ_INS_VST = 2187,
    SYSZ_INS_VSTEB = 2188,
    SYSZ_INS_VSTEF = 2189,
    SYSZ_INS_VSTEG = 2190,
    SYSZ_INS_VSTEH = 2191,
    SYSZ_INS_VSTL = 2192,
    SYSZ_INS_VSTM = 2193,
    SYSZ_INS_VSTRC = 2194,
    SYSZ_INS_VSTRCB = 2195,
    SYSZ_INS_VSTRCBS = 2196,
    SYSZ_INS_VSTRCF = 2197,
    SYSZ_INS_VSTRCFS = 2198,
    SYSZ_INS_VSTRCH = 2199,
    SYSZ_INS_VSTRCHS = 2200,
    SYSZ_INS_VSTRCZB = 2201,
    SYSZ_INS_VSTRCZBS = 2202,
    SYSZ_INS_VSTRCZF = 2203,
    SYSZ_INS_VSTRCZFS = 2204,
    SYSZ_INS_VSTRCZH = 2205,
    SYSZ_INS_VSTRCZHS = 2206,
    SYSZ_INS_VSTRL = 2207,
    SYSZ_INS_VSTRLR = 2208,
    SYSZ_INS_VSUM = 2209,
    SYSZ_INS_VSUMB = 2210,
    SYSZ_INS_VSUMG = 2211,
    SYSZ_INS_VSUMGF = 2212,
    SYSZ_INS_VSUMGH = 2213,
    SYSZ_INS_VSUMH = 2214,
    SYSZ_INS_VSUMQ = 2215,
    SYSZ_INS_VSUMQF = 2216,
    SYSZ_INS_VSUMQG = 2217,
    SYSZ_INS_VTM = 2218,
    SYSZ_INS_VTP = 2219,
    SYSZ_INS_VUPH = 2220,
    SYSZ_INS_VUPHB = 2221,
    SYSZ_INS_VUPHF = 2222,
    SYSZ_INS_VUPHH = 2223,
    SYSZ_INS_VUPKZ = 2224,
    SYSZ_INS_VUPL = 2225,
    SYSZ_INS_VUPLB = 2226,
    SYSZ_INS_VUPLF = 2227,
    SYSZ_INS_VUPLH = 2228,
    SYSZ_INS_VUPLHB = 2229,
    SYSZ_INS_VUPLHF = 2230,
    SYSZ_INS_VUPLHH = 2231,
    SYSZ_INS_VUPLHW = 2232,
    SYSZ_INS_VUPLL = 2233,
    SYSZ_INS_VUPLLB = 2234,
    SYSZ_INS_VUPLLF = 2235,
    SYSZ_INS_VUPLLH = 2236,
    SYSZ_INS_VX = 2237,
    SYSZ_INS_VZERO = 2238,
    SYSZ_INS_WCDGB = 2239,
    SYSZ_INS_WCDLGB = 2240,
    SYSZ_INS_WCGDB = 2241,
    SYSZ_INS_WCLGDB = 2242,
    SYSZ_INS_WFADB = 2243,
    SYSZ_INS_WFASB = 2244,
    SYSZ_INS_WFAXB = 2245,
    SYSZ_INS_WFC = 2246,
    SYSZ_INS_WFCDB = 2247,
    SYSZ_INS_WFCEDB = 2248,
    SYSZ_INS_WFCEDBS = 2249,
    SYSZ_INS_WFCESB = 2250,
    SYSZ_INS_WFCESBS = 2251,
    SYSZ_INS_WFCEXB = 2252,
    SYSZ_INS_WFCEXBS = 2253,
    SYSZ_INS_WFCHDB = 2254,
    SYSZ_INS_WFCHDBS = 2255,
    SYSZ_INS_WFCHEDB = 2256,
    SYSZ_INS_WFCHEDBS = 2257,
    SYSZ_INS_WFCHESB = 2258,
    SYSZ_INS_WFCHESBS = 2259,
    SYSZ_INS_WFCHEXB = 2260,
    SYSZ_INS_WFCHEXBS = 2261,
    SYSZ_INS_WFCHSB = 2262,
    SYSZ_INS_WFCHSBS = 2263,
    SYSZ_INS_WFCHXB = 2264,
    SYSZ_INS_WFCHXBS = 2265,
    SYSZ_INS_WFCSB = 2266,
    SYSZ_INS_WFCXB = 2267,
    SYSZ_INS_WFDDB = 2268,
    SYSZ_INS_WFDSB = 2269,
    SYSZ_INS_WFDXB = 2270,
    SYSZ_INS_WFIDB = 2271,
    SYSZ_INS_WFISB = 2272,
    SYSZ_INS_WFIXB = 2273,
    SYSZ_INS_WFK = 2274,
    SYSZ_INS_WFKDB = 2275,
    SYSZ_INS_WFKEDB = 2276,
    SYSZ_INS_WFKEDBS = 2277,
    SYSZ_INS_WFKESB = 2278,
    SYSZ_INS_WFKESBS = 2279,
    SYSZ_INS_WFKEXB = 2280,
    SYSZ_INS_WFKEXBS = 2281,
    SYSZ_INS_WFKHDB = 2282,
    SYSZ_INS_WFKHDBS = 2283,
    SYSZ_INS_WFKHEDB = 2284,
    SYSZ_INS_WFKHEDBS = 2285,
    SYSZ_INS_WFKHESB = 2286,
    SYSZ_INS_WFKHESBS = 2287,
    SYSZ_INS_WFKHEXB = 2288,
    SYSZ_INS_WFKHEXBS = 2289,
    SYSZ_INS_WFKHSB = 2290,
    SYSZ_INS_WFKHSBS = 2291,
    SYSZ_INS_WFKHXB = 2292,
    SYSZ_INS_WFKHXBS = 2293,
    SYSZ_INS_WFKSB = 2294,
    SYSZ_INS_WFKXB = 2295,
    SYSZ_INS_WFLCDB = 2296,
    SYSZ_INS_WFLCSB = 2297,
    SYSZ_INS_WFLCXB = 2298,
    SYSZ_INS_WFLLD = 2299,
    SYSZ_INS_WFLLS = 2300,
    SYSZ_INS_WFLNDB = 2301,
    SYSZ_INS_WFLNSB = 2302,
    SYSZ_INS_WFLNXB = 2303,
    SYSZ_INS_WFLPDB = 2304,
    SYSZ_INS_WFLPSB = 2305,
    SYSZ_INS_WFLPXB = 2306,
    SYSZ_INS_WFLRD = 2307,
    SYSZ_INS_WFLRX = 2308,
    SYSZ_INS_WFMADB = 2309,
    SYSZ_INS_WFMASB = 2310,
    SYSZ_INS_WFMAXB = 2311,
    SYSZ_INS_WFMAXDB = 2312,
    SYSZ_INS_WFMAXSB = 2313,
    SYSZ_INS_WFMAXXB = 2314,
    SYSZ_INS_WFMDB = 2315,
    SYSZ_INS_WFMINDB = 2316,
    SYSZ_INS_WFMINSB = 2317,
    SYSZ_INS_WFMINXB = 2318,
    SYSZ_INS_WFMSB = 2319,
    SYSZ_INS_WFMSDB = 2320,
    SYSZ_INS_WFMSSB = 2321,
    SYSZ_INS_WFMSXB = 2322,
    SYSZ_INS_WFMXB = 2323,
    SYSZ_INS_WFNMADB = 2324,
    SYSZ_INS_WFNMASB = 2325,
    SYSZ_INS_WFNMAXB = 2326,
    SYSZ_INS_WFNMSDB = 2327,
    SYSZ_INS_WFNMSSB = 2328,
    SYSZ_INS_WFNMSXB = 2329,
    SYSZ_INS_WFPSODB = 2330,
    SYSZ_INS_WFPSOSB = 2331,
    SYSZ_INS_WFPSOXB = 2332,
    SYSZ_INS_WFSDB = 2333,
    SYSZ_INS_WFSQDB = 2334,
    SYSZ_INS_WFSQSB = 2335,
    SYSZ_INS_WFSQXB = 2336,
    SYSZ_INS_WFSSB = 2337,
    SYSZ_INS_WFSXB = 2338,
    SYSZ_INS_WFTCIDB = 2339,
    SYSZ_INS_WFTCISB = 2340,
    SYSZ_INS_WFTCIXB = 2341,
    SYSZ_INS_WLDEB = 2342,
    SYSZ_INS_WLEDB = 2343,
    SYSZ_INS_XSCH = 2344,
    SYSZ_INS_ZAP = 2345,
    SYSZ_INS_ENDING = 2346,
}
pub mod sysz_insn_group {
    #[doc = " Group of SystemZ instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const SYSZ_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const SYSZ_GRP_JUMP: Type = 1;
    pub const SYSZ_GRP_DISTINCTOPS: Type = 128;
    pub const SYSZ_GRP_FPEXTENSION: Type = 129;
    pub const SYSZ_GRP_HIGHWORD: Type = 130;
    pub const SYSZ_GRP_INTERLOCKEDACCESS1: Type = 131;
    pub const SYSZ_GRP_LOADSTOREONCOND: Type = 132;
    pub const SYSZ_GRP_DFPPACKEDCONVERSION: Type = 133;
    pub const SYSZ_GRP_DFPZONEDCONVERSION: Type = 134;
    pub const SYSZ_GRP_ENHANCEDDAT2: Type = 135;
    pub const SYSZ_GRP_EXECUTIONHINT: Type = 136;
    pub const SYSZ_GRP_GUARDEDSTORAGE: Type = 137;
    pub const SYSZ_GRP_INSERTREFERENCEBITSMULTIPLE: Type = 138;
    pub const SYSZ_GRP_LOADANDTRAP: Type = 139;
    pub const SYSZ_GRP_LOADANDZERORIGHTMOSTBYTE: Type = 140;
    pub const SYSZ_GRP_LOADSTOREONCOND2: Type = 141;
    pub const SYSZ_GRP_MESSAGESECURITYASSIST3: Type = 142;
    pub const SYSZ_GRP_MESSAGESECURITYASSIST4: Type = 143;
    pub const SYSZ_GRP_MESSAGESECURITYASSIST5: Type = 144;
    pub const SYSZ_GRP_MESSAGESECURITYASSIST7: Type = 145;
    pub const SYSZ_GRP_MESSAGESECURITYASSIST8: Type = 146;
    pub const SYSZ_GRP_MISCELLANEOUSEXTENSIONS: Type = 147;
    pub const SYSZ_GRP_MISCELLANEOUSEXTENSIONS2: Type = 148;
    pub const SYSZ_GRP_NOVECTOR: Type = 149;
    pub const SYSZ_GRP_POPULATIONCOUNT: Type = 150;
    pub const SYSZ_GRP_PROCESSORASSIST: Type = 151;
    pub const SYSZ_GRP_RESETREFERENCEBITSMULTIPLE: Type = 152;
    pub const SYSZ_GRP_TRANSACTIONALEXECUTION: Type = 153;
    pub const SYSZ_GRP_VECTOR: Type = 154;
    pub const SYSZ_GRP_VECTORENHANCEMENTS1: Type = 155;
    pub const SYSZ_GRP_VECTORPACKEDDECIMAL: Type = 156;
    pub const SYSZ_GRP_ENDING: Type = 157;
}
pub mod x86_reg {
    #[doc = " X86 registers"]
    pub type Type = libc::c_uint;
    pub const X86_REG_INVALID: Type = 0;
    pub const X86_REG_AH: Type = 1;
    pub const X86_REG_AL: Type = 2;
    pub const X86_REG_AX: Type = 3;
    pub const X86_REG_BH: Type = 4;
    pub const X86_REG_BL: Type = 5;
    pub const X86_REG_BP: Type = 6;
    pub const X86_REG_BPL: Type = 7;
    pub const X86_REG_BX: Type = 8;
    pub const X86_REG_CH: Type = 9;
    pub const X86_REG_CL: Type = 10;
    pub const X86_REG_CS: Type = 11;
    pub const X86_REG_CX: Type = 12;
    pub const X86_REG_DH: Type = 13;
    pub const X86_REG_DI: Type = 14;
    pub const X86_REG_DIL: Type = 15;
    pub const X86_REG_DL: Type = 16;
    pub const X86_REG_DS: Type = 17;
    pub const X86_REG_DX: Type = 18;
    pub const X86_REG_EAX: Type = 19;
    pub const X86_REG_EBP: Type = 20;
    pub const X86_REG_EBX: Type = 21;
    pub const X86_REG_ECX: Type = 22;
    pub const X86_REG_EDI: Type = 23;
    pub const X86_REG_EDX: Type = 24;
    pub const X86_REG_EFLAGS: Type = 25;
    pub const X86_REG_EIP: Type = 26;
    pub const X86_REG_EIZ: Type = 27;
    pub const X86_REG_ES: Type = 28;
    pub const X86_REG_ESI: Type = 29;
    pub const X86_REG_ESP: Type = 30;
    pub const X86_REG_FPSW: Type = 31;
    pub const X86_REG_FS: Type = 32;
    pub const X86_REG_GS: Type = 33;
    pub const X86_REG_IP: Type = 34;
    pub const X86_REG_RAX: Type = 35;
    pub const X86_REG_RBP: Type = 36;
    pub const X86_REG_RBX: Type = 37;
    pub const X86_REG_RCX: Type = 38;
    pub const X86_REG_RDI: Type = 39;
    pub const X86_REG_RDX: Type = 40;
    pub const X86_REG_RIP: Type = 41;
    pub const X86_REG_RIZ: Type = 42;
    pub const X86_REG_RSI: Type = 43;
    pub const X86_REG_RSP: Type = 44;
    pub const X86_REG_SI: Type = 45;
    pub const X86_REG_SIL: Type = 46;
    pub const X86_REG_SP: Type = 47;
    pub const X86_REG_SPL: Type = 48;
    pub const X86_REG_SS: Type = 49;
    pub const X86_REG_CR0: Type = 50;
    pub const X86_REG_CR1: Type = 51;
    pub const X86_REG_CR2: Type = 52;
    pub const X86_REG_CR3: Type = 53;
    pub const X86_REG_CR4: Type = 54;
    pub const X86_REG_CR5: Type = 55;
    pub const X86_REG_CR6: Type = 56;
    pub const X86_REG_CR7: Type = 57;
    pub const X86_REG_CR8: Type = 58;
    pub const X86_REG_CR9: Type = 59;
    pub const X86_REG_CR10: Type = 60;
    pub const X86_REG_CR11: Type = 61;
    pub const X86_REG_CR12: Type = 62;
    pub const X86_REG_CR13: Type = 63;
    pub const X86_REG_CR14: Type = 64;
    pub const X86_REG_CR15: Type = 65;
    pub const X86_REG_DR0: Type = 66;
    pub const X86_REG_DR1: Type = 67;
    pub const X86_REG_DR2: Type = 68;
    pub const X86_REG_DR3: Type = 69;
    pub const X86_REG_DR4: Type = 70;
    pub const X86_REG_DR5: Type = 71;
    pub const X86_REG_DR6: Type = 72;
    pub const X86_REG_DR7: Type = 73;
    pub const X86_REG_DR8: Type = 74;
    pub const X86_REG_DR9: Type = 75;
    pub const X86_REG_DR10: Type = 76;
    pub const X86_REG_DR11: Type = 77;
    pub const X86_REG_DR12: Type = 78;
    pub const X86_REG_DR13: Type = 79;
    pub const X86_REG_DR14: Type = 80;
    pub const X86_REG_DR15: Type = 81;
    pub const X86_REG_FP0: Type = 82;
    pub const X86_REG_FP1: Type = 83;
    pub const X86_REG_FP2: Type = 84;
    pub const X86_REG_FP3: Type = 85;
    pub const X86_REG_FP4: Type = 86;
    pub const X86_REG_FP5: Type = 87;
    pub const X86_REG_FP6: Type = 88;
    pub const X86_REG_FP7: Type = 89;
    pub const X86_REG_K0: Type = 90;
    pub const X86_REG_K1: Type = 91;
    pub const X86_REG_K2: Type = 92;
    pub const X86_REG_K3: Type = 93;
    pub const X86_REG_K4: Type = 94;
    pub const X86_REG_K5: Type = 95;
    pub const X86_REG_K6: Type = 96;
    pub const X86_REG_K7: Type = 97;
    pub const X86_REG_MM0: Type = 98;
    pub const X86_REG_MM1: Type = 99;
    pub const X86_REG_MM2: Type = 100;
    pub const X86_REG_MM3: Type = 101;
    pub const X86_REG_MM4: Type = 102;
    pub const X86_REG_MM5: Type = 103;
    pub const X86_REG_MM6: Type = 104;
    pub const X86_REG_MM7: Type = 105;
    pub const X86_REG_R8: Type = 106;
    pub const X86_REG_R9: Type = 107;
    pub const X86_REG_R10: Type = 108;
    pub const X86_REG_R11: Type = 109;
    pub const X86_REG_R12: Type = 110;
    pub const X86_REG_R13: Type = 111;
    pub const X86_REG_R14: Type = 112;
    pub const X86_REG_R15: Type = 113;
    pub const X86_REG_ST0: Type = 114;
    pub const X86_REG_ST1: Type = 115;
    pub const X86_REG_ST2: Type = 116;
    pub const X86_REG_ST3: Type = 117;
    pub const X86_REG_ST4: Type = 118;
    pub const X86_REG_ST5: Type = 119;
    pub const X86_REG_ST6: Type = 120;
    pub const X86_REG_ST7: Type = 121;
    pub const X86_REG_XMM0: Type = 122;
    pub const X86_REG_XMM1: Type = 123;
    pub const X86_REG_XMM2: Type = 124;
    pub const X86_REG_XMM3: Type = 125;
    pub const X86_REG_XMM4: Type = 126;
    pub const X86_REG_XMM5: Type = 127;
    pub const X86_REG_XMM6: Type = 128;
    pub const X86_REG_XMM7: Type = 129;
    pub const X86_REG_XMM8: Type = 130;
    pub const X86_REG_XMM9: Type = 131;
    pub const X86_REG_XMM10: Type = 132;
    pub const X86_REG_XMM11: Type = 133;
    pub const X86_REG_XMM12: Type = 134;
    pub const X86_REG_XMM13: Type = 135;
    pub const X86_REG_XMM14: Type = 136;
    pub const X86_REG_XMM15: Type = 137;
    pub const X86_REG_XMM16: Type = 138;
    pub const X86_REG_XMM17: Type = 139;
    pub const X86_REG_XMM18: Type = 140;
    pub const X86_REG_XMM19: Type = 141;
    pub const X86_REG_XMM20: Type = 142;
    pub const X86_REG_XMM21: Type = 143;
    pub const X86_REG_XMM22: Type = 144;
    pub const X86_REG_XMM23: Type = 145;
    pub const X86_REG_XMM24: Type = 146;
    pub const X86_REG_XMM25: Type = 147;
    pub const X86_REG_XMM26: Type = 148;
    pub const X86_REG_XMM27: Type = 149;
    pub const X86_REG_XMM28: Type = 150;
    pub const X86_REG_XMM29: Type = 151;
    pub const X86_REG_XMM30: Type = 152;
    pub const X86_REG_XMM31: Type = 153;
    pub const X86_REG_YMM0: Type = 154;
    pub const X86_REG_YMM1: Type = 155;
    pub const X86_REG_YMM2: Type = 156;
    pub const X86_REG_YMM3: Type = 157;
    pub const X86_REG_YMM4: Type = 158;
    pub const X86_REG_YMM5: Type = 159;
    pub const X86_REG_YMM6: Type = 160;
    pub const X86_REG_YMM7: Type = 161;
    pub const X86_REG_YMM8: Type = 162;
    pub const X86_REG_YMM9: Type = 163;
    pub const X86_REG_YMM10: Type = 164;
    pub const X86_REG_YMM11: Type = 165;
    pub const X86_REG_YMM12: Type = 166;
    pub const X86_REG_YMM13: Type = 167;
    pub const X86_REG_YMM14: Type = 168;
    pub const X86_REG_YMM15: Type = 169;
    pub const X86_REG_YMM16: Type = 170;
    pub const X86_REG_YMM17: Type = 171;
    pub const X86_REG_YMM18: Type = 172;
    pub const X86_REG_YMM19: Type = 173;
    pub const X86_REG_YMM20: Type = 174;
    pub const X86_REG_YMM21: Type = 175;
    pub const X86_REG_YMM22: Type = 176;
    pub const X86_REG_YMM23: Type = 177;
    pub const X86_REG_YMM24: Type = 178;
    pub const X86_REG_YMM25: Type = 179;
    pub const X86_REG_YMM26: Type = 180;
    pub const X86_REG_YMM27: Type = 181;
    pub const X86_REG_YMM28: Type = 182;
    pub const X86_REG_YMM29: Type = 183;
    pub const X86_REG_YMM30: Type = 184;
    pub const X86_REG_YMM31: Type = 185;
    pub const X86_REG_ZMM0: Type = 186;
    pub const X86_REG_ZMM1: Type = 187;
    pub const X86_REG_ZMM2: Type = 188;
    pub const X86_REG_ZMM3: Type = 189;
    pub const X86_REG_ZMM4: Type = 190;
    pub const X86_REG_ZMM5: Type = 191;
    pub const X86_REG_ZMM6: Type = 192;
    pub const X86_REG_ZMM7: Type = 193;
    pub const X86_REG_ZMM8: Type = 194;
    pub const X86_REG_ZMM9: Type = 195;
    pub const X86_REG_ZMM10: Type = 196;
    pub const X86_REG_ZMM11: Type = 197;
    pub const X86_REG_ZMM12: Type = 198;
    pub const X86_REG_ZMM13: Type = 199;
    pub const X86_REG_ZMM14: Type = 200;
    pub const X86_REG_ZMM15: Type = 201;
    pub const X86_REG_ZMM16: Type = 202;
    pub const X86_REG_ZMM17: Type = 203;
    pub const X86_REG_ZMM18: Type = 204;
    pub const X86_REG_ZMM19: Type = 205;
    pub const X86_REG_ZMM20: Type = 206;
    pub const X86_REG_ZMM21: Type = 207;
    pub const X86_REG_ZMM22: Type = 208;
    pub const X86_REG_ZMM23: Type = 209;
    pub const X86_REG_ZMM24: Type = 210;
    pub const X86_REG_ZMM25: Type = 211;
    pub const X86_REG_ZMM26: Type = 212;
    pub const X86_REG_ZMM27: Type = 213;
    pub const X86_REG_ZMM28: Type = 214;
    pub const X86_REG_ZMM29: Type = 215;
    pub const X86_REG_ZMM30: Type = 216;
    pub const X86_REG_ZMM31: Type = 217;
    pub const X86_REG_R8B: Type = 218;
    pub const X86_REG_R9B: Type = 219;
    pub const X86_REG_R10B: Type = 220;
    pub const X86_REG_R11B: Type = 221;
    pub const X86_REG_R12B: Type = 222;
    pub const X86_REG_R13B: Type = 223;
    pub const X86_REG_R14B: Type = 224;
    pub const X86_REG_R15B: Type = 225;
    pub const X86_REG_R8D: Type = 226;
    pub const X86_REG_R9D: Type = 227;
    pub const X86_REG_R10D: Type = 228;
    pub const X86_REG_R11D: Type = 229;
    pub const X86_REG_R12D: Type = 230;
    pub const X86_REG_R13D: Type = 231;
    pub const X86_REG_R14D: Type = 232;
    pub const X86_REG_R15D: Type = 233;
    pub const X86_REG_R8W: Type = 234;
    pub const X86_REG_R9W: Type = 235;
    pub const X86_REG_R10W: Type = 236;
    pub const X86_REG_R11W: Type = 237;
    pub const X86_REG_R12W: Type = 238;
    pub const X86_REG_R13W: Type = 239;
    pub const X86_REG_R14W: Type = 240;
    pub const X86_REG_R15W: Type = 241;
    pub const X86_REG_BND0: Type = 242;
    pub const X86_REG_BND1: Type = 243;
    pub const X86_REG_BND2: Type = 244;
    pub const X86_REG_BND3: Type = 245;
    pub const X86_REG_ENDING: Type = 246;
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    X86_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    X86_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    X86_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    X86_OP_MEM = 3,
}
#[repr(u32)]
#[doc = " XOP Code Condition type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_xop_cc {
    #[doc = "< Uninitialized."]
    X86_XOP_CC_INVALID = 0,
    X86_XOP_CC_LT = 1,
    X86_XOP_CC_LE = 2,
    X86_XOP_CC_GT = 3,
    X86_XOP_CC_GE = 4,
    X86_XOP_CC_EQ = 5,
    X86_XOP_CC_NEQ = 6,
    X86_XOP_CC_FALSE = 7,
    X86_XOP_CC_TRUE = 8,
}
#[repr(u32)]
#[doc = " AVX broadcast type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_avx_bcast {
    #[doc = "< Uninitialized."]
    X86_AVX_BCAST_INVALID = 0,
    #[doc = "< AVX512 broadcast type {1to2}"]
    X86_AVX_BCAST_2 = 1,
    #[doc = "< AVX512 broadcast type {1to4}"]
    X86_AVX_BCAST_4 = 2,
    #[doc = "< AVX512 broadcast type {1to8}"]
    X86_AVX_BCAST_8 = 3,
    #[doc = "< AVX512 broadcast type {1to16}"]
    X86_AVX_BCAST_16 = 4,
}
#[repr(u32)]
#[doc = " SSE Code Condition type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_sse_cc {
    #[doc = "< Uninitialized."]
    X86_SSE_CC_INVALID = 0,
    X86_SSE_CC_EQ = 1,
    X86_SSE_CC_LT = 2,
    X86_SSE_CC_LE = 3,
    X86_SSE_CC_UNORD = 4,
    X86_SSE_CC_NEQ = 5,
    X86_SSE_CC_NLT = 6,
    X86_SSE_CC_NLE = 7,
    X86_SSE_CC_ORD = 8,
}
#[repr(u32)]
#[doc = " AVX Code Condition type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_avx_cc {
    #[doc = "< Uninitialized."]
    X86_AVX_CC_INVALID = 0,
    X86_AVX_CC_EQ = 1,
    X86_AVX_CC_LT = 2,
    X86_AVX_CC_LE = 3,
    X86_AVX_CC_UNORD = 4,
    X86_AVX_CC_NEQ = 5,
    X86_AVX_CC_NLT = 6,
    X86_AVX_CC_NLE = 7,
    X86_AVX_CC_ORD = 8,
    X86_AVX_CC_EQ_UQ = 9,
    X86_AVX_CC_NGE = 10,
    X86_AVX_CC_NGT = 11,
    X86_AVX_CC_FALSE = 12,
    X86_AVX_CC_NEQ_OQ = 13,
    X86_AVX_CC_GE = 14,
    X86_AVX_CC_GT = 15,
    X86_AVX_CC_TRUE = 16,
    X86_AVX_CC_EQ_OS = 17,
    X86_AVX_CC_LT_OQ = 18,
    X86_AVX_CC_LE_OQ = 19,
    X86_AVX_CC_UNORD_S = 20,
    X86_AVX_CC_NEQ_US = 21,
    X86_AVX_CC_NLT_UQ = 22,
    X86_AVX_CC_NLE_UQ = 23,
    X86_AVX_CC_ORD_S = 24,
    X86_AVX_CC_EQ_US = 25,
    X86_AVX_CC_NGE_UQ = 26,
    X86_AVX_CC_NGT_UQ = 27,
    X86_AVX_CC_FALSE_OS = 28,
    X86_AVX_CC_NEQ_OS = 29,
    X86_AVX_CC_GE_OQ = 30,
    X86_AVX_CC_GT_OQ = 31,
    X86_AVX_CC_TRUE_US = 32,
}
#[repr(u32)]
#[doc = " AVX static rounding mode type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_avx_rm {
    #[doc = "< Uninitialized."]
    X86_AVX_RM_INVALID = 0,
    #[doc = "< Round to nearest"]
    X86_AVX_RM_RN = 1,
    #[doc = "< Round down"]
    X86_AVX_RM_RD = 2,
    #[doc = "< Round up"]
    X86_AVX_RM_RU = 3,
    #[doc = "< Round toward zero"]
    X86_AVX_RM_RZ = 4,
}
pub const X86_PREFIX_REPE: x86_prefix = x86_prefix::X86_PREFIX_REP;
#[repr(u32)]
#[doc = " Instruction prefixes - to be used in cs_x86.prefix[]"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_prefix {
    #[doc = "< lock (cs_x86.prefix[0]"]
    X86_PREFIX_LOCK = 240,
    #[doc = "< rep (cs_x86.prefix[0]"]
    X86_PREFIX_REP = 243,
    #[doc = "< repne/repnz (cs_x86.prefix[0]"]
    X86_PREFIX_REPNE = 242,
    #[doc = "< segment override CS (cs_x86.prefix[1]"]
    X86_PREFIX_CS = 46,
    #[doc = "< segment override SS (cs_x86.prefix[1]"]
    X86_PREFIX_SS = 54,
    #[doc = "< segment override DS (cs_x86.prefix[1]"]
    X86_PREFIX_DS = 62,
    #[doc = "< segment override ES (cs_x86.prefix[1]"]
    X86_PREFIX_ES = 38,
    #[doc = "< segment override FS (cs_x86.prefix[1]"]
    X86_PREFIX_FS = 100,
    #[doc = "< segment override GS (cs_x86.prefix[1]"]
    X86_PREFIX_GS = 101,
    #[doc = "< operand-size override (cs_x86.prefix[2]"]
    X86_PREFIX_OPSIZE = 102,
    #[doc = "< address-size override (cs_x86.prefix[3]"]
    X86_PREFIX_ADDRSIZE = 103,
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with X86_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct x86_op_mem {
    #[doc = "< segment register (or X86_REG_INVALID if irrelevant)"]
    pub segment: x86_reg::Type,
    #[doc = "< base register (or X86_REG_INVALID if irrelevant)"]
    pub base: x86_reg::Type,
    #[doc = "< index register (or X86_REG_INVALID if irrelevant)"]
    pub index: x86_reg::Type,
    #[doc = "< scale for index register"]
    pub scale: libc::c_int,
    #[doc = "< displacement value"]
    pub disp: i64,
}
impl Clone for x86_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_x86_op {
    #[doc = "< operand type"]
    pub type_: x86_op_type,
    pub __bindgen_anon_1: cs_x86_op__bindgen_ty_1,
    #[doc = " size of this operand (in bytes)."]
    pub size: u8,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
    #[doc = " AVX broadcast type, or 0 if irrelevant"]
    pub avx_bcast: x86_avx_bcast,
    #[doc = " AVX zero opmask {z}"]
    pub avx_zero_opmask: bool,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_x86_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: x86_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i64,
    #[doc = "< base/index/scale/disp value for MEM operand"]
    pub mem: x86_op_mem,
}
impl Clone for cs_x86_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_x86_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_x86_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_x86_op {{ type: {:?}, __bindgen_anon_1: {:?}, size: {:?}, access: {:?}, avx_bcast: {:?}, avx_zero_opmask: {:?} }}" , self . type_ , self . __bindgen_anon_1 , self . size , self . access , self . avx_bcast , self . avx_zero_opmask)
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_x86_encoding {
    #[doc = " ModR/M offset, or 0 when irrelevant"]
    pub modrm_offset: u8,
    #[doc = " Displacement offset, or 0 when irrelevant."]
    pub disp_offset: u8,
    pub disp_size: u8,
    #[doc = " Immediate offset, or 0 when irrelevant."]
    pub imm_offset: u8,
    pub imm_size: u8,
}
impl Clone for cs_x86_encoding {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_x86 {
    #[doc = " Instruction prefix, which can be up to 4 bytes."]
    #[doc = " A prefix byte gets value 0 when irrelevant."]
    #[doc = " prefix[0] indicates REP/REPNE/LOCK prefix (See X86_PREFIX_REP/REPNE/LOCK above)"]
    #[doc = " prefix[1] indicates segment override (irrelevant for x86_64):"]
    #[doc = " See X86_PREFIX_CS/SS/DS/ES/FS/GS above."]
    #[doc = " prefix[2] indicates operand-size override (X86_PREFIX_OPSIZE)"]
    #[doc = " prefix[3] indicates address-size override (X86_PREFIX_ADDRSIZE)"]
    pub prefix: [u8; 4usize],
    #[doc = " Instruction opcode, which can be from 1 to 4 bytes in size."]
    #[doc = " This contains VEX opcode as well."]
    #[doc = " An trailing opcode byte gets value 0 when irrelevant."]
    pub opcode: [u8; 4usize],
    #[doc = " REX prefix: only a non-zero value is relevant for x86_64"]
    pub rex: u8,
    #[doc = " Address size, which can be overridden with above prefix[5]."]
    pub addr_size: u8,
    #[doc = " ModR/M byte"]
    pub modrm: u8,
    #[doc = " SIB value, or 0 when irrelevant."]
    pub sib: u8,
    #[doc = " Displacement value, valid if encoding.disp_offset != 0"]
    pub disp: i64,
    #[doc = " SIB index register, or X86_REG_INVALID when irrelevant."]
    pub sib_index: x86_reg::Type,
    #[doc = " SIB scale, only applicable if sib_index is valid."]
    pub sib_scale: i8,
    #[doc = " SIB base register, or X86_REG_INVALID when irrelevant."]
    pub sib_base: x86_reg::Type,
    #[doc = " XOP Code Condition"]
    pub xop_cc: x86_xop_cc,
    #[doc = " SSE Code Condition"]
    pub sse_cc: x86_sse_cc,
    #[doc = " AVX Code Condition"]
    pub avx_cc: x86_avx_cc,
    #[doc = " AVX Suppress all Exception"]
    pub avx_sae: bool,
    #[doc = " AVX static rounding mode"]
    pub avx_rm: x86_avx_rm,
    pub __bindgen_anon_1: cs_x86__bindgen_ty_1,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_x86_op; 8usize],
    #[doc = "< encoding information"]
    pub encoding: cs_x86_encoding,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_x86__bindgen_ty_1 {
    #[doc = " EFLAGS updated by this instruction."]
    #[doc = " This can be formed from OR combination of X86_EFLAGS_* symbols in x86.h"]
    pub eflags: u64,
    #[doc = " FPU_FLAGS updated by this instruction."]
    #[doc = " This can be formed from OR combination of X86_FPU_FLAGS_* symbols in x86.h"]
    pub fpu_flags: u64,
}
impl Clone for cs_x86__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_x86__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_x86 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_x86 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_x86 {{ prefix: {:?}, opcode: {:?}, rex: {:?}, addr_size: {:?}, modrm: {:?}, sib: {:?}, disp: {:?}, sib_index: {:?}, sib_scale: {:?}, sib_base: {:?}, xop_cc: {:?}, sse_cc: {:?}, avx_cc: {:?}, avx_sae: {:?}, avx_rm: {:?}, __bindgen_anon_1: {:?}, op_count: {:?}, operands: {:?}, encoding: {:?} }}" , self . prefix , self . opcode , self . rex , self . addr_size , self . modrm , self . sib , self . disp , self . sib_index , self . sib_scale , self . sib_base , self . xop_cc , self . sse_cc , self . avx_cc , self . avx_sae , self . avx_rm , self . __bindgen_anon_1 , self . op_count , self . operands , self . encoding)
    }
}
#[repr(u32)]
#[doc = " X86 instructions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum x86_insn {
    X86_INS_INVALID = 0,
    X86_INS_AAA = 1,
    X86_INS_AAD = 2,
    X86_INS_AAM = 3,
    X86_INS_AAS = 4,
    X86_INS_FABS = 5,
    X86_INS_ADC = 6,
    X86_INS_ADCX = 7,
    X86_INS_ADD = 8,
    X86_INS_ADDPD = 9,
    X86_INS_ADDPS = 10,
    X86_INS_ADDSD = 11,
    X86_INS_ADDSS = 12,
    X86_INS_ADDSUBPD = 13,
    X86_INS_ADDSUBPS = 14,
    X86_INS_FADD = 15,
    X86_INS_FIADD = 16,
    X86_INS_ADOX = 17,
    X86_INS_AESDECLAST = 18,
    X86_INS_AESDEC = 19,
    X86_INS_AESENCLAST = 20,
    X86_INS_AESENC = 21,
    X86_INS_AESIMC = 22,
    X86_INS_AESKEYGENASSIST = 23,
    X86_INS_AND = 24,
    X86_INS_ANDN = 25,
    X86_INS_ANDNPD = 26,
    X86_INS_ANDNPS = 27,
    X86_INS_ANDPD = 28,
    X86_INS_ANDPS = 29,
    X86_INS_ARPL = 30,
    X86_INS_BEXTR = 31,
    X86_INS_BLCFILL = 32,
    X86_INS_BLCI = 33,
    X86_INS_BLCIC = 34,
    X86_INS_BLCMSK = 35,
    X86_INS_BLCS = 36,
    X86_INS_BLENDPD = 37,
    X86_INS_BLENDPS = 38,
    X86_INS_BLENDVPD = 39,
    X86_INS_BLENDVPS = 40,
    X86_INS_BLSFILL = 41,
    X86_INS_BLSI = 42,
    X86_INS_BLSIC = 43,
    X86_INS_BLSMSK = 44,
    X86_INS_BLSR = 45,
    X86_INS_BNDCL = 46,
    X86_INS_BNDCN = 47,
    X86_INS_BNDCU = 48,
    X86_INS_BNDLDX = 49,
    X86_INS_BNDMK = 50,
    X86_INS_BNDMOV = 51,
    X86_INS_BNDSTX = 52,
    X86_INS_BOUND = 53,
    X86_INS_BSF = 54,
    X86_INS_BSR = 55,
    X86_INS_BSWAP = 56,
    X86_INS_BT = 57,
    X86_INS_BTC = 58,
    X86_INS_BTR = 59,
    X86_INS_BTS = 60,
    X86_INS_BZHI = 61,
    X86_INS_CALL = 62,
    X86_INS_CBW = 63,
    X86_INS_CDQ = 64,
    X86_INS_CDQE = 65,
    X86_INS_FCHS = 66,
    X86_INS_CLAC = 67,
    X86_INS_CLC = 68,
    X86_INS_CLD = 69,
    X86_INS_CLDEMOTE = 70,
    X86_INS_CLFLUSH = 71,
    X86_INS_CLFLUSHOPT = 72,
    X86_INS_CLGI = 73,
    X86_INS_CLI = 74,
    X86_INS_CLRSSBSY = 75,
    X86_INS_CLTS = 76,
    X86_INS_CLWB = 77,
    X86_INS_CLZERO = 78,
    X86_INS_CMC = 79,
    X86_INS_CMOVA = 80,
    X86_INS_CMOVAE = 81,
    X86_INS_CMOVB = 82,
    X86_INS_CMOVBE = 83,
    X86_INS_FCMOVBE = 84,
    X86_INS_FCMOVB = 85,
    X86_INS_CMOVE = 86,
    X86_INS_FCMOVE = 87,
    X86_INS_CMOVG = 88,
    X86_INS_CMOVGE = 89,
    X86_INS_CMOVL = 90,
    X86_INS_CMOVLE = 91,
    X86_INS_FCMOVNBE = 92,
    X86_INS_FCMOVNB = 93,
    X86_INS_CMOVNE = 94,
    X86_INS_FCMOVNE = 95,
    X86_INS_CMOVNO = 96,
    X86_INS_CMOVNP = 97,
    X86_INS_FCMOVNU = 98,
    X86_INS_FCMOVNP = 99,
    X86_INS_CMOVNS = 100,
    X86_INS_CMOVO = 101,
    X86_INS_CMOVP = 102,
    X86_INS_FCMOVU = 103,
    X86_INS_CMOVS = 104,
    X86_INS_CMP = 105,
    X86_INS_CMPPD = 106,
    X86_INS_CMPPS = 107,
    X86_INS_CMPSB = 108,
    X86_INS_CMPSD = 109,
    X86_INS_CMPSQ = 110,
    X86_INS_CMPSS = 111,
    X86_INS_CMPSW = 112,
    X86_INS_CMPXCHG16B = 113,
    X86_INS_CMPXCHG = 114,
    X86_INS_CMPXCHG8B = 115,
    X86_INS_COMISD = 116,
    X86_INS_COMISS = 117,
    X86_INS_FCOMP = 118,
    X86_INS_FCOMPI = 119,
    X86_INS_FCOMI = 120,
    X86_INS_FCOM = 121,
    X86_INS_FCOS = 122,
    X86_INS_CPUID = 123,
    X86_INS_CQO = 124,
    X86_INS_CRC32 = 125,
    X86_INS_CVTDQ2PD = 126,
    X86_INS_CVTDQ2PS = 127,
    X86_INS_CVTPD2DQ = 128,
    X86_INS_CVTPD2PS = 129,
    X86_INS_CVTPS2DQ = 130,
    X86_INS_CVTPS2PD = 131,
    X86_INS_CVTSD2SI = 132,
    X86_INS_CVTSD2SS = 133,
    X86_INS_CVTSI2SD = 134,
    X86_INS_CVTSI2SS = 135,
    X86_INS_CVTSS2SD = 136,
    X86_INS_CVTSS2SI = 137,
    X86_INS_CVTTPD2DQ = 138,
    X86_INS_CVTTPS2DQ = 139,
    X86_INS_CVTTSD2SI = 140,
    X86_INS_CVTTSS2SI = 141,
    X86_INS_CWD = 142,
    X86_INS_CWDE = 143,
    X86_INS_DAA = 144,
    X86_INS_DAS = 145,
    X86_INS_DATA16 = 146,
    X86_INS_DEC = 147,
    X86_INS_DIV = 148,
    X86_INS_DIVPD = 149,
    X86_INS_DIVPS = 150,
    X86_INS_FDIVR = 151,
    X86_INS_FIDIVR = 152,
    X86_INS_FDIVRP = 153,
    X86_INS_DIVSD = 154,
    X86_INS_DIVSS = 155,
    X86_INS_FDIV = 156,
    X86_INS_FIDIV = 157,
    X86_INS_FDIVP = 158,
    X86_INS_DPPD = 159,
    X86_INS_DPPS = 160,
    X86_INS_ENCLS = 161,
    X86_INS_ENCLU = 162,
    X86_INS_ENCLV = 163,
    X86_INS_ENDBR32 = 164,
    X86_INS_ENDBR64 = 165,
    X86_INS_ENTER = 166,
    X86_INS_EXTRACTPS = 167,
    X86_INS_EXTRQ = 168,
    X86_INS_F2XM1 = 169,
    X86_INS_LCALL = 170,
    X86_INS_LJMP = 171,
    X86_INS_JMP = 172,
    X86_INS_FBLD = 173,
    X86_INS_FBSTP = 174,
    X86_INS_FCOMPP = 175,
    X86_INS_FDECSTP = 176,
    X86_INS_FDISI8087_NOP = 177,
    X86_INS_FEMMS = 178,
    X86_INS_FENI8087_NOP = 179,
    X86_INS_FFREE = 180,
    X86_INS_FFREEP = 181,
    X86_INS_FICOM = 182,
    X86_INS_FICOMP = 183,
    X86_INS_FINCSTP = 184,
    X86_INS_FLDCW = 185,
    X86_INS_FLDENV = 186,
    X86_INS_FLDL2E = 187,
    X86_INS_FLDL2T = 188,
    X86_INS_FLDLG2 = 189,
    X86_INS_FLDLN2 = 190,
    X86_INS_FLDPI = 191,
    X86_INS_FNCLEX = 192,
    X86_INS_FNINIT = 193,
    X86_INS_FNOP = 194,
    X86_INS_FNSTCW = 195,
    X86_INS_FNSTSW = 196,
    X86_INS_FPATAN = 197,
    X86_INS_FSTPNCE = 198,
    X86_INS_FPREM = 199,
    X86_INS_FPREM1 = 200,
    X86_INS_FPTAN = 201,
    X86_INS_FRNDINT = 202,
    X86_INS_FRSTOR = 203,
    X86_INS_FNSAVE = 204,
    X86_INS_FSCALE = 205,
    X86_INS_FSETPM = 206,
    X86_INS_FSINCOS = 207,
    X86_INS_FNSTENV = 208,
    X86_INS_FXAM = 209,
    X86_INS_FXRSTOR = 210,
    X86_INS_FXRSTOR64 = 211,
    X86_INS_FXSAVE = 212,
    X86_INS_FXSAVE64 = 213,
    X86_INS_FXTRACT = 214,
    X86_INS_FYL2X = 215,
    X86_INS_FYL2XP1 = 216,
    X86_INS_GETSEC = 217,
    X86_INS_GF2P8AFFINEINVQB = 218,
    X86_INS_GF2P8AFFINEQB = 219,
    X86_INS_GF2P8MULB = 220,
    X86_INS_HADDPD = 221,
    X86_INS_HADDPS = 222,
    X86_INS_HLT = 223,
    X86_INS_HSUBPD = 224,
    X86_INS_HSUBPS = 225,
    X86_INS_IDIV = 226,
    X86_INS_FILD = 227,
    X86_INS_IMUL = 228,
    X86_INS_IN = 229,
    X86_INS_INC = 230,
    X86_INS_INCSSPD = 231,
    X86_INS_INCSSPQ = 232,
    X86_INS_INSB = 233,
    X86_INS_INSERTPS = 234,
    X86_INS_INSERTQ = 235,
    X86_INS_INSD = 236,
    X86_INS_INSW = 237,
    X86_INS_INT = 238,
    X86_INS_INT1 = 239,
    X86_INS_INT3 = 240,
    X86_INS_INTO = 241,
    X86_INS_INVD = 242,
    X86_INS_INVEPT = 243,
    X86_INS_INVLPG = 244,
    X86_INS_INVLPGA = 245,
    X86_INS_INVPCID = 246,
    X86_INS_INVVPID = 247,
    X86_INS_IRET = 248,
    X86_INS_IRETD = 249,
    X86_INS_IRETQ = 250,
    X86_INS_FISTTP = 251,
    X86_INS_FIST = 252,
    X86_INS_FISTP = 253,
    X86_INS_JAE = 254,
    X86_INS_JA = 255,
    X86_INS_JBE = 256,
    X86_INS_JB = 257,
    X86_INS_JCXZ = 258,
    X86_INS_JECXZ = 259,
    X86_INS_JE = 260,
    X86_INS_JGE = 261,
    X86_INS_JG = 262,
    X86_INS_JLE = 263,
    X86_INS_JL = 264,
    X86_INS_JNE = 265,
    X86_INS_JNO = 266,
    X86_INS_JNP = 267,
    X86_INS_JNS = 268,
    X86_INS_JO = 269,
    X86_INS_JP = 270,
    X86_INS_JRCXZ = 271,
    X86_INS_JS = 272,
    X86_INS_KADDB = 273,
    X86_INS_KADDD = 274,
    X86_INS_KADDQ = 275,
    X86_INS_KADDW = 276,
    X86_INS_KANDB = 277,
    X86_INS_KANDD = 278,
    X86_INS_KANDNB = 279,
    X86_INS_KANDND = 280,
    X86_INS_KANDNQ = 281,
    X86_INS_KANDNW = 282,
    X86_INS_KANDQ = 283,
    X86_INS_KANDW = 284,
    X86_INS_KMOVB = 285,
    X86_INS_KMOVD = 286,
    X86_INS_KMOVQ = 287,
    X86_INS_KMOVW = 288,
    X86_INS_KNOTB = 289,
    X86_INS_KNOTD = 290,
    X86_INS_KNOTQ = 291,
    X86_INS_KNOTW = 292,
    X86_INS_KORB = 293,
    X86_INS_KORD = 294,
    X86_INS_KORQ = 295,
    X86_INS_KORTESTB = 296,
    X86_INS_KORTESTD = 297,
    X86_INS_KORTESTQ = 298,
    X86_INS_KORTESTW = 299,
    X86_INS_KORW = 300,
    X86_INS_KSHIFTLB = 301,
    X86_INS_KSHIFTLD = 302,
    X86_INS_KSHIFTLQ = 303,
    X86_INS_KSHIFTLW = 304,
    X86_INS_KSHIFTRB = 305,
    X86_INS_KSHIFTRD = 306,
    X86_INS_KSHIFTRQ = 307,
    X86_INS_KSHIFTRW = 308,
    X86_INS_KTESTB = 309,
    X86_INS_KTESTD = 310,
    X86_INS_KTESTQ = 311,
    X86_INS_KTESTW = 312,
    X86_INS_KUNPCKBW = 313,
    X86_INS_KUNPCKDQ = 314,
    X86_INS_KUNPCKWD = 315,
    X86_INS_KXNORB = 316,
    X86_INS_KXNORD = 317,
    X86_INS_KXNORQ = 318,
    X86_INS_KXNORW = 319,
    X86_INS_KXORB = 320,
    X86_INS_KXORD = 321,
    X86_INS_KXORQ = 322,
    X86_INS_KXORW = 323,
    X86_INS_LAHF = 324,
    X86_INS_LAR = 325,
    X86_INS_LDDQU = 326,
    X86_INS_LDMXCSR = 327,
    X86_INS_LDS = 328,
    X86_INS_FLDZ = 329,
    X86_INS_FLD1 = 330,
    X86_INS_FLD = 331,
    X86_INS_LEA = 332,
    X86_INS_LEAVE = 333,
    X86_INS_LES = 334,
    X86_INS_LFENCE = 335,
    X86_INS_LFS = 336,
    X86_INS_LGDT = 337,
    X86_INS_LGS = 338,
    X86_INS_LIDT = 339,
    X86_INS_LLDT = 340,
    X86_INS_LLWPCB = 341,
    X86_INS_LMSW = 342,
    X86_INS_LOCK = 343,
    X86_INS_LODSB = 344,
    X86_INS_LODSD = 345,
    X86_INS_LODSQ = 346,
    X86_INS_LODSW = 347,
    X86_INS_LOOP = 348,
    X86_INS_LOOPE = 349,
    X86_INS_LOOPNE = 350,
    X86_INS_RETF = 351,
    X86_INS_RETFQ = 352,
    X86_INS_LSL = 353,
    X86_INS_LSS = 354,
    X86_INS_LTR = 355,
    X86_INS_LWPINS = 356,
    X86_INS_LWPVAL = 357,
    X86_INS_LZCNT = 358,
    X86_INS_MASKMOVDQU = 359,
    X86_INS_MAXPD = 360,
    X86_INS_MAXPS = 361,
    X86_INS_MAXSD = 362,
    X86_INS_MAXSS = 363,
    X86_INS_MFENCE = 364,
    X86_INS_MINPD = 365,
    X86_INS_MINPS = 366,
    X86_INS_MINSD = 367,
    X86_INS_MINSS = 368,
    X86_INS_CVTPD2PI = 369,
    X86_INS_CVTPI2PD = 370,
    X86_INS_CVTPI2PS = 371,
    X86_INS_CVTPS2PI = 372,
    X86_INS_CVTTPD2PI = 373,
    X86_INS_CVTTPS2PI = 374,
    X86_INS_EMMS = 375,
    X86_INS_MASKMOVQ = 376,
    X86_INS_MOVD = 377,
    X86_INS_MOVQ = 378,
    X86_INS_MOVDQ2Q = 379,
    X86_INS_MOVNTQ = 380,
    X86_INS_MOVQ2DQ = 381,
    X86_INS_PABSB = 382,
    X86_INS_PABSD = 383,
    X86_INS_PABSW = 384,
    X86_INS_PACKSSDW = 385,
    X86_INS_PACKSSWB = 386,
    X86_INS_PACKUSWB = 387,
    X86_INS_PADDB = 388,
    X86_INS_PADDD = 389,
    X86_INS_PADDQ = 390,
    X86_INS_PADDSB = 391,
    X86_INS_PADDSW = 392,
    X86_INS_PADDUSB = 393,
    X86_INS_PADDUSW = 394,
    X86_INS_PADDW = 395,
    X86_INS_PALIGNR = 396,
    X86_INS_PANDN = 397,
    X86_INS_PAND = 398,
    X86_INS_PAVGB = 399,
    X86_INS_PAVGW = 400,
    X86_INS_PCMPEQB = 401,
    X86_INS_PCMPEQD = 402,
    X86_INS_PCMPEQW = 403,
    X86_INS_PCMPGTB = 404,
    X86_INS_PCMPGTD = 405,
    X86_INS_PCMPGTW = 406,
    X86_INS_PEXTRW = 407,
    X86_INS_PHADDD = 408,
    X86_INS_PHADDSW = 409,
    X86_INS_PHADDW = 410,
    X86_INS_PHSUBD = 411,
    X86_INS_PHSUBSW = 412,
    X86_INS_PHSUBW = 413,
    X86_INS_PINSRW = 414,
    X86_INS_PMADDUBSW = 415,
    X86_INS_PMADDWD = 416,
    X86_INS_PMAXSW = 417,
    X86_INS_PMAXUB = 418,
    X86_INS_PMINSW = 419,
    X86_INS_PMINUB = 420,
    X86_INS_PMOVMSKB = 421,
    X86_INS_PMULHRSW = 422,
    X86_INS_PMULHUW = 423,
    X86_INS_PMULHW = 424,
    X86_INS_PMULLW = 425,
    X86_INS_PMULUDQ = 426,
    X86_INS_POR = 427,
    X86_INS_PSADBW = 428,
    X86_INS_PSHUFB = 429,
    X86_INS_PSHUFW = 430,
    X86_INS_PSIGNB = 431,
    X86_INS_PSIGND = 432,
    X86_INS_PSIGNW = 433,
    X86_INS_PSLLD = 434,
    X86_INS_PSLLQ = 435,
    X86_INS_PSLLW = 436,
    X86_INS_PSRAD = 437,
    X86_INS_PSRAW = 438,
    X86_INS_PSRLD = 439,
    X86_INS_PSRLQ = 440,
    X86_INS_PSRLW = 441,
    X86_INS_PSUBB = 442,
    X86_INS_PSUBD = 443,
    X86_INS_PSUBQ = 444,
    X86_INS_PSUBSB = 445,
    X86_INS_PSUBSW = 446,
    X86_INS_PSUBUSB = 447,
    X86_INS_PSUBUSW = 448,
    X86_INS_PSUBW = 449,
    X86_INS_PUNPCKHBW = 450,
    X86_INS_PUNPCKHDQ = 451,
    X86_INS_PUNPCKHWD = 452,
    X86_INS_PUNPCKLBW = 453,
    X86_INS_PUNPCKLDQ = 454,
    X86_INS_PUNPCKLWD = 455,
    X86_INS_PXOR = 456,
    X86_INS_MONITORX = 457,
    X86_INS_MONITOR = 458,
    X86_INS_MONTMUL = 459,
    X86_INS_MOV = 460,
    X86_INS_MOVABS = 461,
    X86_INS_MOVAPD = 462,
    X86_INS_MOVAPS = 463,
    X86_INS_MOVBE = 464,
    X86_INS_MOVDDUP = 465,
    X86_INS_MOVDIR64B = 466,
    X86_INS_MOVDIRI = 467,
    X86_INS_MOVDQA = 468,
    X86_INS_MOVDQU = 469,
    X86_INS_MOVHLPS = 470,
    X86_INS_MOVHPD = 471,
    X86_INS_MOVHPS = 472,
    X86_INS_MOVLHPS = 473,
    X86_INS_MOVLPD = 474,
    X86_INS_MOVLPS = 475,
    X86_INS_MOVMSKPD = 476,
    X86_INS_MOVMSKPS = 477,
    X86_INS_MOVNTDQA = 478,
    X86_INS_MOVNTDQ = 479,
    X86_INS_MOVNTI = 480,
    X86_INS_MOVNTPD = 481,
    X86_INS_MOVNTPS = 482,
    X86_INS_MOVNTSD = 483,
    X86_INS_MOVNTSS = 484,
    X86_INS_MOVSB = 485,
    X86_INS_MOVSD = 486,
    X86_INS_MOVSHDUP = 487,
    X86_INS_MOVSLDUP = 488,
    X86_INS_MOVSQ = 489,
    X86_INS_MOVSS = 490,
    X86_INS_MOVSW = 491,
    X86_INS_MOVSX = 492,
    X86_INS_MOVSXD = 493,
    X86_INS_MOVUPD = 494,
    X86_INS_MOVUPS = 495,
    X86_INS_MOVZX = 496,
    X86_INS_MPSADBW = 497,
    X86_INS_MUL = 498,
    X86_INS_MULPD = 499,
    X86_INS_MULPS = 500,
    X86_INS_MULSD = 501,
    X86_INS_MULSS = 502,
    X86_INS_MULX = 503,
    X86_INS_FMUL = 504,
    X86_INS_FIMUL = 505,
    X86_INS_FMULP = 506,
    X86_INS_MWAITX = 507,
    X86_INS_MWAIT = 508,
    X86_INS_NEG = 509,
    X86_INS_NOP = 510,
    X86_INS_NOT = 511,
    X86_INS_OR = 512,
    X86_INS_ORPD = 513,
    X86_INS_ORPS = 514,
    X86_INS_OUT = 515,
    X86_INS_OUTSB = 516,
    X86_INS_OUTSD = 517,
    X86_INS_OUTSW = 518,
    X86_INS_PACKUSDW = 519,
    X86_INS_PAUSE = 520,
    X86_INS_PAVGUSB = 521,
    X86_INS_PBLENDVB = 522,
    X86_INS_PBLENDW = 523,
    X86_INS_PCLMULQDQ = 524,
    X86_INS_PCMPEQQ = 525,
    X86_INS_PCMPESTRI = 526,
    X86_INS_PCMPESTRM = 527,
    X86_INS_PCMPGTQ = 528,
    X86_INS_PCMPISTRI = 529,
    X86_INS_PCMPISTRM = 530,
    X86_INS_PCONFIG = 531,
    X86_INS_PDEP = 532,
    X86_INS_PEXT = 533,
    X86_INS_PEXTRB = 534,
    X86_INS_PEXTRD = 535,
    X86_INS_PEXTRQ = 536,
    X86_INS_PF2ID = 537,
    X86_INS_PF2IW = 538,
    X86_INS_PFACC = 539,
    X86_INS_PFADD = 540,
    X86_INS_PFCMPEQ = 541,
    X86_INS_PFCMPGE = 542,
    X86_INS_PFCMPGT = 543,
    X86_INS_PFMAX = 544,
    X86_INS_PFMIN = 545,
    X86_INS_PFMUL = 546,
    X86_INS_PFNACC = 547,
    X86_INS_PFPNACC = 548,
    X86_INS_PFRCPIT1 = 549,
    X86_INS_PFRCPIT2 = 550,
    X86_INS_PFRCP = 551,
    X86_INS_PFRSQIT1 = 552,
    X86_INS_PFRSQRT = 553,
    X86_INS_PFSUBR = 554,
    X86_INS_PFSUB = 555,
    X86_INS_PHMINPOSUW = 556,
    X86_INS_PI2FD = 557,
    X86_INS_PI2FW = 558,
    X86_INS_PINSRB = 559,
    X86_INS_PINSRD = 560,
    X86_INS_PINSRQ = 561,
    X86_INS_PMAXSB = 562,
    X86_INS_PMAXSD = 563,
    X86_INS_PMAXUD = 564,
    X86_INS_PMAXUW = 565,
    X86_INS_PMINSB = 566,
    X86_INS_PMINSD = 567,
    X86_INS_PMINUD = 568,
    X86_INS_PMINUW = 569,
    X86_INS_PMOVSXBD = 570,
    X86_INS_PMOVSXBQ = 571,
    X86_INS_PMOVSXBW = 572,
    X86_INS_PMOVSXDQ = 573,
    X86_INS_PMOVSXWD = 574,
    X86_INS_PMOVSXWQ = 575,
    X86_INS_PMOVZXBD = 576,
    X86_INS_PMOVZXBQ = 577,
    X86_INS_PMOVZXBW = 578,
    X86_INS_PMOVZXDQ = 579,
    X86_INS_PMOVZXWD = 580,
    X86_INS_PMOVZXWQ = 581,
    X86_INS_PMULDQ = 582,
    X86_INS_PMULHRW = 583,
    X86_INS_PMULLD = 584,
    X86_INS_POP = 585,
    X86_INS_POPAW = 586,
    X86_INS_POPAL = 587,
    X86_INS_POPCNT = 588,
    X86_INS_POPF = 589,
    X86_INS_POPFD = 590,
    X86_INS_POPFQ = 591,
    X86_INS_PREFETCH = 592,
    X86_INS_PREFETCHNTA = 593,
    X86_INS_PREFETCHT0 = 594,
    X86_INS_PREFETCHT1 = 595,
    X86_INS_PREFETCHT2 = 596,
    X86_INS_PREFETCHW = 597,
    X86_INS_PREFETCHWT1 = 598,
    X86_INS_PSHUFD = 599,
    X86_INS_PSHUFHW = 600,
    X86_INS_PSHUFLW = 601,
    X86_INS_PSLLDQ = 602,
    X86_INS_PSRLDQ = 603,
    X86_INS_PSWAPD = 604,
    X86_INS_PTEST = 605,
    X86_INS_PTWRITE = 606,
    X86_INS_PUNPCKHQDQ = 607,
    X86_INS_PUNPCKLQDQ = 608,
    X86_INS_PUSH = 609,
    X86_INS_PUSHAW = 610,
    X86_INS_PUSHAL = 611,
    X86_INS_PUSHF = 612,
    X86_INS_PUSHFD = 613,
    X86_INS_PUSHFQ = 614,
    X86_INS_RCL = 615,
    X86_INS_RCPPS = 616,
    X86_INS_RCPSS = 617,
    X86_INS_RCR = 618,
    X86_INS_RDFSBASE = 619,
    X86_INS_RDGSBASE = 620,
    X86_INS_RDMSR = 621,
    X86_INS_RDPID = 622,
    X86_INS_RDPKRU = 623,
    X86_INS_RDPMC = 624,
    X86_INS_RDRAND = 625,
    X86_INS_RDSEED = 626,
    X86_INS_RDSSPD = 627,
    X86_INS_RDSSPQ = 628,
    X86_INS_RDTSC = 629,
    X86_INS_RDTSCP = 630,
    X86_INS_REPNE = 631,
    X86_INS_REP = 632,
    X86_INS_RET = 633,
    X86_INS_REX64 = 634,
    X86_INS_ROL = 635,
    X86_INS_ROR = 636,
    X86_INS_RORX = 637,
    X86_INS_ROUNDPD = 638,
    X86_INS_ROUNDPS = 639,
    X86_INS_ROUNDSD = 640,
    X86_INS_ROUNDSS = 641,
    X86_INS_RSM = 642,
    X86_INS_RSQRTPS = 643,
    X86_INS_RSQRTSS = 644,
    X86_INS_RSTORSSP = 645,
    X86_INS_SAHF = 646,
    X86_INS_SAL = 647,
    X86_INS_SALC = 648,
    X86_INS_SAR = 649,
    X86_INS_SARX = 650,
    X86_INS_SAVEPREVSSP = 651,
    X86_INS_SBB = 652,
    X86_INS_SCASB = 653,
    X86_INS_SCASD = 654,
    X86_INS_SCASQ = 655,
    X86_INS_SCASW = 656,
    X86_INS_SETAE = 657,
    X86_INS_SETA = 658,
    X86_INS_SETBE = 659,
    X86_INS_SETB = 660,
    X86_INS_SETE = 661,
    X86_INS_SETGE = 662,
    X86_INS_SETG = 663,
    X86_INS_SETLE = 664,
    X86_INS_SETL = 665,
    X86_INS_SETNE = 666,
    X86_INS_SETNO = 667,
    X86_INS_SETNP = 668,
    X86_INS_SETNS = 669,
    X86_INS_SETO = 670,
    X86_INS_SETP = 671,
    X86_INS_SETSSBSY = 672,
    X86_INS_SETS = 673,
    X86_INS_SFENCE = 674,
    X86_INS_SGDT = 675,
    X86_INS_SHA1MSG1 = 676,
    X86_INS_SHA1MSG2 = 677,
    X86_INS_SHA1NEXTE = 678,
    X86_INS_SHA1RNDS4 = 679,
    X86_INS_SHA256MSG1 = 680,
    X86_INS_SHA256MSG2 = 681,
    X86_INS_SHA256RNDS2 = 682,
    X86_INS_SHL = 683,
    X86_INS_SHLD = 684,
    X86_INS_SHLX = 685,
    X86_INS_SHR = 686,
    X86_INS_SHRD = 687,
    X86_INS_SHRX = 688,
    X86_INS_SHUFPD = 689,
    X86_INS_SHUFPS = 690,
    X86_INS_SIDT = 691,
    X86_INS_FSIN = 692,
    X86_INS_SKINIT = 693,
    X86_INS_SLDT = 694,
    X86_INS_SLWPCB = 695,
    X86_INS_SMSW = 696,
    X86_INS_SQRTPD = 697,
    X86_INS_SQRTPS = 698,
    X86_INS_SQRTSD = 699,
    X86_INS_SQRTSS = 700,
    X86_INS_FSQRT = 701,
    X86_INS_STAC = 702,
    X86_INS_STC = 703,
    X86_INS_STD = 704,
    X86_INS_STGI = 705,
    X86_INS_STI = 706,
    X86_INS_STMXCSR = 707,
    X86_INS_STOSB = 708,
    X86_INS_STOSD = 709,
    X86_INS_STOSQ = 710,
    X86_INS_STOSW = 711,
    X86_INS_STR = 712,
    X86_INS_FST = 713,
    X86_INS_FSTP = 714,
    X86_INS_SUB = 715,
    X86_INS_SUBPD = 716,
    X86_INS_SUBPS = 717,
    X86_INS_FSUBR = 718,
    X86_INS_FISUBR = 719,
    X86_INS_FSUBRP = 720,
    X86_INS_SUBSD = 721,
    X86_INS_SUBSS = 722,
    X86_INS_FSUB = 723,
    X86_INS_FISUB = 724,
    X86_INS_FSUBP = 725,
    X86_INS_SWAPGS = 726,
    X86_INS_SYSCALL = 727,
    X86_INS_SYSENTER = 728,
    X86_INS_SYSEXIT = 729,
    X86_INS_SYSEXITQ = 730,
    X86_INS_SYSRET = 731,
    X86_INS_SYSRETQ = 732,
    X86_INS_T1MSKC = 733,
    X86_INS_TEST = 734,
    X86_INS_TPAUSE = 735,
    X86_INS_FTST = 736,
    X86_INS_TZCNT = 737,
    X86_INS_TZMSK = 738,
    X86_INS_UCOMISD = 739,
    X86_INS_UCOMISS = 740,
    X86_INS_FUCOMPI = 741,
    X86_INS_FUCOMI = 742,
    X86_INS_FUCOMPP = 743,
    X86_INS_FUCOMP = 744,
    X86_INS_FUCOM = 745,
    X86_INS_UD0 = 746,
    X86_INS_UD1 = 747,
    X86_INS_UD2 = 748,
    X86_INS_UMONITOR = 749,
    X86_INS_UMWAIT = 750,
    X86_INS_UNPCKHPD = 751,
    X86_INS_UNPCKHPS = 752,
    X86_INS_UNPCKLPD = 753,
    X86_INS_UNPCKLPS = 754,
    X86_INS_V4FMADDPS = 755,
    X86_INS_V4FMADDSS = 756,
    X86_INS_V4FNMADDPS = 757,
    X86_INS_V4FNMADDSS = 758,
    X86_INS_VADDPD = 759,
    X86_INS_VADDPS = 760,
    X86_INS_VADDSD = 761,
    X86_INS_VADDSS = 762,
    X86_INS_VADDSUBPD = 763,
    X86_INS_VADDSUBPS = 764,
    X86_INS_VAESDECLAST = 765,
    X86_INS_VAESDEC = 766,
    X86_INS_VAESENCLAST = 767,
    X86_INS_VAESENC = 768,
    X86_INS_VAESIMC = 769,
    X86_INS_VAESKEYGENASSIST = 770,
    X86_INS_VALIGND = 771,
    X86_INS_VALIGNQ = 772,
    X86_INS_VANDNPD = 773,
    X86_INS_VANDNPS = 774,
    X86_INS_VANDPD = 775,
    X86_INS_VANDPS = 776,
    X86_INS_VBLENDMPD = 777,
    X86_INS_VBLENDMPS = 778,
    X86_INS_VBLENDPD = 779,
    X86_INS_VBLENDPS = 780,
    X86_INS_VBLENDVPD = 781,
    X86_INS_VBLENDVPS = 782,
    X86_INS_VBROADCASTF128 = 783,
    X86_INS_VBROADCASTF32X2 = 784,
    X86_INS_VBROADCASTF32X4 = 785,
    X86_INS_VBROADCASTF32X8 = 786,
    X86_INS_VBROADCASTF64X2 = 787,
    X86_INS_VBROADCASTF64X4 = 788,
    X86_INS_VBROADCASTI128 = 789,
    X86_INS_VBROADCASTI32X2 = 790,
    X86_INS_VBROADCASTI32X4 = 791,
    X86_INS_VBROADCASTI32X8 = 792,
    X86_INS_VBROADCASTI64X2 = 793,
    X86_INS_VBROADCASTI64X4 = 794,
    X86_INS_VBROADCASTSD = 795,
    X86_INS_VBROADCASTSS = 796,
    X86_INS_VCMP = 797,
    X86_INS_VCMPPD = 798,
    X86_INS_VCMPPS = 799,
    X86_INS_VCMPSD = 800,
    X86_INS_VCMPSS = 801,
    X86_INS_VCOMISD = 802,
    X86_INS_VCOMISS = 803,
    X86_INS_VCOMPRESSPD = 804,
    X86_INS_VCOMPRESSPS = 805,
    X86_INS_VCVTDQ2PD = 806,
    X86_INS_VCVTDQ2PS = 807,
    X86_INS_VCVTPD2DQ = 808,
    X86_INS_VCVTPD2PS = 809,
    X86_INS_VCVTPD2QQ = 810,
    X86_INS_VCVTPD2UDQ = 811,
    X86_INS_VCVTPD2UQQ = 812,
    X86_INS_VCVTPH2PS = 813,
    X86_INS_VCVTPS2DQ = 814,
    X86_INS_VCVTPS2PD = 815,
    X86_INS_VCVTPS2PH = 816,
    X86_INS_VCVTPS2QQ = 817,
    X86_INS_VCVTPS2UDQ = 818,
    X86_INS_VCVTPS2UQQ = 819,
    X86_INS_VCVTQQ2PD = 820,
    X86_INS_VCVTQQ2PS = 821,
    X86_INS_VCVTSD2SI = 822,
    X86_INS_VCVTSD2SS = 823,
    X86_INS_VCVTSD2USI = 824,
    X86_INS_VCVTSI2SD = 825,
    X86_INS_VCVTSI2SS = 826,
    X86_INS_VCVTSS2SD = 827,
    X86_INS_VCVTSS2SI = 828,
    X86_INS_VCVTSS2USI = 829,
    X86_INS_VCVTTPD2DQ = 830,
    X86_INS_VCVTTPD2QQ = 831,
    X86_INS_VCVTTPD2UDQ = 832,
    X86_INS_VCVTTPD2UQQ = 833,
    X86_INS_VCVTTPS2DQ = 834,
    X86_INS_VCVTTPS2QQ = 835,
    X86_INS_VCVTTPS2UDQ = 836,
    X86_INS_VCVTTPS2UQQ = 837,
    X86_INS_VCVTTSD2SI = 838,
    X86_INS_VCVTTSD2USI = 839,
    X86_INS_VCVTTSS2SI = 840,
    X86_INS_VCVTTSS2USI = 841,
    X86_INS_VCVTUDQ2PD = 842,
    X86_INS_VCVTUDQ2PS = 843,
    X86_INS_VCVTUQQ2PD = 844,
    X86_INS_VCVTUQQ2PS = 845,
    X86_INS_VCVTUSI2SD = 846,
    X86_INS_VCVTUSI2SS = 847,
    X86_INS_VDBPSADBW = 848,
    X86_INS_VDIVPD = 849,
    X86_INS_VDIVPS = 850,
    X86_INS_VDIVSD = 851,
    X86_INS_VDIVSS = 852,
    X86_INS_VDPPD = 853,
    X86_INS_VDPPS = 854,
    X86_INS_VERR = 855,
    X86_INS_VERW = 856,
    X86_INS_VEXP2PD = 857,
    X86_INS_VEXP2PS = 858,
    X86_INS_VEXPANDPD = 859,
    X86_INS_VEXPANDPS = 860,
    X86_INS_VEXTRACTF128 = 861,
    X86_INS_VEXTRACTF32X4 = 862,
    X86_INS_VEXTRACTF32X8 = 863,
    X86_INS_VEXTRACTF64X2 = 864,
    X86_INS_VEXTRACTF64X4 = 865,
    X86_INS_VEXTRACTI128 = 866,
    X86_INS_VEXTRACTI32X4 = 867,
    X86_INS_VEXTRACTI32X8 = 868,
    X86_INS_VEXTRACTI64X2 = 869,
    X86_INS_VEXTRACTI64X4 = 870,
    X86_INS_VEXTRACTPS = 871,
    X86_INS_VFIXUPIMMPD = 872,
    X86_INS_VFIXUPIMMPS = 873,
    X86_INS_VFIXUPIMMSD = 874,
    X86_INS_VFIXUPIMMSS = 875,
    X86_INS_VFMADD132PD = 876,
    X86_INS_VFMADD132PS = 877,
    X86_INS_VFMADD132SD = 878,
    X86_INS_VFMADD132SS = 879,
    X86_INS_VFMADD213PD = 880,
    X86_INS_VFMADD213PS = 881,
    X86_INS_VFMADD213SD = 882,
    X86_INS_VFMADD213SS = 883,
    X86_INS_VFMADD231PD = 884,
    X86_INS_VFMADD231PS = 885,
    X86_INS_VFMADD231SD = 886,
    X86_INS_VFMADD231SS = 887,
    X86_INS_VFMADDPD = 888,
    X86_INS_VFMADDPS = 889,
    X86_INS_VFMADDSD = 890,
    X86_INS_VFMADDSS = 891,
    X86_INS_VFMADDSUB132PD = 892,
    X86_INS_VFMADDSUB132PS = 893,
    X86_INS_VFMADDSUB213PD = 894,
    X86_INS_VFMADDSUB213PS = 895,
    X86_INS_VFMADDSUB231PD = 896,
    X86_INS_VFMADDSUB231PS = 897,
    X86_INS_VFMADDSUBPD = 898,
    X86_INS_VFMADDSUBPS = 899,
    X86_INS_VFMSUB132PD = 900,
    X86_INS_VFMSUB132PS = 901,
    X86_INS_VFMSUB132SD = 902,
    X86_INS_VFMSUB132SS = 903,
    X86_INS_VFMSUB213PD = 904,
    X86_INS_VFMSUB213PS = 905,
    X86_INS_VFMSUB213SD = 906,
    X86_INS_VFMSUB213SS = 907,
    X86_INS_VFMSUB231PD = 908,
    X86_INS_VFMSUB231PS = 909,
    X86_INS_VFMSUB231SD = 910,
    X86_INS_VFMSUB231SS = 911,
    X86_INS_VFMSUBADD132PD = 912,
    X86_INS_VFMSUBADD132PS = 913,
    X86_INS_VFMSUBADD213PD = 914,
    X86_INS_VFMSUBADD213PS = 915,
    X86_INS_VFMSUBADD231PD = 916,
    X86_INS_VFMSUBADD231PS = 917,
    X86_INS_VFMSUBADDPD = 918,
    X86_INS_VFMSUBADDPS = 919,
    X86_INS_VFMSUBPD = 920,
    X86_INS_VFMSUBPS = 921,
    X86_INS_VFMSUBSD = 922,
    X86_INS_VFMSUBSS = 923,
    X86_INS_VFNMADD132PD = 924,
    X86_INS_VFNMADD132PS = 925,
    X86_INS_VFNMADD132SD = 926,
    X86_INS_VFNMADD132SS = 927,
    X86_INS_VFNMADD213PD = 928,
    X86_INS_VFNMADD213PS = 929,
    X86_INS_VFNMADD213SD = 930,
    X86_INS_VFNMADD213SS = 931,
    X86_INS_VFNMADD231PD = 932,
    X86_INS_VFNMADD231PS = 933,
    X86_INS_VFNMADD231SD = 934,
    X86_INS_VFNMADD231SS = 935,
    X86_INS_VFNMADDPD = 936,
    X86_INS_VFNMADDPS = 937,
    X86_INS_VFNMADDSD = 938,
    X86_INS_VFNMADDSS = 939,
    X86_INS_VFNMSUB132PD = 940,
    X86_INS_VFNMSUB132PS = 941,
    X86_INS_VFNMSUB132SD = 942,
    X86_INS_VFNMSUB132SS = 943,
    X86_INS_VFNMSUB213PD = 944,
    X86_INS_VFNMSUB213PS = 945,
    X86_INS_VFNMSUB213SD = 946,
    X86_INS_VFNMSUB213SS = 947,
    X86_INS_VFNMSUB231PD = 948,
    X86_INS_VFNMSUB231PS = 949,
    X86_INS_VFNMSUB231SD = 950,
    X86_INS_VFNMSUB231SS = 951,
    X86_INS_VFNMSUBPD = 952,
    X86_INS_VFNMSUBPS = 953,
    X86_INS_VFNMSUBSD = 954,
    X86_INS_VFNMSUBSS = 955,
    X86_INS_VFPCLASSPD = 956,
    X86_INS_VFPCLASSPS = 957,
    X86_INS_VFPCLASSSD = 958,
    X86_INS_VFPCLASSSS = 959,
    X86_INS_VFRCZPD = 960,
    X86_INS_VFRCZPS = 961,
    X86_INS_VFRCZSD = 962,
    X86_INS_VFRCZSS = 963,
    X86_INS_VGATHERDPD = 964,
    X86_INS_VGATHERDPS = 965,
    X86_INS_VGATHERPF0DPD = 966,
    X86_INS_VGATHERPF0DPS = 967,
    X86_INS_VGATHERPF0QPD = 968,
    X86_INS_VGATHERPF0QPS = 969,
    X86_INS_VGATHERPF1DPD = 970,
    X86_INS_VGATHERPF1DPS = 971,
    X86_INS_VGATHERPF1QPD = 972,
    X86_INS_VGATHERPF1QPS = 973,
    X86_INS_VGATHERQPD = 974,
    X86_INS_VGATHERQPS = 975,
    X86_INS_VGETEXPPD = 976,
    X86_INS_VGETEXPPS = 977,
    X86_INS_VGETEXPSD = 978,
    X86_INS_VGETEXPSS = 979,
    X86_INS_VGETMANTPD = 980,
    X86_INS_VGETMANTPS = 981,
    X86_INS_VGETMANTSD = 982,
    X86_INS_VGETMANTSS = 983,
    X86_INS_VGF2P8AFFINEINVQB = 984,
    X86_INS_VGF2P8AFFINEQB = 985,
    X86_INS_VGF2P8MULB = 986,
    X86_INS_VHADDPD = 987,
    X86_INS_VHADDPS = 988,
    X86_INS_VHSUBPD = 989,
    X86_INS_VHSUBPS = 990,
    X86_INS_VINSERTF128 = 991,
    X86_INS_VINSERTF32X4 = 992,
    X86_INS_VINSERTF32X8 = 993,
    X86_INS_VINSERTF64X2 = 994,
    X86_INS_VINSERTF64X4 = 995,
    X86_INS_VINSERTI128 = 996,
    X86_INS_VINSERTI32X4 = 997,
    X86_INS_VINSERTI32X8 = 998,
    X86_INS_VINSERTI64X2 = 999,
    X86_INS_VINSERTI64X4 = 1000,
    X86_INS_VINSERTPS = 1001,
    X86_INS_VLDDQU = 1002,
    X86_INS_VLDMXCSR = 1003,
    X86_INS_VMASKMOVDQU = 1004,
    X86_INS_VMASKMOVPD = 1005,
    X86_INS_VMASKMOVPS = 1006,
    X86_INS_VMAXPD = 1007,
    X86_INS_VMAXPS = 1008,
    X86_INS_VMAXSD = 1009,
    X86_INS_VMAXSS = 1010,
    X86_INS_VMCALL = 1011,
    X86_INS_VMCLEAR = 1012,
    X86_INS_VMFUNC = 1013,
    X86_INS_VMINPD = 1014,
    X86_INS_VMINPS = 1015,
    X86_INS_VMINSD = 1016,
    X86_INS_VMINSS = 1017,
    X86_INS_VMLAUNCH = 1018,
    X86_INS_VMLOAD = 1019,
    X86_INS_VMMCALL = 1020,
    X86_INS_VMOVQ = 1021,
    X86_INS_VMOVAPD = 1022,
    X86_INS_VMOVAPS = 1023,
    X86_INS_VMOVDDUP = 1024,
    X86_INS_VMOVD = 1025,
    X86_INS_VMOVDQA32 = 1026,
    X86_INS_VMOVDQA64 = 1027,
    X86_INS_VMOVDQA = 1028,
    X86_INS_VMOVDQU16 = 1029,
    X86_INS_VMOVDQU32 = 1030,
    X86_INS_VMOVDQU64 = 1031,
    X86_INS_VMOVDQU8 = 1032,
    X86_INS_VMOVDQU = 1033,
    X86_INS_VMOVHLPS = 1034,
    X86_INS_VMOVHPD = 1035,
    X86_INS_VMOVHPS = 1036,
    X86_INS_VMOVLHPS = 1037,
    X86_INS_VMOVLPD = 1038,
    X86_INS_VMOVLPS = 1039,
    X86_INS_VMOVMSKPD = 1040,
    X86_INS_VMOVMSKPS = 1041,
    X86_INS_VMOVNTDQA = 1042,
    X86_INS_VMOVNTDQ = 1043,
    X86_INS_VMOVNTPD = 1044,
    X86_INS_VMOVNTPS = 1045,
    X86_INS_VMOVSD = 1046,
    X86_INS_VMOVSHDUP = 1047,
    X86_INS_VMOVSLDUP = 1048,
    X86_INS_VMOVSS = 1049,
    X86_INS_VMOVUPD = 1050,
    X86_INS_VMOVUPS = 1051,
    X86_INS_VMPSADBW = 1052,
    X86_INS_VMPTRLD = 1053,
    X86_INS_VMPTRST = 1054,
    X86_INS_VMREAD = 1055,
    X86_INS_VMRESUME = 1056,
    X86_INS_VMRUN = 1057,
    X86_INS_VMSAVE = 1058,
    X86_INS_VMULPD = 1059,
    X86_INS_VMULPS = 1060,
    X86_INS_VMULSD = 1061,
    X86_INS_VMULSS = 1062,
    X86_INS_VMWRITE = 1063,
    X86_INS_VMXOFF = 1064,
    X86_INS_VMXON = 1065,
    X86_INS_VORPD = 1066,
    X86_INS_VORPS = 1067,
    X86_INS_VP4DPWSSDS = 1068,
    X86_INS_VP4DPWSSD = 1069,
    X86_INS_VPABSB = 1070,
    X86_INS_VPABSD = 1071,
    X86_INS_VPABSQ = 1072,
    X86_INS_VPABSW = 1073,
    X86_INS_VPACKSSDW = 1074,
    X86_INS_VPACKSSWB = 1075,
    X86_INS_VPACKUSDW = 1076,
    X86_INS_VPACKUSWB = 1077,
    X86_INS_VPADDB = 1078,
    X86_INS_VPADDD = 1079,
    X86_INS_VPADDQ = 1080,
    X86_INS_VPADDSB = 1081,
    X86_INS_VPADDSW = 1082,
    X86_INS_VPADDUSB = 1083,
    X86_INS_VPADDUSW = 1084,
    X86_INS_VPADDW = 1085,
    X86_INS_VPALIGNR = 1086,
    X86_INS_VPANDD = 1087,
    X86_INS_VPANDND = 1088,
    X86_INS_VPANDNQ = 1089,
    X86_INS_VPANDN = 1090,
    X86_INS_VPANDQ = 1091,
    X86_INS_VPAND = 1092,
    X86_INS_VPAVGB = 1093,
    X86_INS_VPAVGW = 1094,
    X86_INS_VPBLENDD = 1095,
    X86_INS_VPBLENDMB = 1096,
    X86_INS_VPBLENDMD = 1097,
    X86_INS_VPBLENDMQ = 1098,
    X86_INS_VPBLENDMW = 1099,
    X86_INS_VPBLENDVB = 1100,
    X86_INS_VPBLENDW = 1101,
    X86_INS_VPBROADCASTB = 1102,
    X86_INS_VPBROADCASTD = 1103,
    X86_INS_VPBROADCASTMB2Q = 1104,
    X86_INS_VPBROADCASTMW2D = 1105,
    X86_INS_VPBROADCASTQ = 1106,
    X86_INS_VPBROADCASTW = 1107,
    X86_INS_VPCLMULQDQ = 1108,
    X86_INS_VPCMOV = 1109,
    X86_INS_VPCMP = 1110,
    X86_INS_VPCMPB = 1111,
    X86_INS_VPCMPD = 1112,
    X86_INS_VPCMPEQB = 1113,
    X86_INS_VPCMPEQD = 1114,
    X86_INS_VPCMPEQQ = 1115,
    X86_INS_VPCMPEQW = 1116,
    X86_INS_VPCMPESTRI = 1117,
    X86_INS_VPCMPESTRM = 1118,
    X86_INS_VPCMPGTB = 1119,
    X86_INS_VPCMPGTD = 1120,
    X86_INS_VPCMPGTQ = 1121,
    X86_INS_VPCMPGTW = 1122,
    X86_INS_VPCMPISTRI = 1123,
    X86_INS_VPCMPISTRM = 1124,
    X86_INS_VPCMPQ = 1125,
    X86_INS_VPCMPUB = 1126,
    X86_INS_VPCMPUD = 1127,
    X86_INS_VPCMPUQ = 1128,
    X86_INS_VPCMPUW = 1129,
    X86_INS_VPCMPW = 1130,
    X86_INS_VPCOM = 1131,
    X86_INS_VPCOMB = 1132,
    X86_INS_VPCOMD = 1133,
    X86_INS_VPCOMPRESSB = 1134,
    X86_INS_VPCOMPRESSD = 1135,
    X86_INS_VPCOMPRESSQ = 1136,
    X86_INS_VPCOMPRESSW = 1137,
    X86_INS_VPCOMQ = 1138,
    X86_INS_VPCOMUB = 1139,
    X86_INS_VPCOMUD = 1140,
    X86_INS_VPCOMUQ = 1141,
    X86_INS_VPCOMUW = 1142,
    X86_INS_VPCOMW = 1143,
    X86_INS_VPCONFLICTD = 1144,
    X86_INS_VPCONFLICTQ = 1145,
    X86_INS_VPDPBUSDS = 1146,
    X86_INS_VPDPBUSD = 1147,
    X86_INS_VPDPWSSDS = 1148,
    X86_INS_VPDPWSSD = 1149,
    X86_INS_VPERM2F128 = 1150,
    X86_INS_VPERM2I128 = 1151,
    X86_INS_VPERMB = 1152,
    X86_INS_VPERMD = 1153,
    X86_INS_VPERMI2B = 1154,
    X86_INS_VPERMI2D = 1155,
    X86_INS_VPERMI2PD = 1156,
    X86_INS_VPERMI2PS = 1157,
    X86_INS_VPERMI2Q = 1158,
    X86_INS_VPERMI2W = 1159,
    X86_INS_VPERMIL2PD = 1160,
    X86_INS_VPERMILPD = 1161,
    X86_INS_VPERMIL2PS = 1162,
    X86_INS_VPERMILPS = 1163,
    X86_INS_VPERMPD = 1164,
    X86_INS_VPERMPS = 1165,
    X86_INS_VPERMQ = 1166,
    X86_INS_VPERMT2B = 1167,
    X86_INS_VPERMT2D = 1168,
    X86_INS_VPERMT2PD = 1169,
    X86_INS_VPERMT2PS = 1170,
    X86_INS_VPERMT2Q = 1171,
    X86_INS_VPERMT2W = 1172,
    X86_INS_VPERMW = 1173,
    X86_INS_VPEXPANDB = 1174,
    X86_INS_VPEXPANDD = 1175,
    X86_INS_VPEXPANDQ = 1176,
    X86_INS_VPEXPANDW = 1177,
    X86_INS_VPEXTRB = 1178,
    X86_INS_VPEXTRD = 1179,
    X86_INS_VPEXTRQ = 1180,
    X86_INS_VPEXTRW = 1181,
    X86_INS_VPGATHERDD = 1182,
    X86_INS_VPGATHERDQ = 1183,
    X86_INS_VPGATHERQD = 1184,
    X86_INS_VPGATHERQQ = 1185,
    X86_INS_VPHADDBD = 1186,
    X86_INS_VPHADDBQ = 1187,
    X86_INS_VPHADDBW = 1188,
    X86_INS_VPHADDDQ = 1189,
    X86_INS_VPHADDD = 1190,
    X86_INS_VPHADDSW = 1191,
    X86_INS_VPHADDUBD = 1192,
    X86_INS_VPHADDUBQ = 1193,
    X86_INS_VPHADDUBW = 1194,
    X86_INS_VPHADDUDQ = 1195,
    X86_INS_VPHADDUWD = 1196,
    X86_INS_VPHADDUWQ = 1197,
    X86_INS_VPHADDWD = 1198,
    X86_INS_VPHADDWQ = 1199,
    X86_INS_VPHADDW = 1200,
    X86_INS_VPHMINPOSUW = 1201,
    X86_INS_VPHSUBBW = 1202,
    X86_INS_VPHSUBDQ = 1203,
    X86_INS_VPHSUBD = 1204,
    X86_INS_VPHSUBSW = 1205,
    X86_INS_VPHSUBWD = 1206,
    X86_INS_VPHSUBW = 1207,
    X86_INS_VPINSRB = 1208,
    X86_INS_VPINSRD = 1209,
    X86_INS_VPINSRQ = 1210,
    X86_INS_VPINSRW = 1211,
    X86_INS_VPLZCNTD = 1212,
    X86_INS_VPLZCNTQ = 1213,
    X86_INS_VPMACSDD = 1214,
    X86_INS_VPMACSDQH = 1215,
    X86_INS_VPMACSDQL = 1216,
    X86_INS_VPMACSSDD = 1217,
    X86_INS_VPMACSSDQH = 1218,
    X86_INS_VPMACSSDQL = 1219,
    X86_INS_VPMACSSWD = 1220,
    X86_INS_VPMACSSWW = 1221,
    X86_INS_VPMACSWD = 1222,
    X86_INS_VPMACSWW = 1223,
    X86_INS_VPMADCSSWD = 1224,
    X86_INS_VPMADCSWD = 1225,
    X86_INS_VPMADD52HUQ = 1226,
    X86_INS_VPMADD52LUQ = 1227,
    X86_INS_VPMADDUBSW = 1228,
    X86_INS_VPMADDWD = 1229,
    X86_INS_VPMASKMOVD = 1230,
    X86_INS_VPMASKMOVQ = 1231,
    X86_INS_VPMAXSB = 1232,
    X86_INS_VPMAXSD = 1233,
    X86_INS_VPMAXSQ = 1234,
    X86_INS_VPMAXSW = 1235,
    X86_INS_VPMAXUB = 1236,
    X86_INS_VPMAXUD = 1237,
    X86_INS_VPMAXUQ = 1238,
    X86_INS_VPMAXUW = 1239,
    X86_INS_VPMINSB = 1240,
    X86_INS_VPMINSD = 1241,
    X86_INS_VPMINSQ = 1242,
    X86_INS_VPMINSW = 1243,
    X86_INS_VPMINUB = 1244,
    X86_INS_VPMINUD = 1245,
    X86_INS_VPMINUQ = 1246,
    X86_INS_VPMINUW = 1247,
    X86_INS_VPMOVB2M = 1248,
    X86_INS_VPMOVD2M = 1249,
    X86_INS_VPMOVDB = 1250,
    X86_INS_VPMOVDW = 1251,
    X86_INS_VPMOVM2B = 1252,
    X86_INS_VPMOVM2D = 1253,
    X86_INS_VPMOVM2Q = 1254,
    X86_INS_VPMOVM2W = 1255,
    X86_INS_VPMOVMSKB = 1256,
    X86_INS_VPMOVQ2M = 1257,
    X86_INS_VPMOVQB = 1258,
    X86_INS_VPMOVQD = 1259,
    X86_INS_VPMOVQW = 1260,
    X86_INS_VPMOVSDB = 1261,
    X86_INS_VPMOVSDW = 1262,
    X86_INS_VPMOVSQB = 1263,
    X86_INS_VPMOVSQD = 1264,
    X86_INS_VPMOVSQW = 1265,
    X86_INS_VPMOVSWB = 1266,
    X86_INS_VPMOVSXBD = 1267,
    X86_INS_VPMOVSXBQ = 1268,
    X86_INS_VPMOVSXBW = 1269,
    X86_INS_VPMOVSXDQ = 1270,
    X86_INS_VPMOVSXWD = 1271,
    X86_INS_VPMOVSXWQ = 1272,
    X86_INS_VPMOVUSDB = 1273,
    X86_INS_VPMOVUSDW = 1274,
    X86_INS_VPMOVUSQB = 1275,
    X86_INS_VPMOVUSQD = 1276,
    X86_INS_VPMOVUSQW = 1277,
    X86_INS_VPMOVUSWB = 1278,
    X86_INS_VPMOVW2M = 1279,
    X86_INS_VPMOVWB = 1280,
    X86_INS_VPMOVZXBD = 1281,
    X86_INS_VPMOVZXBQ = 1282,
    X86_INS_VPMOVZXBW = 1283,
    X86_INS_VPMOVZXDQ = 1284,
    X86_INS_VPMOVZXWD = 1285,
    X86_INS_VPMOVZXWQ = 1286,
    X86_INS_VPMULDQ = 1287,
    X86_INS_VPMULHRSW = 1288,
    X86_INS_VPMULHUW = 1289,
    X86_INS_VPMULHW = 1290,
    X86_INS_VPMULLD = 1291,
    X86_INS_VPMULLQ = 1292,
    X86_INS_VPMULLW = 1293,
    X86_INS_VPMULTISHIFTQB = 1294,
    X86_INS_VPMULUDQ = 1295,
    X86_INS_VPOPCNTB = 1296,
    X86_INS_VPOPCNTD = 1297,
    X86_INS_VPOPCNTQ = 1298,
    X86_INS_VPOPCNTW = 1299,
    X86_INS_VPORD = 1300,
    X86_INS_VPORQ = 1301,
    X86_INS_VPOR = 1302,
    X86_INS_VPPERM = 1303,
    X86_INS_VPROLD = 1304,
    X86_INS_VPROLQ = 1305,
    X86_INS_VPROLVD = 1306,
    X86_INS_VPROLVQ = 1307,
    X86_INS_VPRORD = 1308,
    X86_INS_VPRORQ = 1309,
    X86_INS_VPRORVD = 1310,
    X86_INS_VPRORVQ = 1311,
    X86_INS_VPROTB = 1312,
    X86_INS_VPROTD = 1313,
    X86_INS_VPROTQ = 1314,
    X86_INS_VPROTW = 1315,
    X86_INS_VPSADBW = 1316,
    X86_INS_VPSCATTERDD = 1317,
    X86_INS_VPSCATTERDQ = 1318,
    X86_INS_VPSCATTERQD = 1319,
    X86_INS_VPSCATTERQQ = 1320,
    X86_INS_VPSHAB = 1321,
    X86_INS_VPSHAD = 1322,
    X86_INS_VPSHAQ = 1323,
    X86_INS_VPSHAW = 1324,
    X86_INS_VPSHLB = 1325,
    X86_INS_VPSHLDD = 1326,
    X86_INS_VPSHLDQ = 1327,
    X86_INS_VPSHLDVD = 1328,
    X86_INS_VPSHLDVQ = 1329,
    X86_INS_VPSHLDVW = 1330,
    X86_INS_VPSHLDW = 1331,
    X86_INS_VPSHLD = 1332,
    X86_INS_VPSHLQ = 1333,
    X86_INS_VPSHLW = 1334,
    X86_INS_VPSHRDD = 1335,
    X86_INS_VPSHRDQ = 1336,
    X86_INS_VPSHRDVD = 1337,
    X86_INS_VPSHRDVQ = 1338,
    X86_INS_VPSHRDVW = 1339,
    X86_INS_VPSHRDW = 1340,
    X86_INS_VPSHUFBITQMB = 1341,
    X86_INS_VPSHUFB = 1342,
    X86_INS_VPSHUFD = 1343,
    X86_INS_VPSHUFHW = 1344,
    X86_INS_VPSHUFLW = 1345,
    X86_INS_VPSIGNB = 1346,
    X86_INS_VPSIGND = 1347,
    X86_INS_VPSIGNW = 1348,
    X86_INS_VPSLLDQ = 1349,
    X86_INS_VPSLLD = 1350,
    X86_INS_VPSLLQ = 1351,
    X86_INS_VPSLLVD = 1352,
    X86_INS_VPSLLVQ = 1353,
    X86_INS_VPSLLVW = 1354,
    X86_INS_VPSLLW = 1355,
    X86_INS_VPSRAD = 1356,
    X86_INS_VPSRAQ = 1357,
    X86_INS_VPSRAVD = 1358,
    X86_INS_VPSRAVQ = 1359,
    X86_INS_VPSRAVW = 1360,
    X86_INS_VPSRAW = 1361,
    X86_INS_VPSRLDQ = 1362,
    X86_INS_VPSRLD = 1363,
    X86_INS_VPSRLQ = 1364,
    X86_INS_VPSRLVD = 1365,
    X86_INS_VPSRLVQ = 1366,
    X86_INS_VPSRLVW = 1367,
    X86_INS_VPSRLW = 1368,
    X86_INS_VPSUBB = 1369,
    X86_INS_VPSUBD = 1370,
    X86_INS_VPSUBQ = 1371,
    X86_INS_VPSUBSB = 1372,
    X86_INS_VPSUBSW = 1373,
    X86_INS_VPSUBUSB = 1374,
    X86_INS_VPSUBUSW = 1375,
    X86_INS_VPSUBW = 1376,
    X86_INS_VPTERNLOGD = 1377,
    X86_INS_VPTERNLOGQ = 1378,
    X86_INS_VPTESTMB = 1379,
    X86_INS_VPTESTMD = 1380,
    X86_INS_VPTESTMQ = 1381,
    X86_INS_VPTESTMW = 1382,
    X86_INS_VPTESTNMB = 1383,
    X86_INS_VPTESTNMD = 1384,
    X86_INS_VPTESTNMQ = 1385,
    X86_INS_VPTESTNMW = 1386,
    X86_INS_VPTEST = 1387,
    X86_INS_VPUNPCKHBW = 1388,
    X86_INS_VPUNPCKHDQ = 1389,
    X86_INS_VPUNPCKHQDQ = 1390,
    X86_INS_VPUNPCKHWD = 1391,
    X86_INS_VPUNPCKLBW = 1392,
    X86_INS_VPUNPCKLDQ = 1393,
    X86_INS_VPUNPCKLQDQ = 1394,
    X86_INS_VPUNPCKLWD = 1395,
    X86_INS_VPXORD = 1396,
    X86_INS_VPXORQ = 1397,
    X86_INS_VPXOR = 1398,
    X86_INS_VRANGEPD = 1399,
    X86_INS_VRANGEPS = 1400,
    X86_INS_VRANGESD = 1401,
    X86_INS_VRANGESS = 1402,
    X86_INS_VRCP14PD = 1403,
    X86_INS_VRCP14PS = 1404,
    X86_INS_VRCP14SD = 1405,
    X86_INS_VRCP14SS = 1406,
    X86_INS_VRCP28PD = 1407,
    X86_INS_VRCP28PS = 1408,
    X86_INS_VRCP28SD = 1409,
    X86_INS_VRCP28SS = 1410,
    X86_INS_VRCPPS = 1411,
    X86_INS_VRCPSS = 1412,
    X86_INS_VREDUCEPD = 1413,
    X86_INS_VREDUCEPS = 1414,
    X86_INS_VREDUCESD = 1415,
    X86_INS_VREDUCESS = 1416,
    X86_INS_VRNDSCALEPD = 1417,
    X86_INS_VRNDSCALEPS = 1418,
    X86_INS_VRNDSCALESD = 1419,
    X86_INS_VRNDSCALESS = 1420,
    X86_INS_VROUNDPD = 1421,
    X86_INS_VROUNDPS = 1422,
    X86_INS_VROUNDSD = 1423,
    X86_INS_VROUNDSS = 1424,
    X86_INS_VRSQRT14PD = 1425,
    X86_INS_VRSQRT14PS = 1426,
    X86_INS_VRSQRT14SD = 1427,
    X86_INS_VRSQRT14SS = 1428,
    X86_INS_VRSQRT28PD = 1429,
    X86_INS_VRSQRT28PS = 1430,
    X86_INS_VRSQRT28SD = 1431,
    X86_INS_VRSQRT28SS = 1432,
    X86_INS_VRSQRTPS = 1433,
    X86_INS_VRSQRTSS = 1434,
    X86_INS_VSCALEFPD = 1435,
    X86_INS_VSCALEFPS = 1436,
    X86_INS_VSCALEFSD = 1437,
    X86_INS_VSCALEFSS = 1438,
    X86_INS_VSCATTERDPD = 1439,
    X86_INS_VSCATTERDPS = 1440,
    X86_INS_VSCATTERPF0DPD = 1441,
    X86_INS_VSCATTERPF0DPS = 1442,
    X86_INS_VSCATTERPF0QPD = 1443,
    X86_INS_VSCATTERPF0QPS = 1444,
    X86_INS_VSCATTERPF1DPD = 1445,
    X86_INS_VSCATTERPF1DPS = 1446,
    X86_INS_VSCATTERPF1QPD = 1447,
    X86_INS_VSCATTERPF1QPS = 1448,
    X86_INS_VSCATTERQPD = 1449,
    X86_INS_VSCATTERQPS = 1450,
    X86_INS_VSHUFF32X4 = 1451,
    X86_INS_VSHUFF64X2 = 1452,
    X86_INS_VSHUFI32X4 = 1453,
    X86_INS_VSHUFI64X2 = 1454,
    X86_INS_VSHUFPD = 1455,
    X86_INS_VSHUFPS = 1456,
    X86_INS_VSQRTPD = 1457,
    X86_INS_VSQRTPS = 1458,
    X86_INS_VSQRTSD = 1459,
    X86_INS_VSQRTSS = 1460,
    X86_INS_VSTMXCSR = 1461,
    X86_INS_VSUBPD = 1462,
    X86_INS_VSUBPS = 1463,
    X86_INS_VSUBSD = 1464,
    X86_INS_VSUBSS = 1465,
    X86_INS_VTESTPD = 1466,
    X86_INS_VTESTPS = 1467,
    X86_INS_VUCOMISD = 1468,
    X86_INS_VUCOMISS = 1469,
    X86_INS_VUNPCKHPD = 1470,
    X86_INS_VUNPCKHPS = 1471,
    X86_INS_VUNPCKLPD = 1472,
    X86_INS_VUNPCKLPS = 1473,
    X86_INS_VXORPD = 1474,
    X86_INS_VXORPS = 1475,
    X86_INS_VZEROALL = 1476,
    X86_INS_VZEROUPPER = 1477,
    X86_INS_WAIT = 1478,
    X86_INS_WBINVD = 1479,
    X86_INS_WBNOINVD = 1480,
    X86_INS_WRFSBASE = 1481,
    X86_INS_WRGSBASE = 1482,
    X86_INS_WRMSR = 1483,
    X86_INS_WRPKRU = 1484,
    X86_INS_WRSSD = 1485,
    X86_INS_WRSSQ = 1486,
    X86_INS_WRUSSD = 1487,
    X86_INS_WRUSSQ = 1488,
    X86_INS_XABORT = 1489,
    X86_INS_XACQUIRE = 1490,
    X86_INS_XADD = 1491,
    X86_INS_XBEGIN = 1492,
    X86_INS_XCHG = 1493,
    X86_INS_FXCH = 1494,
    X86_INS_XCRYPTCBC = 1495,
    X86_INS_XCRYPTCFB = 1496,
    X86_INS_XCRYPTCTR = 1497,
    X86_INS_XCRYPTECB = 1498,
    X86_INS_XCRYPTOFB = 1499,
    X86_INS_XEND = 1500,
    X86_INS_XGETBV = 1501,
    X86_INS_XLATB = 1502,
    X86_INS_XOR = 1503,
    X86_INS_XORPD = 1504,
    X86_INS_XORPS = 1505,
    X86_INS_XRELEASE = 1506,
    X86_INS_XRSTOR = 1507,
    X86_INS_XRSTOR64 = 1508,
    X86_INS_XRSTORS = 1509,
    X86_INS_XRSTORS64 = 1510,
    X86_INS_XSAVE = 1511,
    X86_INS_XSAVE64 = 1512,
    X86_INS_XSAVEC = 1513,
    X86_INS_XSAVEC64 = 1514,
    X86_INS_XSAVEOPT = 1515,
    X86_INS_XSAVEOPT64 = 1516,
    X86_INS_XSAVES = 1517,
    X86_INS_XSAVES64 = 1518,
    X86_INS_XSETBV = 1519,
    X86_INS_XSHA1 = 1520,
    X86_INS_XSHA256 = 1521,
    X86_INS_XSTORE = 1522,
    X86_INS_XTEST = 1523,
    X86_INS_ENDING = 1524,
}
pub mod x86_insn_group {
    #[doc = " Group of X86 instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const X86_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const X86_GRP_JUMP: Type = 1;
    #[doc = "< = CS_GRP_CALL"]
    pub const X86_GRP_CALL: Type = 2;
    #[doc = "< = CS_GRP_RET"]
    pub const X86_GRP_RET: Type = 3;
    #[doc = "< = CS_GRP_INT"]
    pub const X86_GRP_INT: Type = 4;
    #[doc = "< = CS_GRP_IRET"]
    pub const X86_GRP_IRET: Type = 5;
    #[doc = "< = CS_GRP_PRIVILEGE"]
    pub const X86_GRP_PRIVILEGE: Type = 6;
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    pub const X86_GRP_BRANCH_RELATIVE: Type = 7;
    #[doc = "< all virtualization instructions (VT-x + AMD-V)"]
    pub const X86_GRP_VM: Type = 128;
    pub const X86_GRP_3DNOW: Type = 129;
    pub const X86_GRP_AES: Type = 130;
    pub const X86_GRP_ADX: Type = 131;
    pub const X86_GRP_AVX: Type = 132;
    pub const X86_GRP_AVX2: Type = 133;
    pub const X86_GRP_AVX512: Type = 134;
    pub const X86_GRP_BMI: Type = 135;
    pub const X86_GRP_BMI2: Type = 136;
    pub const X86_GRP_CMOV: Type = 137;
    pub const X86_GRP_F16C: Type = 138;
    pub const X86_GRP_FMA: Type = 139;
    pub const X86_GRP_FMA4: Type = 140;
    pub const X86_GRP_FSGSBASE: Type = 141;
    pub const X86_GRP_HLE: Type = 142;
    pub const X86_GRP_MMX: Type = 143;
    pub const X86_GRP_MODE32: Type = 144;
    pub const X86_GRP_MODE64: Type = 145;
    pub const X86_GRP_RTM: Type = 146;
    pub const X86_GRP_SHA: Type = 147;
    pub const X86_GRP_SSE1: Type = 148;
    pub const X86_GRP_SSE2: Type = 149;
    pub const X86_GRP_SSE3: Type = 150;
    pub const X86_GRP_SSE41: Type = 151;
    pub const X86_GRP_SSE42: Type = 152;
    pub const X86_GRP_SSE4A: Type = 153;
    pub const X86_GRP_SSSE3: Type = 154;
    pub const X86_GRP_PCLMUL: Type = 155;
    pub const X86_GRP_XOP: Type = 156;
    pub const X86_GRP_CDI: Type = 157;
    pub const X86_GRP_ERI: Type = 158;
    pub const X86_GRP_TBM: Type = 159;
    pub const X86_GRP_16BITMODE: Type = 160;
    pub const X86_GRP_NOT64BITMODE: Type = 161;
    pub const X86_GRP_SGX: Type = 162;
    pub const X86_GRP_DQI: Type = 163;
    pub const X86_GRP_BWI: Type = 164;
    pub const X86_GRP_PFI: Type = 165;
    pub const X86_GRP_VLX: Type = 166;
    pub const X86_GRP_SMAP: Type = 167;
    pub const X86_GRP_NOVLX: Type = 168;
    pub const X86_GRP_FPU: Type = 169;
    pub const X86_GRP_ENDING: Type = 170;
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum xcore_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    XCORE_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    XCORE_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    XCORE_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    XCORE_OP_MEM = 3,
}
pub mod xcore_reg {
    #[doc = " XCore registers"]
    pub type Type = libc::c_uint;
    pub const XCORE_REG_INVALID: Type = 0;
    pub const XCORE_REG_CP: Type = 1;
    pub const XCORE_REG_DP: Type = 2;
    pub const XCORE_REG_LR: Type = 3;
    pub const XCORE_REG_SP: Type = 4;
    pub const XCORE_REG_R0: Type = 5;
    pub const XCORE_REG_R1: Type = 6;
    pub const XCORE_REG_R2: Type = 7;
    pub const XCORE_REG_R3: Type = 8;
    pub const XCORE_REG_R4: Type = 9;
    pub const XCORE_REG_R5: Type = 10;
    pub const XCORE_REG_R6: Type = 11;
    pub const XCORE_REG_R7: Type = 12;
    pub const XCORE_REG_R8: Type = 13;
    pub const XCORE_REG_R9: Type = 14;
    pub const XCORE_REG_R10: Type = 15;
    pub const XCORE_REG_R11: Type = 16;
    #[doc = "< pc"]
    pub const XCORE_REG_PC: Type = 17;
    #[doc = "< save pc"]
    pub const XCORE_REG_SCP: Type = 18;
    pub const XCORE_REG_SSR: Type = 19;
    pub const XCORE_REG_ET: Type = 20;
    pub const XCORE_REG_ED: Type = 21;
    pub const XCORE_REG_SED: Type = 22;
    pub const XCORE_REG_KEP: Type = 23;
    pub const XCORE_REG_KSP: Type = 24;
    pub const XCORE_REG_ID: Type = 25;
    pub const XCORE_REG_ENDING: Type = 26;
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with XCORE_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct xcore_op_mem {
    #[doc = "< base register, can be safely interpreted as"]
    #[doc = "< a value of type `xcore_reg`, but it is only"]
    #[doc = "< one byte wide"]
    pub base: u8,
    #[doc = "< index register, same conditions apply here"]
    pub index: u8,
    #[doc = "< displacement/offset value"]
    pub disp: i32,
    #[doc = "< +1: forward, -1: backward"]
    pub direct: libc::c_int,
}
impl Clone for xcore_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_xcore_op {
    #[doc = "< operand type"]
    pub type_: xcore_op_type,
    pub __bindgen_anon_1: cs_xcore_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_xcore_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: xcore_reg::Type,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i32,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: xcore_op_mem,
}
impl Clone for cs_xcore_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_xcore_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_xcore_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_xcore_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_xcore_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_xcore_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_xcore {
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_xcore_op; 8usize],
}
impl Clone for cs_xcore {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_xcore {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_xcore {{ op_count: {:?}, operands: {:?} }}",
            self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " XCore instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum xcore_insn {
    XCORE_INS_INVALID = 0,
    XCORE_INS_ADD = 1,
    XCORE_INS_ANDNOT = 2,
    XCORE_INS_AND = 3,
    XCORE_INS_ASHR = 4,
    XCORE_INS_BAU = 5,
    XCORE_INS_BITREV = 6,
    XCORE_INS_BLA = 7,
    XCORE_INS_BLAT = 8,
    XCORE_INS_BL = 9,
    XCORE_INS_BF = 10,
    XCORE_INS_BT = 11,
    XCORE_INS_BU = 12,
    XCORE_INS_BRU = 13,
    XCORE_INS_BYTEREV = 14,
    XCORE_INS_CHKCT = 15,
    XCORE_INS_CLRE = 16,
    XCORE_INS_CLRPT = 17,
    XCORE_INS_CLRSR = 18,
    XCORE_INS_CLZ = 19,
    XCORE_INS_CRC8 = 20,
    XCORE_INS_CRC32 = 21,
    XCORE_INS_DCALL = 22,
    XCORE_INS_DENTSP = 23,
    XCORE_INS_DGETREG = 24,
    XCORE_INS_DIVS = 25,
    XCORE_INS_DIVU = 26,
    XCORE_INS_DRESTSP = 27,
    XCORE_INS_DRET = 28,
    XCORE_INS_ECALLF = 29,
    XCORE_INS_ECALLT = 30,
    XCORE_INS_EDU = 31,
    XCORE_INS_EEF = 32,
    XCORE_INS_EET = 33,
    XCORE_INS_EEU = 34,
    XCORE_INS_ENDIN = 35,
    XCORE_INS_ENTSP = 36,
    XCORE_INS_EQ = 37,
    XCORE_INS_EXTDP = 38,
    XCORE_INS_EXTSP = 39,
    XCORE_INS_FREER = 40,
    XCORE_INS_FREET = 41,
    XCORE_INS_GETD = 42,
    XCORE_INS_GET = 43,
    XCORE_INS_GETN = 44,
    XCORE_INS_GETR = 45,
    XCORE_INS_GETSR = 46,
    XCORE_INS_GETST = 47,
    XCORE_INS_GETTS = 48,
    XCORE_INS_INCT = 49,
    XCORE_INS_INIT = 50,
    XCORE_INS_INPW = 51,
    XCORE_INS_INSHR = 52,
    XCORE_INS_INT = 53,
    XCORE_INS_IN = 54,
    XCORE_INS_KCALL = 55,
    XCORE_INS_KENTSP = 56,
    XCORE_INS_KRESTSP = 57,
    XCORE_INS_KRET = 58,
    XCORE_INS_LADD = 59,
    XCORE_INS_LD16S = 60,
    XCORE_INS_LD8U = 61,
    XCORE_INS_LDA16 = 62,
    XCORE_INS_LDAP = 63,
    XCORE_INS_LDAW = 64,
    XCORE_INS_LDC = 65,
    XCORE_INS_LDW = 66,
    XCORE_INS_LDIVU = 67,
    XCORE_INS_LMUL = 68,
    XCORE_INS_LSS = 69,
    XCORE_INS_LSUB = 70,
    XCORE_INS_LSU = 71,
    XCORE_INS_MACCS = 72,
    XCORE_INS_MACCU = 73,
    XCORE_INS_MJOIN = 74,
    XCORE_INS_MKMSK = 75,
    XCORE_INS_MSYNC = 76,
    XCORE_INS_MUL = 77,
    XCORE_INS_NEG = 78,
    XCORE_INS_NOT = 79,
    XCORE_INS_OR = 80,
    XCORE_INS_OUTCT = 81,
    XCORE_INS_OUTPW = 82,
    XCORE_INS_OUTSHR = 83,
    XCORE_INS_OUTT = 84,
    XCORE_INS_OUT = 85,
    XCORE_INS_PEEK = 86,
    XCORE_INS_REMS = 87,
    XCORE_INS_REMU = 88,
    XCORE_INS_RETSP = 89,
    XCORE_INS_SETCLK = 90,
    XCORE_INS_SET = 91,
    XCORE_INS_SETC = 92,
    XCORE_INS_SETD = 93,
    XCORE_INS_SETEV = 94,
    XCORE_INS_SETN = 95,
    XCORE_INS_SETPSC = 96,
    XCORE_INS_SETPT = 97,
    XCORE_INS_SETRDY = 98,
    XCORE_INS_SETSR = 99,
    XCORE_INS_SETTW = 100,
    XCORE_INS_SETV = 101,
    XCORE_INS_SEXT = 102,
    XCORE_INS_SHL = 103,
    XCORE_INS_SHR = 104,
    XCORE_INS_SSYNC = 105,
    XCORE_INS_ST16 = 106,
    XCORE_INS_ST8 = 107,
    XCORE_INS_STW = 108,
    XCORE_INS_SUB = 109,
    XCORE_INS_SYNCR = 110,
    XCORE_INS_TESTCT = 111,
    XCORE_INS_TESTLCL = 112,
    XCORE_INS_TESTWCT = 113,
    XCORE_INS_TSETMR = 114,
    XCORE_INS_START = 115,
    XCORE_INS_WAITEF = 116,
    XCORE_INS_WAITET = 117,
    XCORE_INS_WAITEU = 118,
    XCORE_INS_XOR = 119,
    XCORE_INS_ZEXT = 120,
    XCORE_INS_ENDING = 121,
}
pub mod xcore_insn_group {
    #[doc = " Group of XCore instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const XCORE_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const XCORE_GRP_JUMP: Type = 1;
    pub const XCORE_GRP_ENDING: Type = 2;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tms320c64x_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    TMS320C64X_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    TMS320C64X_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    TMS320C64X_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    TMS320C64X_OP_MEM = 3,
    #[doc = "< Register pair for double word ops"]
    TMS320C64X_OP_REGPAIR = 64,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tms320c64x_mem_disp {
    TMS320C64X_MEM_DISP_INVALID = 0,
    TMS320C64X_MEM_DISP_CONSTANT = 1,
    TMS320C64X_MEM_DISP_REGISTER = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tms320c64x_mem_dir {
    TMS320C64X_MEM_DIR_INVALID = 0,
    TMS320C64X_MEM_DIR_FW = 1,
    TMS320C64X_MEM_DIR_BW = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tms320c64x_mem_mod {
    TMS320C64X_MEM_MOD_INVALID = 0,
    TMS320C64X_MEM_MOD_NO = 1,
    TMS320C64X_MEM_MOD_PRE = 2,
    TMS320C64X_MEM_MOD_POST = 3,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct tms320c64x_op_mem {
    #[doc = "< base register"]
    pub base: libc::c_uint,
    #[doc = "< displacement/offset value"]
    pub disp: libc::c_uint,
    #[doc = "< unit of base and offset register"]
    pub unit: libc::c_uint,
    #[doc = "< offset scaled"]
    pub scaled: libc::c_uint,
    #[doc = "< displacement type"]
    pub disptype: libc::c_uint,
    #[doc = "< direction"]
    pub direction: libc::c_uint,
    #[doc = "< modification"]
    pub modify: libc::c_uint,
}
impl Clone for tms320c64x_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_tms320c64x_op {
    #[doc = "< operand type"]
    pub type_: tms320c64x_op_type,
    pub __bindgen_anon_1: cs_tms320c64x_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_tms320c64x_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand or first register for REGPAIR operand"]
    pub reg: libc::c_uint,
    #[doc = "< immediate value for IMM operand"]
    pub imm: i32,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: tms320c64x_op_mem,
}
impl Clone for cs_tms320c64x_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_tms320c64x_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_tms320c64x_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_tms320c64x_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_tms320c64x_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_tms320c64x_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_tms320c64x {
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_tms320c64x_op; 8usize],
    pub condition: cs_tms320c64x__bindgen_ty_1,
    pub funit: cs_tms320c64x__bindgen_ty_2,
    pub parallel: libc::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_tms320c64x__bindgen_ty_1 {
    pub reg: libc::c_uint,
    pub zero: libc::c_uint,
}
impl Clone for cs_tms320c64x__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_tms320c64x__bindgen_ty_2 {
    pub unit: libc::c_uint,
    pub side: libc::c_uint,
    pub crosspath: libc::c_uint,
}
impl Clone for cs_tms320c64x__bindgen_ty_2 {
    fn clone(&self) -> Self {
        *self
    }
}
impl Clone for cs_tms320c64x {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_tms320c64x {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_tms320c64x {{ op_count: {:?}, operands: {:?}, condition: {:?}, funit: {:?}, parallel: {:?} }}" , self . op_count , self . operands , self . condition , self . funit , self . parallel)
    }
}
pub mod tms320c64x_reg {
    pub type Type = libc::c_uint;
    pub const TMS320C64X_REG_INVALID: Type = 0;
    pub const TMS320C64X_REG_AMR: Type = 1;
    pub const TMS320C64X_REG_CSR: Type = 2;
    pub const TMS320C64X_REG_DIER: Type = 3;
    pub const TMS320C64X_REG_DNUM: Type = 4;
    pub const TMS320C64X_REG_ECR: Type = 5;
    pub const TMS320C64X_REG_GFPGFR: Type = 6;
    pub const TMS320C64X_REG_GPLYA: Type = 7;
    pub const TMS320C64X_REG_GPLYB: Type = 8;
    pub const TMS320C64X_REG_ICR: Type = 9;
    pub const TMS320C64X_REG_IER: Type = 10;
    pub const TMS320C64X_REG_IERR: Type = 11;
    pub const TMS320C64X_REG_ILC: Type = 12;
    pub const TMS320C64X_REG_IRP: Type = 13;
    pub const TMS320C64X_REG_ISR: Type = 14;
    pub const TMS320C64X_REG_ISTP: Type = 15;
    pub const TMS320C64X_REG_ITSR: Type = 16;
    pub const TMS320C64X_REG_NRP: Type = 17;
    pub const TMS320C64X_REG_NTSR: Type = 18;
    pub const TMS320C64X_REG_REP: Type = 19;
    pub const TMS320C64X_REG_RILC: Type = 20;
    pub const TMS320C64X_REG_SSR: Type = 21;
    pub const TMS320C64X_REG_TSCH: Type = 22;
    pub const TMS320C64X_REG_TSCL: Type = 23;
    pub const TMS320C64X_REG_TSR: Type = 24;
    pub const TMS320C64X_REG_A0: Type = 25;
    pub const TMS320C64X_REG_A1: Type = 26;
    pub const TMS320C64X_REG_A2: Type = 27;
    pub const TMS320C64X_REG_A3: Type = 28;
    pub const TMS320C64X_REG_A4: Type = 29;
    pub const TMS320C64X_REG_A5: Type = 30;
    pub const TMS320C64X_REG_A6: Type = 31;
    pub const TMS320C64X_REG_A7: Type = 32;
    pub const TMS320C64X_REG_A8: Type = 33;
    pub const TMS320C64X_REG_A9: Type = 34;
    pub const TMS320C64X_REG_A10: Type = 35;
    pub const TMS320C64X_REG_A11: Type = 36;
    pub const TMS320C64X_REG_A12: Type = 37;
    pub const TMS320C64X_REG_A13: Type = 38;
    pub const TMS320C64X_REG_A14: Type = 39;
    pub const TMS320C64X_REG_A15: Type = 40;
    pub const TMS320C64X_REG_A16: Type = 41;
    pub const TMS320C64X_REG_A17: Type = 42;
    pub const TMS320C64X_REG_A18: Type = 43;
    pub const TMS320C64X_REG_A19: Type = 44;
    pub const TMS320C64X_REG_A20: Type = 45;
    pub const TMS320C64X_REG_A21: Type = 46;
    pub const TMS320C64X_REG_A22: Type = 47;
    pub const TMS320C64X_REG_A23: Type = 48;
    pub const TMS320C64X_REG_A24: Type = 49;
    pub const TMS320C64X_REG_A25: Type = 50;
    pub const TMS320C64X_REG_A26: Type = 51;
    pub const TMS320C64X_REG_A27: Type = 52;
    pub const TMS320C64X_REG_A28: Type = 53;
    pub const TMS320C64X_REG_A29: Type = 54;
    pub const TMS320C64X_REG_A30: Type = 55;
    pub const TMS320C64X_REG_A31: Type = 56;
    pub const TMS320C64X_REG_B0: Type = 57;
    pub const TMS320C64X_REG_B1: Type = 58;
    pub const TMS320C64X_REG_B2: Type = 59;
    pub const TMS320C64X_REG_B3: Type = 60;
    pub const TMS320C64X_REG_B4: Type = 61;
    pub const TMS320C64X_REG_B5: Type = 62;
    pub const TMS320C64X_REG_B6: Type = 63;
    pub const TMS320C64X_REG_B7: Type = 64;
    pub const TMS320C64X_REG_B8: Type = 65;
    pub const TMS320C64X_REG_B9: Type = 66;
    pub const TMS320C64X_REG_B10: Type = 67;
    pub const TMS320C64X_REG_B11: Type = 68;
    pub const TMS320C64X_REG_B12: Type = 69;
    pub const TMS320C64X_REG_B13: Type = 70;
    pub const TMS320C64X_REG_B14: Type = 71;
    pub const TMS320C64X_REG_B15: Type = 72;
    pub const TMS320C64X_REG_B16: Type = 73;
    pub const TMS320C64X_REG_B17: Type = 74;
    pub const TMS320C64X_REG_B18: Type = 75;
    pub const TMS320C64X_REG_B19: Type = 76;
    pub const TMS320C64X_REG_B20: Type = 77;
    pub const TMS320C64X_REG_B21: Type = 78;
    pub const TMS320C64X_REG_B22: Type = 79;
    pub const TMS320C64X_REG_B23: Type = 80;
    pub const TMS320C64X_REG_B24: Type = 81;
    pub const TMS320C64X_REG_B25: Type = 82;
    pub const TMS320C64X_REG_B26: Type = 83;
    pub const TMS320C64X_REG_B27: Type = 84;
    pub const TMS320C64X_REG_B28: Type = 85;
    pub const TMS320C64X_REG_B29: Type = 86;
    pub const TMS320C64X_REG_B30: Type = 87;
    pub const TMS320C64X_REG_B31: Type = 88;
    pub const TMS320C64X_REG_PCE1: Type = 89;
    pub const TMS320C64X_REG_ENDING: Type = 90;
    pub const TMS320C64X_REG_EFR: Type = 5;
    pub const TMS320C64X_REG_IFR: Type = 14;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tms320c64x_insn {
    TMS320C64X_INS_INVALID = 0,
    TMS320C64X_INS_ABS = 1,
    TMS320C64X_INS_ABS2 = 2,
    TMS320C64X_INS_ADD = 3,
    TMS320C64X_INS_ADD2 = 4,
    TMS320C64X_INS_ADD4 = 5,
    TMS320C64X_INS_ADDAB = 6,
    TMS320C64X_INS_ADDAD = 7,
    TMS320C64X_INS_ADDAH = 8,
    TMS320C64X_INS_ADDAW = 9,
    TMS320C64X_INS_ADDK = 10,
    TMS320C64X_INS_ADDKPC = 11,
    TMS320C64X_INS_ADDU = 12,
    TMS320C64X_INS_AND = 13,
    TMS320C64X_INS_ANDN = 14,
    TMS320C64X_INS_AVG2 = 15,
    TMS320C64X_INS_AVGU4 = 16,
    TMS320C64X_INS_B = 17,
    TMS320C64X_INS_BDEC = 18,
    TMS320C64X_INS_BITC4 = 19,
    TMS320C64X_INS_BNOP = 20,
    TMS320C64X_INS_BPOS = 21,
    TMS320C64X_INS_CLR = 22,
    TMS320C64X_INS_CMPEQ = 23,
    TMS320C64X_INS_CMPEQ2 = 24,
    TMS320C64X_INS_CMPEQ4 = 25,
    TMS320C64X_INS_CMPGT = 26,
    TMS320C64X_INS_CMPGT2 = 27,
    TMS320C64X_INS_CMPGTU4 = 28,
    TMS320C64X_INS_CMPLT = 29,
    TMS320C64X_INS_CMPLTU = 30,
    TMS320C64X_INS_DEAL = 31,
    TMS320C64X_INS_DOTP2 = 32,
    TMS320C64X_INS_DOTPN2 = 33,
    TMS320C64X_INS_DOTPNRSU2 = 34,
    TMS320C64X_INS_DOTPRSU2 = 35,
    TMS320C64X_INS_DOTPSU4 = 36,
    TMS320C64X_INS_DOTPU4 = 37,
    TMS320C64X_INS_EXT = 38,
    TMS320C64X_INS_EXTU = 39,
    TMS320C64X_INS_GMPGTU = 40,
    TMS320C64X_INS_GMPY4 = 41,
    TMS320C64X_INS_LDB = 42,
    TMS320C64X_INS_LDBU = 43,
    TMS320C64X_INS_LDDW = 44,
    TMS320C64X_INS_LDH = 45,
    TMS320C64X_INS_LDHU = 46,
    TMS320C64X_INS_LDNDW = 47,
    TMS320C64X_INS_LDNW = 48,
    TMS320C64X_INS_LDW = 49,
    TMS320C64X_INS_LMBD = 50,
    TMS320C64X_INS_MAX2 = 51,
    TMS320C64X_INS_MAXU4 = 52,
    TMS320C64X_INS_MIN2 = 53,
    TMS320C64X_INS_MINU4 = 54,
    TMS320C64X_INS_MPY = 55,
    TMS320C64X_INS_MPY2 = 56,
    TMS320C64X_INS_MPYH = 57,
    TMS320C64X_INS_MPYHI = 58,
    TMS320C64X_INS_MPYHIR = 59,
    TMS320C64X_INS_MPYHL = 60,
    TMS320C64X_INS_MPYHLU = 61,
    TMS320C64X_INS_MPYHSLU = 62,
    TMS320C64X_INS_MPYHSU = 63,
    TMS320C64X_INS_MPYHU = 64,
    TMS320C64X_INS_MPYHULS = 65,
    TMS320C64X_INS_MPYHUS = 66,
    TMS320C64X_INS_MPYLH = 67,
    TMS320C64X_INS_MPYLHU = 68,
    TMS320C64X_INS_MPYLI = 69,
    TMS320C64X_INS_MPYLIR = 70,
    TMS320C64X_INS_MPYLSHU = 71,
    TMS320C64X_INS_MPYLUHS = 72,
    TMS320C64X_INS_MPYSU = 73,
    TMS320C64X_INS_MPYSU4 = 74,
    TMS320C64X_INS_MPYU = 75,
    TMS320C64X_INS_MPYU4 = 76,
    TMS320C64X_INS_MPYUS = 77,
    TMS320C64X_INS_MVC = 78,
    TMS320C64X_INS_MVD = 79,
    TMS320C64X_INS_MVK = 80,
    TMS320C64X_INS_MVKL = 81,
    TMS320C64X_INS_MVKLH = 82,
    TMS320C64X_INS_NOP = 83,
    TMS320C64X_INS_NORM = 84,
    TMS320C64X_INS_OR = 85,
    TMS320C64X_INS_PACK2 = 86,
    TMS320C64X_INS_PACKH2 = 87,
    TMS320C64X_INS_PACKH4 = 88,
    TMS320C64X_INS_PACKHL2 = 89,
    TMS320C64X_INS_PACKL4 = 90,
    TMS320C64X_INS_PACKLH2 = 91,
    TMS320C64X_INS_ROTL = 92,
    TMS320C64X_INS_SADD = 93,
    TMS320C64X_INS_SADD2 = 94,
    TMS320C64X_INS_SADDU4 = 95,
    TMS320C64X_INS_SADDUS2 = 96,
    TMS320C64X_INS_SAT = 97,
    TMS320C64X_INS_SET = 98,
    TMS320C64X_INS_SHFL = 99,
    TMS320C64X_INS_SHL = 100,
    TMS320C64X_INS_SHLMB = 101,
    TMS320C64X_INS_SHR = 102,
    TMS320C64X_INS_SHR2 = 103,
    TMS320C64X_INS_SHRMB = 104,
    TMS320C64X_INS_SHRU = 105,
    TMS320C64X_INS_SHRU2 = 106,
    TMS320C64X_INS_SMPY = 107,
    TMS320C64X_INS_SMPY2 = 108,
    TMS320C64X_INS_SMPYH = 109,
    TMS320C64X_INS_SMPYHL = 110,
    TMS320C64X_INS_SMPYLH = 111,
    TMS320C64X_INS_SPACK2 = 112,
    TMS320C64X_INS_SPACKU4 = 113,
    TMS320C64X_INS_SSHL = 114,
    TMS320C64X_INS_SSHVL = 115,
    TMS320C64X_INS_SSHVR = 116,
    TMS320C64X_INS_SSUB = 117,
    TMS320C64X_INS_STB = 118,
    TMS320C64X_INS_STDW = 119,
    TMS320C64X_INS_STH = 120,
    TMS320C64X_INS_STNDW = 121,
    TMS320C64X_INS_STNW = 122,
    TMS320C64X_INS_STW = 123,
    TMS320C64X_INS_SUB = 124,
    TMS320C64X_INS_SUB2 = 125,
    TMS320C64X_INS_SUB4 = 126,
    TMS320C64X_INS_SUBAB = 127,
    TMS320C64X_INS_SUBABS4 = 128,
    TMS320C64X_INS_SUBAH = 129,
    TMS320C64X_INS_SUBAW = 130,
    TMS320C64X_INS_SUBC = 131,
    TMS320C64X_INS_SUBU = 132,
    TMS320C64X_INS_SWAP4 = 133,
    TMS320C64X_INS_UNPKHU4 = 134,
    TMS320C64X_INS_UNPKLU4 = 135,
    TMS320C64X_INS_XOR = 136,
    TMS320C64X_INS_XPND2 = 137,
    TMS320C64X_INS_XPND4 = 138,
    TMS320C64X_INS_IDLE = 139,
    TMS320C64X_INS_MV = 140,
    TMS320C64X_INS_NEG = 141,
    TMS320C64X_INS_NOT = 142,
    TMS320C64X_INS_SWAP2 = 143,
    TMS320C64X_INS_ZERO = 144,
    TMS320C64X_INS_ENDING = 145,
}
pub mod tms320c64x_insn_group {
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const TMS320C64X_GRP_INVALID: Type = 0;
    #[doc = "< = CS_GRP_JUMP"]
    pub const TMS320C64X_GRP_JUMP: Type = 1;
    pub const TMS320C64X_GRP_FUNIT_D: Type = 128;
    pub const TMS320C64X_GRP_FUNIT_L: Type = 129;
    pub const TMS320C64X_GRP_FUNIT_M: Type = 130;
    pub const TMS320C64X_GRP_FUNIT_S: Type = 131;
    pub const TMS320C64X_GRP_FUNIT_NO: Type = 132;
    pub const TMS320C64X_GRP_ENDING: Type = 133;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum tms320c64x_funit {
    TMS320C64X_FUNIT_INVALID = 0,
    TMS320C64X_FUNIT_D = 1,
    TMS320C64X_FUNIT_L = 2,
    TMS320C64X_FUNIT_M = 3,
    TMS320C64X_FUNIT_S = 4,
    TMS320C64X_FUNIT_NO = 5,
}
pub mod m680x_reg {
    #[doc = " M680X registers and special registers"]
    pub type Type = libc::c_uint;
    pub const M680X_REG_INVALID: Type = 0;
    #[doc = "< M6800/1/2/3/9, HD6301/9"]
    pub const M680X_REG_A: Type = 1;
    #[doc = "< M6800/1/2/3/9, HD6301/9"]
    pub const M680X_REG_B: Type = 2;
    #[doc = "< HD6309"]
    pub const M680X_REG_E: Type = 3;
    #[doc = "< HD6309"]
    pub const M680X_REG_F: Type = 4;
    #[doc = "< HD6309"]
    pub const M680X_REG_0: Type = 5;
    #[doc = "< M6801/3/9, HD6301/9"]
    pub const M680X_REG_D: Type = 6;
    #[doc = "< HD6309"]
    pub const M680X_REG_W: Type = 7;
    #[doc = "< M6800/1/2/3/9, M6301/9"]
    pub const M680X_REG_CC: Type = 8;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_DP: Type = 9;
    #[doc = "< M6309"]
    pub const M680X_REG_MD: Type = 10;
    #[doc = "< M6808"]
    pub const M680X_REG_HX: Type = 11;
    #[doc = "< M6808"]
    pub const M680X_REG_H: Type = 12;
    #[doc = "< M6800/1/2/3/9, M6301/9"]
    pub const M680X_REG_X: Type = 13;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_Y: Type = 14;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_S: Type = 15;
    #[doc = "< M6809/M6309"]
    pub const M680X_REG_U: Type = 16;
    #[doc = "< M6309"]
    pub const M680X_REG_V: Type = 17;
    #[doc = "< M6309"]
    pub const M680X_REG_Q: Type = 18;
    #[doc = "< M6800/1/2/3/9, M6301/9"]
    pub const M680X_REG_PC: Type = 19;
    #[doc = "< CPU12"]
    pub const M680X_REG_TMP2: Type = 20;
    #[doc = "< CPU12"]
    pub const M680X_REG_TMP3: Type = 21;
    #[doc = "< <-- mark the end of the list of registers"]
    pub const M680X_REG_ENDING: Type = 22;
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m680x_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    M680X_OP_INVALID = 0,
    #[doc = "< = Register operand."]
    M680X_OP_REGISTER = 1,
    #[doc = "< = Immediate operand."]
    M680X_OP_IMMEDIATE = 2,
    #[doc = "< = Indexed addressing operand."]
    M680X_OP_INDEXED = 3,
    #[doc = "< = Extended addressing operand."]
    M680X_OP_EXTENDED = 4,
    #[doc = "< = Direct addressing operand."]
    M680X_OP_DIRECT = 5,
    #[doc = "< = Relative addressing operand."]
    M680X_OP_RELATIVE = 6,
    #[doc = "< = constant operand (Displayed as number only)."]
    #[doc = "< Used e.g. for a bit index or page number."]
    M680X_OP_CONSTANT = 7,
}
#[doc = " Instruction's operand referring to indexed addressing"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m680x_op_idx {
    #[doc = "< base register (or M680X_REG_INVALID if"]
    #[doc = "< irrelevant)"]
    pub base_reg: m680x_reg::Type,
    #[doc = "< offset register (or M680X_REG_INVALID if"]
    #[doc = "< irrelevant)"]
    pub offset_reg: m680x_reg::Type,
    #[doc = "< 5-,8- or 16-bit offset. See also offset_bits."]
    pub offset: i16,
    #[doc = "< = offset addr. if base_reg == M680X_REG_PC."]
    #[doc = "< calculated as offset + PC"]
    pub offset_addr: u16,
    #[doc = "< offset width in bits for indexed addressing"]
    pub offset_bits: u8,
    #[doc = "< inc. or dec. value:"]
    #[doc = "<    0: no inc-/decrement"]
    #[doc = "<    1 .. 8: increment by 1 .. 8"]
    #[doc = "<    -1 .. -8: decrement by 1 .. 8"]
    #[doc = "< if flag M680X_IDX_POST_INC_DEC set it is post"]
    #[doc = "< inc-/decrement otherwise pre inc-/decrement"]
    pub inc_dec: i8,
    #[doc = "< 8-bit flags (see above)"]
    pub flags: u8,
}
impl Clone for m680x_op_idx {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction's memory operand referring to relative addressing (Bcc/LBcc)"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m680x_op_rel {
    #[doc = "< The absolute address."]
    #[doc = "< calculated as PC + offset. PC is the first"]
    #[doc = "< address after the instruction."]
    pub address: u16,
    #[doc = "< the offset/displacement value"]
    pub offset: i16,
}
impl Clone for m680x_op_rel {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction's operand referring to extended addressing"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct m680x_op_ext {
    #[doc = "< The absolute address"]
    pub address: u16,
    #[doc = "< true if extended indirect addressing"]
    pub indirect: bool,
}
impl Clone for m680x_op_ext {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m680x_op {
    pub type_: m680x_op_type,
    pub __bindgen_anon_1: cs_m680x_op__bindgen_ty_1,
    #[doc = "< size of this operand (in bytes)"]
    pub size: u8,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET"]
    pub access: u8,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_m680x_op__bindgen_ty_1 {
    #[doc = "< immediate value for IMM operand"]
    pub imm: i32,
    #[doc = "< register value for REG operand"]
    pub reg: m680x_reg::Type,
    #[doc = "< Indexed addressing operand"]
    pub idx: m680x_op_idx,
    #[doc = "< Relative address. operand (Bcc/LBcc)"]
    pub rel: m680x_op_rel,
    #[doc = "< Extended address"]
    pub ext: m680x_op_ext,
    #[doc = "<</ Direct address (lower 8-bit)"]
    pub direct_addr: u8,
    #[doc = "< constant value (bit index, page nr.)"]
    pub const_val: u8,
}
impl Clone for cs_m680x_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m680x_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_m680x_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_m680x_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m680x_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_m680x_op {{ type: {:?}, __bindgen_anon_1: {:?}, size: {:?}, access: {:?} }}",
            self.type_, self.__bindgen_anon_1, self.size, self.access
        )
    }
}
#[repr(u32)]
#[doc = " Group of M680X instructions"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m680x_group_type {
    M680X_GRP_INVALID = 0,
    #[doc = "< = CS_GRP_JUMP"]
    M680X_GRP_JUMP = 1,
    #[doc = "< = CS_GRP_CALL"]
    M680X_GRP_CALL = 2,
    #[doc = "< = CS_GRP_RET"]
    M680X_GRP_RET = 3,
    #[doc = "< = CS_GRP_INT"]
    M680X_GRP_INT = 4,
    #[doc = "< = CS_GRP_IRET"]
    M680X_GRP_IRET = 5,
    #[doc = "< = CS_GRP_PRIVILEDGE; not used"]
    M680X_GRP_PRIV = 6,
    #[doc = "< = CS_GRP_BRANCH_RELATIVE"]
    M680X_GRP_BRAREL = 7,
    M680X_GRP_ENDING = 8,
}
#[doc = " The M680X instruction and it's operands"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_m680x {
    #[doc = "< See: M680X instruction flags"]
    pub flags: u8,
    #[doc = "< number of operands for the instruction or 0"]
    pub op_count: u8,
    #[doc = "< operands for this insn."]
    pub operands: [cs_m680x_op; 9usize],
}
impl Clone for cs_m680x {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_m680x {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_m680x {{ flags: {:?}, op_count: {:?}, operands: {:?} }}",
            self.flags, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " M680X instruction IDs"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum m680x_insn {
    M680X_INS_INVLD = 0,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_ABA = 1,
    M680X_INS_ABX = 2,
    M680X_INS_ABY = 3,
    M680X_INS_ADC = 4,
    M680X_INS_ADCA = 5,
    M680X_INS_ADCB = 6,
    M680X_INS_ADCD = 7,
    M680X_INS_ADCR = 8,
    M680X_INS_ADD = 9,
    M680X_INS_ADDA = 10,
    M680X_INS_ADDB = 11,
    M680X_INS_ADDD = 12,
    M680X_INS_ADDE = 13,
    M680X_INS_ADDF = 14,
    M680X_INS_ADDR = 15,
    M680X_INS_ADDW = 16,
    M680X_INS_AIM = 17,
    M680X_INS_AIS = 18,
    M680X_INS_AIX = 19,
    M680X_INS_AND = 20,
    M680X_INS_ANDA = 21,
    M680X_INS_ANDB = 22,
    M680X_INS_ANDCC = 23,
    M680X_INS_ANDD = 24,
    M680X_INS_ANDR = 25,
    M680X_INS_ASL = 26,
    M680X_INS_ASLA = 27,
    M680X_INS_ASLB = 28,
    #[doc = "< or LSLD"]
    M680X_INS_ASLD = 29,
    M680X_INS_ASR = 30,
    M680X_INS_ASRA = 31,
    M680X_INS_ASRB = 32,
    M680X_INS_ASRD = 33,
    M680X_INS_ASRX = 34,
    M680X_INS_BAND = 35,
    #[doc = "< or BHS"]
    M680X_INS_BCC = 36,
    M680X_INS_BCLR = 37,
    #[doc = "< or BLO"]
    M680X_INS_BCS = 38,
    M680X_INS_BEOR = 39,
    M680X_INS_BEQ = 40,
    M680X_INS_BGE = 41,
    M680X_INS_BGND = 42,
    M680X_INS_BGT = 43,
    M680X_INS_BHCC = 44,
    M680X_INS_BHCS = 45,
    M680X_INS_BHI = 46,
    M680X_INS_BIAND = 47,
    M680X_INS_BIEOR = 48,
    M680X_INS_BIH = 49,
    M680X_INS_BIL = 50,
    M680X_INS_BIOR = 51,
    M680X_INS_BIT = 52,
    M680X_INS_BITA = 53,
    M680X_INS_BITB = 54,
    M680X_INS_BITD = 55,
    M680X_INS_BITMD = 56,
    M680X_INS_BLE = 57,
    M680X_INS_BLS = 58,
    M680X_INS_BLT = 59,
    M680X_INS_BMC = 60,
    M680X_INS_BMI = 61,
    M680X_INS_BMS = 62,
    M680X_INS_BNE = 63,
    M680X_INS_BOR = 64,
    M680X_INS_BPL = 65,
    M680X_INS_BRCLR = 66,
    M680X_INS_BRSET = 67,
    M680X_INS_BRA = 68,
    M680X_INS_BRN = 69,
    M680X_INS_BSET = 70,
    M680X_INS_BSR = 71,
    M680X_INS_BVC = 72,
    M680X_INS_BVS = 73,
    M680X_INS_CALL = 74,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CBA = 75,
    M680X_INS_CBEQ = 76,
    M680X_INS_CBEQA = 77,
    M680X_INS_CBEQX = 78,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CLC = 79,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CLI = 80,
    M680X_INS_CLR = 81,
    M680X_INS_CLRA = 82,
    M680X_INS_CLRB = 83,
    M680X_INS_CLRD = 84,
    M680X_INS_CLRE = 85,
    M680X_INS_CLRF = 86,
    M680X_INS_CLRH = 87,
    M680X_INS_CLRW = 88,
    M680X_INS_CLRX = 89,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CLV = 90,
    M680X_INS_CMP = 91,
    M680X_INS_CMPA = 92,
    M680X_INS_CMPB = 93,
    M680X_INS_CMPD = 94,
    M680X_INS_CMPE = 95,
    M680X_INS_CMPF = 96,
    M680X_INS_CMPR = 97,
    M680X_INS_CMPS = 98,
    M680X_INS_CMPU = 99,
    M680X_INS_CMPW = 100,
    M680X_INS_CMPX = 101,
    M680X_INS_CMPY = 102,
    M680X_INS_COM = 103,
    M680X_INS_COMA = 104,
    M680X_INS_COMB = 105,
    M680X_INS_COMD = 106,
    M680X_INS_COME = 107,
    M680X_INS_COMF = 108,
    M680X_INS_COMW = 109,
    M680X_INS_COMX = 110,
    M680X_INS_CPD = 111,
    M680X_INS_CPHX = 112,
    M680X_INS_CPS = 113,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_CPX = 114,
    M680X_INS_CPY = 115,
    M680X_INS_CWAI = 116,
    M680X_INS_DAA = 117,
    M680X_INS_DBEQ = 118,
    M680X_INS_DBNE = 119,
    M680X_INS_DBNZ = 120,
    M680X_INS_DBNZA = 121,
    M680X_INS_DBNZX = 122,
    M680X_INS_DEC = 123,
    M680X_INS_DECA = 124,
    M680X_INS_DECB = 125,
    M680X_INS_DECD = 126,
    M680X_INS_DECE = 127,
    M680X_INS_DECF = 128,
    M680X_INS_DECW = 129,
    M680X_INS_DECX = 130,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_DES = 131,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_DEX = 132,
    M680X_INS_DEY = 133,
    M680X_INS_DIV = 134,
    M680X_INS_DIVD = 135,
    M680X_INS_DIVQ = 136,
    M680X_INS_EDIV = 137,
    M680X_INS_EDIVS = 138,
    M680X_INS_EIM = 139,
    M680X_INS_EMACS = 140,
    M680X_INS_EMAXD = 141,
    M680X_INS_EMAXM = 142,
    M680X_INS_EMIND = 143,
    M680X_INS_EMINM = 144,
    M680X_INS_EMUL = 145,
    M680X_INS_EMULS = 146,
    M680X_INS_EOR = 147,
    M680X_INS_EORA = 148,
    M680X_INS_EORB = 149,
    M680X_INS_EORD = 150,
    M680X_INS_EORR = 151,
    M680X_INS_ETBL = 152,
    M680X_INS_EXG = 153,
    M680X_INS_FDIV = 154,
    M680X_INS_IBEQ = 155,
    M680X_INS_IBNE = 156,
    M680X_INS_IDIV = 157,
    M680X_INS_IDIVS = 158,
    M680X_INS_ILLGL = 159,
    M680X_INS_INC = 160,
    M680X_INS_INCA = 161,
    M680X_INS_INCB = 162,
    M680X_INS_INCD = 163,
    M680X_INS_INCE = 164,
    M680X_INS_INCF = 165,
    M680X_INS_INCW = 166,
    M680X_INS_INCX = 167,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_INS = 168,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_INX = 169,
    M680X_INS_INY = 170,
    M680X_INS_JMP = 171,
    M680X_INS_JSR = 172,
    #[doc = "< or LBHS"]
    M680X_INS_LBCC = 173,
    #[doc = "< or LBLO"]
    M680X_INS_LBCS = 174,
    M680X_INS_LBEQ = 175,
    M680X_INS_LBGE = 176,
    M680X_INS_LBGT = 177,
    M680X_INS_LBHI = 178,
    M680X_INS_LBLE = 179,
    M680X_INS_LBLS = 180,
    M680X_INS_LBLT = 181,
    M680X_INS_LBMI = 182,
    M680X_INS_LBNE = 183,
    M680X_INS_LBPL = 184,
    M680X_INS_LBRA = 185,
    M680X_INS_LBRN = 186,
    M680X_INS_LBSR = 187,
    M680X_INS_LBVC = 188,
    M680X_INS_LBVS = 189,
    M680X_INS_LDA = 190,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_LDAA = 191,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_LDAB = 192,
    M680X_INS_LDB = 193,
    M680X_INS_LDBT = 194,
    M680X_INS_LDD = 195,
    M680X_INS_LDE = 196,
    M680X_INS_LDF = 197,
    M680X_INS_LDHX = 198,
    M680X_INS_LDMD = 199,
    M680X_INS_LDQ = 200,
    M680X_INS_LDS = 201,
    M680X_INS_LDU = 202,
    M680X_INS_LDW = 203,
    M680X_INS_LDX = 204,
    M680X_INS_LDY = 205,
    M680X_INS_LEAS = 206,
    M680X_INS_LEAU = 207,
    M680X_INS_LEAX = 208,
    M680X_INS_LEAY = 209,
    M680X_INS_LSL = 210,
    M680X_INS_LSLA = 211,
    M680X_INS_LSLB = 212,
    M680X_INS_LSLD = 213,
    M680X_INS_LSLX = 214,
    M680X_INS_LSR = 215,
    M680X_INS_LSRA = 216,
    M680X_INS_LSRB = 217,
    #[doc = "< or ASRD"]
    M680X_INS_LSRD = 218,
    M680X_INS_LSRW = 219,
    M680X_INS_LSRX = 220,
    M680X_INS_MAXA = 221,
    M680X_INS_MAXM = 222,
    M680X_INS_MEM = 223,
    M680X_INS_MINA = 224,
    M680X_INS_MINM = 225,
    M680X_INS_MOV = 226,
    M680X_INS_MOVB = 227,
    M680X_INS_MOVW = 228,
    M680X_INS_MUL = 229,
    M680X_INS_MULD = 230,
    M680X_INS_NEG = 231,
    M680X_INS_NEGA = 232,
    M680X_INS_NEGB = 233,
    M680X_INS_NEGD = 234,
    M680X_INS_NEGX = 235,
    M680X_INS_NOP = 236,
    M680X_INS_NSA = 237,
    M680X_INS_OIM = 238,
    M680X_INS_ORA = 239,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_ORAA = 240,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_ORAB = 241,
    M680X_INS_ORB = 242,
    M680X_INS_ORCC = 243,
    M680X_INS_ORD = 244,
    M680X_INS_ORR = 245,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PSHA = 246,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PSHB = 247,
    M680X_INS_PSHC = 248,
    M680X_INS_PSHD = 249,
    M680X_INS_PSHH = 250,
    M680X_INS_PSHS = 251,
    M680X_INS_PSHSW = 252,
    M680X_INS_PSHU = 253,
    M680X_INS_PSHUW = 254,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PSHX = 255,
    M680X_INS_PSHY = 256,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PULA = 257,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PULB = 258,
    M680X_INS_PULC = 259,
    M680X_INS_PULD = 260,
    M680X_INS_PULH = 261,
    M680X_INS_PULS = 262,
    M680X_INS_PULSW = 263,
    M680X_INS_PULU = 264,
    M680X_INS_PULUW = 265,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_PULX = 266,
    M680X_INS_PULY = 267,
    M680X_INS_REV = 268,
    M680X_INS_REVW = 269,
    M680X_INS_ROL = 270,
    M680X_INS_ROLA = 271,
    M680X_INS_ROLB = 272,
    M680X_INS_ROLD = 273,
    M680X_INS_ROLW = 274,
    M680X_INS_ROLX = 275,
    M680X_INS_ROR = 276,
    M680X_INS_RORA = 277,
    M680X_INS_RORB = 278,
    M680X_INS_RORD = 279,
    M680X_INS_RORW = 280,
    M680X_INS_RORX = 281,
    M680X_INS_RSP = 282,
    M680X_INS_RTC = 283,
    M680X_INS_RTI = 284,
    M680X_INS_RTS = 285,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_SBA = 286,
    M680X_INS_SBC = 287,
    M680X_INS_SBCA = 288,
    M680X_INS_SBCB = 289,
    M680X_INS_SBCD = 290,
    M680X_INS_SBCR = 291,
    M680X_INS_SEC = 292,
    M680X_INS_SEI = 293,
    M680X_INS_SEV = 294,
    M680X_INS_SEX = 295,
    M680X_INS_SEXW = 296,
    M680X_INS_SLP = 297,
    M680X_INS_STA = 298,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_STAA = 299,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_STAB = 300,
    M680X_INS_STB = 301,
    M680X_INS_STBT = 302,
    M680X_INS_STD = 303,
    M680X_INS_STE = 304,
    M680X_INS_STF = 305,
    M680X_INS_STOP = 306,
    M680X_INS_STHX = 307,
    M680X_INS_STQ = 308,
    M680X_INS_STS = 309,
    M680X_INS_STU = 310,
    M680X_INS_STW = 311,
    M680X_INS_STX = 312,
    M680X_INS_STY = 313,
    M680X_INS_SUB = 314,
    M680X_INS_SUBA = 315,
    M680X_INS_SUBB = 316,
    M680X_INS_SUBD = 317,
    M680X_INS_SUBE = 318,
    M680X_INS_SUBF = 319,
    M680X_INS_SUBR = 320,
    M680X_INS_SUBW = 321,
    M680X_INS_SWI = 322,
    M680X_INS_SWI2 = 323,
    M680X_INS_SWI3 = 324,
    M680X_INS_SYNC = 325,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TAB = 326,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TAP = 327,
    M680X_INS_TAX = 328,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TBA = 329,
    M680X_INS_TBEQ = 330,
    M680X_INS_TBL = 331,
    M680X_INS_TBNE = 332,
    M680X_INS_TEST = 333,
    M680X_INS_TFM = 334,
    M680X_INS_TFR = 335,
    M680X_INS_TIM = 336,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TPA = 337,
    M680X_INS_TST = 338,
    M680X_INS_TSTA = 339,
    M680X_INS_TSTB = 340,
    M680X_INS_TSTD = 341,
    M680X_INS_TSTE = 342,
    M680X_INS_TSTF = 343,
    M680X_INS_TSTW = 344,
    M680X_INS_TSTX = 345,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TSX = 346,
    M680X_INS_TSY = 347,
    M680X_INS_TXA = 348,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_TXS = 349,
    M680X_INS_TYS = 350,
    #[doc = "< M6800/1/2/3"]
    M680X_INS_WAI = 351,
    M680X_INS_WAIT = 352,
    M680X_INS_WAV = 353,
    M680X_INS_WAVR = 354,
    #[doc = "< HD6301"]
    M680X_INS_XGDX = 355,
    M680X_INS_XGDY = 356,
    M680X_INS_ENDING = 357,
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_evm {
    #[doc = "< number of items popped from the stack"]
    pub pop: libc::c_uchar,
    #[doc = "< number of items pushed into the stack"]
    pub push: libc::c_uchar,
    #[doc = "< gas fee for the instruction"]
    pub fee: libc::c_uint,
}
impl Clone for cs_evm {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(u32)]
#[doc = " EVM instruction"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum evm_insn {
    EVM_INS_STOP = 0,
    EVM_INS_ADD = 1,
    EVM_INS_MUL = 2,
    EVM_INS_SUB = 3,
    EVM_INS_DIV = 4,
    EVM_INS_SDIV = 5,
    EVM_INS_MOD = 6,
    EVM_INS_SMOD = 7,
    EVM_INS_ADDMOD = 8,
    EVM_INS_MULMOD = 9,
    EVM_INS_EXP = 10,
    EVM_INS_SIGNEXTEND = 11,
    EVM_INS_LT = 16,
    EVM_INS_GT = 17,
    EVM_INS_SLT = 18,
    EVM_INS_SGT = 19,
    EVM_INS_EQ = 20,
    EVM_INS_ISZERO = 21,
    EVM_INS_AND = 22,
    EVM_INS_OR = 23,
    EVM_INS_XOR = 24,
    EVM_INS_NOT = 25,
    EVM_INS_BYTE = 26,
    EVM_INS_SHA3 = 32,
    EVM_INS_ADDRESS = 48,
    EVM_INS_BALANCE = 49,
    EVM_INS_ORIGIN = 50,
    EVM_INS_CALLER = 51,
    EVM_INS_CALLVALUE = 52,
    EVM_INS_CALLDATALOAD = 53,
    EVM_INS_CALLDATASIZE = 54,
    EVM_INS_CALLDATACOPY = 55,
    EVM_INS_CODESIZE = 56,
    EVM_INS_CODECOPY = 57,
    EVM_INS_GASPRICE = 58,
    EVM_INS_EXTCODESIZE = 59,
    EVM_INS_EXTCODECOPY = 60,
    EVM_INS_RETURNDATASIZE = 61,
    EVM_INS_RETURNDATACOPY = 62,
    EVM_INS_BLOCKHASH = 64,
    EVM_INS_COINBASE = 65,
    EVM_INS_TIMESTAMP = 66,
    EVM_INS_NUMBER = 67,
    EVM_INS_DIFFICULTY = 68,
    EVM_INS_GASLIMIT = 69,
    EVM_INS_POP = 80,
    EVM_INS_MLOAD = 81,
    EVM_INS_MSTORE = 82,
    EVM_INS_MSTORE8 = 83,
    EVM_INS_SLOAD = 84,
    EVM_INS_SSTORE = 85,
    EVM_INS_JUMP = 86,
    EVM_INS_JUMPI = 87,
    EVM_INS_PC = 88,
    EVM_INS_MSIZE = 89,
    EVM_INS_GAS = 90,
    EVM_INS_JUMPDEST = 91,
    EVM_INS_PUSH1 = 96,
    EVM_INS_PUSH2 = 97,
    EVM_INS_PUSH3 = 98,
    EVM_INS_PUSH4 = 99,
    EVM_INS_PUSH5 = 100,
    EVM_INS_PUSH6 = 101,
    EVM_INS_PUSH7 = 102,
    EVM_INS_PUSH8 = 103,
    EVM_INS_PUSH9 = 104,
    EVM_INS_PUSH10 = 105,
    EVM_INS_PUSH11 = 106,
    EVM_INS_PUSH12 = 107,
    EVM_INS_PUSH13 = 108,
    EVM_INS_PUSH14 = 109,
    EVM_INS_PUSH15 = 110,
    EVM_INS_PUSH16 = 111,
    EVM_INS_PUSH17 = 112,
    EVM_INS_PUSH18 = 113,
    EVM_INS_PUSH19 = 114,
    EVM_INS_PUSH20 = 115,
    EVM_INS_PUSH21 = 116,
    EVM_INS_PUSH22 = 117,
    EVM_INS_PUSH23 = 118,
    EVM_INS_PUSH24 = 119,
    EVM_INS_PUSH25 = 120,
    EVM_INS_PUSH26 = 121,
    EVM_INS_PUSH27 = 122,
    EVM_INS_PUSH28 = 123,
    EVM_INS_PUSH29 = 124,
    EVM_INS_PUSH30 = 125,
    EVM_INS_PUSH31 = 126,
    EVM_INS_PUSH32 = 127,
    EVM_INS_DUP1 = 128,
    EVM_INS_DUP2 = 129,
    EVM_INS_DUP3 = 130,
    EVM_INS_DUP4 = 131,
    EVM_INS_DUP5 = 132,
    EVM_INS_DUP6 = 133,
    EVM_INS_DUP7 = 134,
    EVM_INS_DUP8 = 135,
    EVM_INS_DUP9 = 136,
    EVM_INS_DUP10 = 137,
    EVM_INS_DUP11 = 138,
    EVM_INS_DUP12 = 139,
    EVM_INS_DUP13 = 140,
    EVM_INS_DUP14 = 141,
    EVM_INS_DUP15 = 142,
    EVM_INS_DUP16 = 143,
    EVM_INS_SWAP1 = 144,
    EVM_INS_SWAP2 = 145,
    EVM_INS_SWAP3 = 146,
    EVM_INS_SWAP4 = 147,
    EVM_INS_SWAP5 = 148,
    EVM_INS_SWAP6 = 149,
    EVM_INS_SWAP7 = 150,
    EVM_INS_SWAP8 = 151,
    EVM_INS_SWAP9 = 152,
    EVM_INS_SWAP10 = 153,
    EVM_INS_SWAP11 = 154,
    EVM_INS_SWAP12 = 155,
    EVM_INS_SWAP13 = 156,
    EVM_INS_SWAP14 = 157,
    EVM_INS_SWAP15 = 158,
    EVM_INS_SWAP16 = 159,
    EVM_INS_LOG0 = 160,
    EVM_INS_LOG1 = 161,
    EVM_INS_LOG2 = 162,
    EVM_INS_LOG3 = 163,
    EVM_INS_LOG4 = 164,
    EVM_INS_CREATE = 240,
    EVM_INS_CALL = 241,
    EVM_INS_CALLCODE = 242,
    EVM_INS_RETURN = 243,
    EVM_INS_DELEGATECALL = 244,
    EVM_INS_CALLBLACKBOX = 245,
    EVM_INS_STATICCALL = 250,
    EVM_INS_REVERT = 253,
    EVM_INS_SUICIDE = 255,
    EVM_INS_INVALID = 512,
    EVM_INS_ENDING = 513,
}
pub mod evm_insn_group {
    #[doc = " Group of EVM instructions"]
    pub type Type = libc::c_uint;
    #[doc = "< = CS_GRP_INVALID"]
    pub const EVM_GRP_INVALID: Type = 0;
    #[doc = "< all jump instructions"]
    pub const EVM_GRP_JUMP: Type = 1;
    #[doc = "< math instructions"]
    pub const EVM_GRP_MATH: Type = 8;
    #[doc = "< instructions write to stack"]
    pub const EVM_GRP_STACK_WRITE: Type = 9;
    #[doc = "< instructions read from stack"]
    pub const EVM_GRP_STACK_READ: Type = 10;
    #[doc = "< instructions write to memory"]
    pub const EVM_GRP_MEM_WRITE: Type = 11;
    #[doc = "< instructions read from memory"]
    pub const EVM_GRP_MEM_READ: Type = 12;
    #[doc = "< instructions write to storage"]
    pub const EVM_GRP_STORE_WRITE: Type = 13;
    #[doc = "< instructions read from storage"]
    pub const EVM_GRP_STORE_READ: Type = 14;
    #[doc = "< instructions halt execution"]
    pub const EVM_GRP_HALT: Type = 15;
    #[doc = "< <-- mark the end of the list of groups"]
    pub const EVM_GRP_ENDING: Type = 16;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum riscv_op_type {
    RISCV_OP_INVALID = 0,
    RISCV_OP_REG = 1,
    RISCV_OP_IMM = 2,
    RISCV_OP_MEM = 3,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct riscv_op_mem {
    pub base: libc::c_uint,
    pub disp: i64,
}
impl Clone for riscv_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_riscv_op {
    pub type_: riscv_op_type,
    pub __bindgen_anon_1: cs_riscv_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_riscv_op__bindgen_ty_1 {
    pub reg: libc::c_uint,
    pub imm: i64,
    pub mem: riscv_op_mem,
}
impl Clone for cs_riscv_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_riscv_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_riscv_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_riscv_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_riscv_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_riscv_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_riscv {
    pub need_effective_addr: bool,
    pub op_count: u8,
    pub operands: [cs_riscv_op; 8usize],
}
impl Clone for cs_riscv {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_riscv {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_riscv {{ need_effective_addr: {:?}, op_count: {:?}, operands: {:?} }}",
            self.need_effective_addr, self.op_count, self.operands
        )
    }
}
pub mod riscv_reg {
    pub type Type = libc::c_uint;
    pub const RISCV_REG_INVALID: Type = 0;
    pub const RISCV_REG_X0: Type = 1;
    pub const RISCV_REG_ZERO: Type = 1;
    pub const RISCV_REG_X1: Type = 2;
    pub const RISCV_REG_RA: Type = 2;
    pub const RISCV_REG_X2: Type = 3;
    pub const RISCV_REG_SP: Type = 3;
    pub const RISCV_REG_X3: Type = 4;
    pub const RISCV_REG_GP: Type = 4;
    pub const RISCV_REG_X4: Type = 5;
    pub const RISCV_REG_TP: Type = 5;
    pub const RISCV_REG_X5: Type = 6;
    pub const RISCV_REG_T0: Type = 6;
    pub const RISCV_REG_X6: Type = 7;
    pub const RISCV_REG_T1: Type = 7;
    pub const RISCV_REG_X7: Type = 8;
    pub const RISCV_REG_T2: Type = 8;
    pub const RISCV_REG_X8: Type = 9;
    pub const RISCV_REG_S0: Type = 9;
    pub const RISCV_REG_FP: Type = 9;
    pub const RISCV_REG_X9: Type = 10;
    pub const RISCV_REG_S1: Type = 10;
    pub const RISCV_REG_X10: Type = 11;
    pub const RISCV_REG_A0: Type = 11;
    pub const RISCV_REG_X11: Type = 12;
    pub const RISCV_REG_A1: Type = 12;
    pub const RISCV_REG_X12: Type = 13;
    pub const RISCV_REG_A2: Type = 13;
    pub const RISCV_REG_X13: Type = 14;
    pub const RISCV_REG_A3: Type = 14;
    pub const RISCV_REG_X14: Type = 15;
    pub const RISCV_REG_A4: Type = 15;
    pub const RISCV_REG_X15: Type = 16;
    pub const RISCV_REG_A5: Type = 16;
    pub const RISCV_REG_X16: Type = 17;
    pub const RISCV_REG_A6: Type = 17;
    pub const RISCV_REG_X17: Type = 18;
    pub const RISCV_REG_A7: Type = 18;
    pub const RISCV_REG_X18: Type = 19;
    pub const RISCV_REG_S2: Type = 19;
    pub const RISCV_REG_X19: Type = 20;
    pub const RISCV_REG_S3: Type = 20;
    pub const RISCV_REG_X20: Type = 21;
    pub const RISCV_REG_S4: Type = 21;
    pub const RISCV_REG_X21: Type = 22;
    pub const RISCV_REG_S5: Type = 22;
    pub const RISCV_REG_X22: Type = 23;
    pub const RISCV_REG_S6: Type = 23;
    pub const RISCV_REG_X23: Type = 24;
    pub const RISCV_REG_S7: Type = 24;
    pub const RISCV_REG_X24: Type = 25;
    pub const RISCV_REG_S8: Type = 25;
    pub const RISCV_REG_X25: Type = 26;
    pub const RISCV_REG_S9: Type = 26;
    pub const RISCV_REG_X26: Type = 27;
    pub const RISCV_REG_S10: Type = 27;
    pub const RISCV_REG_X27: Type = 28;
    pub const RISCV_REG_S11: Type = 28;
    pub const RISCV_REG_X28: Type = 29;
    pub const RISCV_REG_T3: Type = 29;
    pub const RISCV_REG_X29: Type = 30;
    pub const RISCV_REG_T4: Type = 30;
    pub const RISCV_REG_X30: Type = 31;
    pub const RISCV_REG_T5: Type = 31;
    pub const RISCV_REG_X31: Type = 32;
    pub const RISCV_REG_T6: Type = 32;
    pub const RISCV_REG_F0_32: Type = 33;
    pub const RISCV_REG_F0_64: Type = 34;
    pub const RISCV_REG_F1_32: Type = 35;
    pub const RISCV_REG_F1_64: Type = 36;
    pub const RISCV_REG_F2_32: Type = 37;
    pub const RISCV_REG_F2_64: Type = 38;
    pub const RISCV_REG_F3_32: Type = 39;
    pub const RISCV_REG_F3_64: Type = 40;
    pub const RISCV_REG_F4_32: Type = 41;
    pub const RISCV_REG_F4_64: Type = 42;
    pub const RISCV_REG_F5_32: Type = 43;
    pub const RISCV_REG_F5_64: Type = 44;
    pub const RISCV_REG_F6_32: Type = 45;
    pub const RISCV_REG_F6_64: Type = 46;
    pub const RISCV_REG_F7_32: Type = 47;
    pub const RISCV_REG_F7_64: Type = 48;
    pub const RISCV_REG_F8_32: Type = 49;
    pub const RISCV_REG_F8_64: Type = 50;
    pub const RISCV_REG_F9_32: Type = 51;
    pub const RISCV_REG_F9_64: Type = 52;
    pub const RISCV_REG_F10_32: Type = 53;
    pub const RISCV_REG_F10_64: Type = 54;
    pub const RISCV_REG_F11_32: Type = 55;
    pub const RISCV_REG_F11_64: Type = 56;
    pub const RISCV_REG_F12_32: Type = 57;
    pub const RISCV_REG_F12_64: Type = 58;
    pub const RISCV_REG_F13_32: Type = 59;
    pub const RISCV_REG_F13_64: Type = 60;
    pub const RISCV_REG_F14_32: Type = 61;
    pub const RISCV_REG_F14_64: Type = 62;
    pub const RISCV_REG_F15_32: Type = 63;
    pub const RISCV_REG_F15_64: Type = 64;
    pub const RISCV_REG_F16_32: Type = 65;
    pub const RISCV_REG_F16_64: Type = 66;
    pub const RISCV_REG_F17_32: Type = 67;
    pub const RISCV_REG_F17_64: Type = 68;
    pub const RISCV_REG_F18_32: Type = 69;
    pub const RISCV_REG_F18_64: Type = 70;
    pub const RISCV_REG_F19_32: Type = 71;
    pub const RISCV_REG_F19_64: Type = 72;
    pub const RISCV_REG_F20_32: Type = 73;
    pub const RISCV_REG_F20_64: Type = 74;
    pub const RISCV_REG_F21_32: Type = 75;
    pub const RISCV_REG_F21_64: Type = 76;
    pub const RISCV_REG_F22_32: Type = 77;
    pub const RISCV_REG_F22_64: Type = 78;
    pub const RISCV_REG_F23_32: Type = 79;
    pub const RISCV_REG_F23_64: Type = 80;
    pub const RISCV_REG_F24_32: Type = 81;
    pub const RISCV_REG_F24_64: Type = 82;
    pub const RISCV_REG_F25_32: Type = 83;
    pub const RISCV_REG_F25_64: Type = 84;
    pub const RISCV_REG_F26_32: Type = 85;
    pub const RISCV_REG_F26_64: Type = 86;
    pub const RISCV_REG_F27_32: Type = 87;
    pub const RISCV_REG_F27_64: Type = 88;
    pub const RISCV_REG_F28_32: Type = 89;
    pub const RISCV_REG_F28_64: Type = 90;
    pub const RISCV_REG_F29_32: Type = 91;
    pub const RISCV_REG_F29_64: Type = 92;
    pub const RISCV_REG_F30_32: Type = 93;
    pub const RISCV_REG_F30_64: Type = 94;
    pub const RISCV_REG_F31_32: Type = 95;
    pub const RISCV_REG_F31_64: Type = 96;
    pub const RISCV_REG_ENDING: Type = 97;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum riscv_insn {
    RISCV_INS_INVALID = 0,
    RISCV_INS_ADD = 1,
    RISCV_INS_ADDI = 2,
    RISCV_INS_ADDIW = 3,
    RISCV_INS_ADDW = 4,
    RISCV_INS_AMOADD_D = 5,
    RISCV_INS_AMOADD_D_AQ = 6,
    RISCV_INS_AMOADD_D_AQ_RL = 7,
    RISCV_INS_AMOADD_D_RL = 8,
    RISCV_INS_AMOADD_W = 9,
    RISCV_INS_AMOADD_W_AQ = 10,
    RISCV_INS_AMOADD_W_AQ_RL = 11,
    RISCV_INS_AMOADD_W_RL = 12,
    RISCV_INS_AMOAND_D = 13,
    RISCV_INS_AMOAND_D_AQ = 14,
    RISCV_INS_AMOAND_D_AQ_RL = 15,
    RISCV_INS_AMOAND_D_RL = 16,
    RISCV_INS_AMOAND_W = 17,
    RISCV_INS_AMOAND_W_AQ = 18,
    RISCV_INS_AMOAND_W_AQ_RL = 19,
    RISCV_INS_AMOAND_W_RL = 20,
    RISCV_INS_AMOMAXU_D = 21,
    RISCV_INS_AMOMAXU_D_AQ = 22,
    RISCV_INS_AMOMAXU_D_AQ_RL = 23,
    RISCV_INS_AMOMAXU_D_RL = 24,
    RISCV_INS_AMOMAXU_W = 25,
    RISCV_INS_AMOMAXU_W_AQ = 26,
    RISCV_INS_AMOMAXU_W_AQ_RL = 27,
    RISCV_INS_AMOMAXU_W_RL = 28,
    RISCV_INS_AMOMAX_D = 29,
    RISCV_INS_AMOMAX_D_AQ = 30,
    RISCV_INS_AMOMAX_D_AQ_RL = 31,
    RISCV_INS_AMOMAX_D_RL = 32,
    RISCV_INS_AMOMAX_W = 33,
    RISCV_INS_AMOMAX_W_AQ = 34,
    RISCV_INS_AMOMAX_W_AQ_RL = 35,
    RISCV_INS_AMOMAX_W_RL = 36,
    RISCV_INS_AMOMINU_D = 37,
    RISCV_INS_AMOMINU_D_AQ = 38,
    RISCV_INS_AMOMINU_D_AQ_RL = 39,
    RISCV_INS_AMOMINU_D_RL = 40,
    RISCV_INS_AMOMINU_W = 41,
    RISCV_INS_AMOMINU_W_AQ = 42,
    RISCV_INS_AMOMINU_W_AQ_RL = 43,
    RISCV_INS_AMOMINU_W_RL = 44,
    RISCV_INS_AMOMIN_D = 45,
    RISCV_INS_AMOMIN_D_AQ = 46,
    RISCV_INS_AMOMIN_D_AQ_RL = 47,
    RISCV_INS_AMOMIN_D_RL = 48,
    RISCV_INS_AMOMIN_W = 49,
    RISCV_INS_AMOMIN_W_AQ = 50,
    RISCV_INS_AMOMIN_W_AQ_RL = 51,
    RISCV_INS_AMOMIN_W_RL = 52,
    RISCV_INS_AMOOR_D = 53,
    RISCV_INS_AMOOR_D_AQ = 54,
    RISCV_INS_AMOOR_D_AQ_RL = 55,
    RISCV_INS_AMOOR_D_RL = 56,
    RISCV_INS_AMOOR_W = 57,
    RISCV_INS_AMOOR_W_AQ = 58,
    RISCV_INS_AMOOR_W_AQ_RL = 59,
    RISCV_INS_AMOOR_W_RL = 60,
    RISCV_INS_AMOSWAP_D = 61,
    RISCV_INS_AMOSWAP_D_AQ = 62,
    RISCV_INS_AMOSWAP_D_AQ_RL = 63,
    RISCV_INS_AMOSWAP_D_RL = 64,
    RISCV_INS_AMOSWAP_W = 65,
    RISCV_INS_AMOSWAP_W_AQ = 66,
    RISCV_INS_AMOSWAP_W_AQ_RL = 67,
    RISCV_INS_AMOSWAP_W_RL = 68,
    RISCV_INS_AMOXOR_D = 69,
    RISCV_INS_AMOXOR_D_AQ = 70,
    RISCV_INS_AMOXOR_D_AQ_RL = 71,
    RISCV_INS_AMOXOR_D_RL = 72,
    RISCV_INS_AMOXOR_W = 73,
    RISCV_INS_AMOXOR_W_AQ = 74,
    RISCV_INS_AMOXOR_W_AQ_RL = 75,
    RISCV_INS_AMOXOR_W_RL = 76,
    RISCV_INS_AND = 77,
    RISCV_INS_ANDI = 78,
    RISCV_INS_AUIPC = 79,
    RISCV_INS_BEQ = 80,
    RISCV_INS_BGE = 81,
    RISCV_INS_BGEU = 82,
    RISCV_INS_BLT = 83,
    RISCV_INS_BLTU = 84,
    RISCV_INS_BNE = 85,
    RISCV_INS_CSRRC = 86,
    RISCV_INS_CSRRCI = 87,
    RISCV_INS_CSRRS = 88,
    RISCV_INS_CSRRSI = 89,
    RISCV_INS_CSRRW = 90,
    RISCV_INS_CSRRWI = 91,
    RISCV_INS_C_ADD = 92,
    RISCV_INS_C_ADDI = 93,
    RISCV_INS_C_ADDI16SP = 94,
    RISCV_INS_C_ADDI4SPN = 95,
    RISCV_INS_C_ADDIW = 96,
    RISCV_INS_C_ADDW = 97,
    RISCV_INS_C_AND = 98,
    RISCV_INS_C_ANDI = 99,
    RISCV_INS_C_BEQZ = 100,
    RISCV_INS_C_BNEZ = 101,
    RISCV_INS_C_EBREAK = 102,
    RISCV_INS_C_FLD = 103,
    RISCV_INS_C_FLDSP = 104,
    RISCV_INS_C_FLW = 105,
    RISCV_INS_C_FLWSP = 106,
    RISCV_INS_C_FSD = 107,
    RISCV_INS_C_FSDSP = 108,
    RISCV_INS_C_FSW = 109,
    RISCV_INS_C_FSWSP = 110,
    RISCV_INS_C_J = 111,
    RISCV_INS_C_JAL = 112,
    RISCV_INS_C_JALR = 113,
    RISCV_INS_C_JR = 114,
    RISCV_INS_C_LD = 115,
    RISCV_INS_C_LDSP = 116,
    RISCV_INS_C_LI = 117,
    RISCV_INS_C_LUI = 118,
    RISCV_INS_C_LW = 119,
    RISCV_INS_C_LWSP = 120,
    RISCV_INS_C_MV = 121,
    RISCV_INS_C_NOP = 122,
    RISCV_INS_C_OR = 123,
    RISCV_INS_C_SD = 124,
    RISCV_INS_C_SDSP = 125,
    RISCV_INS_C_SLLI = 126,
    RISCV_INS_C_SRAI = 127,
    RISCV_INS_C_SRLI = 128,
    RISCV_INS_C_SUB = 129,
    RISCV_INS_C_SUBW = 130,
    RISCV_INS_C_SW = 131,
    RISCV_INS_C_SWSP = 132,
    RISCV_INS_C_UNIMP = 133,
    RISCV_INS_C_XOR = 134,
    RISCV_INS_DIV = 135,
    RISCV_INS_DIVU = 136,
    RISCV_INS_DIVUW = 137,
    RISCV_INS_DIVW = 138,
    RISCV_INS_EBREAK = 139,
    RISCV_INS_ECALL = 140,
    RISCV_INS_FADD_D = 141,
    RISCV_INS_FADD_S = 142,
    RISCV_INS_FCLASS_D = 143,
    RISCV_INS_FCLASS_S = 144,
    RISCV_INS_FCVT_D_L = 145,
    RISCV_INS_FCVT_D_LU = 146,
    RISCV_INS_FCVT_D_S = 147,
    RISCV_INS_FCVT_D_W = 148,
    RISCV_INS_FCVT_D_WU = 149,
    RISCV_INS_FCVT_LU_D = 150,
    RISCV_INS_FCVT_LU_S = 151,
    RISCV_INS_FCVT_L_D = 152,
    RISCV_INS_FCVT_L_S = 153,
    RISCV_INS_FCVT_S_D = 154,
    RISCV_INS_FCVT_S_L = 155,
    RISCV_INS_FCVT_S_LU = 156,
    RISCV_INS_FCVT_S_W = 157,
    RISCV_INS_FCVT_S_WU = 158,
    RISCV_INS_FCVT_WU_D = 159,
    RISCV_INS_FCVT_WU_S = 160,
    RISCV_INS_FCVT_W_D = 161,
    RISCV_INS_FCVT_W_S = 162,
    RISCV_INS_FDIV_D = 163,
    RISCV_INS_FDIV_S = 164,
    RISCV_INS_FENCE = 165,
    RISCV_INS_FENCE_I = 166,
    RISCV_INS_FENCE_TSO = 167,
    RISCV_INS_FEQ_D = 168,
    RISCV_INS_FEQ_S = 169,
    RISCV_INS_FLD = 170,
    RISCV_INS_FLE_D = 171,
    RISCV_INS_FLE_S = 172,
    RISCV_INS_FLT_D = 173,
    RISCV_INS_FLT_S = 174,
    RISCV_INS_FLW = 175,
    RISCV_INS_FMADD_D = 176,
    RISCV_INS_FMADD_S = 177,
    RISCV_INS_FMAX_D = 178,
    RISCV_INS_FMAX_S = 179,
    RISCV_INS_FMIN_D = 180,
    RISCV_INS_FMIN_S = 181,
    RISCV_INS_FMSUB_D = 182,
    RISCV_INS_FMSUB_S = 183,
    RISCV_INS_FMUL_D = 184,
    RISCV_INS_FMUL_S = 185,
    RISCV_INS_FMV_D_X = 186,
    RISCV_INS_FMV_W_X = 187,
    RISCV_INS_FMV_X_D = 188,
    RISCV_INS_FMV_X_W = 189,
    RISCV_INS_FNMADD_D = 190,
    RISCV_INS_FNMADD_S = 191,
    RISCV_INS_FNMSUB_D = 192,
    RISCV_INS_FNMSUB_S = 193,
    RISCV_INS_FSD = 194,
    RISCV_INS_FSGNJN_D = 195,
    RISCV_INS_FSGNJN_S = 196,
    RISCV_INS_FSGNJX_D = 197,
    RISCV_INS_FSGNJX_S = 198,
    RISCV_INS_FSGNJ_D = 199,
    RISCV_INS_FSGNJ_S = 200,
    RISCV_INS_FSQRT_D = 201,
    RISCV_INS_FSQRT_S = 202,
    RISCV_INS_FSUB_D = 203,
    RISCV_INS_FSUB_S = 204,
    RISCV_INS_FSW = 205,
    RISCV_INS_JAL = 206,
    RISCV_INS_JALR = 207,
    RISCV_INS_LB = 208,
    RISCV_INS_LBU = 209,
    RISCV_INS_LD = 210,
    RISCV_INS_LH = 211,
    RISCV_INS_LHU = 212,
    RISCV_INS_LR_D = 213,
    RISCV_INS_LR_D_AQ = 214,
    RISCV_INS_LR_D_AQ_RL = 215,
    RISCV_INS_LR_D_RL = 216,
    RISCV_INS_LR_W = 217,
    RISCV_INS_LR_W_AQ = 218,
    RISCV_INS_LR_W_AQ_RL = 219,
    RISCV_INS_LR_W_RL = 220,
    RISCV_INS_LUI = 221,
    RISCV_INS_LW = 222,
    RISCV_INS_LWU = 223,
    RISCV_INS_MRET = 224,
    RISCV_INS_MUL = 225,
    RISCV_INS_MULH = 226,
    RISCV_INS_MULHSU = 227,
    RISCV_INS_MULHU = 228,
    RISCV_INS_MULW = 229,
    RISCV_INS_OR = 230,
    RISCV_INS_ORI = 231,
    RISCV_INS_REM = 232,
    RISCV_INS_REMU = 233,
    RISCV_INS_REMUW = 234,
    RISCV_INS_REMW = 235,
    RISCV_INS_SB = 236,
    RISCV_INS_SC_D = 237,
    RISCV_INS_SC_D_AQ = 238,
    RISCV_INS_SC_D_AQ_RL = 239,
    RISCV_INS_SC_D_RL = 240,
    RISCV_INS_SC_W = 241,
    RISCV_INS_SC_W_AQ = 242,
    RISCV_INS_SC_W_AQ_RL = 243,
    RISCV_INS_SC_W_RL = 244,
    RISCV_INS_SD = 245,
    RISCV_INS_SFENCE_VMA = 246,
    RISCV_INS_SH = 247,
    RISCV_INS_SLL = 248,
    RISCV_INS_SLLI = 249,
    RISCV_INS_SLLIW = 250,
    RISCV_INS_SLLW = 251,
    RISCV_INS_SLT = 252,
    RISCV_INS_SLTI = 253,
    RISCV_INS_SLTIU = 254,
    RISCV_INS_SLTU = 255,
    RISCV_INS_SRA = 256,
    RISCV_INS_SRAI = 257,
    RISCV_INS_SRAIW = 258,
    RISCV_INS_SRAW = 259,
    RISCV_INS_SRET = 260,
    RISCV_INS_SRL = 261,
    RISCV_INS_SRLI = 262,
    RISCV_INS_SRLIW = 263,
    RISCV_INS_SRLW = 264,
    RISCV_INS_SUB = 265,
    RISCV_INS_SUBW = 266,
    RISCV_INS_SW = 267,
    RISCV_INS_UNIMP = 268,
    RISCV_INS_URET = 269,
    RISCV_INS_WFI = 270,
    RISCV_INS_XOR = 271,
    RISCV_INS_XORI = 272,
    RISCV_INS_ENDING = 273,
}
pub mod riscv_insn_group {
    pub type Type = libc::c_uint;
    pub const RISCV_GRP_INVALID: Type = 0;
    pub const RISCV_GRP_JUMP: Type = 1;
    pub const RISCV_GRP_ISRV32: Type = 128;
    pub const RISCV_GRP_ISRV64: Type = 129;
    pub const RISCV_GRP_HASSTDEXTA: Type = 130;
    pub const RISCV_GRP_HASSTDEXTC: Type = 131;
    pub const RISCV_GRP_HASSTDEXTD: Type = 132;
    pub const RISCV_GRP_HASSTDEXTF: Type = 133;
    pub const RISCV_GRP_HASSTDEXTM: Type = 134;
    pub const RISCV_GRP_ENDING: Type = 135;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum wasm_op_type {
    WASM_OP_INVALID = 0,
    WASM_OP_NONE = 1,
    WASM_OP_INT7 = 2,
    WASM_OP_VARUINT32 = 3,
    WASM_OP_VARUINT64 = 4,
    WASM_OP_UINT32 = 5,
    WASM_OP_UINT64 = 6,
    WASM_OP_IMM = 7,
    WASM_OP_BRTABLE = 8,
}
#[repr(C)]
#[derive(Debug, Copy)]
pub struct cs_wasm_brtable {
    pub length: u32,
    pub address: u64,
    pub default_target: u32,
}
impl Clone for cs_wasm_brtable {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[derive(Copy)]
pub struct cs_wasm_op {
    pub type_: wasm_op_type,
    pub size: u32,
    pub __bindgen_anon_1: cs_wasm_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_wasm_op__bindgen_ty_1 {
    pub int7: i8,
    pub varuint32: u32,
    pub varuint64: u64,
    pub uint32: u32,
    pub uint64: u64,
    pub immediate: [u32; 2usize],
    pub brtable: cs_wasm_brtable,
}
impl Clone for cs_wasm_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_wasm_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_wasm_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_wasm_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_wasm_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_wasm_op {{ type: {:?}, size: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.size, self.__bindgen_anon_1
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_wasm {
    pub op_count: u8,
    pub operands: [cs_wasm_op; 2usize],
}
impl Clone for cs_wasm {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_wasm {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_wasm {{ op_count: {:?}, operands: {:?} }}",
            self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " MOS65XX registers and special registers"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mos65xx_reg {
    MOS65XX_REG_INVALID = 0,
    #[doc = "< accumulator"]
    MOS65XX_REG_ACC = 1,
    #[doc = "< X index register"]
    MOS65XX_REG_X = 2,
    #[doc = "< Y index register"]
    MOS65XX_REG_Y = 3,
    #[doc = "< status register"]
    MOS65XX_REG_P = 4,
    #[doc = "< stack pointer register"]
    MOS65XX_REG_SP = 5,
    #[doc = "< direct page register"]
    MOS65XX_REG_DP = 6,
    #[doc = "< data bank register"]
    MOS65XX_REG_B = 7,
    #[doc = "< program bank register"]
    MOS65XX_REG_K = 8,
    MOS65XX_REG_ENDING = 9,
}
#[repr(u32)]
#[doc = " MOS65XX Addressing Modes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mos65xx_address_mode {
    #[doc = "< No address mode."]
    MOS65XX_AM_NONE = 0,
    #[doc = "< implied addressing (no addressing mode)"]
    MOS65XX_AM_IMP = 1,
    #[doc = "< accumulator addressing"]
    MOS65XX_AM_ACC = 2,
    #[doc = "< 8/16 Bit immediate value"]
    MOS65XX_AM_IMM = 3,
    #[doc = "< relative addressing used by branches"]
    MOS65XX_AM_REL = 4,
    #[doc = "< interrupt addressing"]
    MOS65XX_AM_INT = 5,
    #[doc = "< memory block addressing"]
    MOS65XX_AM_BLOCK = 6,
    #[doc = "< zeropage addressing"]
    MOS65XX_AM_ZP = 7,
    #[doc = "< indexed zeropage addressing by the X index register"]
    MOS65XX_AM_ZP_X = 8,
    #[doc = "< indexed zeropage addressing by the Y index register"]
    MOS65XX_AM_ZP_Y = 9,
    #[doc = "< zero page address, branch relative address"]
    MOS65XX_AM_ZP_REL = 10,
    #[doc = "< indirect zeropage addressing"]
    MOS65XX_AM_ZP_IND = 11,
    #[doc = "< indexed zeropage indirect addressing by the X index register"]
    MOS65XX_AM_ZP_X_IND = 12,
    #[doc = "< indirect zeropage indexed addressing by the Y index register"]
    MOS65XX_AM_ZP_IND_Y = 13,
    #[doc = "< zeropage indirect long addressing"]
    MOS65XX_AM_ZP_IND_LONG = 14,
    #[doc = "< zeropage indirect long addressing indexed by Y register"]
    MOS65XX_AM_ZP_IND_LONG_Y = 15,
    #[doc = "< absolute addressing"]
    MOS65XX_AM_ABS = 16,
    #[doc = "< indexed absolute addressing by the X index register"]
    MOS65XX_AM_ABS_X = 17,
    #[doc = "< indexed absolute addressing by the Y index register"]
    MOS65XX_AM_ABS_Y = 18,
    #[doc = "< absolute indirect addressing"]
    MOS65XX_AM_ABS_IND = 19,
    #[doc = "< indexed absolute indirect addressing by the X index register"]
    MOS65XX_AM_ABS_X_IND = 20,
    #[doc = "< absolute indirect long addressing"]
    MOS65XX_AM_ABS_IND_LONG = 21,
    #[doc = "< absolute long address mode"]
    MOS65XX_AM_ABS_LONG = 22,
    #[doc = "< absolute long address mode, indexed by X register"]
    MOS65XX_AM_ABS_LONG_X = 23,
    #[doc = "< stack relative addressing"]
    MOS65XX_AM_SR = 24,
    #[doc = "< indirect stack relative addressing indexed by the Y index register"]
    MOS65XX_AM_SR_IND_Y = 25,
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mos65xx_op_type {
    #[doc = "< = CS_OP_INVALID (Uninitialized)."]
    MOS65XX_OP_INVALID = 0,
    #[doc = "< = CS_OP_REG (Register operand)."]
    MOS65XX_OP_REG = 1,
    #[doc = "< = CS_OP_IMM (Immediate operand)."]
    MOS65XX_OP_IMM = 2,
    #[doc = "< = CS_OP_MEM (Memory operand)."]
    MOS65XX_OP_MEM = 3,
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_mos65xx_op {
    #[doc = "< operand type"]
    pub type_: mos65xx_op_type,
    pub __bindgen_anon_1: cs_mos65xx_op__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_mos65xx_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: mos65xx_reg,
    #[doc = "< immediate value for IMM operand"]
    pub imm: u16,
    #[doc = "< address for MEM operand"]
    pub mem: u32,
}
impl Clone for cs_mos65xx_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mos65xx_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_mos65xx_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_mos65xx_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mos65xx_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_mos65xx_op {{ type: {:?}, __bindgen_anon_1: {:?} }}",
            self.type_, self.__bindgen_anon_1
        )
    }
}
#[doc = " The MOS65XX address mode and it's operands"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_mos65xx {
    pub am: mos65xx_address_mode,
    pub modifies_flags: bool,
    #[doc = " Number of operands of this instruction,"]
    #[doc = " or 0 when instruction has no operand."]
    pub op_count: u8,
    #[doc = "< operands for this instruction."]
    pub operands: [cs_mos65xx_op; 3usize],
}
impl Clone for cs_mos65xx {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_mos65xx {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_mos65xx {{ am: {:?}, modifies_flags: {:?}, op_count: {:?}, operands: {:?} }}",
            self.am, self.modifies_flags, self.op_count, self.operands
        )
    }
}
#[repr(u32)]
#[doc = " Operand type for instruction's operands"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bpf_op_type {
    BPF_OP_INVALID = 0,
    BPF_OP_REG = 1,
    BPF_OP_IMM = 2,
    BPF_OP_OFF = 3,
    BPF_OP_MEM = 4,
    #[doc = "< M[k] in cBPF"]
    BPF_OP_MMEM = 5,
    #[doc = "< corresponds to cBPF's BPF_MSH mode"]
    BPF_OP_MSH = 6,
    #[doc = "< cBPF's extension (not eBPF)"]
    BPF_OP_EXT = 7,
}
#[repr(u32)]
#[doc = " BPF registers"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum bpf_reg {
    BPF_REG_INVALID = 0,
    BPF_REG_A = 1,
    BPF_REG_X = 2,
    BPF_REG_R0 = 3,
    BPF_REG_R1 = 4,
    BPF_REG_R2 = 5,
    BPF_REG_R3 = 6,
    BPF_REG_R4 = 7,
    BPF_REG_R5 = 8,
    BPF_REG_R6 = 9,
    BPF_REG_R7 = 10,
    BPF_REG_R8 = 11,
    BPF_REG_R9 = 12,
    BPF_REG_R10 = 13,
    BPF_REG_ENDING = 14,
}
#[doc = " Instruction's operand referring to memory"]
#[doc = " This is associated with BPF_OP_MEM operand type above"]
#[repr(C)]
#[derive(Debug, Copy)]
pub struct bpf_op_mem {
    #[doc = "< base register"]
    pub base: bpf_reg,
    #[doc = "< offset value"]
    pub disp: u32,
}
impl Clone for bpf_op_mem {
    fn clone(&self) -> Self {
        *self
    }
}
#[doc = " Instruction operand"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_bpf_op {
    pub type_: bpf_op_type,
    pub __bindgen_anon_1: cs_bpf_op__bindgen_ty_1,
    #[doc = " How is this operand accessed? (READ, WRITE or READ|WRITE)"]
    #[doc = " This field is combined of cs_ac_type."]
    #[doc = " NOTE: this field is irrelevant if engine is compiled in DIET mode."]
    pub access: u8,
}
#[repr(C)]
#[derive(Copy)]
pub union cs_bpf_op__bindgen_ty_1 {
    #[doc = "< register value for REG operand"]
    pub reg: u8,
    #[doc = "< immediate value IMM operand"]
    pub imm: u64,
    #[doc = "< offset value, used in jump & call"]
    pub off: u32,
    #[doc = "< base/disp value for MEM operand"]
    pub mem: bpf_op_mem,
    #[doc = "< M[k] in cBPF"]
    pub mmem: u32,
    #[doc = "< corresponds to cBPF's BPF_MSH mode"]
    pub msh: u32,
    #[doc = "< cBPF's extension (not eBPF)"]
    pub ext: u32,
}
impl Clone for cs_bpf_op__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_bpf_op__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_bpf_op__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_bpf_op {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_bpf_op {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_bpf_op {{ type: {:?}, __bindgen_anon_1: {:?}, access: {:?} }}",
            self.type_, self.__bindgen_anon_1, self.access
        )
    }
}
#[doc = " Instruction structure"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_bpf {
    pub op_count: u8,
    pub operands: [cs_bpf_op; 4usize],
}
impl Clone for cs_bpf {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_bpf {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(
            f,
            "cs_bpf {{ op_count: {:?}, operands: {:?} }}",
            self.op_count, self.operands
        )
    }
}
#[doc = " NOTE: All information in cs_detail is only available when CS_OPT_DETAIL = CS_OPT_ON"]
#[doc = " Initialized as memset(., 0, offsetof(cs_detail, ARCH)+sizeof(cs_ARCH))"]
#[doc = " by ARCH_getInstruction in arch/ARCH/ARCHDisassembler.c"]
#[doc = " if cs_detail changes, in particular if a field is added after the union,"]
#[doc = " then update arch/ARCH/ARCHDisassembler.c accordingly"]
#[repr(C)]
#[derive(Copy)]
pub struct cs_detail {
    #[doc = "< list of implicit registers read by this insn"]
    pub regs_read: [u16; 16usize],
    #[doc = "< number of implicit registers read by this insn"]
    pub regs_read_count: u8,
    #[doc = "< list of implicit registers modified by this insn"]
    pub regs_write: [u16; 20usize],
    #[doc = "< number of implicit registers modified by this insn"]
    pub regs_write_count: u8,
    #[doc = "< list of group this instruction belong to"]
    pub groups: [u8; 8usize],
    #[doc = "< number of groups this insn belongs to"]
    pub groups_count: u8,
    pub __bindgen_anon_1: cs_detail__bindgen_ty_1,
}
#[doc = " Architecture-specific instruction info"]
#[repr(C)]
#[derive(Copy)]
pub union cs_detail__bindgen_ty_1 {
    #[doc = "< X86 architecture, including 16-bit, 32-bit & 64-bit mode"]
    pub x86: cs_x86,
    #[doc = "< ARM64 architecture (aka AArch64)"]
    pub arm64: cs_arm64,
    #[doc = "< ARM architecture (including Thumb/Thumb2)"]
    pub arm: cs_arm,
    #[doc = "< M68K architecture"]
    pub m68k: cs_m68k,
    #[doc = "< MIPS architecture"]
    pub mips: cs_mips,
    #[doc = "< PowerPC architecture"]
    pub ppc: cs_ppc,
    #[doc = "< Sparc architecture"]
    pub sparc: cs_sparc,
    #[doc = "< SystemZ architecture"]
    pub sysz: cs_sysz,
    #[doc = "< XCore architecture"]
    pub xcore: cs_xcore,
    #[doc = "< TMS320C64x architecture"]
    pub tms320c64x: cs_tms320c64x,
    #[doc = "< M680X architecture"]
    pub m680x: cs_m680x,
    #[doc = "< Ethereum architecture"]
    pub evm: cs_evm,
    #[doc = "< MOS65XX architecture (including MOS6502)"]
    pub mos65xx: cs_mos65xx,
    #[doc = "< Web Assembly architecture"]
    pub wasm: cs_wasm,
    #[doc = "< Berkeley Packet Filter architecture (including eBPF)"]
    pub bpf: cs_bpf,
    #[doc = "< RISCV architecture"]
    pub riscv: cs_riscv,
}
impl Clone for cs_detail__bindgen_ty_1 {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_detail__bindgen_ty_1 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write!(f, "cs_detail__bindgen_ty_1 {{ union }}")
    }
}
impl Clone for cs_detail {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for cs_detail {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_detail {{ regs_read: {:?}, regs_read_count: {:?}, regs_write: {:?}, regs_write_count: {:?}, groups: {:?}, groups_count: {:?}, __bindgen_anon_1: {:?} }}" , self . regs_read , self . regs_read_count , self . regs_write , self . regs_write_count , self . groups , self . groups_count , self . __bindgen_anon_1)
    }
}
#[doc = " Detail information of disassembled instruction"]
#[repr(C)]
pub struct cs_insn {
    #[doc = " Instruction ID (basically a numeric ID for the instruction mnemonic)"]
    #[doc = " Find the instruction id in the '[ARCH]_insn' enum in the header file"]
    #[doc = " of corresponding architecture, such as 'arm_insn' in arm.h for ARM,"]
    #[doc = " 'x86_insn' in x86.h for X86, etc..."]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    #[doc = " NOTE: in Skipdata mode, \"data\" instruction has 0 for this id field."]
    pub id: libc::c_uint,
    #[doc = " Address (EIP) of this instruction"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub address: u64,
    #[doc = " Size of this instruction"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub size: u16,
    #[doc = " Machine bytes of this instruction, with number of bytes indicated by @size above"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub bytes: [u8; 24usize],
    #[doc = " Ascii text of instruction mnemonic"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub mnemonic: [libc::c_char; 32usize],
    #[doc = " Ascii text of instruction operands"]
    #[doc = " This information is available even when CS_OPT_DETAIL = CS_OPT_OFF"]
    pub op_str: [libc::c_char; 160usize],
    #[doc = " Pointer to cs_detail."]
    #[doc = " NOTE: detail pointer is only valid when both requirements below are met:"]
    #[doc = " (1) CS_OP_DETAIL = CS_OPT_ON"]
    #[doc = " (2) Engine is not in Skipdata mode (CS_OP_SKIPDATA option set to CS_OPT_ON)"]
    #[doc = ""]
    #[doc = " NOTE 2: when in Skipdata mode, or when detail mode is OFF, even if this pointer"]
    #[doc = "     is not NULL, its content is still irrelevant."]
    pub detail: *mut cs_detail,
}
impl ::core::fmt::Debug for cs_insn {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        write ! (f , "cs_insn {{ id: {:?}, address: {:?}, size: {:?}, bytes: {:?}, mnemonic: [...], op_str: [...], detail: {:?} }}" , self . id , self . address , self . size , self . bytes , self . detail)
    }
}
pub mod cs_err {
    #[doc = " All type of errors encountered by Capstone API."]
    #[doc = " These are values returned by cs_errno()"]
    pub type Type = libc::c_uint;
    #[doc = "< No error: everything was fine"]
    pub const CS_ERR_OK: Type = 0;
    #[doc = "< Out-Of-Memory error: cs_open(), cs_disasm(), cs_disasm_iter()"]
    pub const CS_ERR_MEM: Type = 1;
    #[doc = "< Unsupported architecture: cs_open()"]
    pub const CS_ERR_ARCH: Type = 2;
    #[doc = "< Invalid handle: cs_op_count(), cs_op_index()"]
    pub const CS_ERR_HANDLE: Type = 3;
    #[doc = "< Invalid csh argument: cs_close(), cs_errno(), cs_option()"]
    pub const CS_ERR_CSH: Type = 4;
    #[doc = "< Invalid/unsupported mode: cs_open()"]
    pub const CS_ERR_MODE: Type = 5;
    #[doc = "< Invalid/unsupported option: cs_option()"]
    pub const CS_ERR_OPTION: Type = 6;
    #[doc = "< Information is unavailable because detail option is OFF"]
    pub const CS_ERR_DETAIL: Type = 7;
    #[doc = "< Dynamic memory management uninitialized (see CS_OPT_MEM)"]
    pub const CS_ERR_MEMSETUP: Type = 8;
    #[doc = "< Unsupported version (bindings)"]
    pub const CS_ERR_VERSION: Type = 9;
    #[doc = "< Access irrelevant data in \"diet\" engine"]
    pub const CS_ERR_DIET: Type = 10;
    #[doc = "< Access irrelevant data for \"data\" instruction in SKIPDATA mode"]
    pub const CS_ERR_SKIPDATA: Type = 11;
    #[doc = "< X86 AT&T syntax is unsupported (opt-out at compile time)"]
    pub const CS_ERR_X86_ATT: Type = 12;
    #[doc = "< X86 Intel syntax is unsupported (opt-out at compile time)"]
    pub const CS_ERR_X86_INTEL: Type = 13;
    #[doc = "< X86 Masm syntax is unsupported (opt-out at compile time)"]
    pub const CS_ERR_X86_MASM: Type = 14;
}
extern "C" {
    #[doc = "Return combined API version & major and minor version numbers."]
    #[doc = ""]
    #[doc = "@major: major number of API version"]
    #[doc = "@minor: minor number of API version"]
    #[doc = ""]
    #[doc = "@return hexical number as (major << 8 | minor), which encodes both"]
    #[doc = "major & minor versions."]
    #[doc = "NOTE: This returned value can be compared with version number made"]
    #[doc = "with macro CS_MAKE_VERSION"]
    #[doc = ""]
    #[doc = "For example, second API version would return 1 in @major, and 1 in @minor"]
    #[doc = "The return value would be 0x0101"]
    #[doc = ""]
    #[doc = "NOTE: if you only care about returned value, but not major and minor values,"]
    #[doc = "set both @major & @minor arguments to NULL."]
    pub fn cs_version(major: *mut libc::c_int, minor: *mut libc::c_int) -> libc::c_uint;
}
extern "C" {
    #[doc = "This API can be used to either ask for archs supported by this library,"]
    #[doc = "or check to see if the library was compile with 'diet' option (or called"]
    #[doc = "in 'diet' mode)."]
    #[doc = ""]
    #[doc = "To check if a particular arch is supported by this library, set @query to"]
    #[doc = "arch mode (CS_ARCH_* value)."]
    #[doc = "To verify if this library supports all the archs, use CS_ARCH_ALL."]
    #[doc = ""]
    #[doc = "To check if this library is in 'diet' mode, set @query to CS_SUPPORT_DIET."]
    #[doc = ""]
    #[doc = "@return True if this library supports the given arch, or in 'diet' mode."]
    pub fn cs_support(query: libc::c_int) -> bool;
}
extern "C" {
    #[doc = "Initialize CS handle: this must be done before any usage of CS."]
    #[doc = ""]
    #[doc = "@arch: architecture type (CS_ARCH_*)"]
    #[doc = "@mode: hardware mode. This is combined of CS_MODE_*"]
    #[doc = "@handle: pointer to handle, which will be updated at return time"]
    #[doc = ""]
    #[doc = "@return CS_ERR_OK on success, or other value on failure (refer to cs_err enum"]
    #[doc = "for detailed error)."]
    pub fn cs_open(arch: cs_arch, mode: cs_mode, handle: *mut csh) -> cs_err::Type;
}
extern "C" {
    #[doc = "Close CS handle: MUST do to release the handle when it is not used anymore."]
    #[doc = "NOTE: this must be only called when there is no longer usage of Capstone,"]
    #[doc = "not even access to cs_insn array. The reason is the this API releases some"]
    #[doc = "cached memory, thus access to any Capstone API after cs_close() might crash"]
    #[doc = "your application."]
    #[doc = ""]
    #[doc = "In fact,this API invalidate @handle by ZERO out its value (i.e *handle = 0)."]
    #[doc = ""]
    #[doc = "@handle: pointer to a handle returned by cs_open()"]
    #[doc = ""]
    #[doc = "@return CS_ERR_OK on success, or other value on failure (refer to cs_err enum"]
    #[doc = "for detailed error)."]
    pub fn cs_close(handle: *mut csh) -> cs_err::Type;
}
extern "C" {
    #[doc = "Set option for disassembling engine at runtime"]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@type: type of option to be set"]
    #[doc = "@value: option value corresponding with @type"]
    #[doc = ""]
    #[doc = "@return: CS_ERR_OK on success, or other value on failure."]
    #[doc = "Refer to cs_err enum for detailed error."]
    #[doc = ""]
    #[doc = "NOTE: in the case of CS_OPT_MEM, handle's value can be anything,"]
    #[doc = "so that cs_option(handle, CS_OPT_MEM, value) can (i.e must) be called"]
    #[doc = "even before cs_open()"]
    pub fn cs_option(handle: csh, type_: cs_opt_type, value: usize) -> cs_err::Type;
}
extern "C" {
    #[doc = "Report the last error number when some API function fail."]
    #[doc = "Like glibc's errno, cs_errno might not retain its old value once accessed."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = ""]
    #[doc = "@return: error code of cs_err enum type (CS_ERR_*, see above)"]
    pub fn cs_errno(handle: csh) -> cs_err::Type;
}
extern "C" {
    #[doc = "Return a string describing given error code."]
    #[doc = ""]
    #[doc = "@code: error code (see CS_ERR_* above)"]
    #[doc = ""]
    #[doc = "@return: returns a pointer to a string that describes the error code"]
    #[doc = "passed in the argument @code"]
    pub fn cs_strerror(code: cs_err::Type) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Disassemble binary code, given the code buffer, size, address and number"]
    #[doc = "of instructions to be decoded."]
    #[doc = "This API dynamically allocate memory to contain disassembled instruction."]
    #[doc = "Resulting instructions will be put into @*insn"]
    #[doc = ""]
    #[doc = "NOTE 1: this API will automatically determine memory needed to contain"]
    #[doc = "output disassembled instructions in @insn."]
    #[doc = ""]
    #[doc = "NOTE 2: caller must free the allocated memory itself to avoid memory leaking."]
    #[doc = ""]
    #[doc = "NOTE 3: for system with scarce memory to be dynamically allocated such as"]
    #[doc = "OS kernel or firmware, the API cs_disasm_iter() might be a better choice than"]
    #[doc = "cs_disasm(). The reason is that with cs_disasm(), based on limited available"]
    #[doc = "memory, we have to calculate in advance how many instructions to be disassembled,"]
    #[doc = "which complicates things. This is especially troublesome for the case @count=0,"]
    #[doc = "when cs_disasm() runs uncontrollably (until either end of input buffer, or"]
    #[doc = "when it encounters an invalid instruction)."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@code: buffer containing raw binary code to be disassembled."]
    #[doc = "@code_size: size of the above code buffer."]
    #[doc = "@address: address of the first instruction in given raw code buffer."]
    #[doc = "@insn: array of instructions filled in by this API."]
    #[doc = "NOTE: @insn will be allocated by this function, and should be freed"]
    #[doc = "with cs_free() API."]
    #[doc = "@count: number of instructions to be disassembled, or 0 to get all of them"]
    #[doc = ""]
    #[doc = "@return: the number of successfully disassembled instructions,"]
    #[doc = "or 0 if this function failed to disassemble the given code"]
    #[doc = ""]
    #[doc = "On failure, call cs_errno() for error code."]
    pub fn cs_disasm(
        handle: csh,
        code: *const u8,
        code_size: usize,
        address: u64,
        count: usize,
        insn: *mut *mut cs_insn,
    ) -> usize;
}
extern "C" {
    #[doc = "Free memory allocated by cs_malloc() or cs_disasm() (argument @insn)"]
    #[doc = ""]
    #[doc = "@insn: pointer returned by @insn argument in cs_disasm() or cs_malloc()"]
    #[doc = "@count: number of cs_insn structures returned by cs_disasm(), or 1"]
    #[doc = "to free memory allocated by cs_malloc()."]
    pub fn cs_free(insn: *mut cs_insn, count: usize);
}
extern "C" {
    #[doc = "Allocate memory for 1 instruction to be used by cs_disasm_iter()."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = ""]
    #[doc = "NOTE: when no longer in use, you can reclaim the memory allocated for"]
    #[doc = "this instruction with cs_free(insn, 1)"]
    pub fn cs_malloc(handle: csh) -> *mut cs_insn;
}
extern "C" {
    #[doc = "Fast API to disassemble binary code, given the code buffer, size, address"]
    #[doc = "and number of instructions to be decoded."]
    #[doc = "This API puts the resulting instruction into a given cache in @insn."]
    #[doc = "See tests/test_iter.c for sample code demonstrating this API."]
    #[doc = ""]
    #[doc = "NOTE 1: this API will update @code, @size & @address to point to the next"]
    #[doc = "instruction in the input buffer. Therefore, it is convenient to use"]
    #[doc = "cs_disasm_iter() inside a loop to quickly iterate all the instructions."]
    #[doc = "While decoding one instruction at a time can also be achieved with"]
    #[doc = "cs_disasm(count=1), some benchmarks shown that cs_disasm_iter() can be 30%"]
    #[doc = "faster on random input."]
    #[doc = ""]
    #[doc = "NOTE 2: the cache in @insn can be created with cs_malloc() API."]
    #[doc = ""]
    #[doc = "NOTE 3: for system with scarce memory to be dynamically allocated such as"]
    #[doc = "OS kernel or firmware, this API is recommended over cs_disasm(), which"]
    #[doc = "allocates memory based on the number of instructions to be disassembled."]
    #[doc = "The reason is that with cs_disasm(), based on limited available memory,"]
    #[doc = "we have to calculate in advance how many instructions to be disassembled,"]
    #[doc = "which complicates things. This is especially troublesome for the case"]
    #[doc = "@count=0, when cs_disasm() runs uncontrollably (until either end of input"]
    #[doc = "buffer, or when it encounters an invalid instruction)."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@code: buffer containing raw binary code to be disassembled"]
    #[doc = "@size: size of above code"]
    #[doc = "@address: address of the first insn in given raw code buffer"]
    #[doc = "@insn: pointer to instruction to be filled in by this API."]
    #[doc = ""]
    #[doc = "@return: true if this API successfully decode 1 instruction,"]
    #[doc = "or false otherwise."]
    #[doc = ""]
    #[doc = "On failure, call cs_errno() for error code."]
    pub fn cs_disasm_iter(
        handle: csh,
        code: *mut *const u8,
        size: *mut usize,
        address: *mut u64,
        insn: *mut cs_insn,
    ) -> bool;
}
extern "C" {
    #[doc = "Return friendly name of register in a string."]
    #[doc = "Find the instruction id from header file of corresponding architecture (arm.h for ARM,"]
    #[doc = "x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because engine does not"]
    #[doc = "store register name."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@reg_id: register id"]
    #[doc = ""]
    #[doc = "@return: string name of the register, or NULL if @reg_id is invalid."]
    pub fn cs_reg_name(handle: csh, reg_id: libc::c_uint) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Return friendly name of an instruction in a string."]
    #[doc = "Find the instruction id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "store instruction name."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn_id: instruction id"]
    #[doc = ""]
    #[doc = "@return: string name of the instruction, or NULL if @insn_id is invalid."]
    pub fn cs_insn_name(handle: csh, insn_id: libc::c_uint) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Return friendly name of a group id (that an instruction can belong to)"]
    #[doc = "Find the group id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "store group name."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@group_id: group id"]
    #[doc = ""]
    #[doc = "@return: string name of the group, or NULL if @group_id is invalid."]
    pub fn cs_group_name(handle: csh, group_id: libc::c_uint) -> *const libc::c_char;
}
extern "C" {
    #[doc = "Check if a disassembled instruction belong to a particular group."]
    #[doc = "Find the group id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = "Internally, this simply verifies if @group_id matches any member of insn->groups array."]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)."]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "update @groups array."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@group_id: group that you want to check if this instruction belong to."]
    #[doc = ""]
    #[doc = "@return: true if this instruction indeed belongs to the given group, or false otherwise."]
    pub fn cs_insn_group(handle: csh, insn: *const cs_insn, group_id: libc::c_uint) -> bool;
}
extern "C" {
    #[doc = "Check if a disassembled instruction IMPLICITLY used a particular register."]
    #[doc = "Find the register id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = "Internally, this simply verifies if @reg_id matches any member of insn->regs_read array."]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "update @regs_read array."]
    #[doc = ""]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@reg_id: register that you want to check if this instruction used it."]
    #[doc = ""]
    #[doc = "@return: true if this instruction indeed implicitly used the given register, or false otherwise."]
    pub fn cs_reg_read(handle: csh, insn: *const cs_insn, reg_id: libc::c_uint) -> bool;
}
extern "C" {
    #[doc = "Check if a disassembled instruction IMPLICITLY modified a particular register."]
    #[doc = "Find the register id from header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = "Internally, this simply verifies if @reg_id matches any member of insn->regs_write array."]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because the engine does not"]
    #[doc = "update @regs_write array."]
    #[doc = ""]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@reg_id: register that you want to check if this instruction modified it."]
    #[doc = ""]
    #[doc = "@return: true if this instruction indeed implicitly modified the given register, or false otherwise."]
    pub fn cs_reg_write(handle: csh, insn: *const cs_insn, reg_id: libc::c_uint) -> bool;
}
extern "C" {
    #[doc = "Count the number of operands of a given type."]
    #[doc = "Find the operand type in header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@op_type: Operand type to be found."]
    #[doc = ""]
    #[doc = "@return: number of operands of given type @op_type in instruction @insn,"]
    #[doc = "or -1 on failure."]
    pub fn cs_op_count(handle: csh, insn: *const cs_insn, op_type: libc::c_uint) -> libc::c_int;
}
extern "C" {
    #[doc = "Retrieve the position of operand of given type in <arch>.operands[] array."]
    #[doc = "Later, the operand can be accessed using the returned position."]
    #[doc = "Find the operand type in header file of corresponding architecture (arm.h for ARM, x86.h for X86, ...)"]
    #[doc = ""]
    #[doc = "NOTE: this API is only valid when detail option is ON (which is OFF by default)"]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure received from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@op_type: Operand type to be found."]
    #[doc = "@position: position of the operand to be found. This must be in the range"]
    #[doc = "[1, cs_op_count(handle, insn, op_type)]"]
    #[doc = ""]
    #[doc = "@return: index of operand of given type @op_type in <arch>.operands[] array"]
    #[doc = "in instruction @insn, or -1 on failure."]
    pub fn cs_op_index(
        handle: csh,
        insn: *const cs_insn,
        op_type: libc::c_uint,
        position: libc::c_uint,
    ) -> libc::c_int;
}
#[doc = " Type of array to keep the list of registers"]
pub type cs_regs = [u16; 64usize];
extern "C" {
    #[doc = "Retrieve all the registers accessed by an instruction, either explicitly or"]
    #[doc = "implicitly."]
    #[doc = ""]
    #[doc = "WARN: when in 'diet' mode, this API is irrelevant because engine does not"]
    #[doc = "store registers."]
    #[doc = ""]
    #[doc = "@handle: handle returned by cs_open()"]
    #[doc = "@insn: disassembled instruction structure returned from cs_disasm() or cs_disasm_iter()"]
    #[doc = "@regs_read: on return, this array contains all registers read by instruction."]
    #[doc = "@regs_read_count: number of registers kept inside @regs_read array."]
    #[doc = "@regs_write: on return, this array contains all registers written by instruction."]
    #[doc = "@regs_write_count: number of registers kept inside @regs_write array."]
    #[doc = ""]
    #[doc = "@return CS_ERR_OK on success, or other value on failure (refer to cs_err enum"]
    #[doc = "for detailed error)."]
    pub fn cs_regs_access(
        handle: csh,
        insn: *const cs_insn,
        regs_read: *mut u16,
        regs_read_count: *mut u8,
        regs_write: *mut u16,
        regs_write_count: *mut u8,
    ) -> cs_err::Type;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy)]
pub struct __va_list_tag {
    pub gp_offset: libc::c_uint,
    pub fp_offset: libc::c_uint,
    pub overflow_arg_area: *mut libc::c_void,
    pub reg_save_area: *mut libc::c_void,
}
impl Clone for __va_list_tag {
    fn clone(&self) -> Self {
        *self
    }
}
