#!/bin/bash
#
# named_nettemp.sh
#
# Setup a network template and RC role and type for named networking control
#


net_temp new_template 100 "Named Localhost"
net_temp set_address_family 100 INET
net_temp set_type 100 ANY
net_temp set_address 100 127.0.0.1
net_temp set_valid_len 100 32
net_temp set_protocol 100 ANY
net_temp set_netdev 100 ""
net_temp set_min_port 100 53
net_temp set_max_port 100 53

net_temp new_template 120 "Named Localaddr"
net_temp set_address_family 120 INET
net_temp set_type 120 ANY
net_temp set_address 120 192.168.200.240
net_temp set_valid_len 120 32
net_temp set_protocol 120 ANY
net_temp set_netdev 120 ""
net_temp set_min_port 120 53
net_temp set_max_port 120 53

net_temp new_template 1000 "Named Unix"
net_temp set_address_family 1000 UNIX
net_temp set_type 1000 STREAM
net_temp -u set_address 1000 "/var/run/ndc"
net_temp set_valid_len 1000 12
net_temp set_protocol 1000 ANY
net_temp set_netdev 1000 ""
net_temp set_min_port 1000 0
net_temp set_max_port 1000 0

rc_set_item TYPE 3 type_netobj_name "Named Local"

rc_set_item ROLE 4 name "Named"
rc_set_item -b ROLE 4 type_comp_fd 0 0000000000000001111100000011011111010111111110110100
rc_set_item -b ROLE 4 type_comp_dev 0 0000000000000000111000000000011111000000000010000100
rc_set_item -b ROLE 4 type_comp_ipc 0 0000000000000000110000000000011110010001101110011110
rc_set_item -b ROLE 4 type_comp_scd 5 1111000000000001011000111000100101111001100000000001
rc_set_item -b ROLE 4 type_comp_scd 12 1111111111111111111111111111111111111111111111111111
rc_set_item -b ROLE 4 type_comp_process 0 0000000000000000000011000100000100000000000101011000
rc_set_item -b ROLE 4 type_comp_netdev 0 0000000000000010000000000000000100100001000000000000
rc_set_item -b ROLE 4 type_comp_nettemp 0 0000000000000000000000000000000010000000000000000000
rc_set_item -b ROLE 4 type_comp_netobj 0 0000000001111000010000000000000010000000000100000000
rc_set_item -b ROLE 4 type_comp_netobj 3 0000000011111110000000000000000000000000000110000000
rc_set_item ROLE 4 def_fd_create_type 4294967294
rc_set_item ROLE 4 def_process_create_type 4294967294
rc_set_item ROLE 4 def_process_chown_type 4294967291
rc_set_item ROLE 4 def_process_execute_type 4294967295
rc_set_item ROLE 4 def_ipc_create_type 0

attr_set_net NETTEMP rc_type 3 100
attr_set_net NETTEMP rc_type 3 120
attr_set_net NETTEMP rc_type 3 1000
attr_set_net NETTEMP rc_type 3 100105

attr_set_file_dir FILE /usr/sbin/named rc_force_role 4
