% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/is-valid.R
\docType{methods}
\name{isIdCurrent}
\alias{dbIsValid,MySQLConnection-method}
\alias{dbIsValid,MySQLDriver-method}
\alias{dbIsValid,MySQLResult-method}
\alias{isIdCurrent}
\title{Check if a database object is valid.}
\usage{
isIdCurrent(obj)

\S4method{dbIsValid}{MySQLDriver}(dbObj)

\S4method{dbIsValid}{MySQLConnection}(dbObj)

\S4method{dbIsValid}{MySQLResult}(dbObj)
}
\arguments{
\item{dbObj,obj}{A \code{MysqlDriver}, \code{MysqlConnection},
\code{MysqlResult}.}
}
\value{
a logical scalar.
}
\description{
Support function that verifies that an object holding a reference to a
foreign object is still valid for communicating with the RDBMS.
\code{isIdCurrent} will be deprecated in the near future; please use
the \code{\link[DBI]{dbIsValid}()} generic instead.
}
\details{
\code{dbObjects} are R/S-Plus remote references to foreign objects. This
introduces differences to the object's semantics such as persistence (e.g.,
connections may be closed unexpectedly), thus this function provides a
minimal verification to ensure that the foreign object being referenced can
be contacted.
}
\examples{
dbIsValid(MySQL())
}

