// TODO: merge with nfem/plib/rounder.h
template <class T>
struct rounder_type : std::unary_function<T,T> {
  rounder_type (const T& prec) : _prec(prec) {}
  T operator() (const T& x) const {
     // use floor : std::round() is non-standard (INTEL C++)
     T value = _prec*floor(x/_prec + 0.5);
     if (1+value == 1) value = T(0);
     return value;
  }
  T _prec;
};
