#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
SRCDIR=${SRCDIR-"."}
TOP_SRCDIR=${TOP_SRCDIR-"../.."}
DATADIR=${TOP_SRCDIR}/nfem/data
NPROC_MAX=${NPROC_MAX-"7"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0

# --------------------
# 2D tests
# --------------------
run "../sbin/mkgeo_grid_2d -t 11 > square-11.geo"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-11 -test 1 -normal 1 0 0 -origin 0.5 0.5 0 -m 1    -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-11 -test 1 -normal 0 1 0 -origin 0.5 0.5 0 -m 1    -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-11 -test x -normal 0 1 0 -origin 0.5 0.5 0 -m 0.333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-11 -test y -normal 1 0 0 -origin 0.5 0.5 0 -m 0.333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-11 -test x -normal 1 0 0 -origin 0.5 0.5 0 -m 0.25 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-11 -test y -normal 0 1 0 -origin 0.5 0.5 0 -m 0.25 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "rm -f square-11.geo"


run "../sbin/mkgeo_grid_2d -t 101 > square-101.geo"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst square-101 -test x2 -normal 0 1 0 -origin 0.5 0.5 0 -m 0.200010892391878 -a 1.3333006567983 >/dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "rm -f square-101.geo"


run "./form_grad_grad_s_tst $DATADIR/square-bamg -test 1 -normal 1 0 0 -origin 0.5 0.5 0 -m 1    -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/square-bamg -test 1 -normal 0 1 0 -origin 0.5 0.5 0 -m 1    -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/square-bamg -test x -normal 0 1 0 -origin 0.5 0.5 0 -m 0.333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/square-bamg -test y -normal 1 0 0 -origin 0.5 0.5 0 -m 0.333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/square-bamg -test x -normal 1 0 0 -origin 0.5 0.5 0 -m 0.25 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/square-bamg -test y -normal 0 1 0 -origin 0.5 0.5 0 -m 0.25 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
# --------------------
# 3D tests
# --------------------
run "../sbin/mkgeo_grid_3d -T 5 | ../bin/geo -upgrade -geo - > cube-5.geo"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst cube-5 -test 1 -normal 0 1 0 -origin 0.5 0.5 0.5 -m 1 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst cube-5 -test x -normal 0 1 0 -origin 0.5 0.5 0.5 -m 0.333333333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst cube-5 -test y -normal 1 0 0 -origin 0.5 0.5 0.5 -m 0.333333333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst cube-5 -test z -normal 1 0 0 -origin 0.5 0.5 0.5 -m 0.333333333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst cube-5 -test x -normal 1 0 0 -origin 0.5 0.5 0.5 -m 0.25 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "rm -f cube-5.geo"


run "./form_grad_grad_s_tst $DATADIR/cube-gmsh -test 1 -normal 0 1 0 -origin 0.5 0.5 0.5 -m 1 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/cube-gmsh -test x -normal 0 1 0 -origin 0.5 0.5 0.5 -m 0.333333333333333 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/cube-gmsh -test y -normal 1 0 0 -origin 0.5 0.5 0.5 -m 0.333333333333333-1 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/cube-gmsh -test z -normal 1 0 0 -origin 0.5 0.5 0.5 -m 0.333333333333333-1 -a 1 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi
run "./form_grad_grad_s_tst $DATADIR/cube-gmsh -test x -normal 1 0 0 -origin 0.5 0.5 0.5 -m 0.25 -a 0 > /dev/null 2>/dev/null"
if test $? -ne 0; then status=1; fi

exit $status
