#ifndef _RHEOLEF_FORM_VF_EXPR_OPS_V0_H
#define _RHEOLEF_FORM_VF_EXPR_OPS_V0_H
//
// This file is part of Rheolef.
//
// Copyright (C) 2000-2009 Pierre Saramito 
//
// Rheolef is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// Rheolef is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Rheolef; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// ==========================================================================
// 
// form_vf: template expressions
//
// author: Pierre.Saramito@imag.fr
//
// date: 20 march 2011
//
#include "rheolef/form_vf_expr.h"
namespace rheolef {

#ifdef TO_CLEAN
// ---------------------------------
// u*v
// ---------------------------------
template<class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::multiplies
     ,test_basic<T,M,VfTag1>
     ,test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
operator* (const test_basic<T,M,VfTag1>& x, const test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::multiplies                                    op_t;
  typedef test_basic<T,M,VfTag1>                                 arg1_t;
  typedef test_basic<T,M,VfTag2>                                 arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// field_vf_expr*v
// ---------------------------------
template<class Expr1, class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::multiplies
     ,field_vf_expr<Expr1,VfTag1>
     ,test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
operator* (const field_vf_expr<Expr1,VfTag1>& x, const test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::multiplies                                    op_t;
  typedef field_vf_expr<Expr1,VfTag1>                            arg1_t;
  typedef test_basic<T,M,VfTag2>                                 arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// vf_expr(u)*vf_expr(v)
// ---------------------------------
template<class Expr1, class Expr2, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::multiplies
     ,field_vf_expr<Expr1,VfTag1>
     ,field_vf_expr<Expr2,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
operator* (const field_vf_expr<Expr1,VfTag1>& x, const field_vf_expr<Expr2,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::multiplies                                    op_t;
  typedef field_vf_expr<Expr1,VfTag1>                            arg1_t;
  typedef field_vf_expr<Expr2,VfTag2>                            arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// dot(u,v)
// ---------------------------------
template<class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::dot_
     ,test_basic<T,M,VfTag1>
     ,test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
dot (const test_basic<T,M,VfTag1>& x, const test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type        VfTag2;
  typedef details::dot_                                      op_t;
  typedef test_basic<T,M,VfTag1>                                 arg1_t;
  typedef test_basic<T,M,VfTag2>                                 arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// dot(expr(u),v)
// ---------------------------------
template<class Expr, class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::dot_
     ,field_vf_expr<Expr,VfTag1>
     ,test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
dot (const field_vf_expr<Expr,VfTag1>& x, const test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::dot_                                       op_t;
  typedef field_vf_expr<Expr,VfTag1>                             arg1_t;
  typedef test_basic<T,M,VfTag2>                                 arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// dot(u,expr(v))
// ---------------------------------
template<class Expr, class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::dot_
     ,test_basic<T,M,VfTag1>
     ,field_vf_expr<Expr,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
dot (const test_basic<T,M,VfTag1>& x, const field_vf_expr<Expr,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::dot_                                       op_t;
  typedef test_basic<T,M,VfTag1>                                 arg1_t;
  typedef field_vf_expr<Expr,VfTag2>                             arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// dot(expr(u),expr(v))
// ---------------------------------
template<class Expr1, class Expr2, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::dot_
     ,field_vf_expr<Expr1,VfTag1>
     ,field_vf_expr<Expr2,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
dot (const field_vf_expr<Expr1,VfTag1>& x, const field_vf_expr<Expr2,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::dot_                                          op_t;
  typedef field_vf_expr<Expr1,VfTag1>                            arg1_t;
  typedef field_vf_expr<Expr2,VfTag2>                            arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// ddot(u,v)
// ---------------------------------
template<class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::ddot_
     ,test_basic<T,M,VfTag1>
     ,test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
ddot (const test_basic<T,M,VfTag1>& x, const test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::ddot_                                         op_t;
  typedef test_basic<T,M,VfTag1>                                 arg1_t;
  typedef test_basic<T,M,VfTag2>                                 arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// ddot(expr,v)
// ---------------------------------
template<class Expr, class T, class M, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::ddot_
     ,field_vf_expr<Expr,VfTag1>
     ,test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
ddot (const field_vf_expr<Expr,VfTag1>& x, const test_basic<T,M,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::ddot_                                         op_t;
  typedef field_vf_expr<Expr,VfTag1>                             arg1_t;
  typedef test_basic<T,M,VfTag2>                                 arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// ddot(expr(u),expr(v))
// ---------------------------------
template<class Expr1, class Expr2, class VfTag1>
inline
form_vf_expr<
  form_vf_expr_bf_field<
      details::ddot_
     ,field_vf_expr<Expr1,VfTag1>
     ,field_vf_expr<Expr2,typename details::dual_vf_tag<VfTag1>::type>
    >
  >
ddot (const field_vf_expr<Expr1,VfTag1>& x, const field_vf_expr<Expr2,typename details::dual_vf_tag<VfTag1>::type>& y)
{
  typedef typename details::dual_vf_tag<VfTag1>::type            VfTag2;
  typedef details::ddot_                                         op_t;
  typedef field_vf_expr<Expr1,VfTag1>                            arg1_t;
  typedef field_vf_expr<Expr2,VfTag2>                            arg2_t;
  typedef form_vf_expr_bf_field<op_t, arg1_t, arg2_t>            expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// form_vf_expr +- form_vf_expr
// ---------------------------------
template<class Expr1, class Expr2>
inline
form_vf_expr<
  form_vf_expr_bf<
      details::plus
     ,form_vf_expr<Expr1>
     ,form_vf_expr<Expr2>
    >
  >
operator+ (const form_vf_expr<Expr1>& x, const form_vf_expr<Expr2>& y)
{
  typedef details::plus                                         op_t;
  typedef form_vf_expr<Expr1>                                   arg1_t;
  typedef form_vf_expr<Expr2>                                   arg2_t;
  typedef form_vf_expr_bf<op_t, arg1_t, arg2_t>                 expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
template<class Expr1, class Expr2>
inline
form_vf_expr<
  form_vf_expr_bf<
      details::minus
     ,form_vf_expr<Expr1>
     ,form_vf_expr<Expr2>
    >
  >
operator- (const form_vf_expr<Expr1>& x, const form_vf_expr<Expr2>& y)
{
  typedef details::minus                                        op_t;
  typedef form_vf_expr<Expr1>                                   arg1_t;
  typedef form_vf_expr<Expr2>                                   arg2_t;
  typedef form_vf_expr_bf<op_t, arg1_t, arg2_t>                 expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
// ---------------------------------
// alpha*form_vf_expr
// ---------------------------------
template<class Expr>
inline
form_vf_expr<
  form_vf_expr_uf<
      std::binder1st<std::multiplies<typename Expr::scalar_type> >
     ,form_vf_expr<Expr>
    >
  >
operator* (const typename Expr::scalar_type& x, const form_vf_expr<Expr>& y)
{
  typedef typename Expr::scalar_type                            T;
  typedef std::multiplies<T>                                    raw_fun_t;
  typedef std::binder1st<raw_fun_t>                             fun_t;
  typedef form_vf_expr<Expr>                                    arg_t;
  typedef form_vf_expr_uf<fun_t, arg_t>                         expr_t;
  return form_vf_expr<expr_t>(expr_t(fun_t(raw_fun_t(), x), y));
}
// ---------------------------------
// eta_h*form_vf_expr
// ---------------------------------
template<class T, class M, class Expr>
inline
form_vf_expr<
  form_vf_expr_binded_bf<
    details::multiplies
   ,field_expr_terminal_field<T,M>
   ,form_vf_expr<Expr>
  >
>
operator* (const field_basic<T,M>& x, const form_vf_expr<Expr>& y)
{
  typedef details::multiplies                               op_t;
  typedef field_expr_terminal_field<T,M>                    arg1_t;
  typedef form_vf_expr<Expr>                                arg2_t;
  typedef form_vf_expr_binded_bf<op_t, arg1_t, arg2_t>      expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), arg1_t(x), y));
}
// ---------------------------------
// field_nl_expr*form_vf_expr
// ---------------------------------
template<class Expr1, class Expr2>
inline
form_vf_expr<
  form_vf_expr_binded_bf<
    details::multiplies
   ,field_nonlinear_expr<Expr1>
   ,form_vf_expr<Expr2>
  >
>
operator* (const field_nonlinear_expr<Expr1>& x, const form_vf_expr<Expr2>& y)
{
  typedef details::multiplies                               op_t;
  typedef field_nonlinear_expr<Expr1>                       arg1_t;
  typedef form_vf_expr<Expr2>                               arg2_t;
  typedef form_vf_expr_binded_bf<op_t, arg1_t, arg2_t>      expr_t;
  return form_vf_expr<expr_t>(expr_t(op_t(), x, y));
}
#endif // TO_CLEAN 

} // namespace rheolef
#endif // _RHEOLEF_FORM_VF_EXPR_OPS_V0_H
