namespace rheolef {
  Float phi (const point& x) { return norm(x) - 1; }
  
  void get_spherical_coordinates (const point& x, Float& rho, Float& theta, Float& phi) {
    static const Float pi = acos(Float(-1));
    rho = norm(x);
    phi = acos(x[2]/rho);
    theta = acos(x[0]/sqrt(sqr(x[0])+sqr(x[1])));
    if (x[1] < 0) theta = 2*pi - theta;
  }
  // test case from DecDziEllHei-2009, p. 17
  // for Helmhotz operator:
  //
  //	u - Laplacian_s(u) = f  on Gamma
  //
  struct p : std::unary_function<point,Float> {
   Float operator() (const point& x) {
    if (d == 2) return 26*(pow(x[0],5)-10*pow(x[0],3)*sqr(x[1]) + 5*x[0]*pow(x[1],4));
    return 3*sqr(x[0])*x[1] - pow(x[1],3);
   }
   p (size_t d1) : d(d1) {}
   protected: size_t d;
  };
  struct f : std::unary_function<point,Float> {
   Float operator() (const point& x) {
    if (d == 2) return _p(x)/pow(norm(x),5);
    return alpha*_p(x);
   }
   f (size_t d1) : d(d1), _p(d1) {
     Float pi = acos(Float(-1));
     alpha = -(13./8.)*sqrt(35./pi);
   }
   protected: size_t d; p _p; Float alpha;
  };
  struct u : std::unary_function<point,Float> {
   Float operator() (const point& x) {
    if (d == 2) return _f(x)/(25+sqr(norm(x)));
    return sqr(norm(x))/(12+sqr(norm(x)))*_f(x);
   }
   u (size_t d1) : d(d1), _f(d1) {}
   protected: size_t d; f _f;
  };
} // namespace rheolef
