<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA DSSSL>
<!ENTITY refdblib SYSTEM "../lib/refdblib.dsl">
<!ENTITY refdbvar SYSTEM "../lib/refdbvar.dsl">
]>

<style-sheet>
<style-specification use="docbook">
<style-specification-body>

;; $Id: docbook-refdb.dsl,v 1.8.2.3 2005/12/17 00:57:51 mhoenicka Exp $
;; Driver file for the DocBook stylesheets.

;; include common stuff
&refdblib;
&refdbvar;

;; overrides for docbook definitions (in dbparam.dsl)

(define %graphic-extensions% 
  ;; REFENTRY graphic-extensions
  ;; PURP List of graphic filename extensions
  ;; DESC
  ;; The list of extensions which may appear on a 'fileref'
  ;; on a 'Graphic' which are indicative of graphic formats.
  ;;
  ;; Filenames that end in one of these extensions will not have
  ;; the '%graphic-default-extension%' added to them.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  '("gif" "jpg" "jpeg" "png" "tif" "tiff" "eps" "epsf"))

(define %html-ext% 
  ;; REFENTRY html-ext
  ;; PURP Default extension for HTML output files
  ;; DESC
  ;; The default extension for HTML output files.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  ".html")

(define html-manifest
  ;; REFENTRY html-manifest
  ;; PURP Write a manifest?
  ;; DESC
  ;; If not '#f' then the list of HTML files created by the stylesheet
  ;; will be written to the file named by 'html-manifest-filename'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

(define html-manifest-filename
  ;; REFENTRY html-manifest-filename
  ;; PURP Name of HTML manifest file
  ;; DESC
  ;; The name of the file to which a manifest will be written if
  ;; 'html-manifest' is not '#f'.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  "HTML.manifest")

(define %shade-verbatim%  
  ;; REFENTRY shade-verbatim
  ;; PURP Should verbatim environments be shaded?
  ;; DESC
  ;; If true, a table with '($shade-verbatim-attr$)' attributes will be
  ;; wrapped around each verbatim environment.  This gives the effect
  ;; of a shaded verbatim environment.
  ;; /DESC
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)

;;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; refdb defines

(define fold-multixref  
  ;; REFENTRY fold-multixref
  ;; PURP Should consecutive numbered citations be folded to a range?
  ;; DESC
  ;; Some numeric citation formats demand that consecutive citations be
  ;; folded into a range. This looks cool in printed media, but it breaks
  ;; the benefit of a link to each of the cited references. If this
  ;; value is set to #f, all single citations will be displayed instead
  ;; with the correct links to the references, regardless of what the
  ;; citation style suggests. You buy increased functionality by departing
  ;; from the canonical citation style.
  ;; /DESC
  ;; EXAMPLE
  ;; if fold-multixref is set to #t, a citation of references (1,2,3,4,6)
  ;; will be formatted as (1-4,6) if the citation style suggests so. If
  ;; set to #f, it is displayed as is.
  ;; AUTHOR N/A
  ;; /REFENTRY
  #t)


(define (refdb-process-inline token)
  ;; REFENTRY refdb-process-inline
  ;; PURP process inline elements with refdb formatting instructions
  ;; DESC
  ;; uses the command line parameters to apply custom formatting to
  ;; inline elements
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-process-inline "VOLUMESTYLE") will process the current element
  ;; and its children with the formatting instructions in the variable
  ;; VOLUMESTYLE
  ;; /EXAMPLE
  ;; /REFENTRY

  (make sequence
    (if (refdb-underline? token)
	(make formatting-instruction
	  data: "&#60;U&#62;")
	(empty-sosofo))
    
    (if (equal? (refdb-getfontweight token) 'bold)
	(make formatting-instruction
	  data: "&#60;B&#62;")
	(empty-sosofo))

    (if (equal? (refdb-getfontposture token) 'italic)
	(make formatting-instruction
	  data: "&#60;I&#62;")
	(empty-sosofo))

    (cond
     ((equal? (refdb-getsubsup token) "SUB")
	(make formatting-instruction
	  data: "&#60;SUB&#62;"))
     ((equal? (refdb-getsubsup token) "SUP")
	(make formatting-instruction
	  data: "&#60;SUP&#62;"))
     (else
      (empty-sosofo)))

    (process-children)

    (cond
     ((equal? (refdb-getsubsup token) "SUB")
	(make formatting-instruction
	  data: "&#60;/SUB&#62;"))
     ((equal? (refdb-getsubsup token) "SUP")
	(make formatting-instruction
	  data: "&#60;/SUP&#62;"))
     (else
      (empty-sosofo)))

    (if (equal? (refdb-getfontposture token) 'italic)
	(make formatting-instruction
	  data: "&#60;/I&#62;")
	(empty-sosofo))

    (if (equal? (refdb-getfontweight token) 'bold)
	(make formatting-instruction
	  data: "&#60;/B&#62;")
	(empty-sosofo))

    (if (refdb-underline? token)
	(make formatting-instruction
	  data: "&#60;/U&#62;")
	(empty-sosofo))))
    


(define (refdb-literal string token)
  ;; REFENTRY refdb-literal
  ;; PURP display literal string with refdb formatting instructions
  ;; DESC
  ;; uses the command line parameters to apply custom formatting to
  ;; literals
  ;; ARGS
  ;; ARG 'string'
  ;; the string to print
  ;; /ARG
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-process-inline "VOLUMESTYLE") will process the current element
  ;; and its children with the formatting instructions in the variable
  ;; VOLUMESTYLE
  ;; /EXAMPLE
  ;; /REFENTRY
  (make sequence
    (if (refdb-underline? token)
	(make formatting-instruction
	  data: "&#60;U&#62;")
	(empty-sosofo))
    
    (if (equal? (refdb-getfontweight token) 'bold)
	(make formatting-instruction
	  data: "&#60;B&#62;")
	(empty-sosofo))

    (if (equal? (refdb-getfontposture token) 'italic)
	(make formatting-instruction
	  data: "&#60;I&#62;")
	(empty-sosofo))

    (cond
     ((equal? (refdb-getsubsup token) "SUB")
	(make formatting-instruction
	  data: "&#60;SUB&#62;"))
     ((equal? (refdb-getsubsup token) "SUP")
	(make formatting-instruction
	  data: "&#60;SUP&#62;"))
     (else
      (empty-sosofo)))

    (literal string)

    (cond
     ((equal? (refdb-getsubsup token) "SUB")
	(make formatting-instruction
	  data: "&#60;/SUB&#62;"))
     ((equal? (refdb-getsubsup token) "SUP")
	(make formatting-instruction
	  data: "&#60;/SUP&#62;"))
     (else
      (empty-sosofo)))

    (if (equal? (refdb-getfontposture token) 'italic)
	(make formatting-instruction
	  data: "&#60;/I&#62;")
	(empty-sosofo))

    (if (equal? (refdb-getfontweight token) 'bold)
	(make formatting-instruction
	  data: "&#60;/B&#62;")
	(empty-sosofo))

    (if (refdb-underline? token)
	(make formatting-instruction
	  data: "&#60;/U&#62;")
	(empty-sosofo))))

(define (refdb-getsubsup token)
  ;; REFENTRY refdb-getsubsup
  ;; PURP retrieves the font shift (for sub/superscript)
  ;; DESC
  ;; determines whether the current element should be displayed
  ;; as superscript/subscript/normal
  ;; ARGS
  ;; ARG 'token'
  ;; this is roughly equivalent to an element, but the name of the token
  ;; stems from the name in the database, not from the DocBook element
  ;; /ARG
  ;; /ARGS
  ;; /DESC
  ;; EXAMPLE
  ;; (refdb-getsubsup "VOLUMESTYLE") will return "SUB" if we are in a
  ;; "bibliomixed" element with the role attribute "JOUR" and the variable
  ;; "JOURVOLUMESTYLE" has the value "SUPER"
  ;; /EXAMPLE
  ;; /REFENTRY
  (let* ((pointshift (refdb-getstyle token)))
    (cond ((equal? pointshift "SUB") "SUB")
	  ((equal? pointshift "SUPER") "SUP")
	  (else ""))))

;;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; docbook overrides: bibliography stuff

(define (refdb-bibliography-content)
  ;; Note that the code below works for both the case where the bibliography
  ;; has BIBLIODIVs and the case where it doesn't, by the slightly subtle
  ;; fact that if it does, then allentries will be (empty-node-list).
  (let* ((allbibcontent (children (current-node)))
	 (prebibcontent (node-list-filter-by-not-gi 
			 allbibcontent
			 (list (normalize "biblioentry")
			       (normalize "bibliomixed"))))
	 (allentries    (node-list-filter-by-gi 
			 allbibcontent
			 (list (normalize "biblioentry")
			       (normalize "bibliomixed"))))
	 (entries       (if biblio-filter-used
			    (biblio-filter allentries)
			    allentries)))
    (make sequence
      (with-mode refdb-mode (process-node-list prebibcontent))
      (if (bibliography-table)
	  (make element gi: "TABLE"
		attributes: '(("BORDER" "0"))
		(with-mode refdb-mode (process-node-list entries)))
	  (with-mode refdb-mode (process-node-list entries))))))

(define (refdb-nontable-bibliomixed 
	 xreflabel leading-abbrev inline-children)
  (let* ((has-leading-abbrev? (not (node-list-empty? leading-abbrev))))
    (make element gi: "P"
	  attributes: (list (list "CLASS" (gi)))
	  (make empty-element gi: "A"
		attributes: (list (list "NAME" (attribute-string (normalize "id")))))
	  (with-mode biblioentry-inline-refdb-mode
	    (process-node-list inline-children)))))

(define (refdb-table-bibliomixed 
	 xreflabel leading-abbrev inline-children)
  (let* ((has-leading-abbrev? (not (node-list-empty? leading-abbrev))))
    (make element gi: "TR"
	  (make element gi: "TD"
		attributes: '(("ALIGN" "LEFT")
			      ("VALIGN" "TOP")
			      ("WIDTH" "10%"))

	  (make element gi: "TD"
		attributes: '(("ALIGN" "LEFT")
			      ("VALIGN" "TOP")
			      ("WIDTH" "90%"))
		(make empty-element gi: "A"
		      attributes: (list (list "NAME" (attribute-string (normalize "id")))))
		(with-mode biblioentry-inline-refdb-mode
		  (process-node-list inline-children)))))))

(mode refdb-mode
  (element bibliomixed
    (if (equal? (normalize
		 (attribute-string (normalize "role"))) (normalize "multixref"))
	(empty-sosofo)
	(let* ((xreflabel (attribute-string (normalize "xreflabel"))))
	  (if (bibliography-table)
	      (refdb-table-bibliomixed xreflabel (empty-node-list)
				 (children(current-node)))
	      (refdb-nontable-bibliomixed xreflabel (empty-node-list)
				    (children (current-node)))))))

)

;; bibliography is the entry point where we fork off the RefDB-specific
;; formatting
(element (book bibliography)
  (let ((title         (element-title-sosofo (current-node)))
	(body          (make sequence
			 (make element gi: "A"
			       attributes: (list (list "NAME" (element-id)))
			       (empty-sosofo))
			 ($component-separator$)
			 ($component-title$)
			 (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "refdb"))
			     (refdb-bibliography-content)
			     (bibliography-content)))))
    (html-document title body)))

(element (article bibliography)
  (let ((title         (element-title-sosofo (current-node)))
	(body          (make sequence
			 (make element gi: "A"
			       attributes: (list (list "NAME" (element-id)))
			       (empty-sosofo))
			 ($component-separator$)
			 ($component-title$)
			 (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "refdb"))
			     (refdb-bibliography-content)
			     (bibliography-content)))))
    (html-document title body)))

(element bibliography
  ;; A bibliography that's inside something else...or root
  (if (sgml-root-element? (current-node))
      (let ((title         (element-title-sosofo (current-node)))
	    (body          (make sequence
			     (make element gi: "A"
				   attributes: (list (list "NAME"
							   (element-id)))
				   (empty-sosofo))
			     ($component-separator$)
			     ($component-title$)
			     (if (equal? (normalize (attribute-string (normalize "role"))) "REFDB")
				 (refdb-bibliography-content)
				 (bibliography-content)))))
	(html-document title body))
      (let* ((sect   (ancestor-member (current-node) 
				      (append (section-element-list)
					      (component-element-list))))
	     (hlevel (+ (SECTLEVEL sect) 1))
	     (helem  (string-append "H" (number->string (+ hlevel 1)))))
	(make sequence
	  (make element gi: helem
		(make element gi: "A"
		      attributes: (list (list "NAME" (element-id)))
		      (element-title-sosofo (current-node))))
	  (if (equal? (normalize (attribute-string (normalize "role"))) (normalize "refdb"))
	      (refdb-bibliography-content)
	      (bibliography-content))))))
  
(mode biblioentry-inline-refdb-mode
  (element abbrev
    (refdb-process-inline "REFNUMBERSTYLE"))

  (element abstract
    (refdb-process-inline "ABSTRACTSTYLE"))

  (element address
    (refdb-process-inline "ADDRESSSTYLE"))

  (element affiliation
    (let ((inline-children (node-list-filter-by-not-gi 
			    (children (current-node))
			    (list (normalize "address")))))
      (let loop ((nl inline-children))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (process-node-list (node-list-first nl))
	      (if (node-list-empty? (node-list-rest nl))
		  (empty-sosofo)
		  (literal ", "))
	      (loop (node-list-rest nl)))))))

  (element artpagenums
    (make sequence
      (process-children)))

  (element author
    (make sequence
      (process-children)))

  (element authorgroup
    (process-children))

  (element authorinitials
    (make sequence
      (process-children)))

  (element (address city)
    (refdb-process-inline "PUBPLACESTYLE"))

  (element collab
    (let* ((nl (children (current-node)))
	   (collabname (node-list-first nl))
	   (affil (node-list-rest nl)))
      (make sequence
	(process-node-list collabname)
	(if (node-list-empty? affil)
	    (empty-sosofo)
	    (let loop ((nl affil))
	      (if (node-list-empty? nl)
		  (empty-sosofo)
		  (make sequence
		    (literal ", ")
		    (process-node-list (node-list-first nl))
		    (loop (node-list-rest nl)))))))))

  (element (collab collabname)
    (process-children))

  (element confgroup
    (let ((inline-children (node-list-filter-by-not-gi 
			    (children (current-node))
			    (list (normalize "address")))))
      (let loop ((nl inline-children))
	(if (node-list-empty? nl)
	    (empty-sosofo)
	    (make sequence
	      (process-node-list (node-list-first nl))
	      (if (node-list-empty? (node-list-rest nl))
		  (empty-sosofo)
		  (literal ", "))
	      (loop (node-list-rest nl)))))))

  (element contractnum
    (process-children))

  (element contractsponsor
    (process-children))

  (element contrib
    (process-children))

  (element copyright
    ;; Just print the year(s)
    (let ((years (select-elements (children (current-node))
				  (normalize "year"))))
      (process-node-list years)))

  (element (copyright year)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (empty-sosofo))))

  (element corpauthor
    (make sequence
      (process-children)))

  (element corpname
    (make sequence
      (process-children)))

  (element date
    (make sequence
      (process-children)))

  (element edition
    (make sequence
      (process-children)))

  (element editor
    (make element gi: "SPAN"
	  attributes: '(("CLASS" "EDITOR"))
	  (if (first-sibling?) 
	      (make sequence
		(literal (gentext-edited-by))
		(literal " "))
	      (empty-sosofo))
	  (literal (author-list-string))))

  (element firstname
    (let ((relation (normalize 
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element honorific
    (let ((relation (normalize
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element invpartnumber
    (make sequence
      (process-children)))

  (element isbn
    (refdb-process-inline "SERIALSTYLE"))

  (element issn
    (refdb-process-inline "SERIALSTYLE"))

  (element issuenum
    (refdb-process-inline "ISSUESTYLE"))

  (element lineage
    (let ((relation (normalize
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element orgname
    (make sequence
      (process-children)))

  (element othercredit
    (make element gi: "SPAN"
	  attributes: '(("CLASS" "OTHERCREDIT"))
	  (literal (author-list-string))))

  (element othername
    (let ((relation (normalize
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element pagenums
    (refdb-process-inline "PAGESSTYLE"))

  (element productname
    (make sequence
      ($charseq$)
; this is actually a problem since "trade" is the default value for
; the class attribute. we can put this back in in DocBook 5.0, when
; class becomes #IMPLIED
;      (if (equal? (attribute-string "class") (normalize "trade"))
;	  (dingbat-sosofo "trademark")
;	  (empty-sosofo))
      ))

  (element productnumber
    (make sequence
      (process-children)))

  (element pubdate
    (let ((role (normalize
		(attribute-string (normalize "role")))))
     (cond
      ((equal? role (normalize "primary")) 
	(refdb-process-inline "PUBDATESTYLE"))
      ((equal? role (normalize "secondary")) 
	(refdb-process-inline "PUBDATESECSTYLE"))
      (else 
	(refdb-process-inline "PUBDATEALLSTYLE")))))

  (element publisher
    (let ((pubname (select-elements (children (current-node))
				    (normalize "publishername")))
	  (cities  (select-elements (descendants (current-node))
				    (normalize "city"))))
    (make sequence
      (process-node-list pubname)
      (if (node-list-empty? cities)
	  (empty-sosofo)
	  (literal ", "))
      (process-node-list cities))))

  (element publishername
    (refdb-process-inline "PUBLISHERSTYLE"))

  (element (publisher address city)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (empty-sosofo))))

  (element pubsnumber
    (make sequence
      (process-children)))

  (element releaseinfo
    (make sequence
      (process-children)))

  (element seriesvolnums
    (make sequence
      (process-children)))

  (element subtitle
    (make element gi: "I"
	  (process-children)))

  (element surname
    (let ((relation (normalize
		(inherited-attribute-string (normalize "relation")))))
     (cond
      ((equal? relation (normalize "author")) 
	(refdb-process-inline "AUTHORLISTSTYLE"))
      ((equal? relation (normalize "editor")) 
	(refdb-process-inline "EDITORLISTSTYLE"))
      ((equal? relation (normalize "seditor")) 
	(refdb-process-inline "SEDITORLISTSTYLE"))
      (else 
	(refdb-process-inline "ALLALISTSTYLE")))))

  (element title
    (make element gi: "I"
	  (process-children)))

  (element titleabbrev
    (make sequence
      (process-children)))

  (element ulink
    (let ((target (normalize (attribute-string (normalize "url")))))
      (make element gi: "A"
	    attributes: (list
			 (list "HREF" target))
	    (refdb-process-inline "URLSTYLE"))))

  (element volumenum
    (refdb-process-inline "VOLUMESTYLE"))

  (element (bibliomixed title) 
      (make element gi: "I"
	    (process-children)))
  
  (element (bibliomixed subtitle) 
    (make element gi: "I"
	  (process-children)))

  (element (biblioset title)
    (let ((rel (normalize
		(inherited-attribute-string (normalize "relation")))))
      (cond
       ((equal? rel (normalize "article")) (make sequence
				 (literal (gentext-start-quote))
				 (process-children)
				 (literal (gentext-end-quote))))
       (else (make element gi: "I"
		   (process-children))))))

  (element (bibliomset title)
    (let ((rel (normalize
		(inherited-attribute-string (normalize "relation")))))
      (cond
       ((equal? rel (normalize "article")) 
	(refdb-process-inline "TITLESTYLE"))
       ((equal? rel (normalize "journal")) 
	(refdb-process-inline "JOURNALNAMESTYLE"))
       ((equal? rel (normalize "book"))
	(refdb-process-inline "BOOKTITLESTYLE"))
       ((equal? rel (normalize "chapter"))
	(refdb-process-inline "CHAPTITLESTYLE"))
       ((equal? rel (normalize "series"))
	(refdb-process-inline "SERIESTITLESTYLE"))
       ((equal? rel (normalize "all"))
	(refdb-process-inline "ALLTITLESTYLE"))
       ((equal? rel (normalize "author")) 
	(refdb-process-inline "AUTHORLISTALTERNATESTYLE"))
       (else  (make element gi: "B"
		    (process-children))))))

  (element bibliomset
    (let ((role (normalize (attribute-string (normalize "role"))))
	  (relation (normalize (attribute-string (normalize "relation")))))
      (cond
       ((equal? role (normalize "intext"))
	(empty-sosofo))
       ((equal? role (normalize "intextsq"))
	(empty-sosofo))
       ((equal? role (normalize "authoronly"))
	(empty-sosofo))
       ((equal? role (normalize "authoronlysq"))
	(empty-sosofo))
       ((equal? role (normalize "yearonly"))
	(empty-sosofo))
       ((equal? relation (normalize "endtermtarget"))
	(empty-sosofo))
       ((equal? role (normalize "userdef1"))
	(refdb-process-inline "USERDEF1STYLE"))
       ((equal? role (normalize "userdef2"))
	(refdb-process-inline "USERDEF2STYLE"))
       ((equal? role (normalize "userdef3"))
	(refdb-process-inline "USERDEF3STYLE"))
       ((equal? role (normalize "userdef4"))
	(refdb-process-inline "USERDEF4STYLE"))
       ((equal? role (normalize "userdef5"))
	(refdb-process-inline "USERDEF5STYLE"))
       ((equal? role (normalize "misc1"))
	(refdb-process-inline "MISC1STYLE"))
       ((equal? role (normalize "misc2"))
	(refdb-process-inline "MISC2STYLE"))
       ((equal? role (normalize "misc3"))
	(refdb-process-inline "MISC3STYLE"))
       ((equal? role (normalize "link0"))
	(refdb-process-inline "LINK0STYLE"))
       ((equal? role (normalize "link1"))
	(refdb-process-inline "LINK1STYLE"))
       ((equal? role (normalize "link2"))
	(refdb-process-inline "LINK2STYLE"))
       ((equal? role (normalize "link3"))
	(refdb-process-inline "LINK3STYLE"))
       ((equal? role (normalize "link4"))
	(refdb-process-inline "LINK4STYLE"))
       ((equal? role (normalize "notes"))
	(refdb-process-inline "NOTESSTYLE"))
       (else
	(process-children)))))

)

;;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;; docbook overrides: citation/xref stuff
(element citation 
  (if (equal? (normalize
	       (attribute-string (normalize "role"))) (normalize "refdb"))
      (let ((multixref (node-list-filter-by-attribute-token (children (current-node))
						   (normalize "role")  
						   (normalize "multixref"))))
	(if fold-multixref
	    (if (node-list-empty? multixref)
		(with-mode refdb-mode ($charseq$))
		(with-mode refdb-mode (process-node-list multixref)))
	    (with-mode refdb-mode ($charseq$))))
      (if biblio-citation-check
	  (let* ((bgraphies (select-elements (descendants (sgml-root-element))
					     (normalize "bibliography")))
		 (bchildren1 (expand-children bgraphies
					      (list (normalize "bibliography"))))
		 (bchildren2 (expand-children bchildren1
					      (list (normalize "bibliodiv"))))
		 (bibentries (node-list-filter-by-gi 
			      bchildren2
			      (list (normalize "biblioentry")
				    (normalize "bibliomixed")))))
	    (let loop ((bibs bibentries))
	      (if (node-list-empty? bibs)
		  (make sequence
		    (error (string-append "Cannot find citation: " 
					  (data (current-node))))
		    (literal "[") ($charseq$) (literal "]"))
		  (if (citation-matches-target? (current-node) 
						(node-list-first bibs))
		      (make element gi: "A"
			    attributes: (list 
					 (list "HREF" (href-to 
						       (node-list-first bibs))))
			    (literal "[") ($charseq$) (literal "]"))
		      (loop (node-list-rest bibs))))))
	  (make sequence 
	    (literal "[") ($charseq$) (literal "]")))))

(mode refdb-mode
  (element xref
    (let* ((endterm (attribute-string (normalize "endterm")))
	   (multixref (normalize (attribute-string (normalize "role"))))
	   ; we want to link to ID2 if linkend is ID2X or ID2Y or whatever
	   (linkend
	    (if (equal? multixref (normalize "multixref"))
		(attribute-string (normalize "linkend"))
		(substring
		 (attribute-string (normalize "linkend"))
		 0
		 (- (string-length (attribute-string (normalize "linkend"))) 2))))
	   (target  (element-with-id linkend))
	   (xreflabel (attribute-string (normalize "linkend"))))
      (if (and (equal? multixref (normalize "multixref")) (equal? fold-multixref #f))
	  (empty-sosofo)
	  (if (node-list-empty? target)
	      (error (string-append "XRef LinkEnd to missing ID '" linkend "'"))
	      (if endterm
		  (if (node-list-empty? (element-with-id endterm))
		      (error (string-append "XRef EndTerm to missing ID '" 
					    endterm "'"))
		      (make element gi: "A" 
			    attributes: (list
					 (list "HREF" (href-to target)))
			      (process-element-with-id endterm)))
		  (if xreflabel
		      (make element gi: "A"
			    attributes: (list
					 (list "HREF" (href-to target)))
			      (process-element-with-id xreflabel))
		      (empty-sosofo)))))))

  (element bibliomset
    (with-mode biblioentry-inline-refdb-mode
      (process-children)))
)

(mode refdb-xref-endterm-mode
  (default
    (refdb-process-inline "REFNUMBERSTYLE")))

</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>

