// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2023 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Security.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.security {
  public class Security_3_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("security.Security:3.0.1", null);

    public Security_3_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public Security_3_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new Security_3_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new Security_3_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_INVALID_VALUE = 1;

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.http2httpsRedir = this.http2httpsRedir;
        copy.userBlockTimeout = this.userBlockTimeout;
        copy.userMaxFailedLogins = this.userMaxFailedLogins;
        copy.ipFw = this.ipFw;
        copy.ipV6Fw = this.ipV6Fw;
        copy.roleAccessControl = this.roleAccessControl;
        copy.roleAccessControlV6 = this.roleAccessControlV6;
        copy.pwSettings = this.pwSettings;
        copy.idleTimeout = this.idleTimeout;
        copy.singleLogin = this.singleLogin;
        copy.sshSettings = this.sshSettings;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["http2httpsRedir"] = this.http2httpsRedir;
        json["userBlockTimeout"] = this.userBlockTimeout;
        json["userMaxFailedLogins"] = this.userMaxFailedLogins;
        json["ipFw"] = this.ipFw.Encode();
        json["ipV6Fw"] = this.ipV6Fw.Encode();
        json["roleAccessControl"] = this.roleAccessControl.Encode();
        json["roleAccessControlV6"] = this.roleAccessControlV6.Encode();
        json["pwSettings"] = this.pwSettings.Encode();
        json["idleTimeout"] = this.idleTimeout;
        json["singleLogin"] = this.singleLogin;
        json["sshSettings"] = this.sshSettings.Encode();
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.http2httpsRedir = (bool)json["http2httpsRedir"];
        inst.userBlockTimeout = (int)json["userBlockTimeout"];
        inst.userMaxFailedLogins = (int)json["userMaxFailedLogins"];
        inst.ipFw = Com.Raritan.Idl.security.IpFw_2_0_0.Decode(json["ipFw"], agent);
        inst.ipV6Fw = Com.Raritan.Idl.security.IpFw_2_0_0.Decode(json["ipV6Fw"], agent);
        inst.roleAccessControl = Com.Raritan.Idl.security.RoleAccessControl.Decode(json["roleAccessControl"], agent);
        inst.roleAccessControlV6 = Com.Raritan.Idl.security.RoleAccessControl.Decode(json["roleAccessControlV6"], agent);
        inst.pwSettings = Com.Raritan.Idl.security.PasswordSettings.Decode(json["pwSettings"], agent);
        inst.idleTimeout = (int)json["idleTimeout"];
        inst.singleLogin = (bool)json["singleLogin"];
        inst.sshSettings = Com.Raritan.Idl.security.SSHSettings.Decode(json["sshSettings"], agent);
        return inst;
      }

      public bool http2httpsRedir = false;
      public int userBlockTimeout = 0;
      public int userMaxFailedLogins = 0;
      public Com.Raritan.Idl.security.IpFw_2_0_0 ipFw = new Com.Raritan.Idl.security.IpFw_2_0_0();
      public Com.Raritan.Idl.security.IpFw_2_0_0 ipV6Fw = new Com.Raritan.Idl.security.IpFw_2_0_0();
      public Com.Raritan.Idl.security.RoleAccessControl roleAccessControl = new Com.Raritan.Idl.security.RoleAccessControl();
      public Com.Raritan.Idl.security.RoleAccessControl roleAccessControlV6 = new Com.Raritan.Idl.security.RoleAccessControl();
      public Com.Raritan.Idl.security.PasswordSettings pwSettings = new Com.Raritan.Idl.security.PasswordSettings();
      public int idleTimeout = 0;
      public bool singleLogin = false;
      public Com.Raritan.Idl.security.SSHSettings sshSettings = new Com.Raritan.Idl.security.SSHSettings();
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.security.Security_3_0_1.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.security.Security_3_0_1.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.security.Security_3_0_1.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.security.Security_3_0_1.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.security.Security_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.security.Security_3_0_1.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetHttpRedirSettingsResult {
      public bool _ret_;
    }

    public GetHttpRedirSettingsResult getHttpRedirSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getHttpRedirSettings", _parameters);
      var _ret = new GetHttpRedirSettingsResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getHttpRedirSettings(AsyncRpcResponse<GetHttpRedirSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getHttpRedirSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getHttpRedirSettings(AsyncRpcResponse<GetHttpRedirSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getHttpRedirSettings", _parameters,
        _result => {
          try {
            var _ret = new GetHttpRedirSettingsResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetHttpRedirSettingsResult {
    }

    public SetHttpRedirSettingsResult setHttpRedirSettings(bool http2httpsRedir) {
      var _parameters = new LightJson.JsonObject();
      _parameters["http2httpsRedir"] = http2httpsRedir;

      var _result = RpcCall("setHttpRedirSettings", _parameters);
      var _ret = new SetHttpRedirSettingsResult();
      return _ret;
    }

    public AsyncRequest setHttpRedirSettings(bool http2httpsRedir, AsyncRpcResponse<SetHttpRedirSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setHttpRedirSettings(http2httpsRedir, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setHttpRedirSettings(bool http2httpsRedir, AsyncRpcResponse<SetHttpRedirSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["http2httpsRedir"] = http2httpsRedir;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setHttpRedirSettings", _parameters,
        _result => {
          try {
            var _ret = new SetHttpRedirSettingsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetIpFwSettingsResult {
      public Com.Raritan.Idl.security.IpFw_2_0_0 _ret_;
    }

    public GetIpFwSettingsResult getIpFwSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getIpFwSettings", _parameters);
      var _ret = new GetIpFwSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.security.IpFw_2_0_0.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getIpFwSettings(AsyncRpcResponse<GetIpFwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getIpFwSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getIpFwSettings(AsyncRpcResponse<GetIpFwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getIpFwSettings", _parameters,
        _result => {
          try {
            var _ret = new GetIpFwSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.security.IpFw_2_0_0.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetIpFwSettingsResult {
      public int _ret_;
    }

    public SetIpFwSettingsResult setIpFwSettings(Com.Raritan.Idl.security.IpFw_2_0_0 ipFw) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ipFw"] = ipFw.Encode();

      var _result = RpcCall("setIpFwSettings", _parameters);
      var _ret = new SetIpFwSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setIpFwSettings(Com.Raritan.Idl.security.IpFw_2_0_0 ipFw, AsyncRpcResponse<SetIpFwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setIpFwSettings(ipFw, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setIpFwSettings(Com.Raritan.Idl.security.IpFw_2_0_0 ipFw, AsyncRpcResponse<SetIpFwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ipFw"] = ipFw.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setIpFwSettings", _parameters,
        _result => {
          try {
            var _ret = new SetIpFwSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetIpV6FwSettingsResult {
      public Com.Raritan.Idl.security.IpFw_2_0_0 _ret_;
    }

    public GetIpV6FwSettingsResult getIpV6FwSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getIpV6FwSettings", _parameters);
      var _ret = new GetIpV6FwSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.security.IpFw_2_0_0.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getIpV6FwSettings(AsyncRpcResponse<GetIpV6FwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getIpV6FwSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getIpV6FwSettings(AsyncRpcResponse<GetIpV6FwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getIpV6FwSettings", _parameters,
        _result => {
          try {
            var _ret = new GetIpV6FwSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.security.IpFw_2_0_0.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetIpV6FwSettingsResult {
      public int _ret_;
    }

    public SetIpV6FwSettingsResult setIpV6FwSettings(Com.Raritan.Idl.security.IpFw_2_0_0 ipV6Fw) {
      var _parameters = new LightJson.JsonObject();
      _parameters["ipV6Fw"] = ipV6Fw.Encode();

      var _result = RpcCall("setIpV6FwSettings", _parameters);
      var _ret = new SetIpV6FwSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setIpV6FwSettings(Com.Raritan.Idl.security.IpFw_2_0_0 ipV6Fw, AsyncRpcResponse<SetIpV6FwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setIpV6FwSettings(ipV6Fw, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setIpV6FwSettings(Com.Raritan.Idl.security.IpFw_2_0_0 ipV6Fw, AsyncRpcResponse<SetIpV6FwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["ipV6Fw"] = ipV6Fw.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setIpV6FwSettings", _parameters,
        _result => {
          try {
            var _ret = new SetIpV6FwSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRoleAccessControlSettingsResult {
      public Com.Raritan.Idl.security.RoleAccessControl _ret_;
    }

    public GetRoleAccessControlSettingsResult getRoleAccessControlSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRoleAccessControlSettings", _parameters);
      var _ret = new GetRoleAccessControlSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.security.RoleAccessControl.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getRoleAccessControlSettings(AsyncRpcResponse<GetRoleAccessControlSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRoleAccessControlSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRoleAccessControlSettings(AsyncRpcResponse<GetRoleAccessControlSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRoleAccessControlSettings", _parameters,
        _result => {
          try {
            var _ret = new GetRoleAccessControlSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.security.RoleAccessControl.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetRoleAccessControlSettingsResult {
      public int _ret_;
    }

    public SetRoleAccessControlSettingsResult setRoleAccessControlSettings(Com.Raritan.Idl.security.RoleAccessControl settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setRoleAccessControlSettings", _parameters);
      var _ret = new SetRoleAccessControlSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setRoleAccessControlSettings(Com.Raritan.Idl.security.RoleAccessControl settings, AsyncRpcResponse<SetRoleAccessControlSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setRoleAccessControlSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setRoleAccessControlSettings(Com.Raritan.Idl.security.RoleAccessControl settings, AsyncRpcResponse<SetRoleAccessControlSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setRoleAccessControlSettings", _parameters,
        _result => {
          try {
            var _ret = new SetRoleAccessControlSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRoleAccessControlSettingsV6Result {
      public Com.Raritan.Idl.security.RoleAccessControl _ret_;
    }

    public GetRoleAccessControlSettingsV6Result getRoleAccessControlSettingsV6() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRoleAccessControlSettingsV6", _parameters);
      var _ret = new GetRoleAccessControlSettingsV6Result();
      _ret._ret_ = Com.Raritan.Idl.security.RoleAccessControl.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getRoleAccessControlSettingsV6(AsyncRpcResponse<GetRoleAccessControlSettingsV6Result>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRoleAccessControlSettingsV6(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRoleAccessControlSettingsV6(AsyncRpcResponse<GetRoleAccessControlSettingsV6Result>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRoleAccessControlSettingsV6", _parameters,
        _result => {
          try {
            var _ret = new GetRoleAccessControlSettingsV6Result();
            _ret._ret_ = Com.Raritan.Idl.security.RoleAccessControl.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetRoleAccessControlSettingsV6Result {
      public int _ret_;
    }

    public SetRoleAccessControlSettingsV6Result setRoleAccessControlSettingsV6(Com.Raritan.Idl.security.RoleAccessControl settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setRoleAccessControlSettingsV6", _parameters);
      var _ret = new SetRoleAccessControlSettingsV6Result();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setRoleAccessControlSettingsV6(Com.Raritan.Idl.security.RoleAccessControl settings, AsyncRpcResponse<SetRoleAccessControlSettingsV6Result>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setRoleAccessControlSettingsV6(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setRoleAccessControlSettingsV6(Com.Raritan.Idl.security.RoleAccessControl settings, AsyncRpcResponse<SetRoleAccessControlSettingsV6Result>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setRoleAccessControlSettingsV6", _parameters,
        _result => {
          try {
            var _ret = new SetRoleAccessControlSettingsV6Result();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetBlockSettingsResult {
      public int blockTimeout;
      public int maxFailedLogins;
    }

    public GetBlockSettingsResult getBlockSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getBlockSettings", _parameters);
      var _ret = new GetBlockSettingsResult();
      _ret.blockTimeout = (int)_result["blockTimeout"];
      _ret.maxFailedLogins = (int)_result["maxFailedLogins"];
      return _ret;
    }

    public AsyncRequest getBlockSettings(AsyncRpcResponse<GetBlockSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getBlockSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getBlockSettings(AsyncRpcResponse<GetBlockSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getBlockSettings", _parameters,
        _result => {
          try {
            var _ret = new GetBlockSettingsResult();
            _ret.blockTimeout = (int)_result["blockTimeout"];
            _ret.maxFailedLogins = (int)_result["maxFailedLogins"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetBlockSettingsResult {
      public int _ret_;
    }

    public SetBlockSettingsResult setBlockSettings(int blockTimeout, int maxFailedLogins) {
      var _parameters = new LightJson.JsonObject();
      _parameters["blockTimeout"] = blockTimeout;
      _parameters["maxFailedLogins"] = maxFailedLogins;

      var _result = RpcCall("setBlockSettings", _parameters);
      var _ret = new SetBlockSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setBlockSettings(int blockTimeout, int maxFailedLogins, AsyncRpcResponse<SetBlockSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setBlockSettings(blockTimeout, maxFailedLogins, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setBlockSettings(int blockTimeout, int maxFailedLogins, AsyncRpcResponse<SetBlockSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["blockTimeout"] = blockTimeout;
        _parameters["maxFailedLogins"] = maxFailedLogins;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setBlockSettings", _parameters,
        _result => {
          try {
            var _ret = new SetBlockSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPwSettingsResult {
      public Com.Raritan.Idl.security.PasswordSettings _ret_;
    }

    public GetPwSettingsResult getPwSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPwSettings", _parameters);
      var _ret = new GetPwSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.security.PasswordSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getPwSettings(AsyncRpcResponse<GetPwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPwSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPwSettings(AsyncRpcResponse<GetPwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPwSettings", _parameters,
        _result => {
          try {
            var _ret = new GetPwSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.security.PasswordSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetPwSettingsResult {
      public int _ret_;
    }

    public SetPwSettingsResult setPwSettings(Com.Raritan.Idl.security.PasswordSettings pwSettings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["pwSettings"] = pwSettings.Encode();

      var _result = RpcCall("setPwSettings", _parameters);
      var _ret = new SetPwSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setPwSettings(Com.Raritan.Idl.security.PasswordSettings pwSettings, AsyncRpcResponse<SetPwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setPwSettings(pwSettings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setPwSettings(Com.Raritan.Idl.security.PasswordSettings pwSettings, AsyncRpcResponse<SetPwSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["pwSettings"] = pwSettings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setPwSettings", _parameters,
        _result => {
          try {
            var _ret = new SetPwSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetIdleTimeoutSettingsResult {
      public int _ret_;
    }

    public GetIdleTimeoutSettingsResult getIdleTimeoutSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getIdleTimeoutSettings", _parameters);
      var _ret = new GetIdleTimeoutSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getIdleTimeoutSettings(AsyncRpcResponse<GetIdleTimeoutSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getIdleTimeoutSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getIdleTimeoutSettings(AsyncRpcResponse<GetIdleTimeoutSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getIdleTimeoutSettings", _parameters,
        _result => {
          try {
            var _ret = new GetIdleTimeoutSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetIdleTimeoutSettingsResult {
      public int _ret_;
    }

    public SetIdleTimeoutSettingsResult setIdleTimeoutSettings(int idleTimeout) {
      var _parameters = new LightJson.JsonObject();
      _parameters["idleTimeout"] = idleTimeout;

      var _result = RpcCall("setIdleTimeoutSettings", _parameters);
      var _ret = new SetIdleTimeoutSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setIdleTimeoutSettings(int idleTimeout, AsyncRpcResponse<SetIdleTimeoutSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setIdleTimeoutSettings(idleTimeout, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setIdleTimeoutSettings(int idleTimeout, AsyncRpcResponse<SetIdleTimeoutSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["idleTimeout"] = idleTimeout;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setIdleTimeoutSettings", _parameters,
        _result => {
          try {
            var _ret = new SetIdleTimeoutSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSingleLoginLimitationResult {
      public bool _ret_;
    }

    public GetSingleLoginLimitationResult getSingleLoginLimitation() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSingleLoginLimitation", _parameters);
      var _ret = new GetSingleLoginLimitationResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getSingleLoginLimitation(AsyncRpcResponse<GetSingleLoginLimitationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSingleLoginLimitation(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSingleLoginLimitation(AsyncRpcResponse<GetSingleLoginLimitationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSingleLoginLimitation", _parameters,
        _result => {
          try {
            var _ret = new GetSingleLoginLimitationResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSingleLoginLimitationResult {
    }

    public SetSingleLoginLimitationResult setSingleLoginLimitation(bool singleLogin) {
      var _parameters = new LightJson.JsonObject();
      _parameters["singleLogin"] = singleLogin;

      var _result = RpcCall("setSingleLoginLimitation", _parameters);
      var _ret = new SetSingleLoginLimitationResult();
      return _ret;
    }

    public AsyncRequest setSingleLoginLimitation(bool singleLogin, AsyncRpcResponse<SetSingleLoginLimitationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSingleLoginLimitation(singleLogin, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSingleLoginLimitation(bool singleLogin, AsyncRpcResponse<SetSingleLoginLimitationResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["singleLogin"] = singleLogin;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSingleLoginLimitation", _parameters,
        _result => {
          try {
            var _ret = new SetSingleLoginLimitationResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSSHSettingsResult {
      public Com.Raritan.Idl.security.SSHSettings _ret_;
    }

    public GetSSHSettingsResult getSSHSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSSHSettings", _parameters);
      var _ret = new GetSSHSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.security.SSHSettings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSSHSettings(AsyncRpcResponse<GetSSHSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSSHSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSSHSettings(AsyncRpcResponse<GetSSHSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSSHSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSSHSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.security.SSHSettings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSSHSettingsResult {
    }

    public SetSSHSettingsResult setSSHSettings(Com.Raritan.Idl.security.SSHSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSSHSettings", _parameters);
      var _ret = new SetSSHSettingsResult();
      return _ret;
    }

    public AsyncRequest setSSHSettings(Com.Raritan.Idl.security.SSHSettings settings, AsyncRpcResponse<SetSSHSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSSHSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSSHSettings(Com.Raritan.Idl.security.SSHSettings settings, AsyncRpcResponse<SetSSHSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSSHSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSSHSettingsResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRestrictedServiceAgreementResult {
      public Com.Raritan.Idl.security.RestrictedServiceAgreement _ret_;
    }

    public GetRestrictedServiceAgreementResult getRestrictedServiceAgreement() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRestrictedServiceAgreement", _parameters);
      var _ret = new GetRestrictedServiceAgreementResult();
      _ret._ret_ = Com.Raritan.Idl.security.RestrictedServiceAgreement.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getRestrictedServiceAgreement(AsyncRpcResponse<GetRestrictedServiceAgreementResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRestrictedServiceAgreement(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRestrictedServiceAgreement(AsyncRpcResponse<GetRestrictedServiceAgreementResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRestrictedServiceAgreement", _parameters,
        _result => {
          try {
            var _ret = new GetRestrictedServiceAgreementResult();
            _ret._ret_ = Com.Raritan.Idl.security.RestrictedServiceAgreement.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetRestrictedServiceAgreementResult {
      public int _ret_;
    }

    public SetRestrictedServiceAgreementResult setRestrictedServiceAgreement(Com.Raritan.Idl.security.RestrictedServiceAgreement settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setRestrictedServiceAgreement", _parameters);
      var _ret = new SetRestrictedServiceAgreementResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setRestrictedServiceAgreement(Com.Raritan.Idl.security.RestrictedServiceAgreement settings, AsyncRpcResponse<SetRestrictedServiceAgreementResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setRestrictedServiceAgreement(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setRestrictedServiceAgreement(Com.Raritan.Idl.security.RestrictedServiceAgreement settings, AsyncRpcResponse<SetRestrictedServiceAgreementResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setRestrictedServiceAgreement", _parameters,
        _result => {
          try {
            var _ret = new SetRestrictedServiceAgreementResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSupportedFrontPanelPrivilegesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetSupportedFrontPanelPrivilegesResult getSupportedFrontPanelPrivileges() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSupportedFrontPanelPrivileges", _parameters);
      var _ret = new GetSupportedFrontPanelPrivilegesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getSupportedFrontPanelPrivileges(AsyncRpcResponse<GetSupportedFrontPanelPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSupportedFrontPanelPrivileges(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSupportedFrontPanelPrivileges(AsyncRpcResponse<GetSupportedFrontPanelPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSupportedFrontPanelPrivileges", _parameters,
        _result => {
          try {
            var _ret = new GetSupportedFrontPanelPrivilegesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetFrontPanelPrivilegesResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetFrontPanelPrivilegesResult getFrontPanelPrivileges() {
      JsonObject _parameters = null;
      var _result = RpcCall("getFrontPanelPrivileges", _parameters);
      var _ret = new GetFrontPanelPrivilegesResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getFrontPanelPrivileges(AsyncRpcResponse<GetFrontPanelPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getFrontPanelPrivileges(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getFrontPanelPrivileges(AsyncRpcResponse<GetFrontPanelPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getFrontPanelPrivileges", _parameters,
        _result => {
          try {
            var _ret = new GetFrontPanelPrivilegesResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetFrontPanelPrivilegesResult {
      public int _ret_;
    }

    public SetFrontPanelPrivilegesResult setFrontPanelPrivileges(System.Collections.Generic.IEnumerable<string> privileges) {
      var _parameters = new LightJson.JsonObject();
      _parameters["privileges"] = new JsonArray(privileges.Select(
        _value => (JsonValue)(_value)));

      var _result = RpcCall("setFrontPanelPrivileges", _parameters);
      var _ret = new SetFrontPanelPrivilegesResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setFrontPanelPrivileges(System.Collections.Generic.IEnumerable<string> privileges, AsyncRpcResponse<SetFrontPanelPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setFrontPanelPrivileges(privileges, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setFrontPanelPrivileges(System.Collections.Generic.IEnumerable<string> privileges, AsyncRpcResponse<SetFrontPanelPrivilegesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["privileges"] = new JsonArray(privileges.Select(
          _value => (JsonValue)(_value)));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setFrontPanelPrivileges", _parameters,
        _result => {
          try {
            var _ret = new SetFrontPanelPrivilegesResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
