# Announce: Rakudo compiler, Release #137 (2020.07)

On behalf of the Rakudo development team, I’m very happy to announce the
July 2020 release of Rakudo #137. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2020.07:
  + Fixes:
    + Improve "Method not found" error message for some rare cases [0a86798f]
    + Fix calling `.say`/`.put`/`.note` methods on Match objects [9f546ef6]
    + Add word wrapping to numerous error messages, improve wording
      [eb589c03][1b84e036][3cb29a03][6db1fb1d][80aaede3][42031860][f70a3ccd]
      [3ffed2fb][a7a1fe24][cd8846ad][83a126b3][3add8615][3d9a9fc4][697596fd]
      [56e5f7dc][88b0e7a3][7a93c907][f550c9f9][a4b982cd][93963433][58685eeb]
      [5f423a7e][92f8c19b][5627e02b][5b7ecdc0][a7455050][f96a641f][1f93724f]
      [98c7e512][248664c6][3bc4fa90]
    + Wordwrap `Mu.WHY` [16d24a21]
    + Fix check for valid Raku module extension to be an exact match instead of suffix-like one [d4eef8d4]
    + Fix result of `.raku` method called on a generic typed array [90f86d4c]
  + Additions:
    + Set equality operators: `(==)` Unicode `≡` and `≢` which allow to check
      for sameness of the operands using QuantHash semantics
      (for example, `1,2,3 (==) 3,1,2` returns `True`) [701f4cfb][dbd69ba7]
    + Add support for Supply.tail(*) and .tail(Inf) [9ccfc90e]
    + Add support for Supply.tail(*-3) [eaa72afa]
    + Make `Supply.head(*-3)` consistent with `List.head(*-3)` [5c8c7324][70e5cfb9]
    + Rakudo now supports the `--rakudo-home` command line option to specify the path of the Rakudo home [914bcbad]
  + Efficiency:
    + Make <a b c d>.permutations between 23 and 85x faster [682a4d4f]
    + Make IO::Handle.read(1) about 3x as fast and consuming less memory [2946ed64][252b9349]
  + Internal:
    + Micro-optimize `buf8.new` creation code in compiler [ed936c14]
    + Give `Supply.tail` its own candidate [1a91af8c]
    + Add `Str.naive-word-wrapper` (implementation detail)
      [056d6a4e][9ea66e13][6db1fb1d][45893495][821f582f][3674f812]
    + Make `IO::Path` use its own `.succ` / `.pred` logic [305fc7bd]
    + Remove placeholder files [07009cc0]
    + Re-imagine `CompUnit::Repository::FileSystem!distribution` [f3b1c8df]
    + Change `perl6` to `Raku` in nqp-configure submodule URL [ddebab5a]
    + Refactor `Rakudo home` and `NQP home` handling [e4f020ca]
    + Do core setting name mapping via compiler config [6e087e13]
    + Fix for spectest not seeing Inline::Perl5 [d5630720]

The following people contributed to this release:

Elizabeth Mattijsen, JJ Merelo, Timo Paulssen, Patrick Böker, Alexander Kiryuhin,
Nicholas Clark, Vadim Belman, Will "Coke" Coleda, Antonio, Ben Davies,
Christian Bartolomäus, Daniel Green, Jonathan Worthington,
Richard Hainsworth, stoned, Stefan Seifert, Daniel Sockwell,
Joshua Yeshouroun, Nick Logan, Trey Harris

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#138), is tentatively scheduled for 2020-07-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
