% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grd.R
\name{grd}
\alias{grd}
\alias{grd_rct}
\alias{grd_xy}
\alias{as_grd_rct}
\alias{as_grd_rct.wk_grd_rct}
\alias{as_grd_rct.wk_grd_xy}
\alias{as_grd_xy}
\alias{as_grd_xy.wk_grd_xy}
\alias{as_grd_xy.wk_grd_rct}
\title{Raster-like objects}
\usage{
grd(
  bbox = NULL,
  nx = NULL,
  ny = NULL,
  dx = NULL,
  dy = NULL,
  type = c("polygons", "corners", "centers")
)

grd_rct(data, bbox = rct(0, 0, dim(data)[2], dim(data)[1]))

grd_xy(data, bbox = rct(0, 0, dim(data)[2] - 1, dim(data)[1] - 1))

as_grd_rct(x, ...)

\method{as_grd_rct}{wk_grd_rct}(x, ...)

\method{as_grd_rct}{wk_grd_xy}(x, ...)

as_grd_xy(x, ...)

\method{as_grd_xy}{wk_grd_xy}(x, ...)

\method{as_grd_xy}{wk_grd_rct}(x, ...)
}
\arguments{
\item{bbox}{A \code{\link[=rct]{rct()}} containing the bounds and CRS of the object. You can
specify a \code{\link[=rct]{rct()}} with \code{xmin > xmax} or \code{ymin > ymax} which will flip
the underlying data and return an object with a normalized bounding
box and data.}

\item{nx, ny, dx, dy}{Either a number of cells in the x- and y- directions
or delta in the x- and y-directions (in which case \code{bbox} must
be specified).}

\item{type}{Use "polygons" to return a grid whose objects can be
represented using an \code{\link[=rct]{rct()}}; use "centers" to return a grid whose
objects are the center of the \code{\link[=rct]{rct()}} grid; use "corners" to return
a grid along the corners of \code{bbox}.}

\item{data}{An object with two or more dimensions. Most usefully, a matrix.}

\item{x}{An object to convert to a grid}

\item{...}{Passed to S3 methods}
}
\value{
\itemize{
\item \code{grd()} returns a \code{grd_rct()} for \verb{type == "polygons} or
a \code{grd_xy()} otherwise.
\item \code{grd_rct()} returns an object of class "wk_grd_rct".
\item \code{grd_xy()} returns an object of class "wk_grd_xy".
}
}
\description{
\code{\link[=grd]{grd()}} objects are just an array (any object with more than
two \code{\link[=dim]{dim()}}s) and a bounding box (a \code{\link[=rct]{rct()}}, which may or
may not have a \code{\link[=wk_crs]{wk_crs()}} attached). The ordering of the dimensions
is y (indices increasing downwards), x (indices increasing to the right).
This follows the ordering of \code{\link[=as.raster]{as.raster()}}/\code{\link[=rasterImage]{rasterImage()}} and aligns
with the printing of matrices.
}
\examples{
# create a grid with no data (just for coordinates)
(grid <- grd(nx = 2, ny = 2))
as_rct(grid)
as_xy(grid)
plot(grid, border = "black")

# more usefully, wraps a matrix or nd array + bbox
# approx volcano in New Zealand Transverse Mercator
bbox <- rct(
  5917000,       1757000 + 870,
  5917000 + 610, 1757000,
  crs = "EPSG:2193"
)
(grid <- grd_rct(volcano, bbox))

# these come with a reasonable default plot method for matrix data
plot(grid)

# you can set the data or the bounding box after creation
grid$bbox <- rct(0, 0, 1, 1)

# subset by indices or rct
plot(grid[1:2, 1:2])
plot(grid[c(start = NA, stop = NA, step = 2), c(start = NA, stop = NA, step = 2)])
plot(grid[rct(0, 0, 0.5, 0.5)])

}
