% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_features.R
\name{get_font_features}
\alias{get_font_features}
\title{Get available OpenType features in a font}
\usage{
get_font_features(
  family = "",
  italic = FALSE,
  bold = FALSE,
  path = NULL,
  index = 0
)
}
\arguments{
\item{family}{The name of the font family}

\item{italic}{logicals indicating the font style}

\item{bold}{logicals indicating the font style}

\item{path}{path an index of a font file to circumvent lookup based on
family and style}

\item{index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A list with an element for each of the input fonts containing the
supported feature tags for that font.
}
\description{
This is a simply functions that returns the available OpenType feature tags
for one or more fonts. See \code{\link[systemfonts:font_feature]{font_feature()}} for
more information on how to use the different feature with a font.
}
\examples{
# Select a random font on the system
sys_fonts <- systemfonts::system_fonts()
random_font <- sys_fonts$family[sample(nrow(sys_fonts), 1)]

# Get the features
get_font_features(random_font)

}
