% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable.R
\name{xtable}
\alias{xtable}
\alias{xtable.table}
\alias{xtable.survfit}
\title{\code{xtable} methods}
\usage{
xtable(x, caption = NULL, label = NULL, align = NULL, digits = NULL,
  display = NULL, ...)

\method{xtable}{table}(x, caption = paste0(paste(names(dimnames(x)), collapse
  = " $\\\\times$ "), "\\\\\\\\ chi-sq=",
  signif(suppressWarnings(stats::chisq.test(x)$p.value), digits)),
  label = NULL, align = c("l", rep("c", dim(x)[2])), digits = 2,
  display = NULL, ...)

\method{xtable}{survfit}(x, caption = paste0("Survival for ",
  deparse(x$call[[2]])), label = NULL, align = c("l", rep("c", 7)),
  digits = NULL, display = rep("fg", 8), ...)
}
\arguments{
\item{x}{An object with an xtable method.}

\item{caption}{Caption.}

\item{label}{Label.}

\item{align}{Alignment of columns.}

\item{digits}{Number of digits to display.}

\item{display}{How to display - passed to \code{formatC}.}

\item{...}{Additional arguments (not implemented).}
}
\value{
An \code{xtable}, suitable for use with/ parsing by LaTeX.
}
\description{
\code{xtable} methods
}
\note{
\code{xtable.survfit} - this does \emph{not} show the (restricted) mean survival, 
 only the median with confidence intervals.
}
\examples{
data("kidney", package="KMsurv")
xtable(with(kidney, table(delta, type)))

## K&M. Example 7.2, pg 210.
xtable(survfit(Surv(time=time, event=delta) ~ type, data=kidney))


}
\seealso{
? xtable
? xtable::print.xtable
methods("xtable")
}
