% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{RunCCA}
\alias{RunCCA}
\alias{RunCCA.default}
\alias{RunCCA.Seurat}
\title{Perform Canonical Correlation Analysis}
\usage{
RunCCA(object1, object2, ...)

\method{RunCCA}{default}(
  object1,
  object2,
  standardize = TRUE,
  num.cc = 20,
  seed.use = 42,
  verbose = FALSE,
  ...
)

\method{RunCCA}{Seurat}(
  object1,
  object2,
  assay1 = NULL,
  assay2 = NULL,
  num.cc = 20,
  features = NULL,
  renormalize = FALSE,
  rescale = FALSE,
  compute.gene.loadings = TRUE,
  add.cell.id1 = NULL,
  add.cell.id2 = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object1}{First Seurat object}

\item{object2}{Second Seurat object.}

\item{...}{Extra parameters (passed onto MergeSeurat in case with two objects
passed, passed onto ScaleData in case with single object and rescale.groups
set to TRUE)}

\item{standardize}{Standardize matrices - scales columns to have unit variance
and mean 0}

\item{num.cc}{Number of canonical vectors to calculate}

\item{seed.use}{Random seed to set. If NULL, does not set a seed}

\item{verbose}{Show progress messages}

\item{assay1, assay2}{Assays to pull from in the first and second objects, respectively}

\item{features}{Set of genes to use in CCA. Default is the union of both
the variable features sets present in both objects.}

\item{renormalize}{Renormalize raw data after merging the objects. If FALSE,
merge the data matrices also.}

\item{rescale}{Rescale the datasets prior to CCA. If FALSE, uses existing data in the scale data slots.}

\item{compute.gene.loadings}{Also compute the gene loadings. NOTE - this will
scale every gene in the dataset which may impose a high memory cost.}

\item{add.cell.id1, add.cell.id2}{Add ...}
}
\value{
Returns a combined Seurat object with the CCA results stored.
}
\description{
Runs a canonical correlation analysis using a diagonal implementation of CCA.
For details about stored CCA calculation parameters, see
\code{PrintCCAParams}.
}
\examples{
data("pbmc_small")
pbmc_small
# As CCA requires two datasets, we will split our test object into two just for this example
pbmc1 <- subset(pbmc_small, cells = colnames(pbmc_small)[1:40])
pbmc2 <- subset(pbmc_small, cells = colnames(x = pbmc_small)[41:80])
pbmc1[["group"]] <- "group1"
pbmc2[["group"]] <- "group2"
pbmc_cca <- RunCCA(object1 = pbmc1, object2 = pbmc2)
# Print results
print(x = pbmc_cca[["cca"]])

}
\seealso{
\code{\link{merge.Seurat}}
}
\concept{dimensional_reduction}
